// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{TestImportManager}from"../../../../../../../../../../../../../../../../../../common/testing/test_import_manager.js";import{AsyncUtil}from"../../../../../../../../../../../../../../../../../../common/async_util.js";import{Flags,FlagName}from"../../../../../../../../../../../../../../../../../../common/flags.js";import{KeepAlive}from"../../../../../../../../../../../../../../../../../../common/keep_alive.js";import{InstanceChecker}from"../../../../../../../../../../../../../../../../../../common/mv3/instance_checker.js";import{RectUtil}from"../../../../../../../../../../../../../../../../../../common/rect_util.js";import{ArrayUtil}from"../../../../../../../../../../../../../../../../../../common/array_util.js";import{EventHandler}from"../../../../../../../../../../../../../../../../../../common/event_handler.js";import{EventGenerator}from"../../../../../../../../../../../../../../../../../../common/event_generator.js";import{KeyCode}from"../../../../../../../../../../../../../../../../../../common/key_code.js";import{AutomationPredicate}from"../../../../../../../../../../../../../../../../../../common/automation_predicate.js";import{RepeatedEventHandler}from"../../../../../../../../../../../../../../../../../../common/repeated_event_handler.js";import{constants}from"../../../../../../../../../../../../../../../../../../common/constants.js";import{AutomationTreeWalker}from"../../../../../../../../../../../../../../../../../../common/tree_walker.js";import{AutomationUtil}from"../../../../../../../../../../../../../../../../../../common/automation_util.js";import{RepeatedTreeChangeHandler}from"../../../../../../../../../../../../../../../../../../common/repeated_tree_change_handler.js";import{StringUtil}from"../../../../../../../../../../../../../../../../../../common/string_util.js";import{Settings}from"../../../../../../../../../../../../../../../../../../common/settings.js";var ActionResponse;(function(ActionResponse){ActionResponse[ActionResponse["NO_ACTION_TAKEN"]=-1]="NO_ACTION_TAKEN";ActionResponse[ActionResponse["REMAIN_OPEN"]=0]="REMAIN_OPEN";ActionResponse[ActionResponse["CLOSE_MENU"]=1]="CLOSE_MENU";ActionResponse[ActionResponse["EXIT_SUBMENU"]=2]="EXIT_SUBMENU";ActionResponse[ActionResponse["RELOAD_MENU"]=3]="RELOAD_MENU";ActionResponse[ActionResponse["OPEN_TEXT_NAVIGATION_MENU"]=4]="OPEN_TEXT_NAVIGATION_MENU"})(ActionResponse||(ActionResponse={}));var ErrorType;(function(ErrorType){ErrorType[ErrorType["UNKNOWN"]=0]="UNKNOWN";ErrorType[ErrorType["PREFERENCE_TYPE"]=1]="PREFERENCE_TYPE";ErrorType[ErrorType["UNTRANSLATED_STRING"]=2]="UNTRANSLATED_STRING";ErrorType[ErrorType["INVALID_COLOR"]=3]="INVALID_COLOR";ErrorType[ErrorType["NEXT_UNDEFINED"]=4]="NEXT_UNDEFINED";ErrorType[ErrorType["PREVIOUS_UNDEFINED"]=5]="PREVIOUS_UNDEFINED";ErrorType[ErrorType["NULL_CHILD"]=6]="NULL_CHILD";ErrorType[ErrorType["NO_CHILDREN"]=7]="NO_CHILDREN";ErrorType[ErrorType["MALFORMED_DESKTOP"]=8]="MALFORMED_DESKTOP";ErrorType[ErrorType["MISSING_LOCATION"]=9]="MISSING_LOCATION";ErrorType[ErrorType["MISSING_KEYBOARD"]=10]="MISSING_KEYBOARD";ErrorType[ErrorType["ROW_TOO_SHORT"]=11]="ROW_TOO_SHORT";ErrorType[ErrorType["MISSING_BASE_NODE"]=12]="MISSING_BASE_NODE";ErrorType[ErrorType["NEXT_INVALID"]=13]="NEXT_INVALID";ErrorType[ErrorType["PREVIOUS_INVALID"]=14]="PREVIOUS_INVALID";ErrorType[ErrorType["INVALID_SELECTION_BOUNDS"]=15]="INVALID_SELECTION_BOUNDS";ErrorType[ErrorType["UNINITIALIZED"]=16]="UNINITIALIZED";ErrorType[ErrorType["DUPLICATE_INITIALIZATION"]=17]="DUPLICATE_INITIALIZATION"})(ErrorType||(ErrorType={}));var MenuType;(function(MenuType){MenuType[MenuType["MAIN_MENU"]=0]="MAIN_MENU";MenuType[MenuType["TEXT_NAVIGATION"]=1]="TEXT_NAVIGATION";MenuType[MenuType["POINT_SCAN_MENU"]=2]="POINT_SCAN_MENU"})(MenuType||(MenuType={}));var Mode;(function(Mode){Mode[Mode["ITEM_SCAN"]=0]="ITEM_SCAN";Mode[Mode["POINT_SCAN"]=1]="POINT_SCAN"})(Mode||(Mode={}));TestImportManager.exportForTesting(["Mode",Mode]);class AutoScanManager{intervalID_;isEnabled_=false;inKeyboard_=false;keyboardScanTime_=NOT_INITIALIZED;primaryScanTime_=NOT_INITIALIZED;static instance;constructor(){}static init(){if(AutoScanManager.instance){throw SwitchAccess.error(ErrorType.DUPLICATE_INITIALIZATION,"Cannot call AutoScanManager.init() more than once.")}AutoScanManager.instance=new AutoScanManager}static restartIfRunning(){if(AutoScanManager.instance?.isRunning_()){AutoScanManager.instance.stop_();AutoScanManager.instance.start_()}}static setEnabled(enabled){if(AutoScanManager.instance.isRunning_()){AutoScanManager.instance.stop_()}AutoScanManager.instance.isEnabled_=enabled;if(enabled){AutoScanManager.instance.start_()}}static setInKeyboard(inKeyboard){AutoScanManager.instance.inKeyboard_=inKeyboard}static setKeyboardScanTime(scanTime){AutoScanManager.instance.keyboardScanTime_=scanTime;if(AutoScanManager.instance.inKeyboard_){AutoScanManager.restartIfRunning()}}static setPrimaryScanTime(scanTime){AutoScanManager.instance.primaryScanTime_=scanTime;AutoScanManager.restartIfRunning()}isRunning_(){return this.isEnabled_}start_(){if(this.primaryScanTime_===NOT_INITIALIZED||this.intervalID_||SwitchAccess.mode===Mode.POINT_SCAN){return}let currentScanTime=this.primaryScanTime_;if(SwitchAccess.improvedTextInputEnabled()&&this.inKeyboard_&&this.keyboardScanTime_!==NOT_INITIALIZED){currentScanTime=this.keyboardScanTime_}this.intervalID_=setInterval((()=>{if(SwitchAccess.mode===Mode.POINT_SCAN){this.stop_();return}Navigator.byItem.moveForward()}),currentScanTime)}stop_(){clearInterval(this.intervalID_);this.intervalID_=undefined}}const NOT_INITIALIZED=-1;TestImportManager.exportForTesting(AutoScanManager);class SACache{isActionable=new Map;isGroup=new Map;isInterestingSubtree=new Map}TestImportManager.exportForTesting(SACache);var MenuAction$b=chrome.accessibilityPrivate.SwitchAccessMenuAction;class SAChildNode{isFocused_=false;next_=null;previous_=null;valid_=true;get group(){return null}set next(newVal){this.next_=newVal}get next(){let next=this;while(true){next=next.next_;if(!next){this.onInvalidNavigation_(ErrorType.NEXT_UNDEFINED,"Next node must be set on all SAChildNodes before navigating")}if(this===next){this.onInvalidNavigation_(ErrorType.NEXT_INVALID,"No valid next node")}if(next.isValidAndVisible()){return next}}}set previous(newVal){this.previous_=newVal}get previous(){let previous=this;while(true){previous=previous.previous_;if(!previous){this.onInvalidNavigation_(ErrorType.PREVIOUS_UNDEFINED,"Previous node must be set on all SAChildNodes before navigating")}if(this===previous){this.onInvalidNavigation_(ErrorType.PREVIOUS_INVALID,"No valid previous node")}if(previous.isValidAndVisible()){return previous}}}doDefaultAction(){if(!this.isFocused_){return}if(this.isGroup()){this.performAction(MenuAction$b.DRILL_DOWN)}else{this.performAction(MenuAction$b.SELECT)}}hasAction(action){return this.actions.includes(action)}isFocused(){return this.isFocused_}isValidAndVisible(){return this.valid_&&Boolean(this.location)}onFocus(){this.isFocused_=true;FocusRingManager.setFocusedNode(this)}onUnfocus(){this.isFocused_=false}debugString(wholeTree,prefix="",currentNode=null){if(this.isGroup()&&wholeTree){return this.asRootNode().debugString(wholeTree,prefix+"  ",currentNode)}let str=this.constructor.name+" role("+this.role+") ";if(this.automationNode.name){str+="name("+this.automationNode.name+") "}const loc=this.location;if(loc){str+="loc("+RectUtil.toString(loc)+") "}if(this.isGroup()){str+="[isGroup]"}return str}onInvalidNavigation_(error,message){this.valid_=false;throw SwitchAccess.error(error,message,true)}ignoreWhenComputingUnionOfBoundingBoxes(){return false}}class SARootNode{children_=[];automationNode_;constructor(autoNode){this.automationNode_=autoNode}get automationNode(){return this.automationNode_}set children(newVal){this.children_=newVal;this.connectChildren_()}get children(){return this.children_}get firstChild(){if(this.children_.length>0){return this.children_[0]}else{throw SwitchAccess.error(ErrorType.NO_CHILDREN,"Root nodes must contain children.",true)}}get lastChild(){if(this.children_.length>0){return this.children_[this.children_.length-1]}else{throw SwitchAccess.error(ErrorType.NO_CHILDREN,"Root nodes must contain children.",true)}}get location(){const children=this.children_.filter((c=>!c.ignoreWhenComputingUnionOfBoundingBoxes()));const childLocations=children.map((c=>c.location)).filter((l=>l));return RectUtil.unionAll(childLocations)}equals(other){if(!other){return false}if(this.children_.length!==other.children_.length){return false}let result=true;for(let i=0;i<this.children_.length;i++){if(!this.children_[i]){console.error(SwitchAccess.error(ErrorType.NULL_CHILD,"Child cannot be null."));return false}result=result&&this.children_[i].equals(other.children_[i])}return result}findChild(node){for(const child of this.children_){if(child.isEquivalentTo(node)){return child}}return null}isEquivalentTo(node){if(node instanceof SARootNode){return this.equals(node)}if(node instanceof SAChildNode){return node.isEquivalentTo(this)}return false}isValidGroup(){return this.children_.filter((child=>!child.ignoreWhenComputingUnionOfBoundingBoxes()&&child.isValidAndVisible())).length>=1}firstValidChild(){const children=this.children_.filter((child=>child.isValidAndVisible()));return children.length>0?children[0]:null}onFocus(){}onUnfocus(){}onExit(){}refreshChildren(){this.children=this.children.filter((child=>child.isValidAndVisible()))}refresh(){}debugString(wholeTree=false,prefix="",currentNode=null){let str="Root: "+this.constructor.name+" "+this.automationNode.role+" ";if(this.automationNode.name){str+="name("+this.automationNode.name+") "}const loc=this.location;if(loc){str+="loc("+RectUtil.toString(loc)+") "}for(const child of this.children){str+="\n"+prefix+(child.equals(currentNode)?" * ":" - ");str+=child.debugString(wholeTree,prefix,currentNode)}return str}connectChildren_(){if(this.children_.length<1){console.error(SwitchAccess.error(ErrorType.NO_CHILDREN,"Root node must have at least 1 interesting child."));return}let previous=this.children_[this.children_.length-1];for(let i=0;i<this.children_.length;i++){const current=this.children_[i];previous.next=current;current.previous=previous;previous=current}}}TestImportManager.exportForTesting(SARootNode);const StateType$2=chrome.automation.StateType;const Restriction=chrome.automation.Restriction;const RoleType$8=chrome.automation.RoleType;const DefaultActionVerb=chrome.automation.DefaultActionVerb;var SwitchAccessPredicate;(function(SwitchAccessPredicate){SwitchAccessPredicate.GROUP_INTERESTING_CHILD_THRESHOLD=2;function isActionable(node,cache){if(cache.isActionable.has(node)){return cache.isActionable.get(node)}const defaultActionVerb=node.defaultActionVerb;if(!SwitchAccessPredicate.isVisible(node)){cache.isActionable.set(node,false);return false}if(node.restriction===Restriction.DISABLED){cache.isActionable.set(node,false);return false}if(AutomationPredicate.structuralContainer(node)){cache.isActionable.set(node,false);return false}const actionableRole=AutomationPredicate.roles([RoleType$8.BUTTON,RoleType$8.SLIDER,RoleType$8.TAB]);if(actionableRole(node)){cache.isActionable.set(node,true);return true}if(AutomationPredicate.comboBox(node)||SwitchAccessPredicate.isTextInput(node)){cache.isActionable.set(node,true);return true}if(defaultActionVerb&&(defaultActionVerb===DefaultActionVerb.ACTIVATE||defaultActionVerb===DefaultActionVerb.CHECK||defaultActionVerb===DefaultActionVerb.OPEN||defaultActionVerb===DefaultActionVerb.PRESS||defaultActionVerb===DefaultActionVerb.SELECT||defaultActionVerb===DefaultActionVerb.UNCHECK)){cache.isActionable.set(node,true);return true}if(node.role===RoleType$8.LIST_ITEM&&defaultActionVerb===DefaultActionVerb.CLICK){cache.isActionable.set(node,true);return true}if(node.state[StateType$2.FOCUSABLE]||node.role===RoleType$8.MENU_ITEM){const result=!node.children.some((child=>SwitchAccessPredicate.isInterestingSubtree(child,cache)));cache.isActionable.set(node,result);return result}return false}SwitchAccessPredicate.isActionable=isActionable;function isGroup(node,scope,cache){if(!node||!node.role){return false}if(cache.isGroup.has(node)){return cache.isGroup.get(node)}const scopeEqualsNode=scope&&(scope instanceof SARootNode?scope.isEquivalentTo(node):scope===node);if(scope&&!scopeEqualsNode&&RectUtil.equal(node.location,scope.location)){cache.isGroup.set(node,false);return false}if(node.state[StateType$2.INVISIBLE]){cache.isGroup.set(node,false);return false}if(node.role===RoleType$8.KEYBOARD){cache.isGroup.set(node,true);return true}let interestingBranchesCount=SwitchAccessPredicate.isActionable(node,cache)?1:0;let child=node.firstChild;while(child){if(SwitchAccessPredicate.isInterestingSubtree(child,cache)){interestingBranchesCount+=1}if(interestingBranchesCount>=SwitchAccessPredicate.GROUP_INTERESTING_CHILD_THRESHOLD){cache.isGroup.set(node,true);return true}child=child.nextSibling}cache.isGroup.set(node,false);return false}SwitchAccessPredicate.isGroup=isGroup;function isInteresting(node,scope,cache){cache=cache||new SACache;return SwitchAccessPredicate.isActionable(node,cache)||SwitchAccessPredicate.isGroup(node,scope,cache)}SwitchAccessPredicate.isInteresting=isInteresting;function isVisible(node){return Boolean(!node.state[StateType$2.OFFSCREEN]&&node.location&&node.location.top>=0&&node.location.left>=0&&!node.state[StateType$2.INVISIBLE])}SwitchAccessPredicate.isVisible=isVisible;function isInterestingSubtree(node,cache){cache=cache||new SACache;if(cache.isInterestingSubtree.has(node)){return cache.isInterestingSubtree.get(node)}const result=SwitchAccessPredicate.isActionable(node,cache)||node.children.some((child=>SwitchAccessPredicate.isInterestingSubtree(child,cache)));cache.isInterestingSubtree.set(node,result);return result}SwitchAccessPredicate.isInterestingSubtree=isInterestingSubtree;function isTextInput(node){return Boolean(node&&node.state[StateType$2.EDITABLE])}SwitchAccessPredicate.isTextInput=isTextInput;function isWindow(node){return Boolean(node&&(node.role===RoleType$8.WINDOW||node.role===RoleType$8.CLIENT&&node.parent&&node.parent.role===RoleType$8.WINDOW))}SwitchAccessPredicate.isWindow=isWindow;function restrictions(scope){const cache=new SACache;return{leaf:SwitchAccessPredicate.leaf(scope,cache),root:SwitchAccessPredicate.root(scope),visit:SwitchAccessPredicate.visit(scope,cache)}}SwitchAccessPredicate.restrictions=restrictions;function leaf(scope,cache){return node=>!SwitchAccessPredicate.isInterestingSubtree(node,cache)||scope!==node&&SwitchAccessPredicate.isInteresting(node,scope,cache)}SwitchAccessPredicate.leaf=leaf;function root(scope){return node=>scope===node}SwitchAccessPredicate.root=root;function visit(scope,cache){return node=>node.role!==RoleType$8.DESKTOP&&SwitchAccessPredicate.isInteresting(node,scope,cache)}SwitchAccessPredicate.visit=visit})(SwitchAccessPredicate||(SwitchAccessPredicate={}));TestImportManager.exportForTesting(["SwitchAccessPredicate",SwitchAccessPredicate]);const EventType$7=chrome.automation.EventType;var MenuAction$a=chrome.accessibilityPrivate.SwitchAccessMenuAction;var RoleType$7=chrome.automation.RoleType;class BackButtonNode extends SAChildNode{group_;locationChangedHandler_;static automationNode_;static clickHandler_;static locationForTesting;constructor(group){super();this.group_=group}get actions(){return[MenuAction$a.SELECT]}get automationNode(){return BackButtonNode.automationNode_}get group(){return this.group_}get location(){if(BackButtonNode.locationForTesting){return BackButtonNode.locationForTesting}if(this.automationNode){return this.automationNode.location}return undefined}get role(){return RoleType$7.BUTTON}asRootNode(){return undefined}equals(other){return other instanceof BackButtonNode}isEquivalentTo(node){return node instanceof BackButtonNode||this.automationNode===node}isGroup(){return false}isValidAndVisible(){return this.group_.isValidGroup()}onFocus(){super.onFocus();chrome.accessibilityPrivate.updateSwitchAccessBubble(chrome.accessibilityPrivate.SwitchAccessBubble.BACK_BUTTON,true,this.group_.location);BackButtonNode.findAutomationNode_();this.locationChangedHandler_=new RepeatedEventHandler(this.group_.automationNode,chrome.automation.EventType.LOCATION_CHANGED,(()=>FocusRingManager.setFocusedNode(this)),{exactMatch:true,allAncestors:true})}onUnfocus(){super.onUnfocus();chrome.accessibilityPrivate.updateSwitchAccessBubble(chrome.accessibilityPrivate.SwitchAccessBubble.BACK_BUTTON,false);if(this.locationChangedHandler_){this.locationChangedHandler_.stop()}}performAction(action){if(action===MenuAction$a.SELECT&&this.automationNode){BackButtonNode.onClick_();return ActionResponse.CLOSE_MENU}return ActionResponse.NO_ACTION_TAKEN}ignoreWhenComputingUnionOfBoundingBoxes(){return true}debugString(wholeTree,prefix="",currentNode=null){if(!this.automationNode){return"BackButtonNode"}return super.debugString(wholeTree,prefix,currentNode)}static findAutomationNode_(){if(BackButtonNode.automationNode_&&BackButtonNode.automationNode_.role){return}SwitchAccess.findNodeMatching({role:RoleType$7.BUTTON,attributes:{className:"SwitchAccessBackButtonView"}},BackButtonNode.saveAutomationNode_)}static onClick_(){if(MenuManager.isMenuOpen()){ActionManager.exitCurrentMenu()}else{Navigator.byItem.exitGroupUnconditionally()}}static saveAutomationNode_(automationNode){BackButtonNode.automationNode_=automationNode;if(BackButtonNode.clickHandler_){BackButtonNode.clickHandler_.setNodes(automationNode)}else{BackButtonNode.clickHandler_=new EventHandler(automationNode,EventType$7.CLICKED,BackButtonNode.onClick_)}}}TestImportManager.exportForTesting(BackButtonNode);var AutomationActionType=chrome.automation.ActionType;var EventType$6=chrome.automation.EventType;var MenuAction$9=chrome.accessibilityPrivate.SwitchAccessMenuAction;class BasicNode extends SAChildNode{baseNode_;parent_;locationChangedHandler_;isActionable_;static creators_=[];constructor(baseNode,parent){super();this.baseNode_=baseNode;this.parent_=parent;this.isActionable_=!this.isGroup()||SwitchAccessPredicate.isActionable(baseNode,new SACache)}get actions(){const actions=[];if(this.isActionable_){actions.push(MenuAction$9.SELECT)}if(this.isGroup()){actions.push(MenuAction$9.DRILL_DOWN)}const ancestor=this.getScrollableAncestor_();if(ancestor.scrollable){if(ancestor.scrollX>ancestor.scrollXMin){actions.push(MenuAction$9.SCROLL_LEFT)}if(ancestor.scrollX<ancestor.scrollXMax){actions.push(MenuAction$9.SCROLL_RIGHT)}if(ancestor.scrollY>ancestor.scrollYMin){actions.push(MenuAction$9.SCROLL_UP)}if(ancestor.scrollY<ancestor.scrollYMax){actions.push(MenuAction$9.SCROLL_DOWN)}}const menuActions=Object.values(MenuAction$9);const standardActions=this.baseNode_.standardActions.filter((action=>menuActions.includes(action)));return actions.concat(standardActions)}get automationNode(){return this.baseNode_}get location(){return this.baseNode_.location}get role(){return this.baseNode_.role}asRootNode(){if(!this.isGroup()){return undefined}return BasicRootNode.buildTree(this.baseNode_)}equals(rhs){if(!rhs||!(rhs instanceof BasicNode)){return false}const other=rhs;return other.baseNode_===this.baseNode_}isEquivalentTo(node){if(node instanceof BasicNode){return this.baseNode_===node.baseNode_}if(node instanceof BasicRootNode){return this.baseNode_===node.automationNode}if(node instanceof SAChildNode){return node.isEquivalentTo(this)}return this.baseNode_===node}isGroup(){const cache=new SACache;return SwitchAccessPredicate.isGroup(this.baseNode_,this.parent_,cache)}isValidAndVisible(){if(!this.baseNode_||!this.baseNode_.role){return false}return SwitchAccessPredicate.isVisible(this.baseNode_)&&super.isValidAndVisible()}onFocus(){super.onFocus();this.locationChangedHandler_=new RepeatedEventHandler(this.baseNode_,EventType$6.LOCATION_CHANGED,(()=>{if(this.isValidAndVisible()){FocusRingManager.setFocusedNode(this)}else{Navigator.byItem.moveToValidNode()}}),{exactMatch:true,allAncestors:true})}onUnfocus(){super.onUnfocus();if(this.locationChangedHandler_){this.locationChangedHandler_.stop()}}performAction(action){let ancestor;switch(action){case MenuAction$9.DRILL_DOWN:if(this.isGroup()){Navigator.byItem.enterGroup();return ActionResponse.CLOSE_MENU}console.error("Action DRILL_DOWN received on non-group node.");return ActionResponse.NO_ACTION_TAKEN;case MenuAction$9.SELECT:this.baseNode_.doDefault();return ActionResponse.CLOSE_MENU;case MenuAction$9.SCROLL_DOWN:ancestor=this.getScrollableAncestor_();if(ancestor.scrollable){ancestor.scrollDown((()=>{}))}return ActionResponse.RELOAD_MENU;case MenuAction$9.SCROLL_UP:ancestor=this.getScrollableAncestor_();if(ancestor.scrollable){ancestor.scrollUp((()=>{}))}return ActionResponse.RELOAD_MENU;case MenuAction$9.SCROLL_RIGHT:ancestor=this.getScrollableAncestor_();if(ancestor.scrollable){ancestor.scrollRight((()=>{}))}return ActionResponse.RELOAD_MENU;case MenuAction$9.SCROLL_LEFT:ancestor=this.getScrollableAncestor_();if(ancestor.scrollable){ancestor.scrollLeft((()=>{}))}return ActionResponse.RELOAD_MENU;default:const actions=Object.values(AutomationActionType);const automationAction=actions.find((a=>a===action));if(automationAction){this.baseNode_.performStandardAction(automationAction)}return ActionResponse.CLOSE_MENU}}getScrollableAncestor_(){let ancestor=this.baseNode_;while(!ancestor.scrollable&&ancestor.parent){ancestor=ancestor.parent}return ancestor}static create(baseNode,parent){const item=BasicNode.creators.find((creator=>creator.predicate(baseNode)));if(item){return item.creator(baseNode,parent)}return new BasicNode(baseNode,parent)}static get creators(){return BasicNode.creators_}}class BasicRootNode extends SARootNode{static builders_=[];childrenChangedHandler_;invalidated_=false;constructor(baseNode){super(baseNode)}get location(){return this.automationNode.location||super.location}equals(other){if(!(other instanceof BasicRootNode)){return false}return super.equals(other)&&this.automationNode===other.automationNode}isEquivalentTo(node){if(node instanceof BasicRootNode||node instanceof BasicNode){return this.automationNode===node.automationNode}if(node instanceof SAChildNode){return node.isEquivalentTo(this)}return this.automationNode===node}isValidGroup(){if(!this.automationNode.role){return false}return!this.invalidated_&&SwitchAccessPredicate.isVisible(this.automationNode)&&super.isValidGroup()}onFocus(){super.onFocus();this.childrenChangedHandler_=new RepeatedEventHandler(this.automationNode,EventType$6.CHILDREN_CHANGED,(event=>{const cache=new SACache;if(SwitchAccessPredicate.isInterestingSubtree(event.target,cache)){this.refresh()}}))}onUnfocus(){super.onUnfocus();if(this.childrenChangedHandler_){this.childrenChangedHandler_.stop()}}refreshChildren(){const childConstructor=node=>BasicNode.create(node,this);try{BasicRootNode.findAndSetChildren(this,childConstructor)}catch(e){this.invalidated_=true}}refresh(){let focusedChild=null;for(const child of this.children){if(child.isFocused()){focusedChild=child;break}}this.refreshChildren();if(this.invalidated_){this.onUnfocus();Navigator.byItem.moveToValidNode();return}if(focusedChild){for(const child of this.children){if(child.isEquivalentTo(focusedChild)){Navigator.byItem.forceFocusedNode(child);return}}}Navigator.byItem.moveToValidNode()}static buildTree(rootNode){const item=BasicRootNode.builders.find((builder=>builder.predicate(rootNode)));if(item){return item.builder(rootNode)}const root=new BasicRootNode(rootNode);const childConstructor=node=>BasicNode.create(node,root);BasicRootNode.findAndSetChildren(root,childConstructor);return root}static findAndSetChildren(root,childConstructor){const interestingChildren=BasicRootNode.getInterestingChildren(root);const children=interestingChildren.map(childConstructor).filter((child=>child.isValidAndVisible()));if(children.length<1){throw SwitchAccess.error(ErrorType.NO_CHILDREN,"Root node must have at least 1 interesting child.",true)}children.push(new BackButtonNode(root));root.children=children}static getInterestingChildren(root){if(root instanceof BasicRootNode){root=root.automationNode}if(root.children.length===0){return[]}const interestingChildren=[];const treeWalker=new AutomationTreeWalker(root,constants.Dir.FORWARD,SwitchAccessPredicate.restrictions(root));let node=treeWalker.next().node;while(node){interestingChildren.push(node);node=treeWalker.next().node}return interestingChildren}static get builders(){return BasicRootNode.builders_}}TestImportManager.exportForTesting(BasicNode,BasicRootNode);var MenuAction$8=chrome.accessibilityPrivate.SwitchAccessMenuAction;var RoleType$6=chrome.automation.RoleType;class GroupNode extends SAChildNode{children_;containingNode_;constructor(children_,containingNode_){super();this.children_=children_;this.containingNode_=containingNode_}get actions(){return[MenuAction$8.DRILL_DOWN]}get automationNode(){return this.containingNode_}get location(){const childLocations=this.children_.filter((c=>c.isValidAndVisible())).map((c=>c.location));return RectUtil.unionAll(childLocations)}get role(){return RoleType$6.GROUP}asRootNode(){const root=new SARootNode(this.containingNode_);const children=[...this.children_];children.push(new BackButtonNode(root));root.children=children;return root}equals(other){if(!(other instanceof GroupNode)){return false}if(other.children_.length!==this.children_.length){return false}for(let i=0;i<this.children_.length;i++){if(!other.children_[i].equals(this.children_[i])){return false}}return true}isEquivalentTo(node){if(node instanceof GroupNode){return this.equals(node)}for(const child of this.children_){if(child.isEquivalentTo(node)){return true}}return false}isGroup(){return true}isValidAndVisible(){for(const child of this.children_){if(child.isValidAndVisible()){return super.isValidAndVisible()}}return false}performAction(action){if(action===MenuAction$8.DRILL_DOWN){Navigator.byItem.enterGroup();return ActionResponse.CLOSE_MENU}return ActionResponse.NO_ACTION_TAKEN}static separateByRow(nodes,containingNode){const result=[];for(let i=0;i<nodes.length;){const children=[];children.push(nodes[i]);i++;while(i<nodes.length&&RectUtil.sameRow(children[0].location,nodes[i].location)){children.push(nodes[i]);i++}result.push(new GroupNode(children,containingNode))}return result}}TestImportManager.exportForTesting(GroupNode);const EventType$5=chrome.automation.EventType;var MenuAction$7=chrome.accessibilityPrivate.SwitchAccessMenuAction;const RoleType$5=chrome.automation.RoleType;class KeyboardNode extends BasicNode{static resetting=false;constructor(node,parent){super(node,parent)}get actions(){return[MenuAction$7.SELECT]}asRootNode(){return undefined}isGroup(){return false}isValidAndVisible(){if(super.isValidAndVisible()){return true}if(!KeyboardNode.resetting&&Navigator.byItem.currentGroupHasChild(this)){KeyboardNode.resetting=true;KeyboardRootNode.ignoreNextExit=true;Navigator.byItem.exitKeyboard().then((()=>Navigator.byItem.enterKeyboard()))}return false}performAction(action){if(action!==MenuAction$7.SELECT){return ActionResponse.NO_ACTION_TAKEN}const keyLocation=this.location;if(!keyLocation){return ActionResponse.NO_ACTION_TAKEN}const center=RectUtil.center(keyLocation);EventGenerator.sendMouseClick(center.x,center.y,{delayMs:VK_KEY_PRESS_DURATION_MS});return ActionResponse.CLOSE_MENU}}class KeyboardRootNode extends BasicRootNode{static ignoreNextExit=false;static isVisible_=false;static explicitStateChange_=false;static object_;constructor(groupNode){super(groupNode);KeyboardNode.resetting=false}isValidGroup(){return true}onExit(){if(KeyboardRootNode.ignoreNextExit){KeyboardRootNode.ignoreNextExit=false;return}if(KeyboardRootNode.isVisible_){KeyboardRootNode.explicitStateChange_=true;chrome.accessibilityPrivate.setVirtualKeyboardVisible(false)}AutoScanManager.setInKeyboard(false)}refreshChildren(){KeyboardRootNode.findAndSetChildren_(this)}static buildTree(){KeyboardRootNode.loadKeyboard_();AutoScanManager.setInKeyboard(true);const keyboard=KeyboardRootNode.getKeyboardObject();if(!keyboard){throw SwitchAccess.error(ErrorType.MISSING_KEYBOARD,"Could not find keyboard in the automation tree",true)}const root=new KeyboardRootNode(keyboard);KeyboardRootNode.findAndSetChildren_(root);return root}static startWatchingVisibility(){const keyboardObject=KeyboardRootNode.getKeyboardObject();if(!keyboardObject){SwitchAccess.findNodeMatching({role:RoleType$5.KEYBOARD},KeyboardRootNode.startWatchingVisibility);return}KeyboardRootNode.isVisible_=KeyboardRootNode.isKeyboardVisible_();new EventHandler(keyboardObject,EventType$5.LOAD_COMPLETE,KeyboardRootNode.checkVisibilityChanged_).start();new EventHandler(keyboardObject,EventType$5.STATE_CHANGED,KeyboardRootNode.checkVisibilityChanged_,{exactMatch:true}).start()}static isKeyboardVisible_(){const keyboardObject=KeyboardRootNode.getKeyboardObject();return Boolean(keyboardObject&&SwitchAccessPredicate.isVisible(keyboardObject)&&keyboardObject.find({role:RoleType$5.ROOT_WEB_AREA}))}static checkVisibilityChanged_(_event){const currentlyVisible=KeyboardRootNode.isKeyboardVisible_();if(currentlyVisible===KeyboardRootNode.isVisible_){return}KeyboardRootNode.isVisible_=currentlyVisible;if(KeyboardRootNode.explicitStateChange_){KeyboardRootNode.explicitStateChange_=false;return}if(KeyboardRootNode.isVisible_){Navigator.byItem.enterKeyboard()}else{Navigator.byItem.exitKeyboard()}}static findAndSetChildren_(root){const childConstructor=node=>new KeyboardNode(node,root);const interestingChildren=root.automationNode.findAll({role:RoleType$5.BUTTON});const children=GroupNode.separateByRow(interestingChildren.map(childConstructor),root.automationNode);children.push(new BackButtonNode(root));root.children=children}static getKeyboardObject(){if(!this.object_||!this.object_.role){this.object_=Navigator.byItem.desktopNode.find({role:RoleType$5.KEYBOARD})}return this.object_}static loadKeyboard_(){if(KeyboardRootNode.isVisible_){return}chrome.accessibilityPrivate.setVirtualKeyboardVisible(true)}}BasicRootNode.builders.push({predicate:rootNode=>rootNode.role===RoleType$5.KEYBOARD,builder:KeyboardRootNode.buildTree});const VK_KEY_PRESS_DURATION_MS=100;TestImportManager.exportForTesting(KeyboardNode,KeyboardRootNode);const EventType$4=chrome.automation.EventType;const RoleType$4=chrome.automation.RoleType;let readyCallback;const readyPromise=new Promise((resolve=>readyCallback=resolve));class SwitchAccess{static instance;static mode=Mode.ITEM_SCAN;constructor(){}static async init(desktop){if(SwitchAccess.instance){throw new Error("Cannot create two SwitchAccess.instances")}SwitchAccess.instance=new SwitchAccess;const currentFocus=await AsyncUtil.getFocus();await SwitchAccess.instance.waitForFocus_(desktop,currentFocus)}static start(){KeyboardRootNode.startWatchingVisibility();Navigator.byItem.start();readyCallback()}static async ready(){return readyPromise}static improvedTextInputEnabled(){return Flags.isEnabled(FlagName.SWITCH_ACCESS_TEXT)}static findNodeMatching(findParams,foundCallback){const desktop=Navigator.byItem.desktopNode;let node=desktop.find(findParams);if(node){foundCallback(node);return}const eventHandler=new EventHandler(desktop,EventType$4.CHILDREN_CHANGED,(_evt=>{}));const onEvent=event=>{if(event.target.matches(findParams)){eventHandler.stop();foundCallback(event.target)}else if(event.target.children.length>0){node=event.target.find(findParams);if(node){eventHandler.stop();foundCallback(node)}}};eventHandler.setCallback(onEvent);eventHandler.start()}static error(errorType,errorString,shouldRecover=false){if(shouldRecover){setTimeout(Navigator.byItem.moveToValidNode.bind(Navigator.byItem),0)}const errorTypeCountForUMA=Object.keys(ErrorType).length;chrome.metricsPrivate.recordEnumerationValue("Accessibility.CrosSwitchAccess.Error",errorType,errorTypeCountForUMA);return new Error(errorString)}async waitForFocus_(desktop,currentFocus){return new Promise((resolve=>{if(currentFocus&&currentFocus.role!==RoleType$4.WEB_VIEW){resolve();return}let callbackId=0;const listener=maybeEvent=>{if(maybeEvent&&maybeEvent.target.role===RoleType$4.WEB_VIEW){return}desktop.removeEventListener(EventType$4.FOCUS,listener,false);clearTimeout(callbackId);resolve()};desktop.addEventListener(EventType$4.FOCUS,listener,false);callbackId=setTimeout(listener,5e3)}))}}TestImportManager.exportForTesting(SwitchAccess);const EventType$3=chrome.automation.EventType;const MenuAction$6=chrome.accessibilityPrivate.SwitchAccessMenuAction;class TextNavigationManager{static instance_;currentlySelecting_=false;selectionExists_=false;clipboardHasData_=false;selectionStartIndex_=TextNavigationManager.NO_SELECT_INDEX;selectionStartObject_;selectionEndIndex_=TextNavigationManager.NO_SELECT_INDEX;selectionEndObject_;selectionListener_;constructor(){this.selectionListener_=new EventHandler([],EventType$3.TEXT_SELECTION_CHANGED,(()=>this.onNavChange_()));if(SwitchAccess.improvedTextInputEnabled()){chrome.clipboard.onClipboardDataChanged.addListener((()=>this.updateClipboardHasData_()))}}static get instance(){if(!TextNavigationManager.instance_){TextNavigationManager.instance_=new TextNavigationManager}return TextNavigationManager.instance_}static currentlySelecting(){const manager=TextNavigationManager.instance;return manager.selectionStartIndex_!==TextNavigationManager.NO_SELECT_INDEX&&manager.currentlySelecting_}static jumpToBeginning(){const manager=TextNavigationManager.instance;if(manager.currentlySelecting_){manager.setupDynamicSelection_(false)}EventGenerator.sendKeyPress(KeyCode.HOME,{ctrl:true})}static jumpToEnd(){const manager=TextNavigationManager.instance;if(manager.currentlySelecting_){manager.setupDynamicSelection_(false)}EventGenerator.sendKeyPress(KeyCode.END,{ctrl:true})}static moveBackwardOneChar(){const manager=TextNavigationManager.instance;if(manager.currentlySelecting_){manager.setupDynamicSelection_(true)}EventGenerator.sendKeyPress(KeyCode.LEFT)}static moveBackwardOneWord(){const manager=TextNavigationManager.instance;if(manager.currentlySelecting_){manager.setupDynamicSelection_(false)}EventGenerator.sendKeyPress(KeyCode.LEFT,{ctrl:true})}static moveDownOneLine(){const manager=TextNavigationManager.instance;if(manager.currentlySelecting_){manager.setupDynamicSelection_(true)}EventGenerator.sendKeyPress(KeyCode.DOWN)}static moveForwardOneChar(){const manager=TextNavigationManager.instance;if(manager.currentlySelecting_){manager.setupDynamicSelection_(true)}EventGenerator.sendKeyPress(KeyCode.RIGHT)}static moveForwardOneWord(){const manager=TextNavigationManager.instance;if(manager.currentlySelecting_){manager.setupDynamicSelection_(false)}EventGenerator.sendKeyPress(KeyCode.RIGHT,{ctrl:true})}static moveUpOneLine(){const manager=TextNavigationManager.instance;if(manager.currentlySelecting_){manager.setupDynamicSelection_(true)}EventGenerator.sendKeyPress(KeyCode.UP)}static resetCurrentlySelecting(){const manager=TextNavigationManager.instance;manager.currentlySelecting_=false;manager.manageNavigationListener_(false);manager.selectionStartIndex_=TextNavigationManager.NO_SELECT_INDEX;manager.selectionEndIndex_=TextNavigationManager.NO_SELECT_INDEX;if(manager.currentlySelecting_){manager.setupDynamicSelection_(true)}EventGenerator.sendKeyPress(KeyCode.DOWN)}static get clipboardHasData(){return TextNavigationManager.instance.clipboardHasData_}static get selectionExists(){return TextNavigationManager.instance.selectionExists_}static set selectionExists(newVal){TextNavigationManager.instance.selectionExists_=newVal}getSelEndIndex(){return this.selectionEndIndex_}resetSelStartIndex(){this.selectionStartIndex_=TextNavigationManager.NO_SELECT_INDEX}getSelStartIndex(){return this.selectionStartIndex_}setSelStartIndexAndNode(startIndex,textNode){this.selectionStartIndex_=startIndex;this.selectionStartObject_=textNode}static saveSelectStart(){const manager=TextNavigationManager.instance;chrome.automation.getFocus((focusedNode=>{manager.selectionStartObject_=focusedNode;manager.selectionStartIndex_=manager.getSelectionIndexFromNode_(manager.selectionStartObject_,true);manager.currentlySelecting_=true}))}getSelectionIndexFromNode_(node,getStart){let indexFromNode=TextNavigationManager.NO_SELECT_INDEX;if(getStart){indexFromNode=node.textSelStart}else{indexFromNode=node.textSelEnd}if(indexFromNode===undefined){return TextNavigationManager.NO_SELECT_INDEX}return indexFromNode}manageNavigationListener_(addListener){if(!this.selectionStartObject_){return}if(addListener){this.selectionListener_.setNodes(this.selectionStartObject_);this.selectionListener_.start()}else{this.selectionListener_.stop()}}onNavChange_(){this.manageNavigationListener_(false);if(this.currentlySelecting_){TextNavigationManager.saveSelectEnd()}}static saveSelectEnd(){const manager=TextNavigationManager.instance;chrome.automation.getFocus((focusedNode=>{manager.selectionEndObject_=focusedNode;manager.selectionEndIndex_=manager.getSelectionIndexFromNode_(manager.selectionEndObject_,false);manager.saveSelection_()}))}saveSelection_(){if(this.selectionStartIndex_===TextNavigationManager.NO_SELECT_INDEX||this.selectionEndIndex_===TextNavigationManager.NO_SELECT_INDEX){console.error(SwitchAccess.error(ErrorType.INVALID_SELECTION_BOUNDS,"Selection bounds are not set properly: "+this.selectionStartIndex_+" "+this.selectionEndIndex_))}else{this.setSelection_()}}setupDynamicSelection_(needToResetCursor){if(needToResetCursor){if(TextNavigationManager.currentlySelecting()&&this.selectionEndIndex_!==TextNavigationManager.NO_SELECT_INDEX){this.setSelection_()}}this.manageNavigationListener_(true)}setSelection_(){if(this.selectionStartObject_===this.selectionEndObject_){this.selectionStartObject_.setSelection(this.selectionStartIndex_,this.selectionEndIndex_)}else{chrome.automation.setDocumentSelection({anchorObject:this.selectionStartObject_,anchorOffset:this.selectionStartIndex_,focusObject:this.selectionEndObject_,focusOffset:this.selectionEndIndex_})}}updateClipboardHasData_(){this.clipboardHasData_=true;const node=Navigator.byItem.currentNode;if(node.hasAction(MenuAction$6.PASTE)){ActionManager.refreshMenuForNode(node)}}}(function(TextNavigationManager){TextNavigationManager.NO_SELECT_INDEX=-1})(TextNavigationManager||(TextNavigationManager={}));TestImportManager.exportForTesting(TextNavigationManager);var EventType$2=chrome.automation.EventType;var MenuAction$5=chrome.accessibilityPrivate.SwitchAccessMenuAction;var StateType$1=chrome.automation.StateType;class EditableTextNode extends BasicNode{constructor(baseNode,parent){super(baseNode,parent)}get actions(){const actions=super.actions;const selectIndex=actions.indexOf(MenuAction$5.SELECT);if(selectIndex>=0){actions.splice(selectIndex,1)}actions.unshift(MenuAction$5.KEYBOARD,MenuAction$5.DICTATION);if(SwitchAccess.improvedTextInputEnabled()){actions.push(MenuAction$5.MOVE_CURSOR,MenuAction$5.JUMP_TO_BEGINNING_OF_TEXT,MenuAction$5.JUMP_TO_END_OF_TEXT,MenuAction$5.MOVE_BACKWARD_ONE_CHAR_OF_TEXT,MenuAction$5.MOVE_FORWARD_ONE_CHAR_OF_TEXT,MenuAction$5.MOVE_BACKWARD_ONE_WORD_OF_TEXT,MenuAction$5.MOVE_FORWARD_ONE_WORD_OF_TEXT,MenuAction$5.MOVE_DOWN_ONE_LINE_OF_TEXT,MenuAction$5.MOVE_UP_ONE_LINE_OF_TEXT);actions.push(MenuAction$5.START_TEXT_SELECTION);if(TextNavigationManager.currentlySelecting()){actions.push(MenuAction$5.END_TEXT_SELECTION)}if(TextNavigationManager.selectionExists){actions.push(MenuAction$5.CUT,MenuAction$5.COPY)}if(TextNavigationManager.clipboardHasData){actions.push(MenuAction$5.PASTE)}}return actions}doDefaultAction(){this.performAction(MenuAction$5.KEYBOARD)}performAction(action){switch(action){case MenuAction$5.KEYBOARD:Navigator.byItem.enterKeyboard();return ActionResponse.CLOSE_MENU;case MenuAction$5.DICTATION:if(this.automationNode.state[StateType$1.FOCUSED]){chrome.accessibilityPrivate.toggleDictation()}else{new EventHandler(this.automationNode,EventType$2.FOCUS,(()=>chrome.accessibilityPrivate.toggleDictation()),{exactMatch:true,listenOnce:true}).start();this.automationNode.focus()}return ActionResponse.CLOSE_MENU;case MenuAction$5.MOVE_CURSOR:return ActionResponse.OPEN_TEXT_NAVIGATION_MENU;case MenuAction$5.CUT:EventGenerator.sendKeyPress(KeyCode.X,{ctrl:true});return ActionResponse.REMAIN_OPEN;case MenuAction$5.COPY:EventGenerator.sendKeyPress(KeyCode.C,{ctrl:true});return ActionResponse.REMAIN_OPEN;case MenuAction$5.PASTE:EventGenerator.sendKeyPress(KeyCode.V,{ctrl:true});return ActionResponse.REMAIN_OPEN;case MenuAction$5.START_TEXT_SELECTION:TextNavigationManager.saveSelectStart();return ActionResponse.OPEN_TEXT_NAVIGATION_MENU;case MenuAction$5.END_TEXT_SELECTION:TextNavigationManager.saveSelectEnd();return ActionResponse.EXIT_SUBMENU;case MenuAction$5.JUMP_TO_BEGINNING_OF_TEXT:TextNavigationManager.jumpToBeginning();return ActionResponse.REMAIN_OPEN;case MenuAction$5.JUMP_TO_END_OF_TEXT:TextNavigationManager.jumpToEnd();return ActionResponse.REMAIN_OPEN;case MenuAction$5.MOVE_BACKWARD_ONE_CHAR_OF_TEXT:TextNavigationManager.moveBackwardOneChar();return ActionResponse.REMAIN_OPEN;case MenuAction$5.MOVE_BACKWARD_ONE_WORD_OF_TEXT:TextNavigationManager.moveBackwardOneWord();return ActionResponse.REMAIN_OPEN;case MenuAction$5.MOVE_DOWN_ONE_LINE_OF_TEXT:TextNavigationManager.moveDownOneLine();return ActionResponse.REMAIN_OPEN;case MenuAction$5.MOVE_FORWARD_ONE_CHAR_OF_TEXT:TextNavigationManager.moveForwardOneChar();return ActionResponse.REMAIN_OPEN;case MenuAction$5.MOVE_UP_ONE_LINE_OF_TEXT:TextNavigationManager.moveUpOneLine();return ActionResponse.REMAIN_OPEN;case MenuAction$5.MOVE_FORWARD_ONE_WORD_OF_TEXT:TextNavigationManager.moveForwardOneWord();return ActionResponse.REMAIN_OPEN}return super.performAction(action)}}BasicNode.creators.push({predicate:SwitchAccessPredicate.isTextInput,creator:(node,parentNode)=>new EditableTextNode(node,parentNode)});var MenuAction$4=chrome.accessibilityPrivate.SwitchAccessMenuAction;var RoleType$3=chrome.automation.RoleType;class SliderNode extends BasicNode{isCustomSlider_=true;constructor(baseNode,parent){super(baseNode,parent)}onFocus(){super.onFocus();this.automationNode.focus()}performAction(action){if(this.isCustomSlider_){if(action===MenuAction$4.INCREMENT){EventGenerator.sendKeyPress(KeyCode.RIGHT);return ActionResponse.REMAIN_OPEN}else if(action===MenuAction$4.DECREMENT){EventGenerator.sendKeyPress(KeyCode.LEFT);return ActionResponse.REMAIN_OPEN}}return super.performAction(action)}}BasicNode.creators.push({predicate:baseNode=>baseNode.role===RoleType$3.SLIDER,creator:(node,parent)=>new SliderNode(node,parent)});var MenuAction$3=chrome.accessibilityPrivate.SwitchAccessMenuAction;var RoleType$2=chrome.automation.RoleType;class TabNode extends BasicNode{tabAsRoot_;constructor(node,parent,tabAsRoot_){super(node,parent);this.tabAsRoot_=tabAsRoot_}get actions(){return[MenuAction$3.DRILL_DOWN]}asRootNode(){return this.tabAsRoot_}isGroup(){return true}performAction(action){if(action!==MenuAction$3.DRILL_DOWN){return ActionResponse.NO_ACTION_TAKEN}Navigator.byItem.enterGroup();return ActionResponse.CLOSE_MENU}static create(tabNode,parent){const tabAsRoot=new BasicRootNode(tabNode);let closeButton;for(const child of tabNode.children){if(child.role===RoleType$2.BUTTON){closeButton=new BasicNode(child,tabAsRoot);break}}if(!closeButton){return new ActionableTabNode(tabNode,parent,null)}const tabToSelect=new ActionableTabNode(tabNode,tabAsRoot,closeButton);const backButton=new BackButtonNode(tabAsRoot);tabAsRoot.children=[tabToSelect,closeButton,backButton];return new TabNode(tabNode,parent,tabAsRoot)}}class ActionableTabNode extends BasicNode{closeButton_;constructor(node,parent,closeButton_){super(node,parent);this.closeButton_=closeButton_}get actions(){return[MenuAction$3.SELECT]}get location(){if(!this.closeButton_){return super.location}return RectUtil.difference(super.location,this.closeButton_.location)}asRootNode(){return undefined}isGroup(){return false}}BasicNode.creators.push({predicate:baseNode=>baseNode.role===RoleType$2.TAB&&baseNode.root.role===RoleType$2.DESKTOP,creator:TabNode.create});class DesktopNode extends BasicRootNode{equals(other){return other instanceof DesktopNode}isValidGroup(){return true}refresh(){let focusedChild=null;for(const child of this.children){if(child.isFocused()){focusedChild=child;break}}const childConstructor=node=>BasicNode.create(node,this);DesktopNode.findAndSetChildren(this,childConstructor);for(const child of this.children){if(child.isEquivalentTo(focusedChild)){Navigator.byItem.forceFocusedNode(child);return}}Navigator.byItem.forceFocusedNode(this.children[0])}static build(desktop){const root=new DesktopNode(desktop);const childConstructor=autoNode=>BasicNode.create(autoNode,root);DesktopNode.findAndSetChildren(root,childConstructor);return root}static findAndSetChildren(root,childConstructor){const interestingChildren=BasicRootNode.getInterestingChildren(root);if(interestingChildren.length<1){throw SwitchAccess.error(ErrorType.MALFORMED_DESKTOP,"Desktop node must have at least 1 interesting child.",false)}root.children=interestingChildren.map(childConstructor)}}TestImportManager.exportForTesting(DesktopNode);class FocusData{group;focus;constructor(group,focus){this.group=group;this.focus=focus}isValid(){if(this.group.isValidGroup()){this.group.refreshChildren()}return this.group.isValidGroup()}}class FocusHistory{dataStack=[];buildFromAutomationNode(node){if(!node.parent){return false}const cache=new SACache;const ancestorStack=[node];while(node.parent){ancestorStack.push(node.parent);node=node.parent}let group=DesktopNode.build(ancestorStack.pop());const firstAncestor=ancestorStack[ancestorStack.length-1];if(!SwitchAccessPredicate.isInterestingSubtree(firstAncestor,cache)){return false}const newDataStack=[];while(ancestorStack.length>0){const candidate=ancestorStack.pop();if(!SwitchAccessPredicate.isInteresting(candidate,group,cache)){continue}const focus=group.findChild(candidate);if(!focus){continue}newDataStack.push(new FocusData(group,focus));group=focus.asRootNode();if(!group){break}}if(newDataStack.length===0){return false}this.dataStack=newDataStack;return true}containsDataMatchingPredicate(predicate){for(const data of this.dataStack){if(predicate(data)){return true}}return false}peek(){return this.dataStack[this.dataStack.length-1]||null}retrieve(){let data=this.dataStack.pop();while(data&&!data.isValid()){data=this.dataStack.pop()}if(data){return data}const desktop=new DesktopNode(Navigator.byItem.desktopNode);return new FocusData(desktop,desktop.firstChild)}save(data){this.dataStack.push(data)}[Symbol.iterator](){return this.dataStack[Symbol.iterator]()}}class ItemNavigatorInterface{}class ModalDialogRootNode extends BasicRootNode{onExit(){EventGenerator.sendKeyPress(KeyCode.ESCAPE)}static buildTree(dialogNode){const root=new ModalDialogRootNode(dialogNode);const childConstructor=node=>BasicNode.create(node,root);BasicRootNode.findAndSetChildren(root,childConstructor);return root}}const EventType$1=chrome.automation.EventType;const RoleType$1=chrome.automation.RoleType;const TreeChangeObserverFilter=chrome.automation.TreeChangeObserverFilter;const TreeChangeType=chrome.automation.TreeChangeType;class ItemScanManager extends ItemNavigatorInterface{desktop_;group_;node_;history_;suspendedGroup_=null;ignoreFocusInKeyboard_=false;constructor(desktop){super();this.desktop_=desktop;this.group_=DesktopNode.build(this.desktop_);this.node_=this.group_.firstChild;this.history_=new FocusHistory}currentGroupHasChild(node){return this.group_.children.includes(node)}enterGroup(){if(!this.node_.isGroup()){return}const newGroup=this.node_.asRootNode();if(newGroup){this.history_.save(new FocusData(this.group_,this.node_));this.setGroup_(newGroup)}}enterKeyboard(){this.ignoreFocusInKeyboard_=true;this.node_.automationNode.focus();const keyboard=KeyboardRootNode.buildTree();this.jumpTo_(keyboard)}exitGroupUnconditionally(){this.exitGroup_()}exitIfInGroup(node){if(this.group_.isEquivalentTo(node)){this.exitGroup_()}}async exitKeyboard(){this.ignoreFocusInKeyboard_=false;const isKeyboard=data=>data.group instanceof KeyboardRootNode;if(!(this.group_ instanceof KeyboardRootNode)&&!this.history_.containsDataMatchingPredicate(isKeyboard)){return}while(this.history_.peek()!==null){if(this.group_ instanceof KeyboardRootNode){this.exitGroup_();break}this.exitGroup_()}const focus=await AsyncUtil.getFocus();if(focus){this.moveTo_(focus)}else{this.moveToValidNode()}}forceFocusedNode(node){if(this.node_!==node){this.setNode_(node)}}getTreeForDebugging(wholeTree=true){if(!wholeTree){console.log(this.group_.debugString(wholeTree));return this.group_}const desktopRoot=DesktopNode.build(this.desktop_);console.log(desktopRoot.debugString(wholeTree,"",this.node_));return desktopRoot}jumpTo(automationNode){if(!automationNode){return}const node=BasicRootNode.buildTree(automationNode);this.jumpTo_(node,false)}moveBackward(){if(this.node_.isValidAndVisible()){this.tryMoving(this.node_.previous,(node=>node.previous),this.node_)}else{this.moveToValidNode()}}moveForward(){if(this.node_.isValidAndVisible()){this.tryMoving(this.node_.next,(node=>node.next),this.node_)}else{this.moveToValidNode()}}async tryMoving(node,getNext,startingNode){if(node===startingNode){return}if(!(node instanceof BasicNode)){this.setNode_(node);return}if(!SwitchAccessPredicate.isWindow(node.automationNode)){this.setNode_(node);return}const location=node.location;if(!location){this.moveToValidNode();return}const center=RectUtil.center(location);const hitNode=await new Promise((resolve=>this.desktop_.hitTestWithReply(center.x,location.top,resolve)));if(AutomationUtil.isDescendantOf(hitNode,node.automationNode)){this.setNode_(node)}else if(node.isValidAndVisible()){this.tryMoving(getNext(node),getNext,startingNode)}else{this.moveToValidNode()}}moveToValidNode(){const nodeIsValid=this.node_.isValidAndVisible();const groupIsValid=this.group_.isValidGroup();if(nodeIsValid&&groupIsValid){return}if(nodeIsValid&&!(this.node_ instanceof BackButtonNode)){this.moveTo_(this.node_.automationNode);return}const child=this.group_.firstValidChild();if(groupIsValid&&child){this.setNode_(child);return}this.restoreFromHistory_();if(!this.group_.isEquivalentTo(MenuManager.menuAutomationNode)){ActionManager.exitAllMenus()}}restart(){const point=Navigator.byPoint.currentPoint;SwitchAccess.mode=Mode.ITEM_SCAN;this.desktop_.hitTestWithReply(point.x,point.y,(node=>this.moveTo_(node)))}restoreSuspendedGroup(){if(this.suspendedGroup_){FocusRingManager.clearAll();this.history_.save(new FocusData(this.group_,this.node_));this.loadFromData_(this.suspendedGroup_)}}suspendCurrentGroup(){const data=new FocusData(this.group_,this.node_);this.exitGroup_();this.suspendedGroup_=data}get currentNode(){this.moveToValidNode();return this.node_}get desktopNode(){return this.desktop_}onFocusChange_(event){if(SwitchAccess.mode===Mode.POINT_SCAN){return}if(event.eventFrom==="action"){return}if(this.ignoreFocusInKeyboard_||this.group_ instanceof KeyboardRootNode||MenuManager.isMenuOpen()){return}if(this.node_.isEquivalentTo(event.target)){return}this.moveTo_(event.target)}onScrollChange_(){if(SwitchAccess.mode===Mode.POINT_SCAN){return}if(this.node_.isValidAndVisible()){FocusRingManager.setFocusedNode(this.node_)}this.group_.refresh();ActionManager.refreshMenuUnconditionally()}onModalDialog_(event){if(SwitchAccess.mode===Mode.POINT_SCAN){return}const modalRoot=ModalDialogRootNode.buildTree(event.target);if(modalRoot.isValidGroup()){this.jumpTo_(modalRoot)}}onTreeChange_(treeChange){if(SwitchAccess.mode===Mode.POINT_SCAN){return}if(treeChange.type===TreeChangeType.NODE_REMOVED){this.group_.refresh();this.moveToValidNode()}else if(treeChange.type===TreeChangeType.SUBTREE_UPDATE_END){this.group_.refresh()}}exitGroup_(){this.group_.onExit();this.restoreFromHistory_()}start(){chrome.automation.getFocus((focus=>{if(focus&&this.history_.buildFromAutomationNode(focus)){this.restoreFromHistory_()}else{this.group_.onFocus();this.node_.onFocus()}}));new RepeatedEventHandler(this.desktop_,EventType$1.FOCUS,(event=>this.onFocusChange_(event)));new RepeatedEventHandler(this.desktop_,EventType$1.SCROLL_POSITION_CHANGED,(()=>this.onScrollChange_()));new RepeatedEventHandler(this.desktop_,EventType$1.SCROLL_HORIZONTAL_POSITION_CHANGED,(()=>this.onScrollChange_()));new RepeatedEventHandler(this.desktop_,EventType$1.SCROLL_VERTICAL_POSITION_CHANGED,(()=>this.onScrollChange_()));new RepeatedTreeChangeHandler(TreeChangeObserverFilter.ALL_TREE_CHANGES,(treeChange=>this.onTreeChange_(treeChange)),{predicate:treeChange=>this.group_.findChild(treeChange.target)!=null||this.group_.isEquivalentTo(treeChange.target)});new EventHandler(this.desktop_,[EventType$1.MENU_START,EventType$1.SHOW],(event=>this.onModalDialog_(event))).start()}jumpTo_(group,shouldExitMenu=true){if(shouldExitMenu){ActionManager.exitAllMenus()}this.history_.save(new FocusData(this.group_,this.node_));this.setGroup_(group)}moveTo_(automationNode){ActionManager.exitAllMenus();if(this.history_.buildFromAutomationNode(automationNode)){this.restoreFromHistory_()}}restoreFromHistory_(){this.loadFromData_(this.history_.retrieve())}loadFromData_(data){if(!data.group.isValidGroup()){return}let focusTarget=null;for(const child of data.group.children){if(child.isEquivalentTo(data.focus)){focusTarget=child;break}}if(focusTarget&&focusTarget.isValidAndVisible()){this.setGroup_(data.group,focusTarget)}else{this.setGroup_(data.group)}}setGroup_(group,focus){this.suspendedGroup_=null;this.group_.onUnfocus();this.group_=group;this.group_.onFocus();const node=focus||this.group_.firstValidChild();if(!node){this.moveToValidNode();return}chrome.automation.getFocus((currentAutomationFocus=>{const newAutomationNode=node.automationNode;if(!newAutomationNode||!currentAutomationFocus){return}if(AutomationUtil.isDescendantOf(currentAutomationFocus,newAutomationNode)||AutomationUtil.isDescendantOf(newAutomationNode,currentAutomationFocus)){return}let widget=newAutomationNode;while(widget&&(widget.role!==RoleType$1.WINDOW||widget.className!=="Widget")){widget=widget.parent}if(widget&&widget.parent){widget.parent.focus()}}));this.setNode_(node)}setNode_(node){if(!node.isValidAndVisible()){this.moveToValidNode();return}this.node_.onUnfocus();this.node_=node;this.node_.onFocus();AutoScanManager.restartIfRunning()}}TestImportManager.exportForTesting(ItemScanManager);var MenuAction$2=chrome.accessibilityPrivate.SwitchAccessMenuAction;var PointScanState=chrome.accessibilityPrivate.PointScanState;class PointScanManager{point_={x:0,y:0};pointListener_;constructor(){this.pointListener_=point=>this.handleOnPointScanSet_(point)}get currentPoint(){return this.point_}start(){FocusRingManager.clearAll();SwitchAccess.mode=Mode.POINT_SCAN;chrome.accessibilityPrivate.onPointScanSet.addListener(this.pointListener_);chrome.accessibilityPrivate.setPointScanState(PointScanState.START)}stop(){chrome.accessibilityPrivate.setPointScanState(PointScanState.STOP)}performMouseAction(action){if(SwitchAccess.mode!==Mode.POINT_SCAN){return}if(action!==MenuAction$2.LEFT_CLICK&&action!==MenuAction$2.RIGHT_CLICK){return}const params={};if(action===MenuAction$2.RIGHT_CLICK){params.mouseButton=chrome.accessibilityPrivate.SyntheticMouseEventButton.RIGHT}EventGenerator.sendMouseClick(this.point_.x,this.point_.y,params);this.start()}handleOnPointScanSet_(point){this.point_=point;ActionManager.openMenu(MenuType.POINT_SCAN_MENU);chrome.accessibilityPrivate.onPointScanSet.removeListener(this.pointListener_)}}class Navigator{static itemManager_;static pointManager_;static initializeSingletonInstances(desktop){Navigator.itemManager_=new ItemScanManager(desktop);Navigator.pointManager_=new PointScanManager}static get byItem(){if(!Navigator.itemManager_){throw SwitchAccess.error(ErrorType.UNINITIALIZED,"Cannot access itemManager before Navigator.init()")}return Navigator.itemManager_}static get byPoint(){if(!Navigator.pointManager_){throw SwitchAccess.error(ErrorType.UNINITIALIZED,"Cannot access pointManager before Navigator.init()")}return Navigator.pointManager_}}TestImportManager.exportForTesting(Navigator);var EventType=chrome.automation.EventType;var MenuAction$1=chrome.accessibilityPrivate.SwitchAccessMenuAction;var RoleType=chrome.automation.RoleType;var StateType=chrome.automation.StateType;var SwitchAccessBubble=chrome.accessibilityPrivate.SwitchAccessBubble;class MenuManager{displayedActions_=null;displayedLocation_;isMenuOpen_=false;menuAutomationNode_;clickHandler_;static instance;constructor(){this.clickHandler_=new EventHandler([],EventType.CLICKED,(event=>this.onButtonClicked_(event)))}static create(){if(MenuManager.instance){throw new Error("Cannot instantiate more than one MenuManager")}MenuManager.instance=new MenuManager;return MenuManager.instance}static isMenuOpen(){return Boolean(MenuManager.instance)&&MenuManager.instance.isMenuOpen_}static get menuAutomationNode(){if(MenuManager.instance){return MenuManager.instance.menuAutomationNode_}return null}open(actions,location){if(!this.isMenuOpen_){if(!location){return}this.displayedLocation_=location}if(ArrayUtil.contentsAreEqual(actions,this.displayedActions_??undefined)){return}this.displayMenuWithActions_(actions)}close(){this.isMenuOpen_=false;this.displayedActions_=null;this.displayedLocation_=undefined;Navigator.byItem.exitIfInGroup(this.menuAutomationNode_??null);this.menuAutomationNode_=null;chrome.accessibilityPrivate.updateSwitchAccessBubble(SwitchAccessBubble.MENU,false)}asAction_(actionString){if(Object.values(MenuAction$1).includes(actionString)){return actionString}return null}displayMenuWithActions_(actions){chrome.accessibilityPrivate.updateSwitchAccessBubble(SwitchAccessBubble.MENU,true,this.displayedLocation_,actions);this.isMenuOpen_=true;this.findAndJumpToMenu_();this.displayedActions_=actions}findAndJumpToMenu_(){if(this.hasMenuNode_()&&this.menuAutomationNode_){this.jumpToMenu_(this.menuAutomationNode_);return}SwitchAccess.findNodeMatching({role:RoleType.MENU,attributes:{className:"SwitchAccessMenuView"}},(node=>this.jumpToMenu_(node)))}hasMenuNode_(){return Boolean(this.menuAutomationNode_&&this.menuAutomationNode_.role&&!this.menuAutomationNode_.state[StateType.OFFSCREEN])}jumpToMenu_(node){if(!this.isMenuOpen_){return}if(node.children.length<1||node.firstChild.state[StateType.OFFSCREEN]){new EventHandler(node,[EventType.CHILDREN_CHANGED,EventType.LOCATION_CHANGED],(()=>this.jumpToMenu_(node)),{listenOnce:true}).start();return}this.menuAutomationNode_=node;this.clickHandler_.setNodes(this.menuAutomationNode_);this.clickHandler_.start();Navigator.byItem.jumpTo(this.menuAutomationNode_)}onButtonClicked_(event){const selectedAction=this.asAction_(event.target.value);if(!this.isMenuOpen_||!selectedAction){return}ActionManager.performAction(selectedAction)}}var FocusType=chrome.accessibilityPrivate.FocusType;class FocusRingManager{observer_;rings_;ringNodesForTesting_={[RingId.PRIMARY]:null,[RingId.PREVIEW]:null};static instance_;constructor(){this.rings_=this.createRings_()}static init(){if(FocusRingManager.instance_){throw SwitchAccess.error(ErrorType.DUPLICATE_INITIALIZATION,"Cannot initialize focus ring manager twice.")}FocusRingManager.instance_=new FocusRingManager}static get instance(){if(!FocusRingManager.instance_){throw SwitchAccess.error(ErrorType.UNINITIALIZED,"FocusRingManager cannot be accessed before being initialized")}return FocusRingManager.instance_}static setColor(color){if(!COLOR_PATTERN.test(color)){console.error(SwitchAccess.error(ErrorType.INVALID_COLOR,"Problem setting focus ring color: "+color+" is not"+"a valid CSS color string."));return}FocusRingManager.instance.setColorValidated_(color)}static setFocusedNode(node){if(node.ignoreWhenComputingUnionOfBoundingBoxes()){FocusRingManager.instance.setFocusedNodeIgnorePrimary_(node);return}if(!node.location){throw SwitchAccess.error(ErrorType.MISSING_LOCATION,"Cannot set focus rings if node location is undefined",true)}if(node.isGroup()){const firstChild=node.asRootNode().firstChild;FocusRingManager.instance.setFocusedNodeGroup_(node,firstChild);return}FocusRingManager.instance.setFocusedNodeLeaf_(node)}static clearAll(){FocusRingManager.instance.clearAll_()}static setObserver(observer){FocusRingManager.instance.observer_=observer}clearAll_(){this.forEachRing_((ring=>ring.rects=[]));this.updateNodesForTesting_(null,null);this.updateFocusRings_()}createRings_(){const primaryRing={id:RingId.PRIMARY,rects:[],type:FocusType.SOLID,color:PRIMARY_COLOR,secondaryColor:OUTER_COLOR};const previewRing={id:RingId.PREVIEW,rects:[],type:FocusType.DASHED,color:PREVIEW_COLOR,secondaryColor:OUTER_COLOR};return{[RingId.PRIMARY]:primaryRing,[RingId.PREVIEW]:previewRing}}forEachRing_(callback){Object.values(this.rings_).forEach((ring=>callback(ring)))}setColorValidated_(color){this.forEachRing_((ring=>ring.color=color))}setFocusedNodeGroup_(group,firstChild){this.rings_[RingId.PREVIEW].rects=[];let focusRect=group.location;const childRect=firstChild?firstChild.location:null;if(childRect){focusRect=RectUtil.expandToFitWithPadding(GROUP_BUFFER,focusRect,childRect);this.rings_[RingId.PREVIEW].rects=[childRect]}this.rings_[RingId.PRIMARY].rects=[focusRect];this.updateNodesForTesting_(group,firstChild);this.updateFocusRings_()}setFocusedNodeIgnorePrimary_(node){this.rings_[RingId.PRIMARY].rects=[];this.rings_[RingId.PREVIEW].rects=[];this.updateFocusRings_();if(!MenuManager.isMenuOpen()){this.rings_[RingId.PREVIEW].rects=[node.group.location]}this.updateNodesForTesting_(node,node.group);this.updateFocusRings_()}setFocusedNodeLeaf_(node){this.rings_[RingId.PRIMARY].rects=[node.location];this.rings_[RingId.PREVIEW].rects=[];this.updateNodesForTesting_(node,null);this.updateFocusRings_()}updateFocusRings_(){if(SwitchAccess.mode===Mode.POINT_SCAN&&!MenuManager.isMenuOpen()){return}const focusRings=Object.values(this.rings_);chrome.accessibilityPrivate.setFocusRings(focusRings,chrome.accessibilityPrivate.AssistiveTechnologyType.SWITCH_ACCESS)}updateNodesForTesting_(primary,preview){this.ringNodesForTesting_[RingId.PRIMARY]=primary;this.ringNodesForTesting_[RingId.PREVIEW]=preview;const observer=FocusRingManager.instance.observer_;if(observer){observer(primary,preview)}}}const COLOR_PATTERN=/^#([0-9A-F]{3,4}|[0-9A-F]{6}|[0-9A-F]{8})$/i;const GROUP_BUFFER=2;var RingId;(function(RingId){RingId["PRIMARY"]="primary";RingId["PREVIEW"]="preview"})(RingId||(RingId={}));const OUTER_COLOR="#174EA6";const PREVIEW_COLOR="#8AB4F880";const PRIMARY_COLOR="#8AB4F8";TestImportManager.exportForTesting(FocusRingManager,["RingId",RingId]);var SwitchAccessMetrics;(function(SwitchAccessMetrics){function recordMenuAction(menuAction){const metricName="Accessibility.CrosSwitchAccess.MenuAction."+StringUtil.toUpperCamelCase(menuAction);chrome.metricsPrivate.recordUserAction(metricName)}SwitchAccessMetrics.recordMenuAction=recordMenuAction})(SwitchAccessMetrics||(SwitchAccessMetrics={}));var MenuAction=chrome.accessibilityPrivate.SwitchAccessMenuAction;class ActionManager{actionNode_;menuManager_;menuStack_=[];static instance;constructor(){this.menuManager_=MenuManager.create()}static init(){if(ActionManager.instance){throw SwitchAccess.error(ErrorType.DUPLICATE_INITIALIZATION,"Cannot call ActionManager.init() more than once.")}ActionManager.instance=new ActionManager}static exitAllMenus(){ActionManager.instance.menuStack_=[];ActionManager.instance.actionNode_=null;ActionManager.instance.menuManager_.close();if(SwitchAccess.mode===Mode.POINT_SCAN){Navigator.byPoint.start()}else{Navigator.byPoint.stop()}}static exitCurrentMenu(){ActionManager.instance.menuStack_.pop();if(ActionManager.instance.menuStack_.length>0){ActionManager.instance.openCurrentMenu_()}else{ActionManager.exitAllMenus()}}static onSelect(){const node=Navigator.byItem.currentNode;if(MenuManager.isMenuOpen()||node.actions.length<=1||!node.location){node.doDefaultAction();return}ActionManager.instance.menuStack_=[];ActionManager.instance.menuStack_.push(MenuType.MAIN_MENU);ActionManager.instance.actionNode_=node;ActionManager.instance.openCurrentMenu_()}static openMenu(menu){ActionManager.instance.menuStack_.push(menu);ActionManager.instance.openCurrentMenu_()}static performAction(action){SwitchAccessMetrics.recordMenuAction(action);switch(action){case MenuAction.SETTINGS:chrome.accessibilityPrivate.openSettingsSubpage("manageAccessibility/switchAccess");ActionManager.exitCurrentMenu();break;case MenuAction.POINT_SCAN:ActionManager.exitCurrentMenu();Navigator.byPoint.start();break;case MenuAction.ITEM_SCAN:Navigator.byItem.restart();ActionManager.exitAllMenus();break;case MenuAction.LEFT_CLICK:case MenuAction.RIGHT_CLICK:FocusRingManager.clearAll();ActionManager.exitCurrentMenu();Navigator.byPoint.performMouseAction(action);break;default:ActionManager.instance.performActionOnCurrentNode_(action)}}static refreshMenuUnconditionally(){if(!MenuManager.isMenuOpen()){return}ActionManager.instance.openCurrentMenu_()}static refreshMenuForNode(node){const actionNode=ActionManager.instance.actionNode_;if(actionNode&&node.equals(actionNode)){ActionManager.refreshMenuUnconditionally()}}actionsForType_(type){switch(type){case MenuType.MAIN_MENU:return[MenuAction.COPY,MenuAction.CUT,MenuAction.DECREMENT,MenuAction.DICTATION,MenuAction.DRILL_DOWN,MenuAction.INCREMENT,MenuAction.KEYBOARD,MenuAction.MOVE_CURSOR,MenuAction.PASTE,MenuAction.SCROLL_DOWN,MenuAction.SCROLL_LEFT,MenuAction.SCROLL_RIGHT,MenuAction.SCROLL_UP,MenuAction.SELECT,MenuAction.START_TEXT_SELECTION];case MenuType.TEXT_NAVIGATION:return[MenuAction.JUMP_TO_BEGINNING_OF_TEXT,MenuAction.JUMP_TO_END_OF_TEXT,MenuAction.MOVE_UP_ONE_LINE_OF_TEXT,MenuAction.MOVE_DOWN_ONE_LINE_OF_TEXT,MenuAction.MOVE_BACKWARD_ONE_WORD_OF_TEXT,MenuAction.MOVE_FORWARD_ONE_WORD_OF_TEXT,MenuAction.MOVE_BACKWARD_ONE_CHAR_OF_TEXT,MenuAction.MOVE_FORWARD_ONE_CHAR_OF_TEXT,MenuAction.END_TEXT_SELECTION];case MenuType.POINT_SCAN_MENU:return[MenuAction.LEFT_CLICK,MenuAction.RIGHT_CLICK];default:return[]}}addGlobalActions_(actions){if(SwitchAccess.mode===Mode.POINT_SCAN){actions.push(MenuAction.ITEM_SCAN)}else{actions.push(MenuAction.POINT_SCAN)}actions.push(MenuAction.SETTINGS);return actions}get currentMenuType_(){return this.menuStack_[this.menuStack_.length-1]}getActionsForCurrentMenuAndNode_(){if(this.currentMenuType_===MenuType.POINT_SCAN_MENU){let actions=this.actionsForType_(MenuType.POINT_SCAN_MENU);actions=this.addGlobalActions_(actions);return actions}if(!this.actionNode_||!this.actionNode_.isValidAndVisible()){return[]}let actions=this.actionNode_.actions;const possibleActions=this.actionsForType_(this.currentMenuType_);actions=actions.filter((a=>possibleActions.includes(a)));if(this.currentMenuType_===MenuType.MAIN_MENU){actions=this.addGlobalActions_(actions)}return actions}getLocationForCurrentMenuAndNode_(){if(this.currentMenuType_===MenuType.POINT_SCAN_MENU){return{left:Math.floor(Navigator.byPoint.currentPoint.x),top:Math.floor(Navigator.byPoint.currentPoint.y),width:1,height:1}}if(this.actionNode_){return this.actionNode_.location}return undefined}openCurrentMenu_(){const actions=this.getActionsForCurrentMenuAndNode_();const location=this.getLocationForCurrentMenuAndNode_();if(actions.length<2){ActionManager.exitCurrentMenu()}this.menuManager_.open(actions,location)}performActionOnCurrentNode_(action){if(!this.actionNode_.hasAction(action)){ActionManager.refreshMenuUnconditionally();return}Navigator.byItem.suspendCurrentGroup();const response=this.actionNode_.performAction(action);switch(response){case ActionResponse.CLOSE_MENU:ActionManager.exitAllMenus();return;case ActionResponse.EXIT_SUBMENU:ActionManager.exitCurrentMenu();return;case ActionResponse.REMAIN_OPEN:Navigator.byItem.restoreSuspendedGroup();return;case ActionResponse.RELOAD_MENU:ActionManager.refreshMenuUnconditionally();return;case ActionResponse.OPEN_TEXT_NAVIGATION_MENU:if(SwitchAccess.improvedTextInputEnabled()){this.menuStack_.push(MenuType.TEXT_NAVIGATION)}this.openCurrentMenu_()}}}ActionManager.instance;TestImportManager.exportForTesting(ActionManager);var Command=chrome.accessibilityPrivate.SwitchAccessCommand;class SACommands{static instance;commandMap_=new Map([[Command.SELECT,()=>ActionManager.onSelect()],[Command.NEXT,()=>Navigator.byItem.moveForward()],[Command.PREVIOUS,()=>Navigator.byItem.moveBackward()]]);constructor(){chrome.accessibilityPrivate.onSwitchAccessCommand.addListener((command=>this.runCommand_(command)))}static init(){if(SACommands.instance){throw SwitchAccess.error(ErrorType.DUPLICATE_INITIALIZATION,"Cannot create more than one SACommands instance.")}SACommands.instance=new SACommands}runCommand_(command){this.commandMap_.get(command)();AutoScanManager.restartIfRunning()}}TestImportManager.exportForTesting(SACommands);class SettingsManager{static async init(){await Settings.init(Object.values(Preference));Settings.addListener(Preference.AUTO_SCAN_ENABLED,(value=>AutoScanManager.setEnabled(value)));Settings.addListener(Preference.AUTO_SCAN_TIME,(value=>AutoScanManager.setPrimaryScanTime(value)));Settings.addListener(Preference.AUTO_SCAN_KEYBOARD_TIME,(value=>AutoScanManager.setKeyboardScanTime(value)));if(!SettingsManager.settingsAreConfigured_()){chrome.accessibilityPrivate.openSettingsSubpage("manageAccessibility/switchAccess")}}static settingsAreConfigured_(){const selectPref=Settings.get(Preference.SELECT_DEVICE_KEY_CODES);const selectSet=selectPref?Object.keys(selectPref).length:false;const nextPref=Settings.get(Preference.NEXT_DEVICE_KEY_CODES);const nextSet=nextPref?Object.keys(nextPref).length:false;const previousPref=Settings.get(Preference.PREVIOUS_DEVICE_KEY_CODES);const previousSet=previousPref?Object.keys(previousPref).length:false;const autoScanEnabled=Settings.get(Preference.AUTO_SCAN_ENABLED);if(!selectSet){return false}if(nextSet||previousSet){return true}return Boolean(autoScanEnabled)}}var Preference;(function(Preference){Preference["AUTO_SCAN_ENABLED"]="settings.a11y.switch_access.auto_scan.enabled";Preference["AUTO_SCAN_TIME"]="settings.a11y.switch_access.auto_scan.speed_ms";Preference["AUTO_SCAN_KEYBOARD_TIME"]="settings.a11y.switch_access.auto_scan.keyboard.speed_ms";Preference["NEXT_DEVICE_KEY_CODES"]="settings.a11y.switch_access.next.device_key_codes";Preference["PREVIOUS_DEVICE_KEY_CODES"]="settings.a11y.switch_access.previous.device_key_codes";Preference["SELECT_DEVICE_KEY_CODES"]="settings.a11y.switch_access.select.device_key_codes"})(Preference||(Preference={}));async function initAll(){await InstanceChecker.closeExtraInstances();KeepAlive.init();await Flags.init();const desktop=await AsyncUtil.getDesktop();await SwitchAccess.init(desktop);Navigator.initializeSingletonInstances(desktop);ActionManager.init();AutoScanManager.init();FocusRingManager.init();SACommands.init();SettingsManager.init();SwitchAccess.start()}initAll();