SDK.Target=class extends Protocol.TargetBase{constructor(targetManager,id,name,capabilitiesMask,connectionFactory,parentTarget){super(connectionFactory);this._targetManager=targetManager;this._name=name;this._inspectedURL='';this._capabilitiesMask=capabilitiesMask;this._parentTarget=parentTarget;this._id=id;this._modelByConstructor=new Map();}
createModels(required){this._creatingModels=true;this.model(SDK.ResourceTreeModel);var registered=Array.from(SDK.SDKModel._registeredModels.keys());for(var modelClass of registered){var info=SDK.SDKModel._registeredModels.get(modelClass);if(info.autostart||required.has(modelClass))
this.model(modelClass);}
this._creatingModels=false;}
isNodeJS(){return this._capabilitiesMask===SDK.Target.Capability.JS||this._isNodeJSForTest;}
setIsNodeJSForTest(){this._isNodeJSForTest=true;}
id(){return this._id;}
name(){return this._name||this._inspectedURLName;}
targetManager(){return this._targetManager;}
hasAllCapabilities(capabilitiesMask){return(this._capabilitiesMask&capabilitiesMask)===capabilitiesMask;}
decorateLabel(label){return!this.hasBrowserCapability()?'\u2699 '+label:label;}
hasBrowserCapability(){return this.hasAllCapabilities(SDK.Target.Capability.Browser);}
hasJSCapability(){return this.hasAllCapabilities(SDK.Target.Capability.JS);}
hasLogCapability(){return this.hasAllCapabilities(SDK.Target.Capability.Log);}
hasNetworkCapability(){return this.hasAllCapabilities(SDK.Target.Capability.Network);}
hasTargetCapability(){return this.hasAllCapabilities(SDK.Target.Capability.Target);}
hasDOMCapability(){return this.hasAllCapabilities(SDK.Target.Capability.DOM);}
parentTarget(){return this._parentTarget;}
dispose(){this._targetManager.removeTarget(this);for(var model of this._modelByConstructor.valuesArray())
model.dispose();}
model(modelClass){if(!this._modelByConstructor.get(modelClass)){var info=SDK.SDKModel._registeredModels.get(modelClass);if(info===undefined)
throw'Model class is not registered @'+new Error().stack;if((this._capabilitiesMask&info.capabilities)===info.capabilities){var model=new modelClass(this);this._modelByConstructor.set(modelClass,model);if(!this._creatingModels)
this._targetManager.modelAdded(this,modelClass,model);}}
return this._modelByConstructor.get(modelClass)||null;}
models(){return this._modelByConstructor;}
inspectedURL(){return this._inspectedURL;}
setInspectedURL(inspectedURL){this._inspectedURL=inspectedURL;var parsedURL=inspectedURL.asParsedURL();this._inspectedURLName=parsedURL?parsedURL.lastPathComponentWithFragment():'#'+this._id;if(!this.parentTarget())
InspectorFrontendHost.inspectedURLChanged(inspectedURL||'');this._targetManager.dispatchEventToListeners(SDK.TargetManager.Events.InspectedURLChanged,this);if(!this._name)
this._targetManager.dispatchEventToListeners(SDK.TargetManager.Events.NameChanged,this);}};SDK.Target.Capability={Browser:1<<0,DOM:1<<1,JS:1<<2,Log:1<<3,Network:1<<4,Target:1<<5,ScreenCapture:1<<6,Tracing:1<<7,Emulation:1<<8,Security:1<<9,Input:1<<10,Inspector:1<<11,DeviceEmulation:1<<12,None:0,AllForTests:(1<<13)-1};SDK.SDKModel=class extends Common.Object{constructor(target){super();this._target=target;}
target(){return this._target;}
suspendModel(){return Promise.resolve();}
resumeModel(){return Promise.resolve();}
dispose(){}};SDK.SDKModel.register=function(modelClass,capabilities,autostart){if(!SDK.SDKModel._registeredModels)
SDK.SDKModel._registeredModels=new Map();SDK.SDKModel._registeredModels.set(modelClass,{capabilities:capabilities,autostart:autostart});};SDK.SDKModel._registeredModels;;SDK.TargetManager=class extends Common.Object{constructor(){super();this._targets=[];this._observers=[];this._observerCapabiliesMaskSymbol=Symbol('observerCapabilitiesMask');this._modelListeners=new Map();this._modelObservers=new Map();this._isSuspended=false;this._lastAnonymousTargetId=0;this._childTargetManagers=new Map();this._nodeTargetIds=new Set();this._mainConnection;this._webSocketConnectionLostCallback;}
suspendAllTargets(){if(this._isSuspended)
return Promise.resolve();this._isSuspended=true;this.dispatchEventToListeners(SDK.TargetManager.Events.SuspendStateChanged);var promises=[];for(var target of this._targets){var childTargetManager=this._childTargetManagers.get(target);if(childTargetManager)
promises.push(childTargetManager.suspend());for(var model of target.models().values())
promises.push(model.suspendModel());}
return Promise.all(promises);}
resumeAllTargets(){if(!this._isSuspended)
return Promise.resolve();this._isSuspended=false;this.dispatchEventToListeners(SDK.TargetManager.Events.SuspendStateChanged);var promises=[];for(var target of this._targets){var childTargetManager=this._childTargetManagers.get(target);if(childTargetManager)
promises.push(childTargetManager.resume());for(var model of target.models().values())
promises.push(model.resumeModel());}
return Promise.all(promises);}
allTargetsSuspended(){return this._isSuspended;}
models(modelClass){var result=[];for(var i=0;i<this._targets.length;++i){var model=this._targets[i].model(modelClass);if(model)
result.push(model);}
return result;}
inspectedURL(){return this._targets[0]?this._targets[0].inspectedURL():'';}
observeModels(modelClass,observer){if(!this._modelObservers.has(modelClass))
this._modelObservers.set(modelClass,[]);this._modelObservers.get(modelClass).push(observer);for(var model of this.models(modelClass))
observer.modelAdded(model);}
unobserveModels(modelClass,observer){if(!this._modelObservers.has(modelClass))
return;var observers=this._modelObservers.get(modelClass);observers.remove(observer);if(!observers.length)
this._modelObservers.delete(modelClass);}
modelAdded(target,modelClass,model){if(!this._modelObservers.has(modelClass))
return;for(var observer of this._modelObservers.get(modelClass).slice())
observer.modelAdded(model);}
_modelRemoved(target,modelClass,model){if(!this._modelObservers.has(modelClass))
return;for(var observer of this._modelObservers.get(modelClass).slice())
observer.modelRemoved(model);}
addModelListener(modelClass,eventType,listener,thisObject){for(var i=0;i<this._targets.length;++i){var model=this._targets[i].model(modelClass);if(model)
model.addEventListener(eventType,listener,thisObject);}
if(!this._modelListeners.has(eventType))
this._modelListeners.set(eventType,[]);this._modelListeners.get(eventType).push({modelClass:modelClass,thisObject:thisObject,listener:listener});}
removeModelListener(modelClass,eventType,listener,thisObject){if(!this._modelListeners.has(eventType))
return;for(var i=0;i<this._targets.length;++i){var model=this._targets[i].model(modelClass);if(model)
model.removeEventListener(eventType,listener,thisObject);}
var listeners=this._modelListeners.get(eventType);for(var i=0;i<listeners.length;++i){if(listeners[i].modelClass===modelClass&&listeners[i].listener===listener&&listeners[i].thisObject===thisObject)
listeners.splice(i--,1);}
if(!listeners.length)
this._modelListeners.delete(eventType);}
observeTargets(targetObserver,capabilitiesMask){if(this._observerCapabiliesMaskSymbol in targetObserver)
throw new Error('Observer can only be registered once');targetObserver[this._observerCapabiliesMaskSymbol]=capabilitiesMask||0;this.targets(capabilitiesMask).forEach(targetObserver.targetAdded.bind(targetObserver));this._observers.push(targetObserver);}
unobserveTargets(targetObserver){delete targetObserver[this._observerCapabiliesMaskSymbol];this._observers.remove(targetObserver);}
createTarget(id,name,capabilitiesMask,connectionFactory,parentTarget){var target=new SDK.Target(this,id,name,capabilitiesMask,connectionFactory,parentTarget);target.createModels(new Set(this._modelObservers.keys()));if(target.hasTargetCapability())
this._childTargetManagers.set(target,new SDK.ChildTargetManager(this,target));this._targets.push(target);var copy=this._observersForTarget(target);for(var i=0;i<copy.length;++i)
copy[i].targetAdded(target);for(var modelClass of target.models().keys())
this.modelAdded(target,modelClass,target.models().get(modelClass));for(var pair of this._modelListeners){var listeners=pair[1];for(var i=0;i<listeners.length;++i){var model=target.model(listeners[i].modelClass);if(model)
model.addEventListener((pair[0]),listeners[i].listener,listeners[i].thisObject);}}
return target;}
_observersForTarget(target){return this._observers.filter(observer=>target.hasAllCapabilities(observer[this._observerCapabiliesMaskSymbol]||0));}
removeTarget(target){if(!this._targets.includes(target))
return;var childTargetManager=this._childTargetManagers.get(target);this._childTargetManagers.delete(target);if(childTargetManager)
childTargetManager.dispose();this._targets.remove(target);for(var modelClass of target.models().keys())
this._modelRemoved(target,modelClass,target.models().get(modelClass));var copy=this._observersForTarget(target);for(var i=0;i<copy.length;++i)
copy[i].targetRemoved(target);for(var pair of this._modelListeners){var listeners=pair[1];for(var i=0;i<listeners.length;++i){var model=target.model(listeners[i].modelClass);if(model)
model.removeEventListener((pair[0]),listeners[i].listener,listeners[i].thisObject);}}}
targets(capabilitiesMask){if(!capabilitiesMask)
return this._targets.slice();else
return this._targets.filter(target=>target.hasAllCapabilities(capabilitiesMask||0));}
targetById(id){for(var i=0;i<this._targets.length;++i){if(this._targets[i].id()===id)
return this._targets[i];}
return null;}
mainTarget(){return this._targets[0]||null;}
connectToMainTarget(webSocketConnectionLostCallback){this._webSocketConnectionLostCallback=webSocketConnectionLostCallback;this._connectAndCreateMainTarget();}
_connectAndCreateMainTarget(){if(Runtime.queryParam('nodeFrontend')){var target=new SDK.Target(this,'main',Common.UIString('Node.js'),SDK.Target.Capability.Target,this._createMainConnection.bind(this),null);target.setInspectedURL('Node.js');this._childTargetManagers.set(target,new SDK.ChildTargetManager(this,target));Host.userMetrics.actionTaken(Host.UserMetrics.Action.ConnectToNodeJSFromFrontend);return;}
var capabilities=SDK.Target.Capability.Browser|SDK.Target.Capability.DOM|SDK.Target.Capability.JS|SDK.Target.Capability.Log|SDK.Target.Capability.Network|SDK.Target.Capability.Target|SDK.Target.Capability.ScreenCapture|SDK.Target.Capability.Tracing|SDK.Target.Capability.Emulation|SDK.Target.Capability.Security|SDK.Target.Capability.Input|SDK.Target.Capability.Inspector|SDK.Target.Capability.DeviceEmulation;if(Runtime.queryParam('isSharedWorker')){capabilities=SDK.Target.Capability.Browser|SDK.Target.Capability.Log|SDK.Target.Capability.Network|SDK.Target.Capability.Target|SDK.Target.Capability.Inspector;}else if(Runtime.queryParam('v8only')){capabilities=SDK.Target.Capability.JS;Host.userMetrics.actionTaken(Host.UserMetrics.Action.ConnectToNodeJSDirectly);}
var target=this.createTarget('main',Common.UIString('Main'),capabilities,this._createMainConnection.bind(this),null);target.runtimeAgent().runIfWaitingForDebugger();}
_createMainConnection(params){var wsParam=Runtime.queryParam('ws');var wssParam=Runtime.queryParam('wss');if(wsParam||wssParam){var ws=wsParam?`ws://${wsParam}`:`wss://${wssParam}`;this._mainConnection=new SDK.WebSocketConnection(ws,this._webSocketConnectionLostCallback,params);}else if(InspectorFrontendHost.isHostedMode()){this._mainConnection=new SDK.StubConnection(params);}else{this._mainConnection=new SDK.MainConnection(params);}
return this._mainConnection;}
availableNodeTargetsCount(){return this._nodeTargetIds.size;}
interceptMainConnection(onMessage){var params={onMessage:onMessage,onDisconnect:this._connectAndCreateMainTarget.bind(this)};return this._mainConnection.disconnect().then(this._createMainConnection.bind(this,params));}};SDK.ChildTargetManager=class{constructor(targetManager,parentTarget){this._targetManager=targetManager;this._parentTarget=parentTarget;this._targetAgent=parentTarget.targetAgent();this._childConnections=new Map();parentTarget.registerTargetDispatcher(this);this._targetAgent.invoke_setAutoAttach({autoAttach:true,waitForDebuggerOnStart:true});if(Runtime.experiments.isEnabled('autoAttachToCrossProcessSubframes'))
this._targetAgent.setAttachToFrames(true);if(!parentTarget.parentTarget()){this._targetAgent.setDiscoverTargets(true);if(Runtime.queryParam('nodeFrontend')){InspectorFrontendHost.setDevicesUpdatesEnabled(true);InspectorFrontendHost.events.addEventListener(InspectorFrontendHostAPI.Events.DevicesDiscoveryConfigChanged,this._devicesDiscoveryConfigChanged,this);}else{this._targetAgent.setRemoteLocations([{host:'localhost',port:9229}]);}}}
_devicesDiscoveryConfigChanged(event){var config=(event.data);var locations=[];for(var address of config.networkDiscoveryConfig){var parts=address.split(':');var port=parseInt(parts[1],10);if(parts[0]&&port)
locations.push({host:parts[0],port:port});}
this._targetAgent.setRemoteLocations(locations);}
suspend(){return this._targetAgent.invoke_setAutoAttach({autoAttach:true,waitForDebuggerOnStart:false});}
resume(){return this._targetAgent.invoke_setAutoAttach({autoAttach:true,waitForDebuggerOnStart:true});}
dispose(){if(Runtime.queryParam('nodeFrontend')&&!this._parentTarget.parentTarget()){InspectorFrontendHost.events.removeEventListener(InspectorFrontendHostAPI.Events.DevicesDiscoveryConfigChanged,this._devicesDiscoveryConfigChanged,this);}
for(var sessionId of this._childConnections.keys())
this.detachedFromTarget(sessionId,undefined);}
_capabilitiesForType(type){if(type==='worker')
return SDK.Target.Capability.JS|SDK.Target.Capability.Log|SDK.Target.Capability.Network;if(type==='service_worker')
return SDK.Target.Capability.Log|SDK.Target.Capability.Network|SDK.Target.Capability.Target;if(type==='iframe'){return SDK.Target.Capability.Browser|SDK.Target.Capability.DOM|SDK.Target.Capability.JS|SDK.Target.Capability.Log|SDK.Target.Capability.Network|SDK.Target.Capability.Target|SDK.Target.Capability.Tracing|SDK.Target.Capability.Emulation|SDK.Target.Capability.Input;}
if(type==='node')
return SDK.Target.Capability.JS;return 0;}
targetCreated(targetInfo){if(targetInfo.type!=='node')
return;if(Runtime.queryParam('nodeFrontend')){if(!targetInfo.attached)
this._targetAgent.attachToTarget(targetInfo.targetId);return;}
if(targetInfo.attached)
return;this._targetManager._nodeTargetIds.add(targetInfo.targetId);this._targetManager.dispatchEventToListeners(SDK.TargetManager.Events.AvailableNodeTargetsChanged);}
targetInfoChanged(targetInfo){if(targetInfo.type!=='node'||Runtime.queryParam('nodeFrontend'))
return;var availableIds=this._targetManager._nodeTargetIds;if(!availableIds.has(targetInfo.targetId)&&!targetInfo.attached){availableIds.add(targetInfo.targetId);this._targetManager.dispatchEventToListeners(SDK.TargetManager.Events.AvailableNodeTargetsChanged);}else if(availableIds.has(targetInfo.targetId)&&targetInfo.attached){availableIds.delete(targetInfo.targetId);this._targetManager.dispatchEventToListeners(SDK.TargetManager.Events.AvailableNodeTargetsChanged);}}
targetDestroyed(targetId){if(Runtime.queryParam('nodeFrontend')||!this._targetManager._nodeTargetIds.has(targetId))
return;this._targetManager._nodeTargetIds.delete(targetId);this._targetManager.dispatchEventToListeners(SDK.TargetManager.Events.AvailableNodeTargetsChanged);}
attachedToTarget(sessionId,targetInfo,waitingForDebugger){var targetName='';if(targetInfo.type==='node'){targetName=Common.UIString('Node.js: %s',targetInfo.url);}else if(targetInfo.type!=='iframe'){var parsedURL=targetInfo.url.asParsedURL();targetName=parsedURL?parsedURL.lastPathComponentWithFragment():'#'+(++this._targetManager._lastAnonymousTargetId);}
var target=this._targetManager.createTarget(targetInfo.targetId,targetName,this._capabilitiesForType(targetInfo.type),this._createChildConnection.bind(this,this._targetAgent,sessionId),this._parentTarget);if(!this._parentTarget.parentTarget()&&Runtime.queryParam('isSharedWorker')&&waitingForDebugger){var debuggerModel=target.model(SDK.DebuggerModel);if(debuggerModel)
debuggerModel.pause();}
target.runtimeAgent().runIfWaitingForDebugger();if(Runtime.queryParam('nodeFrontend'))
InspectorFrontendHost.bringToFront();}
detachedFromTarget(sessionId,childTargetId){this._childConnections.get(sessionId)._onDisconnect.call(null,'target terminated');this._childConnections.delete(sessionId);}
receivedMessageFromTarget(sessionId,message,childTargetId){var connection=this._childConnections.get(sessionId);if(connection)
connection._onMessage.call(null,message);}
_createChildConnection(agent,sessionId,params){var connection=new SDK.ChildConnection(agent,sessionId,params);this._childConnections.set(sessionId,connection);return connection;}};SDK.ChildConnection=class{constructor(agent,sessionId,params){this._agent=agent;this._sessionId=sessionId;this._onMessage=params.onMessage;this._onDisconnect=params.onDisconnect;}
sendMessage(message){this._agent.sendMessageToTarget(message,this._sessionId);}
disconnect(){throw'Not implemented';}};SDK.TargetManager.Events={InspectedURLChanged:Symbol('InspectedURLChanged'),NameChanged:Symbol('NameChanged'),SuspendStateChanged:Symbol('SuspendStateChanged'),AvailableNodeTargetsChanged:Symbol('AvailableNodeTargetsChanged')};SDK.TargetManager.Observer=function(){};SDK.TargetManager.Observer.prototype={targetAdded(target){},targetRemoved(target){},};SDK.SDKModelObserver=function(){};SDK.SDKModelObserver.prototype={modelAdded(model){},modelRemoved(model){},};SDK.targetManager=new SDK.TargetManager();;SDK.MainConnection=class{constructor(params){this._onMessage=params.onMessage;this._onDisconnect=params.onDisconnect;this._disconnected=false;this._eventListeners=[InspectorFrontendHost.events.addEventListener(InspectorFrontendHostAPI.Events.DispatchMessage,this._dispatchMessage,this),InspectorFrontendHost.events.addEventListener(InspectorFrontendHostAPI.Events.DispatchMessageChunk,this._dispatchMessageChunk,this),InspectorFrontendHost.events.addEventListener(InspectorFrontendHostAPI.Events.EvaluateForTestInFrontend,this._evaluateForTestInFrontend,this),];}
sendMessage(message){if(!this._disconnected)
InspectorFrontendHost.sendMessageToBackend(message);}
_dispatchMessage(event){this._onMessage.call(null,(event.data));}
_dispatchMessageChunk(event){var messageChunk=(event.data['messageChunk']);var messageSize=(event.data['messageSize']);if(messageSize){this._messageBuffer='';this._messageSize=messageSize;}
this._messageBuffer+=messageChunk;if(this._messageBuffer.length===this._messageSize){this._onMessage.call(null,this._messageBuffer);this._messageBuffer='';this._messageSize=0;}}
_evaluateForTestInFrontend(event){if(!Host.isUnderTest())
return;var callId=(event.data['callId']);var script=(event.data['script']);function invokeMethod(){try{script=script+'//# sourceURL=evaluateInWebInspector'+callId+'.js';window.eval(script);}catch(e){console.error(e.stack);}}
Protocol.InspectorBackend.deprecatedRunAfterPendingDispatches(invokeMethod);}
disconnect(){var onDisconnect=this._onDisconnect;Common.EventTarget.removeEventListeners(this._eventListeners);this._onDisconnect=null;this._onMessage=null;this._disconnected=true;var fulfill;var promise=new Promise(f=>fulfill=f);InspectorFrontendHost.reattach(()=>{onDisconnect.call(null,'force disconnect');fulfill();});return promise;}};SDK.WebSocketConnection=class{constructor(url,onWebSocketDisconnect,params){this._socket=new WebSocket(url);this._socket.onerror=this._onError.bind(this);this._socket.onopen=this._onOpen.bind(this);this._socket.onmessage=messageEvent=>params.onMessage.call(null,(messageEvent.data));this._socket.onclose=this._onClose.bind(this);this._onDisconnect=params.onDisconnect;this._onWebSocketDisconnect=onWebSocketDisconnect;this._connected=false;this._messages=[];}
_onError(){this._onWebSocketDisconnect.call(null);this._onDisconnect.call(null,'connection failed');this._close();}
_onOpen(){this._socket.onerror=console.error;this._connected=true;for(var message of this._messages)
this._socket.send(message);this._messages=[];}
_onClose(){this._onWebSocketDisconnect.call(null);this._onDisconnect.call(null,'websocket closed');this._close();}
_close(callback){this._socket.onerror=null;this._socket.onopen=null;this._socket.onclose=callback||null;this._socket.onmessage=null;this._socket.close();this._socket=null;this._onWebSocketDisconnect=null;}
sendMessage(message){if(this._connected)
this._socket.send(message);else
this._messages.push(message);}
disconnect(){var fulfill;var promise=new Promise(f=>fulfill=f);this._close(()=>{this._onDisconnect.call(null,'force disconnect');fulfill();});return promise;}};SDK.StubConnection=class{constructor(params){this._onMessage=params.onMessage;this._onDisconnect=params.onDisconnect;}
sendMessage(message){setTimeout(this._respondWithError.bind(this,message),0);}
_respondWithError(message){var messageObject=JSON.parse(message);var error={message:'This is a stub connection, can\'t dispatch message.',code:Protocol.InspectorBackend.DevToolsStubErrorCode,data:messageObject};this._onMessage.call(null,{id:messageObject.id,error:error});}
disconnect(){this._onDisconnect.call(null,'force disconnect');this._onDisconnect=null;this._onMessage=null;return Promise.resolve();}};;SDK.CompilerSourceMappingContentProvider=class{constructor(sourceURL,contentType){this._sourceURL=sourceURL;this._contentType=contentType;}
contentURL(){return this._sourceURL;}
contentType(){return this._contentType;}
requestContent(){var callback;var promise=new Promise(fulfill=>callback=fulfill);SDK.multitargetNetworkManager.loadResource(this._sourceURL,contentLoaded.bind(this));return promise;function contentLoaded(statusCode,headers,content){if(statusCode>=400){console.error('Could not load content for '+this._sourceURL+' : '+'HTTP status code: '+statusCode);callback(null);return;}
callback(content);}}
async searchInContent(query,caseSensitive,isRegex){var content=await this.requestContent();if(typeof content!=='string')
return[];return Common.ContentProvider.performSearchInContent(content,query,caseSensitive,isRegex);}};;SDK.CookieModel=class extends SDK.SDKModel{constructor(target){super(target);}
static _parseProtocolCookie(protocolCookie){var cookie=new SDK.Cookie(protocolCookie.name,protocolCookie.value,null);cookie.addAttribute('domain',protocolCookie['domain']);cookie.addAttribute('path',protocolCookie['path']);cookie.addAttribute('port',protocolCookie['port']);if(protocolCookie['expires'])
cookie.addAttribute('expires',protocolCookie['expires']*1000);if(protocolCookie['httpOnly'])
cookie.addAttribute('httpOnly');if(protocolCookie['secure'])
cookie.addAttribute('secure');if(protocolCookie['sameSite'])
cookie.addAttribute('sameSite',protocolCookie['sameSite']);cookie.setSize(protocolCookie['size']);return cookie;}
static cookieMatchesResourceURL(cookie,resourceURL){var url=resourceURL.asParsedURL();if(!url||!SDK.CookieModel.cookieDomainMatchesResourceDomain(cookie.domain(),url.host))
return false;return(url.path.startsWith(cookie.path())&&(!cookie.port()||url.port===cookie.port())&&(!cookie.secure()||url.scheme==='https'));}
static cookieDomainMatchesResourceDomain(cookieDomain,resourceDomain){if(cookieDomain.charAt(0)!=='.')
return resourceDomain===cookieDomain;return!!resourceDomain.match(new RegExp('^([^\\.]+\\.)*'+cookieDomain.substring(1).escapeForRegExp()+'$','i'));}
getCookies(urls){return this.target().networkAgent().getCookies(urls).then(cookies=>(cookies||[]).map(cookie=>SDK.CookieModel._parseProtocolCookie(cookie)));}
deleteCookie(cookie,callback){this._deleteAll([cookie],callback);}
clear(domain,callback){this.getCookiesForDomain(domain||null).then(cookies=>this._deleteAll(cookies,callback));}
saveCookie(cookie){var domain=cookie.domain();if(!domain.startsWith('.'))
domain='';var expires=undefined;if(cookie.expires())
expires=Math.floor(Date.parse(cookie.expires())/1000);return this.target().networkAgent().setCookie(cookie.name(),cookie.value(),cookie.url(),domain,cookie.path(),cookie.secure(),cookie.httpOnly(),cookie.sameSite(),expires).then(success=>!!success);}
getCookiesForDomain(domain){var resourceURLs=[];function populateResourceURLs(resource){var url=resource.documentURL.asParsedURL();if(url&&(!domain||url.securityOrigin()===domain))
resourceURLs.push(resource.url);}
var resourceTreeModel=this.target().model(SDK.ResourceTreeModel);if(resourceTreeModel)
resourceTreeModel.forAllResources(populateResourceURLs);return this.getCookies(resourceURLs);}
_deleteAll(cookies,callback){var networkAgent=this.target().networkAgent();Promise.all(cookies.map(cookie=>networkAgent.deleteCookies(cookie.name(),undefined,cookie.domain(),cookie.path()))).then(callback||function(){});}};SDK.SDKModel.register(SDK.CookieModel,SDK.Target.Capability.Network,false);;SDK.CookieParser=class{constructor(){}
static parseCookie(header){return(new SDK.CookieParser()).parseCookie(header);}
static parseSetCookie(header){return(new SDK.CookieParser()).parseSetCookie(header);}
cookies(){return this._cookies;}
parseCookie(cookieHeader){if(!this._initialize(cookieHeader))
return null;for(var kv=this._extractKeyValue();kv;kv=this._extractKeyValue()){if(kv.key.charAt(0)==='$'&&this._lastCookie)
this._lastCookie.addAttribute(kv.key.slice(1),kv.value);else if(kv.key.toLowerCase()!=='$version'&&typeof kv.value==='string')
this._addCookie(kv,SDK.Cookie.Type.Request);this._advanceAndCheckCookieDelimiter();}
this._flushCookie();return this._cookies;}
parseSetCookie(setCookieHeader){if(!this._initialize(setCookieHeader))
return null;for(var kv=this._extractKeyValue();kv;kv=this._extractKeyValue()){if(this._lastCookie)
this._lastCookie.addAttribute(kv.key,kv.value);else
this._addCookie(kv,SDK.Cookie.Type.Response);if(this._advanceAndCheckCookieDelimiter())
this._flushCookie();}
this._flushCookie();return this._cookies;}
_initialize(headerValue){this._input=headerValue;if(typeof headerValue!=='string')
return false;this._cookies=[];this._lastCookie=null;this._originalInputLength=this._input.length;return true;}
_flushCookie(){if(this._lastCookie)
this._lastCookie.setSize(this._originalInputLength-this._input.length-this._lastCookiePosition);this._lastCookie=null;}
_extractKeyValue(){if(!this._input||!this._input.length)
return null;var keyValueMatch=/^[ \t]*([^\s=;]+)[ \t]*(?:=[ \t]*([^;\n]*))?/.exec(this._input);if(!keyValueMatch){console.error('Failed parsing cookie header before: '+this._input);return null;}
var result=new SDK.CookieParser.KeyValue(keyValueMatch[1],keyValueMatch[2]&&keyValueMatch[2].trim(),this._originalInputLength-this._input.length);this._input=this._input.slice(keyValueMatch[0].length);return result;}
_advanceAndCheckCookieDelimiter(){var match=/^\s*[\n;]\s*/.exec(this._input);if(!match)
return false;this._input=this._input.slice(match[0].length);return match[0].match('\n')!==null;}
_addCookie(keyValue,type){if(this._lastCookie)
this._lastCookie.setSize(keyValue.position-this._lastCookiePosition);this._lastCookie=typeof keyValue.value==='string'?new SDK.Cookie(keyValue.key,keyValue.value,type):new SDK.Cookie('',keyValue.key,type);this._lastCookiePosition=keyValue.position;this._cookies.push(this._lastCookie);}};SDK.CookieParser.KeyValue=class{constructor(key,value,position){this.key=key;this.value=value;this.position=position;}};SDK.Cookie=class{constructor(name,value,type){this._name=name;this._value=value;this._type=type;this._attributes={};this._size=0;}
name(){return this._name;}
value(){return this._value;}
type(){return this._type;}
httpOnly(){return'httponly'in this._attributes;}
secure(){return'secure'in this._attributes;}
sameSite(){return(this._attributes['samesite']);}
session(){return!('expires'in this._attributes||'max-age'in this._attributes);}
path(){return this._attributes['path'];}
port(){return this._attributes['port'];}
domain(){return this._attributes['domain'];}
expires(){return this._attributes['expires'];}
maxAge(){return this._attributes['max-age'];}
size(){return this._size;}
url(){return(this.secure()?'https://':'http://')+this.domain()+this.path();}
setSize(size){this._size=size;}
expiresDate(requestDate){if(this.maxAge()){var targetDate=requestDate===null?new Date():requestDate;return new Date(targetDate.getTime()+1000*this.maxAge());}
if(this.expires())
return new Date(this.expires());return null;}
attributes(){return this._attributes;}
addAttribute(key,value){this._attributes[key.toLowerCase()]=value;}};SDK.Cookie.Type={Request:0,Response:1};;SDK.ProfileNode=class{constructor(callFrame){this.callFrame=callFrame;this.callUID=`${this.callFrame.functionName}@${this.callFrame.scriptId}:${this.callFrame.lineNumber}`;this.self=0;this.total=0;this.id=0;this.parent=null;this.children=[];}
get functionName(){return this.callFrame.functionName;}
get scriptId(){return this.callFrame.scriptId;}
get url(){return this.callFrame.url;}
get lineNumber(){return this.callFrame.lineNumber;}
get columnNumber(){return this.callFrame.columnNumber;}};SDK.ProfileTreeModel=class{initialize(root){this.root=root;this._assignDepthsAndParents();this.total=this._calculateTotals(this.root);}
_assignDepthsAndParents(){var root=this.root;root.depth=-1;root.parent=null;this.maxDepth=0;var nodesToTraverse=[root];while(nodesToTraverse.length){var parent=nodesToTraverse.pop();var depth=parent.depth+1;if(depth>this.maxDepth)
this.maxDepth=depth;var children=parent.children;var length=children.length;for(var i=0;i<length;++i){var child=children[i];child.depth=depth;child.parent=parent;if(child.children.length)
nodesToTraverse.push(child);}}}
_calculateTotals(root){var nodesToTraverse=[root];var dfsList=[];while(nodesToTraverse.length){var node=nodesToTraverse.pop();node.total=node.self;dfsList.push(node);nodesToTraverse.push(...node.children);}
while(dfsList.length>1){var node=dfsList.pop();node.parent.total+=node.total;}
return root.total;}};;SDK.ServerTiming=class{constructor(metric,value,description){this.metric=metric;this.value=value;this.description=description;}
static parseHeaders(headers){var rawServerTimingHeaders=headers.filter(item=>item.name.toLowerCase()==='server-timing');if(!rawServerTimingHeaders.length)
return null;function createFromHeaderValue(valueString){var serverTimingMetricRegExp=/[ \t]*([\!\#\$\%\&\'\*\+\-\.\^\_\`\|\~0-9A-Za-z]+)[ \t]*(?:=[ \t]*(\d+(?:\.\d+)?))?[ \t]*(?:;[ \t]*(?:"([^"]+)"|([\!\#\$\%\&\'\*\+\-\.\^\_\`\|\~0-9A-Za-z]+)))?[ \t]*(?:,(.*))?/;var metricMatch;var result=[];while(valueString&&(metricMatch=serverTimingMetricRegExp.exec(valueString))){var metric=metricMatch[1];var value=metricMatch[2];var description=metricMatch[3]||metricMatch[4];if(value!==undefined)
value=Math.abs(parseFloat(metricMatch[2]));valueString=metricMatch[5];if(value===undefined||isNaN(value))
value=null;result.push(new SDK.ServerTiming(metric,value,description));}
return result;}
var serverTimings=rawServerTimingHeaders.reduce((memo,header)=>{var timing=createFromHeaderValue(header.value);Array.prototype.push.apply(memo,timing);return memo;},[]);serverTimings.sort((a,b)=>a.metric.toLowerCase().compareTo(b.metric.toLowerCase()));return serverTimings;}};;SDK.CPUProfileNode=class extends SDK.ProfileNode{constructor(node,sampleTime){var callFrame=node.callFrame||({functionName:node['functionName'],scriptId:node['scriptId'],url:node['url'],lineNumber:node['lineNumber']-1,columnNumber:node['columnNumber']-1});super(callFrame);this.id=node.id;this.self=node.hitCount*sampleTime;this.positionTicks=node.positionTicks;this.deoptReason=node.deoptReason&&node.deoptReason!=='no reason'?node.deoptReason:null;}};SDK.CPUProfileDataModel=class extends SDK.ProfileTreeModel{constructor(profile){super();var isLegacyFormat=!!profile['head'];if(isLegacyFormat){this.profileStartTime=profile.startTime*1000;this.profileEndTime=profile.endTime*1000;this.timestamps=profile.timestamps;this._compatibilityConversionHeadToNodes(profile);}else{this.profileStartTime=profile.startTime/1000;this.profileEndTime=profile.endTime/1000;this.timestamps=this._convertTimeDeltas(profile);}
this.samples=profile.samples;this.totalHitCount=0;this.profileHead=this._translateProfileTree(profile.nodes);this.initialize(this.profileHead);this._extractMetaNodes();if(this.samples){this._buildIdToNodeMap();this._sortSamples();this._normalizeTimestamps();}}
_compatibilityConversionHeadToNodes(profile){if(!profile.head||profile.nodes)
return;var nodes=[];convertNodesTree(profile.head);profile.nodes=nodes;delete profile.head;function convertNodesTree(node){nodes.push(node);node.children=((node.children)).map(convertNodesTree);return node.id;}}
_convertTimeDeltas(profile){if(!profile.timeDeltas)
return null;var lastTimeUsec=profile.startTime;var timestamps=new Array(profile.timeDeltas.length);for(var i=0;i<timestamps.length;++i){lastTimeUsec+=profile.timeDeltas[i];timestamps[i]=lastTimeUsec;}
return timestamps;}
_translateProfileTree(nodes){function isNativeNode(node){if(node.callFrame)
return!!node.callFrame.url&&node.callFrame.url.startsWith('native ');return!!node['url']&&node['url'].startsWith('native ');}
function buildChildrenFromParents(nodes){if(nodes[0].children)
return;nodes[0].children=[];for(var i=1;i<nodes.length;++i){var node=nodes[i];var parentNode=nodeByIdMap.get(node.parent);if(parentNode.children)
parentNode.children.push(node.id);else
parentNode.children=[node.id];}}
var nodeByIdMap=new Map();for(var i=0;i<nodes.length;++i){var node=nodes[i];nodeByIdMap.set(node.id,node);}
buildChildrenFromParents(nodes);this.totalHitCount=nodes.reduce((acc,node)=>acc+node.hitCount,0);var sampleTime=(this.profileEndTime-this.profileStartTime)/this.totalHitCount;var keepNatives=!!Common.moduleSetting('showNativeFunctionsInJSProfile').get();var root=nodes[0];var idMap=new Map([[root.id,root.id]]);var resultRoot=new SDK.CPUProfileNode(root,sampleTime);var parentNodeStack=root.children.map(()=>resultRoot);var sourceNodeStack=root.children.map(id=>nodeByIdMap.get(id));while(sourceNodeStack.length){var parentNode=parentNodeStack.pop();var sourceNode=sourceNodeStack.pop();if(!sourceNode.children)
sourceNode.children=[];var targetNode=new SDK.CPUProfileNode(sourceNode,sampleTime);if(keepNatives||!isNativeNode(sourceNode)){parentNode.children.push(targetNode);parentNode=targetNode;}else{parentNode.self+=targetNode.self;}
idMap.set(sourceNode.id,parentNode.id);parentNodeStack.push.apply(parentNodeStack,sourceNode.children.map(()=>parentNode));sourceNodeStack.push.apply(sourceNodeStack,sourceNode.children.map(id=>nodeByIdMap.get(id)));}
if(this.samples)
this.samples=this.samples.map(id=>idMap.get(id));return resultRoot;}
_sortSamples(){var timestamps=this.timestamps;if(!timestamps)
return;var samples=this.samples;var indices=timestamps.map((x,index)=>index);indices.sort((a,b)=>timestamps[a]-timestamps[b]);for(var i=0;i<timestamps.length;++i){var index=indices[i];if(index===i)
continue;var savedTimestamp=timestamps[i];var savedSample=samples[i];var currentIndex=i;while(index!==i){samples[currentIndex]=samples[index];timestamps[currentIndex]=timestamps[index];currentIndex=index;index=indices[index];indices[currentIndex]=currentIndex;}
samples[currentIndex]=savedSample;timestamps[currentIndex]=savedTimestamp;}}
_normalizeTimestamps(){var timestamps=this.timestamps;if(!timestamps){var profileStartTime=this.profileStartTime;var interval=(this.profileEndTime-profileStartTime)/this.samples.length;timestamps=new Float64Array(this.samples.length+1);for(var i=0;i<timestamps.length;++i)
timestamps[i]=profileStartTime+i*interval;this.timestamps=timestamps;return;}
for(var i=0;i<timestamps.length;++i)
timestamps[i]/=1000;var averageSample=(timestamps.peekLast()-timestamps[0])/(timestamps.length-1);this.timestamps.push(timestamps.peekLast()+averageSample);this.profileStartTime=timestamps[0];this.profileEndTime=timestamps.peekLast();}
_buildIdToNodeMap(){this._idToNode=new Map();var idToNode=this._idToNode;var stack=[this.profileHead];while(stack.length){var node=stack.pop();idToNode.set(node.id,node);stack.push.apply(stack,node.children);}}
_extractMetaNodes(){var topLevelNodes=this.profileHead.children;for(var i=0;i<topLevelNodes.length&&!(this.gcNode&&this.programNode&&this.idleNode);i++){var node=topLevelNodes[i];if(node.functionName==='(garbage collector)')
this.gcNode=node;else if(node.functionName==='(program)')
this.programNode=node;else if(node.functionName==='(idle)')
this.idleNode=node;}}
forEachFrame(openFrameCallback,closeFrameCallback,startTime,stopTime){if(!this.profileHead||!this.samples)
return;startTime=startTime||0;stopTime=stopTime||Infinity;var samples=this.samples;var timestamps=this.timestamps;var idToNode=this._idToNode;var gcNode=this.gcNode;var samplesCount=samples.length;var startIndex=timestamps.lowerBound(startTime);var stackTop=0;var stackNodes=[];var prevId=this.profileHead.id;var sampleTime=timestamps[samplesCount];var gcParentNode=null;if(!this._stackStartTimes)
this._stackStartTimes=new Float64Array(this.maxDepth+2);var stackStartTimes=this._stackStartTimes;if(!this._stackChildrenDuration)
this._stackChildrenDuration=new Float64Array(this.maxDepth+2);var stackChildrenDuration=this._stackChildrenDuration;for(var sampleIndex=startIndex;sampleIndex<samplesCount;sampleIndex++){sampleTime=timestamps[sampleIndex];if(sampleTime>=stopTime)
break;var id=samples[sampleIndex];if(id===prevId)
continue;var node=idToNode.get(id);var prevNode=idToNode.get(prevId);if(node===gcNode){gcParentNode=prevNode;openFrameCallback(gcParentNode.depth+1,gcNode,sampleTime);stackStartTimes[++stackTop]=sampleTime;stackChildrenDuration[stackTop]=0;prevId=id;continue;}
if(prevNode===gcNode){var start=stackStartTimes[stackTop];var duration=sampleTime-start;stackChildrenDuration[stackTop-1]+=duration;closeFrameCallback(gcParentNode.depth+1,gcNode,start,duration,duration-stackChildrenDuration[stackTop]);--stackTop;prevNode=gcParentNode;prevId=prevNode.id;gcParentNode=null;}
while(node.depth>prevNode.depth){stackNodes.push(node);node=node.parent;}
while(prevNode!==node){var start=stackStartTimes[stackTop];var duration=sampleTime-start;stackChildrenDuration[stackTop-1]+=duration;closeFrameCallback(prevNode.depth,(prevNode),start,duration,duration-stackChildrenDuration[stackTop]);--stackTop;if(node.depth===prevNode.depth){stackNodes.push(node);node=node.parent;}
prevNode=prevNode.parent;}
while(stackNodes.length){node=stackNodes.pop();openFrameCallback(node.depth,node,sampleTime);stackStartTimes[++stackTop]=sampleTime;stackChildrenDuration[stackTop]=0;}
prevId=id;}
if(idToNode.get(prevId)===gcNode){var start=stackStartTimes[stackTop];var duration=sampleTime-start;stackChildrenDuration[stackTop-1]+=duration;closeFrameCallback(gcParentNode.depth+1,node,start,duration,duration-stackChildrenDuration[stackTop]);--stackTop;}
for(var node=idToNode.get(prevId);node.parent;node=node.parent){var start=stackStartTimes[stackTop];var duration=sampleTime-start;stackChildrenDuration[stackTop-1]+=duration;closeFrameCallback(node.depth,(node),start,duration,duration-stackChildrenDuration[stackTop]);--stackTop;}}
nodeByIndex(index){return this._idToNode.get(this.samples[index])||null;}};;SDK.CPUProfilerModel=class extends SDK.SDKModel{constructor(target){super(target);this._isRecording=false;this._nextAnonymousConsoleProfileNumber=1;this._anonymousConsoleProfileIdToTitle=new Map();this._profilerAgent=target.profilerAgent();target.registerProfilerDispatcher(this);this._profilerAgent.enable();this._debuggerModel=(target.model(SDK.DebuggerModel));}
runtimeModel(){return this._debuggerModel.runtimeModel();}
debuggerModel(){return this._debuggerModel;}
consoleProfileStarted(id,scriptLocation,title){if(!title){title=Common.UIString('Profile %d',this._nextAnonymousConsoleProfileNumber++);this._anonymousConsoleProfileIdToTitle.set(id,title);}
this._dispatchProfileEvent(SDK.CPUProfilerModel.Events.ConsoleProfileStarted,id,scriptLocation,title);}
consoleProfileFinished(id,scriptLocation,cpuProfile,title){if(!title){title=this._anonymousConsoleProfileIdToTitle.get(id);this._anonymousConsoleProfileIdToTitle.delete(id);}
self.runtime.loadModulePromise('profiler').then(()=>{this._dispatchProfileEvent(SDK.CPUProfilerModel.Events.ConsoleProfileFinished,id,scriptLocation,title,cpuProfile);});}
_dispatchProfileEvent(eventName,id,scriptLocation,title,cpuProfile){var debuggerLocation=SDK.DebuggerModel.Location.fromPayload(this._debuggerModel,scriptLocation);var globalId=this.target().id()+'.'+id;var data=({id:globalId,scriptLocation:debuggerLocation,cpuProfile:cpuProfile,title:title,cpuProfilerModel:this});this.dispatchEventToListeners(eventName,data);}
isRecordingProfile(){return this._isRecording;}
startRecording(){this._isRecording=true;var intervalUs=Common.moduleSetting('highResolutionCpuProfiling').get()?100:1000;this._profilerAgent.setSamplingInterval(intervalUs);this._profilerAgent.start();}
stopRecording(){this._isRecording=false;return this._profilerAgent.stop();}
startPreciseCoverage(){return this._profilerAgent.startPreciseCoverage();}
takePreciseCoverage(){return this._profilerAgent.takePreciseCoverage().then(result=>result||[]);}
stopPreciseCoverage(){return this._profilerAgent.stopPreciseCoverage();}};SDK.SDKModel.register(SDK.CPUProfilerModel,SDK.Target.Capability.JS,true);SDK.CPUProfilerModel.Events={ConsoleProfileStarted:Symbol('ConsoleProfileStarted'),ConsoleProfileFinished:Symbol('ConsoleProfileFinished')};SDK.CPUProfilerModel.EventData;;SDK.CSSMatchedStyles=class{constructor(cssModel,node,inlinePayload,attributesPayload,matchedPayload,pseudoPayload,inheritedPayload,animationsPayload){this._cssModel=cssModel;this._node=node;this._nodeStyles=[];this._nodeForStyle=new Map();this._inheritedStyles=new Set();this._keyframes=[];this._matchingSelectors=new Map();function addAttributesStyle(){if(!attributesPayload)
return;var style=new SDK.CSSStyleDeclaration(cssModel,null,attributesPayload,SDK.CSSStyleDeclaration.Type.Attributes);this._nodeForStyle.set(style,this._node);this._nodeStyles.push(style);}
if(inlinePayload&&this._node.nodeType()===Node.ELEMENT_NODE){var style=new SDK.CSSStyleDeclaration(cssModel,null,inlinePayload,SDK.CSSStyleDeclaration.Type.Inline);this._nodeForStyle.set(style,this._node);this._nodeStyles.push(style);}
var addedAttributesStyle;for(var i=matchedPayload.length-1;i>=0;--i){var rule=new SDK.CSSStyleRule(cssModel,matchedPayload[i].rule);if((rule.isInjected()||rule.isUserAgent())&&!addedAttributesStyle){addedAttributesStyle=true;addAttributesStyle.call(this);}
this._nodeForStyle.set(rule.style,this._node);this._nodeStyles.push(rule.style);addMatchingSelectors.call(this,this._node,rule,matchedPayload[i].matchingSelectors);}
if(!addedAttributesStyle)
addAttributesStyle.call(this);var parentNode=this._node.parentNode;for(var i=0;parentNode&&inheritedPayload&&i<inheritedPayload.length;++i){var entryPayload=inheritedPayload[i];var inheritedInlineStyle=entryPayload.inlineStyle?new SDK.CSSStyleDeclaration(cssModel,null,entryPayload.inlineStyle,SDK.CSSStyleDeclaration.Type.Inline):null;if(inheritedInlineStyle&&this._containsInherited(inheritedInlineStyle)){this._nodeForStyle.set(inheritedInlineStyle,parentNode);this._nodeStyles.push(inheritedInlineStyle);this._inheritedStyles.add(inheritedInlineStyle);}
var inheritedMatchedCSSRules=entryPayload.matchedCSSRules||[];for(var j=inheritedMatchedCSSRules.length-1;j>=0;--j){var inheritedRule=new SDK.CSSStyleRule(cssModel,inheritedMatchedCSSRules[j].rule);addMatchingSelectors.call(this,parentNode,inheritedRule,inheritedMatchedCSSRules[j].matchingSelectors);if(!this._containsInherited(inheritedRule.style))
continue;this._nodeForStyle.set(inheritedRule.style,parentNode);this._nodeStyles.push(inheritedRule.style);this._inheritedStyles.add(inheritedRule.style);}
parentNode=parentNode.parentNode;}
this._pseudoStyles=new Map();if(pseudoPayload){for(var i=0;i<pseudoPayload.length;++i){var entryPayload=pseudoPayload[i];var pseudoElement=this._node.pseudoElements().get(entryPayload.pseudoType)||null;var pseudoStyles=[];var rules=entryPayload.matches||[];for(var j=rules.length-1;j>=0;--j){var pseudoRule=new SDK.CSSStyleRule(cssModel,rules[j].rule);pseudoStyles.push(pseudoRule.style);this._nodeForStyle.set(pseudoRule.style,pseudoElement);if(pseudoElement)
addMatchingSelectors.call(this,pseudoElement,pseudoRule,rules[j].matchingSelectors);}
this._pseudoStyles.set(entryPayload.pseudoType,pseudoStyles);}}
if(animationsPayload)
this._keyframes=animationsPayload.map(rule=>new SDK.CSSKeyframesRule(cssModel,rule));this.resetActiveProperties();function addMatchingSelectors(node,rule,matchingSelectorIndices){for(var matchingSelectorIndex of matchingSelectorIndices){var selector=rule.selectors[matchingSelectorIndex];this._setSelectorMatches(node,selector.text,true);}}}
node(){return this._node;}
cssModel(){return this._cssModel;}
hasMatchingSelectors(rule){var matchingSelectors=this.matchingSelectors(rule);return matchingSelectors.length>0&&this.mediaMatches(rule.style);}
matchingSelectors(rule){var node=this.nodeForStyle(rule.style);if(!node)
return[];var map=this._matchingSelectors.get(node.id);if(!map)
return[];var result=[];for(var i=0;i<rule.selectors.length;++i){if(map.get(rule.selectors[i].text))
result.push(i);}
return result;}
recomputeMatchingSelectors(rule){var node=this.nodeForStyle(rule.style);if(!node)
return Promise.resolve();var promises=[];for(var selector of rule.selectors)
promises.push(querySelector.call(this,node,selector.text));return Promise.all(promises);async function querySelector(node,selectorText){var ownerDocument=node.ownerDocument||null;var map=this._matchingSelectors.get(node.id);if((map&&map.has(selectorText))||!ownerDocument)
return;var matchingNodeIds=await this._node.domModel().querySelectorAll(ownerDocument.id,selectorText);if(matchingNodeIds)
this._setSelectorMatches(node,selectorText,matchingNodeIds.indexOf(node.id)!==-1);}}
addNewRule(rule,node){this._nodeForStyle.set(rule.style,node);return this.recomputeMatchingSelectors(rule);}
_setSelectorMatches(node,selectorText,value){var map=this._matchingSelectors.get(node.id);if(!map){map=new Map();this._matchingSelectors.set(node.id,map);}
map.set(selectorText,value);}
mediaMatches(style){var media=style.parentRule?style.parentRule.media:[];for(var i=0;media&&i<media.length;++i){if(!media[i].active())
return false;}
return true;}
nodeStyles(){return this._nodeStyles;}
keyframes(){return this._keyframes;}
pseudoStyles(){return this._pseudoStyles;}
_containsInherited(style){var properties=style.allProperties();for(var i=0;i<properties.length;++i){var property=properties[i];if(property.activeInStyle()&&SDK.cssMetadata().isPropertyInherited(property.name))
return true;}
return false;}
nodeForStyle(style){return this._nodeForStyle.get(style)||null;}
cssVariables(){var cssVariables=[];for(var style of this.nodeStyles()){for(var property of style.allProperties()){if(property.name.startsWith('--'))
cssVariables.push(property.name);}}
return cssVariables;}
isInherited(style){return this._inheritedStyles.has(style);}
propertyState(property){if(this._propertiesState.size===0){this._computeActiveProperties(this._nodeStyles,this._propertiesState);for(var pseudoElementStyles of this._pseudoStyles.valuesArray())
this._computeActiveProperties(pseudoElementStyles,this._propertiesState);}
return this._propertiesState.get(property)||null;}
resetActiveProperties(){this._propertiesState=new Map();}
_computeActiveProperties(styles,result){var foundImportantProperties=new Set();var propertyToEffectiveRule=new Map();var inheritedPropertyToNode=new Map();var allUsedProperties=new Set();for(var i=0;i<styles.length;++i){var style=styles[i];var rule=style.parentRule;if(rule&&!(rule instanceof SDK.CSSStyleRule))
continue;if(rule&&!this.hasMatchingSelectors(rule))
continue;var styleActiveProperties=new Map();var allProperties=style.allProperties();for(var j=0;j<allProperties.length;++j){var property=allProperties[j];var inherited=this.isInherited(style);if(inherited&&!SDK.cssMetadata().isPropertyInherited(property.name))
continue;if(!property.activeInStyle()){result.set(property,SDK.CSSMatchedStyles.PropertyState.Overloaded);continue;}
var canonicalName=SDK.cssMetadata().canonicalPropertyName(property.name);if(foundImportantProperties.has(canonicalName)){result.set(property,SDK.CSSMatchedStyles.PropertyState.Overloaded);continue;}
if(!property.important&&allUsedProperties.has(canonicalName)){result.set(property,SDK.CSSMatchedStyles.PropertyState.Overloaded);continue;}
var isKnownProperty=propertyToEffectiveRule.has(canonicalName);var inheritedFromNode=inherited?this.nodeForStyle(style):null;if(!isKnownProperty&&inheritedFromNode&&!inheritedPropertyToNode.has(canonicalName))
inheritedPropertyToNode.set(canonicalName,inheritedFromNode);if(property.important){if(inherited&&isKnownProperty&&inheritedFromNode!==inheritedPropertyToNode.get(canonicalName)){result.set(property,SDK.CSSMatchedStyles.PropertyState.Overloaded);continue;}
foundImportantProperties.add(canonicalName);if(isKnownProperty){var overloaded=(propertyToEffectiveRule.get(canonicalName).get(canonicalName));result.set(overloaded,SDK.CSSMatchedStyles.PropertyState.Overloaded);propertyToEffectiveRule.get(canonicalName).delete(canonicalName);}}
styleActiveProperties.set(canonicalName,property);allUsedProperties.add(canonicalName);propertyToEffectiveRule.set(canonicalName,styleActiveProperties);result.set(property,SDK.CSSMatchedStyles.PropertyState.Active);}
for(var property of style.leadingProperties()){var canonicalName=SDK.cssMetadata().canonicalPropertyName(property.name);if(!styleActiveProperties.has(canonicalName))
continue;var longhands=style.longhandProperties(property.name);if(!longhands.length)
continue;var notUsed=true;for(var longhand of longhands){var longhandCanonicalName=SDK.cssMetadata().canonicalPropertyName(longhand.name);notUsed=notUsed&&!styleActiveProperties.has(longhandCanonicalName);}
if(!notUsed)
continue;styleActiveProperties.delete(canonicalName);allUsedProperties.delete(canonicalName);result.set(property,SDK.CSSMatchedStyles.PropertyState.Overloaded);}}}};SDK.CSSMatchedStyles.PropertyState={Active:'Active',Overloaded:'Overloaded'};;SDK.CSSMediaQuery=class{constructor(payload){this._active=payload.active;this._expressions=[];for(var j=0;j<payload.expressions.length;++j)
this._expressions.push(SDK.CSSMediaQueryExpression.parsePayload(payload.expressions[j]));}
static parsePayload(payload){return new SDK.CSSMediaQuery(payload);}
active(){return this._active;}
expressions(){return this._expressions;}};SDK.CSSMediaQueryExpression=class{constructor(payload){this._value=payload.value;this._unit=payload.unit;this._feature=payload.feature;this._valueRange=payload.valueRange?TextUtils.TextRange.fromObject(payload.valueRange):null;this._computedLength=payload.computedLength||null;}
static parsePayload(payload){return new SDK.CSSMediaQueryExpression(payload);}
value(){return this._value;}
unit(){return this._unit;}
feature(){return this._feature;}
valueRange(){return this._valueRange;}
computedLength(){return this._computedLength;}};SDK.CSSMedia=class{constructor(cssModel,payload){this._cssModel=cssModel;this._reinitialize(payload);}
static parsePayload(cssModel,payload){return new SDK.CSSMedia(cssModel,payload);}
static parseMediaArrayPayload(cssModel,payload){var result=[];for(var i=0;i<payload.length;++i)
result.push(SDK.CSSMedia.parsePayload(cssModel,payload[i]));return result;}
_reinitialize(payload){this.text=payload.text;this.source=payload.source;this.sourceURL=payload.sourceURL||'';this.range=payload.range?TextUtils.TextRange.fromObject(payload.range):null;this.styleSheetId=payload.styleSheetId;this.mediaList=null;if(payload.mediaList){this.mediaList=[];for(var i=0;i<payload.mediaList.length;++i)
this.mediaList.push(SDK.CSSMediaQuery.parsePayload(payload.mediaList[i]));}}
rebase(edit){if(this.styleSheetId!==edit.styleSheetId||!this.range)
return;if(edit.oldRange.equal(this.range))
this._reinitialize((edit.payload));else
this.range=this.range.rebaseAfterTextEdit(edit.oldRange,edit.newRange);}
equal(other){if(!this.styleSheetId||!this.range||!other.range)
return false;return this.styleSheetId===other.styleSheetId&&this.range.equal(other.range);}
active(){if(!this.mediaList)
return true;for(var i=0;i<this.mediaList.length;++i){if(this.mediaList[i].active())
return true;}
return false;}
lineNumberInSource(){if(!this.range)
return undefined;var header=this.header();if(!header)
return undefined;return header.lineNumberInSource(this.range.startLine);}
columnNumberInSource(){if(!this.range)
return undefined;var header=this.header();if(!header)
return undefined;return header.columnNumberInSource(this.range.startLine,this.range.startColumn);}
header(){return this.styleSheetId?this._cssModel.styleSheetHeaderForId(this.styleSheetId):null;}
rawLocation(){var header=this.header();if(!header||this.lineNumberInSource()===undefined)
return null;var lineNumber=Number(this.lineNumberInSource());return new SDK.CSSLocation(header,lineNumber,this.columnNumberInSource());}};SDK.CSSMedia.Source={LINKED_SHEET:'linkedSheet',INLINE_SHEET:'inlineSheet',MEDIA_RULE:'mediaRule',IMPORT_RULE:'importRule'};;SDK.CSSMetadata=class{constructor(properties){this._values=([]);this._longhands=new Map();this._shorthands=new Map();this._inherited=new Set();this._svgProperties=new Set();for(var i=0;i<properties.length;++i){var property=properties[i];var propertyName=property.name;if(!CSS.supports(propertyName,'initial'))
continue;this._values.push(propertyName);if(property.inherited)
this._inherited.add(propertyName);if(property.svg)
this._svgProperties.add(propertyName);var longhands=properties[i].longhands;if(longhands){this._longhands.set(propertyName,longhands);for(var j=0;j<longhands.length;++j){var longhandName=longhands[j];var shorthands=this._shorthands.get(longhandName);if(!shorthands){shorthands=[];this._shorthands.set(longhandName,shorthands);}
shorthands.push(propertyName);}}}
this._values.sort();this._valuesSet=new Set(this._values);}
allProperties(){return this._values;}
isSVGProperty(name){name=name.toLowerCase();return this._svgProperties.has(name);}
longhands(shorthand){return this._longhands.get(shorthand)||null;}
shorthands(longhand){return this._shorthands.get(longhand)||null;}
isColorAwareProperty(propertyName){return!!SDK.CSSMetadata._colorAwareProperties.has(propertyName.toLowerCase())||this.isCustomProperty(propertyName.toLowerCase());}
isLengthProperty(propertyName){propertyName=propertyName.toLowerCase();if(propertyName==='line-height')
return false;return SDK.CSSMetadata._distanceProperties.has(propertyName)||propertyName.startsWith('margin')||propertyName.startsWith('padding')||propertyName.indexOf('width')!==-1||propertyName.indexOf('height')!==-1;}
isBezierAwareProperty(propertyName){propertyName=propertyName.toLowerCase();return!!SDK.CSSMetadata._bezierAwareProperties.has(propertyName)||this.isCustomProperty(propertyName);}
isCustomProperty(propertyName){return propertyName.startsWith('--');}
canonicalPropertyName(name){name=name.toLowerCase();if(!name||name.length<9||name.charAt(0)!=='-')
return name;var match=name.match(/(?:-webkit-)(.+)/);if(!match||!this._valuesSet.has(match[1]))
return name;return match[1];}
isCSSPropertyName(propertyName){propertyName=propertyName.toLowerCase();if(propertyName.startsWith('-moz-')||propertyName.startsWith('-o-')||propertyName.startsWith('-webkit-')||propertyName.startsWith('-ms-'))
return true;return this._valuesSet.has(propertyName);}
isPropertyInherited(propertyName){propertyName=propertyName.toLowerCase();return propertyName.startsWith('--')||this._inherited.has(this.canonicalPropertyName(propertyName))||this._inherited.has(propertyName);}
propertyValues(propertyName){var acceptedKeywords=['inherit','initial','unset'];propertyName=propertyName.toLowerCase();var unprefixedName=propertyName.replace(/^-webkit-/,'');var entry=SDK.CSSMetadata._propertyDataMap[propertyName]||SDK.CSSMetadata._propertyDataMap[unprefixedName];if(entry&&entry.values)
acceptedKeywords.pushAll(entry.values);if(this.isColorAwareProperty(propertyName)){acceptedKeywords.push('currentColor');for(var color in Common.Color.Nicknames)
acceptedKeywords.push(color);}
return acceptedKeywords.sort();}
propertyUsageWeight(property){return SDK.CSSMetadata.Weight[property]||SDK.CSSMetadata.Weight[this.canonicalPropertyName(property)]||0;}};SDK.CSSMetadata.VariableRegex=/(var\(--.*?\))/g;SDK.CSSMetadata.URLRegex=/url\(\s*('.+?'|".+?"|[^)]+)\s*\)/g;SDK.cssMetadata=function(){if(!SDK.CSSMetadata._instance)
SDK.CSSMetadata._instance=new SDK.CSSMetadata(SDK.CSSMetadata._generatedProperties||[]);return SDK.CSSMetadata._instance;};SDK.CSSMetadata._distanceProperties=new Set(['background-position','border-spacing','bottom','font-size','height','left','letter-spacing','max-height','max-width','min-height','min-width','right','text-indent','top','width','word-spacing','grid-row-gap','grid-column-gap']);SDK.CSSMetadata._bezierAwareProperties=new Set(['animation','animation-timing-function','transition','transition-timing-function','-webkit-animation','-webkit-animation-timing-function','-webkit-transition','-webkit-transition-timing-function']);SDK.CSSMetadata._colorAwareProperties=new Set(['backdrop-filter','background','background-color','background-image','border','border-color','border-image','border-image-source','border-bottom','border-bottom-color','border-left','border-left-color','border-right','border-right-color','border-top','border-top-color','box-shadow','caret-color','color','column-rule','column-rule-color','fill','list-style','list-style-image','outline','outline-color','stroke','text-decoration-color','text-shadow','-webkit-border-after','-webkit-border-after-color','-webkit-border-before','-webkit-border-before-color','-webkit-border-end','-webkit-border-end-color','-webkit-border-start','-webkit-border-start-color','-webkit-box-reflect','-webkit-box-shadow','-webkit-column-rule-color','-webkit-filter','-webkit-mask','-webkit-mask-box-image','-webkit-mask-box-image-source','-webkit-mask-image','-webkit-tap-highlight-color','-webkit-text-decoration-color','-webkit-text-emphasis','-webkit-text-emphasis-color','-webkit-text-fill-color','-webkit-text-stroke','-webkit-text-stroke-color']);SDK.CSSMetadata._propertyDataMap={'table-layout':{values:['auto','fixed']},'visibility':{values:['hidden','visible','collapse']},'background-repeat':{values:['repeat','repeat-x','repeat-y','no-repeat','space','round']},'content':{values:['none','normal','close-quote','no-close-quote','no-open-quote','open-quote']},'list-style-image':{values:['none']},'clear':{values:['none','left','right','both']},'overflow-x':{values:['hidden','auto','visible','overlay','scroll']},'stroke-linejoin':{values:['round','miter','bevel']},'baseline-shift':{values:['baseline','sub','super']},'border-bottom-width':{values:['medium','thick','thin']},'margin-top-collapse':{values:['collapse','separate','discard']},'max-height':{values:['none','min-content','max-content','-webkit-fill-available','fit-content']},'box-orient':{values:['horizontal','vertical','inline-axis','block-axis'],},'font-stretch':{values:['normal','ultra-condensed','extra-condensed','condensed','semi-condensed','semi-expanded','expanded','extra-expanded','ultra-expanded']},'border-left-width':{values:['medium','thick','thin']},'box-shadow':{values:['inset','none']},'-webkit-writing-mode':{values:['horizontal-tb','vertical-rl','vertical-lr']},'writing-mode':{values:['lr','rl','tb','lr-tb','rl-tb','tb-rl','horizontal-tb','vertical-rl','vertical-lr']},'border-collapse':{values:['collapse','separate']},'page-break-inside':{values:['auto','avoid']},'border-top-width':{values:['medium','thick','thin']},'outline-style':{values:['auto','none','inset','groove','ridge','outset','dotted','dashed','solid','double']},'cursor':{values:['none','copy','auto','crosshair','default','pointer','move','vertical-text','cell','context-menu','alias','progress','no-drop','not-allowed','-webkit-zoom-in','-webkit-zoom-out','e-resize','ne-resize','nw-resize','n-resize','se-resize','sw-resize','s-resize','w-resize','ew-resize','ns-resize','nesw-resize','nwse-resize','col-resize','row-resize','text','wait','help','all-scroll','zoom-in','zoom-out','-webkit-grab','-webkit-grabbing']},'border-width':{values:['medium','thick','thin']},'border-style':{values:['none','hidden','inset','groove','ridge','outset','dotted','dashed','solid','double']},'size':{values:['auto','a3','a4','a5','b4','b5','landscape','ledger','legal','letter','portrait']},'background-size':{values:['auto','contain','cover']},'direction':{values:['ltr','rtl']},'enable-background':{values:['accumulate','new']},'float':{values:['none','left','right']},'overflow-y':{values:['hidden','auto','visible','overlay','scroll','-webkit-paged-x','-webkit-paged-y']},'margin-bottom-collapse':{values:['collapse','separate','discard']},'box-reflect':{values:['left','right','above','below']},'overflow':{values:['hidden','auto','visible','overlay','scroll','-webkit-paged-x','-webkit-paged-y']},'contain':{values:['none','strict','content','size','layout','style','paint']},'text-rendering':{values:['auto','optimizeSpeed','optimizeLegibility','geometricPrecision']},'text-align':{values:['-webkit-auto','start','end','left','right','center','justify','-webkit-left','-webkit-right','-webkit-center','-webkit-match-parent']},'list-style-position':{values:['outside','inside']},'margin-bottom':{values:['auto']},'color-interpolation':{values:['auto','sRGB','linearRGB']},'background-origin':{values:['border-box','content-box','padding-box']},'word-wrap':{values:['normal','break-word']},'font-weight':{values:['normal','bold','bolder','lighter','100','200','300','400','500','600','700','800','900']},'margin-before-collapse':{values:['collapse','separate','discard']},'text-transform':{values:['none','capitalize','uppercase','lowercase']},'border-right-style':{values:['none','hidden','inset','groove','ridge','outset','dotted','dashed','solid','double']},'border-left-style':{values:['none','hidden','inset','groove','ridge','outset','dotted','dashed','solid','double']},'-webkit-text-emphasis':{values:['circle','filled','open','dot','double-circle','triangle','sesame','none']},'font-style':{values:['italic','oblique','normal']},'speak':{values:['none','normal','spell-out','digits','literal-punctuation','no-punctuation']},'color-rendering':{values:['auto','optimizeSpeed','optimizeQuality']},'list-style-type':{values:['none','disc','circle','square','decimal','decimal-leading-zero','arabic-indic','bengali','cambodian','khmer','devanagari','gujarati','gurmukhi','kannada','lao','malayalam','mongolian','myanmar','oriya','persian','urdu','telugu','tibetan','thai','lower-roman','upper-roman','lower-greek','lower-alpha','lower-latin','upper-alpha','upper-latin','ethiopic-halehame','ethiopic-halehame-am','ethiopic-halehame-ti-er','ethiopic-halehame-ti-et','cjk-earthly-branch','cjk-heavenly-stem','hangul-consonant','hangul','korean-hangul-formal','korean-hanja-formal','korean-hanja-informal','simp-chinese-formal','simp-chinese-informal','trad-chinese-formal','trad-chinese-informal','hebrew','armenian','lower-armenian','upper-armenian','georgian','cjk-ideographic','hiragana','katakana','hiragana-iroha','katakana-iroha']},'text-combine-upright':{values:['none','all']},'-webkit-text-combine':{values:['none','horizontal']},'text-orientation':{values:['mixed','upright','sideways','sideways-right']},'outline':{values:['none','inset','groove','ridge','outset','dotted','dashed','solid','double','medium','auto','thick','thin']},'font':{values:['caption','icon','menu','message-box','small-caption','-webkit-mini-control','-webkit-small-control','-webkit-control','status-bar','italic','oblique','small-caps','normal','bold','bolder','lighter','100','200','300','400','500','600','700','800','900','xx-small','x-small','small','medium','large','x-large','xx-large','-webkit-xxx-large','smaller','larger','serif','sans-serif','cursive','fantasy','monospace','-webkit-body','-webkit-pictograph']},'dominant-baseline':{values:['middle','auto','central','text-before-edge','text-after-edge','ideographic','alphabetic','hanging','mathematical','use-script','no-change','reset-size']},'display':{values:['none','inline','block','flow-root','list-item','inline-block','table','inline-table','table-row-group','table-header-group','table-footer-group','table-row','table-column-group','table-column','table-cell','table-caption','-webkit-box','-webkit-inline-box','flex','inline-flex','grid','inline-grid','contents']},'-webkit-text-emphasis-position':{values:['over','under']},'image-rendering':{values:['auto','pixelated','-webkit-optimize-contrast']},'alignment-baseline':{values:['baseline','middle','auto','before-edge','after-edge','central','text-before-edge','text-after-edge','ideographic','alphabetic','hanging','mathematical']},'outline-width':{values:['medium','thick','thin']},'box-align':{values:['baseline','center','stretch','start','end']},'border-right-width':{values:['medium','thick','thin']},'border-top-style':{values:['none','hidden','inset','groove','ridge','outset','dotted','dashed','solid','double']},'line-height':{values:['normal']},'text-overflow':{values:['clip','ellipsis']},'overflow-wrap':{values:['normal','break-word']},'box-direction':{values:['normal','reverse']},'margin-after-collapse':{values:['collapse','separate','discard']},'page-break-before':{values:['left','right','auto','always','avoid']},'border-image':{values:['repeat','stretch','none','space','round']},'text-decoration':{values:['none','blink','line-through','overline','underline','wavy','double','solid','dashed','dotted']},'position':{values:['absolute','fixed','relative','static','sticky']},'font-family':{values:['serif','sans-serif','cursive','fantasy','monospace','-webkit-body','-webkit-pictograph']},'text-overflow-mode':{values:['clip','ellipsis']},'border-bottom-style':{values:['none','hidden','inset','groove','ridge','outset','dotted','dashed','solid','double']},'unicode-bidi':{values:['normal','bidi-override','embed','isolate','isolate-override','plaintext']},'clip-rule':{values:['nonzero','evenodd']},'margin-left':{values:['auto']},'margin-top':{values:['auto']},'zoom':{values:['normal']},'max-width':{values:['none','min-content','max-content','-webkit-fill-available','fit-content']},'caption-side':{values:['top','bottom']},'empty-cells':{values:['hide','show']},'pointer-events':{values:['none','all','auto','visible','visiblepainted','visiblefill','visiblestroke','painted','fill','stroke','bounding-box']},'letter-spacing':{values:['normal']},'background-clip':{values:['border-box','content-box','padding-box']},'-webkit-font-smoothing':{values:['none','auto','antialiased','subpixel-antialiased']},'border':{values:['none','hidden','inset','groove','ridge','outset','dotted','dashed','solid','double','medium','thick','thin']},'font-size':{values:['xx-small','x-small','small','medium','large','x-large','xx-large','-webkit-xxx-large','smaller','larger']},'font-variant':{values:['small-caps','normal','none','common-ligatures','no-common-ligatures','discretionary-ligatures','no-discretionary-ligatures','historical-ligatures','no-historical-ligatures','contextual','no-contextual','all-small-caps','petite-caps','all-petite-caps','unicase','titling-caps','lining-nums','oldstyle-nums','proportional-nums','tabular-nums','diagonal-fractions','stacked-fractions','ordinal','slashed-zero']},'vertical-align':{values:['baseline','middle','sub','super','text-top','text-bottom','top','bottom','-webkit-baseline-middle']},'white-space':{values:['normal','nowrap','pre','pre-line','pre-wrap']},'box-lines':{values:['single','multiple']},'page-break-after':{values:['left','right','auto','always','avoid']},'clip-path':{values:['none']},'margin':{values:['auto']},'margin-right':{values:['auto']},'word-break':{values:['normal','break-all','break-word','keep-all']},'word-spacing':{values:['normal']},'-webkit-text-emphasis-style':{values:['circle','filled','open','dot','double-circle','triangle','sesame','none']},'transform':{values:['scale','scaleX','scaleY','scale3d','rotate','rotateX','rotateY','rotateZ','rotate3d','skew','skewX','skewY','translate','translateX','translateY','translateZ','translate3d','matrix','matrix3d','perspective','none']},'image-resolution':{values:['from-image','snap']},'box-sizing':{values:['content-box','border-box']},'clip':{values:['auto']},'resize':{values:['none','both','horizontal','vertical','auto']},'align-content':{values:['normal','baseline','space-between','space-around','space-evenly','stretch','unsafe','safe','center','start','end','flex-start','flex-end','left','right']},'justify-content':{values:['normal','space-between','space-around','space-evenly','stretch','unsafe','safe','center','start','end','flex-start','flex-end','left','right','baseline']},'place-content':{values:['normal','space-between','space-around','space-evenly','stretch','unsafe','safe','center','start','end','flex-start','flex-end','left','right','baseline']},'align-items':{values:['normal','stretch','baseline','unsafe','safe','center','start','end','self-start','self-end','flex-start','flex-end','left','right']},'justify-items':{values:['normal','stretch','baseline','unsafe','safe','center','start','end','self-start','self-end','flex-start','flex-end','left','right','legacy','auto']},'place-items':{values:['auto','normal','stretch','baseline','unsafe','safe','center','start','end','self-start','self-end','flex-start','flex-end','left','right']},'align-self':{values:['auto','normal','stretch','baseline','unsafe','safe','center','start','end','self-start','self-end','flex-start','flex-end','left','right']},'justify-self':{values:['auto','normal','stretch','baseline','unsafe','safe','center','start','end','self-start','self-end','flex-start','flex-end','left','right']},'place-self':{values:['auto','normal','stretch','baseline','unsafe','safe','center','start','end','self-start','self-end','flex-start','flex-end','left','right']},'flex-direction':{values:['row','row-reverse','column','column-reverse']},'flex-wrap':{values:['nowrap','wrap','wrap-reverse']},'perspective':{values:['none']},'perspective-origin':{values:['left','center','right','top','bottom']},'transform-origin':{values:['left','center','right','top','bottom']},'transform-style':{values:['flat','preserve-3d']},'transition-timing-function':{values:['ease','linear','ease-in','ease-out','ease-in-out','step-start','step-end','steps','frames','cubic-bezier','step-middle']},'animation-timing-function':{values:['ease','linear','ease-in','ease-out','ease-in-out','step-start','step-end','steps','frames','cubic-bezier','step-middle']},'animation-direction':{values:['normal','reverse','alternate','alternate-reverse']},'animation-play-state':{values:['running','paused']},'animation-fill-mode':{values:['none','forwards','backwards','both']},'-webkit-backface-visibility':{values:['visible','hidden']},'-webkit-box-decoration-break':{values:['slice','clone']},'-webkit-column-break-after':{values:['auto','always','avoid','left','right','page','column','avoid-page','avoid-column']},'-webkit-column-break-before':{values:['auto','always','avoid','left','right','page','column','avoid-page','avoid-column']},'-webkit-column-break-inside':{values:['auto','avoid','avoid-page','avoid-column']},'-webkit-column-span':{values:['none','all']},'-webkit-column-count':{values:['auto']},'-webkit-column-gap':{values:['normal']},'filter':{values:['url','blur','brightness','contrast','drop-shadow','grayscale','hue-rotate','invert','opacity','saturate','sepia','none']},'line-break':{values:['auto','loose','normal','strict','after-white-space']},'user-select':{values:['none','text','all','auto']},'-webkit-user-modify':{values:['read-only','read-write','read-write-plaintext-only']},'text-align-last':{values:['auto','start','end','left','right','center','justify']},'-webkit-text-decoration-line':{values:['none','underline','overline','line-through','blink']},'-webkit-text-decoration-style':{values:['solid','double','dotted','dashed','wavy']},'-webkit-text-decoration-skip':{values:['none','objects','spaces','ink','edges','box-decoration']},'mix-blend-mode':{values:['normal','multiply','screen','overlay','darken','lighten','color-dodge','color-burn','hard-light','soft-light','difference','exclusion','hue','saturation','color','luminosity','unset']},'background-blend-mode':{values:['normal','multiply','screen','overlay','darken','lighten','color-dodge','color-burn','hard-light','soft-light','difference','exclusion','hue','saturation','color','luminosity','unset']},'caret-color':{values:['auto']},'grid-template-columns':{values:['none','auto','min-content','max-content']},'grid-template-rows':{values:['none','auto','min-content','max-content']},'grid-template-areas':{values:['none']},'grid-template':{values:['none']},'grid-auto-columns':{values:['auto','min-content','max-content']},'grid-auto-rows':{values:['auto','min-content','max-content']},'grid-auto-flow':{values:['row','column','dense']},'grid':{values:['none']},'grid-row-start':{values:['auto']},'grid-column-start':{values:['auto']},'grid-row-end':{values:['auto']},'grid-column-end':{values:['auto']},'grid-row':{values:['auto']},'grid-column':{values:['auto']},'grid-area':{values:['auto']},'animation-iteration-count':{values:['infinite']},'font-feature-settings':{values:['normal']},'font-kerning':{values:['none','normal','auto']},'font-size-adjust':{values:['none']},'font-variant-caps':{values:['small-caps','all-small-caps','petite-caps','all-petite-caps','unicase','titling-caps','normal']},'font-variant-ligatures':{values:['none','common-ligatures','no-common-ligatures','discretionary-ligatures','no-discretionary-ligatures','historical-ligatures','no-historical-ligatures','contextual','no-contextual','normal']},'font-variant-numeric':{values:['lining-nums','oldstyle-nums','proportional-nums','tabular-nums','diagonal-fractions','stacked-fractions','ordinal','slashed-zero','normal']},'font-variation-settings':{values:['normal']},'-webkit-locale':{values:['auto']},'backdrop-filter':{values:['none']},'backface-visibility':{values:['hidden','visible']},'background':{values:['none','repeat','repeat-x','repeat-y','no-repeat','top','bottom','left','right','center','fixed','local','scroll','space','round','border-box','content-box','padding-box']},'background-attachment':{values:['fixed','local','scroll']},'background-image':{values:['none']},'background-position':{values:['top','bottom','left','right','center']},'background-position-x':{values:['left','right','center']},'background-position-y':{values:['top','bottom','center']},'background-repeat-x':{values:['repeat','no-repeat']},'background-repeat-y':{values:['repeat','no-repeat']},'border-bottom':{values:['none','hidden','inset','groove','outset','ridge','dotted','dashed','solid','double','medium','thick','thin']},'border-image-repeat':{values:['repeat','stretch','space','round']},'border-image-source':{values:['none']},'border-image-width':{values:['auto']},'border-left':{values:['none','hidden','inset','groove','outset','ridge','dotted','dashed','solid','double','medium','thick','thin']},'border-right':{values:['none','hidden','inset','groove','outset','ridge','dotted','dashed','solid','double','medium','thick','thin']},'border-top':{values:['none','hidden','inset','groove','outset','ridge','dotted','dashed','solid','double','medium','thick','thin']},'bottom':{values:['auto']},'break-after':{values:['left','right','auto','avoid','column','avoid-page','page','recto','verso','avoid-column']},'break-before':{values:['left','right','auto','avoid','column','avoid-page','page','recto','verso','avoid-column']},'break-inside':{values:['auto','avoid','avoid-page','avoid-column']},'buffered-rendering':{values:['auto','static','dynamic']},'color-interpolation-filters':{values:['auto','srgb','linearrgb']},'column-count':{values:['auto']},'column-fill':{values:['auto','balance']},'column-gap':{values:['normal']},'column-rule':{values:['none','hidden','inset','groove','outset','ridge','dotted','dashed','solid','double','medium','thick','thin']},'column-rule-style':{values:['none','hidden','inset','groove','outset','ridge','dotted','dashed','solid','double']},'column-rule-width':{values:['medium','thick','thin']},'column-span':{values:['none','all']},'column-width':{values:['auto']},'columns':{values:['auto']},'d':{values:['none']},'fill':{values:['none']},'fill-rule':{values:['nonzero','evenodd']},'flex':{values:['none','auto']},'flex-basis':{values:['auto']},'flex-flow':{values:['nowrap','row','row-reverse','column','column-reverse','wrap','wrap-reverse']},'height':{values:['auto','-webkit-fill-available','min-content','max-content','fit-content']},'hyphens':{values:['none','manual']},'inline-size':{values:['auto','-webkit-fill-available','min-content','max-content','fit-content']},'isolation':{values:['auto','isolate']},'left':{values:['auto']},'list-style':{values:['none','outside','inside','disc','circle','square','decimal','decimal-leading-zero','arabic-indic','bengali','cambodian','khmer','devanagari','gujarati','gurmukhi','kannada','lao','malayalam','mongolian','myanmar','oriya','persian','urdu','telugu','tibetan','thai','lower-roman','upper-roman','lower-greek','lower-alpha','lower-latin','upper-alpha','upper-latin','cjk-earthly-branch','cjk-heavenly-stem','ethiopic-halehame','ethiopic-halehame-am','ethiopic-halehame-ti-er','ethiopic-halehame-ti-et','hangul','hangul-consonant','korean-hangul-formal','korean-hanja-formal','korean-hanja-informal','hebrew','armenian','lower-armenian','upper-armenian','georgian','cjk-ideographic','simp-chinese-formal','simp-chinese-informal','trad-chinese-formal','trad-chinese-informal','hiragana','katakana','hiragana-iroha','katakana-iroha']},'marker':{values:['none']},'marker-end':{values:['none']},'marker-mid':{values:['none']},'marker-start':{values:['none']},'mask':{values:['none']},'mask-source-type':{values:['auto','alpha','luminance']},'mask-type':{values:['alpha','luminance']},'max-block-size':{values:['none','-webkit-fill-available','min-content','max-content','fit-content']},'max-inline-size':{values:['none','-webkit-fill-available','min-content','max-content','fit-content']},'min-block-size':{values:['auto','-webkit-fill-available','min-content','max-content','fit-content']},'min-height':{values:['auto','-webkit-fill-available','min-content','max-content','fit-content']},'min-inline-size':{values:['auto','-webkit-fill-available','min-content','max-content','fit-content']},'min-width':{values:['auto','-webkit-fill-available','min-content','max-content','fit-content']},'object-fit':{values:['none','contain','cover','fill','scale-down']},'object-position':{values:['top','bottom','left','right','center']},'offset-anchor':{values:['top','bottom','left','right','center','auto']},'offset-path':{values:['none']},'offset-position':{values:['top','bottom','left','right','center','auto']},'offset-rotate':{values:['auto','reverse']},'overflow-anchor':{values:['none','auto','visible']},'paint-order':{values:['normal','fill','stroke','markers']},'quotes':{values:['none']},'right':{values:['auto']},'rotate':{values:['none']},'rx':{values:['auto']},'ry':{values:['auto']},'scale':{values:['none']},'scroll-behavior':{values:['auto','smooth']},'shape-outside':{values:['none','border-box','content-box','padding-box','margin-box']},'shape-rendering':{values:['auto','optimizespeed','geometricprecision','crispedges']},'stroke':{values:['none']},'stroke-dasharray':{values:['none']},'stroke-linecap':{values:['square','round','butt']},'text-anchor':{values:['middle','start','end']},'text-decoration-line':{values:['none','blink','line-through','overline','underline']},'text-decoration-skip':{values:['objects','ink']},'text-decoration-style':{values:['dotted','dashed','solid','double','wavy']},'text-justify':{values:['none','inter-word','distribute','auto']},'text-shadow':{values:['none']},'text-size-adjust':{values:['none','auto']},'text-underline-position':{values:['auto','under']},'top':{values:['auto']},'touch-action':{values:['none','auto','pan-x','pan-y','pan-left','pan-right','pan-up','pan-down','manipulation','pinch-zoom']},'transform-box':{values:['border-box','fill-box','view-box']},'translate':{values:['none']},'vector-effect':{values:['none','non-scaling-stroke']},'-webkit-app-region':{values:['drag','no-drag']},'-webkit-appearance':{values:['none','checkbox','radio','push-button','square-button','button','button-bevel','inner-spin-button','listbox','listitem','media-enter-fullscreen-button','media-exit-fullscreen-button','media-mute-button','media-play-button','media-overlay-play-button','media-toggle-closed-captions-button','media-slider','media-sliderthumb','media-volume-slider-container','media-volume-slider','media-volume-sliderthumb','media-controls-background','media-controls-fullscreen-background','media-current-time-display','media-time-remaining-display','menulist','menulist-button','menulist-text','menulist-textfield','meter','progress-bar','progress-bar-value','slider-horizontal','slider-vertical','sliderthumb-horizontal','sliderthumb-vertical','caret','searchfield','searchfield-cancel-button','textfield','textarea']},'-webkit-border-after':{values:['none','hidden','inset','groove','outset','ridge','dotted','dashed','solid','double','medium','thick','thin']},'-webkit-border-after-style':{values:['none','hidden','inset','groove','outset','ridge','dotted','dashed','solid','double']},'-webkit-border-after-width':{values:['medium','thick','thin']},'-webkit-border-before':{values:['none','hidden','inset','groove','outset','ridge','dotted','dashed','solid','double','medium','thick','thin']},'-webkit-border-before-style':{values:['none','hidden','inset','groove','outset','ridge','dotted','dashed','solid','double']},'-webkit-border-before-width':{values:['medium','thick','thin']},'-webkit-border-end':{values:['none','hidden','inset','groove','outset','ridge','dotted','dashed','solid','double','medium','thick','thin']},'-webkit-border-end-style':{values:['none','hidden','inset','groove','outset','ridge','dotted','dashed','solid','double']},'-webkit-border-end-width':{values:['medium','thick','thin']},'-webkit-border-start':{values:['none','hidden','inset','groove','outset','ridge','dotted','dashed','solid','double','medium','thick','thin']},'-webkit-border-start-style':{values:['none','hidden','inset','groove','outset','ridge','dotted','dashed','solid','double']},'-webkit-border-start-width':{values:['medium','thick','thin']},'-webkit-box-pack':{values:['center','justify','start','end']},'-webkit-highlight':{values:['none']},'-webkit-hyphenate-character':{values:['auto']},'-webkit-logical-height':{values:['auto','-webkit-fill-available','min-content','max-content','fit-content']},'-webkit-logical-width':{values:['auto','-webkit-fill-available','min-content','max-content','fit-content']},'-webkit-margin-after':{values:['auto']},'-webkit-margin-before':{values:['auto']},'-webkit-margin-collapse':{values:['collapse','separate','discard']},'-webkit-margin-end':{values:['auto']},'-webkit-margin-start':{values:['auto']},'-webkit-mask-box-image':{values:['none','repeat','stretch','space','round']},'-webkit-mask-box-image-repeat':{values:['repeat','stretch','space','round']},'-webkit-mask-box-image-source':{values:['none']},'-webkit-mask-box-image-width':{values:['auto']},'-webkit-mask-clip':{values:['text','border','border-box','content','content-box','padding','padding-box']},'-webkit-mask-composite':{values:['clear','copy','source-over','source-in','source-out','source-atop','destination-over','destination-in','destination-out','destination-atop','xor','plus-lighter']},'-webkit-mask-image':{values:['none']},'-webkit-mask-origin':{values:['border','border-box','content','content-box','padding','padding-box']},'-webkit-mask-position':{values:['top','bottom','left','right','center']},'-webkit-mask-position-x':{values:['left','right','center']},'-webkit-mask-position-y':{values:['top','bottom','center']},'-webkit-mask-repeat':{values:['repeat','repeat-x','repeat-y','no-repeat','space','round']},'-webkit-mask-size':{values:['auto','contain','cover']},'-webkit-max-logical-height':{values:['none','-webkit-fill-available','min-content','max-content','fit-content']},'-webkit-max-logical-width':{values:['none','-webkit-fill-available','min-content','max-content','fit-content']},'-webkit-min-logical-height':{values:['auto','-webkit-fill-available','min-content','max-content','fit-content']},'-webkit-min-logical-width':{values:['auto','-webkit-fill-available','min-content','max-content','fit-content']},'-webkit-perspective-origin-x':{values:['left','right','center']},'-webkit-perspective-origin-y':{values:['top','bottom','center']},'-webkit-print-color-adjust':{values:['economy','exact']},'-webkit-rtl-ordering':{values:['logical','visual']},'-webkit-ruby-position':{values:['after','before']},'-webkit-text-decorations-in-effect':{values:['none','blink','line-through','overline','underline']},'-webkit-text-security':{values:['none','disc','circle','square']},'-webkit-text-stroke':{values:['medium','thick','thin']},'-webkit-text-stroke-width':{values:['medium','thick','thin']},'-webkit-transform-origin-x':{values:['left','right','center']},'-webkit-transform-origin-y':{values:['top','bottom','center']},'-webkit-user-drag':{values:['none','auto','element']},'width':{values:['auto','-webkit-fill-available','min-content','max-content','fit-content']},'z-index':{values:['auto']}};SDK.CSSMetadata.Weight={'align-content':57,'align-items':129,'align-self':55,'animation':175,'animation-delay':114,'animation-direction':113,'animation-duration':137,'animation-fill-mode':132,'animation-iteration-count':124,'animation-name':139,'animation-play-state':104,'animation-timing-function':141,'backface-visibility':123,'background':260,'background-attachment':119,'background-clip':165,'background-color':259,'background-image':246,'background-origin':107,'background-position':237,'background-position-x':108,'background-position-y':93,'background-repeat':234,'background-size':203,'border':263,'border-bottom':233,'border-bottom-color':190,'border-bottom-left-radius':186,'border-bottom-right-radius':185,'border-bottom-style':150,'border-bottom-width':179,'border-collapse':209,'border-color':226,'border-image':89,'border-image-outset':50,'border-image-repeat':49,'border-image-slice':58,'border-image-source':32,'border-image-width':52,'border-left':221,'border-left-color':174,'border-left-style':142,'border-left-width':172,'border-radius':224,'border-right':223,'border-right-color':182,'border-right-style':130,'border-right-width':178,'border-spacing':198,'border-style':206,'border-top':231,'border-top-color':192,'border-top-left-radius':187,'border-top-right-radius':189,'border-top-style':152,'border-top-width':180,'border-width':214,'bottom':227,'box-shadow':213,'box-sizing':216,'caption-side':96,'clear':229,'clip':173,'clip-rule':5,'color':256,'content':219,'counter-increment':111,'counter-reset':110,'cursor':250,'direction':176,'display':262,'empty-cells':99,'fill':140,'fill-opacity':82,'fill-rule':22,'filter':160,'flex':133,'flex-basis':66,'flex-direction':85,'flex-flow':94,'flex-grow':112,'flex-shrink':61,'flex-wrap':68,'float':252,'font':211,'font-family':254,'font-kerning':18,'font-size':264,'font-stretch':77,'font-style':220,'font-variant':161,'font-weight':257,'height':266,'image-rendering':90,'justify-content':127,'left':248,'letter-spacing':188,'line-height':244,'list-style':215,'list-style-image':145,'list-style-position':149,'list-style-type':199,'margin':267,'margin-bottom':241,'margin-left':243,'margin-right':238,'margin-top':253,'mask':20,'max-height':205,'max-width':225,'min-height':217,'min-width':218,'object-fit':33,'opacity':251,'order':117,'orphans':146,'outline':222,'outline-color':153,'outline-offset':147,'outline-style':151,'outline-width':148,'overflow':255,'overflow-wrap':105,'overflow-x':184,'overflow-y':196,'padding':265,'padding-bottom':230,'padding-left':235,'padding-right':232,'padding-top':240,'page':8,'page-break-after':120,'page-break-before':69,'page-break-inside':121,'perspective':92,'perspective-origin':103,'pointer-events':183,'position':261,'quotes':158,'resize':168,'right':245,'shape-rendering':38,'size':64,'speak':118,'src':170,'stop-color':42,'stop-opacity':31,'stroke':98,'stroke-dasharray':36,'stroke-dashoffset':3,'stroke-linecap':30,'stroke-linejoin':21,'stroke-miterlimit':12,'stroke-opacity':34,'stroke-width':87,'table-layout':171,'tab-size':46,'text-align':260,'text-anchor':35,'text-decoration':247,'text-indent':207,'text-overflow':204,'text-rendering':155,'text-shadow':208,'text-transform':202,'top':258,'touch-action':80,'transform':181,'transform-origin':162,'transform-style':86,'transition':193,'transition-delay':134,'transition-duration':135,'transition-property':131,'transition-timing-function':122,'unicode-bidi':156,'unicode-range':136,'vertical-align':236,'visibility':242,'-webkit-appearance':191,'-webkit-backface-visibility':154,'-webkit-background-clip':164,'-webkit-background-origin':40,'-webkit-background-size':163,'-webkit-border-end':9,'-webkit-border-horizontal-spacing':81,'-webkit-border-image':75,'-webkit-border-radius':212,'-webkit-border-start':10,'-webkit-border-start-color':16,'-webkit-border-start-width':13,'-webkit-border-vertical-spacing':43,'-webkit-box-align':101,'-webkit-box-direction':51,'-webkit-box-flex':128,'-webkit-box-lines':2,'-webkit-box-ordinal-group':91,'-webkit-box-orient':144,'-webkit-box-pack':106,'-webkit-box-reflect':39,'-webkit-box-shadow':210,'-webkit-column-break-inside':60,'-webkit-column-count':84,'-webkit-column-gap':76,'-webkit-column-rule':25,'-webkit-column-rule-color':23,'-webkit-columns':44,'-webkit-column-span':29,'-webkit-column-width':47,'-webkit-filter':159,'-webkit-font-feature-settings':59,'-webkit-font-smoothing':177,'-webkit-highlight':1,'-webkit-line-break':45,'-webkit-line-clamp':126,'-webkit-margin-after':67,'-webkit-margin-before':70,'-webkit-margin-collapse':14,'-webkit-margin-end':65,'-webkit-margin-start':100,'-webkit-margin-top-collapse':78,'-webkit-mask':19,'-webkit-mask-box-image':72,'-webkit-mask-image':88,'-webkit-mask-position':54,'-webkit-mask-repeat':63,'-webkit-mask-size':79,'-webkit-padding-after':15,'-webkit-padding-before':28,'-webkit-padding-end':48,'-webkit-padding-start':73,'-webkit-print-color-adjust':83,'-webkit-rtl-ordering':7,'-webkit-tap-highlight-color':169,'-webkit-text-emphasis-color':11,'-webkit-text-fill-color':71,'-webkit-text-security':17,'-webkit-text-stroke':56,'-webkit-text-stroke-color':37,'-webkit-text-stroke-width':53,'-webkit-user-drag':95,'-webkit-user-modify':62,'-webkit-user-select':194,'-webkit-writing-mode':4,'white-space':228,'widows':115,'width':268,'will-change':74,'word-break':166,'word-spacing':157,'word-wrap':197,'writing-mode':41,'z-index':239,'zoom':200};;SDK.CSSModel=class extends SDK.SDKModel{constructor(target){super(target);this._domModel=(target.model(SDK.DOMModel));this._sourceMapManager=new SDK.SourceMapManager(target);this._agent=target.cssAgent();this._styleLoader=new SDK.CSSModel.ComputedStyleLoader(this);this._resourceTreeModel=target.model(SDK.ResourceTreeModel);if(this._resourceTreeModel){this._resourceTreeModel.addEventListener(SDK.ResourceTreeModel.Events.MainFrameNavigated,this._resetStyleSheets,this);}
target.registerCSSDispatcher(new SDK.CSSDispatcher(this));this._enable();this._styleSheetIdToHeader=new Map();this._styleSheetIdsForURL=new Map();this._originalStyleSheetText=new Map();this._sourceMapManager.setEnabled(Common.moduleSetting('cssSourceMapsEnabled').get());Common.moduleSetting('cssSourceMapsEnabled').addChangeListener(event=>this._sourceMapManager.setEnabled((event.data)));}
sourceMapManager(){return this._sourceMapManager;}
static trimSourceURL(text){var sourceURLIndex=text.lastIndexOf('/*# sourceURL=');if(sourceURLIndex===-1){sourceURLIndex=text.lastIndexOf('/*@ sourceURL=');if(sourceURLIndex===-1)
return text;}
var sourceURLLineIndex=text.lastIndexOf('\n',sourceURLIndex);if(sourceURLLineIndex===-1)
return text;var sourceURLLine=text.substr(sourceURLLineIndex+1).split('\n',1)[0];var sourceURLRegex=/[\040\t]*\/\*[#@] sourceURL=[\040\t]*([^\s]*)[\040\t]*\*\/[\040\t]*$/;if(sourceURLLine.search(sourceURLRegex)===-1)
return text;return text.substr(0,sourceURLLineIndex)+text.substr(sourceURLLineIndex+sourceURLLine.length+1);}
domModel(){return this._domModel;}
setStyleText(styleSheetId,range,text,majorChange){var original=this._innerSetStyleTexts.bind(this,[styleSheetId],[range],[text],majorChange);var header=this.styleSheetHeaderForId(styleSheetId);if(!header)
return original();var sourceMap=this._sourceMapManager.sourceMapForClient(header);if(!sourceMap)
return original();var originalAndDetach=originalAndDetachIfSuccess.bind(this,header);if(!sourceMap.editable())
return original();return(sourceMap.editCompiled([range],[text]).then(onEditingDone.bind(this)).catch(onError.bind(this,header)));function onEditingDone(editResult){if(!editResult)
return Promise.resolve(false);var edits=editResult.compiledEdits;if(!edits.length)
return onCSSPatched.call(this,editResult,true);edits.sort(TextUtils.SourceEdit.comparator);edits=edits.reverse();var styleSheetIds=[];var ranges=[];var texts=[];for(var edit of edits){styleSheetIds.push(header.id);ranges.push(edit.oldRange);texts.push(edit.newText);}
return this._innerSetStyleTexts(styleSheetIds,ranges,texts,majorChange).then(onCSSPatched.bind(this,editResult));}
function onCSSPatched(editResult,success){if(!success)
return originalAndDetach();this._sourceMapManager.applySourceMapEdit(editResult);return Promise.resolve(true);}
function onError(header,error){Common.console.error(Common.UIString('LiveSASS failed: %s',sourceMap.compiledURL()));console.error(error);this._sourceMapManager.detachSourceMap(header);return original();}
function originalAndDetachIfSuccess(header){return this._innerSetStyleTexts([styleSheetId],[range],[text],majorChange).then(detachIfSuccess.bind(this));function detachIfSuccess(success){if(success)
this._sourceMapManager.detachSourceMap(header);return success;}}}
async _innerSetStyleTexts(styleSheetIds,ranges,texts,majorChange){console.assert(styleSheetIds.length===ranges.length&&ranges.length===texts.length,'Array lengths must be equal');var edits=[];var ensureContentPromises=[];for(var i=0;i<styleSheetIds.length;++i){edits.push({styleSheetId:styleSheetIds[i],range:ranges[i].serializeToObject(),text:texts[i]});ensureContentPromises.push(this._ensureOriginalStyleSheetText(styleSheetIds[i]));}
try{await Promise.all(ensureContentPromises);var stylePayloads=await this._agent.setStyleTexts(edits);if(!stylePayloads||stylePayloads.length!==ranges.length)
return false;if(majorChange)
this._domModel.markUndoableState();for(var i=0;i<ranges.length;++i){var edit=new SDK.CSSModel.Edit(styleSheetIds[i],ranges[i],texts[i],stylePayloads[i]);this._fireStyleSheetChanged(styleSheetIds[i],edit);}
return true;}catch(e){return false;}}
async setSelectorText(styleSheetId,range,text){Host.userMetrics.actionTaken(Host.UserMetrics.Action.StyleRuleEdited);try{await this._ensureOriginalStyleSheetText(styleSheetId);var selectorPayload=await this._agent.setRuleSelector(styleSheetId,range,text);if(!selectorPayload)
return false;this._domModel.markUndoableState();var edit=new SDK.CSSModel.Edit(styleSheetId,range,text,selectorPayload);this._fireStyleSheetChanged(styleSheetId,edit);return true;}catch(e){return false;}}
async setKeyframeKey(styleSheetId,range,text){Host.userMetrics.actionTaken(Host.UserMetrics.Action.StyleRuleEdited);try{await this._ensureOriginalStyleSheetText(styleSheetId);var payload=await this._agent.setKeyframeKey(styleSheetId,range,text);if(!payload)
return false;this._domModel.markUndoableState();var edit=new SDK.CSSModel.Edit(styleSheetId,range,text,payload);this._fireStyleSheetChanged(styleSheetId,edit);return true;}catch(e){return false;}}
startCoverage(){this._agent.startRuleUsageTracking();}
takeCoverageDelta(){return this._agent.takeCoverageDelta().then(ruleUsage=>ruleUsage||[]);}
stopCoverage(){return this._agent.stopRuleUsageTracking();}
async mediaQueriesPromise(){var payload=await this._agent.getMediaQueries();return payload?SDK.CSSMedia.parseMediaArrayPayload(this,payload):[];}
isEnabled(){return this._isEnabled;}
async _enable(){await this._agent.enable();this._isEnabled=true;this.dispatchEventToListeners(SDK.CSSModel.Events.ModelWasEnabled);}
async matchedStylesPromise(nodeId){var response=await this._agent.invoke_getMatchedStylesForNode({nodeId});if(response[Protocol.Error])
return null;var node=this._domModel.nodeForId(nodeId);if(!node)
return null;return new SDK.CSSMatchedStyles(this,(node),response.inlineStyle||null,response.attributesStyle||null,response.matchedCSSRules||[],response.pseudoElements||[],response.inherited||[],response.cssKeyframesRules||[]);}
classNamesPromise(styleSheetId){return this._agent.collectClassNames(styleSheetId).then(classNames=>classNames||[]);}
computedStylePromise(nodeId){return this._styleLoader.computedStylePromise(nodeId);}
async backgroundColorsPromise(nodeId){var response=this._agent.invoke_getBackgroundColors({nodeId});if(response[Protocol.Error])
return null;return response;}
platformFontsPromise(nodeId){return this._agent.getPlatformFontsForNode(nodeId);}
allStyleSheets(){var values=this._styleSheetIdToHeader.valuesArray();function styleSheetComparator(a,b){if(a.sourceURL<b.sourceURL)
return-1;else if(a.sourceURL>b.sourceURL)
return 1;return a.startLine-b.startLine||a.startColumn-b.startColumn;}
values.sort(styleSheetComparator);return values;}
async inlineStylesPromise(nodeId){var response=await this._agent.invoke_getInlineStylesForNode({nodeId});if(response[Protocol.Error]||!response.inlineStyle)
return null;var inlineStyle=new SDK.CSSStyleDeclaration(this,null,response.inlineStyle,SDK.CSSStyleDeclaration.Type.Inline);var attributesStyle=response.attributesStyle?new SDK.CSSStyleDeclaration(this,null,response.attributesStyle,SDK.CSSStyleDeclaration.Type.Attributes):null;return new SDK.CSSModel.InlineStyleResult(inlineStyle,attributesStyle);}
forcePseudoState(node,pseudoClass,enable){var pseudoClasses=node.marker(SDK.CSSModel.PseudoStateMarker)||[];if(enable){if(pseudoClasses.indexOf(pseudoClass)>=0)
return false;pseudoClasses.push(pseudoClass);node.setMarker(SDK.CSSModel.PseudoStateMarker,pseudoClasses);}else{if(pseudoClasses.indexOf(pseudoClass)<0)
return false;pseudoClasses.remove(pseudoClass);if(pseudoClasses.length)
node.setMarker(SDK.CSSModel.PseudoStateMarker,pseudoClasses);else
node.setMarker(SDK.CSSModel.PseudoStateMarker,null);}
this._agent.forcePseudoState(node.id,pseudoClasses);this.dispatchEventToListeners(SDK.CSSModel.Events.PseudoStateForced,{node:node,pseudoClass:pseudoClass,enable:enable});return true;}
pseudoState(node){return node.marker(SDK.CSSModel.PseudoStateMarker)||[];}
async setMediaText(styleSheetId,range,newMediaText){Host.userMetrics.actionTaken(Host.UserMetrics.Action.StyleRuleEdited);try{await this._ensureOriginalStyleSheetText(styleSheetId);var mediaPayload=await this._agent.setMediaText(styleSheetId,range,newMediaText);if(!mediaPayload)
return false;this._domModel.markUndoableState();var edit=new SDK.CSSModel.Edit(styleSheetId,range,newMediaText,mediaPayload);this._fireStyleSheetChanged(styleSheetId,edit);return true;}catch(e){return false;}}
async addRule(styleSheetId,ruleText,ruleLocation){try{await this._ensureOriginalStyleSheetText(styleSheetId);var rulePayload=await this._agent.addRule(styleSheetId,ruleText,ruleLocation);if(!rulePayload)
return null;this._domModel.markUndoableState();var edit=new SDK.CSSModel.Edit(styleSheetId,ruleLocation,ruleText,rulePayload);this._fireStyleSheetChanged(styleSheetId,edit);return new SDK.CSSStyleRule(this,rulePayload);}catch(e){return null;}}
async requestViaInspectorStylesheet(node){var frameId=node.frameId()||(this._resourceTreeModel?this._resourceTreeModel.mainFrame.id:'');var headers=this._styleSheetIdToHeader.valuesArray();var styleSheetHeader=headers.find(header=>header.frameId===frameId&&header.isViaInspector());if(styleSheetHeader)
return styleSheetHeader;try{var styleSheetId=await this._agent.createStyleSheet(frameId);return styleSheetId&&this._styleSheetIdToHeader.get(styleSheetId)||null;}catch(e){return null;}}
mediaQueryResultChanged(){this.dispatchEventToListeners(SDK.CSSModel.Events.MediaQueryResultChanged);}
fontsUpdated(){this.dispatchEventToListeners(SDK.CSSModel.Events.FontsUpdated);}
styleSheetHeaderForId(id){return this._styleSheetIdToHeader.get(id)||null;}
styleSheetHeaders(){return this._styleSheetIdToHeader.valuesArray();}
_fireStyleSheetChanged(styleSheetId,edit){this.dispatchEventToListeners(SDK.CSSModel.Events.StyleSheetChanged,{styleSheetId:styleSheetId,edit:edit});}
_ensureOriginalStyleSheetText(styleSheetId){var header=this.styleSheetHeaderForId(styleSheetId);if(!header)
return Promise.resolve((null));var promise=this._originalStyleSheetText.get(header);if(!promise){promise=this.getStyleSheetText(header.id);this._originalStyleSheetText.set(header,promise);this._originalContentRequestedForTest(header);}
return promise;}
_originalContentRequestedForTest(header){}
originalStyleSheetText(header){return this._ensureOriginalStyleSheetText(header.id);}
_styleSheetAdded(header){console.assert(!this._styleSheetIdToHeader.get(header.styleSheetId));var styleSheetHeader=new SDK.CSSStyleSheetHeader(this,header);this._styleSheetIdToHeader.set(header.styleSheetId,styleSheetHeader);var url=styleSheetHeader.resourceURL();if(!this._styleSheetIdsForURL.get(url))
this._styleSheetIdsForURL.set(url,{});var frameIdToStyleSheetIds=this._styleSheetIdsForURL.get(url);var styleSheetIds=frameIdToStyleSheetIds[styleSheetHeader.frameId];if(!styleSheetIds){styleSheetIds=[];frameIdToStyleSheetIds[styleSheetHeader.frameId]=styleSheetIds;}
styleSheetIds.push(styleSheetHeader.id);this._sourceMapManager.attachSourceMap(styleSheetHeader,styleSheetHeader.sourceURL,styleSheetHeader.sourceMapURL);this.dispatchEventToListeners(SDK.CSSModel.Events.StyleSheetAdded,styleSheetHeader);}
_styleSheetRemoved(id){var header=this._styleSheetIdToHeader.get(id);console.assert(header);if(!header)
return;this._styleSheetIdToHeader.remove(id);var url=header.resourceURL();var frameIdToStyleSheetIds=(this._styleSheetIdsForURL.get(url));console.assert(frameIdToStyleSheetIds,'No frameId to styleSheetId map is available for given style sheet URL.');frameIdToStyleSheetIds[header.frameId].remove(id);if(!frameIdToStyleSheetIds[header.frameId].length){delete frameIdToStyleSheetIds[header.frameId];if(!Object.keys(frameIdToStyleSheetIds).length)
this._styleSheetIdsForURL.remove(url);}
this._originalStyleSheetText.remove(header);this._sourceMapManager.detachSourceMap(header);this.dispatchEventToListeners(SDK.CSSModel.Events.StyleSheetRemoved,header);}
styleSheetIdsForURL(url){var frameIdToStyleSheetIds=this._styleSheetIdsForURL.get(url);if(!frameIdToStyleSheetIds)
return[];var result=[];for(var frameId in frameIdToStyleSheetIds)
result=result.concat(frameIdToStyleSheetIds[frameId]);return result;}
async setStyleSheetText(styleSheetId,newText,majorChange){var header=(this._styleSheetIdToHeader.get(styleSheetId));console.assert(header);newText=SDK.CSSModel.trimSourceURL(newText);if(header.hasSourceURL)
newText+='\n/*# sourceURL='+header.sourceURL+' */';await this._ensureOriginalStyleSheetText(styleSheetId);var response=await this._agent.invoke_setStyleSheetText({styleSheetId:header.id,text:newText});var sourceMapURL=response.sourceMapURL;this._sourceMapManager.detachSourceMap(header);header.setSourceMapURL(sourceMapURL);this._sourceMapManager.attachSourceMap(header,header.sourceURL,header.sourceMapURL);if(sourceMapURL===null)
return'Error in CSS.setStyleSheetText';if(majorChange)
this._domModel.markUndoableState();this._fireStyleSheetChanged(styleSheetId);return null;}
async getStyleSheetText(styleSheetId){try{var text=await this._agent.getStyleSheetText(styleSheetId);return text&&SDK.CSSModel.trimSourceURL(text);}catch(e){return null;}}
_resetStyleSheets(){var headers=this._styleSheetIdToHeader.valuesArray();this._styleSheetIdsForURL.clear();this._styleSheetIdToHeader.clear();for(var i=0;i<headers.length;++i){this._sourceMapManager.detachSourceMap(headers[i]);this.dispatchEventToListeners(SDK.CSSModel.Events.StyleSheetRemoved,headers[i]);}}
suspendModel(){this._isEnabled=false;return this._agent.disable().then(this._resetStyleSheets.bind(this));}
async resumeModel(){return this._enable();}
setEffectivePropertyValueForNode(nodeId,name,value){this._agent.setEffectivePropertyValueForNode(nodeId,name,value);}
cachedMatchedCascadeForNode(node){if(this._cachedMatchedCascadeNode!==node)
this.discardCachedMatchedCascade();this._cachedMatchedCascadeNode=node;if(!this._cachedMatchedCascadePromise)
this._cachedMatchedCascadePromise=this.matchedStylesPromise(node.id);return this._cachedMatchedCascadePromise;}
discardCachedMatchedCascade(){delete this._cachedMatchedCascadeNode;delete this._cachedMatchedCascadePromise;}
dispose(){super.dispose();this._sourceMapManager.dispose();}};SDK.SDKModel.register(SDK.CSSModel,SDK.Target.Capability.DOM,true);SDK.CSSModel.RuleUsage;SDK.CSSModel.ContrastInfo;SDK.CSSModel.Events={FontsUpdated:Symbol('FontsUpdated'),MediaQueryResultChanged:Symbol('MediaQueryResultChanged'),ModelWasEnabled:Symbol('ModelWasEnabled'),PseudoStateForced:Symbol('PseudoStateForced'),StyleSheetAdded:Symbol('StyleSheetAdded'),StyleSheetChanged:Symbol('StyleSheetChanged'),StyleSheetRemoved:Symbol('StyleSheetRemoved')};SDK.CSSModel.MediaTypes=['all','braille','embossed','handheld','print','projection','screen','speech','tty','tv'];SDK.CSSModel.PseudoStateMarker='pseudo-state-marker';SDK.CSSModel.Edit=class{constructor(styleSheetId,oldRange,newText,payload){this.styleSheetId=styleSheetId;this.oldRange=oldRange;this.newRange=TextUtils.TextRange.fromEdit(oldRange,newText);this.payload=payload;}};SDK.CSSLocation=class{constructor(header,lineNumber,columnNumber){this._cssModel=header.cssModel();this.styleSheetId=header.id;this.url=header.resourceURL();this.lineNumber=lineNumber;this.columnNumber=columnNumber||0;}
cssModel(){return this._cssModel;}
header(){return this._cssModel.styleSheetHeaderForId(this.styleSheetId);}};SDK.CSSDispatcher=class{constructor(cssModel){this._cssModel=cssModel;}
mediaQueryResultChanged(){this._cssModel.mediaQueryResultChanged();}
fontsUpdated(){this._cssModel.fontsUpdated();}
styleSheetChanged(styleSheetId){this._cssModel._fireStyleSheetChanged(styleSheetId);}
styleSheetAdded(header){this._cssModel._styleSheetAdded(header);}
styleSheetRemoved(id){this._cssModel._styleSheetRemoved(id);}};SDK.CSSModel.ComputedStyleLoader=class{constructor(cssModel){this._cssModel=cssModel;this._nodeIdToPromise=new Map();}
computedStylePromise(nodeId){var promise=this._nodeIdToPromise.get(nodeId);if(promise)
return promise;promise=this._cssModel._agent.getComputedStyleForNode(nodeId).then(parsePayload.bind(this));this._nodeIdToPromise.set(nodeId,promise);return promise;function parsePayload(computedPayload){this._nodeIdToPromise.delete(nodeId);if(!computedPayload||!computedPayload.length)
return null;var result=new Map();for(var property of computedPayload)
result.set(property.name,property.value);return result;}}};SDK.CSSModel.InlineStyleResult=class{constructor(inlineStyle,attributesStyle){this.inlineStyle=inlineStyle;this.attributesStyle=attributesStyle;}};;SDK.CSSProperty=class{constructor(ownerStyle,index,name,value,important,disabled,parsedOk,implicit,text,range){this.ownerStyle=ownerStyle;this.index=index;this.name=name;this.value=value;this.important=important;this.disabled=disabled;this.parsedOk=parsedOk;this.implicit=implicit;this.text=text;this.range=range?TextUtils.TextRange.fromObject(range):null;this._active=true;this._nameRange=null;this._valueRange=null;}
static parsePayload(ownerStyle,index,payload){var result=new SDK.CSSProperty(ownerStyle,index,payload.name,payload.value,payload.important||false,payload.disabled||false,('parsedOk'in payload)?!!payload.parsedOk:true,!!payload.implicit,payload.text,payload.range);return result;}
_ensureRanges(){if(this._nameRange&&this._valueRange)
return;var range=this.range;var text=this.text?new TextUtils.Text(this.text):null;if(!range||!text)
return;var nameIndex=text.value().indexOf(this.name);var valueIndex=text.value().lastIndexOf(this.value);if(nameIndex===-1||valueIndex===-1||nameIndex>valueIndex)
return;var nameSourceRange=new TextUtils.SourceRange(nameIndex,this.name.length);var valueSourceRange=new TextUtils.SourceRange(valueIndex,this.value.length);this._nameRange=rebase(text.toTextRange(nameSourceRange),range.startLine,range.startColumn);this._valueRange=rebase(text.toTextRange(valueSourceRange),range.startLine,range.startColumn);function rebase(oneLineRange,lineOffset,columnOffset){if(oneLineRange.startLine===0){oneLineRange.startColumn+=columnOffset;oneLineRange.endColumn+=columnOffset;}
oneLineRange.startLine+=lineOffset;oneLineRange.endLine+=lineOffset;return oneLineRange;}}
nameRange(){this._ensureRanges();return this._nameRange;}
valueRange(){this._ensureRanges();return this._valueRange;}
rebase(edit){if(this.ownerStyle.styleSheetId!==edit.styleSheetId)
return;if(this.range)
this.range=this.range.rebaseAfterTextEdit(edit.oldRange,edit.newRange);}
setActive(active){this._active=active;}
get propertyText(){if(this.text!==undefined)
return this.text;if(this.name==='')
return'';return this.name+': '+this.value+(this.important?' !important':'')+';';}
activeInStyle(){return this._active;}
setText(propertyText,majorChange,overwrite){if(!this.ownerStyle)
return Promise.reject(new Error('No ownerStyle for property'));if(!this.ownerStyle.styleSheetId)
return Promise.reject(new Error('No owner style id'));if(!this.range||!this.ownerStyle.range)
return Promise.reject(new Error('Style not editable'));if(majorChange)
Host.userMetrics.actionTaken(Host.UserMetrics.Action.StyleRuleEdited);if(overwrite&&propertyText===this.propertyText){if(majorChange)
this.ownerStyle.cssModel().domModel().markUndoableState();return Promise.resolve(true);}
var range=this.range.relativeTo(this.ownerStyle.range.startLine,this.ownerStyle.range.startColumn);var indentation=this.ownerStyle.cssText?this._detectIndentation(this.ownerStyle.cssText):Common.moduleSetting('textEditorIndent').get();var endIndentation=this.ownerStyle.cssText?indentation.substring(0,this.ownerStyle.range.endColumn):'';var text=new TextUtils.Text(this.ownerStyle.cssText||'');var newStyleText=text.replaceRange(range,String.sprintf(';%s;',propertyText));return self.runtime.extension(TextUtils.TokenizerFactory).instance().then(this._formatStyle.bind(this,newStyleText,indentation,endIndentation)).then(setStyleText.bind(this));function setStyleText(styleText){return this.ownerStyle.setText(styleText,majorChange);}}
_formatStyle(styleText,indentation,endIndentation,tokenizerFactory){if(indentation)
indentation='\n'+indentation;var result='';var propertyText;var insideProperty=false;var tokenize=tokenizerFactory.createTokenizer('text/css');tokenize('*{'+styleText+'}',processToken);if(insideProperty)
result+=propertyText;result=result.substring(2,result.length-1).trimRight();return result+(indentation?'\n'+endIndentation:'');function processToken(token,tokenType,column,newColumn){if(!insideProperty){var disabledProperty=tokenType&&tokenType.includes('css-comment')&&isDisabledProperty(token);var isPropertyStart=tokenType&&(tokenType.includes('css-string')||tokenType.includes('css-meta')||tokenType.includes('css-property')||tokenType.includes('css-variable-2'));if(disabledProperty){result=result.trimRight()+indentation+token;}else if(isPropertyStart){insideProperty=true;propertyText=token;}else if(token!==';'){result+=token;}
return;}
if(token==='}'||token===';'){result=result.trimRight()+indentation+propertyText.trim()+';';insideProperty=false;if(token==='}')
result+='}';}else{propertyText+=token;}}
function isDisabledProperty(text){var colon=text.indexOf(':');if(colon===-1)
return false;var propertyName=text.substring(2,colon).trim();return SDK.cssMetadata().isCSSPropertyName(propertyName);}}
_detectIndentation(text){var lines=text.split('\n');if(lines.length<2)
return'';return TextUtils.TextUtils.lineIndent(lines[1]);}
setValue(newValue,majorChange,overwrite,userCallback){var text=this.name+': '+newValue+(this.important?' !important':'')+';';this.setText(text,majorChange,overwrite).then(userCallback);}
setDisabled(disabled){if(!this.ownerStyle)
return Promise.resolve(false);if(disabled===this.disabled)
return Promise.resolve(true);var propertyText=this.text.trim();var text=disabled?'/* '+propertyText+' */':this.text.substring(2,propertyText.length-2).trim();return this.setText(text,true,true);}};;SDK.CSSValue=class{constructor(payload){this.text=payload.text;if(payload.range)
this.range=TextUtils.TextRange.fromObject(payload.range);}
rebase(edit){if(!this.range)
return;this.range=this.range.rebaseAfterTextEdit(edit.oldRange,edit.newRange);}};SDK.CSSRule=class{constructor(cssModel,payload){this._cssModel=cssModel;this.styleSheetId=payload.styleSheetId;if(this.styleSheetId){var styleSheetHeader=cssModel.styleSheetHeaderForId(this.styleSheetId);this.sourceURL=styleSheetHeader.sourceURL;}
this.origin=payload.origin;this.style=new SDK.CSSStyleDeclaration(this._cssModel,this,payload.style,SDK.CSSStyleDeclaration.Type.Regular);}
rebase(edit){if(this.styleSheetId!==edit.styleSheetId)
return;this.style.rebase(edit);}
resourceURL(){if(!this.styleSheetId)
return'';var styleSheetHeader=this._cssModel.styleSheetHeaderForId(this.styleSheetId);return styleSheetHeader.resourceURL();}
isUserAgent(){return this.origin===Protocol.CSS.StyleSheetOrigin.UserAgent;}
isInjected(){return this.origin===Protocol.CSS.StyleSheetOrigin.Injected;}
isViaInspector(){return this.origin===Protocol.CSS.StyleSheetOrigin.Inspector;}
isRegular(){return this.origin===Protocol.CSS.StyleSheetOrigin.Regular;}
cssModel(){return this._cssModel;}};SDK.CSSStyleRule=class extends SDK.CSSRule{constructor(cssModel,payload,wasUsed){super(cssModel,payload);this._reinitializeSelectors(payload.selectorList);this.media=payload.media?SDK.CSSMedia.parseMediaArrayPayload(cssModel,payload.media):[];this.wasUsed=wasUsed||false;}
static createDummyRule(cssModel,selectorText){var dummyPayload={selectorList:{selectors:[{text:selectorText}],},style:{styleSheetId:'0',range:new TextUtils.TextRange(0,0,0,0),shorthandEntries:[],cssProperties:[]}};return new SDK.CSSStyleRule(cssModel,(dummyPayload));}
_reinitializeSelectors(selectorList){this.selectors=[];for(var i=0;i<selectorList.selectors.length;++i)
this.selectors.push(new SDK.CSSValue(selectorList.selectors[i]));}
setSelectorText(newSelector){var styleSheetId=this.styleSheetId;if(!styleSheetId)
throw'No rule stylesheet id';var range=this.selectorRange();if(!range)
throw'Rule selector is not editable';return this._cssModel.setSelectorText(styleSheetId,range,newSelector);}
selectorText(){return this.selectors.select('text').join(', ');}
selectorRange(){var firstRange=this.selectors[0].range;if(!firstRange)
return null;var lastRange=this.selectors.peekLast().range;return new TextUtils.TextRange(firstRange.startLine,firstRange.startColumn,lastRange.endLine,lastRange.endColumn);}
lineNumberInSource(selectorIndex){var selector=this.selectors[selectorIndex];if(!selector||!selector.range||!this.styleSheetId)
return 0;var styleSheetHeader=this._cssModel.styleSheetHeaderForId(this.styleSheetId);return styleSheetHeader.lineNumberInSource(selector.range.startLine);}
columnNumberInSource(selectorIndex){var selector=this.selectors[selectorIndex];if(!selector||!selector.range||!this.styleSheetId)
return undefined;var styleSheetHeader=this._cssModel.styleSheetHeaderForId(this.styleSheetId);console.assert(styleSheetHeader);return styleSheetHeader.columnNumberInSource(selector.range.startLine,selector.range.startColumn);}
rebase(edit){if(this.styleSheetId!==edit.styleSheetId)
return;if(this.selectorRange().equal(edit.oldRange)){this._reinitializeSelectors((edit.payload));}else{for(var i=0;i<this.selectors.length;++i)
this.selectors[i].rebase(edit);}
for(var media of this.media)
media.rebase(edit);super.rebase(edit);}};SDK.CSSKeyframesRule=class{constructor(cssModel,payload){this._cssModel=cssModel;this._animationName=new SDK.CSSValue(payload.animationName);this._keyframes=payload.keyframes.map(keyframeRule=>new SDK.CSSKeyframeRule(cssModel,keyframeRule));}
name(){return this._animationName;}
keyframes(){return this._keyframes;}};SDK.CSSKeyframeRule=class extends SDK.CSSRule{constructor(cssModel,payload){super(cssModel,payload);this._reinitializeKey(payload.keyText);}
key(){return this._keyText;}
_reinitializeKey(payload){this._keyText=new SDK.CSSValue(payload);}
rebase(edit){if(this.styleSheetId!==edit.styleSheetId||!this._keyText.range)
return;if(edit.oldRange.equal(this._keyText.range))
this._reinitializeKey((edit.payload));else
this._keyText.rebase(edit);super.rebase(edit);}
setKeyText(newKeyText){var styleSheetId=this.styleSheetId;if(!styleSheetId)
throw'No rule stylesheet id';var range=this._keyText.range;if(!range)
throw'Keyframe key is not editable';return this._cssModel.setKeyframeKey(styleSheetId,range,newKeyText);}};;SDK.CSSStyleDeclaration=class{constructor(cssModel,parentRule,payload,type){this._cssModel=cssModel;this.parentRule=parentRule;this._allProperties;this.styleSheetId;this.range;this.cssText;this._shorthandValues;this._shorthandIsImportant;this._activePropertyMap;this._leadingProperties;this._reinitialize(payload);this.type=type;}
rebase(edit){if(this.styleSheetId!==edit.styleSheetId||!this.range)
return;if(edit.oldRange.equal(this.range)){this._reinitialize((edit.payload));}else{this.range=this.range.rebaseAfterTextEdit(edit.oldRange,edit.newRange);for(var i=0;i<this._allProperties.length;++i)
this._allProperties[i].rebase(edit);}}
_reinitialize(payload){this.styleSheetId=payload.styleSheetId;this.range=payload.range?TextUtils.TextRange.fromObject(payload.range):null;var shorthandEntries=payload.shorthandEntries;this._shorthandValues=new Map();this._shorthandIsImportant=new Set();for(var i=0;i<shorthandEntries.length;++i){this._shorthandValues.set(shorthandEntries[i].name,shorthandEntries[i].value);if(shorthandEntries[i].important)
this._shorthandIsImportant.add(shorthandEntries[i].name);}
this._allProperties=[];for(var i=0;i<payload.cssProperties.length;++i){var property=SDK.CSSProperty.parsePayload(this,i,payload.cssProperties[i]);this._allProperties.push(property);}
this._generateSyntheticPropertiesIfNeeded();this._computeInactiveProperties();this._activePropertyMap=new Map();for(var property of this._allProperties){if(!property.activeInStyle())
continue;this._activePropertyMap.set(property.name,property);}
this.cssText=payload.cssText;this._leadingProperties=null;}
_generateSyntheticPropertiesIfNeeded(){if(this.range)
return;if(!this._shorthandValues.size)
return;var propertiesSet=new Set();for(var property of this._allProperties)
propertiesSet.add(property.name);var generatedProperties=[];for(var property of this._allProperties){var shorthands=SDK.cssMetadata().shorthands(property.name)||[];for(var shorthand of shorthands){if(propertiesSet.has(shorthand))
continue;var shorthandValue=this._shorthandValues.get(shorthand);if(!shorthandValue)
continue;var shorthandImportance=!!this._shorthandIsImportant.has(shorthand);var shorthandProperty=new SDK.CSSProperty(this,this.allProperties().length,shorthand,shorthandValue,shorthandImportance,false,true,false);generatedProperties.push(shorthandProperty);propertiesSet.add(shorthand);}}
this._allProperties=this._allProperties.concat(generatedProperties);}
_computeLeadingProperties(){function propertyHasRange(property){return!!property.range;}
if(this.range)
return this._allProperties.filter(propertyHasRange);var leadingProperties=[];for(var property of this._allProperties){var shorthands=SDK.cssMetadata().shorthands(property.name)||[];var belongToAnyShorthand=false;for(var shorthand of shorthands){if(this._shorthandValues.get(shorthand)){belongToAnyShorthand=true;break;}}
if(!belongToAnyShorthand)
leadingProperties.push(property);}
return leadingProperties;}
leadingProperties(){if(!this._leadingProperties)
this._leadingProperties=this._computeLeadingProperties();return this._leadingProperties;}
target(){return this._cssModel.target();}
cssModel(){return this._cssModel;}
_computeInactiveProperties(){var activeProperties={};for(var i=0;i<this._allProperties.length;++i){var property=this._allProperties[i];if(property.disabled||!property.parsedOk){property.setActive(false);continue;}
var canonicalName=SDK.cssMetadata().canonicalPropertyName(property.name);var activeProperty=activeProperties[canonicalName];if(!activeProperty){activeProperties[canonicalName]=property;}else if(!activeProperty.important||property.important){activeProperty.setActive(false);activeProperties[canonicalName]=property;}else{property.setActive(false);}}}
allProperties(){return this._allProperties;}
getPropertyValue(name){var property=this._activePropertyMap.get(name);return property?property.value:'';}
isPropertyImplicit(name){var property=this._activePropertyMap.get(name);return property?property.implicit:false;}
longhandProperties(name){var longhands=SDK.cssMetadata().longhands(name);var result=[];for(var i=0;longhands&&i<longhands.length;++i){var property=this._activePropertyMap.get(longhands[i]);if(property)
result.push(property);}
return result;}
propertyAt(index){return(index<this.allProperties().length)?this.allProperties()[index]:null;}
pastLastSourcePropertyIndex(){for(var i=this.allProperties().length-1;i>=0;--i){if(this.allProperties()[i].range)
return i+1;}
return 0;}
_insertionRange(index){var property=this.propertyAt(index);return property&&property.range?property.range.collapseToStart():this.range.collapseToEnd();}
newBlankProperty(index){index=(typeof index==='undefined')?this.pastLastSourcePropertyIndex():index;var property=new SDK.CSSProperty(this,index,'','',false,false,true,false,'',this._insertionRange(index));return property;}
setText(text,majorChange){if(!this.range||!this.styleSheetId)
return Promise.resolve(false);return this._cssModel.setStyleText(this.styleSheetId,this.range,text,majorChange);}
insertPropertyAt(index,name,value,userCallback){this.newBlankProperty(index).setText(name+': '+value+';',false,true).then(userCallback);}
appendProperty(name,value,userCallback){this.insertPropertyAt(this.allProperties().length,name,value,userCallback);}};SDK.CSSStyleDeclaration.Type={Regular:'Regular',Inline:'Inline',Attributes:'Attributes'};;SDK.CSSStyleSheetHeader=class{constructor(cssModel,payload){this._cssModel=cssModel;this.id=payload.styleSheetId;this.frameId=payload.frameId;this.sourceURL=payload.sourceURL;this.hasSourceURL=!!payload.hasSourceURL;this.origin=payload.origin;this.title=payload.title;this.disabled=payload.disabled;this.isInline=payload.isInline;this.startLine=payload.startLine;this.startColumn=payload.startColumn;this.contentLength=payload.length;if(payload.ownerNode)
this.ownerNode=new SDK.DeferredDOMNode(cssModel.target(),payload.ownerNode);this.setSourceMapURL(payload.sourceMapURL);}
originalContentProvider(){if(!this._originalContentProvider){var lazyContent=this._cssModel.originalStyleSheetText.bind(this._cssModel,this);this._originalContentProvider=new Common.StaticContentProvider(this.contentURL(),this.contentType(),(lazyContent));}
return this._originalContentProvider;}
setSourceMapURL(sourceMapURL){this.sourceMapURL=sourceMapURL;}
cssModel(){return this._cssModel;}
isAnonymousInlineStyleSheet(){return!this.resourceURL()&&!this._cssModel.sourceMapManager().sourceMapForClient(this);}
resourceURL(){return this.isViaInspector()?this._viaInspectorResourceURL():this.sourceURL;}
_viaInspectorResourceURL(){var frame=this._cssModel.target().model(SDK.ResourceTreeModel).frameForId(this.frameId);console.assert(frame);var parsedURL=new Common.ParsedURL(frame.url);var fakeURL='inspector://'+parsedURL.host+parsedURL.folderPathComponents;if(!fakeURL.endsWith('/'))
fakeURL+='/';fakeURL+='inspector-stylesheet';return fakeURL;}
lineNumberInSource(lineNumberInStyleSheet){return this.startLine+lineNumberInStyleSheet;}
columnNumberInSource(lineNumberInStyleSheet,columnNumberInStyleSheet){return(lineNumberInStyleSheet?0:this.startColumn)+columnNumberInStyleSheet;}
contentURL(){return this.resourceURL();}
contentType(){return Common.resourceTypes.Stylesheet;}
requestContent(){return this._cssModel.getStyleSheetText(this.id);}
async searchInContent(query,caseSensitive,isRegex){var content=await this.requestContent();return Common.ContentProvider.performSearchInContent(content,query,caseSensitive,isRegex);}
isViaInspector(){return this.origin==='inspector';}};;SDK.DOMDebuggerModel=class extends SDK.SDKModel{constructor(target){super(target);this._agent=target.domdebuggerAgent();this._runtimeModel=(target.model(SDK.RuntimeModel));this._domModel=(target.model(SDK.DOMModel));this._domModel.addEventListener(SDK.DOMModel.Events.DocumentUpdated,this._documentUpdated,this);this._domModel.addEventListener(SDK.DOMModel.Events.NodeRemoved,this._nodeRemoved,this);this._domBreakpoints=[];this._domBreakpointsSetting=Common.settings.createLocalSetting('domBreakpoints',[]);if(this._domModel.existingDocument())
this._documentUpdated();}
runtimeModel(){return this._runtimeModel;}
async eventListeners(remoteObject){console.assert(remoteObject.runtimeModel()===this._runtimeModel);if(!remoteObject.objectId)
return[];var payloads=await this._agent.getEventListeners((remoteObject.objectId));var eventListeners=[];for(var payload of payloads||[]){var location=this._runtimeModel.debuggerModel().createRawLocationByScriptId(payload.scriptId,payload.lineNumber,payload.columnNumber);if(!location)
continue;eventListeners.push(new SDK.EventListener(this,remoteObject,payload.type,payload.useCapture,payload.passive,payload.once,payload.handler?this._runtimeModel.createRemoteObject(payload.handler):null,payload.originalHandler?this._runtimeModel.createRemoteObject(payload.originalHandler):null,location,null));}
return eventListeners;}
retrieveDOMBreakpoints(){this._domModel.requestDocumentPromise();}
domBreakpoints(){return this._domBreakpoints.slice();}
hasDOMBreakpoint(node,type){return this._domBreakpoints.some(breakpoint=>(breakpoint.node===node&&breakpoint.type===type));}
setDOMBreakpoint(node,type){for(var breakpoint of this._domBreakpoints){if(breakpoint.node===node&&breakpoint.type===type){this.toggleDOMBreakpoint(breakpoint,true);return breakpoint;}}
var breakpoint=new SDK.DOMDebuggerModel.DOMBreakpoint(this,node,type,true);this._domBreakpoints.push(breakpoint);this._saveDOMBreakpoints();this._enableDOMBreakpoint(breakpoint);this.dispatchEventToListeners(SDK.DOMDebuggerModel.Events.DOMBreakpointAdded,breakpoint);return breakpoint;}
removeDOMBreakpoint(node,type){this._removeDOMBreakpoints(breakpoint=>breakpoint.node===node&&breakpoint.type===type);}
removeAllDOMBreakpoints(){this._removeDOMBreakpoints(breakpoint=>true);}
toggleDOMBreakpoint(breakpoint,enabled){if(enabled===breakpoint.enabled)
return;breakpoint.enabled=enabled;if(enabled)
this._enableDOMBreakpoint(breakpoint);else
this._disableDOMBreakpoint(breakpoint);this.dispatchEventToListeners(SDK.DOMDebuggerModel.Events.DOMBreakpointToggled,breakpoint);}
_enableDOMBreakpoint(breakpoint){this._agent.setDOMBreakpoint(breakpoint.node.id,breakpoint.type);breakpoint.node.setMarker(SDK.DOMDebuggerModel.DOMBreakpoint.Marker,true);}
_disableDOMBreakpoint(breakpoint){this._agent.removeDOMBreakpoint(breakpoint.node.id,breakpoint.type);breakpoint.node.setMarker(SDK.DOMDebuggerModel.DOMBreakpoint.Marker,this._nodeHasBreakpoints(breakpoint.node)?true:null);}
_nodeHasBreakpoints(node){for(var breakpoint of this._domBreakpoints){if(breakpoint.node===node&&breakpoint.enabled)
return true;}
return false;}
resolveDOMBreakpointData(auxData){var type=auxData['type'];var node=this._domModel.nodeForId(auxData['nodeId']);if(!type||!node)
return null;var targetNode=null;var insertion=false;if(type===SDK.DOMDebuggerModel.DOMBreakpoint.Type.SubtreeModified){insertion=auxData['insertion']||false;targetNode=this._domModel.nodeForId(auxData['targetNodeId']);}
return{type:type,node:node,targetNode:targetNode,insertion:insertion};}
_currentURL(){var domDocument=this._domModel.existingDocument();return domDocument?domDocument.documentURL:'';}
_documentUpdated(){var removed=this._domBreakpoints;this._domBreakpoints=[];this.dispatchEventToListeners(SDK.DOMDebuggerModel.Events.DOMBreakpointsRemoved,removed);var currentURL=this._currentURL();for(var breakpoint of this._domBreakpointsSetting.get()){if(breakpoint.url===currentURL)
this._domModel.pushNodeByPathToFrontend(breakpoint.path).then(appendBreakpoint.bind(this,breakpoint));}
function appendBreakpoint(breakpoint,nodeId){var node=nodeId?this._domModel.nodeForId(nodeId):null;if(!node)
return;var domBreakpoint=new SDK.DOMDebuggerModel.DOMBreakpoint(this,node,breakpoint.type,breakpoint.enabled);this._domBreakpoints.push(domBreakpoint);if(breakpoint.enabled)
this._enableDOMBreakpoint(domBreakpoint);this.dispatchEventToListeners(SDK.DOMDebuggerModel.Events.DOMBreakpointAdded,domBreakpoint);}}
_removeDOMBreakpoints(filter){var removed=[];var left=[];for(var breakpoint of this._domBreakpoints){if(filter(breakpoint)){removed.push(breakpoint);if(breakpoint.enabled){breakpoint.enabled=false;this._disableDOMBreakpoint(breakpoint);}}else{left.push(breakpoint);}}
if(!removed.length)
return;this._domBreakpoints=left;this._saveDOMBreakpoints();this.dispatchEventToListeners(SDK.DOMDebuggerModel.Events.DOMBreakpointsRemoved,removed);}
_nodeRemoved(event){var node=(event.data.node);var children=node.children()||[];this._removeDOMBreakpoints(breakpoint=>breakpoint.node===node||children.indexOf(breakpoint.node)!==-1);}
_saveDOMBreakpoints(){var currentURL=this._currentURL();var breakpoints=this._domBreakpointsSetting.get().filter(breakpoint=>breakpoint.url!==currentURL);for(var breakpoint of this._domBreakpoints){breakpoints.push({url:currentURL,path:breakpoint.node.path(),type:breakpoint.type,enabled:breakpoint.enabled});}
this._domBreakpointsSetting.set(breakpoints);}};SDK.SDKModel.register(SDK.DOMDebuggerModel,SDK.Target.Capability.DOM,false);SDK.DOMDebuggerModel.Events={DOMBreakpointAdded:Symbol('DOMBreakpointAdded'),DOMBreakpointToggled:Symbol('DOMBreakpointToggled'),DOMBreakpointsRemoved:Symbol('DOMBreakpointsRemoved'),};SDK.DOMDebuggerModel.DOMBreakpoint=class{constructor(domDebuggerModel,node,type,enabled){this.domDebuggerModel=domDebuggerModel;this.node=node;this.type=type;this.enabled=enabled;}};SDK.DOMDebuggerModel.DOMBreakpoint.Type=Protocol.DOMDebugger.DOMBreakpointType;SDK.DOMDebuggerModel.DOMBreakpoint.Marker='breakpoint-marker';SDK.EventListener=class{constructor(domDebuggerModel,eventTarget,type,useCapture,passive,once,handler,originalHandler,location,customRemoveFunction,origin){this._domDebuggerModel=domDebuggerModel;this._eventTarget=eventTarget;this._type=type;this._useCapture=useCapture;this._passive=passive;this._once=once;this._handler=handler;this._originalHandler=originalHandler||handler;this._location=location;var script=location.script();this._sourceURL=script?script.contentURL():'';this._customRemoveFunction=customRemoveFunction;this._origin=origin||SDK.EventListener.Origin.Raw;}
domDebuggerModel(){return this._domDebuggerModel;}
type(){return this._type;}
useCapture(){return this._useCapture;}
passive(){return this._passive;}
once(){return this._once;}
handler(){return this._handler;}
location(){return this._location;}
sourceURL(){return this._sourceURL;}
originalHandler(){return this._originalHandler;}
canRemove(){return!!this._customRemoveFunction||this._origin!==SDK.EventListener.Origin.FrameworkUser;}
remove(){if(!this.canRemove())
return Promise.resolve();if(this._origin!==SDK.EventListener.Origin.FrameworkUser){function removeListener(type,listener,useCapture){this.removeEventListener(type,listener,useCapture);if(this['on'+type])
this['on'+type]=undefined;}
return(this._eventTarget.callFunctionPromise(removeListener,[SDK.RemoteObject.toCallArgument(this._type),SDK.RemoteObject.toCallArgument(this._originalHandler),SDK.RemoteObject.toCallArgument(this._useCapture)]));}
return this._customRemoveFunction.callFunctionPromise(callCustomRemove,[SDK.RemoteObject.toCallArgument(this._type),SDK.RemoteObject.toCallArgument(this._originalHandler),SDK.RemoteObject.toCallArgument(this._useCapture),SDK.RemoteObject.toCallArgument(this._passive),]).then(()=>undefined);function callCustomRemove(type,listener,useCapture,passive){this.call(null,type,listener,useCapture,passive);}}
canTogglePassive(){return this._origin!==SDK.EventListener.Origin.FrameworkUser;}
togglePassive(){return(this._eventTarget.callFunctionPromise(callTogglePassive,[SDK.RemoteObject.toCallArgument(this._type),SDK.RemoteObject.toCallArgument(this._originalHandler),SDK.RemoteObject.toCallArgument(this._useCapture),SDK.RemoteObject.toCallArgument(this._passive),]));function callTogglePassive(type,listener,useCapture,passive){this.removeEventListener(type,listener,{capture:useCapture});this.addEventListener(type,listener,{capture:useCapture,passive:!passive});}}
origin(){return this._origin;}
markAsFramework(){this._origin=SDK.EventListener.Origin.Framework;}
isScrollBlockingType(){return this._type==='touchstart'||this._type==='touchmove'||this._type==='mousewheel'||this._type==='wheel';}};SDK.EventListener.Origin={Raw:'Raw',Framework:'Framework',FrameworkUser:'FrameworkUser'};SDK.DOMDebuggerModel.EventListenerBreakpoint=class{constructor(instrumentationName,eventName,eventTargetNames,category,title){this._instrumentationName=instrumentationName;this._eventName=eventName;this._eventTargetNames=eventTargetNames;this._category=category;this._title=title;this._enabled=false;}
category(){return this._category;}
enabled(){return this._enabled;}
setEnabled(enabled){if(this._enabled===enabled)
return;this._enabled=enabled;for(var model of SDK.targetManager.models(SDK.DOMDebuggerModel))
this._updateOnModel(model);}
_updateOnModel(model){if(this._instrumentationName){if(this._enabled)
model._agent.setInstrumentationBreakpoint(this._instrumentationName);else
model._agent.removeInstrumentationBreakpoint(this._instrumentationName);}else{for(var eventTargetName of this._eventTargetNames){if(this._enabled)
model._agent.setEventListenerBreakpoint(this._eventName,eventTargetName);else
model._agent.removeEventListenerBreakpoint(this._eventName,eventTargetName);}}}
title(){return this._title;}};SDK.DOMDebuggerModel.EventListenerBreakpoint._listener='listener:';SDK.DOMDebuggerModel.EventListenerBreakpoint._instrumentation='instrumentation:';SDK.DOMDebuggerManager=class{constructor(){this._xhrBreakpointsSetting=Common.settings.createLocalSetting('xhrBreakpoints',[]);this._xhrBreakpoints=new Map();for(var breakpoint of this._xhrBreakpointsSetting.get())
this._xhrBreakpoints.set(breakpoint.url,breakpoint.enabled);this._eventListenerBreakpoints=[];this._createInstrumentationBreakpoints(Common.UIString('Animation'),['requestAnimationFrame','cancelAnimationFrame','requestAnimationFrame.callback']);this._createInstrumentationBreakpoints(Common.UIString('Canvas'),['canvasContextCreated','webglErrorFired','webglWarningFired']);this._createInstrumentationBreakpoints(Common.UIString('Geolocation'),['Geolocation.getCurrentPosition','Geolocation.watchPosition']);this._createInstrumentationBreakpoints(Common.UIString('Notification'),['Notification.requestPermission']);this._createInstrumentationBreakpoints(Common.UIString('Parse'),['Element.setInnerHTML','Document.write']);this._createInstrumentationBreakpoints(Common.UIString('Script'),['scriptFirstStatement','scriptBlockedByCSP']);this._createInstrumentationBreakpoints(Common.UIString('Timer'),['setTimeout','clearTimeout','setInterval','clearInterval','setTimeout.callback','setInterval.callback']);this._createInstrumentationBreakpoints(Common.UIString('Window'),['DOMWindow.close']);this._createEventListenerBreakpoints(Common.UIString('Media'),['play','pause','playing','canplay','canplaythrough','seeking','seeked','timeupdate','ended','ratechange','durationchange','volumechange','loadstart','progress','suspend','abort','error','emptied','stalled','loadedmetadata','loadeddata','waiting'],['audio','video']);this._createEventListenerBreakpoints(Common.UIString('Clipboard'),['copy','cut','paste','beforecopy','beforecut','beforepaste'],['*']);this._createEventListenerBreakpoints(Common.UIString('Control'),['resize','scroll','zoom','focus','blur','select','change','submit','reset'],['*']);this._createEventListenerBreakpoints(Common.UIString('Device'),['deviceorientation','devicemotion'],['*']);this._createEventListenerBreakpoints(Common.UIString('DOM Mutation'),['DOMActivate','DOMFocusIn','DOMFocusOut','DOMAttrModified','DOMCharacterDataModified','DOMNodeInserted','DOMNodeInsertedIntoDocument','DOMNodeRemoved','DOMNodeRemovedFromDocument','DOMSubtreeModified','DOMContentLoaded'],['*']);this._createEventListenerBreakpoints(Common.UIString('Drag / drop'),['dragenter','dragover','dragleave','drop'],['*']);this._createEventListenerBreakpoints(Common.UIString('Keyboard'),['keydown','keyup','keypress','input'],['*']);this._createEventListenerBreakpoints(Common.UIString('Load'),['load','beforeunload','unload','abort','error','hashchange','popstate'],['*']);this._createEventListenerBreakpoints(Common.UIString('Mouse'),['auxclick','click','dblclick','mousedown','mouseup','mouseover','mousemove','mouseout','mouseenter','mouseleave','mousewheel','wheel','contextmenu'],['*']);this._createEventListenerBreakpoints(Common.UIString('Pointer'),['pointerover','pointerout','pointerenter','pointerleave','pointerdown','pointerup','pointermove','pointercancel','gotpointercapture','lostpointercapture'],['*']);this._createEventListenerBreakpoints(Common.UIString('Touch'),['touchstart','touchmove','touchend','touchcancel'],['*']);this._createEventListenerBreakpoints(Common.UIString('XHR'),['readystatechange','load','loadstart','loadend','abort','error','progress','timeout'],['xmlhttprequest','xmlhttprequestupload']);this._resolveEventListenerBreakpoint('instrumentation:setTimeout.callback')._title=Common.UIString('setTimeout fired');this._resolveEventListenerBreakpoint('instrumentation:setInterval.callback')._title=Common.UIString('setInterval fired');this._resolveEventListenerBreakpoint('instrumentation:scriptFirstStatement')._title=Common.UIString('Script First Statement');this._resolveEventListenerBreakpoint('instrumentation:scriptBlockedByCSP')._title=Common.UIString('Script Blocked by Content Security Policy');this._resolveEventListenerBreakpoint('instrumentation:requestAnimationFrame')._title=Common.UIString('Request Animation Frame');this._resolveEventListenerBreakpoint('instrumentation:cancelAnimationFrame')._title=Common.UIString('Cancel Animation Frame');this._resolveEventListenerBreakpoint('instrumentation:requestAnimationFrame.callback')._title=Common.UIString('Animation Frame Fired');this._resolveEventListenerBreakpoint('instrumentation:webglErrorFired')._title=Common.UIString('WebGL Error Fired');this._resolveEventListenerBreakpoint('instrumentation:webglWarningFired')._title=Common.UIString('WebGL Warning Fired');this._resolveEventListenerBreakpoint('instrumentation:Element.setInnerHTML')._title=Common.UIString('Set innerHTML');this._resolveEventListenerBreakpoint('instrumentation:canvasContextCreated')._title=Common.UIString('Create canvas context');this._resolveEventListenerBreakpoint('instrumentation:Geolocation.getCurrentPosition')._title='getCurrentPosition';this._resolveEventListenerBreakpoint('instrumentation:Geolocation.watchPosition')._title='watchPosition';this._resolveEventListenerBreakpoint('instrumentation:Notification.requestPermission')._title='requestPermission';this._resolveEventListenerBreakpoint('instrumentation:DOMWindow.close')._title='window.close';this._resolveEventListenerBreakpoint('instrumentation:Document.write')._title='document.write';SDK.targetManager.observeModels(SDK.DOMDebuggerModel,this);}
_createInstrumentationBreakpoints(category,instrumentationNames){for(var instrumentationName of instrumentationNames){this._eventListenerBreakpoints.push(new SDK.DOMDebuggerModel.EventListenerBreakpoint(instrumentationName,'',[],category,instrumentationName));}}
_createEventListenerBreakpoints(category,eventNames,eventTargetNames){for(var eventName of eventNames){this._eventListenerBreakpoints.push(new SDK.DOMDebuggerModel.EventListenerBreakpoint('',eventName,eventTargetNames,category,eventName));}}
_resolveEventListenerBreakpoint(eventName,eventTargetName){var instrumentationPrefix='instrumentation:';var listenerPrefix='listener:';var instrumentationName='';if(eventName.startsWith(instrumentationPrefix)){instrumentationName=eventName.substring(instrumentationPrefix.length);eventName='';}else if(eventName.startsWith(listenerPrefix)){eventName=eventName.substring(listenerPrefix.length);}else{return null;}
eventTargetName=(eventTargetName||'*').toLowerCase();var result=null;for(var breakpoint of this._eventListenerBreakpoints){if(instrumentationName&&breakpoint._instrumentationName===instrumentationName)
result=breakpoint;if(eventName&&breakpoint._eventName===eventName&&breakpoint._eventTargetNames.indexOf(eventTargetName)!==-1)
result=breakpoint;if(!result&&eventName&&breakpoint._eventName===eventName&&breakpoint._eventTargetNames.indexOf('*')!==-1)
result=breakpoint;}
return result;}
eventListenerBreakpoints(){return this._eventListenerBreakpoints.slice();}
resolveEventListenerBreakpointTitle(auxData){var id=auxData['eventName'];if(id==='instrumentation:webglErrorFired'&&auxData['webglErrorName']){var errorName=auxData['webglErrorName'];errorName=errorName.replace(/^.*(0x[0-9a-f]+).*$/i,'$1');return Common.UIString('WebGL Error Fired (%s)',errorName);}
if(id==='instrumentation:scriptBlockedByCSP'&&auxData['directiveText'])
return Common.UIString('Script blocked due to Content Security Policy directive: %s',auxData['directiveText']);var breakpoint=this._resolveEventListenerBreakpoint(id,auxData['targetName']);if(!breakpoint)
return'';if(auxData['targetName'])
return auxData['targetName']+'.'+breakpoint._title;return breakpoint._title;}
resolveEventListenerBreakpoint(auxData){return this._resolveEventListenerBreakpoint(auxData['eventName'],auxData['targetName']);}
xhrBreakpoints(){return this._xhrBreakpoints;}
_saveXHRBreakpoints(){var breakpoints=[];for(var url of this._xhrBreakpoints.keys())
breakpoints.push({url:url,enabled:this._xhrBreakpoints.get(url)});this._xhrBreakpointsSetting.set(breakpoints);}
addXHRBreakpoint(url,enabled){this._xhrBreakpoints.set(url,enabled);if(enabled){for(var model of SDK.targetManager.models(SDK.DOMDebuggerModel))
model._agent.setXHRBreakpoint(url);}
this._saveXHRBreakpoints();}
removeXHRBreakpoint(url){var enabled=this._xhrBreakpoints.get(url);this._xhrBreakpoints.delete(url);if(enabled){for(var model of SDK.targetManager.models(SDK.DOMDebuggerModel))
model._agent.removeXHRBreakpoint(url);}
this._saveXHRBreakpoints();}
toggleXHRBreakpoint(url,enabled){this._xhrBreakpoints.set(url,enabled);for(var model of SDK.targetManager.models(SDK.DOMDebuggerModel)){if(enabled)
model._agent.setXHRBreakpoint(url);else
model._agent.removeXHRBreakpoint(url);}
this._saveXHRBreakpoints();}
modelAdded(domDebuggerModel){for(var url of this._xhrBreakpoints.keys()){if(this._xhrBreakpoints.get(url))
domDebuggerModel._agent.setXHRBreakpoint(url);}
for(var breakpoint of this._eventListenerBreakpoints){if(breakpoint._enabled)
breakpoint._updateOnModel(domDebuggerModel);}}
modelRemoved(domDebuggerModel){}};SDK.domDebuggerManager;;SDK.DOMNode=class{constructor(domModel){this._domModel=domModel;}
static create(domModel,doc,isInShadowTree,payload){var node=new SDK.DOMNode(domModel);node._init(doc,isInShadowTree,payload);return node;}
_init(doc,isInShadowTree,payload){this._agent=this._domModel._agent;this.ownerDocument=doc;this._isInShadowTree=isInShadowTree;this.id=payload.nodeId;this._backendNodeId=payload.backendNodeId;this._domModel._idToDOMNode[this.id]=this;this._nodeType=payload.nodeType;this._nodeName=payload.nodeName;this._localName=payload.localName;this._nodeValue=payload.nodeValue;this._pseudoType=payload.pseudoType;this._shadowRootType=payload.shadowRootType;this._frameOwnerFrameId=payload.frameId||null;this._xmlVersion=payload.xmlVersion;this._isSVGNode=!!payload.isSVG;this._shadowRoots=[];this._attributes=[];this._attributesMap={};if(payload.attributes)
this._setAttributesPayload(payload.attributes);this._markers=new Map();this._subtreeMarkerCount=0;this._childNodeCount=payload.childNodeCount||0;this._children=null;this.nextSibling=null;this.previousSibling=null;this.firstChild=null;this.lastChild=null;this.parentNode=null;if(payload.shadowRoots){for(var i=0;i<payload.shadowRoots.length;++i){var root=payload.shadowRoots[i];var node=SDK.DOMNode.create(this._domModel,this.ownerDocument,true,root);this._shadowRoots.push(node);node.parentNode=this;}}
if(payload.templateContent){this._templateContent=SDK.DOMNode.create(this._domModel,this.ownerDocument,true,payload.templateContent);this._templateContent.parentNode=this;}
if(payload.importedDocument){this._importedDocument=SDK.DOMNode.create(this._domModel,this.ownerDocument,true,payload.importedDocument);this._importedDocument.parentNode=this;}
if(payload.distributedNodes)
this._setDistributedNodePayloads(payload.distributedNodes);if(payload.children)
this._setChildrenPayload(payload.children);this._setPseudoElements(payload.pseudoElements);if(payload.contentDocument){this._contentDocument=new SDK.DOMDocument(this._domModel,payload.contentDocument);this._children=[this._contentDocument];this._renumber();}
if(this._nodeType===Node.ELEMENT_NODE){if(this.ownerDocument&&!this.ownerDocument.documentElement&&this._nodeName==='HTML')
this.ownerDocument.documentElement=this;if(this.ownerDocument&&!this.ownerDocument.body&&this._nodeName==='BODY')
this.ownerDocument.body=this;}else if(this._nodeType===Node.DOCUMENT_TYPE_NODE){this.publicId=payload.publicId;this.systemId=payload.systemId;this.internalSubset=payload.internalSubset;}else if(this._nodeType===Node.ATTRIBUTE_NODE){this.name=payload.name;this.value=payload.value;}}
isSVGNode(){return this._isSVGNode;}
domModel(){return this._domModel;}
backendNodeId(){return this._backendNodeId;}
children(){return this._children?this._children.slice():null;}
hasAttributes(){return this._attributes.length>0;}
childNodeCount(){return this._childNodeCount;}
hasShadowRoots(){return!!this._shadowRoots.length;}
shadowRoots(){return this._shadowRoots.slice();}
templateContent(){return this._templateContent||null;}
importedDocument(){return this._importedDocument||null;}
nodeType(){return this._nodeType;}
nodeName(){return this._nodeName;}
pseudoType(){return this._pseudoType;}
hasPseudoElements(){return this._pseudoElements.size>0;}
pseudoElements(){return this._pseudoElements;}
beforePseudoElement(){if(!this._pseudoElements)
return null;return this._pseudoElements.get(SDK.DOMNode.PseudoElementNames.Before);}
afterPseudoElement(){if(!this._pseudoElements)
return null;return this._pseudoElements.get(SDK.DOMNode.PseudoElementNames.After);}
isInsertionPoint(){return!this.isXMLNode()&&(this._nodeName==='SHADOW'||this._nodeName==='CONTENT'||this._nodeName==='SLOT');}
distributedNodes(){return this._distributedNodes||[];}
isInShadowTree(){return this._isInShadowTree;}
ancestorShadowHost(){var ancestorShadowRoot=this.ancestorShadowRoot();return ancestorShadowRoot?ancestorShadowRoot.parentNode:null;}
ancestorShadowRoot(){if(!this._isInShadowTree)
return null;var current=this;while(current&&!current.isShadowRoot())
current=current.parentNode;return current;}
ancestorUserAgentShadowRoot(){var ancestorShadowRoot=this.ancestorShadowRoot();if(!ancestorShadowRoot)
return null;return ancestorShadowRoot.shadowRootType()===SDK.DOMNode.ShadowRootTypes.UserAgent?ancestorShadowRoot:null;}
isShadowRoot(){return!!this._shadowRootType;}
shadowRootType(){return this._shadowRootType||null;}
nodeNameInCorrectCase(){var shadowRootType=this.shadowRootType();if(shadowRootType)
return'#shadow-root ('+shadowRootType+')';if(!this.localName())
return this.nodeName();if(this.localName().length!==this.nodeName().length)
return this.nodeName();return this.localName();}
setNodeName(name,callback){this._agent.invoke_setNodeName({nodeId:this.id,name}).then(response=>{if(!response[Protocol.Error])
this._domModel.markUndoableState();if(callback)
callback(response[Protocol.Error]||null,response.nodeId);});}
localName(){return this._localName;}
nodeValue(){return this._nodeValue;}
setNodeValue(value,callback){this._agent.invoke_setNodeValue({nodeId:this.id,value}).then(response=>{if(!response[Protocol.Error])
this._domModel.markUndoableState();if(callback)
callback(response[Protocol.Error]||null);});}
getAttribute(name){var attr=this._attributesMap[name];return attr?attr.value:undefined;}
setAttribute(name,text,callback){this._agent.invoke_setAttributesAsText({nodeId:this.id,text,name}).then(response=>{if(!response[Protocol.Error])
this._domModel.markUndoableState();if(callback)
callback(response[Protocol.Error]||null);});}
setAttributeValue(name,value,callback){this._agent.invoke_setAttributeValue({nodeId:this.id,name,value}).then(response=>{if(!response[Protocol.Error])
this._domModel.markUndoableState();if(callback)
callback(response[Protocol.Error]||null);});}
setAttributeValuePromise(name,value){return new Promise(fulfill=>this.setAttributeValue(name,value,fulfill));}
attributes(){return this._attributes;}
async removeAttribute(name){var response=await this._agent.invoke_removeAttribute({nodeId:this.id,name});if(response[Protocol.Error])
return;delete this._attributesMap[name];var index=this._attributes.findIndex(attr=>attr.name===name);if(index!==-1)
this._attributes.splice(index,1);this._domModel.markUndoableState();}
getChildNodes(callback){if(this._children){callback(this.children());return;}
this._agent.invoke_requestChildNodes({nodeId:this.id}).then(response=>{callback(response[Protocol.Error]?null:this.children());});}
async getSubtree(depth){var response=await this._agent.invoke_requestChildNodes({id:this.id,depth});return response[Protocol.Error]?null:this._children;}
getOuterHTML(){return this._agent.getOuterHTML(this.id);}
setOuterHTML(html,callback){this._agent.invoke_setOuterHTML({nodeId:this.id,outerHTML:html}).then(response=>{if(!response[Protocol.Error])
this._domModel.markUndoableState();if(callback)
callback(response[Protocol.Error]||null);});}
removeNode(callback){this._agent.invoke_removeNode({nodeId:this.id}).then(response=>{if(!response[Protocol.Error])
this._domModel.markUndoableState();if(callback)
callback(response[Protocol.Error]||null);});}
async copyNode(){var text=await this._agent.getOuterHTML(this.id);if(text!==null)
InspectorFrontendHost.copyText(text);return text;}
path(){function canPush(node){return node&&('index'in node||(node.isShadowRoot()&&node.parentNode))&&node._nodeName.length;}
var path=[];var node=this;while(canPush(node)){var index=typeof node.index==='number'?node.index:(node.shadowRootType()===SDK.DOMNode.ShadowRootTypes.UserAgent?'u':'a');path.push([index,node._nodeName]);node=node.parentNode;}
path.reverse();return path.join(',');}
isAncestor(node){if(!node)
return false;var currentNode=node.parentNode;while(currentNode){if(this===currentNode)
return true;currentNode=currentNode.parentNode;}
return false;}
isDescendant(descendant){return descendant!==null&&descendant.isAncestor(this);}
frameId(){var node=this.parentNode||this;while(!node._frameOwnerFrameId&&node.parentNode)
node=node.parentNode;return node._frameOwnerFrameId;}
_setAttributesPayload(attrs){var attributesChanged=!this._attributes||attrs.length!==this._attributes.length*2;var oldAttributesMap=this._attributesMap||{};this._attributes=[];this._attributesMap={};for(var i=0;i<attrs.length;i+=2){var name=attrs[i];var value=attrs[i+1];this._addAttribute(name,value);if(attributesChanged)
continue;if(!oldAttributesMap[name]||oldAttributesMap[name].value!==value)
attributesChanged=true;}
return attributesChanged;}
_insertChild(prev,payload){var node=SDK.DOMNode.create(this._domModel,this.ownerDocument,this._isInShadowTree,payload);this._children.splice(this._children.indexOf(prev)+1,0,node);this._renumber();return node;}
_removeChild(node){if(node.pseudoType()){this._pseudoElements.delete(node.pseudoType());}else{var shadowRootIndex=this._shadowRoots.indexOf(node);if(shadowRootIndex!==-1){this._shadowRoots.splice(shadowRootIndex,1);}else{console.assert(this._children.indexOf(node)!==-1);this._children.splice(this._children.indexOf(node),1);}}
node.parentNode=null;this._subtreeMarkerCount-=node._subtreeMarkerCount;if(node._subtreeMarkerCount)
this._domModel.dispatchEventToListeners(SDK.DOMModel.Events.MarkersChanged,this);this._renumber();}
_setChildrenPayload(payloads){if(this._contentDocument)
return;this._children=[];for(var i=0;i<payloads.length;++i){var payload=payloads[i];var node=SDK.DOMNode.create(this._domModel,this.ownerDocument,this._isInShadowTree,payload);this._children.push(node);}
this._renumber();}
_setPseudoElements(payloads){this._pseudoElements=new Map();if(!payloads)
return;for(var i=0;i<payloads.length;++i){var node=SDK.DOMNode.create(this._domModel,this.ownerDocument,this._isInShadowTree,payloads[i]);node.parentNode=this;this._pseudoElements.set(node.pseudoType(),node);}}
_setDistributedNodePayloads(payloads){this._distributedNodes=[];for(var payload of payloads){this._distributedNodes.push(new SDK.DOMNodeShortcut(this._domModel.target(),payload.backendNodeId,payload.nodeType,payload.nodeName));}}
_renumber(){this._childNodeCount=this._children.length;if(this._childNodeCount===0){this.firstChild=null;this.lastChild=null;return;}
this.firstChild=this._children[0];this.lastChild=this._children[this._childNodeCount-1];for(var i=0;i<this._childNodeCount;++i){var child=this._children[i];child.index=i;child.nextSibling=i+1<this._childNodeCount?this._children[i+1]:null;child.previousSibling=i-1>=0?this._children[i-1]:null;child.parentNode=this;}}
_addAttribute(name,value){var attr={name:name,value:value,_node:this};this._attributesMap[name]=attr;this._attributes.push(attr);}
_setAttribute(name,value){var attr=this._attributesMap[name];if(attr)
attr.value=value;else
this._addAttribute(name,value);}
_removeAttribute(name){var attr=this._attributesMap[name];if(attr){this._attributes.remove(attr);delete this._attributesMap[name];}}
copyTo(targetNode,anchorNode,callback){this._agent.invoke_copyTo({nodeId:this.id,targetNodeId:targetNode.id,insertBeforeNodeId:anchorNode?anchorNode.id:undefined}).then(response=>{if(!response[Protocol.Error])
this._domModel.markUndoableState();if(callback)
callback(response[Protocol.Error]||null,response.nodeId);});}
moveTo(targetNode,anchorNode,callback){this._agent.invoke_moveTo({nodeId:this.id,targetNodeId:targetNode.id,insertBeforeNodeId:anchorNode?anchorNode.id:undefined}).then(response=>{if(!response[Protocol.Error])
this._domModel.markUndoableState();if(callback)
callback(response[Protocol.Error]||null,response.nodeId);});}
isXMLNode(){return!!this._xmlVersion;}
setMarker(name,value){if(value===null){if(!this._markers.has(name))
return;this._markers.delete(name);for(var node=this;node;node=node.parentNode)
--node._subtreeMarkerCount;for(var node=this;node;node=node.parentNode)
this._domModel.dispatchEventToListeners(SDK.DOMModel.Events.MarkersChanged,node);return;}
if(this.parentNode&&!this._markers.has(name)){for(var node=this;node;node=node.parentNode)
++node._subtreeMarkerCount;}
this._markers.set(name,value);for(var node=this;node;node=node.parentNode)
this._domModel.dispatchEventToListeners(SDK.DOMModel.Events.MarkersChanged,node);}
marker(name){return this._markers.get(name)||null;}
traverseMarkers(visitor){function traverse(node){if(!node._subtreeMarkerCount)
return;for(var marker of node._markers.keys())
visitor(node,marker);if(!node._children)
return;for(var child of node._children)
traverse(child);}
traverse(this);}
resolveURL(url){if(!url)
return url;for(var frameOwnerCandidate=this;frameOwnerCandidate;frameOwnerCandidate=frameOwnerCandidate.parentNode){if(frameOwnerCandidate.baseURL)
return Common.ParsedURL.completeURL(frameOwnerCandidate.baseURL,url);}
return null;}
highlight(mode,objectId){this._domModel.overlayModel().highlightDOMNode(this.id,mode,undefined,objectId);}
highlightForTwoSeconds(){this._domModel.overlayModel().highlightDOMNodeForTwoSeconds(this.id);}
async resolveToObject(objectGroup){var object=await this._agent.resolveNode(this.id,undefined,objectGroup);return object&&this._domModel._runtimeModel.createRemoteObject(object);}
boxModel(){return this._agent.getBoxModel(this.id);}
setAsInspectedNode(){var node=this;while(true){var ancestor=node.ancestorUserAgentShadowRoot();if(!ancestor)
break;ancestor=node.ancestorShadowHost();if(!ancestor)
break;node=ancestor;}
this._agent.setInspectedNode(node.id);}
enclosingElementOrSelf(){var node=this;if(node&&node.nodeType()===Node.TEXT_NODE&&node.parentNode)
node=node.parentNode;if(node&&node.nodeType()!==Node.ELEMENT_NODE)
node=null;return node;}
async scrollIntoView(){var node=this.enclosingElementOrSelf();var object=await node.resolveToObject('');if(object)
object.callFunction(scrollIntoView);object.release();node.highlightForTwoSeconds();function scrollIntoView(){this.scrollIntoViewIfNeeded(true);}}};SDK.DOMNode.PseudoElementNames={Before:'before',After:'after'};SDK.DOMNode.ShadowRootTypes={UserAgent:'user-agent',Open:'open',Closed:'closed'};SDK.DOMNode.Attribute;SDK.DeferredDOMNode=class{constructor(target,backendNodeId){this._domModel=target.model(SDK.DOMModel);this._backendNodeId=backendNodeId;}
resolve(callback){this.resolvePromise().then(callback);}
async resolvePromise(){if(!this._domModel)
return null;var nodeIds=await this._domModel.pushNodesByBackendIdsToFrontend(new Set([this._backendNodeId]));return nodeIds&&nodeIds.get(this._backendNodeId)||null;}
backendNodeId(){return this._backendNodeId;}
highlight(){if(this._domModel)
this._domModel.overlayModel().highlightDOMNode(undefined,undefined,this._backendNodeId);}};SDK.DOMNodeShortcut=class{constructor(target,backendNodeId,nodeType,nodeName){this.nodeType=nodeType;this.nodeName=nodeName;this.deferredNode=new SDK.DeferredDOMNode(target,backendNodeId);}};SDK.DOMDocument=class extends SDK.DOMNode{constructor(domModel,payload){super(domModel);this._init(this,false,payload);this.documentURL=payload.documentURL||'';this.baseURL=payload.baseURL||'';}};SDK.DOMModel=class extends SDK.SDKModel{constructor(target){super(target);this._agent=target.domAgent();this._idToDOMNode={};this._document=null;this._attributeLoadNodeIds=new Set();target.registerDOMDispatcher(new SDK.DOMDispatcher(this));this._runtimeModel=(target.model(SDK.RuntimeModel));this._agent.enable();}
runtimeModel(){return this._runtimeModel;}
cssModel(){return(this.target().model(SDK.CSSModel));}
overlayModel(){return(this.target().model(SDK.OverlayModel));}
static cancelSearch(){for(var domModel of SDK.targetManager.models(SDK.DOMModel))
domModel._cancelSearch();}
_scheduleMutationEvent(node){if(!this.hasEventListeners(SDK.DOMModel.Events.DOMMutated))
return;this._lastMutationId=(this._lastMutationId||0)+1;Promise.resolve().then(callObserve.bind(this,node,this._lastMutationId));function callObserve(node,mutationId){if(!this.hasEventListeners(SDK.DOMModel.Events.DOMMutated)||this._lastMutationId!==mutationId)
return;this.dispatchEventToListeners(SDK.DOMModel.Events.DOMMutated,node);}}
requestDocument(callback){if(this._document)
callback(this._document);else
this.requestDocumentPromise().then(callback);}
requestDocumentPromise(){if(this._document)
return Promise.resolve(this._document);if(this._pendingDocumentRequestPromise)
return this._pendingDocumentRequestPromise;this._pendingDocumentRequestPromise=this._agent.getDocument().then(root=>{if(root)
this._setDocument(root);delete this._pendingDocumentRequestPromise;if(!this._document)
console.error('No document');return this._document;});return this._pendingDocumentRequestPromise;}
existingDocument(){return this._document;}
async pushNodeToFrontend(objectId){await this.requestDocumentPromise();var nodeId=await this._agent.requestNode(objectId);return nodeId?this.nodeForId(nodeId):null;}
pushNodeByPathToFrontend(path){return this.requestDocumentPromise().then(()=>this._agent.pushNodeByPathToFrontend(path));}
async pushNodesByBackendIdsToFrontend(backendNodeIds){await this.requestDocumentPromise();var backendNodeIdsArray=backendNodeIds.valuesArray();var nodeIds=await this._agent.pushNodesByBackendIdsToFrontend(backendNodeIdsArray);if(!nodeIds)
return null;var map=new Map();for(var i=0;i<nodeIds.length;++i){if(nodeIds[i])
map.set(backendNodeIdsArray[i],this.nodeForId(nodeIds[i]));}
return map;}
_wrapClientCallback(callback){function wrapper(error,result){callback(error?null:result||null);}
return wrapper;}
_attributeModified(nodeId,name,value){var node=this._idToDOMNode[nodeId];if(!node)
return;node._setAttribute(name,value);this.dispatchEventToListeners(SDK.DOMModel.Events.AttrModified,{node:node,name:name});this._scheduleMutationEvent(node);}
_attributeRemoved(nodeId,name){var node=this._idToDOMNode[nodeId];if(!node)
return;node._removeAttribute(name);this.dispatchEventToListeners(SDK.DOMModel.Events.AttrRemoved,{node:node,name:name});this._scheduleMutationEvent(node);}
_inlineStyleInvalidated(nodeIds){this._attributeLoadNodeIds.addAll(nodeIds);if(!this._loadNodeAttributesTimeout)
this._loadNodeAttributesTimeout=setTimeout(this._loadNodeAttributes.bind(this),20);}
_loadNodeAttributes(){delete this._loadNodeAttributesTimeout;for(let nodeId of this._attributeLoadNodeIds){this._agent.getAttributes(nodeId).then(attributes=>{if(!attributes){return;}
var node=this._idToDOMNode[nodeId];if(!node)
return;if(node._setAttributesPayload(attributes)){this.dispatchEventToListeners(SDK.DOMModel.Events.AttrModified,{node:node,name:'style'});this._scheduleMutationEvent(node);}});}
this._attributeLoadNodeIds.clear();}
_characterDataModified(nodeId,newValue){var node=this._idToDOMNode[nodeId];node._nodeValue=newValue;this.dispatchEventToListeners(SDK.DOMModel.Events.CharacterDataModified,node);this._scheduleMutationEvent(node);}
nodeForId(nodeId){return this._idToDOMNode[nodeId]||null;}
_documentUpdated(){this._setDocument(null);}
_setDocument(payload){this._idToDOMNode={};if(payload&&'nodeId'in payload)
this._document=new SDK.DOMDocument(this,payload);else
this._document=null;this.dispatchEventToListeners(SDK.DOMModel.Events.DocumentUpdated,this);}
_setDetachedRoot(payload){if(payload.nodeName==='#document')
new SDK.DOMDocument(this,payload);else
SDK.DOMNode.create(this,null,false,payload);}
_setChildNodes(parentId,payloads){if(!parentId&&payloads.length){this._setDetachedRoot(payloads[0]);return;}
var parent=this._idToDOMNode[parentId];parent._setChildrenPayload(payloads);}
_childNodeCountUpdated(nodeId,newValue){var node=this._idToDOMNode[nodeId];node._childNodeCount=newValue;this.dispatchEventToListeners(SDK.DOMModel.Events.ChildNodeCountUpdated,node);this._scheduleMutationEvent(node);}
_childNodeInserted(parentId,prevId,payload){var parent=this._idToDOMNode[parentId];var prev=this._idToDOMNode[prevId];var node=parent._insertChild(prev,payload);this._idToDOMNode[node.id]=node;this.dispatchEventToListeners(SDK.DOMModel.Events.NodeInserted,node);this._scheduleMutationEvent(node);}
_childNodeRemoved(parentId,nodeId){var parent=this._idToDOMNode[parentId];var node=this._idToDOMNode[nodeId];parent._removeChild(node);this._unbind(node);this.dispatchEventToListeners(SDK.DOMModel.Events.NodeRemoved,{node:node,parent:parent});this._scheduleMutationEvent(node);}
_shadowRootPushed(hostId,root){var host=this._idToDOMNode[hostId];if(!host)
return;var node=SDK.DOMNode.create(this,host.ownerDocument,true,root);node.parentNode=host;this._idToDOMNode[node.id]=node;host._shadowRoots.unshift(node);this.dispatchEventToListeners(SDK.DOMModel.Events.NodeInserted,node);this._scheduleMutationEvent(node);}
_shadowRootPopped(hostId,rootId){var host=this._idToDOMNode[hostId];if(!host)
return;var root=this._idToDOMNode[rootId];if(!root)
return;host._removeChild(root);this._unbind(root);this.dispatchEventToListeners(SDK.DOMModel.Events.NodeRemoved,{node:root,parent:host});this._scheduleMutationEvent(root);}
_pseudoElementAdded(parentId,pseudoElement){var parent=this._idToDOMNode[parentId];if(!parent)
return;var node=SDK.DOMNode.create(this,parent.ownerDocument,false,pseudoElement);node.parentNode=parent;this._idToDOMNode[node.id]=node;console.assert(!parent._pseudoElements.get(node.pseudoType()));parent._pseudoElements.set(node.pseudoType(),node);this.dispatchEventToListeners(SDK.DOMModel.Events.NodeInserted,node);this._scheduleMutationEvent(node);}
_pseudoElementRemoved(parentId,pseudoElementId){var parent=this._idToDOMNode[parentId];if(!parent)
return;var pseudoElement=this._idToDOMNode[pseudoElementId];if(!pseudoElement)
return;parent._removeChild(pseudoElement);this._unbind(pseudoElement);this.dispatchEventToListeners(SDK.DOMModel.Events.NodeRemoved,{node:pseudoElement,parent:parent});this._scheduleMutationEvent(pseudoElement);}
_distributedNodesUpdated(insertionPointId,distributedNodes){var insertionPoint=this._idToDOMNode[insertionPointId];if(!insertionPoint)
return;insertionPoint._setDistributedNodePayloads(distributedNodes);this.dispatchEventToListeners(SDK.DOMModel.Events.DistributedNodesChanged,insertionPoint);this._scheduleMutationEvent(insertionPoint);}
_unbind(node){delete this._idToDOMNode[node.id];for(var i=0;node._children&&i<node._children.length;++i)
this._unbind(node._children[i]);for(var i=0;i<node._shadowRoots.length;++i)
this._unbind(node._shadowRoots[i]);var pseudoElements=node.pseudoElements();for(var value of pseudoElements.values())
this._unbind(value);if(node._templateContent)
this._unbind(node._templateContent);}
async performSearch(query,includeUserAgentShadowDOM){var response=await this._agent.invoke_performSearch({query,includeUserAgentShadowDOM});if(!response[Protocol.Error])
this._searchId=response.searchId;return response[Protocol.Error]?0:response.resultCount;}
async searchResult(index){if(!this._searchId)
return null;var nodeIds=await this._agent.getSearchResults(this._searchId,index,index+1);return nodeIds&&nodeIds.length===1?this.nodeForId(nodeIds[0]):null;}
_cancelSearch(){if(!this._searchId)
return;this._agent.discardSearchResults(this._searchId);delete this._searchId;}
classNamesPromise(nodeId){return this._agent.collectClassNamesFromSubtree(nodeId).then(classNames=>classNames||[]);}
querySelector(nodeId,selectors){return this._agent.querySelector(nodeId,selectors);}
querySelectorAll(nodeId,selectors){return this._agent.querySelectorAll(nodeId,selectors);}
markUndoableState(){this._agent.markUndoableState();}
undo(){return this._agent.undo();}
redo(){return this._agent.redo();}
nodeForLocation(x,y,includeUserAgentShadowDOM){return this._agent.getNodeForLocation(x,y,includeUserAgentShadowDOM).then(nodeId=>nodeId?this.nodeForId(nodeId):null);}
pushObjectAsNodeToFrontend(object){return object.isNode()?this.pushNodeToFrontend((object.objectId)):Promise.resolve(null);}
suspendModel(){return this._agent.disable().then(()=>this._setDocument(null));}
resumeModel(){return this._agent.enable();}};SDK.SDKModel.register(SDK.DOMModel,SDK.Target.Capability.DOM,true);SDK.DOMModel.Events={AttrModified:Symbol('AttrModified'),AttrRemoved:Symbol('AttrRemoved'),CharacterDataModified:Symbol('CharacterDataModified'),DOMMutated:Symbol('DOMMutated'),NodeInserted:Symbol('NodeInserted'),NodeRemoved:Symbol('NodeRemoved'),DocumentUpdated:Symbol('DocumentUpdated'),ChildNodeCountUpdated:Symbol('ChildNodeCountUpdated'),DistributedNodesChanged:Symbol('DistributedNodesChanged'),MarkersChanged:Symbol('MarkersChanged')};SDK.DOMDispatcher=class{constructor(domModel){this._domModel=domModel;}
documentUpdated(){this._domModel._documentUpdated();}
attributeModified(nodeId,name,value){this._domModel._attributeModified(nodeId,name,value);}
attributeRemoved(nodeId,name){this._domModel._attributeRemoved(nodeId,name);}
inlineStyleInvalidated(nodeIds){this._domModel._inlineStyleInvalidated(nodeIds);}
characterDataModified(nodeId,characterData){this._domModel._characterDataModified(nodeId,characterData);}
setChildNodes(parentId,payloads){this._domModel._setChildNodes(parentId,payloads);}
childNodeCountUpdated(nodeId,childNodeCount){this._domModel._childNodeCountUpdated(nodeId,childNodeCount);}
childNodeInserted(parentNodeId,previousNodeId,payload){this._domModel._childNodeInserted(parentNodeId,previousNodeId,payload);}
childNodeRemoved(parentNodeId,nodeId){this._domModel._childNodeRemoved(parentNodeId,nodeId);}
shadowRootPushed(hostId,root){this._domModel._shadowRootPushed(hostId,root);}
shadowRootPopped(hostId,rootId){this._domModel._shadowRootPopped(hostId,rootId);}
pseudoElementAdded(parentId,pseudoElement){this._domModel._pseudoElementAdded(parentId,pseudoElement);}
pseudoElementRemoved(parentId,pseudoElementId){this._domModel._pseudoElementRemoved(parentId,pseudoElementId);}
distributedNodesUpdated(insertionPointId,distributedNodes){this._domModel._distributedNodesUpdated(insertionPointId,distributedNodes);}};;SDK.DebuggerModel=class extends SDK.SDKModel{constructor(target){super(target);target.registerDebuggerDispatcher(new SDK.DebuggerDispatcher(this));this._agent=target.debuggerAgent();this._runtimeModel=(target.model(SDK.RuntimeModel));this._sourceMapManager=new SDK.SourceMapManager(target);this._sourceMapIdToScript=new Map();this._debuggerPausedDetails=null;this._scripts=new Map();this._scriptsBySourceURL=new Map();this._discardableScripts=[];this._breakpointResolvedEventTarget=new Common.Object();this._isPausing=false;Common.moduleSetting('pauseOnExceptionEnabled').addChangeListener(this._pauseOnExceptionStateChanged,this);Common.moduleSetting('pauseOnCaughtException').addChangeListener(this._pauseOnExceptionStateChanged,this);Common.moduleSetting('disableAsyncStackTraces').addChangeListener(this._asyncStackTracesStateChanged,this);this._fileURLToNodeJSPath=new Map();this._enableDebugger();this._stringMap=new Map();this._sourceMapManager.setEnabled(Common.moduleSetting('jsSourceMapsEnabled').get());Common.moduleSetting('jsSourceMapsEnabled').addChangeListener(event=>this._sourceMapManager.setEnabled((event.data)));}
static _sourceMapId(executionContextId,sourceURL,sourceMapURL){if(!sourceMapURL)
return null;return executionContextId+':'+sourceURL+':'+sourceMapURL;}
sourceMapManager(){return this._sourceMapManager;}
runtimeModel(){return this._runtimeModel;}
debuggerEnabled(){return!!this._debuggerEnabled;}
_enableDebugger(){if(this._debuggerEnabled)
return Promise.resolve();this._debuggerEnabled=true;var enablePromise=this._agent.enable();this._pauseOnExceptionStateChanged();this._asyncStackTracesStateChanged();this.dispatchEventToListeners(SDK.DebuggerModel.Events.DebuggerWasEnabled,this);return enablePromise;}
_disableDebugger(){if(!this._debuggerEnabled)
return Promise.resolve();this._debuggerEnabled=false;var disablePromise=this._agent.disable();this._isPausing=false;this._asyncStackTracesStateChanged();this.globalObjectCleared();this.dispatchEventToListeners(SDK.DebuggerModel.Events.DebuggerWasDisabled);return disablePromise;}
_skipAllPauses(skip){if(this._skipAllPausesTimeout){clearTimeout(this._skipAllPausesTimeout);delete this._skipAllPausesTimeout;}
this._agent.setSkipAllPauses(skip);}
skipAllPausesUntilReloadOrTimeout(timeout){if(this._skipAllPausesTimeout)
clearTimeout(this._skipAllPausesTimeout);this._agent.setSkipAllPauses(true);this._skipAllPausesTimeout=setTimeout(this._skipAllPauses.bind(this,false),timeout);}
_pauseOnExceptionStateChanged(){var state;if(!Common.moduleSetting('pauseOnExceptionEnabled').get())
state=SDK.DebuggerModel.PauseOnExceptionsState.DontPauseOnExceptions;else if(Common.moduleSetting('pauseOnCaughtException').get())
state=SDK.DebuggerModel.PauseOnExceptionsState.PauseOnAllExceptions;else
state=SDK.DebuggerModel.PauseOnExceptionsState.PauseOnUncaughtExceptions;this._agent.setPauseOnExceptions(state);}
_asyncStackTracesStateChanged(){const maxAsyncStackChainDepth=32;var enabled=!Common.moduleSetting('disableAsyncStackTraces').get()&&this._debuggerEnabled;this._agent.setAsyncCallStackDepth(enabled?maxAsyncStackChainDepth:0);}
stepInto(){this._agent.stepInto();}
stepOver(){this._agent.stepOver();}
stepOut(){this._agent.stepOut();}
scheduleStepIntoAsync(){this._agent.scheduleStepIntoAsync();}
resume(){this._agent.resume();this._isPausing=false;}
pause(){this._isPausing=true;this._skipAllPauses(false);this._agent.pause();}
setBreakpointsActive(active){this._agent.setBreakpointsActive(active);}
async setBreakpointByURL(url,lineNumber,columnNumber,condition,callback){if(this.target().isNodeJS()&&this._fileURLToNodeJSPath.has(url))
url=this._fileURLToNodeJSPath.get(url);var minColumnNumber=0;var scripts=this._scriptsBySourceURL.get(url)||[];for(var i=0,l=scripts.length;i<l;++i){var script=scripts[i];if(lineNumber===script.lineOffset)
minColumnNumber=minColumnNumber?Math.min(minColumnNumber,script.columnOffset):script.columnOffset;}
columnNumber=Math.max(columnNumber,minColumnNumber);var response=await this._agent.invoke_setBreakpointByUrl({lineNumber,url,urlRegex:undefined,columnNumber,condition});if(!callback)
return;var locations=(response.locations||[]).map(payload=>SDK.DebuggerModel.Location.fromPayload(this,payload));callback(response[Protocol.Error]?null:response.breakpointId,locations);}
setBreakpointBySourceId(rawLocation,condition,callback){this._agent.invoke_setBreakpoint({location:rawLocation.payload(),condition}).then(response=>{if(!callback)
return;if(response[Protocol.Error]||!response.actualLocation){callback(null,[]);return;}
callback(response.breakpointId,[SDK.DebuggerModel.Location.fromPayload(this,response.actualLocation)]);});}
async removeBreakpoint(breakpointId){var response=await this._agent.invoke_removeBreakpoint({breakpointId});if(response[Protocol.Error])
console.error('Failed to remove breakpoint: '+response[Protocol.Error]);}
async getPossibleBreakpoints(startLocation,endLocation,restrictToFunction){var response=await this._agent.invoke_getPossibleBreakpoints({start:startLocation.payload(),end:endLocation.payload(),restrictToFunction:restrictToFunction});if(response[Protocol.Error]||!response.locations)
return[];return response.locations.map(location=>SDK.DebuggerModel.BreakLocation.fromPayload(this,location));}
_breakpointResolved(breakpointId,location){this._breakpointResolvedEventTarget.dispatchEventToListeners(breakpointId,SDK.DebuggerModel.Location.fromPayload(this,location));}
globalObjectCleared(){this._setDebuggerPausedDetails(null);this._reset();this.dispatchEventToListeners(SDK.DebuggerModel.Events.GlobalObjectCleared,this);}
_reset(){for(var scriptWithSourceMap of this._sourceMapIdToScript.values())
this._sourceMapManager.detachSourceMap(scriptWithSourceMap);this._sourceMapIdToScript.clear();this._scripts.clear();this._scriptsBySourceURL.clear();this._stringMap.clear();this._discardableScripts=[];}
scripts(){return Array.from(this._scripts.values());}
scriptForId(scriptId){return this._scripts.get(scriptId)||null;}
scriptsForSourceURL(sourceURL){if(!sourceURL)
return[];return this._scriptsBySourceURL.get(sourceURL)||[];}
scriptsForExecutionContext(executionContext){var result=[];for(var script of this._scripts.values()){if(script.executionContextId===executionContext.id)
result.push(script);}
return result;}
setScriptSource(scriptId,newSource,callback){this._scripts.get(scriptId).editSource(newSource,this._didEditScriptSource.bind(this,scriptId,newSource,callback));}
_didEditScriptSource(scriptId,newSource,callback,error,exceptionDetails,callFrames,asyncStackTrace,needsStepIn){callback(error,exceptionDetails);if(needsStepIn){this.stepInto();return;}
if(!error&&callFrames&&callFrames.length){this._pausedScript(callFrames,this._debuggerPausedDetails.reason,this._debuggerPausedDetails.auxData,this._debuggerPausedDetails.breakpointIds,asyncStackTrace);}}
get callFrames(){return this._debuggerPausedDetails?this._debuggerPausedDetails.callFrames:null;}
debuggerPausedDetails(){return this._debuggerPausedDetails;}
_setDebuggerPausedDetails(debuggerPausedDetails){this._isPausing=false;this._debuggerPausedDetails=debuggerPausedDetails;if(this._debuggerPausedDetails){if(Runtime.experiments.isEnabled('emptySourceMapAutoStepping')&&this._beforePausedCallback){if(!this._beforePausedCallback.call(null,this._debuggerPausedDetails))
return false;}
this.dispatchEventToListeners(SDK.DebuggerModel.Events.DebuggerPaused,this);}
if(debuggerPausedDetails)
this.setSelectedCallFrame(debuggerPausedDetails.callFrames[0]);else
this.setSelectedCallFrame(null);return true;}
setBeforePausedCallback(callback){this._beforePausedCallback=callback;}
_pausedScript(callFrames,reason,auxData,breakpointIds,asyncStackTrace){var pausedDetails=new SDK.DebuggerPausedDetails(this,callFrames,reason,auxData,breakpointIds,asyncStackTrace);if(pausedDetails&&this._continueToLocationCallback){var callback=this._continueToLocationCallback;delete this._continueToLocationCallback;if(callback(pausedDetails))
return;}
if(!this._setDebuggerPausedDetails(pausedDetails))
this._agent.stepInto();}
_resumedScript(){this._setDebuggerPausedDetails(null);this.dispatchEventToListeners(SDK.DebuggerModel.Events.DebuggerResumed,this);}
_parsedScriptSource(scriptId,sourceURL,startLine,startColumn,endLine,endColumn,executionContextId,hash,executionContextAuxData,isLiveEdit,sourceMapURL,hasSourceURL,hasSyntaxError,length){var isContentScript=false;if(executionContextAuxData&&('isDefault'in executionContextAuxData))
isContentScript=!executionContextAuxData['isDefault'];if(this.target().isNodeJS()&&sourceURL&&sourceURL.startsWith('/')){var nodeJSPath=sourceURL;sourceURL=Common.ParsedURL.platformPathToURL(nodeJSPath);sourceURL=this._internString(sourceURL);this._fileURLToNodeJSPath.set(sourceURL,nodeJSPath);}else{sourceURL=this._internString(sourceURL);}
var script=new SDK.Script(this,scriptId,sourceURL,startLine,startColumn,endLine,endColumn,executionContextId,this._internString(hash),isContentScript,isLiveEdit,sourceMapURL,hasSourceURL,length);this._registerScript(script);if(!hasSyntaxError)
this.dispatchEventToListeners(SDK.DebuggerModel.Events.ParsedScriptSource,script);else
this.dispatchEventToListeners(SDK.DebuggerModel.Events.FailedToParseScriptSource,script);var sourceMapId=SDK.DebuggerModel._sourceMapId(script.executionContextId,script.sourceURL,script.sourceMapURL);if(sourceMapId&&!hasSyntaxError){var previousScript=this._sourceMapIdToScript.get(sourceMapId);if(previousScript)
this._sourceMapManager.detachSourceMap(previousScript);this._sourceMapIdToScript.set(sourceMapId,script);this._sourceMapManager.attachSourceMap(script,script.sourceURL,script.sourceMapURL);}
var isDiscardable=hasSyntaxError&&script.isAnonymousScript();if(isDiscardable){this._discardableScripts.push(script);this._collectDiscardedScripts();}
return script;}
setSourceMapURL(script,newSourceMapURL){var sourceMapId=SDK.DebuggerModel._sourceMapId(script.executionContextId,script.sourceURL,script.sourceMapURL);if(sourceMapId&&this._sourceMapIdToScript.get(sourceMapId)===script)
this._sourceMapIdToScript.delete(sourceMapId);this._sourceMapManager.detachSourceMap(script);script.sourceMapURL=newSourceMapURL;sourceMapId=SDK.DebuggerModel._sourceMapId(script.executionContextId,script.sourceURL,script.sourceMapURL);if(!sourceMapId)
return;this._sourceMapIdToScript.set(sourceMapId,script);this._sourceMapManager.attachSourceMap(script,script.sourceURL,script.sourceMapURL);}
executionContextDestroyed(executionContext){var sourceMapIds=Array.from(this._sourceMapIdToScript.keys());for(var sourceMapId of sourceMapIds){var script=this._sourceMapIdToScript.get(sourceMapId);if(script.executionContextId===executionContext.id){this._sourceMapIdToScript.delete(sourceMapId);this._sourceMapManager.detachSourceMap(script);}}}
_registerScript(script){this._scripts.set(script.scriptId,script);if(script.isAnonymousScript())
return;var scripts=this._scriptsBySourceURL.get(script.sourceURL);if(!scripts){scripts=[];this._scriptsBySourceURL.set(script.sourceURL,scripts);}
scripts.push(script);}
_unregisterScript(script){console.assert(script.isAnonymousScript());this._scripts.delete(script.scriptId);}
_collectDiscardedScripts(){if(this._discardableScripts.length<1000)
return;var scriptsToDiscard=this._discardableScripts.splice(0,100);for(var script of scriptsToDiscard){this._unregisterScript(script);this.dispatchEventToListeners(SDK.DebuggerModel.Events.DiscardedAnonymousScriptSource,script);}}
createRawLocation(script,lineNumber,columnNumber){return new SDK.DebuggerModel.Location(this,script.scriptId,lineNumber,columnNumber);}
createRawLocationByURL(sourceURL,lineNumber,columnNumber){var closestScript=null;var scripts=this._scriptsBySourceURL.get(sourceURL)||[];for(var i=0,l=scripts.length;i<l;++i){var script=scripts[i];if(!closestScript)
closestScript=script;if(script.lineOffset>lineNumber||(script.lineOffset===lineNumber&&script.columnOffset>columnNumber))
continue;if(script.endLine<lineNumber||(script.endLine===lineNumber&&script.endColumn<=columnNumber))
continue;closestScript=script;break;}
return closestScript?new SDK.DebuggerModel.Location(this,closestScript.scriptId,lineNumber,columnNumber):null;}
createRawLocationByScriptId(scriptId,lineNumber,columnNumber){var script=this.scriptForId(scriptId);return script?this.createRawLocation(script,lineNumber,columnNumber):null;}
createRawLocationsByStackTrace(stackTrace){var frames=[];while(stackTrace){for(var frame of stackTrace.callFrames)
frames.push(frame);stackTrace=stackTrace.parent;}
var rawLocations=[];for(var frame of frames){var rawLocation=this.createRawLocationByScriptId(frame.scriptId,frame.lineNumber,frame.columnNumber);if(rawLocation)
rawLocations.push(rawLocation);}
return rawLocations;}
isPaused(){return!!this.debuggerPausedDetails();}
isPausing(){return this._isPausing;}
setSelectedCallFrame(callFrame){if(this._selectedCallFrame===callFrame)
return;this._selectedCallFrame=callFrame;this.dispatchEventToListeners(SDK.DebuggerModel.Events.CallFrameSelected,this);}
selectedCallFrame(){return this._selectedCallFrame;}
evaluateOnSelectedCallFrame(options){return this.selectedCallFrame().evaluate(options);}
functionDetailsPromise(remoteObject){return remoteObject.getAllPropertiesPromise(false,false).then(buildDetails.bind(this));function buildDetails(response){if(!response)
return null;var location=null;if(response.internalProperties){for(var prop of response.internalProperties){if(prop.name==='[[FunctionLocation]]')
location=prop.value;}}
var functionName=null;if(response.properties){for(var prop of response.properties){if(prop.name==='name'&&prop.value&&prop.value.type==='string')
functionName=prop.value;if(prop.name==='displayName'&&prop.value&&prop.value.type==='string'){functionName=prop.value;break;}}}
var debuggerLocation=null;if(location){debuggerLocation=this.createRawLocationByScriptId(location.value.scriptId,location.value.lineNumber,location.value.columnNumber);}
return{location:debuggerLocation,functionName:functionName?functionName.value:''};}}
async setVariableValue(scopeNumber,variableName,newValue,callFrameId){var response=await this._agent.invoke_setVariableValue({scopeNumber,variableName,newValue,callFrameId});var error=response[Protocol.Error];if(error)
console.error(error);return error;}
addBreakpointListener(breakpointId,listener,thisObject){this._breakpointResolvedEventTarget.addEventListener(breakpointId,listener,thisObject);}
removeBreakpointListener(breakpointId,listener,thisObject){this._breakpointResolvedEventTarget.removeEventListener(breakpointId,listener,thisObject);}
async setBlackboxPatterns(patterns){var response=await this._agent.invoke_setBlackboxPatterns({patterns});var error=response[Protocol.Error];if(error)
console.error(error);return!error;}
dispose(){this._sourceMapManager.dispose();Common.moduleSetting('pauseOnExceptionEnabled').removeChangeListener(this._pauseOnExceptionStateChanged,this);Common.moduleSetting('pauseOnCaughtException').removeChangeListener(this._pauseOnExceptionStateChanged,this);Common.moduleSetting('disableAsyncStackTraces').removeChangeListener(this._asyncStackTracesStateChanged,this);}
async suspendModel(){await this._disableDebugger();}
async resumeModel(){await this._enableDebugger();}
_internString(string){if(!this._stringMap.has(string))
this._stringMap.set(string,string);return this._stringMap.get(string);}};SDK.SDKModel.register(SDK.DebuggerModel,SDK.Target.Capability.JS,true);SDK.DebuggerModel.FunctionDetails;SDK.DebuggerModel.PauseOnExceptionsState={DontPauseOnExceptions:'none',PauseOnAllExceptions:'all',PauseOnUncaughtExceptions:'uncaught'};SDK.DebuggerModel.Events={DebuggerWasEnabled:Symbol('DebuggerWasEnabled'),DebuggerWasDisabled:Symbol('DebuggerWasDisabled'),DebuggerPaused:Symbol('DebuggerPaused'),DebuggerResumed:Symbol('DebuggerResumed'),ParsedScriptSource:Symbol('ParsedScriptSource'),FailedToParseScriptSource:Symbol('FailedToParseScriptSource'),DiscardedAnonymousScriptSource:Symbol('DiscardedAnonymousScriptSource'),GlobalObjectCleared:Symbol('GlobalObjectCleared'),CallFrameSelected:Symbol('CallFrameSelected'),ConsoleCommandEvaluatedInSelectedCallFrame:Symbol('ConsoleCommandEvaluatedInSelectedCallFrame')};SDK.DebuggerModel.BreakReason={DOM:'DOM',EventListener:'EventListener',XHR:'XHR',Exception:'exception',PromiseRejection:'promiseRejection',Assert:'assert',DebugCommand:'debugCommand',OOM:'OOM',Other:'other'};SDK.DebuggerModel.BreakLocationType={Return:'return',Call:'call',DebuggerStatement:'debuggerStatement'};SDK.DebuggerEventTypes={JavaScriptPause:0,JavaScriptBreakpoint:1,NativeBreakpoint:2};SDK.DebuggerModel.ContinueToLocationTargetCallFrames={Any:'any',Current:'current'};SDK.DebuggerDispatcher=class{constructor(debuggerModel){this._debuggerModel=debuggerModel;}
paused(callFrames,reason,auxData,breakpointIds,asyncStackTrace){this._debuggerModel._pausedScript(callFrames,reason,auxData,breakpointIds||[],asyncStackTrace);}
resumed(){this._debuggerModel._resumedScript();}
scriptParsed(scriptId,sourceURL,startLine,startColumn,endLine,endColumn,executionContextId,hash,executionContextAuxData,isLiveEdit,sourceMapURL,hasSourceURL,isModule,length){this._debuggerModel._parsedScriptSource(scriptId,sourceURL,startLine,startColumn,endLine,endColumn,executionContextId,hash,executionContextAuxData,!!isLiveEdit,sourceMapURL,!!hasSourceURL,false,length||0);}
scriptFailedToParse(scriptId,sourceURL,startLine,startColumn,endLine,endColumn,executionContextId,hash,executionContextAuxData,sourceMapURL,hasSourceURL,isModule,length){this._debuggerModel._parsedScriptSource(scriptId,sourceURL,startLine,startColumn,endLine,endColumn,executionContextId,hash,executionContextAuxData,false,sourceMapURL,!!hasSourceURL,true,length||0);}
breakpointResolved(breakpointId,location){this._debuggerModel._breakpointResolved(breakpointId,location);}};SDK.DebuggerModel.Location=class{constructor(debuggerModel,scriptId,lineNumber,columnNumber){this.debuggerModel=debuggerModel;this.scriptId=scriptId;this.lineNumber=lineNumber;this.columnNumber=columnNumber||0;}
static fromPayload(debuggerModel,payload){return new SDK.DebuggerModel.Location(debuggerModel,payload.scriptId,payload.lineNumber,payload.columnNumber);}
payload(){return{scriptId:this.scriptId,lineNumber:this.lineNumber,columnNumber:this.columnNumber};}
script(){return this.debuggerModel.scriptForId(this.scriptId);}
continueToLocation(pausedCallback){if(pausedCallback)
this.debuggerModel._continueToLocationCallback=this._paused.bind(this,pausedCallback);this.debuggerModel._agent.continueToLocation(this.payload(),SDK.DebuggerModel.ContinueToLocationTargetCallFrames.Current);}
_paused(pausedCallback,debuggerPausedDetails){var location=debuggerPausedDetails.callFrames[0].location();if(location.scriptId===this.scriptId&&location.lineNumber===this.lineNumber&&location.columnNumber===this.columnNumber){pausedCallback();return true;}
return false;}
id(){return this.debuggerModel.target().id()+':'+this.scriptId+':'+this.lineNumber+':'+this.columnNumber;}};SDK.DebuggerModel.BreakLocation=class extends SDK.DebuggerModel.Location{constructor(debuggerModel,scriptId,lineNumber,columnNumber,type){super(debuggerModel,scriptId,lineNumber,columnNumber);if(type)
this.type=type;}
static fromPayload(debuggerModel,payload){return new SDK.DebuggerModel.BreakLocation(debuggerModel,payload.scriptId,payload.lineNumber,payload.columnNumber,payload.type);}};SDK.DebuggerModel.CallFrame=class{constructor(debuggerModel,script,payload){this.debuggerModel=debuggerModel;this._script=script;this._payload=payload;this._location=SDK.DebuggerModel.Location.fromPayload(debuggerModel,payload.location);this._scopeChain=[];this._localScope=null;for(var i=0;i<payload.scopeChain.length;++i){var scope=new SDK.DebuggerModel.Scope(this,i);this._scopeChain.push(scope);if(scope.type()===Protocol.Debugger.ScopeType.Local)
this._localScope=scope;}
if(payload.functionLocation)
this._functionLocation=SDK.DebuggerModel.Location.fromPayload(debuggerModel,payload.functionLocation);}
static fromPayloadArray(debuggerModel,callFrames){var result=[];for(var i=0;i<callFrames.length;++i){var callFrame=callFrames[i];var script=debuggerModel.scriptForId(callFrame.location.scriptId);if(script)
result.push(new SDK.DebuggerModel.CallFrame(debuggerModel,script,callFrame));}
return result;}
get script(){return this._script;}
get id(){return this._payload.callFrameId;}
scopeChain(){return this._scopeChain;}
localScope(){return this._localScope;}
thisObject(){return this._payload.this?this.debuggerModel._runtimeModel.createRemoteObject(this._payload.this):null;}
returnValue(){return this._payload.returnValue?this.debuggerModel._runtimeModel.createRemoteObject(this._payload.returnValue):null;}
get functionName(){return this._payload.functionName;}
location(){return this._location;}
functionLocation(){return this._functionLocation||null;}
async evaluate(options){var response=await this.debuggerModel._agent.invoke_evaluateOnCallFrame({callFrameId:this.id,expression:options.expression,objectGroup:options.objectGroup,includeCommandLineAPI:options.includeCommandLineAPI,silent:options.silent,returnByValue:options.returnByValue,generatePreview:options.generatePreview,throwOnSideEffect:false});var error=response[Protocol.Error];if(error){console.error(error);return{error:error};}
return{object:this.debuggerModel.runtimeModel().createRemoteObject(response.result),exceptionDetails:response.exceptionDetails};}
async restart(){var response=await this.debuggerModel._agent.invoke_restartFrame({callFrameId:this._payload.callFrameId});if(!response[Protocol.Error])
this.debuggerModel.stepInto();}};SDK.DebuggerModel.Scope=class{constructor(callFrame,ordinal){this._callFrame=callFrame;this._payload=callFrame._payload.scopeChain[ordinal];this._type=this._payload.type;this._name=this._payload.name;this._ordinal=ordinal;this._startLocation=this._payload.startLocation?SDK.DebuggerModel.Location.fromPayload(callFrame.debuggerModel,this._payload.startLocation):null;this._endLocation=this._payload.endLocation?SDK.DebuggerModel.Location.fromPayload(callFrame.debuggerModel,this._payload.endLocation):null;}
callFrame(){return this._callFrame;}
type(){return this._type;}
typeName(){switch(this._type){case Protocol.Debugger.ScopeType.Local:return Common.UIString('Local');case Protocol.Debugger.ScopeType.Closure:return Common.UIString('Closure');case Protocol.Debugger.ScopeType.Catch:return Common.UIString('Catch');case Protocol.Debugger.ScopeType.Block:return Common.UIString('Block');case Protocol.Debugger.ScopeType.Script:return Common.UIString('Script');case Protocol.Debugger.ScopeType.With:return Common.UIString('With Block');case Protocol.Debugger.ScopeType.Global:return Common.UIString('Global');case Protocol.Debugger.ScopeType.Module:return Common.UIString('Module');}
return'';}
name(){return this._name;}
startLocation(){return this._startLocation;}
endLocation(){return this._endLocation;}
object(){if(this._object)
return this._object;var runtimeModel=this._callFrame.debuggerModel._runtimeModel;var declarativeScope=this._type!==Protocol.Debugger.ScopeType.With&&this._type!==Protocol.Debugger.ScopeType.Global;if(declarativeScope){this._object=runtimeModel.createScopeRemoteObject(this._payload.object,new SDK.ScopeRef(this._ordinal,this._callFrame.id));}else{this._object=runtimeModel.createRemoteObject(this._payload.object);}
return this._object;}
description(){var declarativeScope=this._type!==Protocol.Debugger.ScopeType.With&&this._type!==Protocol.Debugger.ScopeType.Global;return declarativeScope?'':(this._payload.object.description||'');}};SDK.DebuggerPausedDetails=class{constructor(debuggerModel,callFrames,reason,auxData,breakpointIds,asyncStackTrace){this.debuggerModel=debuggerModel;this.callFrames=SDK.DebuggerModel.CallFrame.fromPayloadArray(debuggerModel,callFrames);this.reason=reason;this.auxData=auxData;this.breakpointIds=breakpointIds;if(asyncStackTrace)
this.asyncStackTrace=this._cleanRedundantFrames(asyncStackTrace);}
exception(){if(this.reason!==SDK.DebuggerModel.BreakReason.Exception&&this.reason!==SDK.DebuggerModel.BreakReason.PromiseRejection)
return null;return this.debuggerModel._runtimeModel.createRemoteObject((this.auxData));}
_cleanRedundantFrames(asyncStackTrace){var stack=asyncStackTrace;var previous=null;while(stack){if(stack.description==='async function'&&stack.callFrames.length)
stack.callFrames.shift();if(previous&&(!stack.callFrames.length&&!stack.promiseCreationFrame))
previous.parent=stack.parent;else
previous=stack;stack=stack.parent;}
return asyncStackTrace;}};;SDK.EmulationModel=class extends SDK.SDKModel{constructor(target){super(target);this._emulationAgent=target.emulationAgent();this._pageAgent=target.pageAgent();this._deviceOrientationAgent=target.deviceOrientationAgent();this._cssModel=target.model(SDK.CSSModel);this._overlayModel=target.model(SDK.OverlayModel);if(this._overlayModel)
this._overlayModel.addEventListener(SDK.OverlayModel.Events.InspectModeWillBeToggled,this._updateTouch,this);var disableJavascriptSetting=Common.settings.moduleSetting('javaScriptDisabled');disableJavascriptSetting.addChangeListener(()=>this._emulationAgent.setScriptExecutionDisabled(disableJavascriptSetting.get()));if(disableJavascriptSetting.get())
this._emulationAgent.setScriptExecutionDisabled(true);var mediaSetting=Common.moduleSetting('emulatedCSSMedia');mediaSetting.addChangeListener(()=>this._emulateCSSMedia(mediaSetting.get()));if(mediaSetting.get())
this._emulateCSSMedia(mediaSetting.get());this._touchEnabled=false;this._touchMobile=false;this._customTouchEnabled=false;this._touchConfiguration={enabled:false,configuration:'mobile',scriptId:''};}
supportsDeviceEmulation(){return this.target().hasAllCapabilities(SDK.Target.Capability.DeviceEmulation);}
resetPageScaleFactor(){return this._emulationAgent.resetPageScaleFactor();}
emulateDevice(metrics){if(metrics)
return this._emulationAgent.invoke_setDeviceMetricsOverride(metrics);else
return this._emulationAgent.clearDeviceMetricsOverride();}
overlayModel(){return this._overlayModel;}
emulateGeolocation(geolocation){if(!geolocation){this._emulationAgent.clearGeolocationOverride();return;}
if(geolocation.error){this._emulationAgent.setGeolocationOverride();}else{this._emulationAgent.setGeolocationOverride(geolocation.latitude,geolocation.longitude,SDK.EmulationModel.Geolocation.DefaultMockAccuracy);}}
emulateDeviceOrientation(deviceOrientation){if(deviceOrientation){this._deviceOrientationAgent.setDeviceOrientationOverride(deviceOrientation.alpha,deviceOrientation.beta,deviceOrientation.gamma);}else{this._deviceOrientationAgent.clearDeviceOrientationOverride();}}
_emulateCSSMedia(media){this._emulationAgent.setEmulatedMedia(media);if(this._cssModel)
this._cssModel.mediaQueryResultChanged();}
setCPUThrottlingRate(rate){this._emulationAgent.setCPUThrottlingRate(rate);}
emulateTouch(enabled,mobile){this._touchEnabled=enabled;this._touchMobile=mobile;this._updateTouch();}
overrideEmulateTouch(enabled){this._customTouchEnabled=enabled;this._updateTouch();}
_updateTouch(){var configuration={enabled:this._touchEnabled,configuration:this._touchMobile?'mobile':'desktop',};if(this._customTouchEnabled)
configuration={enabled:true,configuration:'mobile'};if(this._overlayModel&&this._overlayModel.inspectModeEnabled())
configuration={enabled:false,configuration:'mobile'};if(!this._touchConfiguration.enabled&&!configuration.enabled)
return;if(this._touchConfiguration.enabled&&configuration.enabled&&this._touchConfiguration.configuration===configuration.configuration)
return;this._touchConfiguration=configuration;this._emulationAgent.setTouchEmulationEnabled(configuration.enabled,1);this._emulationAgent.setEmitTouchEventsForMouse(configuration.enabled,configuration.configuration);}};SDK.SDKModel.register(SDK.EmulationModel,SDK.Target.Capability.Emulation,true);SDK.EmulationModel.Geolocation=class{constructor(latitude,longitude,error){this.latitude=latitude;this.longitude=longitude;this.error=error;}
static parseSetting(value){if(value){var splitError=value.split(':');if(splitError.length===2){var splitPosition=splitError[0].split('@');if(splitPosition.length===2){return new SDK.EmulationModel.Geolocation(parseFloat(splitPosition[0]),parseFloat(splitPosition[1]),splitError[1]);}}}
return new SDK.EmulationModel.Geolocation(0,0,false);}
static parseUserInput(latitudeString,longitudeString,errorStatus){if(!latitudeString&&!longitudeString)
return null;var isLatitudeValid=SDK.EmulationModel.Geolocation.latitudeValidator(latitudeString);var isLongitudeValid=SDK.EmulationModel.Geolocation.longitudeValidator(longitudeString);if(!isLatitudeValid&&!isLongitudeValid)
return null;var latitude=isLatitudeValid?parseFloat(latitudeString):-1;var longitude=isLongitudeValid?parseFloat(longitudeString):-1;return new SDK.EmulationModel.Geolocation(latitude,longitude,!!errorStatus);}
static latitudeValidator(value){var numValue=parseFloat(value);return/^([+-]?[\d]+(\.\d+)?|[+-]?\.\d+)$/.test(value)&&numValue>=-90&&numValue<=90;}
static longitudeValidator(value){var numValue=parseFloat(value);return/^([+-]?[\d]+(\.\d+)?|[+-]?\.\d+)$/.test(value)&&numValue>=-180&&numValue<=180;}
toSetting(){return(typeof this.latitude==='number'&&typeof this.longitude==='number'&&typeof this.error==='string')?this.latitude+'@'+this.longitude+':'+this.error:'';}};SDK.EmulationModel.Geolocation.DefaultMockAccuracy=150;SDK.EmulationModel.DeviceOrientation=class{constructor(alpha,beta,gamma){this.alpha=alpha;this.beta=beta;this.gamma=gamma;}
static parseSetting(value){if(value){var jsonObject=JSON.parse(value);return new SDK.EmulationModel.DeviceOrientation(jsonObject.alpha,jsonObject.beta,jsonObject.gamma);}
return new SDK.EmulationModel.DeviceOrientation(0,0,0);}
static parseUserInput(alphaString,betaString,gammaString){if(!alphaString&&!betaString&&!gammaString)
return null;var isAlphaValid=SDK.EmulationModel.DeviceOrientation.validator(alphaString);var isBetaValid=SDK.EmulationModel.DeviceOrientation.validator(betaString);var isGammaValid=SDK.EmulationModel.DeviceOrientation.validator(gammaString);if(!isAlphaValid&&!isBetaValid&&!isGammaValid)
return null;var alpha=isAlphaValid?parseFloat(alphaString):-1;var beta=isBetaValid?parseFloat(betaString):-1;var gamma=isGammaValid?parseFloat(gammaString):-1;return new SDK.EmulationModel.DeviceOrientation(alpha,beta,gamma);}
static validator(value){return/^([+-]?[\d]+(\.\d+)?|[+-]?\.\d+)$/.test(value);}
toSetting(){return JSON.stringify(this);}};;SDK.SnapshotWithRect;SDK.Layer=function(){};SDK.Layer.prototype={id(){},parentId(){},parent(){},isRoot(){},children(){},addChild(child){},node(){},nodeForSelfOrAncestor(){},offsetX(){},offsetY(){},width(){},height(){},transform(){},quad(){},anchorPoint(){},invisible(){},paintCount(){},lastPaintRect(){},scrollRects(){},stickyPositionConstraint(){},gpuMemoryUsage(){},requestCompositingReasons(){},drawsContent(){},snapshots(){}};SDK.Layer.ScrollRectType={NonFastScrollable:'NonFastScrollable',TouchEventHandler:'TouchEventHandler',WheelEventHandler:'WheelEventHandler',RepaintsOnScroll:'RepaintsOnScroll'};SDK.Layer.StickyPositionConstraint=class{constructor(layerTree,constraint){this._stickyBoxRect=constraint.stickyBoxRect;this._containingBlockRect=constraint.containingBlockRect;this._nearestLayerShiftingStickyBox=null;if(layerTree&&constraint.nearestLayerShiftingStickyBox)
this._nearestLayerShiftingStickyBox=layerTree.layerById(constraint.nearestLayerShiftingStickyBox);this._nearestLayerShiftingContainingBlock=null;if(layerTree&&constraint.nearestLayerShiftingContainingBlock)
this._nearestLayerShiftingContainingBlock=layerTree.layerById(constraint.nearestLayerShiftingContainingBlock);}
stickyBoxRect(){return this._stickyBoxRect;}
containingBlockRect(){return this._containingBlockRect;}
nearestLayerShiftingStickyBox(){return this._nearestLayerShiftingStickyBox;}
nearestLayerShiftingContainingBlock(){return this._nearestLayerShiftingContainingBlock;}};SDK.LayerTreeBase=class{constructor(target){this._target=target;this._domModel=target?target.model(SDK.DOMModel):null;this._layersById={};this._root=null;this._contentRoot=null;this._backendNodeIdToNode=new Map();}
target(){return this._target;}
root(){return this._root;}
setRoot(root){this._root=root;}
contentRoot(){return this._contentRoot;}
setContentRoot(contentRoot){this._contentRoot=contentRoot;}
forEachLayer(callback,root){if(!root){root=this.root();if(!root)
return false;}
return callback(root)||root.children().some(this.forEachLayer.bind(this,callback));}
layerById(id){return this._layersById[id]||null;}
async resolveBackendNodeIds(requestedNodeIds){if(!requestedNodeIds.size||!this._domModel)
return;var nodesMap=await this._domModel.pushNodesByBackendIdsToFrontend(requestedNodeIds);if(!nodesMap)
return;for(var nodeId of nodesMap.keysArray())
this._backendNodeIdToNode.set(nodeId,nodesMap.get(nodeId)||null);}
backendNodeIdToNode(){return this._backendNodeIdToNode;}
setViewportSize(viewportSize){this._viewportSize=viewportSize;}
viewportSize(){return this._viewportSize;}
_nodeForId(id){return this._domModel?this._domModel.nodeForId(id):null;}};;SDK.LogModel=class extends SDK.SDKModel{constructor(target){super(target);target.registerLogDispatcher(this);this._logAgent=target.logAgent();this._logAgent.enable();if(!Host.isUnderTest()){this._logAgent.startViolationsReport([{name:'longTask',threshold:200},{name:'longLayout',threshold:30},{name:'blockedEvent',threshold:100},{name:'blockedParser',threshold:-1},{name:'handler',threshold:150},{name:'recurringHandler',threshold:50},{name:'discouragedAPIUse',threshold:-1}]);}}
entryAdded(payload){this.dispatchEventToListeners(SDK.LogModel.Events.EntryAdded,{logModel:this,entry:payload});}
requestClear(){this._logAgent.clear();}};SDK.SDKModel.register(SDK.LogModel,SDK.Target.Capability.Log,true);SDK.LogModel.Events={EntryAdded:Symbol('EntryAdded')};;SDK.ServiceWorkerManager=class extends SDK.SDKModel{constructor(target){super(target);target.registerServiceWorkerDispatcher(new SDK.ServiceWorkerDispatcher(this));this._lastAnonymousTargetId=0;this._agent=target.serviceWorkerAgent();this._registrations=new Map();this.enable();this._forceUpdateSetting=Common.settings.createSetting('serviceWorkerUpdateOnReload',false);if(this._forceUpdateSetting.get())
this._forceUpdateSettingChanged();this._forceUpdateSetting.addChangeListener(this._forceUpdateSettingChanged,this);new SDK.ServiceWorkerContextNamer(target,this);}
enable(){if(this._enabled)
return;this._enabled=true;this._agent.enable();}
disable(){if(!this._enabled)
return;this._enabled=false;this._registrations.clear();this._agent.disable();}
registrations(){return this._registrations;}
findVersion(versionId){for(var registration of this.registrations().values()){var version=registration.versions.get(versionId);if(version)
return version;}
return null;}
deleteRegistration(registrationId){var registration=this._registrations.get(registrationId);if(!registration)
return;if(registration._isRedundant()){this._registrations.delete(registrationId);this.dispatchEventToListeners(SDK.ServiceWorkerManager.Events.RegistrationDeleted,registration);return;}
registration._deleting=true;for(var version of registration.versions.values())
this.stopWorker(version.id);this._unregister(registration.scopeURL);}
updateRegistration(registrationId){var registration=this._registrations.get(registrationId);if(!registration)
return;this._agent.updateRegistration(registration.scopeURL);}
deliverPushMessage(registrationId,data){var registration=this._registrations.get(registrationId);if(!registration)
return;var origin=Common.ParsedURL.extractOrigin(registration.scopeURL);this._agent.deliverPushMessage(origin,registrationId,data);}
dispatchSyncEvent(registrationId,tag,lastChance){var registration=this._registrations.get(registrationId);if(!registration)
return;var origin=Common.ParsedURL.extractOrigin(registration.scopeURL);this._agent.dispatchSyncEvent(origin,registrationId,tag,lastChance);}
_unregister(scope){this._agent.unregister(scope);}
startWorker(scope){this._agent.startWorker(scope);}
skipWaiting(scope){this._agent.skipWaiting(scope);}
stopWorker(versionId){this._agent.stopWorker(versionId);}
inspectWorker(versionId){this._agent.inspectWorker(versionId);}
_workerRegistrationUpdated(registrations){for(var payload of registrations){var registration=this._registrations.get(payload.registrationId);if(!registration){registration=new SDK.ServiceWorkerRegistration(payload);this._registrations.set(payload.registrationId,registration);this.dispatchEventToListeners(SDK.ServiceWorkerManager.Events.RegistrationUpdated,registration);continue;}
registration._update(payload);if(registration._shouldBeRemoved()){this._registrations.delete(registration.id);this.dispatchEventToListeners(SDK.ServiceWorkerManager.Events.RegistrationDeleted,registration);}else{this.dispatchEventToListeners(SDK.ServiceWorkerManager.Events.RegistrationUpdated,registration);}}}
_workerVersionUpdated(versions){var registrations=new Set();for(var payload of versions){var registration=this._registrations.get(payload.registrationId);if(!registration)
continue;registration._updateVersion(payload);registrations.add(registration);}
for(var registration of registrations){if(registration._shouldBeRemoved()){this._registrations.delete(registration.id);this.dispatchEventToListeners(SDK.ServiceWorkerManager.Events.RegistrationDeleted,registration);}else{this.dispatchEventToListeners(SDK.ServiceWorkerManager.Events.RegistrationUpdated,registration);}}}
_workerErrorReported(payload){var registration=this._registrations.get(payload.registrationId);if(!registration)
return;registration.errors.push(payload);this.dispatchEventToListeners(SDK.ServiceWorkerManager.Events.RegistrationErrorAdded,{registration:registration,error:payload});}
forceUpdateOnReloadSetting(){return this._forceUpdateSetting;}
_forceUpdateSettingChanged(){this._agent.setForceUpdateOnPageLoad(this._forceUpdateSetting.get());}};SDK.SDKModel.register(SDK.ServiceWorkerManager,SDK.Target.Capability.Target|SDK.Target.Capability.Browser,true);SDK.ServiceWorkerManager.Events={RegistrationUpdated:Symbol('RegistrationUpdated'),RegistrationErrorAdded:Symbol('RegistrationErrorAdded'),RegistrationDeleted:Symbol('RegistrationDeleted')};SDK.ServiceWorkerDispatcher=class{constructor(manager){this._manager=manager;}
workerRegistrationUpdated(registrations){this._manager._workerRegistrationUpdated(registrations);}
workerVersionUpdated(versions){this._manager._workerVersionUpdated(versions);}
workerErrorReported(errorMessage){this._manager._workerErrorReported(errorMessage);}};SDK.ServiceWorkerVersion=class{constructor(registration,payload){this.registration=registration;this._update(payload);}
_update(payload){this.id=payload.versionId;this.scriptURL=payload.scriptURL;var parsedURL=new Common.ParsedURL(payload.scriptURL);this.securityOrigin=parsedURL.securityOrigin();this.runningStatus=payload.runningStatus;this.status=payload.status;this.scriptLastModified=payload.scriptLastModified;this.scriptResponseTime=payload.scriptResponseTime;this.controlledClients=[];for(var i=0;i<payload.controlledClients.length;++i)
this.controlledClients.push(payload.controlledClients[i]);this.targetId=payload.targetId||null;}
isStartable(){return!this.registration.isDeleted&&this.isActivated()&&this.isStopped();}
isStoppedAndRedundant(){return this.runningStatus===Protocol.ServiceWorker.ServiceWorkerVersionRunningStatus.Stopped&&this.status===Protocol.ServiceWorker.ServiceWorkerVersionStatus.Redundant;}
isStopped(){return this.runningStatus===Protocol.ServiceWorker.ServiceWorkerVersionRunningStatus.Stopped;}
isStarting(){return this.runningStatus===Protocol.ServiceWorker.ServiceWorkerVersionRunningStatus.Starting;}
isRunning(){return this.runningStatus===Protocol.ServiceWorker.ServiceWorkerVersionRunningStatus.Running;}
isStopping(){return this.runningStatus===Protocol.ServiceWorker.ServiceWorkerVersionRunningStatus.Stopping;}
isNew(){return this.status===Protocol.ServiceWorker.ServiceWorkerVersionStatus.New;}
isInstalling(){return this.status===Protocol.ServiceWorker.ServiceWorkerVersionStatus.Installing;}
isInstalled(){return this.status===Protocol.ServiceWorker.ServiceWorkerVersionStatus.Installed;}
isActivating(){return this.status===Protocol.ServiceWorker.ServiceWorkerVersionStatus.Activating;}
isActivated(){return this.status===Protocol.ServiceWorker.ServiceWorkerVersionStatus.Activated;}
isRedundant(){return this.status===Protocol.ServiceWorker.ServiceWorkerVersionStatus.Redundant;}
mode(){if(this.isNew()||this.isInstalling())
return SDK.ServiceWorkerVersion.Modes.Installing;else if(this.isInstalled())
return SDK.ServiceWorkerVersion.Modes.Waiting;else if(this.isActivating()||this.isActivated())
return SDK.ServiceWorkerVersion.Modes.Active;return SDK.ServiceWorkerVersion.Modes.Redundant;}};SDK.ServiceWorkerVersion.Modes={Installing:'installing',Waiting:'waiting',Active:'active',Redundant:'redundant'};SDK.ServiceWorkerRegistration=class{constructor(payload){this._update(payload);this.versions=new Map();this._deleting=false;this.errors=[];}
_update(payload){this._fingerprint=Symbol('fingerprint');this.id=payload.registrationId;this.scopeURL=payload.scopeURL;var parsedURL=new Common.ParsedURL(payload.scopeURL);this.securityOrigin=parsedURL.securityOrigin();this.isDeleted=payload.isDeleted;this.forceUpdateOnPageLoad=payload.forceUpdateOnPageLoad;}
fingerprint(){return this._fingerprint;}
versionsByMode(){var result=new Map();for(var version of this.versions.values())
result.set(version.mode(),version);return result;}
_updateVersion(payload){this._fingerprint=Symbol('fingerprint');var version=this.versions.get(payload.versionId);if(!version){version=new SDK.ServiceWorkerVersion(this,payload);this.versions.set(payload.versionId,version);return version;}
version._update(payload);return version;}
_isRedundant(){for(var version of this.versions.values()){if(!version.isStoppedAndRedundant())
return false;}
return true;}
_shouldBeRemoved(){return this._isRedundant()&&(!this.errors.length||this._deleting);}
canBeRemoved(){return this.isDeleted||this._deleting;}
clearErrors(){this._fingerprint=Symbol('fingerprint');this.errors=[];}};SDK.ServiceWorkerContextNamer=class{constructor(target,serviceWorkerManager){this._target=target;this._serviceWorkerManager=serviceWorkerManager;this._versionByTargetId=new Map();serviceWorkerManager.addEventListener(SDK.ServiceWorkerManager.Events.RegistrationUpdated,this._registrationsUpdated,this);serviceWorkerManager.addEventListener(SDK.ServiceWorkerManager.Events.RegistrationDeleted,this._registrationsUpdated,this);SDK.targetManager.addModelListener(SDK.RuntimeModel,SDK.RuntimeModel.Events.ExecutionContextCreated,this._executionContextCreated,this);}
_registrationsUpdated(event){this._versionByTargetId.clear();var registrations=this._serviceWorkerManager.registrations().valuesArray();for(var registration of registrations){var versions=registration.versions.valuesArray();for(var version of versions){if(version.targetId)
this._versionByTargetId.set(version.targetId,version);}}
this._updateAllContextLabels();}
_executionContextCreated(event){var executionContext=(event.data);var serviceWorkerTargetId=this._serviceWorkerTargetIdForWorker(executionContext.target());if(!serviceWorkerTargetId)
return;this._updateContextLabel(executionContext,this._versionByTargetId.get(serviceWorkerTargetId)||null);}
_serviceWorkerTargetIdForWorker(target){var parent=target.parentTarget();if(!parent||parent.parentTarget()!==this._target)
return null;return parent.id();}
_updateAllContextLabels(){for(var target of SDK.targetManager.targets()){var serviceWorkerTargetId=this._serviceWorkerTargetIdForWorker(target);if(!serviceWorkerTargetId)
continue;var version=this._versionByTargetId.get(serviceWorkerTargetId)||null;var runtimeModel=target.model(SDK.RuntimeModel);var executionContexts=runtimeModel?runtimeModel.executionContexts():[];for(var context of executionContexts)
this._updateContextLabel(context,version);}}
_updateContextLabel(context,version){if(!version){context.setLabel('');return;}
var parsedUrl=context.origin.asParsedURL();var label=parsedUrl?parsedUrl.lastPathComponentWithFragment():context.name;context.setLabel(label+' #'+version.id+' ('+version.status+')');}};;SDK.TracingManagerClient=function(){};SDK.TracingManagerClient.prototype={traceEventsCollected(events){},tracingComplete(){},tracingBufferUsage(usage){},eventsRetrievalProgress(progress){}};SDK.TracingManager=class extends SDK.SDKModel{constructor(target){super(target);this._tracingAgent=target.tracingAgent();target.registerTracingDispatcher(new SDK.TracingDispatcher(this));this._activeClient=null;this._eventBufferSize=0;this._eventsRetrieved=0;}
_bufferUsage(usage,eventCount,percentFull){this._eventBufferSize=eventCount;this._activeClient.tracingBufferUsage(usage||percentFull||0);}
_eventsCollected(events){this._activeClient.traceEventsCollected(events);this._eventsRetrieved+=events.length;if(!this._eventBufferSize)
return;if(this._eventsRetrieved>this._eventBufferSize)
this._eventsRetrieved=this._eventBufferSize;this._activeClient.eventsRetrievalProgress(this._eventsRetrieved/this._eventBufferSize);}
_tracingComplete(){this._eventBufferSize=0;this._eventsRetrieved=0;this._activeClient.tracingComplete();this._activeClient=null;this._finishing=false;}
start(client,categoryFilter,options){if(this._activeClient)
throw new Error('Tracing is already started');var bufferUsageReportingIntervalMs=500;this._activeClient=client;return this._tracingAgent.start(categoryFilter,options,bufferUsageReportingIntervalMs,SDK.TracingManager.TransferMode.ReportEvents);}
stop(){if(!this._activeClient)
throw new Error('Tracing is not started');if(this._finishing)
throw new Error('Tracing is already being stopped');this._finishing=true;this._tracingAgent.end();}};SDK.SDKModel.register(SDK.TracingManager,SDK.Target.Capability.Tracing,false);SDK.TracingManager.EventPayload;SDK.TracingManager.TransferMode={ReportEvents:'ReportEvents',ReturnAsStream:'ReturnAsStream'};SDK.TracingDispatcher=class{constructor(tracingManager){this._tracingManager=tracingManager;}
bufferUsage(usage,eventCount,percentFull){this._tracingManager._bufferUsage(usage,eventCount,percentFull);}
dataCollected(data){this._tracingManager._eventsCollected(data);}
tracingComplete(){this._tracingManager._tracingComplete();}};;SDK.TracingModel=class{constructor(backingStorage){this._backingStorage=backingStorage;this._firstWritePending=true;this._processById=new Map();this._processByName=new Map();this._minimumRecordTime=0;this._maximumRecordTime=0;this._devToolsMetadataEvents=[];this._asyncEvents=[];this._openAsyncEvents=new Map();this._openNestableAsyncEvents=new Map();this._profileGroups=new Map();this._parsedCategories=new Map();}
static isNestableAsyncPhase(phase){return phase==='b'||phase==='e'||phase==='n';}
static isAsyncBeginPhase(phase){return phase==='S'||phase==='b';}
static isAsyncPhase(phase){return SDK.TracingModel.isNestableAsyncPhase(phase)||phase==='S'||phase==='T'||phase==='F'||phase==='p';}
static isFlowPhase(phase){return phase==='s'||phase==='t'||phase==='f';}
static isTopLevelEvent(event){return event.hasCategory(SDK.TracingModel.TopLevelEventCategory)||event.hasCategory(SDK.TracingModel.DevToolsMetadataEventCategory)&&event.name==='Program';}
static _extractId(payload){var scope=payload.scope||'';if(typeof payload.id2==='undefined')
return scope&&payload.id?`${scope}@${payload.id}`:payload.id;var id2=payload.id2;if(typeof id2==='object'&&('global'in id2)!==('local'in id2)){return typeof id2['global']!=='undefined'?`:${scope}:${id2['global']}`:`:${scope}:${payload.pid}:${id2['local']}`;}
console.error(`Unexpected id2 field at ${payload.ts / 1000}, one and only one of 'local' and 'global' should be present.`);}
static browserMainThread(tracingModel){var processes=tracingModel.sortedProcesses();if(!processes.length)
return null;var browserProcesses=[];var crRendererMainThreads=[];for(var process of processes){if(process.name().toLowerCase().endsWith('browser'))
browserProcesses.push(process);crRendererMainThreads.push(...process.sortedThreads().filter(t=>t.name()==='CrBrowserMain'));}
if(crRendererMainThreads.length===1)
return crRendererMainThreads[0];if(browserProcesses.length===1)
return browserProcesses[0].threadByName('CrBrowserMain');var tracingStartedInBrowser=tracingModel.devToolsMetadataEvents().filter(e=>e.name==='TracingStartedInBrowser');if(tracingStartedInBrowser.length===1)
return tracingStartedInBrowser[0].thread;Common.console.error('Failed to find browser main thread in trace, some timeline features may be unavailable');return null;}
devToolsMetadataEvents(){return this._devToolsMetadataEvents;}
addEvents(events){for(var i=0;i<events.length;++i)
this._addEvent(events[i]);}
tracingComplete(){this._processPendingAsyncEvents();this._backingStorage.appendString(this._firstWritePending?'[]':']');this._backingStorage.finishWriting();this._firstWritePending=false;for(var process of this._processById.values()){for(var thread of process._threads.values())
thread.tracingComplete();}}
dispose(){if(!this._firstWritePending)
this._backingStorage.reset();}
adjustTime(offset){this._minimumRecordTime+=offset;this._maximumRecordTime+=offset;for(const process of this._processById.values()){for(const thread of process._threads.values()){for(const event of thread.events()){event.startTime+=offset;if(typeof event.endTime==='number')
event.endTime+=offset;}
for(const event of thread.asyncEvents()){event.startTime+=offset;if(typeof event.endTime==='number')
event.endTime+=offset;}}}}
_addEvent(payload){var process=this._processById.get(payload.pid);if(!process){process=new SDK.TracingModel.Process(this,payload.pid);this._processById.set(payload.pid,process);}
const phase=SDK.TracingModel.Phase;const eventsDelimiter=',\n';this._backingStorage.appendString(this._firstWritePending?'[':eventsDelimiter);this._firstWritePending=false;var stringPayload=JSON.stringify(payload);var isAccessible=payload.ph===phase.SnapshotObject;var backingStorage=null;var keepStringsLessThan=10000;if(isAccessible&&stringPayload.length>keepStringsLessThan)
backingStorage=this._backingStorage.appendAccessibleString(stringPayload);else
this._backingStorage.appendString(stringPayload);const timestamp=payload.ts/1000;if(timestamp&&(!this._minimumRecordTime||timestamp<this._minimumRecordTime)&&(payload.ph===phase.Begin||payload.ph===phase.Complete||payload.ph===phase.Instant))
this._minimumRecordTime=timestamp;const endTimeStamp=(payload.ts+(payload.dur||0))/1000;this._maximumRecordTime=Math.max(this._maximumRecordTime,endTimeStamp);const event=process._addEvent(payload);if(!event)
return;if(payload.ph===phase.Sample){this._addSampleEvent(event);return;}
if(SDK.TracingModel.isAsyncPhase(payload.ph))
this._asyncEvents.push(event);event._setBackingStorage(backingStorage);if(event.hasCategory(SDK.TracingModel.DevToolsMetadataEventCategory))
this._devToolsMetadataEvents.push(event);if(payload.ph!==phase.Metadata)
return;switch(payload.name){case SDK.TracingModel.MetadataEvent.ProcessSortIndex:process._setSortIndex(payload.args['sort_index']);break;case SDK.TracingModel.MetadataEvent.ProcessName:var processName=payload.args['name'];process._setName(processName);this._processByName.set(processName,process);break;case SDK.TracingModel.MetadataEvent.ThreadSortIndex:process.threadById(payload.tid)._setSortIndex(payload.args['sort_index']);break;case SDK.TracingModel.MetadataEvent.ThreadName:process.threadById(payload.tid)._setName(payload.args['name']);break;}}
_addSampleEvent(event){var group=this._profileGroups.get(event.id);if(group)
group._addChild(event);else
this._profileGroups.set(event.id,new SDK.TracingModel.ProfileEventsGroup(event));}
profileGroup(id){return this._profileGroups.get(id)||null;}
minimumRecordTime(){return this._minimumRecordTime;}
maximumRecordTime(){return this._maximumRecordTime;}
sortedProcesses(){return SDK.TracingModel.NamedObject._sort(this._processById.valuesArray());}
processByName(name){return this._processByName.get(name);}
threadByName(processName,threadName){var process=this.processByName(processName);return process&&process.threadByName(threadName);}
_processPendingAsyncEvents(){this._asyncEvents.stableSort(SDK.TracingModel.Event.compareStartTime);for(var i=0;i<this._asyncEvents.length;++i){var event=this._asyncEvents[i];if(SDK.TracingModel.isNestableAsyncPhase(event.phase))
this._addNestableAsyncEvent(event);else
this._addAsyncEvent(event);}
this._asyncEvents=[];this._closeOpenAsyncEvents();}
_closeOpenAsyncEvents(){for(var event of this._openAsyncEvents.values()){event.setEndTime(this._maximumRecordTime);event.steps[0].setEndTime(this._maximumRecordTime);}
this._openAsyncEvents.clear();for(var eventStack of this._openNestableAsyncEvents.values()){while(eventStack.length)
eventStack.pop().setEndTime(this._maximumRecordTime);}
this._openNestableAsyncEvents.clear();}
_addNestableAsyncEvent(event){var phase=SDK.TracingModel.Phase;var key=event.categoriesString+'.'+event.id;var openEventsStack=this._openNestableAsyncEvents.get(key);switch(event.phase){case phase.NestableAsyncBegin:if(!openEventsStack){openEventsStack=[];this._openNestableAsyncEvents.set(key,openEventsStack);}
var asyncEvent=new SDK.TracingModel.AsyncEvent(event);openEventsStack.push(asyncEvent);event.thread._addAsyncEvent(asyncEvent);break;case phase.NestableAsyncInstant:if(openEventsStack&&openEventsStack.length)
openEventsStack.peekLast()._addStep(event);break;case phase.NestableAsyncEnd:if(!openEventsStack||!openEventsStack.length)
break;var top=openEventsStack.pop();if(top.name!==event.name){console.error(`Begin/end event mismatch for nestable async event, ${top.name} vs. ${event.name}, key: ${key}`);break;}
top._addStep(event);}}
_addAsyncEvent(event){var phase=SDK.TracingModel.Phase;var key=event.categoriesString+'.'+event.name+'.'+event.id;var asyncEvent=this._openAsyncEvents.get(key);if(event.phase===phase.AsyncBegin){if(asyncEvent){console.error(`Event ${event.name} has already been started`);return;}
asyncEvent=new SDK.TracingModel.AsyncEvent(event);this._openAsyncEvents.set(key,asyncEvent);event.thread._addAsyncEvent(asyncEvent);return;}
if(!asyncEvent){return;}
if(event.phase===phase.AsyncEnd){asyncEvent._addStep(event);this._openAsyncEvents.delete(key);return;}
if(event.phase===phase.AsyncStepInto||event.phase===phase.AsyncStepPast){var lastStep=asyncEvent.steps.peekLast();if(lastStep.phase!==phase.AsyncBegin&&lastStep.phase!==event.phase){console.assert(false,'Async event step phase mismatch: '+lastStep.phase+' at '+lastStep.startTime+' vs. '+
event.phase+' at '+event.startTime);return;}
asyncEvent._addStep(event);return;}
console.assert(false,'Invalid async event phase');}
backingStorage(){return this._backingStorage;}
_parsedCategoriesForString(str){var parsedCategories=this._parsedCategories.get(str);if(!parsedCategories){parsedCategories=new Set(str.split(','));this._parsedCategories.set(str,parsedCategories);}
return parsedCategories;}};SDK.TracingModel.Phase={Begin:'B',End:'E',Complete:'X',Instant:'I',AsyncBegin:'S',AsyncStepInto:'T',AsyncStepPast:'p',AsyncEnd:'F',NestableAsyncBegin:'b',NestableAsyncEnd:'e',NestableAsyncInstant:'n',FlowBegin:'s',FlowStep:'t',FlowEnd:'f',Metadata:'M',Counter:'C',Sample:'P',CreateObject:'N',SnapshotObject:'O',DeleteObject:'D'};SDK.TracingModel.MetadataEvent={ProcessSortIndex:'process_sort_index',ProcessName:'process_name',ThreadSortIndex:'thread_sort_index',ThreadName:'thread_name'};SDK.TracingModel.TopLevelEventCategory='toplevel';SDK.TracingModel.DevToolsMetadataEventCategory='disabled-by-default-devtools.timeline';SDK.TracingModel.DevToolsTimelineEventCategory='disabled-by-default-devtools.timeline';SDK.TracingModel.FrameLifecycleEventCategory='cc,devtools';SDK.BackingStorage=function(){};SDK.BackingStorage.prototype={appendString(string){},appendAccessibleString(string){},finishWriting(){},reset(){}};SDK.TracingModel.Event=class{constructor(categories,name,phase,startTime,thread){this.categoriesString=categories;this._parsedCategories=thread._model._parsedCategoriesForString(categories);this.name=name;this.phase=phase;this.startTime=startTime;this.thread=thread;this.args={};this.selfTime=0;}
static fromPayload(payload,thread){var event=new SDK.TracingModel.Event(payload.cat,payload.name,(payload.ph),payload.ts/1000,thread);if(payload.args)
event.addArgs(payload.args);else
console.error('Missing mandatory event argument \'args\' at '+payload.ts/1000);if(typeof payload.dur==='number')
event.setEndTime((payload.ts+payload.dur)/1000);var id=SDK.TracingModel._extractId(payload);if(typeof id!=='undefined')
event.id=id;if(payload.bind_id)
event.bind_id=payload.bind_id;return event;}
static compareStartTime(a,b){return a.startTime-b.startTime;}
static compareStartAndEndTime(a,b){return a.startTime-b.startTime||(b.endTime!==undefined&&a.endTime!==undefined&&b.endTime-a.endTime)||0;}
static orderedCompareStartTime(a,b){return a.startTime-b.startTime||a.ordinal-b.ordinal||-1;}
hasCategory(categoryName){return this._parsedCategories.has(categoryName);}
setEndTime(endTime){if(endTime<this.startTime){console.assert(false,'Event out of order: '+this.name);return;}
this.endTime=endTime;this.duration=endTime-this.startTime;}
addArgs(args){for(var name in args){if(name in this.args)
console.error('Same argument name ('+name+') is used for begin and end phases of '+this.name);this.args[name]=args[name];}}
_complete(endEvent){if(endEvent.args)
this.addArgs(endEvent.args);else
console.error('Missing mandatory event argument \'args\' at '+endEvent.startTime);this.setEndTime(endEvent.startTime);}
_setBackingStorage(backingStorage){}};SDK.TracingModel.ObjectSnapshot=class extends SDK.TracingModel.Event{constructor(category,name,startTime,thread){super(category,name,SDK.TracingModel.Phase.SnapshotObject,startTime,thread);this._backingStorage=null;this.id;this._objectPromise=null;}
static fromPayload(payload,thread){var snapshot=new SDK.TracingModel.ObjectSnapshot(payload.cat,payload.name,payload.ts/1000,thread);var id=SDK.TracingModel._extractId(payload);if(typeof id!=='undefined')
snapshot.id=id;if(!payload.args||!payload.args['snapshot']){console.error('Missing mandatory \'snapshot\' argument at '+payload.ts/1000);return snapshot;}
if(payload.args)
snapshot.addArgs(payload.args);return snapshot;}
requestObject(callback){var snapshot=this.args['snapshot'];if(snapshot){callback(snapshot);return;}
this._backingStorage().then(onRead,callback.bind(null,null));function onRead(result){if(!result){callback(null);return;}
try{var payload=JSON.parse(result);callback(payload['args']['snapshot']);}catch(e){Common.console.error('Malformed event data in backing storage');callback(null);}}}
objectPromise(){if(!this._objectPromise)
this._objectPromise=new Promise(this.requestObject.bind(this));return this._objectPromise;}
_setBackingStorage(backingStorage){if(!backingStorage)
return;this._backingStorage=backingStorage;this.args={};}};SDK.TracingModel.AsyncEvent=class extends SDK.TracingModel.Event{constructor(startEvent){super(startEvent.categoriesString,startEvent.name,startEvent.phase,startEvent.startTime,startEvent.thread);this.addArgs(startEvent.args);this.steps=[startEvent];}
_addStep(event){this.steps.push(event);if(event.phase===SDK.TracingModel.Phase.AsyncEnd||event.phase===SDK.TracingModel.Phase.NestableAsyncEnd){this.setEndTime(event.startTime);this.steps[0].setEndTime(event.startTime);}}};SDK.TracingModel.ProfileEventsGroup=class{constructor(event){this.children=[event];}
_addChild(event){this.children.push(event);}};SDK.TracingModel.NamedObject=class{constructor(model,id){this._model=model;this._id=id;this._name='';this._sortIndex=0;}
static _sort(array){function comparator(a,b){return a._sortIndex!==b._sortIndex?a._sortIndex-b._sortIndex:a.name().localeCompare(b.name());}
return array.sort(comparator);}
_setName(name){this._name=name;}
name(){return this._name;}
_setSortIndex(sortIndex){this._sortIndex=sortIndex;}};SDK.TracingModel.Process=class extends SDK.TracingModel.NamedObject{constructor(model,id){super(model,id);this._threads=new Map();this._threadByName=new Map();}
id(){return this._id;}
threadById(id){var thread=this._threads.get(id);if(!thread){thread=new SDK.TracingModel.Thread(this,id);this._threads.set(id,thread);}
return thread;}
threadByName(name){return this._threadByName.get(name)||null;}
_setThreadByName(name,thread){this._threadByName.set(name,thread);}
_addEvent(payload){return this.threadById(payload.tid)._addEvent(payload);}
sortedThreads(){return SDK.TracingModel.NamedObject._sort(this._threads.valuesArray());}};SDK.TracingModel.Thread=class extends SDK.TracingModel.NamedObject{constructor(process,id){super(process._model,id);this._process=process;this._events=[];this._asyncEvents=[];this._lastTopLevelEvent=null;}
tracingComplete(){this._asyncEvents.stableSort(SDK.TracingModel.Event.compareStartAndEndTime);this._events.stableSort(SDK.TracingModel.Event.compareStartTime);var phases=SDK.TracingModel.Phase;var stack=[];for(var i=0;i<this._events.length;++i){var e=this._events[i];e.ordinal=i;switch(e.phase){case phases.End:this._events[i]=null;if(!stack.length)
continue;var top=stack.pop();if(top.name!==e.name||top.categoriesString!==e.categoriesString){console.error('B/E events mismatch at '+top.startTime+' ('+top.name+') vs. '+e.startTime+' ('+e.name+')');}else{top._complete(e);}
break;case phases.Begin:stack.push(e);break;}}
while(stack.length)
stack.pop().setEndTime(this._model.maximumRecordTime());this._events.remove(null,false);}
_addEvent(payload){var event=payload.ph===SDK.TracingModel.Phase.SnapshotObject?SDK.TracingModel.ObjectSnapshot.fromPayload(payload,this):SDK.TracingModel.Event.fromPayload(payload,this);if(SDK.TracingModel.isTopLevelEvent(event)){if(this._lastTopLevelEvent&&this._lastTopLevelEvent.endTime>event.startTime)
return null;this._lastTopLevelEvent=event;}
this._events.push(event);return event;}
_addAsyncEvent(asyncEvent){this._asyncEvents.push(asyncEvent);}
_setName(name){super._setName(name);this._process._setThreadByName(name,this);}
id(){return this._id;}
process(){return this._process;}
events(){return this._events;}
asyncEvents(){return this._asyncEvents;}};;SDK.OverlayModel=class extends SDK.SDKModel{constructor(target){super(target);this._domModel=(target.model(SDK.DOMModel));target.registerOverlayDispatcher(this);this._overlayAgent=target.overlayAgent();this._overlayAgent.enable();this._overlayAgent.setShowViewportSizeOnResize(true);this._debuggerModel=target.model(SDK.DebuggerModel);if(this._debuggerModel){Common.moduleSetting('disablePausedStateOverlay').addChangeListener(this._updatePausedInDebuggerMessage,this);this._debuggerModel.addEventListener(SDK.DebuggerModel.Events.DebuggerPaused,this._updatePausedInDebuggerMessage,this);this._debuggerModel.addEventListener(SDK.DebuggerModel.Events.DebuggerResumed,this._updatePausedInDebuggerMessage,this);this._debuggerModel.addEventListener(SDK.DebuggerModel.Events.GlobalObjectCleared,this._updatePausedInDebuggerMessage,this);}
this._inspectModeEnabled=false;this._hideHighlightTimeout=null;this._defaultHighlighter=new SDK.OverlayModel.DefaultHighlighter(this);this._highlighter=this._defaultHighlighter;this._showPaintRectsSetting=Common.moduleSetting('showPaintRects');this._showPaintRectsSetting.addChangeListener(()=>this._overlayAgent.setShowPaintRects(this._showPaintRectsSetting.get()));if(this._showPaintRectsSetting.get())
this._overlayAgent.setShowPaintRects(true);this._showDebugBordersSetting=Common.moduleSetting('showDebugBorders');this._showDebugBordersSetting.addChangeListener(()=>this._overlayAgent.setShowDebugBorders(this._showDebugBordersSetting.get()));if(this._showDebugBordersSetting.get())
this._overlayAgent.setShowDebugBorders(true);this._showFPSCounterSetting=Common.moduleSetting('showFPSCounter');this._showFPSCounterSetting.addChangeListener(()=>this._overlayAgent.setShowFPSCounter(this._showFPSCounterSetting.get()));if(this._showFPSCounterSetting.get())
this._overlayAgent.setShowFPSCounter(true);this._showScrollBottleneckRectsSetting=Common.moduleSetting('showScrollBottleneckRects');this._showScrollBottleneckRectsSetting.addChangeListener(()=>this._overlayAgent.setShowScrollBottleneckRects(this._showScrollBottleneckRectsSetting.get()));if(this._showScrollBottleneckRectsSetting.get())
this._overlayAgent.setShowScrollBottleneckRects(true);}
static highlightObjectAsDOMNode(object){var domModel=object.runtimeModel().target().model(SDK.DOMModel);if(domModel)
domModel.overlayModel().highlightDOMNode(undefined,undefined,undefined,object.objectId);}
static hideDOMNodeHighlight(){for(var overlayModel of SDK.targetManager.models(SDK.OverlayModel))
overlayModel.highlightDOMNode(0);}
static muteHighlight(){SDK.OverlayModel.hideDOMNodeHighlight();SDK.OverlayModel._highlightDisabled=true;}
static unmuteHighlight(){SDK.OverlayModel._highlightDisabled=false;}
suspendModel(){return this._overlayAgent.setSuspended(true);}
resumeModel(){return this._overlayAgent.setSuspended(false);}
setShowViewportSizeOnResize(show){this._overlayAgent.setShowViewportSizeOnResize(show);}
_updatePausedInDebuggerMessage(){var message=this._debuggerModel.isPaused()&&!Common.moduleSetting('disablePausedStateOverlay').get()?Common.UIString('Paused in debugger'):undefined;this._overlayAgent.setPausedInDebuggerMessage(message);}
setHighlighter(highlighter){this._highlighter=highlighter||this._defaultHighlighter;}
async setInspectMode(mode){await this._domModel.requestDocumentPromise();this._inspectModeEnabled=mode!==Protocol.Overlay.InspectMode.None;this.dispatchEventToListeners(SDK.OverlayModel.Events.InspectModeWillBeToggled,this);this._highlighter.setInspectMode(mode,this._buildHighlightConfig());}
inspectModeEnabled(){return this._inspectModeEnabled;}
highlightDOMNode(nodeId,mode,backendNodeId,objectId){this.highlightDOMNodeWithConfig(nodeId,{mode:mode},backendNodeId,objectId);}
highlightDOMNodeWithConfig(nodeId,config,backendNodeId,objectId){if(SDK.OverlayModel._highlightDisabled)
return;config=config||{mode:'all',showInfo:undefined,selectors:undefined};if(this._hideHighlightTimeout){clearTimeout(this._hideHighlightTimeout);this._hideHighlightTimeout=null;}
var highlightConfig=this._buildHighlightConfig(config.mode);if(typeof config.showInfo!=='undefined')
highlightConfig.showInfo=config.showInfo;if(typeof config.selectors!=='undefined')
highlightConfig.selectorList=config.selectors;this._highlighter.highlightDOMNode(this._domModel.nodeForId(nodeId||0),highlightConfig,backendNodeId,objectId);}
highlightDOMNodeForTwoSeconds(nodeId){this.highlightDOMNode(nodeId);this._hideHighlightTimeout=setTimeout(()=>this.highlightDOMNode(0),2000);}
highlightFrame(frameId){if(SDK.OverlayModel._highlightDisabled)
return;this._highlighter.highlightFrame(frameId);}
_buildHighlightConfig(mode){mode=mode||'all';var showRulers=Common.moduleSetting('showMetricsRulers').get();var highlightConfig={showInfo:mode==='all',showRulers:showRulers,showExtensionLines:showRulers};if(mode==='all'||mode==='content')
highlightConfig.contentColor=Common.Color.PageHighlight.Content.toProtocolRGBA();if(mode==='all'||mode==='padding')
highlightConfig.paddingColor=Common.Color.PageHighlight.Padding.toProtocolRGBA();if(mode==='all'||mode==='border')
highlightConfig.borderColor=Common.Color.PageHighlight.Border.toProtocolRGBA();if(mode==='all'||mode==='margin')
highlightConfig.marginColor=Common.Color.PageHighlight.Margin.toProtocolRGBA();if(mode==='all'){highlightConfig.eventTargetColor=Common.Color.PageHighlight.EventTarget.toProtocolRGBA();highlightConfig.shapeColor=Common.Color.PageHighlight.Shape.toProtocolRGBA();highlightConfig.shapeMarginColor=Common.Color.PageHighlight.ShapeMargin.toProtocolRGBA();highlightConfig.displayAsMaterial=true;}
if(mode==='all')
highlightConfig.cssGridColor=Common.Color.PageHighlight.CssGrid.toProtocolRGBA();return highlightConfig;}
nodeHighlightRequested(nodeId){var node=this._domModel.nodeForId(nodeId);if(node)
this.dispatchEventToListeners(SDK.OverlayModel.Events.HighlightNodeRequested,node);}
inspectNodeRequested(backendNodeId){var deferredNode=new SDK.DeferredDOMNode(this.target(),backendNodeId);this.dispatchEventToListeners(SDK.OverlayModel.Events.InspectNodeRequested,deferredNode);}
screenshotRequested(viewport){this.dispatchEventToListeners(SDK.OverlayModel.Events.ScreenshotRequested,viewport);}};SDK.SDKModel.register(SDK.OverlayModel,SDK.Target.Capability.DOM,true);SDK.OverlayModel.Events={InspectModeWillBeToggled:Symbol('InspectModeWillBeToggled'),HighlightNodeRequested:Symbol('HighlightNodeRequested'),InspectNodeRequested:Symbol('InspectNodeRequested'),ScreenshotRequested:Symbol('ScreenshotRequested'),};SDK.OverlayModel.Highlighter=function(){};SDK.OverlayModel.Highlighter.prototype={highlightDOMNode(node,config,backendNodeId,objectId){},setInspectMode(mode,config){},highlightFrame(frameId){}};SDK.OverlayModel.DefaultHighlighter=class{constructor(model){this._model=model;}
highlightDOMNode(node,config,backendNodeId,objectId){if(objectId||node||backendNodeId){this._model._overlayAgent.highlightNode(config,(objectId||backendNodeId)?undefined:node.id,backendNodeId,objectId);}else{this._model._overlayAgent.hideHighlight();}}
setInspectMode(mode,config){return this._model._overlayAgent.setInspectMode(mode,config);}
highlightFrame(frameId){this._model._overlayAgent.highlightFrame(frameId,Common.Color.PageHighlight.Content.toProtocolRGBA(),Common.Color.PageHighlight.ContentOutline.toProtocolRGBA());}};;SDK.RuntimeModel=class extends SDK.SDKModel{constructor(target){super(target);this._agent=target.runtimeAgent();this.target().registerRuntimeDispatcher(new SDK.RuntimeDispatcher(this));this._agent.enable();this._executionContextById=new Map();this._executionContextComparator=SDK.ExecutionContext.comparator;if(Common.moduleSetting('customFormatters').get())
this._agent.setCustomObjectFormatterEnabled(true);Common.moduleSetting('customFormatters').addChangeListener(this._customFormattersStateChanged.bind(this));}
static wrapObjectLiteralExpressionIfNeeded(code){if(!(/^\s*\{/.test(code)&&/\}\s*$/.test(code)))
return code;var parse=(async()=>0).constructor;try{parse('return '+code+';');var wrappedCode='('+code+')';parse(wrappedCode);return wrappedCode;}catch(e){return code;}}
debuggerModel(){return(this.target().model(SDK.DebuggerModel));}
heapProfilerModel(){return(this.target().model(SDK.HeapProfilerModel));}
executionContexts(){return this._executionContextById.valuesArray().sort(this.executionContextComparator());}
setExecutionContextComparator(comparator){this._executionContextComparator=comparator;}
executionContextComparator(){return this._executionContextComparator;}
defaultExecutionContext(){for(var context of this.executionContexts()){if(context.isDefault)
return context;}
return null;}
executionContext(id){return this._executionContextById.get(id)||null;}
_executionContextCreated(context){var data=context.auxData||{isDefault:true};var executionContext=new SDK.ExecutionContext(this,context.id,context.name,context.origin,data['isDefault'],data['frameId']);this._executionContextById.set(executionContext.id,executionContext);this.dispatchEventToListeners(SDK.RuntimeModel.Events.ExecutionContextCreated,executionContext);}
_executionContextDestroyed(executionContextId){var executionContext=this._executionContextById.get(executionContextId);if(!executionContext)
return;this.debuggerModel().executionContextDestroyed(executionContext);this._executionContextById.delete(executionContextId);this.dispatchEventToListeners(SDK.RuntimeModel.Events.ExecutionContextDestroyed,executionContext);}
fireExecutionContextOrderChanged(){this.dispatchEventToListeners(SDK.RuntimeModel.Events.ExecutionContextOrderChanged,this);}
_executionContextsCleared(){this.debuggerModel().globalObjectCleared();var contexts=this.executionContexts();this._executionContextById.clear();for(var i=0;i<contexts.length;++i)
this.dispatchEventToListeners(SDK.RuntimeModel.Events.ExecutionContextDestroyed,contexts[i]);}
createRemoteObject(payload){console.assert(typeof payload==='object','Remote object payload should only be an object');return new SDK.RemoteObjectImpl(this,payload.objectId,payload.type,payload.subtype,payload.value,payload.unserializableValue,payload.description,payload.preview,payload.customPreview);}
createScopeRemoteObject(payload,scopeRef){return new SDK.ScopeRemoteObject(this,payload.objectId,scopeRef,payload.type,payload.subtype,payload.value,payload.unserializableValue,payload.description,payload.preview);}
createRemoteObjectFromPrimitiveValue(value){var type=typeof value;var unserializableValue=undefined;if(typeof value==='number'){var description=String(value);if(value===0&&1/value<0)
unserializableValue=Protocol.Runtime.UnserializableValue.Negative0;if(description==='NaN')
unserializableValue=Protocol.Runtime.UnserializableValue.NaN;if(description==='Infinity')
unserializableValue=Protocol.Runtime.UnserializableValue.Infinity;if(description==='-Infinity')
unserializableValue=Protocol.Runtime.UnserializableValue.NegativeInfinity;if(typeof unserializableValue!=='undefined')
value=undefined;}
return new SDK.RemoteObjectImpl(this,undefined,type,undefined,value,unserializableValue);}
createRemotePropertyFromPrimitiveValue(name,value){return new SDK.RemoteObjectProperty(name,this.createRemoteObjectFromPrimitiveValue(value));}
discardConsoleEntries(){this._agent.discardConsoleEntries();}
releaseObjectGroup(objectGroupName){this._agent.releaseObjectGroup(objectGroupName);}
runIfWaitingForDebugger(){this._agent.runIfWaitingForDebugger();}
_customFormattersStateChanged(event){var enabled=(event.data);this._agent.setCustomObjectFormatterEnabled(enabled);}
async compileScript(expression,sourceURL,persistScript,executionContextId){var response=await this._agent.invoke_compileScript({expression:expression,sourceURL:sourceURL,persistScript:persistScript,executionContextId:executionContextId});if(response[Protocol.Error]){console.error(response[Protocol.Error]);return null;}
return{scriptId:response.scriptId,exceptionDetails:response.exceptionDetails};}
async runScript(scriptId,executionContextId,objectGroup,silent,includeCommandLineAPI,returnByValue,generatePreview,awaitPromise){var response=await this._agent.invoke_runScript({scriptId,executionContextId,objectGroup,silent,includeCommandLineAPI,returnByValue,generatePreview,awaitPromise});var error=response[Protocol.Error];if(error){console.error(error);return{error:error};}
return{object:this.createRemoteObject(response.result),exceptionDetails:response.exceptionDetails};}
_inspectRequested(payload,hints){var object=this.createRemoteObject(payload);if(hints.copyToClipboard){this._copyRequested(object);return;}
if(object.isNode()){Common.Revealer.revealPromise(object).then(object.release.bind(object));return;}
if(object.type==='function'){SDK.RemoteFunction.objectAsFunction(object).targetFunctionDetails().then(didGetDetails);return;}
function didGetDetails(response){object.release();if(!response||!response.location)
return;Common.Revealer.reveal(response.location);}
object.release();}
_copyRequested(object){if(!object.objectId){InspectorFrontendHost.copyText(object.value);return;}
object.callFunctionJSON(toStringForClipboard,[{value:object.subtype}],InspectorFrontendHost.copyText.bind(InspectorFrontendHost));function toStringForClipboard(subtype){if(subtype==='node')
return this.outerHTML;if(subtype&&typeof this==='undefined')
return subtype+'';try{return JSON.stringify(this,null,'  ');}catch(e){return''+this;}}}
static simpleTextFromException(exceptionDetails){var text=exceptionDetails.text;if(exceptionDetails.exception&&exceptionDetails.exception.description){var description=exceptionDetails.exception.description;if(description.indexOf('\n')!==-1)
description=description.substring(0,description.indexOf('\n'));text+=' '+description;}
return text;}
exceptionThrown(timestamp,exceptionDetails){var exceptionWithTimestamp={timestamp:timestamp,details:exceptionDetails};this.dispatchEventToListeners(SDK.RuntimeModel.Events.ExceptionThrown,exceptionWithTimestamp);}
_exceptionRevoked(exceptionId){this.dispatchEventToListeners(SDK.RuntimeModel.Events.ExceptionRevoked,exceptionId);}
_consoleAPICalled(type,args,executionContextId,timestamp,stackTrace,context){var consoleAPICall={type:type,args:args,executionContextId:executionContextId,timestamp:timestamp,stackTrace:stackTrace,context:context};this.dispatchEventToListeners(SDK.RuntimeModel.Events.ConsoleAPICalled,consoleAPICall);}
executionContextIdForScriptId(scriptId){var script=this.debuggerModel().scriptForId(scriptId);return script?script.executionContextId:0;}
executionContextForStackTrace(stackTrace){while(stackTrace&&!stackTrace.callFrames.length)
stackTrace=stackTrace.parent;if(!stackTrace||!stackTrace.callFrames.length)
return 0;return this.executionContextIdForScriptId(stackTrace.callFrames[0].scriptId);}};SDK.SDKModel.register(SDK.RuntimeModel,SDK.Target.Capability.JS,true);SDK.RuntimeModel.Events={ExecutionContextCreated:Symbol('ExecutionContextCreated'),ExecutionContextDestroyed:Symbol('ExecutionContextDestroyed'),ExecutionContextChanged:Symbol('ExecutionContextChanged'),ExecutionContextOrderChanged:Symbol('ExecutionContextOrderChanged'),ExceptionThrown:Symbol('ExceptionThrown'),ExceptionRevoked:Symbol('ExceptionRevoked'),ConsoleAPICalled:Symbol('ConsoleAPICalled'),};SDK.RuntimeModel.ExceptionWithTimestamp;SDK.RuntimeModel.CompileScriptResult;SDK.RuntimeModel.EvaluationOptions;SDK.RuntimeModel.EvaluationResult;SDK.RuntimeModel.ConsoleAPICall;SDK.RuntimeDispatcher=class{constructor(runtimeModel){this._runtimeModel=runtimeModel;}
executionContextCreated(context){this._runtimeModel._executionContextCreated(context);}
executionContextDestroyed(executionContextId){this._runtimeModel._executionContextDestroyed(executionContextId);}
executionContextsCleared(){this._runtimeModel._executionContextsCleared();}
exceptionThrown(timestamp,exceptionDetails){this._runtimeModel.exceptionThrown(timestamp,exceptionDetails);}
exceptionRevoked(reason,exceptionId){this._runtimeModel._exceptionRevoked(exceptionId);}
consoleAPICalled(type,args,executionContextId,timestamp,stackTrace,context){this._runtimeModel._consoleAPICalled(type,args,executionContextId,timestamp,stackTrace,context);}
inspectRequested(payload,hints){this._runtimeModel._inspectRequested(payload,hints);}};SDK.ExecutionContext=class{constructor(runtimeModel,id,name,origin,isDefault,frameId){this.id=id;this.name=name;this.origin=origin;this.isDefault=isDefault;this.runtimeModel=runtimeModel;this.debuggerModel=runtimeModel.debuggerModel();this.frameId=frameId;this._setLabel('');}
target(){return this.runtimeModel.target();}
static comparator(a,b){function targetWeight(target){if(!target.parentTarget())
return 4;if(target.hasBrowserCapability())
return 3;if(target.hasJSCapability())
return 2;return 1;}
var weightDiff=targetWeight(a.target())-targetWeight(b.target());if(weightDiff)
return-weightDiff;if(a.isDefault)
return-1;if(b.isDefault)
return+1;return a.name.localeCompare(b.name);}
evaluate(options,userGesture,awaitPromise){if(this.debuggerModel.selectedCallFrame())
return this.debuggerModel.evaluateOnSelectedCallFrame(options);return this._evaluateGlobal(options,userGesture,awaitPromise);}
globalObject(objectGroup,generatePreview){return this._evaluateGlobal({expression:'this',objectGroup:objectGroup,includeCommandLineAPI:false,silent:true,returnByValue:false,generatePreview:generatePreview},false,false);}
async _evaluateGlobal(options,userGesture,awaitPromise){if(!options.expression){options.expression='this';}
var response=await this.runtimeModel._agent.invoke_evaluate({expression:options.expression,objectGroup:options.objectGroup,includeCommandLineAPI:options.includeCommandLineAPI,silent:options.silent,contextId:this.id,returnByValue:options.returnByValue,generatePreview:options.generatePreview,userGesture:userGesture,awaitPromise:awaitPromise});var error=response[Protocol.Error];if(error){console.error(error);return{error:error};}
return{object:this.runtimeModel.createRemoteObject(response.result),exceptionDetails:response.exceptionDetails};}
label(){return this._label;}
setLabel(label){this._setLabel(label);this.runtimeModel.dispatchEventToListeners(SDK.RuntimeModel.Events.ExecutionContextChanged,this);}
_setLabel(label){if(label){this._label=label;return;}
if(this.name){this._label=this.name;return;}
var parsedUrl=this.origin.asParsedURL();this._label=parsedUrl?parsedUrl.lastPathComponentWithFragment():'';}};;SDK.ScreenCaptureModel=class extends SDK.SDKModel{constructor(target){super(target);this._agent=target.pageAgent();this._onScreencastFrame=null;this._onScreencastVisibilityChanged=null;target.registerPageDispatcher(this);}
startScreencast(format,quality,width,height,everyNthFrame,onFrame,onVisibilityChanged){this._onScreencastFrame=onFrame;this._onScreencastVisibilityChanged=onVisibilityChanged;this._agent.startScreencast(format,quality,width,height,everyNthFrame);}
stopScreencast(){this._onScreencastFrame=null;this._onScreencastVisibilityChanged=null;this._agent.stopScreencast();}
captureScreenshot(format,quality,clip){return this._agent.captureScreenshot(format,quality,clip,true);}
async fetchLayoutMetrics(){var response=await this._agent.invoke_getLayoutMetrics({});if(response[Protocol.Error])
return null;return{viewportX:response.visualViewport.pageX,viewportY:response.visualViewport.pageY,viewportScale:response.visualViewport.scale,contentWidth:response.contentSize.width,contentHeight:response.contentSize.height};}
screencastFrame(data,metadata,sessionId){this._agent.screencastFrameAck(sessionId);if(this._onScreencastFrame)
this._onScreencastFrame.call(null,data,metadata);}
screencastVisibilityChanged(visible){if(this._onScreencastVisibilityChanged)
this._onScreencastVisibilityChanged.call(null,visible);}
domContentEventFired(time){}
loadEventFired(time){}
frameAttached(frameId,parentFrameId){}
frameNavigated(frame){}
frameDetached(frameId){}
frameStartedLoading(frameId){}
frameStoppedLoading(frameId){}
frameScheduledNavigation(frameId,delay){}
frameClearedScheduledNavigation(frameId){}
frameResized(){}
javascriptDialogOpening(url,message,dialogType,prompt){}
javascriptDialogClosed(result,userInput){}
interstitialShown(){}
interstitialHidden(){}};SDK.SDKModel.register(SDK.ScreenCaptureModel,SDK.Target.Capability.ScreenCapture,false);;SDK.Script=class{constructor(debuggerModel,scriptId,sourceURL,startLine,startColumn,endLine,endColumn,executionContextId,hash,isContentScript,isLiveEdit,sourceMapURL,hasSourceURL,length){this.debuggerModel=debuggerModel;this.scriptId=scriptId;this.sourceURL=sourceURL;this.lineOffset=startLine;this.columnOffset=startColumn;this.endLine=endLine;this.endColumn=endColumn;this.executionContextId=executionContextId;this.hash=hash;this._isContentScript=isContentScript;this._isLiveEdit=isLiveEdit;this.sourceMapURL=sourceMapURL;this.hasSourceURL=hasSourceURL;this.contentLength=length;this._originalContentProvider=null;this._originalSource=null;}
static _trimSourceURLComment(source){var sourceURLIndex=source.lastIndexOf('//# sourceURL=');if(sourceURLIndex===-1){sourceURLIndex=source.lastIndexOf('//@ sourceURL=');if(sourceURLIndex===-1)
return source;}
var sourceURLLineIndex=source.lastIndexOf('\n',sourceURLIndex);if(sourceURLLineIndex===-1)
return source;var sourceURLLine=source.substr(sourceURLLineIndex+1).split('\n',1)[0];if(sourceURLLine.search(SDK.Script.sourceURLRegex)===-1)
return source;return source.substr(0,sourceURLLineIndex)+source.substr(sourceURLLineIndex+sourceURLLine.length+1);}
isContentScript(){return this._isContentScript;}
executionContext(){return this.debuggerModel.runtimeModel().executionContext(this.executionContextId);}
isLiveEdit(){return this._isLiveEdit;}
contentURL(){return this.sourceURL;}
contentType(){return Common.resourceTypes.Script;}
async requestContent(){if(this._source)
return this._source;if(!this.scriptId)
return'';var source=await this.debuggerModel.target().debuggerAgent().getScriptSource(this.scriptId);this._source=source?SDK.Script._trimSourceURLComment(source):'';if(this._originalSource===null)
this._originalSource=this._source;return this._source;}
originalContentProvider(){if(!this._originalContentProvider){var lazyContent=()=>this.requestContent().then(()=>this._originalSource);this._originalContentProvider=new Common.StaticContentProvider(this.contentURL(),this.contentType(),lazyContent);}
return this._originalContentProvider;}
async searchInContent(query,caseSensitive,isRegex){if(!this.scriptId)
return[];var matches=await this.debuggerModel.target().debuggerAgent().searchInContent(this.scriptId,query,caseSensitive,isRegex);return(matches||[]).map(match=>new Common.ContentProvider.SearchMatch(match.lineNumber,match.lineContent));}
_appendSourceURLCommentIfNeeded(source){if(!this.hasSourceURL)
return source;return source+'\n //# sourceURL='+this.sourceURL;}
async editSource(newSource,callback){newSource=SDK.Script._trimSourceURLComment(newSource);newSource=this._appendSourceURLCommentIfNeeded(newSource);if(!this.scriptId){callback('Script failed to parse');return;}
await this.requestContent();var response=await this.debuggerModel.target().debuggerAgent().invoke_setScriptSource({scriptId:this.scriptId,scriptSource:newSource});if(!response[Protocol.Error]&&!response.exceptionDetails)
this._source=newSource;var needsStepIn=!!response.stackChanged;callback(response[Protocol.Error],response.exceptionDetails,response.callFrames,response.asyncStackTrace,needsStepIn);}
rawLocation(lineNumber,columnNumber){return new SDK.DebuggerModel.Location(this.debuggerModel,this.scriptId,lineNumber,columnNumber||0);}
isInlineScript(){var startsAtZero=!this.lineOffset&&!this.columnOffset;return!!this.sourceURL&&!startsAtZero;}
isAnonymousScript(){return!this.sourceURL;}
isInlineScriptWithSourceURL(){return!!this.hasSourceURL&&this.isInlineScript();}
async setBlackboxedRanges(positions){var response=await this.debuggerModel.target().debuggerAgent().invoke_setBlackboxedRanges({scriptId:this.scriptId,positions});var error=response[Protocol.Error];if(error)
console.error(error);return!error;}};SDK.Script.sourceURLRegex=/^[\040\t]*\/\/[@#] sourceURL=\s*(\S*?)\s*$/m;;SDK.ServiceWorkerCacheModel=class extends SDK.SDKModel{constructor(target){super(target);target.registerStorageDispatcher(this);this._caches=new Map();this._cacheAgent=target.cacheStorageAgent();this._storageAgent=target.storageAgent();this._securityOriginManager=target.model(SDK.SecurityOriginManager);this._enabled=false;}
enable(){if(this._enabled)
return;this._securityOriginManager.addEventListener(SDK.SecurityOriginManager.Events.SecurityOriginAdded,this._securityOriginAdded,this);this._securityOriginManager.addEventListener(SDK.SecurityOriginManager.Events.SecurityOriginRemoved,this._securityOriginRemoved,this);for(var securityOrigin of this._securityOriginManager.securityOrigins())
this._addOrigin(securityOrigin);this._enabled=true;}
clearForOrigin(origin){this._removeOrigin(origin);this._addOrigin(origin);}
refreshCacheNames(){for(var cache of this._caches.values())
this._cacheRemoved(cache);this._caches.clear();var securityOrigins=this._securityOriginManager.securityOrigins();for(var securityOrigin of securityOrigins)
this._loadCacheNames(securityOrigin);}
async deleteCache(cache){var response=await this._cacheAgent.invoke_deleteCache({cacheId:cache.cacheId});if(response[Protocol.Error]){console.error(`ServiceWorkerCacheAgent error deleting cache ${cache.toString()}: ${response[Protocol.Error]}`);return;}
this._caches.delete(cache.cacheId);this._cacheRemoved(cache);}
async deleteCacheEntry(cache,request){var response=await this._cacheAgent.invoke_deleteEntry({cacheId:cache.cacheId,request});if(!response[Protocol.Error])
return;Common.console.error(Common.UIString('ServiceWorkerCacheAgent error deleting cache entry %s in cache: %s',cache.toString(),response[Protocol.Error]));}
loadCacheData(cache,skipCount,pageSize,callback){this._requestEntries(cache,skipCount,pageSize,callback);}
caches(){var caches=new Array();for(var cache of this._caches.values())
caches.push(cache);return caches;}
dispose(){for(var cache of this._caches.values())
this._cacheRemoved(cache);this._caches.clear();if(this._enabled){this._securityOriginManager.removeEventListener(SDK.SecurityOriginManager.Events.SecurityOriginAdded,this._securityOriginAdded,this);this._securityOriginManager.removeEventListener(SDK.SecurityOriginManager.Events.SecurityOriginRemoved,this._securityOriginRemoved,this);}}
_addOrigin(securityOrigin){this._loadCacheNames(securityOrigin);this._storageAgent.trackCacheStorageForOrigin(securityOrigin);}
_removeOrigin(securityOrigin){for(var opaqueId of this._caches.keys()){var cache=this._caches.get(opaqueId);if(cache.securityOrigin===securityOrigin){this._caches.delete(opaqueId);this._cacheRemoved(cache);}}
this._storageAgent.untrackCacheStorageForOrigin(securityOrigin);}
async _loadCacheNames(securityOrigin){var caches=await this._cacheAgent.requestCacheNames(securityOrigin);if(!caches)
return;this._updateCacheNames(securityOrigin,caches);}
_updateCacheNames(securityOrigin,cachesJson){function deleteAndSaveOldCaches(cache){if(cache.securityOrigin===securityOrigin&&!updatingCachesIds.has(cache.cacheId)){oldCaches.set(cache.cacheId,cache);this._caches.delete(cache.cacheId);}}
var updatingCachesIds=new Set();var newCaches=new Map();var oldCaches=new Map();for(var cacheJson of cachesJson){var cache=new SDK.ServiceWorkerCacheModel.Cache(this,cacheJson.securityOrigin,cacheJson.cacheName,cacheJson.cacheId);updatingCachesIds.add(cache.cacheId);if(this._caches.has(cache.cacheId))
continue;newCaches.set(cache.cacheId,cache);this._caches.set(cache.cacheId,cache);}
this._caches.forEach(deleteAndSaveOldCaches,this);newCaches.forEach(this._cacheAdded,this);oldCaches.forEach(this._cacheRemoved,this);}
_securityOriginAdded(event){var securityOrigin=(event.data);this._addOrigin(securityOrigin);}
_securityOriginRemoved(event){var securityOrigin=(event.data);this._removeOrigin(securityOrigin);}
_cacheAdded(cache){this.dispatchEventToListeners(SDK.ServiceWorkerCacheModel.Events.CacheAdded,{model:this,cache:cache});}
_cacheRemoved(cache){this.dispatchEventToListeners(SDK.ServiceWorkerCacheModel.Events.CacheRemoved,{model:this,cache:cache});}
async _requestEntries(cache,skipCount,pageSize,callback){var response=await this._cacheAgent.invoke_requestEntries({cacheId:cache.cacheId,skipCount,pageSize});if(response[Protocol.Error]){console.error('ServiceWorkerCacheAgent error while requesting entries: ',response[Protocol.Error]);return;}
var entries=response.cacheDataEntries.map(dataEntry=>new SDK.ServiceWorkerCacheModel.Entry(dataEntry.request,dataEntry.response,new Date(dataEntry.responseTime*1000).toLocaleString()));callback(entries,response.hasMore);}
cacheStorageListUpdated(origin){this.dispatchEventToListeners(SDK.ServiceWorkerCacheModel.Events.CacheStorageListUpdated,{origin:origin});}
cacheStorageContentUpdated(origin,cacheName){this.dispatchEventToListeners(SDK.ServiceWorkerCacheModel.Events.CacheStorageContentUpdated,{origin:origin,cacheName:cacheName});}};SDK.SDKModel.register(SDK.ServiceWorkerCacheModel,SDK.Target.Capability.Browser,false);SDK.ServiceWorkerCacheModel.Events={CacheAdded:Symbol('CacheAdded'),CacheRemoved:Symbol('CacheRemoved'),CacheStorageListUpdated:Symbol('CacheStorageListUpdated'),CacheStorageContentUpdated:Symbol('CacheStorageContentUpdated')};SDK.ServiceWorkerCacheModel.Entry=class{constructor(request,response,responseTime){this.request=request;this.response=response;this.responseTime=responseTime;}};SDK.ServiceWorkerCacheModel.Cache=class{constructor(model,securityOrigin,cacheName,cacheId){this._model=model;this.securityOrigin=securityOrigin;this.cacheName=cacheName;this.cacheId=cacheId;}
equals(cache){return this.cacheId===cache.cacheId;}
toString(){return this.securityOrigin+this.cacheName;}
requestCachedResponse(url){return this._model._cacheAgent.requestCachedResponse(this.cacheId,url);}};;SDK.CallFunctionResult;SDK.RemoteObject=class{static fromLocalObject(value){return new SDK.LocalJSONObject(value);}
static type(remoteObject){if(remoteObject===null)
return'null';var type=typeof remoteObject;if(type!=='object'&&type!=='function')
return type;return remoteObject.type;}
static arrayNameFromDescription(description){return description.replace(SDK.RemoteObject._descriptionLengthParenRegex,'').replace(SDK.RemoteObject._descriptionLengthSquareRegex,'');}
static arrayLength(object){if(object.subtype!=='array'&&object.subtype!=='typedarray')
return 0;var parenMatches=object.description.match(SDK.RemoteObject._descriptionLengthParenRegex);var squareMatches=object.description.match(SDK.RemoteObject._descriptionLengthSquareRegex);return parenMatches?parseInt(parenMatches[1],10):(squareMatches?parseInt(squareMatches[1],10):0);}
static toCallArgument(object){var type=typeof object;if(type==='undefined')
return{};if(type==='number'){var description=String(object);if(object===0&&1/object<0)
return{unserializableValue:Protocol.Runtime.UnserializableValue.Negative0};if(description==='NaN')
return{unserializableValue:Protocol.Runtime.UnserializableValue.NaN};if(description==='Infinity')
return{unserializableValue:Protocol.Runtime.UnserializableValue.Infinity};if(description==='-Infinity')
return{unserializableValue:Protocol.Runtime.UnserializableValue.NegativeInfinity};return{value:object};}
if(type==='string'||type==='boolean')
return{value:object};if(!object)
return{value:null};if(typeof object.unserializableValue!=='undefined')
return{unserializableValue:object.unserializableValue};if(object instanceof SDK.RemoteObjectImpl&&typeof object._unserializableValue!=='undefined')
return{unserializableValue:object._unserializableValue};if(typeof object.objectId!=='undefined')
return{objectId:object.objectId};return{value:object.value};}
static loadFromObjectPerProto(object,generatePreview,callback){var savedOwnProperties;var savedAccessorProperties;var savedInternalProperties;var resultCounter=2;function processCallback(){if(--resultCounter)
return;if(savedOwnProperties&&savedAccessorProperties){var propertiesMap=new Map();var propertySymbols=[];for(var i=0;i<savedAccessorProperties.length;i++){var property=savedAccessorProperties[i];if(property.symbol)
propertySymbols.push(property);else
propertiesMap.set(property.name,property);}
for(var i=0;i<savedOwnProperties.length;i++){var property=savedOwnProperties[i];if(property.isAccessorProperty())
continue;if(property.symbol)
propertySymbols.push(property);else
propertiesMap.set(property.name,property);}
return callback(propertiesMap.valuesArray().concat(propertySymbols),savedInternalProperties?savedInternalProperties:null);}else{callback(null,null);}}
function allAccessorPropertiesCallback(properties,internalProperties){savedAccessorProperties=properties;processCallback();}
function ownPropertiesCallback(properties,internalProperties){savedOwnProperties=properties;savedInternalProperties=internalProperties;processCallback();}
object.getAllProperties(true,generatePreview,allAccessorPropertiesCallback);object.getOwnProperties(generatePreview,ownPropertiesCallback);}
customPreview(){return null;}
get objectId(){return'Not implemented';}
get type(){throw'Not implemented';}
get subtype(){throw'Not implemented';}
get value(){throw'Not implemented';}
get description(){throw'Not implemented';}
get hasChildren(){throw'Not implemented';}
get preview(){return undefined;}
arrayLength(){throw'Not implemented';}
getOwnProperties(generatePreview,callback){throw'Not implemented';}
getOwnPropertiesPromise(generatePreview){return new Promise(promiseConstructor.bind(this));function promiseConstructor(success){this.getOwnProperties(!!generatePreview,getOwnPropertiesCallback.bind(null,success));}
function getOwnPropertiesCallback(callback,properties,internalProperties){callback({properties:properties,internalProperties:internalProperties});}}
getAllProperties(accessorPropertiesOnly,generatePreview,callback){throw'Not implemented';}
getAllPropertiesPromise(accessorPropertiesOnly,generatePreview){return new Promise(promiseConstructor.bind(this));function promiseConstructor(success){this.getAllProperties(accessorPropertiesOnly,generatePreview,getAllPropertiesCallback.bind(null,success));}
function getAllPropertiesCallback(callback,properties,internalProperties){callback({properties:properties,internalProperties:internalProperties});}}
getProperty(propertyPath,callback){throw'Not implemented';}
async deleteProperty(name){throw'Not implemented';}
async setPropertyValue(name,value){throw'Not implemented';}
callFunction(functionDeclaration,args,callback){throw'Not implemented';}
callFunctionPromise(functionDeclaration,args){return new Promise(promiseConstructor.bind(this));function promiseConstructor(success){this.callFunction(functionDeclaration,args,callFunctionCallback.bind(null,success));}
function callFunctionCallback(callback,object,wasThrown){callback({object:object,wasThrown:wasThrown});}}
callFunctionJSON(functionDeclaration,args,callback){throw'Not implemented';}
callFunctionJSONPromise(functionDeclaration,args){return new Promise(success=>this.callFunctionJSON(functionDeclaration,args,success));}
release(){}
debuggerModel(){throw new Error('DebuggerModel-less object');}
runtimeModel(){throw new Error('RuntimeModel-less object');}
isNode(){return false;}};SDK.RemoteObjectImpl=class extends SDK.RemoteObject{constructor(runtimeModel,objectId,type,subtype,value,unserializableValue,description,preview,customPreview){super();this._runtimeModel=runtimeModel;this._runtimeAgent=runtimeModel.target().runtimeAgent();this._type=type;this._subtype=subtype;if(objectId){this._objectId=objectId;this._description=description;this._hasChildren=(type!=='symbol');this._preview=preview;}else{this._description=description;if(!this._description&&(typeof value!=='object'||value===null))
this._description=value+'';this._hasChildren=false;if(typeof unserializableValue!=='undefined'){this._unserializableValue=unserializableValue;if(unserializableValue===Protocol.Runtime.UnserializableValue.Infinity||unserializableValue===Protocol.Runtime.UnserializableValue.NegativeInfinity||unserializableValue===Protocol.Runtime.UnserializableValue.Negative0||unserializableValue===Protocol.Runtime.UnserializableValue.NaN)
this._value=Number(unserializableValue);else
this._value=unserializableValue;}else{this._value=value;}}
this._customPreview=customPreview||null;}
customPreview(){return this._customPreview;}
get objectId(){return this._objectId;}
get type(){return this._type;}
get subtype(){return this._subtype;}
get value(){return this._value;}
get description(){return this._description;}
get hasChildren(){return this._hasChildren;}
get preview(){return this._preview;}
getOwnProperties(generatePreview,callback){this.doGetProperties(true,false,generatePreview,callback);}
getAllProperties(accessorPropertiesOnly,generatePreview,callback){this.doGetProperties(false,accessorPropertiesOnly,generatePreview,callback);}
getProperty(propertyPath,callback){function remoteFunction(arrayStr){var result=this;var properties=JSON.parse(arrayStr);for(var i=0,n=properties.length;i<n;++i)
result=result[properties[i]];return result;}
var args=[{value:JSON.stringify(propertyPath)}];this.callFunction(remoteFunction,args,callback);}
doGetProperties(ownProperties,accessorPropertiesOnly,generatePreview,callback){if(!this._objectId){callback(null,null);return;}
this._runtimeAgent.invoke_getProperties({objectId:this._objectId,ownProperties,accessorPropertiesOnly,generatePreview}).then(remoteObjectBinder.bind(this));function remoteObjectBinder(response){if(response[Protocol.Error]){callback(null,null);return;}
if(response.exceptionDetails){this._runtimeModel.exceptionThrown(Date.now(),response.exceptionDetails);callback(null,null);return;}
var properties=response.result;var internalProperties=response.internalProperties;var result=[];for(var i=0;properties&&i<properties.length;++i){var property=properties[i];var propertyValue=property.value?this._runtimeModel.createRemoteObject(property.value):null;var propertySymbol=property.symbol?this._runtimeModel.createRemoteObject(property.symbol):null;var remoteProperty=new SDK.RemoteObjectProperty(property.name,propertyValue,!!property.enumerable,!!property.writable,!!property.isOwn,!!property.wasThrown,propertySymbol);if(typeof property.value==='undefined'){if(property.get&&property.get.type!=='undefined')
remoteProperty.getter=this._runtimeModel.createRemoteObject(property.get);if(property.set&&property.set.type!=='undefined')
remoteProperty.setter=this._runtimeModel.createRemoteObject(property.set);}
result.push(remoteProperty);}
var internalPropertiesResult=null;if(internalProperties){internalPropertiesResult=[];for(var i=0;i<internalProperties.length;i++){var property=internalProperties[i];if(!property.value)
continue;var propertyValue=this._runtimeModel.createRemoteObject(property.value);internalPropertiesResult.push(new SDK.RemoteObjectProperty(property.name,propertyValue,true,false));}}
callback(result,internalPropertiesResult);}}
async setPropertyValue(name,value){if(!this._objectId)
return`Can't set a property of non-object.`;var response=await this._runtimeAgent.invoke_evaluate({expression:value,silent:true});if(response[Protocol.Error]||response.exceptionDetails){return response[Protocol.Error]||(response.result.type!=='string'?response.result.description:(response.result.value));}
if(typeof name==='string')
name=SDK.RemoteObject.toCallArgument(name);var resultPromise=this.doSetObjectPropertyValue(response.result,name);if(response.result.objectId)
this._runtimeAgent.releaseObject(response.result.objectId);return resultPromise;}
async doSetObjectPropertyValue(result,name){var setPropertyValueFunction='function(a, b) { this[a] = b; }';var argv=[name,SDK.RemoteObject.toCallArgument(result)];var response=await this._runtimeAgent.invoke_callFunctionOn({objectId:this._objectId,functionDeclaration:setPropertyValueFunction,arguments:argv,silent:true});var error=response[Protocol.Error];return error||response.exceptionDetails?error||response.result.description:undefined;}
async deleteProperty(name){if(!this._objectId)
return`Can't delete a property of non-object.`;var deletePropertyFunction='function(a) { delete this[a]; return !(a in this); }';var response=await this._runtimeAgent.invoke_callFunctionOn({objectId:this._objectId,functionDeclaration:deletePropertyFunction,arguments:[name],silent:true});if(response[Protocol.Error]||response.exceptionDetails)
return response[Protocol.Error]||response.result.description;if(!response.result.value)
return'Failed to delete property.';}
callFunction(functionDeclaration,args,callback){this._runtimeAgent.invoke_callFunctionOn({objectId:this._objectId,functionDeclaration:functionDeclaration.toString(),arguments:args,silent:true}).then(response=>{if(!callback)
return;if(response[Protocol.Error])
callback(null,false);else
callback(this._runtimeModel.createRemoteObject(response.result),!!response.exceptionDetails);});}
callFunctionJSON(functionDeclaration,args,callback){this._runtimeAgent.invoke_callFunctionOn({objectId:this._objectId,functionDeclaration:functionDeclaration.toString(),arguments:args,silent:true,returnByValue:true}).then(response=>callback(response[Protocol.Error]||response.exceptionDetails?null:response.result.value));}
release(){if(!this._objectId)
return;this._runtimeAgent.releaseObject(this._objectId);}
arrayLength(){return SDK.RemoteObject.arrayLength(this);}
debuggerModel(){return this._runtimeModel.debuggerModel();}
runtimeModel(){return this._runtimeModel;}
isNode(){return!!this._objectId&&this.type==='object'&&this.subtype==='node';}};SDK.ScopeRemoteObject=class extends SDK.RemoteObjectImpl{constructor(runtimeModel,objectId,scopeRef,type,subtype,value,unserializableValue,description,preview){super(runtimeModel,objectId,type,subtype,value,unserializableValue,description,preview);this._scopeRef=scopeRef;this._savedScopeProperties=undefined;}
doGetProperties(ownProperties,accessorPropertiesOnly,generatePreview,callback){if(accessorPropertiesOnly){callback([],[]);return;}
if(this._savedScopeProperties){callback(this._savedScopeProperties.slice(),[]);return;}
function wrappedCallback(properties,internalProperties){if(this._scopeRef&&Array.isArray(properties)){this._savedScopeProperties=properties.slice();if(!this._scopeRef.callFrameId){for(var property of this._savedScopeProperties)
property.writable=false;}}
callback(properties,internalProperties);}
generatePreview=true;super.doGetProperties(ownProperties,accessorPropertiesOnly,generatePreview,wrappedCallback.bind(this));}
async doSetObjectPropertyValue(result,argumentName){var name=(argumentName.value);var error=await this.debuggerModel().setVariableValue(this._scopeRef.number,name,SDK.RemoteObject.toCallArgument(result),this._scopeRef.callFrameId);if(error)
return error;if(this._savedScopeProperties){for(var property of this._savedScopeProperties){if(property.name===name)
property.value=this._runtimeModel.createRemoteObject(result);}}}};SDK.ScopeRef=class{constructor(number,callFrameId){this.number=number;this.callFrameId=callFrameId;}};SDK.RemoteObjectProperty=class{constructor(name,value,enumerable,writable,isOwn,wasThrown,symbol,synthetic){this.name=name;if(value!==null)
this.value=value;this.enumerable=typeof enumerable!=='undefined'?enumerable:true;this.writable=typeof writable!=='undefined'?writable:true;this.isOwn=!!isOwn;this.wasThrown=!!wasThrown;if(symbol)
this.symbol=symbol;this.synthetic=!!synthetic;}
isAccessorProperty(){return!!(this.getter||this.setter);}};SDK.LocalJSONObject=class extends SDK.RemoteObject{constructor(value){super();this._value=value;this._cachedDescription;this._cachedChildren;}
get objectId(){return undefined;}
get value(){return this._value;}
get description(){if(this._cachedDescription)
return this._cachedDescription;function formatArrayItem(property){return this._formatValue(property.value);}
function formatObjectItem(property){var name=property.name;if(/^\s|\s$|^$|\n/.test(name))
name='"'+name.replace(/\n/g,'\u21B5')+'"';return name+': '+this._formatValue(property.value);}
if(this.type==='object'){switch(this.subtype){case'array':this._cachedDescription=this._concatenate('[',']',formatArrayItem.bind(this));break;case'date':this._cachedDescription=''+this._value;break;case'null':this._cachedDescription='null';break;default:this._cachedDescription=this._concatenate('{','}',formatObjectItem.bind(this));}}else{this._cachedDescription=String(this._value);}
return this._cachedDescription;}
_formatValue(value){if(!value)
return'undefined';var description=value.description||'';if(value.type==='string')
return'"'+description.replace(/\n/g,'\u21B5')+'"';return description;}
_concatenate(prefix,suffix,formatProperty){var previewChars=100;var buffer=prefix;var children=this._children();for(var i=0;i<children.length;++i){var itemDescription=formatProperty(children[i]);if(buffer.length+itemDescription.length>previewChars){buffer+=',\u2026';break;}
if(i)
buffer+=', ';buffer+=itemDescription;}
buffer+=suffix;return buffer;}
get type(){return typeof this._value;}
get subtype(){if(this._value===null)
return'null';if(Array.isArray(this._value))
return'array';if(this._value instanceof Date)
return'date';return undefined;}
get hasChildren(){if((typeof this._value!=='object')||(this._value===null))
return false;return!!Object.keys((this._value)).length;}
getOwnProperties(generatePreview,callback){callback(this._children(),null);}
getAllProperties(accessorPropertiesOnly,generatePreview,callback){if(accessorPropertiesOnly)
callback([],null);else
callback(this._children(),null);}
_children(){if(!this.hasChildren)
return[];var value=(this._value);function buildProperty(propName){var propValue=value[propName];if(!(propValue instanceof SDK.RemoteObject))
propValue=SDK.RemoteObject.fromLocalObject(propValue);return new SDK.RemoteObjectProperty(propName,propValue);}
if(!this._cachedChildren)
this._cachedChildren=Object.keys(value).map(buildProperty);return this._cachedChildren;}
isError(){return false;}
arrayLength(){return Array.isArray(this._value)?this._value.length:0;}
callFunction(functionDeclaration,args,callback){var target=(this._value);var rawArgs=args?args.map(arg=>arg.value):[];var result;var wasThrown=false;try{result=functionDeclaration.apply(target,rawArgs);}catch(e){wasThrown=true;}
if(!callback)
return;callback(SDK.RemoteObject.fromLocalObject(result),wasThrown);}
callFunctionJSON(functionDeclaration,args,callback){var target=(this._value);var rawArgs=args?args.map(arg=>arg.value):[];var result;try{result=functionDeclaration.apply(target,rawArgs);}catch(e){result=null;}
callback(result);}};SDK.RemoteArray=class{constructor(object){this._object=object;}
static objectAsArray(object){if(!object||object.type!=='object'||(object.subtype!=='array'&&object.subtype!=='typedarray'))
throw new Error('Object is empty or not an array');return new SDK.RemoteArray(object);}
static createFromRemoteObjects(objects){if(!objects.length)
throw new Error('Input array is empty');var objectArguments=[];for(var i=0;i<objects.length;++i)
objectArguments.push(SDK.RemoteObject.toCallArgument(objects[i]));return objects[0].callFunctionPromise(createArray,objectArguments).then(returnRemoteArray);function createArray(){if(arguments.length>1)
return new Array(arguments);return[arguments[0]];}
function returnRemoteArray(result){if(result.wasThrown||!result.object)
throw new Error('Call function throws exceptions or returns empty value');return SDK.RemoteArray.objectAsArray(result.object);}}
at(index){if(index<0||index>this._object.arrayLength())
throw new Error('Out of range');return this._object.callFunctionPromise(at,[SDK.RemoteObject.toCallArgument(index)]).then(assertCallFunctionResult);function at(index){return this[index];}
function assertCallFunctionResult(result){if(result.wasThrown||!result.object)
throw new Error('Exception in callFunction or result value is empty');return result.object;}}
length(){return this._object.arrayLength();}
map(func){var promises=[];for(var i=0;i<this.length();++i)
promises.push(this.at(i).then(func));return Promise.all(promises);}
object(){return this._object;}};SDK.RemoteFunction=class{constructor(object){this._object=object;}
static objectAsFunction(object){if(!object||object.type!=='function')
throw new Error('Object is empty or not a function');return new SDK.RemoteFunction(object);}
targetFunction(){return this._object.getOwnPropertiesPromise(false).then(targetFunction.bind(this));function targetFunction(ownProperties){if(!ownProperties.internalProperties)
return this._object;var internalProperties=ownProperties.internalProperties;for(var property of internalProperties){if(property.name==='[[TargetFunction]]')
return property.value;}
return this._object;}}
targetFunctionDetails(){return this.targetFunction().then(functionDetails.bind(this));function functionDetails(targetFunction){var boundReleaseFunctionDetails=releaseTargetFunction.bind(null,this._object!==targetFunction?targetFunction:null);return targetFunction.debuggerModel().functionDetailsPromise(targetFunction).then(boundReleaseFunctionDetails);}
function releaseTargetFunction(targetFunction,functionDetails){if(targetFunction)
targetFunction.release();return functionDetails;}}
object(){return this._object;}};SDK.RemoteObject._descriptionLengthParenRegex=/\(([0-9]+)\)/;SDK.RemoteObject._descriptionLengthSquareRegex=/\[([0-9]+)\]/;;SDK.Resource=class{constructor(resourceTreeModel,request,url,documentURL,frameId,loaderId,type,mimeType,lastModified,contentSize){this._resourceTreeModel=resourceTreeModel;this._request=request;this.url=url;this._documentURL=documentURL;this._frameId=frameId;this._loaderId=loaderId;this._type=type||Common.resourceTypes.Other;this._mimeType=mimeType;this._lastModified=lastModified&&lastModified.isValid()?lastModified:null;this._contentSize=contentSize;this._content;this._contentEncoded;this._pendingContentCallbacks=[];if(this._request&&!this._request.finished)
this._request.addEventListener(SDK.NetworkRequest.Events.FinishedLoading,this._requestFinished,this);}
lastModified(){if(this._lastModified||!this._request)
return this._lastModified;var lastModifiedHeader=this._request.responseLastModified();var date=lastModifiedHeader?new Date(lastModifiedHeader):null;this._lastModified=date&&date.isValid()?date:null;return this._lastModified;}
contentSize(){if(typeof this._contentSize==='number'||!this._request)
return this._contentSize;return this._request.resourceSize;}
get request(){return this._request;}
get url(){return this._url;}
set url(x){this._url=x;this._parsedURL=new Common.ParsedURL(x);}
get parsedURL(){return this._parsedURL;}
get documentURL(){return this._documentURL;}
get frameId(){return this._frameId;}
get loaderId(){return this._loaderId;}
get displayName(){return this._parsedURL.displayName;}
resourceType(){return this._request?this._request.resourceType():this._type;}
get mimeType(){return this._request?this._request.mimeType:this._mimeType;}
get content(){return this._content;}
get contentEncoded(){return this._contentEncoded;}
contentURL(){return this._url;}
contentType(){if(this.resourceType()===Common.resourceTypes.Document&&this.mimeType.indexOf('javascript')!==-1)
return Common.resourceTypes.Script;return this.resourceType();}
requestContent(){if(typeof this._content!=='undefined')
return Promise.resolve(this._content);var callback;var promise=new Promise(fulfill=>callback=fulfill);this._pendingContentCallbacks.push(callback);if(!this._request||this._request.finished)
this._innerRequestContent();return promise;}
canonicalMimeType(){return this.contentType().canonicalMimeType()||this.mimeType;}
async searchInContent(query,caseSensitive,isRegex){if(!this.frameId)
return[];var result=await this._resourceTreeModel.target().pageAgent().searchInResource(this.frameId,this.url,query,caseSensitive,isRegex);return result||[];}
populateImageSource(image){function onResourceContent(content){var imageSrc=Common.ContentProvider.contentAsDataURL(content,this._mimeType,true);if(imageSrc===null)
imageSrc=this._url;image.src=imageSrc;}
this.requestContent().then(onResourceContent.bind(this));}
_requestFinished(){this._request.removeEventListener(SDK.NetworkRequest.Events.FinishedLoading,this._requestFinished,this);if(this._pendingContentCallbacks.length)
this._innerRequestContent();}
async _innerRequestContent(){if(this._contentRequested)
return;this._contentRequested=true;if(this.request){var contentData=await this.request.contentData();this._content=contentData.content;this._contentEncoded=contentData.encoded;}else{var response=await this._resourceTreeModel.target().pageAgent().invoke_getResourceContent({frameId:this.frameId,url:this.url});this._content=response[Protocol.Error]?null:response.content;this._contentEncoded=response.base64Encoded;}
if(this._content===null)
this._contentEncoded=false;for(var callback of this._pendingContentCallbacks.splice(0))
callback(this._content);delete this._contentRequested;}
hasTextContent(){if(this._type.isTextType())
return true;if(this._type===Common.resourceTypes.Other)
return!!this._content&&!this._contentEncoded;return false;}};;SDK.ResourceTreeModel=class extends SDK.SDKModel{constructor(target){super(target);var networkManager=target.model(SDK.NetworkManager);if(networkManager){networkManager.addEventListener(SDK.NetworkManager.Events.RequestFinished,this._onRequestFinished,this);networkManager.addEventListener(SDK.NetworkManager.Events.RequestUpdateDropped,this._onRequestUpdateDropped,this);}
this._agent=target.pageAgent();this._agent.enable();this._securityOriginManager=target.model(SDK.SecurityOriginManager);target.registerPageDispatcher(new SDK.PageDispatcher(this));this._frames=new Map();this._cachedResourcesProcessed=false;this._pendingReloadOptions=null;this._reloadSuspensionCount=0;this._isInterstitialShowing=false;this.mainFrame=null;this._agent.getResourceTree().then(this._processCachedResources.bind(this));}
static frameForRequest(request){var networkManager=SDK.NetworkManager.forRequest(request);var resourceTreeModel=networkManager?networkManager.target().model(SDK.ResourceTreeModel):null;if(!resourceTreeModel)
return null;return resourceTreeModel.frameForId(request.frameId);}
static frames(){var result=[];for(var resourceTreeModel of SDK.targetManager.models(SDK.ResourceTreeModel))
result=result.concat(resourceTreeModel._frames.valuesArray());return result;}
static resourceForURL(url){for(var resourceTreeModel of SDK.targetManager.models(SDK.ResourceTreeModel)){var mainFrame=resourceTreeModel.mainFrame;var result=mainFrame?mainFrame.resourceForURL(url):null;if(result)
return result;}
return null;}
static reloadAllPages(bypassCache,scriptToEvaluateOnLoad){for(var resourceTreeModel of SDK.targetManager.models(SDK.ResourceTreeModel)){if(!resourceTreeModel.target().parentTarget())
resourceTreeModel.reloadPage(bypassCache,scriptToEvaluateOnLoad);}}
domModel(){return(this.target().model(SDK.DOMModel));}
_processCachedResources(mainFramePayload){if(mainFramePayload){this.dispatchEventToListeners(SDK.ResourceTreeModel.Events.WillLoadCachedResources);this._addFramesRecursively(null,mainFramePayload);this.target().setInspectedURL(mainFramePayload.frame.url);}
this._cachedResourcesProcessed=true;var runtimeModel=this.target().model(SDK.RuntimeModel);if(runtimeModel){runtimeModel.setExecutionContextComparator(this._executionContextComparator.bind(this));runtimeModel.fireExecutionContextOrderChanged();}
this.dispatchEventToListeners(SDK.ResourceTreeModel.Events.CachedResourcesLoaded,this);}
cachedResourcesLoaded(){return this._cachedResourcesProcessed;}
isInterstitialShowing(){return this._isInterstitialShowing;}
_addFrame(frame,aboutToNavigate){this._frames.set(frame.id,frame);if(frame.isMainFrame())
this.mainFrame=frame;this.dispatchEventToListeners(SDK.ResourceTreeModel.Events.FrameAdded,frame);this._updateSecurityOrigins();}
_frameAttached(frameId,parentFrameId,stackTrace){if(!this._cachedResourcesProcessed&&parentFrameId)
return null;if(this._frames.has(frameId))
return null;var parentFrame=parentFrameId?(this._frames.get(parentFrameId)||null):null;var frame=new SDK.ResourceTreeFrame(this,parentFrame,frameId,null,stackTrace||null);if(frame.isMainFrame()&&this.mainFrame){this._frameDetached(this.mainFrame.id);}
this._addFrame(frame,true);return frame;}
_frameNavigated(framePayload){if(!this._cachedResourcesProcessed&&framePayload.parentId)
return;var frame=this._frames.get(framePayload.id);if(!frame){console.assert(!framePayload.parentId,'Main frame shouldn\'t have parent frame id.');frame=this._frameAttached(framePayload.id,framePayload.parentId||'');console.assert(frame);}
this.dispatchEventToListeners(SDK.ResourceTreeModel.Events.FrameWillNavigate,frame);frame._navigate(framePayload);this.dispatchEventToListeners(SDK.ResourceTreeModel.Events.FrameNavigated,frame);if(frame.isMainFrame())
this.dispatchEventToListeners(SDK.ResourceTreeModel.Events.MainFrameNavigated,frame);var resources=frame.resources();for(var i=0;i<resources.length;++i)
this.dispatchEventToListeners(SDK.ResourceTreeModel.Events.ResourceAdded,resources[i]);if(frame.isMainFrame())
this.target().setInspectedURL(frame.url);this._updateSecurityOrigins();}
_frameDetached(frameId){if(!this._cachedResourcesProcessed)
return;var frame=this._frames.get(frameId);if(!frame)
return;if(frame.parentFrame)
frame.parentFrame._removeChildFrame(frame);else
frame._remove();this._updateSecurityOrigins();}
_onRequestFinished(event){if(!this._cachedResourcesProcessed)
return;var request=(event.data);if(request.failed||request.resourceType()===Common.resourceTypes.XHR)
return;var frame=this._frames.get(request.frameId);if(frame)
frame._addRequest(request);}
_onRequestUpdateDropped(event){if(!this._cachedResourcesProcessed)
return;var frameId=event.data.frameId;var frame=this._frames.get(frameId);if(!frame)
return;var url=event.data.url;if(frame._resourcesMap[url])
return;var resource=new SDK.Resource(this,null,url,frame.url,frameId,event.data.loaderId,Common.resourceTypes[event.data.resourceType],event.data.mimeType,event.data.lastModified,null);frame.addResource(resource);}
frameForId(frameId){return this._frames.get(frameId);}
forAllResources(callback){if(this.mainFrame)
return this.mainFrame._callForFrameResources(callback);return false;}
frames(){return this._frames.valuesArray();}
resourceForURL(url){return this.mainFrame?this.mainFrame.resourceForURL(url):null;}
_addFramesRecursively(parentFrame,frameTreePayload){var framePayload=frameTreePayload.frame;var frame=new SDK.ResourceTreeFrame(this,parentFrame,framePayload.id,framePayload,null);this._addFrame(frame);for(var i=0;frameTreePayload.childFrames&&i<frameTreePayload.childFrames.length;++i)
this._addFramesRecursively(frame,frameTreePayload.childFrames[i]);for(var i=0;i<frameTreePayload.resources.length;++i){var subresource=frameTreePayload.resources[i];var resource=this._createResourceFromFramePayload(framePayload,subresource.url,Common.resourceTypes[subresource.type],subresource.mimeType,subresource.lastModified||null,subresource.contentSize||null);frame.addResource(resource);}
if(!frame._resourcesMap[framePayload.url]){var frameResource=this._createResourceFromFramePayload(framePayload,framePayload.url,Common.resourceTypes.Document,framePayload.mimeType,null,null);frame.addResource(frameResource);}}
_createResourceFromFramePayload(frame,url,type,mimeType,lastModifiedTime,contentSize){var lastModified=typeof lastModifiedTime==='number'?new Date(lastModifiedTime*1000):null;return new SDK.Resource(this,null,url,frame.url,frame.id,frame.loaderId,type,mimeType,lastModified,contentSize);}
suspendReload(){this._reloadSuspensionCount++;}
resumeReload(){this._reloadSuspensionCount--;console.assert(this._reloadSuspensionCount>=0,'Unbalanced call to ResourceTreeModel.resumeReload()');if(!this._reloadSuspensionCount&&this._pendingReloadOptions)
this.reloadPage.apply(this,this._pendingReloadOptions);}
reloadPage(bypassCache,scriptToEvaluateOnLoad){if(!this._pendingReloadOptions)
this.dispatchEventToListeners(SDK.ResourceTreeModel.Events.PageReloadRequested,this);if(this._reloadSuspensionCount){this._pendingReloadOptions=[bypassCache,scriptToEvaluateOnLoad];return;}
this._pendingReloadOptions=null;this.dispatchEventToListeners(SDK.ResourceTreeModel.Events.WillReloadPage);this._agent.reload(bypassCache,scriptToEvaluateOnLoad);}
navigate(url){return this._agent.navigate(url);}
async navigationHistory(){var response=await this._agent.invoke_getNavigationHistory({});if(response[Protocol.Error])
return null;return{currentIndex:response.currentIndex,entries:response.entries};}
navigateToHistoryEntry(entry){this._agent.navigateToHistoryEntry(entry.id);}
async fetchAppManifest(callback){var response=await this._agent.invoke_getAppManifest({});if(response[Protocol.Error])
callback(response.url,null,[]);else
callback(response.url,response.data||null,response.errors);}
_executionContextComparator(a,b){function framePath(frame){var currentFrame=frame;var parents=[];while(currentFrame){parents.push(currentFrame);currentFrame=currentFrame.parentFrame;}
return parents.reverse();}
if(a.target()!==b.target())
return SDK.ExecutionContext.comparator(a,b);var framesA=a.frameId?framePath(this.frameForId(a.frameId)):[];var framesB=b.frameId?framePath(this.frameForId(b.frameId)):[];var frameA;var frameB;for(var i=0;;i++){if(!framesA[i]||!framesB[i]||(framesA[i]!==framesB[i])){frameA=framesA[i];frameB=framesB[i];break;}}
if(!frameA&&frameB)
return-1;if(!frameB&&frameA)
return 1;if(frameA&&frameB)
return frameA.id.localeCompare(frameB.id);return SDK.ExecutionContext.comparator(a,b);}
_updateSecurityOrigins(){var securityOrigins=new Set();var mainSecurityOrigin=null;for(var frame of this._frames.values()){var origin=frame.securityOrigin;if(!origin)
continue;securityOrigins.add(origin);if(frame.isMainFrame())
mainSecurityOrigin=origin;}
this._securityOriginManager.updateSecurityOrigins(securityOrigins);this._securityOriginManager.setMainSecurityOrigin(mainSecurityOrigin||'');}};SDK.SDKModel.register(SDK.ResourceTreeModel,SDK.Target.Capability.DOM,true);SDK.ResourceTreeModel.Events={FrameAdded:Symbol('FrameAdded'),FrameNavigated:Symbol('FrameNavigated'),FrameDetached:Symbol('FrameDetached'),FrameResized:Symbol('FrameResized'),FrameWillNavigate:Symbol('FrameWillNavigate'),MainFrameNavigated:Symbol('MainFrameNavigated'),ResourceAdded:Symbol('ResourceAdded'),WillLoadCachedResources:Symbol('WillLoadCachedResources'),CachedResourcesLoaded:Symbol('CachedResourcesLoaded'),DOMContentLoaded:Symbol('DOMContentLoaded'),Load:Symbol('Load'),PageReloadRequested:Symbol('PageReloadRequested'),WillReloadPage:Symbol('WillReloadPage'),InterstitialShown:Symbol('InterstitialShown'),InterstitialHidden:Symbol('InterstitialHidden')};SDK.ResourceTreeFrame=class{constructor(model,parentFrame,frameId,payload,creationStackTrace){this._model=model;this._parentFrame=parentFrame;this._id=frameId;this._url='';if(payload){this._loaderId=payload.loaderId;this._name=payload.name;this._url=payload.url;this._securityOrigin=payload.securityOrigin;this._mimeType=payload.mimeType;}
this._creationStackTrace=creationStackTrace;this._childFrames=[];this._resourcesMap={};if(this._parentFrame)
this._parentFrame._childFrames.push(this);}
resourceTreeModel(){return this._model;}
get id(){return this._id;}
get name(){return this._name||'';}
get url(){return this._url;}
get securityOrigin(){return this._securityOrigin;}
get loaderId(){return this._loaderId;}
get parentFrame(){return this._parentFrame;}
get childFrames(){return this._childFrames;}
findCreationCallFrame(searchFn){var stackTrace=this._creationStackTrace;while(stackTrace){var foundEntry=stackTrace.callFrames.find(searchFn);if(foundEntry)
return foundEntry;stackTrace=this.parent;}
return null;}
isMainFrame(){return!this._parentFrame;}
_navigate(framePayload){this._loaderId=framePayload.loaderId;this._name=framePayload.name;this._url=framePayload.url;this._securityOrigin=framePayload.securityOrigin;this._mimeType=framePayload.mimeType;var mainResource=this._resourcesMap[this._url];this._resourcesMap={};this._removeChildFrames();if(mainResource&&mainResource.loaderId===this._loaderId)
this.addResource(mainResource);}
get mainResource(){return this._resourcesMap[this._url];}
_removeChildFrame(frame){this._childFrames.remove(frame);frame._remove();}
_removeChildFrames(){var frames=this._childFrames;this._childFrames=[];for(var i=0;i<frames.length;++i)
frames[i]._remove();}
_remove(){this._removeChildFrames();this._model._frames.delete(this.id);this._model.dispatchEventToListeners(SDK.ResourceTreeModel.Events.FrameDetached,this);}
addResource(resource){if(this._resourcesMap[resource.url]===resource){return;}
this._resourcesMap[resource.url]=resource;this._model.dispatchEventToListeners(SDK.ResourceTreeModel.Events.ResourceAdded,resource);}
_addRequest(request){var resource=this._resourcesMap[request.url()];if(resource&&resource.request===request){return;}
resource=new SDK.Resource(this._model,request,request.url(),request.documentURL,request.frameId,request.loaderId,request.resourceType(),request.mimeType,null,null);this._resourcesMap[resource.url]=resource;this._model.dispatchEventToListeners(SDK.ResourceTreeModel.Events.ResourceAdded,resource);}
resources(){var result=[];for(var url in this._resourcesMap)
result.push(this._resourcesMap[url]);return result;}
resourceForURL(url){var resource=this._resourcesMap[url]||null;if(resource)
return resource;for(var i=0;!resource&&i<this._childFrames.length;++i)
resource=this._childFrames[i].resourceForURL(url);return resource;}
_callForFrameResources(callback){for(var url in this._resourcesMap){if(callback(this._resourcesMap[url]))
return true;}
for(var i=0;i<this._childFrames.length;++i){if(this._childFrames[i]._callForFrameResources(callback))
return true;}
return false;}
displayName(){if(!this._parentFrame&&!this._model.target().parentTarget())
return Common.UIString('top');var subtitle=new Common.ParsedURL(this._url).displayName;if(subtitle){if(!this._name)
return subtitle;return this._name+' ('+subtitle+')';}
return Common.UIString('<iframe>');}};SDK.PageDispatcher=class{constructor(resourceTreeModel){this._resourceTreeModel=resourceTreeModel;}
domContentEventFired(time){this._resourceTreeModel.dispatchEventToListeners(SDK.ResourceTreeModel.Events.DOMContentLoaded,time);}
loadEventFired(time){this._resourceTreeModel.dispatchEventToListeners(SDK.ResourceTreeModel.Events.Load,{resourceTreeModel:this._resourceTreeModel,loadTime:time});}
frameAttached(frameId,parentFrameId,stackTrace){this._resourceTreeModel._frameAttached(frameId,parentFrameId,stackTrace);}
frameNavigated(frame){this._resourceTreeModel._frameNavigated(frame);}
frameDetached(frameId){this._resourceTreeModel._frameDetached(frameId);}
frameStartedLoading(frameId){}
frameStoppedLoading(frameId){}
frameScheduledNavigation(frameId,delay){}
frameClearedScheduledNavigation(frameId){}
frameResized(){this._resourceTreeModel.dispatchEventToListeners(SDK.ResourceTreeModel.Events.FrameResized,null);}
javascriptDialogOpening(url,message,dialogType,prompt){}
javascriptDialogClosed(result,userInput){}
screencastFrame(data,metadata,sessionId){}
screencastVisibilityChanged(visible){}
interstitialShown(){this._resourceTreeModel._isInterstitialShowing=true;this._resourceTreeModel.dispatchEventToListeners(SDK.ResourceTreeModel.Events.InterstitialShown);}
interstitialHidden(){this._resourceTreeModel._isInterstitialShowing=false;this._resourceTreeModel.dispatchEventToListeners(SDK.ResourceTreeModel.Events.InterstitialHidden);}};;SDK.SecurityOriginManager=class extends SDK.SDKModel{constructor(target){super(target);this._securityOrigins=new Set();this._mainSecurityOrigin='';}
updateSecurityOrigins(securityOrigins){var oldOrigins=this._securityOrigins;this._securityOrigins=securityOrigins;for(var origin of oldOrigins){if(!this._securityOrigins.has(origin))
this.dispatchEventToListeners(SDK.SecurityOriginManager.Events.SecurityOriginRemoved,origin);}
for(var origin of this._securityOrigins){if(!oldOrigins.has(origin))
this.dispatchEventToListeners(SDK.SecurityOriginManager.Events.SecurityOriginAdded,origin);}}
securityOrigins(){return this._securityOrigins.valuesArray();}
mainSecurityOrigin(){return this._mainSecurityOrigin;}
setMainSecurityOrigin(securityOrigin){this._mainSecurityOrigin=securityOrigin;this.dispatchEventToListeners(SDK.SecurityOriginManager.Events.MainSecurityOriginChanged,securityOrigin);}};SDK.SDKModel.register(SDK.SecurityOriginManager,SDK.Target.Capability.None,false);SDK.SecurityOriginManager.Events={SecurityOriginAdded:Symbol('SecurityOriginAdded'),SecurityOriginRemoved:Symbol('SecurityOriginRemoved'),MainSecurityOriginChanged:Symbol('MainSecurityOriginChanged')};;SDK.SourceMapV3=class{constructor(){this.version;this.file;this.sources;this.sections;this.mappings;this.sourceRoot;this.names;}};SDK.SourceMapV3.Section=class{constructor(){this.map;this.offset;}};SDK.SourceMapV3.Offset=class{constructor(){this.line;this.column;}};SDK.SourceMapEntry=class{constructor(lineNumber,columnNumber,sourceURL,sourceLineNumber,sourceColumnNumber,name){this.lineNumber=lineNumber;this.columnNumber=columnNumber;this.sourceURL=sourceURL;this.sourceLineNumber=sourceLineNumber;this.sourceColumnNumber=sourceColumnNumber;this.name=name;}
static compare(entry1,entry2){if(entry1.lineNumber!==entry2.lineNumber)
return entry1.lineNumber-entry2.lineNumber;return entry1.columnNumber-entry2.columnNumber;}};SDK.SourceMap=function(){};SDK.SourceMap.prototype={compiledURL(){},url(){},sourceURLs(){},sourceContentProvider(sourceURL,contentType){},embeddedContentByURL(sourceURL){},findEntry(lineNumber,columnNumber){},editable(){},editCompiled(ranges,texts){},};SDK.SourceMap.EditResult=class{constructor(map,compiledEdits,newSources){this.map=map;this.compiledEdits=compiledEdits;this.newSources=newSources;}};SDK.SourceMapFactory=function(){};SDK.SourceMapFactory.prototype={editableSourceMap(target,sourceMap){},};SDK.TextSourceMap=class{constructor(compiledURL,sourceMappingURL,payload){if(!SDK.TextSourceMap._base64Map){const base64Digits='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';SDK.TextSourceMap._base64Map={};for(var i=0;i<base64Digits.length;++i)
SDK.TextSourceMap._base64Map[base64Digits.charAt(i)]=i;}
this._json=payload;this._compiledURL=compiledURL;this._sourceMappingURL=sourceMappingURL;this._baseURL=sourceMappingURL.startsWith('data:')?compiledURL:sourceMappingURL;this._mappings=null;this._sourceInfos=new Map();this._eachSection(this._parseSources.bind(this));}
static load(sourceMapURL,compiledURL){var callback;var promise=new Promise(fulfill=>callback=fulfill);SDK.multitargetNetworkManager.loadResource(sourceMapURL,contentLoaded);return promise;function contentLoaded(statusCode,headers,content){if(!content||statusCode>=400){callback(null);return;}
if(content.slice(0,3)===')]}')
content=content.substring(content.indexOf('\n'));try{var payload=(JSON.parse(content));callback(new SDK.TextSourceMap(compiledURL,sourceMapURL,payload));}catch(e){console.error(e);Common.console.warn('DevTools failed to parse SourceMap: '+sourceMapURL);callback(null);}}}
compiledURL(){return this._compiledURL;}
url(){return this._sourceMappingURL;}
sourceURLs(){return this._sourceInfos.keysArray();}
sourceContentProvider(sourceURL,contentType){var info=this._sourceInfos.get(sourceURL);if(info.content)
return Common.StaticContentProvider.fromString(sourceURL,contentType,info.content);return new SDK.CompilerSourceMappingContentProvider(sourceURL,contentType);}
embeddedContentByURL(sourceURL){if(!this._sourceInfos.has(sourceURL))
return null;return this._sourceInfos.get(sourceURL).content;}
editable(){return false;}
editCompiled(ranges,texts){return Promise.resolve((null));}
findEntry(lineNumber,columnNumber){var mappings=this.mappings();var index=mappings.upperBound(undefined,(unused,entry)=>lineNumber-entry.lineNumber||columnNumber-entry.columnNumber);return index?mappings[index-1]:null;}
firstSourceLineMapping(sourceURL,lineNumber){var mappings=this._reversedMappings(sourceURL);var index=mappings.lowerBound(lineNumber,lineComparator);if(index>=mappings.length||mappings[index].sourceLineNumber!==lineNumber)
return null;return mappings[index];function lineComparator(lineNumber,mapping){return lineNumber-mapping.sourceLineNumber;}}
findReverseEntries(sourceURL,lineNumber,columnNumber){var mappings=this._reversedMappings(sourceURL);var endIndex=mappings.upperBound(undefined,(unused,entry)=>lineNumber-entry.sourceLineNumber||columnNumber-entry.sourceColumnNumber);var startIndex=endIndex;while(startIndex>0&&mappings[startIndex-1].sourceLineNumber===mappings[endIndex-1].sourceLineNumber&&mappings[startIndex-1].sourceColumnNumber===mappings[endIndex-1].sourceColumnNumber)
--startIndex;return mappings.slice(startIndex,endIndex);}
mappings(){if(this._mappings===null){this._mappings=[];this._eachSection(this._parseMap.bind(this));this._json=null;}
return(this._mappings);}
_reversedMappings(sourceURL){if(!this._sourceInfos.has(sourceURL))
return[];var mappings=this.mappings();var info=this._sourceInfos.get(sourceURL);if(info.reverseMappings===null)
info.reverseMappings=mappings.filter(mapping=>mapping.sourceURL===sourceURL).sort(sourceMappingComparator);return info.reverseMappings;function sourceMappingComparator(a,b){if(a.sourceLineNumber!==b.sourceLineNumber)
return a.sourceLineNumber-b.sourceLineNumber;if(a.sourceColumnNumber!==b.sourceColumnNumber)
return a.sourceColumnNumber-b.sourceColumnNumber;if(a.lineNumber!==b.lineNumber)
return a.lineNumber-b.lineNumber;return a.columnNumber-b.columnNumber;}}
_eachSection(callback){if(!this._json.sections){callback(this._json,0,0);return;}
for(var section of this._json.sections)
callback(section.map,section.offset.line,section.offset.column);}
_parseSources(sourceMap){var sourcesList=[];var sourceRoot=sourceMap.sourceRoot||'';if(sourceRoot&&!sourceRoot.endsWith('/'))
sourceRoot+='/';for(var i=0;i<sourceMap.sources.length;++i){var href=sourceRoot+sourceMap.sources[i];var url=Common.ParsedURL.completeURL(this._baseURL,href)||href;var source=sourceMap.sourcesContent&&sourceMap.sourcesContent[i];if(url===this._compiledURL&&source)
url+=Common.UIString('? [sm]');this._sourceInfos.set(url,new SDK.TextSourceMap.SourceInfo(source,null));sourcesList.push(url);}
sourceMap[SDK.TextSourceMap._sourcesListSymbol]=sourcesList;}
_parseMap(map,lineNumber,columnNumber){var sourceIndex=0;var sourceLineNumber=0;var sourceColumnNumber=0;var nameIndex=0;var sources=map[SDK.TextSourceMap._sourcesListSymbol];var names=map.names||[];var stringCharIterator=new SDK.TextSourceMap.StringCharIterator(map.mappings);var sourceURL=sources[sourceIndex];while(true){if(stringCharIterator.peek()===','){stringCharIterator.next();}else{while(stringCharIterator.peek()===';'){lineNumber+=1;columnNumber=0;stringCharIterator.next();}
if(!stringCharIterator.hasNext())
break;}
columnNumber+=this._decodeVLQ(stringCharIterator);if(!stringCharIterator.hasNext()||this._isSeparator(stringCharIterator.peek())){this._mappings.push(new SDK.SourceMapEntry(lineNumber,columnNumber));continue;}
var sourceIndexDelta=this._decodeVLQ(stringCharIterator);if(sourceIndexDelta){sourceIndex+=sourceIndexDelta;sourceURL=sources[sourceIndex];}
sourceLineNumber+=this._decodeVLQ(stringCharIterator);sourceColumnNumber+=this._decodeVLQ(stringCharIterator);if(!stringCharIterator.hasNext()||this._isSeparator(stringCharIterator.peek())){this._mappings.push(new SDK.SourceMapEntry(lineNumber,columnNumber,sourceURL,sourceLineNumber,sourceColumnNumber));continue;}
nameIndex+=this._decodeVLQ(stringCharIterator);this._mappings.push(new SDK.SourceMapEntry(lineNumber,columnNumber,sourceURL,sourceLineNumber,sourceColumnNumber,names[nameIndex]));}
this._mappings.stableSort(SDK.SourceMapEntry.compare);}
_isSeparator(char){return char===','||char===';';}
_decodeVLQ(stringCharIterator){var result=0;var shift=0;do{var digit=SDK.TextSourceMap._base64Map[stringCharIterator.next()];result+=(digit&SDK.TextSourceMap._VLQ_BASE_MASK)<<shift;shift+=SDK.TextSourceMap._VLQ_BASE_SHIFT;}while(digit&SDK.TextSourceMap._VLQ_CONTINUATION_MASK);var negative=result&1;result>>=1;return negative?-result:result;}
reverseMapTextRange(url,textRange){function comparator(position,mapping){if(position.lineNumber!==mapping.sourceLineNumber)
return position.lineNumber-mapping.sourceLineNumber;return position.columnNumber-mapping.sourceColumnNumber;}
var mappings=this._reversedMappings(url);var startIndex=mappings.lowerBound({lineNumber:textRange.startLine,columnNumber:textRange.startColumn},comparator);var endIndex=mappings.upperBound({lineNumber:textRange.endLine,columnNumber:textRange.endColumn},comparator);var startMapping=mappings[startIndex];var endMapping=mappings[endIndex];return new TextUtils.TextRange(startMapping.lineNumber,startMapping.columnNumber,endMapping.lineNumber,endMapping.columnNumber);}};SDK.TextSourceMap._VLQ_BASE_SHIFT=5;SDK.TextSourceMap._VLQ_BASE_MASK=(1<<5)-1;SDK.TextSourceMap._VLQ_CONTINUATION_MASK=1<<5;SDK.TextSourceMap.StringCharIterator=class{constructor(string){this._string=string;this._position=0;}
next(){return this._string.charAt(this._position++);}
peek(){return this._string.charAt(this._position);}
hasNext(){return this._position<this._string.length;}};SDK.TextSourceMap.SourceInfo=class{constructor(content,reverseMappings){this.content=content;this.reverseMappings=reverseMappings;}};SDK.TextSourceMap._sourcesListSymbol=Symbol('sourcesList');;SDK.SourceMapManager=class extends Common.Object{constructor(target){super();this._target=target;this._isEnabled=true;this._relativeSourceURL=new Map();this._relativeSourceMapURL=new Map();this._resolvedSourceMapURL=new Map();this._sourceMapByURL=new Map();this._sourceMapURLToLoadingClients=new Multimap();this._sourceMapURLToClients=new Multimap();SDK.targetManager.addEventListener(SDK.TargetManager.Events.InspectedURLChanged,this._inspectedURLChanged,this);}
setEnabled(isEnabled){if(isEnabled===this._isEnabled)
return;this._isEnabled=isEnabled;var clients=Array.from(this._resolvedSourceMapURL.keys());for(var client of clients){var relativeSourceURL=this._relativeSourceURL.get(client);var relativeSourceMapURL=this._relativeSourceMapURL.get(client);this.detachSourceMap(client);this.attachSourceMap(client,relativeSourceURL,relativeSourceMapURL);}}
_inspectedURLChanged(event){if(event.data!==this._target)
return;var clients=Array.from(this._resolvedSourceMapURL.keys());for(var client of clients){var relativeSourceURL=this._relativeSourceURL.get(client);var relativeSourceMapURL=this._relativeSourceMapURL.get(client);var resolvedSourceMapURL=this._resolvedSourceMapURL.get(client);var sourceMapURL=this._resolveRelativeURLs(relativeSourceURL,relativeSourceMapURL).sourceMapURL;if(sourceMapURL!==resolvedSourceMapURL){this.detachSourceMap(client);this.attachSourceMap(client,relativeSourceURL,relativeSourceMapURL);}}}
sourceMapForClient(client){var sourceMapURL=this._resolvedSourceMapURL.get(client);return sourceMapURL?this._sourceMapByURL.get(sourceMapURL)||null:null;}
clientsForSourceMap(sourceMap){if(this._sourceMapURLToClients.has(sourceMap.url()))
return this._sourceMapURLToClients.get(sourceMap.url()).valuesArray();return this._sourceMapURLToLoadingClients.get(sourceMap.url()).valuesArray();}
applySourceMapEdit(editResult){console.assert(this._sourceMapByURL.has(editResult.map.url()),'Cannot apply edit result for non-existing source map');this._sourceMapByURL.set(editResult.map.url(),editResult.map);this.dispatchEventToListeners(SDK.SourceMapManager.Events.SourceMapChanged,{sourceMap:editResult.map,newSources:editResult.newSources});}
_resolveRelativeURLs(sourceURL,sourceMapURL){var resolvedSourceURL=Common.ParsedURL.completeURL(this._target.inspectedURL(),sourceURL);var resolvedSourceMapURL=resolvedSourceURL?Common.ParsedURL.completeURL(resolvedSourceURL,sourceMapURL):null;return{sourceURL:resolvedSourceURL,sourceMapURL:resolvedSourceMapURL};}
attachSourceMap(client,sourceURL,sourceMapURL){if(!sourceMapURL)
return;console.assert(!this._resolvedSourceMapURL.has(client),'SourceMap is already attached to client');var resolvedURLs=this._resolveRelativeURLs(sourceURL,sourceMapURL);if(!resolvedURLs.sourceURL||!resolvedURLs.sourceMapURL)
return;this._relativeSourceURL.set(client,sourceURL);this._relativeSourceMapURL.set(client,sourceMapURL);this._resolvedSourceMapURL.set(client,resolvedURLs.sourceMapURL);sourceURL=resolvedURLs.sourceURL;sourceMapURL=resolvedURLs.sourceMapURL;if(!this._isEnabled)
return;this.dispatchEventToListeners(SDK.SourceMapManager.Events.SourceMapWillAttach,client);if(this._sourceMapByURL.has(sourceMapURL)){attach.call(this,sourceMapURL,client);return;}
if(!this._sourceMapURLToLoadingClients.has(sourceMapURL)){SDK.TextSourceMap.load(sourceMapURL,sourceURL).then(onTextSourceMapLoaded.bind(this,sourceMapURL)).then(onSourceMap.bind(this,sourceMapURL));}
this._sourceMapURLToLoadingClients.set(sourceMapURL,client);function onTextSourceMapLoaded(sourceMapURL,sourceMap){if(!sourceMap)
return Promise.resolve((null));var factoryExtension=this._factoryForSourceMap(sourceMap);if(!factoryExtension)
return Promise.resolve((sourceMap));return factoryExtension.instance().then(factory=>factory.editableSourceMap(this._target,sourceMap)).then(map=>map||sourceMap).catchException((null));}
function onSourceMap(sourceMapURL,sourceMap){this._sourceMapLoadedForTest();var clients=this._sourceMapURLToLoadingClients.get(sourceMapURL);this._sourceMapURLToLoadingClients.deleteAll(sourceMapURL);if(!clients.size)
return;if(!sourceMap){for(var client of clients)
this.dispatchEventToListeners(SDK.SourceMapManager.Events.SourceMapFailedToAttach,client);return;}
this._sourceMapByURL.set(sourceMapURL,sourceMap);for(var client of clients)
attach.call(this,sourceMapURL,client);}
function attach(sourceMapURL,client){this._sourceMapURLToClients.set(sourceMapURL,client);var sourceMap=this._sourceMapByURL.get(sourceMapURL);this.dispatchEventToListeners(SDK.SourceMapManager.Events.SourceMapAttached,{client:client,sourceMap:sourceMap});}}
_factoryForSourceMap(sourceMap){var sourceExtensions=new Set();for(var url of sourceMap.sourceURLs())
sourceExtensions.add(Common.ParsedURL.extractExtension(url));for(var runtimeExtension of self.runtime.extensions(SDK.SourceMapFactory)){var supportedExtensions=new Set(runtimeExtension.descriptor()['extensions']);if(supportedExtensions.containsAll(sourceExtensions))
return runtimeExtension;}
return null;}
detachSourceMap(client){var sourceMapURL=this._resolvedSourceMapURL.get(client);this._relativeSourceURL.delete(client);this._relativeSourceMapURL.delete(client);this._resolvedSourceMapURL.delete(client);if(!sourceMapURL)
return;if(!this._sourceMapURLToClients.hasValue(sourceMapURL,client)){if(this._sourceMapURLToLoadingClients.delete(sourceMapURL,client))
this.dispatchEventToListeners(SDK.SourceMapManager.Events.SourceMapFailedToAttach,client);return;}
this._sourceMapURLToClients.delete(sourceMapURL,client);var sourceMap=this._sourceMapByURL.get(sourceMapURL);if(!this._sourceMapURLToClients.has(sourceMapURL))
this._sourceMapByURL.delete(sourceMapURL);this.dispatchEventToListeners(SDK.SourceMapManager.Events.SourceMapDetached,{client:client,sourceMap:sourceMap});}
_sourceMapLoadedForTest(){}
dispose(){SDK.targetManager.removeEventListener(SDK.TargetManager.Events.InspectedURLChanged,this._inspectedURLChanged,this);}};SDK.SourceMapManager.Events={SourceMapWillAttach:Symbol('SourceMapWillAttach'),SourceMapFailedToAttach:Symbol('SourceMapFailedToAttach'),SourceMapAttached:Symbol('SourceMapAttached'),SourceMapDetached:Symbol('SourceMapDetached'),SourceMapChanged:Symbol('SourceMapChanged')};;SDK.NetworkManager=class extends SDK.SDKModel{constructor(target){super(target);this._dispatcher=new SDK.NetworkDispatcher(this);this._networkAgent=target.networkAgent();target.registerNetworkDispatcher(this._dispatcher);if(Common.moduleSetting('cacheDisabled').get())
this._networkAgent.setCacheDisabled(true);if(Runtime.queryParam('remoteFrontend')||Runtime.queryParam('ws'))
this._networkAgent.enable(10000000,5000000);else
this._networkAgent.enable();this._bypassServiceWorkerSetting=Common.settings.createSetting('bypassServiceWorker',false);if(this._bypassServiceWorkerSetting.get())
this._bypassServiceWorkerChanged();this._bypassServiceWorkerSetting.addChangeListener(this._bypassServiceWorkerChanged,this);Common.moduleSetting('cacheDisabled').addChangeListener(this._cacheDisabledSettingChanged,this);}
static forRequest(request){return request[SDK.NetworkManager._networkManagerForRequestSymbol];}
static canReplayRequest(request){return!!request[SDK.NetworkManager._networkManagerForRequestSymbol]&&request.resourceType()===Common.resourceTypes.XHR;}
static replayRequest(request){var manager=request[SDK.NetworkManager._networkManagerForRequestSymbol];if(!manager)
return;manager._networkAgent.replayXHR(request.requestId());}
static async requestContentData(request){if(request.resourceType()===Common.resourceTypes.WebSocket)
return{error:'Content for WebSockets is currently not supported',content:null,encoded:false};if(!request.finished)
await request.once(SDK.NetworkRequest.Events.FinishedLoading);var manager=SDK.NetworkManager.forRequest(request);if(!manager)
return{error:'No network manager for request',content:null,encoded:false};var response=await manager._networkAgent.invoke_getResponseBody({requestId:request.requestId()});var error=response[Protocol.Error]||null;return{error:error,content:error?null:response.body,encoded:response.base64Encoded};}
static _connectionType(conditions){if(!conditions.download&&!conditions.upload)
return Protocol.Network.ConnectionType.None;var types=SDK.NetworkManager._connectionTypes;if(!types){SDK.NetworkManager._connectionTypes=[];types=SDK.NetworkManager._connectionTypes;types.push(['2g',Protocol.Network.ConnectionType.Cellular2g]);types.push(['3g',Protocol.Network.ConnectionType.Cellular3g]);types.push(['4g',Protocol.Network.ConnectionType.Cellular4g]);types.push(['bluetooth',Protocol.Network.ConnectionType.Bluetooth]);types.push(['wifi',Protocol.Network.ConnectionType.Wifi]);types.push(['wimax',Protocol.Network.ConnectionType.Wimax]);}
for(var type of types){if(conditions.title.toLowerCase().indexOf(type[0])!==-1)
return type[1];}
return Protocol.Network.ConnectionType.Other;}
inflightRequestForURL(url){return this._dispatcher._inflightRequestsByURL[url];}
_cacheDisabledSettingChanged(event){var enabled=(event.data);this._networkAgent.setCacheDisabled(enabled);}
dispose(){Common.moduleSetting('cacheDisabled').removeChangeListener(this._cacheDisabledSettingChanged,this);}
_bypassServiceWorkerChanged(){this._networkAgent.setBypassServiceWorker(this._bypassServiceWorkerSetting.get());}};SDK.SDKModel.register(SDK.NetworkManager,SDK.Target.Capability.Network,true);SDK.NetworkManager.Events={RequestStarted:Symbol('RequestStarted'),RequestUpdated:Symbol('RequestUpdated'),RequestFinished:Symbol('RequestFinished'),RequestUpdateDropped:Symbol('RequestUpdateDropped'),ResponseReceived:Symbol('ResponseReceived'),MessageGenerated:Symbol('MessageGenerated'),RequestRedirected:Symbol('RequestRedirected'),};SDK.NetworkManager.Message;SDK.NetworkManager._MIMETypes={'text/html':{'document':true},'text/xml':{'document':true},'text/plain':{'document':true},'application/xhtml+xml':{'document':true},'image/svg+xml':{'document':true},'text/css':{'stylesheet':true},'text/xsl':{'stylesheet':true},'text/vtt':{'texttrack':true},};SDK.NetworkManager.Conditions;SDK.NetworkManager.NoThrottlingConditions={title:Common.UIString('Online'),download:-1,upload:-1,latency:0};SDK.NetworkManager.OfflineConditions={title:Common.UIString('Offline'),download:0,upload:0,latency:0,};SDK.NetworkManager.Slow3GConditions={title:Common.UIString('Slow 3G'),download:500*1024/8*.8,upload:500*1024/8*.8,latency:400*5,};SDK.NetworkManager.Fast3GConditions={title:Common.UIString('Fast 3G'),download:1.6*1024*1024/8*.9,upload:750*1024/8*.9,latency:150*3.75,};SDK.NetworkManager.BlockedPattern;SDK.NetworkManager._networkManagerForRequestSymbol=Symbol('NetworkManager');SDK.NetworkDispatcher=class{constructor(manager){this._manager=manager;this._inflightRequestsById={};this._inflightRequestsByURL={};}
_headersMapToHeadersArray(headersMap){var result=[];for(var name in headersMap){var values=headersMap[name].split('\n');for(var i=0;i<values.length;++i)
result.push({name:name,value:values[i]});}
return result;}
_updateNetworkRequestWithRequest(networkRequest,request){networkRequest.requestMethod=request.method;networkRequest.setRequestHeaders(this._headersMapToHeadersArray(request.headers));networkRequest.requestFormData=request.postData;networkRequest.setInitialPriority(request.initialPriority);networkRequest.mixedContentType=request.mixedContentType||Protocol.Security.MixedContentType.None;networkRequest.setReferrerPolicy(request.referrerPolicy);}
_updateNetworkRequestWithResponse(networkRequest,response){if(response.url&&networkRequest.url()!==response.url)
networkRequest.setUrl(response.url);networkRequest.mimeType=response.mimeType;networkRequest.statusCode=response.status;networkRequest.statusText=response.statusText;networkRequest.responseHeaders=this._headersMapToHeadersArray(response.headers);if(response.encodedDataLength>=0)
networkRequest.setTransferSize(response.encodedDataLength);if(response.headersText)
networkRequest.responseHeadersText=response.headersText;if(response.requestHeaders){networkRequest.setRequestHeaders(this._headersMapToHeadersArray(response.requestHeaders));networkRequest.setRequestHeadersText(response.requestHeadersText||'');}
networkRequest.connectionReused=response.connectionReused;networkRequest.connectionId=String(response.connectionId);if(response.remoteIPAddress)
networkRequest.setRemoteAddress(response.remoteIPAddress,response.remotePort||-1);if(response.fromServiceWorker)
networkRequest.fetchedViaServiceWorker=true;if(response.fromDiskCache)
networkRequest.setFromDiskCache();networkRequest.timing=response.timing;networkRequest.protocol=response.protocol;networkRequest.setSecurityState(response.securityState);if(!this._mimeTypeIsConsistentWithType(networkRequest)){var message=Common.UIString('Resource interpreted as %s but transferred with MIME type %s: "%s".',networkRequest.resourceType().title(),networkRequest.mimeType,networkRequest.url());this._manager.dispatchEventToListeners(SDK.NetworkManager.Events.MessageGenerated,{message:message,requestId:networkRequest.requestId(),warning:true});}
if(response.securityDetails)
networkRequest.setSecurityDetails(response.securityDetails);}
_mimeTypeIsConsistentWithType(networkRequest){if(networkRequest.hasErrorStatusCode()||networkRequest.statusCode===304||networkRequest.statusCode===204)
return true;var resourceType=networkRequest.resourceType();if(resourceType!==Common.resourceTypes.Stylesheet&&resourceType!==Common.resourceTypes.Document&&resourceType!==Common.resourceTypes.TextTrack)
return true;if(!networkRequest.mimeType)
return true;if(networkRequest.mimeType in SDK.NetworkManager._MIMETypes)
return resourceType.name()in SDK.NetworkManager._MIMETypes[networkRequest.mimeType];return false;}
resourceChangedPriority(requestId,newPriority,timestamp){var networkRequest=this._inflightRequestsById[requestId];if(networkRequest)
networkRequest.setPriority(newPriority);}
requestWillBeSent(requestId,loaderId,documentURL,request,time,wallTime,initiator,redirectResponse,resourceType,frameId){var networkRequest=this._inflightRequestsById[requestId];if(networkRequest){if(!redirectResponse)
return;this.responseReceived(requestId,loaderId,time,Protocol.Page.ResourceType.Other,redirectResponse,frameId);networkRequest=this._appendRedirect(requestId,time,request.url);this._manager.dispatchEventToListeners(SDK.NetworkManager.Events.RequestRedirected,networkRequest);}else{networkRequest=this._createNetworkRequest(requestId,frameId||'',loaderId,request.url,documentURL,initiator);}
networkRequest.hasNetworkData=true;this._updateNetworkRequestWithRequest(networkRequest,request);networkRequest.setIssueTime(time,wallTime);networkRequest.setResourceType(resourceType?Common.resourceTypes[resourceType]:Protocol.Page.ResourceType.Other);this._startNetworkRequest(networkRequest);}
requestServedFromCache(requestId){var networkRequest=this._inflightRequestsById[requestId];if(!networkRequest)
return;networkRequest.setFromMemoryCache();}
responseReceived(requestId,loaderId,time,resourceType,response,frameId){var networkRequest=this._inflightRequestsById[requestId];if(!networkRequest){var eventData={};eventData.url=response.url;eventData.frameId=frameId||'';eventData.loaderId=loaderId;eventData.resourceType=resourceType;eventData.mimeType=response.mimeType;var lastModifiedHeader=response.headers['last-modified'];eventData.lastModified=lastModifiedHeader?new Date(lastModifiedHeader):null;this._manager.dispatchEventToListeners(SDK.NetworkManager.Events.RequestUpdateDropped,eventData);return;}
networkRequest.responseReceivedTime=time;networkRequest.setResourceType(Common.resourceTypes[resourceType]);if('Set-Cookie'in response.headers&&response.headers['Set-Cookie'].length>4096){var message=Common.UIString('Set-Cookie header is ignored in response from url: %s. Cookie length should be less than or equal to 4096 characters.',response.url);this._manager.dispatchEventToListeners(SDK.NetworkManager.Events.MessageGenerated,{message:message,requestId:requestId,warning:true});}
this._updateNetworkRequestWithResponse(networkRequest,response);this._updateNetworkRequest(networkRequest);this._manager.dispatchEventToListeners(SDK.NetworkManager.Events.ResponseReceived,networkRequest);}
dataReceived(requestId,time,dataLength,encodedDataLength){var networkRequest=this._inflightRequestsById[requestId];if(!networkRequest)
return;networkRequest.resourceSize+=dataLength;if(encodedDataLength!==-1)
networkRequest.increaseTransferSize(encodedDataLength);networkRequest.endTime=time;this._updateNetworkRequest(networkRequest);}
loadingFinished(requestId,finishTime,encodedDataLength){var networkRequest=this._inflightRequestsById[requestId];if(!networkRequest)
return;this._finishNetworkRequest(networkRequest,finishTime,encodedDataLength);}
loadingFailed(requestId,time,resourceType,localizedDescription,canceled,blockedReason){var networkRequest=this._inflightRequestsById[requestId];if(!networkRequest)
return;networkRequest.failed=true;networkRequest.setResourceType(Common.resourceTypes[resourceType]);networkRequest.canceled=!!canceled;if(blockedReason){networkRequest.setBlockedReason(blockedReason);if(blockedReason===Protocol.Network.BlockedReason.Inspector){var message=Common.UIString('Request was blocked by DevTools: "%s".',networkRequest.url());this._manager.dispatchEventToListeners(SDK.NetworkManager.Events.MessageGenerated,{message:message,requestId:requestId,warning:true});}}
networkRequest.localizedFailDescription=localizedDescription;this._finishNetworkRequest(networkRequest,time,-1);}
webSocketCreated(requestId,requestURL,initiator){var networkRequest=new SDK.NetworkRequest(requestId,requestURL,'','','',initiator||null);networkRequest[SDK.NetworkManager._networkManagerForRequestSymbol]=this._manager;networkRequest.setResourceType(Common.resourceTypes.WebSocket);this._startNetworkRequest(networkRequest);}
webSocketWillSendHandshakeRequest(requestId,time,wallTime,request){var networkRequest=this._inflightRequestsById[requestId];if(!networkRequest)
return;networkRequest.requestMethod='GET';networkRequest.setRequestHeaders(this._headersMapToHeadersArray(request.headers));networkRequest.setIssueTime(time,wallTime);this._updateNetworkRequest(networkRequest);}
webSocketHandshakeResponseReceived(requestId,time,response){var networkRequest=this._inflightRequestsById[requestId];if(!networkRequest)
return;networkRequest.statusCode=response.status;networkRequest.statusText=response.statusText;networkRequest.responseHeaders=this._headersMapToHeadersArray(response.headers);networkRequest.responseHeadersText=response.headersText||'';if(response.requestHeaders)
networkRequest.setRequestHeaders(this._headersMapToHeadersArray(response.requestHeaders));if(response.requestHeadersText)
networkRequest.setRequestHeadersText(response.requestHeadersText);networkRequest.responseReceivedTime=time;networkRequest.protocol='websocket';this._updateNetworkRequest(networkRequest);}
webSocketFrameReceived(requestId,time,response){var networkRequest=this._inflightRequestsById[requestId];if(!networkRequest)
return;networkRequest.addFrame(response,time,false);networkRequest.responseReceivedTime=time;this._updateNetworkRequest(networkRequest);}
webSocketFrameSent(requestId,time,response){var networkRequest=this._inflightRequestsById[requestId];if(!networkRequest)
return;networkRequest.addFrame(response,time,true);networkRequest.responseReceivedTime=time;this._updateNetworkRequest(networkRequest);}
webSocketFrameError(requestId,time,errorMessage){var networkRequest=this._inflightRequestsById[requestId];if(!networkRequest)
return;networkRequest.addFrameError(errorMessage,time);networkRequest.responseReceivedTime=time;this._updateNetworkRequest(networkRequest);}
webSocketClosed(requestId,time){var networkRequest=this._inflightRequestsById[requestId];if(!networkRequest)
return;this._finishNetworkRequest(networkRequest,time,-1);}
eventSourceMessageReceived(requestId,time,eventName,eventId,data){var networkRequest=this._inflightRequestsById[requestId];if(!networkRequest)
return;networkRequest.addEventSourceMessage(time,eventName,eventId,data);}
requestIntercepted(requestId,request,resourceType,isNavigationRequest,redirectHeaders,redirectStatusCode,redirectUrl){}
_appendRedirect(requestId,time,redirectURL){var originalNetworkRequest=this._inflightRequestsById[requestId];var redirectCount=0;for(var redirect=originalNetworkRequest.redirectSource();redirect;redirect=redirect.redirectSource())
redirectCount++;originalNetworkRequest.setRequestId(requestId+':redirected.'+redirectCount);this._finishNetworkRequest(originalNetworkRequest,time,-1);var newNetworkRequest=this._createNetworkRequest(requestId,originalNetworkRequest.frameId,originalNetworkRequest.loaderId,redirectURL,originalNetworkRequest.documentURL,originalNetworkRequest.initiator());newNetworkRequest.setRedirectSource(originalNetworkRequest);return newNetworkRequest;}
_startNetworkRequest(networkRequest){this._inflightRequestsById[networkRequest.requestId()]=networkRequest;this._inflightRequestsByURL[networkRequest.url()]=networkRequest;this._manager.dispatchEventToListeners(SDK.NetworkManager.Events.RequestStarted,networkRequest);}
_updateNetworkRequest(networkRequest){this._manager.dispatchEventToListeners(SDK.NetworkManager.Events.RequestUpdated,networkRequest);}
_finishNetworkRequest(networkRequest,finishTime,encodedDataLength){networkRequest.endTime=finishTime;networkRequest.finished=true;if(encodedDataLength>=0)
networkRequest.setTransferSize(encodedDataLength);this._manager.dispatchEventToListeners(SDK.NetworkManager.Events.RequestFinished,networkRequest);delete this._inflightRequestsById[networkRequest.requestId()];delete this._inflightRequestsByURL[networkRequest.url()];if(Common.moduleSetting('monitoringXHREnabled').get()&&networkRequest.resourceType().category()===Common.resourceCategories.XHR){var message=Common.UIString((networkRequest.failed||networkRequest.hasErrorStatusCode())?'%s failed loading: %s "%s".':'%s finished loading: %s "%s".',networkRequest.resourceType().title(),networkRequest.requestMethod,networkRequest.url());this._manager.dispatchEventToListeners(SDK.NetworkManager.Events.MessageGenerated,{message:message,requestId:networkRequest.requestId(),warning:false});}}
_createNetworkRequest(requestId,frameId,loaderId,url,documentURL,initiator){var request=new SDK.NetworkRequest(requestId,url,documentURL,frameId,loaderId,initiator);request[SDK.NetworkManager._networkManagerForRequestSymbol]=this._manager;return request;}};SDK.MultitargetNetworkManager=class extends Common.Object{constructor(){super();this._userAgentOverride='';this._agents=new Set();this._networkConditions=SDK.NetworkManager.NoThrottlingConditions;this._blockingEnabledSetting=Common.moduleSetting('requestBlockingEnabled');this._blockedPatternsSetting=Common.settings.createSetting('networkBlockedPatterns',[]);this._effectiveBlockedURLs=[];this._updateBlockedPatterns();SDK.targetManager.observeTargets(this,SDK.Target.Capability.Network);}
static patchUserAgentWithChromeVersion(uaString){var chromeRegex=new RegExp('(?:^|\\W)Chrome/(\\S+)');var chromeMatch=navigator.userAgent.match(chromeRegex);if(chromeMatch&&chromeMatch.length>1)
return String.sprintf(uaString,chromeMatch[1]);return uaString;}
targetAdded(target){var networkAgent=target.networkAgent();if(this._extraHeaders)
networkAgent.setExtraHTTPHeaders(this._extraHeaders);if(this._currentUserAgent())
networkAgent.setUserAgentOverride(this._currentUserAgent());if(this._effectiveBlockedURLs.length)
networkAgent.setBlockedURLs(this._effectiveBlockedURLs);this._agents.add(networkAgent);if(this.isThrottling())
this._updateNetworkConditions(networkAgent);}
targetRemoved(target){this._agents.delete(target.networkAgent());}
isThrottling(){return this._networkConditions.download>=0||this._networkConditions.upload>=0||this._networkConditions.latency>0;}
isOffline(){return!this._networkConditions.download&&!this._networkConditions.upload;}
setNetworkConditions(conditions){this._networkConditions=conditions;for(var agent of this._agents)
this._updateNetworkConditions(agent);this.dispatchEventToListeners(SDK.MultitargetNetworkManager.Events.ConditionsChanged);}
networkConditions(){return this._networkConditions;}
_updateNetworkConditions(networkAgent){var conditions=this._networkConditions;if(!this.isThrottling()){networkAgent.emulateNetworkConditions(false,0,0,0);}else{networkAgent.emulateNetworkConditions(this.isOffline(),conditions.latency,conditions.download<0?0:conditions.download,conditions.upload<0?0:conditions.upload,SDK.NetworkManager._connectionType(conditions));}}
setExtraHTTPHeaders(headers){this._extraHeaders=headers;for(var agent of this._agents)
agent.setExtraHTTPHeaders(this._extraHeaders);}
_currentUserAgent(){return this._customUserAgent?this._customUserAgent:this._userAgentOverride;}
_updateUserAgentOverride(){var userAgent=this._currentUserAgent();for(var agent of this._agents)
agent.setUserAgentOverride(userAgent);}
setUserAgentOverride(userAgent){if(this._userAgentOverride===userAgent)
return;this._userAgentOverride=userAgent;if(!this._customUserAgent)
this._updateUserAgentOverride();this.dispatchEventToListeners(SDK.MultitargetNetworkManager.Events.UserAgentChanged);}
userAgentOverride(){return this._userAgentOverride;}
setCustomUserAgentOverride(userAgent){this._customUserAgent=userAgent;this._updateUserAgentOverride();}
blockedPatterns(){return this._blockedPatternsSetting.get().slice();}
blockingEnabled(){return this._blockingEnabledSetting.get();}
isBlocking(){return!!this._effectiveBlockedURLs.length;}
setBlockedPatterns(patterns){this._blockedPatternsSetting.set(patterns);this._updateBlockedPatterns();this.dispatchEventToListeners(SDK.MultitargetNetworkManager.Events.BlockedPatternsChanged);}
setBlockingEnabled(enabled){if(this._blockingEnabledSetting.get()===enabled)
return;this._blockingEnabledSetting.set(enabled);this._updateBlockedPatterns();this.dispatchEventToListeners(SDK.MultitargetNetworkManager.Events.BlockedPatternsChanged);}
_updateBlockedPatterns(){var urls=[];if(this._blockingEnabledSetting.get()){for(var pattern of this._blockedPatternsSetting.get()){if(pattern.enabled)
urls.push(pattern.url);}}
if(!urls.length&&!this._effectiveBlockedURLs.length)
return;this._effectiveBlockedURLs=urls;for(var agent of this._agents)
agent.setBlockedURLs(this._effectiveBlockedURLs);}
clearBrowserCache(){for(var agent of this._agents)
agent.clearBrowserCache();}
clearBrowserCookies(){for(var agent of this._agents)
agent.clearBrowserCookies();}
getCertificate(origin){var target=SDK.targetManager.mainTarget();return target.networkAgent().getCertificate(origin).then(certificate=>certificate||[]);}
loadResource(url,callback){var headers={};var currentUserAgent=this._currentUserAgent();if(currentUserAgent)
headers['User-Agent']=currentUserAgent;if(Common.moduleSetting('cacheDisabled').get())
headers['Cache-Control']='no-cache';Host.ResourceLoader.load(url,headers,callback);}};SDK.MultitargetNetworkManager.Events={BlockedPatternsChanged:Symbol('BlockedPatternsChanged'),ConditionsChanged:Symbol('ConditionsChanged'),UserAgentChanged:Symbol('UserAgentChanged')};SDK.multitargetNetworkManager;;SDK.NetworkRequest=class extends Common.Object{constructor(requestId,url,documentURL,frameId,loaderId,initiator){super();this._requestId=requestId;this.setUrl(url);this._documentURL=documentURL;this._frameId=frameId;this._loaderId=loaderId;this._initiator=initiator;this._redirectSource=null;this._issueTime=-1;this._startTime=-1;this._endTime=-1;this._blockedReason=undefined;this.statusCode=0;this.statusText='';this.requestMethod='';this.requestTime=0;this.protocol='';this.mixedContentType=Protocol.Security.MixedContentType.None;this._initialPriority=null;this._currentPriority=null;this._resourceType=Common.resourceTypes.Other;this._contentData=null;this._frames=[];this._eventSourceMessages=[];this._responseHeaderValues={};this._responseHeadersText='';this._requestHeaders=[];this._requestHeaderValues={};this._remoteAddress='';this._referrerPolicy=null;this._securityState=Protocol.Security.SecurityState.Unknown;this._securityDetails=null;this.connectionId='0';}
indentityCompare(other){if(this._requestId>other._requestId)
return 1;if(this._requestId<other._requestId)
return-1;return 0;}
requestId(){return this._requestId;}
setRequestId(requestId){this._requestId=requestId;}
url(){return this._url;}
setUrl(x){if(this._url===x)
return;this._url=x;this._parsedURL=new Common.ParsedURL(x);delete this._queryString;delete this._parsedQueryParameters;delete this._name;delete this._path;}
get documentURL(){return this._documentURL;}
get parsedURL(){return this._parsedURL;}
get frameId(){return this._frameId;}
get loaderId(){return this._loaderId;}
setRemoteAddress(ip,port){this._remoteAddress=ip+':'+port;this.dispatchEventToListeners(SDK.NetworkRequest.Events.RemoteAddressChanged,this);}
remoteAddress(){return this._remoteAddress;}
setReferrerPolicy(referrerPolicy){this._referrerPolicy=referrerPolicy;}
referrerPolicy(){return this._referrerPolicy;}
securityState(){return this._securityState;}
setSecurityState(securityState){this._securityState=securityState;}
securityDetails(){return this._securityDetails;}
setSecurityDetails(securityDetails){this._securityDetails=securityDetails;}
get startTime(){return this._startTime||-1;}
setIssueTime(monotonicTime,wallTime){this._issueTime=monotonicTime;this._wallIssueTime=wallTime;this._startTime=monotonicTime;}
issueTime(){return this._issueTime;}
pseudoWallTime(monotonicTime){return this._wallIssueTime?this._wallIssueTime-this._issueTime+monotonicTime:monotonicTime;}
get responseReceivedTime(){return this._responseReceivedTime||-1;}
set responseReceivedTime(x){this._responseReceivedTime=x;}
get endTime(){return this._endTime||-1;}
set endTime(x){if(this.timing&&this.timing.requestTime){this._endTime=Math.max(x,this.responseReceivedTime);}else{this._endTime=x;if(this._responseReceivedTime>x)
this._responseReceivedTime=x;}
this.dispatchEventToListeners(SDK.NetworkRequest.Events.TimingChanged,this);}
get duration(){if(this._endTime===-1||this._startTime===-1)
return-1;return this._endTime-this._startTime;}
get latency(){if(this._responseReceivedTime===-1||this._startTime===-1)
return-1;return this._responseReceivedTime-this._startTime;}
get resourceSize(){return this._resourceSize||0;}
set resourceSize(x){this._resourceSize=x;}
get transferSize(){return this._transferSize||0;}
increaseTransferSize(x){this._transferSize=(this._transferSize||0)+x;}
setTransferSize(x){this._transferSize=x;}
get finished(){return this._finished;}
set finished(x){if(this._finished===x)
return;this._finished=x;if(x)
this.dispatchEventToListeners(SDK.NetworkRequest.Events.FinishedLoading,this);}
get failed(){return this._failed;}
set failed(x){this._failed=x;}
get canceled(){return this._canceled;}
set canceled(x){this._canceled=x;}
blockedReason(){return this._blockedReason;}
setBlockedReason(reason){this._blockedReason=reason;}
wasBlocked(){return!!this._blockedReason;}
cached(){return(!!this._fromMemoryCache||!!this._fromDiskCache)&&!this._transferSize;}
cachedInMemory(){return!!this._fromMemoryCache&&!this._transferSize;}
setFromMemoryCache(){this._fromMemoryCache=true;delete this._timing;}
setFromDiskCache(){this._fromDiskCache=true;}
get fetchedViaServiceWorker(){return this._fetchedViaServiceWorker;}
set fetchedViaServiceWorker(x){this._fetchedViaServiceWorker=x;}
get timing(){return this._timing;}
set timing(timingInfo){if(!timingInfo||this._fromMemoryCache)
return;this._startTime=timingInfo.requestTime;var headersReceivedTime=timingInfo.requestTime+timingInfo.receiveHeadersEnd/1000.0;if((this._responseReceivedTime||-1)<0||this._responseReceivedTime>headersReceivedTime)
this._responseReceivedTime=headersReceivedTime;if(this._startTime>this._responseReceivedTime)
this._responseReceivedTime=this._startTime;this._timing=timingInfo;this.dispatchEventToListeners(SDK.NetworkRequest.Events.TimingChanged,this);}
get mimeType(){return this._mimeType;}
set mimeType(x){this._mimeType=x;}
get displayName(){return this._parsedURL.displayName;}
name(){if(this._name)
return this._name;this._parseNameAndPathFromURL();return this._name;}
path(){if(this._path)
return this._path;this._parseNameAndPathFromURL();return this._path;}
_parseNameAndPathFromURL(){if(this._parsedURL.isDataURL()){this._name=this._parsedURL.dataURLDisplayName();this._path='';}else if(this._parsedURL.isAboutBlank()){this._name=this._parsedURL.url;this._path='';}else{this._path=this._parsedURL.host+this._parsedURL.folderPathComponents;var networkManager=SDK.NetworkManager.forRequest(this);var inspectedURL=networkManager?networkManager.target().inspectedURL().asParsedURL():null;this._path=this._path.trimURL(inspectedURL?inspectedURL.host:'');if(this._parsedURL.lastPathComponent||this._parsedURL.queryParams){this._name=this._parsedURL.lastPathComponent+(this._parsedURL.queryParams?'?'+this._parsedURL.queryParams:'');}else if(this._parsedURL.folderPathComponents){this._name=this._parsedURL.folderPathComponents.substring(this._parsedURL.folderPathComponents.lastIndexOf('/')+1)+'/';this._path=this._path.substring(0,this._path.lastIndexOf('/'));}else{this._name=this._parsedURL.host;this._path='';}}}
get folder(){var path=this._parsedURL.path;var indexOfQuery=path.indexOf('?');if(indexOfQuery!==-1)
path=path.substring(0,indexOfQuery);var lastSlashIndex=path.lastIndexOf('/');return lastSlashIndex!==-1?path.substring(0,lastSlashIndex):'';}
resourceType(){return this._resourceType;}
setResourceType(resourceType){this._resourceType=resourceType;}
get domain(){return this._parsedURL.host;}
get scheme(){return this._parsedURL.scheme;}
redirectSource(){return this._redirectSource;}
setRedirectSource(originatingRequest){this._redirectSource=originatingRequest;}
requestHeaders(){return this._requestHeaders;}
setRequestHeaders(headers){this._requestHeaders=headers;delete this._requestCookies;this.dispatchEventToListeners(SDK.NetworkRequest.Events.RequestHeadersChanged);}
requestHeadersText(){return this._requestHeadersText;}
setRequestHeadersText(text){this._requestHeadersText=text;this.dispatchEventToListeners(SDK.NetworkRequest.Events.RequestHeadersChanged);}
requestHeaderValue(headerName){if(headerName in this._requestHeaderValues)
return this._requestHeaderValues[headerName];this._requestHeaderValues[headerName]=this._computeHeaderValue(this.requestHeaders(),headerName);return this._requestHeaderValues[headerName];}
get requestCookies(){if(!this._requestCookies)
this._requestCookies=SDK.CookieParser.parseCookie(this.requestHeaderValue('Cookie'));return this._requestCookies;}
get requestFormData(){return this._requestFormData;}
set requestFormData(x){this._requestFormData=x;delete this._parsedFormParameters;}
_filteredProtocolName(){var protocol=this.protocol.toLowerCase();if(protocol==='h2')
return'http/2.0';return protocol.replace(/^http\/2(\.0)?\+/,'http/2.0+');}
requestHttpVersion(){var headersText=this.requestHeadersText();if(!headersText){var version=this.requestHeaderValue('version')||this.requestHeaderValue(':version');if(version)
return version;return this._filteredProtocolName();}
var firstLine=headersText.split(/\r\n/)[0];var match=firstLine.match(/(HTTP\/\d+\.\d+)$/);return match?match[1]:'HTTP/0.9';}
get responseHeaders(){return this._responseHeaders||[];}
set responseHeaders(x){this._responseHeaders=x;delete this._sortedResponseHeaders;delete this._serverTimings;delete this._responseCookies;this._responseHeaderValues={};this.dispatchEventToListeners(SDK.NetworkRequest.Events.ResponseHeadersChanged);}
get responseHeadersText(){return this._responseHeadersText;}
set responseHeadersText(x){this._responseHeadersText=x;this.dispatchEventToListeners(SDK.NetworkRequest.Events.ResponseHeadersChanged);}
get sortedResponseHeaders(){if(this._sortedResponseHeaders!==undefined)
return this._sortedResponseHeaders;this._sortedResponseHeaders=this.responseHeaders.slice();this._sortedResponseHeaders.sort(function(a,b){return a.name.toLowerCase().compareTo(b.name.toLowerCase());});return this._sortedResponseHeaders;}
responseHeaderValue(headerName){if(headerName in this._responseHeaderValues)
return this._responseHeaderValues[headerName];this._responseHeaderValues[headerName]=this._computeHeaderValue(this.responseHeaders,headerName);return this._responseHeaderValues[headerName];}
get responseCookies(){if(!this._responseCookies)
this._responseCookies=SDK.CookieParser.parseSetCookie(this.responseHeaderValue('Set-Cookie'));return this._responseCookies;}
responseLastModified(){return this.responseHeaderValue('last-modified');}
get serverTimings(){if(typeof this._serverTimings==='undefined')
this._serverTimings=SDK.ServerTiming.parseHeaders(this.responseHeaders);return this._serverTimings;}
queryString(){if(this._queryString!==undefined)
return this._queryString;var queryString=null;var url=this.url();var questionMarkPosition=url.indexOf('?');if(questionMarkPosition!==-1){queryString=url.substring(questionMarkPosition+1);var hashSignPosition=queryString.indexOf('#');if(hashSignPosition!==-1)
queryString=queryString.substring(0,hashSignPosition);}
this._queryString=queryString;return this._queryString;}
get queryParameters(){if(this._parsedQueryParameters)
return this._parsedQueryParameters;var queryString=this.queryString();if(!queryString)
return null;this._parsedQueryParameters=this._parseParameters(queryString);return this._parsedQueryParameters;}
get formParameters(){if(this._parsedFormParameters)
return this._parsedFormParameters;if(!this.requestFormData)
return null;var requestContentType=this.requestContentType();if(!requestContentType||!requestContentType.match(/^application\/x-www-form-urlencoded\s*(;.*)?$/i))
return null;this._parsedFormParameters=this._parseParameters(this.requestFormData);return this._parsedFormParameters;}
responseHttpVersion(){var headersText=this._responseHeadersText;if(!headersText){var version=this.responseHeaderValue('version')||this.responseHeaderValue(':version');if(version)
return version;return this._filteredProtocolName();}
var firstLine=headersText.split(/\r\n/)[0];var match=firstLine.match(/^(HTTP\/\d+\.\d+)/);return match?match[1]:'HTTP/0.9';}
_parseParameters(queryString){function parseNameValue(pair){var position=pair.indexOf('=');if(position===-1)
return{name:pair,value:''};else
return{name:pair.substring(0,position),value:pair.substring(position+1)};}
return queryString.split('&').map(parseNameValue);}
_computeHeaderValue(headers,headerName){headerName=headerName.toLowerCase();var values=[];for(var i=0;i<headers.length;++i){if(headers[i].name.toLowerCase()===headerName)
values.push(headers[i].value);}
if(!values.length)
return undefined;if(headerName==='set-cookie')
return values.join('\n');return values.join(', ');}
contentData(){if(this._contentData)
return this._contentData;this._contentData=SDK.NetworkManager.requestContentData(this);return this._contentData;}
setContentData(data){console.assert(!this._contentData,'contentData can only be set once.');this._contentData=Promise.resolve(data);}
contentURL(){return this._url;}
contentType(){return this._resourceType;}
async requestContent(){return(await this.contentData()).content;}
searchInContent(query,caseSensitive,isRegex){return Promise.resolve([]);}
isHttpFamily(){return!!this.url().match(/^https?:/i);}
requestContentType(){return this.requestHeaderValue('Content-Type');}
hasErrorStatusCode(){return this.statusCode>=400;}
setInitialPriority(priority){this._initialPriority=priority;}
initialPriority(){return this._initialPriority;}
setPriority(priority){this._currentPriority=priority;}
priority(){return this._currentPriority||this._initialPriority||null;}
populateImageSource(image){function onResourceContent(content){var imageSrc=Common.ContentProvider.contentAsDataURL(content,this._mimeType,true);if(imageSrc===null)
imageSrc=this._url;image.src=imageSrc;}
this.requestContent().then(onResourceContent.bind(this));}
initiator(){return this._initiator;}
frames(){return this._frames;}
addFrameError(errorMessage,time){this._addFrame({type:SDK.NetworkRequest.WebSocketFrameType.Error,text:errorMessage,time:this.pseudoWallTime(time),opCode:-1,mask:false});}
addFrame(response,time,sent){var type=sent?SDK.NetworkRequest.WebSocketFrameType.Send:SDK.NetworkRequest.WebSocketFrameType.Receive;this._addFrame({type:type,text:response.payloadData,time:this.pseudoWallTime(time),opCode:response.opcode,mask:response.mask});}
_addFrame(frame){this._frames.push(frame);this.dispatchEventToListeners(SDK.NetworkRequest.Events.WebsocketFrameAdded,frame);}
eventSourceMessages(){return this._eventSourceMessages;}
addEventSourceMessage(time,eventName,eventId,data){var message={time:this.pseudoWallTime(time),eventName:eventName,eventId:eventId,data:data};this._eventSourceMessages.push(message);this.dispatchEventToListeners(SDK.NetworkRequest.Events.EventSourceMessageAdded,message);}};SDK.NetworkRequest.Events={FinishedLoading:Symbol('FinishedLoading'),TimingChanged:Symbol('TimingChanged'),RemoteAddressChanged:Symbol('RemoteAddressChanged'),RequestHeadersChanged:Symbol('RequestHeadersChanged'),ResponseHeadersChanged:Symbol('ResponseHeadersChanged'),WebsocketFrameAdded:Symbol('WebsocketFrameAdded'),EventSourceMessageAdded:Symbol('EventSourceMessageAdded')};SDK.NetworkRequest.InitiatorType={Other:'other',Parser:'parser',Redirect:'redirect',Script:'script',Preload:'preload'};SDK.NetworkRequest.NameValue;SDK.NetworkRequest.WebSocketFrameType={Send:'send',Receive:'receive',Error:'error'};SDK.NetworkRequest.WebSocketFrame;SDK.NetworkRequest.EventSourceMessage;SDK.NetworkRequest.ContentData;;SDK.PaintProfilerModel=class extends SDK.SDKModel{constructor(target){super(target);this._layerTreeAgent=target.layerTreeAgent();}
async loadSnapshotFromFragments(fragments){var snapshotId=await this._layerTreeAgent.loadSnapshot(fragments);return snapshotId&&new SDK.PaintProfilerSnapshot(this,snapshotId);}
loadSnapshot(encodedPicture){var fragment={x:0,y:0,picture:encodedPicture};return this.loadSnapshotFromFragments([fragment]);}
async makeSnapshot(layerId){var snapshotId=await this._layerTreeAgent.makeSnapshot(layerId);return snapshotId&&new SDK.PaintProfilerSnapshot(this,snapshotId);}};SDK.SDKModel.register(SDK.PaintProfilerModel,SDK.Target.Capability.DOM,false);SDK.PictureFragment;SDK.PaintProfilerSnapshot=class{constructor(paintProfilerModel,snapshotId){this._paintProfilerModel=paintProfilerModel;this._id=snapshotId;this._refCount=1;}
release(){console.assert(this._refCount>0,'release is already called on the object');if(!--this._refCount)
this._paintProfilerModel._layerTreeAgent.releaseSnapshot(this._id);}
addReference(){++this._refCount;console.assert(this._refCount>0,'Referencing a dead object');}
replay(scale,firstStep,lastStep){return this._paintProfilerModel._layerTreeAgent.replaySnapshot(this._id,firstStep,lastStep,scale||1.0);}
profile(clipRect){return this._paintProfilerModel._layerTreeAgent.profileSnapshot(this._id,5,1,clipRect||undefined);}
async commandLog(){var log=await this._paintProfilerModel._layerTreeAgent.snapshotCommandLog(this._id);return log&&log.map((entry,index)=>new SDK.PaintProfilerLogItem(entry,index));}};SDK.RawPaintProfilerLogItem;SDK.PaintProfilerLogItem=class{constructor(rawEntry,commandIndex){this.method=rawEntry.method;this.params=rawEntry.params;this.commandIndex=commandIndex;}};;SDK.HeapProfilerModel=class extends SDK.SDKModel{constructor(target){super(target);target.registerHeapProfilerDispatcher(new SDK.HeapProfilerDispatcher(this));this._enabled=false;this._heapProfilerAgent=target.heapProfilerAgent();this._runtimeModel=(target.model(SDK.RuntimeModel));}
debuggerModel(){return this._runtimeModel.debuggerModel();}
runtimeModel(){return this._runtimeModel;}
enable(){if(this._enabled)
return;this._enabled=true;this._heapProfilerAgent.enable();}
startSampling(){var defaultSamplingIntervalInBytes=16384;this._heapProfilerAgent.startSampling(defaultSamplingIntervalInBytes);}
stopSampling(){this._isRecording=false;return this._heapProfilerAgent.stopSampling();}
collectGarbage(){return this._heapProfilerAgent.collectGarbage();}
snapshotObjectIdForObjectId(objectId){return this._heapProfilerAgent.getHeapObjectId(objectId);}
objectForSnapshotObjectId(snapshotObjectId,objectGroupName){return this._heapProfilerAgent.getObjectByHeapObjectId(snapshotObjectId,objectGroupName).then(result=>result&&result.type?this._runtimeModel.createRemoteObject(result):null);}
addInspectedHeapObject(snapshotObjectId){return this._heapProfilerAgent.addInspectedHeapObject(snapshotObjectId);}
takeHeapSnapshot(reportProgress){return this._heapProfilerAgent.takeHeapSnapshot(reportProgress);}
startTrackingHeapObjects(recordAllocationStacks){return this._heapProfilerAgent.startTrackingHeapObjects(recordAllocationStacks);}
stopTrackingHeapObjects(reportProgress){return this._heapProfilerAgent.stopTrackingHeapObjects(reportProgress);}
heapStatsUpdate(samples){this.dispatchEventToListeners(SDK.HeapProfilerModel.Events.HeapStatsUpdate,samples);}
lastSeenObjectId(lastSeenObjectId,timestamp){this.dispatchEventToListeners(SDK.HeapProfilerModel.Events.LastSeenObjectId,{lastSeenObjectId:lastSeenObjectId,timestamp:timestamp});}
addHeapSnapshotChunk(chunk){this.dispatchEventToListeners(SDK.HeapProfilerModel.Events.AddHeapSnapshotChunk,chunk);}
reportHeapSnapshotProgress(done,total,finished){this.dispatchEventToListeners(SDK.HeapProfilerModel.Events.ReportHeapSnapshotProgress,{done:done,total:total,finished:finished});}
resetProfiles(){this.dispatchEventToListeners(SDK.HeapProfilerModel.Events.ResetProfiles,this);}};SDK.SDKModel.register(SDK.HeapProfilerModel,SDK.Target.Capability.JS,false);SDK.HeapProfilerModel.Events={HeapStatsUpdate:Symbol('HeapStatsUpdate'),LastSeenObjectId:Symbol('LastSeenObjectId'),AddHeapSnapshotChunk:Symbol('AddHeapSnapshotChunk'),ReportHeapSnapshotProgress:Symbol('ReportHeapSnapshotProgress'),ResetProfiles:Symbol('ResetProfiles')};SDK.HeapProfilerDispatcher=class{constructor(model){this._heapProfilerModel=model;}
heapStatsUpdate(samples){this._heapProfilerModel.heapStatsUpdate(samples);}
lastSeenObjectId(lastSeenObjectId,timestamp){this._heapProfilerModel.lastSeenObjectId(lastSeenObjectId,timestamp);}
addHeapSnapshotChunk(chunk){this._heapProfilerModel.addHeapSnapshotChunk(chunk);}
reportHeapSnapshotProgress(done,total,finished){this._heapProfilerModel.reportHeapSnapshotProgress(done,total,finished);}
resetProfiles(){this._heapProfilerModel.resetProfiles();}};;SDK.CSSMetadata._generatedProperties=[{"name":"-webkit-app-region"},{"name":"-webkit-appearance"},{"name":"-webkit-background-clip"},{"name":"-webkit-background-origin"},{"longhands":["-webkit-border-after-width","-webkit-border-after-style","-webkit-border-after-color"],"name":"-webkit-border-after"},{"name":"-webkit-border-after-color"},{"name":"-webkit-border-after-style"},{"name":"-webkit-border-after-width"},{"longhands":["-webkit-border-before-width","-webkit-border-before-style","-webkit-border-before-color"],"name":"-webkit-border-before"},{"name":"-webkit-border-before-color"},{"name":"-webkit-border-before-style"},{"name":"-webkit-border-before-width"},{"longhands":["-webkit-border-end-width","-webkit-border-end-style","-webkit-border-end-color"],"name":"-webkit-border-end"},{"name":"-webkit-border-end-color"},{"name":"-webkit-border-end-style"},{"name":"-webkit-border-end-width"},{"name":"-webkit-border-horizontal-spacing","inherited":true},{"name":"-webkit-border-image"},{"longhands":["-webkit-border-start-width","-webkit-border-start-style","-webkit-border-start-color"],"name":"-webkit-border-start"},{"name":"-webkit-border-start-color"},{"name":"-webkit-border-start-style"},{"name":"-webkit-border-start-width"},{"name":"-webkit-border-vertical-spacing","inherited":true},{"name":"-webkit-box-align"},{"name":"-webkit-box-decoration-break"},{"name":"-webkit-box-direction","inherited":true},{"name":"-webkit-box-flex"},{"name":"-webkit-box-flex-group"},{"name":"-webkit-box-lines"},{"name":"-webkit-box-ordinal-group"},{"name":"-webkit-box-orient"},{"name":"-webkit-box-pack"},{"name":"-webkit-box-reflect"},{"longhands":["break-after"],"name":"-webkit-column-break-after"},{"longhands":["break-before"],"name":"-webkit-column-break-before"},{"longhands":["break-inside"],"name":"-webkit-column-break-inside"},{"name":"-webkit-font-size-delta"},{"name":"-webkit-font-smoothing","inherited":true},{"name":"-webkit-highlight","inherited":true},{"name":"-webkit-hyphenate-character","inherited":true},{"name":"-webkit-line-break","inherited":true},{"name":"-webkit-line-clamp"},{"name":"-webkit-locale","inherited":true},{"name":"-webkit-logical-height"},{"name":"-webkit-logical-width"},{"name":"-webkit-margin-after"},{"name":"-webkit-margin-after-collapse"},{"name":"-webkit-margin-before"},{"name":"-webkit-margin-before-collapse"},{"name":"-webkit-margin-bottom-collapse"},{"longhands":["-webkit-margin-before-collapse","-webkit-margin-after-collapse"],"name":"-webkit-margin-collapse"},{"name":"-webkit-margin-end"},{"name":"-webkit-margin-start"},{"name":"-webkit-margin-top-collapse"},{"longhands":["-webkit-mask-image","-webkit-mask-position-x","-webkit-mask-position-y","-webkit-mask-size","-webkit-mask-repeat-x","-webkit-mask-repeat-y","-webkit-mask-origin","-webkit-mask-clip"],"name":"-webkit-mask"},{"longhands":["-webkit-mask-box-image-source","-webkit-mask-box-image-slice","-webkit-mask-box-image-width","-webkit-mask-box-image-outset","-webkit-mask-box-image-repeat"],"name":"-webkit-mask-box-image"},{"name":"-webkit-mask-box-image-outset"},{"name":"-webkit-mask-box-image-repeat"},{"name":"-webkit-mask-box-image-slice"},{"name":"-webkit-mask-box-image-source"},{"name":"-webkit-mask-box-image-width"},{"name":"-webkit-mask-clip"},{"name":"-webkit-mask-composite"},{"name":"-webkit-mask-image"},{"name":"-webkit-mask-origin"},{"longhands":["-webkit-mask-position-x","-webkit-mask-position-y"],"name":"-webkit-mask-position"},{"name":"-webkit-mask-position-x"},{"name":"-webkit-mask-position-y"},{"longhands":["-webkit-mask-repeat-x","-webkit-mask-repeat-y"],"name":"-webkit-mask-repeat"},{"name":"-webkit-mask-repeat-x"},{"name":"-webkit-mask-repeat-y"},{"name":"-webkit-mask-size"},{"name":"-webkit-max-logical-height"},{"name":"-webkit-max-logical-width"},{"name":"-webkit-min-logical-height"},{"name":"-webkit-min-logical-width"},{"name":"-webkit-padding-after"},{"name":"-webkit-padding-before"},{"name":"-webkit-padding-end"},{"name":"-webkit-padding-start"},{"name":"-webkit-perspective-origin-x"},{"name":"-webkit-perspective-origin-y"},{"name":"-webkit-print-color-adjust","inherited":true},{"name":"-webkit-rtl-ordering","inherited":true},{"name":"-webkit-ruby-position","inherited":true},{"name":"-webkit-tap-highlight-color","inherited":true},{"name":"-webkit-text-combine","inherited":true},{"name":"-webkit-text-decorations-in-effect","inherited":true},{"longhands":["-webkit-text-emphasis-style","-webkit-text-emphasis-color"],"name":"-webkit-text-emphasis"},{"name":"-webkit-text-emphasis-color","inherited":true},{"name":"-webkit-text-emphasis-position","inherited":true},{"inherited":true,"name":"-webkit-text-emphasis-style"},{"name":"-webkit-text-fill-color","inherited":true},{"name":"-webkit-text-orientation","inherited":true},{"name":"-webkit-text-security","inherited":true},{"longhands":["-webkit-text-stroke-width","-webkit-text-stroke-color"],"name":"-webkit-text-stroke"},{"name":"-webkit-text-stroke-color","inherited":true},{"name":"-webkit-text-stroke-width","inherited":true},{"name":"-webkit-transform-origin-x"},{"name":"-webkit-transform-origin-y"},{"name":"-webkit-transform-origin-z"},{"name":"-webkit-user-drag"},{"name":"-webkit-user-modify","inherited":true},{"name":"-webkit-writing-mode","inherited":true},{"name":"align-content"},{"name":"align-items"},{"name":"align-self"},{"svg":true,"name":"alignment-baseline"},{"name":"all"},{"longhands":["animation-name","animation-duration","animation-timing-function","animation-delay","animation-iteration-count","animation-direction","animation-fill-mode","animation-play-state"],"name":"animation"},{"name":"animation-delay"},{"name":"animation-direction"},{"name":"animation-duration"},{"name":"animation-fill-mode"},{"name":"animation-iteration-count"},{"name":"animation-name"},{"name":"animation-play-state"},{"name":"animation-timing-function"},{"name":"backdrop-filter"},{"name":"backface-visibility"},{"longhands":["background-image","background-position-x","background-position-y","background-size","background-repeat-x","background-repeat-y","background-attachment","background-origin","background-clip","background-color"],"name":"background"},{"name":"background-attachment"},{"name":"background-blend-mode"},{"name":"background-clip"},{"name":"background-color"},{"name":"background-image"},{"name":"background-origin"},{"longhands":["background-position-x","background-position-y"],"name":"background-position"},{"name":"background-position-x"},{"name":"background-position-y"},{"longhands":["background-repeat-x","background-repeat-y"],"name":"background-repeat"},{"name":"background-repeat-x"},{"name":"background-repeat-y"},{"name":"background-size"},{"name":"baseline-shift","svg":true},{"name":"block-size"},{"longhands":["border-top-color","border-top-style","border-top-width","border-right-color","border-right-style","border-right-width","border-bottom-color","border-bottom-style","border-bottom-width","border-left-color","border-left-style","border-left-width","border-image-source","border-image-slice","border-image-width","border-image-outset","border-image-repeat"],"name":"border"},{"longhands":["border-bottom-width","border-bottom-style","border-bottom-color"],"name":"border-bottom"},{"name":"border-bottom-color"},{"name":"border-bottom-left-radius"},{"name":"border-bottom-right-radius"},{"name":"border-bottom-style"},{"name":"border-bottom-width"},{"name":"border-collapse","inherited":true},{"longhands":["border-top-color","border-right-color","border-bottom-color","border-left-color"],"name":"border-color"},{"longhands":["border-image-source","border-image-slice","border-image-width","border-image-outset","border-image-repeat"],"name":"border-image"},{"name":"border-image-outset"},{"name":"border-image-repeat"},{"name":"border-image-slice"},{"name":"border-image-source"},{"name":"border-image-width"},{"longhands":["border-left-width","border-left-style","border-left-color"],"name":"border-left"},{"name":"border-left-color"},{"name":"border-left-style"},{"name":"border-left-width"},{"longhands":["border-top-left-radius","border-top-right-radius","border-bottom-right-radius","border-bottom-left-radius"],"name":"border-radius"},{"longhands":["border-right-width","border-right-style","border-right-color"],"name":"border-right"},{"name":"border-right-color"},{"name":"border-right-style"},{"name":"border-right-width"},{"longhands":["-webkit-border-horizontal-spacing","-webkit-border-vertical-spacing"],"name":"border-spacing"},{"name":"border-style","longhands":["border-top-style","border-right-style","border-bottom-style","border-left-style"]},{"longhands":["border-top-width","border-top-style","border-top-color"],"name":"border-top"},{"name":"border-top-color"},{"name":"border-top-left-radius"},{"name":"border-top-right-radius"},{"name":"border-top-style"},{"name":"border-top-width"},{"longhands":["border-top-width","border-right-width","border-bottom-width","border-left-width"],"name":"border-width"},{"name":"bottom"},{"name":"box-shadow"},{"name":"box-sizing"},{"name":"break-after"},{"name":"break-before"},{"name":"break-inside"},{"svg":true,"name":"buffered-rendering"},{"name":"caption-side","inherited":true},{"name":"caret-color","inherited":true},{"name":"clear"},{"name":"clip"},{"name":"clip-path"},{"svg":true,"name":"clip-rule","inherited":true},{"name":"color","inherited":true},{"svg":true,"name":"color-interpolation","inherited":true},{"svg":true,"name":"color-interpolation-filters","inherited":true},{"svg":true,"name":"color-rendering","inherited":true},{"name":"column-count"},{"name":"column-fill"},{"name":"column-gap"},{"longhands":["column-rule-width","column-rule-style","column-rule-color"],"name":"column-rule"},{"name":"column-rule-color"},{"name":"column-rule-style"},{"name":"column-rule-width"},{"name":"column-span"},{"name":"column-width"},{"longhands":["column-width","column-count"],"name":"columns"},{"name":"contain"},{"name":"content"},{"name":"counter-increment"},{"name":"counter-reset"},{"name":"cursor","inherited":true},{"name":"cx","svg":true},{"name":"cy","svg":true},{"name":"d","svg":true},{"name":"direction","inherited":true},{"name":"display"},{"svg":true,"name":"dominant-baseline","inherited":true},{"name":"empty-cells","inherited":true},{"name":"fill","svg":true,"inherited":true},{"name":"fill-opacity","svg":true,"inherited":true},{"svg":true,"name":"fill-rule","inherited":true},{"name":"filter"},{"longhands":["flex-grow","flex-shrink","flex-basis"],"name":"flex"},{"name":"flex-basis"},{"name":"flex-direction"},{"longhands":["flex-direction","flex-wrap"],"name":"flex-flow"},{"name":"flex-grow"},{"name":"flex-shrink"},{"name":"flex-wrap"},{"name":"float"},{"name":"flood-color","svg":true},{"name":"flood-opacity","svg":true},{"longhands":["font-style","font-variant-ligatures","font-variant-caps","font-variant-numeric","font-weight","font-stretch","font-size","line-height","font-family"],"name":"font"},{"name":"font-display"},{"name":"font-family","inherited":true},{"name":"font-feature-settings","inherited":true},{"name":"font-kerning","inherited":true},{"name":"font-size","inherited":true},{"name":"font-size-adjust","inherited":true},{"name":"font-stretch","inherited":true},{"name":"font-style","inherited":true},{"longhands":["font-variant-ligatures","font-variant-caps","font-variant-numeric"],"name":"font-variant"},{"name":"font-variant-caps","inherited":true},{"name":"font-variant-ligatures","inherited":true},{"name":"font-variant-numeric","inherited":true},{"name":"font-variation-settings","inherited":true},{"name":"font-weight","inherited":true},{"longhands":["grid-template-rows","grid-template-columns","grid-template-areas","grid-auto-flow","grid-auto-rows","grid-auto-columns","grid-column-gap","grid-row-gap"],"name":"grid"},{"longhands":["grid-row-start","grid-column-start","grid-row-end","grid-column-end"],"name":"grid-area"},{"name":"grid-auto-columns"},{"name":"grid-auto-flow"},{"name":"grid-auto-rows"},{"longhands":["grid-column-start","grid-column-end"],"name":"grid-column"},{"name":"grid-column-end"},{"name":"grid-column-gap"},{"name":"grid-column-start"},{"longhands":["grid-row-gap","grid-column-gap"],"name":"grid-gap"},{"longhands":["grid-row-start","grid-row-end"],"name":"grid-row"},{"name":"grid-row-end"},{"name":"grid-row-gap"},{"name":"grid-row-start"},{"longhands":["grid-template-rows","grid-template-columns","grid-template-areas"],"name":"grid-template"},{"name":"grid-template-areas"},{"name":"grid-template-columns"},{"name":"grid-template-rows"},{"name":"height"},{"name":"hyphens","inherited":true},{"name":"image-orientation","inherited":true},{"name":"image-rendering","inherited":true},{"name":"inline-size"},{"name":"isolation"},{"name":"justify-content"},{"name":"justify-items"},{"name":"justify-self"},{"name":"left"},{"name":"letter-spacing","inherited":true},{"name":"lighting-color","svg":true},{"name":"line-break","inherited":true},{"name":"line-height","inherited":true},{"name":"line-height-step","inherited":true},{"longhands":["list-style-type","list-style-position","list-style-image"],"name":"list-style"},{"name":"list-style-image","inherited":true},{"name":"list-style-position","inherited":true},{"name":"list-style-type","inherited":true},{"longhands":["margin-top","margin-right","margin-bottom","margin-left"],"name":"margin"},{"name":"margin-bottom"},{"name":"margin-left"},{"name":"margin-right"},{"name":"margin-top"},{"longhands":["marker-start","marker-mid","marker-end"],"name":"marker"},{"name":"marker-end","svg":true,"inherited":true},{"name":"marker-mid","svg":true,"inherited":true},{"name":"marker-start","svg":true,"inherited":true},{"name":"mask","svg":true},{"name":"mask-source-type"},{"svg":true,"name":"mask-type"},{"name":"max-block-size"},{"name":"max-height"},{"name":"max-inline-size"},{"name":"max-width"},{"name":"max-zoom"},{"name":"min-block-size"},{"name":"min-height"},{"name":"min-inline-size"},{"name":"min-width"},{"name":"min-zoom"},{"name":"mix-blend-mode"},{"name":"object-fit"},{"name":"object-position"},{"longhands":["offset-position","offset-path","offset-distance","offset-rotate","offset-anchor"],"name":"offset"},{"name":"offset-anchor"},{"name":"offset-distance"},{"name":"offset-path"},{"name":"offset-position"},{"name":"offset-rotate"},{"name":"opacity"},{"name":"order"},{"name":"orientation"},{"name":"orphans","inherited":true},{"longhands":["outline-color","outline-style","outline-width"],"name":"outline"},{"name":"outline-color"},{"name":"outline-offset"},{"name":"outline-style"},{"name":"outline-width"},{"longhands":["overflow-x","overflow-y"],"name":"overflow"},{"name":"overflow-anchor","inherited":false},{"name":"overflow-wrap","inherited":true},{"name":"overflow-x"},{"name":"overflow-y"},{"longhands":["padding-top","padding-right","padding-bottom","padding-left"],"name":"padding"},{"name":"padding-bottom"},{"name":"padding-left"},{"name":"padding-right"},{"name":"padding-top"},{"name":"page"},{"longhands":["break-after"],"name":"page-break-after"},{"longhands":["break-before"],"name":"page-break-before"},{"longhands":["break-inside"],"name":"page-break-inside"},{"name":"paint-order","svg":true,"inherited":true},{"name":"perspective"},{"name":"perspective-origin"},{"longhands":["align-content","justify-content"],"name":"place-content"},{"longhands":["align-items","justify-items"],"name":"place-items"},{"longhands":["align-self","justify-self"],"name":"place-self"},{"name":"pointer-events","inherited":true},{"name":"position"},{"name":"quotes","inherited":true},{"name":"r","svg":true},{"name":"resize"},{"name":"right"},{"name":"rotate"},{"name":"rx","svg":true},{"name":"ry","svg":true},{"name":"scale"},{"name":"scroll-behavior"},{"longhands":["scroll-boundary-behavior-x","scroll-boundary-behavior-y"],"name":"scroll-boundary-behavior"},{"name":"scroll-boundary-behavior-x"},{"name":"scroll-boundary-behavior-y"},{"longhands":["scroll-padding-top","scroll-padding-right","scroll-padding-bottom","scroll-padding-left"],"name":"scroll-padding"},{"longhands":["scroll-padding-block-start","scroll-padding-block-end"],"name":"scroll-padding-block"},{"name":"scroll-padding-block-end"},{"name":"scroll-padding-block-start"},{"name":"scroll-padding-bottom"},{"longhands":["scroll-padding-inline-start","scroll-padding-inline-end"],"name":"scroll-padding-inline"},{"name":"scroll-padding-inline-end"},{"name":"scroll-padding-inline-start"},{"name":"scroll-padding-left"},{"name":"scroll-padding-right"},{"name":"scroll-padding-top"},{"name":"scroll-snap-align"},{"longhands":["scroll-snap-margin-top","scroll-snap-margin-right","scroll-snap-margin-bottom","scroll-snap-margin-left"],"name":"scroll-snap-margin"},{"longhands":["scroll-snap-margin-block-start","scroll-snap-margin-block-end"],"name":"scroll-snap-margin-block"},{"name":"scroll-snap-margin-block-end"},{"name":"scroll-snap-margin-block-start"},{"name":"scroll-snap-margin-bottom"},{"longhands":["scroll-snap-margin-inline-start","scroll-snap-margin-inline-end"],"name":"scroll-snap-margin-inline"},{"name":"scroll-snap-margin-inline-end"},{"name":"scroll-snap-margin-inline-start"},{"name":"scroll-snap-margin-left"},{"name":"scroll-snap-margin-right"},{"name":"scroll-snap-margin-top"},{"name":"scroll-snap-stop"},{"name":"scroll-snap-type"},{"name":"shape-image-threshold"},{"name":"shape-margin"},{"name":"shape-outside"},{"svg":true,"name":"shape-rendering","inherited":true},{"name":"size"},{"name":"speak","inherited":true},{"name":"src"},{"name":"stop-color","svg":true},{"name":"stop-opacity","svg":true},{"name":"stroke","svg":true,"inherited":true},{"name":"stroke-dasharray","svg":true,"inherited":true},{"name":"stroke-dashoffset","svg":true,"inherited":true},{"name":"stroke-linecap","svg":true,"inherited":true},{"name":"stroke-linejoin","svg":true,"inherited":true},{"name":"stroke-miterlimit","svg":true,"inherited":true},{"name":"stroke-opacity","svg":true,"inherited":true},{"name":"stroke-width","svg":true,"inherited":true},{"name":"tab-size","inherited":true},{"name":"table-layout"},{"name":"text-align","inherited":true},{"name":"text-align-last","inherited":true},{"svg":true,"name":"text-anchor","inherited":true},{"name":"text-combine-upright","inherited":true},{"longhands":["text-decoration-line","text-decoration-style","text-decoration-color"],"name":"text-decoration"},{"name":"text-decoration-color"},{"name":"text-decoration-line"},{"name":"text-decoration-skip","inherited":true},{"name":"text-decoration-style"},{"name":"text-indent","inherited":true},{"name":"text-justify","inherited":true},{"name":"text-orientation","inherited":true},{"name":"text-overflow"},{"name":"text-rendering","inherited":true},{"name":"text-shadow","inherited":true},{"name":"text-size-adjust","inherited":true},{"name":"text-transform","inherited":true},{"name":"text-underline-position","inherited":true},{"name":"top"},{"name":"touch-action"},{"name":"transform"},{"name":"transform-box"},{"name":"transform-origin"},{"name":"transform-style"},{"longhands":["transition-property","transition-duration","transition-timing-function","transition-delay"],"name":"transition"},{"name":"transition-delay"},{"name":"transition-duration"},{"name":"transition-property"},{"name":"transition-timing-function"},{"name":"translate"},{"name":"unicode-bidi"},{"name":"unicode-range"},{"name":"user-select","inherited":true},{"name":"user-zoom"},{"svg":true,"name":"vector-effect"},{"name":"vertical-align"},{"name":"visibility","inherited":true},{"name":"white-space","inherited":true},{"name":"widows","inherited":true},{"name":"width"},{"name":"will-change"},{"name":"word-break","inherited":true},{"name":"word-spacing","inherited":true},{"name":"word-wrap","inherited":true},{"name":"writing-mode","inherited":true},{"name":"x","svg":true},{"name":"y","svg":true},{"name":"z-index"},{"name":"zoom"}];;SDK.FilmStripModel=class{constructor(tracingModel,zeroTime){this.reset(tracingModel,zeroTime);}
reset(tracingModel,zeroTime){this._zeroTime=zeroTime||tracingModel.minimumRecordTime();this._spanTime=tracingModel.maximumRecordTime()-this._zeroTime;this._frames=[];var browserMain=SDK.TracingModel.browserMainThread(tracingModel);if(!browserMain)
return;var events=browserMain.events();for(var i=0;i<events.length;++i){var event=events[i];if(event.startTime<this._zeroTime)
continue;if(!event.hasCategory(SDK.FilmStripModel._category))
continue;if(event.name===SDK.FilmStripModel.TraceEvents.CaptureFrame){var data=event.args['data'];if(data)
this._frames.push(SDK.FilmStripModel.Frame._fromEvent(this,event,this._frames.length));}else if(event.name===SDK.FilmStripModel.TraceEvents.Screenshot){this._frames.push(SDK.FilmStripModel.Frame._fromSnapshot(this,(event),this._frames.length));}}}
frames(){return this._frames;}
zeroTime(){return this._zeroTime;}
spanTime(){return this._spanTime;}
frameByTimestamp(timestamp){var index=this._frames.upperBound(timestamp,(timestamp,frame)=>timestamp-frame.timestamp)-1;return index>=0?this._frames[index]:null;}};SDK.FilmStripModel._category='disabled-by-default-devtools.screenshot';SDK.FilmStripModel.TraceEvents={CaptureFrame:'CaptureFrame',Screenshot:'Screenshot'};SDK.FilmStripModel.Frame=class{constructor(model,timestamp,index){this._model=model;this.timestamp=timestamp;this.index=index;this._imageData=null;this._snapshot=null;}
static _fromEvent(model,event,index){var frame=new SDK.FilmStripModel.Frame(model,event.startTime,index);frame._imageData=event.args['data'];return frame;}
static _fromSnapshot(model,snapshot,index){var frame=new SDK.FilmStripModel.Frame(model,snapshot.startTime,index);frame._snapshot=snapshot;return frame;}
model(){return this._model;}
imageDataPromise(){if(this._imageData||!this._snapshot)
return Promise.resolve(this._imageData);return(this._snapshot.objectPromise());}};;