// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./composebox_tool_chip.js";import"./context_menu_entrypoint.js";import"./contextual_entrypoint_and_carousel.js";import"./composebox_dropdown.js";import"./error_scrim.js";import"./file_carousel.js";import"./icons.html.js";import"//resources/cr_components/localized_link/localized_link.js";import"//resources/cr_elements/cr_icon_button/cr_icon_button.js";import{getInstance as getAnnouncerInstance}from"//resources/cr_elements/cr_a11y_announcer/cr_a11y_announcer.js";import{I18nMixinLit}from"//resources/cr_elements/i18n_mixin_lit.js";import{assert}from"//resources/js/assert.js";import{EventTracker}from"//resources/js/event_tracker.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{hasKeyModifiers}from"//resources/js/util.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{getCss}from"./composebox.css.js";import{getHtml}from"./composebox.html.js";import{ComposeboxProxyImpl}from"./composebox_proxy.js";import{FileUploadStatus}from"./composebox_query.mojom-webui.js";import{ComposeboxMode}from"./contextual_entrypoint_and_carousel.js";export class ComposeboxElement extends(I18nMixinLit(CrLitElement)){static get is(){return"ntp-composebox"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{input_:{type:String},isCollapsible:{reflect:true,type:Boolean},expanded_:{reflect:true,type:Boolean},result_:{type:Object},submitEnabled_:{reflect:true,type:Boolean},selectedMatchIndex_:{type:Number},submitting_:{reflect:true,type:Boolean},showDropdown_:{reflect:true,type:Boolean},showSubmit_:{reflect:true,type:Boolean},enableImageContextualSuggestions_:{reflect:true,type:Boolean},inputPlaceholder_:{reflect:true,type:String},smartComposeEnabled_:{reflect:true,type:Boolean},smartComposeInlineHint_:{type:String},showFileCarousel_:{reflect:true,type:Boolean},inDeepSearchMode_:{reflect:true,type:Boolean},inCreateImageMode_:{reflect:true,type:Boolean},showContextMenuDescription_:{type:Boolean},lensButtonDisabled_:{reflect:true,type:Boolean},ntpRealboxNextEnabled:{type:Boolean,reflect:true},tabSuggestions_:{type:Array},errorScrimVisible_:{type:Boolean},contextFilesSize_:{type:Number},realboxLayoutMode:{type:String,reflect:true}}}#ntpRealboxNextEnabled_accessor_storage=false;get ntpRealboxNextEnabled(){return this.#ntpRealboxNextEnabled_accessor_storage}set ntpRealboxNextEnabled(value){this.#ntpRealboxNextEnabled_accessor_storage=value}#realboxLayoutMode_accessor_storage="";get realboxLayoutMode(){return this.#realboxLayoutMode_accessor_storage}set realboxLayoutMode(value){this.#realboxLayoutMode_accessor_storage=value}#isCollapsible_accessor_storage=false;get isCollapsible(){return this.#isCollapsible_accessor_storage}set isCollapsible(value){this.#isCollapsible_accessor_storage=value}#expanded__accessor_storage=false;get expanded_(){return this.#expanded__accessor_storage}set expanded_(value){this.#expanded__accessor_storage=value}#input__accessor_storage="";get input_(){return this.#input__accessor_storage}set input_(value){this.#input__accessor_storage=value}#showDropdown__accessor_storage=loadTimeData.getBoolean("composeboxShowZps");get showDropdown_(){return this.#showDropdown__accessor_storage}set showDropdown_(value){this.#showDropdown__accessor_storage=value}#showSubmit__accessor_storage=loadTimeData.getBoolean("composeboxShowSubmit");get showSubmit_(){return this.#showSubmit__accessor_storage}set showSubmit_(value){this.#showSubmit__accessor_storage=value}#enableImageContextualSuggestions__accessor_storage=loadTimeData.getBoolean("composeboxShowImageSuggest");get enableImageContextualSuggestions_(){return this.#enableImageContextualSuggestions__accessor_storage}set enableImageContextualSuggestions_(value){this.#enableImageContextualSuggestions__accessor_storage=value}#selectedMatchIndex__accessor_storage=-1;get selectedMatchIndex_(){return this.#selectedMatchIndex__accessor_storage}set selectedMatchIndex_(value){this.#selectedMatchIndex__accessor_storage=value}#submitting__accessor_storage=false;get submitting_(){return this.#submitting__accessor_storage}set submitting_(value){this.#submitting__accessor_storage=value}#submitEnabled__accessor_storage=false;get submitEnabled_(){return this.#submitEnabled__accessor_storage}set submitEnabled_(value){this.#submitEnabled__accessor_storage=value}#result__accessor_storage=null;get result_(){return this.#result__accessor_storage}set result_(value){this.#result__accessor_storage=value}#smartComposeInlineHint__accessor_storage="";get smartComposeInlineHint_(){return this.#smartComposeInlineHint__accessor_storage}set smartComposeInlineHint_(value){this.#smartComposeInlineHint__accessor_storage=value}#smartComposeEnabled__accessor_storage=loadTimeData.getBoolean("composeboxSmartComposeEnabled");get smartComposeEnabled_(){return this.#smartComposeEnabled__accessor_storage}set smartComposeEnabled_(value){this.#smartComposeEnabled__accessor_storage=value}#inputPlaceholder__accessor_storage=loadTimeData.getString("searchboxComposePlaceholder");get inputPlaceholder_(){return this.#inputPlaceholder__accessor_storage}set inputPlaceholder_(value){this.#inputPlaceholder__accessor_storage=value}#showFileCarousel__accessor_storage=false;get showFileCarousel_(){return this.#showFileCarousel__accessor_storage}set showFileCarousel_(value){this.#showFileCarousel__accessor_storage=value}#inCreateImageMode__accessor_storage=false;get inCreateImageMode_(){return this.#inCreateImageMode__accessor_storage}set inCreateImageMode_(value){this.#inCreateImageMode__accessor_storage=value}#inDeepSearchMode__accessor_storage=false;get inDeepSearchMode_(){return this.#inDeepSearchMode__accessor_storage}set inDeepSearchMode_(value){this.#inDeepSearchMode__accessor_storage=value}#showContextMenuDescription__accessor_storage=true;get showContextMenuDescription_(){return this.#showContextMenuDescription__accessor_storage}set showContextMenuDescription_(value){this.#showContextMenuDescription__accessor_storage=value}#lensButtonDisabled__accessor_storage=false;get lensButtonDisabled_(){return this.#lensButtonDisabled__accessor_storage}set lensButtonDisabled_(value){this.#lensButtonDisabled__accessor_storage=value}#tabSuggestions__accessor_storage=[];get tabSuggestions_(){return this.#tabSuggestions__accessor_storage}set tabSuggestions_(value){this.#tabSuggestions__accessor_storage=value}#errorScrimVisible__accessor_storage=false;get errorScrimVisible_(){return this.#errorScrimVisible__accessor_storage}set errorScrimVisible_(value){this.#errorScrimVisible__accessor_storage=value}#contextFilesSize__accessor_storage=0;get contextFilesSize_(){return this.#contextFilesSize__accessor_storage}set contextFilesSize_(value){this.#contextFilesSize__accessor_storage=value}lastQueriedInput_="";showTypedSuggest_=loadTimeData.getBoolean("composeboxShowTypedSuggest");showZps=loadTimeData.getBoolean("composeboxShowZps");browserProxy=ComposeboxProxyImpl.getInstance();searchboxCallbackRouter_;pageHandler_;searchboxHandler_;eventTracker_=new EventTracker;searchboxListenerIds=[];composeboxCloseByEscape_=loadTimeData.getBoolean("composeboxCloseByEscape");selectedMatch_=null;constructor(){super();this.pageHandler_=ComposeboxProxyImpl.getInstance().handler;this.searchboxCallbackRouter_=ComposeboxProxyImpl.getInstance().searchboxCallbackRouter;this.searchboxHandler_=ComposeboxProxyImpl.getInstance().searchboxHandler}connectedCallback(){super.connectedCallback();this.expanded_=!this.isCollapsible;this.searchboxListenerIds=[this.searchboxCallbackRouter_.autocompleteResultChanged.addListener(this.onAutocompleteResultChanged_.bind(this)),this.searchboxCallbackRouter_.onContextualInputStatusChanged.addListener(this.onContextualInputStatusChanged_.bind(this)),this.searchboxCallbackRouter_.onTabStripChanged.addListener(this.refreshTabSuggestions_.bind(this))];this.eventTracker_.add(this.$.input,"input",(()=>{this.submitEnabled_=this.computeSubmitEnabled_()}));this.eventTracker_.add(this.$.context,"on-context-files-changed",(e=>{this.contextFilesSize_=e.detail.files;this.submitEnabled_=this.computeSubmitEnabled_()}));this.$.input.focus();if(this.showZps&&!this.ntpRealboxNextEnabled){this.queryAutocomplete(false)}this.searchboxHandler_.notifySessionStarted();this.refreshTabSuggestions_();if(this.ntpRealboxNextEnabled){this.fire("composebox-initialized",{initializeComposeboxState:this.initializeState_.bind(this)})}}disconnectedCallback(){super.disconnectedCallback();this.searchboxHandler_.notifySessionAbandoned();this.searchboxListenerIds.forEach((id=>assert(this.browserProxy.searchboxCallbackRouter.removeListener(id))));this.searchboxListenerIds=[];this.eventTracker_.removeAll()}willUpdate(changedProperties){super.willUpdate(changedProperties);const changedPrivateProperties=changedProperties;let showDropdownUpdated=changedPrivateProperties.has("showDropdown_");if(changedPrivateProperties.has("input_")||changedPrivateProperties.has("result_")||changedPrivateProperties.has("contextFilesSize_")||changedPrivateProperties.has("errorScrimVisible_")){const prevValue=this.showDropdown_;this.showDropdown_=this.computeShowDropdown_();showDropdownUpdated||=this.showDropdown_!==prevValue}if(this.ntpRealboxNextEnabled&&showDropdownUpdated){this.dispatchEvent(new CustomEvent("composebox-dropdown-visible-changed",{bubbles:true,composed:true,detail:{value:this.showDropdown_}}))}}updated(changedProperties){super.updated(changedProperties);const changedPrivateProperties=changedProperties;if(changedPrivateProperties.has("selectedMatchIndex_")){if(this.selectedMatch_){if(!(this.selectedMatchIndex_===0&&this.selectedMatch_.allowedToBeDefaultMatch)){const text=this.selectedMatch_.fillIntoEdit;assert(text);this.input_=text;this.submitEnabled_=true}}else if(!this.lastQueriedInput_){this.input_="";this.submitEnabled_=false}else{this.input_=this.lastQueriedInput_}}if(changedPrivateProperties.has("smartComposeInlineHint_")){if(this.smartComposeInlineHint_){this.adjustInputForSmartCompose();const announcer=getAnnouncerInstance();announcer.announce(this.smartComposeInlineHint_+", "+this.i18n("composeboxSmartComposeTitle"))}else{this.$.input.style.height="calc-size(fit-content, min(size + 4px, 190px))"}}}getText(){return this.input_}setText(text){this.input_=text}resetModes(){this.$.context.resetModes()}closeDropdown(){this.clearAutocompleteMatches_()}getSmartComposeForTesting(){return this.smartComposeInlineHint_}initializeState_(text="",files=[],mode=ComposeboxMode.DEFAULT){if(text){this.input_=text;this.lastQueriedInput_=text}if(this.showZps&&files.length===0){this.queryAutocomplete(false)}if(files.length>0){this.$.context.setContextFiles(files)}if(mode!==ComposeboxMode.DEFAULT){this.$.context.setInitialMode(mode)}}computeCancelButtonTitle_(){return this.input_.trim().length>0||this.contextFilesSize_>0?this.i18n("composeboxCancelButtonTitleInput"):this.i18n("composeboxCancelButtonTitle")}computeShowDropdown_(){if(this.contextFilesSize_>1){return false}if(!this.result_?.matches.length){return false}if(this.errorScrimVisible_){return false}if(this.showTypedSuggest_&&this.input_.trim()){if(this.$.input.scrollHeight<=48){return true}}return this.showZps&&!this.lastQueriedInput_}computeSubmitEnabled_(){return this.input_.trim().length>0||this.contextFilesSize_>0}shouldShowSuggestionActivityLink_(){if(!this.result_||!this.showDropdown_){return false}return this.result_.matches.some((match=>match.isNoncannedAimSuggestion))}shouldShowSmartComposeInlineHint_(){return!!this.smartComposeInlineHint_}onFileValidationError_(e){this.$.errorScrim.setErrorMessage(e.detail.errorMessage)}async deleteContext_(e){if(this.inCreateImageMode_){await this.setCreateImageMode_({detail:{inCreateImageMode:true,imagePresent:this.$.context.hasImageFiles()}})}this.searchboxHandler_.deleteContext(e.detail.uuid);this.$.input.focus();this.queryAutocomplete(true)}async addFileContext_(e){const composeboxFiles=new Map;for(const file of e.detail.files){const fileBuffer=await file.arrayBuffer();const bigBuffer={bytes:Array.from(new Uint8Array(fileBuffer))};const{token:token}=await this.searchboxHandler_.addFileContext({fileName:file.name,mimeType:file.type,selectionTime:new Date},bigBuffer);const attachment={uuid:token,name:file.name,objectUrl:e.detail.isImage?URL.createObjectURL(file):null,type:file.type,status:FileUploadStatus.kNotUploaded,url:null,file:file,tabId:null};composeboxFiles.set(token,attachment);const announcer=getAnnouncerInstance();announcer.announce(this.i18n("composeboxFileUploadStartedText"))}e.detail.onContextAdded(composeboxFiles);this.$.input.focus()}async addTabContext_(e){const{token:token}=await this.searchboxHandler_.addTabContext(e.detail.id);if(!token){return}const attachment={uuid:token,name:e.detail.title,objectUrl:null,type:"tab",status:FileUploadStatus.kNotUploaded,url:e.detail.url,file:null,tabId:e.detail.id};e.detail.onContextAdded(attachment);this.$.input.focus()}async refreshTabSuggestions_(){const{tabs:tabs}=await this.searchboxHandler_.getRecentTabs();this.tabSuggestions_=[...tabs]}async getTabPreview_(e){const{previewDataUrl:previewDataUrl}=await this.searchboxHandler_.getTabPreview(e.detail.tabId);e.detail.onPreviewFetched(previewDataUrl||"")}onCancelClick_(){if(this.input_.trim().length>0||this.contextFilesSize_>0){this.input_="";this.$.context.resetContextFiles();this.contextFilesSize_=0;this.smartComposeInlineHint_="";this.submitEnabled_=false;this.searchboxHandler_.clearFiles();this.$.input.focus();this.queryAutocomplete(true)}else{this.closeComposebox_()}}onLensClick_(){this.pageHandler_.handleLensButtonClick()}onLensIconMouseDown_(e){e.preventDefault()}updateInputPlaceholder_(){if(this.inDeepSearchMode_){this.inputPlaceholder_=loadTimeData.getString("composeDeepSearchPlaceholder")}else if(this.inCreateImageMode_){this.inputPlaceholder_=loadTimeData.getString("composeCreateImagePlaceholder")}else{this.inputPlaceholder_=loadTimeData.getString("searchboxComposePlaceholder")}}async setDeepSearchMode_(e){this.inDeepSearchMode_=e.detail.inDeepSearchMode;this.pageHandler_.setDeepSearchMode(e.detail.inDeepSearchMode);this.queryAutocomplete(true);this.updateInputPlaceholder_();await this.updateComplete;this.$.input.focus()}async setCreateImageMode_(e){this.inCreateImageMode_=e.detail.inCreateImageMode;this.pageHandler_.setCreateImageMode(e.detail.inCreateImageMode,e.detail.imagePresent);this.queryAutocomplete(true);this.updateInputPlaceholder_();await this.updateComplete;this.$.input.focus()}onErrorScrimVisibilityChanged_(e){this.errorScrimVisible_=e.detail.showErrorScrim}handleInput_(e){const inputElement=e.target;this.input_=inputElement.value;this.queryAutocomplete(this.input_==="")}onKeydown_(e){const KEYDOWN_HANDLED_KEYS=["ArrowDown","ArrowUp","Enter","Escape","PageDown","PageUp","Tab"];if(!KEYDOWN_HANDLED_KEYS.includes(e.key)){return}if(this.shadowRoot.activeElement===this.$.input){if((e.key==="ArrowDown"||e.key==="ArrowUp")&&!this.showDropdown_){return}if(e.key==="Tab"){if(e.shiftKey){this.$.matches.unselect()}else if(this.smartComposeEnabled_&&this.smartComposeInlineHint_){this.input_=this.input_+this.smartComposeInlineHint_;this.smartComposeInlineHint_="";e.preventDefault();this.queryAutocomplete(true)}return}}if(e.key==="Enter"&&this.submitEnabled_){if(this.shadowRoot.activeElement===this.$.matches||!e.shiftKey){e.preventDefault();this.submitQuery_(e)}}if(e.key==="Escape"&&this.composeboxCloseByEscape_){this.closeComposebox_();e.preventDefault();return}if(!this.result_||this.result_.matches.length===0){return}if(hasKeyModifiers(e)){return}if(e.key==="ArrowDown"){this.$.matches.selectNext()}else if(e.key==="ArrowUp"){this.$.matches.selectPrevious()}else if(e.key==="Escape"||e.key==="PageUp"){this.$.matches.selectFirst()}else if(e.key==="PageDown"){this.$.matches.selectLast()}else if(e.key==="Tab"){if(this.selectedMatchIndex_===this.result_.matches.length-1){const focusedMatchElem=this.shadowRoot.activeElement?.shadowRoot?.activeElement;const focusedButtonElem=focusedMatchElem?.shadowRoot?.activeElement;if(focusedButtonElem?.id==="remove"){this.$.matches.unselect()}}return}this.smartComposeInlineHint_="";e.preventDefault();if(this.shadowRoot.activeElement===this.$.matches){this.$.matches.focusSelected()}}handleInputFocusIn_(){if(this.lastQueriedInput_&&this.result_?.matches.length){this.$.matches.selectFirst()}if(this.ntpRealboxNextEnabled){this.fire("composebox-input-focus-changed",{value:true})}}handleInputFocusOut_(){if(this.ntpRealboxNextEnabled){this.fire("composebox-input-focus-changed",{value:false})}}handleComposeboxFocusIn_(e){if(this.$.composebox.contains(e.relatedTarget)){return}this.expanded_=true;this.submitting_=false;this.pageHandler_.focusChanged(true);this.fire("composebox-focus-in")}handleComposeboxFocusOut_(e){if(this.$.composebox.contains(e.relatedTarget)){return}this.expanded_=!this.isCollapsible;this.pageHandler_.focusChanged(false);this.fire("composebox-focus-out")}handleScroll_(){const smartCompose=this.shadowRoot.querySelector("#smartCompose");if(!smartCompose){return}smartCompose.scrollTop=this.$.input.scrollTop}handleSubmitFocusIn_(){if(this.input_&&!this.selectedMatch_){this.$.matches.selectFirst()}}closeComposebox_(){this.resetModes();this.fire("close-composebox",{composeboxText:this.input_});if(this.isCollapsible){this.expanded_=false;this.$.input.blur()}}submitQuery_(e){assert(this.selectedMatchIndex_>=0&&this.result_||this.contextFilesSize_>0);if(this.selectedMatchIndex_>=0){const match=this.result_.matches[this.selectedMatchIndex_];assert(match);this.searchboxHandler_.openAutocompleteMatch(this.selectedMatchIndex_,match.destinationUrl,true,e.button||0,e.altKey,e.ctrlKey,e.metaKey,e.shiftKey)}else{this.searchboxHandler_.submitQuery(this.input_.trim(),e.button||0,e.altKey,e.ctrlKey,e.metaKey,e.shiftKey)}this.submitting_=true;if(this.isCollapsible){this.setText("");this.$.input.blur();this.submitEnabled_=false}}onMatchFocusin_(e){this.$.matches.selectIndex(e.detail.index)}onMatchClick_(){this.clearAutocompleteMatches_()}onSelectedMatchIndexChanged_(e){this.selectedMatchIndex_=e.detail.value;this.selectedMatch_=this.result_?.matches[this.selectedMatchIndex_]||null}clearAutocompleteMatches_(){this.showDropdown_=false;this.result_=null;this.$.matches.unselect();this.searchboxHandler_.stopAutocomplete(true);this.lastQueriedInput_=""}onAutocompleteResultChanged_(result){if(this.lastQueriedInput_===null||this.lastQueriedInput_.trimStart()!==result.input){return}this.result_=result;const hasMatches=this.result_.matches.length>0;const firstMatch=hasMatches?this.result_.matches[0]:null;if(firstMatch&&firstMatch.allowedToBeDefaultMatch){this.$.matches.selectFirst()}else if(this.input_.trim()&&hasMatches&&this.selectedMatchIndex_>=0&&this.selectedMatchIndex_<this.result_.matches.length){this.$.matches.selectIndex(this.selectedMatchIndex_);this.selectedMatch_=this.result_.matches[this.selectedMatchIndex_];this.input_=this.selectedMatch_.fillIntoEdit}else{this.$.matches.unselect()}this.smartComposeInlineHint_=this.result_.smartComposeInlineHint?this.result_.smartComposeInlineHint:""}async onContextualInputStatusChanged_(token,status,errorType){const{file:file,errorMessage:errorMessage}=this.$.context.updateFileStatus(token,status,errorType);if(errorMessage){this.$.errorScrim.setErrorMessage(errorMessage)}else if(file){if(status===FileUploadStatus.kProcessingSuggestSignalsReady&&this.showZps&&!file.type.includes("image")){this.queryAutocomplete(true)}if(status===FileUploadStatus.kProcessingSuggestSignalsReady&&file.type.includes("image")){if(this.inCreateImageMode_){await this.setCreateImageMode_({detail:{inCreateImageMode:true,imagePresent:true}})}else if(this.enableImageContextualSuggestions_){this.queryAutocomplete(true)}else{this.showDropdown_=false}}if(status===FileUploadStatus.kUploadSuccessful){const announcer=getAnnouncerInstance();announcer.announce(this.i18n("composeboxFileUploadCompleteText"))}}}adjustInputForSmartCompose(){const smartCompose=this.shadowRoot.querySelector("#smartCompose");const ghostHeight=smartCompose.scrollHeight;const maxHeight=190;this.$.input.style.height=`${Math.min(ghostHeight,maxHeight)}px`;if(ghostHeight>maxHeight){smartCompose.scrollTop=this.$.input.scrollTop}}queryAutocomplete(clearMatches){if(clearMatches){this.clearAutocompleteMatches_()}this.lastQueriedInput_=this.input_;this.searchboxHandler_.queryAutocomplete(this.input_,false)}}customElements.define(ComposeboxElement.is,ComposeboxElement);