// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"../assert.js";import{debounceEnd}from"../util.js";import{TrackedElementProxyImpl}from"./tracked_element_proxy.js";function parseOptions(options){if(!options){return{padding:{top:0,bottom:0,left:0,right:0},fixed:false}}const padding={top:0,bottom:0,left:0,right:0};padding.top=clampPadding(options.paddingTop);padding.left=clampPadding(options.paddingLeft);padding.bottom=clampPadding(options.paddingBottom);padding.right=clampPadding(options.paddingRight);return{padding:padding,fixed:!!options.fixed}}function clampPadding(n=0){return Math.max(0,Math.min(20,n))}function computeIsVisible(element){const rect=element.getBoundingClientRect();return rect.height>0&&rect.width>0}export class TrackedElementManager{static instance_=null;static getInstance(){if(TrackedElementManager.instance_===null){TrackedElementManager.instance_=new TrackedElementManager}return TrackedElementManager.instance_}trackedElementHandler_;trackedElements_=new Map;fixedElementObserver_;resizeObserver_;debouncedUpdateAllBoundsCallback_;constructor(){this.trackedElementHandler_=TrackedElementProxyImpl.getInstance().getHandler();this.debouncedUpdateAllBoundsCallback_=debounceEnd(this.updateAllBounds_.bind(this),50);this.resizeObserver_=new ResizeObserver((entries=>entries.forEach((({target:target})=>{if(target===document.body){this.debouncedUpdateAllBoundsCallback_()}else{this.onElementVisibilityChanged_(target,computeIsVisible(target))}}))));this.fixedElementObserver_=new IntersectionObserver((entries=>entries.forEach((({target:target,isIntersecting:isIntersecting})=>this.onElementVisibilityChanged_(target,isIntersecting)))),{root:null});document.addEventListener("scroll",this.debouncedUpdateAllBoundsCallback_,{passive:true});this.resizeObserver_.observe(document.body)}reset(){this.resizeObserver_.disconnect();this.fixedElementObserver_.disconnect();document.removeEventListener("scroll",this.debouncedUpdateAllBoundsCallback_);this.trackedElements_.clear()}startTracking(element,nativeId,options,onVisibilityChanged){element.dataset["nativeId"]=nativeId;if(this.trackedElements_.has(element)){this.stopTracking(element)}const parsedOptions=parseOptions(options);const trackedElement={element:element,nativeId:nativeId,padding:parsedOptions.padding,fixed:parsedOptions.fixed,visible:false,bounds:{x:0,y:0,width:0,height:0},onVisibilityChanged:onVisibilityChanged};this.trackedElements_.set(element,trackedElement);if(trackedElement.fixed){this.fixedElementObserver_.observe(element)}else{this.resizeObserver_.observe(element)}}stopTracking(element){const trackedElement=this.trackedElements_.get(element);if(!trackedElement){return}this.onElementVisibilityChanged_(element,false);if(trackedElement.fixed){this.fixedElementObserver_.unobserve(element)}else{this.resizeObserver_.unobserve(element)}this.trackedElements_.delete(element);element.dataset["nativeId"]=""}notifyElementActivated(element){const nativeId=element.dataset["nativeId"];assert(nativeId);this.trackedElementHandler_.trackedElementActivated(nativeId)}notifyCustomEvent(element,customEventName){const nativeId=element.dataset["nativeId"];assert(nativeId);this.trackedElementHandler_.trackedElementCustomEvent(nativeId,customEventName)}onElementVisibilityChanged_(element,isVisible){const trackedElement=this.trackedElements_.get(element);assert(trackedElement);const bounds=isVisible?this.getElementBounds_(element):{x:0,y:0,width:0,height:0};if(trackedElement.onVisibilityChanged){trackedElement.onVisibilityChanged(isVisible,bounds)}trackedElement.visible=isVisible;trackedElement.bounds=bounds;this.trackedElementHandler_.trackedElementVisibilityChanged(trackedElement.nativeId,isVisible,bounds)}updateAllBounds_(){this.trackedElements_.forEach(((_,element)=>{this.onElementVisibilityChanged_(element,computeIsVisible(element))}))}getElementBounds_(element){const rect={x:0,y:0,width:0,height:0};const bounds=element.getBoundingClientRect();rect.x=bounds.x;rect.y=bounds.y;rect.width=bounds.width;rect.height=bounds.height;const trackedElement=this.trackedElements_.get(element);if(trackedElement){const padding=trackedElement.padding;rect.x-=padding.left;rect.y-=padding.top;rect.width+=padding.left+padding.right;rect.height+=padding.top+padding.bottom}return rect}}