// components/commerce/core/mojom/price_tracking.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { BookmarkProductInfoSpec as commerce_shared_mojom_BookmarkProductInfoSpec } from './shared.mojom-webui.js';
import { String16Spec as mojoBase_mojom_String16Spec } from '//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js';
export class PriceTrackingHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'commerce.price_tracking.mojom.PriceTrackingHandler', scope);
    }
}
export class PriceTrackingHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PriceTrackingHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    trackPriceForBookmark(bookmarkId) {
        this.proxy.sendMessage(0, PriceTrackingHandler_TrackPriceForBookmark_ParamsSpec.$, null, [
            bookmarkId
        ], false);
    }
    untrackPriceForBookmark(bookmarkId) {
        this.proxy.sendMessage(1, PriceTrackingHandler_UntrackPriceForBookmark_ParamsSpec.$, null, [
            bookmarkId
        ], false);
    }
    setPriceTrackingStatusForCurrentUrl(track) {
        this.proxy.sendMessage(2, PriceTrackingHandler_SetPriceTrackingStatusForCurrentUrl_ParamsSpec.$, null, [
            track
        ], false);
    }
    getAllShoppingBookmarkProductInfo() {
        return this.proxy.sendMessage(3, PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ParamsSpec.$, PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ResponseParamsSpec.$, [], false);
    }
    getAllPriceTrackedBookmarkProductInfo() {
        return this.proxy.sendMessage(4, PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ParamsSpec.$, PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ResponseParamsSpec.$, [], false);
    }
    getShoppingCollectionBookmarkFolderId() {
        return this.proxy.sendMessage(5, PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ParamsSpec.$, PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ResponseParamsSpec.$, [], false);
    }
    getParentBookmarkFolderNameForCurrentUrl() {
        return this.proxy.sendMessage(6, PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ParamsSpec.$, PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ResponseParamsSpec.$, [], false);
    }
    showBookmarkEditorForCurrentUrl() {
        this.proxy.sendMessage(7, PriceTrackingHandler_ShowBookmarkEditorForCurrentUrl_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the PriceTrackingHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PriceTrackingHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PriceTrackingHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PriceTrackingHandler_TrackPriceForBookmark_ParamsSpec.$, null, impl.trackPriceForBookmark.bind(impl), false);
        this.helper_internal_.registerHandler(1, PriceTrackingHandler_UntrackPriceForBookmark_ParamsSpec.$, null, impl.untrackPriceForBookmark.bind(impl), false);
        this.helper_internal_.registerHandler(2, PriceTrackingHandler_SetPriceTrackingStatusForCurrentUrl_ParamsSpec.$, null, impl.setPriceTrackingStatusForCurrentUrl.bind(impl), false);
        this.helper_internal_.registerHandler(3, PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ParamsSpec.$, PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ResponseParamsSpec.$, impl.getAllShoppingBookmarkProductInfo.bind(impl), false);
        this.helper_internal_.registerHandler(4, PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ParamsSpec.$, PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ResponseParamsSpec.$, impl.getAllPriceTrackedBookmarkProductInfo.bind(impl), false);
        this.helper_internal_.registerHandler(5, PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ParamsSpec.$, PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ResponseParamsSpec.$, impl.getShoppingCollectionBookmarkFolderId.bind(impl), false);
        this.helper_internal_.registerHandler(6, PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ParamsSpec.$, PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ResponseParamsSpec.$, impl.getParentBookmarkFolderNameForCurrentUrl.bind(impl), false);
        this.helper_internal_.registerHandler(7, PriceTrackingHandler_ShowBookmarkEditorForCurrentUrl_ParamsSpec.$, null, impl.showBookmarkEditorForCurrentUrl.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PriceTrackingHandler {
    static get $interfaceName() {
        return "commerce.price_tracking.mojom.PriceTrackingHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PriceTrackingHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PriceTrackingHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PriceTrackingHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    trackPriceForBookmark;
    untrackPriceForBookmark;
    setPriceTrackingStatusForCurrentUrl;
    getAllShoppingBookmarkProductInfo;
    getAllPriceTrackedBookmarkProductInfo;
    getShoppingCollectionBookmarkFolderId;
    getParentBookmarkFolderNameForCurrentUrl;
    showBookmarkEditorForCurrentUrl;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PriceTrackingHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.trackPriceForBookmark =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PriceTrackingHandler_TrackPriceForBookmark_ParamsSpec.$, null, this.trackPriceForBookmark.createReceiverHandler(false /* expectsResponse */), false);
        this.untrackPriceForBookmark =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PriceTrackingHandler_UntrackPriceForBookmark_ParamsSpec.$, null, this.untrackPriceForBookmark.createReceiverHandler(false /* expectsResponse */), false);
        this.setPriceTrackingStatusForCurrentUrl =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PriceTrackingHandler_SetPriceTrackingStatusForCurrentUrl_ParamsSpec.$, null, this.setPriceTrackingStatusForCurrentUrl.createReceiverHandler(false /* expectsResponse */), false);
        this.getAllShoppingBookmarkProductInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ParamsSpec.$, PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ResponseParamsSpec.$, this.getAllShoppingBookmarkProductInfo.createReceiverHandler(true /* expectsResponse */), false);
        this.getAllPriceTrackedBookmarkProductInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ParamsSpec.$, PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ResponseParamsSpec.$, this.getAllPriceTrackedBookmarkProductInfo.createReceiverHandler(true /* expectsResponse */), false);
        this.getShoppingCollectionBookmarkFolderId =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ParamsSpec.$, PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ResponseParamsSpec.$, this.getShoppingCollectionBookmarkFolderId.createReceiverHandler(true /* expectsResponse */), false);
        this.getParentBookmarkFolderNameForCurrentUrl =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ParamsSpec.$, PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ResponseParamsSpec.$, this.getParentBookmarkFolderNameForCurrentUrl.createReceiverHandler(true /* expectsResponse */), false);
        this.showBookmarkEditorForCurrentUrl =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, PriceTrackingHandler_ShowBookmarkEditorForCurrentUrl_ParamsSpec.$, null, this.showBookmarkEditorForCurrentUrl.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PagePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'commerce.price_tracking.mojom.Page', scope);
    }
}
export class PageRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    priceTrackedForBookmark(bookmarkProduct) {
        this.proxy.sendMessage(0, Page_PriceTrackedForBookmark_ParamsSpec.$, null, [
            bookmarkProduct
        ], false);
    }
    priceUntrackedForBookmark(bookmarkProduct) {
        this.proxy.sendMessage(1, Page_PriceUntrackedForBookmark_ParamsSpec.$, null, [
            bookmarkProduct
        ], false);
    }
    operationFailedForBookmark(bookmarkProduct, attemptedTrack) {
        this.proxy.sendMessage(2, Page_OperationFailedForBookmark_ParamsSpec.$, null, [
            bookmarkProduct,
            attemptedTrack
        ], false);
    }
    onProductBookmarkMoved(bookmarkProduct) {
        this.proxy.sendMessage(3, Page_OnProductBookmarkMoved_ParamsSpec.$, null, [
            bookmarkProduct
        ], false);
    }
}
;
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Page_PriceTrackedForBookmark_ParamsSpec.$, null, impl.priceTrackedForBookmark.bind(impl), false);
        this.helper_internal_.registerHandler(1, Page_PriceUntrackedForBookmark_ParamsSpec.$, null, impl.priceUntrackedForBookmark.bind(impl), false);
        this.helper_internal_.registerHandler(2, Page_OperationFailedForBookmark_ParamsSpec.$, null, impl.operationFailedForBookmark.bind(impl), false);
        this.helper_internal_.registerHandler(3, Page_OnProductBookmarkMoved_ParamsSpec.$, null, impl.onProductBookmarkMoved.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Page {
    static get $interfaceName() {
        return "commerce.price_tracking.mojom.Page";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
    helper_internal_;
    $;
    router_;
    priceTrackedForBookmark;
    priceUntrackedForBookmark;
    operationFailedForBookmark;
    onProductBookmarkMoved;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.priceTrackedForBookmark =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Page_PriceTrackedForBookmark_ParamsSpec.$, null, this.priceTrackedForBookmark.createReceiverHandler(false /* expectsResponse */), false);
        this.priceUntrackedForBookmark =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, Page_PriceUntrackedForBookmark_ParamsSpec.$, null, this.priceUntrackedForBookmark.createReceiverHandler(false /* expectsResponse */), false);
        this.operationFailedForBookmark =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, Page_OperationFailedForBookmark_ParamsSpec.$, null, this.operationFailedForBookmark.createReceiverHandler(false /* expectsResponse */), false);
        this.onProductBookmarkMoved =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, Page_OnProductBookmarkMoved_ParamsSpec.$, null, this.onProductBookmarkMoved.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PriceTrackingHandlerFactoryPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'commerce.price_tracking.mojom.PriceTrackingHandlerFactory', scope);
    }
}
export class PriceTrackingHandlerFactoryRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PriceTrackingHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createPriceTrackingHandler(page, handler) {
        this.proxy.sendMessage(0, PriceTrackingHandlerFactory_CreatePriceTrackingHandler_ParamsSpec.$, null, [
            page,
            handler
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PriceTrackingHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PriceTrackingHandlerFactoryReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PriceTrackingHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PriceTrackingHandlerFactory_CreatePriceTrackingHandler_ParamsSpec.$, null, impl.createPriceTrackingHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PriceTrackingHandlerFactory {
    static get $interfaceName() {
        return "commerce.price_tracking.mojom.PriceTrackingHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PriceTrackingHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PriceTrackingHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PriceTrackingHandlerFactoryCallbackRouter {
    helper_internal_;
    $;
    router_;
    createPriceTrackingHandler;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PriceTrackingHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createPriceTrackingHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PriceTrackingHandlerFactory_CreatePriceTrackingHandler_ParamsSpec.$, null, this.createPriceTrackingHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const PriceTrackingHandler_TrackPriceForBookmark_ParamsSpec = { $: {} };
export const PriceTrackingHandler_UntrackPriceForBookmark_ParamsSpec = { $: {} };
export const PriceTrackingHandler_SetPriceTrackingStatusForCurrentUrl_ParamsSpec = { $: {} };
export const PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ParamsSpec = { $: {} };
export const PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ResponseParamsSpec = { $: {} };
export const PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ParamsSpec = { $: {} };
export const PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ResponseParamsSpec = { $: {} };
export const PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ParamsSpec = { $: {} };
export const PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ResponseParamsSpec = { $: {} };
export const PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ParamsSpec = { $: {} };
export const PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ResponseParamsSpec = { $: {} };
export const PriceTrackingHandler_ShowBookmarkEditorForCurrentUrl_ParamsSpec = { $: {} };
export const Page_PriceTrackedForBookmark_ParamsSpec = { $: {} };
export const Page_PriceUntrackedForBookmark_ParamsSpec = { $: {} };
export const Page_OperationFailedForBookmark_ParamsSpec = { $: {} };
export const Page_OnProductBookmarkMoved_ParamsSpec = { $: {} };
export const PriceTrackingHandlerFactory_CreatePriceTrackingHandler_ParamsSpec = { $: {} };
mojo.internal.Struct(PriceTrackingHandler_TrackPriceForBookmark_ParamsSpec.$, 'PriceTrackingHandler_TrackPriceForBookmark_Params', [
    mojo.internal.StructField('bookmarkId', 0, 0, mojo.internal.Int64, BigInt(0), false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PriceTrackingHandler_UntrackPriceForBookmark_ParamsSpec.$, 'PriceTrackingHandler_UntrackPriceForBookmark_Params', [
    mojo.internal.StructField('bookmarkId', 0, 0, mojo.internal.Int64, BigInt(0), false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PriceTrackingHandler_SetPriceTrackingStatusForCurrentUrl_ParamsSpec.$, 'PriceTrackingHandler_SetPriceTrackingStatusForCurrentUrl_Params', [
    mojo.internal.StructField('track', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ParamsSpec.$, 'PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_Params', [], [[0, 8],]);
mojo.internal.Struct(PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ResponseParamsSpec.$, 'PriceTrackingHandler_GetAllShoppingBookmarkProductInfo_ResponseParams', [
    mojo.internal.StructField('productInfos', 0, 0, mojo.internal.Array(commerce_shared_mojom_BookmarkProductInfoSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ParamsSpec.$, 'PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_Params', [], [[0, 8],]);
mojo.internal.Struct(PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ResponseParamsSpec.$, 'PriceTrackingHandler_GetAllPriceTrackedBookmarkProductInfo_ResponseParams', [
    mojo.internal.StructField('productInfos', 0, 0, mojo.internal.Array(commerce_shared_mojom_BookmarkProductInfoSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ParamsSpec.$, 'PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_Params', [], [[0, 8],]);
mojo.internal.Struct(PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ResponseParamsSpec.$, 'PriceTrackingHandler_GetShoppingCollectionBookmarkFolderId_ResponseParams', [
    mojo.internal.StructField('collectionId', 0, 0, mojo.internal.Int64, BigInt(0), false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ParamsSpec.$, 'PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_Params', [], [[0, 8],]);
mojo.internal.Struct(PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ResponseParamsSpec.$, 'PriceTrackingHandler_GetParentBookmarkFolderNameForCurrentUrl_ResponseParams', [
    mojo.internal.StructField('name', 0, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PriceTrackingHandler_ShowBookmarkEditorForCurrentUrl_ParamsSpec.$, 'PriceTrackingHandler_ShowBookmarkEditorForCurrentUrl_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_PriceTrackedForBookmark_ParamsSpec.$, 'Page_PriceTrackedForBookmark_Params', [
    mojo.internal.StructField('bookmarkProduct', 0, 0, commerce_shared_mojom_BookmarkProductInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_PriceUntrackedForBookmark_ParamsSpec.$, 'Page_PriceUntrackedForBookmark_Params', [
    mojo.internal.StructField('bookmarkProduct', 0, 0, commerce_shared_mojom_BookmarkProductInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_OperationFailedForBookmark_ParamsSpec.$, 'Page_OperationFailedForBookmark_Params', [
    mojo.internal.StructField('bookmarkProduct', 0, 0, commerce_shared_mojom_BookmarkProductInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('attemptedTrack', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Page_OnProductBookmarkMoved_ParamsSpec.$, 'Page_OnProductBookmarkMoved_Params', [
    mojo.internal.StructField('bookmarkProduct', 0, 0, commerce_shared_mojom_BookmarkProductInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PriceTrackingHandlerFactory_CreatePriceTrackingHandler_ParamsSpec.$, 'PriceTrackingHandlerFactory_CreatePriceTrackingHandler_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(PageRemote), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('handler', 8, 0, mojo.internal.InterfaceRequest(PriceTrackingHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
