// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { getInstance as getAnnouncerInstance } from '//resources/cr_elements/cr_a11y_announcer/cr_a11y_announcer.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import { I18nMixinLit } from '//resources/cr_elements/i18n_mixin_lit.js';
import { getCss } from './error_scrim.css.js';
import { getHtml } from './error_scrim.html.js';
export class ErrorScrimElement extends I18nMixinLit(CrLitElement) {
    static get is() {
        return 'ntp-error-scrim';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            compactMode: {
                type: Boolean,
            },
            showErrorScrim_: {
                reflect: true,
                type: Boolean,
            },
            errorMessage_: {
                type: String,
            },
        };
    }
    #compactMode_accessor_storage = false;
    get compactMode() { return this.#compactMode_accessor_storage; }
    set compactMode(value) { this.#compactMode_accessor_storage = value; }
    #showErrorScrim__accessor_storage = false;
    get showErrorScrim_() { return this.#showErrorScrim__accessor_storage; }
    set showErrorScrim_(value) { this.#showErrorScrim__accessor_storage = value; }
    #errorMessage__accessor_storage = '';
    get errorMessage_() { return this.#errorMessage__accessor_storage; }
    set errorMessage_(value) { this.#errorMessage__accessor_storage = value; }
    updated(changedProperties) {
        super.updated(changedProperties);
        const changedPrivateProperties = changedProperties;
        if (changedPrivateProperties.has('showErrorScrim_')) {
            if (this.showErrorScrim_) {
                const announcer = getAnnouncerInstance();
                announcer.announce(this.errorMessage_);
                const dismissErrorButton = this.shadowRoot.querySelector('#dismissErrorButton');
                if (dismissErrorButton) {
                    dismissErrorButton.focus();
                }
            }
            this.fire('error-scrim-visibility-changed', {
                showErrorScrim: this.showErrorScrim_,
            });
        }
    }
    setErrorMessage(errorMessage) {
        this.errorMessage_ = errorMessage;
        this.showErrorScrim_ = true;
    }
    onDismissErrorButtonClick_() {
        this.errorMessage_ = '';
        this.showErrorScrim_ = false;
    }
}
customElements.define(ErrorScrimElement.is, ErrorScrimElement);
