"use strict";
import { buildPath, emptyBounds, fillPathWithBoxStyle } from "./highlight_common.js";
export function drawIsolatedElementHighlight(highlight, context, canvasWidth, canvasHeight, emulationScaleFactor) {
  const { currentX, currentY, currentWidth, currentHeight, highlightIndex } = highlight;
  context.save();
  context.fillStyle = highlight.isolationModeHighlightConfig.maskColor;
  context.fillRect(0, 0, canvasWidth, canvasHeight);
  context.clearRect(currentX, currentY, currentWidth, currentHeight);
  context.restore();
  const bounds = emptyBounds();
  const widthPath = buildPath(highlight.widthResizerBorder, bounds, emulationScaleFactor);
  fillPathWithBoxStyle(context, widthPath, bounds, 0, {
    fillColor: highlight.isolationModeHighlightConfig.resizerColor
  });
  const heightPath = buildPath(highlight.heightResizerBorder, bounds, emulationScaleFactor);
  fillPathWithBoxStyle(context, heightPath, bounds, 0, {
    fillColor: highlight.isolationModeHighlightConfig.resizerColor
  });
  const bidirectionPath = buildPath(highlight.bidirectionResizerBorder, bounds, emulationScaleFactor);
  fillPathWithBoxStyle(context, bidirectionPath, bounds, 0, {
    fillColor: highlight.isolationModeHighlightConfig.resizerColor
  });
  return {
    widthPath,
    heightPath,
    bidirectionPath,
    currentWidth,
    currentHeight,
    highlightIndex
  };
}
//# sourceMappingURL=highlight_isolated_element.js.map
