"use strict";
import commonStyle from "./common.css";
import { adoptStyleSheet } from "./common.js";
import { gridStyle } from "./highlight_grid_common.js";
import highlightGridStyle from "./tool_grid.css";
import highlightStyle from "./tool_highlight.css";
import { HighlightOverlay } from "./tool_highlight.js";
import pausedStyle from "./tool_paused.css";
import { PausedOverlay } from "./tool_paused.js";
import { PersistentOverlay } from "./tool_persistent.js";
import screenshotStyle from "./tool_screenshot.css";
import { ScreenshotOverlay } from "./tool_screenshot.js";
import sourceOrderStyle from "./tool_source_order.css";
import { SourceOrderOverlay } from "./tool_source_order.js";
import { ViewportSizeOverlay } from "./tool_viewport_size.js";
import wcoStyle from "./tool_window_controls.css";
import { WindowControlsOverlay } from "./tool_window_controls.js";
adoptStyleSheet(commonStyle);
const gridStyleSheet = new CSSStyleSheet();
gridStyleSheet.replaceSync(gridStyle);
const highlightOverlay = new HighlightOverlay(window, [highlightStyle, gridStyleSheet]);
const persistentOverlay = new PersistentOverlay(window, [highlightGridStyle, gridStyleSheet]);
const pausedOverlay = new PausedOverlay(window, pausedStyle);
const screenshotOverlay = new ScreenshotOverlay(window, screenshotStyle);
const sourceOrderOverlay = new SourceOrderOverlay(window, sourceOrderStyle);
const viewportSizeOverlay = new ViewportSizeOverlay(window);
const windowControlsOverlay = new WindowControlsOverlay(window, [wcoStyle]);
const overlays = {
  highlight: highlightOverlay,
  persistent: persistentOverlay,
  paused: pausedOverlay,
  screenshot: screenshotOverlay,
  sourceOrder: sourceOrderOverlay,
  viewportSize: viewportSizeOverlay,
  windowControlsOverlay
};
let currentOverlay;
let platformName;
const dispatch = (message) => {
  const functionName = message[0];
  if (functionName === "setOverlay") {
    const overlayName = message[1];
    if (currentOverlay) {
      currentOverlay.uninstall();
    }
    currentOverlay = overlays[overlayName];
    currentOverlay.setPlatform(platformName);
    if (!currentOverlay.installed) {
      currentOverlay.install();
    }
  } else if (functionName === "setPlatform") {
    platformName = message[1];
  } else if (functionName === "drawingFinished") {
  } else {
    currentOverlay.dispatch(message);
  }
};
window.dispatch = dispatch;
//# sourceMappingURL=main.js.map
