// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./cluster_menu.js";import"./horizontal_carousel.js";import"./search_query.js";import"./url_visit.js";import"//resources/cr_elements/cr_auto_img/cr_auto_img.js";import{HistoryResultType}from"//resources/cr_components/history/constants.js";import{I18nMixinLit}from"//resources/cr_elements/i18n_mixin_lit.js";import{assert}from"//resources/js/assert.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{BrowserProxyImpl}from"./browser_proxy.js";import{getCss}from"./cluster.css.js";import{getHtml}from"./cluster.html.js";import{ClusterAction,VisitAction}from"./history_clusters.mojom-webui.js";import{MetricsProxyImpl}from"./metrics_proxy.js";import{insertHighlightedTextWithMatchesIntoElement}from"./utils.js";const ClusterElementBase=I18nMixinLit(CrLitElement);export class ClusterElement extends ClusterElementBase{static get is(){return"history-cluster"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{cluster:{type:Object},index:{type:Number},inSidePanel:{type:Boolean,reflect:true},query:{type:String},relatedSearches_:{type:Array},label_:{type:String,state:true},imageUrl_:{type:String}}}#cluster_accessor_storage;get cluster(){return this.#cluster_accessor_storage}set cluster(value){this.#cluster_accessor_storage=value}#index_accessor_storage=-1;get index(){return this.#index_accessor_storage}set index(value){this.#index_accessor_storage=value}#inSidePanel_accessor_storage=loadTimeData.getBoolean("inSidePanel");get inSidePanel(){return this.#inSidePanel_accessor_storage}set inSidePanel(value){this.#inSidePanel_accessor_storage=value}#query_accessor_storage="";get query(){return this.#query_accessor_storage}set query(value){this.#query_accessor_storage=value}#imageUrl__accessor_storage="";get imageUrl_(){return this.#imageUrl__accessor_storage}set imageUrl_(value){this.#imageUrl__accessor_storage=value}#relatedSearches__accessor_storage=[];get relatedSearches_(){return this.#relatedSearches__accessor_storage}set relatedSearches_(value){this.#relatedSearches__accessor_storage=value}callbackRouter_;onVisitsHiddenListenerId_=null;onVisitsRemovedListenerId_=null;#label__accessor_storage="no_label";get label_(){return this.#label__accessor_storage}set label_(value){this.#label__accessor_storage=value}constructor(){super();this.callbackRouter_=BrowserProxyImpl.getInstance().callbackRouter}connectedCallback(){super.connectedCallback();this.onVisitsHiddenListenerId_=this.callbackRouter_.onVisitsHidden.addListener(this.onVisitsRemovedOrHidden_.bind(this));this.onVisitsRemovedListenerId_=this.callbackRouter_.onVisitsRemoved.addListener(this.onVisitsRemovedOrHidden_.bind(this))}disconnectedCallback(){super.disconnectedCallback();assert(this.onVisitsHiddenListenerId_);this.callbackRouter_.removeListener(this.onVisitsHiddenListenerId_);this.onVisitsHiddenListenerId_=null;assert(this.onVisitsRemovedListenerId_);this.callbackRouter_.removeListener(this.onVisitsRemovedListenerId_);this.onVisitsRemovedListenerId_=null}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("cluster")){assert(this.cluster);this.label_=this.cluster.label?this.cluster.label:"no_label";this.imageUrl_=this.cluster.imageUrl?this.cluster.imageUrl.url:"";this.relatedSearches_=this.cluster.relatedSearches.filter(((query,index)=>query&&!(this.inSidePanel&&index>2)))}}updated(changedProperties){super.updated(changedProperties);const changedPrivateProperties=changedProperties;if(changedPrivateProperties.has("label_")&&this.label_!=="no_label"&&this.cluster){insertHighlightedTextWithMatchesIntoElement(this.$.label,this.cluster.label,this.cluster.labelMatchPositions)}if(changedPrivateProperties.has("imageUrl_")){requestIdleCallback((()=>{this.fire("iron-resize")}))}else if(changedProperties.has("cluster")){this.fire("iron-resize")}}onRelatedSearchClicked_(){MetricsProxyImpl.getInstance().recordClusterAction(ClusterAction.kRelatedSearchClicked,this.index)}clearSelection_(event){this.onBrowserIdle_().then((()=>{if(window.getSelection()&&!event.altKey){window.getSelection()?.empty()}}))}onVisitClicked_(event){MetricsProxyImpl.getInstance().recordClusterAction(ClusterAction.kVisitClicked,this.index);const visit=event.detail;const visitIndex=this.getVisitIndex_(visit);MetricsProxyImpl.getInstance().recordVisitAction(VisitAction.kClicked,visitIndex,MetricsProxyImpl.getVisitType(visit));this.fire("record-history-link-click",{resultType:HistoryResultType.GROUPED,index:visitIndex})}onOpenAllVisits_(){assert(this.cluster);BrowserProxyImpl.getInstance().handler.openVisitUrlsInTabGroup(this.cluster.visits,this.cluster.tabGroupName??null);MetricsProxyImpl.getInstance().recordClusterAction(ClusterAction.kOpenedInTabGroup,this.index)}onHideAllVisits_(){this.fire("hide-visits",this.cluster?this.cluster.visits:[])}onRemoveAllVisits_(){this.fire("remove-visits",this.cluster?this.cluster.visits:[])}onHideVisit_(event){const visit=event.detail;MetricsProxyImpl.getInstance().recordVisitAction(VisitAction.kHidden,this.getVisitIndex_(visit),MetricsProxyImpl.getVisitType(visit))}onRemoveVisit_(event){const visit=event.detail;MetricsProxyImpl.getInstance().recordVisitAction(VisitAction.kDeleted,this.getVisitIndex_(visit),MetricsProxyImpl.getVisitType(visit));this.fire("remove-visits",[visit])}onBrowserIdle_(){return new Promise((resolve=>{requestIdleCallback((()=>{resolve()}))}))}onVisitsRemovedOrHidden_(removedVisits){assert(this.cluster);const visitHasBeenRemoved=visit=>removedVisits.findIndex((removedVisit=>{if(visit.normalizedUrl.url!==removedVisit.normalizedUrl.url){return false}const rawVisitTime=visit.rawVisitData.visitTime.internalValue;return removedVisit.rawVisitData.visitTime.internalValue===rawVisitTime||removedVisit.duplicates.map((data=>data.visitTime.internalValue)).includes(rawVisitTime)}))!==-1;const allVisits=this.cluster.visits;const remainingVisits=allVisits.filter((v=>!visitHasBeenRemoved(v)));if(allVisits.length===remainingVisits.length){return}if(!remainingVisits.length){this.fire("remove-cluster",this.index);MetricsProxyImpl.getInstance().recordClusterAction(ClusterAction.kDeleted,this.index)}else{this.cluster.visits=remainingVisits;this.requestUpdate()}this.updateComplete.then((()=>{this.fire("iron-resize")}))}getVisitIndex_(visit){return this.cluster?this.cluster.visits.indexOf(visit):-1}hideRelatedSearches_(){return!this.cluster||!this.cluster.relatedSearches.length}debugInfo_(){return this.cluster&&this.cluster.debugInfo?this.cluster.debugInfo:""}timestamp_(){return this.cluster&&this.cluster.visits.length>0?this.cluster.visits[0].relativeDate:""}visits_(){return this.cluster?this.cluster.visits:[]}}customElements.define(ClusterElement.is,ClusterElement);