// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert,assertNotReached}from"//resources/js/assert.js";import{sanitizeInnerHtml}from"//resources/js/parse_html_subset.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{getCss}from"./localized_link.css.js";import{getHtml}from"./localized_link.html.js";export class LocalizedLinkElement extends CrLitElement{static get is(){return"localized-link"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{localizedString:{type:String},linkUrl:{type:String},linkDisabled:{type:Boolean,reflect:true},containerInnerHTML_:{type:String}}}#localizedString_accessor_storage="";get localizedString(){return this.#localizedString_accessor_storage}set localizedString(value){this.#localizedString_accessor_storage=value}#linkUrl_accessor_storage="";get linkUrl(){return this.#linkUrl_accessor_storage}set linkUrl(value){this.#linkUrl_accessor_storage=value}#linkDisabled_accessor_storage=false;get linkDisabled(){return this.#linkDisabled_accessor_storage}set linkDisabled(value){this.#linkDisabled_accessor_storage=value}#containerInnerHTML__accessor_storage="";get containerInnerHTML_(){return this.#containerInnerHTML__accessor_storage}set containerInnerHTML_(value){this.#containerInnerHTML__accessor_storage=value}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("localizedString")||changedProperties.has("linkUrl")){this.containerInnerHTML_=this.getAriaLabelledContent_(this.localizedString,this.linkUrl)}}updated(changedProperties){super.updated(changedProperties);const changedPrivateProperties=changedProperties;if(changedPrivateProperties.has("containerInnerHTML_")){this.setContainerInnerHtml_()}if(changedProperties.has("linkDisabled")){this.updateAnchorTagTabIndex_()}}getAriaLabelledContent_(localizedString,linkUrl){const tempEl=document.createElement("div");tempEl.innerHTML=sanitizeInnerHtml(localizedString,{attrs:["id"]});const ariaLabelledByIds=[];tempEl.childNodes.forEach(((node,index)=>{if(node.nodeType===Node.TEXT_NODE){const spanNode=document.createElement("span");spanNode.textContent=node.textContent;spanNode.id=`id${index}`;ariaLabelledByIds.push(spanNode.id);spanNode.setAttribute("aria-hidden","true");node.replaceWith(spanNode);return}if(node.nodeType===Node.ELEMENT_NODE&&node.nodeName==="A"){const element=node;element.id=`id${index}`;ariaLabelledByIds.push(element.id);return}assertNotReached("localized-link has invalid node types")}));const anchorTags=tempEl.querySelectorAll("a");if(anchorTags.length===0){return localizedString}assert(anchorTags.length===1,"localized-link should contain exactly one anchor tag");const anchorTag=anchorTags[0];anchorTag.setAttribute("aria-labelledby",ariaLabelledByIds.join(" "));anchorTag.tabIndex=this.linkDisabled?-1:0;if(linkUrl!==""){anchorTag.href=linkUrl;anchorTag.target="_blank"}return tempEl.innerHTML}setContainerInnerHtml_(){this.$.container.innerHTML=sanitizeInnerHtml(this.containerInnerHTML_,{attrs:["aria-hidden","aria-labelledby","id","tabindex"]});const anchorTag=this.shadowRoot.querySelector("a");if(anchorTag){anchorTag.addEventListener("click",(event=>this.onAnchorTagClick_(event)));anchorTag.addEventListener("auxclick",(event=>{if(event.button===1){this.onAnchorTagClick_(event)}}))}}onAnchorTagClick_(event){if(this.linkDisabled){event.preventDefault();return}this.fire("link-clicked",{event:event});event.stopPropagation()}updateAnchorTagTabIndex_(){const anchorTag=this.shadowRoot.querySelector("a");if(!anchorTag){return}anchorTag.tabIndex=this.linkDisabled?-1:0}}customElements.define(LocalizedLinkElement.is,LocalizedLinkElement);