// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./searchbox_match.js";import"//resources/cr_elements/cr_icon_button/cr_icon_button.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{MetricsReporterImpl}from"//resources/js/metrics_reporter/metrics_reporter.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{RenderType,SideType}from"//resources/mojo/components/omnibox/browser/searchbox.mojom-webui.js";import{getCss}from"./searchbox_dropdown.css.js";import{getHtml}from"./searchbox_dropdown.html.js";import{renderTypeToClass,sideTypeToClass}from"./utils.js";const remainder=(lhs,rhs)=>(lhs%rhs+rhs)%rhs;export class SearchboxDropdownElement extends CrLitElement{static get is(){return"cr-searchbox-dropdown"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{canShowSecondarySide:{type:Boolean},hadSecondarySide:{type:Boolean,notify:true},hasSecondarySide:{type:Boolean,notify:true,reflect:true},hasEmptyInput:{type:Boolean,reflect:true},result:{type:Object},selectedMatchIndex:{type:Number,notify:true},showThumbnail:{type:Boolean},showSecondarySide_:{type:Boolean}}}#canShowSecondarySide_accessor_storage=false;get canShowSecondarySide(){return this.#canShowSecondarySide_accessor_storage}set canShowSecondarySide(value){this.#canShowSecondarySide_accessor_storage=value}#hadSecondarySide_accessor_storage=false;get hadSecondarySide(){return this.#hadSecondarySide_accessor_storage}set hadSecondarySide(value){this.#hadSecondarySide_accessor_storage=value}#hasSecondarySide_accessor_storage=false;get hasSecondarySide(){return this.#hasSecondarySide_accessor_storage}set hasSecondarySide(value){this.#hasSecondarySide_accessor_storage=value}#hasEmptyInput_accessor_storage=false;get hasEmptyInput(){return this.#hasEmptyInput_accessor_storage}set hasEmptyInput(value){this.#hasEmptyInput_accessor_storage=value}#result_accessor_storage=null;get result(){return this.#result_accessor_storage}set result(value){this.#result_accessor_storage=value}#selectedMatchIndex_accessor_storage=-1;get selectedMatchIndex(){return this.#selectedMatchIndex_accessor_storage}set selectedMatchIndex(value){this.#selectedMatchIndex_accessor_storage=value}#showThumbnail_accessor_storage=false;get showThumbnail(){return this.#showThumbnail_accessor_storage}set showThumbnail(value){this.#showThumbnail_accessor_storage=value}#showSecondarySide__accessor_storage=false;get showSecondarySide_(){return this.#showSecondarySide__accessor_storage}set showSecondarySide_(value){this.#showSecondarySide__accessor_storage=value}selectableMatchElements_=[];willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("result")){this.hasSecondarySide=this.computeHasSecondarySide_();this.hasEmptyInput=this.computeHasEmptyInput_()}if(changedProperties.has("result")||changedProperties.has("canShowSecondarySide")){this.showSecondarySide_=this.computeShowSecondarySide_()}}updated(changedProperties){super.updated(changedProperties);this.onResultRepaint_();this.selectableMatchElements_=[...this.shadowRoot.querySelectorAll("cr-searchbox-match")]}get selectableMatchElements(){return this.selectableMatchElements_.filter((matchEl=>matchEl.sideType===SideType.kDefaultPrimary||this.showSecondarySide_))}unselect(){this.selectedMatchIndex=-1}focusSelected(){this.selectableMatchElements[this.selectedMatchIndex]?.focus()}selectFirst(){this.selectedMatchIndex=0;return this.updateComplete}selectIndex(index){this.selectedMatchIndex=index;return this.updateComplete}updateSelection(oldSelection,selection){if(oldSelection.line!==selection.line){const oldMatch=this.selectableMatchElements[this.selectedMatchIndex];if(oldMatch){oldMatch.selection=selection}}this.selectIndex(selection.line);const newMatch=this.selectableMatchElements[this.selectedMatchIndex];if(newMatch){newMatch.selection=selection}}selectPrevious(){const previous=Math.max(this.selectedMatchIndex,0)-1;this.selectedMatchIndex=remainder(previous,this.selectableMatchElements.length);return this.updateComplete}selectLast(){this.selectedMatchIndex=this.selectableMatchElements.length-1;return this.updateComplete}selectNext(){const next=this.selectedMatchIndex+1;this.selectedMatchIndex=remainder(next,this.selectableMatchElements.length);return this.updateComplete}onHeaderMousedown_(e){e.preventDefault()}onResultRepaint_(){if(!loadTimeData.getBoolean("reportMetrics")){return}const metricsReporter=MetricsReporterImpl.getInstance();metricsReporter.measure("CharTyped").then((duration=>{metricsReporter.umaReportTime(loadTimeData.getString("charTypedToPaintMetricName"),duration)})).then((()=>{metricsReporter.clearMark("CharTyped")})).catch((()=>{}));metricsReporter.measure("ResultChanged").then((duration=>{metricsReporter.umaReportTime(loadTimeData.getString("resultChangedToPaintMetricName"),duration)})).then((()=>{metricsReporter.clearMark("ResultChanged")})).catch((()=>{}))}sideTypeClass_(side){return sideTypeToClass(side)}renderTypeClassForGroup_(groupId){return renderTypeToClass(this.result?.suggestionGroupsMap[groupId]?.renderType??RenderType.kDefaultVertical)}computeHasSecondarySide_(){const hasSecondarySide=!!this.groupIdsForSideType_(SideType.kSecondary).length;if(!this.hadSecondarySide){this.hadSecondarySide=hasSecondarySide}return hasSecondarySide}computeHasEmptyInput_(){return!!this.result&&this.result.input===""}isSelected_(match){return this.matchIndex_(match)===this.selectedMatchIndex}groupIdsForSideType_(side){return[...new Set(this.result?.matches.map((match=>match.suggestionGroupId)).filter((groupId=>this.sideTypeForGroup_(groupId)===side)))]}hasHeaderForGroup_(groupId){return!!this.headerForGroup_(groupId)}headerForGroup_(groupId){return this.result?.suggestionGroupsMap[groupId]?this.result.suggestionGroupsMap[groupId].header:""}matchIndex_(match){return this.result?.matches.indexOf(match)??-1}matchesForGroup_(groupId){return(this.result?.matches??[]).filter((match=>match.suggestionGroupId===groupId))}sideTypes_(){return this.showSecondarySide_?[SideType.kDefaultPrimary,SideType.kSecondary]:[SideType.kDefaultPrimary]}sideTypeForGroup_(groupId){return this.result?.suggestionGroupsMap[groupId]?.sideType??SideType.kDefaultPrimary}computeShowSecondarySide_(){if(!this.canShowSecondarySide){return false}const primaryGroupIds=this.groupIdsForSideType_(SideType.kDefaultPrimary);return primaryGroupIds.some((groupId=>this.matchesForGroup_(groupId).length>0))}}customElements.define(SearchboxDropdownElement.is,SearchboxDropdownElement);