// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/cr_elements/cr_action_menu/cr_action_menu.js";import"//resources/cr_elements/cr_checkbox/cr_checkbox.js";import{CrLitElement}from"chrome://resources/lit/v3_0/lit.rollup.js";import{AppType,RunOnOsLoginMode}from"./app_home.mojom-webui.js";import{AppHomeUserAction,recordUserAction}from"./app_home_utils.js";import{getCss}from"./app_item.css.js";import{getHtml}from"./app_item.html.js";import{BrowserProxy}from"./browser_proxy.js";import{UserDisplayMode}from"./user_display_mode.mojom-webui.js";export class AppItemElement extends CrLitElement{static get is(){return"app-item"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{appInfo:{type:Object}}}#appInfo_accessor_storage={appType:AppType.kWebApp,id:"",startUrl:{url:""},name:"",iconUrl:{url:""},mayShowRunOnOsLoginMode:false,mayToggleRunOnOsLoginMode:false,runOnOsLoginMode:0,isLocallyInstalled:false,openInWindow:false,mayUninstall:false,storePageUrl:{url:""}};get appInfo(){return this.#appInfo_accessor_storage}set appInfo(value){this.#appInfo_accessor_storage=value}firstUpdated(){this.addEventListener("contextmenu",this.handleContextMenu_);this.addEventListener("click",this.handleClick_);this.addEventListener("auxclick",this.handleClick_)}closeContextMenu(){if(!this.$.menu.open){return}this.$.menu.close();this.fire_("on-menu-closed",{appItem:this})}handleContextMenu_(e){const position=this.getPositionForEvent_(e);if(this.isValidPosition(position)){this.fire_("on-menu-open-triggered",{appItem:this});this.$.menu.showAtPosition(position);recordUserAction(AppHomeUserAction.CONTEXT_MENU_TRIGGERED)}e.preventDefault();e.stopPropagation()}isValidPosition(position){const rect=this.shadowRoot.getElementById("objectContainer").getBoundingClientRect();if(!rect){return false}return position.top>=rect.top&&position.top<=rect.bottom&&position.left>=rect.left&&position.left<=rect.right}getPositionForEvent_(e){if(e instanceof MouseEvent){return{top:e.clientY,left:e.clientX}}else{const rect=this.shadowRoot.getElementById("iconContainer").getBoundingClientRect();if(rect){return{top:rect.top+rect.height/2,left:rect.left+rect.width/2}}else{return{top:0,left:0}}}}handleClick_(e){if(e.button>1){return}const clickEvent={button:e.button,altKey:e.altKey,ctrlKey:e.ctrlKey,metaKey:e.metaKey,shiftKey:e.shiftKey};if(this.appInfo.appType===AppType.kDeprecatedChromeApp){recordUserAction(AppHomeUserAction.LAUNCH_DEPRECATED_APP)}else{recordUserAction(AppHomeUserAction.LAUNCH_WEB_APP)}BrowserProxy.getInstance().handler.launchApp(this.appInfo.id,clickEvent);e.preventDefault();e.stopPropagation()}fire_(eventName,detail){this.dispatchEvent(new CustomEvent(eventName,{bubbles:true,composed:true,detail:detail}))}onMenuMousedown_(e){if(e.button!==2){return}if(e.composedPath()[0].tagName!=="DIALOG"){return}this.closeContextMenu()}isWebStoreLinkHidden_(){return!this.appInfo.storePageUrl}isOpenInWindowHidden_(){return!this.appInfo.isLocallyInstalled||this.appInfo.appType===AppType.kDeprecatedChromeApp||this.appInfo.appType===AppType.kIsolatedWebApp}isLaunchOnStartupDisabled_(){return!this.appInfo.mayToggleRunOnOsLoginMode}isLaunchOnStartupHidden_(){return!this.appInfo.mayShowRunOnOsLoginMode||this.appInfo.appType===AppType.kDeprecatedChromeApp}isCreateShortcutHidden_(){return!this.appInfo.isLocallyInstalled||this.appInfo.appType===AppType.kDeprecatedChromeApp}isInstallLocallyHidden_(){return this.appInfo.isLocallyInstalled||this.appInfo.appType===AppType.kDeprecatedChromeApp}isUninstallHidden_(){return!this.appInfo.isLocallyInstalled}isRemoveFromChromeHidden_(){return this.appInfo.isLocallyInstalled}isAppSettingsHidden_(){return!this.appInfo.isLocallyInstalled}isLocallyInstalled_(){return this.appInfo.isLocallyInstalled}isLaunchOnStartUp_(){return this.appInfo.runOnOsLoginMode!==RunOnOsLoginMode.kNotRun}onMenuClick_(event){event.stopPropagation()}openStorePage_(){if(!this.appInfo.storePageUrl){return}window.open(new URL(this.appInfo.storePageUrl.url),"_blank");this.closeContextMenu()}onOpenInWindowItemChange_(e){const checked=e.detail;if(!checked){BrowserProxy.getInstance().handler.setUserDisplayMode(this.appInfo.id,UserDisplayMode.kBrowser);recordUserAction(AppHomeUserAction.OPEN_IN_WINDOW_UNCHECKED)}else{BrowserProxy.getInstance().handler.setUserDisplayMode(this.appInfo.id,UserDisplayMode.kStandalone);recordUserAction(AppHomeUserAction.OPEN_IN_WINDOW_CHECKED)}}onLaunchOnStartupItemClick_(){if(this.isLaunchOnStartupDisabled_()){return}if(this.isLaunchOnStartUp_()){BrowserProxy.getInstance().handler.setRunOnOsLoginMode(this.appInfo.id,RunOnOsLoginMode.kNotRun);recordUserAction(AppHomeUserAction.LAUNCH_AT_STARTUP_UNCHECKED)}else{BrowserProxy.getInstance().handler.setRunOnOsLoginMode(this.appInfo.id,RunOnOsLoginMode.kWindowed);recordUserAction(AppHomeUserAction.LAUNCH_AT_STARTUP_CHECKED)}}onCreateShortcutItemClick_(){if(this.appInfo.id){BrowserProxy.getInstance().handler.createAppShortcut(this.appInfo.id);recordUserAction(AppHomeUserAction.CREATE_SHORTCUT)}this.closeContextMenu()}onInstallLocallyItemClick_(){if(this.appInfo.id){BrowserProxy.getInstance().handler.installAppLocally(this.appInfo.id);recordUserAction(AppHomeUserAction.INSTALL_APP_LOCALLY)}this.closeContextMenu()}onUninstallItemClick_(){if(this.appInfo.id){BrowserProxy.getInstance().handler.uninstallApp(this.appInfo.id);recordUserAction(AppHomeUserAction.UNINSTALL)}this.closeContextMenu()}onAppSettingsItemClick_(){if(this.appInfo.id){BrowserProxy.getInstance().handler.showAppSettings(this.appInfo.id);recordUserAction(AppHomeUserAction.OPEN_APP_SETTINGS)}this.closeContextMenu()}getIconUrl_(){const url=new URL(this.appInfo.iconUrl.url);if(!this.isLocallyInstalled_()){url.searchParams.append("grayscale","true")}return url}}customElements.define(AppItemElement.is,AppItemElement);