// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/cr_elements/cr_button/cr_button.js";import"chrome://resources/cr_elements/cr_dialog/cr_dialog.js";import{castExists}from"chrome://resources/cr_components/app_management/util.js";import{I18nMixinLit}from"chrome://resources/cr_elements/i18n_mixin_lit.js";import{assert}from"chrome://resources/js/assert.js";import{CrLitElement}from"chrome://resources/lit/v3_0/lit.rollup.js";import{getCss}from"./app_management_shared_style.css.js";import{getHtml}from"./supported_links_overlapping_apps_dialog.html.js";import{createDummyApp}from"./web_app_settings_utils.js";const SupportedLinksOverlappingAppsDialogElementBase=I18nMixinLit(CrLitElement);export class SupportedLinksOverlappingAppsDialogElement extends SupportedLinksOverlappingAppsDialogElementBase{static get is(){return"app-management-supported-links-overlapping-apps-dialog"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{app:{type:Object},apps:{type:Object},overlappingAppIds:{type:Array}}}#app_accessor_storage=createDummyApp();get app(){return this.#app_accessor_storage}set app(value){this.#app_accessor_storage=value}#overlappingAppIds_accessor_storage=[];get overlappingAppIds(){return this.#overlappingAppIds_accessor_storage}set overlappingAppIds(value){this.#overlappingAppIds_accessor_storage=value}#apps_accessor_storage={};get apps(){return this.#apps_accessor_storage}set apps(value){this.#apps_accessor_storage=value}getBodyText_(){const appNames=this.overlappingAppIds.map((appId=>this.apps[appId].title));const appTitle=castExists(this.app.title);switch(appNames.length){case 1:assert(appNames[0]);return this.i18n("appManagementIntentOverlapDialogText1App",appTitle,appNames[0]);case 2:return this.i18n("appManagementIntentOverlapDialogText2Apps",appTitle,...appNames);case 3:return this.i18n("appManagementIntentOverlapDialogText3Apps",appTitle,...appNames);case 4:return this.i18n("appManagementIntentOverlapDialogText4Apps",appTitle,...appNames.slice(0,3));default:return this.i18n("appManagementIntentOverlapDialogText5OrMoreApps",appTitle,...appNames.slice(0,3),appNames.length-3)}}wasConfirmed(){return this.$.dialog.getNative().returnValue==="success"}onChangeClick_(){this.$.dialog.close()}onCancelClick_(){this.$.dialog.cancel()}}customElements.define(SupportedLinksOverlappingAppsDialogElement.is,SupportedLinksOverlappingAppsDialogElement);