// device/bluetooth/public/mojom/adapter.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { DeviceRemote as bluetooth_mojom_DeviceRemote, DeviceInfoSpec as bluetooth_mojom_DeviceInfoSpec } from './device.mojom-webui.js';
import { GattCharacteristicPermissionsSpec as bluetooth_mojom_GattCharacteristicPermissionsSpec } from './gatt_characteristic_permissions.mojom-webui.js';
import { GattCharacteristicPropertiesSpec as bluetooth_mojom_GattCharacteristicPropertiesSpec } from './gatt_characteristic_properties.mojom-webui.js';
import { GattServiceErrorCodeSpec as bluetooth_mojom_GattServiceErrorCodeSpec } from './gatt_service_error_code.mojom-webui.js';
import { UUIDSpec as bluetooth_mojom_UUIDSpec } from './uuid.mojom-webui.js';
export const ConnectResultSpec = { $: mojo.internal.Enum() };
export var ConnectResult;
(function (ConnectResult) {
    ConnectResult[ConnectResult["MIN_VALUE"] = 0] = "MIN_VALUE";
    ConnectResult[ConnectResult["MAX_VALUE"] = 22] = "MAX_VALUE";
    ConnectResult[ConnectResult["SUCCESS"] = 0] = "SUCCESS";
    ConnectResult[ConnectResult["AUTH_CANCELED"] = 1] = "AUTH_CANCELED";
    ConnectResult[ConnectResult["AUTH_FAILED"] = 2] = "AUTH_FAILED";
    ConnectResult[ConnectResult["AUTH_REJECTED"] = 3] = "AUTH_REJECTED";
    ConnectResult[ConnectResult["AUTH_TIMEOUT"] = 4] = "AUTH_TIMEOUT";
    ConnectResult[ConnectResult["FAILED"] = 5] = "FAILED";
    ConnectResult[ConnectResult["INPROGRESS"] = 6] = "INPROGRESS";
    ConnectResult[ConnectResult["UNKNOWN"] = 7] = "UNKNOWN";
    ConnectResult[ConnectResult["UNSUPPORTED_DEVICE"] = 8] = "UNSUPPORTED_DEVICE";
    ConnectResult[ConnectResult["DEVICE_NO_LONGER_IN_RANGE"] = 9] = "DEVICE_NO_LONGER_IN_RANGE";
    ConnectResult[ConnectResult["NOT_READY"] = 10] = "NOT_READY";
    ConnectResult[ConnectResult["ALREADY_CONNECTED"] = 11] = "ALREADY_CONNECTED";
    ConnectResult[ConnectResult["ALREADY_EXISTS"] = 12] = "ALREADY_EXISTS";
    ConnectResult[ConnectResult["NOT_CONNECTED"] = 13] = "NOT_CONNECTED";
    ConnectResult[ConnectResult["DOES_NOT_EXIST"] = 14] = "DOES_NOT_EXIST";
    ConnectResult[ConnectResult["INVALID_ARGS"] = 15] = "INVALID_ARGS";
    ConnectResult[ConnectResult["NON_AUTH_TIMEOUT"] = 16] = "NON_AUTH_TIMEOUT";
    ConnectResult[ConnectResult["NO_MEMORY"] = 17] = "NO_MEMORY";
    ConnectResult[ConnectResult["JNI_ENVIRONMENT"] = 18] = "JNI_ENVIRONMENT";
    ConnectResult[ConnectResult["JNI_THREAD_ATTACH"] = 19] = "JNI_THREAD_ATTACH";
    ConnectResult[ConnectResult["WAKELOCK"] = 20] = "WAKELOCK";
    ConnectResult[ConnectResult["UNEXPECTED_STATE"] = 21] = "UNEXPECTED_STATE";
    ConnectResult[ConnectResult["SOCKET"] = 22] = "SOCKET";
})(ConnectResult || (ConnectResult = {}));
export class AdvertisementPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'bluetooth.mojom.Advertisement', scope);
    }
}
export class AdvertisementRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(AdvertisementPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    unregister() {
        return this.proxy.sendMessage(0, Advertisement_Unregister_ParamsSpec.$, Advertisement_Unregister_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the Advertisement
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AdvertisementReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AdvertisementRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Advertisement_Unregister_ParamsSpec.$, Advertisement_Unregister_ResponseParamsSpec.$, impl.unregister.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Advertisement {
    static get $interfaceName() {
        return "bluetooth.mojom.Advertisement";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new AdvertisementRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Advertisement
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AdvertisementCallbackRouter {
    helper_internal_;
    $;
    router_;
    unregister;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AdvertisementRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.unregister =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Advertisement_Unregister_ParamsSpec.$, Advertisement_Unregister_ResponseParamsSpec.$, this.unregister.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class DiscoverySessionPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'bluetooth.mojom.DiscoverySession', scope);
    }
}
export class DiscoverySessionRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(DiscoverySessionPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    isActive() {
        return this.proxy.sendMessage(0, DiscoverySession_IsActive_ParamsSpec.$, DiscoverySession_IsActive_ResponseParamsSpec.$, [], false);
    }
    stop() {
        return this.proxy.sendMessage(1, DiscoverySession_Stop_ParamsSpec.$, DiscoverySession_Stop_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the DiscoverySession
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DiscoverySessionReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DiscoverySessionRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, DiscoverySession_IsActive_ParamsSpec.$, DiscoverySession_IsActive_ResponseParamsSpec.$, impl.isActive.bind(impl), false);
        this.helper_internal_.registerHandler(1, DiscoverySession_Stop_ParamsSpec.$, DiscoverySession_Stop_ResponseParamsSpec.$, impl.stop.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class DiscoverySession {
    static get $interfaceName() {
        return "bluetooth.mojom.DiscoverySession";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new DiscoverySessionRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the DiscoverySession
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DiscoverySessionCallbackRouter {
    helper_internal_;
    $;
    router_;
    isActive;
    stop;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DiscoverySessionRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.isActive =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, DiscoverySession_IsActive_ParamsSpec.$, DiscoverySession_IsActive_ResponseParamsSpec.$, this.isActive.createReceiverHandler(true /* expectsResponse */), false);
        this.stop =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, DiscoverySession_Stop_ParamsSpec.$, DiscoverySession_Stop_ResponseParamsSpec.$, this.stop.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class SocketPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'bluetooth.mojom.Socket', scope);
    }
}
export class SocketRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(SocketPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    disconnect() {
        return this.proxy.sendMessage(0, Socket_Disconnect_ParamsSpec.$, Socket_Disconnect_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the Socket
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SocketReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SocketRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Socket_Disconnect_ParamsSpec.$, Socket_Disconnect_ResponseParamsSpec.$, impl.disconnect.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Socket {
    static get $interfaceName() {
        return "bluetooth.mojom.Socket";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new SocketRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Socket
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SocketCallbackRouter {
    helper_internal_;
    $;
    router_;
    disconnect;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SocketRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.disconnect =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Socket_Disconnect_ParamsSpec.$, Socket_Disconnect_ResponseParamsSpec.$, this.disconnect.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class ServerSocketPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'bluetooth.mojom.ServerSocket', scope);
    }
}
export class ServerSocketRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ServerSocketPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    accept() {
        return this.proxy.sendMessage(0, ServerSocket_Accept_ParamsSpec.$, ServerSocket_Accept_ResponseParamsSpec.$, [], false);
    }
    disconnect() {
        return this.proxy.sendMessage(1, ServerSocket_Disconnect_ParamsSpec.$, ServerSocket_Disconnect_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the ServerSocket
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ServerSocketReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ServerSocketRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ServerSocket_Accept_ParamsSpec.$, ServerSocket_Accept_ResponseParamsSpec.$, impl.accept.bind(impl), false);
        this.helper_internal_.registerHandler(1, ServerSocket_Disconnect_ParamsSpec.$, ServerSocket_Disconnect_ResponseParamsSpec.$, impl.disconnect.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ServerSocket {
    static get $interfaceName() {
        return "bluetooth.mojom.ServerSocket";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ServerSocketRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ServerSocket
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ServerSocketCallbackRouter {
    helper_internal_;
    $;
    router_;
    accept;
    disconnect;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ServerSocketRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.accept =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ServerSocket_Accept_ParamsSpec.$, ServerSocket_Accept_ResponseParamsSpec.$, this.accept.createReceiverHandler(true /* expectsResponse */), false);
        this.disconnect =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, ServerSocket_Disconnect_ParamsSpec.$, ServerSocket_Disconnect_ResponseParamsSpec.$, this.disconnect.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class GattServicePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'bluetooth.mojom.GattService', scope);
    }
}
export class GattServiceRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(GattServicePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createCharacteristic(characteristicUuid, permissions, properties) {
        return this.proxy.sendMessage(0, GattService_CreateCharacteristic_ParamsSpec.$, GattService_CreateCharacteristic_ResponseParamsSpec.$, [
            characteristicUuid,
            permissions,
            properties
        ], false);
    }
    register() {
        return this.proxy.sendMessage(1, GattService_Register_ParamsSpec.$, GattService_Register_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the GattService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class GattServiceReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(GattServiceRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, GattService_CreateCharacteristic_ParamsSpec.$, GattService_CreateCharacteristic_ResponseParamsSpec.$, impl.createCharacteristic.bind(impl), false);
        this.helper_internal_.registerHandler(1, GattService_Register_ParamsSpec.$, GattService_Register_ResponseParamsSpec.$, impl.register.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class GattService {
    static get $interfaceName() {
        return "bluetooth.mojom.GattService";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new GattServiceRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the GattService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class GattServiceCallbackRouter {
    helper_internal_;
    $;
    router_;
    createCharacteristic;
    register;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(GattServiceRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createCharacteristic =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, GattService_CreateCharacteristic_ParamsSpec.$, GattService_CreateCharacteristic_ResponseParamsSpec.$, this.createCharacteristic.createReceiverHandler(true /* expectsResponse */), false);
        this.register =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, GattService_Register_ParamsSpec.$, GattService_Register_ResponseParamsSpec.$, this.register.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class GattServiceObserverPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'bluetooth.mojom.GattServiceObserver', scope);
    }
}
export class GattServiceObserverRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(GattServiceObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onLocalCharacteristicRead(remoteDevice, characteristicUuid, serviceUuid, offset) {
        return this.proxy.sendMessage(0, GattServiceObserver_OnLocalCharacteristicRead_ParamsSpec.$, GattServiceObserver_OnLocalCharacteristicRead_ResponseParamsSpec.$, [
            remoteDevice,
            characteristicUuid,
            serviceUuid,
            offset
        ], false);
    }
}
;
/**
 * An object which receives request messages for the GattServiceObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class GattServiceObserverReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(GattServiceObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, GattServiceObserver_OnLocalCharacteristicRead_ParamsSpec.$, GattServiceObserver_OnLocalCharacteristicRead_ResponseParamsSpec.$, impl.onLocalCharacteristicRead.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class GattServiceObserver {
    static get $interfaceName() {
        return "bluetooth.mojom.GattServiceObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new GattServiceObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the GattServiceObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class GattServiceObserverCallbackRouter {
    helper_internal_;
    $;
    router_;
    onLocalCharacteristicRead;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(GattServiceObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onLocalCharacteristicRead =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, GattServiceObserver_OnLocalCharacteristicRead_ParamsSpec.$, GattServiceObserver_OnLocalCharacteristicRead_ResponseParamsSpec.$, this.onLocalCharacteristicRead.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class AdapterPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'bluetooth.mojom.Adapter', scope);
    }
}
export class AdapterRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(AdapterPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    connectToDevice(address) {
        return this.proxy.sendMessage(0, Adapter_ConnectToDevice_ParamsSpec.$, Adapter_ConnectToDevice_ResponseParamsSpec.$, [
            address
        ], false);
    }
    getDevices() {
        return this.proxy.sendMessage(1, Adapter_GetDevices_ParamsSpec.$, Adapter_GetDevices_ResponseParamsSpec.$, [], false);
    }
    getInfo() {
        return this.proxy.sendMessage(2, Adapter_GetInfo_ParamsSpec.$, Adapter_GetInfo_ResponseParamsSpec.$, [], false);
    }
    addObserver(observer) {
        return this.proxy.sendMessage(3, Adapter_AddObserver_ParamsSpec.$, Adapter_AddObserver_ResponseParamsSpec.$, [
            observer
        ], false);
    }
    registerAdvertisement(serviceId, serviceData, useScanResponse, connectable) {
        return this.proxy.sendMessage(4, Adapter_RegisterAdvertisement_ParamsSpec.$, Adapter_RegisterAdvertisement_ResponseParamsSpec.$, [
            serviceId,
            serviceData,
            useScanResponse,
            connectable
        ], false);
    }
    setDiscoverable(discoverable) {
        return this.proxy.sendMessage(5, Adapter_SetDiscoverable_ParamsSpec.$, Adapter_SetDiscoverable_ResponseParamsSpec.$, [
            discoverable
        ], false);
    }
    setName(name) {
        return this.proxy.sendMessage(6, Adapter_SetName_ParamsSpec.$, Adapter_SetName_ResponseParamsSpec.$, [
            name
        ], false);
    }
    startDiscoverySession(clientName) {
        return this.proxy.sendMessage(7, Adapter_StartDiscoverySession_ParamsSpec.$, Adapter_StartDiscoverySession_ResponseParamsSpec.$, [
            clientName
        ], false);
    }
    connectToServiceInsecurely(address, serviceUuid, shouldUnbondOnError) {
        return this.proxy.sendMessage(8, Adapter_ConnectToServiceInsecurely_ParamsSpec.$, Adapter_ConnectToServiceInsecurely_ResponseParamsSpec.$, [
            address,
            serviceUuid,
            shouldUnbondOnError
        ], false);
    }
    createRfcommServiceInsecurely(serviceName, serviceUuid) {
        return this.proxy.sendMessage(9, Adapter_CreateRfcommServiceInsecurely_ParamsSpec.$, Adapter_CreateRfcommServiceInsecurely_ResponseParamsSpec.$, [
            serviceName,
            serviceUuid
        ], false);
    }
    createLocalGattService(serviceId, observer) {
        return this.proxy.sendMessage(10, Adapter_CreateLocalGattService_ParamsSpec.$, Adapter_CreateLocalGattService_ResponseParamsSpec.$, [
            serviceId,
            observer
        ], false);
    }
    isLeScatternetDualRoleSupported() {
        return this.proxy.sendMessage(11, Adapter_IsLeScatternetDualRoleSupported_ParamsSpec.$, Adapter_IsLeScatternetDualRoleSupported_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the Adapter
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AdapterReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AdapterRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Adapter_ConnectToDevice_ParamsSpec.$, Adapter_ConnectToDevice_ResponseParamsSpec.$, impl.connectToDevice.bind(impl), false);
        this.helper_internal_.registerHandler(1, Adapter_GetDevices_ParamsSpec.$, Adapter_GetDevices_ResponseParamsSpec.$, impl.getDevices.bind(impl), false);
        this.helper_internal_.registerHandler(2, Adapter_GetInfo_ParamsSpec.$, Adapter_GetInfo_ResponseParamsSpec.$, impl.getInfo.bind(impl), false);
        this.helper_internal_.registerHandler(3, Adapter_AddObserver_ParamsSpec.$, Adapter_AddObserver_ResponseParamsSpec.$, impl.addObserver.bind(impl), false);
        this.helper_internal_.registerHandler(4, Adapter_RegisterAdvertisement_ParamsSpec.$, Adapter_RegisterAdvertisement_ResponseParamsSpec.$, impl.registerAdvertisement.bind(impl), false);
        this.helper_internal_.registerHandler(5, Adapter_SetDiscoverable_ParamsSpec.$, Adapter_SetDiscoverable_ResponseParamsSpec.$, impl.setDiscoverable.bind(impl), false);
        this.helper_internal_.registerHandler(6, Adapter_SetName_ParamsSpec.$, Adapter_SetName_ResponseParamsSpec.$, impl.setName.bind(impl), false);
        this.helper_internal_.registerHandler(7, Adapter_StartDiscoverySession_ParamsSpec.$, Adapter_StartDiscoverySession_ResponseParamsSpec.$, impl.startDiscoverySession.bind(impl), false);
        this.helper_internal_.registerHandler(8, Adapter_ConnectToServiceInsecurely_ParamsSpec.$, Adapter_ConnectToServiceInsecurely_ResponseParamsSpec.$, impl.connectToServiceInsecurely.bind(impl), false);
        this.helper_internal_.registerHandler(9, Adapter_CreateRfcommServiceInsecurely_ParamsSpec.$, Adapter_CreateRfcommServiceInsecurely_ResponseParamsSpec.$, impl.createRfcommServiceInsecurely.bind(impl), false);
        this.helper_internal_.registerHandler(10, Adapter_CreateLocalGattService_ParamsSpec.$, Adapter_CreateLocalGattService_ResponseParamsSpec.$, impl.createLocalGattService.bind(impl), false);
        this.helper_internal_.registerHandler(11, Adapter_IsLeScatternetDualRoleSupported_ParamsSpec.$, Adapter_IsLeScatternetDualRoleSupported_ResponseParamsSpec.$, impl.isLeScatternetDualRoleSupported.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Adapter {
    static get $interfaceName() {
        return "bluetooth.mojom.Adapter";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new AdapterRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Adapter
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AdapterCallbackRouter {
    helper_internal_;
    $;
    router_;
    connectToDevice;
    getDevices;
    getInfo;
    addObserver;
    registerAdvertisement;
    setDiscoverable;
    setName;
    startDiscoverySession;
    connectToServiceInsecurely;
    createRfcommServiceInsecurely;
    createLocalGattService;
    isLeScatternetDualRoleSupported;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AdapterRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.connectToDevice =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Adapter_ConnectToDevice_ParamsSpec.$, Adapter_ConnectToDevice_ResponseParamsSpec.$, this.connectToDevice.createReceiverHandler(true /* expectsResponse */), false);
        this.getDevices =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, Adapter_GetDevices_ParamsSpec.$, Adapter_GetDevices_ResponseParamsSpec.$, this.getDevices.createReceiverHandler(true /* expectsResponse */), false);
        this.getInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, Adapter_GetInfo_ParamsSpec.$, Adapter_GetInfo_ResponseParamsSpec.$, this.getInfo.createReceiverHandler(true /* expectsResponse */), false);
        this.addObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, Adapter_AddObserver_ParamsSpec.$, Adapter_AddObserver_ResponseParamsSpec.$, this.addObserver.createReceiverHandler(true /* expectsResponse */), false);
        this.registerAdvertisement =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, Adapter_RegisterAdvertisement_ParamsSpec.$, Adapter_RegisterAdvertisement_ResponseParamsSpec.$, this.registerAdvertisement.createReceiverHandler(true /* expectsResponse */), false);
        this.setDiscoverable =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, Adapter_SetDiscoverable_ParamsSpec.$, Adapter_SetDiscoverable_ResponseParamsSpec.$, this.setDiscoverable.createReceiverHandler(true /* expectsResponse */), false);
        this.setName =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, Adapter_SetName_ParamsSpec.$, Adapter_SetName_ResponseParamsSpec.$, this.setName.createReceiverHandler(true /* expectsResponse */), false);
        this.startDiscoverySession =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, Adapter_StartDiscoverySession_ParamsSpec.$, Adapter_StartDiscoverySession_ResponseParamsSpec.$, this.startDiscoverySession.createReceiverHandler(true /* expectsResponse */), false);
        this.connectToServiceInsecurely =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, Adapter_ConnectToServiceInsecurely_ParamsSpec.$, Adapter_ConnectToServiceInsecurely_ResponseParamsSpec.$, this.connectToServiceInsecurely.createReceiverHandler(true /* expectsResponse */), false);
        this.createRfcommServiceInsecurely =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, Adapter_CreateRfcommServiceInsecurely_ParamsSpec.$, Adapter_CreateRfcommServiceInsecurely_ResponseParamsSpec.$, this.createRfcommServiceInsecurely.createReceiverHandler(true /* expectsResponse */), false);
        this.createLocalGattService =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, Adapter_CreateLocalGattService_ParamsSpec.$, Adapter_CreateLocalGattService_ResponseParamsSpec.$, this.createLocalGattService.createReceiverHandler(true /* expectsResponse */), false);
        this.isLeScatternetDualRoleSupported =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, Adapter_IsLeScatternetDualRoleSupported_ParamsSpec.$, Adapter_IsLeScatternetDualRoleSupported_ResponseParamsSpec.$, this.isLeScatternetDualRoleSupported.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class AdapterObserverPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'bluetooth.mojom.AdapterObserver', scope);
    }
}
export class AdapterObserverRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(AdapterObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    presentChanged(present) {
        this.proxy.sendMessage(0, AdapterObserver_PresentChanged_ParamsSpec.$, null, [
            present
        ], false);
    }
    poweredChanged(powered) {
        this.proxy.sendMessage(1, AdapterObserver_PoweredChanged_ParamsSpec.$, null, [
            powered
        ], false);
    }
    discoverableChanged(discoverable) {
        this.proxy.sendMessage(2, AdapterObserver_DiscoverableChanged_ParamsSpec.$, null, [
            discoverable
        ], false);
    }
    discoveringChanged(discovering) {
        this.proxy.sendMessage(3, AdapterObserver_DiscoveringChanged_ParamsSpec.$, null, [
            discovering
        ], false);
    }
    deviceAdded(device) {
        this.proxy.sendMessage(4, AdapterObserver_DeviceAdded_ParamsSpec.$, null, [
            device
        ], false);
    }
    deviceChanged(device) {
        this.proxy.sendMessage(5, AdapterObserver_DeviceChanged_ParamsSpec.$, null, [
            device
        ], false);
    }
    deviceRemoved(device) {
        this.proxy.sendMessage(6, AdapterObserver_DeviceRemoved_ParamsSpec.$, null, [
            device
        ], false);
    }
}
;
/**
 * An object which receives request messages for the AdapterObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AdapterObserverReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AdapterObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, AdapterObserver_PresentChanged_ParamsSpec.$, null, impl.presentChanged.bind(impl), false);
        this.helper_internal_.registerHandler(1, AdapterObserver_PoweredChanged_ParamsSpec.$, null, impl.poweredChanged.bind(impl), false);
        this.helper_internal_.registerHandler(2, AdapterObserver_DiscoverableChanged_ParamsSpec.$, null, impl.discoverableChanged.bind(impl), false);
        this.helper_internal_.registerHandler(3, AdapterObserver_DiscoveringChanged_ParamsSpec.$, null, impl.discoveringChanged.bind(impl), false);
        this.helper_internal_.registerHandler(4, AdapterObserver_DeviceAdded_ParamsSpec.$, null, impl.deviceAdded.bind(impl), false);
        this.helper_internal_.registerHandler(5, AdapterObserver_DeviceChanged_ParamsSpec.$, null, impl.deviceChanged.bind(impl), false);
        this.helper_internal_.registerHandler(6, AdapterObserver_DeviceRemoved_ParamsSpec.$, null, impl.deviceRemoved.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class AdapterObserver {
    static get $interfaceName() {
        return "bluetooth.mojom.AdapterObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new AdapterObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the AdapterObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AdapterObserverCallbackRouter {
    helper_internal_;
    $;
    router_;
    presentChanged;
    poweredChanged;
    discoverableChanged;
    discoveringChanged;
    deviceAdded;
    deviceChanged;
    deviceRemoved;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AdapterObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.presentChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, AdapterObserver_PresentChanged_ParamsSpec.$, null, this.presentChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.poweredChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, AdapterObserver_PoweredChanged_ParamsSpec.$, null, this.poweredChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.discoverableChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, AdapterObserver_DiscoverableChanged_ParamsSpec.$, null, this.discoverableChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.discoveringChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, AdapterObserver_DiscoveringChanged_ParamsSpec.$, null, this.discoveringChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.deviceAdded =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, AdapterObserver_DeviceAdded_ParamsSpec.$, null, this.deviceAdded.createReceiverHandler(false /* expectsResponse */), false);
        this.deviceChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, AdapterObserver_DeviceChanged_ParamsSpec.$, null, this.deviceChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.deviceRemoved =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, AdapterObserver_DeviceRemoved_ParamsSpec.$, null, this.deviceRemoved.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const ConnectToServiceResultSpec = { $: {} };
export const AcceptConnectionResultSpec = { $: {} };
export const AdapterInfoSpec = { $: {} };
export const Advertisement_Unregister_ParamsSpec = { $: {} };
export const Advertisement_Unregister_ResponseParamsSpec = { $: {} };
export const DiscoverySession_IsActive_ParamsSpec = { $: {} };
export const DiscoverySession_IsActive_ResponseParamsSpec = { $: {} };
export const DiscoverySession_Stop_ParamsSpec = { $: {} };
export const DiscoverySession_Stop_ResponseParamsSpec = { $: {} };
export const Socket_Disconnect_ParamsSpec = { $: {} };
export const Socket_Disconnect_ResponseParamsSpec = { $: {} };
export const ServerSocket_Accept_ParamsSpec = { $: {} };
export const ServerSocket_Accept_ResponseParamsSpec = { $: {} };
export const ServerSocket_Disconnect_ParamsSpec = { $: {} };
export const ServerSocket_Disconnect_ResponseParamsSpec = { $: {} };
export const GattService_CreateCharacteristic_ParamsSpec = { $: {} };
export const GattService_CreateCharacteristic_ResponseParamsSpec = { $: {} };
export const GattService_Register_ParamsSpec = { $: {} };
export const GattService_Register_ResponseParamsSpec = { $: {} };
export const GattServiceObserver_OnLocalCharacteristicRead_ParamsSpec = { $: {} };
export const GattServiceObserver_OnLocalCharacteristicRead_ResponseParamsSpec = { $: {} };
export const Adapter_ConnectToDevice_ParamsSpec = { $: {} };
export const Adapter_ConnectToDevice_ResponseParamsSpec = { $: {} };
export const Adapter_GetDevices_ParamsSpec = { $: {} };
export const Adapter_GetDevices_ResponseParamsSpec = { $: {} };
export const Adapter_GetInfo_ParamsSpec = { $: {} };
export const Adapter_GetInfo_ResponseParamsSpec = { $: {} };
export const Adapter_AddObserver_ParamsSpec = { $: {} };
export const Adapter_AddObserver_ResponseParamsSpec = { $: {} };
export const Adapter_RegisterAdvertisement_ParamsSpec = { $: {} };
export const Adapter_RegisterAdvertisement_ResponseParamsSpec = { $: {} };
export const Adapter_SetDiscoverable_ParamsSpec = { $: {} };
export const Adapter_SetDiscoverable_ResponseParamsSpec = { $: {} };
export const Adapter_SetName_ParamsSpec = { $: {} };
export const Adapter_SetName_ResponseParamsSpec = { $: {} };
export const Adapter_StartDiscoverySession_ParamsSpec = { $: {} };
export const Adapter_StartDiscoverySession_ResponseParamsSpec = { $: {} };
export const Adapter_ConnectToServiceInsecurely_ParamsSpec = { $: {} };
export const Adapter_ConnectToServiceInsecurely_ResponseParamsSpec = { $: {} };
export const Adapter_CreateRfcommServiceInsecurely_ParamsSpec = { $: {} };
export const Adapter_CreateRfcommServiceInsecurely_ResponseParamsSpec = { $: {} };
export const Adapter_CreateLocalGattService_ParamsSpec = { $: {} };
export const Adapter_CreateLocalGattService_ResponseParamsSpec = { $: {} };
export const Adapter_IsLeScatternetDualRoleSupported_ParamsSpec = { $: {} };
export const Adapter_IsLeScatternetDualRoleSupported_ResponseParamsSpec = { $: {} };
export const AdapterObserver_PresentChanged_ParamsSpec = { $: {} };
export const AdapterObserver_PoweredChanged_ParamsSpec = { $: {} };
export const AdapterObserver_DiscoverableChanged_ParamsSpec = { $: {} };
export const AdapterObserver_DiscoveringChanged_ParamsSpec = { $: {} };
export const AdapterObserver_DeviceAdded_ParamsSpec = { $: {} };
export const AdapterObserver_DeviceChanged_ParamsSpec = { $: {} };
export const AdapterObserver_DeviceRemoved_ParamsSpec = { $: {} };
export const LocalCharacteristicReadResultSpec = { $: {} };
mojo.internal.Struct(ConnectToServiceResultSpec.$, 'ConnectToServiceResult', [
    mojo.internal.StructField('socket', 0, 0, mojo.internal.InterfaceProxy(SocketRemote), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('receiveStream', 8, 0, mojo.internal.Handle, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sendStream', 12, 0, mojo.internal.Handle, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(AcceptConnectionResultSpec.$, 'AcceptConnectionResult', [
    mojo.internal.StructField('device', 0, 0, bluetooth_mojom_DeviceInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('socket', 8, 0, mojo.internal.InterfaceProxy(SocketRemote), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('receiveStream', 16, 0, mojo.internal.Handle, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sendStream', 20, 0, mojo.internal.Handle, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(AdapterInfoSpec.$, 'AdapterInfo', [
    mojo.internal.StructField('address', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('name', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('systemName', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('floss', 24, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('extendedAdvertisementSupport', 24, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('initialized', 24, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('present', 24, 3, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('powered', 24, 4, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('discoverable', 24, 5, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('discovering', 24, 6, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(Advertisement_Unregister_ParamsSpec.$, 'Advertisement_Unregister_Params', [], [[0, 8],]);
mojo.internal.Struct(Advertisement_Unregister_ResponseParamsSpec.$, 'Advertisement_Unregister_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(DiscoverySession_IsActive_ParamsSpec.$, 'DiscoverySession_IsActive_Params', [], [[0, 8],]);
mojo.internal.Struct(DiscoverySession_IsActive_ResponseParamsSpec.$, 'DiscoverySession_IsActive_ResponseParams', [
    mojo.internal.StructField('active', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DiscoverySession_Stop_ParamsSpec.$, 'DiscoverySession_Stop_Params', [], [[0, 8],]);
mojo.internal.Struct(DiscoverySession_Stop_ResponseParamsSpec.$, 'DiscoverySession_Stop_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Socket_Disconnect_ParamsSpec.$, 'Socket_Disconnect_Params', [], [[0, 8],]);
mojo.internal.Struct(Socket_Disconnect_ResponseParamsSpec.$, 'Socket_Disconnect_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(ServerSocket_Accept_ParamsSpec.$, 'ServerSocket_Accept_Params', [], [[0, 8],]);
mojo.internal.Struct(ServerSocket_Accept_ResponseParamsSpec.$, 'ServerSocket_Accept_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, AcceptConnectionResultSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ServerSocket_Disconnect_ParamsSpec.$, 'ServerSocket_Disconnect_Params', [], [[0, 8],]);
mojo.internal.Struct(ServerSocket_Disconnect_ResponseParamsSpec.$, 'ServerSocket_Disconnect_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(GattService_CreateCharacteristic_ParamsSpec.$, 'GattService_CreateCharacteristic_Params', [
    mojo.internal.StructField('characteristicUuid', 0, 0, bluetooth_mojom_UUIDSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('permissions', 8, 0, bluetooth_mojom_GattCharacteristicPermissionsSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('properties', 16, 0, bluetooth_mojom_GattCharacteristicPropertiesSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(GattService_CreateCharacteristic_ResponseParamsSpec.$, 'GattService_CreateCharacteristic_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(GattService_Register_ParamsSpec.$, 'GattService_Register_Params', [], [[0, 8],]);
mojo.internal.Struct(GattService_Register_ResponseParamsSpec.$, 'GattService_Register_ResponseParams', [
    mojo.internal.StructField('error_code_$flag', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "error_code_$value",
        originalFieldName: "errorCode",
    }, undefined),
    mojo.internal.StructField('error_code_$value', 4, 0, bluetooth_mojom_GattServiceErrorCodeSpec.$, 0, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "errorCode",
    }, undefined),
], [[0, 16],]);
mojo.internal.Struct(GattServiceObserver_OnLocalCharacteristicRead_ParamsSpec.$, 'GattServiceObserver_OnLocalCharacteristicRead_Params', [
    mojo.internal.StructField('remoteDevice', 0, 0, bluetooth_mojom_DeviceInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('characteristicUuid', 8, 0, bluetooth_mojom_UUIDSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('serviceUuid', 16, 0, bluetooth_mojom_UUIDSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('offset', 24, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(GattServiceObserver_OnLocalCharacteristicRead_ResponseParamsSpec.$, 'GattServiceObserver_OnLocalCharacteristicRead_ResponseParams', [
    mojo.internal.StructField('readResult', 0, 0, LocalCharacteristicReadResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Adapter_ConnectToDevice_ParamsSpec.$, 'Adapter_ConnectToDevice_Params', [
    mojo.internal.StructField('address', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Adapter_ConnectToDevice_ResponseParamsSpec.$, 'Adapter_ConnectToDevice_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, ConnectResultSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('device', 4, 0, mojo.internal.InterfaceProxy(bluetooth_mojom_DeviceRemote), null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Adapter_GetDevices_ParamsSpec.$, 'Adapter_GetDevices_Params', [], [[0, 8],]);
mojo.internal.Struct(Adapter_GetDevices_ResponseParamsSpec.$, 'Adapter_GetDevices_ResponseParams', [
    mojo.internal.StructField('devices', 0, 0, mojo.internal.Array(bluetooth_mojom_DeviceInfoSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Adapter_GetInfo_ParamsSpec.$, 'Adapter_GetInfo_Params', [], [[0, 8],]);
mojo.internal.Struct(Adapter_GetInfo_ResponseParamsSpec.$, 'Adapter_GetInfo_ResponseParams', [
    mojo.internal.StructField('info', 0, 0, AdapterInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Adapter_AddObserver_ParamsSpec.$, 'Adapter_AddObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(AdapterObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Adapter_AddObserver_ResponseParamsSpec.$, 'Adapter_AddObserver_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(Adapter_RegisterAdvertisement_ParamsSpec.$, 'Adapter_RegisterAdvertisement_Params', [
    mojo.internal.StructField('serviceId', 0, 0, bluetooth_mojom_UUIDSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('serviceData', 8, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('useScanResponse', 16, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('connectable', 16, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(Adapter_RegisterAdvertisement_ResponseParamsSpec.$, 'Adapter_RegisterAdvertisement_ResponseParams', [
    mojo.internal.StructField('advertisement', 0, 0, mojo.internal.InterfaceProxy(AdvertisementRemote), null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Adapter_SetDiscoverable_ParamsSpec.$, 'Adapter_SetDiscoverable_Params', [
    mojo.internal.StructField('discoverable', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Adapter_SetDiscoverable_ResponseParamsSpec.$, 'Adapter_SetDiscoverable_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Adapter_SetName_ParamsSpec.$, 'Adapter_SetName_Params', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Adapter_SetName_ResponseParamsSpec.$, 'Adapter_SetName_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Adapter_StartDiscoverySession_ParamsSpec.$, 'Adapter_StartDiscoverySession_Params', [
    mojo.internal.StructField('clientName', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Adapter_StartDiscoverySession_ResponseParamsSpec.$, 'Adapter_StartDiscoverySession_ResponseParams', [
    mojo.internal.StructField('session', 0, 0, mojo.internal.InterfaceProxy(DiscoverySessionRemote), null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Adapter_ConnectToServiceInsecurely_ParamsSpec.$, 'Adapter_ConnectToServiceInsecurely_Params', [
    mojo.internal.StructField('address', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('serviceUuid', 8, 0, bluetooth_mojom_UUIDSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('shouldUnbondOnError', 16, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(Adapter_ConnectToServiceInsecurely_ResponseParamsSpec.$, 'Adapter_ConnectToServiceInsecurely_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, ConnectToServiceResultSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Adapter_CreateRfcommServiceInsecurely_ParamsSpec.$, 'Adapter_CreateRfcommServiceInsecurely_Params', [
    mojo.internal.StructField('serviceName', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('serviceUuid', 8, 0, bluetooth_mojom_UUIDSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Adapter_CreateRfcommServiceInsecurely_ResponseParamsSpec.$, 'Adapter_CreateRfcommServiceInsecurely_ResponseParams', [
    mojo.internal.StructField('serverSocket', 0, 0, mojo.internal.InterfaceProxy(ServerSocketRemote), null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Adapter_CreateLocalGattService_ParamsSpec.$, 'Adapter_CreateLocalGattService_Params', [
    mojo.internal.StructField('serviceId', 0, 0, bluetooth_mojom_UUIDSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('observer', 8, 0, mojo.internal.InterfaceProxy(GattServiceObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Adapter_CreateLocalGattService_ResponseParamsSpec.$, 'Adapter_CreateLocalGattService_ResponseParams', [
    mojo.internal.StructField('gattService', 0, 0, mojo.internal.InterfaceProxy(GattServiceRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Adapter_IsLeScatternetDualRoleSupported_ParamsSpec.$, 'Adapter_IsLeScatternetDualRoleSupported_Params', [], [[0, 8],]);
mojo.internal.Struct(Adapter_IsLeScatternetDualRoleSupported_ResponseParamsSpec.$, 'Adapter_IsLeScatternetDualRoleSupported_ResponseParams', [
    mojo.internal.StructField('isSupported', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AdapterObserver_PresentChanged_ParamsSpec.$, 'AdapterObserver_PresentChanged_Params', [
    mojo.internal.StructField('present', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AdapterObserver_PoweredChanged_ParamsSpec.$, 'AdapterObserver_PoweredChanged_Params', [
    mojo.internal.StructField('powered', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AdapterObserver_DiscoverableChanged_ParamsSpec.$, 'AdapterObserver_DiscoverableChanged_Params', [
    mojo.internal.StructField('discoverable', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AdapterObserver_DiscoveringChanged_ParamsSpec.$, 'AdapterObserver_DiscoveringChanged_Params', [
    mojo.internal.StructField('discovering', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AdapterObserver_DeviceAdded_ParamsSpec.$, 'AdapterObserver_DeviceAdded_Params', [
    mojo.internal.StructField('device', 0, 0, bluetooth_mojom_DeviceInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AdapterObserver_DeviceChanged_ParamsSpec.$, 'AdapterObserver_DeviceChanged_Params', [
    mojo.internal.StructField('device', 0, 0, bluetooth_mojom_DeviceInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AdapterObserver_DeviceRemoved_ParamsSpec.$, 'AdapterObserver_DeviceRemoved_Params', [
    mojo.internal.StructField('device', 0, 0, bluetooth_mojom_DeviceInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Union(LocalCharacteristicReadResultSpec.$, 'LocalCharacteristicReadResult', {
    'errorCode': {
        'ordinal': 0,
        'type': bluetooth_mojom_GattServiceErrorCodeSpec.$,
    },
    'data': {
        'ordinal': 1,
        'type': mojo.internal.Array(mojo.internal.Uint8, false),
    },
});
export var LocalCharacteristicReadResultFieldTags;
(function (LocalCharacteristicReadResultFieldTags) {
    LocalCharacteristicReadResultFieldTags[LocalCharacteristicReadResultFieldTags["ERROR_CODE"] = 0] = "ERROR_CODE";
    LocalCharacteristicReadResultFieldTags[LocalCharacteristicReadResultFieldTags["DATA"] = 1] = "DATA";
})(LocalCharacteristicReadResultFieldTags || (LocalCharacteristicReadResultFieldTags = {}));
export function whichLocalCharacteristicReadResult(u) {
    if (u.errorCode !== null && u.errorCode !== undefined) {
        return LocalCharacteristicReadResultFieldTags.ERROR_CODE;
    }
    if (u.data !== null && u.data !== undefined) {
        return LocalCharacteristicReadResultFieldTags.DATA;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
