// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{EventTracker}from"//resources/js/event_tracker.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{GlicRequestHeaderInjector}from"/shared/glic_request_headers.js";import{DetailedWebClientState,GlicApiHost,WebClientState}from"./glic_api_impl/glic_api_host.js";import{ObservableValue}from"./observable.js";import{OneShotTimer}from"./timer.js";var WebviewExitReason;(function(WebviewExitReason){WebviewExitReason[WebviewExitReason["NORMAL"]=0]="NORMAL";WebviewExitReason[WebviewExitReason["ABNORMAL"]=1]="ABNORMAL";WebviewExitReason[WebviewExitReason["CRASHED"]=2]="CRASHED";WebviewExitReason[WebviewExitReason["KILLED"]=3]="KILLED";WebviewExitReason[WebviewExitReason["OOM_KILLED"]=4]="OOM_KILLED";WebviewExitReason[WebviewExitReason["OOM"]=5]="OOM";WebviewExitReason[WebviewExitReason["FAILED_TO_LAUNCH"]=6]="FAILED_TO_LAUNCH";WebviewExitReason[WebviewExitReason["INTEGRITY_FAILURE"]=7]="INTEGRITY_FAILURE";WebviewExitReason[WebviewExitReason["UNKNOWN"]=8]="UNKNOWN"})(WebviewExitReason||(WebviewExitReason={}));const WEBVIEW_EXIT_REASON_MAP={normal:WebviewExitReason.NORMAL,abnormal:WebviewExitReason.ABNORMAL,crashed:WebviewExitReason.CRASHED,killed:WebviewExitReason.KILLED,"oom killed":WebviewExitReason.OOM_KILLED,oom:WebviewExitReason.OOM,"failed to launch":WebviewExitReason.FAILED_TO_LAUNCH,"integrity failure":WebviewExitReason.INTEGRITY_FAILURE};function webviewExitReasonStringToEnum(reason){return WEBVIEW_EXIT_REASON_MAP[reason]??WebviewExitReason.UNKNOWN}var ResourceType;(function(ResourceType){ResourceType["MAIN_FRAME"]="main_frame"})(ResourceType||(ResourceType={}));export class WebviewPersistentState{loadUrl;loadUrlUsed=false;useLoadUrl(){if(this.loadUrl&&!this.loadUrlUsed){this.loadUrlUsed=true;return this.loadUrl}else{return loadTimeData.getString("glicGuestURL")}}onCommitAfterConnect(newUrl){this.loadUrl=newUrl;this.loadUrlUsed=false}onClientReady(){this.loadUrlUsed=false}}export class WebviewController{container;browserProxy;delegate;hostEmbedder;persistentState;webview;host;hostSubscriber;onDestroy=[];eventTracker=new EventTracker;webClientState=ObservableValue.withValue(WebClientState.UNINITIALIZED);oneMinuteTimer=new OneShotTimer(1e3*60);glicRequestHeaderInjector;constructor(container,browserProxy,delegate,hostEmbedder,persistentState){this.container=container;this.browserProxy=browserProxy;this.delegate=delegate;this.hostEmbedder=hostEmbedder;this.persistentState=persistentState;this.webview=document.createElement("webview");this.glicRequestHeaderInjector=new GlicRequestHeaderInjector(this.webview,loadTimeData.getString("chromeVersion"),loadTimeData.getString("chromeChannel"),loadTimeData.getString("glicHeaderRequestTypes"));const onBeforeRequest=this.onBeforeRequest.bind(this);this.webview.request.onBeforeRequest.addListener(onBeforeRequest,{types:[ResourceType.MAIN_FRAME],urls:["<all_urls>"]},["blocking"]);this.onDestroy.push((()=>{this.webview.request.onBeforeRequest.removeListener(onBeforeRequest)}));this.webview.id="guestFrame";this.webview.setAttribute("partition","persist:glicpart");this.container.appendChild(this.webview);this.eventTracker.add(this.webview,"loadcommit",this.onLoadCommit.bind(this));this.eventTracker.add(this.webview,"contentload",this.contentLoaded.bind(this));this.eventTracker.add(this.webview,"loadstop",this.onLoadStop.bind(this));this.eventTracker.add(this.webview,"newwindow",this.onNewWindow.bind(this));this.eventTracker.add(this.webview,"permissionrequest",this.onPermissionRequest.bind(this));this.eventTracker.add(this.webview,"unresponsive",this.onUnresponsive.bind(this));this.eventTracker.add(this.webview,"exit",this.onExit.bind(this));this.webview.src=this.persistentState.useLoadUrl();this.oneMinuteTimer.start((()=>{if(this.host){chrome.metricsPrivate.recordEnumerationValue("Glic.Host.WebClientState.AtOneMinute",this.host.getDetailedWebClientState(),DetailedWebClientState.MAX_VALUE+1)}}))}getWebClientState(){return this.webClientState}destroy(){this.glicRequestHeaderInjector.destroy();this.oneMinuteTimer.reset();if(this.host){chrome.metricsPrivate.recordEnumerationValue("Glic.Host.WebClientState.OnDestroy",this.host.getDetailedWebClientState(),DetailedWebClientState.MAX_VALUE+1)}this.destroyHost(this.webClientState.getCurrentValue()===WebClientState.ERROR?WebClientState.ERROR:WebClientState.UNINITIALIZED);this.eventTracker.removeAll();this.onDestroy.forEach((f=>f()));this.onDestroy=[];this.webview.remove()}destroyHost(webClientState){if(this.hostSubscriber){this.hostSubscriber.unsubscribe();this.hostSubscriber=undefined}if(this.host){this.host.destroy();this.host=undefined}this.webClientState.assignAndSignal(webClientState)}waitingOnPanelWillOpen(){return this.host?.waitingOnPanelWillOpen()??false}onLoadTimeOut(){if(this.host){chrome.metricsPrivate.recordEnumerationValue("Glic.Host.WebClientState.OnLoadTimeOut",this.host.getDetailedWebClientState(),DetailedWebClientState.MAX_VALUE+1)}}onLoadCommit(e){this.loadCommit(e.url,e.isTopLevel)}onLoadStop(){this.webview.focus()}onNewWindow(e){this.onNewWindowEvent(e)}async onPermissionRequest(e){e.preventDefault();if(!this.host){e.request.deny();return}switch(e.permission){case"media":{e.request.allow();return}case"geolocation":{const isGeolocationAllowed=await this.host.shouldAllowGeolocationPermissionRequest();if(isGeolocationAllowed){e.request.allow()}else{e.request.deny()}return}}console.warn(`Webview permission request was denied: ${e.permission}`);e.request.deny()}onUnresponsive(){this.delegate.webviewUnresponsive()}onExit=event=>{chrome.metricsPrivate.recordEnumerationValue("Glic.Session.WebClientCrash.ExitReason",webviewExitReasonStringToEnum(event.reason),Object.keys(WEBVIEW_EXIT_REASON_MAP).length);if(event.reason!=="normal"){this.destroyHost(WebClientState.ERROR);chrome.metricsPrivate.recordUserAction("GlicSessionWebClientCrash");console.warn(`webview exit. processID: ${event.processID}, reason: ${event.reason}`)}};loadCommit(url,isTopLevel){if(!isTopLevel){return}if(this.host){chrome.metricsPrivate.recordEnumerationValue("Glic.Host.WebClientState.OnCommit",this.host.getDetailedWebClientState(),DetailedWebClientState.MAX_VALUE+1)}const wasResponsive=this.getWebClientState().getCurrentValue()===WebClientState.RESPONSIVE;this.destroyHost(WebClientState.UNINITIALIZED);const origin=new URL(url).origin;if(this.webview.contentWindow&&origin!=="null"){this.host=new GlicApiHost(this.browserProxy,this.webview.contentWindow,origin,this.hostEmbedder);this.hostSubscriber=this.host.getWebClientState().subscribe((state=>{if(state===WebClientState.RESPONSIVE){this.persistentState.onClientReady()}this.webClientState.assignAndSignal(state)}))}this.browserProxy.handler.webviewCommitted({url:url});if(!this.host){this.delegate.webviewPageCommit("loadError");return}if(url.startsWith("https://login.corp.google.com/")||url.startsWith("https://accounts.google.com/")||url.startsWith("https://accounts.googlers.com/")||url.startsWith("https://gaiastaging.corp.google.com/")){this.delegate.webviewPageCommit("login")}else if(new URL(url).pathname.startsWith("/sorry/")){this.delegate.webviewPageCommit("guestError")}else{if(wasResponsive){this.persistentState.onCommitAfterConnect(url)}if(loadTimeData.getBoolean("reloadAfterNavigation")){this.delegate.webviewPageCommit("regular")}}}contentLoaded(){if(this.host){this.host.contentLoaded()}}onNewWindowEvent(event){if(!this.host){return}event.preventDefault();this.host.openLinkInNewTab(event.targetUrl);event.stopPropagation()}urlMatchesAdminBlockedUrl(url){const adminBlockedRedirectPatterns=loadTimeData.getString("adminBlockedRedirectPatterns");if(!adminBlockedRedirectPatterns){return false}if(adminBlockedRedirectPatterns.split(" ").some((pattern=>new URLPattern(pattern.trim()).test(url)))){console.warn(`Admin blocked error page detected.`);return true}return false}onBeforeRequest=details=>{if(details.frameId!==0){return{}}if(this.urlMatchesAdminBlockedUrl(details.url)){this.delegate.webviewDeniedByAdmin();return{cancel:true}}return{cancel:!urlMatchesAllowedOrigin(details.url)}}}export function matcherForOrigin(originPattern){const match=originPattern.match(/([^:]+):\/\/([^:]*)(?::(\d+))?[/]?/);if(!match){return null}const[protocol,hostname,port]=[match[1],match[2],match[3]??"*"];try{return new URLPattern({protocol:protocol,hostname:hostname,port:port})}catch(_){return null}}export function urlMatchesAllowedOrigin(url){if(loadTimeData.getBoolean("devMode")){return true}const defaultUrl=new URL(loadTimeData.getString("glicGuestURL"));if(matcherForOrigin(defaultUrl.origin)?.test(url)){return true}return loadTimeData.getString("glicAllowedOrigins").split(" ").some((origin=>matcherForOrigin(origin.trim())?.test(url)))}