// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Attaches the X-Glic headers to all main-frame requests.
// X-Glic: 1
// X-Glic-Chrome-Channel: stable
// X-Glic-Chrome-Version: 137.0.1234.0
export class GlicRequestHeaderInjector {
    chromeVersion;
    chromeChannel;
    onDestroy = () => { };
    constructor(webview, chromeVersion, chromeChannel, requestTypes) {
        this.chromeVersion = chromeVersion;
        this.chromeChannel = chromeChannel;
        if (requestTypes === '') {
            return;
        }
        const onBeforeSendHeaders = this.onBeforeSendHeaders.bind(this);
        webview.request.onBeforeSendHeaders.addListener(onBeforeSendHeaders, {
            // These should be valid values from web_request.d.ts.
            types: requestTypes.split(','),
            urls: ['<all_urls>'],
        }, ['blocking', 'requestHeaders', 'extraHeaders']);
        this.onDestroy = () => {
            webview.request.onBeforeSendHeaders.removeListener(onBeforeSendHeaders);
        };
    }
    destroy() {
        this.onDestroy();
    }
    onBeforeSendHeaders = (details) => {
        // Ignore subframe requests.
        if (details.frameId !== 0) {
            return {};
        }
        const requestHeaders = details.requestHeaders || [];
        requestHeaders.push({
            name: 'X-Glic',
            value: '1',
        });
        requestHeaders.push({
            name: 'X-Glic-Chrome-Version',
            value: this.chromeVersion,
        });
        requestHeaders.push({
            name: 'X-Glic-Chrome-Channel',
            value: this.chromeChannel,
        });
        return { requestHeaders };
    };
}
