// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"chrome://resources/js/assert.js";import{CrLitElement}from"chrome://resources/lit/v3_0/lit.rollup.js";import{getCss}from"./app.css.js";import{getHtml}from"./app.html.js";import{BrowserProxy}from"./browser_proxy.js";export class InfobarInternalsAppElement extends CrLitElement{static get is(){return"infobar-internals-app"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{infobars:{type:Array}}}#infobars_accessor_storage=[];get infobars(){return this.#infobars_accessor_storage}set infobars(value){this.#infobars_accessor_storage=value}connectedCallback(){super.connectedCallback();BrowserProxy.getInstance().handler.getInfoBars().then((({infobars:infobars})=>this.infobars=infobars))}onTrigger(e){const target=e.currentTarget;const typeStr=target.dataset["type"];assert(typeStr);const typeNum=Number(typeStr);assert(!Number.isNaN(typeNum));const type=typeNum;this.trigger(type)}async trigger(id){const{success:success}=await BrowserProxy.getInstance().handler.triggerInfoBar(id);if(!success){console.warn("Failed to trigger infobar",id)}}}customElements.define(InfobarInternalsAppElement.is,InfobarInternalsAppElement);