// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '/strings.m.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import { WebUiListenerMixinLit } from 'chrome://resources/cr_elements/web_ui_listener_mixin_lit.js';
import { loadTimeData } from 'chrome://resources/js/load_time_data.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { getCss } from './app.css.js';
import { getHtml } from './app.html.js';
import { DefaultBrowserBrowserProxyImpl } from './browser_proxy.js';
const AppElementBase = WebUiListenerMixinLit(CrLitElement);
export class AppElement extends AppElementBase {
    static get is() {
        return 'default-browser-app';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            anyButtonClicked_: { type: Boolean },
        };
    }
    #anyButtonClicked__accessor_storage = false;
    get anyButtonClicked_() { return this.#anyButtonClicked__accessor_storage; }
    set anyButtonClicked_(value) { this.#anyButtonClicked__accessor_storage = value; }
    browserProxy_ = DefaultBrowserBrowserProxyImpl.getInstance();
    connectedCallback() {
        super.connectedCallback();
        this.addWebUiListener('reset-default-browser-buttons', this.resetButtons_.bind(this));
    }
    onConfirmDefaultBrowserClick_() {
        this.anyButtonClicked_ = true;
        this.browserProxy_.setAsDefaultBrowser();
    }
    onSkipDefaultBrowserClick_() {
        this.anyButtonClicked_ = true;
        this.browserProxy_.skipDefaultBrowser();
    }
    resetButtons_() {
        this.anyButtonClicked_ = false;
    }
    getTitle() {
        return loadTimeData.getString('defaultBrowserTitle');
    }
    getSubtitle() {
        return loadTimeData.getString('defaultBrowserSubtitle');
    }
    /**
     * Disable buttons if a button was clicked.
     */
    areButtonsDisabled_() {
        return this.anyButtonClicked_;
    }
}
customElements.define(AppElement.is, AppElement);
