// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./cursor_tooltip.js";import"./initial_gradient.js";import"./selection_overlay.js";import"./translate_button.js";import"/lens/shared/searchbox_ghost_loader.js";import"/lens/shared/searchbox_shared_style.css.js";import"//resources/cr_elements/cr_icon_button/cr_icon_button.js";import"//resources/cr_elements/icons.html.js";import"//resources/cr_components/searchbox/searchbox.js";import{HelpBubbleMixin}from"//resources/cr_components/help_bubble/help_bubble_mixin.js";import{I18nMixin}from"//resources/cr_elements/i18n_mixin.js";import{assert}from"//resources/js/assert.js";import{skColorToHexColor}from"//resources/js/color_utils.js";import{EventTracker}from"//resources/js/event_tracker.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{BrowserProxyImpl}from"./browser_proxy.js";import{getFallbackTheme}from"./color_utils.js";import{CursorTooltipType}from"./cursor_tooltip.js";import{UserAction}from"./lens.mojom-webui.js";import{getTemplate}from"./lens_overlay_app.html.js";import{recordLensOverlayInteraction,recordTimeToWebUIReady}from"./metrics_utils.js";import{PageContentType}from"./page_content_type.mojom-webui.js";import{PerformanceTracker}from"./performance_tracker.js";import{handleEscapeSearchbox}from"./searchbox_utils.js";import{focusShimmerOnRegion,ShimmerControlRequester,unfocusShimmer}from"./selection_utils.js";export let INVOCATION_SOURCE="Unknown";const LensOverlayAppElementBase=HelpBubbleMixin(I18nMixin(PolymerElement));export class LensOverlayAppElement extends LensOverlayAppElementBase{static get is(){return"lens-overlay-app"}static get template(){return getTemplate()}static get properties(){return{autocompleteRequestStarted:{type:Boolean,value:false},enableBorderGlow:{type:Boolean,value:()=>loadTimeData.getBoolean("enableBorderGlow")},enableCsbMotionTweaks:{reflectToAttribute:true,type:Boolean,value:()=>loadTimeData.getBoolean("enableCsbMotionTweaks")},forceHideSearchBox:{type:Boolean,value:false},isImageRendered:{type:Boolean,reflectToAttribute:true,value:false},initialFlashAnimationHasEnded:{type:Boolean,reflectToAttribute:true,value:false},sidePanelOpened:{type:Boolean,reflectToAttribute:true,value:false},searchBoxHidden:{type:Boolean,computed:"computeShouldHideSearchBox(isTranslateModeActive, sidePanelOpened, forceHideSearchBox)",reflectToAttribute:true},isClosing:{type:Boolean,reflectToAttribute:true,value:false},moreOptionsMenuVisible:{type:Boolean,reflectToAttribute:true,value:false},isPointerDown:{type:Boolean,value:false},isTranslateButtonEnabled:{type:Boolean,value:()=>loadTimeData.getBoolean("enableOverlayTranslateButton"),readOnly:true,reflectToAttribute:true},isTranslateModeActive:{type:Boolean,value:false},shouldFadeOutButtons:{type:Boolean,computed:"computeShouldFadeOutButtons(isTranslateModeActive, "+"isPointerDown)",reflectToAttribute:true},isLensOverlayContextualSearchboxEnabled:{type:Boolean,reflectToAttribute:true,readOnly:true,value:()=>loadTimeData.getBoolean("enableOverlayContextualSearchbox")},isLensOverlayContextualSearchboxVisible:{type:Boolean,reflectToAttribute:true,value:false},theme:{type:Object,value:getFallbackTheme},darkMode:{type:Boolean,value:()=>loadTimeData.getBoolean("darkMode"),reflectToAttribute:true},isSearchboxFocused:{type:Boolean,reflectToAttribute:true,value:false},suppressGhostLoader:{type:Boolean,value:false},enableGhostLoader:{type:Boolean,value:()=>loadTimeData.getBoolean("enableGhostLoader")},showGhostLoader:{type:Boolean,computed:`computeShowGhostLoader(\n                enableGhostLoader,\n                isSearchboxFocused,\n                autocompleteRequestStarted,\n                showErrorState,\n                suppressGhostLoader)`,reflectToAttribute:true},pageContentType:{type:Number,value:PageContentType.kUnknown},placeholderText:{type:String,computed:`computePlaceholderText(pageContentType)`},showErrorState:{type:Boolean,value:false,notify:true},areLanguagePickersOpen:{type:Boolean,value:false},toastMessage:{type:String,value:""},enableCloseButtonTweaks:{type:Boolean,value:()=>loadTimeData.getBoolean("enableCloseButtonTweaks"),reflectToAttribute:true},enableVisualSelectionUpdates:{type:Boolean,value:()=>loadTimeData.getBoolean("enableVisualSelectionUpdates"),reflectToAttribute:true},searchboxSuggestionCount:{type:Number,value:0},canAnimateInCloseButton:{type:Boolean,value:false,reflectToAttribute:true},overlayReshowInProgress:{type:Boolean,value:false,reflectToAttribute:true}}}autoFocusSearchbox=loadTimeData.getValue("autoFocusSearchbox");performanceTracker=new PerformanceTracker;isBackendHandshakeComplete=false;triggerSuggestOnInputReady=false;eventTracker_=new EventTracker;browserProxy=BrowserProxyImpl.getInstance();listenerIds;invocationTime=loadTimeData.getValue("invocationTime");searchboxBoundingClientRectObserver=new ResizeObserver(this.onSearchboxBoundsChanged.bind(this));updateCursorPositionRequestId;constructor(){super();this.browserProxy.handler.getOverlayInvocationSource().then((({invocationSource:invocationSource})=>{INVOCATION_SOURCE=invocationSource}))}connectedCallback(){super.connectedCallback();const callbackRouter=this.browserProxy.callbackRouter;this.listenerIds=[callbackRouter.themeReceived.addListener(this.themeReceived.bind(this)),callbackRouter.shouldShowContextualSearchBox.addListener(this.shouldShowContextualSearchBox.bind(this)),callbackRouter.notifyHandshakeComplete.addListener(this.onBackendHandshakeComplete.bind(this)),callbackRouter.notifyResultsPanelOpened.addListener(this.onNotifyResultsPanelOpened.bind(this)),callbackRouter.notifyOverlayClosing.addListener((()=>{this.isClosing=true;this.performanceTracker.endSession()})),callbackRouter.onOverlayReshown.addListener((()=>{this.isClosing=false;this.sidePanelOpened=true;this.overlayReshowInProgress=true;this.performanceTracker.reset();this.performanceTracker.startSession()})),callbackRouter.suppressGhostLoader.addListener(this.suppressGhostLoader_.bind(this)),callbackRouter.pageContentTypeChanged.addListener(this.onPageContentTypeChanged.bind(this))];this.eventTracker_.add(document,"set-cursor-tooltip",(e=>{this.$.cursorTooltip.setTooltip(e.detail.tooltipType)}));this.eventTracker_.add(document,"translate-mode-state-changed",(e=>{this.isTranslateModeActive=e.detail.translateModeEnabled}));this.eventTracker_.add(document,"text-copied",(()=>{this.showToast(this.i18n("copyToastMessage"))}));this.eventTracker_.add(document,"copied-as-image",(()=>{this.showToast(this.i18n("copyAsImageToastMessage"))}));this.eventTracker_.add(this.$.translateButtonContainer,"transitionend",(()=>{this.registerHelpBubble("kLensOverlayTranslateButtonElementId",this.$.translateButton.getTranslateEnableButton());this.browserProxy.handler.maybeShowTranslateFeaturePromo();this.eventTracker_.remove(this.$.translateButtonContainer,"transitionend")}));this.eventTracker_.add(document,"language-picker-closed",(()=>{this.handleLanguagePickerClosed()}));this.eventTracker_.add(document,"language-picker-opened",(()=>{this.handleLanguagePickersOpened()}));this.eventTracker_.add(document,"query-autocomplete",this.handleQueryAutocomplete.bind(this));this.eventTracker_.add(document,"pointermove",this.updateCursorPosition.bind(this));this.eventTracker_.add(this.$.searchbox,"mousedown",(()=>{this.suppressGhostLoader=false}));this.eventTracker_.add(this.$.selectionOverlay,"on-finish-reshow-overlay",(()=>{if(!this.overlayReshowInProgress){return}this.overlayReshowInProgress=false;this.browserProxy.handler.finishReshowOverlay()}));this.performanceTracker.startSession()}disconnectedCallback(){super.disconnectedCallback();this.listenerIds.forEach((id=>assert(this.browserProxy.callbackRouter.removeListener(id))));this.listenerIds=[];this.eventTracker_.removeAll()}ready(){super.ready();recordTimeToWebUIReady(Number(Date.now()-this.invocationTime))}handlePointerEnter(){this.$.cursorTooltip.markPointerEnteredContentArea()}handlePointerLeave(){this.$.cursorTooltip.markPointerLeftContentArea()}handlePointerEnterBackgroundScrim(){this.$.cursorTooltip.setTooltip(CursorTooltipType.LIVE_PAGE);this.$.cursorTooltip.unhideTooltip()}handlePointerLeaveBackgroundScrim(){this.$.cursorTooltip.hideTooltip()}handlePointerEnterSelectionOverlay(){this.$.cursorTooltip.unhideTooltip()}handlePointerLeaveSelectionOverlay(){this.$.cursorTooltip.hideTooltip()}handleSearchboxFocused(){this.suppressGhostLoader=false;this.isSearchboxFocused=true;this.$.translateButtonContainer.classList.remove("searchbox-unfocused");this.focusShimmerOnSearchbox();this.searchboxBoundingClientRectObserver.observe(this.$.searchbox.getSuggestionsElement());this.searchboxBoundingClientRectObserver.observe(this.$.selectionOverlay)}handleQueryAutocomplete(e){this.autocompleteRequestStarted=!e.detail.inputValue;if(this.autocompleteRequestStarted&&!window.navigator.onLine){this.showErrorState=true;return}this.showErrorState=false}onSearchboxBoundsChanged(){this.focusShimmerOnSearchbox();this.searchboxSuggestionCount=this.$.searchbox.getSuggestionsElement().selectableMatchElements.length}focusShimmerOnSearchbox(){const suggestionsContainer=this.$.searchbox.getSuggestionsElement();const areSuggestionsShowing=suggestionsContainer.offsetWidth*suggestionsContainer.offsetHeight>0;const newSearchboxWidth=areSuggestionsShowing?suggestionsContainer.offsetWidth:this.$.searchboxGhostLoader.offsetWidth>0?this.$.searchboxGhostLoader.offsetWidth:this.$.searchbox.offsetWidth;const newSearchboxHeight=areSuggestionsShowing?suggestionsContainer.offsetHeight:this.$.searchboxGhostLoader.offsetHeight>0?this.$.searchboxGhostLoader.offsetHeight:this.$.searchbox.offsetHeight;const selectionOverlayRect=this.$.selectionOverlay.getBoundingRect();const newTop=this.$.searchboxContainer.offsetTop-selectionOverlayRect.top;const newLeft=this.$.searchboxContainer.offsetLeft-selectionOverlayRect.left;focusShimmerOnRegion(this,newTop/selectionOverlayRect.height,newLeft/selectionOverlayRect.width,newSearchboxWidth/selectionOverlayRect.width,newSearchboxHeight/selectionOverlayRect.height,ShimmerControlRequester.SEARCHBOX)}handleSearchboxBlurred(event){if(event.relatedTarget instanceof Node&&this.$.searchboxContainer.contains(event.relatedTarget)){return}this.isSearchboxFocused=false;this.autocompleteRequestStarted=false;this.showErrorState=false;this.$.translateButtonContainer.classList.add("searchbox-unfocused");unfocusShimmer(this,ShimmerControlRequester.SEARCHBOX);this.searchboxBoundingClientRectObserver.disconnect()}handleEscapeSearchbox(e){handleEscapeSearchbox(this,this.$.searchbox,e)}handleLanguagePickersOpened(){this.areLanguagePickersOpen=true}handleLanguagePickerClosed(){this.areLanguagePickersOpen=false}onBackgroundScrimClicked(){this.browserProxy.handler.closeRequestedByOverlayBackgroundClick()}onCloseButtonClick(){this.browserProxy.handler.closeRequestedByOverlayCloseButton()}onFeedbackClick(event){if(event instanceof KeyboardEvent&&!(event.key==="Enter"||event.key===" ")){return}this.browserProxy.handler.feedbackRequestedByOverlay();this.moreOptionsMenuVisible=false;recordLensOverlayInteraction(INVOCATION_SOURCE,UserAction.kSendFeedback)}onLearnMoreClick(event){if(event instanceof KeyboardEvent&&!(event.key==="Enter"||event.key===" ")){return}this.browserProxy.handler.infoRequestedByOverlay({middleButton:event.button===1,altKey:event.altKey,ctrlKey:event.ctrlKey,metaKey:event.metaKey,shiftKey:event.shiftKey});this.moreOptionsMenuVisible=false;recordLensOverlayInteraction(INVOCATION_SOURCE,UserAction.kLearnMore)}computeShowGhostLoader(){if(!this.enableGhostLoader||this.suppressGhostLoader){return false}return this.isSearchboxFocused&&(this.autocompleteRequestStarted||this.showErrorState)}computePlaceholderText(){return this.pageContentType===PageContentType.kPdf?this.i18n("searchBoxHintPdf"):this.i18n("searchBoxHintDefault")}suppressGhostLoader_(){this.suppressGhostLoader=true}onPageContentTypeChanged(newPageContentType){this.pageContentType=newPageContentType}onMoreOptionsButtonClick(){if(this.isTranslateButtonEnabled){this.browserProxy.handler.maybeCloseTranslateFeaturePromo(false)}this.moreOptionsMenuVisible=!this.moreOptionsMenuVisible}onMyActivityClick(event){if(event instanceof KeyboardEvent&&!(event.key==="Enter"||event.key===" ")){return}this.browserProxy.handler.activityRequestedByOverlay({middleButton:event.button===1,altKey:event.altKey,ctrlKey:event.ctrlKey,metaKey:event.metaKey,shiftKey:event.shiftKey});this.moreOptionsMenuVisible=false;recordLensOverlayInteraction(INVOCATION_SOURCE,UserAction.kMyActivity)}onBackendHandshakeComplete(){if(this.isBackendHandshakeComplete){return}this.isBackendHandshakeComplete=true;if(this.triggerSuggestOnInputReady&&this.isSearchboxFocused){this.triggerSearchboxSuggestions()}this.triggerSuggestOnInputReady=false}onNotifyResultsPanelOpened(){this.sidePanelOpened=true}themeReceived(theme){this.theme=theme}shouldShowContextualSearchBox(shouldShow){this.isLensOverlayContextualSearchboxVisible=this.isLensOverlayContextualSearchboxEnabled&&shouldShow;this.canAnimateInCloseButton=true}handleSelectionStarted(){this.$.cursorTooltip.setPauseTooltipChanges(true);this.isPointerDown=true;this.forceHideSearchBox=true}handleSelectionFinished(){if(!this.enableBorderGlow){this.$.initialGradient.triggerHideScrimAnimation()}this.$.cursorTooltip.setPauseTooltipChanges(false);this.isPointerDown=false}onScreenshotRendered(e){this.isImageRendered=true;this.sidePanelOpened=e.detail.isSidePanelOpen;if(this.enableCsbMotionTweaks&&this.autoFocusSearchbox&&this.isLensOverlayContextualSearchboxVisible){this.focusSearchbox()}}onInitialFlashAnimationEnd(){this.initialFlashAnimationHasEnded=true;if(!this.enableBorderGlow){this.$.initialGradient.setScrimVisible()}if(this.autoFocusSearchbox&&this.isLensOverlayContextualSearchboxVisible&&!this.enableCsbMotionTweaks){this.focusSearchbox()}}triggerSearchboxSuggestions(){if(!window.navigator.onLine){this.showErrorState=true;return}if(this.isBackendHandshakeComplete){this.$.searchbox.queryAutocomplete();return}this.triggerSuggestOnInputReady=true;this.autocompleteRequestStarted=true}focusSearchbox(){this.shadowRoot.querySelector("cr-searchbox")?.shadowRoot.querySelector("input")?.focus();this.triggerSearchboxSuggestions()}computeShouldFadeOutButtons(){return!this.isTranslateModeActive&&this.isPointerDown}computeShouldHideSearchBox(){return this.isTranslateModeActive||this.sidePanelOpened||this.forceHideSearchBox}async showToast(message){if(this.$.toast.open){await this.$.toast.hide();setTimeout((()=>{this.toastMessage=message;this.$.toast.show()}),100)}else{this.toastMessage=message;this.$.toast.show()}}onHideToastClick(){this.$.toast.hide()}updateCursorPosition(event){if(this.updateCursorPositionRequestId){cancelAnimationFrame(this.updateCursorPositionRequestId)}if(!this.$.cursorTooltip.isTooltipVisible()){return}this.updateCursorPositionRequestId=requestAnimationFrame((()=>{this.$.cursorTooltip.style.transform=`translate3d(${event.clientX}px, ${event.clientY}px, 0)`;this.updateCursorPositionRequestId=undefined}))}skColorToHex_(skColor){return skColorToHexColor(skColor)}skColorToRgb_(skColor){const hex=skColorToHexColor(skColor);assert(/^#[0-9a-fA-F]{6}$/.test(hex));const r=parseInt(hex.substring(1,3),16);const g=parseInt(hex.substring(3,5),16);const b=parseInt(hex.substring(5,7),16);return`${r}, ${g}, ${b}`}getSearchboxAriaDescription(){return this.showGhostLoader?this.$.searchboxGhostLoader.getText():""}setSearchboxFocusForTesting(isFocused){this.isSearchboxFocused=isFocused}handleEscapeSearchboxForTesting(e){this.handleEscapeSearchbox(e)}getSidePanelOpenedForTesting(){return this.sidePanelOpened}getOverlayReshowInProgressForTesting(){return this.overlayReshowInProgress}}customElements.define(LensOverlayAppElement.is,LensOverlayAppElement);