// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./object_layer.js";import"./simplified_text_layer.js";import"./text_layer.js";import"./region_selection.js";import"./post_selection_renderer.js";import"./overlay_border_glow.js";import"./overlay_shimmer_canvas.js";import"/strings.m.js";import"//resources/cr_elements/cr_button/cr_button.js";import"//resources/cr_elements/cr_toast/cr_toast.js";import{I18nMixin}from"//resources/cr_elements/i18n_mixin.js";import{assert}from"//resources/js/assert.js";import{EventTracker}from"//resources/js/event_tracker.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{afterNextRender,PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{BrowserProxyImpl}from"./browser_proxy.js";import{getFallbackTheme}from"./color_utils.js";import{CursorTooltipType}from"./cursor_tooltip.js";import{UserAction}from"./lens.mojom-webui.js";import{INVOCATION_SOURCE}from"./lens_overlay_app.js";import{ContextMenuOption,recordContextMenuOptionShown,recordLensOverlayInteraction,recordLensOverlaySelectionCloseButtonShown,recordLensOverlaySelectionCloseButtonUsed}from"./metrics_utils.js";import{ScreenshotBitmapBrowserProxyImpl}from"./screenshot_bitmap_browser_proxy.js";import{renderScreenshot}from"./screenshot_utils.js";import{getTemplate}from"./selection_overlay.html.js";import{CursorType,DRAG_THRESHOLD,DragFeature,emptyGestureEvent,focusShimmerOnRegion,GestureState,ShimmerControlRequester}from"./selection_utils.js";import{toPercent}from"./values_converter.js";const SCREENSHOT_FULLSIZE_MARGIN_PIXEL=24;const SCREENSHOT_RESIZE_TOLERANCE_PIXELS=2;export const CURSOR_SIZE_PIXEL=32;export const CURSOR_IMG_URL="--cursor-img-url";const FADE_OUT_DELAY_MS=250;function shouldIgnoreKeyboardEvent(event){return event instanceof KeyboardEvent&&!(event.key==="Enter"||event.key===" ")}const SelectionOverlayElementBase=I18nMixin(PolymerElement);export class SelectionOverlayElement extends SelectionOverlayElementBase{static get is(){return"lens-selection-overlay"}static get template(){return getTemplate()}static get properties(){return{isScreenshotRendered:{type:Boolean,reflectToAttribute:true,value:false},isResized:{type:Boolean,reflectToAttribute:true,value:false,observer:"onIsResizedChanged"},isInitialSize:{type:Boolean,reflectToAttribute:true,value:true},showTranslateContextMenuItem:{type:Boolean,reflectToAttribute:true,value:true},showSelectedTextContextMenu:{type:Boolean,value:false,reflectToAttribute:true},showSelectedRegionContextMenu:{type:Boolean,value:false,reflectToAttribute:true},showDetectedTextContextMenuOptions:{type:Boolean,reflectToAttribute:true},selectedTextContextMenuX:Number,selectedTextContextMenuY:Number,selectedRegionContextMenuX:Number,selectedRegionContextMenuY:Number,selectedRegionContextMenuHorizontalStyle:String,selectedRegionContextMenuVerticalStyle:String,canvasHeight:Number,canvasWidth:Number,isPointerInside:{type:Boolean,value:false},currentGesture:{type:Object,value:()=>emptyGestureEvent()},disableShimmer:{type:Boolean,readOnly:true,value:!loadTimeData.getBoolean("enableShimmer")},enableBorderGlow:{type:Boolean,value:()=>loadTimeData.getBoolean("enableBorderGlow")},enableCopyAsImage:{type:Boolean,reflectToAttribute:true,value:()=>loadTimeData.getBoolean("enableCopyAsImage")},enableSaveAsImage:{type:Boolean,reflectToAttribute:true,value:()=>loadTimeData.getBoolean("enableSaveAsImage")},isClosing:{type:Boolean,reflectToAttribute:true,value:false},suppressCopyAndSaveAsImage:{type:Boolean,reflectToAttribute:true,value:()=>loadTimeData.getString("invocationSource")==="ContentAreaContextMenuImage"},shimmerOnSegmentation:{type:Boolean,reflectToAttribute:true,value:false},shimmerFadeOutComplete:{type:Boolean,reflectToAttribute:true,value:true},darkenExtraScrim:{type:Boolean,reflectToAttribute:true,value:false},theme:{type:Object,value:getFallbackTheme},translateModeEnabled:{type:Boolean,reflectToAttribute:true,value:false},selectionOverlayRect:Object,isSearchboxFocused:Boolean,areLanguagePickersOpen:Boolean,sidePanelOpened:{type:Boolean,reflectToAttribute:true,value:false},hideBackgroundImageCanvas:{type:Boolean,reflectToAttribute:true,value:false}}}selectedRegionContextMenuBox;highlightedText="";contentLanguage="";textSelectionStartIndex=-1;textSelectionEndIndex=-1;detectedTextStartIndex=-1;detectedTextEndIndex=-1;isPointerInsideButton=false;overlayBorderGlow;eventTracker_=new EventTracker;listenerIds;draggingRespondent=DragFeature.NONE;resizeObserver=new ResizeObserver(this.handleResize.bind(this));matchMedia;cursorOffsetX=3;cursorOffsetY=6;hasInitialFlashAnimationEnded=false;browserProxy=BrowserProxyImpl.getInstance();backgroundImageFadeOutTimeoutId=-1;updateCursorPositionRequestId;onPointerMoveRequestId;handleResizeRequestId;closeButtonUsedRecorded=false;connectedCallback(){super.connectedCallback();this.resizeObserver.observe(this);this.listenerIds=[this.browserProxy.callbackRouter.notifyOverlayClosing.addListener((()=>{this.isClosing=true;this.removeDragListeners();clearTimeout(this.backgroundImageFadeOutTimeoutId);this.backgroundImageFadeOutTimeoutId=setTimeout((()=>{this.hideBackgroundImageCanvas=true}),FADE_OUT_DELAY_MS)})),this.browserProxy.callbackRouter.onCopyCommand.addListener(this.onCopyCommand.bind(this)),this.browserProxy.callbackRouter.notifyResultsPanelOpened.addListener(this.onNotifyResultsPanelOpened.bind(this))];ScreenshotBitmapBrowserProxyImpl.getInstance().fetchScreenshot(this.screenshotDataReceived.bind(this));ScreenshotBitmapBrowserProxyImpl.getInstance().addOnOverlayReshownListener(this.onOverlayReshown.bind(this));this.eventTracker_.add(document,"shimmer-fade-out-complete",(e=>{this.shimmerFadeOutComplete=e.detail}));this.eventTracker_.add(document,"set-cursor",(e=>{if(e.detail.cursor===CursorType.POINTER){this.setCursorToPointer()}else if(e.detail.cursor===CursorType.CROSSHAIR){this.setCursorToCrosshair()}else if(e.detail.cursor===CursorType.TEXT){this.setCursorToText()}else{this.resetCursor()}}));this.eventTracker_.add(document,"translate-mode-state-changed",(e=>{this.showTranslateContextMenuItem=!e.detail.translateModeEnabled;this.translateModeEnabled=e.detail.translateModeEnabled;this.resetCursor()}));this.eventTracker_.add(document,"show-selected-text-context-menu",(e=>{this.selectedTextContextMenuX=e.detail.left;this.selectedTextContextMenuY=e.detail.bottom;this.highlightedText=e.detail.text;this.contentLanguage=e.detail.contentLanguage;this.textSelectionStartIndex=e.detail.selectionStartIndex;this.textSelectionEndIndex=e.detail.selectionEndIndex;this.setShowSelectedTextContextMenu(true)}));this.eventTracker_.add(document,"restore-selected-text-context-menu",(()=>{this.setShowSelectedTextContextMenu(true)}));this.eventTracker_.add(document,"update-selected-text-context-menu",(e=>{this.selectedTextContextMenuX=e.detail.left;this.selectedTextContextMenuY=e.detail.bottom;this.highlightedText=e.detail.text;this.contentLanguage=e.detail.contentLanguage;this.textSelectionStartIndex=e.detail.selectionStartIndex;this.textSelectionEndIndex=e.detail.selectionEndIndex}));this.eventTracker_.add(document,"hide-selected-text-context-menu",(()=>{this.setShowSelectedTextContextMenu(false);this.textSelectionStartIndex=-1;this.textSelectionEndIndex=-1}));this.eventTracker_.add(document,"update-selected-region-context-menu",(e=>{this.updateSelectedRegionContextMenu(e.detail);this.positionSelectedRegionContextMenu()}));this.eventTracker_.add(document,"show-selected-region-context-menu",(e=>{this.updateSelectedRegionContextMenu(e.detail);this.setShowSelectedRegionContextMenu(!this.suppressCopyAndSaveAsImage&&(this.enableCopyAsImage||this.enableSaveAsImage)||this.showDetectedTextContextMenuOptions);this.positionSelectedRegionContextMenu();if(this.showDetectedTextContextMenuOptions){this.dispatchEvent(new CustomEvent("text-found-in-region",{bubbles:true,composed:true}))}}));this.eventTracker_.add(document,"restore-selected-region-context-menu",(()=>{if(this.selectedRegionContextMenuBox!==undefined){this.setShowSelectedRegionContextMenu(!this.suppressCopyAndSaveAsImage&&(this.enableCopyAsImage||this.enableSaveAsImage)||this.showDetectedTextContextMenuOptions)}}));this.eventTracker_.add(document,"hide-selected-region-context-menu",(()=>{this.setShowSelectedRegionContextMenu(false);this.detectedTextStartIndex=-1;this.detectedTextEndIndex=-1}));this.eventTracker_.add(document,"darken-extra-scrim-opacity",(()=>{this.darkenExtraScrim=true}));this.eventTracker_.add(document,"lighten-extra-scrim-opacity",(()=>{this.darkenExtraScrim=false}));this.eventTracker_.add(this.$.initialFlashScrim,"animationend",(event=>{if(event.animationName!=="initial-inset-animation"){return}this.onInitialFlashAnimationEnd()}));this.eventTracker_.add(document,"focus-region",(e=>{if(e.detail.requester===ShimmerControlRequester.SEGMENTATION){this.shimmerOnSegmentation=true}}));this.eventTracker_.add(document,"post-selection-updated",(e=>{this.selectedRegionContextMenuBox=e.detail.centerRotatedBox;this.selectedRegionContextMenuX=this.selectedRegionContextMenuBox.box.x-this.selectedRegionContextMenuBox.box.width/2;this.selectedRegionContextMenuY=this.selectedRegionContextMenuBox.box.y+this.selectedRegionContextMenuBox.box.height/2}));this.eventTracker_.add(document,"unfocus-region",(()=>{this.shimmerOnSegmentation=false}));if(this.enableBorderGlow){this.eventTracker_.add(document,"post-selection-updated",(e=>{this.handlePostSelectionUpdated(e.detail.height,e.detail.width)}))}this.updateSelectionOverlayRect();this.updateDevicePixelRatioListener()}disconnectedCallback(){super.disconnectedCallback();this.resizeObserver.unobserve(this);this.eventTracker_.removeAll();this.listenerIds.forEach((id=>assert(this.browserProxy.callbackRouter.removeListener(id))));this.listenerIds=[];assert(this.matchMedia);this.matchMedia.removeEventListener("change",this.onDevicePixelRatioChanged.bind(this))}ready(){super.ready();this.addEventListener("pointerdown",this.onPointerDown.bind(this));this.addEventListener("pointermove",this.updateCursorPosition.bind(this))}addDragListeners(){this.addEventListener("pointerup",this.onPointerUp);this.addEventListener("pointermove",this.onPointerMove);this.addEventListener("pointercancel",this.onPointerCancel)}removeDragListeners(){this.removeEventListener("pointerup",this.onPointerUp);this.removeEventListener("pointermove",this.onPointerMove);this.removeEventListener("pointercancel",this.onPointerCancel)}updateDevicePixelRatioListener(){if(this.matchMedia){this.eventTracker_.remove(this.matchMedia,"change")}const queryString=`(resolution: ${window.devicePixelRatio}dppx)`;this.matchMedia=matchMedia(queryString);this.eventTracker_.add(this.matchMedia,"change",this.onDevicePixelRatioChanged.bind(this))}onDevicePixelRatioChanged(){this.updateDevicePixelRatioListener();this.resizeSelectionCanvases(this.selectionOverlayRect.width,this.selectionOverlayRect.height)}updateCursorPosition(event){if(this.updateCursorPositionRequestId){cancelAnimationFrame(this.updateCursorPositionRequestId)}this.updateCursorPositionRequestId=requestAnimationFrame((()=>{const mouseX=event.clientX;const mouseY=event.clientY;const cursorOffsetX=mouseX+this.cursorOffsetX;const cursorOffsetY=mouseY+this.cursorOffsetY;if(!this.disableShimmer&&(this.isPointerInside||this.currentGesture.state===GestureState.DRAGGING)){this.updateShimmerForCursor(cursorOffsetX,cursorOffsetY)}this.$.cursor.style.transform=`translate3d(${cursorOffsetX}px, ${cursorOffsetY}px, 0)`;this.updateCursorPositionRequestId=undefined}))}updateShimmerForCursor(cursorLeft,cursorTop){const relativeXPercent=Math.max(0,Math.min(cursorLeft,this.selectionOverlayRect.right)-this.selectionOverlayRect.left)/this.selectionOverlayRect.width;const relativeYPercent=Math.max(0,Math.min(cursorTop,this.selectionOverlayRect.bottom)-this.selectionOverlayRect.top)/this.selectionOverlayRect.height;focusShimmerOnRegion(this,relativeYPercent,relativeXPercent,CURSOR_SIZE_PIXEL/this.selectionOverlayRect.width,CURSOR_SIZE_PIXEL/this.selectionOverlayRect.height,ShimmerControlRequester.CURSOR)}onIsResizedChanged(newValue){this.browserProxy.handler.setLiveBlur(newValue)}getHiddenCursorClass(isPointerInside,state){if(!isPointerInside&&state!==GestureState.DRAGGING){return"hidden"}else{return""}}setCursorToText(){document.body.style.cursor="text";this.cursorOffsetX=3;this.cursorOffsetY=8;this.style.setProperty(CURSOR_IMG_URL,'url("text.svg")')}setCursorToCrosshair(){document.body.style.cursor="crosshair";this.cursorOffsetX=3;this.cursorOffsetY=6;this.style.setProperty(CURSOR_IMG_URL,'url("lens.svg")')}setCursorToPointer(){this.cursorOffsetX=11;this.cursorOffsetY=17;this.style.setProperty(CURSOR_IMG_URL,'url("lens.svg")')}resetCursor(){if(this.translateModeEnabled){this.setCursorToText();return}document.body.style.cursor="unset";this.cursorOffsetX=3;this.cursorOffsetY=6;this.style.setProperty(CURSOR_IMG_URL,'url("lens.svg")')}handlePointerEnter(){this.isPointerInside=true;if(!this.isPointerInsideButton){this.dispatchEvent(new CustomEvent("set-cursor-tooltip",{bubbles:true,composed:true,detail:{tooltipType:this.translateModeEnabled?CursorTooltipType.TEXT_HIGHLIGHT:CursorTooltipType.REGION_SEARCH}}))}}handlePointerLeave(){this.isPointerInside=false}onImageRendered(){this.dispatchEvent(new CustomEvent("screenshot-rendered",{bubbles:true,composed:true,detail:{isSidePanelOpen:this.sidePanelOpened}}));this.browserProxy.handler.notifyOverlayInitialized()}onPointerDown(event){if(this.shouldIgnoreEvent(event)){return}if(event.button===2){if(this.$.textLayer.handleRightClick(event)){return}this.$.postSelectionRenderer.handleRightClick(event);return}this.addDragListeners();this.currentGesture={state:GestureState.NOT_STARTED,startX:event.clientX,startY:event.clientY,clientX:event.clientX,clientY:event.clientY};this.browserProxy.handler.maybeCloseTranslateFeaturePromo(false);if(!this.isSearchboxFocused&&!this.areLanguagePickersOpen){this.handleGestureStart()}}onPointerUp(event){this.updateGestureCoordinates(event);if(this.currentGesture.state===GestureState.DRAGGING){this.cancelPendingDragAnimationFrame();this.handleGestureDrag(event)}if(this.currentGesture.state!==GestureState.NOT_STARTED){this.handleGestureEnd()}this.currentGesture=emptyGestureEvent();this.draggingRespondent=DragFeature.NONE;this.removeDragListeners()}onPointerMove(event){this.updateGestureCoordinates(event);if(!this.isDragging()){return}if(this.currentGesture.state===GestureState.NOT_STARTED){this.handleGestureStart()}if(this.currentGesture.state===GestureState.STARTING){this.set("currentGesture.state",GestureState.DRAGGING)}assert(this.currentGesture.state===GestureState.DRAGGING);this.cancelPendingDragAnimationFrame();this.onPointerMoveRequestId=requestAnimationFrame((()=>{this.handleGestureDrag(event);this.onPointerMoveRequestId=undefined}))}cancelPendingDragAnimationFrame(){if(this.onPointerMoveRequestId){cancelAnimationFrame(this.onPointerMoveRequestId)}}onPointerCancel(){this.handleGestureCancel();this.currentGesture=emptyGestureEvent();this.draggingRespondent=DragFeature.NONE;this.removeDragListeners();this.resetCursor()}handleGestureStart(){this.set("currentGesture.state",GestureState.STARTING);this.browserProxy.handler.closePreselectionBubble();this.suppressCopyAndSaveAsImage=false;this.dispatchEvent(new CustomEvent("selection-started",{bubbles:true,composed:true}));this.detectedTextStartIndex=-1;this.detectedTextEndIndex=-1;this.showDetectedTextContextMenuOptions=false;this.$.textLayer.onSelectionStart();if(this.enableBorderGlow){this.getOverlayBorderGlow().handleGestureStart();if(!this.$.postSelectionRenderer.hasSelection()){this.$.regionSelectionLayer.handleGestureStart()}}if(this.$.postSelectionRenderer.handleGestureStart(this.currentGesture)){this.draggingRespondent=DragFeature.POST_SELECTION}else if(this.$.textLayer.handleGestureStart(this.currentGesture)){this.draggingRespondent=DragFeature.TEXT;this.$.postSelectionRenderer.clearSelection()}}handleGestureDrag(event){assert(this.currentGesture.state===GestureState.DRAGGING);this.setPointerCapture(event.pointerId);if(this.draggingRespondent===DragFeature.TEXT){this.setCursorToText();this.$.textLayer.handleGestureDrag(this.currentGesture)}else if(this.draggingRespondent===DragFeature.POST_SELECTION){this.$.postSelectionRenderer.handleGestureDrag(this.currentGesture)}else if(!this.translateModeEnabled){this.setCursorToCrosshair();this.draggingRespondent=DragFeature.MANUAL_REGION;this.$.postSelectionRenderer.clearSelection();this.$.regionSelectionLayer.handleGestureStart();this.$.regionSelectionLayer.handleGestureDrag(this.currentGesture)}}handleGestureEnd(){this.$.textLayer.onSelectionFinish();switch(this.currentGesture.state){case GestureState.DRAGGING:if(this.draggingRespondent===DragFeature.MANUAL_REGION){this.$.regionSelectionLayer.handleGestureEnd(this.currentGesture)}else if(this.draggingRespondent===DragFeature.TEXT){this.$.textLayer.handleGestureEnd()}else if(this.draggingRespondent===DragFeature.POST_SELECTION){this.$.postSelectionRenderer.handleGestureEnd();this.$.regionSelectionLayer.handlePostSelectionDragGestureEnd()}break;case GestureState.STARTING:if(this.draggingRespondent===DragFeature.TEXT){this.$.textLayer.handleGestureEnd();break}if(this.translateModeEnabled){break}if(this.$.objectSelectionLayer.handleGestureEnd(this.currentGesture)){break}this.$.regionSelectionLayer.handleGestureEnd(this.currentGesture);break;default:break}this.resetCursor();this.dispatchEvent(new CustomEvent("selection-finished",{bubbles:true,composed:true}))}handleGestureCancel(){this.$.textLayer.cancelGesture();this.$.regionSelectionLayer.cancelGesture();this.$.postSelectionRenderer.cancelGesture()}handlePostSelectionUpdated(height,width){const overlayBorderGlow=this.getOverlayBorderGlow();if(width===0&&height===0&&this.draggingRespondent===DragFeature.NONE){overlayBorderGlow.handleClearSelection();this.$.regionSelectionLayer.handlePostSelectionCleared();return}overlayBorderGlow.handlePostSelectionUpdated()}updateCanvasSize(containerWidth,containerHeight){const screenshotHeight=this.$.backgroundImageCanvas.height;const screenshotWidth=this.$.backgroundImageCanvas.width;const doesScreenshotFillContainer=Math.abs(containerWidth-screenshotWidth/window.devicePixelRatio)<=SCREENSHOT_RESIZE_TOLERANCE_PIXELS&&Math.abs(containerHeight-screenshotHeight/window.devicePixelRatio)<=SCREENSHOT_RESIZE_TOLERANCE_PIXELS;const shouldApplyMargins=!doesScreenshotFillContainer||this.sidePanelOpened;const margins=shouldApplyMargins&&!this.isClosing?SCREENSHOT_FULLSIZE_MARGIN_PIXEL*2:0;const newContainerWidth=containerWidth-margins;const newContainerHeight=containerHeight-margins;const aspectRatio=this.$.backgroundImageCanvas.width/this.$.backgroundImageCanvas.height;const widthBasedHeight=Math.round(newContainerWidth/aspectRatio);const heightBasedWidth=Math.round(newContainerHeight*aspectRatio);if(widthBasedHeight<=newContainerHeight){this.canvasHeight=widthBasedHeight;this.canvasWidth=newContainerWidth}else{this.canvasWidth=heightBasedWidth;this.canvasHeight=newContainerHeight}this.isResized=shouldApplyMargins;if(this.isResized){this.isInitialSize=false;this.onInitialFlashAnimationEnd()}}handleResize(entries){if(this.handleResizeRequestId){cancelAnimationFrame(this.handleResizeRequestId)}this.handleResizeRequestId=requestAnimationFrame((()=>{assert(entries.length===1);const newRect=entries[0].contentRect;if(!this.isScreenshotRendered||newRect.width===0&&newRect.height===0){this.handleResizeRequestId=undefined;return}this.updateCanvasSize(newRect.width,newRect.height);this.positionSelectedRegionContextMenu();this.updateSelectionOverlayRect();this.resizeSelectionCanvases(this.selectionOverlayRect.width,this.selectionOverlayRect.height);this.handleResizeRequestId=undefined}))}updateSelectionOverlayRect(){this.selectionOverlayRect=new DOMRect(this.$.selectionOverlay.offsetLeft,this.$.selectionOverlay.offsetTop,this.$.selectionOverlay.offsetWidth,this.$.selectionOverlay.offsetHeight)}resizeSelectionCanvases(newWidth,newHeight){this.$.regionSelectionLayer.setCanvasSizeTo(newWidth,newHeight);this.$.postSelectionRenderer.setCanvasSizeTo(newWidth,newHeight);this.$.objectSelectionLayer.setCanvasSizeTo(newWidth,newHeight);this.$.overlayShimmerCanvas.setCanvasSizeTo(newWidth,newHeight)}updateGestureCoordinates(event){this.currentGesture.clientX=event.clientX;this.currentGesture.clientY=event.clientY}shouldIgnoreEvent(event){if(this.isClosing){return true}const elementsAtPoint=this.shadowRoot.elementsFromPoint(event.clientX,event.clientY);if(elementsAtPoint.includes(this.$.selectedTextContextMenu)||elementsAtPoint.includes(this.$.selectedRegionContextMenu)||elementsAtPoint.includes(this.$.closeButton)){return true}return!event.isPrimary||event.button!==0&&event.button!==2}isDragging(){if(this.currentGesture.state===GestureState.DRAGGING){return true}const xMovement=Math.abs(this.currentGesture.clientX-this.currentGesture.startX);const yMovement=Math.abs(this.currentGesture.clientY-this.currentGesture.startY);return xMovement>DRAG_THRESHOLD||yMovement>DRAG_THRESHOLD}positionSelectedRegionContextMenu(){if(!this.selectedRegionContextMenuBox){return}const left=this.selectedRegionContextMenuBox.box.x-this.selectedRegionContextMenuBox.box.width/2;const top=this.selectedRegionContextMenuBox.box.y-this.selectedRegionContextMenuBox.box.height/2;const bottom=this.selectedRegionContextMenuBox.box.y+this.selectedRegionContextMenuBox.box.height/2;this.selectedRegionContextMenuHorizontalStyle=`left: ${toPercent(left)}; `;if(this.$.selectedRegionContextMenu.offsetLeft+this.$.selectedRegionContextMenu.offsetWidth>this.canvasWidth){this.selectedRegionContextMenuHorizontalStyle=`right: 0; `;if(this.$.selectedRegionContextMenu.offsetLeft<0){this.selectedRegionContextMenuHorizontalStyle=` `}}this.selectedRegionContextMenuVerticalStyle=`top: calc(${toPercent(bottom)} + 12px)`;if(this.$.selectionOverlay.offsetTop+this.$.selectedRegionContextMenu.offsetTop+this.$.selectedRegionContextMenu.offsetHeight>window.innerHeight){this.selectedRegionContextMenuVerticalStyle=`bottom: calc(${toPercent(1-top)} + 12px);`;if(this.$.selectionOverlay.offsetTop+this.$.selectedRegionContextMenu.offsetTop<0){this.selectedRegionContextMenuVerticalStyle=`bottom: calc(${toPercent(1-top)} + 12px + ${this.$.selectionOverlay.offsetTop+this.$.selectedRegionContextMenu.offsetTop}px);`}}}getContextMenuStyle(contextMenuX,contextMenuY){return`left: ${toPercent(contextMenuX)}; top: calc(${toPercent(contextMenuY)} + 12px)`}handleCopy(event){if(shouldIgnoreKeyboardEvent(event)){return}this.copyText(this.textSelectionStartIndex,this.textSelectionEndIndex,this.highlightedText)}handleCopyDetectedText(event){if(shouldIgnoreKeyboardEvent(event)){return}this.setShowSelectedRegionContextMenu(false);this.$.textLayer.onCopyDetectedText(this.detectedTextStartIndex,this.detectedTextEndIndex,this.copyText.bind(this))}copyText(textStartIndex,textEndIndex,text){if(textStartIndex<0||textEndIndex<0){return}this.browserProxy.handler.copyText(text);recordLensOverlayInteraction(INVOCATION_SOURCE,UserAction.kCopyText);this.dispatchEvent(new CustomEvent("text-copied",{bubbles:true,composed:true}));this.setShowSelectedTextContextMenu(false);this.setShowSelectedRegionContextMenu(false)}handleSelectText(event){if(shouldIgnoreKeyboardEvent(event)){return}this.$.textLayer.selectAndSendWords(this.detectedTextStartIndex,this.detectedTextEndIndex);this.$.postSelectionRenderer.clearSelection()}handleTranslateDetectedText(event){if(shouldIgnoreKeyboardEvent(event)){return}this.$.textLayer.selectAndTranslateWords(this.detectedTextStartIndex,this.detectedTextEndIndex);this.setShowSelectedRegionContextMenu(false)}handleTranslate(event){if(shouldIgnoreKeyboardEvent(event)){return}BrowserProxyImpl.getInstance().handler.issueTranslateSelectionRequest(this.highlightedText.replaceAll("\r\n"," "),this.contentLanguage,this.textSelectionStartIndex,this.textSelectionEndIndex);this.setShowSelectedTextContextMenu(false);recordLensOverlayInteraction(INVOCATION_SOURCE,UserAction.kTranslateText)}handleCopyAsImage(event){if(shouldIgnoreKeyboardEvent(event)){return}BrowserProxyImpl.getInstance().handler.copyImage(this.selectedRegionContextMenuBox);this.setShowSelectedRegionContextMenu(false);recordLensOverlayInteraction(INVOCATION_SOURCE,UserAction.kCopyAsImage);this.dispatchEvent(new CustomEvent("copied-as-image",{bubbles:true,composed:true}))}handleSaveAsImage(event){if(shouldIgnoreKeyboardEvent(event)){return}BrowserProxyImpl.getInstance().handler.saveAsImage(this.selectedRegionContextMenuBox);this.setShowSelectedRegionContextMenu(false);recordLensOverlayInteraction(INVOCATION_SOURCE,UserAction.kSaveAsImage)}handlePointerEnterButton(){this.isPointerInside=false;this.isPointerInsideButton=true;this.dispatchEvent(new CustomEvent("set-cursor-tooltip",{bubbles:true,composed:true,detail:{tooltipType:CursorTooltipType.NONE}}))}handlePointerLeaveButton(){this.isPointerInside=true;this.isPointerInsideButton=false;this.dispatchEvent(new CustomEvent("set-cursor-tooltip",{bubbles:true,composed:true,detail:{tooltipType:this.translateModeEnabled?CursorTooltipType.TEXT_HIGHLIGHT:CursorTooltipType.REGION_SEARCH}}))}setShowSelectedTextContextMenu(shouldShow){if(shouldShow&&!this.showSelectedTextContextMenu){recordContextMenuOptionShown(INVOCATION_SOURCE,ContextMenuOption.COPY_TEXT);if(this.showTranslateContextMenuItem){recordContextMenuOptionShown(INVOCATION_SOURCE,ContextMenuOption.TRANSLATE_TEXT)}}this.showSelectedTextContextMenu=shouldShow}setShowSelectedRegionContextMenu(shouldShow){if(shouldShow&&!this.showSelectedRegionContextMenu){if(this.showDetectedTextContextMenuOptions){recordContextMenuOptionShown(INVOCATION_SOURCE,ContextMenuOption.COPY_TEXT_IN_REGION);if(this.showTranslateContextMenuItem){recordContextMenuOptionShown(INVOCATION_SOURCE,ContextMenuOption.TRANSLATE_TEXT_IN_REGION)}}if(!this.suppressCopyAndSaveAsImage){if(this.enableCopyAsImage){recordContextMenuOptionShown(INVOCATION_SOURCE,ContextMenuOption.COPY_AS_IMAGE)}if(this.enableSaveAsImage){recordContextMenuOptionShown(INVOCATION_SOURCE,ContextMenuOption.SAVE_AS_IMAGE)}}}this.showSelectedRegionContextMenu=shouldShow}onInitialFlashAnimationEnd(){if(this.hasInitialFlashAnimationEnded){return}this.hasInitialFlashAnimationEnded=true;this.eventTracker_.remove(this.$.initialFlashScrim,"animationend");this.browserProxy.handler.addBackgroundBlur();this.dispatchEvent(new CustomEvent("initial-flash-animation-end",{bubbles:true,composed:true}));if(!this.disableShimmer&&!this.enableBorderGlow){this.$.overlayShimmerCanvas.startAnimation()}}screenshotDataReceived(screenshotBitmap,isSidePanelOpen){renderScreenshot(this.$.backgroundImageCanvas,screenshotBitmap);this.canvasWidth=window.innerWidth;this.canvasHeight=window.innerHeight;this.isScreenshotRendered=true;if(isSidePanelOpen){this.sidePanelOpened=true;this.isResized=true;this.isInitialSize=false}this.onImageRendered()}onOverlayReshown(screenshotBitmap){clearTimeout(this.backgroundImageFadeOutTimeoutId);renderScreenshot(this.$.backgroundImageCanvas,screenshotBitmap);this.isClosing=false;this.sidePanelOpened=true;this.hideBackgroundImageCanvas=true;this.updateCanvasSize(window.innerWidth,window.innerHeight);this.updateSelectionOverlayRect();this.resizeSelectionCanvases(this.selectionOverlayRect.width,this.selectionOverlayRect.height);afterNextRender(this.$.backgroundImageCanvas,(()=>{this.onFinishReshowOverlay()}))}getOverlayBorderGlow(){if(this.overlayBorderGlow){return this.overlayBorderGlow}this.overlayBorderGlow=this.shadowRoot.querySelector("overlay-border-glow");return this.overlayBorderGlow}onCopyCommand(){this.$.textLayer.onCopyDetectedText(this.detectedTextStartIndex,this.detectedTextEndIndex,this.copyText.bind(this))}updateSelectedRegionContextMenu(data){this.selectedRegionContextMenuX=data.box.box.x-data.box.box.width/2;this.selectedRegionContextMenuY=data.box.box.y+data.box.box.height/2;this.selectedRegionContextMenuBox=data.box;this.detectedTextStartIndex=data.selectionStartIndex;this.detectedTextEndIndex=data.selectionEndIndex;this.showDetectedTextContextMenuOptions=this.detectedTextStartIndex!==-1&&this.detectedTextEndIndex!==-1;this.highlightedText=data.text??this.highlightedText}onNotifyResultsPanelOpened(){assert(!this.sidePanelOpened);recordLensOverlaySelectionCloseButtonShown(INVOCATION_SOURCE);this.sidePanelOpened=true}onCloseButtonClick(){if(!this.closeButtonUsedRecorded){recordLensOverlaySelectionCloseButtonUsed(INVOCATION_SOURCE);this.closeButtonUsedRecorded=true}this.browserProxy.handler.closeRequestedByOverlayCloseButton()}onFinishReshowOverlay(){this.hideBackgroundImageCanvas=false;recordLensOverlaySelectionCloseButtonShown(INVOCATION_SOURCE);this.dispatchEvent(new CustomEvent("on-finish-reshow-overlay",{bubbles:true,composed:true}))}getBoundingRect(){return this.selectionOverlayRect}fetchNewScreenshotForTesting(){ScreenshotBitmapBrowserProxyImpl.getInstance().fetchScreenshot(this.screenshotDataReceived.bind(this))}getShowSelectedRegionContextMenuForTesting(){return this.showSelectedRegionContextMenu}getShowSelectedTextContextMenuForTesting(){return this.showSelectedTextContextMenu}getShowDetectedTextContextMenuOptionsForTesting(){return this.showDetectedTextContextMenuOptions}getSuppressCopyAndSaveAsImageForTesting(){return this.suppressCopyAndSaveAsImage}handleSelectTextForTesting(){this.handleSelectText()}handleTranslateDetectedTextForTesting(){this.handleTranslateDetectedText()}handleCopyForTesting(){this.handleCopy()}handleCopyDetectedTextForTesting(){this.handleCopyDetectedText()}handleTranslateForTesting(){this.handleTranslate()}handleCopyAsImageForTesting(){this.handleCopyAsImage()}handleSaveAsImageForTesting(){this.handleSaveAsImage()}setSearchboxFocusForTesting(isFocused){this.isSearchboxFocused=isFocused}setLanguagePickersOpenForTesting(open){this.areLanguagePickersOpen=open}getHideBackgroundImageCanvasForTesting(){return this.hideBackgroundImageCanvas}}customElements.define(SelectionOverlayElement.is,SelectionOverlayElement);