import { html } from '//resources/lit/v3_0/lit.rollup.js';
export function getHtml() {
    return html `<!--_html_template_start_--><ntp-module-header-v2
    header-text="${this.title}"
    .menuItems="${this.getMenuItems_()}"
    more-actions-text="${this.i18nRecursive('', 'modulesMoreActions', 'modulesDummyLower')}"
    @disable-button-click="${this.onDisableButtonClick_}">
</ntp-module-header-v2>
<div id="moduleContent">
  <cr-grid id="tiles" columns="2">
    ${this.tiles.map(item => html `
      <div class="tile-item" title="${item.label}">
        <img is="cr-auto-img" .autoSrc="${item.imageUrl}"></img>
        <span>${item.value}</span>
      </div>
    `)}
  </cr-grid>
</div>
<!--_html_template_end_-->`;
}
