// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";import{LoadModelResultSpec as onDeviceModel_mojom_LoadModelResultSpec,PerformanceClassSpec as onDeviceModel_mojom_PerformanceClassSpec,OnDeviceModelPendingReceiver as onDeviceModel_mojom_OnDeviceModelPendingReceiver,TextSafetyModelPendingReceiver as onDeviceModel_mojom_TextSafetyModelPendingReceiver,CapabilitiesSpec as onDeviceModel_mojom_CapabilitiesSpec,DeviceInfoSpec as onDeviceModel_mojom_DeviceInfoSpec,DevicePerformanceInfoSpec as onDeviceModel_mojom_DevicePerformanceInfoSpec,SafetyInfoSpec as onDeviceModel_mojom_SafetyInfoSpec}from"./on_device_model.mojom-webui.js";import{FileSpec as mojoBase_mojom_FileSpec,ReadOnlyFileSpec as mojoBase_mojom_ReadOnlyFileSpec}from"//resources/mojo/mojo/public/mojom/base/file.mojom-webui.js";import{FilePathSpec as mojoBase_mojom_FilePathSpec}from"//resources/mojo/mojo/public/mojom/base/file_path.mojom-webui.js";import{UuidSpec as mojoBase_mojom_UuidSpec}from"//resources/mojo/mojo/public/mojom/base/uuid.mojom-webui.js";export const ModelBackendTypeSpec={$:mojo.internal.Enum()};export var ModelBackendType;(function(ModelBackendType){ModelBackendType[ModelBackendType["MIN_VALUE"]=0]="MIN_VALUE";ModelBackendType[ModelBackendType["MAX_VALUE"]=2]="MAX_VALUE";ModelBackendType[ModelBackendType["kGpu"]=0]="kGpu";ModelBackendType[ModelBackendType["kApu"]=1]="kApu";ModelBackendType[ModelBackendType["kCpu"]=2]="kCpu"})(ModelBackendType||(ModelBackendType={}));export const ModelPerformanceHintSpec={$:mojo.internal.Enum()};export var ModelPerformanceHint;(function(ModelPerformanceHint){ModelPerformanceHint[ModelPerformanceHint["MIN_VALUE"]=0]="MIN_VALUE";ModelPerformanceHint[ModelPerformanceHint["MAX_VALUE"]=1]="MAX_VALUE";ModelPerformanceHint[ModelPerformanceHint["kHighestQuality"]=0]="kHighestQuality";ModelPerformanceHint[ModelPerformanceHint["kFastestInference"]=1]="kFastestInference"})(ModelPerformanceHint||(ModelPerformanceHint={}));export const PlatformModelStateSpec={$:mojo.internal.Enum()};export var PlatformModelState;(function(PlatformModelState){PlatformModelState[PlatformModelState["MIN_VALUE"]=0]="MIN_VALUE";PlatformModelState[PlatformModelState["MAX_VALUE"]=9]="MAX_VALUE";PlatformModelState[PlatformModelState["kUnknownState"]=0]="kUnknownState";PlatformModelState[PlatformModelState["kInstalledOnDisk"]=1]="kInstalledOnDisk";PlatformModelState[PlatformModelState["kInvalidUuid"]=2]="kInvalidUuid";PlatformModelState[PlatformModelState["kInvalidDlcClient"]=3]="kInvalidDlcClient";PlatformModelState[PlatformModelState["kInvalidDlcPackage"]=4]="kInvalidDlcPackage";PlatformModelState[PlatformModelState["kInvalidDlcVerifiedState"]=5]="kInvalidDlcVerifiedState";PlatformModelState[PlatformModelState["kInvalidDlcInstall"]=6]="kInvalidDlcInstall";PlatformModelState[PlatformModelState["kInvalidModelFormat"]=7]="kInvalidModelFormat";PlatformModelState[PlatformModelState["kInvalidModelDescriptor"]=8]="kInvalidModelDescriptor";PlatformModelState[PlatformModelState["kInvalidBaseModelDescriptor"]=9]="kInvalidBaseModelDescriptor"})(PlatformModelState||(PlatformModelState={}));export const FormatFeatureSpec={$:mojo.internal.Enum()};export var FormatFeature;(function(FormatFeature){FormatFeature[FormatFeature["MIN_VALUE"]=0]="MIN_VALUE";FormatFeature[FormatFeature["MAX_VALUE"]=3]="MAX_VALUE";FormatFeature[FormatFeature["kNone"]=0]="kNone";FormatFeature[FormatFeature["kPrompt"]=1]="kPrompt";FormatFeature[FormatFeature["kAudioSummary"]=2]="kAudioSummary";FormatFeature[FormatFeature["kAudioTitle"]=3]="kAudioTitle"})(FormatFeature||(FormatFeature={}));export const SafetyFeatureSpec={$:mojo.internal.Enum()};export var SafetyFeature;(function(SafetyFeature){SafetyFeature[SafetyFeature["MIN_VALUE"]=0]="MIN_VALUE";SafetyFeature[SafetyFeature["MAX_VALUE"]=6]="MAX_VALUE";SafetyFeature[SafetyFeature["kGeneral"]=0]="kGeneral";SafetyFeature[SafetyFeature["kAudioSummaryRequest"]=1]="kAudioSummaryRequest";SafetyFeature[SafetyFeature["kAudioTitleRequest"]=2]="kAudioTitleRequest";SafetyFeature[SafetyFeature["kAudioSummaryResponse"]=3]="kAudioSummaryResponse";SafetyFeature[SafetyFeature["kAudioTitleResponse"]=4]="kAudioTitleResponse";SafetyFeature[SafetyFeature["kAudioSummaryResponseV2"]=5]="kAudioSummaryResponseV2";SafetyFeature[SafetyFeature["kAudioTitleResponseV2"]=6]="kAudioTitleResponseV2"})(SafetyFeature||(SafetyFeature={}));export class PlatformModelProgressObserverPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"on_device_model.mojom.PlatformModelProgressObserver",scope)}}export class PlatformModelProgressObserverRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PlatformModelProgressObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}progress(progress){this.proxy.sendMessage(0,PlatformModelProgressObserver_Progress_ParamsSpec.$,null,[progress],false)}}export class PlatformModelProgressObserverReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PlatformModelProgressObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,PlatformModelProgressObserver_Progress_ParamsSpec.$,null,impl.progress.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class PlatformModelProgressObserver{static get $interfaceName(){return"on_device_model.mojom.PlatformModelProgressObserver"}static getRemote(){let remote=new PlatformModelProgressObserverRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class PlatformModelProgressObserverCallbackRouter{helper_internal_;$;router_;progress;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PlatformModelProgressObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.progress=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,PlatformModelProgressObserver_Progress_ParamsSpec.$,null,this.progress.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class OnDeviceModelServicePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"on_device_model.mojom.OnDeviceModelService",scope)}}export class OnDeviceModelServiceRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(OnDeviceModelServicePendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}loadModel(params,model){return this.proxy.sendMessage(0,OnDeviceModelService_LoadModel_ParamsSpec.$,OnDeviceModelService_LoadModel_ResponseParamsSpec.$,[params,model],false)}getCapabilities(weights){return this.proxy.sendMessage(1,OnDeviceModelService_GetCapabilities_ParamsSpec.$,OnDeviceModelService_GetCapabilities_ResponseParamsSpec.$,[weights],false)}loadTextSafetyModel(params,model){this.proxy.sendMessage(2,OnDeviceModelService_LoadTextSafetyModel_ParamsSpec.$,null,[params,model],false)}getDeviceAndPerformanceInfo(){return this.proxy.sendMessage(3,OnDeviceModelService_GetDeviceAndPerformanceInfo_ParamsSpec.$,OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsSpec.$,[],false)}}export class OnDeviceModelServiceReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(OnDeviceModelServiceRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,OnDeviceModelService_LoadModel_ParamsSpec.$,OnDeviceModelService_LoadModel_ResponseParamsSpec.$,impl.loadModel.bind(impl),false);this.helper_internal_.registerHandler(1,OnDeviceModelService_GetCapabilities_ParamsSpec.$,OnDeviceModelService_GetCapabilities_ResponseParamsSpec.$,impl.getCapabilities.bind(impl),false);this.helper_internal_.registerHandler(2,OnDeviceModelService_LoadTextSafetyModel_ParamsSpec.$,null,impl.loadTextSafetyModel.bind(impl),false);this.helper_internal_.registerHandler(3,OnDeviceModelService_GetDeviceAndPerformanceInfo_ParamsSpec.$,OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsSpec.$,impl.getDeviceAndPerformanceInfo.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class OnDeviceModelService{static get $interfaceName(){return"on_device_model.mojom.OnDeviceModelService"}static getRemote(){let remote=new OnDeviceModelServiceRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class OnDeviceModelServiceCallbackRouter{helper_internal_;$;router_;loadModel;getCapabilities;loadTextSafetyModel;getDeviceAndPerformanceInfo;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(OnDeviceModelServiceRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.loadModel=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,OnDeviceModelService_LoadModel_ParamsSpec.$,OnDeviceModelService_LoadModel_ResponseParamsSpec.$,this.loadModel.createReceiverHandler(true),false);this.getCapabilities=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,OnDeviceModelService_GetCapabilities_ParamsSpec.$,OnDeviceModelService_GetCapabilities_ResponseParamsSpec.$,this.getCapabilities.createReceiverHandler(true),false);this.loadTextSafetyModel=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,OnDeviceModelService_LoadTextSafetyModel_ParamsSpec.$,null,this.loadTextSafetyModel.createReceiverHandler(false),false);this.getDeviceAndPerformanceInfo=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,OnDeviceModelService_GetDeviceAndPerformanceInfo_ParamsSpec.$,OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsSpec.$,this.getDeviceAndPerformanceInfo.createReceiverHandler(true),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class OnDeviceModelPlatformServicePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"on_device_model.mojom.OnDeviceModelPlatformService",scope)}}export class OnDeviceModelPlatformServiceRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(OnDeviceModelPlatformServicePendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}loadPlatformModel(uuid,model,progressObserver){return this.proxy.sendMessage(0,OnDeviceModelPlatformService_LoadPlatformModel_ParamsSpec.$,OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsSpec.$,[uuid,model,progressObserver],false)}getPlatformModelState(uuid){return this.proxy.sendMessage(1,OnDeviceModelPlatformService_GetPlatformModelState_ParamsSpec.$,OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsSpec.$,[uuid],false)}getEstimatedPerformanceClass(){return this.proxy.sendMessage(2,OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ParamsSpec.$,OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsSpec.$,[],false)}formatInput(uuid,feature,fields){return this.proxy.sendMessage(3,OnDeviceModelPlatformService_FormatInput_ParamsSpec.$,OnDeviceModelPlatformService_FormatInput_ResponseParamsSpec.$,[uuid,feature,fields],false)}validateSafetyResult(safetyFeature,text,safetyInfo){return this.proxy.sendMessage(4,OnDeviceModelPlatformService_ValidateSafetyResult_ParamsSpec.$,OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsSpec.$,[safetyFeature,text,safetyInfo],false)}}export class OnDeviceModelPlatformServiceReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(OnDeviceModelPlatformServiceRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,OnDeviceModelPlatformService_LoadPlatformModel_ParamsSpec.$,OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsSpec.$,impl.loadPlatformModel.bind(impl),false);this.helper_internal_.registerHandler(1,OnDeviceModelPlatformService_GetPlatformModelState_ParamsSpec.$,OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsSpec.$,impl.getPlatformModelState.bind(impl),false);this.helper_internal_.registerHandler(2,OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ParamsSpec.$,OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsSpec.$,impl.getEstimatedPerformanceClass.bind(impl),false);this.helper_internal_.registerHandler(3,OnDeviceModelPlatformService_FormatInput_ParamsSpec.$,OnDeviceModelPlatformService_FormatInput_ResponseParamsSpec.$,impl.formatInput.bind(impl),false);this.helper_internal_.registerHandler(4,OnDeviceModelPlatformService_ValidateSafetyResult_ParamsSpec.$,OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsSpec.$,impl.validateSafetyResult.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class OnDeviceModelPlatformService{static get $interfaceName(){return"on_device_model.mojom.OnDeviceModelPlatformService"}static getRemote(){let remote=new OnDeviceModelPlatformServiceRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class OnDeviceModelPlatformServiceCallbackRouter{helper_internal_;$;router_;loadPlatformModel;getPlatformModelState;getEstimatedPerformanceClass;formatInput;validateSafetyResult;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(OnDeviceModelPlatformServiceRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.loadPlatformModel=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,OnDeviceModelPlatformService_LoadPlatformModel_ParamsSpec.$,OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsSpec.$,this.loadPlatformModel.createReceiverHandler(true),false);this.getPlatformModelState=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,OnDeviceModelPlatformService_GetPlatformModelState_ParamsSpec.$,OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsSpec.$,this.getPlatformModelState.createReceiverHandler(true),false);this.getEstimatedPerformanceClass=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ParamsSpec.$,OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsSpec.$,this.getEstimatedPerformanceClass.createReceiverHandler(true),false);this.formatInput=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,OnDeviceModelPlatformService_FormatInput_ParamsSpec.$,OnDeviceModelPlatformService_FormatInput_ResponseParamsSpec.$,this.formatInput.createReceiverHandler(true),false);this.validateSafetyResult=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,OnDeviceModelPlatformService_ValidateSafetyResult_ParamsSpec.$,OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsSpec.$,this.validateSafetyResult.createReceiverHandler(true),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const ModelAssetsSpec={$:{}};export const LoadModelParamsSpec={$:{}};export const TextSafetyModelAssetsSpec={$:{}};export const BertSafetyModelAssetsSpec={$:{}};export const LanguageModelAssetsSpec={$:{}};export const TextSafetyModelParamsSpec={$:{}};export const PlatformModelProgressObserver_Progress_ParamsSpec={$:{}};export const OnDeviceModelService_LoadModel_ParamsSpec={$:{}};export const OnDeviceModelService_LoadModel_ResponseParamsSpec={$:{}};export const OnDeviceModelService_GetCapabilities_ParamsSpec={$:{}};export const OnDeviceModelService_GetCapabilities_ResponseParamsSpec={$:{}};export const OnDeviceModelService_LoadTextSafetyModel_ParamsSpec={$:{}};export const OnDeviceModelService_GetDeviceAndPerformanceInfo_ParamsSpec={$:{}};export const OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsSpec={$:{}};export const OnDeviceModelPlatformService_LoadPlatformModel_ParamsSpec={$:{}};export const OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsSpec={$:{}};export const OnDeviceModelPlatformService_GetPlatformModelState_ParamsSpec={$:{}};export const OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsSpec={$:{}};export const OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ParamsSpec={$:{}};export const OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsSpec={$:{}};export const OnDeviceModelPlatformService_FormatInput_ParamsSpec={$:{}};export const OnDeviceModelPlatformService_FormatInput_ResponseParamsSpec={$:{}};export const OnDeviceModelPlatformService_ValidateSafetyResult_ParamsSpec={$:{}};export const OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsSpec={$:{}};export const ModelFileSpec={$:{}};export const SafetyModelAssetsSpec={$:{}};mojo.internal.Struct(ModelAssetsSpec.$,"ModelAssets",[mojo.internal.StructField("weights",0,0,ModelFileSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("spModelPath",16,0,mojoBase_mojom_FilePathSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("cache",24,0,mojoBase_mojom_FileSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("encoderCache",32,0,mojoBase_mojom_FileSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("adapterCache",40,0,mojoBase_mojom_FileSpec.$,null,true,0,undefined,undefined)],[[0,56]]);mojo.internal.Struct(LoadModelParamsSpec.$,"LoadModelParams",[mojo.internal.StructField("backendType",0,0,ModelBackendTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("assets",8,0,ModelAssetsSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("maxTokens",4,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("adaptationRanks",16,0,mojo.internal.Array(mojo.internal.Uint32,false),null,false,0,undefined,undefined),mojo.internal.StructField("performanceHint",24,0,ModelPerformanceHintSpec.$,ModelPerformanceHint.kHighestQuality,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(TextSafetyModelAssetsSpec.$,"TextSafetyModelAssets",[mojo.internal.StructField("data",0,0,mojoBase_mojom_ReadOnlyFileSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("spModel",8,0,mojoBase_mojom_ReadOnlyFileSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(BertSafetyModelAssetsSpec.$,"BertSafetyModelAssets",[mojo.internal.StructField("model",0,0,mojoBase_mojom_ReadOnlyFileSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(LanguageModelAssetsSpec.$,"LanguageModelAssets",[mojo.internal.StructField("model",0,0,mojoBase_mojom_ReadOnlyFileSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(TextSafetyModelParamsSpec.$,"TextSafetyModelParams",[mojo.internal.StructField("safetyAssets",0,0,SafetyModelAssetsSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("languageAssets",16,0,LanguageModelAssetsSpec.$,null,true,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(PlatformModelProgressObserver_Progress_ParamsSpec.$,"PlatformModelProgressObserver_Progress_Params",[mojo.internal.StructField("progress",0,0,mojo.internal.Double,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(OnDeviceModelService_LoadModel_ParamsSpec.$,"OnDeviceModelService_LoadModel_Params",[mojo.internal.StructField("params",0,0,LoadModelParamsSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("model",8,0,mojo.internal.InterfaceRequest(onDeviceModel_mojom_OnDeviceModelPendingReceiver),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(OnDeviceModelService_LoadModel_ResponseParamsSpec.$,"OnDeviceModelService_LoadModel_ResponseParams",[mojo.internal.StructField("result",0,0,onDeviceModel_mojom_LoadModelResultSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(OnDeviceModelService_GetCapabilities_ParamsSpec.$,"OnDeviceModelService_GetCapabilities_Params",[mojo.internal.StructField("weights",0,0,ModelFileSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(OnDeviceModelService_GetCapabilities_ResponseParamsSpec.$,"OnDeviceModelService_GetCapabilities_ResponseParams",[mojo.internal.StructField("capabilities",0,0,onDeviceModel_mojom_CapabilitiesSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(OnDeviceModelService_LoadTextSafetyModel_ParamsSpec.$,"OnDeviceModelService_LoadTextSafetyModel_Params",[mojo.internal.StructField("params",0,0,TextSafetyModelParamsSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("model",8,0,mojo.internal.InterfaceRequest(onDeviceModel_mojom_TextSafetyModelPendingReceiver),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(OnDeviceModelService_GetDeviceAndPerformanceInfo_ParamsSpec.$,"OnDeviceModelService_GetDeviceAndPerformanceInfo_Params",[],[[0,8]]);mojo.internal.Struct(OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsSpec.$,"OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams",[mojo.internal.StructField("performanceInfo",0,0,onDeviceModel_mojom_DevicePerformanceInfoSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("deviceInfo",8,0,onDeviceModel_mojom_DeviceInfoSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(OnDeviceModelPlatformService_LoadPlatformModel_ParamsSpec.$,"OnDeviceModelPlatformService_LoadPlatformModel_Params",[mojo.internal.StructField("uuid",0,0,mojoBase_mojom_UuidSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("model",8,0,mojo.internal.InterfaceRequest(onDeviceModel_mojom_OnDeviceModelPendingReceiver),null,false,0,undefined,undefined),mojo.internal.StructField("progressObserver",12,0,mojo.internal.InterfaceProxy(PlatformModelProgressObserverRemote),null,true,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsSpec.$,"OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams",[mojo.internal.StructField("result",0,0,onDeviceModel_mojom_LoadModelResultSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(OnDeviceModelPlatformService_GetPlatformModelState_ParamsSpec.$,"OnDeviceModelPlatformService_GetPlatformModelState_Params",[mojo.internal.StructField("uuid",0,0,mojoBase_mojom_UuidSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsSpec.$,"OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams",[mojo.internal.StructField("result",0,0,PlatformModelStateSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ParamsSpec.$,"OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params",[],[[0,8]]);mojo.internal.Struct(OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsSpec.$,"OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams",[mojo.internal.StructField("performanceClass",0,0,onDeviceModel_mojom_PerformanceClassSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(OnDeviceModelPlatformService_FormatInput_ParamsSpec.$,"OnDeviceModelPlatformService_FormatInput_Params",[mojo.internal.StructField("uuid",0,0,mojoBase_mojom_UuidSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("feature",8,0,FormatFeatureSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("fields",16,0,mojo.internal.Map(mojo.internal.String,mojo.internal.String,false),null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(OnDeviceModelPlatformService_FormatInput_ResponseParamsSpec.$,"OnDeviceModelPlatformService_FormatInput_ResponseParams",[mojo.internal.StructField("result",0,0,mojo.internal.String,null,true,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(OnDeviceModelPlatformService_ValidateSafetyResult_ParamsSpec.$,"OnDeviceModelPlatformService_ValidateSafetyResult_Params",[mojo.internal.StructField("safetyFeature",0,0,SafetyFeatureSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("text",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("safetyInfo",16,0,onDeviceModel_mojom_SafetyInfoSpec.$,null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsSpec.$,"OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams",[mojo.internal.StructField("result",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Union(ModelFileSpec.$,"ModelFile",{file:{ordinal:0,type:mojoBase_mojom_FileSpec.$},path:{ordinal:1,type:mojoBase_mojom_FilePathSpec.$}});export var ModelFileFieldTags;(function(ModelFileFieldTags){ModelFileFieldTags[ModelFileFieldTags["FILE"]=0]="FILE";ModelFileFieldTags[ModelFileFieldTags["PATH"]=1]="PATH"})(ModelFileFieldTags||(ModelFileFieldTags={}));export function whichModelFile(u){if(u.file!==null&&u.file!==undefined){return ModelFileFieldTags.FILE}if(u.path!==null&&u.path!==undefined){return ModelFileFieldTags.PATH}throw new Error("no union field has been set, this is an illegal state")}mojo.internal.Union(SafetyModelAssetsSpec.$,"SafetyModelAssets",{tsAssets:{ordinal:0,type:TextSafetyModelAssetsSpec.$},bsAssets:{ordinal:1,type:BertSafetyModelAssetsSpec.$}});export var SafetyModelAssetsFieldTags;(function(SafetyModelAssetsFieldTags){SafetyModelAssetsFieldTags[SafetyModelAssetsFieldTags["TS_ASSETS"]=0]="TS_ASSETS";SafetyModelAssetsFieldTags[SafetyModelAssetsFieldTags["BS_ASSETS"]=1]="BS_ASSETS"})(SafetyModelAssetsFieldTags||(SafetyModelAssetsFieldTags={}));export function whichSafetyModelAssets(u){if(u.tsAssets!==null&&u.tsAssets!==undefined){return SafetyModelAssetsFieldTags.TS_ASSETS}if(u.bsAssets!==null&&u.bsAssets!==undefined){return SafetyModelAssetsFieldTags.BS_ASSETS}throw new Error("no union field has been set, this is an illegal state")}