// Copyright 2011 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{css,CrLitElement,html,nothing}from"chrome://resources/lit/v3_0/lit.rollup.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{ZoomBehavior}from"./browser_api.js";import{LoadState}from"./pdf_scripting_api.js";const sheet=new CSSStyleSheet;sheet.replaceSync(`html{--google-blue-50-rgb:232,240,254;--google-blue-50:rgb(var(--google-blue-50-rgb));--google-blue-100-rgb:210,227,252;--google-blue-100:rgb(var(--google-blue-100-rgb));--google-blue-200-rgb:174,203,250;--google-blue-200:rgb(var(--google-blue-200-rgb));--google-blue-300-rgb:138,180,248;--google-blue-300:rgb(var(--google-blue-300-rgb));--google-blue-400-rgb:102,157,246;--google-blue-400:rgb(var(--google-blue-400-rgb));--google-blue-500-rgb:66,133,244;--google-blue-500:rgb(var(--google-blue-500-rgb));--google-blue-600-rgb:26,115,232;--google-blue-600:rgb(var(--google-blue-600-rgb));--google-blue-700-rgb:25,103,210;--google-blue-700:rgb(var(--google-blue-700-rgb));--google-blue-800-rgb:24,90,188;--google-blue-800:rgb(var(--google-blue-800-rgb));--google-blue-900-rgb:23,78,166;--google-blue-900:rgb(var(--google-blue-900-rgb));--google-green-50-rgb:230,244,234;--google-green-50:rgb(var(--google-green-50-rgb));--google-green-200-rgb:168,218,181;--google-green-200:rgb(var(--google-green-200-rgb));--google-green-300-rgb:129,201,149;--google-green-300:rgb(var(--google-green-300-rgb));--google-green-400-rgb:91,185,116;--google-green-400:rgb(var(--google-green-400-rgb));--google-green-500-rgb:52,168,83;--google-green-500:rgb(var(--google-green-500-rgb));--google-green-600-rgb:30,142,62;--google-green-600:rgb(var(--google-green-600-rgb));--google-green-700-rgb:24,128,56;--google-green-700:rgb(var(--google-green-700-rgb));--google-green-800-rgb:19,115,51;--google-green-800:rgb(var(--google-green-800-rgb));--google-green-900-rgb:13,101,45;--google-green-900:rgb(var(--google-green-900-rgb));--google-grey-50-rgb:248,249,250;--google-grey-50:rgb(var(--google-grey-50-rgb));--google-grey-100-rgb:241,243,244;--google-grey-100:rgb(var(--google-grey-100-rgb));--google-grey-200-rgb:232,234,237;--google-grey-200:rgb(var(--google-grey-200-rgb));--google-grey-300-rgb:218,220,224;--google-grey-300:rgb(var(--google-grey-300-rgb));--google-grey-400-rgb:189,193,198;--google-grey-400:rgb(var(--google-grey-400-rgb));--google-grey-500-rgb:154,160,166;--google-grey-500:rgb(var(--google-grey-500-rgb));--google-grey-600-rgb:128,134,139;--google-grey-600:rgb(var(--google-grey-600-rgb));--google-grey-700-rgb:95,99,104;--google-grey-700:rgb(var(--google-grey-700-rgb));--google-grey-800-rgb:60,64,67;--google-grey-800:rgb(var(--google-grey-800-rgb));--google-grey-900-rgb:32,33,36;--google-grey-900:rgb(var(--google-grey-900-rgb));--google-grey-900-white-4-percent:#292a2d;--google-purple-200-rgb:215,174,251;--google-purple-200:rgb(var(--google-purple-200-rgb));--google-purple-900-rgb:104,29,168;--google-purple-900:rgb(var(--google-purple-900-rgb));--google-red-100-rgb:244,199,195;--google-red-100:rgb(var(--google-red-100-rgb));--google-red-300-rgb:242,139,130;--google-red-300:rgb(var(--google-red-300-rgb));--google-red-500-rgb:234,67,53;--google-red-500:rgb(var(--google-red-500-rgb));--google-red-600-rgb:217,48,37;--google-red-600:rgb(var(--google-red-600-rgb));--google-red-700-rgb:197,57,41;--google-red-700:rgb(var(--google-red-700-rgb));--google-yellow-50-rgb:254,247,224;--google-yellow-50:rgb(var(--google-yellow-50-rgb));--google-yellow-100-rgb:254,239,195;--google-yellow-100:rgb(var(--google-yellow-100-rgb));--google-yellow-200-rgb:253,226,147;--google-yellow-200:rgb(var(--google-yellow-200-rgb));--google-yellow-300-rgb:253,214,51;--google-yellow-300:rgb(var(--google-yellow-300-rgb));--google-yellow-400-rgb:252,201,52;--google-yellow-400:rgb(var(--google-yellow-400-rgb));--google-yellow-500-rgb:251,188,4;--google-yellow-500:rgb(var(--google-yellow-500-rgb));--google-yellow-700-rgb:240,147,0;--google-yellow-700:rgb(var(--google-yellow-700-rgb));--cr-card-background-color:white;--cr-shadow-key-color_:color-mix(in srgb,var(--cr-shadow-color) 30%,transparent);--cr-shadow-ambient-color_:color-mix(in srgb,var(--cr-shadow-color) 15%,transparent);--cr-elevation-1:var(--cr-shadow-key-color_) 0 1px 2px 0,var(--cr-shadow-ambient-color_) 0 1px 3px 1px;--cr-elevation-2:var(--cr-shadow-key-color_) 0 1px 2px 0,var(--cr-shadow-ambient-color_) 0 2px 6px 2px;--cr-elevation-3:var(--cr-shadow-key-color_) 0 1px 3px 0,var(--cr-shadow-ambient-color_) 0 4px 8px 3px;--cr-elevation-4:var(--cr-shadow-key-color_) 0 2px 3px 0,var(--cr-shadow-ambient-color_) 0 6px 10px 4px;--cr-elevation-5:var(--cr-shadow-key-color_) 0 4px 4px 0,var(--cr-shadow-ambient-color_) 0 8px 12px 6px;--cr-card-shadow:var(--cr-elevation-2);--cr-focused-item-color:var(--google-grey-300);--cr-form-field-label-color:var(--google-grey-700);--cr-hairline-rgb:0,0,0;--cr-iph-anchor-highlight-color:rgba(var(--google-blue-600-rgb),0.1);--cr-menu-background-color:white;--cr-menu-background-focus-color:var(--google-grey-400);--cr-menu-shadow:var(--cr-elevation-2);--cr-separator-color:rgba(0,0,0,.06);--cr-title-text-color:rgb(90,90,90);--cr-scrollable-border-color:var(--google-grey-300)}@media (prefers-color-scheme:dark){html{--cr-card-background-color:var(--google-grey-900-white-4-percent);--cr-focused-item-color:var(--google-grey-800);--cr-form-field-label-color:var(--dark-secondary-color);--cr-hairline-rgb:255,255,255;--cr-iph-anchor-highlight-color:rgba(var(--google-grey-100-rgb),0.1);--cr-menu-background-color:var(--google-grey-900);--cr-menu-background-focus-color:var(--google-grey-700);--cr-menu-background-sheen:rgba(255,255,255,.06);--cr-menu-shadow:rgba(0,0,0,.3) 0 1px 2px 0,rgba(0,0,0,.15) 0 3px 6px 2px;--cr-separator-color:rgba(255,255,255,.1);--cr-title-text-color:var(--cr-primary-text-color);--cr-scrollable-border-color:var(--google-grey-700)}}@media (forced-colors:active){html{--cr-focus-outline-hcm:2px solid transparent;--cr-border-hcm:2px solid transparent}}html{--cr-button-edge-spacing:12px;--cr-controlled-by-spacing:24px;--cr-default-input-max-width:264px;--cr-icon-ripple-size:36px;--cr-icon-ripple-padding:8px;--cr-icon-size:20px;--cr-icon-button-margin-start:16px;--cr-icon-ripple-margin:calc(var(--cr-icon-ripple-padding) * -1);--cr-section-min-height:48px;--cr-section-two-line-min-height:64px;--cr-section-padding:20px;--cr-section-vertical-padding:12px;--cr-section-indent-width:40px;--cr-section-indent-padding:calc(var(--cr-section-padding) + var(--cr-section-indent-width));--cr-section-vertical-margin:21px;--cr-centered-card-max-width:680px;--cr-centered-card-width-percentage:0.96;--cr-hairline:1px solid rgba(var(--cr-hairline-rgb),.14);--cr-separator-height:1px;--cr-separator-line:var(--cr-separator-height) solid var(--cr-separator-color);--cr-toolbar-overlay-animation-duration:150ms;--cr-toolbar-height:56px;--cr-container-shadow-height:6px;--cr-container-shadow-margin:calc(-1 * var(--cr-container-shadow-height));--cr-container-shadow-max-opacity:1;--cr-card-border-radius:8px;--cr-disabled-opacity:.38;--cr-form-field-bottom-spacing:16px;--cr-form-field-label-font-size:.625rem;--cr-form-field-label-height:1em;--cr-form-field-label-line-height:1}html{--cr-fallback-color-outline:rgb(116,119,117);--cr-fallback-color-primary:rgb(11,87,208);--cr-fallback-color-on-primary:rgb(255,255,255);--cr-fallback-color-primary-container:rgb(211,227,253);--cr-fallback-color-on-primary-container:rgb(4,30,73);--cr-fallback-color-secondary-container:rgb(194,231,255);--cr-fallback-color-on-secondary-container:rgb(0,29,53);--cr-fallback-color-neutral-container:rgb(242,242,242);--cr-fallback-color-neutral-outline:rgb(199,199,199);--cr-fallback-color-surface:rgb(255,255,255);--cr-fallback-color-surface1:rgb(248,250,253);--cr-fallback-color-surface2:rgb(243,246,252);--cr-fallback-color-surface3:rgb(239,243,250);--cr-fallback-color-on-surface-rgb:31,31,31;--cr-fallback-color-on-surface:rgb(var(--cr-fallback-color-on-surface-rgb));--cr-fallback-color-surface-variant:rgb(225,227,225);--cr-fallback-color-on-surface-variant:rgb(68,71,70);--cr-fallback-color-on-surface-subtle:rgb(71,71,71);--cr-fallback-color-inverse-primary:rgb(168,199,250);--cr-fallback-color-inverse-surface:rgb(48,48,48);--cr-fallback-color-inverse-on-surface:rgb(242,242,242);--cr-fallback-color-tonal-container:rgb(211,227,253);--cr-fallback-color-on-tonal-container:rgb(4,30,73);--cr-fallback-color-tonal-outline:rgb(168,199,250);--cr-fallback-color-error:rgb(179,38,30);--cr-fallback-color-divider:rgb(211,227,253);--cr-fallback-color-state-hover-on-prominent_:rgba(253,252,251,.1);--cr-fallback-color-state-on-subtle-rgb_:31,31,31;--cr-fallback-color-state-hover-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.06);--cr-fallback-color-state-ripple-neutral-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.08);--cr-fallback-color-state-ripple-primary-rgb_:124,172,248;--cr-fallback-color-state-ripple-primary_:rgba(var(--cr-fallback-color-state-ripple-primary-rgb_),0.32);--cr-fallback-color-base-container:rgb(236,239,247);--cr-fallback-color-disabled-background:rgba(var(--cr-fallback-color-on-surface-rgb),.12);--cr-fallback-color-disabled-foreground:rgba(var(--cr-fallback-color-on-surface-rgb),var(--cr-disabled-opacity));--cr-hover-background-color:var(--color-sys-state-hover,rgba(var(--cr-fallback-color-on-surface-rgb),.08));--cr-hover-on-prominent-background-color:var(--color-sys-state-hover-on-prominent,var(--cr-fallback-color-state-hover-on-prominent_));--cr-hover-on-subtle-background-color:var(--color-sys-state-hover-on-subtle,var(--cr-fallback-color-state-hover-on-subtle_));--cr-active-background-color:var(--color-sys-state-pressed,rgba(var(--cr-fallback-color-on-surface-rgb),.12));--cr-active-on-primary-background-color:var(--color-sys-state-ripple-primary,var(--cr-fallback-color-state-ripple-primary_));--cr-active-neutral-on-subtle-background-color:var(--color-sys-state-ripple-neutral-on-subtle,var(--cr-fallback-color-state-ripple-neutral-on-subtle_));--cr-focus-outline-color:var(--color-sys-state-focus-ring,var(--cr-fallback-color-primary));--cr-focus-outline-inverse-color:var(--color-sys-state-focus-ring-inverse,var(--cr-fallback-color-inverse-primary));--cr-primary-text-color:var(--color-primary-foreground,var(--cr-fallback-color-on-surface));--cr-secondary-text-color:var(--color-secondary-foreground,var(--cr-fallback-color-on-surface-variant));--cr-link-color:var(--color-link-foreground-default,var(--cr-fallback-color-primary));--cr-button-height:36px;--cr-shadow-color:var(--color-sys-shadow,rgb(0,0,0));--cr-checked-color:var(--color-checkbox-foreground-checked,var(--cr-fallback-color-primary))}@media (prefers-color-scheme:dark){html{--cr-fallback-color-outline:rgb(142,145,143);--cr-fallback-color-primary:rgb(168,199,250);--cr-fallback-color-on-primary:rgb(6,46,111);--cr-fallback-color-primary-container:rgb(8,66,160);--cr-fallback-color-on-primary-container:rgb(211,227,253);--cr-fallback-color-secondary-container:rgb(0,74,119);--cr-fallback-color-on-secondary-container:rgb(194,231,255);--cr-fallback-color-neutral-container:rgb(40,40,40);--cr-fallback-color-neutral-outline:rgb(117,117,117);--cr-fallback-color-surface:rgb(31,31,31);--cr-fallback-color-surface1:rgb(39,40,42);--cr-fallback-color-surface2:rgb(45,47,49);--cr-fallback-color-surface3:rgb(51,52,56);--cr-fallback-color-on-surface-rgb:227,227,227;--cr-fallback-color-surface-variant:rgb(68,71,70);--cr-fallback-color-on-surface-variant:rgb(196,199,197);--cr-fallback-color-on-surface-subtle:rgb(199,199,199);--cr-fallback-color-inverse-primary:rgb(11,87,208);--cr-fallback-color-inverse-surface:rgb(227,227,227);--cr-fallback-color-inverse-on-surface:rgb(31,31,31);--cr-fallback-color-tonal-container:rgb(0,74,119);--cr-fallback-color-on-tonal-container:rgb(194,231,255);--cr-fallback-color-tonal-outline:rgb(4,125,183);--cr-fallback-color-error:rgb(242,184,181);--cr-fallback-color-divider:rgb(94,94,94);--cr-fallback-color-state-hover-on-prominent_:rgba(31,31,31,.06);--cr-fallback-color-state-on-subtle-rgb_:253,252,251;--cr-fallback-color-state-hover-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.10);--cr-fallback-color-state-ripple-neutral-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.16);--cr-fallback-color-state-ripple-primary-rgb_:76,141,246;--cr-fallback-color-base-container:rgba(40,40,40,1)}}@media (forced-colors:active){html{--cr-fallback-color-disabled-background:Canvas;--cr-fallback-color-disabled-foreground:GrayText}}`);document.adoptedStyleSheets=[...document.adoptedStyleSheets,sheet];function assert(value,message){if(value){return}throw new Error("Assertion failed"+(message?`: ${message}`:""))}function assertInstanceof(value,type,message){if(value instanceof type){return}throw new Error(`Value ${value} is not of type ${type.name||typeof type}`)}function assertNotReached(message="Unreachable code hit"){assert(false,message)}const CLASS_NAME="focus-outline-visible";const docsToManager=new Map;class FocusOutlineManager{focusByKeyboard_=true;classList_;constructor(doc){this.classList_=doc.documentElement.classList;doc.addEventListener("keydown",(e=>this.onEvent_(true,e)),true);doc.addEventListener("mousedown",(e=>this.onEvent_(false,e)),true);this.updateVisibility()}onEvent_(focusByKeyboard,e){if(this.focusByKeyboard_===focusByKeyboard){return}if(e instanceof KeyboardEvent&&e.repeat){return}this.focusByKeyboard_=focusByKeyboard;this.updateVisibility()}updateVisibility(){this.visible=this.focusByKeyboard_}set visible(visible){this.classList_.toggle(CLASS_NAME,visible)}get visible(){return this.classList_.contains(CLASS_NAME)}static forDocument(doc){let manager=docsToManager.get(doc);if(!manager){manager=new FocusOutlineManager(doc);docsToManager.set(doc,manager)}return manager}}class EventTracker{listeners_=[];add(target,eventType,listener,capture=false){const h={target:target,eventType:eventType,listener:listener,capture:capture};this.listeners_.push(h);target.addEventListener(eventType,listener,capture)}remove(target,eventType){this.listeners_=this.listeners_.filter((listener=>{if(listener.target===target&&(!eventType||listener.eventType===eventType)){EventTracker.removeEventListener(listener);return false}return true}))}removeAll(){this.listeners_.forEach((listener=>EventTracker.removeEventListener(listener)));this.listeners_=[]}static removeEventListener(entry){entry.target.removeEventListener(entry.eventType,entry.listener,entry.capture)}}function getDeepActiveElement(){let a=document.activeElement;while(a&&a.shadowRoot&&a.shadowRoot.activeElement){a=a.shadowRoot.activeElement}return a}function isRTL(){return document.documentElement.dir==="rtl"}function listenOnce(target,eventNames,callback){const eventNamesArray=Array.isArray(eventNames)?eventNames:eventNames.split(/ +/);const removeAllAndCallCallback=function(event){eventNamesArray.forEach((function(eventName){target.removeEventListener(eventName,removeAllAndCallCallback,false)}));return callback(event)};eventNamesArray.forEach((function(eventName){target.addEventListener(eventName,removeAllAndCallCallback,false)}))}function hasKeyModifiers(e){return!!(e.altKey||e.ctrlKey||e.metaKey||e.shiftKey)}let instance$a=null;function getCss$9(){return instance$a||(instance$a=[...[],css`[hidden],:host([hidden]){display:none !important}`])}let instance$9=null;function getCss$8(){return instance$9||(instance$9=[...[getCss$9()],css`:host{align-items:center;display:inline-flex;justify-content:center;position:relative;vertical-align:middle;fill:var(--iron-icon-fill-color,currentcolor);stroke:var(--iron-icon-stroke-color,none);width:var(--iron-icon-width,24px);height:var(--iron-icon-height,24px)}`])}let iconsetMap=null;class IconsetMap extends EventTarget{iconsets_=new Map;static getInstance(){return iconsetMap||(iconsetMap=new IconsetMap)}static resetInstanceForTesting(instance){iconsetMap=instance}get(id){return this.iconsets_.get(id)||null}set(id,iconset){assert(!this.iconsets_.has(id),`Tried to add a second iconset with id '${id}'`);this.iconsets_.set(id,iconset);this.dispatchEvent(new CustomEvent("cr-iconset-added",{detail:id}))}}class CrIconElement extends CrLitElement{static get is(){return"cr-icon"}static get styles(){return getCss$8()}static get properties(){return{icon:{type:String}}}#icon_accessor_storage="";get icon(){return this.#icon_accessor_storage}set icon(value){this.#icon_accessor_storage=value}iconsetName_="";iconName_="";iconset_=null;updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("icon")){const[iconsetName,iconName]=this.icon.split(":");this.iconName_=iconName||"";this.iconsetName_=iconsetName||"";this.updateIcon_()}}updateIcon_(){if(this.iconName_===""&&this.iconset_){this.iconset_.removeIcon(this)}else if(this.iconsetName_){const iconsetMap=IconsetMap.getInstance();this.iconset_=iconsetMap.get(this.iconsetName_);assert(this.iconset_,`Could not find iconset for: '${this.iconsetName_}:${this.iconName_}'`);this.iconset_.applyIcon(this,this.iconName_)}}}customElements.define(CrIconElement.is,CrIconElement);let instance$8=null;function getCss$7(){return instance$8||(instance$8=[...[],css`:host{bottom:0;display:block;left:0;overflow:hidden;pointer-events:none;position:absolute;right:0;top:0;transform:translate3d(0,0,0)}.ripple{background-color:currentcolor;left:0;opacity:var(--paper-ripple-opacity,0.25);pointer-events:none;position:absolute;will-change:height,transform,width}.ripple,:host(.circle){border-radius:50%}`])}const MAX_RADIUS_PX=300;const MIN_DURATION_MS=800;function distance$1(x1,y1,x2,y2){const xDelta=x1-x2;const yDelta=y1-y2;return Math.sqrt(xDelta*xDelta+yDelta*yDelta)}class CrRippleElement extends CrLitElement{static get is(){return"cr-ripple"}static get styles(){return getCss$7()}static get properties(){return{holdDown:{type:Boolean},recenters:{type:Boolean},noink:{type:Boolean}}}#holdDown_accessor_storage=false;get holdDown(){return this.#holdDown_accessor_storage}set holdDown(value){this.#holdDown_accessor_storage=value}#recenters_accessor_storage=false;get recenters(){return this.#recenters_accessor_storage}set recenters(value){this.#recenters_accessor_storage=value}#noink_accessor_storage=false;get noink(){return this.#noink_accessor_storage}set noink(value){this.#noink_accessor_storage=value}ripples_=[];eventTracker_=new EventTracker;connectedCallback(){super.connectedCallback();assert(this.parentNode);const keyEventTarget=this.parentNode.nodeType===Node.DOCUMENT_FRAGMENT_NODE?this.parentNode.host:this.parentElement;this.eventTracker_.add(keyEventTarget,"pointerdown",(e=>this.uiDownAction(e)));this.eventTracker_.add(keyEventTarget,"pointerup",(()=>this.uiUpAction()));this.eventTracker_.add(keyEventTarget,"pointerout",(()=>this.uiUpAction()));this.eventTracker_.add(keyEventTarget,"keydown",(e=>{if(e.defaultPrevented){return}if(e.key==="Enter"){this.onEnterKeydown_();return}if(e.key===" "){this.onSpaceKeydown_()}}));this.eventTracker_.add(keyEventTarget,"keyup",(e=>{if(e.defaultPrevented){return}if(e.key===" "){this.onSpaceKeyup_()}}))}disconnectedCallback(){super.disconnectedCallback();this.eventTracker_.removeAll()}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("holdDown")){this.holdDownChanged_(this.holdDown,changedProperties.get("holdDown"))}}uiDownAction(e){if(e!==undefined&&e.button!==0){return}if(!this.noink){this.downAction_(e)}}downAction_(e){if(this.ripples_.length&&this.holdDown){return}this.showRipple_(e)}clear(){this.hideRipple_();this.holdDown=false}showAndHoldDown(){this.ripples_.forEach((ripple=>{ripple.remove()}));this.ripples_=[];this.holdDown=true}showRipple_(e){const rect=this.getBoundingClientRect();const roundedCenterX=function(){return Math.round(rect.width/2)};const roundedCenterY=function(){return Math.round(rect.height/2)};let x=0;let y=0;const centered=!e;if(centered){x=roundedCenterX();y=roundedCenterY()}else{x=Math.round(e.clientX-rect.left);y=Math.round(e.clientY-rect.top)}const corners=[{x:0,y:0},{x:rect.width,y:0},{x:0,y:rect.height},{x:rect.width,y:rect.height}];const cornerDistances=corners.map((function(corner){return Math.round(distance$1(x,y,corner.x,corner.y))}));const radius=Math.min(MAX_RADIUS_PX,Math.max.apply(Math,cornerDistances));const startTranslate=`${x-radius}px, ${y-radius}px`;let endTranslate=startTranslate;if(this.recenters&&!centered){endTranslate=`${roundedCenterX()-radius}px, ${roundedCenterY()-radius}px`}const ripple=document.createElement("div");ripple.classList.add("ripple");ripple.style.height=ripple.style.width=2*radius+"px";this.ripples_.push(ripple);this.shadowRoot.appendChild(ripple);ripple.animate({transform:[`translate(${startTranslate}) scale(0)`,`translate(${endTranslate}) scale(1)`]},{duration:Math.max(MIN_DURATION_MS,Math.log(radius)*radius)||0,easing:"cubic-bezier(.2, .9, .1, .9)",fill:"forwards"})}uiUpAction(){if(!this.noink){this.upAction_()}}upAction_(){if(!this.holdDown){this.hideRipple_()}}hideRipple_(){if(this.ripples_.length===0){return}this.ripples_.forEach((function(ripple){const opacity=ripple.computedStyleMap().get("opacity");if(opacity===null){ripple.remove();return}const animation=ripple.animate({opacity:[opacity.value,0]},{duration:150,fill:"forwards"});animation.finished.then((()=>{ripple.remove()}))}));this.ripples_=[]}onEnterKeydown_(){this.uiDownAction();window.setTimeout((()=>{this.uiUpAction()}),1)}onSpaceKeydown_(){this.uiDownAction()}onSpaceKeyup_(){this.uiUpAction()}holdDownChanged_(newHoldDown,oldHoldDown){if(oldHoldDown===undefined){return}if(newHoldDown){this.downAction_()}else{this.upAction_()}}}customElements.define(CrRippleElement.is,CrRippleElement);const CrRippleMixin=superClass=>{class CrRippleMixin extends superClass{static get properties(){return{noink:{type:Boolean}}}#noink_accessor_storage=false;get noink(){return this.#noink_accessor_storage}set noink(value){this.#noink_accessor_storage=value}rippleContainer=null;ripple_=null;updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("noink")&&this.hasRipple()){assert(this.ripple_);this.ripple_.noink=this.noink}}ensureRippleOnPointerdown(){this.addEventListener("pointerdown",(()=>this.ensureRipple()),{capture:true})}ensureRipple(){if(this.hasRipple()){return}this.ripple_=this.createRipple();this.ripple_.noink=this.noink;const rippleContainer=this.rippleContainer||this.shadowRoot;assert(rippleContainer);rippleContainer.appendChild(this.ripple_)}getRipple(){this.ensureRipple();assert(this.ripple_);return this.ripple_}hasRipple(){return Boolean(this.ripple_)}createRipple(){const ripple=document.createElement("cr-ripple");ripple.id="ink";return ripple}}return CrRippleMixin};let instance$7=null;function getCss$6(){return instance$7||(instance$7=[...[],css`:host{--cr-icon-button-fill-color:currentColor;--cr-icon-button-icon-start-offset:0;--cr-icon-button-icon-size:20px;--cr-icon-button-size:32px;--cr-icon-button-height:var(--cr-icon-button-size);--cr-icon-button-transition:150ms ease-in-out;--cr-icon-button-width:var(--cr-icon-button-size);-webkit-tap-highlight-color:transparent;border-radius:50%;color:var(--cr-icon-button-stroke-color,var(--cr-icon-button-fill-color));cursor:pointer;display:inline-flex;flex-shrink:0;height:var(--cr-icon-button-height);margin-inline-end:var(--cr-icon-button-margin-end,var(--cr-icon-ripple-margin));margin-inline-start:var(--cr-icon-button-margin-start);outline:none;overflow:hidden;position:relative;user-select:none;vertical-align:middle;width:var(--cr-icon-button-width)}:host(:hover){background-color:var(--cr-icon-button-hover-background-color,var(--cr-hover-background-color))}:host(:focus-visible:focus){box-shadow:inset 0 0 0 2px var(--cr-icon-button-focus-outline-color,var(--cr-focus-outline-color))}@media (forced-colors:active){:host(:focus-visible:focus){outline:var(--cr-focus-outline-hcm)}}#ink{--paper-ripple-opacity:1;color:var(--cr-icon-button-active-background-color,var(--cr-active-background-color))}:host([disabled]){cursor:initial;opacity:var(--cr-disabled-opacity);pointer-events:none}:host(.no-overlap){--cr-icon-button-margin-end:0;--cr-icon-button-margin-start:0}:host-context([dir=rtl]):host(:not([suppress-rtl-flip]):not([multiple-icons_])){transform:scaleX(-1)}:host-context([dir=rtl]):host(:not([suppress-rtl-flip])[multiple-icons_]) cr-icon{transform:scaleX(-1)}:host(:not([iron-icon])) #maskedImage{-webkit-mask-image:var(--cr-icon-image);-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-icon-button-icon-size);-webkit-transform:var(--cr-icon-image-transform,none);background-color:var(--cr-icon-button-fill-color);height:100%;transition:background-color var(--cr-icon-button-transition);width:100%}@media (forced-colors:active){:host(:not([iron-icon])) #maskedImage{background-color:ButtonText}}#icon{align-items:center;border-radius:4px;display:flex;height:100%;justify-content:center;padding-inline-start:var(--cr-icon-button-icon-start-offset);position:relative;width:100%}cr-icon{--iron-icon-fill-color:var(--cr-icon-button-fill-color);--iron-icon-stroke-color:var(--cr-icon-button-stroke-color,none);--iron-icon-height:var(--cr-icon-button-icon-size);--iron-icon-width:var(--cr-icon-button-icon-size);transition:fill var(--cr-icon-button-transition),stroke var(--cr-icon-button-transition)}@media (prefers-color-scheme:dark){:host{--cr-icon-button-fill-color:var(--google-grey-500)}}`])}function getHtml$4(){return html`
<div id="icon">
  <div id="maskedImage"></div>
</div>`}const CrIconbuttonElementBase=CrRippleMixin(CrLitElement);class CrIconButtonElement extends CrIconbuttonElementBase{static get is(){return"cr-icon-button"}static get styles(){return getCss$6()}render(){return getHtml$4.bind(this)()}static get properties(){return{disabled:{type:Boolean,reflect:true},ironIcon:{type:String,reflect:true},suppressRtlFlip:{type:Boolean,value:false,reflect:true},multipleIcons_:{type:Boolean,reflect:true}}}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#ironIcon_accessor_storage;get ironIcon(){return this.#ironIcon_accessor_storage}set ironIcon(value){this.#ironIcon_accessor_storage=value}#multipleIcons__accessor_storage=false;get multipleIcons_(){return this.#multipleIcons__accessor_storage}set multipleIcons_(value){this.#multipleIcons__accessor_storage=value}spaceKeyDown_=false;constructor(){super();this.addEventListener("blur",this.onBlur_.bind(this));this.addEventListener("click",this.onClick_.bind(this));this.addEventListener("keydown",this.onKeyDown_.bind(this));this.addEventListener("keyup",this.onKeyUp_.bind(this));this.ensureRippleOnPointerdown()}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("ironIcon")){const icons=(this.ironIcon||"").split(",");this.multipleIcons_=icons.length>1}}firstUpdated(){if(!this.hasAttribute("role")){this.setAttribute("role","button")}if(!this.hasAttribute("tabindex")){this.setAttribute("tabindex","0")}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("disabled")){this.setAttribute("aria-disabled",this.disabled?"true":"false");this.disabledChanged_(this.disabled,changedProperties.get("disabled"))}if(changedProperties.has("ironIcon")){this.onIronIconChanged_()}}disabledChanged_(newValue,oldValue){if(!newValue&&oldValue===undefined){return}if(this.disabled){this.blur()}this.setAttribute("tabindex",String(this.disabled?-1:0))}onBlur_(){this.spaceKeyDown_=false}onClick_(e){if(this.disabled){e.stopImmediatePropagation()}}onIronIconChanged_(){this.shadowRoot.querySelectorAll("cr-icon").forEach((el=>el.remove()));if(!this.ironIcon){return}const icons=(this.ironIcon||"").split(",");icons.forEach((async icon=>{const crIcon=document.createElement("cr-icon");crIcon.icon=icon;this.$.icon.appendChild(crIcon);await crIcon.updateComplete;crIcon.shadowRoot.querySelectorAll("svg, img").forEach((child=>child.setAttribute("role","none")))}))}onKeyDown_(e){if(e.key!==" "&&e.key!=="Enter"){return}e.preventDefault();e.stopPropagation();if(e.repeat){return}if(e.key==="Enter"){this.click()}else if(e.key===" "){this.spaceKeyDown_=true}}onKeyUp_(e){if(e.key===" "||e.key==="Enter"){e.preventDefault();e.stopPropagation()}if(this.spaceKeyDown_&&e.key===" "){this.spaceKeyDown_=false;this.click()}}}customElements.define(CrIconButtonElement.is,CrIconButtonElement);var AnnotationMode;(function(AnnotationMode){AnnotationMode["OFF"]="off";AnnotationMode["DRAW"]="draw";AnnotationMode["TEXT"]="text"})(AnnotationMode||(AnnotationMode={}));var AnnotationBrushType;(function(AnnotationBrushType){AnnotationBrushType["ERASER"]="eraser";AnnotationBrushType["HIGHLIGHTER"]="highlighter";AnnotationBrushType["PEN"]="pen"})(AnnotationBrushType||(AnnotationBrushType={}));var TextAlignment;(function(TextAlignment){TextAlignment["LEFT"]="left";TextAlignment["CENTER"]="center";TextAlignment["RIGHT"]="right"})(TextAlignment||(TextAlignment={}));var TextStyle;(function(TextStyle){TextStyle["BOLD"]="bold";TextStyle["ITALIC"]="italic"})(TextStyle||(TextStyle={}));var TextTypeface;(function(TextTypeface){TextTypeface["SANS_SERIF"]="sans-serif";TextTypeface["SERIF"]="serif";TextTypeface["MONOSPACE"]="monospace"})(TextTypeface||(TextTypeface={}));var DisplayAnnotationsAction;(function(DisplayAnnotationsAction){DisplayAnnotationsAction["DISPLAY_ANNOTATIONS"]="display-annotations";DisplayAnnotationsAction["HIDE_ANNOTATIONS"]="hide-annotations"})(DisplayAnnotationsAction||(DisplayAnnotationsAction={}));var FittingType;(function(FittingType){FittingType["NONE"]="none";FittingType["FIT_TO_PAGE"]="fit-to-page";FittingType["FIT_TO_WIDTH"]="fit-to-width";FittingType["FIT_TO_HEIGHT"]="fit-to-height";FittingType["FIT_TO_BOUNDING_BOX"]="fit-to-bounding-box";FittingType["FIT_TO_BOUNDING_BOX_WIDTH"]="fit-to-bounding-box-width";FittingType["FIT_TO_BOUNDING_BOX_HEIGHT"]="fit-to-bounding-box-height"})(FittingType||(FittingType={}));var FormFieldFocusType;(function(FormFieldFocusType){FormFieldFocusType["NONE"]="none";FormFieldFocusType["NON_TEXT"]="non-text";FormFieldFocusType["TEXT"]="text"})(FormFieldFocusType||(FormFieldFocusType={}));var SaveToDriveState;(function(SaveToDriveState){SaveToDriveState["UNINITIALIZED"]="uninitialized";SaveToDriveState["UPLOADING"]="uploading";SaveToDriveState["SUCCESS"]="success";SaveToDriveState["CONNECTION_ERROR"]="connection-error";SaveToDriveState["STORAGE_FULL_ERROR"]="storage-full-error";SaveToDriveState["SESSION_TIMEOUT_ERROR"]="session-timeout-error";SaveToDriveState["UNKNOWN_ERROR"]="unknown-error"})(SaveToDriveState||(SaveToDriveState={}));var SaveToDriveBubbleRequestType;(function(SaveToDriveBubbleRequestType){SaveToDriveBubbleRequestType["CANCEL_UPLOAD"]="cancel-upload";SaveToDriveBubbleRequestType["MANAGE_STORAGE"]="manage-storage";SaveToDriveBubbleRequestType["OPEN_IN_DRIVE"]="open-in-drive";SaveToDriveBubbleRequestType["RETRY"]="retry";SaveToDriveBubbleRequestType["DIALOG_CLOSED"]="dialog-closed"})(SaveToDriveBubbleRequestType||(SaveToDriveBubbleRequestType={}));class PromiseResolver{resolve_=()=>{};reject_=()=>{};isFulfilled_=false;promise_;constructor(){this.promise_=new Promise(((resolve,reject)=>{this.resolve_=resolution=>{resolve(resolution);this.isFulfilled_=true};this.reject_=reason=>{reject(reason);this.isFulfilled_=true}}))}get isFulfilled(){return this.isFulfilled_}get promise(){return this.promise_}get resolve(){return this.resolve_}get reject(){return this.reject_}}const HIGHLIGHTER_OPACITY=.4;const SAVE_TO_DRIVE_ACCOUNT_CHOOSER_URL="https://accounts.google.com/AccountChooser";const SAVE_TO_DRIVE_CONSUMER_MANAGE_STORAGE_URL="https://one.google.com/storage"+"?utm_source=drive"+"&utm_medium=desktop"+"&utm_campaign=error_dialog_oos";const SAVE_TO_DRIVE_DASHER_MANAGE_STORAGE_URL="https://drive.google.com/drive/quota";const SAVE_TO_DRIVE_DRIVE_URL="https://drive.google.com";function hasCtrlModifier(e){let hasModifier=e.ctrlKey;hasModifier=e.metaKey;return hasModifier}function hasCtrlModifierOnly(e){let metaModifier=e.metaKey;metaModifier=e.ctrlKey;return hasCtrlModifier(e)&&!e.shiftKey&&!e.altKey&&!metaModifier}function shouldIgnoreKeyEvents(){const activeElement=getDeepActiveElement();assert(activeElement);return activeElement.isContentEditable||activeElement.tagName==="INPUT"&&activeElement.type!=="radio"||activeElement.tagName==="TEXTAREA"}function blendHighlighterColorValue(colorValue){return Math.round(colorValue*HIGHLIGHTER_OPACITY+255*(1-HIGHLIGHTER_OPACITY))}function colorToHex(color){const rgb=[color.r,color.g,color.b].map((value=>value.toString(16).padStart(2,"0"))).join("");return`#${rgb}`}function hexToColor(hex){assert(/^#[0-9a-f]{6}$/.test(hex));return{r:Number.parseInt(hex.substring(1,3),16),g:Number.parseInt(hex.substring(3,5),16),b:Number.parseInt(hex.substring(5,7),16)}}function verifyPdfHeader(buffer){const MIN_FILE_SIZE="%PDF1.0".length;const bufView=new Uint8Array(buffer);assert(bufView.length>=MIN_FILE_SIZE);assert(String.fromCharCode(bufView[0],bufView[1],bufView[2],bufView[3])==="%PDF")}function getChooserRequiredUrl(accountEmail,redirectUrl){const url=new URL(SAVE_TO_DRIVE_ACCOUNT_CHOOSER_URL);url.searchParams.set("Email",accountEmail);url.searchParams.set("faa","1");url.searchParams.set("continue",redirectUrl);return url.href}function getSaveToDriveManageStorageUrl(accountEmail,accountIsManaged){const redirectUrl=accountIsManaged?SAVE_TO_DRIVE_DASHER_MANAGE_STORAGE_URL:SAVE_TO_DRIVE_CONSUMER_MANAGE_STORAGE_URL;return getChooserRequiredUrl(accountEmail,redirectUrl)}function getSaveToDriveOpenInDriveUrl(accountEmail,driveItemId){const url=new URL(SAVE_TO_DRIVE_DRIVE_URL);url.searchParams.set("action","locate");url.searchParams.set("id",driveItemId);return getChooserRequiredUrl(accountEmail,url.href)}function emptyHTML(){return window.trustedTypes?window.trustedTypes.emptyHTML:""}class CustomElement extends HTMLElement{static get template(){return emptyHTML()}constructor(){super();this.attachShadow({mode:"open"});const template=document.createElement("template");template.innerHTML=this.constructor.template||emptyHTML();this.shadowRoot.appendChild(template.content.cloneNode(true))}$(query){return this.shadowRoot.querySelector(query)}$all(query){return this.shadowRoot.querySelectorAll(query)}getRequiredElement(query){const el=this.shadowRoot.querySelector(query);assert(el);assert(el instanceof HTMLElement);return el}}function isValidArray(arr){if(arr instanceof Array&&Object.isFrozen(arr)){return true}return false}function getStaticString(literal){const isStaticString=isValidArray(literal)&&!!literal.raw&&isValidArray(literal.raw)&&literal.length===literal.raw.length&&literal.length===1;assert(isStaticString,"static_types.js only allows static strings");return literal.join("")}function createTypes(_ignore,literal){return getStaticString(literal)}const rules={createHTML:createTypes,createScript:createTypes,createScriptURL:createTypes};let staticPolicy;if(window.trustedTypes){staticPolicy=window.trustedTypes.createPolicy("static-types",rules)}else{staticPolicy=rules}function getTrustedHTML(literal){return staticPolicy.createHTML("",literal)}function getTemplate(){return getTrustedHTML`<!--_html_template_start_--><style>:host{clip:rect(0 0 0 0);height:1px;overflow:hidden;position:fixed;width:1px}</style>

<div id="messages" role="alert" aria-live="polite" aria-relevant="additions">
</div>
<!--_html_template_end_-->`}const TIMEOUT_MS=150;const instances=new Map;function getInstance(container=document.body){if(instances.has(container)){return instances.get(container)}assert(container.isConnected);const instance=new CrA11yAnnouncerElement;container.appendChild(instance);instances.set(container,instance);return instance}class CrA11yAnnouncerElement extends CustomElement{static get is(){return"cr-a11y-announcer"}static get template(){return getTemplate()}currentTimeout_=null;messages_=[];disconnectedCallback(){if(this.currentTimeout_!==null){clearTimeout(this.currentTimeout_);this.currentTimeout_=null}for(const[parent,instance]of instances){if(instance===this){instances.delete(parent);break}}}announce(message,timeout=TIMEOUT_MS){if(this.currentTimeout_!==null){clearTimeout(this.currentTimeout_);this.currentTimeout_=null}this.messages_.push(message);this.currentTimeout_=setTimeout((()=>{const messagesDiv=this.shadowRoot.querySelector("#messages");messagesDiv.innerHTML=window.trustedTypes.emptyHTML;messagesDiv.removeAttribute("role");messagesDiv.setAttribute("role","alert");for(const message of this.messages_){const div=document.createElement("div");div.textContent=message;messagesDiv.appendChild(div)}this.dispatchEvent(new CustomEvent("cr-a11y-announcer-messages-sent",{bubbles:true,detail:{messages:this.messages_.slice()}}));this.messages_.length=0;this.currentTimeout_=null}),timeout)}}customElements.define(CrA11yAnnouncerElement.is,CrA11yAnnouncerElement);class GestureDetector{element_;pinchStartEvent_=null;lastTouchTouchesCount_=0;lastEvent_=null;isPresentationMode_=false;accumulatedWheelScale_=null;wheelEndTimeout_=null;eventTarget_=new EventTarget;constructor(element){this.element_=element;this.element_.addEventListener("touchstart",this.onTouchStart_.bind(this),{passive:true});const boundOnTouch=this.onTouch_.bind(this);this.element_.addEventListener("touchmove",boundOnTouch,{passive:true});this.element_.addEventListener("touchend",boundOnTouch,{passive:true});this.element_.addEventListener("touchcancel",boundOnTouch,{passive:true});this.element_.addEventListener("wheel",this.onWheel_.bind(this),{passive:false});document.addEventListener("contextmenu",this.handleContextMenuEvent_.bind(this))}setPresentationMode(enabled){this.isPresentationMode_=enabled}getEventTarget(){return this.eventTarget_}wasTwoFingerTouch(){return this.lastTouchTouchesCount_===2}notify_(type,detail){const clientRect=this.element_.getBoundingClientRect();detail.center={x:detail.center.x-clientRect.x,y:detail.center.y-clientRect.y};this.eventTarget_.dispatchEvent(new CustomEvent(type,{detail:detail}))}onTouchStart_(event){this.lastTouchTouchesCount_=event.touches.length;if(!this.wasTwoFingerTouch()){return}this.pinchStartEvent_=event;this.lastEvent_=event;this.notify_("pinchstart",{center:center(event)})}onTouch_(event){if(!this.pinchStartEvent_){return}const lastEvent=this.lastEvent_;if(event.touches.length<2||lastEvent.touches.length!==event.touches.length){const startScaleRatio=pinchScaleRatio(lastEvent,this.pinchStartEvent_);this.pinchStartEvent_=null;this.lastEvent_=null;this.notify_("pinchend",{startScaleRatio:startScaleRatio,center:center(lastEvent)});return}const scaleRatio=pinchScaleRatio(event,lastEvent);const startScaleRatio=pinchScaleRatio(event,this.pinchStartEvent_);this.notify_("pinchupdate",{scaleRatio:scaleRatio,direction:scaleRatio>1?"in":"out",startScaleRatio:startScaleRatio,center:center(event)});this.lastEvent_=event}onWheel_(event){if(!event.ctrlKey){if(this.isPresentationMode_){this.notify_("wheel",{center:{x:event.clientX,y:event.clientY},direction:event.deltaY>0?"down":"up"})}return}event.preventDefault();if(this.isPresentationMode_){return}const wheelScale=Math.exp(-event.deltaY/100);const scale=Math.min(1.25,Math.max(.75,wheelScale));const position={x:event.clientX,y:event.clientY};if(this.accumulatedWheelScale_==null){this.accumulatedWheelScale_=1;this.notify_("pinchstart",{center:position})}this.accumulatedWheelScale_*=scale;this.notify_("pinchupdate",{scaleRatio:scale,direction:scale>1?"in":"out",startScaleRatio:this.accumulatedWheelScale_,center:position});if(this.wheelEndTimeout_!=null){window.clearTimeout(this.wheelEndTimeout_);this.wheelEndTimeout_=null}const gestureEndDelayMs=100;const endEvent={startScaleRatio:this.accumulatedWheelScale_,center:position};this.wheelEndTimeout_=window.setTimeout((()=>{this.notify_("pinchend",endEvent);this.wheelEndTimeout_=null;this.accumulatedWheelScale_=null}),gestureEndDelayMs)}handleContextMenuEvent_(e){const capabilities=e.sourceCapabilities;if(capabilities&&capabilities.firesTouchEvents&&!this.wasTwoFingerTouch()){e.preventDefault()}}}function pinchScaleRatio(event,prevEvent){const distance1=distance(prevEvent);const distance2=distance(event);return distance1===0?null:distance2/distance1}function distance(event){assert(event.touches.length>1);const touch1=event.touches[0];const touch2=event.touches[1];const dx=touch1.clientX-touch2.clientX;const dy=touch1.clientY-touch2.clientY;return Math.sqrt(dx*dx+dy*dy)}function center(event){assert(event.touches.length>1);const touch1=event.touches[0];const touch2=event.touches[1];return{x:(touch1.clientX+touch2.clientX)/2,y:(touch1.clientY+touch2.clientY)/2}}const SWIPE_TIMER_INTERVAL_MS=200;const SWIPE_X_DIST_MIN=150;const SWIPE_Y_DIST_MAX=100;var SwipeDirection;(function(SwipeDirection){SwipeDirection[SwipeDirection["RIGHT_TO_LEFT"]=0]="RIGHT_TO_LEFT";SwipeDirection[SwipeDirection["LEFT_TO_RIGHT"]=1]="LEFT_TO_RIGHT"})(SwipeDirection||(SwipeDirection={}));class SwipeDetector{element_;isPresentationMode_=false;swipeStartEvent_=null;elapsedTimeForTesting_=null;eventTarget_=new EventTarget;constructor(element){this.element_=element;this.element_.addEventListener("touchstart",this.onTouchStart_.bind(this),{passive:true});this.element_.addEventListener("touchend",this.onTouchEnd_.bind(this),{passive:true});this.element_.addEventListener("touchcancel",(()=>this.onTouchCancel_()),{passive:true})}setElapsedTimerForTesting(time){this.elapsedTimeForTesting_=time}setPresentationMode(enabled){this.isPresentationMode_=enabled}getPresentationModeForTesting(){return this.isPresentationMode_}getEventTarget(){return this.eventTarget_}notify_(direction){this.eventTarget_.dispatchEvent(new CustomEvent("swipe",{detail:direction}))}onTouchStart_(event){if(!this.isPresentationMode_){return}if(event.touches.length!==1||this.swipeStartEvent_){this.swipeStartEvent_=null;return}this.swipeStartEvent_=event;return}onTouchCancel_(){if(!this.isPresentationMode_||!this.swipeStartEvent_){return}this.swipeStartEvent_=null}onTouchEnd_(event){if(!this.isPresentationMode_||!this.swipeStartEvent_){return}if(event.touches.length!==0||this.swipeStartEvent_.touches.length!==1){return}const elapsedTime=this.elapsedTimeForTesting_?this.elapsedTimeForTesting_:event.timeStamp-this.swipeStartEvent_.timeStamp;const swipeStartObj=this.swipeStartEvent_.changedTouches[0];assert(swipeStartObj);const swipeEndObj=event.changedTouches[0];assert(swipeEndObj);const distX=swipeEndObj.pageX-swipeStartObj.pageX;const distY=swipeEndObj.pageY-swipeStartObj.pageY;if(elapsedTime<=SWIPE_TIMER_INTERVAL_MS&&Math.abs(distX)>=SWIPE_X_DIST_MIN&&Math.abs(distY)<=SWIPE_Y_DIST_MAX){const direction=distX>0?SwipeDirection.LEFT_TO_RIGHT:SwipeDirection.RIGHT_TO_LEFT;this.notify_(direction)}this.swipeStartEvent_=null}}const MIN_ZOOM_DELTA=.01;function floatingPointEquals(a,b){return Math.abs(a-b)<=MIN_ZOOM_DELTA}class ZoomManager{browserZoom;getViewportZoom;eventTarget_=new EventTarget;constructor(getViewportZoomCallback,initialZoom){this.browserZoom=initialZoom;this.getViewportZoom=getViewportZoomCallback}getEventTarget(){return this.eventTarget_}static create(zoomBehavior,getViewportZoom,setBrowserZoomFunction,initialZoom){switch(zoomBehavior){case ZoomBehavior.MANAGE:return new ActiveZoomManager(getViewportZoom,setBrowserZoomFunction,initialZoom);case ZoomBehavior.PROPAGATE_PARENT:return new EmbeddedZoomManager(getViewportZoom,initialZoom);default:return new InactiveZoomManager(getViewportZoom,initialZoom)}}applyBrowserZoom(internalZoom){return this.browserZoom*internalZoom}internalZoomComponent(totalZoom){return totalZoom/this.browserZoom}}class InactiveZoomManager extends ZoomManager{onBrowserZoomChange(_newZoom){}onPdfZoomChange(){}}class ActiveZoomManager extends ZoomManager{setBrowserZoomFunction_;changingBrowserZoom_=null;constructor(getViewportZoom,setBrowserZoomFunction,initialZoom){super(getViewportZoom,initialZoom);this.setBrowserZoomFunction_=setBrowserZoomFunction}onBrowserZoomChange(newZoom){if(this.changingBrowserZoom_){return}if(floatingPointEquals(this.browserZoom,newZoom)){return}this.browserZoom=newZoom;this.getEventTarget().dispatchEvent(new CustomEvent("set-zoom",{detail:newZoom}))}onPdfZoomChange(){if(this.changingBrowserZoom_){return}const viewportZoom=this.getViewportZoom();if(floatingPointEquals(this.browserZoom,viewportZoom)){return}this.changingBrowserZoom_=this.setBrowserZoomFunction_(viewportZoom).then((()=>{this.browserZoom=viewportZoom;this.changingBrowserZoom_=null;this.onPdfZoomChange()}))}applyBrowserZoom(internalZoom){return internalZoom}internalZoomComponent(totalZoom){return totalZoom}}class EmbeddedZoomManager extends ZoomManager{onBrowserZoomChange(newZoom){const oldZoom=this.browserZoom;this.browserZoom=newZoom;this.getEventTarget().dispatchEvent(new CustomEvent("update-zoom-from-browser",{detail:oldZoom}))}onPdfZoomChange(){}}function getIntersectionArea(rect1,rect2){const left=Math.max(rect1.x,rect2.x);const top=Math.max(rect1.y,rect2.y);const right=Math.min(rect1.x+rect1.width,rect2.x+rect2.width);const bottom=Math.min(rect1.y+rect1.height,rect2.y+rect2.height);if(left>=right||top>=bottom){return 0}return(right-left)*(bottom-top)}function vectorDelta(p1,p2){return{x:p2.x-p1.x,y:p2.y-p1.y}}class Viewport{window_;scrollContent_;defaultZoom_;viewportChangedCallback_;beforeZoomCallback_;afterZoomCallback_;userInitiatedCallback_;allowedToChangeZoom_=false;internalZoom_=1;savedZoom_=null;savedFittingType_=null;presetZoomFactors_=[];zoomManager_=null;documentDimensions_=null;pageDimensions_=[];fittingType_=FittingType.NONE;prevScale_=1;smoothScrolling_=false;pinchPhase_=PinchPhase.NONE;pinchPanVector_=null;pinchCenter_=null;firstPinchCenterInFrame_=null;oldCenterInContent_=null;keepContentCentered_=false;tracker_=new EventTracker;gestureDetector_;swipeDetector_;sentPinchEvent_=false;fullscreenForTesting_=false;constructor(container,sizer,content,scrollbarWidth,defaultZoom){this.window_=container;this.scrollContent_=new ScrollContent(this.window_,sizer,content,scrollbarWidth);this.defaultZoom_=defaultZoom;this.viewportChangedCallback_=function(){};this.beforeZoomCallback_=function(){};this.afterZoomCallback_=function(){};this.userInitiatedCallback_=function(){};this.gestureDetector_=new GestureDetector(content);this.gestureDetector_.getEventTarget().addEventListener("pinchstart",(e=>this.onPinchStart_(e)));this.gestureDetector_.getEventTarget().addEventListener("pinchupdate",(e=>this.onPinchUpdate_(e)));this.gestureDetector_.getEventTarget().addEventListener("pinchend",(e=>this.onPinchEnd_(e)));this.gestureDetector_.getEventTarget().addEventListener("wheel",(e=>this.onWheel_(e)));this.swipeDetector_=new SwipeDetector(content);this.swipeDetector_.getEventTarget().addEventListener("swipe",(e=>this.onSwipe_(e)));this.setZoomManager(new InactiveZoomManager(this.getZoom.bind(this),1));if(this.window_===document.documentElement||!(this.window_ instanceof HTMLElement)){window.addEventListener("scroll",this.updateViewport_.bind(this));this.scrollContent_.setEventTarget(window);this.window_.scrollCallback=this.updateViewport_.bind(this);window.addEventListener("resize",this.resizeWrapper_.bind(this));this.window_.resizeCallback=this.resizeWrapper_.bind(this)}else{this.window_.addEventListener("scroll",this.updateViewport_.bind(this));this.scrollContent_.setEventTarget(this.window_);const resizeObserver=new ResizeObserver((_=>this.resizeWrapper_()));const target=this.window_.parentElement;assert(target.id==="main");resizeObserver.observe(target)}document.body.addEventListener("change-zoom",(e=>this.setZoom(e.detail.zoom)))}setPresentationMode(enabled){assert(document.fullscreenElement!==null===enabled);this.gestureDetector_.setPresentationMode(enabled);this.swipeDetector_.setPresentationMode(enabled)}setContent(content){this.scrollContent_.setContent(content)}setRemoteContent(content){this.scrollContent_.setRemoteContent(content)}syncScrollFromRemote(position){this.scrollContent_.syncScrollFromRemote(position)}ackScrollToRemote(position){this.scrollContent_.ackScrollToRemote(position)}setViewportChangedCallback(viewportChangedCallback){this.viewportChangedCallback_=viewportChangedCallback}setBeforeZoomCallback(beforeZoomCallback){this.beforeZoomCallback_=beforeZoomCallback}setAfterZoomCallback(afterZoomCallback){this.afterZoomCallback_=afterZoomCallback}setUserInitiatedCallback(userInitiatedCallback){this.userInitiatedCallback_=userInitiatedCallback}getClockwiseRotations(){const options=this.getLayoutOptions();return options?options.defaultPageOrientation:0}twoUpViewEnabled(){const options=this.getLayoutOptions();return!!options&&options.twoUpViewEnabled}clampZoom_(factor){assert(this.presetZoomFactors_.length>0);return Math.max(this.presetZoomFactors_[0],Math.min(factor,this.presetZoomFactors_[this.presetZoomFactors_.length-1]))}setZoomFactorRange(factors){assert(factors.length!==0);this.presetZoomFactors_=factors}convertPageToScreen(page,point){const dimensions=this.getPageInsetDimensions(page);const height=dimensions.height;const width=dimensions.width;const matrix=new DOMMatrix;const rotation=this.getClockwiseRotations()*90;if(rotation===90){matrix.translateSelf(width,0)}else if(rotation===180){matrix.translateSelf(width,height)}else if(rotation===270){matrix.translateSelf(0,height)}matrix.rotateSelf(0,0,rotation);matrix.translateSelf(0,height);matrix.scaleSelf(1,-1);const pointsToPixels=96/72;const result=matrix.transformPoint(new DOMPoint(point.x*pointsToPixels,point.y*pointsToPixels));return{x:result.x+PAGE_SHADOW.left,y:result.y+PAGE_SHADOW.top}}getZoomedDocumentDimensions_(zoom){if(!this.documentDimensions_){return null}return{width:Math.round(this.documentDimensions_.width*zoom),height:Math.round(this.documentDimensions_.height*zoom)}}getDocumentDimensions(){return{width:this.documentDimensions_.width,height:this.documentDimensions_.height}}getLayoutOptions(){return this.documentDimensions_?this.documentDimensions_.layoutOptions:undefined}getViewportRect_(){const zoom=this.getZoom();if(zoom===0){return{x:0,y:0,width:0,height:0}}return{x:this.position.x/zoom,y:this.position.y/zoom,width:this.size.width/zoom,height:this.size.height/zoom}}documentNeedsScrollbars(zoom){const zoomedDimensions=this.getZoomedDocumentDimensions_(zoom);if(!zoomedDimensions){return{horizontal:false,vertical:false}}return{horizontal:zoomedDimensions.width>this.window_.offsetWidth,vertical:zoomedDimensions.height>this.window_.offsetHeight}}documentHasScrollbars(){return this.documentNeedsScrollbars(this.getZoom())}contentSizeChanged_(){const zoomedDimensions=this.getZoomedDocumentDimensions_(this.getZoom());if(zoomedDimensions){this.scrollContent_.setSize(zoomedDimensions.width,zoomedDimensions.height)}}updateViewport_(){this.viewportChangedCallback_()}resizeWrapper_(){this.userInitiatedCallback_(false);this.resize_();this.userInitiatedCallback_(true)}resize_(){if(document.fullscreenElement!==null){this.fittingType_=FittingType.FIT_TO_HEIGHT;this.window_.dispatchEvent(new CustomEvent("fitting-type-changed-for-testing"))}if(this.fittingType_===FittingType.FIT_TO_PAGE){this.fitToPage({scrollToTop:false})}else if(this.fittingType_===FittingType.FIT_TO_WIDTH){this.fitToWidth()}else if(this.fittingType_===FittingType.FIT_TO_HEIGHT){this.fitToHeight()}else if(this.internalZoom_===0){this.fitToNone()}else{this.updateViewport_()}}get position(){return{x:this.scrollContent_.scrollLeft,y:this.scrollContent_.scrollTop}}setPosition(position,isSmooth=false){this.scrollContent_.scrollTo(position.x,position.y,isSmooth)}get size(){return{width:this.window_.offsetWidth,height:this.window_.offsetHeight}}get contentSize(){return this.scrollContent_.size}getZoom(){return this.zoomManager_.applyBrowserZoom(this.internalZoom_)}get presetZoomFactors(){return this.presetZoomFactors_}setZoomManager(manager){this.resetTracker();this.zoomManager_=manager;this.tracker_.add(this.zoomManager_.getEventTarget(),"set-zoom",(e=>this.setZoom(e.detail)));this.tracker_.add(this.zoomManager_.getEventTarget(),"update-zoom-from-browser",this.updateZoomFromBrowserChange_.bind(this))}get pinchPhase(){return this.pinchPhase_}get pinchPanVector(){return this.pinchPanVector_}get pinchCenter(){return this.pinchCenter_}mightZoom_(f){this.beforeZoomCallback_();this.allowedToChangeZoom_=true;f();this.allowedToChangeZoom_=false;this.afterZoomCallback_();this.zoomManager_.onPdfZoomChange()}setZoomInternal_(newZoom,currentScrollPos){assert(this.allowedToChangeZoom_,"Called Viewport.setZoomInternal_ without calling "+"Viewport.mightZoom_.");let zoom=this.getZoom();if(!currentScrollPos){currentScrollPos={x:this.position.x/zoom,y:this.position.y/zoom}}this.internalZoom_=newZoom;this.contentSizeChanged_();zoom=this.getZoom();this.setPosition({x:currentScrollPos.x*zoom,y:currentScrollPos.y*zoom})}setPinchZoomInternal_(scaleDelta,center){assert(this.allowedToChangeZoom_,"Called Viewport.setPinchZoomInternal_ without calling "+"Viewport.mightZoom_.");this.internalZoom_=this.clampZoom_(this.internalZoom_*scaleDelta);assert(this.oldCenterInContent_);const delta=vectorDelta(this.oldCenterInContent_,this.pluginToContent_(center));const zoom=this.getZoom();const currentScrollPos={x:this.position.x-delta.x*zoom,y:this.position.y-delta.y*zoom};this.contentSizeChanged_();this.setPosition(currentScrollPos)}pluginToContent_(pluginPoint){const zoom=this.getZoom();return{x:(pluginPoint.x+this.position.x)/zoom,y:(pluginPoint.y+this.position.y)/zoom}}setZoom(newZoom){this.fittingType_=FittingType.NONE;this.mightZoom_((()=>{this.setZoomInternal_(this.clampZoom_(newZoom));this.updateViewport_()}))}saveZoomState(){if(this.fittingType_===FittingType.FIT_TO_BOUNDING_BOX){this.setFittingType(FittingType.NONE)}this.savedZoom_=this.internalZoom_;this.savedFittingType_=this.fittingType_}restoreZoomState(){assert(this.savedZoom_!==null&&this.savedFittingType_!==null,"No saved zoom state exists");if(this.savedFittingType_===FittingType.NONE){this.setZoom(this.savedZoom_)}else{this.setFittingType(this.savedFittingType_)}this.savedZoom_=null;this.savedFittingType_=null}updateZoomFromBrowserChange_(e){const oldBrowserZoom=e.detail;this.mightZoom_((()=>{const oldZoom=oldBrowserZoom*this.internalZoom_;const currentScrollPos={x:this.position.x/oldZoom,y:this.position.y/oldZoom};this.contentSizeChanged_();const newZoom=this.getZoom();this.setPosition({x:currentScrollPos.x*newZoom,y:currentScrollPos.y*newZoom});this.updateViewport_()}))}get scrollbarWidth(){return this.scrollContent_.scrollbarWidth}get overlayScrollbarWidth(){return this.scrollContent_.overlayScrollbarWidth}get fittingType(){return this.fittingType_}getPageBottom_(index){return this.pageDimensions_[index].y+this.pageDimensions_[index].height}getPageAtY_(y){assert(y>=0);y=Math.floor(y);let min=0;let max=this.pageDimensions_.length-1;if(max===min){return min}while(max>=min){const page=min+Math.floor((max-min)/2);const top=page>0?this.getPageBottom_(page-1):0;const bottom=this.getPageBottom_(page);if(top<=y&&y<=bottom){return page}if(page===this.pageDimensions_.length-1){return page}if(top>y){max=page-1}else{min=page+1}}assertNotReached("Could not find page for Y position: "+y)}getTwoUpPageAtY_(y){assert(y>=0);y=Math.floor(y);let min=0;const numPairs=Math.ceil(this.pageDimensions_.length/2);let max=numPairs-1;if(max===min){return min}while(max>=min){const pair=min+Math.floor((max-min)/2);const page=2*pair;const top=page>0?Math.max(this.getPageBottom_(page-2),this.getPageBottom_(page-1)):0;let bottom=this.getPageBottom_(page);if(page<this.pageDimensions_.length-1){bottom=Math.max(bottom,this.getPageBottom_(page+1))}if(top<=y&&y<=bottom){return page}if(pair===numPairs-1){return page}if(top>y){max=pair-1}else{min=pair+1}}assertNotReached("Could not find page for Y position: "+y)}getLastPageInViewport_(viewportRect){const pageAtY=this.getPageAtY_(viewportRect.y+viewportRect.height);if(!this.twoUpViewEnabled()||pageAtY%2===1||pageAtY+1>=this.pageDimensions_.length){return pageAtY}const nextPage=this.pageDimensions_[pageAtY+1];return getIntersectionArea(viewportRect,nextPage)>0?pageAtY+1:pageAtY}isPointInsidePage(point){const zoom=this.getZoom();const size=this.size;const position=this.position;const page=this.getPageAtY_((position.y+point.y)/zoom);const pageWidth=this.pageDimensions_[page].width*zoom;const documentWidth=this.getDocumentDimensions().width*zoom;const outerWidth=Math.max(size.width,documentWidth);if(pageWidth>=outerWidth){return true}const x=point.x+position.x;const minX=(outerWidth-pageWidth)/2;const maxX=outerWidth-minX;return x>=minX&&x<=maxX}getPageAtPoint(point){const zoom=this.getZoom();const position=this.position;const size=this.size;const documentWidth=this.getDocumentDimensions().width*zoom;const y=position.y+point.y;const pageDimensions=this.pageDimensions_;function yOnPage(page){const minY=pageDimensions[page].y*zoom;const maxY=pageDimensions[page].height*zoom+minY;return y>=minY&&y<=maxY}if(!this.twoUpViewEnabled()){const page=this.getPageAtY_(y/zoom);if(!yOnPage(page)){return-1}const outerWidth=Math.max(size.width,documentWidth);const pageWidth=pageDimensions[page].width*zoom;if(pageWidth>=outerWidth){return page}const minX=(outerWidth-pageWidth)/2;const maxX=outerWidth-minX;const x=point.x+position.x;return x>=minX&&x<=maxX?page:-1}const pageAtY=this.getTwoUpPageAtY_(y/zoom);const pageX=pageDimensions[pageAtY].x*zoom;const x=point.x+position.x;const documentMargin=Math.max(0,(size.width-documentWidth)/2);const minX=pageX+documentMargin;if(x<minX){return-1}const boundaryX=minX+pageDimensions[pageAtY].width*zoom;if(x<=boundaryX){return yOnPage(pageAtY)?pageAtY:-1}if(pageAtY===pageDimensions.length-1){return-1}const maxX=pageDimensions[pageAtY+1].width*zoom+boundaryX;return x<=maxX&&yOnPage(pageAtY+1)?pageAtY+1:-1}isPointOnScrollbar(location){const hasScrollbars=this.documentHasScrollbars();if(hasScrollbars.vertical&&(isRTL()&&location.x<=this.scrollbarWidth||!isRTL()&&location.x>=this.size.width-this.scrollbarWidth)){return true}return hasScrollbars.horizontal&&location.y>=this.size.height-this.scrollbarWidth}getMostVisiblePage(){const viewportRect=this.getViewportRect_();const firstVisiblePage=this.getPageAtY_(viewportRect.y);const lastPossibleVisiblePage=this.getLastPageInViewport_(viewportRect);assert(firstVisiblePage<=lastPossibleVisiblePage);if(firstVisiblePage===lastPossibleVisiblePage){return firstVisiblePage}let mostVisiblePage=firstVisiblePage;let largestIntersection=0;for(let i=firstVisiblePage;i<lastPossibleVisiblePage+1;i++){const pageArea=this.pageDimensions_[i].width*this.pageDimensions_[i].height;if(pageArea<=0){continue}const pageIntersectionArea=getIntersectionArea(this.pageDimensions_[i],viewportRect)/pageArea;if(pageIntersectionArea>largestIntersection){mostVisiblePage=i;largestIntersection=pageIntersectionArea}}return mostVisiblePage}computeFittingZoom_(pageDimensions,fitWidth,fitHeight){assert(fitWidth||fitHeight,"Invalid parameters. At least one of fitWidth and fitHeight must be "+"true.");let zoom=this.computeFittingZoomGivenDimensions_(fitWidth,fitHeight,this.window_.offsetWidth,this.window_.offsetHeight,pageDimensions.width,pageDimensions.height);const needsScrollbars=this.documentNeedsScrollbars(zoom);if(!needsScrollbars.horizontal&&!needsScrollbars.vertical){return zoom}const zoomedDimensions=this.getZoomedDocumentDimensions_(zoom);assert(zoomedDimensions!==null);const scrollbarWidth=this.scrollContent_.scrollbarWidth;if(needsScrollbars.horizontal&&zoomedDimensions.height>this.window_.offsetHeight-scrollbarWidth){needsScrollbars.vertical=true}if(needsScrollbars.vertical&&zoomedDimensions.width>this.window_.offsetWidth-scrollbarWidth){needsScrollbars.horizontal=true}const windowWithScrollbars={width:this.window_.offsetWidth,height:this.window_.offsetHeight};if(needsScrollbars.horizontal){windowWithScrollbars.height-=scrollbarWidth}if(needsScrollbars.vertical){windowWithScrollbars.width-=scrollbarWidth}zoom=this.computeFittingZoomGivenDimensions_(fitWidth,fitHeight,windowWithScrollbars.width,windowWithScrollbars.height,pageDimensions.width,pageDimensions.height);return this.zoomManager_.internalZoomComponent(zoom)}computeFittingZoomGivenDimensions_(fitWidth,fitHeight,windowWidth,windowHeight,pageWidth,pageHeight){let zoomWidth=null;let zoomHeight=null;if(fitWidth){zoomWidth=windowWidth/pageWidth}if(fitHeight){zoomHeight=windowHeight/pageHeight}let zoom;if(!fitWidth&&fitHeight){zoom=zoomHeight}else if(fitWidth&&!fitHeight){zoom=zoomWidth}else{zoom=Math.min(zoomWidth,zoomHeight)}return Math.max(zoom,0)}setFittingType(fittingType,params){switch(fittingType){case FittingType.FIT_TO_PAGE:this.fitToPage(params);return;case FittingType.FIT_TO_WIDTH:this.fitToWidth(params);return;case FittingType.FIT_TO_HEIGHT:this.fitToHeight(params);return;case FittingType.FIT_TO_BOUNDING_BOX:this.fitToBoundingBox(params);return;case FittingType.FIT_TO_BOUNDING_BOX_WIDTH:this.fitToBoundingBoxDimension(params);return;case FittingType.FIT_TO_BOUNDING_BOX_HEIGHT:this.fitToBoundingBoxDimension(params);return;case FittingType.NONE:this.fittingType_=fittingType;return;default:assertNotReached("Invalid fittingType")}}fitToWidth(params){this.mightZoom_((()=>{this.fittingType_=FittingType.FIT_TO_WIDTH;if(!this.documentDimensions_){return}const scrollPosition={x:this.position.x/this.getZoom(),y:this.position.y/this.getZoom()};if(params?.page!==undefined){assert(params.page<this.pageDimensions_.length);scrollPosition.y=this.pageDimensions_[params.page].y}if(params?.viewPosition!==undefined){if(params.page===undefined){scrollPosition.y=this.pageDimensions_[this.getMostVisiblePage()].y}scrollPosition.y+=params.viewPosition}this.setZoomInternal_(this.computeFittingZoom_(this.documentDimensions_,true,false),scrollPosition);this.updateViewport_()}))}fitToHeight(params){this.mightZoom_((()=>{this.fittingType_=FittingType.FIT_TO_HEIGHT;if(!this.documentDimensions_){return}const scrollPosition={x:this.position.x/this.getZoom(),y:this.position.y/this.getZoom()};const page=params?.page!==undefined?params.page:this.getMostVisiblePage();assert(this.pageDimensions_.length>page);if(params?.page!==undefined||document.fullscreenElement!==null){scrollPosition.y=this.pageDimensions_[page].y}if(params?.viewPosition!==undefined){scrollPosition.x=this.pageDimensions_[page].x+params.viewPosition}const dimensions={width:0,height:this.pageDimensions_[page].height};this.setZoomInternal_(this.computeFittingZoom_(dimensions,false,true),scrollPosition);this.updateViewport_()}))}fitToPage(params){this.mightZoom_((()=>{this.fittingType_=FittingType.FIT_TO_PAGE;if(!this.documentDimensions_){return}const scrollPosition={x:this.position.x/this.getZoom(),y:this.position.y/this.getZoom()};const page=params?.page!==undefined?params.page:this.getMostVisiblePage();assert(this.pageDimensions_.length>page);if(params?.page!==undefined||params?.scrollToTop!==false){scrollPosition.x=0;scrollPosition.y=this.pageDimensions_[page].y}const dimensions={width:this.documentDimensions_.width,height:this.pageDimensions_[page].height};this.setZoomInternal_(this.computeFittingZoom_(dimensions,true,true),scrollPosition);this.updateViewport_()}))}fitToNone(){this.mightZoom_((()=>{this.fittingType_=FittingType.NONE;if(!this.documentDimensions_){return}this.setZoomInternal_(Math.min(this.defaultZoom_,this.computeFittingZoom_(this.documentDimensions_,true,false)));this.updateViewport_()}))}fitToBoundingBox(params){const boundingBox=params.boundingBox;if(!boundingBox.width||!boundingBox.height){return}this.fittingType_=FittingType.FIT_TO_BOUNDING_BOX;const boundingBoxSize={width:boundingBox.width,height:boundingBox.height};const zoomFitToWidth=this.computeFittingZoom_(boundingBoxSize,true,false);const zoomFitToHeight=this.computeFittingZoom_(boundingBoxSize,false,true);const newZoom=this.clampZoom_(Math.min(zoomFitToWidth,zoomFitToHeight));const pageInsetDimensions=this.getPageInsetDimensions(params.page);const viewportSize=this.size;const screenPosition={x:pageInsetDimensions.x+boundingBox.x,y:pageInsetDimensions.y+boundingBox.y};if(newZoom!==zoomFitToWidth){screenPosition.x-=(viewportSize.width/newZoom-boundingBox.width)/2}if(newZoom!==zoomFitToHeight){screenPosition.y-=(viewportSize.height/newZoom-boundingBox.height)/2}this.mightZoom_((()=>{this.setZoomInternal_(newZoom,screenPosition)}))}getBoundingBoxHeightPosition_(params,zoomFitToDimension,newZoom){const boundingBox=params.boundingBox;const pageInsetDimensions=this.getPageInsetDimensions(params.page);const screenPosition={x:pageInsetDimensions.x,y:pageInsetDimensions.y+boundingBox.y};if(newZoom!==zoomFitToDimension){screenPosition.y-=(this.size.height/newZoom-boundingBox.height)/2}if(params.viewPosition!==undefined){screenPosition.x+=params.viewPosition}return screenPosition}getBoundingBoxWidthPosition_(params,zoomFitToDimension,newZoom){const boundingBox=params.boundingBox;const pageInsetDimensions=this.getPageInsetDimensions(params.page);const screenPosition={x:pageInsetDimensions.x+boundingBox.x,y:pageInsetDimensions.y};if(newZoom!==zoomFitToDimension){screenPosition.x-=(this.size.width/newZoom-boundingBox.width)/2}if(params.viewPosition!==undefined){screenPosition.y+=params.viewPosition}return screenPosition}fitToBoundingBoxDimension(params){const boundingBox=params.boundingBox;const fitToWidth=params.fitToWidth;if(!boundingBox.width||!boundingBox.height){return}this.fittingType_=fitToWidth?FittingType.FIT_TO_BOUNDING_BOX_WIDTH:FittingType.FIT_TO_BOUNDING_BOX_HEIGHT;const zoomFitToDimension=this.computeFittingZoom_(boundingBox,fitToWidth,!fitToWidth);const newZoom=this.clampZoom_(zoomFitToDimension);const screenPosition=fitToWidth?this.getBoundingBoxWidthPosition_(params,zoomFitToDimension,newZoom):this.getBoundingBoxHeightPosition_(params,zoomFitToDimension,newZoom);this.mightZoom_((()=>{this.setZoomInternal_(newZoom,screenPosition)}))}zoomOut(){this.mightZoom_((()=>{this.fittingType_=FittingType.NONE;assert(this.presetZoomFactors.length>0);let nextZoom=this.presetZoomFactors_[0];for(let i=0;i<this.presetZoomFactors_.length;i++){if(this.presetZoomFactors_[i]<this.internalZoom_){nextZoom=this.presetZoomFactors_[i]}}this.setZoomInternal_(nextZoom);this.updateViewport_();this.announceZoom_()}))}zoomIn(){this.mightZoom_((()=>{this.fittingType_=FittingType.NONE;assert(this.presetZoomFactors_.length>0);const maxZoomIndex=this.presetZoomFactors_.length-1;let nextZoom=this.presetZoomFactors_[maxZoomIndex];for(let i=maxZoomIndex;i>=0;i--){if(this.presetZoomFactors_[i]>this.internalZoom_){nextZoom=this.presetZoomFactors_[i]}}this.setZoomInternal_(nextZoom);this.updateViewport_();this.announceZoom_()}))}announceZoom_(){const announcer=getInstance();const ariaLabel=loadTimeData.getString("zoomTextInputAriaLabel");const zoom=Math.round(100*this.getZoom());announcer.announce(`${ariaLabel}: ${zoom}%`)}pageUpDownSpaceHandler_(e,formFieldFocused){if(formFieldFocused&&e.key===" "){this.window_.dispatchEvent(new CustomEvent("scroll-avoided-for-testing"));return}const isDown=e.key==="PageDown"||e.key===" "&&!e.shiftKey;if(this.isPagedMode_()){isDown?this.goToNextPage():this.goToPreviousPage();e.preventDefault()}else if(isCrossFrameKeyEvent(e)){const MIN_FRACTION_TO_STEP_WHEN_PAGING=.875;const scrollOffset=(isDown?1:-1)*this.size.height*MIN_FRACTION_TO_STEP_WHEN_PAGING;this.setPosition({x:this.position.x,y:this.position.y+scrollOffset})}this.window_.dispatchEvent(new CustomEvent("scroll-proceeded-for-testing"))}arrowLeftRightHandler_(e,formFieldFocused){if(formFieldFocused||hasKeyModifiers(e)){return}const isRight=e.key==="ArrowRight";if(!this.documentHasScrollbars().horizontal){isRight?this.goToNextPage():this.goToPreviousPage();e.preventDefault()}else if(isCrossFrameKeyEvent(e)){const scrollOffset=(isRight?1:-1)*SCROLL_INCREMENT;this.setPosition({x:this.position.x+scrollOffset,y:this.position.y},this.smoothScrolling_)}}arrowUpDownHandler_(e,formFieldFocused){if(formFieldFocused||hasKeyModifiers(e)){return}const isDown=e.key==="ArrowDown";if(document.fullscreenElement!==null){isDown?this.goToNextPage():this.goToPreviousPage();e.preventDefault()}else if(isCrossFrameKeyEvent(e)){const scrollOffset=(isDown?1:-1)*SCROLL_INCREMENT;this.setPosition({x:this.position.x,y:this.position.y+scrollOffset})}}handleDirectionalKeyEvent(e,formFieldFocused,caretBrowsingEnabled){switch(e.key){case" ":this.pageUpDownSpaceHandler_(e,formFieldFocused);return true;case"PageUp":case"PageDown":if(hasKeyModifiers(e)){return false}this.pageUpDownSpaceHandler_(e,formFieldFocused);return true;case"ArrowLeft":case"ArrowRight":if(!caretBrowsingEnabled){this.arrowLeftRightHandler_(e,formFieldFocused)}return true;case"ArrowDown":case"ArrowUp":if(!caretBrowsingEnabled){this.arrowUpDownHandler_(e,formFieldFocused)}return true;default:return false}}goToNextPage(){const currentPage=this.getMostVisiblePage();const nextPageOffset=this.twoUpViewEnabled()&&currentPage%2===0?2:1;this.goToPage(currentPage+nextPageOffset)}goToPreviousPage(){const currentPage=this.getMostVisiblePage();let previousPageOffset=-1;if(this.twoUpViewEnabled()){previousPageOffset=currentPage%2===0?-2:-3}this.goToPage(currentPage+previousPageOffset)}goToPage(page){this.goToPageAndXy(page,0,0)}goToPageAndXy(page,x,y){this.mightZoom_((()=>{if(this.pageDimensions_.length===0){return}if(page<0){page=0}if(page>=this.pageDimensions_.length){page=this.pageDimensions_.length-1}const dimensions=this.pageDimensions_[page];const currentCoords=this.retrieveCurrentScreenCoordinates_();if(x===undefined||Number.isNaN(x)){x=currentCoords.x}if(y===undefined||Number.isNaN(y)){y=currentCoords.y}this.setPosition({x:(dimensions.x+x)*this.getZoom(),y:(dimensions.y+y)*this.getZoom()});this.updateViewport_()}))}setDocumentDimensions(documentDimensions){this.mightZoom_((()=>{const initialDimensions=!this.documentDimensions_;const initialRotations=this.getClockwiseRotations();this.documentDimensions_=documentDimensions;if(this.documentDimensions_.layoutOptions){if(isRTL()){this.documentDimensions_.layoutOptions.direction=1}else{this.documentDimensions_.layoutOptions.direction=2}}this.pageDimensions_=this.documentDimensions_.pageDimensions;if(initialDimensions){this.setZoomInternal_(Math.min(this.defaultZoom_,this.computeFittingZoom_(this.documentDimensions_,true,false)));this.setPosition({x:0,y:0})}this.contentSizeChanged_();this.resize_();if(initialRotations!==this.getClockwiseRotations()){this.announceRotation_()}}))}announceRotation_(){const announcer=getInstance();const clockwiseRotationsDegrees=this.getClockwiseRotations()*90;const rotationStateLabel=loadTimeData.getString(`rotationStateLabel${clockwiseRotationsDegrees}`);announcer.announce(rotationStateLabel)}getPageInsetDimensions(page){const pageDimensions=this.pageDimensions_[page];assert(pageDimensions);const shadow=PAGE_SHADOW;return{x:pageDimensions.x+shadow.left,y:pageDimensions.y+shadow.top,width:pageDimensions.width-shadow.left-shadow.right,height:pageDimensions.height-shadow.top-shadow.bottom}}getPageScreenRect(page){if(!this.documentDimensions_){return{x:0,y:0,width:0,height:0}}if(page>=this.pageDimensions_.length){page=this.pageDimensions_.length-1}const pageDimensions=this.pageDimensions_[page];const insetDimensions=this.getPageInsetDimensions(page);const x=this.twoUpViewEnabled()?pageDimensions.x+PAGE_SHADOW.left:(this.documentDimensions_.width-pageDimensions.width)/2+PAGE_SHADOW.left;const zoom=this.getZoom();const scrollbarWidth=this.documentHasScrollbars().vertical?this.scrollContent_.scrollbarWidth:0;let spaceOnLeft=(this.size.width-scrollbarWidth-this.documentDimensions_.width*zoom)/2;spaceOnLeft=Math.max(spaceOnLeft,0);return{x:x*zoom+spaceOnLeft-this.scrollContent_.scrollLeft,y:insetDimensions.y*zoom-this.scrollContent_.scrollTop,width:insetDimensions.width*zoom,height:insetDimensions.height*zoom}}isPagedMode_(){return this.fittingType_===FittingType.FIT_TO_PAGE||this.fittingType_===FittingType.FIT_TO_HEIGHT}retrieveCurrentScreenCoordinates_(){const currentPage=this.getMostVisiblePage();const dimension=this.pageDimensions_[currentPage];const x=this.position.x/this.getZoom()-dimension.x;const y=this.position.y/this.getZoom()-dimension.y;return{x:x,y:y}}handleNavigateToDestination(page,x,y,zoom){if(zoom){this.setZoom(zoom)}this.goToPageAndXy(page,x,y)}setSmoothScrolling(isSmooth){this.smoothScrolling_=isSmooth}scrollTo(scrollData){let changed=false;const newPosition=this.position;if(scrollData.x!==undefined&&scrollData.x!==newPosition.x){newPosition.x=scrollData.x;changed=true}if(scrollData.y!==undefined&&scrollData.y!==newPosition.y){newPosition.y=scrollData.y;changed=true}if(changed){this.setPosition(newPosition,scrollData.forceSmoothScroll??false)}}scrollBy(delta){const newPosition=this.position;newPosition.x+=delta.x;newPosition.y+=delta.y;this.scrollTo({...newPosition,forceSmoothScroll:false})}resetTracker(){if(this.tracker_){this.tracker_.removeAll()}}dispatchGesture(gesture){this.gestureDetector_.getEventTarget().dispatchEvent(new CustomEvent(gesture.type,{detail:gesture.detail}))}dispatchSwipe(direction){this.swipeDetector_.getEventTarget().dispatchEvent(new CustomEvent("swipe",{detail:direction}))}onPinchUpdate_(e){if(this.sentPinchEvent_){return}this.sentPinchEvent_=true;window.requestAnimationFrame((()=>{this.sentPinchEvent_=false;this.mightZoom_((()=>{const{direction:direction,center:center,startScaleRatio:startScaleRatio}=e.detail;this.pinchPhase_=direction==="out"?PinchPhase.UPDATE_ZOOM_OUT:PinchPhase.UPDATE_ZOOM_IN;const scaleDelta=startScaleRatio/this.prevScale_;if(this.firstPinchCenterInFrame_!=null){this.pinchPanVector_=vectorDelta(center,this.firstPinchCenterInFrame_)}const needsScrollbars=this.documentNeedsScrollbars(this.zoomManager_.applyBrowserZoom(this.clampZoom_(this.internalZoom_*scaleDelta)));this.pinchCenter_=center;if(!needsScrollbars.horizontal){this.pinchCenter_={x:this.window_.offsetWidth/2,y:this.window_.offsetHeight/2}}else if(this.keepContentCentered_){this.oldCenterInContent_=this.pluginToContent_(this.pinchCenter_);this.keepContentCentered_=false}this.fittingType_=FittingType.NONE;this.setPinchZoomInternal_(scaleDelta,center);this.updateViewport_();this.prevScale_=startScaleRatio}))}))}onPinchEnd_(e){window.requestAnimationFrame((()=>{this.mightZoom_((()=>{const{center:center,startScaleRatio:startScaleRatio}=e.detail;this.pinchPhase_=PinchPhase.END;const scaleDelta=startScaleRatio/this.prevScale_;this.pinchCenter_=center;this.setPinchZoomInternal_(scaleDelta,this.pinchCenter_);this.updateViewport_()}));this.pinchPhase_=PinchPhase.NONE;this.pinchPanVector_=null;this.pinchCenter_=null;this.firstPinchCenterInFrame_=null}))}onPinchStart_(e){if(document.fullscreenElement!==null){return}window.requestAnimationFrame((()=>{this.pinchPhase_=PinchPhase.START;this.prevScale_=1;this.oldCenterInContent_=this.pluginToContent_(e.detail.center);const needsScrollbars=this.documentNeedsScrollbars(this.getZoom());this.keepContentCentered_=!needsScrollbars.horizontal;this.firstPinchCenterInFrame_=e.detail.center}))}onWheel_(e){if(e.detail.direction==="down"){this.goToNextPage()}else{this.goToPreviousPage()}}getGestureDetectorForTesting(){return this.gestureDetector_}onSwipe_(e){if(document.fullscreenElement===null&&!this.fullscreenForTesting_){return}if(e.detail===SwipeDirection.RIGHT_TO_LEFT&&!isRTL()||e.detail===SwipeDirection.LEFT_TO_RIGHT&&isRTL()){this.goToNextPage()}else{this.goToPreviousPage()}}enableFullscreenForTesting(){this.fullscreenForTesting_=true}}var PinchPhase;(function(PinchPhase){PinchPhase[PinchPhase["NONE"]=0]="NONE";PinchPhase[PinchPhase["START"]=1]="START";PinchPhase[PinchPhase["UPDATE_ZOOM_OUT"]=2]="UPDATE_ZOOM_OUT";PinchPhase[PinchPhase["UPDATE_ZOOM_IN"]=3]="UPDATE_ZOOM_IN";PinchPhase[PinchPhase["END"]=4]="END"})(PinchPhase||(PinchPhase={}));const SCROLL_INCREMENT=40;function isCrossFrameKeyEvent(keyEvent){return!!keyEvent.fromPlugin||!!keyEvent.fromScriptingAPI}const PAGE_SHADOW={top:3,bottom:7,left:5,right:5};class ScrollContent{container_;sizer_;target_=null;content_;scrollbarWidth_;plugin_=null;width_=0;height_=0;scrollLeft_=0;scrollTop_=0;unackedScrollsToRemote_=0;constructor(container,sizer,content,scrollbarWidth){this.container_=container;this.sizer_=sizer;this.content_=content;this.scrollbarWidth_=scrollbarWidth}setEventTarget(target){this.target_=target}dispatchScroll_(){this.target_&&this.target_.dispatchEvent(new Event("scroll"))}setContent(content){if(content===null){this.sizer_.style.display="none";return}this.attachContent_(content);this.sizer_.style.display="block";if(!this.plugin_){return}this.plugin_=null;this.updateSize_();this.scrollTo(this.scrollLeft_,this.scrollTop_)}setRemoteContent(content){this.attachContent_(content);const previousScrollLeft=this.scrollLeft;const previousScrollTop=this.scrollTop;this.sizer_.style.display="none";assert(!this.plugin_);this.plugin_=content;this.updateSize_();this.scrollTo(previousScrollLeft,previousScrollTop)}attachContent_(content){if(!content.parentNode){this.content_.appendChild(content)}assert(content.parentNode===this.content_)}syncScrollFromRemote(position){if(this.unackedScrollsToRemote_>0){return}if(this.scrollLeft_===position.x&&this.scrollTop_===position.y){return}this.scrollLeft_=position.x;this.scrollTop_=position.y;this.dispatchScroll_()}ackScrollToRemote(position){assert(this.unackedScrollsToRemote_>0);if(--this.unackedScrollsToRemote_===0){this.scrollLeft_=position.x;this.scrollTop_=position.y}this.dispatchScroll_()}get scrollbarWidth(){return this.scrollbarWidth_}get overlayScrollbarWidth(){let overlayScrollbarWidth=16;return overlayScrollbarWidth}get size(){return{width:this.width_,height:this.height_}}setSize(width,height){this.width_=width;this.height_=height;this.updateSize_()}updateSize_(){if(this.plugin_){this.plugin_.postMessage({type:"updateSize",width:this.width_,height:this.height_})}else{this.sizer_.style.width=`${this.width_}px`;this.sizer_.style.height=`${this.height_}px`}}get scrollLeft(){return this.plugin_?this.scrollLeft_:this.container_.scrollLeft}get scrollTop(){return this.plugin_?this.scrollTop_:this.container_.scrollTop}scrollTo(x,y,isSmooth=false){if(this.plugin_){x=Number.isNaN(x)?0:x;y=Number.isNaN(y)?0:y;const maxX=this.maxScroll_(this.width_,this.container_.clientWidth,this.height_>this.container_.clientHeight);const maxY=this.maxScroll_(this.height_,this.container_.clientHeight,this.width_>this.container_.clientWidth);if(this.container_.dir==="rtl"){x=Math.min(Math.max(-maxX,x),0)}else{x=Math.max(0,Math.min(x,maxX))}y=Math.max(0,Math.min(y,maxY));this.scrollLeft_=x;this.scrollTop_=y;++this.unackedScrollsToRemote_;this.plugin_.postMessage({type:"syncScrollToRemote",x:this.scrollLeft_,y:this.scrollTop_,isSmooth:isSmooth})}else{this.container_.scrollTo(x,y)}}maxScroll_(maxContent,maxContainer,hasScrollbar){if(hasScrollbar){maxContainer-=this.scrollbarWidth_}return maxContent-maxContainer}}function createToken(){const randomBytes=new Uint8Array(16);window.crypto.getRandomValues(randomBytes);return Array.from(randomBytes,(b=>b.toString(16).padStart(2,"0"))).join("")}var PluginControllerEventType;(function(PluginControllerEventType){PluginControllerEventType["FINISH_INK_STROKE"]="PluginControllerEventType.FINISH_INK_STROKE";PluginControllerEventType["START_INK_STROKE"]="PluginControllerEventType.START_INK_STROKE";PluginControllerEventType["UPDATE_INK_THUMBNAIL"]="PluginControllerEventType.UPDATE_INK_THUMBNAIL";PluginControllerEventType["IS_ACTIVE_CHANGED"]="PluginControllerEventType.IS_ACTIVE_CHANGED";PluginControllerEventType["PLUGIN_MESSAGE"]="PluginControllerEventType.PLUGIN_MESSAGE"})(PluginControllerEventType||(PluginControllerEventType={}));class PluginController{eventTarget_=new EventTarget;isActive_=false;plugin_;delayedMessages_=[];viewport_;getIsUserInitiatedCallback_=()=>false;pendingSaveTokens_=new Map;pendingSaveDataBlockTokens_=new Map;requestResolverMap_=new Map;uidCounter_=1;init(plugin,viewport,getIsUserInitiatedCallback){this.viewport_=viewport;this.getIsUserInitiatedCallback_=getIsUserInitiatedCallback;this.pendingSaveTokens_=new Map;this.pendingSaveDataBlockTokens_=new Map;this.requestResolverMap_=new Map;this.setPlugin_(plugin)}get isActive(){return!!this.plugin_&&this.isActive_}set isActive(isActive){const wasActive=this.isActive;this.isActive_=isActive;if(this.isActive===wasActive){return}this.eventTarget_.dispatchEvent(new CustomEvent(PluginControllerEventType.IS_ACTIVE_CHANGED,{detail:this.isActive}))}setPlugin_(plugin){this.plugin_=plugin;this.plugin_.addEventListener("message",(e=>this.handlePluginMessage_(e)),false);if(this.delayedMessages_){this.plugin_.postMessage=(message,transfer)=>{this.delayedMessages_.push({message:message,transfer:transfer})}}this.viewport_.setContent(this.plugin_);this.viewport_.setRemoteContent(this.plugin_)}createUid_(){return this.uidCounter_++}getEventTarget(){return this.eventTarget_}viewportChanged(){}setAnnotationMode(mode){this.postMessage_({type:"setAnnotationMode",mode:mode})}getAnnotationBrush(brushType){return this.postMessageWithReply_({type:"getAnnotationBrush",brushType:brushType})}setAnnotationBrush(brush){const message={type:"setAnnotationBrush",data:brush};this.postMessage_(message)}getAllTextAnnotations(){return this.postMessageWithReply_({type:"getAllTextAnnotations"})}startTextAnnotation(id){const message={type:"startTextAnnotation",data:id};this.postMessage_(message)}finishTextAnnotation(annotation){const message={type:"finishTextAnnotation",data:annotation};this.postMessage_(message)}redo(){this.postMessage_({type:"annotationRedo"})}undo(){this.postMessage_({type:"annotationUndo"})}beforeZoom(){this.postMessage_({type:"stopScrolling"});assert(this.viewport_);if(this.viewport_.pinchPhase===PinchPhase.START){const position=this.viewport_.position;const zoom=this.viewport_.getZoom();const pinchPhase=this.viewport_.pinchPhase;const layoutOptions=this.viewport_.getLayoutOptions();this.postMessage_({type:"viewport",userInitiated:true,zoom:zoom,layoutOptions:layoutOptions,xOffset:position.x,yOffset:position.y,pinchPhase:pinchPhase})}}afterZoom(){assert(this.viewport_);const position=this.viewport_.position;const zoom=this.viewport_.getZoom();const layoutOptions=this.viewport_.getLayoutOptions();const pinchVector=this.viewport_.pinchPanVector||{x:0,y:0};const pinchCenter=this.viewport_.pinchCenter||{x:0,y:0};const pinchPhase=this.viewport_.pinchPhase;this.postMessage_({type:"viewport",userInitiated:this.getIsUserInitiatedCallback_(),zoom:zoom,layoutOptions:layoutOptions,xOffset:position.x,yOffset:position.y,pinchPhase:pinchPhase,pinchX:pinchCenter.x,pinchY:pinchCenter.y,pinchVectorX:pinchVector.x,pinchVectorY:pinchVector.y})}postMessage_(message){assert(this.plugin_);this.plugin_.postMessage(message)}postMessageWithReply_(message){const promiseResolver=new PromiseResolver;message.messageId=`${message.type}_${this.createUid_()}`;this.requestResolverMap_.set(message.messageId,promiseResolver);this.postMessage_(message);return promiseResolver.promise}rotateClockwise(){this.postMessage_({type:"rotateClockwise"})}rotateCounterclockwise(){this.postMessage_({type:"rotateCounterclockwise"})}setDisplayAnnotations(displayAnnotations){this.postMessage_({type:"displayAnnotations",display:displayAnnotations})}setTwoUpView(enableTwoUpView){this.postMessage_({type:"setTwoUpView",enableTwoUpView:enableTwoUpView})}print(){this.postMessage_({type:"print"})}selectAll(){this.postMessage_({type:"selectAll"})}highlightTextFragments(textFragments){this.postMessage_({type:"highlightTextFragments",textFragments:textFragments})}getSelectedText(){return this.postMessageWithReply_({type:"getSelectedText"})}requestThumbnail(pageIndex){return this.postMessageWithReply_({type:"getThumbnail",pageIndex:pageIndex})}resetPrintPreviewMode(printPreviewParams){this.postMessage_({type:"resetPrintPreviewMode",url:printPreviewParams.url,grayscale:printPreviewParams.grayscale,pageCount:printPreviewParams.modifiable?printPreviewParams.pageNumbers.length:0})}setBackgroundColor(color){this.postMessage_({type:"setBackgroundColor",color:color})}loadPreviewPage(url,index){this.postMessage_({type:"loadPreviewPage",url:url,index:index})}getPageBoundingBox(page){return this.postMessageWithReply_({type:"getPageBoundingBox",page:page})}getPasswordComplete(password){this.postMessage_({type:"getPasswordComplete",password:password})}getNamedDestination(destination){return this.postMessageWithReply_({type:"getNamedDestination",namedDestination:destination})}setPresentationMode(enablePresentationMode){this.postMessage_({type:"setPresentationMode",enablePresentationMode:enablePresentationMode})}save(requestType){const resolver=new PromiseResolver;const newToken=createToken();this.pendingSaveTokens_.set(newToken,resolver);this.postMessage_({type:"save",token:newToken,saveRequestType:requestType});return resolver.promise}getSaveDataBlock(requestType,offset,blockSize){const resolver=new PromiseResolver;const newToken=createToken();this.pendingSaveDataBlockTokens_.set(newToken,resolver);this.postMessage_({type:"getSaveDataBlock",token:newToken,saveRequestType:requestType,offset:offset,blockSize:blockSize});return resolver.promise}getSuggestedFileName(requestType){return this.postMessageWithReply_({type:"getSuggestedFileName",saveRequestTypeForTesting:requestType})}releaseSaveInBlockBuffers(){this.postMessage_({type:"releaseSaveInBlockBuffers"})}saveAttachment(index){return this.postMessageWithReply_({type:"saveAttachment",attachmentIndex:index})}bindMessageHandler(port){assert(this.delayedMessages_!==null);assert(this.plugin_);const delayedMessages=this.delayedMessages_;this.delayedMessages_=null;this.plugin_.postMessage=port.postMessage.bind(port);port.onmessage=e=>this.handlePluginMessage_(e);for(const{message:message,transfer:transfer}of delayedMessages){this.plugin_.postMessage(message,transfer)}}handlePluginMessage_(messageEvent){const messageData=messageEvent.data;if(messageData.messageId!==undefined){const resolver=this.requestResolverMap_.get(messageData.messageId)||null;assert(resolver!==null);this.requestResolverMap_.delete(messageData.messageId);resolver.resolve(messageData);return}assert(this.viewport_);switch(messageData.type){case"ackScrollToRemote":this.viewport_.ackScrollToRemote(messageData);break;case"consumeSaveToken":const resolver=this.pendingSaveTokens_.get(messageData.token);assert(resolver);assert(this.pendingSaveTokens_.delete(messageData.token));resolver.resolve(null);break;case"gesture":this.viewport_.dispatchGesture(messageData.gesture);break;case"goToPage":this.viewport_.goToPage(messageData.page);break;case"navigateToDestination":const destinationData=messageData;this.viewport_.handleNavigateToDestination(destinationData.page,destinationData.x,destinationData.y,destinationData.zoom);return;case"saveData":this.saveData_(messageData);break;case"saveDataBlock":this.saveDataBlock_(messageData);break;case"scrollBy":this.viewport_.scrollBy(messageData);break;case"setScrollPosition":this.viewport_.scrollTo(messageData);break;case"setSmoothScrolling":this.viewport_.setSmoothScrolling(messageData.smoothScrolling);return;case"swipe":this.viewport_.dispatchSwipe(messageData.direction);break;case"syncScrollFromRemote":this.viewport_.syncScrollFromRemote(messageData);break;default:this.eventTarget_.dispatchEvent(new CustomEvent(PluginControllerEventType.PLUGIN_MESSAGE,{detail:messageData}))}}saveData_(messageData){const resolver=this.pendingSaveTokens_.get(messageData.token);assert(resolver);assert(this.pendingSaveTokens_.delete(messageData.token));if(!messageData.dataToSave){resolver.reject();return}const MAX_FILE_SIZE=100*1e3*1e3;assert(messageData.dataToSave.byteLength<=MAX_FILE_SIZE,`File too large to be saved: ${messageData.dataToSave.byteLength} bytes.`);verifyPdfHeader(messageData.dataToSave);resolver.resolve(messageData)}saveDataBlock_(messageData){const resolver=this.pendingSaveDataBlockTokens_.get(messageData.token);assert(resolver);assert(this.pendingSaveDataBlockTokens_.delete(messageData.token));if(!messageData.dataToSave){resolver.reject();return}resolver.resolve(messageData)}setPluginForTesting(plugin){this.setPlugin_(plugin)}static getInstance(){return instance$6||(instance$6=new PluginController)}}let instance$6=null;let instance$5=null;function getCss$5(){return instance$5||(instance$5=[...[],css`:host{display:none}`])}function getHtml$3(){return html`
<svg id="baseSvg" xmlns="http://www.w3.org/2000/svg"
     viewBox="0 0 ${this.size} ${this.size}"
     preserveAspectRatio="xMidYMid meet" focusable="false"
     style="pointer-events: none; display: block; width: 100%; height: 100%;">
 </svg>
<slot></slot>
`}const APPLIED_ICON_CLASS="cr-iconset-svg-icon_";class CrIconsetElement extends CrLitElement{static get is(){return"cr-iconset"}static get styles(){return getCss$5()}render(){return getHtml$3.bind(this)()}static get properties(){return{name:{type:String},size:{type:Number}}}#name_accessor_storage="";get name(){return this.#name_accessor_storage}set name(value){this.#name_accessor_storage=value}#size_accessor_storage=24;get size(){return this.#size_accessor_storage}set size(value){this.#size_accessor_storage=value}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("name")){assert(changedProperties.get("name")===undefined);IconsetMap.getInstance().set(this.name,this)}}applyIcon(element,iconName){this.removeIcon(element);const svg=this.cloneIcon_(iconName);if(svg){svg.classList.add(APPLIED_ICON_CLASS);element.shadowRoot.insertBefore(svg,element.shadowRoot.childNodes[0]);return svg}return null}createIcon(iconName){return this.cloneIcon_(iconName)}removeIcon(element){const oldSvg=element.shadowRoot.querySelector(`.${APPLIED_ICON_CLASS}`);if(oldSvg){oldSvg.remove()}}cloneIcon_(id){const sourceSvg=this.querySelector(`g[id="${id}"]`);if(!sourceSvg){return null}const svgClone=this.$.baseSvg.cloneNode(true);const content=sourceSvg.cloneNode(true);content.removeAttribute("id");const contentViewBox=content.getAttribute("viewBox");if(contentViewBox){svgClone.setAttribute("viewBox",contentViewBox)}svgClone.appendChild(content);return svgClone}}customElements.define(CrIconsetElement.is,CrIconsetElement);const div$1=document.createElement("div");div$1.innerHTML=getTrustedHTML`<cr-iconset size="20" name="pdf">
  <svg>
    <defs>
      <g id="add" viewBox="0 -960 960 960"><path d="M444-444H240v-72h204v-204h72v204h204v72H516v204h-72v-204Z"></path></g>
      <g id="attach-file" viewBox="0 -960 960 960"><path d="M696-312q0 89.86-63.07 152.93Q569.86-96 480-96q-91 0-153.5-65.5T264-319v-389q0-65 45.5-110.5T420-864q66 0 111 48t45 115v365q0 40.15-27.93 68.07Q520.15-240 480-240q-41 0-68.5-29.09T384-340v-380h72v384q0 10.4 6.8 17.2 6.8 6.8 17.2 6.8 10.4 0 17.2-6.8 6.8-6.8 6.8-17.2v-372q0-35-24.5-59.5T419.8-792q-35.19 0-59.5 25.5Q336-741 336-706v394q0 60 42 101.5T480-168q60 1 102-43t42-106v-403h72v408Z"></path></g>
      <g id="check" viewBox="0 -960 960 960"><path d="M389-267 195-460l51-52 143 143 325-324 51 51-376 375Z"></path></g>
      <g id="doc-outline" viewBox="0 -960 960 960"><path d="M323.79-288q15.21 0 25.71-10.29t10.5-25.5q0-15.21-10.29-25.71t-25.5-10.5q-15.21 0-25.71 10.29t-10.5 25.5q0 15.21 10.29 25.71t25.5 10.5Zm0-156q15.21 0 25.71-10.29t10.5-25.5q0-15.21-10.29-25.71t-25.5-10.5q-15.21 0-25.71 10.29t-10.5 25.5q0 15.21 10.29 25.71t25.5 10.5Zm0-156q15.21 0 25.71-10.29t10.5-25.5q0-15.21-10.29-25.71t-25.5-10.5q-15.21 0-25.71 10.29t-10.5 25.5q0 15.21 10.29 25.71t25.5 10.5ZM432-288h240v-72H432v72Zm0-156h240v-72H432v72Zm0-156h240v-72H432v72ZM216-144q-29.7 0-50.85-21.15Q144-186.3 144-216v-528q0-29.7 21.15-50.85Q186.3-816 216-816h528q29.7 0 50.85 21.15Q816-773.7 816-744v528q0 29.7-21.15 50.85Q773.7-144 744-144H216Zm0-72h528v-528H216v528Zm0-528v528-528Z"></path></g>
      <g id="fit-to-height" viewBox="0 -960 960 960"><path d="M263.72-96Q234-96 213-117.15T192-168v-624q0-29.7 21.16-50.85Q234.32-864 264.04-864h432.24Q726-864 747-842.85T768-792v624q0 29.7-21.16 50.85Q725.68-96 695.96-96H263.72ZM696-168v-624H264v624h432Zm0-624H264h432ZM360-600h240L480-720 360-600Zm120 360 120-120H360l120 120Z"></path></g>
      <g id="fit-to-width" viewBox="0 -960 960 960"><path d="M168-192q-29.7 0-50.85-21.16Q96-234.32 96-264.04v-432.24Q96-726 117.15-747T168-768h624q29.7 0 50.85 21.16Q864-725.68 864-695.96v432.24Q864-234 842.85-213T792-192H168Zm624-504H168v432h624v-432Zm-624 0v432-432Zm192 336v-240L240-480l120 120Zm360-120L600-600v240l120-120Z"></path></g>
      <g id="fullscreen-exit" viewBox="0 -960 960 960"><path d="M264-144v-120H144v-72h192v192h-72Zm360 0v-192h192v72H696v120h-72ZM144-624v-72h120v-120h72v192H144Zm480 0v-192h72v120h120v72H624Z"></path></g>
      <g id="menu" viewBox="0 -960 960 960"><path d="M144-264v-72h672v72H144Zm0-180v-72h672v72H144Zm0-180v-72h672v72H144Z"></path></g>
      <g id="more" viewBox="0 -960 960 960" width="20px"><path d="M479.79-192Q450-192 429-213.21t-21-51Q408-294 429.21-315t51-21Q510-336 531-314.79t21 51Q552-234 530.79-213t-51 21Zm0-216Q450-408 429-429.21t-21-51Q408-510 429.21-531t51-21Q510-552 531-530.79t21 51Q552-450 530.79-429t-51 21Zm0-216Q450-624 429-645.21t-21-51Q408-726 429.21-747t51-21Q510-768 531-746.79t21 51Q552-666 530.79-645t-51 21Z"></path></g>
      <g id="print" viewBox="0 -960 960 960"><path d="M648-624v-120H312v120h-72v-192h480v192h-72Zm-480 72h625-625Zm539.79 96q15.21 0 25.71-10.29t10.5-25.5q0-15.21-10.29-25.71t-25.5-10.5q-15.21 0-25.71 10.29t-10.5 25.5q0 15.21 10.29 25.71t25.5 10.5ZM648-216v-144H312v144h336Zm72 72H240v-144H96v-240q0-40 28-68t68-28h576q40 0 68 28t28 68v240H720v144Zm73-216v-153.67Q793-530 781-541t-28-11H206q-16.15 0-27.07 11.04Q168-529.92 168-513.6V-360h72v-72h480v72h73Z"></path></g>
      <g id="redo" viewBox="0 -960 960 960"><path d="M384-192q-80 0-136-56t-56-136q0-80 56-136t136-56h246l-93-93 51-51 180 180-180 180-51-51 93-93H384q-50 0-85 35t-35 85q0 50 35 85t85 35h288v72H384Z"></path></g>
      <g id="remove" viewBox="0 -960 960 960"><path d="M232-444v-72h496v72H232Z"></path></g>
      <g id="rotate-left" viewBox="0 -960 960 960"><path d="M528-84q-52 0-98.5-14.5T343-140l52-52q29 17 63 26.5t70 9.5q109 0 186.5-77.5T792-420q0-109-77.5-187.5T522-684l57 57-51 51-144-144 144-144 51 51-57 57q144-3 243 96.5T864-420q0 70-26.5 131t-72 106.5Q720-137 659-110.5T528-84Zm-240-96L48-420l240-240 240 240-240 240Zm0-102 138-138-138-138-138 138 138 138Zm0-138Z"></path></g>
      <g id="thumbnails" viewBox="0 -960 960 960"><path d="M216-144q-29.7 0-50.85-21.5Q144-187 144-216v-528q0-29 21.15-50.5T216-816h528q29.7 0 50.85 21.5Q816-773 816-744v528q0 29-21.15 50.5T744-144H216Zm0-72h528v-528H216v528Zm48-72h432L552-480 444-336l-72-96-108 144Zm-48 72v-528 528Z"></path></g>
      <g id="undo" viewBox="0 -960 960 960"><path d="M288-192v-72h288q50 0 85-35t35-85q0-50-35-85t-85-35H330l93 93-51 51-180-180 180-180 51 51-93 93h246q80 0 136 56t56 136q0 80-56 136t-136 56H288Z"></path></g>

      <g id="add-to-drive" viewBox="0 -960 960 960"><path d="M232-120q-17 0-31.5-8.5t-22.29-22.09L80.79-320.41Q73-334 73-351t8-31l248-427q8-14 22.5-22.5t31.06-8.5h194.88q16.56 0 31.06 8.5t22.42 22.37L811-500q-21-5-42-4.5t-42 4.5L571-768H389L146-351l92 159h337q11 21.17 25.5 39.59Q615-134 634-120H232Zm68-171-27-48 172.95-302H514l110 192q-14.32 13-26.53 28.5T576-388l-96-168-111 194h196q-6 17-9.5 34.7-3.5 17.71-3.5 36.3H300Zm432 147v-108H624v-72h108v-108h72v108h108v72H804v108h-72Z"></path></g>
      <g id="arrow-upward-alt" viewBox="0 -960 960 960"><path d="M440-240v-368L296-464l-56-56 240-240 240 240-56 56-144-144v368h-80Z"></path></g>
      <g id="cancel-unfill" viewBox="0 -960 960 960"><path d="m339-288 141-141 141 141 51-51-141-141 141-141-51-51-141 141-141-141-51 51 141 141-141 141 51 51ZM480-96q-79 0-149-30t-122.5-82.5Q156-261 126-331T96-480q0-80 30-149.5t82.5-122Q261-804 331-834t149-30q80 0 149.5 30t122 82.5Q804-699 834-629.5T864-480q0 79-30 149t-82.5 122.5Q699-156 629.5-126T480-96Zm0-72q130 0 221-91t91-221q0-130-91-221t-221-91q-130 0-221 91t-91 221q0 130 91 221t221 91Zm0-312Z"></path></g>
      <g id="pdf-icon" viewBox="0 -960 960 960"><path d="M612-384h48v-64h48v-48h-48v-32h48v-48h-96v192Zm-360 0h48v-64h36q20.4 0 34.2-13.8Q384-475.6 384-496v-32q0-20.4-13.8-34.2Q356.4-576 336-576h-84v192Zm48-112v-32h36v32h-36Zm132 112h84q20.4 0 34.2-13.8Q564-411.6 564-432v-96q0-20.4-13.8-34.2Q536.4-576 516-576h-84v192Zm48-48v-96h36v96h-36ZM216-144q-29.7 0-50.85-21.15Q144-186.3 144-216v-528q0-29.7 21.15-50.85Q186.3-816 216-816h528q29.7 0 50.85 21.15Q816-773.7 816-744v528q0 29.7-21.15 50.85Q773.7-144 744-144H216Z"></path></g>

    </defs>
  </svg>
</cr-iconset>


  <cr-iconset size="24" name="pdf-ink">
    <svg>
      <defs>
      <g id="annotate" viewBox="0 -960 960 960"><path d="M547-144q-46 0-77-32t-31-80q0-69 62.5-127.5T649-454q-7-48-26-73t-49-25q-35 0-74.5 33.5T418-420q-44 68-85 100t-83 32q-45 0-72.5-31.5T150-402q0-42 20-90.5T231-599q29-41 43.5-70.5T289-719q0-11-4.5-17.5T272-743q-11 0-29 13.5T195-686l-51-50q44-44 73-62t56-18q37 0 62 27t25 68q0 33-19 75.5T287-555q-32 44-49 81.5T221-406q0 20 9 33t23 13q12 0 23.5-6.5T304-390q11-11 23.5-27.5T354-455q57-85 112-127t109-42q60 0 100 46t46 122h95v72h-92q0 95-53.5 167.5T547-144Zm3-71q37 0 69.5-53T652-381q-53 9-97.5 47.5T510-258q0 18 11.5 30.5T550-215Z"></path></g>
      <g id="highlighter-size-1" viewBox="0 -960 960 960"><path d="m268-212-56-56q-12-12-12-28.5t12-28.5l423-423q12-12 28.5-12t28.5 12l56 56q12 12 12 28.5T748-635L324-212q-11 11-28 11t-28-11Z"></path></g>
      <g id="highlighter-size-2" viewBox="0 -960 960 960"><path d="m282-198-84-84q-12-12-12-28.5t12-28.5l423-423q12-12 28.5-12t28.5 12l84 85q11 11 11 28t-11 28L339-198q-12 12-28.5 12T282-198Z"></path></g>
      <g id="highlighter-size-3" viewBox="0 -960 960 960"><path d="M310-170 169-311q-11-11-11-28t11-28l423-424q12-12 29-12t28 12l141 142q11 11 11 28t-11 28L367-170q-12 12-28.5 12T310-170Z"></path></g>
      <g id="highlighter-size-4" viewBox="0 -960 960 960"><path d="M353-127 127-353q-12-12-12-28.5t12-28.5l423-423q12-12 28.5-12t27.5 12l227 226q12 12 12 28.5T833-550L410-127q-12 12-28.5 12T353-127Z"></path></g>
      <g id="highlighter-size-5" viewBox="0 -960 960 960"><path d="M410-70 70-410q-11-11-11-28t11-28l424-424q11-11 27.5-11t28.5 12l340 339q11 11 11 28t-11 28L466-70q-11 11-28 11t-28-11Z"></path></g>
      <g id="ink-eraser" viewBox="0 -960 960 960"><path d="M672-264h192v72H600l72-72Zm-437 72L117-310q-21-21-21.5-50.5T117-412l431-431q22-22 51-22t51.27 22.27L843-650q21 21 21.5 50.5T843-548L487-192H235Zm222-72 335-335-193-193-431 431 97 97h192Zm23-216Z"></path></g>
      <g id="ink-eraser-fill" viewBox="0 -960 960 960"><path d="M672-264h192v72H600l72-72Zm-437 72L117-310q-21-21-21.5-50.5T117-412l431-431q22-22 51-22t51 22l193 193q21 21 21.5 50.5T843-548L487-192H235Z"></path></g>
      <g id="ink-highlighter" viewBox="0 -960 960 960"><path d="m548-410-90-91-193 193 91 91 192-193Zm-38-143 90 91 192-192-90-91-192 192Zm-77-24 192 192-218 218q-22 20-50.5 21.5T308-164l-20 20H96l116-116q-21-20-20-49.5t23-49.5l218-218Zm0 0 218-218q21-21 51-21t51 21l90 90q20 22 20 51t-20 51L625-385 433-577Z"></path></g>
      <g id="ink-highlighter-fill" viewBox="0 -960 960 960"><path d="m407-551 192 192-192 192q-22 20-50.5 21.5T308-164l-20 20H96l116-116q-21-20-20-49.5t23-49.5l192-192Zm52-52 192-192q21-21 51-21t51 21l90 90q20 22 20 51t-20 51L651-411 459-603Z"></path></g>
      <g id="ink-pen" viewBox="0 -960 960 960"><path d="m484-526 42 42 208-208-42-42-208 208ZM216-216h42l218-218-42-42-218 218v42Zm336-192L408-552l136-136-51-51-201 201-51-51 202-201q21-21 50.5-21t50.5 21l51 51 63-63q14-14 34-14t34 14l76 76q14 14 13.5 33.5T802-658L552-408ZM288-144H144v-144l264-264 144 144-264 264Z"></path></g>
      <g id="ink-pen-fill" viewBox="0 -960 960 960"><path d="M602-458 458-602l86-86-51-51-201 201-51-51 202-201q21-21 50.5-21t50.5 21l51 51 63-63q14-14 34-14t34 14l76 76q14 14 13.5 33.5T802-658L602-458ZM288-144H144v-144l263-263 144 144-263 263Z"></path></g>
      <g id="pen-size-1" viewBox="0 -960 960 960"><path d="M199-199q-9-9-9-21t9-21l520-520q9-9 21-9t21 9q9 9 9 21t-9 21L241-199q-9 9-21 9t-21-9Z"></path></g>
      <g id="pen-size-2" viewBox="0 -960 960 960"><path d="M212-212q-11-11-11-28t11-28l480-480q11-12 27.5-12t28.5 12q11 11 11 28t-11 28L268-212q-11 11-28 11t-28-11Z"></path></g>
      <g id="pen-size-3" viewBox="0 -960 960 960"><path d="M218-218q-17-17-17-42t17-42l440-440q17-18 42-17.5t42 17.5q17 17 17.5 42T742-658L302-218q-17 17-42 17.5T218-218Z"></path></g>
      <g id="pen-size-4" viewBox="0 -960 960 960"><path d="M229-229q-29-29-29-71t29-71l360-360q29-29 71-29t71 29q29 29 29 71t-29 71L371-229q-29 29-71 29t-71-29Z"></path></g>
      <g id="pen-size-5" viewBox="0 -960 960 960"><path d="M235-235q-35-35-35-85t35-85l320-320q35-35 85-35t85 35q35 35 35 85t-35 85L405-235q-35 35-85 35t-85-35Z"></path></g>
      <g id="text-align-center" viewBox="0 -960 960 960"><path d="M120-120v-80h720v80H120Zm160-160v-80h400v80H280ZM120-440v-80h720v80H120Zm160-160v-80h400v80H280ZM120-760v-80h720v80H120Z"></path></g>
      <g id="text-align-left" viewBox="0 -960 960 960"><path d="M120-120v-80h720v80H120Zm0-160v-80h480v80H120Zm0-160v-80h720v80H120Zm0-160v-80h480v80H120Zm0-160v-80h720v80H120Z"></path></g>
      <g id="text-align-right" viewBox="0 -960 960 960"><path d="M120-760v-80h720v80H120Zm240 160v-80h480v80H360ZM120-440v-80h720v80H120Zm240 160v-80h480v80H360ZM120-120v-80h720v80H120Z"></path></g>
      <g id="text-annotate" viewBox="0 -960 960 960"><path d="M280-160v-520H80v-120h520v120H400v520H280Zm360 0v-320H520v-120h360v120H760v320H640Z"></path></g>
      <g id="text-format-bold" viewBox="0 -960 960 960"><path d="M272-200v-560h221q65 0 120 40t55 111q0 51-23 78.5T602-491q25 11 55.5 41t30.5 90q0 89-65 124.5T501-200H272Zm121-112h104q48 0 58.5-24.5T566-372q0-11-10.5-35.5T494-432H393v120Zm0-228h93q33 0 48-17t15-38q0-24-17-39t-44-15h-95v109Z"></path></g>
      <g id="text-format-italic" viewBox="0 -960 960 960"><path d="M200-200v-100h160l120-360H320v-100h400v100H580L460-300h140v100H200Z"></path></g>
    </defs>
    </svg>
  </cr-iconset>

`;const iconsets$1=div$1.querySelectorAll("cr-iconset");for(const iconset of iconsets$1){document.head.appendChild(iconset)}function recordFitTo(fittingType){if(fittingType===FittingType.FIT_TO_PAGE){record(UserAction.FIT_TO_PAGE)}else if(fittingType===FittingType.FIT_TO_WIDTH){record(UserAction.FIT_TO_WIDTH)}}function record(action){if(!chrome.metricsPrivate){return}if(!actionsMetric){actionsMetric={metricName:"PDF.Actions",type:chrome.metricsPrivate.MetricTypeType.HISTOGRAM_LOG,min:1,max:UserAction.NUMBER_OF_ACTIONS,buckets:UserAction.NUMBER_OF_ACTIONS+1}}chrome.metricsPrivate.recordValue(actionsMetric,action);if(firstMap.has(action)){const firstAction=firstMap.get(action);if(!firstActionRecorded.has(firstAction)){chrome.metricsPrivate.recordValue(actionsMetric,firstAction);firstActionRecorded.add(firstAction)}}}function recordEnumeration(enumKey,enumValue,enumSize){if(!chrome.metricsPrivate){return}chrome.metricsPrivate.recordEnumerationValue(enumKey,enumValue,enumSize)}function resetForTesting(){firstActionRecorded.clear();actionsMetric=null}let actionsMetric=null;const firstActionRecorded=new Set;var UserAction;(function(UserAction){UserAction[UserAction["DOCUMENT_OPENED"]=0]="DOCUMENT_OPENED";UserAction[UserAction["ROTATE_FIRST"]=1]="ROTATE_FIRST";UserAction[UserAction["ROTATE"]=2]="ROTATE";UserAction[UserAction["FIT_TO_WIDTH_FIRST"]=3]="FIT_TO_WIDTH_FIRST";UserAction[UserAction["FIT_TO_WIDTH"]=4]="FIT_TO_WIDTH";UserAction[UserAction["FIT_TO_PAGE_FIRST"]=5]="FIT_TO_PAGE_FIRST";UserAction[UserAction["FIT_TO_PAGE"]=6]="FIT_TO_PAGE";UserAction[UserAction["FOLLOW_BOOKMARK_FIRST"]=9]="FOLLOW_BOOKMARK_FIRST";UserAction[UserAction["FOLLOW_BOOKMARK"]=10]="FOLLOW_BOOKMARK";UserAction[UserAction["PAGE_SELECTOR_NAVIGATE_FIRST"]=11]="PAGE_SELECTOR_NAVIGATE_FIRST";UserAction[UserAction["PAGE_SELECTOR_NAVIGATE"]=12]="PAGE_SELECTOR_NAVIGATE";UserAction[UserAction["SAVE_FIRST"]=13]="SAVE_FIRST";UserAction[UserAction["SAVE"]=14]="SAVE";UserAction[UserAction["SAVE_WITH_ANNOTATION_FIRST"]=15]="SAVE_WITH_ANNOTATION_FIRST";UserAction[UserAction["SAVE_WITH_ANNOTATION"]=16]="SAVE_WITH_ANNOTATION";UserAction[UserAction["PRINT_FIRST"]=17]="PRINT_FIRST";UserAction[UserAction["PRINT"]=18]="PRINT";UserAction[UserAction["ENTER_ANNOTATION_MODE_FIRST"]=19]="ENTER_ANNOTATION_MODE_FIRST";UserAction[UserAction["ENTER_ANNOTATION_MODE"]=20]="ENTER_ANNOTATION_MODE";UserAction[UserAction["EXIT_ANNOTATION_MODE_FIRST"]=21]="EXIT_ANNOTATION_MODE_FIRST";UserAction[UserAction["EXIT_ANNOTATION_MODE"]=22]="EXIT_ANNOTATION_MODE";UserAction[UserAction["ANNOTATE_STROKE_TOOL_PEN_FIRST"]=23]="ANNOTATE_STROKE_TOOL_PEN_FIRST";UserAction[UserAction["ANNOTATE_STROKE_TOOL_PEN"]=24]="ANNOTATE_STROKE_TOOL_PEN";UserAction[UserAction["ANNOTATE_STROKE_TOOL_ERASER_FIRST"]=25]="ANNOTATE_STROKE_TOOL_ERASER_FIRST";UserAction[UserAction["ANNOTATE_STROKE_TOOL_ERASER"]=26]="ANNOTATE_STROKE_TOOL_ERASER";UserAction[UserAction["ANNOTATE_STROKE_TOOL_HIGHLIGHTER_FIRST"]=27]="ANNOTATE_STROKE_TOOL_HIGHLIGHTER_FIRST";UserAction[UserAction["ANNOTATE_STROKE_TOOL_HIGHLIGHTER"]=28]="ANNOTATE_STROKE_TOOL_HIGHLIGHTER";UserAction[UserAction["ANNOTATE_STROKE_DEVICE_TOUCH_FIRST"]=29]="ANNOTATE_STROKE_DEVICE_TOUCH_FIRST";UserAction[UserAction["ANNOTATE_STROKE_DEVICE_TOUCH"]=30]="ANNOTATE_STROKE_DEVICE_TOUCH";UserAction[UserAction["ANNOTATE_STROKE_DEVICE_MOUSE_FIRST"]=31]="ANNOTATE_STROKE_DEVICE_MOUSE_FIRST";UserAction[UserAction["ANNOTATE_STROKE_DEVICE_MOUSE"]=32]="ANNOTATE_STROKE_DEVICE_MOUSE";UserAction[UserAction["ANNOTATE_STROKE_DEVICE_PEN_FIRST"]=33]="ANNOTATE_STROKE_DEVICE_PEN_FIRST";UserAction[UserAction["ANNOTATE_STROKE_DEVICE_PEN"]=34]="ANNOTATE_STROKE_DEVICE_PEN";UserAction[UserAction["TWO_UP_VIEW_ENABLE_FIRST"]=35]="TWO_UP_VIEW_ENABLE_FIRST";UserAction[UserAction["TWO_UP_VIEW_ENABLE"]=36]="TWO_UP_VIEW_ENABLE";UserAction[UserAction["TWO_UP_VIEW_DISABLE_FIRST"]=37]="TWO_UP_VIEW_DISABLE_FIRST";UserAction[UserAction["TWO_UP_VIEW_DISABLE"]=38]="TWO_UP_VIEW_DISABLE";UserAction[UserAction["ZOOM_IN_FIRST"]=39]="ZOOM_IN_FIRST";UserAction[UserAction["ZOOM_IN"]=40]="ZOOM_IN";UserAction[UserAction["ZOOM_OUT_FIRST"]=41]="ZOOM_OUT_FIRST";UserAction[UserAction["ZOOM_OUT"]=42]="ZOOM_OUT";UserAction[UserAction["ZOOM_CUSTOM_FIRST"]=43]="ZOOM_CUSTOM_FIRST";UserAction[UserAction["ZOOM_CUSTOM"]=44]="ZOOM_CUSTOM";UserAction[UserAction["THUMBNAIL_NAVIGATE_FIRST"]=45]="THUMBNAIL_NAVIGATE_FIRST";UserAction[UserAction["THUMBNAIL_NAVIGATE"]=46]="THUMBNAIL_NAVIGATE";UserAction[UserAction["SAVE_ORIGINAL_ONLY_FIRST"]=47]="SAVE_ORIGINAL_ONLY_FIRST";UserAction[UserAction["SAVE_ORIGINAL_ONLY"]=48]="SAVE_ORIGINAL_ONLY";UserAction[UserAction["SAVE_ORIGINAL_FIRST"]=49]="SAVE_ORIGINAL_FIRST";UserAction[UserAction["SAVE_ORIGINAL"]=50]="SAVE_ORIGINAL";UserAction[UserAction["SAVE_EDITED_FIRST"]=51]="SAVE_EDITED_FIRST";UserAction[UserAction["SAVE_EDITED"]=52]="SAVE_EDITED";UserAction[UserAction["TOGGLE_SIDENAV_FIRST"]=53]="TOGGLE_SIDENAV_FIRST";UserAction[UserAction["TOGGLE_SIDENAV"]=54]="TOGGLE_SIDENAV";UserAction[UserAction["SELECT_SIDENAV_THUMBNAILS_FIRST"]=55]="SELECT_SIDENAV_THUMBNAILS_FIRST";UserAction[UserAction["SELECT_SIDENAV_THUMBNAILS"]=56]="SELECT_SIDENAV_THUMBNAILS";UserAction[UserAction["SELECT_SIDENAV_OUTLINE_FIRST"]=57]="SELECT_SIDENAV_OUTLINE_FIRST";UserAction[UserAction["SELECT_SIDENAV_OUTLINE"]=58]="SELECT_SIDENAV_OUTLINE";UserAction[UserAction["TOGGLE_DISPLAY_ANNOTATIONS_FIRST"]=59]="TOGGLE_DISPLAY_ANNOTATIONS_FIRST";UserAction[UserAction["TOGGLE_DISPLAY_ANNOTATIONS"]=60]="TOGGLE_DISPLAY_ANNOTATIONS";UserAction[UserAction["PRESENT_FIRST"]=61]="PRESENT_FIRST";UserAction[UserAction["PRESENT"]=62]="PRESENT";UserAction[UserAction["PROPERTIES_FIRST"]=63]="PROPERTIES_FIRST";UserAction[UserAction["PROPERTIES"]=64]="PROPERTIES";UserAction[UserAction["SELECT_SIDENAV_ATTACHMENT_FIRST"]=65]="SELECT_SIDENAV_ATTACHMENT_FIRST";UserAction[UserAction["SELECT_SIDENAV_ATTACHMENT"]=66]="SELECT_SIDENAV_ATTACHMENT";UserAction[UserAction["CUT_FIRST"]=67]="CUT_FIRST";UserAction[UserAction["CUT"]=68]="CUT";UserAction[UserAction["COPY_FIRST"]=69]="COPY_FIRST";UserAction[UserAction["COPY"]=70]="COPY";UserAction[UserAction["PASTE_FIRST"]=71]="PASTE_FIRST";UserAction[UserAction["PASTE"]=72]="PASTE";UserAction[UserAction["FIND_IN_PAGE_FIRST"]=73]="FIND_IN_PAGE_FIRST";UserAction[UserAction["FIND_IN_PAGE"]=74]="FIND_IN_PAGE";UserAction[UserAction["COPY_SEARCHIFIED_FIRST"]=75]="COPY_SEARCHIFIED_FIRST";UserAction[UserAction["COPY_SEARCHIFIED"]=76]="COPY_SEARCHIFIED";UserAction[UserAction["FIND_IN_PAGE_SEARCHIFIED_FIRST"]=77]="FIND_IN_PAGE_SEARCHIFIED_FIRST";UserAction[UserAction["FIND_IN_PAGE_SEARCHIFIED"]=78]="FIND_IN_PAGE_SEARCHIFIED";UserAction[UserAction["ENTER_INK2_ANNOTATION_MODE_FIRST"]=79]="ENTER_INK2_ANNOTATION_MODE_FIRST";UserAction[UserAction["ENTER_INK2_ANNOTATION_MODE"]=80]="ENTER_INK2_ANNOTATION_MODE";UserAction[UserAction["EXIT_INK2_ANNOTATION_MODE_FIRST"]=81]="EXIT_INK2_ANNOTATION_MODE_FIRST";UserAction[UserAction["EXIT_INK2_ANNOTATION_MODE"]=82]="EXIT_INK2_ANNOTATION_MODE";UserAction[UserAction["SAVE_WITH_INK2_ANNOTATION_FIRST"]=83]="SAVE_WITH_INK2_ANNOTATION_FIRST";UserAction[UserAction["SAVE_WITH_INK2_ANNOTATION"]=84]="SAVE_WITH_INK2_ANNOTATION";UserAction[UserAction["SELECT_INK2_BRUSH_ERASER_FIRST"]=85]="SELECT_INK2_BRUSH_ERASER_FIRST";UserAction[UserAction["SELECT_INK2_BRUSH_ERASER"]=86]="SELECT_INK2_BRUSH_ERASER";UserAction[UserAction["SELECT_INK2_BRUSH_HIGHLIGHTER_FIRST"]=87]="SELECT_INK2_BRUSH_HIGHLIGHTER_FIRST";UserAction[UserAction["SELECT_INK2_BRUSH_HIGHLIGHTER"]=88]="SELECT_INK2_BRUSH_HIGHLIGHTER";UserAction[UserAction["SELECT_INK2_BRUSH_PEN_FIRST"]=89]="SELECT_INK2_BRUSH_PEN_FIRST";UserAction[UserAction["SELECT_INK2_BRUSH_PEN"]=90]="SELECT_INK2_BRUSH_PEN";UserAction[UserAction["UNDO_INK2_FIRST"]=91]="UNDO_INK2_FIRST";UserAction[UserAction["UNDO_INK2"]=92]="UNDO_INK2";UserAction[UserAction["REDO_INK2_FIRST"]=93]="REDO_INK2_FIRST";UserAction[UserAction["REDO_INK2"]=94]="REDO_INK2";UserAction[UserAction["OPEN_INK2_SIDE_PANEL_FIRST"]=95]="OPEN_INK2_SIDE_PANEL_FIRST";UserAction[UserAction["OPEN_INK2_SIDE_PANEL"]=96]="OPEN_INK2_SIDE_PANEL";UserAction[UserAction["OPEN_INK2_BOTTOM_TOOLBAR_FIRST"]=97]="OPEN_INK2_BOTTOM_TOOLBAR_FIRST";UserAction[UserAction["OPEN_INK2_BOTTOM_TOOLBAR"]=98]="OPEN_INK2_BOTTOM_TOOLBAR";UserAction[UserAction["SAVE_SEARCHIFIED_FIRST"]=99]="SAVE_SEARCHIFIED_FIRST";UserAction[UserAction["SAVE_SEARCHIFIED"]=100]="SAVE_SEARCHIFIED";UserAction[UserAction["ENTER_INK2_TEXT_ANNOTATION_MODE_FIRST"]=101]="ENTER_INK2_TEXT_ANNOTATION_MODE_FIRST";UserAction[UserAction["ENTER_INK2_TEXT_ANNOTATION_MODE"]=102]="ENTER_INK2_TEXT_ANNOTATION_MODE";UserAction[UserAction["EXIT_INK2_TEXT_ANNOTATION_MODE_FIRST"]=103]="EXIT_INK2_TEXT_ANNOTATION_MODE_FIRST";UserAction[UserAction["EXIT_INK2_TEXT_ANNOTATION_MODE"]=104]="EXIT_INK2_TEXT_ANNOTATION_MODE";UserAction[UserAction["NUMBER_OF_ACTIONS"]=105]="NUMBER_OF_ACTIONS"})(UserAction||(UserAction={}));function createFirstMap(){const entries=Object.entries(UserAction).filter((x=>Number.isInteger(x[1]))).sort(((a,b)=>a[1]-b[1]));const entriesWithFirst=entries.slice(1,entries.length-1);const map=new Map;for(let i=0;i<entriesWithFirst.length-1;i+=2){map.set(entriesWithFirst[i+1][1],entriesWithFirst[i][1])}return map}const firstMap=createFirstMap();const div=document.createElement("div");div.innerHTML=getTrustedHTML`
<cr-iconset name="cr20" size="20">
  <svg>
    <defs>
      <!--
      Keep these in sorted order by id="".
      -->
      <g id="block">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M10 0C4.48 0 0 4.48 0 10C0 15.52 4.48 20 10 20C15.52 20 20 15.52 20 10C20 4.48 15.52 0 10 0ZM2 10C2 5.58 5.58 2 10 2C11.85 2 13.55 2.63 14.9 3.69L3.69 14.9C2.63 13.55 2 11.85 2 10ZM5.1 16.31C6.45 17.37 8.15 18 10 18C14.42 18 18 14.42 18 10C18 8.15 17.37 6.45 16.31 5.1L5.1 16.31Z">
        </path>
      </g>
      <g id="cloud-off">
        <path
          d="M16 18.125L13.875 16H5C3.88889 16 2.94444 15.6111 2.16667 14.8333C1.38889 14.0556 1 13.1111 1 12C1 10.9444 1.36111 10.0347 2.08333 9.27083C2.80556 8.50694 3.6875 8.09028 4.72917 8.02083C4.77083 7.86805 4.8125 7.72222 4.85417 7.58333C4.90972 7.44444 4.97222 7.30555 5.04167 7.16667L1.875 4L2.9375 2.9375L17.0625 17.0625L16 18.125ZM5 14.5H12.375L6.20833 8.33333C6.15278 8.51389 6.09722 8.70139 6.04167 8.89583C6 9.07639 5.95139 9.25694 5.89583 9.4375L4.83333 9.52083C4.16667 9.57639 3.61111 9.84028 3.16667 10.3125C2.72222 10.7708 2.5 11.3333 2.5 12C2.5 12.6944 2.74306 13.2847 3.22917 13.7708C3.71528 14.2569 4.30556 14.5 5 14.5ZM17.5 15.375L16.3958 14.2917C16.7153 14.125 16.9792 13.8819 17.1875 13.5625C17.3958 13.2431 17.5 12.8889 17.5 12.5C17.5 11.9444 17.3056 11.4722 16.9167 11.0833C16.5278 10.6944 16.0556 10.5 15.5 10.5H14.125L14 9.14583C13.9028 8.11806 13.4722 7.25694 12.7083 6.5625C11.9444 5.85417 11.0417 5.5 10 5.5C9.65278 5.5 9.31944 5.54167 9 5.625C8.69444 5.70833 8.39583 5.82639 8.10417 5.97917L7.02083 4.89583C7.46528 4.61806 7.93056 4.40278 8.41667 4.25C8.91667 4.08333 9.44444 4 10 4C11.4306 4 12.6736 4.48611 13.7292 5.45833C14.7847 6.41667 15.375 7.59722 15.5 9C16.4722 9 17.2986 9.34028 17.9792 10.0208C18.6597 10.7014 19 11.5278 19 12.5C19 13.0972 18.8611 13.6458 18.5833 14.1458C18.3194 14.6458 17.9583 15.0556 17.5 15.375Z">
        </path>
      </g>
      <g id="delete">
        <path
          d="M 5.832031 17.5 C 5.375 17.5 4.984375 17.335938 4.65625 17.011719 C 4.328125 16.683594 4.167969 16.292969 4.167969 15.832031 L 4.167969 5 L 3.332031 5 L 3.332031 3.332031 L 7.5 3.332031 L 7.5 2.5 L 12.5 2.5 L 12.5 3.332031 L 16.667969 3.332031 L 16.667969 5 L 15.832031 5 L 15.832031 15.832031 C 15.832031 16.292969 15.671875 16.683594 15.34375 17.011719 C 15.015625 17.335938 14.625 17.5 14.167969 17.5 Z M 14.167969 5 L 5.832031 5 L 5.832031 15.832031 L 14.167969 15.832031 Z M 7.5 14.167969 L 9.167969 14.167969 L 9.167969 6.667969 L 7.5 6.667969 Z M 10.832031 14.167969 L 12.5 14.167969 L 12.5 6.667969 L 10.832031 6.667969 Z M 5.832031 5 L 5.832031 15.832031 Z M 5.832031 5 ">
        </path>
      </g>
      <g id="domain" viewBox="0 -960 960 960">
        <path d="M96-144v-672h384v144h384v528H96Zm72-72h72v-72h-72v72Zm0-152h72v-72h-72v72Zm0-152h72v-72h-72v72Zm0-152h72v-72h-72v72Zm168 456h72v-72h-72v72Zm0-152h72v-72h-72v72Zm0-152h72v-72h-72v72Zm0-152h72v-72h-72v72Zm144 456h312v-384H480v80h72v72h-72v80h72v72h-72v80Zm168-232v-72h72v72h-72Zm0 152v-72h72v72h-72Z"></path>
      </g>
      <g id="kite">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M4.6327 8.00094L10.3199 2L16 8.00094L10.1848 16.8673C10.0995 16.9873 10.0071 17.1074 9.90047 17.2199C9.42417 17.7225 8.79147 18 8.11611 18C7.44076 18 6.80806 17.7225 6.33175 17.2199C5.85545 16.7173 5.59242 16.0497 5.59242 15.3371C5.59242 14.977 5.46445 14.647 5.22275 14.3919C4.98104 14.1369 4.66825 14.0019 4.32701 14.0019H4V12.6667H4.32701C5.00237 12.6667 5.63507 12.9442 6.11137 13.4468C6.58768 13.9494 6.85071 14.617 6.85071 15.3296C6.85071 15.6896 6.97867 16.0197 7.22038 16.2747C7.46209 16.5298 7.77488 16.6648 8.11611 16.6648C8.45735 16.6648 8.77014 16.5223 9.01185 16.2747C9.02396 16.2601 9.03607 16.246 9.04808 16.2319C9.08541 16.1883 9.12176 16.1458 9.15403 16.0947L9.55213 15.4946L4.6327 8.00094ZM10.3199 13.9371L6.53802 8.17116L10.3199 4.1814L14.0963 8.17103L10.3199 13.9371Z">
        </path>
      </g>
      <g id="menu">
        <path d="M2 4h16v2H2zM2 9h16v2H2zM2 14h16v2H2z"></path>
      </g>
      <g id="password">
        <path d="M5.833 11.667c.458 0 .847-.16 1.167-.479.333-.333.5-.729.5-1.188s-.167-.847-.5-1.167a1.555 1.555 0 0 0-1.167-.5c-.458 0-.854.167-1.188.5A1.588 1.588 0 0 0 4.166 10c0 .458.16.854.479 1.188.333.319.729.479 1.188.479Zm0 3.333c-1.389 0-2.569-.486-3.542-1.458C1.319 12.569.833 11.389.833 10c0-1.389.486-2.569 1.458-3.542C3.264 5.486 4.444 5 5.833 5c.944 0 1.813.243 2.604.729a4.752 4.752 0 0 1 1.833 1.979h7.23c.458 0 .847.167 1.167.5.333.319.5.708.5 1.167v3.958c0 .458-.167.854-.5 1.188A1.588 1.588 0 0 1 17.5 15h-3.75a1.658 1.658 0 0 1-1.188-.479 1.658 1.658 0 0 1-.479-1.188v-1.042H10.27a4.59 4.59 0 0 1-1.813 2A5.1 5.1 0 0 1 5.833 15Zm3.292-4.375h4.625v2.708H15v-1.042a.592.592 0 0 1 .167-.438.623.623 0 0 1 .458-.188c.181 0 .327.063.438.188a.558.558 0 0 1 .188.438v1.042H17.5V9.375H9.125a3.312 3.312 0 0 0-1.167-1.938 3.203 3.203 0 0 0-2.125-.77 3.21 3.21 0 0 0-2.354.979C2.827 8.298 2.5 9.083 2.5 10s.327 1.702.979 2.354a3.21 3.21 0 0 0 2.354.979c.806 0 1.514-.25 2.125-.75.611-.514 1-1.167 1.167-1.958Z"></path>
      </g>
      
  </svg>
</cr-iconset>

<!-- NOTE: In the common case that the final icon will be 20x20, export the SVG
     at 20px and place it in the section above. -->
<cr-iconset name="cr" size="24">
  <svg>
    <defs>
      <!--
      These icons are copied from Polymer's iron-icons and kept in sorted order.
      -->
      <g id="add">
        <path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z" />
      </g>
      <g id="arrow-back">
        <path
          d="m7.824 13 5.602 5.602L12 20l-8-8 8-8 1.426 1.398L7.824 11H20v2Zm0 0">
        </path>
      </g>
      <g id="arrow-drop-up">
        <path d="M7 14l5-5 5 5z"></path>
      </g>
      <g id="arrow-drop-down">
        <path d="M7 10l5 5 5-5z"></path>
      </g>
      <g id="arrow-forward">
        <path
          d="M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8z">
        </path>
      </g>
      <g id="arrow-right">
        <path d="M10 7l5 5-5 5z"></path>
      </g>
      <g id="cancel">
        <path
          d="M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm5 13.59L15.59 17 12 13.41 8.41 17 7 15.59 10.59 12 7 8.41 8.41 7 12 10.59 15.59 7 17 8.41 13.41 12 17 15.59z">
        </path>
      </g>
      <g id="check">
        <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"></path>
      </g>
      <g id="check-circle" viewBox="0 -960 960 960">
        <path d="m424-296 282-282-56-56-226 226-114-114-56 56 170 170Zm56 216q-83 0-156-31.5T197-197q-54-54-85.5-127T80-480q0-83 31.5-156T197-763q54-54 127-85.5T480-880q83 0 156 31.5T763-763q54 54 85.5 127T880-480q0 83-31.5 156T763-197q-54 54-127 85.5T480-80Zm0-80q134 0 227-93t93-227q0-134-93-227t-227-93q-134 0-227 93t-93 227q0 134 93 227t227 93Zm0-320Z"></path>
      </g>
      <g id="chevron-left">
        <path d="M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z"></path>
      </g>
      <g id="chevron-right">
        <path d="M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6z"></path>
      </g>
      <g id="clear">
        <path
          d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z">
        </path>
      </g>
      <g id="chrome-product" viewBox="0 -960 960 960">
        <path d="M336-479q0 60 42 102t102 42q60 0 102-42t42-102q0-60-42-102t-102-42q-60 0-102 42t-42 102Zm144 216q11 0 22.5-.5T525-267L427-99q-144-16-237.5-125T96-479q0-43 9.5-84.5T134-645l160 274q28 51 78 79.5T480-263Zm0-432q-71 0-126.5 42T276-545l-98-170q53-71 132.5-109.5T480-863q95 0 179 45t138 123H480Zm356 72q15 35 21.5 71t6.5 73q0 155-100 260.5T509-96l157-275q14-25 22-52t8-56q0-40-15-77t-41-67h196Z">
        </path>
      </g>
      <g id="close">
        <path
          d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z">
        </path>
      </g>
      <g id="computer">
        <path
          d="M20 18c1.1 0 1.99-.9 1.99-2L22 6c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2H0v2h24v-2h-4zM4 6h16v10H4V6z">
        </path>
      </g>
      <g id="create">
        <path
          d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04c.39-.39.39-1.02 0-1.41l-2.34-2.34c-.39-.39-1.02-.39-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z">
        </path>
      </g>
      <g id="delete" viewBox="0 -960 960 960">
        <path
          d="M309.37-135.87q-34.48 0-58.74-24.26-24.26-24.26-24.26-58.74v-474.5h-53.5v-83H378.5v-53.5h202.52v53.5h206.11v83h-53.5v474.07q0 35.21-24.26 59.32t-58.74 24.11H309.37Zm341.26-557.5H309.37v474.5h341.26v-474.5ZM379.7-288.24h77.5v-336h-77.5v336Zm123.1 0h77.5v-336h-77.5v336ZM309.37-693.37v474.5-474.5Z">
        </path>
      </g>
      <g id="domain">
        <path
          d="M12 7V3H2v18h20V7H12zM6 19H4v-2h2v2zm0-4H4v-2h2v2zm0-4H4V9h2v2zm0-4H4V5h2v2zm4 12H8v-2h2v2zm0-4H8v-2h2v2zm0-4H8V9h2v2zm0-4H8V5h2v2zm10 12h-8v-2h2v-2h-2v-2h2v-2h-2V9h8v10zm-2-8h-2v2h2v-2zm0 4h-2v2h2v-2z">
        </path>
      </g>
      <!-- source: https://fonts.google.com/icons?selected=Material+Symbols+Outlined:family_link:FILL@0;wght@0;GRAD@0;opsz@24&icon.size=24&icon.color=%23e8eaed -->
      <g id="kite" viewBox="0 -960 960 960">
        <path
          d="M390-40q-51 0-90.5-30.5T246-149q-6-23-25-37t-43-14q-16 0-30 6.5T124-175l-61-51q21-26 51.5-40t63.5-14q51 0 91 30t54 79q6 23 25 37t42 14q19 0 34-10t26-25l1-2-276-381q-8-11-11.5-23t-3.5-24q0-16 6-30.5t18-26.5l260-255q11-11 26-17t30-6q15 0 30 6t26 17l260 255q12 12 18 26.5t6 30.5q0 12-3.5 24T825-538L500-88q-18 25-48 36.5T390-40Zm110-185 260-360-260-255-259 256 259 359Zm1-308Z"/>
        </path>
      </g>
      <g id="error">
        <path
          d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z">
        </path>
      </g>
      <g id="error-outline">
        <path
          d="M11 15h2v2h-2zm0-8h2v6h-2zm.99-5C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z">
        </path>
      </g>
      <g id="expand-less">
        <path d="M12 8l-6 6 1.41 1.41L12 10.83l4.59 4.58L18 14z"></path>
      </g>
      <g id="expand-more">
        <path d="M16.59 8.59L12 13.17 7.41 8.59 6 10l6 6 6-6z"></path>
      </g>
      <g id="extension">
        <path
          d="M20.5 11H19V7c0-1.1-.9-2-2-2h-4V3.5C13 2.12 11.88 1 10.5 1S8 2.12 8 3.5V5H4c-1.1 0-1.99.9-1.99 2v3.8H3.5c1.49 0 2.7 1.21 2.7 2.7s-1.21 2.7-2.7 2.7H2V20c0 1.1.9 2 2 2h3.8v-1.5c0-1.49 1.21-2.7 2.7-2.7 1.49 0 2.7 1.21 2.7 2.7V22H17c1.1 0 2-.9 2-2v-4h1.5c1.38 0 2.5-1.12 2.5-2.5S21.88 11 20.5 11z">
        </path>
      </g>
      <g id="file-download" viewBox="0 -960 960 960">
        <path d="M480-336 288-528l51-51 105 105v-342h72v342l105-105 51 51-192 192ZM263.72-192Q234-192 213-213.15T192-264v-72h72v72h432v-72h72v72q0 29.7-21.16 50.85Q725.68-192 695.96-192H263.72Z"></path>
      </g>
      <g id="fullscreen">
        <path
          d="M7 14H5v5h5v-2H7v-3zm-2-4h2V7h3V5H5v5zm12 7h-3v2h5v-5h-2v3zM14 5v2h3v3h2V5h-5z">
        </path>
      </g>
      <g id="group">
        <path
          d="M16 11c1.66 0 2.99-1.34 2.99-3S17.66 5 16 5c-1.66 0-3 1.34-3 3s1.34 3 3 3zm-8 0c1.66 0 2.99-1.34 2.99-3S9.66 5 8 5C6.34 5 5 6.34 5 8s1.34 3 3 3zm0 2c-2.33 0-7 1.17-7 3.5V19h14v-2.5c0-2.33-4.67-3.5-7-3.5zm8 0c-.29 0-.62.02-.97.05 1.16.84 1.97 1.97 1.97 3.45V19h6v-2.5c0-2.33-4.67-3.5-7-3.5z">
        </path>
      </g>
      <g id="help-outline">
        <path
          d="M11 18h2v-2h-2v2zm1-16C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm0-14c-2.21 0-4 1.79-4 4h2c0-1.1.9-2 2-2s2 .9 2 2c0 2-3 1.75-3 5h2c0-2.25 3-2.5 3-5 0-2.21-1.79-4-4-4z">
        </path>
      </g>
      <g id="history">
        <path
          d="M12.945312 22.75 C 10.320312 22.75 8.074219 21.839844 6.207031 20.019531 C 4.335938 18.199219 3.359375 15.972656 3.269531 13.34375 L 5.089844 13.34375 C 5.175781 15.472656 5.972656 17.273438 7.480469 18.742188 C 8.988281 20.210938 10.808594 20.945312 12.945312 20.945312 C 15.179688 20.945312 17.070312 20.164062 18.621094 18.601562 C 20.167969 17.039062 20.945312 15.144531 20.945312 12.910156 C 20.945312 10.714844 20.164062 8.855469 18.601562 7.335938 C 17.039062 5.816406 15.15625 5.054688 12.945312 5.054688 C 11.710938 5.054688 10.554688 5.339844 9.480469 5.902344 C 8.402344 6.46875 7.476562 7.226562 6.699219 8.179688 L 9.585938 8.179688 L 9.585938 9.984375 L 3.648438 9.984375 L 3.648438 4.0625 L 5.453125 4.0625 L 5.453125 6.824219 C 6.386719 5.707031 7.503906 4.828125 8.804688 4.199219 C 10.109375 3.566406 11.488281 3.25 12.945312 3.25 C 14.300781 3.25 15.570312 3.503906 16.761719 4.011719 C 17.949219 4.519531 18.988281 5.214844 19.875 6.089844 C 20.761719 6.964844 21.464844 7.992188 21.976562 9.167969 C 22.492188 10.34375 22.75 11.609375 22.75 12.964844 C 22.75 14.316406 22.492188 15.589844 21.976562 16.777344 C 21.464844 17.964844 20.761719 19.003906 19.875 19.882812 C 18.988281 20.765625 17.949219 21.464844 16.761719 21.976562 C 15.570312 22.492188 14.300781 22.75 12.945312 22.75 Z M 16.269531 17.460938 L 12.117188 13.34375 L 12.117188 7.527344 L 13.921875 7.527344 L 13.921875 12.601562 L 17.550781 16.179688 Z M 16.269531 17.460938">
        </path>
      </g>
      <g id="info">
        <path
          d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-6h2v6zm0-8h-2V7h2v2z">
        </path>
      </g>
      <g id="info-outline">
        <path
          d="M11 17h2v-6h-2v6zm1-15C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zM11 9h2V7h-2v2z">
        </path>
      </g>
      <g id="insert-drive-file">
        <path
          d="M6 2c-1.1 0-1.99.9-1.99 2L4 20c0 1.1.89 2 1.99 2H18c1.1 0 2-.9 2-2V8l-6-6H6zm7 7V3.5L18.5 9H13z">
        </path>
      </g>
      <g id="location-on">
        <path
          d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z">
        </path>
      </g>
      <g id="mic">
        <path
          d="M12 14c1.66 0 2.99-1.34 2.99-3L15 5c0-1.66-1.34-3-3-3S9 3.34 9 5v6c0 1.66 1.34 3 3 3zm5.3-3c0 3-2.54 5.1-5.3 5.1S6.7 14 6.7 11H5c0 3.41 2.72 6.23 6 6.72V21h2v-3.28c3.28-.48 6-3.3 6-6.72h-1.7z">
        </path>
      </g>
      <g id="more-vert">
        <path
          d="M12 8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm0 2c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0 6c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z">
        </path>
      </g>
      <g id="open-in-new" viewBox="0 -960 960 960">
        <path
          d="M216-144q-29.7 0-50.85-21.15Q144-186.3 144-216v-528q0-29.7 21.15-50.85Q186.3-816 216-816h264v72H216v528h528v-264h72v264q0 29.7-21.15 50.85Q773.7-144 744-144H216Zm171-192-51-51 357-357H576v-72h240v240h-72v-117L387-336Z">
        </path>
      </g>
      <g id="person">
        <path
          d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z">
        </path>
      </g>
      <g id="phonelink">
        <path
          d="M4 6h18V4H4c-1.1 0-2 .9-2 2v11H0v3h14v-3H4V6zm19 2h-6c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h6c.55 0 1-.45 1-1V9c0-.55-.45-1-1-1zm-1 9h-4v-7h4v7z">
        </path>
      </g>
      <g id="print">
        <path
          d="M19 8H5c-1.66 0-3 1.34-3 3v6h4v4h12v-4h4v-6c0-1.66-1.34-3-3-3zm-3 11H8v-5h8v5zm3-7c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-1-9H6v4h12V3z">
        </path>
      </g>
      <g id="schedule">
        <path
          d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm.5-13H11v6l5.25 3.15.75-1.23-4.5-2.67z">
        </path>
      </g>
      <g id="search">
        <path
          d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z">
        </path>
      </g>
      <g id="security">
        <path
          d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm0 10.99h7c-.53 4.12-3.28 7.79-7 8.94V12H5V6.3l7-3.11v8.8z">
        </path>
      </g>
      <!-- The <g> IDs are exposed as global variables in Vulcanized mode, which
        conflicts with the "settings" namespace of MD Settings. Using an "_icon"
        suffix prevents the naming conflict. -->
      <g id="settings_icon">
        <path
          d="M19.43 12.98c.04-.32.07-.64.07-.98s-.03-.66-.07-.98l2.11-1.65c.19-.15.24-.42.12-.64l-2-3.46c-.12-.22-.39-.3-.61-.22l-2.49 1c-.52-.4-1.08-.73-1.69-.98l-.38-2.65C14.46 2.18 14.25 2 14 2h-4c-.25 0-.46.18-.49.42l-.38 2.65c-.61.25-1.17.59-1.69.98l-2.49-1c-.23-.09-.49 0-.61.22l-2 3.46c-.13.22-.07.49.12.64l2.11 1.65c-.04.32-.07.65-.07.98s.03.66.07.98l-2.11 1.65c-.19.15-.24.42-.12.64l2 3.46c.12.22.39.3.61.22l2.49-1c.52.4 1.08.73 1.69.98l.38 2.65c.03.24.24.42.49.42h4c.25 0 .46-.18.49-.42l.38-2.65c.61-.25 1.17-.59 1.69-.98l2.49 1c.23.09.49 0 .61-.22l2-3.46c.12-.22.07-.49-.12-.64l-2.11-1.65zM12 15.5c-1.93 0-3.5-1.57-3.5-3.5s1.57-3.5 3.5-3.5 3.5 1.57 3.5 3.5-1.57 3.5-3.5 3.5z">
        </path>
      </g>
      <g id="star">
        <path
          d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z">
        </path>
      </g>
      <g id="sync" viewBox="0 -960 960 960">
        <path
          d="M216-192v-72h74q-45-40-71.5-95.5T192-480q0-101 61-177.5T408-758v75q-63 23-103.5 77.5T264-480q0 48 19.5 89t52.5 70v-63h72v192H216Zm336-10v-75q63-23 103.5-77.5T696-480q0-48-19.5-89T624-639v63h-72v-192h192v72h-74q45 40 71.5 95.5T768-480q0 101-61 177.5T552-202Z">
        </path>
      </g>
      <g id="thumbs-down">
        <path
            d="M6 3h11v13l-7 7-1.25-1.25a1.454 1.454 0 0 1-.3-.475c-.067-.2-.1-.392-.1-.575v-.35L9.45 16H3c-.533 0-1-.2-1.4-.6-.4-.4-.6-.867-.6-1.4v-2c0-.117.017-.242.05-.375s.067-.258.1-.375l3-7.05c.15-.333.4-.617.75-.85C5.25 3.117 5.617 3 6 3Zm9 2H6l-3 7v2h9l-1.35 5.5L15 15.15V5Zm0 10.15V5v10.15Zm2 .85v-2h3V5h-3V3h5v13h-5Z">
        </path>
      </g>
      <g id="thumbs-down-filled">
        <path
            d="M6 3h10v13l-7 7-1.25-1.25a1.336 1.336 0 0 1-.29-.477 1.66 1.66 0 0 1-.108-.574v-.347L8.449 16H3c-.535 0-1-.2-1.398-.602C1.199 15 1 14.535 1 14v-2c0-.117.012-.242.04-.375.022-.133.062-.258.108-.375l3-7.05c.153-.333.403-.618.75-.848A1.957 1.957 0 0 1 6 3Zm12 13V3h4v13Zm0 0">
        </path>
      </g>
      <g id="thumbs-up">
        <path
            d="M18 21H7V8l7-7 1.25 1.25c.117.117.208.275.275.475.083.2.125.392.125.575v.35L14.55 8H21c.533 0 1 .2 1.4.6.4.4.6.867.6 1.4v2c0 .117-.017.242-.05.375s-.067.258-.1.375l-3 7.05c-.15.333-.4.617-.75.85-.35.233-.717.35-1.1.35Zm-9-2h9l3-7v-2h-9l1.35-5.5L9 8.85V19ZM9 8.85V19 8.85ZM7 8v2H4v9h3v2H2V8h5Z">
        </path>
      </g>
      <g id="thumbs-up-filled">
        <path
            d="M18 21H8V8l7-7 1.25 1.25c.117.117.21.273.29.477.073.199.108.39.108.574v.347L15.551 8H21c.535 0 1 .2 1.398.602C22.801 9 23 9.465 23 10v2c0 .117-.012.242-.04.375a1.897 1.897 0 0 1-.108.375l-3 7.05a2.037 2.037 0 0 1-.75.848A1.957 1.957 0 0 1 18 21ZM6 8v13H2V8Zm0 0">
      </g>
      <g id="videocam" viewBox="0 -960 960 960">
        <path
          d="M216-192q-29 0-50.5-21.5T144-264v-432q0-29.7 21.5-50.85Q187-768 216-768h432q29.7 0 50.85 21.15Q720-725.7 720-696v168l144-144v384L720-432v168q0 29-21.15 50.5T648-192H216Zm0-72h432v-432H216v432Zm0 0v-432 432Z">
        </path>
      </g>
      <g id="warning">
        <path d="M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z"></path>
      </g>
    </defs>
  </svg>
</cr-iconset>`;const iconsets=div.querySelectorAll("cr-iconset");for(const iconset of iconsets){document.head.appendChild(iconset)}let instance$4=null;function getCss$4(){return instance$4||(instance$4=[...[getCss$9()],css`:host{--cr-button-background-color:transparent;--cr-button-border-color:var(--color-button-border,var(--cr-fallback-color-tonal-outline));--cr-button-text-color:var(--color-button-foreground,var(--cr-fallback-color-primary));--cr-button-ripple-opacity:1;--cr-button-ripple-color:var(--cr-active-background-color);--cr-button-disabled-background-color:transparent;--cr-button-disabled-border-color:var(--color-button-border-disabled,var(--cr-fallback-color-disabled-background));--cr-button-disabled-text-color:var(--color-button-foreground-disabled,var(--cr-fallback-color-disabled-foreground))}:host(.action-button){--cr-button-background-color:var(--color-button-background-prominent,var(--cr-fallback-color-primary));--cr-button-text-color:var(--color-button-foreground-prominent,var(--cr-fallback-color-on-primary));--cr-button-ripple-color:var(--cr-active-on-primary-background-color);--cr-button-border:none;--cr-button-disabled-background-color:var(--color-button-background-prominent-disabled,var(--cr-fallback-color-disabled-background));--cr-button-disabled-text-color:var(--color-button-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--cr-button-disabled-border:none}:host(.tonal-button),:host(.floating-button){--cr-button-background-color:var(--color-button-background-tonal,var(--cr-fallback-color-secondary-container));--cr-button-text-color:var(--color-button-foreground-tonal,var(--cr-fallback-color-on-tonal-container));--cr-button-border:none;--cr-button-disabled-background-color:var(--color-button-background-tonal-disabled,var(--cr-fallback-color-disabled-background));--cr-button-disabled-text-color:var(--color-button-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--cr-button-disabled-border:none}:host{flex-shrink:0;display:inline-flex;align-items:center;justify-content:center;box-sizing:border-box;min-width:5.14em;height:var(--cr-button-height);padding:8px 16px;outline-width:0;overflow:hidden;position:relative;cursor:pointer;user-select:none;-webkit-tap-highlight-color:transparent;border:var(--cr-button-border,1px solid var(--cr-button-border-color));border-radius:100px;background:var(--cr-button-background-color);color:var(--cr-button-text-color);font-weight:500;line-height:20px;isolation:isolate}@media (forced-colors:active){:host{forced-color-adjust:none}}:host(.floating-button){border-radius:8px;height:40px;transition:box-shadow 80ms linear}:host(.floating-button:hover){box-shadow:var(--cr-elevation-3)}:host([has-prefix-icon_]),:host([has-suffix-icon_]){--iron-icon-height:20px;--iron-icon-width:20px;--icon-block-padding-large:16px;--icon-block-padding-small:12px;gap:8px;padding-block-end:8px;padding-block-start:8px}:host([has-prefix-icon_]){padding-inline-end:var(--icon-block-padding-large);padding-inline-start:var(--icon-block-padding-small)}:host([has-suffix-icon_]){padding-inline-end:var(--icon-block-padding-small);padding-inline-start:var(--icon-block-padding-large)}:host-context(.focus-outline-visible):host(:focus){box-shadow:none;outline:2px solid var(--cr-focus-outline-color);outline-offset:2px}#background{border-radius:inherit;inset:0;pointer-events:none;position:absolute}#content{display:inline}#hoverBackground{content:'';display:none;inset:0;pointer-events:none;position:absolute;z-index:1}:host(:hover) #hoverBackground{background:var(--cr-hover-background-color);display:block}:host(.action-button:hover) #hoverBackground{background:var(--cr-hover-on-prominent-background-color)}:host([disabled]){background:var(--cr-button-disabled-background-color);border:var(--cr-button-disabled-border,1px solid var(--cr-button-disabled-border-color));color:var(--cr-button-disabled-text-color);cursor:auto;pointer-events:none}:host(.cancel-button){margin-inline-end:8px}:host(.action-button),:host(.cancel-button){line-height:154%}#ink{color:var(--cr-button-ripple-color);--paper-ripple-opacity:var(--cr-button-ripple-opacity)}#background{z-index:0}#hoverBackground,cr-ripple{z-index:1}#content,::slotted(*){z-index:2}`])}function getHtml$2(){return html`
<div id="background"></div>
<slot id="prefixIcon" name="prefix-icon"
    @slotchange="${this.onPrefixIconSlotChanged_}">
</slot>
<span id="content"><slot></slot></span>
<slot id="suffixIcon" name="suffix-icon"
    @slotchange="${this.onSuffixIconSlotChanged_}">
</slot>
<div id="hoverBackground" part="hoverBackground"></div>`}const CrButtonElementBase=CrRippleMixin(CrLitElement);class CrButtonElement extends CrButtonElementBase{static get is(){return"cr-button"}static get styles(){return getCss$4()}render(){return getHtml$2.bind(this)()}static get properties(){return{disabled:{type:Boolean,reflect:true},hasPrefixIcon_:{type:Boolean,reflect:true},hasSuffixIcon_:{type:Boolean,reflect:true}}}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#hasPrefixIcon__accessor_storage=false;get hasPrefixIcon_(){return this.#hasPrefixIcon__accessor_storage}set hasPrefixIcon_(value){this.#hasPrefixIcon__accessor_storage=value}#hasSuffixIcon__accessor_storage=false;get hasSuffixIcon_(){return this.#hasSuffixIcon__accessor_storage}set hasSuffixIcon_(value){this.#hasSuffixIcon__accessor_storage=value}spaceKeyDown_=false;timeoutIds_=new Set;constructor(){super();this.addEventListener("blur",this.onBlur_.bind(this));this.addEventListener("click",this.onClick_.bind(this));this.addEventListener("keydown",this.onKeyDown_.bind(this));this.addEventListener("keyup",this.onKeyUp_.bind(this));this.ensureRippleOnPointerdown()}firstUpdated(){if(!this.hasAttribute("role")){this.setAttribute("role","button")}if(!this.hasAttribute("tabindex")){this.setAttribute("tabindex","0")}FocusOutlineManager.forDocument(document)}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("disabled")){this.setAttribute("aria-disabled",this.disabled?"true":"false");this.disabledChanged_(this.disabled,changedProperties.get("disabled"))}}disconnectedCallback(){super.disconnectedCallback();this.timeoutIds_.forEach(clearTimeout);this.timeoutIds_.clear()}setTimeout_(fn,delay){if(!this.isConnected){return}const id=setTimeout((()=>{this.timeoutIds_.delete(id);fn()}),delay);this.timeoutIds_.add(id)}disabledChanged_(newValue,oldValue){if(!newValue&&oldValue===undefined){return}if(this.disabled){this.blur()}this.setAttribute("tabindex",String(this.disabled?-1:0))}onBlur_(){this.spaceKeyDown_=false;this.setTimeout_((()=>this.getRipple().uiUpAction()),100)}onClick_(e){if(this.disabled){e.stopImmediatePropagation()}}onPrefixIconSlotChanged_(){this.hasPrefixIcon_=this.$.prefixIcon.assignedElements().length>0}onSuffixIconSlotChanged_(){this.hasSuffixIcon_=this.$.suffixIcon.assignedElements().length>0}onKeyDown_(e){if(e.key!==" "&&e.key!=="Enter"){return}e.preventDefault();e.stopPropagation();if(e.repeat){return}this.getRipple().uiDownAction();if(e.key==="Enter"){this.click();this.setTimeout_((()=>this.getRipple().uiUpAction()),100)}else if(e.key===" "){this.spaceKeyDown_=true}}onKeyUp_(e){if(e.key!==" "&&e.key!=="Enter"){return}e.preventDefault();e.stopPropagation();if(this.spaceKeyDown_&&e.key===" "){this.spaceKeyDown_=false;this.click();this.getRipple().uiUpAction()}}}customElements.define(CrButtonElement.is,CrButtonElement);let instance$3=null;function getCss$3(){return instance$3||(instance$3=[...[],css`.icon-arrow-back{--cr-icon-image:url(//resources/images/icon_arrow_back.svg)}.icon-arrow-dropdown{--cr-icon-image:url(//resources/images/icon_arrow_dropdown.svg)}.icon-arrow-drop-down-cr23{--cr-icon-image:url(//resources/images/icon_arrow_drop_down_cr23.svg)}.icon-arrow-drop-up-cr23{--cr-icon-image:url(//resources/images/icon_arrow_drop_up_cr23.svg)}.icon-arrow-upward{--cr-icon-image:url(//resources/images/icon_arrow_upward.svg)}.icon-cancel{--cr-icon-image:url(//resources/images/icon_cancel.svg)}.icon-clear{--cr-icon-image:url(//resources/images/icon_clear.svg)}.icon-copy-content{--cr-icon-image:url(//resources/images/icon_copy_content.svg)}.icon-delete-gray{--cr-icon-image:url(//resources/images/icon_delete_gray.svg)}.icon-edit{--cr-icon-image:url(//resources/images/icon_edit.svg)}.icon-file{--cr-icon-image:url(//resources/images/icon_filetype_generic.svg)}.icon-folder-open{--cr-icon-image:url(//resources/images/icon_folder_open.svg)}.icon-picture-delete{--cr-icon-image:url(//resources/images/icon_picture_delete.svg)}.icon-expand-less{--cr-icon-image:url(//resources/images/icon_expand_less.svg)}.icon-expand-more{--cr-icon-image:url(//resources/images/icon_expand_more.svg)}.icon-external{--cr-icon-image:url(//resources/images/open_in_new.svg)}.icon-more-vert{--cr-icon-image:url(//resources/images/icon_more_vert.svg)}.icon-refresh{--cr-icon-image:url(//resources/images/icon_refresh.svg)}.icon-search{--cr-icon-image:url(//resources/images/icon_search.svg)}.icon-settings{--cr-icon-image:url(//resources/images/icon_settings.svg)}.icon-visibility{--cr-icon-image:url(//resources/images/icon_visibility.svg)}.icon-visibility-off{--cr-icon-image:url(//resources/images/icon_visibility_off.svg)}.subpage-arrow{--cr-icon-image:url(//resources/images/arrow_right.svg)}.cr-icon{-webkit-mask-image:var(--cr-icon-image);-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-icon-size);background-color:var(--cr-icon-color,var(--google-grey-700));flex-shrink:0;height:var(--cr-icon-ripple-size);margin-inline-end:var(--cr-icon-ripple-margin);margin-inline-start:var(--cr-icon-button-margin-start);user-select:none;width:var(--cr-icon-ripple-size)}:host-context([dir=rtl]) .cr-icon{transform:scaleX(-1)}.cr-icon.no-overlap{margin-inline-end:0;margin-inline-start:0}@media (prefers-color-scheme:dark){.cr-icon{background-color:var(--cr-icon-color,var(--google-grey-500))}}`])}let instance$2=null;function getCss$2(){return instance$2||(instance$2=[...[],css`.cr-scrollable{anchor-name:--cr-scrollable;anchor-scope:--cr-scrollable;container-type:scroll-state;overflow:auto}.cr-scrollable-top,.cr-scrollable-top-shadow,.cr-scrollable-bottom{display:none;position:fixed;position-anchor:--cr-scrollable;left:anchor(left);width:anchor-size(width);pointer-events:none;&:where(.force-on){display:block}}.cr-scrollable-top{top:anchor(top);border-top:1px solid var(--cr-scrollable-border-color);@container scroll-state(scrollable:top){display:block}}.cr-scrollable-bottom{bottom:anchor(bottom);border-bottom:1px solid var(--cr-scrollable-border-color);@container scroll-state(scrollable:bottom){display:block}}.cr-scrollable-top-shadow{box-shadow:inset 0 5px 6px -3px rgba(0,0,0,.4);display:block;height:8px;opacity:0;top:anchor(top);transition:opacity 500ms;z-index:1;&:where(.force-on){opacity:1}@container scroll-state(scrollable:top){opacity:1}}`])}let instance$1=null;function getCss$1(){return instance$1||(instance$1=[...[getCss$9(),getCss$3(),getCss$2()],css`dialog{background-color:var(--cr-dialog-background-color,white);border:0;border-radius:var(--cr-dialog-border-radius,8px);bottom:50%;box-shadow:0 0 16px rgba(0,0,0,0.12),0 16px 16px rgba(0,0,0,0.24);color:inherit;line-height:20px;max-height:initial;max-width:initial;overflow-y:hidden;padding:0;position:absolute;top:50%;width:var(--cr-dialog-width,512px)}@media (prefers-color-scheme:dark){dialog{background-color:var(--cr-dialog-background-color,var(--google-grey-900));background-image:linear-gradient(rgba(255,255,255,.04),rgba(255,255,255,.04))}}@media (forced-colors:active){dialog{border:var(--cr-border-hcm)}}dialog[open] #content-wrapper{display:flex;flex-direction:column;max-height:100vh;overflow:auto}.top-container,:host ::slotted([slot=button-container]),:host ::slotted([slot=footer]){flex-shrink:0}dialog::backdrop{background-color:rgba(0,0,0,0.6);bottom:0;left:0;position:fixed;right:0;top:0}:host ::slotted([slot=body]){color:var(--cr-secondary-text-color);padding:0 var(--cr-dialog-body-padding-horizontal,20px)}:host ::slotted([slot=title]){color:var(--cr-primary-text-color);flex:1;font-family:var(--cr-dialog-font-family,inherit);font-size:var(--cr-dialog-title-font-size,calc(15 / 13 * 100%));line-height:1;padding-bottom:var(--cr-dialog-title-slot-padding-bottom,16px);padding-inline-end:var(--cr-dialog-title-slot-padding-end,20px);padding-inline-start:var(--cr-dialog-title-slot-padding-start,20px);padding-top:var(--cr-dialog-title-slot-padding-top,20px)}:host ::slotted([slot=button-container]){display:flex;justify-content:flex-end;padding-bottom:var(--cr-dialog-button-container-padding-bottom,16px);padding-inline-end:var(--cr-dialog-button-container-padding-horizontal,16px);padding-inline-start:var(--cr-dialog-button-container-padding-horizontal,16px);padding-top:var(--cr-dialog-button-container-padding-top,16px)}:host ::slotted([slot=footer]){border-bottom-left-radius:inherit;border-bottom-right-radius:inherit;border-top:1px solid #dbdbdb;margin:0;padding:16px 20px}:host([hide-backdrop]) dialog::backdrop{opacity:0}@media (prefers-color-scheme:dark){:host ::slotted([slot=footer]){border-top-color:var(--cr-separator-color)}}.body-container{box-sizing:border-box;display:flex;flex-direction:column;min-height:1.375rem;overflow:auto}.top-container{align-items:flex-start;display:flex;min-height:var(--cr-dialog-top-container-min-height,31px)}.title-container{display:flex;flex:1;font-size:inherit;font-weight:inherit;margin:0;outline:none}#close{align-self:flex-start;margin-inline-end:4px;margin-top:4px}@container style(--cr-dialog-body-border-top){.cr-scrollable-top{display:block;border-top:var(--cr-dialog-body-border-top)}}`])}function getHtml$1(){return html`
<dialog id="dialog" @close="${this.onNativeDialogClose_}"
    @cancel="${this.onNativeDialogCancel_}" part="dialog"
    aria-labelledby="title"
    aria-description="${this.ariaDescriptionText||nothing}">
<!-- This wrapper is necessary, such that the "pulse" animation is not
    erroneously played when the user clicks on the outer-most scrollbar. -->
  <div id="content-wrapper" part="wrapper">
    <div class="top-container">
      <h2 id="title" class="title-container" tabindex="-1">
        <slot name="title"></slot>
      </h2>
      ${this.showCloseButton?html`
        <cr-icon-button id="close" class="icon-clear"
            aria-label="${this.closeText||nothing}"
            title="${this.closeText||nothing}"
            @click="${this.cancel}" @keypress="${this.onCloseKeypress_}">
        </cr-icon-button>
       `:""}
    </div>
    <slot name="header"></slot>
    <div class="body-container cr-scrollable" id="container"
        part="body-container">
      <div class="cr-scrollable-top"></div>
      <slot name="body"></slot>
      <div class="cr-scrollable-bottom"></div>
    </div>
    <slot name="button-container"></slot>
    <slot name="footer"></slot>
  </div>
</dialog>`}class CrDialogElement extends CrLitElement{static get is(){return"cr-dialog"}static get styles(){return getCss$1()}render(){return getHtml$1.bind(this)()}static get properties(){return{open:{type:Boolean,reflect:true},closeText:{type:String},ignorePopstate:{type:Boolean},ignoreEnterKey:{type:Boolean},consumeKeydownEvent:{type:Boolean},noCancel:{type:Boolean},showCloseButton:{type:Boolean},showOnAttach:{type:Boolean},ariaDescriptionText:{type:String}}}#closeText_accessor_storage;get closeText(){return this.#closeText_accessor_storage}set closeText(value){this.#closeText_accessor_storage=value}#consumeKeydownEvent_accessor_storage=false;get consumeKeydownEvent(){return this.#consumeKeydownEvent_accessor_storage}set consumeKeydownEvent(value){this.#consumeKeydownEvent_accessor_storage=value}#ignoreEnterKey_accessor_storage=false;get ignoreEnterKey(){return this.#ignoreEnterKey_accessor_storage}set ignoreEnterKey(value){this.#ignoreEnterKey_accessor_storage=value}#ignorePopstate_accessor_storage=false;get ignorePopstate(){return this.#ignorePopstate_accessor_storage}set ignorePopstate(value){this.#ignorePopstate_accessor_storage=value}#noCancel_accessor_storage=false;get noCancel(){return this.#noCancel_accessor_storage}set noCancel(value){this.#noCancel_accessor_storage=value}#open_accessor_storage=false;get open(){return this.#open_accessor_storage}set open(value){this.#open_accessor_storage=value}#showCloseButton_accessor_storage=false;get showCloseButton(){return this.#showCloseButton_accessor_storage}set showCloseButton(value){this.#showCloseButton_accessor_storage=value}#showOnAttach_accessor_storage=false;get showOnAttach(){return this.#showOnAttach_accessor_storage}set showOnAttach(value){this.#showOnAttach_accessor_storage=value}#ariaDescriptionText_accessor_storage;get ariaDescriptionText(){return this.#ariaDescriptionText_accessor_storage}set ariaDescriptionText(value){this.#ariaDescriptionText_accessor_storage=value}mutationObserver_=null;boundKeydown_=null;firstUpdated(){window.addEventListener("popstate",(()=>{if(!this.ignorePopstate&&this.$.dialog.open){this.cancel()}}));if(!this.ignoreEnterKey){this.addEventListener("keypress",this.onKeypress_.bind(this))}this.addEventListener("pointerdown",(e=>this.onPointerdown_(e)))}connectedCallback(){super.connectedCallback();const mutationObserverCallback=()=>{if(this.$.dialog.open){this.addKeydownListener_()}else{this.removeKeydownListener_()}};this.mutationObserver_=new MutationObserver(mutationObserverCallback);this.mutationObserver_.observe(this.$.dialog,{attributes:true,attributeFilter:["open"]});mutationObserverCallback();if(this.showOnAttach){this.showModal()}}disconnectedCallback(){super.disconnectedCallback();this.removeKeydownListener_();if(this.mutationObserver_){this.mutationObserver_.disconnect();this.mutationObserver_=null}}addKeydownListener_(){if(!this.consumeKeydownEvent){return}this.boundKeydown_=this.boundKeydown_||this.onKeydown_.bind(this);this.addEventListener("keydown",this.boundKeydown_);document.body.addEventListener("keydown",this.boundKeydown_)}removeKeydownListener_(){if(!this.boundKeydown_){return}this.removeEventListener("keydown",this.boundKeydown_);document.body.removeEventListener("keydown",this.boundKeydown_);this.boundKeydown_=null}async showModal(){if(this.showOnAttach){const element=this.querySelector("[autofocus]");if(element&&element instanceof CrLitElement&&!element.shadowRoot){element.ensureInitialRender()}}this.$.dialog.showModal();assert(this.$.dialog.open);this.open=true;await this.updateComplete;this.fire("cr-dialog-open")}cancel(){this.fire("cancel");this.$.dialog.close();assert(!this.$.dialog.open);this.open=false}close(){this.$.dialog.close("success");assert(!this.$.dialog.open);this.open=false}setTitleAriaLabel(title){this.$.dialog.removeAttribute("aria-labelledby");this.$.dialog.setAttribute("aria-label",title)}onCloseKeypress_(e){e.stopPropagation()}onNativeDialogClose_(e){if(e.target!==this.getNative()){return}this.fire("close")}async onNativeDialogCancel_(e){if(e.target!==this.getNative()){return}if(this.noCancel){e.preventDefault();return}this.open=false;await this.updateComplete;this.fire("cancel")}getNative(){return this.$.dialog}onKeypress_(e){if(e.key!=="Enter"){return}const accept=e.target===this||e.composedPath().some((el=>el.tagName==="CR-INPUT"&&el.type!=="search"));if(!accept){return}const actionButton=this.querySelector(".action-button:not([disabled]):not([hidden])");if(actionButton){actionButton.click();e.preventDefault()}}onKeydown_(e){assert(this.consumeKeydownEvent);if(!this.getNative().open){return}if(this.ignoreEnterKey&&e.key==="Enter"){return}e.stopPropagation()}onPointerdown_(e){if(e.button!==0||e.composedPath()[0].tagName!=="DIALOG"){return}this.$.dialog.animate([{transform:"scale(1)",offset:0},{transform:"scale(1.02)",offset:.4},{transform:"scale(1.02)",offset:.6},{transform:"scale(1)",offset:1}],{duration:180,easing:"ease-in-out",iterations:1});e.preventDefault()}focus(){const titleContainer=this.shadowRoot.querySelector(".title-container");assert(titleContainer);titleContainer.focus()}}customElements.define(CrDialogElement.is,CrDialogElement);var ViewMode;(function(ViewMode){ViewMode["FIT"]="fit";ViewMode["FIT_B"]="fitb";ViewMode["FIT_BH"]="fitbh";ViewMode["FIT_BV"]="fitbv";ViewMode["FIT_H"]="fith";ViewMode["FIT_R"]="fitr";ViewMode["FIT_V"]="fitv";ViewMode["XYZ"]="xyz"})(ViewMode||(ViewMode={}));const FRAGMENT_DIRECTIVE_DELIMITER=":~:";class OpenPdfParamsParser{getNamedDestinationCallback_;getPageBoundingBoxCallback_;pageCount_;viewportDimensions_;constructor(getNamedDestinationCallback,getPageBoundingBoxCallback){this.getNamedDestinationCallback_=getNamedDestinationCallback;this.getPageBoundingBoxCallback_=getPageBoundingBoxCallback}calculateRectZoomLevel_(size){if(size.height===0||size.width===0){return 0}assert(this.viewportDimensions_);return Math.min(this.viewportDimensions_.height/size.height,this.viewportDimensions_.width/size.width)}parseZoomParam_(paramValue){const paramValueSplit=paramValue.split(",");if(paramValueSplit.length!==1&&paramValueSplit.length!==3){return{}}const zoomFactor=parseFloat(paramValueSplit[0])/100;if(Number.isNaN(zoomFactor)){return{}}if(paramValueSplit.length===1){return{zoom:zoomFactor}}const position={x:parseFloat(paramValueSplit[1]),y:parseFloat(paramValueSplit[2])};return{position:position,zoom:zoomFactor}}async parseViewParam_(paramValue,pageNumber){assert(pageNumber>0);if(this.pageCount_){assert(pageNumber<=this.pageCount_)}const viewModeComponents=paramValue.toLowerCase().split(",");if(viewModeComponents.length===0){return{}}const params={};const viewMode=viewModeComponents[0];let acceptsPositionParam=false;switch(viewMode){case ViewMode.FIT:params["view"]=FittingType.FIT_TO_PAGE;break;case ViewMode.FIT_H:params["view"]=FittingType.FIT_TO_WIDTH;acceptsPositionParam=true;break;case ViewMode.FIT_V:params["view"]=FittingType.FIT_TO_HEIGHT;acceptsPositionParam=true;break;case ViewMode.FIT_B:if(this.pageCount_){params["view"]=FittingType.FIT_TO_BOUNDING_BOX;params["boundingBox"]=await this.getPageBoundingBoxCallback_(pageNumber-1)}break;case ViewMode.FIT_BH:if(this.pageCount_){params["view"]=FittingType.FIT_TO_BOUNDING_BOX_WIDTH;params["boundingBox"]=await this.getPageBoundingBoxCallback_(pageNumber-1);acceptsPositionParam=true}break;case ViewMode.FIT_BV:if(this.pageCount_){params["view"]=FittingType.FIT_TO_BOUNDING_BOX_HEIGHT;params["boundingBox"]=await this.getPageBoundingBoxCallback_(pageNumber-1);acceptsPositionParam=true}break;case ViewMode.FIT_R:case ViewMode.XYZ:break}if(!acceptsPositionParam||viewModeComponents.length===1){return params}const position=parseFloat(viewModeComponents[1]);if(!Number.isNaN(position)){params["viewPosition"]=position}return params}async parseNameddestViewParam_(paramValue,pageNumber){const viewModeComponents=paramValue.toLowerCase().split(",");assert(viewModeComponents.length>0);const viewMode=viewModeComponents[0];const params={};if(viewMode===ViewMode.XYZ&&viewModeComponents.length===4){const x=parseFloat(viewModeComponents[1]);const y=parseFloat(viewModeComponents[2]);const zoom=parseFloat(viewModeComponents[3]);assert(zoom!==0);if(!Number.isNaN(zoom)){params["zoom"]=zoom}if(!Number.isNaN(x)||!Number.isNaN(y)){params["position"]={x:x,y:y}}return params}if(viewMode===ViewMode.FIT_R&&viewModeComponents.length===5){assert(this.viewportDimensions_!==undefined);let x1=parseFloat(viewModeComponents[1]);let y1=parseFloat(viewModeComponents[2]);let x2=parseFloat(viewModeComponents[3]);let y2=parseFloat(viewModeComponents[4]);if(!Number.isNaN(x1)&&!Number.isNaN(y1)&&!Number.isNaN(x2)&&!Number.isNaN(y2)){if(x1>x2){[x1,x2]=[x2,x1]}if(y1>y2){[y1,y2]=[y2,y1]}const rectSize={width:x2-x1,height:y2-y1};params["position"]={x:x1,y:y1};const zoom=this.calculateRectZoomLevel_(rectSize);if(zoom!==0){params["zoom"]=zoom}}return params}return this.parseViewParam_(paramValue,pageNumber)}parseUrlParams_(url){const hash=new URL(url).hash;const params=new URLSearchParams(hash.substring(1));if(Array.from(params).length===1){const key=Array.from(params.keys())[0];if(params.get(key)===""){params.append("nameddest",key);params.delete(key)}}return params}setPageCount(pageCount){this.pageCount_=pageCount}setViewportDimensions(dimensions){this.viewportDimensions_=dimensions}shouldShowToolbar(url){const urlParams=this.parseUrlParams_(url);const navpanes=urlParams.get("navpanes");const toolbar=urlParams.get("toolbar");return navpanes==="1"||toolbar!=="0"}shouldShowSidenav(url,sidenavCollapsed){const urlParams=this.parseUrlParams_(url);const navpanes=urlParams.get("navpanes");const toolbar=urlParams.get("toolbar");if(navpanes===null&&toolbar===null){return!sidenavCollapsed}return navpanes==="1"}getTextFragments(url){const hashSplit=url.split("#");if(hashSplit.length!==2){return[]}const hash=hashSplit[1];assert(hash!==undefined);const fragmentDirectiveSplit=hash.split(FRAGMENT_DIRECTIVE_DELIMITER);if(fragmentDirectiveSplit.length!==2){return[]}const fragmentDirective=fragmentDirectiveSplit[1];assert(fragmentDirective!==undefined);const textFragmentDirectives=[];for(const param of fragmentDirective.split("&")){const[key,value]=param.split("=");if(key==="text"&&value){textFragmentDirectives.push(value)}}return textFragmentDirectives}async getViewportFromUrlParams(url){const params={url:url};const urlParams=this.parseUrlParams_(url);let pageNumber=1;if(urlParams.has("page")){pageNumber=parseInt(urlParams.get("page"),10);if(!Number.isNaN(pageNumber)&&this.pageCount_){if(pageNumber<1){pageNumber=1}else if(pageNumber>this.pageCount_){pageNumber=this.pageCount_}params["page"]=pageNumber-1}}if(urlParams.has("view")){Object.assign(params,await this.parseViewParam_(urlParams.get("view"),pageNumber))}if(urlParams.has("zoom")){Object.assign(params,this.parseZoomParam_(urlParams.get("zoom")))}if(params.page===undefined&&urlParams.has("nameddest")){const data=await this.getNamedDestinationCallback_(urlParams.get("nameddest"));if(data.pageNumber!==-1){params.page=data.pageNumber;pageNumber=data.pageNumber}if(data.namedDestinationView){Object.assign(params,await this.parseNameddestViewParam_(data.namedDestinationView,pageNumber))}return params}return params}}function getHtml(){return html`<!--_html_template_start_-->
<cr-dialog id="dialog" no-cancel show-on-attach>
  <div slot="title">$i18n{errorDialogTitle}</div>
  <div slot="body">$i18n{pageLoadFailed}</div>
  <div slot="button-container" ?hidden="${!this.reloadFn}">
    <cr-button class="action-button" @click="${this.onReload_}">
      $i18n{pageReload}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}class ViewerErrorDialogElement extends CrLitElement{static get is(){return"viewer-error-dialog"}static get styles(){return getCss$9()}render(){return getHtml.bind(this)()}static get properties(){return{reloadFn:{type:Object}}}#reloadFn_accessor_storage;get reloadFn(){return this.#reloadFn_accessor_storage}set reloadFn(value){this.#reloadFn_accessor_storage=value}onReload_(){if(this.reloadFn){this.reloadFn()}}}customElements.define(ViewerErrorDialogElement.is,ViewerErrorDialogElement);function convertDocumentDimensionsMessage(message){return message}function convertFormFocusChangeMessage(message){return message}function convertLoadProgressMessage(message){return message}let instance=null;function getCss(){return instance||(instance=[...[],css`#content{height:100%;position:fixed;width:100%;z-index:1}#plugin{display:block;height:100%;position:absolute;width:100%}#sizer{position:absolute;z-index:0}`])}function getScrollbarWidth(){const div=document.createElement("div");div.style.visibility="hidden";div.style.overflow="scroll";div.style.width="50px";div.style.height="50px";div.style.position="absolute";document.body.appendChild(div);const result=div.offsetWidth-div.clientWidth;div.parentNode.removeChild(div);return result}class PdfViewerBaseElement extends CrLitElement{static get properties(){return{showErrorDialog:{type:Boolean},strings:{type:Object}}}browserApi=null;currentController=null;documentDimensions=null;isUserInitiatedEvent=true;lastViewportPosition=null;originalUrl="";paramsParser=null;pdfOopifEnabled=false;#showErrorDialog_accessor_storage=false;get showErrorDialog(){return this.#showErrorDialog_accessor_storage}set showErrorDialog(value){this.#showErrorDialog_accessor_storage=value}#strings_accessor_storage;get strings(){return this.#strings_accessor_storage}set strings(value){this.#strings_accessor_storage=value}tracker=new EventTracker;delayedScriptingMessages_=[];initialLoadComplete_=false;loaded_=null;loadState_=LoadState.LOADING;overrideSendScriptingMessageForTest_=false;parentOrigin_=null;parentWindow_=null;plugin_=null;viewport_=null;zoomManager_=null;isNewUiEnabled(){return true}createPlugin_(){const plugin=document.createElement("embed");plugin.id="plugin";plugin.type="application/x-google-chrome-pdf";plugin.setAttribute("original-url",this.originalUrl);this.setPluginSrc(plugin);plugin.setAttribute("background-color",this.getBackgroundColor().toString());const javascript=this.browserApi.getStreamInfo().javascript||"block";plugin.setAttribute("javascript",javascript);if(this.browserApi.getStreamInfo().embedded){plugin.setAttribute("top-level-url",this.browserApi.getStreamInfo().tabUrl)}else{plugin.toggleAttribute("full-frame",true)}if(this.isNewUiEnabled()){plugin.toggleAttribute("pdf-viewer-update-enabled",true)}const attributesForLoading={backgroundColor:this.getBackgroundColor(),allowJavascript:javascript==="allow"};if(this.pdfOopifEnabled){if(chrome.pdfViewerPrivate){chrome.pdfViewerPrivate.setPdfPluginAttributes(attributesForLoading)}}else if(chrome.mimeHandlerPrivate){chrome.mimeHandlerPrivate.setPdfPluginAttributes(attributesForLoading)}return plugin}initInternal(browserApi,scroller,sizer,content){this.browserApi=browserApi;this.originalUrl=this.browserApi.getStreamInfo().originalUrl;this.pdfOopifEnabled=document.documentElement.hasAttribute("pdfOopifEnabled");record(UserAction.DOCUMENT_OPENED);const defaultZoom=this.browserApi.getZoomBehavior()===ZoomBehavior.MANAGE?this.browserApi.getDefaultZoom():1;assert(!this.viewport_);this.viewport_=new Viewport(scroller,sizer,content,getScrollbarWidth(),defaultZoom);this.viewport_.setViewportChangedCallback((()=>this.viewportChanged_()));this.viewport_.setBeforeZoomCallback((()=>this.currentController.beforeZoom()));this.viewport_.setAfterZoomCallback((()=>{this.currentController.afterZoom();this.afterZoom(this.viewport_.getZoom())}));this.viewport_.setUserInitiatedCallback((userInitiated=>this.setUserInitiated_(userInitiated)));window.addEventListener("message",(message=>{this.handleScriptingMessage(message)}),false);this.plugin_=this.createPlugin_();const pluginController=PluginController.getInstance();pluginController.init(this.plugin_,this.viewport_,(()=>this.isUserInitiatedEvent));pluginController.isActive=true;this.currentController=pluginController;const getNamedDestinationCallback=destination=>PluginController.getInstance().getNamedDestination(destination);const getPageBoundingBoxCallback=page=>PluginController.getInstance().getPageBoundingBox(page);this.paramsParser=new OpenPdfParamsParser(getNamedDestinationCallback,getPageBoundingBoxCallback);this.tracker.add(pluginController.getEventTarget(),PluginControllerEventType.PLUGIN_MESSAGE,(e=>this.handlePluginMessage(e)));document.body.addEventListener("change-page-and-xy",(e=>{const point=this.viewport_.convertPageToScreen(e.detail.page,e.detail);this.viewport_.goToPageAndXy(e.detail.page,point.x,point.y)}));document.addEventListener("keydown",this.handleKeyEvent.bind(this));this.zoomManager_=ZoomManager.create(this.browserApi.getZoomBehavior(),(()=>this.viewport_.getZoom()),(zoom=>this.browserApi.setZoom(zoom)),this.browserApi.getInitialZoom());this.viewport_.setZoomManager(this.zoomManager_);this.browserApi.addZoomEventListener((zoom=>this.zoomManager_.onBrowserZoomChange(zoom)));chrome.resourcesPrivate.getStrings(chrome.resourcesPrivate.Component.PDF,(strings=>this.handleStrings(strings)))}updateProgress(progress){if(progress===-1){this.showErrorDialog=true;this.viewport_.setContent(null);this.setLoadState(LoadState.FAILED);this.sendDocumentLoadedMessage()}else if(progress===100){if(this.lastViewportPosition){this.viewport_.setPosition(this.lastViewportPosition)}this.paramsParser.getViewportFromUrlParams(this.originalUrl).then((params=>this.handleUrlParams(params)));this.setLoadState(LoadState.SUCCESS);this.sendDocumentLoadedMessage();while(this.delayedScriptingMessages_.length>0){this.handleScriptingMessage(this.delayedScriptingMessages_.shift())}}else{this.setLoadState(LoadState.LOADING)}}readyToSendLoadMessage(){return true}sendDocumentLoadedMessage(){if(this.loadState_===LoadState.LOADING||!this.readyToSendLoadMessage()){return}this.sendScriptingMessage({type:"documentLoaded",load_state:this.loadState_})}viewportChanged_(){if(!this.documentDimensions){return}this.updateUiForViewportChange();const visiblePage=this.viewport_.getMostVisiblePage();const visiblePageDimensions=this.viewport_.getPageScreenRect(visiblePage);const size=this.viewport_.size;this.paramsParser.setViewportDimensions(size);this.sendScriptingMessage({type:"viewport",pageX:visiblePageDimensions.x,pageY:visiblePageDimensions.y,pageWidth:visiblePageDimensions.width,viewportWidth:size.width,viewportHeight:size.height})}handleScriptingMessage(message){if(message.data.type==="connect"){const token=message.data.token;if(token===this.browserApi.getStreamInfo().streamUrl){assert(message.ports[0]!==undefined);PluginController.getInstance().bindMessageHandler(message.ports[0])}else{this.dispatchEvent(new CustomEvent("connection-denied-for-testing"))}return true}if(this.parentWindow_!==message.source){this.parentWindow_=message.source;this.parentOrigin_=message.origin;if(this.loadState_!==LoadState.LOADING){this.sendDocumentLoadedMessage()}}return false}delayScriptingMessage(message){if(this.loadState_!==LoadState.SUCCESS){this.delayedScriptingMessages_.push(message);return true}return false}setDocumentDimensions(documentDimensions){this.documentDimensions=documentDimensions;this.isUserInitiatedEvent=false;this.viewport_.setDocumentDimensions(this.documentDimensions);this.paramsParser.setPageCount(documentDimensions.pageDimensions.length);this.paramsParser.setViewportDimensions(this.viewport_.size);this.isUserInitiatedEvent=true}get isPdfOopifEnabled(){return this.pdfOopifEnabled}get loaded(){return this.loaded_?this.loaded_.promise:null}get viewport(){assert(this.viewport_);return this.viewport_}setLoadState(loadState){if(this.loadState_===loadState){return}assert(loadState===LoadState.LOADING||this.loadState_===LoadState.LOADING);this.loadState_=loadState;if(!this.initialLoadComplete_){this.initialLoadComplete_=true;return}if(loadState===LoadState.SUCCESS){this.loaded_.resolve()}else if(loadState===LoadState.FAILED){this.loaded_.reject()}else{this.loaded_=new PromiseResolver}}getLoadSucceededForTesting(){return this.loadState_===LoadState.SUCCESS}handleStrings(strings){if(!strings){return}loadTimeData.data=strings;const presetZoomFactors=JSON.parse(loadTimeData.getString("presetZoomFactors"));this.viewport_.setZoomFactorRange(presetZoomFactors);this.strings=strings}handleUrlParams(params){assert(this.viewport_);if(params.zoom){this.viewport_.setZoom(params.zoom)}if(params.position){this.viewport_.goToPageAndXy(params.page||0,params.position.x,params.position.y)}if(params.view){this.isUserInitiatedEvent=false;const fittingTypeParams={boundingBox:params.boundingBox,page:params.page||0,viewPosition:params.viewPosition,fitToWidth:params.view===FittingType.FIT_TO_BOUNDING_BOX_WIDTH};this.viewport_.setFittingType(params.view,fittingTypeParams);this.forceFit(params.view);this.isUserInitiatedEvent=true}else if(!params.position&&params.page!==undefined){this.viewport_.goToPage(params.page)}}setUserInitiated_(userInitiated){assert(this.isUserInitiatedEvent!==userInitiated);this.isUserInitiatedEvent=userInitiated}overrideSendScriptingMessageForTest(){this.overrideSendScriptingMessageForTest_=true}sendScriptingMessage(message){if(this.parentWindow_&&this.parentOrigin_){let targetOrigin;if(this.parentOrigin_===window.location.origin){targetOrigin=this.parentOrigin_}else if(message.type==="documentLoaded"||message.type==="passwordPrompted"){targetOrigin="*"}else{targetOrigin=this.originalUrl}try{this.parentWindow_.postMessage(message,targetOrigin)}catch(ok){}}}onFitToChanged(e){this.viewport_.setFittingType(e.detail);recordFitTo(e.detail)}onZoomIn(){this.viewport_.zoomIn();record(UserAction.ZOOM_IN)}onZoomChanged(e){this.viewport_.setZoom(e.detail/100);record(UserAction.ZOOM_CUSTOM)}onZoomOut(){this.viewport_.zoomOut();record(UserAction.ZOOM_OUT)}handleSelectedTextReply(message){if(this.overrideSendScriptingMessageForTest_){this.overrideSendScriptingMessageForTest_=false;try{this.sendScriptingMessage(message)}finally{this.parentWindow_.postMessage("flush","*")}return}this.sendScriptingMessage(message)}rotateClockwise(){record(UserAction.ROTATE);this.currentController.rotateClockwise()}rotateCounterclockwise(){record(UserAction.ROTATE);this.currentController.rotateCounterclockwise()}}export{AnnotationBrushType as A,convertDocumentDimensionsMessage as B,CrRippleMixin as C,getSaveToDriveOpenInDriveUrl as D,EventTracker as E,FocusOutlineManager as F,getSaveToDriveManageStorageUrl as G,verifyPdfHeader as H,listenOnce as I,convertLoadProgressMessage as J,convertFormFocusChangeMessage as K,CrIconButtonElement as L,GestureDetector as M,recordFitTo as N,resetForTesting as O,PluginController as P,OpenPdfParamsParser as Q,SwipeDetector as R,SaveToDriveState as S,TextTypeface as T,UserAction as U,ViewMode as V,SwipeDirection as W,PAGE_SHADOW as X,Viewport as Y,ZoomManager as Z,assertInstanceof as a,assert as b,TextAlignment as c,TextStyle as d,PromiseResolver as e,PluginControllerEventType as f,getDeepActiveElement as g,hasKeyModifiers as h,isRTL as i,assertNotReached as j,getCss$9 as k,hexToColor as l,colorToHex as m,blendHighlighterColorValue as n,getCss$3 as o,SaveToDriveBubbleRequestType as p,AnnotationMode as q,record as r,FormFieldFocusType as s,FittingType as t,getCss as u,recordEnumeration as v,PdfViewerBaseElement as w,shouldIgnoreKeyEvents as x,hasCtrlModifier as y,hasCtrlModifierOnly as z};