// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import './value_display.js';
import './mojo_timestamp.js';
import { CustomElement } from 'chrome://resources/js/custom_element.js';
import { getTemplate } from './pref_display.html.js';
import { defaultLogicalFn } from './value_display.js';
export class PrefDisplayElement extends CustomElement {
    static get template() {
        return getTemplate();
    }
    getElement(key) {
        return this.shadowRoot.querySelector(`.id-${key}`);
    }
    configure(prefName, value, valueLogicalFn = defaultLogicalFn) {
        const nameElem = this.getElement('pref-name');
        nameElem.textContent = prefName;
        // Hide the name of the pref from its usual position if the value of this
        // pref is a list or a dictionary
        if (!!value.dictionaryValue || !!value.listValue) {
            const nameWrapperElem = this.getElement('pref-label');
            nameWrapperElem.hidden = true;
        }
        const valueElem = this.getElement('pref-value');
        const v = document.createElement('value-display');
        v.configure(value, valueLogicalFn, prefName);
        valueElem.replaceChildren(v);
    }
}
customElements.define('pref-display', PrefDisplayElement);
