// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/cr_elements/cr_shared_style.css.js";import"chrome://resources/cr_elements/cr_button/cr_button.js";import"chrome://resources/cr_elements/cr_view_manager/cr_view_manager.js";import"./topics_consent_notice.js";import"./protected_audience_measurement_notice.js";import"./three_ads_apis_notice.js";import"./measurement_notice.js";import"/strings.m.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{assert}from"chrome://resources/js/assert.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{getCss}from"./base_dialog_app.css.js";import{getHtml}from"./base_dialog_app.html.js";import{BaseDialogBrowserProxy}from"./base_dialog_browser_proxy.js";import{PrivacySandboxNotice}from"./notice.mojom-webui.js";export class BaseDialogApp extends CrLitElement{static get is(){return"base-dialog-app"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}proxy_=BaseDialogBrowserProxy.getInstance();handler_;navigateToNextStepListenerId_=null;firstUpdated(){this.handler_=this.proxy_.handler;this.navigateToStep_(loadTimeData.getInteger("noticeIdToShow")).then((()=>this.resizeAndShowNativeDialog()))}connectedCallback(){super.connectedCallback();this.navigateToNextStepListenerId_=this.proxy_.callbackRouter.navigateToNextStep.addListener(this.navigateToStep_.bind(this))}disconnectedCallback(){super.disconnectedCallback();assert(this.navigateToNextStepListenerId_);this.proxy_.callbackRouter.removeListener(this.navigateToNextStepListenerId_)}navigateToStep_(step){return this.$.viewManager.switchView(this.getNoticeId(step),"fade-in","fade-out")}getNoticeId(step){return PrivacySandboxNotice[step]}resizeAndShowNativeDialog(){return new Promise((async resolve=>{await this.handler_.resizeDialog(document.body.offsetHeight);this.handler_.showDialog();resolve()}))}}customElements.define(BaseDialogApp.is,BaseDialogApp);