import { html } from '//resources/lit/v3_0/lit.rollup.js';
export function getHtml() {
    return html `<!--_html_template_start_--><h2>Profiles</h2>
${this.profilesList_.map((item, index) => html `
  <cr-expand-button
      ?expanded="${item.expanded}"
      @expanded-changed="${this.onExpandedChanged_}"
      data-index="${index}"
      class="${item.className}"
      .style="color: ${item.profileState.foregroundColor};
              background-color: ${item.profileState.backgroundColor};">
    ${item.profileState.localProfileName}
  </cr-expand-button>
  <cr-collapse ?opened="${item.expanded}">
    <table class="profile">
      <tr>
        <td>Profile Path</td>
        <td>${item.profileState.profilePath}</td>
      </tr>
      <tr>
        <td>Local Profile Name</td>
        <td>${item.profileState.localProfileName}</td>
      </tr>
      <tr>
        <td>Signin State</td>
        <td>${item.profileState.signinState}</td>
      </tr>
      <tr>
        <td>Signin Required</td>
        <td>${item.profileState.signinRequired}</td>
      </tr>
      <tr>
        <td>Gaia Name</td>
        <td>${item.profileState.gaiaName}</td>
      </tr>
      <tr>
        <td>Gaia Id</td>
        <td>${item.profileState.gaiaId}</td>
      </tr>
      <tr>
        <td>User Name</td>
        <td>${item.profileState.userName}</td>
      </tr>
      <tr>
        <td>Hosted Domain</td>
        <td>${item.profileState.hostedDomain}</td>
      </tr>
      <tr>
        <td>Supervised</td>
        <td>${item.profileState.isSupervised}</td>
      </tr>
      <tr>
        <td>Omitted</td>
        <td>${item.profileState.isOmitted}</td>
      </tr>
      <tr>
        <td>Ephemeral</td>
        <td>${item.profileState.isEphemeral}</td>
      </tr>
      <tr>
        <td>User Accepted Account Management</td>
        <td>${item.profileState.userAcceptedAccountManagement}</td>
      </tr>
      <tr>
        <td>KeepAlives</td>
        <td>
          <table>
            ${item.profileState.keepAlives.map(item => html `
              <tr>
                <td>${item.origin}</td>
                <td>${item.count}</td>
              </tr>
            `)}
          </table>
        </td>
      </tr>
      <tr>
        <td>Signed Accounts</td>
        <td>
          <ul>
            ${item.profileState.signedAccounts.map(item => html `
              <li>${item}</li>
            `)}
          </ul>
        </td>
      </tr>
      <tr>
        <td>Loaded in Memory</td>
        <td>${item.profileState.isLoaded}</td>
      </tr>
      <tr>
        <td>Has Incognito Profile</td>
        <td>${item.profileState.hasOffTheRecord}</td>
      </tr>
      <tr>
        <td>Country Info</td>
        <td>
          <table>
            <thead>
              <th>Profile</th>
              <th>Keywords DB (initial)</th>
              <th>Keywords DB (updated)</th>
              <th>Variations (client-scoped)</th>
              <th>OS/Locale (client-scoped)</th>
            </thead>
            <tr>
              <td>${item.profileState.profileCountry}</td>
              <td>${item.profileState.localeCountry}</td>
              <td>${item.profileState.variationsCountry}</td>
              <td>${item.profileState.initialKeywordsDbCountry}</td>
              <td>${item.profileState.updatedKeywordsDbCountry}</td>
            </tr>
          </table>
        </td>
      </tr>
    </table>
  </cr-collapse>
`)}
<!--_html_template_end_-->`;
}
