// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '//resources/cr_elements/cr_collapse/cr_collapse.js';
import '//resources/cr_elements/cr_expand_button/cr_expand_button.js';
import '/strings.m.js';
import { WebUiListenerMixinLit } from 'chrome://resources/cr_elements/web_ui_listener_mixin_lit.js';
import { assert } from 'chrome://resources/js/assert.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { getCss } from './profile_internals_app.css.js';
import { getHtml } from './profile_internals_app.html.js';
import { ProfileInternalsBrowserProxyImpl } from './profile_internals_browser_proxy.js';
const ProfileInternalsAppElementBase = WebUiListenerMixinLit(CrLitElement);
export class ProfileInternalsAppElement extends ProfileInternalsAppElementBase {
    static get is() {
        return 'profile-internals-app';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            /**
             * Profiles list supplied by ProfileInternalsBrowserProxy.
             */
            profilesList_: { type: Array },
        };
    }
    profileInternalsBrowserProxy_ = ProfileInternalsBrowserProxyImpl.getInstance();
    #profilesList__accessor_storage = [];
    get profilesList_() { return this.#profilesList__accessor_storage; }
    set profilesList_(value) { this.#profilesList__accessor_storage = value; }
    connectedCallback() {
        super.connectedCallback();
        this.addWebUiListener('profiles-list-changed', (profilesList) => this.handleProfilesListChanged_(profilesList));
        this.profileInternalsBrowserProxy_.getProfilesList();
    }
    /**
     * Handler for when the profiles list are updated.
     */
    handleProfilesListChanged_(profilesList) {
        const profilesExpanded = new Map(this.profilesList_.map(item => [item.profileState.profilePath, item.expanded]));
        this.profilesList_ = profilesList.map(profile => ({
            profileState: profile,
            className: profile.isLoaded ? 'loaded' : 'unloaded',
            expanded: profilesExpanded.get(profile.profilePath) ?? false,
        }));
    }
    onExpandedChanged_(event) {
        const currentTarget = event.currentTarget;
        const index = Number(currentTarget.dataset['index']);
        const profile = this.profilesList_[index];
        assert(profile);
        profile.expanded = event.detail.value;
        this.requestUpdate();
    }
}
customElements.define(ProfileInternalsAppElement.is, ProfileInternalsAppElement);
