import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_-->    <style include="settings-shared md-select cr-spinner-style">.description{align-items:center;display:flex;margin-top:16px}.spinner{margin:0 8px}#successIcon{fill:var(--cr-checked-color);height:80px;margin:auto;width:100%}.md-select{margin-top:2px}

    </style>
    <cr-dialog id="dialog" close-text="$i18n{close}"
        ignore-popstate>
      <div slot="title">$i18n{importTitle}</div>
      <div slot="body">
        <div hidden$="[[!hasImportStatus_(
            importStatusEnum_.SUCCEEDED, importStatus_)]]">
          <cr-icon id="successIcon" icon="cr:check-circle"></cr-icon>
          <div hidden$="[[!prefs.import_dialog_bookmarks.value]]">
            <div class="description">$i18n{importSuccess}</div>
            <settings-toggle-button
                label="$i18n{showBookmarksBar}"
                pref="{{prefs.bookmark_bar.show_on_all_tabs}}">
            </settings-toggle-button>
          </div>
        </div>

        <div hidden$="[[hasImportStatus_(
              importStatusEnum_.SUCCEEDED, importStatus_)]]">
          <select id="browserSelect" class="md-select"
              aria-label="$i18n{importFromLabel}"
              on-change="onBrowserProfileSelectionChange_">
            <template is="dom-repeat" items="[[browserProfiles_]]">
              <option value="[[item.index]]">
                [[getProfileDisplayName_(item.name, item.profileName)]]
              </option>
            </template>
          </select>
          <div class="description">$i18n{importDescription}</div>

          <!--
            A parent div is needed here to prevent bugs caused by elements
            becoming hidden interfering with NVDA reading out changes to the
            select menu. The checkboxes just need to have a different parent
            than the select menu.
            See https://github.com/nvaccess/nvda/issues/13116.
          -->
          <div>
            <settings-checkbox id="importDialogHistory"
                hidden="[[!selected_.history]]"
                pref="{{prefs.import_dialog_history}}"
                label="$i18n{importHistory}" no-set-pref>
            </settings-checkbox>
            <settings-checkbox id="importDialogBookmarks"
                hidden="[[!selected_.favorites]]"
                pref="{{prefs.import_dialog_bookmarks}}"
                label="$i18n{importFavorites}" no-set-pref>
            </settings-checkbox>
            <settings-checkbox id="importDialogSavedPasswords"
                hidden="[[!selected_.passwords]]"
                pref="{{prefs.import_dialog_saved_passwords}}"
                label="$i18n{importPasswords}" no-set-pref>
            </settings-checkbox>
            <settings-checkbox id="importDialogSearchEngine"
                hidden="[[!selected_.search]]"
                pref="{{prefs.import_dialog_search_engine}}"
                label="$i18n{importSearch}" no-set-pref>
            </settings-checkbox>
            <settings-checkbox id="importDialogAutofillFormData"
                hidden="[[!selected_.autofillFormData]]"
                pref="{{prefs.import_dialog_autofill_form_data}}"
                label="$i18n{importAutofillFormData}" no-set-pref>
            </settings-checkbox>
          </div>
        </div>
      </div>
      <div slot="button-container">
        <div class="spinner" hidden$="[[!hasImportStatus_(
            importStatusEnum_.IN_PROGRESS, importStatus_)]]">
        </div>
        <cr-button id="cancel" class="cancel-button"
            hidden="[[hasImportStatus_(
                importStatusEnum_.SUCCEEDED, importStatus_)]]"
            disabled="[[hasImportStatus_(
                importStatusEnum_.IN_PROGRESS, importStatus_)]]"
            on-click="closeDialog_">
          $i18n{cancel}
        </cr-button>
        <cr-button id="import" class="action-button"
            hidden="[[hasImportStatus_(
                importStatusEnum_.SUCCEEDED, importStatus_)]]"
            disabled="[[shouldDisableImport_(
                importStatus_, noImportDataTypeSelected_)]]"
            on-click="onActionButtonClick_">
          [[getActionButtonText_(selected_)]]
        </cr-button>

        <cr-button id="done" class="action-button"
            hidden$="[[!hasImportStatus_(
                importStatusEnum_.SUCCEEDED, importStatus_)]]"
            on-click="closeDialog_">$i18n{done}</cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`;
}
