import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_-->  <style include="cr-shared-style settings-shared">.no-min-height{min-height:0}#safetyHubModule{padding:0 var(--cr-section-padding)}
  </style>
  <settings-subpage page-title="$i18n{siteSettings}"
      learn-more-url="$i18n{exceptionsLearnMoreURL}"
      route-path$="[[routePath]]">
    <template is="dom-if" if="[[showUnusedSitePermissions_]]">
      <div class="cr-row first">
        <h2>$i18n{safetyHub}</h2>
      </div>
      <settings-safety-hub-module id="safetyHubModule"
          header="[[unusedSitePermissionsHeader_]]"
          subheader="[[unusedSitePermissionsSubheader_]]"
          header-icon="cr:security" header-icon-color="blue">
        <cr-button id="safetyHubButton" slot="button-container"
            class="action-button" on-click="onSafetyHubButtonClick_">
          $i18n{safetyHubEntryPointButtonLabel}
        </cr-button>
      </settings-safety-hub-module>
    </template>
    <div class="cr-row first">
      <h2>$i18n{siteSettingsRecentPermissionsSectionLabel}</h2>
    </div>
    <settings-recent-site-permissions id="recentSitePermissions"
        no-recent-permissions="{{noRecentSitePermissions_}}">
    </settings-recent-site-permissions>

    <cr-link-row data-route="SITE_SETTINGS_ALL" id="allSites"
        class$="[[getClassForSiteSettingsAllLink_(noRecentSitePermissions_)]]"
        label="$i18n{siteSettingsAllSitesDescription}"
        on-click="onSiteSettingsAllClick_"
        role-description="$i18n{subpageArrowRoleDescription}"></cr-link-row>
    <div class="cr-row first line-only">
      <h2>$i18n{siteSettingsPermissions}</h2>
    </div>

    <settings-site-settings-list id="basicPermissionsList" prefs="{{prefs}}"
        category-list="[[lists_.permissionsBasic]]">
    </settings-site-settings-list>
    <cr-expand-button class="cr-row"
        expanded="{{permissionsExpanded_}}">
      <div>$i18n{siteSettingsPermissionsMore}</div>
    </cr-expand-button>
    <cr-collapse opened="[[permissionsExpanded_]]">
      <settings-site-settings-list id="advancedPermissionsList"
          category-list="[[lists_.permissionsAdvanced]]">
      </settings-site-settings-list>
    </cr-collapse>

    <div class="cr-row first line-only">
      <h2>$i18n{siteSettingsContent}</h2>
    </div>
    <settings-site-settings-list id="basicContentList" prefs="{{prefs}}"
        category-list="[[lists_.contentBasic]]">
    </settings-site-settings-list>
    <cr-expand-button id="expandContent" class="cr-row"
        expanded="{{contentExpanded_}}">
      <div>$i18n{siteSettingsContentMore}</div>
    </cr-expand-button>
    <cr-collapse opened="[[contentExpanded_]]">
      <settings-site-settings-list id="advancedContentList" prefs="{{prefs}}"
          category-list="[[lists_.contentAdvanced]]">
      </settings-site-settings-list>
    </cr-collapse>
    <settings-toggle-button
        id="unusedSitePermissionsRevocationToggle"
        pref="{{
            prefs.safety_hub.unused_site_permissions_revocation.enabled}}"
        label="$i18n{safetyHubUnusedSitePermissionsSettingLabel}"
        sub-label=
            "$i18n{safetyHubUnusedSitePermissionsSettingSublabel}">
    </settings-toggle-button>
  </settings-subpage>
<!--_html_template_end_-->`;
}
