// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '/strings.m.js';
import './icons.html.js';
import '//resources/cr_elements/cr_chip/cr_chip.js';
import '//resources/cr_elements/cr_icon/cr_icon.js';
import { loadTimeData } from '//resources/js/load_time_data.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { getTemplate } from './power_bookmarks_labels.html.js';
export class PowerBookmarksLabelsElement extends PolymerElement {
    static get is() {
        return 'power-bookmarks-labels';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            disabled: {
                type: Boolean,
                value: false,
            },
            labels: {
                type: Array,
                computed: 'computeLabels(trackedProductInfos.*)',
                notify: true,
            },
            trackedProductInfos: {
                type: Object,
                value: () => {
                    return {};
                },
            },
        };
    }
    computeLabels() {
        const labels = [];
        const hasTrackedProducts = Object.keys(this.trackedProductInfos)
            .some(key => this.trackedProductInfos[key] !== null);
        if (hasTrackedProducts) {
            // Reuse the current price tracking label if one exists, to maintain its
            // active state.
            const currentLabel = this.labels[0];
            labels.push(Object.assign({}, {
                label: loadTimeData.getString('priceTrackingLabel'),
                icon: 'bookmarks:price-tracking',
                active: false,
            }, { active: currentLabel ? currentLabel.active : false }));
        }
        return labels;
    }
    getLabelIcon(label) {
        return label.active ? 'bookmarks:check' : label.icon;
    }
    onLabelClick(event) {
        event.preventDefault();
        event.stopPropagation();
        this.set(`labels.${event.model.index}.active`, !event.model.item.active);
    }
}
customElements.define(PowerBookmarksLabelsElement.is, PowerBookmarksLabelsElement);
