import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!-- Copyright 2023 The Chromium Authors
     Use of this source code is governed by a BSD-style license that can be
     found in the LICENSE file. -->

<style include="support-tool-shared cr-shared-style">#screenshotButtons{float:left;left:0;margin-bottom:8px;position:relative}.screenshot-button{margin-inline-end:8px}#screenshotPreview{margin-bottom:8px;margin-top:8px;width:520px}cr-dialog::part(dialog){max-width:90vw;overflow:hidden;width:fit-content}cr-dialog [slot=body]{display:flex;max-height:75vh;position:relative}#screenshotEditorBG{height:70%}#screenshotCanvas{position:absolute;z-index:1}#deleteButton{position:absolute;z-index:2;--iron-icon-height:48px;--iron-icon-width:48px}</style>

<div class="support-tool-title">Attach additional files</div>

<div id="screenshotButtons">
  <cr-button
      id="takeScreenshot"
      class="screenshot-button"
      hidden$="[[hasScreenshotPreview_]]"
      on-click="onTakeScreenshotClick_">
    Take Screenshot
  </cr-button>
  <cr-button
      id="removeScreenshot"
      class="screenshot-button"
      hidden$="[[!hasScreenshotPreview_]]"
      on-click="onRemoveScreenshotClick_">
    Remove Screenshot
  </cr-button>
  <cr-button
      id="hideInfo"
      class="screenshot-button"
      hidden$="[[!hasScreenshotPreview_]]"
      on-click="onEditScreenshotClick_">
    Hide Info
  </cr-button>
</div>

<div>
  <img id="screenshotPreview"
       hidden$="[[!hasScreenshotPreview_]]"
       src="[[screenshotBase64_]]"
       alt="Screenshot">
</div>

<template is="dom-if" if="[[showEditor_]]" restamp>
  <cr-dialog
      id="editor"
      on-cr-dialog-open="onOpenDialog_"
      on-close="onCloseDialog_"
      show-on-attach>
    <div slot="title">Hide Info</div>
    <div slot="body">
      <img id="screenshotEditorBG"
           src="[[originalScreenshotBase64_]]"
           alt="Screenshot">
      <canvas id="screenshotCanvas"></canvas>
      <cr-icon
          id="deleteButton"
          icon="support-tool-icons:highlight-off"
          hidden$="[[!showDeleteButton_]]"
          style$="top: [[buttonY_]]px; left: [[buttonX_]]px;"
          on-click="onClickDeleteRect_">
      </cr-icon>
    </div>
    <div slot="button-container">
      <cr-button id="cancelEdit"
                 class="cancel-button"
                 on-click="onClickCancel_">
        Cancel
      </cr-button>
      <cr-button id="confirmEdit"
                 class="action-button"
                 on-click="onClickConfirm_">
        Confirm
      </cr-button>
    </div>
  </cr-dialog>
</template>
<!--_html_template_end_-->`;
}
