import { css, html, CrLitElement, nothing, render } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { g as getCss$w, C as CrRippleMixin, a as getTrustedHTML, b as assert, c as assertNotReached, T as TabOrganizationError, E as EventTracker, d as TabOrganizationModelStrategy, e as getCss$x, f as TabData, h as TabItemType, n as normalizeURL, i as TabOrganizationState, j as TabSearchApiProxyImpl, U as UserFeedback, D as DeclutterCTREvent, k as TabSearchItemElement, l as TabOrganizationFeature, S as SelectorCTREvent, m as TabDeclutterEntryPoint, o as TabGroupData, p as Color, q as colorName, r as highlightText, M as MouseHoverableMixinLit, s as TimeDeltaSpec, t as quoteString, u as getTitle, v as getHostname, w as getTabGroupTitle, N as NO_SELECTION, x as ColorChangeUpdater, y as TabSearchSection, z as listenOnce, A as tokenToString, B as selectorNavigationKeys, F as ariaLabel, G as getDisplayHostnameForUrl, H as tabHasMediaAlerts, I as tokenEquals, J as getDeepActiveElement } from './shared.rollup.js';
export { O as ItemData, P as PageCallbackRouter, Q as PageRemote, K as SelectableLazyListElement, L as SplitNewTabPageAppElement, R as TabAlertState } from './shared.rollup.js';
import 'chrome://tab-search.top-chrome/strings.m.js';
import { loadTimeData } from 'chrome://resources/js/load_time_data.js';
import { addWebUiListener, removeWebUiListener, sendWithPromise } from 'chrome://resources/js/cr.js';
import { mojo } from 'chrome://resources/mojo/mojo/public/js/bindings.js';

// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The class name to set on the document element.
 */
const CLASS_NAME = 'focus-outline-visible';
const docsToManager = new Map();
/**
 * This class sets a CSS class name on the HTML element of |doc| when the user
 * presses a key. It removes the class name when the user clicks anywhere.
 *
 * This allows you to write CSS like this:
 *
 * html.focus-outline-visible my-element:focus {
 *   outline: 5px auto -webkit-focus-ring-color;
 * }
 *
 * And the outline will only be shown if the user uses the keyboard to get to
 * it.
 *
 */
class FocusOutlineManager {
    // Whether focus change is triggered by a keyboard event.
    focusByKeyboard_ = true;
    classList_;
    /**
     * @param doc The document to attach the focus outline manager to.
     */
    constructor(doc) {
        this.classList_ = doc.documentElement.classList;
        doc.addEventListener('keydown', (e) => this.onEvent_(true, e), true);
        doc.addEventListener('mousedown', (e) => this.onEvent_(false, e), true);
        this.updateVisibility();
    }
    onEvent_(focusByKeyboard, e) {
        if (this.focusByKeyboard_ === focusByKeyboard) {
            return;
        }
        if (e instanceof KeyboardEvent && e.repeat) {
            // A repeated keydown should not trigger the focus state. For example,
            // there is a repeated ALT keydown if ALT+CLICK is used to open the
            // context menu and ALT is not released.
            return;
        }
        this.focusByKeyboard_ = focusByKeyboard;
        this.updateVisibility();
    }
    updateVisibility() {
        this.visible = this.focusByKeyboard_;
    }
    /**
     * Whether the focus outline should be visible.
     */
    set visible(visible) {
        this.classList_.toggle(CLASS_NAME, visible);
    }
    get visible() {
        return this.classList_.contains(CLASS_NAME);
    }
    /**
     * Gets a per document singleton focus outline manager.
     * @param doc The document to get the |FocusOutlineManager| for.
     * @return The per document singleton focus outline manager.
     */
    static forDocument(doc) {
        let manager = docsToManager.get(doc);
        if (!manager) {
            manager = new FocusOutlineManager(doc);
            docsToManager.set(doc, manager);
        }
        return manager;
    }
}

let instance$z = null;
function getCss$v() {
    return instance$z || (instance$z = [...[getCss$w()], css `:host{--cr-button-background-color:transparent;--cr-button-border-color:var(--color-button-border,var(--cr-fallback-color-tonal-outline));--cr-button-text-color:var(--color-button-foreground,var(--cr-fallback-color-primary));--cr-button-ripple-opacity:1;--cr-button-ripple-color:var(--cr-active-background-color);--cr-button-disabled-background-color:transparent;--cr-button-disabled-border-color:var(--color-button-border-disabled,var(--cr-fallback-color-disabled-background));--cr-button-disabled-text-color:var(--color-button-foreground-disabled,var(--cr-fallback-color-disabled-foreground))}:host(.action-button){--cr-button-background-color:var(--color-button-background-prominent,var(--cr-fallback-color-primary));--cr-button-text-color:var(--color-button-foreground-prominent,var(--cr-fallback-color-on-primary));--cr-button-ripple-color:var(--cr-active-on-primary-background-color);--cr-button-border:none;--cr-button-disabled-background-color:var(--color-button-background-prominent-disabled,var(--cr-fallback-color-disabled-background));--cr-button-disabled-text-color:var(--color-button-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--cr-button-disabled-border:none}:host(.tonal-button),:host(.floating-button){--cr-button-background-color:var(--color-button-background-tonal,var(--cr-fallback-color-secondary-container));--cr-button-text-color:var(--color-button-foreground-tonal,var(--cr-fallback-color-on-tonal-container));--cr-button-border:none;--cr-button-disabled-background-color:var(--color-button-background-tonal-disabled,var(--cr-fallback-color-disabled-background));--cr-button-disabled-text-color:var(--color-button-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--cr-button-disabled-border:none}:host{flex-shrink:0;display:inline-flex;align-items:center;justify-content:center;box-sizing:border-box;min-width:5.14em;height:var(--cr-button-height);padding:8px 16px;outline-width:0;overflow:hidden;position:relative;cursor:pointer;user-select:none;-webkit-tap-highlight-color:transparent;border:var(--cr-button-border,1px solid var(--cr-button-border-color));border-radius:100px;background:var(--cr-button-background-color);color:var(--cr-button-text-color);font-weight:500;line-height:20px;isolation:isolate}@media (forced-colors:active){:host{forced-color-adjust:none}}:host(.floating-button){border-radius:8px;height:40px;transition:box-shadow 80ms linear}:host(.floating-button:hover){box-shadow:var(--cr-elevation-3)}:host([has-prefix-icon_]),:host([has-suffix-icon_]){--iron-icon-height:20px;--iron-icon-width:20px;--icon-block-padding-large:16px;--icon-block-padding-small:12px;gap:8px;padding-block-end:8px;padding-block-start:8px}:host([has-prefix-icon_]){padding-inline-end:var(--icon-block-padding-large);padding-inline-start:var(--icon-block-padding-small)}:host([has-suffix-icon_]){padding-inline-end:var(--icon-block-padding-small);padding-inline-start:var(--icon-block-padding-large)}:host-context(.focus-outline-visible):host(:focus){box-shadow:none;outline:2px solid var(--cr-focus-outline-color);outline-offset:2px}#background{border-radius:inherit;inset:0;pointer-events:none;position:absolute}#content{display:inline}#hoverBackground{content:'';display:none;inset:0;pointer-events:none;position:absolute;z-index:1}:host(:hover) #hoverBackground{background:var(--cr-hover-background-color);display:block}:host(.action-button:hover) #hoverBackground{background:var(--cr-hover-on-prominent-background-color)}:host([disabled]){background:var(--cr-button-disabled-background-color);border:var(--cr-button-disabled-border,1px solid var(--cr-button-disabled-border-color));color:var(--cr-button-disabled-text-color);cursor:auto;pointer-events:none}:host(.cancel-button){margin-inline-end:8px}:host(.action-button),:host(.cancel-button){line-height:154%}#ink{color:var(--cr-button-ripple-color);--paper-ripple-opacity:var(--cr-button-ripple-opacity)}#background{z-index:0}#hoverBackground,cr-ripple{z-index:1}#content,::slotted(*){z-index:2}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$o() {
    return html `
<div id="background"></div>
<slot id="prefixIcon" name="prefix-icon"
    @slotchange="${this.onPrefixIconSlotChanged_}">
</slot>
<span id="content"><slot></slot></span>
<slot id="suffixIcon" name="suffix-icon"
    @slotchange="${this.onSuffixIconSlotChanged_}">
</slot>
<div id="hoverBackground" part="hoverBackground"></div>`;
}

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'cr-button' is a button which displays slotted elements. It can
 * be interacted with like a normal button using click as well as space and
 * enter to effectively click the button and fire a 'click' event. It can also
 * style an icon inside of the button with the [has-icon] attribute.
 */
const CrButtonElementBase = CrRippleMixin(CrLitElement);
class CrButtonElement extends CrButtonElementBase {
    static get is() {
        return 'cr-button';
    }
    static get styles() {
        return getCss$v();
    }
    render() {
        return getHtml$o.bind(this)();
    }
    static get properties() {
        return {
            disabled: {
                type: Boolean,
                reflect: true,
            },
            hasPrefixIcon_: {
                type: Boolean,
                reflect: true,
            },
            hasSuffixIcon_: {
                type: Boolean,
                reflect: true,
            },
        };
    }
    #disabled_accessor_storage = false;
    get disabled() { return this.#disabled_accessor_storage; }
    set disabled(value) { this.#disabled_accessor_storage = value; }
    #hasPrefixIcon__accessor_storage = false;
    get hasPrefixIcon_() { return this.#hasPrefixIcon__accessor_storage; }
    set hasPrefixIcon_(value) { this.#hasPrefixIcon__accessor_storage = value; }
    #hasSuffixIcon__accessor_storage = false;
    get hasSuffixIcon_() { return this.#hasSuffixIcon__accessor_storage; }
    set hasSuffixIcon_(value) { this.#hasSuffixIcon__accessor_storage = value; }
    /**
     * It is possible to activate a tab when the space key is pressed down. When
     * this element has focus, the keyup event for the space key should not
     * perform a 'click'. |spaceKeyDown_| tracks when a space pressed and
     * handled by this element. Space keyup will only result in a 'click' when
     * |spaceKeyDown_| is true. |spaceKeyDown_| is set to false when element
     * loses focus.
     */
    spaceKeyDown_ = false;
    timeoutIds_ = new Set();
    constructor() {
        super();
        this.addEventListener('blur', this.onBlur_.bind(this));
        // Must be added in constructor so that stopImmediatePropagation() works as
        // expected.
        this.addEventListener('click', this.onClick_.bind(this));
        this.addEventListener('keydown', this.onKeyDown_.bind(this));
        this.addEventListener('keyup', this.onKeyUp_.bind(this));
        this.ensureRippleOnPointerdown();
    }
    firstUpdated() {
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'button');
        }
        if (!this.hasAttribute('tabindex')) {
            this.setAttribute('tabindex', '0');
        }
        FocusOutlineManager.forDocument(document);
    }
    updated(changedProperties) {
        super.updated(changedProperties);
        if (changedProperties.has('disabled')) {
            this.setAttribute('aria-disabled', this.disabled ? 'true' : 'false');
            this.disabledChanged_(this.disabled, changedProperties.get('disabled'));
        }
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.timeoutIds_.forEach(clearTimeout);
        this.timeoutIds_.clear();
    }
    setTimeout_(fn, delay) {
        if (!this.isConnected) {
            return;
        }
        const id = setTimeout(() => {
            this.timeoutIds_.delete(id);
            fn();
        }, delay);
        this.timeoutIds_.add(id);
    }
    disabledChanged_(newValue, oldValue) {
        if (!newValue && oldValue === undefined) {
            return;
        }
        if (this.disabled) {
            this.blur();
        }
        this.setAttribute('tabindex', String(this.disabled ? -1 : 0));
    }
    onBlur_() {
        this.spaceKeyDown_ = false;
        // If a keyup event is never fired (e.g. after keydown the focus is moved to
        // another element), we need to clear the ripple here. 100ms delay was
        // chosen manually as a good time period for the ripple to be visible.
        this.setTimeout_(() => this.getRipple().uiUpAction(), 100);
    }
    onClick_(e) {
        if (this.disabled) {
            e.stopImmediatePropagation();
        }
    }
    onPrefixIconSlotChanged_() {
        this.hasPrefixIcon_ = this.$.prefixIcon.assignedElements().length > 0;
    }
    onSuffixIconSlotChanged_() {
        this.hasSuffixIcon_ = this.$.suffixIcon.assignedElements().length > 0;
    }
    onKeyDown_(e) {
        if (e.key !== ' ' && e.key !== 'Enter') {
            return;
        }
        e.preventDefault();
        e.stopPropagation();
        if (e.repeat) {
            return;
        }
        this.getRipple().uiDownAction();
        if (e.key === 'Enter') {
            this.click();
            // Delay was chosen manually as a good time period for the ripple to be
            // visible.
            this.setTimeout_(() => this.getRipple().uiUpAction(), 100);
        }
        else if (e.key === ' ') {
            this.spaceKeyDown_ = true;
        }
    }
    onKeyUp_(e) {
        if (e.key !== ' ' && e.key !== 'Enter') {
            return;
        }
        e.preventDefault();
        e.stopPropagation();
        if (this.spaceKeyDown_ && e.key === ' ') {
            this.spaceKeyDown_ = false;
            this.click();
            this.getRipple().uiUpAction();
        }
    }
}
customElements.define(CrButtonElement.is, CrButtonElement);

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/* List commonly used icons here to prevent duplication.
 * Do not add rarely used icons here; place those in your application.
 * Note that 20px and 24px icons are specified separately (size="", below).
 *
 * Icons are rendered at 20x20 px, but we don't have 20 px SVGs for everything.
 * The 24 px icons are used where 20 px icons are unavailable (which may appear
 * blurry at 20 px). Please use 20 px icons when available.
 */
const div = document.createElement('div');
div.innerHTML = getTrustedHTML `
<cr-iconset name="cr20" size="20">
  <svg>
    <defs>
      <!--
      Keep these in sorted order by id="".
      -->
      <g id="block">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M10 0C4.48 0 0 4.48 0 10C0 15.52 4.48 20 10 20C15.52 20 20 15.52 20 10C20 4.48 15.52 0 10 0ZM2 10C2 5.58 5.58 2 10 2C11.85 2 13.55 2.63 14.9 3.69L3.69 14.9C2.63 13.55 2 11.85 2 10ZM5.1 16.31C6.45 17.37 8.15 18 10 18C14.42 18 18 14.42 18 10C18 8.15 17.37 6.45 16.31 5.1L5.1 16.31Z">
        </path>
      </g>
      <g id="cloud-off">
        <path
          d="M16 18.125L13.875 16H5C3.88889 16 2.94444 15.6111 2.16667 14.8333C1.38889 14.0556 1 13.1111 1 12C1 10.9444 1.36111 10.0347 2.08333 9.27083C2.80556 8.50694 3.6875 8.09028 4.72917 8.02083C4.77083 7.86805 4.8125 7.72222 4.85417 7.58333C4.90972 7.44444 4.97222 7.30555 5.04167 7.16667L1.875 4L2.9375 2.9375L17.0625 17.0625L16 18.125ZM5 14.5H12.375L6.20833 8.33333C6.15278 8.51389 6.09722 8.70139 6.04167 8.89583C6 9.07639 5.95139 9.25694 5.89583 9.4375L4.83333 9.52083C4.16667 9.57639 3.61111 9.84028 3.16667 10.3125C2.72222 10.7708 2.5 11.3333 2.5 12C2.5 12.6944 2.74306 13.2847 3.22917 13.7708C3.71528 14.2569 4.30556 14.5 5 14.5ZM17.5 15.375L16.3958 14.2917C16.7153 14.125 16.9792 13.8819 17.1875 13.5625C17.3958 13.2431 17.5 12.8889 17.5 12.5C17.5 11.9444 17.3056 11.4722 16.9167 11.0833C16.5278 10.6944 16.0556 10.5 15.5 10.5H14.125L14 9.14583C13.9028 8.11806 13.4722 7.25694 12.7083 6.5625C11.9444 5.85417 11.0417 5.5 10 5.5C9.65278 5.5 9.31944 5.54167 9 5.625C8.69444 5.70833 8.39583 5.82639 8.10417 5.97917L7.02083 4.89583C7.46528 4.61806 7.93056 4.40278 8.41667 4.25C8.91667 4.08333 9.44444 4 10 4C11.4306 4 12.6736 4.48611 13.7292 5.45833C14.7847 6.41667 15.375 7.59722 15.5 9C16.4722 9 17.2986 9.34028 17.9792 10.0208C18.6597 10.7014 19 11.5278 19 12.5C19 13.0972 18.8611 13.6458 18.5833 14.1458C18.3194 14.6458 17.9583 15.0556 17.5 15.375Z">
        </path>
      </g>
      <g id="delete">
        <path
          d="M 5.832031 17.5 C 5.375 17.5 4.984375 17.335938 4.65625 17.011719 C 4.328125 16.683594 4.167969 16.292969 4.167969 15.832031 L 4.167969 5 L 3.332031 5 L 3.332031 3.332031 L 7.5 3.332031 L 7.5 2.5 L 12.5 2.5 L 12.5 3.332031 L 16.667969 3.332031 L 16.667969 5 L 15.832031 5 L 15.832031 15.832031 C 15.832031 16.292969 15.671875 16.683594 15.34375 17.011719 C 15.015625 17.335938 14.625 17.5 14.167969 17.5 Z M 14.167969 5 L 5.832031 5 L 5.832031 15.832031 L 14.167969 15.832031 Z M 7.5 14.167969 L 9.167969 14.167969 L 9.167969 6.667969 L 7.5 6.667969 Z M 10.832031 14.167969 L 12.5 14.167969 L 12.5 6.667969 L 10.832031 6.667969 Z M 5.832031 5 L 5.832031 15.832031 Z M 5.832031 5 ">
        </path>
      </g>
      <g id="domain" viewBox="0 -960 960 960">
        <path d="M96-144v-672h384v144h384v528H96Zm72-72h72v-72h-72v72Zm0-152h72v-72h-72v72Zm0-152h72v-72h-72v72Zm0-152h72v-72h-72v72Zm168 456h72v-72h-72v72Zm0-152h72v-72h-72v72Zm0-152h72v-72h-72v72Zm0-152h72v-72h-72v72Zm144 456h312v-384H480v80h72v72h-72v80h72v72h-72v80Zm168-232v-72h72v72h-72Zm0 152v-72h72v72h-72Z"></path>
      </g>
      <g id="kite">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M4.6327 8.00094L10.3199 2L16 8.00094L10.1848 16.8673C10.0995 16.9873 10.0071 17.1074 9.90047 17.2199C9.42417 17.7225 8.79147 18 8.11611 18C7.44076 18 6.80806 17.7225 6.33175 17.2199C5.85545 16.7173 5.59242 16.0497 5.59242 15.3371C5.59242 14.977 5.46445 14.647 5.22275 14.3919C4.98104 14.1369 4.66825 14.0019 4.32701 14.0019H4V12.6667H4.32701C5.00237 12.6667 5.63507 12.9442 6.11137 13.4468C6.58768 13.9494 6.85071 14.617 6.85071 15.3296C6.85071 15.6896 6.97867 16.0197 7.22038 16.2747C7.46209 16.5298 7.77488 16.6648 8.11611 16.6648C8.45735 16.6648 8.77014 16.5223 9.01185 16.2747C9.02396 16.2601 9.03607 16.246 9.04808 16.2319C9.08541 16.1883 9.12176 16.1458 9.15403 16.0947L9.55213 15.4946L4.6327 8.00094ZM10.3199 13.9371L6.53802 8.17116L10.3199 4.1814L14.0963 8.17103L10.3199 13.9371Z">
        </path>
      </g>
      <g id="menu">
        <path d="M2 4h16v2H2zM2 9h16v2H2zM2 14h16v2H2z"></path>
      </g>
      <g id="password">
        <path d="M5.833 11.667c.458 0 .847-.16 1.167-.479.333-.333.5-.729.5-1.188s-.167-.847-.5-1.167a1.555 1.555 0 0 0-1.167-.5c-.458 0-.854.167-1.188.5A1.588 1.588 0 0 0 4.166 10c0 .458.16.854.479 1.188.333.319.729.479 1.188.479Zm0 3.333c-1.389 0-2.569-.486-3.542-1.458C1.319 12.569.833 11.389.833 10c0-1.389.486-2.569 1.458-3.542C3.264 5.486 4.444 5 5.833 5c.944 0 1.813.243 2.604.729a4.752 4.752 0 0 1 1.833 1.979h7.23c.458 0 .847.167 1.167.5.333.319.5.708.5 1.167v3.958c0 .458-.167.854-.5 1.188A1.588 1.588 0 0 1 17.5 15h-3.75a1.658 1.658 0 0 1-1.188-.479 1.658 1.658 0 0 1-.479-1.188v-1.042H10.27a4.59 4.59 0 0 1-1.813 2A5.1 5.1 0 0 1 5.833 15Zm3.292-4.375h4.625v2.708H15v-1.042a.592.592 0 0 1 .167-.438.623.623 0 0 1 .458-.188c.181 0 .327.063.438.188a.558.558 0 0 1 .188.438v1.042H17.5V9.375H9.125a3.312 3.312 0 0 0-1.167-1.938 3.203 3.203 0 0 0-2.125-.77 3.21 3.21 0 0 0-2.354.979C2.827 8.298 2.5 9.083 2.5 10s.327 1.702.979 2.354a3.21 3.21 0 0 0 2.354.979c.806 0 1.514-.25 2.125-.75.611-.514 1-1.167 1.167-1.958Z"></path>
      </g>
      
  </svg>
</cr-iconset>

<!-- NOTE: In the common case that the final icon will be 20x20, export the SVG
     at 20px and place it in the section above. -->
<cr-iconset name="cr" size="24">
  <svg>
    <defs>
      <!--
      These icons are copied from Polymer's iron-icons and kept in sorted order.
      -->
      <g id="add">
        <path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z" />
      </g>
      <g id="arrow-back">
        <path
          d="m7.824 13 5.602 5.602L12 20l-8-8 8-8 1.426 1.398L7.824 11H20v2Zm0 0">
        </path>
      </g>
      <g id="arrow-drop-up">
        <path d="M7 14l5-5 5 5z"></path>
      </g>
      <g id="arrow-drop-down">
        <path d="M7 10l5 5 5-5z"></path>
      </g>
      <g id="arrow-forward">
        <path
          d="M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8z">
        </path>
      </g>
      <g id="arrow-right">
        <path d="M10 7l5 5-5 5z"></path>
      </g>
      <g id="cancel">
        <path
          d="M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm5 13.59L15.59 17 12 13.41 8.41 17 7 15.59 10.59 12 7 8.41 8.41 7 12 10.59 15.59 7 17 8.41 13.41 12 17 15.59z">
        </path>
      </g>
      <g id="check">
        <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"></path>
      </g>
      <g id="check-circle" viewBox="0 -960 960 960">
        <path d="m424-296 282-282-56-56-226 226-114-114-56 56 170 170Zm56 216q-83 0-156-31.5T197-197q-54-54-85.5-127T80-480q0-83 31.5-156T197-763q54-54 127-85.5T480-880q83 0 156 31.5T763-763q54 54 85.5 127T880-480q0 83-31.5 156T763-197q-54 54-127 85.5T480-80Zm0-80q134 0 227-93t93-227q0-134-93-227t-227-93q-134 0-227 93t-93 227q0 134 93 227t227 93Zm0-320Z"></path>
      </g>
      <g id="chevron-left">
        <path d="M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z"></path>
      </g>
      <g id="chevron-right">
        <path d="M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6z"></path>
      </g>
      <g id="clear">
        <path
          d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z">
        </path>
      </g>
      <g id="chrome-product" viewBox="0 -960 960 960">
        <path d="M336-479q0 60 42 102t102 42q60 0 102-42t42-102q0-60-42-102t-102-42q-60 0-102 42t-42 102Zm144 216q11 0 22.5-.5T525-267L427-99q-144-16-237.5-125T96-479q0-43 9.5-84.5T134-645l160 274q28 51 78 79.5T480-263Zm0-432q-71 0-126.5 42T276-545l-98-170q53-71 132.5-109.5T480-863q95 0 179 45t138 123H480Zm356 72q15 35 21.5 71t6.5 73q0 155-100 260.5T509-96l157-275q14-25 22-52t8-56q0-40-15-77t-41-67h196Z">
        </path>
      </g>
      <g id="close">
        <path
          d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z">
        </path>
      </g>
      <g id="computer">
        <path
          d="M20 18c1.1 0 1.99-.9 1.99-2L22 6c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2H0v2h24v-2h-4zM4 6h16v10H4V6z">
        </path>
      </g>
      <g id="create">
        <path
          d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04c.39-.39.39-1.02 0-1.41l-2.34-2.34c-.39-.39-1.02-.39-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z">
        </path>
      </g>
      <g id="delete" viewBox="0 -960 960 960">
        <path
          d="M309.37-135.87q-34.48 0-58.74-24.26-24.26-24.26-24.26-58.74v-474.5h-53.5v-83H378.5v-53.5h202.52v53.5h206.11v83h-53.5v474.07q0 35.21-24.26 59.32t-58.74 24.11H309.37Zm341.26-557.5H309.37v474.5h341.26v-474.5ZM379.7-288.24h77.5v-336h-77.5v336Zm123.1 0h77.5v-336h-77.5v336ZM309.37-693.37v474.5-474.5Z">
        </path>
      </g>
      <g id="domain">
        <path
          d="M12 7V3H2v18h20V7H12zM6 19H4v-2h2v2zm0-4H4v-2h2v2zm0-4H4V9h2v2zm0-4H4V5h2v2zm4 12H8v-2h2v2zm0-4H8v-2h2v2zm0-4H8V9h2v2zm0-4H8V5h2v2zm10 12h-8v-2h2v-2h-2v-2h2v-2h-2V9h8v10zm-2-8h-2v2h2v-2zm0 4h-2v2h2v-2z">
        </path>
      </g>
      <!-- source: https://fonts.google.com/icons?selected=Material+Symbols+Outlined:family_link:FILL@0;wght@0;GRAD@0;opsz@24&icon.size=24&icon.color=%23e8eaed -->
      <g id="kite" viewBox="0 -960 960 960">
        <path
          d="M390-40q-51 0-90.5-30.5T246-149q-6-23-25-37t-43-14q-16 0-30 6.5T124-175l-61-51q21-26 51.5-40t63.5-14q51 0 91 30t54 79q6 23 25 37t42 14q19 0 34-10t26-25l1-2-276-381q-8-11-11.5-23t-3.5-24q0-16 6-30.5t18-26.5l260-255q11-11 26-17t30-6q15 0 30 6t26 17l260 255q12 12 18 26.5t6 30.5q0 12-3.5 24T825-538L500-88q-18 25-48 36.5T390-40Zm110-185 260-360-260-255-259 256 259 359Zm1-308Z"/>
        </path>
      </g>
      <g id="error">
        <path
          d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z">
        </path>
      </g>
      <g id="error-outline">
        <path
          d="M11 15h2v2h-2zm0-8h2v6h-2zm.99-5C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z">
        </path>
      </g>
      <g id="expand-less">
        <path d="M12 8l-6 6 1.41 1.41L12 10.83l4.59 4.58L18 14z"></path>
      </g>
      <g id="expand-more">
        <path d="M16.59 8.59L12 13.17 7.41 8.59 6 10l6 6 6-6z"></path>
      </g>
      <g id="extension">
        <path
          d="M20.5 11H19V7c0-1.1-.9-2-2-2h-4V3.5C13 2.12 11.88 1 10.5 1S8 2.12 8 3.5V5H4c-1.1 0-1.99.9-1.99 2v3.8H3.5c1.49 0 2.7 1.21 2.7 2.7s-1.21 2.7-2.7 2.7H2V20c0 1.1.9 2 2 2h3.8v-1.5c0-1.49 1.21-2.7 2.7-2.7 1.49 0 2.7 1.21 2.7 2.7V22H17c1.1 0 2-.9 2-2v-4h1.5c1.38 0 2.5-1.12 2.5-2.5S21.88 11 20.5 11z">
        </path>
      </g>
      <g id="file-download" viewBox="0 -960 960 960">
        <path d="M480-336 288-528l51-51 105 105v-342h72v342l105-105 51 51-192 192ZM263.72-192Q234-192 213-213.15T192-264v-72h72v72h432v-72h72v72q0 29.7-21.16 50.85Q725.68-192 695.96-192H263.72Z"></path>
      </g>
      <g id="fullscreen">
        <path
          d="M7 14H5v5h5v-2H7v-3zm-2-4h2V7h3V5H5v5zm12 7h-3v2h5v-5h-2v3zM14 5v2h3v3h2V5h-5z">
        </path>
      </g>
      <g id="group">
        <path
          d="M16 11c1.66 0 2.99-1.34 2.99-3S17.66 5 16 5c-1.66 0-3 1.34-3 3s1.34 3 3 3zm-8 0c1.66 0 2.99-1.34 2.99-3S9.66 5 8 5C6.34 5 5 6.34 5 8s1.34 3 3 3zm0 2c-2.33 0-7 1.17-7 3.5V19h14v-2.5c0-2.33-4.67-3.5-7-3.5zm8 0c-.29 0-.62.02-.97.05 1.16.84 1.97 1.97 1.97 3.45V19h6v-2.5c0-2.33-4.67-3.5-7-3.5z">
        </path>
      </g>
      <g id="help-outline">
        <path
          d="M11 18h2v-2h-2v2zm1-16C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm0-14c-2.21 0-4 1.79-4 4h2c0-1.1.9-2 2-2s2 .9 2 2c0 2-3 1.75-3 5h2c0-2.25 3-2.5 3-5 0-2.21-1.79-4-4-4z">
        </path>
      </g>
      <g id="history">
        <path
          d="M12.945312 22.75 C 10.320312 22.75 8.074219 21.839844 6.207031 20.019531 C 4.335938 18.199219 3.359375 15.972656 3.269531 13.34375 L 5.089844 13.34375 C 5.175781 15.472656 5.972656 17.273438 7.480469 18.742188 C 8.988281 20.210938 10.808594 20.945312 12.945312 20.945312 C 15.179688 20.945312 17.070312 20.164062 18.621094 18.601562 C 20.167969 17.039062 20.945312 15.144531 20.945312 12.910156 C 20.945312 10.714844 20.164062 8.855469 18.601562 7.335938 C 17.039062 5.816406 15.15625 5.054688 12.945312 5.054688 C 11.710938 5.054688 10.554688 5.339844 9.480469 5.902344 C 8.402344 6.46875 7.476562 7.226562 6.699219 8.179688 L 9.585938 8.179688 L 9.585938 9.984375 L 3.648438 9.984375 L 3.648438 4.0625 L 5.453125 4.0625 L 5.453125 6.824219 C 6.386719 5.707031 7.503906 4.828125 8.804688 4.199219 C 10.109375 3.566406 11.488281 3.25 12.945312 3.25 C 14.300781 3.25 15.570312 3.503906 16.761719 4.011719 C 17.949219 4.519531 18.988281 5.214844 19.875 6.089844 C 20.761719 6.964844 21.464844 7.992188 21.976562 9.167969 C 22.492188 10.34375 22.75 11.609375 22.75 12.964844 C 22.75 14.316406 22.492188 15.589844 21.976562 16.777344 C 21.464844 17.964844 20.761719 19.003906 19.875 19.882812 C 18.988281 20.765625 17.949219 21.464844 16.761719 21.976562 C 15.570312 22.492188 14.300781 22.75 12.945312 22.75 Z M 16.269531 17.460938 L 12.117188 13.34375 L 12.117188 7.527344 L 13.921875 7.527344 L 13.921875 12.601562 L 17.550781 16.179688 Z M 16.269531 17.460938">
        </path>
      </g>
      <g id="info">
        <path
          d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-6h2v6zm0-8h-2V7h2v2z">
        </path>
      </g>
      <g id="info-outline">
        <path
          d="M11 17h2v-6h-2v6zm1-15C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zM11 9h2V7h-2v2z">
        </path>
      </g>
      <g id="insert-drive-file">
        <path
          d="M6 2c-1.1 0-1.99.9-1.99 2L4 20c0 1.1.89 2 1.99 2H18c1.1 0 2-.9 2-2V8l-6-6H6zm7 7V3.5L18.5 9H13z">
        </path>
      </g>
      <g id="location-on">
        <path
          d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z">
        </path>
      </g>
      <g id="mic">
        <path
          d="M12 14c1.66 0 2.99-1.34 2.99-3L15 5c0-1.66-1.34-3-3-3S9 3.34 9 5v6c0 1.66 1.34 3 3 3zm5.3-3c0 3-2.54 5.1-5.3 5.1S6.7 14 6.7 11H5c0 3.41 2.72 6.23 6 6.72V21h2v-3.28c3.28-.48 6-3.3 6-6.72h-1.7z">
        </path>
      </g>
      <g id="more-vert">
        <path
          d="M12 8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm0 2c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0 6c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z">
        </path>
      </g>
      <g id="open-in-new" viewBox="0 -960 960 960">
        <path
          d="M216-144q-29.7 0-50.85-21.15Q144-186.3 144-216v-528q0-29.7 21.15-50.85Q186.3-816 216-816h264v72H216v528h528v-264h72v264q0 29.7-21.15 50.85Q773.7-144 744-144H216Zm171-192-51-51 357-357H576v-72h240v240h-72v-117L387-336Z">
        </path>
      </g>
      <g id="person">
        <path
          d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z">
        </path>
      </g>
      <g id="phonelink">
        <path
          d="M4 6h18V4H4c-1.1 0-2 .9-2 2v11H0v3h14v-3H4V6zm19 2h-6c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h6c.55 0 1-.45 1-1V9c0-.55-.45-1-1-1zm-1 9h-4v-7h4v7z">
        </path>
      </g>
      <g id="print">
        <path
          d="M19 8H5c-1.66 0-3 1.34-3 3v6h4v4h12v-4h4v-6c0-1.66-1.34-3-3-3zm-3 11H8v-5h8v5zm3-7c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-1-9H6v4h12V3z">
        </path>
      </g>
      <g id="schedule">
        <path
          d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm.5-13H11v6l5.25 3.15.75-1.23-4.5-2.67z">
        </path>
      </g>
      <g id="search">
        <path
          d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z">
        </path>
      </g>
      <g id="security">
        <path
          d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm0 10.99h7c-.53 4.12-3.28 7.79-7 8.94V12H5V6.3l7-3.11v8.8z">
        </path>
      </g>
      <!-- The <g> IDs are exposed as global variables in Vulcanized mode, which
        conflicts with the "settings" namespace of MD Settings. Using an "_icon"
        suffix prevents the naming conflict. -->
      <g id="settings_icon">
        <path
          d="M19.43 12.98c.04-.32.07-.64.07-.98s-.03-.66-.07-.98l2.11-1.65c.19-.15.24-.42.12-.64l-2-3.46c-.12-.22-.39-.3-.61-.22l-2.49 1c-.52-.4-1.08-.73-1.69-.98l-.38-2.65C14.46 2.18 14.25 2 14 2h-4c-.25 0-.46.18-.49.42l-.38 2.65c-.61.25-1.17.59-1.69.98l-2.49-1c-.23-.09-.49 0-.61.22l-2 3.46c-.13.22-.07.49.12.64l2.11 1.65c-.04.32-.07.65-.07.98s.03.66.07.98l-2.11 1.65c-.19.15-.24.42-.12.64l2 3.46c.12.22.39.3.61.22l2.49-1c.52.4 1.08.73 1.69.98l.38 2.65c.03.24.24.42.49.42h4c.25 0 .46-.18.49-.42l.38-2.65c.61-.25 1.17-.59 1.69-.98l2.49 1c.23.09.49 0 .61-.22l2-3.46c.12-.22.07-.49-.12-.64l-2.11-1.65zM12 15.5c-1.93 0-3.5-1.57-3.5-3.5s1.57-3.5 3.5-3.5 3.5 1.57 3.5 3.5-1.57 3.5-3.5 3.5z">
        </path>
      </g>
      <g id="star">
        <path
          d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z">
        </path>
      </g>
      <g id="sync" viewBox="0 -960 960 960">
        <path
          d="M216-192v-72h74q-45-40-71.5-95.5T192-480q0-101 61-177.5T408-758v75q-63 23-103.5 77.5T264-480q0 48 19.5 89t52.5 70v-63h72v192H216Zm336-10v-75q63-23 103.5-77.5T696-480q0-48-19.5-89T624-639v63h-72v-192h192v72h-74q45 40 71.5 95.5T768-480q0 101-61 177.5T552-202Z">
        </path>
      </g>
      <g id="thumbs-down">
        <path
            d="M6 3h11v13l-7 7-1.25-1.25a1.454 1.454 0 0 1-.3-.475c-.067-.2-.1-.392-.1-.575v-.35L9.45 16H3c-.533 0-1-.2-1.4-.6-.4-.4-.6-.867-.6-1.4v-2c0-.117.017-.242.05-.375s.067-.258.1-.375l3-7.05c.15-.333.4-.617.75-.85C5.25 3.117 5.617 3 6 3Zm9 2H6l-3 7v2h9l-1.35 5.5L15 15.15V5Zm0 10.15V5v10.15Zm2 .85v-2h3V5h-3V3h5v13h-5Z">
        </path>
      </g>
      <g id="thumbs-down-filled">
        <path
            d="M6 3h10v13l-7 7-1.25-1.25a1.336 1.336 0 0 1-.29-.477 1.66 1.66 0 0 1-.108-.574v-.347L8.449 16H3c-.535 0-1-.2-1.398-.602C1.199 15 1 14.535 1 14v-2c0-.117.012-.242.04-.375.022-.133.062-.258.108-.375l3-7.05c.153-.333.403-.618.75-.848A1.957 1.957 0 0 1 6 3Zm12 13V3h4v13Zm0 0">
        </path>
      </g>
      <g id="thumbs-up">
        <path
            d="M18 21H7V8l7-7 1.25 1.25c.117.117.208.275.275.475.083.2.125.392.125.575v.35L14.55 8H21c.533 0 1 .2 1.4.6.4.4.6.867.6 1.4v2c0 .117-.017.242-.05.375s-.067.258-.1.375l-3 7.05c-.15.333-.4.617-.75.85-.35.233-.717.35-1.1.35Zm-9-2h9l3-7v-2h-9l1.35-5.5L9 8.85V19ZM9 8.85V19 8.85ZM7 8v2H4v9h3v2H2V8h5Z">
        </path>
      </g>
      <g id="thumbs-up-filled">
        <path
            d="M18 21H8V8l7-7 1.25 1.25c.117.117.21.273.29.477.073.199.108.39.108.574v.347L15.551 8H21c.535 0 1 .2 1.398.602C22.801 9 23 9.465 23 10v2c0 .117-.012.242-.04.375a1.897 1.897 0 0 1-.108.375l-3 7.05a2.037 2.037 0 0 1-.75.848A1.957 1.957 0 0 1 18 21ZM6 8v13H2V8Zm0 0">
      </g>
      <g id="videocam" viewBox="0 -960 960 960">
        <path
          d="M216-192q-29 0-50.5-21.5T144-264v-432q0-29.7 21.5-50.85Q187-768 216-768h432q29.7 0 50.85 21.15Q720-725.7 720-696v168l144-144v384L720-432v168q0 29-21.15 50.5T648-192H216Zm0-72h432v-432H216v432Zm0 0v-432 432Z">
        </path>
      </g>
      <g id="warning">
        <path d="M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z"></path>
      </g>
    </defs>
  </svg>
</cr-iconset>`;
const iconsets = div.querySelectorAll('cr-iconset');
for (const iconset of iconsets) {
    document.head.appendChild(iconset);
}

// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Make a string safe for Polymer bindings that are inner-h-t-m-l or other
 * innerHTML use.
 * @param rawString The unsanitized string
 * @param opts Optional additional allowed tags and attributes.
 */
function sanitizeInnerHtmlInternal(rawString, opts) {
    opts = opts || {};
    const html = parseHtmlSubset(`<b>${rawString}</b>`, opts.tags, opts.attrs)
        .firstElementChild;
    return html.innerHTML;
}
// 
let sanitizedPolicy = null;
/**
 * Same as |sanitizeInnerHtmlInternal|, but it passes through sanitizedPolicy
 * to create a TrustedHTML.
 */
function sanitizeInnerHtml(rawString, opts) {
    assert(window.trustedTypes);
    if (sanitizedPolicy === null) {
        // Initialize |sanitizedPolicy| lazily.
        sanitizedPolicy = window.trustedTypes.createPolicy('sanitize-inner-html', {
            createHTML: sanitizeInnerHtmlInternal,
            createScript: () => assertNotReached(),
            createScriptURL: () => assertNotReached(),
        });
    }
    return sanitizedPolicy.createHTML(rawString, opts);
}
const allowAttribute = (_node, _value) => true;
/** Allow-list of attributes in parseHtmlSubset. */
const allowedAttributes = new Map([
    [
        'href',
        (node, value) => {
            // Only allow a[href] starting with chrome:// or https:// or equaling
            // to #.
            return node.tagName === 'A' &&
                (value.startsWith('chrome://') || value.startsWith('https://') ||
                    value === '#');
        },
    ],
    [
        'target',
        (node, value) => {
            // Only allow a[target='_blank'].
            // TODO(dbeam): are there valid use cases for target !== '_blank'?
            return node.tagName === 'A' && value === '_blank';
        },
    ],
]);
/** Allow-list of optional attributes in parseHtmlSubset. */
const allowedOptionalAttributes = new Map([
    ['class', allowAttribute],
    ['id', allowAttribute],
    ['is', (_node, value) => value === 'action-link' || value === ''],
    ['role', (_node, value) => value === 'link'],
    [
        'src',
        (node, value) => {
            // Only allow img[src] starting with chrome://
            return node.tagName === 'IMG' &&
                value.startsWith('chrome://');
        },
    ],
    ['tabindex', allowAttribute],
    ['aria-description', allowAttribute],
    ['aria-hidden', allowAttribute],
    ['aria-label', allowAttribute],
    ['aria-labelledby', allowAttribute],
]);
/** Allow-list of tag names in parseHtmlSubset. */
const allowedTags = new Set(['A', 'B', 'I', 'BR', 'DIV', 'EM', 'KBD', 'P', 'PRE', 'SPAN', 'STRONG']);
/** Allow-list of optional tag names in parseHtmlSubset. */
const allowedOptionalTags = new Set(['IMG', 'LI', 'UL']);
/**
 * This policy maps a given string to a `TrustedHTML` object
 * without performing any validation. Callsites must ensure
 * that the resulting object will only be used in inert
 * documents. Initialized lazily.
 */
let unsanitizedPolicy;
/**
 * @param optTags an Array to merge.
 * @return Set of allowed tags.
 */
function mergeTags(optTags) {
    const clone = new Set(allowedTags);
    optTags.forEach(str => {
        const tag = str.toUpperCase();
        if (allowedOptionalTags.has(tag)) {
            clone.add(tag);
        }
    });
    return clone;
}
/**
 * @param optAttrs an Array to merge.
 * @return Map of allowed attributes.
 */
function mergeAttrs(optAttrs) {
    const clone = new Map(allowedAttributes);
    optAttrs.forEach(key => {
        if (allowedOptionalAttributes.has(key)) {
            clone.set(key, allowedOptionalAttributes.get(key));
        }
    });
    return clone;
}
function walk(n, f) {
    f(n);
    for (let i = 0; i < n.childNodes.length; i++) {
        walk(n.childNodes[i], f);
    }
}
function assertElement(tags, node) {
    if (!tags.has(node.tagName)) {
        throw Error(node.tagName + ' is not supported');
    }
}
function assertAttribute(attrs, attrNode, node) {
    const n = attrNode.nodeName;
    const v = attrNode.nodeValue || '';
    if (!attrs.has(n) || !attrs.get(n)(node, v)) {
        throw Error(node.tagName + '[' + n + '="' + v +
            '"] is not supported');
    }
}
/**
 * Parses a very small subset of HTML. This ensures that insecure HTML /
 * javascript cannot be injected into WebUI.
 * @param s The string to parse.
 * @param extraTags Optional extra allowed tags.
 * @param extraAttrs
 *     Optional extra allowed attributes (all tags are run through these).
 * @throws an Error in case of non supported markup.
 * @return A document fragment containing the DOM tree.
 */
function parseHtmlSubset(s, extraTags, extraAttrs) {
    const tags = extraTags ? mergeTags(extraTags) : allowedTags;
    const attrs = extraAttrs ? mergeAttrs(extraAttrs) : allowedAttributes;
    const doc = document.implementation.createHTMLDocument('');
    const r = doc.createRange();
    r.selectNode(doc.body);
    if (window.trustedTypes) {
        if (!unsanitizedPolicy) {
            unsanitizedPolicy =
                window.trustedTypes.createPolicy('parse-html-subset', {
                    createHTML: (untrustedHTML) => untrustedHTML,
                    createScript: () => assertNotReached(),
                    createScriptURL: () => assertNotReached(),
                });
        }
        s = unsanitizedPolicy.createHTML(s);
    }
    // This does not execute any scripts because the document has no view.
    const df = r.createContextualFragment(s);
    walk(df, function (node) {
        switch (node.nodeType) {
            case Node.ELEMENT_NODE:
                assertElement(tags, node);
                const nodeAttrs = node.attributes;
                for (let i = 0; i < nodeAttrs.length; ++i) {
                    assertAttribute(attrs, nodeAttrs[i], node);
                }
                break;
            case Node.COMMENT_NODE:
            case Node.DOCUMENT_FRAGMENT_NODE:
            case Node.TEXT_NODE:
                break;
            default:
                throw Error('Node type ' + node.nodeType + ' is not supported');
        }
    });
    return df;
}

let instance$y = null;
function getCss$u() {
    return instance$y || (instance$y = [...[], css `.icon-arrow-back{--cr-icon-image:url(//resources/images/icon_arrow_back.svg)}.icon-arrow-dropdown{--cr-icon-image:url(//resources/images/icon_arrow_dropdown.svg)}.icon-arrow-drop-down-cr23{--cr-icon-image:url(//resources/images/icon_arrow_drop_down_cr23.svg)}.icon-arrow-drop-up-cr23{--cr-icon-image:url(//resources/images/icon_arrow_drop_up_cr23.svg)}.icon-arrow-upward{--cr-icon-image:url(//resources/images/icon_arrow_upward.svg)}.icon-cancel{--cr-icon-image:url(//resources/images/icon_cancel.svg)}.icon-clear{--cr-icon-image:url(//resources/images/icon_clear.svg)}.icon-copy-content{--cr-icon-image:url(//resources/images/icon_copy_content.svg)}.icon-delete-gray{--cr-icon-image:url(//resources/images/icon_delete_gray.svg)}.icon-edit{--cr-icon-image:url(//resources/images/icon_edit.svg)}.icon-file{--cr-icon-image:url(//resources/images/icon_filetype_generic.svg)}.icon-folder-open{--cr-icon-image:url(//resources/images/icon_folder_open.svg)}.icon-picture-delete{--cr-icon-image:url(//resources/images/icon_picture_delete.svg)}.icon-expand-less{--cr-icon-image:url(//resources/images/icon_expand_less.svg)}.icon-expand-more{--cr-icon-image:url(//resources/images/icon_expand_more.svg)}.icon-external{--cr-icon-image:url(//resources/images/open_in_new.svg)}.icon-more-vert{--cr-icon-image:url(//resources/images/icon_more_vert.svg)}.icon-refresh{--cr-icon-image:url(//resources/images/icon_refresh.svg)}.icon-search{--cr-icon-image:url(//resources/images/icon_search.svg)}.icon-settings{--cr-icon-image:url(//resources/images/icon_settings.svg)}.icon-visibility{--cr-icon-image:url(//resources/images/icon_visibility.svg)}.icon-visibility-off{--cr-icon-image:url(//resources/images/icon_visibility_off.svg)}.subpage-arrow{--cr-icon-image:url(//resources/images/arrow_right.svg)}.cr-icon{-webkit-mask-image:var(--cr-icon-image);-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-icon-size);background-color:var(--cr-icon-color,var(--google-grey-700));flex-shrink:0;height:var(--cr-icon-ripple-size);margin-inline-end:var(--cr-icon-ripple-margin);margin-inline-start:var(--cr-icon-button-margin-start);user-select:none;width:var(--cr-icon-ripple-size)}:host-context([dir=rtl]) .cr-icon{transform:scaleX(-1)}.cr-icon.no-overlap{margin-inline-end:0;margin-inline-start:0}@media (prefers-color-scheme:dark){.cr-icon{background-color:var(--cr-icon-color,var(--google-grey-500))}}`]);
}

let instance$x = null;
function getCss$t() {
    return instance$x || (instance$x = [...[getCss$w(), getCss$u()], css `[actionable]{cursor:pointer}.hr{border-top:var(--cr-separator-line)}iron-list.cr-separators>*:not([first]){border-top:var(--cr-separator-line)}[scrollable]{border-color:transparent;border-style:solid;border-width:1px 0;overflow-y:auto}[scrollable].is-scrolled{border-top-color:var(--cr-scrollable-border-color)}[scrollable].can-scroll:not(.scrolled-to-bottom){border-bottom-color:var(--cr-scrollable-border-color)}[scrollable] iron-list>:not(.no-outline):focus-visible,[selectable]:focus-visible,[selectable]>:focus-visible{outline:solid 2px var(--cr-focus-outline-color);outline-offset:-2px}.scroll-container{display:flex;flex-direction:column;min-height:1px}[selectable]>*{cursor:pointer}.cr-centered-card-container{box-sizing:border-box;display:block;height:inherit;margin:0 auto;max-width:var(--cr-centered-card-max-width);min-width:550px;position:relative;width:calc(100% * var(--cr-centered-card-width-percentage))}.cr-container-shadow{box-shadow:inset 0 5px 6px -3px rgba(0,0,0,.4);height:var(--cr-container-shadow-height);left:0;margin:0 0 var(--cr-container-shadow-margin);opacity:0;pointer-events:none;position:relative;right:0;top:0;transition:opacity 500ms;z-index:1}#cr-container-shadow-bottom{margin-bottom:0;margin-top:var(--cr-container-shadow-margin);transform:scaleY(-1)}#cr-container-shadow-top:has(+#container.can-scroll:not(.scrolled-to-top)),#container.can-scroll:not(.scrolled-to-bottom)+#cr-container-shadow-bottom,#cr-container-shadow-bottom.force-shadow,#cr-container-shadow-top.force-shadow{opacity:var(--cr-container-shadow-max-opacity)}.cr-row{align-items:center;border-top:var(--cr-separator-line);display:flex;min-height:var(--cr-section-min-height);padding:0 var(--cr-section-padding)}.cr-row.first,.cr-row.continuation{border-top:none}.cr-row-gap{padding-inline-start:16px}.cr-button-gap{margin-inline-start:8px}paper-tooltip::part(tooltip),cr-tooltip::part(tooltip){border-radius:var(--paper-tooltip-border-radius,2px);font-size:92.31%;font-weight:500;max-width:330px;min-width:var(--paper-tooltip-min-width,200px);padding:var(--paper-tooltip-padding,10px 8px)}.cr-padded-text{padding-block-end:var(--cr-section-vertical-padding);padding-block-start:var(--cr-section-vertical-padding)}.cr-title-text{color:var(--cr-title-text-color);font-size:107.6923%;font-weight:500}.cr-secondary-text{color:var(--cr-secondary-text-color);font-weight:400}.cr-form-field-label{color:var(--cr-form-field-label-color);display:block;font-size:var(--cr-form-field-label-font-size);font-weight:500;letter-spacing:.4px;line-height:var(--cr-form-field-label-line-height);margin-bottom:8px}.cr-vertical-tab{align-items:center;display:flex}.cr-vertical-tab::before{border-radius:0 3px 3px 0;content:'';display:block;flex-shrink:0;height:var(--cr-vertical-tab-height,100%);width:4px}.cr-vertical-tab.selected::before{background:var(--cr-vertical-tab-selected-color,var(--cr-checked-color))}:host-context([dir=rtl]) .cr-vertical-tab::before{transform:scaleX(-1)}.iph-anchor-highlight{background-color:var(--cr-iph-anchor-highlight-color)}`]);
}

let instance$w = null;
function getCss$s() {
    return instance$w || (instance$w = [...[getCss$t()], css `:host{--cr-localized-link-display:inline;display:block}:host([link-disabled]){cursor:pointer;opacity:var(--cr-disabled-opacity);pointer-events:none}a{display:var(--cr-localized-link-display)}a[href]{color:var(--cr-link-color)}a[is=action-link]{user-select:none}#container{display:contents}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$n() {
    return html `
<!-- innerHTML is set via setContainerInnerHtml_. -->
<div id="container"></div>`;
}

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'localized-link' takes a localized string that
 * contains up to one anchor tag, and labels the string contained within the
 * anchor tag with the entire localized string. The string should not be bound
 * by element tags. The string should not contain any elements other than the
 * single anchor tagged element that will be aria-labelledby the entire string.
 *
 * Example: "lorem ipsum <a href="example.com">Learn More</a> dolor sit"
 *
 * The "Learn More" will be aria-labelledby like so: "lorem ipsum Learn More
 * dolor sit". Meanwhile, "Lorem ipsum" and "dolor sit" will be aria-hidden.
 *
 * This element also supports strings that do not contain anchor tags; in this
 * case, the element gracefully falls back to normal text. This can be useful
 * when the property is data-bound to a function which sometimes returns a
 * string with a link and sometimes returns a normal string.
 */
class LocalizedLinkElement extends CrLitElement {
    static get is() {
        return 'localized-link';
    }
    static get styles() {
        return getCss$s();
    }
    render() {
        return getHtml$n.bind(this)();
    }
    static get properties() {
        return {
            /**
             * The localized string that contains up to one anchor tag, the text
             * within which will be aria-labelledby the entire localizedString.
             */
            localizedString: { type: String },
            /**
             * If provided, the URL that the anchor tag will point to. There is no
             * need to provide a linkUrl if the URL is embedded in the
             * localizedString.
             */
            linkUrl: { type: String },
            /**
             * If true, localized link will be disabled.
             */
            linkDisabled: {
                type: Boolean,
                reflect: true,
            },
            /**
             * localizedString, with aria attributes and the optionally provided
             * link.
             */
            containerInnerHTML_: { type: String },
        };
    }
    #localizedString_accessor_storage = '';
    get localizedString() { return this.#localizedString_accessor_storage; }
    set localizedString(value) { this.#localizedString_accessor_storage = value; }
    #linkUrl_accessor_storage = '';
    get linkUrl() { return this.#linkUrl_accessor_storage; }
    set linkUrl(value) { this.#linkUrl_accessor_storage = value; }
    #linkDisabled_accessor_storage = false;
    get linkDisabled() { return this.#linkDisabled_accessor_storage; }
    set linkDisabled(value) { this.#linkDisabled_accessor_storage = value; }
    #containerInnerHTML__accessor_storage = '';
    get containerInnerHTML_() { return this.#containerInnerHTML__accessor_storage; }
    set containerInnerHTML_(value) { this.#containerInnerHTML__accessor_storage = value; }
    willUpdate(changedProperties) {
        super.willUpdate(changedProperties);
        if (changedProperties.has('localizedString') ||
            changedProperties.has('linkUrl')) {
            this.containerInnerHTML_ =
                this.getAriaLabelledContent_(this.localizedString, this.linkUrl);
        }
    }
    updated(changedProperties) {
        super.updated(changedProperties);
        const changedPrivateProperties = changedProperties;
        if (changedPrivateProperties.has('containerInnerHTML_')) {
            this.setContainerInnerHtml_();
        }
        if (changedProperties.has('linkDisabled')) {
            this.updateAnchorTagTabIndex_();
        }
    }
    /**
     * Attaches aria attributes and optionally provided link to the provided
     * localizedString.
     * @return localizedString formatted with additional ids, spans, and an
     *     aria-labelledby tag
     */
    getAriaLabelledContent_(localizedString, linkUrl) {
        const tempEl = document.createElement('div');
        tempEl.innerHTML = sanitizeInnerHtml(localizedString, { attrs: ['id'] });
        const ariaLabelledByIds = [];
        tempEl.childNodes.forEach((node, index) => {
            // Text nodes should be aria-hidden and associated with an element id
            // that the anchor element can be aria-labelledby.
            if (node.nodeType === Node.TEXT_NODE) {
                const spanNode = document.createElement('span');
                spanNode.textContent = node.textContent;
                spanNode.id = `id${index}`;
                ariaLabelledByIds.push(spanNode.id);
                spanNode.setAttribute('aria-hidden', 'true');
                node.replaceWith(spanNode);
                return;
            }
            // The single element node with anchor tags should also be aria-labelledby
            // itself in-order with respect to the entire string.
            if (node.nodeType === Node.ELEMENT_NODE && node.nodeName === 'A') {
                const element = node;
                element.id = `id${index}`;
                ariaLabelledByIds.push(element.id);
                return;
            }
            // Only text and <a> nodes are allowed.
            assertNotReached('localized-link has invalid node types');
        });
        const anchorTags = tempEl.querySelectorAll('a');
        // In the event the provided localizedString contains only text nodes,
        // populate the contents with the provided localizedString.
        if (anchorTags.length === 0) {
            return localizedString;
        }
        assert(anchorTags.length === 1, 'localized-link should contain exactly one anchor tag');
        const anchorTag = anchorTags[0];
        anchorTag.setAttribute('aria-labelledby', ariaLabelledByIds.join(' '));
        anchorTag.tabIndex = this.linkDisabled ? -1 : 0;
        if (linkUrl !== '') {
            anchorTag.href = linkUrl;
            anchorTag.target = '_blank';
        }
        return tempEl.innerHTML;
    }
    setContainerInnerHtml_() {
        this.$.container.innerHTML = sanitizeInnerHtml(this.containerInnerHTML_, {
            attrs: [
                'aria-hidden',
                'aria-labelledby',
                'id',
                'tabindex',
            ],
        });
        const anchorTag = this.shadowRoot.querySelector('a');
        if (anchorTag) {
            anchorTag.addEventListener('click', (event) => this.onAnchorTagClick_(event));
            anchorTag.addEventListener('auxclick', (event) => {
                // trigger the click handler on middle-button clicks
                if (event.button === 1) {
                    this.onAnchorTagClick_(event);
                }
            });
        }
    }
    onAnchorTagClick_(event) {
        if (this.linkDisabled) {
            event.preventDefault();
            return;
        }
        this.fire('link-clicked', { event });
        // Stop propagation of the event, since it has already been handled by
        // opening the link.
        event.stopPropagation();
    }
    /**
     *  Removes anchor tag from being targeted by chromeVox when link is
     *  disabled.
     */
    updateAnchorTagTabIndex_() {
        const anchorTag = this.shadowRoot.querySelector('a');
        if (!anchorTag) {
            return;
        }
        anchorTag.tabIndex = this.linkDisabled ? -1 : 0;
    }
}
customElements.define(LocalizedLinkElement.is, LocalizedLinkElement);

let instance$v = null;
function getCss$r() {
    return instance$v || (instance$v = [...[], css `.auto-tab-groups-body{color:var(--color-secondary-foreground);font-size:13px;font-weight:400;line-height:20px}.auto-tab-groups-container{display:flex;flex-direction:column;gap:16px;width:100%}.auto-tab-groups-header{color:var(--cr-primary-text-color);font-size:14px;font-weight:500}.auto-tab-groups-link{color:var(--color-link-foreground-on-bubble-footer);cursor:pointer;display:inline-block;font-size:13px;font-weight:400;outline-color:var(--color-button-foreground);outline-offset:1px;text-decoration:underline;width:fit-content}.auto-tab-groups-text-container{display:flex;flex-direction:column;gap:8px}@keyframes displayOut{0%{height:auto;visibility:visible;position:relative}50%{visibility:visible}100%{height:0;visibility:hidden;position:absolute}}@keyframes displayIn{0%{height:0;visibility:hidden;position:absolute}50%{visibility:hidden}100%{height:auto;visibility:visible;position:relative}}@keyframes fadeOut{0%{opacity:1}100%{opacity:0}}@keyframes fadeIn{0%{opacity:0}100%{opacity:1}}@keyframes slideOut{0%{transform:translateY(0px)}100%{transform:translateY(-16px)}}@keyframes slideIn{0%{transform:translateY(16px)}100%{transform:translateY(0px)}}`]);
}

let instance$u = null;
function getCss$q() {
    return instance$u || (instance$u = [...[getCss$r()], css `.footer{background-color:var(--color-bubble-footer-background);display:flex;flex-direction:column;margin:0 -20px -20px -20px;padding:16px var(--mwb-list-item-horizontal-margin)}.auto-tab-groups-body{width:280px}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$m() {
    // clang-format off
    return html `<!--_html_template_start_-->
<div class="auto-tab-groups-container">
  <div class="auto-tab-groups-text-container">
    <div class="auto-tab-groups-body">
      <localized-link localized-string="${this.getBody_()}"
          @link-clicked="${this.onCheckNow_}"></localized-link>
    </div>
  </div>
  ${this.showFre ? html `
    <div class="footer">
      <div class="auto-tab-groups-body">
        <b>$i18n{tipTitle}</b> $i18n{tipBody}
        <div class="auto-tab-groups-link"
            role="link"
            tabindex="0"
            @click="${this.onTipClick_}"
            @keydown="${this.onTipKeyDown_}"
            aria-description="$i18n{tipAriaDescription}">
          $i18n{tipAction}
        </div>
      </div>
    </div>
  ` : ''}
</div>
<!--_html_template_end_-->`;
    // clang-format on
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Failure state for the auto tab groups UI.
class AutoTabGroupsFailureElement extends CrLitElement {
    static get is() {
        return 'auto-tab-groups-failure';
    }
    static get properties() {
        return {
            error: { type: Number },
            showFre: { type: Boolean },
        };
    }
    #error_accessor_storage = TabOrganizationError.kNone;
    get error() { return this.#error_accessor_storage; }
    set error(value) { this.#error_accessor_storage = value; }
    #showFre_accessor_storage = false;
    get showFre() { return this.#showFre_accessor_storage; }
    set showFre(value) { this.#showFre_accessor_storage = value; }
    static get styles() {
        return getCss$q();
    }
    render() {
        return getHtml$m.bind(this)();
    }
    getBody_() {
        switch (this.error) {
            case TabOrganizationError.kGrouping:
                return loadTimeData.getString('failureBodyGrouping');
            case TabOrganizationError.kGeneric:
                return loadTimeData.getString('failureBodyGeneric');
            default:
                return '';
        }
    }
    onCheckNow_(e) {
        // A place holder href with the value "#" is used to have a compliant link.
        // This prevents the browser from navigating the window to "#"
        e.detail.event.preventDefault();
        e.stopPropagation();
        this.fire('check-now');
    }
    onTipClick_() {
        this.fire('tip-click');
    }
    onTipKeyDown_(event) {
        if (event.key === 'Enter') {
            this.onTipClick_();
        }
    }
}
customElements.define(AutoTabGroupsFailureElement.is, AutoTabGroupsFailureElement);

let instance$t = null;
function getCss$p() {
    return instance$t || (instance$t = [...[], css `:host{--cr-loading-gradient-color-start:var(--color-loading-gradient-start,transparent);--cr-loading-gradient-color-middle:var(--color-loading-gradient-middle,var(--cr-fallback-color-primary-container));--cr-loading-gradient-color-end:var(--color-loading-gradient-end,rgb(231,248,237));display:flex;width:100%;height:fit-content;position:relative}@media (prefers-color-scheme:dark){:host{--cr-loading-gradient-color-end:var(--color-loading-gradient-end,rgb(15,82,35))}}#gradient{position:absolute;inset:0;background:linear-gradient(135deg,var(--cr-loading-gradient-color-start) 0%,var(--cr-loading-gradient-color-middle) 20%,var(--cr-loading-gradient-color-end) 40%,var(--cr-loading-gradient-color-start) 60%,var(--cr-loading-gradient-color-middle) 80%,var(--cr-loading-gradient-color-end) 100%);background-position:100% 100%;background-size:250% 250%;animation:gradient 2s infinite linear}@keyframes gradient{0%{background-position:100% 100%}100%{background-position:0% 0%}}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$l() {
    return html `
<div id="gradient"></div>
<slot @slotchange="${this.onSlotchange_}"></slot>`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/* Count of cr-loading-gradient elements created. Used to assign unique IDs.
 * Unique IDs are necessary since clipPaths are slotted in from the light DOM,
 * so there can be leakages across multiple <cr-loading-gradient> instances. */
let count = 0;
class CrLoadingGradientElement extends CrLitElement {
    static get is() {
        return 'cr-loading-gradient';
    }
    static get styles() {
        return getCss$p();
    }
    render() {
        return getHtml$l.bind(this)();
    }
    onSlotchange_() {
        const clipPath = this.querySelector('svg clipPath');
        assert(clipPath);
        const generatedId = `crLoadingGradient${count++}`;
        clipPath.id = generatedId;
        this.style.clipPath = `url(#${generatedId})`;
    }
}
customElements.define(CrLoadingGradientElement.is, CrLoadingGradientElement);

let instance$s = null;
function getCss$o() {
    return instance$s || (instance$s = [...[getCss$r()], css `#loading-container{border:solid 1px var(--color-loading-gradient-border);border-radius:8px;padding:14px}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$k() {
    // clang-format off
    return html `<!--_html_template_start_-->
<div id="loading-container">
  <cr-loading-gradient>
      <svg width="100%" height="191">
        <clipPath>
          <rect x="0" y="0" width="100%" height="35" rx="8"></rect>
          <rect x="0" y="55" width="40" height="40" rx="8"></rect>
          <rect x="56" y="57" width="116" height="16" rx="4"></rect>
          <rect x="56" y="105" width="116" height="16" rx="4"></rect>
          <rect x="56" y="153" width="116" height="16" rx="4"></rect>
          <rect x="56" y="79" width="76" height="14" rx="4"></rect>
          <rect x="56" y="127" width="76" height="14" rx="4"></rect>
          <rect x="56" y="175" width="76" height="14" rx="4"></rect>
          <rect x="0" y="103" width="40" height="40" rx="8"></rect>
          <rect x="0" y="151" width="40" height="40" rx="8"></rect>
        </clipPath>
      </svg>
    </cr-loading-gradient>
  </div>
</div>
<!--_html_template_end_-->`;
    // clang-format on
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Loading state for the auto tab groups UI.
class AutoTabGroupsInProgressElement extends CrLitElement {
    static get is() {
        return 'auto-tab-groups-in-progress';
    }
    static get styles() {
        return getCss$o();
    }
    render() {
        return getHtml$k.bind(this)();
    }
}
customElements.define(AutoTabGroupsInProgressElement.is, AutoTabGroupsInProgressElement);

let instance$r = null;
function getCss$n() {
    return instance$r || (instance$r = [...[], css `:host{--cr-radio-button-checked-color:var(--color-radio-button-foreground-checked,var(--cr-fallback-color-primary));--cr-radio-button-checked-ripple-color:var(--cr-active-background-color);--cr-radio-button-ink-size:32px;--cr-radio-button-size:16px;--cr-radio-button-unchecked-color:var(--color-radio-button-foreground-unchecked,var(--cr-fallback-color-outline));--cr-radio-button-unchecked-ripple-color:var(--cr-active-background-color);--ink-to-circle:calc((var(--cr-radio-button-ink-size) - var(--cr-radio-button-size)) / 2);align-items:center;display:flex;flex-shrink:0;gap:var(--cr-radio-button-label-spacing,20px);outline:none}@media (prefers-color-scheme:dark){:host{--cr-radio-button-checked-color:var(--google-blue-300);--cr-radio-button-checked-ripple-color:rgba(var(--google-blue-300-rgb),.4);--cr-radio-button-unchecked-color:var(--google-grey-500);--cr-radio-button-unchecked-ripple-color:rgba(var(--google-grey-300-rgb),.4)}}@media (forced-colors:active){:host{--cr-radio-button-checked-color:SelectedItem;forced-color-adjust:none}}:host([disabled]){opacity:1;pointer-events:none;--cr-radio-button-checked-color:var(--color-radio-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--cr-radio-button-unchecked-color:var(--color-radio-foreground-disabled,var(--cr-fallback-color-disabled-foreground))}:host(:not([disabled])){cursor:pointer}:host(.label-first){flex-direction:row-reverse}#labelWrapper{flex:1}:host([disabled]) #labelWrapper{opacity:var(--cr-disabled-opacity)}#label{color:inherit}:host([hide-label-text]) #label{clip:rect(0,0,0,0);display:block;position:fixed}.disc-border,.disc,.disc-wrapper,cr-ripple,paper-ripple{border-radius:50%}.disc-wrapper{height:var(--cr-radio-button-size);margin-block-start:var(--cr-radio-button-disc-margin-block-start,0);position:relative;width:var(--cr-radio-button-size)}.disc-border,.disc{box-sizing:border-box;height:var(--cr-radio-button-size);width:var(--cr-radio-button-size)}.disc-border{border:2px solid var(--cr-radio-button-unchecked-color)}:host([checked]) .disc-border{border-color:var(--cr-radio-button-checked-color)}#button:focus{outline:none}.disc{background-color:transparent;position:absolute;top:0;transform:scale(0);transition:border-color 200ms,transform 200ms}:host([checked]) .disc{background-color:var(--cr-radio-button-checked-color);transform:scale(0.5)}#overlay{border-radius:50%;box-sizing:border-box;display:none;height:var(--cr-radio-button-ink-size);left:50%;pointer-events:none;position:absolute;top:50%;transform:translate(-50%,-50%);width:var(--cr-radio-button-ink-size)}#button:hover #overlay{background-color:var(--cr-hover-background-color);display:block}#button:focus-visible #overlay{border:2px solid var(--cr-focus-outline-color);display:block}cr-ripple,paper-ripple{--paper-ripple-opacity:1;color:var(--cr-radio-button-unchecked-ripple-color);height:var(--cr-radio-button-ink-size);left:calc(-1 * var(--ink-to-circle));pointer-events:none;position:absolute;top:calc(-1 * var(--ink-to-circle));transition:color linear 80ms;width:var(--cr-radio-button-ink-size)}:host-context([dir=rtl]) cr-ripple,:host-context([dir=rtl]) paper-ripple{left:auto;right:calc(-1 * var(--ink-to-circle))}:host([checked]) cr-ripple,:host([checked]) paper-ripple{color:var(--cr-radio-button-checked-ripple-color)}`]);
}

let instance$q = null;
function getCss$m() {
    return instance$q || (instance$q = [...[getCss$n(), getCss$w()], css ``]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$j() {
    return html `
<div aria-checked="${this.getAriaChecked()}"
    aria-describedby="slotted-content"
    aria-disabled="${this.getAriaDisabled()}"
    aria-labelledby="label"
    class="disc-wrapper"
    id="button"
    role="radio"
    tabindex="${this.getButtonTabIndex()}"
    @keydown="${this.onInputKeydown}">
  <div class="disc-border"></div>
  <div class="disc"></div>
  <div id="overlay"></div>
</div>

<div id="labelWrapper">
  <span id="label" ?hidden="${!this.label}" aria-hidden="true">
    ${this.label}
  </span>
  <span id="slotted-content">
    <slot></slot>
  </span>
</div>`;
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrRadioButtonMixinLit = (superClass) => {
    class CrRadioButtonMixinLit extends superClass {
        static get properties() {
            return {
                checked: {
                    type: Boolean,
                    reflect: true,
                },
                disabled: {
                    type: Boolean,
                    reflect: true,
                    notify: true,
                },
                /**
                 * Whether the radio button should be focusable or not. Toggling
                 * this property sets the corresponding tabindex of the button
                 * itself as well as any links in the button description.
                 */
                focusable: {
                    type: Boolean,
                },
                hideLabelText: {
                    type: Boolean,
                    reflect: true,
                },
                label: {
                    type: String,
                },
                name: {
                    type: String,
                    notify: true,
                    reflect: true,
                },
                /**
                 * Holds the tabIndex for the radio button.
                 */
                ariaCheckedString: { type: String },
                ariaDisabledString: { type: String },
            };
        }
        #checked_accessor_storage = false;
        get checked() { return this.#checked_accessor_storage; }
        set checked(value) { this.#checked_accessor_storage = value; }
        #disabled_accessor_storage = false;
        get disabled() { return this.#disabled_accessor_storage; }
        set disabled(value) { this.#disabled_accessor_storage = value; }
        #focusable_accessor_storage = false;
        get focusable() { return this.#focusable_accessor_storage; }
        set focusable(value) { this.#focusable_accessor_storage = value; }
        #hideLabelText_accessor_storage = false;
        get hideLabelText() { return this.#hideLabelText_accessor_storage; }
        set hideLabelText(value) { this.#hideLabelText_accessor_storage = value; }
        #label_accessor_storage = '';
        get label() { return this.#label_accessor_storage; }
        set label(value) { this.#label_accessor_storage = value; }
        #name_accessor_storage;
        get name() { return this.#name_accessor_storage; }
        set name(value) { this.#name_accessor_storage = value; }
        noRipple = false;
        #ariaCheckedString_accessor_storage = 'false';
        get ariaCheckedString() { return this.#ariaCheckedString_accessor_storage; }
        set ariaCheckedString(value) { this.#ariaCheckedString_accessor_storage = value; }
        #ariaDisabledString_accessor_storage = 'false';
        get ariaDisabledString() { return this.#ariaDisabledString_accessor_storage; }
        set ariaDisabledString(value) { this.#ariaDisabledString_accessor_storage = value; }
        connectedCallback() {
            super.connectedCallback();
            if (!this.noRipple) {
                this.addEventListener('blur', this.hideRipple_.bind(this));
                this.addEventListener('up', this.hideRipple_.bind(this));
            }
        }
        updated(changedProperties) {
            super.updated(changedProperties);
            if (changedProperties.has('focusable')) {
                const links = this.querySelectorAll('a');
                links.forEach(link => {
                    // Remove the tab stop on any links when the row is unchecked.
                    // Since the row is not tabbable, any links within the row
                    // should not be either.
                    link.tabIndex = this.checked ? 0 : -1;
                });
            }
        }
        getAriaDisabled() {
            return this.disabled ? 'true' : 'false';
        }
        getAriaChecked() {
            return this.checked ? 'true' : 'false';
        }
        getButtonTabIndex() {
            return this.focusable ? 0 : -1;
        }
        focus() {
            const button = this.shadowRoot.querySelector('#button');
            assert(button);
            button.focus();
        }
        getRipple() {
            assertNotReached();
        }
        hideRipple_() {
            assert(!this.noRipple);
            this.getRipple().clear();
        }
        /**
         * When shift-tab is pressed, first bring the focus to the host
         * element. This accomplishes 2 things:
         * 1) Host doesn't get focused when the browser moves the focus
         *    backward.
         * 2) focus now escaped the shadow-dom of this element, so that
         *    it'll correctly obey non-zero tabindex ordering of the
         *    containing document.
         */
        onInputKeydown(e) {
            if (e.shiftKey && e.key === 'Tab') {
                this.focus();
            }
        }
    }
    return CrRadioButtonMixinLit;
};

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrRadioButtonElementBase = CrRippleMixin(CrRadioButtonMixinLit(CrLitElement));
class CrRadioButtonElement extends CrRadioButtonElementBase {
    static get is() {
        return 'cr-radio-button';
    }
    static get styles() {
        return getCss$m();
    }
    render() {
        return getHtml$j.bind(this)();
    }
    // Overridden from CrRippleMixin
    createRipple() {
        this.rippleContainer = this.shadowRoot.querySelector('.disc-wrapper');
        const ripple = super.createRipple();
        ripple.setAttribute('recenters', '');
        ripple.classList.add('circle');
        return ripple;
    }
}
customElements.define(CrRadioButtonElement.is, CrRadioButtonElement);

let instance$p = null;
function getCss$l() {
    return instance$p || (instance$p = [...[], css `:host{display:inline-block}:host ::slotted(*){padding:var(--cr-radio-group-item-padding,12px)}:host([disabled]){cursor:initial;pointer-events:none;user-select:none}:host([disabled]) ::slotted(*){opacity:var(--cr-disabled-opacity)}
`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$i() {
    return html `<slot></slot>`;
}

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function isEnabled(radio) {
    return radio.matches(':not([disabled]):not([hidden])') &&
        radio.style.display !== 'none' && radio.style.visibility !== 'hidden';
}
class CrRadioGroupElement extends CrLitElement {
    static get is() {
        return 'cr-radio-group';
    }
    static get styles() {
        return getCss$l();
    }
    render() {
        return getHtml$i.bind(this)();
    }
    static get properties() {
        return {
            disabled: {
                type: Boolean,
                reflect: true,
            },
            selected: {
                type: String,
                notify: true,
            },
            selectableElements: { type: String },
            nestedSelectable: { type: Boolean },
            selectableRegExp_: { type: Object },
        };
    }
    #disabled_accessor_storage = false;
    get disabled() { return this.#disabled_accessor_storage; }
    set disabled(value) { this.#disabled_accessor_storage = value; }
    #selected_accessor_storage;
    get selected() { return this.#selected_accessor_storage; }
    set selected(value) { this.#selected_accessor_storage = value; }
    #selectableElements_accessor_storage = 'cr-radio-button, cr-card-radio-button, controlled-radio-button';
    get selectableElements() { return this.#selectableElements_accessor_storage; }
    set selectableElements(value) { this.#selectableElements_accessor_storage = value; }
    #nestedSelectable_accessor_storage = false;
    get nestedSelectable() { return this.#nestedSelectable_accessor_storage; }
    set nestedSelectable(value) { this.#nestedSelectable_accessor_storage = value; }
    #selectableRegExp__accessor_storage = new RegExp('');
    get selectableRegExp_() { return this.#selectableRegExp__accessor_storage; }
    set selectableRegExp_(value) { this.#selectableRegExp__accessor_storage = value; }
    buttons_ = null;
    buttonEventTracker_ = new EventTracker();
    deltaKeyMap_ = null;
    isRtl_ = false;
    populateBound_ = null;
    firstUpdated() {
        this.addEventListener('keydown', e => this.onKeyDown_(e));
        this.addEventListener('click', e => this.onClick_(e));
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'radiogroup');
        }
    }
    connectedCallback() {
        super.connectedCallback();
        this.isRtl_ = this.matches(':host-context([dir=rtl]) cr-radio-group');
        this.deltaKeyMap_ = new Map([
            ['ArrowDown', 1],
            ['ArrowLeft', this.isRtl_ ? 1 : -1],
            ['ArrowRight', this.isRtl_ ? -1 : 1],
            ['ArrowUp', -1],
            ['PageDown', 1],
            ['PageUp', -1],
        ]);
        this.populateBound_ = () => this.populate_();
        assert(this.populateBound_);
        this.shadowRoot.querySelector('slot').addEventListener('slotchange', this.populateBound_);
        this.populate_();
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        assert(this.populateBound_);
        this.shadowRoot.querySelector('slot').removeEventListener('slotchange', this.populateBound_);
        this.buttonEventTracker_.removeAll();
    }
    willUpdate(changedProperties) {
        super.willUpdate(changedProperties);
        if (changedProperties.has('selectableElements')) {
            const tags = this.selectableElements.split(', ').join('|');
            this.selectableRegExp_ = new RegExp(`^(${tags})$`, 'i');
        }
    }
    updated(changedProperties) {
        if (changedProperties.has('nestedSelectable')) {
            this.populate_();
        }
        if (changedProperties.has('disabled') ||
            changedProperties.has('selected')) {
            this.update_();
        }
        this.setAttribute('aria-disabled', `${this.disabled}`);
        // Clients of cr-radio-group generally expect that by the time
        // selected-changed or disabled-changed is fired, the state of the
        // buttons in the group (e.g. "checked", "disabled" properties) has been
        // updated accordingly. Since these events are fired in CrLitElement's
        // updated() method, call super.updated() only after all the button updates
        // performed in update_() are complete.
        super.updated(changedProperties);
    }
    focus() {
        if (this.disabled || !this.buttons_) {
            return;
        }
        const radio = this.buttons_.find(radio => this.isButtonEnabledAndSelected_(radio));
        if (radio) {
            radio.focus();
        }
    }
    onKeyDown_(event) {
        if (this.disabled) {
            return;
        }
        if (event.ctrlKey || event.shiftKey || event.metaKey || event.altKey) {
            return;
        }
        const targetElement = event.target;
        if (!this.buttons_ || !this.buttons_.includes(targetElement)) {
            return;
        }
        if (event.key === ' ' || event.key === 'Enter') {
            event.preventDefault();
            this.select_(targetElement);
            return;
        }
        const enabledRadios = this.buttons_.filter(isEnabled);
        if (enabledRadios.length === 0) {
            return;
        }
        assert(this.deltaKeyMap_);
        let selectedIndex;
        const max = enabledRadios.length - 1;
        if (event.key === 'Home') {
            selectedIndex = 0;
        }
        else if (event.key === 'End') {
            selectedIndex = max;
        }
        else if (this.deltaKeyMap_.has(event.key)) {
            const delta = this.deltaKeyMap_.get(event.key);
            // If nothing selected, start from the first radio then add |delta|.
            const lastSelection = enabledRadios.findIndex(radio => radio.checked);
            selectedIndex = Math.max(0, lastSelection) + delta;
            // Wrap the selection, if needed.
            if (selectedIndex > max) {
                selectedIndex = 0;
            }
            else if (selectedIndex < 0) {
                selectedIndex = max;
            }
        }
        else {
            return;
        }
        const radio = enabledRadios[selectedIndex];
        const name = `${radio.name}`;
        if (this.selected !== name) {
            event.preventDefault();
            event.stopPropagation();
            this.selected = name;
            radio.focus();
        }
    }
    onClick_(event) {
        const path = event.composedPath();
        if (path.some(target => /^a$/i.test(target.tagName))) {
            return;
        }
        const target = path.find(n => this.selectableRegExp_.test(n.tagName));
        if (target && this.buttons_ && this.buttons_.includes(target)) {
            this.select_(target);
        }
    }
    populate_() {
        const elements = this.shadowRoot.querySelector('slot').assignedElements({ flatten: true });
        this.buttons_ = Array.from(elements).flatMap(el => {
            let result = [];
            if (el.matches(this.selectableElements)) {
                result.push(el);
            }
            if (this.nestedSelectable) {
                result = result.concat(Array.from(el.querySelectorAll(this.selectableElements)));
            }
            return result;
        });
        this.buttonEventTracker_.removeAll();
        this.buttons_.forEach(el => {
            this.buttonEventTracker_.add(el, 'disabled-changed', () => this.populate_());
            this.buttonEventTracker_.add(el, 'name-changed', () => this.populate_());
        });
        this.update_();
    }
    select_(button) {
        if (!isEnabled(button)) {
            return;
        }
        const name = `${button.name}`;
        if (this.selected !== name) {
            this.selected = name;
        }
    }
    isButtonEnabledAndSelected_(button) {
        return !this.disabled && button.checked && isEnabled(button);
    }
    update_() {
        if (!this.buttons_) {
            return;
        }
        let noneMadeFocusable = true;
        this.buttons_.forEach(radio => {
            radio.checked =
                this.selected !== undefined && `${radio.name}` === `${this.selected}`;
            const disabled = this.disabled || !isEnabled(radio);
            const canBeFocused = radio.checked && !disabled;
            if (canBeFocused) {
                radio.focusable = true;
                noneMadeFocusable = false;
            }
            else {
                radio.focusable = false;
            }
            radio.setAttribute('aria-disabled', `${disabled}`);
        });
        if (noneMadeFocusable && !this.disabled) {
            const radio = this.buttons_.find(isEnabled);
            if (radio) {
                radio.focusable = true;
            }
        }
    }
}
customElements.define(CrRadioGroupElement.is, CrRadioGroupElement);

let instance$o = null;
function getCss$k() {
    return instance$o || (instance$o = [...[], css `:host{--image-background-color-1:var(--color-loading-gradient-middle);--image-background_color-2:var(--color-loading-gradient-end);--window_frame_color:var(--color-tab-search-image-window-frame);--tab-group-1-color:var(--color-tab-group-tab-strip-frame-active-blue);--tab-group-2-color:var(--color-tab-group-tab-strip-frame-active-green);--tab-content-color-top:var(--color-tab-search-image-tab-content-top);--tab-content-color-bottom:var(--color-tab-search-image-tab-content-bottom);--active-tab-text-color:var(--color-tab-search-image-tab-text);--inactive-tab-text-color:var(--color-tab-search-image-tab-text)}.image-background-color-1{stop-color:var(--image-background-color-1)}.image-background-color-2{stop-color:var(--image-background_color-2)}.window-frame-stroke{stroke:var(--window_frame_color)}.window-frame-fill{fill:var(--window_frame_color)}.tab-group-1-stroke{stroke:var(--tab-group-1-color)}.tab-group-1-fill{fill:var(--tab-group-1-color)}.tab-group-2-stroke{stroke:var(--tab-group-2-color)}.tab-group-2-fill{fill:var(--tab-group-2-color)}.tab-content-fill{fill:var(--tab-content-color-top)}.tab-content-stop-color-start{stop-color:var(--tab-content-color-top)}.tab-content-stop-color-end{stop-color:var(--tab-content-color-bottom)}.active-tab-text-color{fill:var(--active-tab-text-color)}.inactive-tab-text-color{fill:var(--inactive-tab-text-color)}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$h() {
    return html `<!--_html_template_start_-->
<svg xmlns="http://www.w3.org/2000/svg" width="280" height="103" fill="none">
  <g clip-path="url(#a)">
    <rect width="280" height="103" fill="url(#b)" rx="8"></rect>
    <path class="window-frame-stroke window-frame-fill" stroke-width="2"
        d="M240 104h1V44a5 5 0 0 0-5-5H44a5 5 0 0 0-5 5v60h1z"></path>
    <path class="window-frame-fill"
        d="M40 44a4 4 0 0 1 4-4h192a4 4 0 0 1 4 4v12H40z"></path>
    <path fill="url(#d)"
        d="M40 56a4 4 0 0 1 4-4h192a4 4 0 0 1 4 4v47H40z"></path>
    <path class="tab-content-fill"
        d="M70 45a3 3 0 0 1 3-3h29a3 3 0 0 1 3 3v7H70z"></path>
    <path class="tab-content-fill" fill-rule="evenodd"
        d="M67 52a3 3 0 0 0 3-3v3zm41 0a3 3 0 0 1-3-3v3z"
        clip-rule="evenodd"></path>
    <rect class="tab-group-1-fill" width="13" height="6" x="53" y="42" rx="2">
    </rect>
    <path class="tab-group-1-stroke" stroke-linecap="round" stroke-width="2"
        d="M54 51h13a2 2 0 0 0 2-2v-4a4 4 0 0 1
           4-4h29a4 4 0 0 1 4 4v4a2 2 0 0 0 2 2h31">
    </path>
    <rect class="tab-group-2-fill" width="13" height="6" x="144" y="42" rx="2">
    </rect>
    <path class="tab-group-2-stroke" stroke-linecap="round" stroke-width="2"
        d="M145 51h80"></path>
    <rect class="active-tab-text-color"
        width="31" height="3" x="72" y="44" rx="1.5"></rect>
    <rect class="inactive-tab-text-color"
        width="30" height="3" x="109" y="44" rx="1.5"></rect>
    <rect class="inactive-tab-text-color"
        width="1" height="7" x="141" y="42" rx=".5"></rect>
    <rect class="inactive-tab-text-color"
        width="30" height="3" x="159" y="44" rx="1.5"></rect>
    <rect class="inactive-tab-text-color"
        width="1" height="7" x="191" y="42" rx=".5"></rect>
    <rect class="inactive-tab-text-color"
        width="30" height="3" x="194" y="44" rx="1.5"></rect>
    <rect class="inactive-tab-text-color"
        width="1" height="7" x="226" y="42" rx=".5"></rect>
  </g>
  <defs>
    <linearGradient id="b" x1="9.074" x2="72.077" y1="0" y2="177.007"
        gradientUnits="userSpaceOnUse">
      <stop class="image-background-color-1"></stop>
      <stop offset="1" class="image-background-color-2"></stop>
    </linearGradient>
    <linearGradient id="d" x1="140" x2="140" y1="80" y2="103"
        gradientUnits="userSpaceOnUse">
      <stop class="tab-content-stop-color-start"></stop>
      <stop offset="1" class="tab-content-stop-color-end"></stop>
    </linearGradient>
    <clipPath id="a">
      <rect width="280" height="103" fill="#fff" rx="8"></rect>
    </clipPath>
  </defs>
</svg>
<!--_html_template_end_-->`;
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Themed image for the auto tab groups not started state.
class AutoTabGroupsNotStartedImageElement extends CrLitElement {
    static get is() {
        return 'auto-tab-groups-not-started-image';
    }
    static get styles() {
        return getCss$k();
    }
    render() {
        return getHtml$h.bind(this)();
    }
}
customElements.define(AutoTabGroupsNotStartedImageElement.is, AutoTabGroupsNotStartedImageElement);

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const WebUiListenerMixinLit = (superClass) => {
    class WebUiListenerMixinLit extends superClass {
        /**
         * Holds WebUI listeners that need to be removed when this element is
         * destroyed.
         */
        webUiListeners_ = [];
        /**
         * Adds a WebUI listener and registers it for automatic removal when
         * this element is detached. Note: Do not use this method if you intend
         * to remove this listener manually (use addWebUiListener directly
         * instead).
         *
         * @param eventName The event to listen to.
         * @param callback The callback run when the event is fired.
         */
        addWebUiListener(eventName, callback) {
            this.webUiListeners_.push(addWebUiListener(eventName, callback));
        }
        disconnectedCallback() {
            super.disconnectedCallback();
            while (this.webUiListeners_.length > 0) {
                removeWebUiListener(this.webUiListeners_.pop());
            }
        }
    }
    return WebUiListenerMixinLit;
};

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class TabSearchSyncBrowserProxyImpl {
    getSignInState() {
        return sendWithPromise('GetSignInState');
    }
    static getInstance() {
        return instance$n || (instance$n = new TabSearchSyncBrowserProxyImpl());
    }
    static setInstance(obj) {
        instance$n = obj;
    }
}
let instance$n = null;

let instance$m = null;
function getCss$j() {
    return instance$m || (instance$m = [...[getCss$r()], css `:host{--avatar-size:40px}cr-button{align-self:flex-end;width:fit-content}.account-email{font-size:12px}.account-image{border-radius:var(--avatar-size);height:var(--avatar-size);width:var(--avatar-size)}.account-row{align-items:center;display:flex;gap:10px}.account-text{display:flex;flex-direction:column;gap:4px}.bullet-list{--iron-icon-height:16px;--iron-icon-width:16px;border-spacing:0 4px;font-size:12px;line-height:16px}td:first-child{padding-inline-end:12px}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$g() {
    // clang-format off
    return html `<!--_html_template_start_-->
<div class="auto-tab-groups-container">
  <auto-tab-groups-not-started-image></auto-tab-groups-not-started-image>
  ${this.tabOrganizationUserInstructionEnabled_ ? html `
    <input id="userInstructionInput"
    @input="${this.onUserInstructionInputChange_}">
  ` : ''}
  <div class="auto-tab-groups-text-container">
    <div class="auto-tab-groups-body">
      ${this.getBody_()}
      ${this.showFre ? html `
        <table class="bullet-list">
          <tr>
            <td>
              <cr-icon icon="tab-search:plant" aria-hidden="true"></cr-icon>
            </td>
            <td>$i18n{notStartedBodyFREBullet1}</td>
          </tr>
          <tr>
            <td>
              <cr-icon icon="tab-search:google" aria-hidden="true"></cr-icon>
            </td>
            <td>$i18n{notStartedBodyFREBullet2}</td>
          </tr>
          <tr>
            <td>
              <cr-icon icon="tab-search:frame" aria-hidden="true"></cr-icon>
            </td>
            <td>$i18n{notStartedBodyFREBullet3}</td>
          </tr>
        </table>
        <a class="auto-tab-groups-link"
            role="link"
            tabindex="0"
            @click="${this.onLearnMoreClick_}"
            @keydown="${this.onLearnMoreKeyDown_}">
          $i18n{learnMore}
        </a>
      ` : ''}
    </div>
  </div>
  ${this.tabOrganizationModelStrategyEnabled_ ? html `
    <div class="auto-tab-groups-header">Update model strategy preference</div>
    <cr-radio-group
        selected="${this.modelStrategy}"
        @selected-changed="${this.onModelStrategyChange_}">
      <cr-radio-button
          name="${TabOrganizationModelStrategy.kTopic}"
          label="Topic/Theme"></cr-radio-button>
      <cr-radio-button
          name="${TabOrganizationModelStrategy.kTask}"
          label="Task"></cr-radio-button>
      <cr-radio-button
          name="${TabOrganizationModelStrategy.kDomain}"
          label="Domain/Subdomain"></cr-radio-button>
    </cr-radio-group>
  ` : ''}
  <cr-button class="action-button"
      aria-label="${this.getActionButtonAriaLabel_()}"
      @click="${this.onButtonClick_}">
    ${this.getActionButtonText_()}
  </cr-button>
</div>
<!--_html_template_end_-->`;
    // clang-format on
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const AutoTabGroupsNotStartedElementBase = WebUiListenerMixinLit(CrLitElement);
// Not started state for the auto tab groups UI.
class AutoTabGroupsNotStartedElement extends AutoTabGroupsNotStartedElementBase {
    static get is() {
        return 'auto-tab-groups-not-started';
    }
    static get properties() {
        return {
            showFre: { type: Boolean },
            modelStrategy: { type: Number },
            signedIn_: { type: Boolean },
            tabOrganizationModelStrategyEnabled_: { type: Boolean },
            tabOrganizationUserInstructionEnabled_: { type: Boolean },
        };
    }
    #showFre_accessor_storage = false;
    get showFre() { return this.#showFre_accessor_storage; }
    set showFre(value) { this.#showFre_accessor_storage = value; }
    #modelStrategy_accessor_storage = TabOrganizationModelStrategy.kTopic;
    get modelStrategy() { return this.#modelStrategy_accessor_storage; }
    set modelStrategy(value) { this.#modelStrategy_accessor_storage = value; }
    #tabOrganizationModelStrategyEnabled__accessor_storage = loadTimeData.getBoolean('tabOrganizationModelStrategyEnabled');
    get tabOrganizationModelStrategyEnabled_() { return this.#tabOrganizationModelStrategyEnabled__accessor_storage; }
    set tabOrganizationModelStrategyEnabled_(value) { this.#tabOrganizationModelStrategyEnabled__accessor_storage = value; }
    #tabOrganizationUserInstructionEnabled__accessor_storage = loadTimeData.getBoolean('TabOrganizationUserInstructionEnabled');
    get tabOrganizationUserInstructionEnabled_() { return this.#tabOrganizationUserInstructionEnabled__accessor_storage; }
    set tabOrganizationUserInstructionEnabled_(value) { this.#tabOrganizationUserInstructionEnabled__accessor_storage = value; }
    #signedIn__accessor_storage = false;
    get signedIn_() { return this.#signedIn__accessor_storage; }
    set signedIn_(value) { this.#signedIn__accessor_storage = value; }
    syncBrowserProxy_ = TabSearchSyncBrowserProxyImpl.getInstance();
    static get styles() {
        return getCss$j();
    }
    render() {
        return getHtml$g.bind(this)();
    }
    connectedCallback() {
        super.connectedCallback();
        this.syncBrowserProxy_.getSignInState().then(this.setSignedIn_.bind(this));
        this.addWebUiListener('account-info-changed', this.setSignedIn_.bind(this));
    }
    setSignedIn_(signedIn) {
        this.signedIn_ = signedIn;
    }
    getBody_() {
        if (!this.signedIn_) {
            return loadTimeData.getString('notStartedBodySignedOut');
        }
        else if (this.showFre) {
            return loadTimeData.getString('notStartedBodyFREHeader');
        }
        else {
            return loadTimeData.getString('notStartedBody');
        }
    }
    getActionButtonAriaLabel_() {
        if (!this.signedIn_) {
            return loadTimeData.getString('notStartedButtonSignedOutAriaLabel');
        }
        else if (this.showFre) {
            return loadTimeData.getString('notStartedButtonFREAriaLabel');
        }
        else {
            return loadTimeData.getString('notStartedButtonAriaLabel');
        }
    }
    getActionButtonText_() {
        if (!this.signedIn_) {
            return loadTimeData.getString('notStartedButtonSignedOut');
        }
        else if (this.showFre) {
            return loadTimeData.getString('notStartedButtonFRE');
        }
        else {
            return loadTimeData.getString('notStartedButton');
        }
    }
    onButtonClick_() {
        if (!this.signedIn_) {
            this.fire('sign-in-click');
        }
        else {
            // Start a tab organization
            this.fire('organize-tabs-click');
            chrome.metricsPrivate.recordBoolean('Tab.Organization.AllEntrypoints.Clicked', true);
            chrome.metricsPrivate.recordBoolean('Tab.Organization.TabSearch.Clicked', true);
        }
    }
    onLearnMoreClick_() {
        this.fire('learn-more-click');
    }
    onLearnMoreKeyDown_(event) {
        if (event.key === 'Enter') {
            this.onLearnMoreClick_();
        }
    }
    onModelStrategyChange_(e) {
        const modelStrategy = e.detail.value;
        if (Number(modelStrategy) !== Number(this.modelStrategy)) {
            this.fire('model-strategy-change', { value: modelStrategy });
        }
    }
    onUserInstructionInputChange_(e) {
        const value = e.target.value;
        this.fire('user-instruction-input-change', { value: value });
    }
}
customElements.define(AutoTabGroupsNotStartedElement.is, AutoTabGroupsNotStartedElement);

let instance$l = null;
function getCss$i() {
    return instance$l || (instance$l = [...[], css `.buttons{--cr-feedback-buttons-icon-size_:16px;display:grid;grid-auto-columns:var(--cr-feedback-buttons-icon-size_);grid-auto-rows:var(--cr-feedback-buttons-icon-size_);grid-auto-flow:column;gap:12px;align-items:center;justify-items:center}cr-icon-button{--cr-icon-button-fill-color:currentColor;--cr-icon-button-icon-size:var(--cr-feedback-buttons-icon-size_);--cr-icon-button-size:24px;margin:0}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$f() {
    return html `
<div class="buttons">
  <cr-icon-button id="thumbsUp" iron-icon="${this.getThumbsUpIcon_()}"
      aria-label="${this.thumbsUpLabel_}"
      title="${this.thumbsUpLabel_}"
      aria-pressed="${this.getThumbsUpAriaPressed_()}"
      @click="${this.onThumbsUpClick_}"
      ?disabled="${this.disabled}">
  </cr-icon-button>
  <cr-icon-button id="thumbsDown"
      iron-icon="${this.getThumbsDownIcon_()}"
      aria-label="${this.thumbsDownLabel_}"
      title="${this.thumbsDownLabel_}"
      aria-pressed="${this.getThumbsDownAriaPressed_()}"
      @click="${this.onThumbsDownClick_}"
      ?disabled="${this.disabled}">
  </cr-icon-button>
</div>`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var CrFeedbackOption;
(function (CrFeedbackOption) {
    CrFeedbackOption[CrFeedbackOption["THUMBS_DOWN"] = 0] = "THUMBS_DOWN";
    CrFeedbackOption[CrFeedbackOption["THUMBS_UP"] = 1] = "THUMBS_UP";
    CrFeedbackOption[CrFeedbackOption["UNSPECIFIED"] = 2] = "UNSPECIFIED";
})(CrFeedbackOption || (CrFeedbackOption = {}));
class CrFeedbackButtonsElement extends CrLitElement {
    static get is() {
        return 'cr-feedback-buttons';
    }
    static get styles() {
        return getCss$i();
    }
    render() {
        return getHtml$f.bind(this)();
    }
    static get properties() {
        return {
            selectedOption: { type: Number },
            thumbsDownLabel_: { type: String },
            thumbsUpLabel_: { type: String },
            disabled: { type: Boolean },
        };
    }
    #selectedOption_accessor_storage = CrFeedbackOption.UNSPECIFIED;
    get selectedOption() { return this.#selectedOption_accessor_storage; }
    set selectedOption(value) { this.#selectedOption_accessor_storage = value; }
    #thumbsDownLabel__accessor_storage = loadTimeData.getString('thumbsDown');
    get thumbsDownLabel_() { return this.#thumbsDownLabel__accessor_storage; }
    set thumbsDownLabel_(value) { this.#thumbsDownLabel__accessor_storage = value; }
    #thumbsUpLabel__accessor_storage = loadTimeData.getString('thumbsUp');
    get thumbsUpLabel_() { return this.#thumbsUpLabel__accessor_storage; }
    set thumbsUpLabel_(value) { this.#thumbsUpLabel__accessor_storage = value; }
    #disabled_accessor_storage = false;
    get disabled() { return this.#disabled_accessor_storage; }
    set disabled(value) { this.#disabled_accessor_storage = value; }
    getThumbsDownAriaPressed_() {
        return this.selectedOption === CrFeedbackOption.THUMBS_DOWN;
    }
    getThumbsDownIcon_() {
        return this.selectedOption === CrFeedbackOption.THUMBS_DOWN ?
            'cr:thumbs-down-filled' :
            'cr:thumbs-down';
    }
    getThumbsUpAriaPressed_() {
        return this.selectedOption === CrFeedbackOption.THUMBS_UP;
    }
    getThumbsUpIcon_() {
        return this.selectedOption === CrFeedbackOption.THUMBS_UP ?
            'cr:thumbs-up-filled' :
            'cr:thumbs-up';
    }
    async notifySelectedOptionChanged_() {
        // Wait for the element's DOM to be updated before dispatching
        // selected-option-changed event.
        await this.updateComplete;
        this.fire('selected-option-changed', { value: this.selectedOption });
    }
    onThumbsDownClick_() {
        this.selectedOption = this.selectedOption === CrFeedbackOption.THUMBS_DOWN ?
            CrFeedbackOption.UNSPECIFIED :
            CrFeedbackOption.THUMBS_DOWN;
        this.notifySelectedOptionChanged_();
    }
    onThumbsUpClick_() {
        this.selectedOption = this.selectedOption === CrFeedbackOption.THUMBS_UP ?
            CrFeedbackOption.UNSPECIFIED :
            CrFeedbackOption.THUMBS_UP;
        this.notifySelectedOptionChanged_();
    }
}
customElements.define(CrFeedbackButtonsElement.is, CrFeedbackButtonsElement);

let instance$k = null;
function getCss$h() {
    return instance$k || (instance$k = [...[], css `:host{--cr-input-background-color:var(--color-textfield-filled-background,var(--cr-fallback-color-surface-variant));--cr-input-border-bottom:1px solid var(--color-textfield-filled-underline,var(--cr-fallback-color-outline));--cr-input-border-radius:8px 8px 0 0;--cr-input-color:var(--cr-primary-text-color);--cr-input-error-color:var(--color-textfield-filled-error,var(--cr-fallback-color-error));--cr-input-focus-color:var(--color-textfield-filled-underline-focused,var(--cr-fallback-color-primary));--cr-input-hover-background-color:var(--cr-hover-background-color);--cr-input-label-color:var(--color-textfield-foreground-label,var(--cr-fallback-color-on-surface-subtle));--cr-input-padding-bottom:10px;--cr-input-padding-end:10px;--cr-input-padding-start:10px;--cr-input-padding-top:10px;--cr-input-placeholder-color:var(--color-textfield-foreground-placeholder,var(--cr-fallback-on-surface-subtle));display:block;isolation:isolate;outline:none}:host([readonly]){--cr-input-border-radius:8px 8px}#label{color:var(--cr-input-label-color);font-size:11px;line-height:16px}:host([focused_]:not([readonly]):not([invalid])) #label{color:var(--cr-input-focus-label-color,var(--cr-input-label-color))}#input-container{border-radius:var(--cr-input-border-radius,4px);overflow:hidden;position:relative;width:var(--cr-input-width,100%)}:host([focused_]) #input-container{outline:var(--cr-input-focus-outline,none)}#inner-input-container{background-color:var(--cr-input-background-color);box-sizing:border-box;padding:0}#inner-input-content ::slotted(*){--cr-icon-button-fill-color:var(--color-textfield-foreground-icon,var(--cr-fallback-color-on-surface-subtle));--cr-icon-button-icon-size:16px;--cr-icon-button-size:24px;--cr-icon-button-margin-start:0;--cr-icon-color:var(--color-textfield-foreground-icon,var(--cr-fallback-color-on-surface-subtle))}#inner-input-content ::slotted([slot='inline-prefix']){--cr-icon-button-margin-start:-8px}#inner-input-content ::slotted([slot='inline-suffix']){--cr-icon-button-margin-end:-4px}:host([invalid]) #inner-input-content ::slotted(*){--cr-icon-color:var(--cr-input-error-color);--cr-icon-button-fill-color:var(--cr-input-error-color)}#hover-layer{background-color:var(--cr-input-hover-background-color);display:none;inset:0;pointer-events:none;position:absolute;z-index:0}:host(:not([readonly]):not([disabled])) #input-container:hover #hover-layer{display:block}#input{-webkit-appearance:none;background-color:transparent;border:none;box-sizing:border-box;caret-color:var(--cr-input-focus-color);color:var(--cr-input-color);font-family:inherit;font-size:var(--cr-input-font-size,12px);font-weight:inherit;line-height:16px;min-height:var(--cr-input-min-height,auto);outline:none;padding:0;text-align:inherit;text-overflow:ellipsis;width:100%}#inner-input-content{padding-bottom:var(--cr-input-padding-bottom);padding-inline-end:var(--cr-input-padding-end);padding-inline-start:var(--cr-input-padding-start);padding-top:var(--cr-input-padding-top)}#underline{border-bottom:2px solid var(--cr-input-focus-color);border-radius:var(--cr-input-underline-border-radius,0);bottom:0;box-sizing:border-box;display:var(--cr-input-underline-display);height:var(--cr-input-underline-height,0);left:0;margin:auto;opacity:0;position:absolute;right:0;transition:opacity 120ms ease-out,width 0s linear 180ms;width:0}:host([invalid]) #underline,:host([force-underline]) #underline,:host([focused_]) #underline{opacity:1;transition:opacity 120ms ease-in,width 180ms ease-out;width:100%}#underline-base{display:none}:host([readonly]) #underline{display:none}:host(:not([readonly])) #underline-base{border-bottom:var(--cr-input-border-bottom);bottom:0;display:block;left:0;position:absolute;right:0}:host([disabled]){color:var(--color-textfield-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--cr-input-border-bottom:1px solid currentColor;--cr-input-placeholder-color:currentColor;--cr-input-color:currentColor;--cr-input-background-color:var(--color-textfield-background-disabled,var(--cr-fallback-color-disabled-background))}:host([disabled]) #inner-input-content ::slotted(*){--cr-icon-color:currentColor;--cr-icon-button-fill-color:currentColor}:host(.stroked){--cr-input-background-color:transparent;--cr-input-border:1px solid var(--color-side-panel-textfield-border,var(--cr-fallback-color-neutral-outline));--cr-input-border-bottom:none;--cr-input-border-radius:8px;--cr-input-padding-bottom:9px;--cr-input-padding-end:9px;--cr-input-padding-start:9px;--cr-input-padding-top:9px;--cr-input-underline-display:none;--cr-input-min-height:36px;line-height:16px}:host(.stroked[focused_]){--cr-input-border:2px solid var(--cr-focus-outline-color);--cr-input-padding-bottom:8px;--cr-input-padding-end:8px;--cr-input-padding-start:8px;--cr-input-padding-top:8px}:host(.stroked[invalid]){--cr-input-border:1px solid var(--cr-input-error-color)}:host(.stroked[focused_][invalid]){--cr-input-border:2px solid var(--cr-input-error-color)}`]);
}

let instance$j = null;
function getCss$g() {
    return instance$j || (instance$j = [...[getCss$w(), getCss$h(), getCss$t()], css `:host([disabled]) :-webkit-any(#label,#error,#input-container){opacity:var(--cr-disabled-opacity);pointer-events:none}:host([disabled]) :is(#label,#error,#input-container){opacity:1}:host ::slotted(cr-button[slot=suffix]){margin-inline-start:var(--cr-button-edge-spacing) !important}:host([invalid]) #label{color:var(--cr-input-error-color)}#input{border-bottom:none;letter-spacing:var(--cr-input-letter-spacing)}#input-container{border:var(--cr-input-border,none)}#input::placeholder{color:var(--cr-input-placeholder-color,var(--cr-secondary-text-color));letter-spacing:var(--cr-input-placeholder-letter-spacing)}:host([invalid]) #input{caret-color:var(--cr-input-error-color)}:host([readonly]) #input{opacity:var(--cr-input-readonly-opacity,0.6)}:host([invalid]) #underline{border-color:var(--cr-input-error-color)}#error{color:var(--cr-input-error-color);display:var(--cr-input-error-display,block);font-size:11px;min-height:var(--cr-form-field-label-height);line-height:16px;margin:4px 10px;visibility:hidden;white-space:var(--cr-input-error-white-space);height:auto;overflow:hidden;text-overflow:ellipsis}:host([invalid]) #error{visibility:visible}#row-container,#inner-input-content{align-items:center;display:flex;justify-content:space-between;position:relative}#inner-input-content{gap:4px;height:16px;z-index:1}#input[type='search']::-webkit-search-cancel-button{display:none}:host-context([dir=rtl]) #input[type=url]{text-align:right}#input[type=url]{direction:ltr}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$e() {
    return html `
<div id="label" class="cr-form-field-label" ?hidden="${!this.label}"
    aria-hidden="true">
  ${this.label}
</div>
<div id="row-container" part="row-container">
  <div id="input-container">
    <div id="inner-input-container">
      <div id="hover-layer"></div>
      <div id="inner-input-content">
        <slot name="inline-prefix"></slot>
        <input id="input" ?disabled="${this.disabled}"
            ?autofocus="${this.autofocus}"
            .value="${this.internalValue_}" tabindex="${this.inputTabindex}"
            .type="${this.type}"
            ?readonly="${this.readonly}" maxlength="${this.maxlength}"
            pattern="${this.pattern || nothing}" ?required="${this.required}"
            minlength="${this.minlength}" inputmode="${this.inputmode}"
            aria-description="${this.ariaDescription || nothing}"
            aria-errormessage="${this.getAriaErrorMessage_() || nothing}"
            aria-label="${this.getAriaLabel_()}"
            aria-invalid="${this.getAriaInvalid_()}"
            .max="${this.max || nothing}" .min="${this.min || nothing}"
            @focus="${this.onInputFocus_}"
            @blur="${this.onInputBlur_}" @change="${this.onInputChange_}"
            @input="${this.onInput_}"
            part="input"
            autocomplete="off">
        <slot name="inline-suffix"></slot>
      </div>
    </div>
    <div id="underline-base"></div>
    <div id="underline"></div>
  </div>
  <slot name="suffix"></slot>
</div>
<div id="error" role="${this.getErrorRole_() || nothing}"
    aria-live="assertive">${this.getErrorMessage_()}</div>`;
}

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Input types supported by cr-input.
 */
const SUPPORTED_INPUT_TYPES = new Set([
    'number',
    'password',
    'search',
    'text',
    'url',
]);
class CrInputElement extends CrLitElement {
    static get is() {
        return 'cr-input';
    }
    static get styles() {
        return getCss$g();
    }
    render() {
        return getHtml$e.bind(this)();
    }
    static get properties() {
        return {
            ariaDescription: { type: String },
            ariaLabel: { type: String },
            autofocus: {
                type: Boolean,
                reflect: true,
            },
            autoValidate: { type: Boolean },
            disabled: {
                type: Boolean,
                reflect: true,
            },
            errorMessage: { type: String },
            errorRole_: { type: String },
            /**
             * This is strictly used internally for styling, do not attempt to use
             * this to set focus.
             */
            focused_: {
                type: Boolean,
                reflect: true,
            },
            invalid: {
                type: Boolean,
                notify: true,
                reflect: true,
            },
            max: {
                type: Number,
                reflect: true,
            },
            min: {
                type: Number,
                reflect: true,
            },
            maxlength: {
                type: Number,
                reflect: true,
            },
            minlength: {
                type: Number,
                reflect: true,
            },
            pattern: {
                type: String,
                reflect: true,
            },
            inputmode: { type: String },
            label: { type: String },
            placeholder: { type: String },
            readonly: {
                type: Boolean,
                reflect: true,
            },
            required: {
                type: Boolean,
                reflect: true,
            },
            inputTabindex: { type: Number },
            type: { type: String },
            value: {
                type: String,
                notify: true,
            },
            internalValue_: {
                type: String,
                state: true,
            },
        };
    }
    #ariaDescription_accessor_storage = null;
    get ariaDescription() { return this.#ariaDescription_accessor_storage; }
    set ariaDescription(value) { this.#ariaDescription_accessor_storage = value; }
    #ariaLabel_accessor_storage = '';
    get ariaLabel() { return this.#ariaLabel_accessor_storage; }
    set ariaLabel(value) { this.#ariaLabel_accessor_storage = value; }
    #autofocus_accessor_storage = false;
    get autofocus() { return this.#autofocus_accessor_storage; }
    set autofocus(value) { this.#autofocus_accessor_storage = value; }
    #autoValidate_accessor_storage = false;
    get autoValidate() { return this.#autoValidate_accessor_storage; }
    set autoValidate(value) { this.#autoValidate_accessor_storage = value; }
    #disabled_accessor_storage = false;
    get disabled() { return this.#disabled_accessor_storage; }
    set disabled(value) { this.#disabled_accessor_storage = value; }
    #errorMessage_accessor_storage = '';
    get errorMessage() { return this.#errorMessage_accessor_storage; }
    set errorMessage(value) { this.#errorMessage_accessor_storage = value; }
    #inputmode_accessor_storage;
    get inputmode() { return this.#inputmode_accessor_storage; }
    set inputmode(value) { this.#inputmode_accessor_storage = value; }
    #inputTabindex_accessor_storage = 0;
    get inputTabindex() { return this.#inputTabindex_accessor_storage; }
    set inputTabindex(value) { this.#inputTabindex_accessor_storage = value; }
    #invalid_accessor_storage = false;
    get invalid() { return this.#invalid_accessor_storage; }
    set invalid(value) { this.#invalid_accessor_storage = value; }
    #label_accessor_storage = '';
    get label() { return this.#label_accessor_storage; }
    set label(value) { this.#label_accessor_storage = value; }
    #max_accessor_storage;
    get max() { return this.#max_accessor_storage; }
    set max(value) { this.#max_accessor_storage = value; }
    #min_accessor_storage;
    get min() { return this.#min_accessor_storage; }
    set min(value) { this.#min_accessor_storage = value; }
    #maxlength_accessor_storage;
    get maxlength() { return this.#maxlength_accessor_storage; }
    set maxlength(value) { this.#maxlength_accessor_storage = value; }
    #minlength_accessor_storage;
    get minlength() { return this.#minlength_accessor_storage; }
    set minlength(value) { this.#minlength_accessor_storage = value; }
    #pattern_accessor_storage;
    get pattern() { return this.#pattern_accessor_storage; }
    set pattern(value) { this.#pattern_accessor_storage = value; }
    #placeholder_accessor_storage = null;
    get placeholder() { return this.#placeholder_accessor_storage; }
    set placeholder(value) { this.#placeholder_accessor_storage = value; }
    #readonly_accessor_storage = false;
    get readonly() { return this.#readonly_accessor_storage; }
    set readonly(value) { this.#readonly_accessor_storage = value; }
    #required_accessor_storage = false;
    get required() { return this.#required_accessor_storage; }
    set required(value) { this.#required_accessor_storage = value; }
    #type_accessor_storage = 'text';
    get type() { return this.#type_accessor_storage; }
    set type(value) { this.#type_accessor_storage = value; }
    #value_accessor_storage = '';
    get value() { return this.#value_accessor_storage; }
    set value(value) { this.#value_accessor_storage = value; }
    #internalValue__accessor_storage = '';
    get internalValue_() { return this.#internalValue__accessor_storage; }
    set internalValue_(value) { this.#internalValue__accessor_storage = value; }
    #focused__accessor_storage = false;
    get focused_() { return this.#focused__accessor_storage; }
    set focused_(value) { this.#focused__accessor_storage = value; }
    firstUpdated() {
        // Use inputTabindex instead.
        assert(!this.hasAttribute('tabindex'));
    }
    willUpdate(changedProperties) {
        super.willUpdate(changedProperties);
        if (changedProperties.has('value')) {
            // Don't allow null or undefined as these will render in the input.
            // cr-input cannot use Lit's "nothing" in the HTML template; this breaks
            // the underlying native input's auto validation if |required| is set.
            this.internalValue_ =
                (this.value === undefined || this.value === null) ? '' : this.value;
        }
        if (changedProperties.has('inputTabindex')) {
            // CrInput only supports 0 or -1 values for the input's tabindex to allow
            // having the input in tab order or not. Values greater than 0 will not
            // work as the shadow root encapsulates tabindices.
            assert(this.inputTabindex === 0 || this.inputTabindex === -1);
        }
        if (changedProperties.has('type')) {
            // Check that the 'type' is one of the supported types.
            assert(SUPPORTED_INPUT_TYPES.has(this.type));
        }
    }
    updated(changedProperties) {
        super.updated(changedProperties);
        if (changedProperties.has('value')) {
            const previous = changedProperties.get('value');
            if ((!!this.value || !!previous) && this.autoValidate) {
                this.invalid = !this.inputElement.checkValidity();
            }
        }
        if (changedProperties.has('placeholder')) {
            if (this.placeholder === null || this.placeholder === undefined) {
                this.inputElement.removeAttribute('placeholder');
            }
            else {
                this.inputElement.setAttribute('placeholder', this.placeholder);
            }
        }
    }
    get inputElement() {
        return this.$.input;
    }
    focus() {
        this.focusInput();
    }
    /**
     * Focuses the input element.
     * TODO(crbug.com/40593040): Replace this with focus() after resolving the text
     * selection issue described in onFocus_().
     * @return Whether the <input> element was focused.
     */
    focusInput() {
        if (this.shadowRoot.activeElement === this.inputElement) {
            return false;
        }
        this.inputElement.focus();
        return true;
    }
    /**
     * 'change' event fires when <input> value changes and user presses 'Enter'.
     * This function helps propagate it to host since change events don't
     * propagate across Shadow DOM boundary by default.
     */
    async onInputChange_(e) {
        // Ensure that |value| has been updated before re-firing 'change'.
        await this.updateComplete;
        this.fire('change', { sourceEvent: e });
    }
    onInput_(e) {
        this.internalValue_ = e.target.value;
        this.value = this.internalValue_;
    }
    onInputFocus_() {
        this.focused_ = true;
    }
    onInputBlur_() {
        this.focused_ = false;
    }
    getAriaLabel_() {
        return this.ariaLabel || this.label || this.placeholder;
    }
    getAriaInvalid_() {
        return this.invalid ? 'true' : 'false';
    }
    getErrorMessage_() {
        return this.invalid ? this.errorMessage : '';
    }
    getErrorRole_() {
        // On VoiceOver role="alert" is not consistently announced when its
        // content changes. Adding and removing the |role| attribute every time
        // there is an error, triggers VoiceOver to consistently announce.
        return this.invalid ? 'alert' : '';
    }
    getAriaErrorMessage_() {
        return this.invalid ? 'error' : '';
    }
    /**
     * Selects the text within the input. If no parameters are passed, it will
     * select the entire string. Either no params or both params should be passed.
     * Publicly, this function should be used instead of inputElement.select() or
     * manipulating inputElement.selectionStart/selectionEnd because the order of
     * execution between focus() and select() is sensitive.
     */
    select(start, end) {
        this.inputElement.focus();
        if (start !== undefined && end !== undefined) {
            this.inputElement.setSelectionRange(start, end);
        }
        else {
            // Can't just pass one param.
            assert(start === undefined && end === undefined);
            this.inputElement.select();
        }
    }
    // Note: In order to preserve it as a synchronous API, validate() forces 2
    // rendering updates to cr-input. This allows this function to be used to
    // synchronously determine the validity of a <cr-input>, however, as a result
    // of these 2 forced updates it may result in slower performance. validate()
    // should not be called internally from within cr_input.ts, and should only
    // be called where necessary from clients.
    validate() {
        // Ensure that any changes to |value| have propagated to the native <input>.
        this.performUpdate();
        this.invalid = !this.inputElement.checkValidity();
        // Perform update again to ensure change propagates via 2 way binding to
        // Polymer parent before returning.
        this.performUpdate();
        return !this.invalid;
    }
}
customElements.define(CrInputElement.is, CrInputElement);

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrSelectableMixin = (superClass) => {
    class CrSelectableMixin extends superClass {
        static get properties() {
            return {
                /**
                 * To use an attribute value of an element for determining `selected`
                 * instead of using the index, set this property to the name of the HTML
                 * attribute.
                 */
                attrForSelected: { type: String },
                /**
                 * Gets or sets the selected value. The default is to use the index of
                 * the selected item. If attrForSelected is set, this is instead the
                 * value of the |attrForSelected| attribute of the selected item.
                 */
                selected: {
                    type: String,
                    notify: true,
                },
                /** Boolean attribute name to set on items that are selected. */
                selectedAttribute: { type: String },
                /**
                 * This is a CSS selector string.  If this is set, only items that match
                 * the CSS selector are selectable.
                 */
                selectable: { type: String },
            };
        }
        #attrForSelected_accessor_storage = null;
        get attrForSelected() { return this.#attrForSelected_accessor_storage; }
        set attrForSelected(value) { this.#attrForSelected_accessor_storage = value; }
        #selectable_accessor_storage;
        get selectable() { return this.#selectable_accessor_storage; }
        set selectable(value) { this.#selectable_accessor_storage = value; }
        #selected_accessor_storage;
        get selected() { return this.#selected_accessor_storage; }
        set selected(value) { this.#selected_accessor_storage = value; }
        #selectedAttribute_accessor_storage = null;
        get selectedAttribute() { return this.#selectedAttribute_accessor_storage; }
        set selectedAttribute(value) { this.#selectedAttribute_accessor_storage = value; }
        // Whether to select items when they or their children are clicked. Note:
        // value is only checked in firstUpdated().
        selectOnClick = true;
        items_ = [];
        selectedItem_ = null;
        firstUpdated(changedProperties) {
            super.firstUpdated(changedProperties);
            if (this.selectOnClick) {
                this.addEventListener('click', e => this.onClick_(e));
            }
            this.observeItems();
        }
        // Override this method in client code to modify the observation logic,
        // or to turn it off completely. By default it listens for any changes on
        // the first <slot> node in this shadowRoot.
        observeItems() {
            this.getSlot().addEventListener('slotchange', () => this.itemsChanged());
        }
        connectedCallback() {
            super.connectedCallback();
            this.updateItems_();
        }
        willUpdate(changedProperties) {
            super.willUpdate(changedProperties);
            if (changedProperties.has('attrForSelected')) {
                if (this.selectedItem_) {
                    assert(this.attrForSelected);
                    const value = this.selectedItem_.getAttribute(this.attrForSelected);
                    assert(value !== null);
                    this.selected = value;
                }
            }
        }
        updated(changedProperties) {
            super.updated(changedProperties);
            if (changedProperties.has('selected')) {
                this.updateSelectedItem_();
            }
        }
        /**
         * Selects the given value.
         */
        select(value) {
            this.selected = value;
        }
        /**
         * Selects the previous item.
         */
        selectPrevious() {
            const length = this.items_.length;
            let index = length - 1;
            if (this.selected !== undefined) {
                index = ((this.valueToIndex_(this.selected)) - 1 + length) % length;
            }
            this.selected = this.indexToValue_(index);
        }
        /**
         * Selects the next item.
         */
        selectNext() {
            const index = this.selected === undefined ?
                0 :
                (this.valueToIndex_(this.selected) + 1) % this.items_.length;
            this.selected = this.indexToValue_(index);
        }
        getItemsForTest() {
            return this.items_;
        }
        getSlot() {
            const slot = this.shadowRoot.querySelector('slot');
            assert(slot);
            return slot;
        }
        // Override this method in client code to modify this logic, for example to
        // grab children that don't reside in a <slot>.
        queryItems() {
            const selectable = this.selectable === undefined ? '*' : this.selectable;
            return Array.from(this.querySelectorAll(`:scope > ${selectable}`));
        }
        // If overriding queryItems(), override this method to return the list item
        // element matching the CSS selector string |selector|.
        queryMatchingItem(selector) {
            const selectable = this.selectable || '*';
            return this.querySelector(`:scope > :is(${selectable})${selector}`);
        }
        updateItems_() {
            this.items_ = this.queryItems();
            this.items_.forEach((item, index) => item.setAttribute('data-selection-index', index.toString()));
        }
        get selectedItem() {
            return this.selectedItem_;
        }
        updateSelectedItem_() {
            if (!this.items_) {
                return;
            }
            const item = this.selected == null ?
                null :
                this.items_[this.valueToIndex_(this.selected)];
            if (!!item && this.selectedItem_ !== item) {
                this.setItemSelected_(this.selectedItem_, false);
                this.setItemSelected_(item, true);
            }
            else if (!item) {
                this.setItemSelected_(this.selectedItem_, false);
            }
        }
        setItemSelected_(item, isSelected) {
            if (!item) {
                return;
            }
            item.classList.toggle('selected', isSelected);
            if (this.selectedAttribute) {
                item.toggleAttribute(this.selectedAttribute, isSelected);
            }
            this.selectedItem_ = isSelected ? item : null;
            this.fire('iron-' + (isSelected ? 'select' : 'deselect'), { item: item });
        }
        valueToIndex_(value) {
            if (!this.attrForSelected) {
                return Number(value);
            }
            const match = this.queryMatchingItem(`[${this.attrForSelected}="${value}"]`);
            return match ? Number(match.dataset['selectionIndex']) : -1;
        }
        indexToValue_(index) {
            if (!this.attrForSelected) {
                return index;
            }
            const item = this.items_[index];
            if (!item) {
                return index;
            }
            return item.getAttribute(this.attrForSelected) || index;
        }
        itemsChanged() {
            this.updateItems_();
            this.updateSelectedItem_();
            // Let other interested parties know about the change.
            this.fire('iron-items-changed');
        }
        onClick_(e) {
            let element = e.target;
            while (element && element !== this) {
                const idx = this.items_.indexOf(element);
                if (idx >= 0) {
                    const value = this.indexToValue_(idx);
                    assert(value !== null);
                    this.fire('iron-activate', { item: element, selected: value });
                    this.select(value);
                    return;
                }
                element = element.parentNode;
            }
        }
    }
    return CrSelectableMixin;
};

let instance$i = null;
function getCss$f() {
    return instance$i || (instance$i = [...[], css `:host{display:block}:host(:not([show-all]))>::slotted(:not(slot):not(.selected)){display:none !important}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$d() {
    return html `<slot></slot>`;
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * cr-page-selector is a simple implementation of CrSelectableMixin which by
 * default hides any slotted element that is not currently marked as 'selected',
 * since this is usually leveraged to implement a page selector where only the
 * currently selected page is visible.
 *
 * A 'show-all' attribute is exposed which when set causes all slotted
 * elements (selected and non-selected) to be visible at all times, which makes
 * this element useful for more UI use cases, besides the 'page selector' case.
 */
const CrPageSelectorElementBase = CrSelectableMixin(CrLitElement);
class CrPageSelectorElement extends CrPageSelectorElementBase {
    static get is() {
        return 'cr-page-selector';
    }
    static get styles() {
        return getCss$f();
    }
    static get properties() {
        return {
            // Set this property to true to flatten slot items, i.e. to grab elements
            // from slots in this element's light DOM, instead of only items assigned
            // directly to this element's shadow DOM <slot>. This is done by passing
            // {flatten: true} when querying items assigned to the <slot> and by
            // observing slotchange events that bubble to this element instead of only
            // those fired on the shadow DOM <slot>. Note |selectable| is ignored
            // if hasNestedSlots = true; all assignedElements are assumed to be
            // selectable.
            hasNestedSlots: { type: Boolean },
        };
    }
    render() {
        return getHtml$d.bind(this)();
    }
    #hasNestedSlots_accessor_storage = false;
    get hasNestedSlots() { return this.#hasNestedSlots_accessor_storage; }
    set hasNestedSlots(value) { this.#hasNestedSlots_accessor_storage = value; }
    constructor() {
        super();
        // Overridden from CrSelectableMixin, since selecting pages on click does
        // not make sense (only one page is visible at a time, and this can undo
        // a selection set elsewhere).
        this.selectOnClick = false;
    }
    // CrSelectableMixin override for hasNestedSlots = true mode.
    queryItems() {
        return this.hasNestedSlots ?
            Array.from(this.getSlot().assignedElements({ flatten: true })) :
            super.queryItems();
    }
    // CrSelectableMixin override for hasNestedSlots = true mode.
    queryMatchingItem(selector) {
        if (this.hasNestedSlots) {
            const match = this.queryItems().find(el => el.matches(selector));
            return match ? match : null;
        }
        return super.queryMatchingItem(selector);
    }
    // CrSelectableMixin override for hasNestedSlots = true mode.
    observeItems() {
        if (this.hasNestedSlots) {
            this.addEventListener('slotchange', () => this.itemsChanged());
        }
        super.observeItems();
    }
}
customElements.define(CrPageSelectorElement.is, CrPageSelectorElement);

let instance$h = null;
function getCss$e() {
    return instance$h || (instance$h = [...[getCss$x()], css `.text{color:var(--cr-primary-text-color);font-size:11px;font-weight:500;line-height:9px;text-wrap:nowrap}.divider{background-color:var(--color-tab-search-divider);height:1px;width:100%}.row{align-items:center;display:flex;gap:10px;flex-direction:row;padding:12px var(--mwb-list-item-horizontal-margin)}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$c() {
    return html `
<!--_html_template_start_-->
<div class="row">
  <div class="text">$i18n{newTabs}</div>
  <div class="divider"></div>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// New badge divider for the auto tab groups UI.
class AutoTabGroupsNewBadgeElement extends CrLitElement {
    static get is() {
        return 'auto-tab-groups-new-badge';
    }
    static get styles() {
        return getCss$e();
    }
    render() {
        return getHtml$c.bind(this)();
    }
}
customElements.define(AutoTabGroupsNewBadgeElement.is, AutoTabGroupsNewBadgeElement);

let instance$g = null;
function getCss$d() {
    return instance$g || (instance$g = [...[], css `cr-button{width:fit-content}.button-row{display:flex;gap:16px;justify-content:flex-end}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$b() {
    // clang-format off
    return html `<!--_html_template_start_-->
<div class="button-row">
  ${this.showClear ? html `
    <cr-button id="clearButton" class="tonal-button"
        aria-label="$i18n{clearAriaLabel}"
        @click="${this.onClearClick_}">
      $i18n{clearSuggestions}
    </cr-button>
  ` : ''}
  <cr-button id="createButton" class="action-button"
      @click="${this.onCreateGroupClick_}">
    ${this.getCreateButtonText_()}
  </cr-button>
</div>
<!--_html_template_end_-->`;
    // clang-format on
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'auto-tab-groups-results-actions' is a row with actions that
 * can be taken on an auto tab groups suggestion. It is agnostic as to what
 * that suggestion is, and can be used to suggest one or multiple groups.
 */
class AutoTabGroupsResultsActionsElement extends CrLitElement {
    static get is() {
        return 'auto-tab-groups-results-actions';
    }
    static get properties() {
        return {
            multipleOrganizations: { type: Boolean },
            showClear: { type: Boolean },
        };
    }
    #multipleOrganizations_accessor_storage = false;
    get multipleOrganizations() { return this.#multipleOrganizations_accessor_storage; }
    set multipleOrganizations(value) { this.#multipleOrganizations_accessor_storage = value; }
    #showClear_accessor_storage = false;
    get showClear() { return this.#showClear_accessor_storage; }
    set showClear(value) { this.#showClear_accessor_storage = value; }
    static get styles() {
        return getCss$d();
    }
    render() {
        return getHtml$b.bind(this)();
    }
    getCreateButtonText_() {
        return this.multipleOrganizations ? loadTimeData.getString('createGroups') :
            loadTimeData.getString('createGroup');
    }
    onClearClick_() {
        this.fire('reject-all-groups-click');
    }
    onCreateGroupClick_() {
        this.fire('create-group-click');
    }
}
customElements.define(AutoTabGroupsResultsActionsElement.is, AutoTabGroupsResultsActionsElement);

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Base class for Web Components that don't use Polymer.
 * See the following file for usage:
 * chrome/test/data/webui/js/custom_element_test.js
 */
function emptyHTML() {
    return window.trustedTypes ? window.trustedTypes.emptyHTML : '';
}
class CustomElement extends HTMLElement {
    static get template() {
        return emptyHTML();
    }
    constructor() {
        super();
        this.attachShadow({ mode: 'open' });
        const template = document.createElement('template');
        template.innerHTML =
            this.constructor.template || emptyHTML();
        this.shadowRoot.appendChild(template.content.cloneNode(true));
    }
    $(query) {
        return this.shadowRoot.querySelector(query);
    }
    $all(query) {
        return this.shadowRoot.querySelectorAll(query);
    }
    getRequiredElement(query) {
        const el = this.shadowRoot.querySelector(query);
        assert(el);
        assert(el instanceof HTMLElement);
        return el;
    }
}

function getTemplate() {
    return getTrustedHTML `<!--_html_template_start_--><style>:host{clip:rect(0 0 0 0);height:1px;overflow:hidden;position:fixed;width:1px}</style>

<div id="messages" role="alert" aria-live="polite" aria-relevant="additions">
</div>
<!--_html_template_end_-->`;
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * 150ms seems to be around the minimum time required for screen readers to
 * read out consecutively queued messages.
 */
const TIMEOUT_MS = 150;
/**
 * A map of an HTML element to its corresponding CrA11yAnnouncerElement. There
 * may be multiple CrA11yAnnouncerElements on a page, especially for cases in
 * which the DocumentElement's CrA11yAnnouncerElement becomes hidden or
 * deactivated (eg. when a modal dialog causes the CrA11yAnnouncerElement to
 * become inaccessible).
 */
const instances = new Map();
function getInstance(container = document.body) {
    if (instances.has(container)) {
        return instances.get(container);
    }
    assert(container.isConnected);
    const instance = new CrA11yAnnouncerElement();
    container.appendChild(instance);
    instances.set(container, instance);
    return instance;
}
class CrA11yAnnouncerElement extends CustomElement {
    static get is() {
        return 'cr-a11y-announcer';
    }
    static get template() {
        return getTemplate();
    }
    currentTimeout_ = null;
    messages_ = [];
    disconnectedCallback() {
        if (this.currentTimeout_ !== null) {
            clearTimeout(this.currentTimeout_);
            this.currentTimeout_ = null;
        }
        for (const [parent, instance] of instances) {
            if (instance === this) {
                instances.delete(parent);
                break;
            }
        }
    }
    announce(message, timeout = TIMEOUT_MS) {
        if (this.currentTimeout_ !== null) {
            clearTimeout(this.currentTimeout_);
            this.currentTimeout_ = null;
        }
        this.messages_.push(message);
        this.currentTimeout_ = setTimeout(() => {
            const messagesDiv = this.shadowRoot.querySelector('#messages');
            messagesDiv.innerHTML = window.trustedTypes.emptyHTML;
            // 
            // VoiceOver on Mac does not seem to consistently read out the contents of
            // a static alert element. Toggling the role of alert seems to force VO
            // to consistently read out the messages.
            messagesDiv.removeAttribute('role');
            messagesDiv.setAttribute('role', 'alert');
            // 
            for (const message of this.messages_) {
                const div = document.createElement('div');
                div.textContent = message;
                messagesDiv.appendChild(div);
            }
            // Dispatch a custom event to allow consumers to know when certain alerts
            // have been sent to the screen reader.
            this.dispatchEvent(new CustomEvent('cr-a11y-announcer-messages-sent', { bubbles: true, detail: { messages: this.messages_.slice() } }));
            this.messages_.length = 0;
            this.currentTimeout_ = null;
        }, timeout);
    }
}
customElements.define(CrA11yAnnouncerElement.is, CrA11yAnnouncerElement);

let instance$f = null;
function getCss$c() {
    return instance$f || (instance$f = [...[getCss$x(), getCss$r(), getCss$u()], css `cr-icon-button{--cr-icon-button-active-background-color:transparent;--cr-icon-button-fill-color:var(--mwb-icon-button-fill-color);--cr-icon-button-icon-size:16px;--cr-icon-button-size:24px;margin:0}cr-input{--cr-input-background-color:transparent;--cr-input-border:1px solid var(--color-side-panel-textfield-border);--cr-input-border-bottom:none;--cr-input-border-radius:8px;--cr-input-error-display:none;--cr-input-padding-bottom:9px;--cr-input-padding-top:9px;--cr-input-underline-display:none}cr-input:focus{--cr-input-border:2px solid var(--cr-focus-outline-color);--cr-input-padding-bottom:8px;--cr-input-padding-top:8px}auto-tab-groups-results-actions{display:block;margin:16px 16px 0 16px}tab-search-item{--tab-search-item-icon-margin:8px;--tab-search-favicon-background:var(--color-tab-search-background)}.divider{background-color:var(--cr-separator-color);height:1px;margin:12px 0;width:100%}.group-header-row{align-items:center;display:flex;gap:8px;justify-content:space-between;margin:0 var(--mwb-list-item-horizontal-margin)}.group-name{font-size:13px;line-height:20px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;width:184px}.group-name-row{align-items:center;display:flex;flex:auto;justify-content:space-between}.icon-edit{margin-inline-end:-4px}:host(:not([show-reject])) .icon-edit,#rejectButton{margin-inline-end:var(--cr-icon-ripple-margin)}#multiOrganizationInput{width:100%}cr-page-selector>.mwb-list-item:focus{background-color:var(--mwb-list-item-selected-background-color)}.mwb-list-item{background-color:transparent}.mwb-list-item[size=compact]{height:32px;padding:0 12px 0 var(--mwb-list-item-horizontal-margin)}.group{background-color:var(--color-tab-search-card-background);border-radius:8px;padding:16px 0}#singleOrganizationInput{margin:0 var(--mwb-list-item-horizontal-margin) 16px var(--mwb-list-item-horizontal-margin)}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$a() {
    // clang-format off
    return html `<!--_html_template_start_-->
<div class="group">
  <div class="group-header-row">
    ${this.showInput_ ? html `
      <cr-input id="input" type="text" .value="${this.name}"
          @value-changed="${this.onNameChanged_}"
          aria-label="${this.getInputAriaLabel_()}"
          @focus="${this.onInputFocus_}"
          @blur="${this.onInputBlur_}"
          @keydown="${this.onInputKeyDown_}">
      </cr-input>
    ` : html `
      <div class="group-name-row">
        <div class="auto-tab-groups-header group-name">${this.name}</div>
        <cr-icon-button class="icon-edit"
            aria-label="${this.getEditButtonAriaLabel_()}"
            title="${this.getEditButtonAriaLabel_()}"
            @click="${this.onEditClick_}">
        </cr-icon-button>
      </div>
    `}
    ${this.showReject ? html `
      <cr-icon-button id="rejectButton"
          aria-label="${this.getRejectButtonAriaLabel_()}"
          title="${this.getRejectButtonAriaLabel_()}"
          iron-icon="tab-search:close"
          @click="${this.onRejectGroupClick_}">
      </cr-icon-button>
    ` : ''}
  </div>
  <div class="divider"></div>
  <cr-page-selector id="selector" role="listbox" show-all
      @keydown="${this.onListKeyDown_}"
      selectable="tab-search-item"
      @iron-select="${this.onSelectedChanged_}">
    ${this.tabDatas_.map((item, index) => html `
      ${this.showNewTabSectionHeader_(index) ? html `
        <auto-tab-groups-new-badge></auto-tab-groups-new-badge>
      ` : ''}
      <tab-search-item class="mwb-list-item" .data="${item}"
          role="option"
          size="compact"
          tabindex="${this.getTabIndex_(index)}"
          data-index="${index}"
          @close="${this.onTabRemove_}"
          @focus="${this.onTabFocus_}"
          @blur="${this.onTabBlur_}"
          close-button-icon="tab-search:remove"
          close-button-tooltip="$i18n{tabOrganizationCloseTabTooltip}"
          close-button-aria-label="${this.getCloseButtonAriaLabel_(item)}"
          hide-timestamp>
      </tab-search-item>
    `)}
  </cr-page-selector>
</div>
<!--_html_template_end_-->`;
    // clang-format on
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getEventTargetIndex(e) {
    return Number(e.currentTarget.dataset['index']);
}
class AutoTabGroupsGroupElement extends CrLitElement {
    static get is() {
        return 'auto-tab-groups-group';
    }
    static get properties() {
        return {
            tabs: { type: Array },
            firstNewTabIndex: { type: Number },
            name: { type: String },
            organizationId: { type: Number },
            showReject: {
                type: Boolean,
                reflect: true,
            },
            lastFocusedIndex_: { type: Number },
            showInput_: { type: Boolean },
            tabDatas_: { type: Array },
            changedName_: { type: Boolean },
        };
    }
    #tabs_accessor_storage = [];
    get tabs() { return this.#tabs_accessor_storage; }
    set tabs(value) { this.#tabs_accessor_storage = value; }
    #firstNewTabIndex_accessor_storage = 0;
    get firstNewTabIndex() { return this.#firstNewTabIndex_accessor_storage; }
    set firstNewTabIndex(value) { this.#firstNewTabIndex_accessor_storage = value; }
    #name_accessor_storage = '';
    get name() { return this.#name_accessor_storage; }
    set name(value) { this.#name_accessor_storage = value; }
    #organizationId_accessor_storage = -1;
    get organizationId() { return this.#organizationId_accessor_storage; }
    set organizationId(value) { this.#organizationId_accessor_storage = value; }
    #showReject_accessor_storage = false;
    get showReject() { return this.#showReject_accessor_storage; }
    set showReject(value) { this.#showReject_accessor_storage = value; }
    #lastFocusedIndex__accessor_storage = 0;
    get lastFocusedIndex_() { return this.#lastFocusedIndex__accessor_storage; }
    set lastFocusedIndex_(value) { this.#lastFocusedIndex__accessor_storage = value; }
    #showInput__accessor_storage = false;
    get showInput_() { return this.#showInput__accessor_storage; }
    set showInput_(value) { this.#showInput__accessor_storage = value; }
    #tabDatas__accessor_storage = [];
    get tabDatas_() { return this.#tabDatas__accessor_storage; }
    set tabDatas_(value) { this.#tabDatas__accessor_storage = value; }
    #changedName__accessor_storage = false;
    get changedName_() { return this.#changedName__accessor_storage; }
    set changedName_(value) { this.#changedName__accessor_storage = value; }
    static get styles() {
        return getCss$c();
    }
    render() {
        return getHtml$a.bind(this)();
    }
    connectedCallback() {
        super.connectedCallback();
        this.showInput_ = false;
    }
    willUpdate(changedProperties) {
        super.willUpdate(changedProperties);
        if (changedProperties.has('tabs')) {
            if (this.lastFocusedIndex_ > this.tabs.length - 1) {
                this.lastFocusedIndex_ = 0;
            }
            this.tabDatas_ = this.computeTabDatas_();
        }
    }
    updated(changedProperties) {
        super.updated(changedProperties);
        const changedPrivateProperties = changedProperties;
        if (changedPrivateProperties.has('showInput_')) {
            this.focusInput();
        }
    }
    focusInput() {
        const input = this.getInput_();
        if (input) {
            input.focus();
        }
    }
    getInput_() {
        if (!this.showInput_) {
            return null;
        }
        return this.shadowRoot.querySelector('#input');
    }
    computeTabDatas_() {
        return this.tabs.map(tab => new TabData(tab, TabItemType.OPEN_TAB, new URL(normalizeURL(tab.url.url)).hostname));
    }
    getTabIndex_(index) {
        return index === this.lastFocusedIndex_ ? 0 : -1;
    }
    getInputAriaLabel_() {
        return loadTimeData.getStringF('inputAriaLabel', this.name);
    }
    getEditButtonAriaLabel_() {
        return loadTimeData.getStringF('editAriaLabel', this.name);
    }
    getRejectButtonAriaLabel_() {
        return loadTimeData.getStringF('rejectAriaLabel', this.name);
    }
    showNewTabSectionHeader_(index) {
        return this.firstNewTabIndex > 0 && this.firstNewTabIndex === index;
    }
    onInputFocus_() {
        const input = this.getInput_();
        if (input) {
            input.select();
        }
    }
    onInputBlur_() {
        if (this.getInput_()) {
            this.showInput_ = false;
        }
        this.maybeRenameGroup_();
    }
    maybeRenameGroup_() {
        if (this.changedName_) {
            this.fire('name-change', { organizationId: this.organizationId, name: this.name });
            this.changedName_ = false;
        }
    }
    onInputKeyDown_(event) {
        if (event.key === 'Enter') {
            event.stopPropagation();
            this.showInput_ = false;
        }
    }
    onListKeyDown_(event) {
        const selector = this.$.selector;
        if (selector.selected === undefined) {
            return;
        }
        let handled = false;
        if (event.shiftKey && event.key === 'Tab') {
            // Explicitly focus the element prior to the list in focus order and
            // override the default behavior, which would be to focus the row that
            // the currently focused close button is in.
            this.shadowRoot.querySelector(`#rejectButton`).focus();
            handled = true;
        }
        else if (!event.shiftKey) {
            if (event.key === 'ArrowUp') {
                selector.selectPrevious();
                handled = true;
            }
            else if (event.key === 'ArrowDown') {
                selector.selectNext();
                handled = true;
            }
        }
        if (handled) {
            event.stopPropagation();
            event.preventDefault();
        }
    }
    onSelectedChanged_() {
        if (this.$.selector.selectedItem) {
            const selectedItem = this.$.selector.selectedItem;
            const selectedItemCloseButton = selectedItem.shadowRoot.querySelector(`cr-icon-button`);
            selectedItemCloseButton.focus();
            this.lastFocusedIndex_ =
                Number.parseInt(selectedItem.dataset['index'], 10);
        }
    }
    onTabRemove_(e) {
        const index = getEventTargetIndex(e);
        const tab = this.tabs[index];
        this.fire('remove-tab', { organizationId: this.organizationId, tab });
        getInstance().announce(loadTimeData.getString('a11yTabExcludedFromGroup'));
    }
    onTabFocus_(e) {
        // Ensure that when a TabSearchItemElement receives focus, it becomes the
        // selected item in the list.
        const index = getEventTargetIndex(e);
        this.$.selector.selected = index;
    }
    onTabBlur_(_e) {
        // Ensure the selector deselects its current selection on blur. If
        // selection should move to another element in the list, this will be done
        // in onTabFocus_.
        this.$.selector.select(-1);
    }
    getCloseButtonAriaLabel_(tabData) {
        return loadTimeData.getStringF('tabOrganizationCloseTabAriaLabel', tabData.tab.title);
    }
    onEditClick_() {
        this.showInput_ = true;
    }
    onRejectGroupClick_(event) {
        event.stopPropagation();
        event.preventDefault();
        this.dispatchEvent(new CustomEvent('reject-click', {
            bubbles: true,
            composed: true,
            detail: { organizationId: this.organizationId },
        }));
    }
    onCreateGroupClick_(event) {
        event.stopPropagation();
        event.preventDefault();
        this.dispatchEvent(new CustomEvent('create-group-click', {
            bubbles: true,
            composed: true,
            detail: {
                organizationId: this.organizationId,
                tabs: this.tabs,
            },
        }));
    }
    onNameChanged_(e) {
        if (this.name !== e.detail.value) {
            this.name = e.detail.value;
            this.changedName_ = true;
        }
    }
}
customElements.define(AutoTabGroupsGroupElement.is, AutoTabGroupsGroupElement);

let instance$e = null;
function getCss$b() {
    return instance$e || (instance$e = [...[getCss$x(), getCss$r()], css `cr-feedback-buttons{color:var(--color-icon)}.button-row{display:flex;gap:8px}.feedback{display:flex;flex-direction:column;gap:8px}:host([multi-tab-organization]) .feedback{background-color:var(--color-tab-search-footer-background);margin:calc(var(--mwb-list-item-horizontal-margin) * -1);margin-top:0;padding:var(--mwb-list-item-horizontal-margin)}.results{background-color:var(--color-tab-search-card-background);border-radius:8px}#scrollable{--external-margin:20px;--scrollbar-width:4px;--scroll-border:solid 1px var(--color-tab-search-divider);--non-scroll-border:solid 1px transparent;border-bottom:var(--non-scroll-border);border-top:var(--non-scroll-border);display:flex;flex-direction:column;gap:12px;margin:0 calc(-1 * var(--external-margin));overflow-y:auto;padding:0 calc(var(--external-margin) - var(--scrollbar-width)) 0 var(--external-margin);scrollbar-gutter:stable}#scrollable.can-scroll.is-scrolled{border-top:var(--scroll-border)}#scrollable.can-scroll:not(.scrolled-to-bottom){border-bottom:var(--scroll-border)}.auto-tab-groups-body,.auto-tab-groups-link{display:inline;font-size:11px;line-height:16px}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$9() {
    // clang-format off
    return html `<!--_html_template_start_-->
<div class="auto-tab-groups-container">
  <div id="scrollable">
    ${this.getOrganizations_().map(item => html `
      <auto-tab-groups-group
        name="${this.getName_(item)}"
        .tabs="${item.tabs}"
        first-new-tab-index="${item.firstNewTabIndex}"
        organization-id="${item.organizationId}"
        ?show-reject="${this.hasMultipleOrganizations_()}">
      </auto-tab-groups-group>
    `)}
  </div>
  <auto-tab-groups-results-actions show-clear
      ?multiple-organizations="${this.hasMultipleOrganizations_()}"
      @create-group-click="${this.onCreateAllGroupsClick_}">
  </auto-tab-groups-results-actions>
  <div class="feedback" role="toolbar" @keydown="${this.onFeedbackKeyDown_}">
    <div class="button-row">
      <div class="auto-tab-groups-body">
        $i18n{learnMoreDisclaimer1}
      </div>
      <cr-feedback-buttons id="feedbackButtons"
          tabindex="-1"
          selected-option="${this.feedbackSelectedOption_}"
          @selected-option-changed="${this.onFeedbackSelectedOptionChanged_}">
      </cr-feedback-buttons>
    </div>
    <div class="auto-tab-groups-body">
      $i18n{learnMoreDisclaimer2}
      <div id="learnMore" class="auto-tab-groups-link"
          @click="${this.onLearnMoreClick_}"
          @keydown="${this.onLearnMoreKeyDown_}"
          role="link"
          tabindex="0"
          aria-label="$i18n{learnMoreAriaLabel}">
        $i18n{learnMore}
      </div>
    </div>
  </div>
</div>
<!--_html_template_end_-->`;
    // clang-format on
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const MINIMUM_SCROLLABLE_MAX_HEIGHT$1 = 204;
const NON_SCROLLABLE_VERTICAL_SPACING$1 = 198;
class AutoTabGroupsResultsElement extends CrLitElement {
    static get is() {
        return 'auto-tab-groups-results';
    }
    static get properties() {
        return {
            session: { type: Object },
            availableHeight: { type: Number },
            feedbackSelectedOption_: { type: Number },
        };
    }
    #session_accessor_storage;
    get session() { return this.#session_accessor_storage; }
    set session(value) { this.#session_accessor_storage = value; }
    #availableHeight_accessor_storage = 0;
    get availableHeight() { return this.#availableHeight_accessor_storage; }
    set availableHeight(value) { this.#availableHeight_accessor_storage = value; }
    #feedbackSelectedOption__accessor_storage = CrFeedbackOption.UNSPECIFIED;
    get feedbackSelectedOption_() { return this.#feedbackSelectedOption__accessor_storage; }
    set feedbackSelectedOption_(value) { this.#feedbackSelectedOption__accessor_storage = value; }
    static get styles() {
        return getCss$b();
    }
    render() {
        return getHtml$9.bind(this)();
    }
    willUpdate(changedProperties) {
        super.willUpdate(changedProperties);
        if (changedProperties.has('session')) {
            const changedSession = changedProperties.get('session');
            if (changedSession &&
                (!this.session ||
                    changedSession.sessionId !== this.session.sessionId)) {
                this.feedbackSelectedOption_ = CrFeedbackOption.UNSPECIFIED;
            }
        }
    }
    updated(changedProperties) {
        super.updated(changedProperties);
        if (changedProperties.has('availableHeight')) {
            this.onAvailableHeightChange_();
        }
        if (changedProperties.has('session')) {
            this.updateScroll_();
        }
    }
    firstUpdated() {
        this.$.scrollable.addEventListener('scroll', this.updateScroll_.bind(this));
    }
    focusInput() {
        const group = this.shadowRoot.querySelector('auto-tab-groups-group');
        if (!group) {
            return;
        }
        group.focusInput();
    }
    updateScroll_() {
        const scrollable = this.$.scrollable;
        scrollable.classList.toggle('can-scroll', scrollable.clientHeight < scrollable.scrollHeight);
        scrollable.classList.toggle('is-scrolled', scrollable.scrollTop > 0);
        scrollable.classList.toggle('scrolled-to-bottom', scrollable.scrollTop + this.getMaxScrollableHeight_() >=
            scrollable.scrollHeight);
    }
    getOrganizations_() {
        if (!this.session) {
            return [];
        }
        return this.session.organizations;
    }
    hasMultipleOrganizations_() {
        return this.getOrganizations_().length > 1;
    }
    getName_(organization) {
        return organization.name;
    }
    getMaxScrollableHeight_() {
        return Math.max(MINIMUM_SCROLLABLE_MAX_HEIGHT$1, (this.availableHeight - NON_SCROLLABLE_VERTICAL_SPACING$1));
    }
    onAvailableHeightChange_() {
        const maxHeight = this.getMaxScrollableHeight_();
        this.$.scrollable.style.maxHeight = maxHeight + 'px';
        this.updateScroll_();
    }
    onCreateAllGroupsClick_(event) {
        event.stopPropagation();
        event.preventDefault();
        const groups = [...this.shadowRoot.querySelectorAll('auto-tab-groups-group')];
        const organizations = groups.map((group) => {
            return {
                organizationId: group.organizationId,
                tabs: group.tabs,
            };
        });
        this.fire('create-all-groups-click', { organizations });
    }
    onLearnMoreClick_() {
        this.fire('learn-more-click');
    }
    onLearnMoreKeyDown_(event) {
        if (event.key === 'Enter') {
            this.onLearnMoreClick_();
        }
    }
    onFeedbackKeyDown_(event) {
        if ((event.key !== 'ArrowLeft' && event.key !== 'ArrowRight')) {
            return;
        }
        const feedbackButtons = this.$.feedbackButtons.shadowRoot.querySelectorAll(`cr-icon-button`);
        const focusableElements = [
            this.$.learnMore,
            feedbackButtons[0],
            feedbackButtons[1],
        ];
        const focusableElementCount = focusableElements.length;
        const focusedIndex = focusableElements.findIndex((element) => element.matches(':focus'));
        if (focusedIndex < 0) {
            return;
        }
        let nextFocusedIndex = 0;
        if (event.key === 'ArrowLeft') {
            nextFocusedIndex =
                (focusedIndex + focusableElementCount - 1) % focusableElementCount;
        }
        else if (event.key === 'ArrowRight') {
            nextFocusedIndex = (focusedIndex + 1) % focusableElementCount;
        }
        focusableElements[nextFocusedIndex].focus();
    }
    onFeedbackSelectedOptionChanged_(event) {
        this.feedbackSelectedOption_ = event.detail.value;
        this.fire('feedback', { value: this.feedbackSelectedOption_ });
    }
}
customElements.define(AutoTabGroupsResultsElement.is, AutoTabGroupsResultsElement);

let instance$d = null;
function getCss$a() {
    return instance$d || (instance$d = [...[getCss$r()], css `:host{--standard-curve:cubic-bezier(0.2,0.0,0,1.0)}auto-tab-groups-not-started,auto-tab-groups-in-progress,auto-tab-groups-results,auto-tab-groups-failure{display:flex}:host(.changed-state) auto-tab-groups-not-started[shown],:host(.changed-state) auto-tab-groups-in-progress[shown],:host(.changed-state) auto-tab-groups-results[shown],:host(.changed-state) auto-tab-groups-failure[shown]{animation:fadeIn 100ms linear 100ms forwards,displayIn 200ms linear forwards,slideIn 250ms var(--standard-curve) forwards}auto-tab-groups-not-started:not([shown]),auto-tab-groups-in-progress:not([shown]),auto-tab-groups-results:not([shown]),auto-tab-groups-failure:not([shown]){height:0px;position:absolute;visibility:hidden}:host(.changed-state.from-not-started) auto-tab-groups-not-started:not([shown]),:host(.changed-state.from-in-progress) auto-tab-groups-in-progress:not([shown]),:host(.changed-state.from-success) auto-tab-groups-results:not([shown]),:host(.changed-state.from-failure) auto-tab-groups-failure:not([shown]){animation:fadeOut 100ms linear forwards,displayOut 200ms linear forwards,slideOut 250ms var(--standard-curve) forwards}.auto-tab-groups-header{align-items:center;display:flex;gap:6px;padding-bottom:16px}.back-button{--cr-icon-button-fill-color:var(--color-tab-search-secondary-foreground);--cr-icon-button-icon-size:16px;--cr-icon-button-margin-end:0;--cr-icon-button-margin-start:0;--cr-icon-button-size:20px}#body{margin:var(--mwb-list-item-horizontal-margin)}#contents{overflow:hidden}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$8() {
    return html `<!--_html_template_start_-->
<div id="contents">
  <div id="body">
    <div id="header"
        class="auto-tab-groups-header"
        aria-live="polite"
        aria-relevant="all">
      ${this.showBackButton ? html `
        <cr-icon-button class="back-button"
            aria-label="${this.getBackButtonAriaLabel_()}"
            iron-icon="cr:arrow-back"
            @click="${this.onBackClick_}">
        </cr-icon-button>
      ` :
        ''}
      ${this.getTitle_()}
    </div>
    <auto-tab-groups-not-started id="notStarted"
        ?shown="${this.isState_(TabOrganizationState.kNotStarted)}"
        model-strategy="${this.modelStrategy_}"
        @model-strategy-change="${this.onModelStrategyChange_}"
        @user-instruction-input-change="${this.onUserInstructionInputChange_}"
        @sign-in-click="${this.onSignInClick_}"
        @organize-tabs-click="${this.onOrganizeTabsClick_}"
        @learn-more-click="${this.onLearnMoreClick_}"
        ?show-fre="${this.showFRE_}">
    </auto-tab-groups-not-started>
    <auto-tab-groups-in-progress id="inProgress"
        ?shown="${this.isState_(TabOrganizationState.kInProgress)}">
    </auto-tab-groups-in-progress>
    <auto-tab-groups-results id="results"
        ?shown="${this.isState_(TabOrganizationState.kSuccess)}"
        .session="${this.session_}"
        available-height="${this.availableHeight}"
        @name-change="${this.onNameChange_}"
        @reject-click="${this.onRejectClick_}"
        @reject-all-groups-click="${this.onRejectAllGroupsClick_}"
        @create-group-click="${this.onCreateGroupClick_}"
        @create-all-groups-click="${this.onCreateAllGroupsClick_}"
        @remove-tab="${this.onRemoveTab_}"
        @learn-more-click="${this.onLearnMoreClick_}"
        @feedback="${this.onFeedback_}">
    </auto-tab-groups-results>
    <auto-tab-groups-failure id="failure"
        ?shown="${this.isState_(TabOrganizationState.kFailure)}"
        ?show-fre="${this.showFRE_}"
        .error="${this.getSessionError_()}"
        @check-now="${this.onCheckNow_}"
        @tip-click="${this.onTipClick_}">
    </auto-tab-groups-failure>
  </div>
</div><!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const MIN_LOADING_ANIMATION_MS = 500;
class AutoTabGroupsPageElement extends CrLitElement {
    static get is() {
        return 'auto-tab-groups-page';
    }
    static get properties() {
        return {
            availableHeight: { type: Number },
            showBackButton: { type: Boolean },
            state_: { type: Number },
            session_: { type: Object },
            showFRE_: { type: Boolean },
            modelStrategy_: { type: Number, notify: true },
        };
    }
    #availableHeight_accessor_storage = 0;
    get availableHeight() { return this.#availableHeight_accessor_storage; }
    set availableHeight(value) { this.#availableHeight_accessor_storage = value; }
    #showBackButton_accessor_storage = false;
    get showBackButton() { return this.#showBackButton_accessor_storage; }
    set showBackButton(value) { this.#showBackButton_accessor_storage = value; }
    apiProxy_ = TabSearchApiProxyImpl.getInstance();
    listenerIds_ = [];
    #state__accessor_storage = TabOrganizationState.kInitializing;
    get state_() { return this.#state__accessor_storage; }
    set state_(value) { this.#state__accessor_storage = value; }
    #session__accessor_storage = null;
    get session_() { return this.#session__accessor_storage; }
    set session_(value) { this.#session__accessor_storage = value; }
    #showFRE__accessor_storage = loadTimeData.getBoolean('showTabOrganizationFRE');
    get showFRE_() { return this.#showFRE__accessor_storage; }
    set showFRE_(value) { this.#showFRE__accessor_storage = value; }
    #modelStrategy__accessor_storage = TabOrganizationModelStrategy.kTopic;
    get modelStrategy_() { return this.#modelStrategy__accessor_storage; }
    set modelStrategy_(value) { this.#modelStrategy__accessor_storage = value; }
    documentVisibilityChangedListener_;
    futureState_ = null;
    static get styles() {
        return getCss$a();
    }
    render() {
        return getHtml$8.bind(this)();
    }
    constructor() {
        super();
        this.documentVisibilityChangedListener_ = () => {
            if (document.visibilityState === 'visible') {
                this.onVisible_();
            }
        };
    }
    connectedCallback() {
        super.connectedCallback();
        this.apiProxy_.getTabOrganizationSession().then(({ session }) => this.setSession_(session));
        this.apiProxy_.getTabOrganizationModelStrategy().then(({ strategy }) => this.setModelStrategy_(strategy));
        const callbackRouter = this.apiProxy_.getCallbackRouter();
        this.listenerIds_.push(callbackRouter.tabOrganizationSessionUpdated.addListener(this.setSession_.bind(this)));
        this.listenerIds_.push(callbackRouter.tabOrganizationModelStrategyUpdated.addListener(this.setModelStrategy_.bind(this)));
        this.listenerIds_.push(callbackRouter.showFREChanged.addListener(this.setShowFre_.bind(this)));
        if (document.visibilityState === 'visible') {
            this.onVisible_();
        }
        document.addEventListener('visibilitychange', this.documentVisibilityChangedListener_);
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.listenerIds_.forEach(id => this.apiProxy_.getCallbackRouter().removeListener(id));
        document.removeEventListener('visibilitychange', this.documentVisibilityChangedListener_);
        if (!this.session_ || this.session_.organizations.length === 0) {
            return;
        }
        this.session_.organizations.forEach((organization) => {
            this.apiProxy_.rejectTabOrganization(this.session_.sessionId, organization.organizationId);
        });
    }
    focus() {
        if (this.showBackButton) {
            const backButton = this.shadowRoot.querySelector('cr-icon-button');
            backButton.focus();
        }
        else {
            super.focus();
        }
    }
    onVisible_() {
        // When the UI goes from not shown to shown, bypass any state change
        // animations.
        this.classList.toggle('changed-state', false);
    }
    setShowFre_(show) {
        this.showFRE_ = show;
    }
    setSessionForTesting(session) {
        this.setSession_(session);
    }
    setSession_(session) {
        this.session_ = session;
        this.maybeSetState_(session.state);
    }
    setModelStrategy_(modelStrategy) {
        this.modelStrategy_ = modelStrategy;
    }
    maybeSetState_(state) {
        if (this.futureState_) {
            this.futureState_ = state;
            return;
        }
        this.setState_(state);
    }
    setState_(state) {
        const changedState = this.state_ !== state;
        const wasInitializing = this.state_ === TabOrganizationState.kInitializing;
        this.classList.toggle('changed-state', changedState && !wasInitializing);
        this.classList.toggle('from-not-started', this.state_ === TabOrganizationState.kNotStarted);
        this.classList.toggle('from-in-progress', this.state_ === TabOrganizationState.kInProgress);
        this.classList.toggle('from-success', this.state_ === TabOrganizationState.kSuccess);
        this.classList.toggle('from-failure', this.state_ === TabOrganizationState.kFailure);
        this.state_ = state;
        if (!changedState) {
            return;
        }
        if (state === TabOrganizationState.kInProgress) {
            // Ensure the loading state appears for a sufficient amount of time, so
            // as to not appear jumpy if the request completes quickly.
            this.futureState_ = TabOrganizationState.kInProgress;
            setTimeout(() => this.applyFutureState_(), MIN_LOADING_ANIMATION_MS);
        }
        else if (state === TabOrganizationState.kSuccess) {
            // Wait until the new state is visible after the transition to focus on
            // the new UI.
            this.$.results.addEventListener('animationend', () => {
                this.$.results.focusInput();
            }, { once: true });
        }
        if (wasInitializing) {
            this.apiProxy_.notifyOrganizationUiReadyToShow();
        }
    }
    applyFutureState_() {
        assert(this.futureState_);
        this.setState_(this.futureState_);
        this.futureState_ = null;
    }
    isState_(state) {
        return this.state_ === state;
    }
    onSignInClick_() {
        this.apiProxy_.triggerSignIn();
    }
    onOrganizeTabsClick_() {
        this.apiProxy_.requestTabOrganization();
    }
    onNameChange_(event) {
        this.apiProxy_.renameTabOrganization(this.session_.sessionId, event.detail.organizationId, event.detail.name);
    }
    onRejectClick_(event) {
        this.apiProxy_.rejectTabOrganization(this.session_.sessionId, event.detail.organizationId);
    }
    onRejectAllGroupsClick_() {
        this.apiProxy_.rejectSession(this.session_.sessionId);
    }
    onBackClick_() {
        if (this.session_ && this.state_ !== TabOrganizationState.kNotStarted) {
            this.apiProxy_.rejectSession(this.session_.sessionId);
        }
        else {
            this.fire('back-click');
        }
    }
    onCreateGroupClick_(event) {
        this.apiProxy_.acceptTabOrganization(this.session_.sessionId, event.detail.organizationId, event.detail.tabs);
    }
    onCreateAllGroupsClick_(event) {
        event.detail.organizations.forEach((organization) => {
            this.apiProxy_.acceptTabOrganization(this.session_.sessionId, organization.organizationId, organization.tabs);
        });
    }
    onCheckNow_() {
        this.apiProxy_.restartSession();
    }
    onTipClick_() {
        this.apiProxy_.startTabGroupTutorial();
    }
    onRemoveTab_(event) {
        this.apiProxy_.removeTabFromOrganization(this.session_.sessionId, event.detail.organizationId, event.detail.tab);
    }
    onLearnMoreClick_() {
        this.apiProxy_.openHelpPage();
    }
    onFeedback_(event) {
        if (!this.session_) {
            return;
        }
        switch (event.detail.value) {
            case CrFeedbackOption.UNSPECIFIED:
                this.apiProxy_.setUserFeedback(this.session_.sessionId, UserFeedback.kUserFeedBackUnspecified);
                break;
            case CrFeedbackOption.THUMBS_UP:
                this.apiProxy_.setUserFeedback(this.session_.sessionId, UserFeedback.kUserFeedBackPositive);
                break;
            case CrFeedbackOption.THUMBS_DOWN:
                this.apiProxy_.setUserFeedback(this.session_.sessionId, UserFeedback.kUserFeedBackNegative);
                break;
        }
        if (event.detail.value === CrFeedbackOption.THUMBS_DOWN) {
            // Show feedback dialog
            this.apiProxy_.triggerFeedback(this.session_.sessionId);
        }
    }
    onModelStrategyChange_(event) {
        this.apiProxy_.setTabOrganizationModelStrategy(event.detail.value);
    }
    onUserInstructionInputChange_(event) {
        this.apiProxy_.setTabOrganizationUserInstruction(event.detail.value);
    }
    getSessionError_() {
        return this.session_?.error || TabOrganizationError.kNone;
    }
    getOrganizations_() {
        if (!this.session_) {
            return [];
        }
        return this.session_.organizations;
    }
    missingActiveTab_() {
        if (!this.session_) {
            return false;
        }
        const id = this.session_.activeTabId;
        // Id 0 is a sentinel value that indicates 'no tab'.
        if (id === 0) {
            return false;
        }
        let foundTab = false;
        this.getOrganizations_().forEach(organization => {
            organization.tabs.forEach((tab) => {
                if (tab.tabId === id) {
                    foundTab = true;
                }
            });
        });
        if (foundTab) {
            return false;
        }
        return true;
    }
    getTitle_() {
        switch (this.state_) {
            case TabOrganizationState.kInitializing:
                return '';
            case TabOrganizationState.kNotStarted:
                return loadTimeData.getString(this.showFRE_ ? 'notStartedTitleFRE' : 'notStartedTitle');
            case TabOrganizationState.kInProgress:
                return loadTimeData.getString('inProgressTitle');
            case TabOrganizationState.kSuccess:
                return this.getSuccessTitle_();
            case TabOrganizationState.kFailure:
                return this.getFailureTitle_();
            default:
                assertNotReached('Invalid tab organization state');
        }
    }
    getSuccessTitle_() {
        if (this.missingActiveTab_()) {
            return loadTimeData.getString('successMissingActiveTabTitle');
        }
        else {
            if (this.getOrganizations_().length > 1) {
                return loadTimeData.getStringF('successTitleMulti', this.getOrganizations_().length);
            }
            else {
                return loadTimeData.getString('successTitleSingle');
            }
        }
    }
    getFailureTitle_() {
        switch (this.getSessionError_()) {
            case TabOrganizationError.kGrouping:
                return loadTimeData.getString('failureTitleGrouping');
            case TabOrganizationError.kGeneric:
                return loadTimeData.getString('failureTitleGeneric');
            default:
                return '';
        }
    }
    getBackButtonAriaLabel_() {
        return loadTimeData.getStringF('backButtonAriaLabel', this.getTitle_());
    }
}
customElements.define(AutoTabGroupsPageElement.is, AutoTabGroupsPageElement);

let instance$c = null;
function getCss$9() {
    return instance$c || (instance$c = [...[getCss$x()], css `cr-icon-button{--cr-icon-button-fill-color:var(--color-tab-search-secondary-foreground);--cr-icon-button-icon-size:16px;--cr-icon-button-margin-end:0;--cr-icon-button-margin-start:0;--cr-icon-button-size:20px}tab-search-item{--tab-search-item-icon-margin:16px;--tab-search-favicon-background:var(--color-tab-search-background);align-items:center;display:flex;flex-direction:row}#declutterPage{display:flex;flex-direction:column;gap:16px;padding:20px}#header{display:flex;gap:6px}#scrollable{--external-margin:20px;--scrollbar-width:4px;--scroll-border:solid 1px var(--color-tab-search-divider);--non-scroll-border:solid 1px transparent;border-bottom:var(--non-scroll-border);border-top:var(--non-scroll-border);display:flex;flex-direction:column;gap:12px;margin:0 calc(-1 * var(--external-margin));overflow-y:auto;padding:0 calc(var(--external-margin) - var(--scrollbar-width)) 0 var(--external-margin);scrollbar-gutter:stable}#scrollable.can-scroll.is-scrolled{border-top:var(--scroll-border)}#scrollable.can-scroll:not(.scrolled-to-bottom){border-bottom:var(--scroll-border)}.action-button{align-self:flex-end}:host([dedupe-enabled]) .card{background-color:var(--color-tab-search-card-background);border-radius:8px}.empty-content{display:flex;flex-direction:column;gap:4px}.empty-subheading{color:var(--cr-secondary-text-color);font-size:13px;font-weight:400;line-height:20px}.empty-title{color:var(--cr-secondary-text-color);font-size:13px;font-weight:500;line-height:20px}.header-text{display:flex;flex-direction:column;gap:4px}:host([dedupe-enabled]) .header-text{padding:12px 16px 0 16px;gap:0}.mwb-list-item:focus{background-color:var(--mwb-list-item-selected-background-color)}.mwb-list-item{--mwb-list-item-horizontal-margin:16px;background-color:transparent}:host([dedupe-enabled]) .mwb-list-item{--mwb-item-height:32px}.subheading{color:var(--cr-secondary-text-color);font-size:12px;font-weight:400;line-height:16px}.tab-list{background-color:var(--color-tab-search-card-background);border-radius:8px;display:flex;flex-direction:column;gap:4px;padding:12px 0}.title{color:var(--cr-primary-text-color);font-size:14px;font-weight:500;line-height:20px}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var DeclutterType;
(function (DeclutterType) {
    DeclutterType[DeclutterType["STALE_TABS"] = 0] = "STALE_TABS";
    DeclutterType[DeclutterType["DUPLICATE_TABS"] = 1] = "DUPLICATE_TABS";
})(DeclutterType || (DeclutterType = {}));
function getHtml$7() {
    return html `<!--_html_template_start_-->
  <div id="declutterPage">
    <div id="header">
      ${this.showBackButton ? html `
        <cr-icon-button
            aria-label="${this.getBackButtonAriaLabel_()}"
            iron-icon="cr:arrow-back"
            @click="${this.onBackClick_}">
        </cr-icon-button>
      ` :
        ''}
      ${this.dedupeEnabled ? html `
        <div class="title">$i18n{declutterTitle}</div>
      ` :
        html `
        <div class="header-text">
          <div class="title">$i18n{declutterInactiveTitleNoDedupe}</div>
            ${this.staleTabDatas_.length === 0 ? '' : html `
              <div class="subheading">$i18n{declutterInactiveBody}</div>
            `}
        </div>
      `}
    </div>
    ${(this.staleTabDatas_.length === 0 &&
        this.duplicateTabDatas_.length === 0) ?
        html `
      <div class="empty-content">
        <div class="empty-title">$i18n{declutterEmptyTitle}</div>
        <div class="empty-subheading">${this.dedupeEnabled ?
            html `$i18n{declutterEmptyBody}` :
            html `$i18n{declutterEmptyBodyNoDedupe}`}</div>
      </div>
    ` :
        html `
      <div id="scrollable">
        ${this.staleTabDatas_.length > 0 ?
            html `
          <div class="card">
            ${this.dedupeEnabled ? html `
              <div class="header-text">
                <div class="title">$i18n{declutterInactiveTitle}</div>
                <div class="subheading">$i18n{declutterInactiveBody}</div>
              </div>
            ` :
                ''}
            <div id="staleTabList" class="tab-list">
              ${this.staleTabDatas_.map((item) => getTabSearchItem.bind(this)(item, DeclutterType.STALE_TABS))}
            </div>
          </div>
        ` :
            ''}
        ${this.dedupeEnabled && this.duplicateTabDatas_.length > 0 ?
            html `
          <div class="card">
            <div class="header-text">
              <div class="title">$i18n{declutterDuplicateTitle}</div>
              <div class="subheading">$i18n{declutterDuplicateBody}</div>
            </div>
            <div id="duplicateTabList" class="tab-list">
              ${this.duplicateTabDatas_.map((item) => getTabSearchItem.bind(this)(item, DeclutterType.DUPLICATE_TABS))}
            </div>
          </div>
        ` :
            ''}
      </div>
      <cr-button class="action-button" @click="${this.onCloseTabsClick_}">
        $i18n{closeTabs}
      </cr-button>
    `}
  </div><!--_html_template_end_-->`;
}
function getTabSearchItem(data, declutterType) {
    return html `
    <tab-search-item class="mwb-list-item" .data="${data}"
        close-button-icon="tab-search:remove"
        close-button-aria-label=
                      "${this.getCloseButtonAriaLabel_(data)}"
        close-button-tooltip="${this.getCloseButtonTooltip_()}"
        role="option"
        @keydown="${this.onTabKeyDown_}"
        @close="${declutterType === DeclutterType.STALE_TABS ? this.onStaleTabExclude_ :
        this.onDuplicateTabExclude_}"
        @focus="${this.onTabFocus_}"
        @blur="${this.onTabBlur_}"
        size=${this.dedupeEnabled ? 'compact' : 'medium'}
        hide-url>
    </tab-search-item>
  `;
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const MINIMUM_SCROLLABLE_MAX_HEIGHT = 238;
const NON_SCROLLABLE_VERTICAL_SPACING = 164;
class DeclutterPageElement extends CrLitElement {
    static get is() {
        return 'declutter-page';
    }
    static get properties() {
        return {
            availableHeight: { type: Number },
            showBackButton: { type: Boolean },
            staleTabDatas_: { type: Array },
            duplicateTabDatas_: { type: Array },
            dedupeEnabled: {
                type: Boolean,
                reflect: true,
            },
        };
    }
    #availableHeight_accessor_storage = 0;
    get availableHeight() { return this.#availableHeight_accessor_storage; }
    set availableHeight(value) { this.#availableHeight_accessor_storage = value; }
    #showBackButton_accessor_storage = false;
    get showBackButton() { return this.#showBackButton_accessor_storage; }
    set showBackButton(value) { this.#showBackButton_accessor_storage = value; }
    #dedupeEnabled_accessor_storage = loadTimeData.getBoolean('dedupeEnabled');
    get dedupeEnabled() { return this.#dedupeEnabled_accessor_storage; }
    set dedupeEnabled(value) { this.#dedupeEnabled_accessor_storage = value; }
    #staleTabDatas__accessor_storage = [];
    get staleTabDatas_() { return this.#staleTabDatas__accessor_storage; }
    set staleTabDatas_(value) { this.#staleTabDatas__accessor_storage = value; }
    #duplicateTabDatas__accessor_storage = [];
    get duplicateTabDatas_() { return this.#duplicateTabDatas__accessor_storage; }
    set duplicateTabDatas_(value) { this.#duplicateTabDatas__accessor_storage = value; }
    apiProxy_ = TabSearchApiProxyImpl.getInstance();
    listenerIds_ = [];
    visibilityChangedListener_;
    static get styles() {
        return getCss$9();
    }
    constructor() {
        super();
        this.visibilityChangedListener_ = () => {
            if (document.visibilityState === 'visible') {
                this.apiProxy_.getUnusedTabs().then(({ tabs }) => this.setUnusedTabs_(tabs));
            }
        };
    }
    render() {
        return getHtml$7.bind(this)();
    }
    connectedCallback() {
        super.connectedCallback();
        this.apiProxy_.getUnusedTabs().then(({ tabs }) => this.setUnusedTabs_(tabs));
        const callbackRouter = this.apiProxy_.getCallbackRouter();
        this.listenerIds_.push(callbackRouter.unusedTabsChanged.addListener(this.setUnusedTabs_.bind(this)));
        document.addEventListener('visibilitychange', this.visibilityChangedListener_);
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.listenerIds_.forEach(id => this.apiProxy_.getCallbackRouter().removeListener(id));
        document.removeEventListener('visibilitychange', this.visibilityChangedListener_);
    }
    updated(changedProperties) {
        super.updated(changedProperties);
        const changedPrivateProperties = changedProperties;
        if (changedPrivateProperties.has('availableHeight')) {
            this.onAvailableHeightChange_();
        }
        if (changedPrivateProperties.has('staleTabDatas_')) {
            this.maybeAddScrollListener_();
            this.updateScroll_();
        }
    }
    firstUpdated() {
        this.maybeAddScrollListener_();
    }
    focus() {
        if (this.showBackButton) {
            const backButton = this.shadowRoot.querySelector('cr-icon-button');
            backButton.focus();
        }
        else {
            super.focus();
        }
    }
    logCtrValue(event) {
        chrome.metricsPrivate.recordEnumerationValue('Tab.Organization.DeclutterCTR', event, DeclutterCTREvent.MAX_VALUE + 1);
    }
    getMaxScrollableHeight_() {
        return Math.max(MINIMUM_SCROLLABLE_MAX_HEIGHT, (this.availableHeight - NON_SCROLLABLE_VERTICAL_SPACING));
    }
    onAvailableHeightChange_() {
        const scrollable = this.shadowRoot.querySelector('#scrollable');
        if (scrollable) {
            this.updateScroll_();
        }
    }
    maybeAddScrollListener_() {
        const scrollable = this.shadowRoot.querySelector('#scrollable');
        if (scrollable) {
            scrollable.addEventListener('scroll', this.updateScroll_.bind(this));
        }
    }
    async updateScroll_() {
        await this.updateComplete;
        const scrollable = this.shadowRoot.querySelector('#scrollable');
        if (scrollable) {
            const maxHeight = this.getMaxScrollableHeight_();
            scrollable.style.maxHeight = maxHeight + 'px';
            scrollable.classList.toggle('can-scroll', scrollable.clientHeight < scrollable.scrollHeight);
            scrollable.classList.toggle('is-scrolled', scrollable.scrollTop > 0);
            scrollable.classList.toggle('scrolled-to-bottom', scrollable.scrollTop + maxHeight >= scrollable.scrollHeight);
        }
    }
    getBackButtonAriaLabel_() {
        return loadTimeData.getStringF('backButtonAriaLabel', loadTimeData.getString(this.dedupeEnabled ? 'declutterTitle' :
            'declutterInactiveTitleNoDedupe'));
    }
    getCloseButtonAriaLabel_(tabData) {
        return loadTimeData.getStringF('declutterCloseTabAriaLabel', tabData.tab.title, tabData.tab.lastActiveElapsedText);
    }
    getCloseButtonTooltip_() {
        return loadTimeData.getString('declutterCloseTabTooltip');
    }
    onBackClick_() {
        this.fire('back-click');
    }
    onCloseTabsClick_() {
        const tabIds = this.staleTabDatas_.map((tabData) => tabData.tab.tabId);
        const urls = this.duplicateTabDatas_.map((tabData) => tabData.tab.url);
        this.apiProxy_.declutterTabs(tabIds, urls);
        this.logCtrValue(DeclutterCTREvent.kCloseTabsClicked);
    }
    onTabFocus_(e) {
        if (e.target instanceof TabSearchItemElement) {
            const tabSearchItem = e.target;
            tabSearchItem.classList.toggle('selected', true);
            const closeButton = tabSearchItem.shadowRoot.querySelector('#closeButton');
            closeButton.setAttribute('aria-selected', 'true');
        }
        else {
            throw new Error('Invalid onTabFocus_ target type: ' + typeof e.target);
        }
    }
    onTabBlur_(e) {
        if (e.target instanceof TabSearchItemElement) {
            const tabSearchItem = e.target;
            tabSearchItem.classList.toggle('selected', false);
            const closeButton = tabSearchItem.shadowRoot.querySelector('#closeButton');
            closeButton.setAttribute('aria-selected', 'false');
        }
        else {
            throw new Error('Invalid onTabBlur_ target type: ' + typeof e.target);
        }
    }
    onTabKeyDown_(e) {
        if ((e.key !== 'ArrowUp' && e.key !== 'ArrowDown')) {
            return;
        }
        const tabSearchItems = Array.from(this.shadowRoot.querySelectorAll('tab-search-item'));
        const tabSearchItemCount = tabSearchItems.length;
        const focusedIndex = tabSearchItems.findIndex((element) => element.matches(':focus'));
        if (focusedIndex < 0) {
            return;
        }
        let nextFocusedIndex = 0;
        if (e.key === 'ArrowUp') {
            nextFocusedIndex =
                (focusedIndex + tabSearchItemCount - 1) % tabSearchItemCount;
        }
        else if (e.key === 'ArrowDown') {
            nextFocusedIndex = (focusedIndex + 1) % tabSearchItemCount;
        }
        const selectedItem = tabSearchItems[nextFocusedIndex];
        const focusableElement = selectedItem.shadowRoot.querySelector(`cr-icon-button`);
        focusableElement.focus();
        e.preventDefault();
        e.stopPropagation();
    }
    onStaleTabExclude_(e) {
        const tabData = e.currentTarget.data;
        this.apiProxy_.excludeFromStaleTabs(tabData.tab.tabId);
        this.announceTabExcluded_();
    }
    onDuplicateTabExclude_(e) {
        const tabData = e.currentTarget.data;
        this.apiProxy_.excludeFromDuplicateTabs(tabData.tab.url);
        this.announceTabExcluded_();
    }
    announceTabExcluded_() {
        getInstance().announce(loadTimeData.getString('a11yTabExcludedFromList'));
    }
    setUnusedTabs_(tabs) {
        this.setStaleTabs_(tabs.staleTabs);
        this.setDuplicateTabs_(tabs.duplicateTabs);
    }
    setStaleTabs_(tabs) {
        this.staleTabDatas_ = tabs.map((tab) => this.tabDataFromTab_(tab));
    }
    setDuplicateTabs_(tabs) {
        this.duplicateTabDatas_ = [];
        for (const url in tabs) {
            const urlTabs = tabs[url];
            // `tabs` include all the tabs with the url. The duplicate tab count
            // should be one less than the count of `tabs`.
            const duplicateCount = urlTabs.length - 1;
            if (duplicateCount > 0) {
                const tabData = this.tabDataFromTab_(urlTabs[0]);
                if (duplicateCount === 1) {
                    tabData.tab.title =
                        loadTimeData.getStringF('duplicateItemTitleSingle', url);
                }
                else {
                    tabData.tab.title = loadTimeData.getStringF('duplicateItemTitleMulti', url, duplicateCount);
                }
                this.duplicateTabDatas_.push(tabData);
            }
        }
    }
    tabDataFromTab_(tab) {
        return new TabData(tab, TabItemType.OPEN_TAB, new URL(normalizeURL(tab.url.url)).hostname);
    }
}
customElements.define(DeclutterPageElement.is, DeclutterPageElement);

let instance$b = null;
function getCss$8() {
    return instance$b || (instance$b = [...[], css `:host{--iron-icon-height:16px;--iron-icon-width:16px;--selector-button-inner-radius:4px;--selector-button-outer-radius:12px}:host([disabled]){pointer-events:none}cr-button{background-color:var(--color-tab-search-button-background);border:none;border-radius:var(--selector-button-inner-radius);height:73px}:host([top]) cr-button{border-start-end-radius:var(--selector-button-outer-radius);border-start-start-radius:var(--selector-button-outer-radius)}:host([bottom]) cr-button{border-end-end-radius:var(--selector-button-outer-radius);border-end-start-radius:var(--selector-button-outer-radius)}cr-button:focus-visible{outline-offset:0}#buttonContent{align-items:center;color:var(--color-tab-search-secondary-foreground);display:flex;justify-content:space-between;width:248px}#heading{color:var(--color-tab-search-primary-foreground);font-size:14px;font-weight:500}:host([disabled]) #buttonContent,:host([disabled]) #heading{color:var(--color-tab-search-disabled)}#iconTextRow{align-items:center;display:flex;flex-direction:row;font-size:13px;font-weight:400;gap:12px;line-height:20px}#prefixIcon{--iron-icon-height:20px;--iron-icon-width:20px;align-items:center;background-color:var(--color-tab-search-button-icon-background);color:var(--color-tab-search-button-icon);border-radius:8px;display:flex;height:40px;justify-content:center;width:40px}:host([disabled]) #prefixIcon{color:var(--color-tab-search-disabled)}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$6() {
    // clang-format off
    return html `
<!--_html_template_start_-->
<cr-button id="button" ?disabled="${this.disabled}"
    aria-label="${this.getAriaLabel_()}">
  <div id="buttonContent">
    <div id="iconTextRow">
      <div id="prefixIcon">
        <cr-icon icon="${this.icon}"></cr-icon>
      </div>
      <div id="textColumn">
        <div id="heading">${this.heading}</div>
        <div>${this.subheading}</div>
      </div>
    </div>
    ${this.disabled ? '' : html `<cr-icon icon="cr:chevron-right"></cr-icon>`}
  </div>
</cr-button>
<!--_html_template_end_-->`;
    // clang-format on
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class TabOrganizationSelectorButtonElement extends CrLitElement {
    static get is() {
        return 'tab-organization-selector-button';
    }
    static get styles() {
        return getCss$8();
    }
    render() {
        return getHtml$6.bind(this)();
    }
    static get properties() {
        return {
            bottom: { type: Boolean, reflect: true },
            disabled: { type: Boolean, reflect: true },
            heading: { type: String },
            icon: { type: String },
            subheading: { type: String },
            top: { type: Boolean, reflect: true },
        };
    }
    #bottom_accessor_storage = false;
    get bottom() { return this.#bottom_accessor_storage; }
    set bottom(value) { this.#bottom_accessor_storage = value; }
    #disabled_accessor_storage = false;
    get disabled() { return this.#disabled_accessor_storage; }
    set disabled(value) { this.#disabled_accessor_storage = value; }
    #heading_accessor_storage = '';
    get heading() { return this.#heading_accessor_storage; }
    set heading(value) { this.#heading_accessor_storage = value; }
    #icon_accessor_storage = 'cr:error';
    get icon() { return this.#icon_accessor_storage; }
    set icon(value) { this.#icon_accessor_storage = value; }
    #subheading_accessor_storage = '';
    get subheading() { return this.#subheading_accessor_storage; }
    set subheading(value) { this.#subheading_accessor_storage = value; }
    #top_accessor_storage = false;
    get top() { return this.#top_accessor_storage; }
    set top(value) { this.#top_accessor_storage = value; }
    focus() {
        this.$.button.focus();
    }
    getAriaLabel_() {
        return loadTimeData.getStringF('selectorAriaLabel', this.heading, this.subheading);
    }
}
customElements.define(TabOrganizationSelectorButtonElement.is, TabOrganizationSelectorButtonElement);

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview A helper object used to get a pluralized string.
 */
// clang-format off
class PluralStringProxyImpl {
    getPluralString(messageName, itemCount) {
        return sendWithPromise('getPluralString', messageName, itemCount);
    }
    getPluralStringTupleWithComma(messageName1, itemCount1, messageName2, itemCount2) {
        return sendWithPromise('getPluralStringTupleWithComma', messageName1, itemCount1, messageName2, itemCount2);
    }
    getPluralStringTupleWithPeriods(messageName1, itemCount1, messageName2, itemCount2) {
        return sendWithPromise('getPluralStringTupleWithPeriods', messageName1, itemCount1, messageName2, itemCount2);
    }
    static getInstance() {
        return instance$a || (instance$a = new PluralStringProxyImpl());
    }
    static setInstance(obj) {
        instance$a = obj;
    }
}
let instance$a = null;

let instance$9 = null;
function getCss$7() {
    return instance$9 || (instance$9 = [...[], css `#buttonContainer{display:flex;flex-direction:column;gap:2px;margin:20px}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$5() {
    // clang-format off
    return html `
<!--_html_template_start_-->
<div ?hidden=${this.getVisibleFeature_() !== TabOrganizationFeature.kSelector}>
  <div id="buttonContainer">
    <tab-organization-selector-button id="autoTabGroupsButton"
        top
        heading="$i18n{autoTabGroupsSelectorHeading}"
        subheading="$i18n{autoTabGroupsSelectorSubheading}"
        icon="tab-search:auto-tab-groups"
        @click="${this.onAutoTabGroupsClick_}">
    </tab-organization-selector-button>
    <tab-organization-selector-button id="declutterButton"
        bottom
        heading="${this.declutterHeading_}"
        subheading="$i18n{declutterSelectorSubheading}"
        icon="tab-search:declutter"
        ?disabled="${this.disableDeclutter_}"
        @click="${this.onDeclutterClick_}">
    </tab-organization-selector-button>
  </div>
</div>

<div ?hidden=${this.getVisibleFeature_() !== TabOrganizationFeature.kAutoTabGroups}>
  <auto-tab-groups-page id="autoTabGroupsPage" show-back-button
      available-height="${this.availableHeight}"
      @back-click="${this.onBackClick_}">
  </auto-tab-groups-page>
</div>

<div ?hidden=${this.getVisibleFeature_() !== TabOrganizationFeature.kDeclutter}>
  <declutter-page id="declutterPage" show-back-button
      available-height="${this.availableHeight}"
      @back-click="${this.onBackClick_}">
  </declutter-page>
</div>
<!--_html_template_end_-->`;
    // clang-format on
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class TabOrganizationSelectorElement extends CrLitElement {
    static get is() {
        return 'tab-organization-selector';
    }
    static get styles() {
        return getCss$7();
    }
    render() {
        return getHtml$5.bind(this)();
    }
    static get properties() {
        return {
            availableHeight: { type: Number },
            declutterHeading_: { type: String },
            disableDeclutter_: { type: Boolean },
            selectedState_: { type: Number },
            prevSelectedState_: { type: Number },
            dedupeEnabled_: { type: Boolean },
        };
    }
    #availableHeight_accessor_storage = 0;
    get availableHeight() { return this.#availableHeight_accessor_storage; }
    set availableHeight(value) { this.#availableHeight_accessor_storage = value; }
    #selectedState__accessor_storage = TabOrganizationFeature.kSelector;
    get selectedState_() { return this.#selectedState__accessor_storage; }
    set selectedState_(value) { this.#selectedState__accessor_storage = value; }
    #prevSelectedState__accessor_storage = TabOrganizationFeature.kSelector;
    get prevSelectedState_() { return this.#prevSelectedState__accessor_storage; }
    set prevSelectedState_(value) { this.#prevSelectedState__accessor_storage = value; }
    #declutterHeading__accessor_storage = '';
    get declutterHeading_() { return this.#declutterHeading__accessor_storage; }
    set declutterHeading_(value) { this.#declutterHeading__accessor_storage = value; }
    #disableDeclutter__accessor_storage = false;
    get disableDeclutter_() { return this.#disableDeclutter__accessor_storage; }
    set disableDeclutter_(value) { this.#disableDeclutter__accessor_storage = value; }
    apiProxy_ = TabSearchApiProxyImpl.getInstance();
    listenerIds_ = [];
    visibilityChangedListener_;
    #dedupeEnabled__accessor_storage = loadTimeData.getBoolean('dedupeEnabled');
    get dedupeEnabled_() { return this.#dedupeEnabled__accessor_storage; }
    set dedupeEnabled_(value) { this.#dedupeEnabled__accessor_storage = value; }
    constructor() {
        super();
        this.visibilityChangedListener_ = () => {
            if (document.visibilityState === 'visible') {
                this.apiProxy_.getUnusedTabs().then(({ tabs }) => this.updateDeclutterTabs_(tabs));
            }
        };
    }
    connectedCallback() {
        super.connectedCallback();
        this.apiProxy_.getUnusedTabs().then(({ tabs }) => this.updateDeclutterTabs_(tabs));
        this.apiProxy_.getTabOrganizationFeature().then(({ feature }) => this.updateSelectedFeature_(feature));
        const callbackRouter = this.apiProxy_.getCallbackRouter();
        this.listenerIds_.push(callbackRouter.unusedTabsChanged.addListener(this.updateDeclutterTabs_.bind(this)));
        this.listenerIds_.push(callbackRouter.tabOrganizationFeatureChanged.addListener(this.updateSelectedFeature_.bind(this)));
        document.addEventListener('visibilitychange', this.visibilityChangedListener_);
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.listenerIds_.forEach(id => this.apiProxy_.getCallbackRouter().removeListener(id));
        document.removeEventListener('visibilitychange', this.visibilityChangedListener_);
    }
    updated(changedProperties) {
        super.updated(changedProperties);
        const changedPrivateProperties = changedProperties;
        if (changedPrivateProperties.has('selectedState_') &&
            this.prevSelectedState_ !== this.selectedState_) {
            switch (this.selectedState_) {
                case TabOrganizationFeature.kAutoTabGroups:
                    this.$.autoTabGroupsPage.focus();
                    break;
                case TabOrganizationFeature.kDeclutter:
                    this.$.declutterPage.focus();
                    break;
                case TabOrganizationFeature.kSelector:
                    if (this.prevSelectedState_ ===
                        TabOrganizationFeature.kAutoTabGroups ||
                        this.disableDeclutter_) {
                        this.$.autoTabGroupsButton.focus();
                    }
                    else {
                        this.$.declutterButton.focus();
                    }
                    break;
            }
        }
        else if (changedPrivateProperties.has('disableDeclutter_') &&
            this.selectedState_ === TabOrganizationFeature.kDeclutter &&
            this.disableDeclutter_) {
            this.$.autoTabGroupsButton.focus();
        }
    }
    maybeLogFeatureShow() {
        if (this.selectedState_ === TabOrganizationFeature.kSelector) {
            this.logSelectorCtrValue_(SelectorCTREvent.kSelectorShown);
        }
        else if (this.selectedState_ === TabOrganizationFeature.kDeclutter) {
            this.$.declutterPage.logCtrValue(DeclutterCTREvent.kDeclutterShown);
        }
    }
    getVisibleFeature_() {
        if (this.selectedState_ === TabOrganizationFeature.kDeclutter &&
            this.disableDeclutter_) {
            return TabOrganizationFeature.kSelector;
        }
        return this.selectedState_;
    }
    onAutoTabGroupsClick_() {
        this.logSelectorCtrValue_(SelectorCTREvent.kAutoTabGroupsClicked);
        this.apiProxy_.requestTabOrganization();
        this.selectedState_ = TabOrganizationFeature.kAutoTabGroups;
        this.apiProxy_.setOrganizationFeature(this.selectedState_);
        this.$.autoTabGroupsPage.classList.toggle('changed-state', false);
    }
    onDeclutterClick_() {
        this.logSelectorCtrValue_(SelectorCTREvent.kDeclutterClicked);
        chrome.metricsPrivate.recordEnumerationValue('Tab.Organization.Declutter.EntryPoint', TabDeclutterEntryPoint.kSelector, TabDeclutterEntryPoint.MAX_VALUE + 1);
        this.$.declutterPage.logCtrValue(DeclutterCTREvent.kDeclutterShown);
        this.selectedState_ = TabOrganizationFeature.kDeclutter;
        this.apiProxy_.setOrganizationFeature(this.selectedState_);
    }
    onBackClick_() {
        this.logSelectorCtrValue_(SelectorCTREvent.kSelectorShown);
        this.prevSelectedState_ = this.selectedState_;
        this.selectedState_ = TabOrganizationFeature.kSelector;
        this.apiProxy_.setOrganizationFeature(this.selectedState_);
    }
    async updateDeclutterTabs_(tabs) {
        let declutterTabCount = tabs.staleTabs.length;
        for (const url in tabs.duplicateTabs) {
            declutterTabCount += tabs.duplicateTabs[url].length;
        }
        this.disableDeclutter_ = declutterTabCount === 0;
        this.declutterHeading_ =
            await PluralStringProxyImpl.getInstance().getPluralString(this.dedupeEnabled_ ? 'declutterSelectorHeading' :
                'declutterSelectorHeadingNoDedupe', declutterTabCount);
    }
    updateSelectedFeature_(feature) {
        if (feature === TabOrganizationFeature.kNone) {
            return;
        }
        this.selectedState_ = feature;
    }
    logSelectorCtrValue_(event) {
        chrome.metricsPrivate.recordEnumerationValue('Tab.Organization.SelectorCTR', event, SelectorCTREvent.MAX_VALUE + 1);
    }
}
customElements.define(TabOrganizationSelectorElement.is, TabOrganizationSelectorElement);

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
let hideInk = false;
document.addEventListener('pointerdown', function () {
    hideInk = true;
}, true);
document.addEventListener('keydown', function () {
    hideInk = false;
}, true);
/**
 * Attempts to track whether focus outlines should be shown, and if they
 * shouldn't, removes the "ink" (ripple) from a control while focusing it.
 * This is helpful when a user is clicking/touching, because it's not super
 * helpful to show focus ripples in that case. This is Polymer-specific.
 */
function focusWithoutInk(toFocus) {
    // |toFocus| does not have a 'noink' property, so it's unclear whether the
    // element has "ink" and/or whether it can be suppressed. Just focus().
    if (!('noink' in toFocus) || !hideInk) {
        toFocus.focus();
        return;
    }
    const toFocusWithNoInk = toFocus;
    // Make sure the element is in the document we're listening to events on.
    assert(document === toFocusWithNoInk.ownerDocument);
    const { noink } = toFocusWithNoInk;
    toFocusWithNoInk.noink = true;
    toFocusWithNoInk.focus();
    toFocusWithNoInk.noink = noink;
}

let instance$8 = null;
function getCss$6() {
    return instance$8 || (instance$8 = [...[], css `:host{align-items:center;align-self:stretch;display:flex;margin:0;outline:none}:host(:not([effectively-disabled_])){cursor:pointer}:host(:not([no-hover],[effectively-disabled_]):hover){background-color:var(--cr-hover-background-color)}:host(:not([no-hover],[effectively-disabled_]):active){background-color:var(--cr-active-background-color)}:host(:not([no-hover],[effectively-disabled_])) cr-icon-button{--cr-icon-button-hover-background-color:transparent;--cr-icon-button-active-background-color:transparent}`]);
}

let instance$7 = null;
function getCss$5() {
    return instance$7 || (instance$7 = [...[getCss$6()], css `:host([disabled]){opacity:0.65;pointer-events:none}:host([disabled]) cr-icon-button{display:var(--cr-expand-button-disabled-display,initial)}#label{flex:1;padding:var(--cr-section-vertical-padding) 0}cr-icon-button{--cr-icon-button-icon-size:var(--cr-expand-button-icon-size,20px);--cr-icon-button-size:var(--cr-expand-button-size,36px)}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$4() {
    return html `
<div id="label" aria-hidden="true"><slot></slot></div>
<cr-icon-button id="icon" aria-labelledby="label" ?disabled="${this.disabled}"
    aria-expanded="${this.getAriaExpanded_()}"
    tabindex="${this.tabIndex}" part="icon" iron-icon="${this.getIcon_()}">
</cr-icon-button>`;
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'cr-expand-button' is a chrome-specific wrapper around a button that toggles
 * between an opened (expanded) and closed state.
 */
class CrExpandButtonElement extends CrLitElement {
    static get is() {
        return 'cr-expand-button';
    }
    static get styles() {
        return getCss$5();
    }
    render() {
        return getHtml$4.bind(this)();
    }
    static get properties() {
        return {
            /**
             * If true, the button is in the expanded state and will show the icon
             * specified in the `collapseIcon` property. If false, the button shows
             * the icon specified in the `expandIcon` property.
             */
            expanded: {
                type: Boolean,
                notify: true,
            },
            /**
             * If true, the button will be disabled and grayed out.
             */
            disabled: {
                type: Boolean,
                reflect: true,
            },
            /** A11y text descriptor for this control. */
            ariaLabel: { type: String },
            tabIndex: { type: Number },
            expandIcon: { type: String },
            collapseIcon: { type: String },
            expandTitle: { type: String },
            collapseTitle: { type: String },
        };
    }
    #expanded_accessor_storage = false;
    get expanded() { return this.#expanded_accessor_storage; }
    set expanded(value) { this.#expanded_accessor_storage = value; }
    #disabled_accessor_storage = false;
    get disabled() { return this.#disabled_accessor_storage; }
    set disabled(value) { this.#disabled_accessor_storage = value; }
    #expandIcon_accessor_storage = 'cr:expand-more';
    get expandIcon() { return this.#expandIcon_accessor_storage; }
    set expandIcon(value) { this.#expandIcon_accessor_storage = value; }
    #collapseIcon_accessor_storage = 'cr:expand-less';
    get collapseIcon() { return this.#collapseIcon_accessor_storage; }
    set collapseIcon(value) { this.#collapseIcon_accessor_storage = value; }
    #expandTitle_accessor_storage;
    get expandTitle() { return this.#expandTitle_accessor_storage; }
    set expandTitle(value) { this.#expandTitle_accessor_storage = value; }
    #collapseTitle_accessor_storage;
    get collapseTitle() { return this.#collapseTitle_accessor_storage; }
    set collapseTitle(value) { this.#collapseTitle_accessor_storage = value; }
    #tabIndex_accessor_storage = 0;
    get tabIndex() { return this.#tabIndex_accessor_storage; }
    set tabIndex(value) { this.#tabIndex_accessor_storage = value; }
    firstUpdated() {
        this.addEventListener('click', this.toggleExpand_);
    }
    willUpdate(changedProperties) {
        super.willUpdate(changedProperties);
        if (changedProperties.has('expanded') ||
            changedProperties.has('collapseTitle') ||
            changedProperties.has('expandTitle')) {
            this.title =
                (this.expanded ? this.collapseTitle : this.expandTitle) || '';
        }
    }
    updated(changedProperties) {
        super.updated(changedProperties);
        if (changedProperties.has('ariaLabel')) {
            this.onAriaLabelChange_();
        }
    }
    focus() {
        this.$.icon.focus();
    }
    getIcon_() {
        return this.expanded ? this.collapseIcon : this.expandIcon;
    }
    getAriaExpanded_() {
        return this.expanded ? 'true' : 'false';
    }
    onAriaLabelChange_() {
        if (this.ariaLabel) {
            this.$.icon.removeAttribute('aria-labelledby');
            this.$.icon.setAttribute('aria-label', this.ariaLabel);
        }
        else {
            this.$.icon.removeAttribute('aria-label');
            this.$.icon.setAttribute('aria-labelledby', 'label');
        }
    }
    toggleExpand_(event) {
        // Prevent |click| event from bubbling. It can cause parents of this
        // elements to erroneously re-toggle this control.
        event.stopPropagation();
        event.preventDefault();
        this.scrollIntoViewIfNeeded();
        this.expanded = !this.expanded;
        focusWithoutInk(this.$.icon);
    }
}
customElements.define(CrExpandButtonElement.is, CrExpandButtonElement);

let instance$6 = null;
function getCss$4() {
    return instance$6 || (instance$6 = [...[], css `:host(:focus){outline:none}#icon{flex-shrink:0;height:var(--mwb-icon-size);width:var(--mwb-icon-size)}#primaryText,#secondaryText{overflow:hidden;text-overflow:ellipsis;white-space:nowrap}#primaryText{color:var(--cr-primary-text-color);font-size:var(--mwb-primary-text-font-size);font-weight:var(--mwb-primary-text-font-weight);margin-bottom:3px}#secondaryTextContainer{align-items:center;color:var(--cr-secondary-text-color);display:flex;font-size:var(--mwb-secondary-text-font-size);font-weight:var(--mwb-secondary-text-font-weight)}#textAriaLabel{clip:rect(0,0,0,0);display:inline-block;position:fixed}#groupSvg{flex-shrink:0;height:8px;margin-inline-end:6px;width:8px}#groupDot{fill:var(--group-dot-color)}.text-container{flex-grow:1;overflow:hidden;user-select:none}.search-highlight-hit{--search-highlight-hit-background-color:none;--search-highlight-hit-color:none;font-weight:bold}.separator{margin-inline-end:4px;margin-inline-start:4px}#iconContainer{align-items:center;background:var(--color-list-item-url-favicon-background);border-radius:8px;display:flex;flex-shrink:0;height:40px;justify-content:center;overflow:hidden;margin-inline-end:16px;width:40px}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$3() {
    // clang-format off
    return html `<!--_html_template_start_-->
<div id="iconContainer">
  <!-- TODO(romanarora): Replace with a 16x16 SVG. -->
  <svg id="icon" width="32" height="32" viewBox="0 0 32 32" fill="none"
      xmlns="http://www.w3.org/2000/svg">
    <mask id="mask0" mask-type="alpha" maskUnits="userSpaceOnUse" x="2" y="4"
        width="28" height="24">
      <path fill-rule="evenodd" clip-rule="evenodd"
          d="M6 5C6 4.44772 6.44772 4 7 4H29C29.5523 4 30 4.44772 30 5V23C30 23.5523 29.5523 24 29 24H7C6.44772 24 6 23.5523 6 23V5ZM7.99992 22V6.33335H17.9999V12H27.9999V22H7.99992ZM2 9C2 8.44772 2.44772 8 3 8H4V26H26V27C26 27.5523 25.5523 28 25 28H3C2.44772 28 2 27.5523 2 27V9Z"
          fill="#616161">
    </mask>
    <g mask="url(#mask0)">
      <rect width="32" height="32" fill="#5F6368">
    </g>
  </svg>
</div>
<div class="text-container" aria-hidden="true">
  <div id="primaryText" title="${this.data.tabGroup.title}"></div>
  <div id="secondaryTextContainer">
    <svg id="groupSvg" viewBox="-5 -5 10 10" xmlns="http://www.w3.org/2000/svg">
      <circle id= "groupDot" cx="0" cy="0" r="4">
    </svg>
    <div id="secondaryText">${this.tabCountText_()}</div>
    <div class="separator">•</div>
    <div id="timestamp">${this.data.tabGroup.lastActiveElapsedText}</div>
  </div>
</div>
<!--_html_template_end_-->`;
    // clang-format on
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const TabSearchGroupItemBase = MouseHoverableMixinLit(CrLitElement);
class TabSearchGroupItemElement extends TabSearchGroupItemBase {
    static get is() {
        return 'tab-search-group-item';
    }
    static get styles() {
        return getCss$4();
    }
    render() {
        return getHtml$3.bind(this)();
    }
    static get properties() {
        return {
            data: { type: Object },
        };
    }
    #data_accessor_storage = new TabGroupData({
        sessionId: -1,
        id: { high: 0n, low: 0n },
        color: Color.kGrey,
        title: '',
        tabCount: 1,
        lastActiveTime: { internalValue: 0n },
        lastActiveElapsedText: '',
    });
    get data() { return this.#data_accessor_storage; }
    set data(value) { this.#data_accessor_storage = value; }
    willUpdate(changedProperties) {
        super.willUpdate(changedProperties);
        if (changedProperties.has('data')) {
            this.style.setProperty('--group-dot-color', `var(--tab-group-color-${colorName(this.data.tabGroup.color)})`);
        }
    }
    updated(changedProperties) {
        super.updated(changedProperties);
        if (changedProperties.has('data')) {
            highlightText(this.$.primaryText, this.data.tabGroup.title, this.data.highlightRanges['tabGroup.title']);
        }
    }
    tabCountText_() {
        const tabCount = this.data.tabGroup.tabCount;
        return loadTimeData.getStringF(tabCount === 1 ? 'oneTab' : 'tabCount', tabCount);
    }
}
customElements.define(TabSearchGroupItemElement.is, TabSearchGroupItemElement);

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class TitleItem {
    title;
    expandable;
    expanded;
    constructor(title, expandable = false, expanded = false) {
        this.title = title;
        this.expandable = expandable;
        this.expanded = expanded;
    }
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Helper functions for implementing an incremental search field. See
 * <settings-subpage-search> for a simple implementation.
 */
const CrSearchFieldMixinLit = (superClass) => {
    class CrSearchFieldMixinLit extends superClass {
        static get properties() {
            return {
                // Prompt text to display in the search field.
                label: {
                    type: String,
                },
                // Tooltip to display on the clear search button.
                clearLabel: {
                    type: String,
                },
                hasSearchText: {
                    type: Boolean,
                    reflect: true,
                },
            };
        }
        #label_accessor_storage = '';
        get label() { return this.#label_accessor_storage; }
        set label(value) { this.#label_accessor_storage = value; }
        #clearLabel_accessor_storage = '';
        get clearLabel() { return this.#clearLabel_accessor_storage; }
        set clearLabel(value) { this.#clearLabel_accessor_storage = value; }
        #hasSearchText_accessor_storage = false;
        get hasSearchText() { return this.#hasSearchText_accessor_storage; }
        set hasSearchText(value) { this.#hasSearchText_accessor_storage = value; }
        effectiveValue_ = '';
        searchDelayTimer_ = -1;
        /**
         * @return The input field element the behavior should use.
         */
        getSearchInput() {
            assertNotReached();
        }
        /**
         * @return The value of the search field.
         */
        getValue() {
            return this.getSearchInput().value;
        }
        /**
         * Sets the value of the search field.
         * @param noEvent Whether to prevent a 'search-changed' event
         *     firing for this change.
         */
        setValue(value, noEvent) {
            const updated = this.updateEffectiveValue_(value);
            this.getSearchInput().value = this.effectiveValue_;
            if (!updated) {
                // If the input is only whitespace and value is empty,
                // |hasSearchText| needs to be updated.
                if (value === '' && this.hasSearchText) {
                    this.hasSearchText = false;
                }
                return;
            }
            this.onSearchTermInput();
            if (!noEvent) {
                this.fire('search-changed', this.effectiveValue_);
            }
        }
        scheduleSearch_() {
            if (this.searchDelayTimer_ >= 0) {
                clearTimeout(this.searchDelayTimer_);
            }
            // Dispatch 'search' event after:
            //    0ms if the value is empty
            //  500ms if the value length is 1
            //  400ms if the value length is 2
            //  300ms if the value length is 3
            //  200ms if the value length is 4 or greater.
            // The logic here was copied from WebKit's native 'search' event.
            const length = this.getValue().length;
            const timeoutMs = length > 0 ? (500 - 100 * (Math.min(length, 4) - 1)) : 0;
            this.searchDelayTimer_ = setTimeout(() => {
                this.getSearchInput().dispatchEvent(new CustomEvent('search', { composed: true, detail: this.getValue() }));
                this.searchDelayTimer_ = -1;
            }, timeoutMs);
        }
        onSearchTermSearch() {
            this.onValueChanged_(this.getValue(), false);
        }
        /**
         * Update the state of the search field whenever the underlying input
         * value changes. Unlike onsearch or onkeypress, this is reliably called
         * immediately after any change, whether the result of user input or JS
         * modification.
         */
        onSearchTermInput() {
            this.hasSearchText = this.getSearchInput().value !== '';
            this.scheduleSearch_();
        }
        /**
         * Updates the internal state of the search field based on a change that
         * has already happened.
         * @param noEvent Whether to prevent a 'search-changed' event
         *     firing for this change.
         */
        onValueChanged_(newValue, noEvent) {
            const updated = this.updateEffectiveValue_(newValue);
            if (updated && !noEvent) {
                this.fire('search-changed', this.effectiveValue_);
            }
        }
        /**
         * Trim leading whitespace and replace consecutive whitespace with
         * single space. This will prevent empty string searches and searches
         * for effectively the same query.
         */
        updateEffectiveValue_(value) {
            const effectiveValue = value.replace(/\s+/g, ' ').replace(/^\s/, '');
            if (effectiveValue === this.effectiveValue_) {
                return false;
            }
            this.effectiveValue_ = effectiveValue;
            return true;
        }
    }
    return CrSearchFieldMixinLit;
};

// ui/webui/resources/js/metrics_reporter/metrics_reporter.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class PageMetricsHostPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'metrics_reporter.mojom.PageMetricsHost', scope);
    }
}
class PageMetricsHostRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageMetricsHostPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onPageRemoteCreated(page) {
        this.proxy.sendMessage(0, PageMetricsHost_OnPageRemoteCreated_ParamsSpec.$, null, [
            page
        ], false);
    }
    onGetMark(name) {
        return this.proxy.sendMessage(1, PageMetricsHost_OnGetMark_ParamsSpec.$, PageMetricsHost_OnGetMark_ResponseParamsSpec.$, [
            name
        ], false);
    }
    onClearMark(name) {
        this.proxy.sendMessage(2, PageMetricsHost_OnClearMark_ParamsSpec.$, null, [
            name
        ], false);
    }
    onUmaReportTime(name, time) {
        this.proxy.sendMessage(3, PageMetricsHost_OnUmaReportTime_ParamsSpec.$, null, [
            name,
            time
        ], false);
    }
}
class PageMetricsHost {
    static get $interfaceName() {
        return "metrics_reporter.mojom.PageMetricsHost";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageMetricsHostRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
class PageMetricsPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'metrics_reporter.mojom.PageMetrics', scope);
    }
}
class PageMetricsRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageMetricsPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onGetMark(name) {
        return this.proxy.sendMessage(0, PageMetrics_OnGetMark_ParamsSpec.$, PageMetrics_OnGetMark_ResponseParamsSpec.$, [
            name
        ], false);
    }
    onClearMark(name) {
        this.proxy.sendMessage(1, PageMetrics_OnClearMark_ParamsSpec.$, null, [
            name
        ], false);
    }
}
/**
 * An object which receives request messages for the PageMetrics
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
class PageMetricsCallbackRouter {
    helper_internal_;
    $;
    router_;
    onGetMark;
    onClearMark;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageMetricsRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onGetMark =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageMetrics_OnGetMark_ParamsSpec.$, PageMetrics_OnGetMark_ResponseParamsSpec.$, this.onGetMark.createReceiverHandler(true /* expectsResponse */), false);
        this.onClearMark =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageMetrics_OnClearMark_ParamsSpec.$, null, this.onClearMark.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
const PageMetricsHost_OnPageRemoteCreated_ParamsSpec = { $: {} };
const PageMetricsHost_OnGetMark_ParamsSpec = { $: {} };
const PageMetricsHost_OnGetMark_ResponseParamsSpec = { $: {} };
const PageMetricsHost_OnClearMark_ParamsSpec = { $: {} };
const PageMetricsHost_OnUmaReportTime_ParamsSpec = { $: {} };
const PageMetrics_OnGetMark_ParamsSpec = { $: {} };
const PageMetrics_OnGetMark_ResponseParamsSpec = { $: {} };
const PageMetrics_OnClearMark_ParamsSpec = { $: {} };
mojo.internal.Struct(PageMetricsHost_OnPageRemoteCreated_ParamsSpec.$, 'PageMetricsHost_OnPageRemoteCreated_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(PageMetricsRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageMetricsHost_OnGetMark_ParamsSpec.$, 'PageMetricsHost_OnGetMark_Params', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageMetricsHost_OnGetMark_ResponseParamsSpec.$, 'PageMetricsHost_OnGetMark_ResponseParams', [
    mojo.internal.StructField('markedTime', 0, 0, TimeDeltaSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageMetricsHost_OnClearMark_ParamsSpec.$, 'PageMetricsHost_OnClearMark_Params', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageMetricsHost_OnUmaReportTime_ParamsSpec.$, 'PageMetricsHost_OnUmaReportTime_Params', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('time', 8, 0, TimeDeltaSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageMetrics_OnGetMark_ParamsSpec.$, 'PageMetrics_OnGetMark_Params', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageMetrics_OnGetMark_ResponseParamsSpec.$, 'PageMetrics_OnGetMark_ResponseParams', [
    mojo.internal.StructField('markedTime', 0, 0, TimeDeltaSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageMetrics_OnClearMark_ParamsSpec.$, 'PageMetrics_OnClearMark_Params', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class BrowserProxyImpl {
    callbackRouter;
    host;
    constructor() {
        this.callbackRouter = new PageMetricsCallbackRouter();
        this.host = PageMetricsHost.getRemote();
        this.host.onPageRemoteCreated(this.callbackRouter.$.bindNewPipeAndPassRemote());
    }
    getMark(name) {
        return this.host.onGetMark(name);
    }
    clearMark(name) {
        this.host.onClearMark(name);
    }
    umaReportTime(name, time) {
        this.host.onUmaReportTime(name, time);
    }
    now() {
        return chrome.timeTicks.nowInMicroseconds();
    }
    getCallbackRouter() {
        return this.callbackRouter;
    }
    static getInstance() {
        return instance$5 || (instance$5 = new BrowserProxyImpl());
    }
    static setInstance(obj) {
        instance$5 = obj;
    }
}
let instance$5 = null;

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function timeFromMojo(delta) {
    return delta.microseconds;
}
function timeToMojo(mark) {
    return { microseconds: mark };
}
class MetricsReporterImpl {
    marks_ = new Map();
    browserProxy_ = BrowserProxyImpl.getInstance();
    constructor() {
        const callbackRouter = this.browserProxy_.getCallbackRouter();
        callbackRouter.onGetMark.addListener((name) => ({
            markedTime: this.marks_.has(name) ? timeToMojo(this.marks_.get(name)) : null,
        }));
        callbackRouter.onClearMark.addListener((name) => this.marks_.delete(name));
    }
    static getInstance() {
        return instance$4 || (instance$4 = new MetricsReporterImpl());
    }
    static setInstanceForTest(newInstance) {
        instance$4 = newInstance;
    }
    mark(name, time) {
        this.marks_.set(name, time ?? this.browserProxy_.now());
    }
    async measure(startMark, endMark) {
        let endTime;
        if (endMark) {
            const entry = this.marks_.get(endMark);
            assert(entry, `Mark "${endMark}" does not exist locally.`);
            endTime = entry;
        }
        else {
            endTime = this.browserProxy_.now();
        }
        let startTime;
        if (this.marks_.has(startMark)) {
            startTime = this.marks_.get(startMark);
        }
        else {
            const remoteStartTime = await this.browserProxy_.getMark(startMark);
            assert(remoteStartTime.markedTime, `Mark "${startMark}" does not exist locally or remotely.`);
            startTime = timeFromMojo(remoteStartTime.markedTime);
        }
        return endTime - startTime;
    }
    async hasMark(name) {
        if (this.marks_.has(name)) {
            return true;
        }
        const remoteMark = await this.browserProxy_.getMark(name);
        return remoteMark !== null && remoteMark.markedTime !== null;
    }
    hasLocalMark(name) {
        return this.marks_.has(name);
    }
    clearMark(name) {
        this.marks_.delete(name);
        this.browserProxy_.clearMark(name);
    }
    umaReportTime(histogram, time) {
        this.browserProxy_.umaReportTime(histogram, timeToMojo(time));
    }
}
let instance$4 = null;

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @return A new array of entries satisfying the input. If no search input is
 *     present, returns a shallow copy of the records.
 */
function search(input, records, options) {
    if (input.length === 0) {
        return [...records];
    }
    const searchStartTime = Date.now();
    const result = exactSearch(input, records, options);
    chrome.metricsPrivate.recordTime('Tabs.TabSearch.WebUI.SearchAlgorithmDuration', Math.round(Date.now() - searchStartTime));
    return result;
}
function cloneTabDataObj(tabData) {
    const clone = Object.assign({}, tabData);
    clone.highlightRanges = {};
    Object.setPrototypeOf(clone, Object.getPrototypeOf(tabData));
    return clone;
}
////////////////////////////////////////////////////////////////////////////////
// Exact Match Implementation :
/**
 * The exact match algorithm returns records ranked according to priorities
 * and scores. Records are ordered by priority (higher priority comes
 * first) and sorted by score within the same priority. See `scoringFunction`
 * for how to calculate score and `prioritizeMatchResult` for how to calculate
 * priority.
 */
function exactSearch(searchText, records, options) {
    if (searchText.length === 0) {
        return records;
    }
    // Default distance to calculate score for search fields based on match
    // position.
    const defaultDistance = 200;
    const distance = options.distance || defaultDistance;
    // Controls how heavily weighted the search field weights are relative to each
    // other in the scoring function.
    const searchFieldWeights = (options.keys).reduce((acc, { name, weight }) => {
        acc[name] = weight;
        return acc;
    }, {});
    // Perform an exact match search with range discovery.
    const exactMatches = [];
    for (const tabDataRecord of records) {
        let matchFound = false;
        const matchedRecord = cloneTabDataObj(tabDataRecord);
        // Searches for fields or nested fields in the record.
        for (const key of options.keys) {
            const text = key.getter(tabDataRecord);
            if (text) {
                const ranges = getRanges(text, searchText);
                if (ranges.length !== 0) {
                    matchedRecord.highlightRanges[key.name] = ranges;
                    matchFound = true;
                }
            }
        }
        if (matchFound) {
            exactMatches.push({
                tab: matchedRecord,
                score: scoringFunction(matchedRecord, distance, searchFieldWeights),
            });
        }
    }
    // Sort by score.
    exactMatches.sort((a, b) => (b.score - a.score));
    // Reorder match result by priorities.
    return prioritizeMatchResult(searchText, options.keys, exactMatches.map(item => item.tab));
}
/**
 * Determines whether the given tab has a search field with identified matches
 * at the beginning of the string.
 */
function hasMatchStringStart(tab, searchText, keys) {
    return keys.some(key => {
        const value = key.getter(tab);
        return value !== undefined && value.startsWith(searchText);
    });
}
/**
 * Determines whether the given tab has a match for the given regexp in its
 * search fields.
 */
function hasRegexMatch(tab, regexp, keys) {
    return keys.some((key) => {
        const value = key.getter(tab);
        return value !== undefined && value.search(regexp) !== -1;
    });
}
// https://crbug.com/433531973: Replace single and double left and right
// quotation characters with the regular ones.
function replaceSpecialQuotationCharacters(text) {
    return text.replace(/[‘’]/g, '\'').replace(/[“”]/g, '"');
}
/**
 * Returns an array of matches that indicate where in the target string the
 * searchText appears. If there are no identified matches an empty array is
 * returned.
 */
function getRanges(target, searchText) {
    target = replaceSpecialQuotationCharacters(target);
    searchText = replaceSpecialQuotationCharacters(searchText);
    const escapedText = quoteString(searchText);
    const ranges = [];
    let match = null;
    for (const re = new RegExp(escapedText, 'gi'); match = re.exec(target);) {
        ranges.push({
            start: match.index,
            length: searchText.length,
        });
    }
    return ranges;
}
/**
 * A scoring function based on match indices of specified search fields.
 * Matches near the beginning of the string will have a higher score than
 * matches near the end of the string. Multiple matches will have a higher score
 * than single matches.
 */
function scoringFunction(tabData, distance, searchFieldWeights) {
    let score = 0;
    // For every match, map the match index in [0, distance] to a scalar value in
    // [1, 0].
    for (const key in searchFieldWeights) {
        if (tabData.highlightRanges[key]) {
            for (const { start } of tabData.highlightRanges[key]) {
                score += Math.max((distance - start) / distance, 0) *
                    searchFieldWeights[key];
            }
        }
    }
    return score;
}
/**
 * Reorder match result based on priorities (highest to lowest priority):
 * 1. All items with a search key matching the searchText at the beginning of
 *    the string.
 * 2. All items with a search key matching the searchText at the beginning of a
 *    word in the string.
 * 3. All remaining items with a search key matching the searchText elsewhere in
 *    the string.
 */
function prioritizeMatchResult(searchText, keys, result) {
    const itemsMatchingStringStart = [];
    const itemsMatchingWordStart = [];
    const others = [];
    const wordStartRegexp = new RegExp(`\\b${quoteString(searchText)}`, 'i');
    for (const tab of result) {
        // Find matches that occur at the beginning of the string.
        if (hasMatchStringStart(tab, searchText, keys)) {
            itemsMatchingStringStart.push(tab);
        }
        else if (hasRegexMatch(tab, wordStartRegexp, keys)) {
            itemsMatchingWordStart.push(tab);
        }
        else {
            others.push(tab);
        }
    }
    return itemsMatchingStringStart.concat(itemsMatchingWordStart, others);
}

let instance$3 = null;
function getCss$3() {
    return instance$3 || (instance$3 = [...[getCss$x()], css `#searchField{align-items:center;background-color:var(--mwb-background-color);display:flex;height:60px;padding:0 var(--mwb-list-item-horizontal-margin);user-select:none}#searchIcon{color:var(--cr-secondary-text-color);height:var(--mwb-icon-size);padding-inline-end:12px;width:var(--mwb-icon-size)}#searchWrapper{display:flex;flex:1;height:100%;position:relative}:host([has-search-text]) #searchField label{visibility:hidden}#searchLabel{align-items:center;color:var(--cr-secondary-text-color);cursor:text;display:flex;font-size:var(--mwb-primary-text-font-size);font-weight:var(--mwb-secondary-text-font-weight);height:100%;justify-content:space-between;margin-inline-start:1px;position:absolute;width:100%}#searchResultText{clip:rect(0,0,0,0);display:inline-block;position:fixed}#searchInput{background-color:transparent;border:none;border-radius:0;color:var(--cr-primary-text-color);flex:1;font-family:inherit;font-size:var(--mwb-primary-text-font-size);font-style:inherit;font-weight:var(--mwb-secondary-text-font-weight);outline:none;padding:0;text-overflow:ellipsis}#searchInput::-webkit-search-cancel-button{display:none}#no-results{color:var(--cr-primary-text-color);font-size:var(--mwb-primary-text-font-size);padding:12px;text-align:center}#feedback-text{color:var(--cr-primary-text-color);font-size:var(--mwb-primary-text-font-size);margin-inline-start:var(--mwb-list-item-horizontal-margin);user-select:none}#feedback-footer{border:none;border-top:1px solid var(--google-grey-500);height:40px;width:100%}#feedback-footer:focus{background-color:var(--mwb-list-item-selected-background-color);outline:none}#feedback-icon{--iron-icon-fill-color:var(--google-grey-700);height:var(--mwb-icon-size);width:var(--mwb-icon-size)}@media (prefers-color-scheme:dark){#feedback-icon{--iron-icon-fill-color:var(--google-blue-300)}}.list-section-title{align-items:center;background-color:var(--mwb-background-color);color:var(--cr-secondary-text-color);display:flex;font-size:var(--mwb-primary-text-font-size);font-weight:var(--mwb-primary-text-font-weight);height:var(--mwb-list-section-title-height);padding-inline-end:28px;padding-inline-start:var(--mwb-list-item-horizontal-margin);position:sticky;top:0;user-select:none;z-index:1000}cr-expand-button{--cr-expand-button-size:24px;--cr-expand-button-icon-size:16px;--cr-section-vertical-padding:0;-webkit-tap-highlight-color:transparent;color:var(--mwb-icon-button-fill-color);flex-grow:1}#divider{width:100%;height:1px;background-color:var(--cr-separator-color)}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// clang-format off
function getHtml$2() {
    return html `<!--_html_template_start_-->
<div id="tabSearchPage">
  <div id="searchField" @keydown="${this.onSearchKeyDown_}"
      clear-label="$i18n{clearSearch}">
    <cr-icon id="searchIcon" icon="tab-search:search"></cr-icon>
    <div id="searchWrapper">
      <label id="searchLabel" for="searchInput" aria-hidden="true">
        <span>$i18n{searchTabs}</span>
        <span>${this.shortcut_}</span>
        <span id="searchResultText">${this.searchResultText_}</span>
      </label>
      <input id="searchInput" aria-labelledby="searchLabel"
          autofocus autocomplete="off"
          maxlength="${this.searchQueryMaxLength_}"
          @search="${this.onSearchTermSearch}"
          @input="${this.onSearchTermInput}"
          type="search" spellcheck="false" role="combobox"
          aria-activedescendant="${this.activeSelectionId_ || nothing}"
          aria-controls="tabsList" aria-owns="tabsList">
    </div>
  </div>
  <div id="divider"></div>
  <div ?hidden="${!this.filteredItems_.length}">
    <selectable-lazy-list id="tabsList"
        max-height="${this.listMaxHeight_}"
        item-size="${this.listItemSize_}"
        .items="${this.filteredItems_}"
        @selected-change="${this.onSelectedChanged_}"
        role="listbox"
        .isSelectable=${(item) => {
        return item.constructor.name === 'TabData' ||
            item.constructor.name === 'TabGroupData';
    }}
        .template=${(item, index) => {
        switch (item.constructor.name) {
            case 'TitleItem':
                return html `
          <div class="list-section-title">
            <div>${item.title}</div>
            ${item.expandable ? html `<cr-expand-button
                  aria-label="$i18n{recentlyClosedExpandA11yLabel}"
                  data-title="${item.title}"
                  data-index="${index}"
                  expand-icon="cr:arrow-drop-down"
                  collapse-icon="cr:arrow-drop-up"
                  ?expanded="${item.expanded}"
                  expand-title="$i18n{expandRecentlyClosed}"
                  collapse-title="$i18n{collapseRecentlyClosed}"
                  @expanded-changed="${this.onTitleExpandChanged_}"
                  no-hover>
              </cr-expand-button>` : ''}
          </div>`;
            case 'TabData':
                return html `<tab-search-item id="${item.tab.tabId}"
            aria-label="${this.ariaLabel_(item)}"
            class="mwb-list-item selectable" .data="${item}"
            data-index="${index}"
            @click="${this.onItemClick_}"
            @close="${this.onItemClose_}"
            @focus="${this.onItemFocus_}"
            @keydown="${this.onItemKeyDown_}"
            role="option"
            tabindex="0">
        </tab-search-item>`;
            case 'TabGroupData':
                return html `<tab-search-group-item id="${item.tabGroup.id}"
            class="mwb-list-item selectable"
            .data="${item}"
            data-index="${index}"
            aria-label="${this.ariaLabel_(item)}"
            @click="${this.onItemClick_}"
            @focus="${this.onItemFocus_}"
            @keydown="${this.onItemKeyDown_}"
            role="option" tabindex="0">
        </tab-search-group-item>`;
            default:
                return '';
        }
    }}
    </selectable-lazy-list>
  </div>
  <div id="no-results" ?hidden="${this.filteredItems_.length}">
    $i18n{noResultsFound}
  </div>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// The minimum number of list items we allow viewing regardless of browser
// height. Includes a half row that hints to the user the capability to scroll.
const MINIMUM_AVAILABLE_HEIGHT_LIST_ITEM_COUNT = 5.5;
// A maximum limit for search queries, to prevent  errors like
// "SyntaxError: Invalid regular expression: ..."
const SEARCH_QUERY_MAX_LENGTH = 400;
const TabSearchSearchFieldBase = CrSearchFieldMixinLit(CrLitElement);
/**
 * These values are persisted to logs and should not be renumbered or re-used.
 * See tools/metrics/histograms/enums.xml.
 */
var TabSwitchAction;
(function (TabSwitchAction) {
    TabSwitchAction[TabSwitchAction["WITHOUT_SEARCH"] = 0] = "WITHOUT_SEARCH";
    TabSwitchAction[TabSwitchAction["WITH_SEARCH"] = 1] = "WITH_SEARCH";
})(TabSwitchAction || (TabSwitchAction = {}));
class TabSearchPageElement extends TabSearchSearchFieldBase {
    static get is() {
        return 'tab-search-page';
    }
    static get properties() {
        return {
            // Text that describes the resulting tabs currently present in the list.
            searchResultText_: { type: String },
            availableHeight: { type: Number },
            shortcut_: { type: String },
            searchText_: { type: String },
            filteredItems_: { type: Array },
            listMaxHeight_: { type: Number },
            listItemSize_: { type: Number },
            searchQueryMaxLength_: { type: Number },
            /**
             * Options for search. Controls how heavily weighted fields are relative
             * to each other in the scoring via field weights.
             */
            searchOptions_: { type: Object },
            recentlyClosedDefaultItemDisplayCount_: { type: Number },
            tabOrganizationEnabled: {
                type: Boolean,
                reflect: true,
            },
        };
    }
    #tabOrganizationEnabled_accessor_storage = loadTimeData.getBoolean('tabOrganizationEnabled');
    get tabOrganizationEnabled() { return this.#tabOrganizationEnabled_accessor_storage; }
    set tabOrganizationEnabled(value) { this.#tabOrganizationEnabled_accessor_storage = value; }
    #availableHeight_accessor_storage;
    get availableHeight() { return this.#availableHeight_accessor_storage; }
    set availableHeight(value) { this.#availableHeight_accessor_storage = value; }
    #searchText__accessor_storage = '';
    get searchText_() { return this.#searchText__accessor_storage; }
    set searchText_(value) { this.#searchText__accessor_storage = value; }
    #listMaxHeight__accessor_storage;
    get listMaxHeight_() { return this.#listMaxHeight__accessor_storage; }
    set listMaxHeight_(value) { this.#listMaxHeight__accessor_storage = value; }
    #listItemSize__accessor_storage;
    get listItemSize_() { return this.#listItemSize__accessor_storage; }
    set listItemSize_(value) { this.#listItemSize__accessor_storage = value; }
    #searchQueryMaxLength__accessor_storage = SEARCH_QUERY_MAX_LENGTH;
    get searchQueryMaxLength_() { return this.#searchQueryMaxLength__accessor_storage; }
    set searchQueryMaxLength_(value) { this.#searchQueryMaxLength__accessor_storage = value; }
    #filteredItems__accessor_storage = [];
    get filteredItems_() { return this.#filteredItems__accessor_storage; }
    set filteredItems_(value) { this.#filteredItems__accessor_storage = value; }
    #searchOptions__accessor_storage = {
        includeScore: true,
        includeMatches: true,
        ignoreLocation: false,
        threshold: 0.0,
        distance: 200,
        keys: [
            {
                name: 'tab.title',
                getter: getTitle,
                weight: 2,
            },
            {
                name: 'hostname',
                getter: getHostname,
                weight: 1,
            },
            {
                name: 'tabGroup.title',
                getter: getTabGroupTitle,
                weight: 1.5,
            },
        ],
    };
    get searchOptions_() { return this.#searchOptions__accessor_storage; }
    set searchOptions_(value) { this.#searchOptions__accessor_storage = value; }
    #recentlyClosedDefaultItemDisplayCount__accessor_storage = loadTimeData.getValue('recentlyClosedDefaultItemDisplayCount');
    get recentlyClosedDefaultItemDisplayCount_() { return this.#recentlyClosedDefaultItemDisplayCount__accessor_storage; }
    set recentlyClosedDefaultItemDisplayCount_(value) { this.#recentlyClosedDefaultItemDisplayCount__accessor_storage = value; }
    #searchResultText__accessor_storage = '';
    get searchResultText_() { return this.#searchResultText__accessor_storage; }
    set searchResultText_(value) { this.#searchResultText__accessor_storage = value; }
    activeSelectionId_;
    #shortcut__accessor_storage = loadTimeData.getString('shortcutText');
    get shortcut_() { return this.#shortcut__accessor_storage; }
    set shortcut_(value) { this.#shortcut__accessor_storage = value; }
    autofocus = false;
    apiProxy_ = TabSearchApiProxyImpl.getInstance();
    metricsReporter_ = null;
    listenerIds_ = [];
    tabGroupsMap_ = new Map();
    recentlyClosedTabGroups_ = [];
    openTabs_ = [];
    recentlyClosedTabs_ = [];
    windowShownTimestamp_ = Date.now();
    mediaTabsTitleItem_;
    openTabsTitleItem_;
    recentlyClosedTitleItem_;
    filteredOpenTabsCount_ = 0;
    filteredOpenHeaderIndices_ = [];
    initiallySelectedIndex_ = NO_SELECTION;
    documentVisibilityChangedListener_;
    elementVisibilityChangedListener_;
    wasInactive_ = false;
    constructor() {
        super();
        ColorChangeUpdater.forDocument().start();
        this.documentVisibilityChangedListener_ = () => {
            if (document.visibilityState === 'visible') {
                this.windowShownTimestamp_ = Date.now();
                this.updateTabs_();
            }
            else {
                this.onDocumentHidden_();
            }
        };
        this.elementVisibilityChangedListener_ =
            new IntersectionObserver((entries, _observer) => {
                entries.forEach(entry => {
                    this.onElementVisibilityChanged_(entry.intersectionRatio > 0);
                });
            }, { root: document.documentElement });
        this.mediaTabsTitleItem_ =
            new TitleItem(loadTimeData.getString('mediaTabs'));
        this.openTabsTitleItem_ = new TitleItem(loadTimeData.getString('openTabs'));
        this.recentlyClosedTitleItem_ = new TitleItem(loadTimeData.getString('recentlyClosed'), true /*expandable*/, true /*expanded*/);
    }
    get metricsReporter() {
        if (!this.metricsReporter_) {
            this.metricsReporter_ = MetricsReporterImpl.getInstance();
        }
        return this.metricsReporter_;
    }
    firstUpdated(changedProperties) {
        super.firstUpdated(changedProperties);
        this.listItemSize_ = this.getStylePropertyPixelValue_('--mwb-item-height');
    }
    connectedCallback() {
        super.connectedCallback();
        document.addEventListener('visibilitychange', this.documentVisibilityChangedListener_);
        this.elementVisibilityChangedListener_.observe(this);
        this.apiProxy_.getTabSearchSection().then(({ section }) => this.wasInactive_ =
            section !== TabSearchSection.kSearch);
        const callbackRouter = this.apiProxy_.getCallbackRouter();
        this.listenerIds_.push(callbackRouter.tabsChanged.addListener(this.tabsChanged_.bind(this)), callbackRouter.tabUpdated.addListener(this.onTabUpdated_.bind(this)), callbackRouter.tabsRemoved.addListener(this.onTabsRemoved_.bind(this)));
        // If added in a visible state update current tabs.
        if (document.visibilityState === 'visible') {
            this.updateTabs_();
        }
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.listenerIds_.forEach(id => this.apiProxy_.getCallbackRouter().removeListener(id));
        document.removeEventListener('visibilitychange', this.documentVisibilityChangedListener_);
        this.elementVisibilityChangedListener_.disconnect();
    }
    updated(changedProperties) {
        super.updated(changedProperties);
        if (changedProperties.has('availableHeight')) {
            assert(this.availableHeight !== undefined);
            /**
             * Calculate the list's available height by subtracting the height used by
             * the search and feedback fields.
             */
            this.listMaxHeight_ = Math.max(this.availableHeight - this.$.searchField.offsetHeight -
                this.$.divider.offsetHeight, Math.round(MINIMUM_AVAILABLE_HEIGHT_LIST_ITEM_COUNT *
                this.getStylePropertyPixelValue_('--mwb-item-height')));
        }
    }
    getSearchInput() {
        return this.$.searchInput;
    }
    /**
     * Do not schedule the timer from CrSearchFieldMixin to make search more
     * responsive.
     */
    onSearchTermInput() {
        this.hasSearchText = this.getSearchInput().value !== '';
        this.searchText_ = this.getSearchInput().value;
        // Reset the selected item whenever a search query is provided.
        // updateFilteredTabs_ will set the correct tab index for initial selection.
        const tabsList = this.$.tabsList;
        tabsList.resetSelected();
        this.updateFilteredTabs_();
        // http://crbug.com/1481787: Dispatch the search event to update the
        // internal value to make CrSearchFieldMixin function correctly.
        this.getSearchInput().dispatchEvent(new CustomEvent('search', { composed: true, detail: this.searchText_ }));
    }
    /**
     * @param name A property whose value is specified in pixels.
     */
    getStylePropertyPixelValue_(name) {
        const pxValue = getComputedStyle(this).getPropertyValue(name);
        assert(pxValue);
        return Number.parseInt(pxValue.trim().slice(0, -2), 10);
    }
    onDocumentHidden_() {
        this.filteredItems_ = [];
        this.setValue('');
        this.$.searchInput.focus();
    }
    onElementVisibilityChanged_(visible) {
        if (visible && this.wasInactive_) {
            this.$.tabsList.fillCurrentViewport();
        }
        else if (!visible) {
            this.wasInactive_ = true;
        }
    }
    updateTabs_() {
        const isMarkOverlap = this.metricsReporter.hasLocalMark('TabListDataReceived');
        chrome.metricsPrivate.recordBoolean('Tabs.TabSearch.WebUI.TabListDataReceived2.IsOverlap', isMarkOverlap);
        if (!isMarkOverlap) {
            this.metricsReporter.mark('TabListDataReceived');
        }
        this.apiProxy_.getProfileData().then(({ profileData }) => {
            // TODO(crbug.com/40205026): this is a side-by-side comparison of metrics
            // reporter histogram vs. old histogram. Cleanup when the experiment ends.
            this.metricsReporter.measure('TabListDataReceived')
                .then(e => this.metricsReporter.umaReportTime('Tabs.TabSearch.WebUI.TabListDataReceived2', e))
                .then(() => this.metricsReporter.clearMark('TabListDataReceived'))
                // Ignore silently if mark 'TabListDataReceived' is missing.
                .catch(() => { });
            // In rare cases there is no browser window. I suspect this happens during
            // browser shutdown. Don't show Tab Search when this happens.
            if (!profileData.windows) {
                console.warn('Tab Search: no browser window.');
                return;
            }
            // The selectable-list produces viewport-filled events whenever a data
            // or scroll position change triggers the viewport fill logic.
            listenOnce(this.$.tabsList, 'viewport-filled', () => this.apiProxy_.notifySearchUiReadyToShow());
            this.tabsChanged_(profileData);
        });
    }
    onTabUpdated_(tabUpdateInfo) {
        const { tab, inActiveWindow } = tabUpdateInfo;
        const tabData = this.tabData_(tab, inActiveWindow, TabItemType.OPEN_TAB, this.tabGroupsMap_);
        // Replace the tab with the same tabId and trigger rerender.
        let foundTab = false;
        for (let i = 0; i < this.openTabs_.length && !foundTab; ++i) {
            if (this.openTabs_[i].tab.tabId === tab.tabId) {
                this.openTabs_[i] = tabData;
                this.updateFilteredTabs_();
                foundTab = true;
            }
        }
        // If the updated tab's id is not found in the existing open tabs, add it
        // to the list.
        if (!foundTab) {
            this.openTabs_.push(tabData);
            this.updateFilteredTabs_();
        }
        this.metricsReporter.measure('TabUpdated')
            .then(e => this.metricsReporter.umaReportTime('Tabs.TabSearch.Mojo.TabUpdated', e))
            .then(() => this.metricsReporter.clearMark('TabUpdated'))
            // Ignore silently if mark 'TabUpdated' is missing.
            .catch(() => { });
    }
    onTabsRemoved_(tabsRemovedInfo) {
        if (this.openTabs_.length === 0) {
            return;
        }
        const ids = new Set(tabsRemovedInfo.tabIds);
        // Splicing in descending index order to avoid affecting preceding indices
        // that are to be removed.
        for (let i = this.openTabs_.length - 1; i >= 0; i--) {
            if (ids.has(this.openTabs_[i].tab.tabId)) {
                this.openTabs_.splice(i, 1);
            }
        }
        tabsRemovedInfo.recentlyClosedTabs.forEach(tab => {
            this.recentlyClosedTabs_.unshift(this.tabData_(tab, false, TabItemType.RECENTLY_CLOSED_TAB, this.tabGroupsMap_));
        });
        this.updateFilteredTabs_();
    }
    itemIndexToTabIndex_(itemIndex) {
        // Note: the array being searched has length at most 3.
        const numPreviousHeaders = this.filteredOpenHeaderIndices_.findLastIndex(idx => idx < itemIndex) +
            1;
        return itemIndex - numPreviousHeaders;
    }
    getSelectedTabIndex() {
        return this.itemIndexToTabIndex_(this.$.tabsList.selected);
    }
    getA11ySearchResultText_() {
        // TODO(romanarora): Screen readers' list item number announcement will
        // not match as it counts the title items too. Investigate how to
        // programmatically control announcements to avoid this.
        const itemCount = this.selectableItemCount_();
        let text;
        if (this.searchText_.length > 0) {
            text = loadTimeData.getStringF(itemCount === 1 ? 'a11yFoundTabFor' : 'a11yFoundTabsFor', itemCount, this.searchText_);
        }
        else {
            text = loadTimeData.getStringF(itemCount === 1 ? 'a11yFoundTab' : 'a11yFoundTabs', itemCount);
        }
        return text;
    }
    /**
     * @return The number of selectable list items, excludes non
     *     selectable items such as section title items.
     */
    selectableItemCount_() {
        return this.filteredItems_.reduce((acc, item) => {
            return acc + (item instanceof TitleItem ? 0 : 1);
        }, 0);
    }
    /**
     * @return The last selectable list item, excludes non
     *     selectable items such as section title items.
     */
    lastSelectableIndex_() {
        return this.filteredItems_.findLastIndex(item => !(item instanceof TitleItem)) ||
            -1;
    }
    onItemClick_(e) {
        const target = e.currentTarget;
        const tabItem = target.data;
        const tabIndex = this.itemIndexToTabIndex_(Number(target.dataset['index']));
        this.tabItemAction_(tabItem, tabIndex);
    }
    recordMetricsForAction(action, tabIndex) {
        const withSearch = !!this.searchText_;
        if (action === 'SwitchTab') {
            chrome.metricsPrivate.recordEnumerationValue('Tabs.TabSearch.WebUI.TabSwitchAction', withSearch ? TabSwitchAction.WITH_SEARCH :
                TabSwitchAction.WITHOUT_SEARCH, Object.keys(TabSwitchAction).length);
        }
        chrome.metricsPrivate.recordSmallCount(withSearch ? `Tabs.TabSearch.WebUI.IndexOf${action}InFilteredList` :
            `Tabs.TabSearch.WebUI.IndexOf${action}InUnfilteredList`, tabIndex);
    }
    /**
     * Trigger the click/press action associated with the given Tab item type.
     */
    tabItemAction_(itemData, tabIndex) {
        const state = this.searchText_ ? 'Filtered' : 'Unfiltered';
        let action;
        switch (itemData.type) {
            case TabItemType.OPEN_TAB:
                const isMarkOverlap = this.metricsReporter.hasLocalMark('SwitchToTab');
                chrome.metricsPrivate.recordBoolean('Tabs.TabSearch.Mojo.SwitchToTab.IsOverlap', isMarkOverlap);
                if (!isMarkOverlap) {
                    this.metricsReporter.mark('SwitchToTab');
                }
                this.recordMetricsForAction('SwitchTab', tabIndex);
                this.apiProxy_.switchToTab({ tabId: itemData.tab.tabId });
                action = 'SwitchTab';
                break;
            case TabItemType.RECENTLY_CLOSED_TAB:
                this.apiProxy_.openRecentlyClosedEntry(itemData.tab.tabId, !!this.searchText_, true, tabIndex - this.filteredOpenTabsCount_);
                action = 'OpenRecentlyClosedEntry';
                break;
            case TabItemType.RECENTLY_CLOSED_TAB_GROUP:
                this.apiProxy_.openRecentlyClosedEntry((itemData.tabGroup).sessionId, !!this.searchText_, false, tabIndex - this.filteredOpenTabsCount_);
                action = 'OpenRecentlyClosedEntry';
                break;
            default:
                throw new Error('ItemData is of invalid type.');
        }
        chrome.metricsPrivate.recordTime(`Tabs.TabSearch.WebUI.TimeTo${action}In${state}List`, Math.round(Date.now() - this.windowShownTimestamp_));
    }
    onItemClose_(e) {
        performance.mark('tab_search:close_tab:metric_begin');
        const target = e.currentTarget;
        const tabItem = target.data;
        const tabIndex = this.itemIndexToTabIndex_(Number(target.dataset['index']));
        const tabId = tabItem.tab.tabId;
        this.recordMetricsForAction('CloseTab', tabIndex);
        this.apiProxy_.closeTab(tabId);
        this.announceA11y_(loadTimeData.getString('a11yTabClosed'));
        listenOnce(this.$.tabsList, 'rendered-items-changed', () => {
            performance.mark('tab_search:close_tab:metric_end');
        });
    }
    onItemKeyDown_(e) {
        if (e.key !== 'Enter' && e.key !== ' ') {
            return;
        }
        e.stopPropagation();
        e.preventDefault();
        const target = e.currentTarget;
        const itemData = target.data;
        const tabIndex = this.itemIndexToTabIndex_(Number(target.dataset['index']));
        this.tabItemAction_(itemData, tabIndex);
    }
    tabsChanged_(profileData) {
        this.tabGroupsMap_ = profileData.tabGroups.reduce((map, tabGroup) => {
            map.set(tokenToString(tabGroup.id), tabGroup);
            return map;
        }, new Map());
        this.openTabs_ = profileData.windows.reduce((acc, { active, tabs }) => acc.concat(tabs.map(tab => this.tabData_(tab, active, TabItemType.OPEN_TAB, this.tabGroupsMap_))), []);
        this.recentlyClosedTabs_ = profileData.recentlyClosedTabs.map(tab => this.tabData_(tab, false, TabItemType.RECENTLY_CLOSED_TAB, this.tabGroupsMap_));
        this.recentlyClosedTabGroups_ =
            profileData.recentlyClosedTabGroups.map(tabGroup => {
                const tabGroupData = new TabGroupData(tabGroup);
                tabGroupData.a11yTypeText =
                    loadTimeData.getString('a11yRecentlyClosedTabGroup');
                return tabGroupData;
            });
        this.recentlyClosedTitleItem_.expanded =
            profileData.recentlyClosedSectionExpanded;
        this.$.tabsList.expandedList = profileData.recentlyClosedSectionExpanded;
        this.updateFilteredTabs_();
    }
    onItemFocus_(e) {
        // Ensure that when a TabSearchItem receives focus, it becomes the selected
        // item in the list.
        const target = e.currentTarget;
        const index = Number(target.dataset['index']);
        this.$.tabsList.setSelected(index);
    }
    getTitleItemFromTitle_(title) {
        const item = [
            this.mediaTabsTitleItem_,
            this.openTabsTitleItem_,
            this.recentlyClosedTitleItem_,
        ].find(item => item.title === title);
        assert(item);
        return item;
    }
    async onTitleExpandChanged_(e) {
        // Instead of relying on two-way binding to update the `expanded` property,
        // we update the value directly as the `expanded-changed` event takes place
        // before a two way bound property update and we need the TitleItem
        // instance to reflect the updated state prior to calling the
        // updateFilteredTabs_ function.
        const expanded = e.detail.value;
        const target = e.currentTarget;
        const title = target.dataset['title'];
        const index = Number(target.dataset['index']);
        assert(title);
        const titleItem = this.getTitleItemFromTitle_(title);
        if (titleItem.expanded === expanded) {
            return;
        }
        titleItem.expanded = expanded;
        this.apiProxy_.saveRecentlyClosedExpandedPref(expanded);
        this.$.tabsList.toggleAttribute('expanded-list', expanded);
        e.stopPropagation();
        await this.updateFilteredTabs_();
        // If a section's title item is the last visible element in the list and the
        // list's height is at its maximum, it will not be evident to the user that
        // on expanding the section there are now section tab items available. By
        // ensuring the first element of the section is visible, we can avoid this
        // confusion.
        if (expanded) {
            this.$.tabsList.scrollIndexIntoView(index + 1);
        }
    }
    /**
     * Handles key events when the search field has focus.
     */
    onSearchKeyDown_(e) {
        // In the event the search field has focus and the first item in the list is
        // selected and we receive a Shift+Tab navigation event, ensure All DOM
        // items are available so that the focus can transfer to the last item in
        // the list.
        if (e.shiftKey && e.key === 'Tab' && this.getSelectedTabIndex() === 0) {
            this.$.tabsList.ensureAllDomItemsAvailable();
            return;
        }
        // Do not interfere with the search field's management of text selection
        // that relies on the Shift key.
        if (e.shiftKey) {
            return;
        }
        if (this.$.tabsList.selected === -1) {
            // No tabs matching the search text criteria.
            return;
        }
        if (selectorNavigationKeys.includes(e.key)) {
            this.$.tabsList.navigate(e.key);
            e.stopPropagation();
            e.preventDefault();
        }
        else if (e.key === 'Enter') {
            if (this.$.tabsList.selectedItem) {
                const itemData = this.$.tabsList.selectedItem
                    .data;
                this.tabItemAction_(itemData, this.getSelectedTabIndex());
            }
            e.stopPropagation();
        }
    }
    announceA11y_(text) {
        getInstance().announce(text);
    }
    ariaLabel_(tabData) {
        return ariaLabel(tabData);
    }
    tabData_(tab, inActiveWindow, type, tabGroupsMap) {
        const tabData = new TabData(tab, type, getDisplayHostnameForUrl(new URL(normalizeURL(tab.url.url))));
        if (tab.groupId) {
            tabData.tabGroup = tabGroupsMap.get(tokenToString(tab.groupId));
        }
        if (type === TabItemType.OPEN_TAB) {
            tabData.inActiveWindow = inActiveWindow;
        }
        tabData.a11yTypeText = loadTimeData.getString(type === TabItemType.OPEN_TAB ? 'a11yOpenTab' :
            'a11yRecentlyClosedTab');
        return tabData;
    }
    getRecentlyClosedItemLastActiveTime_(itemData) {
        if (itemData.type === TabItemType.RECENTLY_CLOSED_TAB &&
            itemData instanceof TabData) {
            return itemData.tab.lastActiveTime;
        }
        if (itemData.type === TabItemType.RECENTLY_CLOSED_TAB_GROUP &&
            itemData instanceof TabGroupData) {
            return (itemData.tabGroup).lastActiveTime;
        }
        throw new Error('ItemData provided is invalid.');
    }
    async updateFilteredTabs_() {
        this.openTabs_.sort((a, b) => {
            const tabA = a.tab;
            const tabB = b.tab;
            // Move the visible tab(s) to the bottom of the list
            // because it's not likely users want to click on it.
            if (a.inActiveWindow && tabA.visible) {
                return 1;
            }
            if (b.inActiveWindow && tabB.visible) {
                return -1;
            }
            return (tabB.lastActiveTimeTicks && tabA.lastActiveTimeTicks) ?
                Number(tabB.lastActiveTimeTicks.internalValue -
                    tabA.lastActiveTimeTicks.internalValue) :
                0;
        });
        let mediaTabs = [];
        // Audio & Video section will not be added when search criteria is applied.
        // Show media tabs in Open Tabs.
        if (this.searchText_.length === 0) {
            mediaTabs = this.openTabs_.filter(tabData => tabHasMediaAlerts(tabData.tab));
        }
        const filteredMediaTabs = search(this.searchText_, mediaTabs, this.searchOptions_);
        let filteredOpenTabs = search(this.searchText_, this.openTabs_, this.searchOptions_);
        // The MRU tab that is not the active tab is either the first tab in the
        // Audio and Video section (if it exists) or the first tab in the Open Tabs
        // section.
        if (filteredOpenTabs.length > 0) {
            this.initiallySelectedIndex_ =
                (tabHasMediaAlerts(filteredOpenTabs[0].tab) ||
                    filteredMediaTabs.length === 0) ?
                    1 :
                    filteredMediaTabs.length + 2;
        }
        if (this.searchText_.length === 0) {
            filteredOpenTabs = filteredOpenTabs.filter(tabData => !tabHasMediaAlerts(tabData.tab));
        }
        this.filteredOpenTabsCount_ =
            filteredOpenTabs.length + filteredMediaTabs.length;
        const recentlyClosedItems = [...this.recentlyClosedTabs_, ...this.recentlyClosedTabGroups_];
        recentlyClosedItems.sort((a, b) => {
            const aTime = this.getRecentlyClosedItemLastActiveTime_(a);
            const bTime = this.getRecentlyClosedItemLastActiveTime_(b);
            return (bTime && aTime) ?
                Number(bTime.internalValue - aTime.internalValue) :
                0;
        });
        let filteredRecentlyClosedItems = search(this.searchText_, recentlyClosedItems, this.searchOptions_);
        // Limit the number of recently closed items to the default display count
        // when no search text has been specified. Filter out recently closed tabs
        // that belong to a recently closed tab group by default.
        const recentlyClosedTabGroupIds = this.recentlyClosedTabGroups_.reduce((acc, tabGroupData) => acc.concat(tabGroupData.tabGroup.id), []);
        if (!this.searchText_.length) {
            filteredRecentlyClosedItems =
                filteredRecentlyClosedItems
                    .filter(recentlyClosedItem => {
                    if (recentlyClosedItem instanceof TabGroupData) {
                        return true;
                    }
                    const recentlyClosedTab = (recentlyClosedItem).tab;
                    return (!recentlyClosedTab.groupId ||
                        !recentlyClosedTabGroupIds.some(groupId => tokenEquals(groupId, recentlyClosedTab.groupId)));
                })
                    .slice(0, this.recentlyClosedDefaultItemDisplayCount_);
        }
        this.filteredOpenHeaderIndices_ = [];
        let numItems = 0;
        [filteredMediaTabs, filteredOpenTabs, filteredRecentlyClosedItems].forEach(list => {
            if (list.length > 0) {
                this.filteredOpenHeaderIndices_.push(numItems);
                numItems += list.length + 1;
            }
        });
        this.filteredItems_ =
            [
                [this.mediaTabsTitleItem_, filteredMediaTabs],
                [this.openTabsTitleItem_, filteredOpenTabs],
                [this.recentlyClosedTitleItem_, filteredRecentlyClosedItems],
            ]
                .reduce((acc, [sectionTitle, sectionItems]) => {
                if (sectionItems.length !== 0) {
                    acc.push(sectionTitle);
                    if (!sectionTitle.expandable ||
                        sectionTitle.expandable && sectionTitle.expanded) {
                        acc.push(...sectionItems);
                    }
                }
                return acc;
            }, []);
        this.searchResultText_ = this.getA11ySearchResultText_();
        // If there was no previously selected index, set the selected index to be
        // the tab index specified for initial selection; else retain the currently
        // selected index. If the list shrunk above the selected index, select the
        // last index in the list. If there are no matching results, set the
        // selected index value to none.
        await this.updateComplete;
        const tabsList = this.$.tabsList;
        await tabsList.updateComplete;
        // Only update the selection after the tab list has a chance to render
        // the newly filtered list.
        let selectedIndex = this.$.tabsList.selected;
        if (selectedIndex === NO_SELECTION) {
            selectedIndex = this.initiallySelectedIndex_;
        }
        tabsList.setSelected(Math.min(Math.max(selectedIndex, 0), this.lastSelectableIndex_()));
    }
    getSearchTextForTesting() {
        return this.searchText_;
    }
    static get styles() {
        return getCss$3();
    }
    render() {
        return getHtml$2.bind(this)();
    }
    onSelectedChanged_(e) {
        const itemData = e.detail.item ? e.detail.item.data : null;
        this.activeSelectionId_ = (itemData && itemData instanceof TabData) ?
            itemData.tab.tabId.toString() :
            undefined;
    }
}
customElements.define(TabSearchPageElement.is, TabSearchPageElement);

let instance$2 = null;
function getCss$2() {
    return instance$2 || (instance$2 = [...[getCss$w()], css `:host{cursor:pointer;display:flex;flex-direction:row;font-size:var(--cr-tabs-font-size,14px);font-weight:500;height:var(--cr-tabs-height,48px);user-select:none}.tab{align-items:center;color:var(--cr-secondary-text-color);display:flex;flex:var(--cr-tabs-flex,auto);height:100%;justify-content:center;opacity:1;outline:none;padding:0 var(--cr-tabs-tab-inline-padding,0);position:relative;transition:opacity 100ms cubic-bezier(.4,0,1,1)}:host-context(.focus-outline-visible) .tab:focus{outline:var(--cr-tabs-focus-outline,auto);outline-offset:var(--cr-tabs-focus-outline-offset,0)}.selected{color:var(--cr-tabs-selected-color,var(--google-blue-600));opacity:1}@media (prefers-color-scheme:dark){.selected{color:var(--cr-tabs-selected-color,var(--google-blue-300))}}.tab-icon{-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-tabs-icon-size,var(--cr-icon-size));background-color:var(--cr-secondary-text-color);display:none;height:var(--cr-tabs-icon-size,var(--cr-icon-size));margin-inline-end:var(--cr-tabs-icon-margin-end,var(--cr-icon-size));width:var(--cr-tabs-icon-size,var(--cr-icon-size))}.selected .tab-icon{background-color:var(--cr-tabs-selected-color,var(--google-blue-600))}@media (prefers-color-scheme:dark){.selected .tab-icon{background-color:var(--cr-tabs-selected-color,var(--google-blue-300))}}.tab-indicator,.tab-indicator-background{bottom:0;height:var(--cr-tabs-selection-bar-width,2px);left:var(--cr-tabs-tab-inline-padding,0);position:absolute;right:var(--cr-tabs-tab-inline-padding,0)}.tab-indicator{border-top-left-radius:var(--cr-tabs-selection-bar-radius,var(--cr-tabs-selection-bar-width,2px));border-top-right-radius:var(--cr-tabs-selection-bar-radius,var(--cr-tabs-selection-bar-width,2px));opacity:0;transform-origin:left center;transition:transform}.selected .tab-indicator{background:var(--cr-tabs-selected-color,var(--google-blue-600));opacity:1}.tab-indicator.expand{transition-duration:150ms;transition-timing-function:cubic-bezier(.4,0,1,1)}.tab-indicator.contract{transition-duration:180ms;transition-timing-function:cubic-bezier(0,0,.2,1)}.tab-indicator-background{background:var(--cr-tabs-unselected-color,var(--google-blue-600));opacity:var(--cr-tabs-selection-bar-unselected-opacity,0);z-index:-1}@media (prefers-color-scheme:dark){.tab-indicator-background{background:var(--cr-tabs-unselected-color,var(--google-blue-300))}.selected .tab-indicator{background:var(--cr-tabs-selected-color,var(--google-blue-300))}}@media (forced-colors:active){.tab-indicator{background:SelectedItem}}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$1() {
    return html `${this.tabNames.map((item, index) => html `
<div role="tab"
    class="tab ${this.getSelectedClass_(index)}"
    aria-selected="${this.getAriaSelected_(index)}"
    tabindex="${this.getTabindex_(index)}"
    data-index="${index}" @click="${this.onTabClick_}">
  <div class="tab-icon" .style="${this.getIconStyle_(index)}"></div>
  ${item}
  <div class="tab-indicator-background"></div>
  <div class="tab-indicator"></div>
</div>
`)}`;
}

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'cr-tabs' is a control used for selecting different sections or
 * tabs. cr-tabs was created to replace paper-tabs and paper-tab. cr-tabs
 * displays the name of each tab provided by |tabs|. A 'selected-changed' event
 * is fired any time |selected| is changed.
 *
 * cr-tabs takes its #selectionBar animation from paper-tabs.
 *
 * Keyboard behavior
 *   - Home, End, ArrowLeft and ArrowRight changes the tab selection
 *
 * Known limitations
 *   - no "disabled" state for the cr-tabs as a whole or individual tabs
 *   - cr-tabs does not accept any <slot> (not necessary as of this writing)
 *   - no horizontal scrolling, it is assumed that tabs always fit in the
 *     available space
 */
const NONE_SELECTED = -1;
class CrTabsElement extends CrLitElement {
    static get is() {
        return 'cr-tabs';
    }
    static get styles() {
        return getCss$2();
    }
    render() {
        return getHtml$1.bind(this)();
    }
    static get properties() {
        return {
            // Optional icon urls displayed in each tab.
            tabIcons: {
                type: Array,
            },
            // Tab names displayed in each tab.
            tabNames: {
                type: Array,
            },
            /** Index of the selected tab. */
            selected: {
                type: Number,
                notify: true,
            },
        };
    }
    #tabIcons_accessor_storage = [];
    get tabIcons() { return this.#tabIcons_accessor_storage; }
    set tabIcons(value) { this.#tabIcons_accessor_storage = value; }
    #tabNames_accessor_storage = [];
    get tabNames() { return this.#tabNames_accessor_storage; }
    set tabNames(value) { this.#tabNames_accessor_storage = value; }
    #selected_accessor_storage = NONE_SELECTED;
    get selected() { return this.#selected_accessor_storage; }
    set selected(value) { this.#selected_accessor_storage = value; }
    isRtl_ = false;
    connectedCallback() {
        super.connectedCallback();
        this.isRtl_ = this.matches(':host-context([dir=rtl]) cr-tabs');
    }
    firstUpdated() {
        this.setAttribute('role', 'tablist');
        this.addEventListener('keydown', this.onKeyDown_.bind(this));
    }
    updated(changedProperties) {
        super.updated(changedProperties);
        if (changedProperties.has('selected')) {
            this.onSelectedChanged_(this.selected, changedProperties.get('selected'));
        }
    }
    getAriaSelected_(index) {
        return index === this.selected ? 'true' : 'false';
    }
    getIconStyle_(index) {
        const icon = this.tabIcons[index];
        return icon ? `-webkit-mask-image: url(${icon}); display: block;` : '';
    }
    getTabindex_(index) {
        return index === this.selected ? '0' : '-1';
    }
    getSelectedClass_(index) {
        return index === this.selected ? 'selected' : '';
    }
    onSelectedChanged_(newSelected, oldSelected) {
        if (newSelected === NONE_SELECTED || oldSelected === NONE_SELECTED ||
            oldSelected === undefined) {
            return;
        }
        const tabs = this.shadowRoot.querySelectorAll('.tab');
        if (tabs.length <= oldSelected) {
            return;
        }
        const oldTabRect = tabs[oldSelected].getBoundingClientRect();
        const newTabRect = tabs[newSelected].getBoundingClientRect();
        const newIndicator = tabs[newSelected].querySelector('.tab-indicator');
        newIndicator.classList.remove('expand', 'contract');
        // Make new indicator look like it is the old indicator.
        this.updateIndicator_(newIndicator, newTabRect, oldTabRect.left, oldTabRect.width);
        newIndicator.getBoundingClientRect(); // Force repaint.
        // Expand to cover both the previous selected tab, the newly selected tab,
        // and everything in between.
        newIndicator.classList.add('expand');
        newIndicator.addEventListener('transitionend', e => this.onIndicatorTransitionEnd_(e), { once: true });
        const leftmostEdge = Math.min(oldTabRect.left, newTabRect.left);
        const fullWidth = newTabRect.left > oldTabRect.left ?
            newTabRect.right - oldTabRect.left :
            oldTabRect.right - newTabRect.left;
        this.updateIndicator_(newIndicator, newTabRect, leftmostEdge, fullWidth);
    }
    async onKeyDown_(e) {
        const count = this.tabNames.length;
        let newSelection;
        if (e.key === 'Home') {
            newSelection = 0;
        }
        else if (e.key === 'End') {
            newSelection = count - 1;
        }
        else if (e.key === 'ArrowLeft' || e.key === 'ArrowRight') {
            const delta = e.key === 'ArrowLeft' ? (this.isRtl_ ? 1 : -1) :
                (this.isRtl_ ? -1 : 1);
            newSelection = (count + this.selected + delta) % count;
        }
        else {
            return;
        }
        e.preventDefault();
        e.stopPropagation();
        this.selected = newSelection;
        await this.updateComplete;
        this.shadowRoot.querySelector('.tab.selected').focus();
    }
    onIndicatorTransitionEnd_(event) {
        const indicator = event.target;
        indicator.classList.replace('expand', 'contract');
        indicator.style.transform = `translateX(0) scaleX(1)`;
    }
    onTabClick_(e) {
        const target = e.currentTarget;
        this.selected = Number(target.dataset['index']);
    }
    updateIndicator_(indicator, originRect, newLeft, newWidth) {
        const leftDiff = 100 * (newLeft - originRect.left) / originRect.width;
        const widthRatio = newWidth / originRect.width;
        const transform = `translateX(${leftDiff}%) scaleX(${widthRatio})`;
        indicator.style.transform = transform;
    }
}
customElements.define(CrTabsElement.is, CrTabsElement);

let instance$1 = null;
function getCss$1() {
    return instance$1 || (instance$1 = [...[getCss$x()], css `:host{--cr-primary-text-color:var(--color-tab-search-primary-foreground);--cr-secondary-text-color:var(--color-tab-search-secondary-foreground);--cr-separator-color:var(--color-tab-search-divider);--cr-tabs-flex:1;--cr-tabs-focus-outline-offset:-4px;--cr-tabs-font-size:12px;--cr-tabs-icon-margin-end:4px;--cr-tabs-icon-size:16px;--cr-tabs-selected-color:var(--color-tab-search-selected);--cr-tabs-selection-bar-radius:0;--cr-tabs-selection-bar-unselected-opacity:1;--cr-tabs-unselected-color:var(--color-tab-search-divider);--mwb-background-color:var(--color-tab-search-background);--mwb-icon-button-fill-color:var(--color-tab-search-secondary-foreground);--mwb-list-item-hover-background-color:var(--cr-hover-background-color);--mwb-list-item-selected-background-color:var(--cr-active-background-color);--mwb-primary-text-font-size:12px;--mwb-primary-text-font-weight:500;--mwb-secondary-text-font-size:11px;--mwb-secondary-text-font-weight:400;--mwb-scrollbar-thumb-color:var(--color-tab-search-scrollbar-thumb);--mwb-scrollbar-thumb-hover-color:var(--color-tab-search-scrollbar-thumb);--mwb-scrollbar-track-color:transparent;user-select:none}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml() {
    // clang-format off
    return html `
${(this.tabOrganizationEnabled_ || this.declutterEnabled_) ? html `
  <cr-tabs
      .tabNames="${this.tabNames_}"
      .selected="${this.sectionToIndex_(this.selectedTabSection_)}"
      @selected-changed="${this.onSelectedTabIndexChanged_}">
  </cr-tabs>
  <cr-page-selector
      .selected="${this.sectionToIndex_(this.selectedTabSection_)}">
    <tab-search-page available-height="${this.availableHeight_}">
    </tab-search-page>
    ${getOrganizationPage(this.tabOrganizationEnabled_, this.declutterEnabled_, this.availableHeight_)}
  </cr-page-selector>
` : html `
  <tab-search-page available-height="${this.availableHeight_}">
  </tab-search-page>
`}`;
    // clang-format on
}
function getOrganizationPage(organizationEnabled, declutterEnabled, availableHeight) {
    if (organizationEnabled && declutterEnabled) {
        return html `
        <tab-organization-selector available-height="${availableHeight}">
        </tab-organization-selector>`;
    }
    else if (organizationEnabled) {
        return html `
        <auto-tab-groups-page available-height="${availableHeight}">
        </auto-tab-groups-page>`;
    }
    else if (declutterEnabled) {
        return html `
        <declutter-page available-height="${availableHeight}">
        </declutter-page>`;
    }
    else {
        return '';
    }
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class TabSearchAppElement extends CrLitElement {
    static get is() {
        return 'tab-search-app';
    }
    static get properties() {
        return {
            selectedTabSection_: { type: Object },
            tabNames_: { type: Array },
            tabOrganizationEnabled_: { type: Boolean },
            declutterEnabled_: { type: Boolean },
            availableHeight_: { type: Number },
        };
    }
    apiProxy_ = TabSearchApiProxyImpl.getInstance();
    listenerIds_ = [];
    documentVisibilityChangedListener_;
    #selectedTabSection__accessor_storage = TabSearchSection.kSearch;
    get selectedTabSection_() { return this.#selectedTabSection__accessor_storage; }
    set selectedTabSection_(value) { this.#selectedTabSection__accessor_storage = value; }
    #tabNames__accessor_storage = [
        loadTimeData.getString('tabSearchTabName'),
        loadTimeData.getString('tabOrganizationTabName'),
    ];
    get tabNames_() { return this.#tabNames__accessor_storage; }
    set tabNames_(value) { this.#tabNames__accessor_storage = value; }
    #tabOrganizationEnabled__accessor_storage = loadTimeData.getBoolean('tabOrganizationEnabled');
    get tabOrganizationEnabled_() { return this.#tabOrganizationEnabled__accessor_storage; }
    set tabOrganizationEnabled_(value) { this.#tabOrganizationEnabled__accessor_storage = value; }
    #declutterEnabled__accessor_storage = loadTimeData.getBoolean('declutterEnabled');
    get declutterEnabled_() { return this.#declutterEnabled__accessor_storage; }
    set declutterEnabled_(value) { this.#declutterEnabled__accessor_storage = value; }
    #availableHeight__accessor_storage = 0;
    get availableHeight_() { return this.#availableHeight__accessor_storage; }
    set availableHeight_(value) { this.#availableHeight__accessor_storage = value; }
    static get styles() {
        return getCss$1();
    }
    render() {
        return getHtml.bind(this)();
    }
    constructor() {
        super();
        this.documentVisibilityChangedListener_ = () => {
            if (document.visibilityState === 'visible') {
                this.updateAvailableHeight_();
            }
        };
    }
    connectedCallback() {
        super.connectedCallback();
        this.apiProxy_.getTabSearchSection().then(({ section }) => this.selectedTabSection_ = section);
        const callbackRouter = this.apiProxy_.getCallbackRouter();
        this.listenerIds_.push(callbackRouter.tabSearchSectionChanged.addListener(this.onTabSectionChanged_.bind(this)));
        this.listenerIds_.push(callbackRouter.tabOrganizationEnabledChanged.addListener(this.onTabOrganizationEnabledChanged_.bind(this)));
        this.updateAvailableHeight_();
        document.addEventListener('visibilitychange', this.documentVisibilityChangedListener_);
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.listenerIds_.forEach(id => this.apiProxy_.getCallbackRouter().removeListener(id));
        document.removeEventListener('visibilitychange', this.documentVisibilityChangedListener_);
    }
    updateAvailableHeight_() {
        this.apiProxy_.getProfileData().then(({ profileData }) => {
            // In rare cases there is no browser window. I suspect this happens during
            // browser shutdown.
            if (!profileData.windows || profileData.windows.length === 0) {
                return;
            }
            // TODO(crbug.com/40855872): Determine why no active window is reported
            // in some cases on ChromeOS and Linux.
            const activeWindow = profileData.windows.find((t) => t.active);
            assert(profileData.windows[0]);
            this.availableHeight_ = (activeWindow ?? profileData.windows[0]).height;
        });
    }
    onTabSectionChanged_(section) {
        this.selectedTabSection_ = section;
        if (section === TabSearchSection.kOrganize) {
            const organizationSelector = this.shadowRoot.querySelector('tab-organization-selector');
            if (organizationSelector) {
                organizationSelector.maybeLogFeatureShow();
            }
        }
    }
    onTabOrganizationEnabledChanged_(enabled) {
        this.tabOrganizationEnabled_ = enabled;
    }
    sectionToIndex_(section) {
        switch (section) {
            case TabSearchSection.kNone:
                return -1;
            case TabSearchSection.kSearch:
                return 0;
            case TabSearchSection.kOrganize:
                return 1;
            default:
                assertNotReached();
        }
    }
    indexToSection(index) {
        switch (index) {
            case -1:
                return TabSearchSection.kNone;
            case 0:
                return TabSearchSection.kSearch;
            case 1:
                return TabSearchSection.kOrganize;
            default:
                assertNotReached();
        }
    }
    onSelectedTabIndexChanged_(e) {
        this.selectedTabSection_ = this.indexToSection(e.detail.value);
        if (this.selectedTabSection_ === TabSearchSection.kOrganize &&
            !this.declutterEnabled_) {
            const autoTabGroupsPage = this.shadowRoot.querySelector('auto-tab-groups-page');
            autoTabGroupsPage.classList.toggle('changed-state', false);
        }
    }
}
customElements.define(TabSearchAppElement.is, TabSearchAppElement);

let instance = null;
function getCss() {
    return instance || (instance = [...[], css `:host{display:block;overflow-x:hidden;overflow-y:auto;position:relative}#container>::slotted(*){box-sizing:border-box;contain-intrinsic-size:var(--list-item-size,100px) auto;content-visibility:auto;width:100%}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'lazy-list' is a component optimized for showing a list of
 * items that overflows the view and requires scrolling. For performance
 * reasons, the DOM items are incrementally added to the view as the user
 * scrolls through the list. The component expects a `scrollTarget` property
 * to be specified indicating the scrolling container. This container is
 * used for observing scroll events and resizes. The container should have
 * bounded height so that lazy-list can determine how many HTML elements to
 * render initially.
 * If using a container that can shrink arbitrarily small to the height of the
 * contents, a 'minViewportHeight' property should also be provided specifying
 * the minimum viewport height to try to fill with items.
 * Each list item's HTML element is created using the `template` property,
 * which should be set to a function returning a TemplateResult corresponding
 * to a passed in list item and selection index.
 * Set `listItemHost` to the `this` context for any event handlers in this
 * template. If this property is not provided, lazy-list is assumed to be
 * residing in a ShadowRoot, and the shadowRoot's |host| is used.
 * The `items` property specifies an array of list item data.
 * The `itemSize` property should be set to an estimate of the list item size.
 * This is used when setting contain-intrinsic-size styling for list items.
 * To restore focus to a specific item if it is focused when the items
 * array changes, set `restoreFocusItem` to that HTMLElement. If the element
 * is focused when the items array is updated, focus will be restored.
 */
class LazyListElement extends CrLitElement {
    static get is() {
        return 'lazy-list';
    }
    static get styles() {
        return getCss();
    }
    render() {
        const host = this.listItemHost === undefined ?
            this.getRootNode().host :
            this.listItemHost;
        // Render items into light DOM using the client provided template
        render(this.items.slice(0, this.numItemsDisplayed_).map((item, index) => {
            return this.template(item, index);
        }), this, {
            host: host,
        });
        // Render container + slot into shadow DOM
        return html `<div id="container"><slot id="slot"></slot></div>`;
    }
    static get properties() {
        return {
            items: { type: Array },
            itemSize: { type: Number },
            listItemHost: { type: Object },
            minViewportHeight: { type: Number },
            scrollTarget: { type: Object },
            restoreFocusElement: { type: Object },
            template: { type: Object },
            numItemsDisplayed_: {
                state: true,
                type: Number,
            },
        };
    }
    #items_accessor_storage = [];
    get items() { return this.#items_accessor_storage; }
    set items(value) { this.#items_accessor_storage = value; }
    #itemSize_accessor_storage = 100;
    get itemSize() { return this.#itemSize_accessor_storage; }
    set itemSize(value) { this.#itemSize_accessor_storage = value; }
    #listItemHost_accessor_storage;
    get listItemHost() { return this.#listItemHost_accessor_storage; }
    set listItemHost(value) { this.#listItemHost_accessor_storage = value; }
    #minViewportHeight_accessor_storage;
    get minViewportHeight() { return this.#minViewportHeight_accessor_storage; }
    set minViewportHeight(value) { this.#minViewportHeight_accessor_storage = value; }
    #scrollTarget_accessor_storage = document.documentElement;
    get scrollTarget() { return this.#scrollTarget_accessor_storage; }
    set scrollTarget(value) { this.#scrollTarget_accessor_storage = value; }
    #restoreFocusElement_accessor_storage = null;
    get restoreFocusElement() { return this.#restoreFocusElement_accessor_storage; }
    set restoreFocusElement(value) { this.#restoreFocusElement_accessor_storage = value; }
    #template_accessor_storage = () => html ``;
    get template() { return this.#template_accessor_storage; }
    set template(value) { this.#template_accessor_storage = value; }
    #numItemsDisplayed__accessor_storage = 0;
    get numItemsDisplayed_() { return this.#numItemsDisplayed__accessor_storage; }
    set numItemsDisplayed_(value) { this.#numItemsDisplayed__accessor_storage = value; }
    // Internal state
    lastRenderedHeight_ = 0;
    resizeObserver_ = null;
    scrollListener_ = () => this.onScroll_();
    willUpdate(changedProperties) {
        super.willUpdate(changedProperties);
        if (changedProperties.has('items')) {
            this.numItemsDisplayed_ = this.items.length === 0 ?
                0 :
                Math.min(this.numItemsDisplayed_, this.items.length);
        }
        if (changedProperties.has('itemSize')) {
            this.style.setProperty('--list-item-size', `${this.itemSize}px`);
        }
    }
    updated(changedProperties) {
        super.updated(changedProperties);
        let itemsChanged = false;
        if (changedProperties.has('items') ||
            changedProperties.has('minViewportHeight')) {
            const previous = changedProperties.get('items');
            if (previous !== undefined || this.items.length !== 0) {
                this.onItemsChanged_();
                itemsChanged = true;
            }
        }
        if (changedProperties.has('scrollTarget')) {
            this.addRemoveScrollTargetListeners_(changedProperties.get('scrollTarget') || null);
            // Only re-render if there are items to display and we are not already
            // re-rendering for the items.
            if (this.scrollTarget && this.items.length > 0 && !itemsChanged) {
                this.fillCurrentViewport();
            }
        }
    }
    // Public API
    // Forces the list to fill the current viewport. Called when the viewport
    // size or position changes.
    fillCurrentViewport() {
        if (this.items.length === 0) {
            return Promise.resolve();
        }
        // Update the height if the previous height calculation was done when this
        // element was not visible or if new DOM items were added.
        return this.update_(this.$.container.style.height === '0px');
    }
    // Forces the list to render |numItems| items. If |numItems| are already
    // rendered, this is a no-op.
    async ensureItemRendered(index) {
        if (index < this.numItemsDisplayed_) {
            return this.$.slot.assignedElements()[index];
        }
        assert(index < this.items.length);
        await this.updateNumItemsDisplayed_(index + 1);
        return this.$.slot.assignedElements()[index];
    }
    // Private methods
    addRemoveScrollTargetListeners_(oldTarget) {
        if (oldTarget) {
            oldTarget.removeEventListener('scroll', this.scrollListener_);
            assert(this.resizeObserver_);
            this.resizeObserver_.disconnect();
        }
        if (this.scrollTarget) {
            this.scrollTarget.addEventListener('scroll', this.scrollListener_);
            this.resizeObserver_ = new ResizeObserver(() => {
                requestAnimationFrame(() => {
                    const newHeight = this.getViewHeight_();
                    if (newHeight !== 0 && newHeight !== this.lastRenderedHeight_) {
                        this.fillCurrentViewport();
                    }
                });
            });
            this.resizeObserver_.observe(this.scrollTarget);
        }
    }
    shouldRestoreFocus_() {
        if (!this.restoreFocusElement) {
            return false;
        }
        const active = getDeepActiveElement();
        return this.restoreFocusElement === active ||
            (!!this.restoreFocusElement.shadowRoot &&
                this.restoreFocusElement.shadowRoot.activeElement === active);
    }
    async onItemsChanged_() {
        if (this.items.length > 0) {
            const restoreFocus = this.shouldRestoreFocus_();
            await this.update_(true);
            if (restoreFocus) {
                // Async to allow clients to update in response to viewport-filled.
                setTimeout(() => {
                    this.restoreFocusElement.focus();
                    this.fire('focus-restored-for-test');
                }, 0);
            }
        }
        else {
            // Update the container height to 0 since there are no items.
            this.$.container.style.height = '0px';
            this.fire('viewport-filled');
        }
    }
    getViewHeight_() {
        return this.scrollTarget.scrollTop +
            Math.max(this.minViewportHeight || 0, this.scrollTarget.offsetHeight);
    }
    async update_(forceUpdateHeight) {
        if (!this.scrollTarget) {
            return;
        }
        const height = this.getViewHeight_();
        if (height === 0) {
            return;
        }
        const added = await this.fillViewHeight_(height);
        if (added || forceUpdateHeight) {
            await this.updateHeight_();
            this.fire('viewport-filled');
        }
    }
    /**
     * @return Whether DOM items were created or not.
     */
    async fillViewHeight_(height) {
        this.fire('fill-height-start');
        this.lastRenderedHeight_ = height;
        // Ensure we have added enough DOM items so that we are able to estimate
        // item average height.
        assert(this.items.length);
        const initialDomItemCount = this.$.slot.assignedElements().length;
        if (initialDomItemCount === 0) {
            await this.updateNumItemsDisplayed_(1);
        }
        const itemHeight = this.domItemAverageHeight_();
        // If this happens, the math below will be incorrect and we will render
        // all items. So return early, and correct |lastRenderedHeight_|.
        if (itemHeight === 0) {
            this.lastRenderedHeight_ = 0;
            return false;
        }
        const desiredDomItemCount = Math.min(Math.ceil(height / itemHeight), this.items.length);
        if (desiredDomItemCount > this.numItemsDisplayed_) {
            await this.updateNumItemsDisplayed_(desiredDomItemCount);
        }
        const added = initialDomItemCount !== desiredDomItemCount;
        if (added) {
            this.fire('fill-height-end');
        }
        return added;
    }
    async updateNumItemsDisplayed_(itemsToDisplay) {
        this.numItemsDisplayed_ = itemsToDisplay;
        await this.updateComplete;
    }
    /**
     * @return The average DOM item height.
     */
    domItemAverageHeight_() {
        // This logic should only be invoked if the list is non-empty and at least
        // one DOM item has been rendered so that an item average height can be
        // estimated. This is ensured by the callers.
        assert(this.items.length > 0);
        const domItems = this.$.slot.assignedElements();
        assert(domItems.length > 0);
        const lastDomItem = domItems.at(-1);
        return (lastDomItem.offsetTop + lastDomItem.offsetHeight) / domItems.length;
    }
    /**
     * Sets the height of the component based on an estimated average DOM item
     * height and the total number of items.
     */
    async updateHeight_() {
        // Await 1 cycle to ensure any child Lit elements have time to finish
        // rendering, or the height estimated below will be incorrect.
        await new Promise(resolve => setTimeout(resolve, 0));
        const estScrollHeight = this.items.length > 0 ?
            this.items.length * this.domItemAverageHeight_() :
            0;
        this.$.container.style.height = estScrollHeight + 'px';
    }
    /**
     * Adds additional DOM items as needed to fill the view based on user scroll
     * interactions.
     */
    async onScroll_() {
        const scrollTop = this.scrollTarget.scrollTop;
        if (scrollTop <= 0 || this.numItemsDisplayed_ === this.items.length) {
            return;
        }
        await this.fillCurrentViewport();
    }
}
customElements.define(LazyListElement.is, LazyListElement);

export { AutoTabGroupsPageElement, AutoTabGroupsResultsElement, CrInputElement, DeclutterPageElement, LazyListElement, SEARCH_QUERY_MAX_LENGTH, TIMEOUT_MS, TabData, Color as TabGroupColor, TabItemType, TabOrganizationError, TabOrganizationFeature, TabOrganizationModelStrategy, TabOrganizationSelectorButtonElement, TabOrganizationSelectorElement, TabOrganizationState, TabSearchApiProxyImpl, TabSearchAppElement, TabSearchGroupItemElement, TabSearchItemElement, TabSearchPageElement, TabSearchSection, TabSearchSyncBrowserProxyImpl, TitleItem, UserFeedback, getInstance as getAnnouncerInstance, getHostname, getTabGroupTitle, getTitle, search };
//# sourceMappingURL=tab_search.rollup.js.map
