// components/ip_protection/mojom/core_test.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('ipProtection.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ipProtection.mojom.CoreControlTestPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ipProtection.mojom.CoreControlTest.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ipProtection.mojom.CoreControlTestInterface }
 */
ipProtection.mojom.CoreControlTestRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ipProtection.mojom.CoreControlTestPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ipProtection.mojom.CoreControlTestPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ipProtection.mojom.CoreControlTestPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        bsaToken: ?ipProtection.mojom.BlindSignedAuthToken,
        tryAgainAfter: ?mojoBase.mojom.Time,
   *  }>}
   */

  verifyIpProtectionCoreHostForTesting() {
    return this.proxy.sendMessage(
        0,
        ipProtection.mojom.CoreControlTest_VerifyIpProtectionCoreHostForTesting_ParamsSpec.$,
        ipProtection.mojom.CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        value: !boolean,
   *  }>}
   */

  isIpProtectionEnabledForTesting() {
    return this.proxy.sendMessage(
        1,
        ipProtection.mojom.CoreControlTest_IsIpProtectionEnabledForTesting_ParamsSpec.$,
        ipProtection.mojom.CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !ipProtection.mojom.ProxyLayer } proxyLayer
   * @param { !string } geoId
   * @return {!Promise<{
        token: ?ipProtection.mojom.BlindSignedAuthToken,
   *  }>}
   */

  getAuthTokenForTesting(
      proxyLayer,
      geoId) {
    return this.proxy.sendMessage(
        2,
        ipProtection.mojom.CoreControlTest_GetAuthTokenForTesting_ParamsSpec.$,
        ipProtection.mojom.CoreControlTest_GetAuthTokenForTesting_ResponseParamsSpec.$,
        [
          proxyLayer,
          geoId
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } firstPartyUrl
   * @return {!Promise<{
        hasException: !boolean,
   *  }>}
   */

  hasTrackingProtectionExceptionForTesting(
      firstPartyUrl) {
    return this.proxy.sendMessage(
        3,
        ipProtection.mojom.CoreControlTest_HasTrackingProtectionExceptionForTesting_ParamsSpec.$,
        ipProtection.mojom.CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParamsSpec.$,
        [
          firstPartyUrl
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CoreControlTest
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ipProtection.mojom.CoreControlTestReceiver = class {
  /**
   * @param {!ipProtection.mojom.CoreControlTestInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ipProtection.mojom.CoreControlTestRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ipProtection.mojom.CoreControlTestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ipProtection.mojom.CoreControlTestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ipProtection.mojom.CoreControlTest_VerifyIpProtectionCoreHostForTesting_ParamsSpec.$,
        ipProtection.mojom.CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParamsSpec.$,
        impl.verifyIpProtectionCoreHostForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ipProtection.mojom.CoreControlTest_IsIpProtectionEnabledForTesting_ParamsSpec.$,
        ipProtection.mojom.CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParamsSpec.$,
        impl.isIpProtectionEnabledForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ipProtection.mojom.CoreControlTest_GetAuthTokenForTesting_ParamsSpec.$,
        ipProtection.mojom.CoreControlTest_GetAuthTokenForTesting_ResponseParamsSpec.$,
        impl.getAuthTokenForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ipProtection.mojom.CoreControlTest_HasTrackingProtectionExceptionForTesting_ParamsSpec.$,
        ipProtection.mojom.CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParamsSpec.$,
        impl.hasTrackingProtectionExceptionForTesting.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ipProtection.mojom.CoreControlTest = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ip_protection.mojom.CoreControlTest";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ipProtection.mojom.CoreControlTestRemote}
   * @export
   */
  static getRemote() {
    let remote = new ipProtection.mojom.CoreControlTestRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CoreControlTest
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ipProtection.mojom.CoreControlTestCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ipProtection.mojom.CoreControlTestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ipProtection.mojom.CoreControlTestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.verifyIpProtectionCoreHostForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ipProtection.mojom.CoreControlTest_VerifyIpProtectionCoreHostForTesting_ParamsSpec.$,
        ipProtection.mojom.CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParamsSpec.$,
        this.verifyIpProtectionCoreHostForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isIpProtectionEnabledForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ipProtection.mojom.CoreControlTest_IsIpProtectionEnabledForTesting_ParamsSpec.$,
        ipProtection.mojom.CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParamsSpec.$,
        this.isIpProtectionEnabledForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAuthTokenForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ipProtection.mojom.CoreControlTest_GetAuthTokenForTesting_ParamsSpec.$,
        ipProtection.mojom.CoreControlTest_GetAuthTokenForTesting_ResponseParamsSpec.$,
        this.getAuthTokenForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.hasTrackingProtectionExceptionForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ipProtection.mojom.CoreControlTest_HasTrackingProtectionExceptionForTesting_ParamsSpec.$,
        ipProtection.mojom.CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParamsSpec.$,
        this.hasTrackingProtectionExceptionForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ipProtection.mojom.CoreControlTest_VerifyIpProtectionCoreHostForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ipProtection.mojom.CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ipProtection.mojom.CoreControlTest_IsIpProtectionEnabledForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ipProtection.mojom.CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ipProtection.mojom.CoreControlTest_GetAuthTokenForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ipProtection.mojom.CoreControlTest_GetAuthTokenForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ipProtection.mojom.CoreControlTest_HasTrackingProtectionExceptionForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ipProtection.mojom.CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ipProtection.mojom.CoreControlTest_VerifyIpProtectionCoreHostForTesting_ParamsSpec.$,
    'CoreControlTest_VerifyIpProtectionCoreHostForTesting_Params',
    [
    ],
    [[0, 8],]);





/** @record */
ipProtection.mojom.CoreControlTest_VerifyIpProtectionCoreHostForTesting_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ipProtection.mojom.CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParamsSpec.$,
    'CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParams',
    [
      mojo.internal.StructField(
        'bsaToken', 0,
        0,
        ipProtection.mojom.BlindSignedAuthTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tryAgainAfter', 8,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ipProtection.mojom.CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParams = class {
  constructor() {
    /** @export { (ipProtection.mojom.BlindSignedAuthToken|undefined) } */
    this.bsaToken;
    /** @export { (mojoBase.mojom.Time|undefined) } */
    this.tryAgainAfter;
  }
};



mojo.internal.Struct(
    ipProtection.mojom.CoreControlTest_IsIpProtectionEnabledForTesting_ParamsSpec.$,
    'CoreControlTest_IsIpProtectionEnabledForTesting_Params',
    [
    ],
    [[0, 8],]);





/** @record */
ipProtection.mojom.CoreControlTest_IsIpProtectionEnabledForTesting_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ipProtection.mojom.CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParamsSpec.$,
    'CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ipProtection.mojom.CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.value;
  }
};



mojo.internal.Struct(
    ipProtection.mojom.CoreControlTest_GetAuthTokenForTesting_ParamsSpec.$,
    'CoreControlTest_GetAuthTokenForTesting_Params',
    [
      mojo.internal.StructField(
        'proxyLayer', 0,
        0,
        ipProtection.mojom.ProxyLayerSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'geoId', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ipProtection.mojom.CoreControlTest_GetAuthTokenForTesting_Params = class {
  constructor() {
    /** @export { !ipProtection.mojom.ProxyLayer } */
    this.proxyLayer;
    /** @export { !string } */
    this.geoId;
  }
};



mojo.internal.Struct(
    ipProtection.mojom.CoreControlTest_GetAuthTokenForTesting_ResponseParamsSpec.$,
    'CoreControlTest_GetAuthTokenForTesting_ResponseParams',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        ipProtection.mojom.BlindSignedAuthTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ipProtection.mojom.CoreControlTest_GetAuthTokenForTesting_ResponseParams = class {
  constructor() {
    /** @export { (ipProtection.mojom.BlindSignedAuthToken|undefined) } */
    this.token;
  }
};



mojo.internal.Struct(
    ipProtection.mojom.CoreControlTest_HasTrackingProtectionExceptionForTesting_ParamsSpec.$,
    'CoreControlTest_HasTrackingProtectionExceptionForTesting_Params',
    [
      mojo.internal.StructField(
        'firstPartyUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ipProtection.mojom.CoreControlTest_HasTrackingProtectionExceptionForTesting_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.firstPartyUrl;
  }
};



mojo.internal.Struct(
    ipProtection.mojom.CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParamsSpec.$,
    'CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParams',
    [
      mojo.internal.StructField(
        'hasException', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ipProtection.mojom.CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.hasException;
  }
};

