// components/ip_protection/mojom/core_test.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'components/ip_protection/mojom/core_test.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ipProtection.mojom');
  var data_types$ =
      mojo.internal.exposeNamespace('ipProtection.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/ip_protection/mojom/data_types.mojom', 'data_types.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../mojo/public/mojom/base/time.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../url/mojom/url.mojom.js');
  }



  function CoreControlTest_VerifyIpProtectionCoreHostForTesting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CoreControlTest_VerifyIpProtectionCoreHostForTesting_Params.prototype.initDefaults_ = function() {
  };
  CoreControlTest_VerifyIpProtectionCoreHostForTesting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CoreControlTest_VerifyIpProtectionCoreHostForTesting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CoreControlTest_VerifyIpProtectionCoreHostForTesting_Params.encodedSize = codec.kStructHeaderSize + 0;

  CoreControlTest_VerifyIpProtectionCoreHostForTesting_Params.decode = function(decoder) {
    var packed;
    var val = new CoreControlTest_VerifyIpProtectionCoreHostForTesting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  CoreControlTest_VerifyIpProtectionCoreHostForTesting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CoreControlTest_VerifyIpProtectionCoreHostForTesting_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParams.prototype.initDefaults_ = function() {
    this.bsaToken = null;
    this.tryAgainAfter = null;
  };
  CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParams.bsaToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, data_types$.BlindSignedAuthToken, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParams.tryAgainAfter
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.Time, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.bsaToken =
        decoder.decodeStructPointer(data_types$.BlindSignedAuthToken);
    val.tryAgainAfter =
        decoder.decodeStructPointer(time$.Time);
    return val;
  };

  CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(data_types$.BlindSignedAuthToken, val.bsaToken);
    encoder.encodeStructPointer(time$.Time, val.tryAgainAfter);
  };
  function CoreControlTest_IsIpProtectionEnabledForTesting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CoreControlTest_IsIpProtectionEnabledForTesting_Params.prototype.initDefaults_ = function() {
  };
  CoreControlTest_IsIpProtectionEnabledForTesting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CoreControlTest_IsIpProtectionEnabledForTesting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CoreControlTest_IsIpProtectionEnabledForTesting_Params.encodedSize = codec.kStructHeaderSize + 0;

  CoreControlTest_IsIpProtectionEnabledForTesting_Params.decode = function(decoder) {
    var packed;
    var val = new CoreControlTest_IsIpProtectionEnabledForTesting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  CoreControlTest_IsIpProtectionEnabledForTesting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CoreControlTest_IsIpProtectionEnabledForTesting_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParams.prototype.initDefaults_ = function() {
    this.value = false;
  };
  CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.value = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.value & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CoreControlTest_GetAuthTokenForTesting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CoreControlTest_GetAuthTokenForTesting_Params.prototype.initDefaults_ = function() {
    this.proxyLayer = 0;
    this.geoId = null;
  };
  CoreControlTest_GetAuthTokenForTesting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CoreControlTest_GetAuthTokenForTesting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CoreControlTest_GetAuthTokenForTesting_Params.proxyLayer
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, data_types$.ProxyLayer);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CoreControlTest_GetAuthTokenForTesting_Params.geoId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CoreControlTest_GetAuthTokenForTesting_Params.encodedSize = codec.kStructHeaderSize + 16;

  CoreControlTest_GetAuthTokenForTesting_Params.decode = function(decoder) {
    var packed;
    var val = new CoreControlTest_GetAuthTokenForTesting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.proxyLayer =
        decoder.decodeStruct(new codec.Enum(data_types$.ProxyLayer));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.geoId =
        decoder.decodeStruct(codec.String);
    return val;
  };

  CoreControlTest_GetAuthTokenForTesting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CoreControlTest_GetAuthTokenForTesting_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.proxyLayer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.geoId);
  };
  function CoreControlTest_GetAuthTokenForTesting_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CoreControlTest_GetAuthTokenForTesting_ResponseParams.prototype.initDefaults_ = function() {
    this.token = null;
  };
  CoreControlTest_GetAuthTokenForTesting_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CoreControlTest_GetAuthTokenForTesting_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CoreControlTest_GetAuthTokenForTesting_ResponseParams.token
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, data_types$.BlindSignedAuthToken, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CoreControlTest_GetAuthTokenForTesting_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  CoreControlTest_GetAuthTokenForTesting_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CoreControlTest_GetAuthTokenForTesting_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStructPointer(data_types$.BlindSignedAuthToken);
    return val;
  };

  CoreControlTest_GetAuthTokenForTesting_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CoreControlTest_GetAuthTokenForTesting_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(data_types$.BlindSignedAuthToken, val.token);
  };
  function CoreControlTest_HasTrackingProtectionExceptionForTesting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CoreControlTest_HasTrackingProtectionExceptionForTesting_Params.prototype.initDefaults_ = function() {
    this.firstPartyUrl = null;
  };
  CoreControlTest_HasTrackingProtectionExceptionForTesting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CoreControlTest_HasTrackingProtectionExceptionForTesting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CoreControlTest_HasTrackingProtectionExceptionForTesting_Params.firstPartyUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CoreControlTest_HasTrackingProtectionExceptionForTesting_Params.encodedSize = codec.kStructHeaderSize + 8;

  CoreControlTest_HasTrackingProtectionExceptionForTesting_Params.decode = function(decoder) {
    var packed;
    var val = new CoreControlTest_HasTrackingProtectionExceptionForTesting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.firstPartyUrl =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  CoreControlTest_HasTrackingProtectionExceptionForTesting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CoreControlTest_HasTrackingProtectionExceptionForTesting_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.firstPartyUrl);
  };
  function CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParams.prototype.initDefaults_ = function() {
    this.hasException = false;
  };
  CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.hasException = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.hasException & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kCoreControlTest_VerifyIpProtectionCoreHostForTesting_Name = 0;
  var kCoreControlTest_IsIpProtectionEnabledForTesting_Name = 1;
  var kCoreControlTest_GetAuthTokenForTesting_Name = 2;
  var kCoreControlTest_HasTrackingProtectionExceptionForTesting_Name = 3;

  function CoreControlTestPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(CoreControlTest,
                                                   handleOrPtrInfo);
  }

  function CoreControlTestAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        CoreControlTest, associatedInterfacePtrInfo);
  }

  CoreControlTestAssociatedPtr.prototype =
      Object.create(CoreControlTestPtr.prototype);
  CoreControlTestAssociatedPtr.prototype.constructor =
      CoreControlTestAssociatedPtr;

  function CoreControlTestProxy(receiver) {
    this.receiver_ = receiver;
  }
  CoreControlTestPtr.prototype.verifyIpProtectionCoreHostForTesting = function() {
    return CoreControlTestProxy.prototype.verifyIpProtectionCoreHostForTesting
        .apply(this.ptr.getProxy(), arguments);
  };

  CoreControlTestProxy.prototype.verifyIpProtectionCoreHostForTesting = function() {
    var params_ = new CoreControlTest_VerifyIpProtectionCoreHostForTesting_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCoreControlTest_VerifyIpProtectionCoreHostForTesting_Name,
          codec.align(CoreControlTest_VerifyIpProtectionCoreHostForTesting_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CoreControlTest_VerifyIpProtectionCoreHostForTesting_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CoreControlTestPtr.prototype.isIpProtectionEnabledForTesting = function() {
    return CoreControlTestProxy.prototype.isIpProtectionEnabledForTesting
        .apply(this.ptr.getProxy(), arguments);
  };

  CoreControlTestProxy.prototype.isIpProtectionEnabledForTesting = function() {
    var params_ = new CoreControlTest_IsIpProtectionEnabledForTesting_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCoreControlTest_IsIpProtectionEnabledForTesting_Name,
          codec.align(CoreControlTest_IsIpProtectionEnabledForTesting_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CoreControlTest_IsIpProtectionEnabledForTesting_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CoreControlTestPtr.prototype.getAuthTokenForTesting = function() {
    return CoreControlTestProxy.prototype.getAuthTokenForTesting
        .apply(this.ptr.getProxy(), arguments);
  };

  CoreControlTestProxy.prototype.getAuthTokenForTesting = function(proxyLayer, geoId) {
    var params_ = new CoreControlTest_GetAuthTokenForTesting_Params();
    params_.proxyLayer = proxyLayer;
    params_.geoId = geoId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCoreControlTest_GetAuthTokenForTesting_Name,
          codec.align(CoreControlTest_GetAuthTokenForTesting_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CoreControlTest_GetAuthTokenForTesting_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CoreControlTest_GetAuthTokenForTesting_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CoreControlTestPtr.prototype.hasTrackingProtectionExceptionForTesting = function() {
    return CoreControlTestProxy.prototype.hasTrackingProtectionExceptionForTesting
        .apply(this.ptr.getProxy(), arguments);
  };

  CoreControlTestProxy.prototype.hasTrackingProtectionExceptionForTesting = function(firstPartyUrl) {
    var params_ = new CoreControlTest_HasTrackingProtectionExceptionForTesting_Params();
    params_.firstPartyUrl = firstPartyUrl;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCoreControlTest_HasTrackingProtectionExceptionForTesting_Name,
          codec.align(CoreControlTest_HasTrackingProtectionExceptionForTesting_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CoreControlTest_HasTrackingProtectionExceptionForTesting_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function CoreControlTestStub(delegate) {
    this.delegate_ = delegate;
  }
  CoreControlTestStub.prototype.verifyIpProtectionCoreHostForTesting = function() {
    return this.delegate_ && this.delegate_.verifyIpProtectionCoreHostForTesting && this.delegate_.verifyIpProtectionCoreHostForTesting();
  }
  CoreControlTestStub.prototype.isIpProtectionEnabledForTesting = function() {
    return this.delegate_ && this.delegate_.isIpProtectionEnabledForTesting && this.delegate_.isIpProtectionEnabledForTesting();
  }
  CoreControlTestStub.prototype.getAuthTokenForTesting = function(proxyLayer, geoId) {
    return this.delegate_ && this.delegate_.getAuthTokenForTesting && this.delegate_.getAuthTokenForTesting(proxyLayer, geoId);
  }
  CoreControlTestStub.prototype.hasTrackingProtectionExceptionForTesting = function(firstPartyUrl) {
    return this.delegate_ && this.delegate_.hasTrackingProtectionExceptionForTesting && this.delegate_.hasTrackingProtectionExceptionForTesting(firstPartyUrl);
  }

  CoreControlTestStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  CoreControlTestStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCoreControlTest_VerifyIpProtectionCoreHostForTesting_Name:
      var params = reader.decodeStruct(CoreControlTest_VerifyIpProtectionCoreHostForTesting_Params);
      this.verifyIpProtectionCoreHostForTesting().then(function(response) {
        var responseParams =
            new CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParams();
        responseParams.bsaToken = response.bsaToken;
        responseParams.tryAgainAfter = response.tryAgainAfter;
        var builder = new codec.MessageV1Builder(
            kCoreControlTest_VerifyIpProtectionCoreHostForTesting_Name,
            codec.align(CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCoreControlTest_IsIpProtectionEnabledForTesting_Name:
      var params = reader.decodeStruct(CoreControlTest_IsIpProtectionEnabledForTesting_Params);
      this.isIpProtectionEnabledForTesting().then(function(response) {
        var responseParams =
            new CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParams();
        responseParams.value = response.value;
        var builder = new codec.MessageV1Builder(
            kCoreControlTest_IsIpProtectionEnabledForTesting_Name,
            codec.align(CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCoreControlTest_GetAuthTokenForTesting_Name:
      var params = reader.decodeStruct(CoreControlTest_GetAuthTokenForTesting_Params);
      this.getAuthTokenForTesting(params.proxyLayer, params.geoId).then(function(response) {
        var responseParams =
            new CoreControlTest_GetAuthTokenForTesting_ResponseParams();
        responseParams.token = response.token;
        var builder = new codec.MessageV1Builder(
            kCoreControlTest_GetAuthTokenForTesting_Name,
            codec.align(CoreControlTest_GetAuthTokenForTesting_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CoreControlTest_GetAuthTokenForTesting_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCoreControlTest_HasTrackingProtectionExceptionForTesting_Name:
      var params = reader.decodeStruct(CoreControlTest_HasTrackingProtectionExceptionForTesting_Params);
      this.hasTrackingProtectionExceptionForTesting(params.firstPartyUrl).then(function(response) {
        var responseParams =
            new CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParams();
        responseParams.hasException = response.hasException;
        var builder = new codec.MessageV1Builder(
            kCoreControlTest_HasTrackingProtectionExceptionForTesting_Name,
            codec.align(CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateCoreControlTestRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kCoreControlTest_VerifyIpProtectionCoreHostForTesting_Name:
        if (message.expectsResponse())
          paramsClass = CoreControlTest_VerifyIpProtectionCoreHostForTesting_Params;
      break;
      case kCoreControlTest_IsIpProtectionEnabledForTesting_Name:
        if (message.expectsResponse())
          paramsClass = CoreControlTest_IsIpProtectionEnabledForTesting_Params;
      break;
      case kCoreControlTest_GetAuthTokenForTesting_Name:
        if (message.expectsResponse())
          paramsClass = CoreControlTest_GetAuthTokenForTesting_Params;
      break;
      case kCoreControlTest_HasTrackingProtectionExceptionForTesting_Name:
        if (message.expectsResponse())
          paramsClass = CoreControlTest_HasTrackingProtectionExceptionForTesting_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateCoreControlTestResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kCoreControlTest_VerifyIpProtectionCoreHostForTesting_Name:
        if (message.isResponse())
          paramsClass = CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParams;
        break;
      case kCoreControlTest_IsIpProtectionEnabledForTesting_Name:
        if (message.isResponse())
          paramsClass = CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParams;
        break;
      case kCoreControlTest_GetAuthTokenForTesting_Name:
        if (message.isResponse())
          paramsClass = CoreControlTest_GetAuthTokenForTesting_ResponseParams;
        break;
      case kCoreControlTest_HasTrackingProtectionExceptionForTesting_Name:
        if (message.isResponse())
          paramsClass = CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var CoreControlTest = {
    name: 'ip_protection.mojom.CoreControlTest',
    kVersion: 0,
    ptrClass: CoreControlTestPtr,
    proxyClass: CoreControlTestProxy,
    stubClass: CoreControlTestStub,
    validateRequest: validateCoreControlTestRequest,
    validateResponse: validateCoreControlTestResponse,
  };
  CoreControlTestStub.prototype.validator = validateCoreControlTestRequest;
  CoreControlTestProxy.prototype.validator = validateCoreControlTestResponse;
  exports.CoreControlTest = CoreControlTest;
  exports.CoreControlTestPtr = CoreControlTestPtr;
  exports.CoreControlTestAssociatedPtr = CoreControlTestAssociatedPtr;
})();