// components/ip_protection/mojom/core_test.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec
} from '../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../url/mojom/url.mojom.m.js';

import {
  ProxyLayer as ipProtection_mojom_ProxyLayer,
  ProxyLayerSpec as ipProtection_mojom_ProxyLayerSpec,
  BlindSignedAuthToken as ipProtection_mojom_BlindSignedAuthToken,
  BlindSignedAuthTokenSpec as ipProtection_mojom_BlindSignedAuthTokenSpec
} from './data_types.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CoreControlTestPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ip_protection.mojom.CoreControlTest', scope);
  }
}

/** @interface */
export class CoreControlTestInterface {
  
  /**
   * @return {!Promise<{
        bsaToken: ?ipProtection_mojom_BlindSignedAuthToken,
        tryAgainAfter: ?mojoBase_mojom_Time,
   *  }>}
   */

  verifyIpProtectionCoreHostForTesting() {}
  
  /**
   * @return {!Promise<{
        value: !boolean,
   *  }>}
   */

  isIpProtectionEnabledForTesting() {}
  
  /**
   * @param { !ipProtection_mojom_ProxyLayer } proxyLayer
   * @param { !string } geoId
   * @return {!Promise<{
        token: ?ipProtection_mojom_BlindSignedAuthToken,
   *  }>}
   */

  getAuthTokenForTesting(proxyLayer, geoId) {}
  
  /**
   * @param { !url_mojom_Url } firstPartyUrl
   * @return {!Promise<{
        hasException: !boolean,
   *  }>}
   */

  hasTrackingProtectionExceptionForTesting(firstPartyUrl) {}
}

/**
 * @implements { CoreControlTestInterface }
 */
export class CoreControlTestRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CoreControlTestPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CoreControlTestPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CoreControlTestPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        bsaToken: ?ipProtection_mojom_BlindSignedAuthToken,
        tryAgainAfter: ?mojoBase_mojom_Time,
   *  }>}
   */

  verifyIpProtectionCoreHostForTesting() {
    return this.proxy.sendMessage(
        0,
        CoreControlTest_VerifyIpProtectionCoreHostForTesting_ParamsSpec.$,
        CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        value: !boolean,
   *  }>}
   */

  isIpProtectionEnabledForTesting() {
    return this.proxy.sendMessage(
        1,
        CoreControlTest_IsIpProtectionEnabledForTesting_ParamsSpec.$,
        CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !ipProtection_mojom_ProxyLayer } proxyLayer
   * @param { !string } geoId
   * @return {!Promise<{
        token: ?ipProtection_mojom_BlindSignedAuthToken,
   *  }>}
   */

  getAuthTokenForTesting(
      proxyLayer,
      geoId) {
    return this.proxy.sendMessage(
        2,
        CoreControlTest_GetAuthTokenForTesting_ParamsSpec.$,
        CoreControlTest_GetAuthTokenForTesting_ResponseParamsSpec.$,
        [
          proxyLayer,
          geoId
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } firstPartyUrl
   * @return {!Promise<{
        hasException: !boolean,
   *  }>}
   */

  hasTrackingProtectionExceptionForTesting(
      firstPartyUrl) {
    return this.proxy.sendMessage(
        3,
        CoreControlTest_HasTrackingProtectionExceptionForTesting_ParamsSpec.$,
        CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParamsSpec.$,
        [
          firstPartyUrl
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CoreControlTest
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CoreControlTestReceiver {
  /**
   * @param {!CoreControlTestInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CoreControlTestRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CoreControlTestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CoreControlTestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CoreControlTest_VerifyIpProtectionCoreHostForTesting_ParamsSpec.$,
        CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParamsSpec.$,
        impl.verifyIpProtectionCoreHostForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CoreControlTest_IsIpProtectionEnabledForTesting_ParamsSpec.$,
        CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParamsSpec.$,
        impl.isIpProtectionEnabledForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        CoreControlTest_GetAuthTokenForTesting_ParamsSpec.$,
        CoreControlTest_GetAuthTokenForTesting_ResponseParamsSpec.$,
        impl.getAuthTokenForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        CoreControlTest_HasTrackingProtectionExceptionForTesting_ParamsSpec.$,
        CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParamsSpec.$,
        impl.hasTrackingProtectionExceptionForTesting.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CoreControlTest {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ip_protection.mojom.CoreControlTest";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CoreControlTestRemote}
   */
  static getRemote() {
    let remote = new CoreControlTestRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CoreControlTest
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CoreControlTestCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CoreControlTestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CoreControlTestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.verifyIpProtectionCoreHostForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CoreControlTest_VerifyIpProtectionCoreHostForTesting_ParamsSpec.$,
        CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParamsSpec.$,
        this.verifyIpProtectionCoreHostForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isIpProtectionEnabledForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CoreControlTest_IsIpProtectionEnabledForTesting_ParamsSpec.$,
        CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParamsSpec.$,
        this.isIpProtectionEnabledForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAuthTokenForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        CoreControlTest_GetAuthTokenForTesting_ParamsSpec.$,
        CoreControlTest_GetAuthTokenForTesting_ResponseParamsSpec.$,
        this.getAuthTokenForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.hasTrackingProtectionExceptionForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        CoreControlTest_HasTrackingProtectionExceptionForTesting_ParamsSpec.$,
        CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParamsSpec.$,
        this.hasTrackingProtectionExceptionForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CoreControlTest_VerifyIpProtectionCoreHostForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CoreControlTest_IsIpProtectionEnabledForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CoreControlTest_GetAuthTokenForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CoreControlTest_GetAuthTokenForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CoreControlTest_HasTrackingProtectionExceptionForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CoreControlTest_VerifyIpProtectionCoreHostForTesting_ParamsSpec.$,
    'CoreControlTest_VerifyIpProtectionCoreHostForTesting_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CoreControlTest_VerifyIpProtectionCoreHostForTesting_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParamsSpec.$,
    'CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParams',
    [
      mojo.internal.StructField(
        'bsaToken', 0,
        0,
        ipProtection_mojom_BlindSignedAuthTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tryAgainAfter', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CoreControlTest_VerifyIpProtectionCoreHostForTesting_ResponseParams {
  constructor() {
    /** @type { (ipProtection_mojom_BlindSignedAuthToken|undefined) } */
    this.bsaToken;
    /** @type { (mojoBase_mojom_Time|undefined) } */
    this.tryAgainAfter;
  }
}



mojo.internal.Struct(
    CoreControlTest_IsIpProtectionEnabledForTesting_ParamsSpec.$,
    'CoreControlTest_IsIpProtectionEnabledForTesting_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CoreControlTest_IsIpProtectionEnabledForTesting_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParamsSpec.$,
    'CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CoreControlTest_IsIpProtectionEnabledForTesting_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.value;
  }
}



mojo.internal.Struct(
    CoreControlTest_GetAuthTokenForTesting_ParamsSpec.$,
    'CoreControlTest_GetAuthTokenForTesting_Params',
    [
      mojo.internal.StructField(
        'proxyLayer', 0,
        0,
        ipProtection_mojom_ProxyLayerSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'geoId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CoreControlTest_GetAuthTokenForTesting_Params {
  constructor() {
    /** @type { !ipProtection_mojom_ProxyLayer } */
    this.proxyLayer;
    /** @type { !string } */
    this.geoId;
  }
}



mojo.internal.Struct(
    CoreControlTest_GetAuthTokenForTesting_ResponseParamsSpec.$,
    'CoreControlTest_GetAuthTokenForTesting_ResponseParams',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        ipProtection_mojom_BlindSignedAuthTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CoreControlTest_GetAuthTokenForTesting_ResponseParams {
  constructor() {
    /** @type { (ipProtection_mojom_BlindSignedAuthToken|undefined) } */
    this.token;
  }
}



mojo.internal.Struct(
    CoreControlTest_HasTrackingProtectionExceptionForTesting_ParamsSpec.$,
    'CoreControlTest_HasTrackingProtectionExceptionForTesting_Params',
    [
      mojo.internal.StructField(
        'firstPartyUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CoreControlTest_HasTrackingProtectionExceptionForTesting_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.firstPartyUrl;
  }
}



mojo.internal.Struct(
    CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParamsSpec.$,
    'CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParams',
    [
      mojo.internal.StructField(
        'hasException', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CoreControlTest_HasTrackingProtectionExceptionForTesting_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.hasException;
  }
}

