// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var certificateErrorPageController;const SecurityInterstitialCommandId={CMD_DONT_PROCEED:0,CMD_PROCEED:1,CMD_SHOW_MORE_SECTION:2,CMD_OPEN_HELP_CENTER:3,CMD_OPEN_DIAGNOSTIC:4,CMD_RELOAD:5,CMD_OPEN_DATE_SETTINGS:6,CMD_OPEN_LOGIN:7,CMD_DO_REPORT:8,CMD_DONT_REPORT:9,CMD_OPEN_REPORTING_PRIVACY:10,CMD_OPEN_WHITEPAPER:11,CMD_REPORT_PHISHING_ERROR:12,CMD_OPEN_ENHANCED_PROTECTION_SETTINGS:13,CMD_OPEN_ANDROID_ADVANCED_PROTECTION_SETTINGS:16,CMD_OPEN_HELP_CENTER_IN_NEW_TAB:17,CMD_OPEN_DIAGNOSTIC_IN_NEW_TAB:18,CMD_OPEN_REPORTING_PRIVACY_IN_NEW_TAB:19,CMD_OPEN_WHITEPAPER_IN_NEW_TAB:20,CMD_REPORT_PHISHING_ERROR_IN_NEW_TAB:21,CMD_SHOW_CERTIFICATE_VIEWER:22};const HIDDEN_CLASS="hidden";function sendCommand(cmd){if(window.certificateErrorPageController){switch(cmd){case SecurityInterstitialCommandId.CMD_DONT_PROCEED:certificateErrorPageController.dontProceed();break;case SecurityInterstitialCommandId.CMD_PROCEED:certificateErrorPageController.proceed();break;case SecurityInterstitialCommandId.CMD_SHOW_MORE_SECTION:certificateErrorPageController.showMoreSection();break;case SecurityInterstitialCommandId.CMD_OPEN_HELP_CENTER:certificateErrorPageController.openHelpCenter();break;case SecurityInterstitialCommandId.CMD_OPEN_DIAGNOSTIC:certificateErrorPageController.openDiagnostic();break;case SecurityInterstitialCommandId.CMD_RELOAD:certificateErrorPageController.reload();break;case SecurityInterstitialCommandId.CMD_OPEN_DATE_SETTINGS:certificateErrorPageController.openDateSettings();break;case SecurityInterstitialCommandId.CMD_OPEN_LOGIN:certificateErrorPageController.openLogin();break;case SecurityInterstitialCommandId.CMD_DO_REPORT:certificateErrorPageController.doReport();break;case SecurityInterstitialCommandId.CMD_DONT_REPORT:certificateErrorPageController.dontReport();break;case SecurityInterstitialCommandId.CMD_OPEN_REPORTING_PRIVACY:certificateErrorPageController.openReportingPrivacy();break;case SecurityInterstitialCommandId.CMD_OPEN_WHITEPAPER:certificateErrorPageController.openWhitepaper();break;case SecurityInterstitialCommandId.CMD_REPORT_PHISHING_ERROR:certificateErrorPageController.reportPhishingError();break;case SecurityInterstitialCommandId.CMD_OPEN_ENHANCED_PROTECTION_SETTINGS:certificateErrorPageController.openEnhancedProtectionSettings();break;case SecurityInterstitialCommandId.CMD_OPEN_ANDROID_ADVANCED_PROTECTION_SETTINGS:certificateErrorPageController.openAndroidAdvancedProtectionSettings();break;case SecurityInterstitialCommandId.CMD_OPEN_HELP_CENTER_IN_NEW_TAB:certificateErrorPageController.openHelpCenterInNewTab();break;case SecurityInterstitialCommandId.CMD_OPEN_DIAGNOSTIC_IN_NEW_TAB:certificateErrorPageController.openDiagnosticInNewTab();break;case SecurityInterstitialCommandId.CMD_OPEN_REPORTING_PRIVACY_IN_NEW_TAB:certificateErrorPageController.openReportingPrivacyInNewTab();break;case SecurityInterstitialCommandId.CMD_OPEN_WHITEPAPER_IN_NEW_TAB:certificateErrorPageController.openWhitepaperInNewTab();break;case SecurityInterstitialCommandId.CMD_REPORT_PHISHING_ERROR_IN_NEW_TAB:certificateErrorPageController.reportPhishingErrorInNewTab();break;case SecurityInterstitialCommandId.CMD_SHOW_CERTIFICATE_VIEWER:certificateErrorPageController.showCertificateViewer();break}return}if(window.domAutomationController){window.domAutomationController.send(cmd)}}function preventDefaultOnPoundLinkClicks(){const anchors=document.body.querySelectorAll('a[href="#"]');for(const anchor of anchors){anchor.addEventListener("click",(e=>e.preventDefault()))}}function assert(value,message){if(value){return}throw new Error("Assertion failed"+(message?`: ${message}`:""))}class LoadTimeData{data_=null;set data(value){assert(!this.data_,"Re-setting data.");this.data_=value}valueExists(id){assert(this.data_,"No data. Did you remember to include strings.js?");return id in this.data_}getValue(id){assert(this.data_,"No data. Did you remember to include strings.js?");const value=this.data_[id];assert(typeof value!=="undefined","Could not find value for "+id);return value}getString(id){const value=this.getValue(id);assert(typeof value==="string",`[${value}] (${id}) is not a string`);return value}getStringF(id,...args){const value=this.getString(id);if(!value){return""}return this.substituteString(value,...args)}substituteString(label,...args){return label.replace(/\$(.|$|\n)/g,(function(m){assert(m.match(/\$[$1-9]/),"Unescaped $ found in localized string.");if(m==="$$"){return"$"}const substitute=args[Number(m[1])-1];if(substitute===undefined||substitute===null){return""}return substitute.toString()}))}getSubstitutedStringPieces(label,...args){const pieces=(label.match(/(\$[1-9])|(([^$]|\$([^1-9]|$))+)/g)||[]).map((function(p){if(!p.match(/^\$[1-9]$/)){assert((p.match(/\$/g)||[]).length%2===0,"Unescaped $ found in localized string.");return{value:p.replace(/\$\$/g,"$"),arg:null}}const substitute=args[Number(p[1])-1];if(substitute===undefined||substitute===null){return{value:"",arg:p}}return{value:substitute.toString(),arg:p}}));return pieces}getBoolean(id){const value=this.getValue(id);assert(typeof value==="boolean",`[${value}] (${id}) is not a boolean`);return value}getInteger(id){const value=this.getValue(id);assert(typeof value==="number",`[${value}] (${id}) is not a number`);assert(value===Math.floor(value),"Number isn't integer: "+value);return value}overrideValues(replacements){assert(typeof replacements==="object","Replacements must be a dictionary object.");assert(this.data_,"Data must exist before being overridden");for(const key in replacements){this.data_[key]=replacements[key]}}resetForTesting(newData=null){this.data_=newData}isInitialized(){return this.data_!==null}}const loadTimeData=new LoadTimeData;function onResize(){const mediaQuery="(max-height:11.25em) and (max-width:18.75em),"+"(max-height:18.75em) and (max-width:11.25em),"+"(max-height:5em), (max-width:5em)";if(window.matchMedia(mediaQuery).matches){document.querySelector("#details").classList.add(HIDDEN_CLASS);document.querySelector("#main-content").classList.remove(HIDDEN_CLASS);document.querySelector("#icon").setAttribute("aria-label",loadTimeData.getString("heading"))}else{document.querySelector("#icon").removeAttribute("aria-label")}}function initPage(){loadTimeData.data=window.loadTimeDataRaw;const isGiantWebView=loadTimeData.getBoolean("is_giant");const interstitialType=loadTimeData.getString("type");const safebrowsing=interstitialType==="SAFEBROWSING";const heavyAd=interstitialType==="HEAVYAD";document.body.className=isGiantWebView?"giant":"";if(heavyAd){document.body.classList.add("heavy-ad")}preventDefaultOnPoundLinkClicks();document.querySelector("#details-link").addEventListener("click",(function(event){const hiddenDetails=document.querySelector("#details").classList.toggle(HIDDEN_CLASS);document.querySelector("#main-content").classList.toggle(HIDDEN_CLASS,!hiddenDetails)}));if(safebrowsing){document.querySelector("#proceed-link").addEventListener("click",(function(event){sendCommand(SecurityInterstitialCommandId.CMD_PROCEED)}))}window.addEventListener("resize",onResize)}document.addEventListener("DOMContentLoaded",initPage);