// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";import{AggregatableResultSpec as attributionReporting_mojom_AggregatableResultSpec}from"./aggregatable_result.mojom-webui.js";import{AttributionSupportSpec as network_mojom_AttributionSupportSpec}from"./attribution.mojom-webui.js";import{OsRegistrationResultSpec as attributionReporting_mojom_OsRegistrationResultSpec,RegistrationTypeSpec as attributionReporting_mojom_RegistrationTypeSpec}from"./attribution_reporting.mojom-webui.js";import{EventLevelResultSpec as attributionReporting_mojom_EventLevelResultSpec}from"./event_level_result.mojom-webui.js";import{ProcessAggregatableDebugReportResultSpec as attributionReporting_mojom_ProcessAggregatableDebugReportResultSpec}from"./process_aggregatable_debug_report_result.mojom-webui.js";import{DestinationSetSpec as attributionReporting_mojom_DestinationSetSpec,EventReportWindowsSpec as attributionReporting_mojom_EventReportWindowsSpec,FilterDataSpec as attributionReporting_mojom_FilterDataSpec}from"./registration.mojom-webui.js";import{SourceTypeSpec as attributionReporting_mojom_SourceTypeSpec}from"./source_type.mojom-webui.js";import{StoreSourceResultSpec as attributionReporting_mojom_StoreSourceResultSpec}from"./store_source_result.mojom-webui.js";import{TriggerDataMatchingSpec as attributionReporting_mojom_TriggerDataMatchingSpec}from"./trigger_data_matching.mojom-webui.js";import{OriginSpec as url_mojom_OriginSpec}from"//resources/mojo/url/mojom/origin.mojom-webui.js";import{UrlSpec as url_mojom_UrlSpec}from"//resources/mojo/url/mojom/url.mojom-webui.js";export class ObserverPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"attribution_internals.mojom.Observer",scope)}}export class ObserverRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(ObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onSourcesChanged(sources){this.proxy.sendMessage(0,Observer_OnSourcesChanged_ParamsSpec.$,null,[sources],false)}onReportsChanged(reports){this.proxy.sendMessage(1,Observer_OnReportsChanged_ParamsSpec.$,null,[reports],false)}onSourceHandled(source){this.proxy.sendMessage(2,Observer_OnSourceHandled_ParamsSpec.$,null,[source],false)}onReportHandled(report){this.proxy.sendMessage(3,Observer_OnReportHandled_ParamsSpec.$,null,[report],false)}onDebugReportSent(report){this.proxy.sendMessage(4,Observer_OnDebugReportSent_ParamsSpec.$,null,[report],false)}onAggregatableDebugReportSent(report){this.proxy.sendMessage(5,Observer_OnAggregatableDebugReportSent_ParamsSpec.$,null,[report],false)}onTriggerHandled(trigger){this.proxy.sendMessage(6,Observer_OnTriggerHandled_ParamsSpec.$,null,[trigger],false)}onOsRegistration(registration){this.proxy.sendMessage(7,Observer_OnOsRegistration_ParamsSpec.$,null,[registration],false)}onDebugModeChanged(debugMode){this.proxy.sendMessage(8,Observer_OnDebugModeChanged_ParamsSpec.$,null,[debugMode],false)}}export class ObserverReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,Observer_OnSourcesChanged_ParamsSpec.$,null,impl.onSourcesChanged.bind(impl),false);this.helper_internal_.registerHandler(1,Observer_OnReportsChanged_ParamsSpec.$,null,impl.onReportsChanged.bind(impl),false);this.helper_internal_.registerHandler(2,Observer_OnSourceHandled_ParamsSpec.$,null,impl.onSourceHandled.bind(impl),false);this.helper_internal_.registerHandler(3,Observer_OnReportHandled_ParamsSpec.$,null,impl.onReportHandled.bind(impl),false);this.helper_internal_.registerHandler(4,Observer_OnDebugReportSent_ParamsSpec.$,null,impl.onDebugReportSent.bind(impl),false);this.helper_internal_.registerHandler(5,Observer_OnAggregatableDebugReportSent_ParamsSpec.$,null,impl.onAggregatableDebugReportSent.bind(impl),false);this.helper_internal_.registerHandler(6,Observer_OnTriggerHandled_ParamsSpec.$,null,impl.onTriggerHandled.bind(impl),false);this.helper_internal_.registerHandler(7,Observer_OnOsRegistration_ParamsSpec.$,null,impl.onOsRegistration.bind(impl),false);this.helper_internal_.registerHandler(8,Observer_OnDebugModeChanged_ParamsSpec.$,null,impl.onDebugModeChanged.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class Observer{static get $interfaceName(){return"attribution_internals.mojom.Observer"}static getRemote(){let remote=new ObserverRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class ObserverCallbackRouter{helper_internal_;$;router_;onSourcesChanged;onReportsChanged;onSourceHandled;onReportHandled;onDebugReportSent;onAggregatableDebugReportSent;onTriggerHandled;onOsRegistration;onDebugModeChanged;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onSourcesChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,Observer_OnSourcesChanged_ParamsSpec.$,null,this.onSourcesChanged.createReceiverHandler(false),false);this.onReportsChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,Observer_OnReportsChanged_ParamsSpec.$,null,this.onReportsChanged.createReceiverHandler(false),false);this.onSourceHandled=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,Observer_OnSourceHandled_ParamsSpec.$,null,this.onSourceHandled.createReceiverHandler(false),false);this.onReportHandled=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,Observer_OnReportHandled_ParamsSpec.$,null,this.onReportHandled.createReceiverHandler(false),false);this.onDebugReportSent=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,Observer_OnDebugReportSent_ParamsSpec.$,null,this.onDebugReportSent.createReceiverHandler(false),false);this.onAggregatableDebugReportSent=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,Observer_OnAggregatableDebugReportSent_ParamsSpec.$,null,this.onAggregatableDebugReportSent.createReceiverHandler(false),false);this.onTriggerHandled=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(6,Observer_OnTriggerHandled_ParamsSpec.$,null,this.onTriggerHandled.createReceiverHandler(false),false);this.onOsRegistration=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(7,Observer_OnOsRegistration_ParamsSpec.$,null,this.onOsRegistration.createReceiverHandler(false),false);this.onDebugModeChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(8,Observer_OnDebugModeChanged_ParamsSpec.$,null,this.onDebugModeChanged.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class HandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"attribution_internals.mojom.Handler",scope)}}export class HandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(HandlerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}isAttributionReportingEnabled(){return this.proxy.sendMessage(0,Handler_IsAttributionReportingEnabled_ParamsSpec.$,Handler_IsAttributionReportingEnabled_ResponseParamsSpec.$,[],false)}sendReport(id){return this.proxy.sendMessage(1,Handler_SendReport_ParamsSpec.$,Handler_SendReport_ResponseParamsSpec.$,[id],false)}clearStorage(){return this.proxy.sendMessage(2,Handler_ClearStorage_ParamsSpec.$,Handler_ClearStorage_ResponseParamsSpec.$,[],false)}}export class HandlerReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(HandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,Handler_IsAttributionReportingEnabled_ParamsSpec.$,Handler_IsAttributionReportingEnabled_ResponseParamsSpec.$,impl.isAttributionReportingEnabled.bind(impl),false);this.helper_internal_.registerHandler(1,Handler_SendReport_ParamsSpec.$,Handler_SendReport_ResponseParamsSpec.$,impl.sendReport.bind(impl),false);this.helper_internal_.registerHandler(2,Handler_ClearStorage_ParamsSpec.$,Handler_ClearStorage_ResponseParamsSpec.$,impl.clearStorage.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class Handler{static get $interfaceName(){return"attribution_internals.mojom.Handler"}static getRemote(){let remote=new HandlerRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class HandlerCallbackRouter{helper_internal_;$;router_;isAttributionReportingEnabled;sendReport;clearStorage;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(HandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.isAttributionReportingEnabled=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,Handler_IsAttributionReportingEnabled_ParamsSpec.$,Handler_IsAttributionReportingEnabled_ResponseParamsSpec.$,this.isAttributionReportingEnabled.createReceiverHandler(true),false);this.sendReport=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,Handler_SendReport_ParamsSpec.$,Handler_SendReport_ResponseParamsSpec.$,this.sendReport.createReceiverHandler(true),false);this.clearStorage=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,Handler_ClearStorage_ParamsSpec.$,Handler_ClearStorage_ResponseParamsSpec.$,this.clearStorage.createReceiverHandler(true),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class FactoryPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"attribution_internals.mojom.Factory",scope)}}export class FactoryRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(FactoryPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}create(observer,handler){this.proxy.sendMessage(0,Factory_Create_ParamsSpec.$,null,[observer,handler],false)}}export class FactoryReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(FactoryRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,Factory_Create_ParamsSpec.$,null,impl.create.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class Factory{static get $interfaceName(){return"attribution_internals.mojom.Factory"}static getRemote(){let remote=new FactoryRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class FactoryCallbackRouter{helper_internal_;$;router_;create;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(FactoryRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.create=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,Factory_Create_ParamsSpec.$,null,this.create.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const ReportIDSpec={$:{}};export const WebUIReportEventLevelDataSpec={$:{}};export const AggregatableHistogramContributionSpec={$:{}};export const WebUIReportAggregatableAttributionDataSpec={$:{}};export const EmptySpec={$:{}};export const WebUIReportSpec={$:{}};export const WebUIDebugReportSpec={$:{}};export const WebUIAggregatableDebugReportSpec={$:{}};export const WebUISourceSpec={$:{}};export const WebUIRegistrationSpec={$:{}};export const WebUITriggerSpec={$:{}};export const WebUISourceRegistrationSpec={$:{}};export const WebUIOsRegistrationSpec={$:{}};export const Observer_OnSourcesChanged_ParamsSpec={$:{}};export const Observer_OnReportsChanged_ParamsSpec={$:{}};export const Observer_OnSourceHandled_ParamsSpec={$:{}};export const Observer_OnReportHandled_ParamsSpec={$:{}};export const Observer_OnDebugReportSent_ParamsSpec={$:{}};export const Observer_OnAggregatableDebugReportSent_ParamsSpec={$:{}};export const Observer_OnTriggerHandled_ParamsSpec={$:{}};export const Observer_OnOsRegistration_ParamsSpec={$:{}};export const Observer_OnDebugModeChanged_ParamsSpec={$:{}};export const Handler_IsAttributionReportingEnabled_ParamsSpec={$:{}};export const Handler_IsAttributionReportingEnabled_ResponseParamsSpec={$:{}};export const Handler_SendReport_ParamsSpec={$:{}};export const Handler_SendReport_ResponseParamsSpec={$:{}};export const Handler_ClearStorage_ParamsSpec={$:{}};export const Handler_ClearStorage_ResponseParamsSpec={$:{}};export const Factory_Create_ParamsSpec={$:{}};export const WebUIReportDataSpec={$:{}};export const NetworkStatusSpec={$:{}};export const ReportStatusSpec={$:{}};export const SendAggregatableDebugReportResultSpec={$:{}};mojo.internal.Struct(ReportIDSpec.$,"ReportID",[mojo.internal.StructField("value",0,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(WebUIReportEventLevelDataSpec.$,"WebUIReportEventLevelData",[mojo.internal.StructField("priority",0,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined),mojo.internal.StructField("attributedTruthfully",8,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(AggregatableHistogramContributionSpec.$,"AggregatableHistogramContribution",[mojo.internal.StructField("key",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("value",8,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("filteringId",16,0,mojo.internal.Uint64,BigInt(0),false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(WebUIReportAggregatableAttributionDataSpec.$,"WebUIReportAggregatableAttributionData",[mojo.internal.StructField("contributions",0,0,mojo.internal.Array(AggregatableHistogramContributionSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("aggregationCoordinator",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("isNullReport",16,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(EmptySpec.$,"Empty",[],[[0,8]]);mojo.internal.Struct(WebUIReportSpec.$,"WebUIReport",[mojo.internal.StructField("id",0,0,ReportIDSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("reportUrl",8,0,url_mojom_UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("triggerTime",16,0,mojo.internal.Double,0,false,0,undefined,undefined),mojo.internal.StructField("reportTime",24,0,mojo.internal.Double,0,false,0,undefined,undefined),mojo.internal.StructField("reportBody",32,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("status",40,0,ReportStatusSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("data",56,0,WebUIReportDataSpec.$,null,false,0,undefined,undefined)],[[0,80]]);mojo.internal.Struct(WebUIDebugReportSpec.$,"WebUIDebugReport",[mojo.internal.StructField("url",0,0,url_mojom_UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("time",8,0,mojo.internal.Double,0,false,0,undefined,undefined),mojo.internal.StructField("body",16,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("status",24,0,NetworkStatusSpec.$,null,false,0,undefined,undefined)],[[0,48]]);mojo.internal.Struct(WebUIAggregatableDebugReportSpec.$,"WebUIAggregatableDebugReport",[mojo.internal.StructField("url",0,0,url_mojom_UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("time",8,0,mojo.internal.Double,0,false,0,undefined,undefined),mojo.internal.StructField("body",16,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("processResult",24,0,attributionReporting_mojom_ProcessAggregatableDebugReportResultSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("sendResult",32,0,SendAggregatableDebugReportResultSpec.$,null,false,0,undefined,undefined)],[[0,56]]);export const WebUISource_AttributabilitySpec={$:mojo.internal.Enum()};export var WebUISource_Attributability;(function(WebUISource_Attributability){WebUISource_Attributability[WebUISource_Attributability["MIN_VALUE"]=0]="MIN_VALUE";WebUISource_Attributability[WebUISource_Attributability["MAX_VALUE"]=3]="MAX_VALUE";WebUISource_Attributability[WebUISource_Attributability["kAttributable"]=0]="kAttributable";WebUISource_Attributability[WebUISource_Attributability["kNoisedNever"]=1]="kNoisedNever";WebUISource_Attributability[WebUISource_Attributability["kNoisedFalsely"]=2]="kNoisedFalsely";WebUISource_Attributability[WebUISource_Attributability["kReachedEventLevelAttributionLimit"]=3]="kReachedEventLevelAttributionLimit"})(WebUISource_Attributability||(WebUISource_Attributability={}));mojo.internal.Struct(WebUISourceSpec.$,"WebUISource",[mojo.internal.StructField("id",0,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined),mojo.internal.StructField("sourceEventId",8,0,mojo.internal.Uint64,BigInt(0),false,0,undefined,undefined),mojo.internal.StructField("sourceOrigin",16,0,url_mojom_OriginSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("destinations",24,0,attributionReporting_mojom_DestinationSetSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("reportingOrigin",32,0,url_mojom_OriginSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("sourceTime",40,0,mojo.internal.Double,0,false,0,undefined,undefined),mojo.internal.StructField("expiryTime",48,0,mojo.internal.Double,0,false,0,undefined,undefined),mojo.internal.StructField("eventReportWindows",56,0,attributionReporting_mojom_EventReportWindowsSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("triggerData",64,0,mojo.internal.Array(mojo.internal.Uint32,false),null,false,0,undefined,undefined),mojo.internal.StructField("maxEventLevelReports",72,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("aggregatableReportWindowTime",80,0,mojo.internal.Double,0,false,0,undefined,undefined),mojo.internal.StructField("sourceType",76,0,attributionReporting_mojom_SourceTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("priority",88,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined),mojo.internal.StructField("debug_key_$flag",96,0,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"debug_key_$value",originalFieldName:"debugKey"},undefined),mojo.internal.StructField("debug_key_$value",104,0,mojo.internal.Uint64,BigInt(0),false,0,{isPrimary:false,originalFieldName:"debugKey"},undefined),mojo.internal.StructField("dedupKeys",112,0,mojo.internal.Array(mojo.internal.Uint64,false),null,false,0,undefined,undefined),mojo.internal.StructField("filterData",120,0,attributionReporting_mojom_FilterDataSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("aggregationKeys",128,0,mojo.internal.Map(mojo.internal.String,mojo.internal.String,false),null,false,0,undefined,undefined),mojo.internal.StructField("remainingAggregatableAttributionBudget",100,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("aggregatableDedupKeys",136,0,mojo.internal.Array(mojo.internal.Uint64,false),null,false,0,undefined,undefined),mojo.internal.StructField("triggerDataMatching",144,0,attributionReporting_mojom_TriggerDataMatchingSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("eventLevelEpsilon",152,0,mojo.internal.Double,0,false,0,undefined,undefined),mojo.internal.StructField("cookieBasedDebugAllowed",96,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("remainingAggregatableDebugBudget",148,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("aggregatableDebugKeyPiece",160,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("attributionScopesDataJson",168,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("aggregatableNamedBudgets",176,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("attributability",184,0,WebUISource_AttributabilitySpec.$,0,false,0,undefined,undefined)],[[0,200]]);mojo.internal.Struct(WebUIRegistrationSpec.$,"WebUIRegistration",[mojo.internal.StructField("time",0,0,mojo.internal.Double,0,false,0,undefined,undefined),mojo.internal.StructField("contextOrigin",8,0,url_mojom_OriginSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("reportingOrigin",16,0,url_mojom_OriginSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("registrationJson",24,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("cleared_debug_key_$flag",32,0,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"cleared_debug_key_$value",originalFieldName:"clearedDebugKey"},undefined),mojo.internal.StructField("cleared_debug_key_$value",40,0,mojo.internal.Uint64,BigInt(0),false,0,{isPrimary:false,originalFieldName:"clearedDebugKey"},undefined)],[[0,56]]);mojo.internal.Struct(WebUITriggerSpec.$,"WebUITrigger",[mojo.internal.StructField("registration",0,0,WebUIRegistrationSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("eventLevelResult",8,0,attributionReporting_mojom_EventLevelResultSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("aggregatableResult",12,0,attributionReporting_mojom_AggregatableResultSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(WebUISourceRegistrationSpec.$,"WebUISourceRegistration",[mojo.internal.StructField("registration",0,0,WebUIRegistrationSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("type",8,0,attributionReporting_mojom_SourceTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("status",12,0,attributionReporting_mojom_StoreSourceResultSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(WebUIOsRegistrationSpec.$,"WebUIOsRegistration",[mojo.internal.StructField("time",0,0,mojo.internal.Double,0,false,0,undefined,undefined),mojo.internal.StructField("registrationUrl",8,0,url_mojom_UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("topLevelOrigin",16,0,url_mojom_OriginSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("isDebugKeyAllowed",24,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("debugReporting",24,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("type",28,0,attributionReporting_mojom_RegistrationTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("result",32,0,attributionReporting_mojom_OsRegistrationResultSpec.$,0,false,0,undefined,undefined)],[[0,48]]);mojo.internal.Struct(Observer_OnSourcesChanged_ParamsSpec.$,"Observer_OnSourcesChanged_Params",[mojo.internal.StructField("sources",0,0,mojo.internal.Array(WebUISourceSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Observer_OnReportsChanged_ParamsSpec.$,"Observer_OnReportsChanged_Params",[mojo.internal.StructField("reports",0,0,mojo.internal.Array(WebUIReportSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Observer_OnSourceHandled_ParamsSpec.$,"Observer_OnSourceHandled_Params",[mojo.internal.StructField("source",0,0,WebUISourceRegistrationSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Observer_OnReportHandled_ParamsSpec.$,"Observer_OnReportHandled_Params",[mojo.internal.StructField("report",0,0,WebUIReportSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Observer_OnDebugReportSent_ParamsSpec.$,"Observer_OnDebugReportSent_Params",[mojo.internal.StructField("report",0,0,WebUIDebugReportSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Observer_OnAggregatableDebugReportSent_ParamsSpec.$,"Observer_OnAggregatableDebugReportSent_Params",[mojo.internal.StructField("report",0,0,WebUIAggregatableDebugReportSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Observer_OnTriggerHandled_ParamsSpec.$,"Observer_OnTriggerHandled_Params",[mojo.internal.StructField("trigger",0,0,WebUITriggerSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Observer_OnOsRegistration_ParamsSpec.$,"Observer_OnOsRegistration_Params",[mojo.internal.StructField("registration",0,0,WebUIOsRegistrationSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Observer_OnDebugModeChanged_ParamsSpec.$,"Observer_OnDebugModeChanged_Params",[mojo.internal.StructField("debugMode",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Handler_IsAttributionReportingEnabled_ParamsSpec.$,"Handler_IsAttributionReportingEnabled_Params",[],[[0,8]]);mojo.internal.Struct(Handler_IsAttributionReportingEnabled_ResponseParamsSpec.$,"Handler_IsAttributionReportingEnabled_ResponseParams",[mojo.internal.StructField("enabled",0,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("attributionSupport",4,0,network_mojom_AttributionSupportSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Handler_SendReport_ParamsSpec.$,"Handler_SendReport_Params",[mojo.internal.StructField("id",0,0,ReportIDSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Handler_SendReport_ResponseParamsSpec.$,"Handler_SendReport_ResponseParams",[],[[0,8]]);mojo.internal.Struct(Handler_ClearStorage_ParamsSpec.$,"Handler_ClearStorage_Params",[],[[0,8]]);mojo.internal.Struct(Handler_ClearStorage_ResponseParamsSpec.$,"Handler_ClearStorage_ResponseParams",[],[[0,8]]);mojo.internal.Struct(Factory_Create_ParamsSpec.$,"Factory_Create_Params",[mojo.internal.StructField("observer",0,0,mojo.internal.InterfaceProxy(ObserverRemote),null,false,0,undefined,undefined),mojo.internal.StructField("handler",8,0,mojo.internal.InterfaceRequest(HandlerPendingReceiver),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Union(WebUIReportDataSpec.$,"WebUIReportData",{eventLevelData:{ordinal:0,type:WebUIReportEventLevelDataSpec.$},aggregatableAttributionData:{ordinal:1,type:WebUIReportAggregatableAttributionDataSpec.$}});export var WebUIReportDataFieldTags;(function(WebUIReportDataFieldTags){WebUIReportDataFieldTags[WebUIReportDataFieldTags["EVENT_LEVEL_DATA"]=0]="EVENT_LEVEL_DATA";WebUIReportDataFieldTags[WebUIReportDataFieldTags["AGGREGATABLE_ATTRIBUTION_DATA"]=1]="AGGREGATABLE_ATTRIBUTION_DATA"})(WebUIReportDataFieldTags||(WebUIReportDataFieldTags={}));export function whichWebUIReportData(u){if(u.eventLevelData!==null&&u.eventLevelData!==undefined){return WebUIReportDataFieldTags.EVENT_LEVEL_DATA}if(u.aggregatableAttributionData!==null&&u.aggregatableAttributionData!==undefined){return WebUIReportDataFieldTags.AGGREGATABLE_ATTRIBUTION_DATA}throw new Error("no union field has been set, this is an illegal state")}mojo.internal.Union(NetworkStatusSpec.$,"NetworkStatus",{httpResponseCode:{ordinal:0,type:mojo.internal.Int32},networkError:{ordinal:1,type:mojo.internal.String}});export var NetworkStatusFieldTags;(function(NetworkStatusFieldTags){NetworkStatusFieldTags[NetworkStatusFieldTags["HTTP_RESPONSE_CODE"]=0]="HTTP_RESPONSE_CODE";NetworkStatusFieldTags[NetworkStatusFieldTags["NETWORK_ERROR"]=1]="NETWORK_ERROR"})(NetworkStatusFieldTags||(NetworkStatusFieldTags={}));export function whichNetworkStatus(u){if(u.httpResponseCode!==null&&u.httpResponseCode!==undefined){return NetworkStatusFieldTags.HTTP_RESPONSE_CODE}if(u.networkError!==null&&u.networkError!==undefined){return NetworkStatusFieldTags.NETWORK_ERROR}throw new Error("no union field has been set, this is an illegal state")}mojo.internal.Union(ReportStatusSpec.$,"ReportStatus",{pending:{ordinal:0,type:EmptySpec.$},replacedByHigherPriorityReport:{ordinal:1,type:mojo.internal.String},prohibitedByBrowserPolicy:{ordinal:2,type:EmptySpec.$},expired:{ordinal:3,type:EmptySpec.$},networkStatus:{ordinal:4,type:NetworkStatusSpec.$},failedToAssemble:{ordinal:5,type:EmptySpec.$}});export var ReportStatusFieldTags;(function(ReportStatusFieldTags){ReportStatusFieldTags[ReportStatusFieldTags["PENDING"]=0]="PENDING";ReportStatusFieldTags[ReportStatusFieldTags["REPLACED_BY_HIGHER_PRIORITY_REPORT"]=1]="REPLACED_BY_HIGHER_PRIORITY_REPORT";ReportStatusFieldTags[ReportStatusFieldTags["PROHIBITED_BY_BROWSER_POLICY"]=2]="PROHIBITED_BY_BROWSER_POLICY";ReportStatusFieldTags[ReportStatusFieldTags["EXPIRED"]=3]="EXPIRED";ReportStatusFieldTags[ReportStatusFieldTags["NETWORK_STATUS"]=4]="NETWORK_STATUS";ReportStatusFieldTags[ReportStatusFieldTags["FAILED_TO_ASSEMBLE"]=5]="FAILED_TO_ASSEMBLE"})(ReportStatusFieldTags||(ReportStatusFieldTags={}));export function whichReportStatus(u){if(u.pending!==null&&u.pending!==undefined){return ReportStatusFieldTags.PENDING}if(u.replacedByHigherPriorityReport!==null&&u.replacedByHigherPriorityReport!==undefined){return ReportStatusFieldTags.REPLACED_BY_HIGHER_PRIORITY_REPORT}if(u.prohibitedByBrowserPolicy!==null&&u.prohibitedByBrowserPolicy!==undefined){return ReportStatusFieldTags.PROHIBITED_BY_BROWSER_POLICY}if(u.expired!==null&&u.expired!==undefined){return ReportStatusFieldTags.EXPIRED}if(u.networkStatus!==null&&u.networkStatus!==undefined){return ReportStatusFieldTags.NETWORK_STATUS}if(u.failedToAssemble!==null&&u.failedToAssemble!==undefined){return ReportStatusFieldTags.FAILED_TO_ASSEMBLE}throw new Error("no union field has been set, this is an illegal state")}mojo.internal.Union(SendAggregatableDebugReportResultSpec.$,"SendAggregatableDebugReportResult",{assemblyFailed:{ordinal:0,type:EmptySpec.$},networkStatus:{ordinal:1,type:NetworkStatusSpec.$}});export var SendAggregatableDebugReportResultFieldTags;(function(SendAggregatableDebugReportResultFieldTags){SendAggregatableDebugReportResultFieldTags[SendAggregatableDebugReportResultFieldTags["ASSEMBLY_FAILED"]=0]="ASSEMBLY_FAILED";SendAggregatableDebugReportResultFieldTags[SendAggregatableDebugReportResultFieldTags["NETWORK_STATUS"]=1]="NETWORK_STATUS"})(SendAggregatableDebugReportResultFieldTags||(SendAggregatableDebugReportResultFieldTags={}));export function whichSendAggregatableDebugReportResult(u){if(u.assemblyFailed!==null&&u.assemblyFailed!==undefined){return SendAggregatableDebugReportResultFieldTags.ASSEMBLY_FAILED}if(u.networkStatus!==null&&u.networkStatus!==undefined){return SendAggregatableDebugReportResultFieldTags.NETWORK_STATUS}throw new Error("no union field has been set, this is an illegal state")}