// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";import{TimeSpec as mojoBase_mojom_TimeSpec}from"//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js";import{OriginSpec as url_mojom_OriginSpec}from"//resources/mojo/url/mojom/origin.mojom-webui.js";export class QuotaInternalsHandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"storage.mojom.QuotaInternalsHandler",scope)}}export class QuotaInternalsHandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(QuotaInternalsHandlerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}getDiskAvailabilityAndTempPoolSize(){return this.proxy.sendMessage(0,QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ParamsSpec.$,QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParamsSpec.$,[],false)}getStatistics(){return this.proxy.sendMessage(1,QuotaInternalsHandler_GetStatistics_ParamsSpec.$,QuotaInternalsHandler_GetStatistics_ResponseParamsSpec.$,[],false)}simulateStoragePressure(originUrl){this.proxy.sendMessage(2,QuotaInternalsHandler_SimulateStoragePressure_ParamsSpec.$,null,[originUrl],false)}retrieveBucketsTable(){return this.proxy.sendMessage(3,QuotaInternalsHandler_RetrieveBucketsTable_ParamsSpec.$,QuotaInternalsHandler_RetrieveBucketsTable_ResponseParamsSpec.$,[],false)}getGlobalUsageForInternals(){return this.proxy.sendMessage(4,QuotaInternalsHandler_GetGlobalUsageForInternals_ParamsSpec.$,QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParamsSpec.$,[],false)}isSimulateStoragePressureAvailable(){return this.proxy.sendMessage(5,QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ParamsSpec.$,QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParamsSpec.$,[],false)}}export class QuotaInternalsHandlerReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(QuotaInternalsHandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ParamsSpec.$,QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParamsSpec.$,impl.getDiskAvailabilityAndTempPoolSize.bind(impl),false);this.helper_internal_.registerHandler(1,QuotaInternalsHandler_GetStatistics_ParamsSpec.$,QuotaInternalsHandler_GetStatistics_ResponseParamsSpec.$,impl.getStatistics.bind(impl),false);this.helper_internal_.registerHandler(2,QuotaInternalsHandler_SimulateStoragePressure_ParamsSpec.$,null,impl.simulateStoragePressure.bind(impl),false);this.helper_internal_.registerHandler(3,QuotaInternalsHandler_RetrieveBucketsTable_ParamsSpec.$,QuotaInternalsHandler_RetrieveBucketsTable_ResponseParamsSpec.$,impl.retrieveBucketsTable.bind(impl),false);this.helper_internal_.registerHandler(4,QuotaInternalsHandler_GetGlobalUsageForInternals_ParamsSpec.$,QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParamsSpec.$,impl.getGlobalUsageForInternals.bind(impl),false);this.helper_internal_.registerHandler(5,QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ParamsSpec.$,QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParamsSpec.$,impl.isSimulateStoragePressureAvailable.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class QuotaInternalsHandler{static get $interfaceName(){return"storage.mojom.QuotaInternalsHandler"}static getRemote(){let remote=new QuotaInternalsHandlerRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class QuotaInternalsHandlerCallbackRouter{helper_internal_;$;router_;getDiskAvailabilityAndTempPoolSize;getStatistics;simulateStoragePressure;retrieveBucketsTable;getGlobalUsageForInternals;isSimulateStoragePressureAvailable;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(QuotaInternalsHandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.getDiskAvailabilityAndTempPoolSize=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ParamsSpec.$,QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParamsSpec.$,this.getDiskAvailabilityAndTempPoolSize.createReceiverHandler(true),false);this.getStatistics=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,QuotaInternalsHandler_GetStatistics_ParamsSpec.$,QuotaInternalsHandler_GetStatistics_ResponseParamsSpec.$,this.getStatistics.createReceiverHandler(true),false);this.simulateStoragePressure=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,QuotaInternalsHandler_SimulateStoragePressure_ParamsSpec.$,null,this.simulateStoragePressure.createReceiverHandler(false),false);this.retrieveBucketsTable=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,QuotaInternalsHandler_RetrieveBucketsTable_ParamsSpec.$,QuotaInternalsHandler_RetrieveBucketsTable_ResponseParamsSpec.$,this.retrieveBucketsTable.createReceiverHandler(true),false);this.getGlobalUsageForInternals=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,QuotaInternalsHandler_GetGlobalUsageForInternals_ParamsSpec.$,QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParamsSpec.$,this.getGlobalUsageForInternals.createReceiverHandler(true),false);this.isSimulateStoragePressureAvailable=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ParamsSpec.$,QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParamsSpec.$,this.isSimulateStoragePressureAvailable.createReceiverHandler(true),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const BucketTableEntrySpec={$:{}};export const QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ParamsSpec={$:{}};export const QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParamsSpec={$:{}};export const QuotaInternalsHandler_GetStatistics_ParamsSpec={$:{}};export const QuotaInternalsHandler_GetStatistics_ResponseParamsSpec={$:{}};export const QuotaInternalsHandler_SimulateStoragePressure_ParamsSpec={$:{}};export const QuotaInternalsHandler_RetrieveBucketsTable_ParamsSpec={$:{}};export const QuotaInternalsHandler_RetrieveBucketsTable_ResponseParamsSpec={$:{}};export const QuotaInternalsHandler_GetGlobalUsageForInternals_ParamsSpec={$:{}};export const QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParamsSpec={$:{}};export const QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ParamsSpec={$:{}};export const QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParamsSpec={$:{}};mojo.internal.Struct(BucketTableEntrySpec.$,"BucketTableEntry",[mojo.internal.StructField("bucketId",0,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined),mojo.internal.StructField("storageKey",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("name",16,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("usage",24,0,mojo.internal.Int64,BigInt("-1"),false,0,undefined,undefined),mojo.internal.StructField("useCount",32,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined),mojo.internal.StructField("lastAccessed",40,0,mojoBase_mojom_TimeSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("lastModified",48,0,mojoBase_mojom_TimeSpec.$,null,false,0,undefined,undefined)],[[0,64]]);mojo.internal.Struct(QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ParamsSpec.$,"QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_Params",[],[[0,8]]);mojo.internal.Struct(QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParamsSpec.$,"QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParams",[mojo.internal.StructField("totalSpace",0,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined),mojo.internal.StructField("availableSpace",8,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined),mojo.internal.StructField("tempPoolSize",16,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(QuotaInternalsHandler_GetStatistics_ParamsSpec.$,"QuotaInternalsHandler_GetStatistics_Params",[],[[0,8]]);mojo.internal.Struct(QuotaInternalsHandler_GetStatistics_ResponseParamsSpec.$,"QuotaInternalsHandler_GetStatistics_ResponseParams",[mojo.internal.StructField("evictionStatistics",0,0,mojo.internal.Map(mojo.internal.String,mojo.internal.String,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(QuotaInternalsHandler_SimulateStoragePressure_ParamsSpec.$,"QuotaInternalsHandler_SimulateStoragePressure_Params",[mojo.internal.StructField("originUrl",0,0,url_mojom_OriginSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(QuotaInternalsHandler_RetrieveBucketsTable_ParamsSpec.$,"QuotaInternalsHandler_RetrieveBucketsTable_Params",[],[[0,8]]);mojo.internal.Struct(QuotaInternalsHandler_RetrieveBucketsTable_ResponseParamsSpec.$,"QuotaInternalsHandler_RetrieveBucketsTable_ResponseParams",[mojo.internal.StructField("entries",0,0,mojo.internal.Array(BucketTableEntrySpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(QuotaInternalsHandler_GetGlobalUsageForInternals_ParamsSpec.$,"QuotaInternalsHandler_GetGlobalUsageForInternals_Params",[],[[0,8]]);mojo.internal.Struct(QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParamsSpec.$,"QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParams",[mojo.internal.StructField("usage",0,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined),mojo.internal.StructField("unlimitedUsage",8,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ParamsSpec.$,"QuotaInternalsHandler_IsSimulateStoragePressureAvailable_Params",[],[[0,8]]);mojo.internal.Struct(QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParamsSpec.$,"QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParams",[mojo.internal.StructField("available",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);