// content/web_test/common/fake_bluetooth_chooser.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('url.mojom.Origin');




goog.provide('content.mojom.ChooserEventType');
goog.provide('content.mojom.ChooserEventTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
content.mojom.ChooserEventTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
content.mojom.ChooserEventType = {
  
  CHOOSER_OPENED: 0,
  CHOOSER_CLOSED: 1,
  ADAPTER_REMOVED: 2,
  ADAPTER_DISABLED: 3,
  ADAPTER_ENABLED: 4,
  DISCOVERY_FAILED_TO_START: 5,
  DISCOVERING: 6,
  DISCOVERY_IDLE: 7,
  ADD_OR_UPDATE_DEVICE: 8,
  UNAUTHORIZED: 9,
  MIN_VALUE: 0,
  MAX_VALUE: 9,
};



goog.provide('content.mojom.FakeBluetoothChooser');
goog.provide('content.mojom.FakeBluetoothChooserReceiver');
goog.provide('content.mojom.FakeBluetoothChooserCallbackRouter');
goog.provide('content.mojom.FakeBluetoothChooserInterface');
goog.provide('content.mojom.FakeBluetoothChooserRemote');
goog.provide('content.mojom.FakeBluetoothChooserPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
content.mojom.FakeBluetoothChooserPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        content.mojom.FakeBluetoothChooser.$interfaceName,
        scope);
  }
};

/** @interface */
content.mojom.FakeBluetoothChooserInterface = class {
  
  /**
   * @param { !string } peripheralAddress
   */

  selectPeripheral(peripheralAddress) {}
  
  /**
   */

  cancel() {}
  
  /**
   */

  rescan() {}
};

/**
 * @export
 * @implements { content.mojom.FakeBluetoothChooserInterface }
 */
content.mojom.FakeBluetoothChooserRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!content.mojom.FakeBluetoothChooserPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          content.mojom.FakeBluetoothChooserPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!content.mojom.FakeBluetoothChooserPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } peripheralAddress
   */

  selectPeripheral(
      peripheralAddress) {
    this.proxy.sendMessage(
        0,
        content.mojom.FakeBluetoothChooser_SelectPeripheral_ParamsSpec.$,
        null,
        [
          peripheralAddress
        ],
        false);
  }

  
  /**
   */

  cancel() {
    this.proxy.sendMessage(
        1,
        content.mojom.FakeBluetoothChooser_Cancel_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  rescan() {
    this.proxy.sendMessage(
        2,
        content.mojom.FakeBluetoothChooser_Rescan_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FakeBluetoothChooser
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
content.mojom.FakeBluetoothChooserReceiver = class {
  /**
   * @param {!content.mojom.FakeBluetoothChooserInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!content.mojom.FakeBluetoothChooserRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        content.mojom.FakeBluetoothChooserRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!content.mojom.FakeBluetoothChooserRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        content.mojom.FakeBluetoothChooser_SelectPeripheral_ParamsSpec.$,
        null,
        impl.selectPeripheral.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        content.mojom.FakeBluetoothChooser_Cancel_ParamsSpec.$,
        null,
        impl.cancel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        content.mojom.FakeBluetoothChooser_Rescan_ParamsSpec.$,
        null,
        impl.rescan.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
content.mojom.FakeBluetoothChooser = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "content.mojom.FakeBluetoothChooser";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!content.mojom.FakeBluetoothChooserRemote}
   * @export
   */
  static getRemote() {
    let remote = new content.mojom.FakeBluetoothChooserRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FakeBluetoothChooser
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
content.mojom.FakeBluetoothChooserCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      content.mojom.FakeBluetoothChooserRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!content.mojom.FakeBluetoothChooserRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.selectPeripheral =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        content.mojom.FakeBluetoothChooser_SelectPeripheral_ParamsSpec.$,
        null,
        this.selectPeripheral.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        content.mojom.FakeBluetoothChooser_Cancel_ParamsSpec.$,
        null,
        this.cancel.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.rescan =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        content.mojom.FakeBluetoothChooser_Rescan_ParamsSpec.$,
        null,
        this.rescan.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('content.mojom.FakeBluetoothChooserFactory');
goog.provide('content.mojom.FakeBluetoothChooserFactoryReceiver');
goog.provide('content.mojom.FakeBluetoothChooserFactoryCallbackRouter');
goog.provide('content.mojom.FakeBluetoothChooserFactoryInterface');
goog.provide('content.mojom.FakeBluetoothChooserFactoryRemote');
goog.provide('content.mojom.FakeBluetoothChooserFactoryPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
content.mojom.FakeBluetoothChooserFactoryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        content.mojom.FakeBluetoothChooserFactory.$interfaceName,
        scope);
  }
};

/** @interface */
content.mojom.FakeBluetoothChooserFactoryInterface = class {
  
  /**
   * @param { !content.mojom.FakeBluetoothChooserPendingReceiver } fakeChooser
   * @param { !Object } client
   * @return {!Promise}
   */

  createFakeBluetoothChooser(fakeChooser, client) {}
};

/**
 * @export
 * @implements { content.mojom.FakeBluetoothChooserFactoryInterface }
 */
content.mojom.FakeBluetoothChooserFactoryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!content.mojom.FakeBluetoothChooserFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          content.mojom.FakeBluetoothChooserFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!content.mojom.FakeBluetoothChooserFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !content.mojom.FakeBluetoothChooserPendingReceiver } fakeChooser
   * @param { !Object } client
   * @return {!Promise}
   */

  createFakeBluetoothChooser(
      fakeChooser,
      client) {
    return this.proxy.sendMessage(
        0,
        content.mojom.FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ParamsSpec.$,
        content.mojom.FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParamsSpec.$,
        [
          fakeChooser,
          client
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FakeBluetoothChooserFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
content.mojom.FakeBluetoothChooserFactoryReceiver = class {
  /**
   * @param {!content.mojom.FakeBluetoothChooserFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!content.mojom.FakeBluetoothChooserFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        content.mojom.FakeBluetoothChooserFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!content.mojom.FakeBluetoothChooserFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        content.mojom.FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ParamsSpec.$,
        content.mojom.FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParamsSpec.$,
        impl.createFakeBluetoothChooser.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
content.mojom.FakeBluetoothChooserFactory = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "content.mojom.FakeBluetoothChooserFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!content.mojom.FakeBluetoothChooserFactoryRemote}
   * @export
   */
  static getRemote() {
    let remote = new content.mojom.FakeBluetoothChooserFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FakeBluetoothChooserFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
content.mojom.FakeBluetoothChooserFactoryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      content.mojom.FakeBluetoothChooserFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!content.mojom.FakeBluetoothChooserFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createFakeBluetoothChooser =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        content.mojom.FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ParamsSpec.$,
        content.mojom.FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParamsSpec.$,
        this.createFakeBluetoothChooser.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('content.mojom.FakeBluetoothChooserClient');
goog.provide('content.mojom.FakeBluetoothChooserClientReceiver');
goog.provide('content.mojom.FakeBluetoothChooserClientCallbackRouter');
goog.provide('content.mojom.FakeBluetoothChooserClientInterface');
goog.provide('content.mojom.FakeBluetoothChooserClientRemote');
goog.provide('content.mojom.FakeBluetoothChooserClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
content.mojom.FakeBluetoothChooserClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        content.mojom.FakeBluetoothChooserClient.$interfaceName,
        scope);
  }
};

/** @interface */
content.mojom.FakeBluetoothChooserClientInterface = class {
  
  /**
   * @param { !content.mojom.FakeBluetoothChooserEvent } event
   */

  onEvent(event) {}
};

/**
 * @export
 * @implements { content.mojom.FakeBluetoothChooserClientInterface }
 */
content.mojom.FakeBluetoothChooserClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!content.mojom.FakeBluetoothChooserClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          content.mojom.FakeBluetoothChooserClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!content.mojom.FakeBluetoothChooserClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !content.mojom.FakeBluetoothChooserEvent } event
   */

  onEvent(
      event) {
    this.proxy.sendMessage(
        0,
        content.mojom.FakeBluetoothChooserClient_OnEvent_ParamsSpec.$,
        null,
        [
          event
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FakeBluetoothChooserClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
content.mojom.FakeBluetoothChooserClientReceiver = class {
  /**
   * @param {!content.mojom.FakeBluetoothChooserClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!content.mojom.FakeBluetoothChooserClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        content.mojom.FakeBluetoothChooserClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!content.mojom.FakeBluetoothChooserClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        content.mojom.FakeBluetoothChooserClient_OnEvent_ParamsSpec.$,
        null,
        impl.onEvent.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
content.mojom.FakeBluetoothChooserClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "content.mojom.FakeBluetoothChooserClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!content.mojom.FakeBluetoothChooserClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new content.mojom.FakeBluetoothChooserClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FakeBluetoothChooserClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
content.mojom.FakeBluetoothChooserClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      content.mojom.FakeBluetoothChooserClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!content.mojom.FakeBluetoothChooserClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        content.mojom.FakeBluetoothChooserClient_OnEvent_ParamsSpec.$,
        null,
        this.onEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('content.mojom.FakeBluetoothChooserEventSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.FakeBluetoothChooserEventSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('content.mojom.FakeBluetoothChooser_SelectPeripheral_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.FakeBluetoothChooser_SelectPeripheral_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('content.mojom.FakeBluetoothChooser_Cancel_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.FakeBluetoothChooser_Cancel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('content.mojom.FakeBluetoothChooser_Rescan_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.FakeBluetoothChooser_Rescan_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('content.mojom.FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('content.mojom.FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('content.mojom.FakeBluetoothChooserClient_OnEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.FakeBluetoothChooserClient_OnEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    content.mojom.FakeBluetoothChooserEventSpec.$,
    'FakeBluetoothChooserEvent',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        content.mojom.ChooserEventTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'origin', 8,
        0,
        url.mojom.OriginSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'peripheralAddress', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('content.mojom.FakeBluetoothChooserEvent');

/** @record */
content.mojom.FakeBluetoothChooserEvent = class {
  constructor() {
    /** @export { !content.mojom.ChooserEventType } */
    this.type;
    /** @export { (url.mojom.Origin|undefined) } */
    this.origin;
    /** @export { (string|undefined) } */
    this.peripheralAddress;
  }
};



mojo.internal.Struct(
    content.mojom.FakeBluetoothChooser_SelectPeripheral_ParamsSpec.$,
    'FakeBluetoothChooser_SelectPeripheral_Params',
    [
      mojo.internal.StructField(
        'peripheralAddress', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('content.mojom.FakeBluetoothChooser_SelectPeripheral_Params');

/** @record */
content.mojom.FakeBluetoothChooser_SelectPeripheral_Params = class {
  constructor() {
    /** @export { !string } */
    this.peripheralAddress;
  }
};



mojo.internal.Struct(
    content.mojom.FakeBluetoothChooser_Cancel_ParamsSpec.$,
    'FakeBluetoothChooser_Cancel_Params',
    [
    ],
    [[0, 8],]);



goog.provide('content.mojom.FakeBluetoothChooser_Cancel_Params');

/** @record */
content.mojom.FakeBluetoothChooser_Cancel_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.FakeBluetoothChooser_Rescan_ParamsSpec.$,
    'FakeBluetoothChooser_Rescan_Params',
    [
    ],
    [[0, 8],]);



goog.provide('content.mojom.FakeBluetoothChooser_Rescan_Params');

/** @record */
content.mojom.FakeBluetoothChooser_Rescan_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ParamsSpec.$,
    'FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Params',
    [
      mojo.internal.StructField(
        'fakeChooser', 0,
        0,
        mojo.internal.InterfaceRequest(content.mojom.FakeBluetoothChooserPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 4,
        0,
        mojo.internal.AssociatedInterfaceProxy(content.mojom.FakeBluetoothChooserClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('content.mojom.FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Params');

/** @record */
content.mojom.FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Params = class {
  constructor() {
    /** @export { !content.mojom.FakeBluetoothChooserPendingReceiver } */
    this.fakeChooser;
    /** @export { !Object } */
    this.client;
  }
};



mojo.internal.Struct(
    content.mojom.FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParamsSpec.$,
    'FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('content.mojom.FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParams');

/** @record */
content.mojom.FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.FakeBluetoothChooserClient_OnEvent_ParamsSpec.$,
    'FakeBluetoothChooserClient_OnEvent_Params',
    [
      mojo.internal.StructField(
        'event', 0,
        0,
        content.mojom.FakeBluetoothChooserEventSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('content.mojom.FakeBluetoothChooserClient_OnEvent_Params');

/** @record */
content.mojom.FakeBluetoothChooserClient_OnEvent_Params = class {
  constructor() {
    /** @export { !content.mojom.FakeBluetoothChooserEvent } */
    this.event;
  }
};

