// content/web_test/common/fake_bluetooth_chooser.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../url/mojom/origin.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ChooserEventTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ChooserEventType = {
  
  CHOOSER_OPENED: 0,
  CHOOSER_CLOSED: 1,
  ADAPTER_REMOVED: 2,
  ADAPTER_DISABLED: 3,
  ADAPTER_ENABLED: 4,
  DISCOVERY_FAILED_TO_START: 5,
  DISCOVERING: 6,
  DISCOVERY_IDLE: 7,
  ADD_OR_UPDATE_DEVICE: 8,
  UNAUTHORIZED: 9,
  MIN_VALUE: 0,
  MAX_VALUE: 9,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FakeBluetoothChooserPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'content.mojom.FakeBluetoothChooser', scope);
  }
}

/** @interface */
export class FakeBluetoothChooserInterface {
  
  /**
   * @param { !string } peripheralAddress
   */

  selectPeripheral(peripheralAddress) {}
  
  /**
   */

  cancel() {}
  
  /**
   */

  rescan() {}
}

/**
 * @implements { FakeBluetoothChooserInterface }
 */
export class FakeBluetoothChooserRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FakeBluetoothChooserPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FakeBluetoothChooserPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FakeBluetoothChooserPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } peripheralAddress
   */

  selectPeripheral(
      peripheralAddress) {
    this.proxy.sendMessage(
        0,
        FakeBluetoothChooser_SelectPeripheral_ParamsSpec.$,
        null,
        [
          peripheralAddress
        ],
        false);
  }

  
  /**
   */

  cancel() {
    this.proxy.sendMessage(
        1,
        FakeBluetoothChooser_Cancel_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  rescan() {
    this.proxy.sendMessage(
        2,
        FakeBluetoothChooser_Rescan_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FakeBluetoothChooser
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FakeBluetoothChooserReceiver {
  /**
   * @param {!FakeBluetoothChooserInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FakeBluetoothChooserRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FakeBluetoothChooserRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FakeBluetoothChooserRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FakeBluetoothChooser_SelectPeripheral_ParamsSpec.$,
        null,
        impl.selectPeripheral.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        FakeBluetoothChooser_Cancel_ParamsSpec.$,
        null,
        impl.cancel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        FakeBluetoothChooser_Rescan_ParamsSpec.$,
        null,
        impl.rescan.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FakeBluetoothChooser {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "content.mojom.FakeBluetoothChooser";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FakeBluetoothChooserRemote}
   */
  static getRemote() {
    let remote = new FakeBluetoothChooserRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FakeBluetoothChooser
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FakeBluetoothChooserCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FakeBluetoothChooserRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FakeBluetoothChooserRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.selectPeripheral =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FakeBluetoothChooser_SelectPeripheral_ParamsSpec.$,
        null,
        this.selectPeripheral.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        FakeBluetoothChooser_Cancel_ParamsSpec.$,
        null,
        this.cancel.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.rescan =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        FakeBluetoothChooser_Rescan_ParamsSpec.$,
        null,
        this.rescan.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FakeBluetoothChooserFactoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'content.mojom.FakeBluetoothChooserFactory', scope);
  }
}

/** @interface */
export class FakeBluetoothChooserFactoryInterface {
  
  /**
   * @param { !FakeBluetoothChooserPendingReceiver } fakeChooser
   * @param { !Object } client
   * @return {!Promise}
   */

  createFakeBluetoothChooser(fakeChooser, client) {}
}

/**
 * @implements { FakeBluetoothChooserFactoryInterface }
 */
export class FakeBluetoothChooserFactoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FakeBluetoothChooserFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FakeBluetoothChooserFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FakeBluetoothChooserFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !FakeBluetoothChooserPendingReceiver } fakeChooser
   * @param { !Object } client
   * @return {!Promise}
   */

  createFakeBluetoothChooser(
      fakeChooser,
      client) {
    return this.proxy.sendMessage(
        0,
        FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ParamsSpec.$,
        FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParamsSpec.$,
        [
          fakeChooser,
          client
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FakeBluetoothChooserFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FakeBluetoothChooserFactoryReceiver {
  /**
   * @param {!FakeBluetoothChooserFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FakeBluetoothChooserFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FakeBluetoothChooserFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FakeBluetoothChooserFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ParamsSpec.$,
        FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParamsSpec.$,
        impl.createFakeBluetoothChooser.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FakeBluetoothChooserFactory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "content.mojom.FakeBluetoothChooserFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FakeBluetoothChooserFactoryRemote}
   */
  static getRemote() {
    let remote = new FakeBluetoothChooserFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FakeBluetoothChooserFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FakeBluetoothChooserFactoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FakeBluetoothChooserFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FakeBluetoothChooserFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createFakeBluetoothChooser =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ParamsSpec.$,
        FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParamsSpec.$,
        this.createFakeBluetoothChooser.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FakeBluetoothChooserClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'content.mojom.FakeBluetoothChooserClient', scope);
  }
}

/** @interface */
export class FakeBluetoothChooserClientInterface {
  
  /**
   * @param { !FakeBluetoothChooserEvent } event
   */

  onEvent(event) {}
}

/**
 * @implements { FakeBluetoothChooserClientInterface }
 */
export class FakeBluetoothChooserClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FakeBluetoothChooserClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FakeBluetoothChooserClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FakeBluetoothChooserClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !FakeBluetoothChooserEvent } event
   */

  onEvent(
      event) {
    this.proxy.sendMessage(
        0,
        FakeBluetoothChooserClient_OnEvent_ParamsSpec.$,
        null,
        [
          event
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FakeBluetoothChooserClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FakeBluetoothChooserClientReceiver {
  /**
   * @param {!FakeBluetoothChooserClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FakeBluetoothChooserClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FakeBluetoothChooserClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FakeBluetoothChooserClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FakeBluetoothChooserClient_OnEvent_ParamsSpec.$,
        null,
        impl.onEvent.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FakeBluetoothChooserClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "content.mojom.FakeBluetoothChooserClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FakeBluetoothChooserClientRemote}
   */
  static getRemote() {
    let remote = new FakeBluetoothChooserClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FakeBluetoothChooserClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FakeBluetoothChooserClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FakeBluetoothChooserClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FakeBluetoothChooserClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FakeBluetoothChooserClient_OnEvent_ParamsSpec.$,
        null,
        this.onEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FakeBluetoothChooserEventSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FakeBluetoothChooser_SelectPeripheral_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FakeBluetoothChooser_Cancel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FakeBluetoothChooser_Rescan_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FakeBluetoothChooserClient_OnEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    FakeBluetoothChooserEventSpec.$,
    'FakeBluetoothChooserEvent',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        ChooserEventTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'origin', 8,
        0,
        url_mojom_OriginSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'peripheralAddress', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class FakeBluetoothChooserEvent {
  constructor() {
    /** @type { !ChooserEventType } */
    this.type;
    /** @type { (url_mojom_Origin|undefined) } */
    this.origin;
    /** @type { (string|undefined) } */
    this.peripheralAddress;
  }
}



mojo.internal.Struct(
    FakeBluetoothChooser_SelectPeripheral_ParamsSpec.$,
    'FakeBluetoothChooser_SelectPeripheral_Params',
    [
      mojo.internal.StructField(
        'peripheralAddress', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FakeBluetoothChooser_SelectPeripheral_Params {
  constructor() {
    /** @type { !string } */
    this.peripheralAddress;
  }
}



mojo.internal.Struct(
    FakeBluetoothChooser_Cancel_ParamsSpec.$,
    'FakeBluetoothChooser_Cancel_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FakeBluetoothChooser_Cancel_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FakeBluetoothChooser_Rescan_ParamsSpec.$,
    'FakeBluetoothChooser_Rescan_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FakeBluetoothChooser_Rescan_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ParamsSpec.$,
    'FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Params',
    [
      mojo.internal.StructField(
        'fakeChooser', 0,
        0,
        mojo.internal.InterfaceRequest(FakeBluetoothChooserPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 4,
        0,
        mojo.internal.AssociatedInterfaceProxy(FakeBluetoothChooserClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_Params {
  constructor() {
    /** @type { !FakeBluetoothChooserPendingReceiver } */
    this.fakeChooser;
    /** @type { !Object } */
    this.client;
  }
}



mojo.internal.Struct(
    FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParamsSpec.$,
    'FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FakeBluetoothChooserFactory_CreateFakeBluetoothChooser_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    FakeBluetoothChooserClient_OnEvent_ParamsSpec.$,
    'FakeBluetoothChooserClient_OnEvent_Params',
    [
      mojo.internal.StructField(
        'event', 0,
        0,
        FakeBluetoothChooserEventSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FakeBluetoothChooserClient_OnEvent_Params {
  constructor() {
    /** @type { !FakeBluetoothChooserEvent } */
    this.event;
  }
}

