// content/web_test/common/mojo_echo.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('content.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
content.mojom.MojoEchoPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        content.mojom.MojoEcho.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { content.mojom.MojoEchoInterface }
 */
content.mojom.MojoEchoRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!content.mojom.MojoEchoPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          content.mojom.MojoEchoPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!content.mojom.MojoEchoPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !content.mojom.TestUnion } testUnion
   * @return {!Promise<{
        value: !boolean,
   *  }>}
   */

  echoBoolFromUnion(
      testUnion) {
    return this.proxy.sendMessage(
        0,
        content.mojom.MojoEcho_EchoBoolFromUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolFromUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @param { !content.mojom.TestUnion } testUnion
   * @return {!Promise<{
        value: !number,
   *  }>}
   */

  echoInt32FromUnion(
      testUnion) {
    return this.proxy.sendMessage(
        1,
        content.mojom.MojoEcho_EchoInt32FromUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoInt32FromUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @param { !content.mojom.TestUnion } testUnion
   * @return {!Promise<{
        value: !string,
   *  }>}
   */

  echoStringFromUnion(
      testUnion) {
    return this.proxy.sendMessage(
        2,
        content.mojom.MojoEcho_EchoStringFromUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoStringFromUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @param { !boolean } value
   * @return {!Promise<{
        testUnion: !content.mojom.TestUnion,
   *  }>}
   */

  echoBoolAsUnion(
      value) {
    return this.proxy.sendMessage(
        3,
        content.mojom.MojoEcho_EchoBoolAsUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolAsUnion_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !number } value
   * @return {!Promise<{
        testUnion: !content.mojom.TestUnion,
   *  }>}
   */

  echoInt32AsUnion(
      value) {
    return this.proxy.sendMessage(
        4,
        content.mojom.MojoEcho_EchoInt32AsUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoInt32AsUnion_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !string } value
   * @return {!Promise<{
        testUnion: !content.mojom.TestUnion,
   *  }>}
   */

  echoStringAsUnion(
      value) {
    return this.proxy.sendMessage(
        5,
        content.mojom.MojoEcho_EchoStringAsUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoStringAsUnion_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { ?content.mojom.TestUnion } testUnion
   * @return {!Promise}
   */

  echoNullFromOptionalUnion(
      testUnion) {
    return this.proxy.sendMessage(
        6,
        content.mojom.MojoEcho_EchoNullFromOptionalUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoNullFromOptionalUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @param { ?content.mojom.TestUnion } testUnion
   * @return {!Promise<{
        value: !boolean,
   *  }>}
   */

  echoBoolFromOptionalUnion(
      testUnion) {
    return this.proxy.sendMessage(
        7,
        content.mojom.MojoEcho_EchoBoolFromOptionalUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolFromOptionalUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @param { ?content.mojom.TestUnion } testUnion
   * @return {!Promise<{
        value: !number,
   *  }>}
   */

  echoInt32FromOptionalUnion(
      testUnion) {
    return this.proxy.sendMessage(
        8,
        content.mojom.MojoEcho_EchoInt32FromOptionalUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoInt32FromOptionalUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @param { ?content.mojom.TestUnion } testUnion
   * @return {!Promise<{
        value: !string,
   *  }>}
   */

  echoStringFromOptionalUnion(
      testUnion) {
    return this.proxy.sendMessage(
        9,
        content.mojom.MojoEcho_EchoStringFromOptionalUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoStringFromOptionalUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        testUnion: ?content.mojom.TestUnion,
   *  }>}
   */

  echoNullAsOptionalUnion() {
    return this.proxy.sendMessage(
        10,
        content.mojom.MojoEcho_EchoNullAsOptionalUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoNullAsOptionalUnion_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } value
   * @return {!Promise<{
        testUnion: ?content.mojom.TestUnion,
   *  }>}
   */

  echoBoolAsOptionalUnion(
      value) {
    return this.proxy.sendMessage(
        11,
        content.mojom.MojoEcho_EchoBoolAsOptionalUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolAsOptionalUnion_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !number } value
   * @return {!Promise<{
        testUnion: ?content.mojom.TestUnion,
   *  }>}
   */

  echoInt32AsOptionalUnion(
      value) {
    return this.proxy.sendMessage(
        12,
        content.mojom.MojoEcho_EchoInt32AsOptionalUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoInt32AsOptionalUnion_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !string } value
   * @return {!Promise<{
        testUnion: ?content.mojom.TestUnion,
   *  }>}
   */

  echoStringAsOptionalUnion(
      value) {
    return this.proxy.sendMessage(
        13,
        content.mojom.MojoEcho_EchoStringAsOptionalUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoStringAsOptionalUnion_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !content.mojom.NestedUnion } testUnion
   * @return {!Promise<{
        value: !number,
   *  }>}
   */

  echoInt8FromNestedUnion(
      testUnion) {
    return this.proxy.sendMessage(
        14,
        content.mojom.MojoEcho_EchoInt8FromNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoInt8FromNestedUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @param { !content.mojom.NestedUnion } testUnion
   * @return {!Promise<{
        value: !boolean,
   *  }>}
   */

  echoBoolFromNestedUnion(
      testUnion) {
    return this.proxy.sendMessage(
        15,
        content.mojom.MojoEcho_EchoBoolFromNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolFromNestedUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @param { !content.mojom.NestedUnion } testUnion
   * @return {!Promise<{
        value: !string,
   *  }>}
   */

  echoStringFromNestedUnion(
      testUnion) {
    return this.proxy.sendMessage(
        16,
        content.mojom.MojoEcho_EchoStringFromNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoStringFromNestedUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @param { !number } value
   * @return {!Promise<{
        testUnion: !content.mojom.NestedUnion,
   *  }>}
   */

  echoInt8AsNestedUnion(
      value) {
    return this.proxy.sendMessage(
        17,
        content.mojom.MojoEcho_EchoInt8AsNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoInt8AsNestedUnion_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !boolean } value
   * @return {!Promise<{
        testUnion: !content.mojom.NestedUnion,
   *  }>}
   */

  echoBoolAsNestedUnion(
      value) {
    return this.proxy.sendMessage(
        18,
        content.mojom.MojoEcho_EchoBoolAsNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolAsNestedUnion_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !string } value
   * @return {!Promise<{
        testUnion: !content.mojom.NestedUnion,
   *  }>}
   */

  echoStringAsNestedUnion(
      value) {
    return this.proxy.sendMessage(
        19,
        content.mojom.MojoEcho_EchoStringAsNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoStringAsNestedUnion_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { ?content.mojom.NestedUnion } testUnion
   * @return {!Promise}
   */

  echoNullFromOptionalNestedUnion(
      testUnion) {
    return this.proxy.sendMessage(
        20,
        content.mojom.MojoEcho_EchoNullFromOptionalNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoNullFromOptionalNestedUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @param { ?content.mojom.NestedUnion } testUnion
   * @return {!Promise<{
        value: !number,
   *  }>}
   */

  echoInt8FromOptionalNestedUnion(
      testUnion) {
    return this.proxy.sendMessage(
        21,
        content.mojom.MojoEcho_EchoInt8FromOptionalNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoInt8FromOptionalNestedUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @param { ?content.mojom.NestedUnion } testUnion
   * @return {!Promise<{
        value: !boolean,
   *  }>}
   */

  echoBoolFromOptionalNestedUnion(
      testUnion) {
    return this.proxy.sendMessage(
        22,
        content.mojom.MojoEcho_EchoBoolFromOptionalNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolFromOptionalNestedUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @param { ?content.mojom.NestedUnion } testUnion
   * @return {!Promise<{
        value: !string,
   *  }>}
   */

  echoStringFromOptionalNestedUnion(
      testUnion) {
    return this.proxy.sendMessage(
        23,
        content.mojom.MojoEcho_EchoStringFromOptionalNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoStringFromOptionalNestedUnion_ResponseParamsSpec.$,
        [
          testUnion
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        testUnion: ?content.mojom.NestedUnion,
   *  }>}
   */

  echoNullAsOptionalNestedUnion() {
    return this.proxy.sendMessage(
        24,
        content.mojom.MojoEcho_EchoNullAsOptionalNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoNullAsOptionalNestedUnion_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } value
   * @return {!Promise<{
        testUnion: ?content.mojom.NestedUnion,
   *  }>}
   */

  echoInt8AsOptionalNestedUnion(
      value) {
    return this.proxy.sendMessage(
        25,
        content.mojom.MojoEcho_EchoInt8AsOptionalNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoInt8AsOptionalNestedUnion_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !boolean } value
   * @return {!Promise<{
        testUnion: ?content.mojom.NestedUnion,
   *  }>}
   */

  echoBoolAsOptionalNestedUnion(
      value) {
    return this.proxy.sendMessage(
        26,
        content.mojom.MojoEcho_EchoBoolAsOptionalNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolAsOptionalNestedUnion_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !string } value
   * @return {!Promise<{
        testUnion: ?content.mojom.NestedUnion,
   *  }>}
   */

  echoStringAsOptionalNestedUnion(
      value) {
    return this.proxy.sendMessage(
        27,
        content.mojom.MojoEcho_EchoStringAsOptionalNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoStringAsOptionalNestedUnion_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !Array<!boolean> } values
   * @return {!Promise<{
        values: !Array<!boolean>,
   *  }>}
   */

  echoBoolArray(
      values) {
    return this.proxy.sendMessage(
        28,
        content.mojom.MojoEcho_EchoBoolArray_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolArray_ResponseParamsSpec.$,
        [
          values
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MojoEcho
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
content.mojom.MojoEchoReceiver = class {
  /**
   * @param {!content.mojom.MojoEchoInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!content.mojom.MojoEchoRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        content.mojom.MojoEchoRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!content.mojom.MojoEchoRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        content.mojom.MojoEcho_EchoBoolFromUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolFromUnion_ResponseParamsSpec.$,
        impl.echoBoolFromUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        content.mojom.MojoEcho_EchoInt32FromUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoInt32FromUnion_ResponseParamsSpec.$,
        impl.echoInt32FromUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        content.mojom.MojoEcho_EchoStringFromUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoStringFromUnion_ResponseParamsSpec.$,
        impl.echoStringFromUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        content.mojom.MojoEcho_EchoBoolAsUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolAsUnion_ResponseParamsSpec.$,
        impl.echoBoolAsUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        content.mojom.MojoEcho_EchoInt32AsUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoInt32AsUnion_ResponseParamsSpec.$,
        impl.echoInt32AsUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        content.mojom.MojoEcho_EchoStringAsUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoStringAsUnion_ResponseParamsSpec.$,
        impl.echoStringAsUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        content.mojom.MojoEcho_EchoNullFromOptionalUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoNullFromOptionalUnion_ResponseParamsSpec.$,
        impl.echoNullFromOptionalUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        content.mojom.MojoEcho_EchoBoolFromOptionalUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolFromOptionalUnion_ResponseParamsSpec.$,
        impl.echoBoolFromOptionalUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        content.mojom.MojoEcho_EchoInt32FromOptionalUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoInt32FromOptionalUnion_ResponseParamsSpec.$,
        impl.echoInt32FromOptionalUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        content.mojom.MojoEcho_EchoStringFromOptionalUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoStringFromOptionalUnion_ResponseParamsSpec.$,
        impl.echoStringFromOptionalUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        content.mojom.MojoEcho_EchoNullAsOptionalUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoNullAsOptionalUnion_ResponseParamsSpec.$,
        impl.echoNullAsOptionalUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        content.mojom.MojoEcho_EchoBoolAsOptionalUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolAsOptionalUnion_ResponseParamsSpec.$,
        impl.echoBoolAsOptionalUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        content.mojom.MojoEcho_EchoInt32AsOptionalUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoInt32AsOptionalUnion_ResponseParamsSpec.$,
        impl.echoInt32AsOptionalUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        content.mojom.MojoEcho_EchoStringAsOptionalUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoStringAsOptionalUnion_ResponseParamsSpec.$,
        impl.echoStringAsOptionalUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        content.mojom.MojoEcho_EchoInt8FromNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoInt8FromNestedUnion_ResponseParamsSpec.$,
        impl.echoInt8FromNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        content.mojom.MojoEcho_EchoBoolFromNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolFromNestedUnion_ResponseParamsSpec.$,
        impl.echoBoolFromNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        content.mojom.MojoEcho_EchoStringFromNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoStringFromNestedUnion_ResponseParamsSpec.$,
        impl.echoStringFromNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        content.mojom.MojoEcho_EchoInt8AsNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoInt8AsNestedUnion_ResponseParamsSpec.$,
        impl.echoInt8AsNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        content.mojom.MojoEcho_EchoBoolAsNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolAsNestedUnion_ResponseParamsSpec.$,
        impl.echoBoolAsNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        content.mojom.MojoEcho_EchoStringAsNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoStringAsNestedUnion_ResponseParamsSpec.$,
        impl.echoStringAsNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        content.mojom.MojoEcho_EchoNullFromOptionalNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoNullFromOptionalNestedUnion_ResponseParamsSpec.$,
        impl.echoNullFromOptionalNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        content.mojom.MojoEcho_EchoInt8FromOptionalNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoInt8FromOptionalNestedUnion_ResponseParamsSpec.$,
        impl.echoInt8FromOptionalNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        content.mojom.MojoEcho_EchoBoolFromOptionalNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolFromOptionalNestedUnion_ResponseParamsSpec.$,
        impl.echoBoolFromOptionalNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        content.mojom.MojoEcho_EchoStringFromOptionalNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoStringFromOptionalNestedUnion_ResponseParamsSpec.$,
        impl.echoStringFromOptionalNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        content.mojom.MojoEcho_EchoNullAsOptionalNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoNullAsOptionalNestedUnion_ResponseParamsSpec.$,
        impl.echoNullAsOptionalNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        content.mojom.MojoEcho_EchoInt8AsOptionalNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoInt8AsOptionalNestedUnion_ResponseParamsSpec.$,
        impl.echoInt8AsOptionalNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        content.mojom.MojoEcho_EchoBoolAsOptionalNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolAsOptionalNestedUnion_ResponseParamsSpec.$,
        impl.echoBoolAsOptionalNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        27,
        content.mojom.MojoEcho_EchoStringAsOptionalNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoStringAsOptionalNestedUnion_ResponseParamsSpec.$,
        impl.echoStringAsOptionalNestedUnion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        28,
        content.mojom.MojoEcho_EchoBoolArray_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolArray_ResponseParamsSpec.$,
        impl.echoBoolArray.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
content.mojom.MojoEcho = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "content.mojom.MojoEcho";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!content.mojom.MojoEchoRemote}
   * @export
   */
  static getRemote() {
    let remote = new content.mojom.MojoEchoRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MojoEcho
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
content.mojom.MojoEchoCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      content.mojom.MojoEchoRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!content.mojom.MojoEchoRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoBoolFromUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        content.mojom.MojoEcho_EchoBoolFromUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolFromUnion_ResponseParamsSpec.$,
        this.echoBoolFromUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoInt32FromUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        content.mojom.MojoEcho_EchoInt32FromUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoInt32FromUnion_ResponseParamsSpec.$,
        this.echoInt32FromUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoStringFromUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        content.mojom.MojoEcho_EchoStringFromUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoStringFromUnion_ResponseParamsSpec.$,
        this.echoStringFromUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoBoolAsUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        content.mojom.MojoEcho_EchoBoolAsUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolAsUnion_ResponseParamsSpec.$,
        this.echoBoolAsUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoInt32AsUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        content.mojom.MojoEcho_EchoInt32AsUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoInt32AsUnion_ResponseParamsSpec.$,
        this.echoInt32AsUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoStringAsUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        content.mojom.MojoEcho_EchoStringAsUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoStringAsUnion_ResponseParamsSpec.$,
        this.echoStringAsUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoNullFromOptionalUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        content.mojom.MojoEcho_EchoNullFromOptionalUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoNullFromOptionalUnion_ResponseParamsSpec.$,
        this.echoNullFromOptionalUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoBoolFromOptionalUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        content.mojom.MojoEcho_EchoBoolFromOptionalUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolFromOptionalUnion_ResponseParamsSpec.$,
        this.echoBoolFromOptionalUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoInt32FromOptionalUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        content.mojom.MojoEcho_EchoInt32FromOptionalUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoInt32FromOptionalUnion_ResponseParamsSpec.$,
        this.echoInt32FromOptionalUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoStringFromOptionalUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        content.mojom.MojoEcho_EchoStringFromOptionalUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoStringFromOptionalUnion_ResponseParamsSpec.$,
        this.echoStringFromOptionalUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoNullAsOptionalUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        content.mojom.MojoEcho_EchoNullAsOptionalUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoNullAsOptionalUnion_ResponseParamsSpec.$,
        this.echoNullAsOptionalUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoBoolAsOptionalUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        content.mojom.MojoEcho_EchoBoolAsOptionalUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolAsOptionalUnion_ResponseParamsSpec.$,
        this.echoBoolAsOptionalUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoInt32AsOptionalUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        content.mojom.MojoEcho_EchoInt32AsOptionalUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoInt32AsOptionalUnion_ResponseParamsSpec.$,
        this.echoInt32AsOptionalUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoStringAsOptionalUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        content.mojom.MojoEcho_EchoStringAsOptionalUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoStringAsOptionalUnion_ResponseParamsSpec.$,
        this.echoStringAsOptionalUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoInt8FromNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        content.mojom.MojoEcho_EchoInt8FromNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoInt8FromNestedUnion_ResponseParamsSpec.$,
        this.echoInt8FromNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoBoolFromNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        content.mojom.MojoEcho_EchoBoolFromNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolFromNestedUnion_ResponseParamsSpec.$,
        this.echoBoolFromNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoStringFromNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        content.mojom.MojoEcho_EchoStringFromNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoStringFromNestedUnion_ResponseParamsSpec.$,
        this.echoStringFromNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoInt8AsNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        content.mojom.MojoEcho_EchoInt8AsNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoInt8AsNestedUnion_ResponseParamsSpec.$,
        this.echoInt8AsNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoBoolAsNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        content.mojom.MojoEcho_EchoBoolAsNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolAsNestedUnion_ResponseParamsSpec.$,
        this.echoBoolAsNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoStringAsNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        content.mojom.MojoEcho_EchoStringAsNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoStringAsNestedUnion_ResponseParamsSpec.$,
        this.echoStringAsNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoNullFromOptionalNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        content.mojom.MojoEcho_EchoNullFromOptionalNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoNullFromOptionalNestedUnion_ResponseParamsSpec.$,
        this.echoNullFromOptionalNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoInt8FromOptionalNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        content.mojom.MojoEcho_EchoInt8FromOptionalNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoInt8FromOptionalNestedUnion_ResponseParamsSpec.$,
        this.echoInt8FromOptionalNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoBoolFromOptionalNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        content.mojom.MojoEcho_EchoBoolFromOptionalNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolFromOptionalNestedUnion_ResponseParamsSpec.$,
        this.echoBoolFromOptionalNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoStringFromOptionalNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        content.mojom.MojoEcho_EchoStringFromOptionalNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoStringFromOptionalNestedUnion_ResponseParamsSpec.$,
        this.echoStringFromOptionalNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoNullAsOptionalNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        content.mojom.MojoEcho_EchoNullAsOptionalNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoNullAsOptionalNestedUnion_ResponseParamsSpec.$,
        this.echoNullAsOptionalNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoInt8AsOptionalNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        content.mojom.MojoEcho_EchoInt8AsOptionalNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoInt8AsOptionalNestedUnion_ResponseParamsSpec.$,
        this.echoInt8AsOptionalNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoBoolAsOptionalNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        content.mojom.MojoEcho_EchoBoolAsOptionalNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolAsOptionalNestedUnion_ResponseParamsSpec.$,
        this.echoBoolAsOptionalNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoStringAsOptionalNestedUnion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        27,
        content.mojom.MojoEcho_EchoStringAsOptionalNestedUnion_ParamsSpec.$,
        content.mojom.MojoEcho_EchoStringAsOptionalNestedUnion_ResponseParamsSpec.$,
        this.echoStringAsOptionalNestedUnion.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.echoBoolArray =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        28,
        content.mojom.MojoEcho_EchoBoolArray_ParamsSpec.$,
        content.mojom.MojoEcho_EchoBoolArray_ResponseParamsSpec.$,
        this.echoBoolArray.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoBoolFromUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoBoolFromUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoInt32FromUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoInt32FromUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoStringFromUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoStringFromUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoBoolAsUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoBoolAsUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoInt32AsUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoInt32AsUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoStringAsUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoStringAsUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoNullFromOptionalUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoNullFromOptionalUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoBoolFromOptionalUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoBoolFromOptionalUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoInt32FromOptionalUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoInt32FromOptionalUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoStringFromOptionalUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoStringFromOptionalUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoNullAsOptionalUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoNullAsOptionalUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoBoolAsOptionalUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoBoolAsOptionalUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoInt32AsOptionalUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoInt32AsOptionalUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoStringAsOptionalUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoStringAsOptionalUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoInt8FromNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoInt8FromNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoBoolFromNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoBoolFromNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoStringFromNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoStringFromNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoInt8AsNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoInt8AsNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoBoolAsNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoBoolAsNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoStringAsNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoStringAsNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoNullFromOptionalNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoNullFromOptionalNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoInt8FromOptionalNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoInt8FromOptionalNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoBoolFromOptionalNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoBoolFromOptionalNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoStringFromOptionalNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoStringFromOptionalNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoNullAsOptionalNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoNullAsOptionalNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoInt8AsOptionalNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoInt8AsOptionalNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoBoolAsOptionalNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoBoolAsOptionalNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoStringAsOptionalNestedUnion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoStringAsOptionalNestedUnion_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoBoolArray_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.MojoEcho_EchoBoolArray_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
content.mojom.TestUnionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
content.mojom.NestedUnionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    content.mojom.MojoEcho_EchoBoolFromUnion_ParamsSpec.$,
    'MojoEcho_EchoBoolFromUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.TestUnionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoBoolFromUnion_Params = class {
  constructor() {
    /** @export { !content.mojom.TestUnion } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoBoolFromUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoBoolFromUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoBoolFromUnion_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.value;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoInt32FromUnion_ParamsSpec.$,
    'MojoEcho_EchoInt32FromUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.TestUnionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoInt32FromUnion_Params = class {
  constructor() {
    /** @export { !content.mojom.TestUnion } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoInt32FromUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoInt32FromUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoInt32FromUnion_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.value;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoStringFromUnion_ParamsSpec.$,
    'MojoEcho_EchoStringFromUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.TestUnionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoStringFromUnion_Params = class {
  constructor() {
    /** @export { !content.mojom.TestUnion } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoStringFromUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoStringFromUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoStringFromUnion_ResponseParams = class {
  constructor() {
    /** @export { !string } */
    this.value;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoBoolAsUnion_ParamsSpec.$,
    'MojoEcho_EchoBoolAsUnion_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoBoolAsUnion_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.value;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoBoolAsUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoBoolAsUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.TestUnionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoBoolAsUnion_ResponseParams = class {
  constructor() {
    /** @export { !content.mojom.TestUnion } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoInt32AsUnion_ParamsSpec.$,
    'MojoEcho_EchoInt32AsUnion_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoInt32AsUnion_Params = class {
  constructor() {
    /** @export { !number } */
    this.value;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoInt32AsUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoInt32AsUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.TestUnionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoInt32AsUnion_ResponseParams = class {
  constructor() {
    /** @export { !content.mojom.TestUnion } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoStringAsUnion_ParamsSpec.$,
    'MojoEcho_EchoStringAsUnion_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoStringAsUnion_Params = class {
  constructor() {
    /** @export { !string } */
    this.value;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoStringAsUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoStringAsUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.TestUnionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoStringAsUnion_ResponseParams = class {
  constructor() {
    /** @export { !content.mojom.TestUnion } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoNullFromOptionalUnion_ParamsSpec.$,
    'MojoEcho_EchoNullFromOptionalUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.TestUnionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoNullFromOptionalUnion_Params = class {
  constructor() {
    /** @export { (content.mojom.TestUnion|undefined) } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoNullFromOptionalUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoNullFromOptionalUnion_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.MojoEcho_EchoNullFromOptionalUnion_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoBoolFromOptionalUnion_ParamsSpec.$,
    'MojoEcho_EchoBoolFromOptionalUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.TestUnionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoBoolFromOptionalUnion_Params = class {
  constructor() {
    /** @export { (content.mojom.TestUnion|undefined) } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoBoolFromOptionalUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoBoolFromOptionalUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoBoolFromOptionalUnion_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.value;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoInt32FromOptionalUnion_ParamsSpec.$,
    'MojoEcho_EchoInt32FromOptionalUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.TestUnionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoInt32FromOptionalUnion_Params = class {
  constructor() {
    /** @export { (content.mojom.TestUnion|undefined) } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoInt32FromOptionalUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoInt32FromOptionalUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoInt32FromOptionalUnion_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.value;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoStringFromOptionalUnion_ParamsSpec.$,
    'MojoEcho_EchoStringFromOptionalUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.TestUnionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoStringFromOptionalUnion_Params = class {
  constructor() {
    /** @export { (content.mojom.TestUnion|undefined) } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoStringFromOptionalUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoStringFromOptionalUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoStringFromOptionalUnion_ResponseParams = class {
  constructor() {
    /** @export { !string } */
    this.value;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoNullAsOptionalUnion_ParamsSpec.$,
    'MojoEcho_EchoNullAsOptionalUnion_Params',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.MojoEcho_EchoNullAsOptionalUnion_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoNullAsOptionalUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoNullAsOptionalUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.TestUnionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoNullAsOptionalUnion_ResponseParams = class {
  constructor() {
    /** @export { (content.mojom.TestUnion|undefined) } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoBoolAsOptionalUnion_ParamsSpec.$,
    'MojoEcho_EchoBoolAsOptionalUnion_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoBoolAsOptionalUnion_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.value;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoBoolAsOptionalUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoBoolAsOptionalUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.TestUnionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoBoolAsOptionalUnion_ResponseParams = class {
  constructor() {
    /** @export { (content.mojom.TestUnion|undefined) } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoInt32AsOptionalUnion_ParamsSpec.$,
    'MojoEcho_EchoInt32AsOptionalUnion_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoInt32AsOptionalUnion_Params = class {
  constructor() {
    /** @export { !number } */
    this.value;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoInt32AsOptionalUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoInt32AsOptionalUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.TestUnionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoInt32AsOptionalUnion_ResponseParams = class {
  constructor() {
    /** @export { (content.mojom.TestUnion|undefined) } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoStringAsOptionalUnion_ParamsSpec.$,
    'MojoEcho_EchoStringAsOptionalUnion_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoStringAsOptionalUnion_Params = class {
  constructor() {
    /** @export { !string } */
    this.value;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoStringAsOptionalUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoStringAsOptionalUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.TestUnionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoStringAsOptionalUnion_ResponseParams = class {
  constructor() {
    /** @export { (content.mojom.TestUnion|undefined) } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoInt8FromNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoInt8FromNestedUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.NestedUnionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoInt8FromNestedUnion_Params = class {
  constructor() {
    /** @export { !content.mojom.NestedUnion } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoInt8FromNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoInt8FromNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Int8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoInt8FromNestedUnion_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.value;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoBoolFromNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoBoolFromNestedUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.NestedUnionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoBoolFromNestedUnion_Params = class {
  constructor() {
    /** @export { !content.mojom.NestedUnion } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoBoolFromNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoBoolFromNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoBoolFromNestedUnion_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.value;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoStringFromNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoStringFromNestedUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.NestedUnionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoStringFromNestedUnion_Params = class {
  constructor() {
    /** @export { !content.mojom.NestedUnion } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoStringFromNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoStringFromNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoStringFromNestedUnion_ResponseParams = class {
  constructor() {
    /** @export { !string } */
    this.value;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoInt8AsNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoInt8AsNestedUnion_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Int8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoInt8AsNestedUnion_Params = class {
  constructor() {
    /** @export { !number } */
    this.value;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoInt8AsNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoInt8AsNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.NestedUnionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoInt8AsNestedUnion_ResponseParams = class {
  constructor() {
    /** @export { !content.mojom.NestedUnion } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoBoolAsNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoBoolAsNestedUnion_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoBoolAsNestedUnion_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.value;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoBoolAsNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoBoolAsNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.NestedUnionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoBoolAsNestedUnion_ResponseParams = class {
  constructor() {
    /** @export { !content.mojom.NestedUnion } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoStringAsNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoStringAsNestedUnion_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoStringAsNestedUnion_Params = class {
  constructor() {
    /** @export { !string } */
    this.value;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoStringAsNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoStringAsNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.NestedUnionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoStringAsNestedUnion_ResponseParams = class {
  constructor() {
    /** @export { !content.mojom.NestedUnion } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoNullFromOptionalNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoNullFromOptionalNestedUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.NestedUnionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoNullFromOptionalNestedUnion_Params = class {
  constructor() {
    /** @export { (content.mojom.NestedUnion|undefined) } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoNullFromOptionalNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoNullFromOptionalNestedUnion_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.MojoEcho_EchoNullFromOptionalNestedUnion_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoInt8FromOptionalNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoInt8FromOptionalNestedUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.NestedUnionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoInt8FromOptionalNestedUnion_Params = class {
  constructor() {
    /** @export { (content.mojom.NestedUnion|undefined) } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoInt8FromOptionalNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoInt8FromOptionalNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Int8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoInt8FromOptionalNestedUnion_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.value;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoBoolFromOptionalNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoBoolFromOptionalNestedUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.NestedUnionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoBoolFromOptionalNestedUnion_Params = class {
  constructor() {
    /** @export { (content.mojom.NestedUnion|undefined) } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoBoolFromOptionalNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoBoolFromOptionalNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoBoolFromOptionalNestedUnion_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.value;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoStringFromOptionalNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoStringFromOptionalNestedUnion_Params',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.NestedUnionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoStringFromOptionalNestedUnion_Params = class {
  constructor() {
    /** @export { (content.mojom.NestedUnion|undefined) } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoStringFromOptionalNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoStringFromOptionalNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoStringFromOptionalNestedUnion_ResponseParams = class {
  constructor() {
    /** @export { !string } */
    this.value;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoNullAsOptionalNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoNullAsOptionalNestedUnion_Params',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.MojoEcho_EchoNullAsOptionalNestedUnion_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoNullAsOptionalNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoNullAsOptionalNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.NestedUnionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoNullAsOptionalNestedUnion_ResponseParams = class {
  constructor() {
    /** @export { (content.mojom.NestedUnion|undefined) } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoInt8AsOptionalNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoInt8AsOptionalNestedUnion_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Int8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoInt8AsOptionalNestedUnion_Params = class {
  constructor() {
    /** @export { !number } */
    this.value;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoInt8AsOptionalNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoInt8AsOptionalNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.NestedUnionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoInt8AsOptionalNestedUnion_ResponseParams = class {
  constructor() {
    /** @export { (content.mojom.NestedUnion|undefined) } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoBoolAsOptionalNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoBoolAsOptionalNestedUnion_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoBoolAsOptionalNestedUnion_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.value;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoBoolAsOptionalNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoBoolAsOptionalNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.NestedUnionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoBoolAsOptionalNestedUnion_ResponseParams = class {
  constructor() {
    /** @export { (content.mojom.NestedUnion|undefined) } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoStringAsOptionalNestedUnion_ParamsSpec.$,
    'MojoEcho_EchoStringAsOptionalNestedUnion_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoStringAsOptionalNestedUnion_Params = class {
  constructor() {
    /** @export { !string } */
    this.value;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoStringAsOptionalNestedUnion_ResponseParamsSpec.$,
    'MojoEcho_EchoStringAsOptionalNestedUnion_ResponseParams',
    [
      mojo.internal.StructField(
        'testUnion', 0,
        0,
        content.mojom.NestedUnionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
content.mojom.MojoEcho_EchoStringAsOptionalNestedUnion_ResponseParams = class {
  constructor() {
    /** @export { (content.mojom.NestedUnion|undefined) } */
    this.testUnion;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoBoolArray_ParamsSpec.$,
    'MojoEcho_EchoBoolArray_Params',
    [
      mojo.internal.StructField(
        'values', 0,
        0,
        mojo.internal.Array(mojo.internal.Bool, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoBoolArray_Params = class {
  constructor() {
    /** @export { !Array<!boolean> } */
    this.values;
  }
};



mojo.internal.Struct(
    content.mojom.MojoEcho_EchoBoolArray_ResponseParamsSpec.$,
    'MojoEcho_EchoBoolArray_ResponseParams',
    [
      mojo.internal.StructField(
        'values', 0,
        0,
        mojo.internal.Array(mojo.internal.Bool, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.MojoEcho_EchoBoolArray_ResponseParams = class {
  constructor() {
    /** @export { !Array<!boolean> } */
    this.values;
  }
};



mojo.internal.Union(
    content.mojom.TestUnionSpec.$, 'TestUnion',
    {
      'boolValue': {
        'ordinal': 0,
        'type': mojo.internal.Bool,
      },
      'int32Value': {
        'ordinal': 1,
        'type': mojo.internal.Int32,
      },
      'stringValue': {
        'ordinal': 2,
        'type': mojo.internal.String,
      },
    });

/**
 * @typedef { {
 *   boolValue: (!boolean|undefined),
 *   int32Value: (!number|undefined),
 *   stringValue: (!string|undefined),
 * } }
 */
content.mojom.TestUnion;


mojo.internal.Union(
    content.mojom.NestedUnionSpec.$, 'NestedUnion',
    {
      'int8Value': {
        'ordinal': 0,
        'type': mojo.internal.Int8,
      },
      'unionValue': {
        'ordinal': 1,
        'type': content.mojom.TestUnionSpec.$,
      },
    });

/**
 * @typedef { {
 *   int8Value: (!number|undefined),
 *   unionValue: (!content.mojom.TestUnion|undefined),
 * } }
 */
content.mojom.NestedUnion;
