// content/web_test/common/mojo_optional_numerics_unittest.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'content/web_test/common/mojo_optional_numerics_unittest.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('content.optionalNumericsUnittest.mojom');


  var RegularEnum = {};
  RegularEnum.kFoo = 1;
  RegularEnum.kBar = 2;
  RegularEnum.MIN_VALUE = 1;
  RegularEnum.MAX_VALUE = 2;

  RegularEnum.isKnownEnumValue = function(value) {
    switch (value) {
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  RegularEnum.toKnownEnumValue = function(value) {
    return value;
  };

  RegularEnum.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function OptionalNumericsStruct(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OptionalNumericsStruct.prototype.initDefaults_ = function() {
    this.optional_bool_$flag = false;
    this.optional_bool_$value = false;
    this.optional_uint8_$flag = false;
    this.optional_int8_$flag = false;
    this.optional_uint16_$flag = false;
    this.optional_int16_$flag = false;
    this.optional_uint32_$flag = false;
    this.optional_int32_$flag = false;
    this.optional_uint8_$value = 0;
    this.optional_int8_$value = 0;
    this.optional_uint64_$flag = false;
    this.optional_int64_$flag = false;
    this.optional_float_$flag = false;
    this.optional_double_$flag = false;
    this.optional_enum_$flag = false;
    this.optional_uint16_$value = 0;
    this.optional_int16_$value = 0;
    this.optional_uint32_$value = 0;
    this.optional_int32_$value = 0;
    this.optional_uint64_$value = 0;
    this.optional_int64_$value = 0;
    this.optional_float_$value = 0;
    this.optional_enum_$value = 0;
    this.optional_double_$value = 0;
  };
  OptionalNumericsStruct.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OptionalNumericsStruct.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

























    // validate OptionalNumericsStruct.optional_enum_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 36, RegularEnum);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OptionalNumericsStruct.encodedSize = codec.kStructHeaderSize + 48;

  OptionalNumericsStruct.decode = function(decoder) {
    var packed;
    var val = new OptionalNumericsStruct();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_bool_$flag = (packed >> 0) & 1 ? true : false;
    val.optional_bool_$value = (packed >> 1) & 1 ? true : false;
    val.optional_uint8_$flag = (packed >> 2) & 1 ? true : false;
    val.optional_int8_$flag = (packed >> 3) & 1 ? true : false;
    val.optional_uint16_$flag = (packed >> 4) & 1 ? true : false;
    val.optional_int16_$flag = (packed >> 5) & 1 ? true : false;
    val.optional_uint32_$flag = (packed >> 6) & 1 ? true : false;
    val.optional_int32_$flag = (packed >> 7) & 1 ? true : false;
    val.optional_uint8_$value =
        decoder.decodeStruct(codec.Uint8);
    val.optional_int8_$value =
        decoder.decodeStruct(codec.Int8);
    packed = decoder.readUint8();
    val.optional_uint64_$flag = (packed >> 0) & 1 ? true : false;
    val.optional_int64_$flag = (packed >> 1) & 1 ? true : false;
    val.optional_float_$flag = (packed >> 2) & 1 ? true : false;
    val.optional_double_$flag = (packed >> 3) & 1 ? true : false;
    val.optional_enum_$flag = (packed >> 4) & 1 ? true : false;
    val.optional_uint16_$value =
        decoder.decodeStruct(codec.Uint16);
    val.optional_int16_$value =
        decoder.decodeStruct(codec.Int16);
    val.optional_uint32_$value =
        decoder.decodeStruct(codec.Uint32);
    val.optional_int32_$value =
        decoder.decodeStruct(codec.Int32);
    val.optional_uint64_$value =
        decoder.decodeStruct(codec.Uint64);
    val.optional_int64_$value =
        decoder.decodeStruct(codec.Int64);
    val.optional_float_$value =
        decoder.decodeStruct(codec.Float);
    val.optional_enum_$value =
        decoder.decodeStruct(new codec.Enum(RegularEnum));
    val.optional_double_$value =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  OptionalNumericsStruct.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OptionalNumericsStruct.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_bool_$flag & 1) << 0
    packed |= (val.optional_bool_$value & 1) << 1
    packed |= (val.optional_uint8_$flag & 1) << 2
    packed |= (val.optional_int8_$flag & 1) << 3
    packed |= (val.optional_uint16_$flag & 1) << 4
    packed |= (val.optional_int16_$flag & 1) << 5
    packed |= (val.optional_uint32_$flag & 1) << 6
    packed |= (val.optional_int32_$flag & 1) << 7
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Uint8, val.optional_uint8_$value);
    encoder.encodeStruct(codec.Int8, val.optional_int8_$value);
    packed = 0;
    packed |= (val.optional_uint64_$flag & 1) << 0
    packed |= (val.optional_int64_$flag & 1) << 1
    packed |= (val.optional_float_$flag & 1) << 2
    packed |= (val.optional_double_$flag & 1) << 3
    packed |= (val.optional_enum_$flag & 1) << 4
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Uint16, val.optional_uint16_$value);
    encoder.encodeStruct(codec.Int16, val.optional_int16_$value);
    encoder.encodeStruct(codec.Uint32, val.optional_uint32_$value);
    encoder.encodeStruct(codec.Int32, val.optional_int32_$value);
    encoder.encodeStruct(codec.Uint64, val.optional_uint64_$value);
    encoder.encodeStruct(codec.Int64, val.optional_int64_$value);
    encoder.encodeStruct(codec.Float, val.optional_float_$value);
    encoder.encodeStruct(codec.Int32, val.optional_enum_$value);
    encoder.encodeStruct(codec.Double, val.optional_double_$value);
  };
  function VersionedStructV0(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VersionedStructV0.prototype.initDefaults_ = function() {
  };
  VersionedStructV0.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VersionedStructV0.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VersionedStructV0.encodedSize = codec.kStructHeaderSize + 0;

  VersionedStructV0.decode = function(decoder) {
    var packed;
    var val = new VersionedStructV0();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  VersionedStructV0.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VersionedStructV0.encodedSize);
    encoder.writeUint32(0);
  };
  function VersionedStructV2(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VersionedStructV2.prototype.initDefaults_ = function() {
    this.bool_value_$flag = false;
    this.bool_value_$value = false;
    this.uint8_value_$flag = false;
    this.int8_value_$flag = false;
    this.uint16_value_$flag = false;
    this.int16_value_$flag = false;
    this.uint32_value_$flag = false;
    this.int32_value_$flag = false;
    this.uint8_value_$value = 0;
    this.int8_value_$value = 0;
    this.uint64_value_$flag = false;
    this.int64_value_$flag = false;
    this.float_value_$flag = false;
    this.double_value_$flag = false;
    this.enum_value_$flag = false;
    this.uint16_value_$value = 0;
    this.int16_value_$value = 0;
    this.uint32_value_$value = 0;
    this.int32_value_$value = 0;
    this.uint64_value_$value = 0;
    this.int64_value_$value = 0;
    this.float_value_$value = 0;
    this.enum_value_$value = 0;
    this.double_value_$value = 0;
  };
  VersionedStructV2.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VersionedStructV2.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8},
      {version: 2, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


























    // version check VersionedStructV2.enum_value_$value
    if (!messageValidator.isFieldInStructVersion(offset, 2))
      return validator.validationError.NONE;
    // validate VersionedStructV2.enum_value_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 36, RegularEnum);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VersionedStructV2.encodedSize = codec.kStructHeaderSize + 48;

  VersionedStructV2.decode = function(decoder) {
    var packed;
    var val = new VersionedStructV2();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.bool_value_$flag = (packed >> 0) & 1 ? true : false;
    val.bool_value_$value = (packed >> 1) & 1 ? true : false;
    val.uint8_value_$flag = (packed >> 2) & 1 ? true : false;
    val.int8_value_$flag = (packed >> 3) & 1 ? true : false;
    val.uint16_value_$flag = (packed >> 4) & 1 ? true : false;
    val.int16_value_$flag = (packed >> 5) & 1 ? true : false;
    val.uint32_value_$flag = (packed >> 6) & 1 ? true : false;
    val.int32_value_$flag = (packed >> 7) & 1 ? true : false;
    if (version >= 2) {
      val.uint8_value_$value =
          decoder.decodeStruct(codec.Uint8);
    } else {
      val.uint8_value_$value = null;
    }
    if (version >= 2) {
      val.int8_value_$value =
          decoder.decodeStruct(codec.Int8);
    } else {
      val.int8_value_$value = null;
    }
    packed = decoder.readUint8();
    val.uint64_value_$flag = (packed >> 0) & 1 ? true : false;
    val.int64_value_$flag = (packed >> 1) & 1 ? true : false;
    val.float_value_$flag = (packed >> 2) & 1 ? true : false;
    val.double_value_$flag = (packed >> 3) & 1 ? true : false;
    val.enum_value_$flag = (packed >> 4) & 1 ? true : false;
    if (version >= 2) {
      val.uint16_value_$value =
          decoder.decodeStruct(codec.Uint16);
    } else {
      val.uint16_value_$value = null;
    }
    if (version >= 2) {
      val.int16_value_$value =
          decoder.decodeStruct(codec.Int16);
    } else {
      val.int16_value_$value = null;
    }
    if (version >= 2) {
      val.uint32_value_$value =
          decoder.decodeStruct(codec.Uint32);
    } else {
      val.uint32_value_$value = null;
    }
    if (version >= 2) {
      val.int32_value_$value =
          decoder.decodeStruct(codec.Int32);
    } else {
      val.int32_value_$value = null;
    }
    if (version >= 2) {
      val.uint64_value_$value =
          decoder.decodeStruct(codec.Uint64);
    } else {
      val.uint64_value_$value = null;
    }
    if (version >= 2) {
      val.int64_value_$value =
          decoder.decodeStruct(codec.Int64);
    } else {
      val.int64_value_$value = null;
    }
    if (version >= 2) {
      val.float_value_$value =
          decoder.decodeStruct(codec.Float);
    } else {
      val.float_value_$value = null;
    }
    if (version >= 2) {
      val.enum_value_$value =
          decoder.decodeStruct(new codec.Enum(RegularEnum));
    } else {
      val.enum_value_$value = null;
    }
    if (version >= 2) {
      val.double_value_$value =
          decoder.decodeStruct(codec.Double);
    } else {
      val.double_value_$value = null;
    }
    return val;
  };

  VersionedStructV2.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VersionedStructV2.encodedSize);
    encoder.writeUint32(2);
    packed = 0;
    packed |= (val.bool_value_$flag & 1) << 0
    packed |= (val.bool_value_$value & 1) << 1
    packed |= (val.uint8_value_$flag & 1) << 2
    packed |= (val.int8_value_$flag & 1) << 3
    packed |= (val.uint16_value_$flag & 1) << 4
    packed |= (val.int16_value_$flag & 1) << 5
    packed |= (val.uint32_value_$flag & 1) << 6
    packed |= (val.int32_value_$flag & 1) << 7
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Uint8, val.uint8_value_$value);
    encoder.encodeStruct(codec.Int8, val.int8_value_$value);
    packed = 0;
    packed |= (val.uint64_value_$flag & 1) << 0
    packed |= (val.int64_value_$flag & 1) << 1
    packed |= (val.float_value_$flag & 1) << 2
    packed |= (val.double_value_$flag & 1) << 3
    packed |= (val.enum_value_$flag & 1) << 4
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Uint16, val.uint16_value_$value);
    encoder.encodeStruct(codec.Int16, val.int16_value_$value);
    encoder.encodeStruct(codec.Uint32, val.uint32_value_$value);
    encoder.encodeStruct(codec.Int32, val.int32_value_$value);
    encoder.encodeStruct(codec.Uint64, val.uint64_value_$value);
    encoder.encodeStruct(codec.Int64, val.int64_value_$value);
    encoder.encodeStruct(codec.Float, val.float_value_$value);
    encoder.encodeStruct(codec.Int32, val.enum_value_$value);
    encoder.encodeStruct(codec.Double, val.double_value_$value);
  };
  function Params_SendNullBool_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullBool_Params.prototype.initDefaults_ = function() {
    this.optional_bool_$flag = false;
    this.optional_bool_$value = false;
  };
  Params_SendNullBool_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullBool_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Params_SendNullBool_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendNullBool_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullBool_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_bool_$flag = (packed >> 0) & 1 ? true : false;
    val.optional_bool_$value = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Params_SendNullBool_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullBool_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_bool_$flag & 1) << 0
    packed |= (val.optional_bool_$value & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Params_SendNullBool_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullBool_ResponseParams.prototype.initDefaults_ = function() {
  };
  Params_SendNullBool_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullBool_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullBool_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Params_SendNullBool_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullBool_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Params_SendNullBool_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullBool_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Params_SendNullUint8_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullUint8_Params.prototype.initDefaults_ = function() {
    this.optional_uint8_$flag = false;
    this.optional_uint8_$value = 0;
  };
  Params_SendNullUint8_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullUint8_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Params_SendNullUint8_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendNullUint8_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullUint8_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_uint8_$flag = (packed >> 0) & 1 ? true : false;
    val.optional_uint8_$value =
        decoder.decodeStruct(codec.Uint8);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Params_SendNullUint8_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullUint8_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_uint8_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Uint8, val.optional_uint8_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Params_SendNullUint8_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullUint8_ResponseParams.prototype.initDefaults_ = function() {
  };
  Params_SendNullUint8_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullUint8_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullUint8_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Params_SendNullUint8_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullUint8_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Params_SendNullUint8_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullUint8_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Params_SendNullInt8_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullInt8_Params.prototype.initDefaults_ = function() {
    this.optional_int8_$flag = false;
    this.optional_int8_$value = 0;
  };
  Params_SendNullInt8_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullInt8_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Params_SendNullInt8_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendNullInt8_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullInt8_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_int8_$flag = (packed >> 0) & 1 ? true : false;
    val.optional_int8_$value =
        decoder.decodeStruct(codec.Int8);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Params_SendNullInt8_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullInt8_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_int8_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Int8, val.optional_int8_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Params_SendNullInt8_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullInt8_ResponseParams.prototype.initDefaults_ = function() {
  };
  Params_SendNullInt8_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullInt8_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullInt8_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Params_SendNullInt8_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullInt8_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Params_SendNullInt8_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullInt8_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Params_SendNullUint16_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullUint16_Params.prototype.initDefaults_ = function() {
    this.optional_uint16_$flag = false;
    this.optional_uint16_$value = 0;
  };
  Params_SendNullUint16_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullUint16_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Params_SendNullUint16_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendNullUint16_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullUint16_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_uint16_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    val.optional_uint16_$value =
        decoder.decodeStruct(codec.Uint16);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Params_SendNullUint16_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullUint16_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_uint16_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint16, val.optional_uint16_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Params_SendNullUint16_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullUint16_ResponseParams.prototype.initDefaults_ = function() {
  };
  Params_SendNullUint16_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullUint16_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullUint16_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Params_SendNullUint16_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullUint16_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Params_SendNullUint16_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullUint16_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Params_SendNullInt16_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullInt16_Params.prototype.initDefaults_ = function() {
    this.optional_int16_$flag = false;
    this.optional_int16_$value = 0;
  };
  Params_SendNullInt16_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullInt16_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Params_SendNullInt16_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendNullInt16_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullInt16_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_int16_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    val.optional_int16_$value =
        decoder.decodeStruct(codec.Int16);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Params_SendNullInt16_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullInt16_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_int16_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int16, val.optional_int16_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Params_SendNullInt16_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullInt16_ResponseParams.prototype.initDefaults_ = function() {
  };
  Params_SendNullInt16_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullInt16_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullInt16_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Params_SendNullInt16_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullInt16_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Params_SendNullInt16_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullInt16_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Params_SendNullUint32_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullUint32_Params.prototype.initDefaults_ = function() {
    this.optional_uint32_$flag = false;
    this.optional_uint32_$value = 0;
  };
  Params_SendNullUint32_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullUint32_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Params_SendNullUint32_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendNullUint32_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullUint32_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_uint32_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_uint32_$value =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  Params_SendNullUint32_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullUint32_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_uint32_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.optional_uint32_$value);
  };
  function Params_SendNullUint32_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullUint32_ResponseParams.prototype.initDefaults_ = function() {
  };
  Params_SendNullUint32_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullUint32_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullUint32_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Params_SendNullUint32_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullUint32_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Params_SendNullUint32_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullUint32_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Params_SendNullInt32_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullInt32_Params.prototype.initDefaults_ = function() {
    this.optional_int32_$flag = false;
    this.optional_int32_$value = 0;
  };
  Params_SendNullInt32_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullInt32_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Params_SendNullInt32_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendNullInt32_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullInt32_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_int32_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_int32_$value =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  Params_SendNullInt32_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullInt32_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_int32_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.optional_int32_$value);
  };
  function Params_SendNullInt32_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullInt32_ResponseParams.prototype.initDefaults_ = function() {
  };
  Params_SendNullInt32_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullInt32_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullInt32_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Params_SendNullInt32_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullInt32_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Params_SendNullInt32_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullInt32_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Params_SendNullUint64_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullUint64_Params.prototype.initDefaults_ = function() {
    this.optional_uint64_$flag = false;
    this.optional_uint64_$value = 0;
  };
  Params_SendNullUint64_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullUint64_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Params_SendNullUint64_Params.encodedSize = codec.kStructHeaderSize + 16;

  Params_SendNullUint64_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullUint64_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_uint64_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_uint64_$value =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  Params_SendNullUint64_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullUint64_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_uint64_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint64, val.optional_uint64_$value);
  };
  function Params_SendNullUint64_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullUint64_ResponseParams.prototype.initDefaults_ = function() {
  };
  Params_SendNullUint64_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullUint64_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullUint64_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Params_SendNullUint64_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullUint64_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Params_SendNullUint64_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullUint64_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Params_SendNullInt64_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullInt64_Params.prototype.initDefaults_ = function() {
    this.optional_int64_$flag = false;
    this.optional_int64_$value = 0;
  };
  Params_SendNullInt64_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullInt64_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Params_SendNullInt64_Params.encodedSize = codec.kStructHeaderSize + 16;

  Params_SendNullInt64_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullInt64_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_int64_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_int64_$value =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  Params_SendNullInt64_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullInt64_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_int64_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int64, val.optional_int64_$value);
  };
  function Params_SendNullInt64_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullInt64_ResponseParams.prototype.initDefaults_ = function() {
  };
  Params_SendNullInt64_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullInt64_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullInt64_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Params_SendNullInt64_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullInt64_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Params_SendNullInt64_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullInt64_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Params_SendNullFloat_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullFloat_Params.prototype.initDefaults_ = function() {
    this.optional_float_$flag = false;
    this.optional_float_$value = 0;
  };
  Params_SendNullFloat_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullFloat_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Params_SendNullFloat_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendNullFloat_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullFloat_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_float_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_float_$value =
        decoder.decodeStruct(codec.Float);
    return val;
  };

  Params_SendNullFloat_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullFloat_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_float_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Float, val.optional_float_$value);
  };
  function Params_SendNullFloat_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullFloat_ResponseParams.prototype.initDefaults_ = function() {
  };
  Params_SendNullFloat_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullFloat_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullFloat_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Params_SendNullFloat_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullFloat_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Params_SendNullFloat_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullFloat_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Params_SendNullDouble_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullDouble_Params.prototype.initDefaults_ = function() {
    this.optional_double_$flag = false;
    this.optional_double_$value = 0;
  };
  Params_SendNullDouble_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullDouble_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Params_SendNullDouble_Params.encodedSize = codec.kStructHeaderSize + 16;

  Params_SendNullDouble_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullDouble_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_double_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_double_$value =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  Params_SendNullDouble_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullDouble_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_double_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Double, val.optional_double_$value);
  };
  function Params_SendNullDouble_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullDouble_ResponseParams.prototype.initDefaults_ = function() {
  };
  Params_SendNullDouble_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullDouble_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullDouble_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Params_SendNullDouble_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullDouble_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Params_SendNullDouble_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullDouble_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Params_SendNullEnum_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullEnum_Params.prototype.initDefaults_ = function() {
    this.optional_enum_$flag = false;
    this.optional_enum_$value = 0;
  };
  Params_SendNullEnum_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullEnum_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate Params_SendNullEnum_Params.optional_enum_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, RegularEnum);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullEnum_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendNullEnum_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullEnum_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_enum_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_enum_$value =
        decoder.decodeStruct(new codec.Enum(RegularEnum));
    return val;
  };

  Params_SendNullEnum_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullEnum_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_enum_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.optional_enum_$value);
  };
  function Params_SendNullEnum_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullEnum_ResponseParams.prototype.initDefaults_ = function() {
  };
  Params_SendNullEnum_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullEnum_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullEnum_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Params_SendNullEnum_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullEnum_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Params_SendNullEnum_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullEnum_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Params_SendNullBools_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullBools_Params.prototype.initDefaults_ = function() {
    this.optionalBools = null;
  };
  Params_SendNullBools_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullBools_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendNullBools_Params.optionalBools
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.PackedBool, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullBools_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendNullBools_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullBools_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalBools =
        decoder.decodeArrayPointer(codec.PackedBool);
    return val;
  };

  Params_SendNullBools_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullBools_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.PackedBool, val.optionalBools);
  };
  function Params_SendNullBools_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullBools_ResponseParams.prototype.initDefaults_ = function() {
  };
  Params_SendNullBools_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullBools_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullBools_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Params_SendNullBools_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullBools_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Params_SendNullBools_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullBools_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Params_SendNullInt16s_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullInt16s_Params.prototype.initDefaults_ = function() {
    this.optionalInt16s = null;
  };
  Params_SendNullInt16s_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullInt16s_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendNullInt16s_Params.optionalInt16s
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 2, codec.Int16, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullInt16s_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendNullInt16s_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullInt16s_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalInt16s =
        decoder.decodeArrayPointer(codec.Int16);
    return val;
  };

  Params_SendNullInt16s_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullInt16s_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Int16, val.optionalInt16s);
  };
  function Params_SendNullInt16s_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullInt16s_ResponseParams.prototype.initDefaults_ = function() {
  };
  Params_SendNullInt16s_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullInt16s_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullInt16s_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Params_SendNullInt16s_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullInt16s_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Params_SendNullInt16s_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullInt16s_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Params_SendNullUint32s_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullUint32s_Params.prototype.initDefaults_ = function() {
    this.optionalUint32s = null;
  };
  Params_SendNullUint32s_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullUint32s_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendNullUint32s_Params.optionalUint32s
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, codec.Uint32, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullUint32s_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendNullUint32s_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullUint32s_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalUint32s =
        decoder.decodeArrayPointer(codec.Uint32);
    return val;
  };

  Params_SendNullUint32s_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullUint32s_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint32, val.optionalUint32s);
  };
  function Params_SendNullUint32s_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullUint32s_ResponseParams.prototype.initDefaults_ = function() {
  };
  Params_SendNullUint32s_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullUint32s_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullUint32s_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Params_SendNullUint32s_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullUint32s_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Params_SendNullUint32s_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullUint32s_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Params_SendNullDoubles_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullDoubles_Params.prototype.initDefaults_ = function() {
    this.optionalDoubles = null;
  };
  Params_SendNullDoubles_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullDoubles_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendNullDoubles_Params.optionalDoubles
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.Double, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullDoubles_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendNullDoubles_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullDoubles_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalDoubles =
        decoder.decodeArrayPointer(codec.Double);
    return val;
  };

  Params_SendNullDoubles_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullDoubles_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Double, val.optionalDoubles);
  };
  function Params_SendNullDoubles_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullDoubles_ResponseParams.prototype.initDefaults_ = function() {
  };
  Params_SendNullDoubles_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullDoubles_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullDoubles_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Params_SendNullDoubles_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullDoubles_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Params_SendNullDoubles_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullDoubles_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Params_SendNullEnums_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullEnums_Params.prototype.initDefaults_ = function() {
    this.optionalEnums = null;
  };
  Params_SendNullEnums_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullEnums_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendNullEnums_Params.optionalEnums
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, new codec.Enum(RegularEnum), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullEnums_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendNullEnums_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullEnums_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalEnums =
        decoder.decodeArrayPointer(new codec.Enum(RegularEnum));
    return val;
  };

  Params_SendNullEnums_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullEnums_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.Enum(RegularEnum), val.optionalEnums);
  };
  function Params_SendNullEnums_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullEnums_ResponseParams.prototype.initDefaults_ = function() {
  };
  Params_SendNullEnums_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullEnums_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullEnums_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Params_SendNullEnums_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullEnums_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Params_SendNullEnums_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullEnums_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Params_SendNullBoolMap_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullBoolMap_Params.prototype.initDefaults_ = function() {
    this.values = null;
  };
  Params_SendNullBoolMap_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullBoolMap_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendNullBoolMap_Params.values
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.Int32, codec.PackedBool, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullBoolMap_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendNullBoolMap_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullBoolMap_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.values =
        decoder.decodeMapPointer(codec.Int32, codec.PackedBool);
    return val;
  };

  Params_SendNullBoolMap_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullBoolMap_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.Int32, codec.PackedBool, val.values);
  };
  function Params_SendNullBoolMap_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullBoolMap_ResponseParams.prototype.initDefaults_ = function() {
  };
  Params_SendNullBoolMap_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullBoolMap_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullBoolMap_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Params_SendNullBoolMap_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullBoolMap_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Params_SendNullBoolMap_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullBoolMap_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Params_SendNullDoubleMap_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullDoubleMap_Params.prototype.initDefaults_ = function() {
    this.values = null;
  };
  Params_SendNullDoubleMap_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullDoubleMap_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendNullDoubleMap_Params.values
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.Int32, codec.Double, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullDoubleMap_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendNullDoubleMap_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullDoubleMap_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.values =
        decoder.decodeMapPointer(codec.Int32, codec.Double);
    return val;
  };

  Params_SendNullDoubleMap_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullDoubleMap_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.Int32, codec.Double, val.values);
  };
  function Params_SendNullDoubleMap_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullDoubleMap_ResponseParams.prototype.initDefaults_ = function() {
  };
  Params_SendNullDoubleMap_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullDoubleMap_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullDoubleMap_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Params_SendNullDoubleMap_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullDoubleMap_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Params_SendNullDoubleMap_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullDoubleMap_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Params_SendNullEnumMap_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullEnumMap_Params.prototype.initDefaults_ = function() {
    this.values = null;
  };
  Params_SendNullEnumMap_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullEnumMap_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendNullEnumMap_Params.values
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.Int32, new codec.Enum(RegularEnum), true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullEnumMap_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendNullEnumMap_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullEnumMap_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.values =
        decoder.decodeMapPointer(codec.Int32, new codec.Enum(RegularEnum));
    return val;
  };

  Params_SendNullEnumMap_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullEnumMap_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.Int32, new codec.Enum(RegularEnum), val.values);
  };
  function Params_SendNullEnumMap_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullEnumMap_ResponseParams.prototype.initDefaults_ = function() {
  };
  Params_SendNullEnumMap_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullEnumMap_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullEnumMap_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Params_SendNullEnumMap_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullEnumMap_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Params_SendNullEnumMap_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullEnumMap_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Params_SendOptionalBool_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalBool_Params.prototype.initDefaults_ = function() {
    this.optional_bool_$flag = false;
    this.optional_bool_$value = false;
  };
  Params_SendOptionalBool_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalBool_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Params_SendOptionalBool_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalBool_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalBool_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_bool_$flag = (packed >> 0) & 1 ? true : false;
    val.optional_bool_$value = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Params_SendOptionalBool_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalBool_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_bool_$flag & 1) << 0
    packed |= (val.optional_bool_$value & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Params_SendOptionalBool_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalBool_ResponseParams.prototype.initDefaults_ = function() {
    this.value = false;
  };
  Params_SendOptionalBool_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalBool_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  Params_SendOptionalBool_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalBool_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalBool_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.value = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Params_SendOptionalBool_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalBool_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.value & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Params_SendOptionalUint8_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalUint8_Params.prototype.initDefaults_ = function() {
    this.optional_uint8_$flag = false;
    this.optional_uint8_$value = 0;
  };
  Params_SendOptionalUint8_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalUint8_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Params_SendOptionalUint8_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalUint8_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalUint8_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_uint8_$flag = (packed >> 0) & 1 ? true : false;
    val.optional_uint8_$value =
        decoder.decodeStruct(codec.Uint8);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Params_SendOptionalUint8_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalUint8_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_uint8_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Uint8, val.optional_uint8_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Params_SendOptionalUint8_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalUint8_ResponseParams.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  Params_SendOptionalUint8_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalUint8_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  Params_SendOptionalUint8_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalUint8_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalUint8_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Uint8);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Params_SendOptionalUint8_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalUint8_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint8, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Params_SendOptionalInt8_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalInt8_Params.prototype.initDefaults_ = function() {
    this.optional_int8_$flag = false;
    this.optional_int8_$value = 0;
  };
  Params_SendOptionalInt8_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalInt8_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Params_SendOptionalInt8_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalInt8_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalInt8_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_int8_$flag = (packed >> 0) & 1 ? true : false;
    val.optional_int8_$value =
        decoder.decodeStruct(codec.Int8);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Params_SendOptionalInt8_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalInt8_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_int8_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Int8, val.optional_int8_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Params_SendOptionalInt8_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalInt8_ResponseParams.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  Params_SendOptionalInt8_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalInt8_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  Params_SendOptionalInt8_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalInt8_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalInt8_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Int8);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Params_SendOptionalInt8_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalInt8_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int8, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Params_SendOptionalUint16_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalUint16_Params.prototype.initDefaults_ = function() {
    this.optional_uint16_$flag = false;
    this.optional_uint16_$value = 0;
  };
  Params_SendOptionalUint16_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalUint16_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Params_SendOptionalUint16_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalUint16_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalUint16_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_uint16_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    val.optional_uint16_$value =
        decoder.decodeStruct(codec.Uint16);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Params_SendOptionalUint16_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalUint16_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_uint16_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint16, val.optional_uint16_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Params_SendOptionalUint16_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalUint16_ResponseParams.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  Params_SendOptionalUint16_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalUint16_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  Params_SendOptionalUint16_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalUint16_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalUint16_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Uint16);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Params_SendOptionalUint16_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalUint16_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint16, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Params_SendOptionalInt16_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalInt16_Params.prototype.initDefaults_ = function() {
    this.optional_int16_$flag = false;
    this.optional_int16_$value = 0;
  };
  Params_SendOptionalInt16_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalInt16_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Params_SendOptionalInt16_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalInt16_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalInt16_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_int16_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    val.optional_int16_$value =
        decoder.decodeStruct(codec.Int16);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Params_SendOptionalInt16_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalInt16_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_int16_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int16, val.optional_int16_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Params_SendOptionalInt16_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalInt16_ResponseParams.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  Params_SendOptionalInt16_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalInt16_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  Params_SendOptionalInt16_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalInt16_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalInt16_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Int16);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Params_SendOptionalInt16_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalInt16_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int16, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Params_SendOptionalUint32_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalUint32_Params.prototype.initDefaults_ = function() {
    this.optional_uint32_$flag = false;
    this.optional_uint32_$value = 0;
  };
  Params_SendOptionalUint32_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalUint32_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Params_SendOptionalUint32_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalUint32_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalUint32_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_uint32_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_uint32_$value =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  Params_SendOptionalUint32_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalUint32_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_uint32_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.optional_uint32_$value);
  };
  function Params_SendOptionalUint32_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalUint32_ResponseParams.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  Params_SendOptionalUint32_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalUint32_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  Params_SendOptionalUint32_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalUint32_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalUint32_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Params_SendOptionalUint32_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalUint32_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Params_SendOptionalInt32_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalInt32_Params.prototype.initDefaults_ = function() {
    this.optional_int32_$flag = false;
    this.optional_int32_$value = 0;
  };
  Params_SendOptionalInt32_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalInt32_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Params_SendOptionalInt32_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalInt32_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalInt32_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_int32_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_int32_$value =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  Params_SendOptionalInt32_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalInt32_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_int32_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.optional_int32_$value);
  };
  function Params_SendOptionalInt32_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalInt32_ResponseParams.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  Params_SendOptionalInt32_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalInt32_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  Params_SendOptionalInt32_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalInt32_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalInt32_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Params_SendOptionalInt32_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalInt32_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Params_SendOptionalUint64_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalUint64_Params.prototype.initDefaults_ = function() {
    this.optional_uint64_$flag = false;
    this.optional_uint64_$value = 0;
  };
  Params_SendOptionalUint64_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalUint64_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Params_SendOptionalUint64_Params.encodedSize = codec.kStructHeaderSize + 16;

  Params_SendOptionalUint64_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalUint64_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_uint64_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_uint64_$value =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  Params_SendOptionalUint64_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalUint64_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_uint64_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint64, val.optional_uint64_$value);
  };
  function Params_SendOptionalUint64_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalUint64_ResponseParams.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  Params_SendOptionalUint64_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalUint64_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  Params_SendOptionalUint64_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalUint64_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalUint64_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  Params_SendOptionalUint64_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalUint64_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.value);
  };
  function Params_SendOptionalInt64_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalInt64_Params.prototype.initDefaults_ = function() {
    this.optional_int64_$flag = false;
    this.optional_int64_$value = 0;
  };
  Params_SendOptionalInt64_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalInt64_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Params_SendOptionalInt64_Params.encodedSize = codec.kStructHeaderSize + 16;

  Params_SendOptionalInt64_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalInt64_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_int64_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_int64_$value =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  Params_SendOptionalInt64_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalInt64_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_int64_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int64, val.optional_int64_$value);
  };
  function Params_SendOptionalInt64_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalInt64_ResponseParams.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  Params_SendOptionalInt64_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalInt64_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  Params_SendOptionalInt64_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalInt64_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalInt64_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  Params_SendOptionalInt64_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalInt64_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.value);
  };
  function Params_SendOptionalFloat_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalFloat_Params.prototype.initDefaults_ = function() {
    this.optional_float_$flag = false;
    this.optional_float_$value = 0;
  };
  Params_SendOptionalFloat_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalFloat_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Params_SendOptionalFloat_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalFloat_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalFloat_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_float_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_float_$value =
        decoder.decodeStruct(codec.Float);
    return val;
  };

  Params_SendOptionalFloat_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalFloat_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_float_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Float, val.optional_float_$value);
  };
  function Params_SendOptionalFloat_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalFloat_ResponseParams.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  Params_SendOptionalFloat_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalFloat_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  Params_SendOptionalFloat_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalFloat_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalFloat_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Float);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Params_SendOptionalFloat_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalFloat_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Float, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Params_SendOptionalDouble_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalDouble_Params.prototype.initDefaults_ = function() {
    this.optional_double_$flag = false;
    this.optional_double_$value = 0;
  };
  Params_SendOptionalDouble_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalDouble_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Params_SendOptionalDouble_Params.encodedSize = codec.kStructHeaderSize + 16;

  Params_SendOptionalDouble_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalDouble_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_double_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_double_$value =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  Params_SendOptionalDouble_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalDouble_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_double_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Double, val.optional_double_$value);
  };
  function Params_SendOptionalDouble_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalDouble_ResponseParams.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  Params_SendOptionalDouble_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalDouble_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  Params_SendOptionalDouble_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalDouble_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalDouble_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  Params_SendOptionalDouble_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalDouble_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Double, val.value);
  };
  function Params_SendOptionalEnum_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalEnum_Params.prototype.initDefaults_ = function() {
    this.optional_enum_$flag = false;
    this.optional_enum_$value = 0;
  };
  Params_SendOptionalEnum_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalEnum_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate Params_SendOptionalEnum_Params.optional_enum_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, RegularEnum);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendOptionalEnum_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalEnum_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalEnum_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_enum_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_enum_$value =
        decoder.decodeStruct(new codec.Enum(RegularEnum));
    return val;
  };

  Params_SendOptionalEnum_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalEnum_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_enum_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.optional_enum_$value);
  };
  function Params_SendOptionalEnum_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalEnum_ResponseParams.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  Params_SendOptionalEnum_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalEnum_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendOptionalEnum_ResponseParams.value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, RegularEnum);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendOptionalEnum_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalEnum_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalEnum_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(new codec.Enum(RegularEnum));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Params_SendOptionalEnum_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalEnum_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Params_SendOptionalBools_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalBools_Params.prototype.initDefaults_ = function() {
    this.optionalEnums = null;
  };
  Params_SendOptionalBools_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalBools_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendOptionalBools_Params.optionalEnums
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.PackedBool, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendOptionalBools_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalBools_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalBools_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalEnums =
        decoder.decodeArrayPointer(codec.PackedBool);
    return val;
  };

  Params_SendOptionalBools_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalBools_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.PackedBool, val.optionalEnums);
  };
  function Params_SendOptionalBools_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalBools_ResponseParams.prototype.initDefaults_ = function() {
    this.values = null;
  };
  Params_SendOptionalBools_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalBools_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendOptionalBools_ResponseParams.values
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.PackedBool, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendOptionalBools_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalBools_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalBools_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.values =
        decoder.decodeArrayPointer(codec.PackedBool);
    return val;
  };

  Params_SendOptionalBools_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalBools_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.PackedBool, val.values);
  };
  function Params_SendOptionalInt16s_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalInt16s_Params.prototype.initDefaults_ = function() {
    this.optionalInt16s = null;
  };
  Params_SendOptionalInt16s_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalInt16s_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendOptionalInt16s_Params.optionalInt16s
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 2, codec.Int16, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendOptionalInt16s_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalInt16s_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalInt16s_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalInt16s =
        decoder.decodeArrayPointer(codec.Int16);
    return val;
  };

  Params_SendOptionalInt16s_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalInt16s_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Int16, val.optionalInt16s);
  };
  function Params_SendOptionalInt16s_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalInt16s_ResponseParams.prototype.initDefaults_ = function() {
    this.values = null;
  };
  Params_SendOptionalInt16s_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalInt16s_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendOptionalInt16s_ResponseParams.values
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 2, codec.Int16, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendOptionalInt16s_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalInt16s_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalInt16s_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.values =
        decoder.decodeArrayPointer(codec.Int16);
    return val;
  };

  Params_SendOptionalInt16s_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalInt16s_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Int16, val.values);
  };
  function Params_SendOptionalUint32s_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalUint32s_Params.prototype.initDefaults_ = function() {
    this.optionalUint32s = null;
  };
  Params_SendOptionalUint32s_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalUint32s_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendOptionalUint32s_Params.optionalUint32s
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, codec.Uint32, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendOptionalUint32s_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalUint32s_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalUint32s_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalUint32s =
        decoder.decodeArrayPointer(codec.Uint32);
    return val;
  };

  Params_SendOptionalUint32s_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalUint32s_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint32, val.optionalUint32s);
  };
  function Params_SendOptionalUint32s_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalUint32s_ResponseParams.prototype.initDefaults_ = function() {
    this.values = null;
  };
  Params_SendOptionalUint32s_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalUint32s_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendOptionalUint32s_ResponseParams.values
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, codec.Uint32, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendOptionalUint32s_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalUint32s_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalUint32s_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.values =
        decoder.decodeArrayPointer(codec.Uint32);
    return val;
  };

  Params_SendOptionalUint32s_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalUint32s_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint32, val.values);
  };
  function Params_SendOptionalDoubles_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalDoubles_Params.prototype.initDefaults_ = function() {
    this.optionalDoubles = null;
  };
  Params_SendOptionalDoubles_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalDoubles_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendOptionalDoubles_Params.optionalDoubles
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.Double, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendOptionalDoubles_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalDoubles_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalDoubles_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalDoubles =
        decoder.decodeArrayPointer(codec.Double);
    return val;
  };

  Params_SendOptionalDoubles_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalDoubles_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Double, val.optionalDoubles);
  };
  function Params_SendOptionalDoubles_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalDoubles_ResponseParams.prototype.initDefaults_ = function() {
    this.values = null;
  };
  Params_SendOptionalDoubles_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalDoubles_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendOptionalDoubles_ResponseParams.values
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.Double, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendOptionalDoubles_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalDoubles_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalDoubles_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.values =
        decoder.decodeArrayPointer(codec.Double);
    return val;
  };

  Params_SendOptionalDoubles_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalDoubles_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Double, val.values);
  };
  function Params_SendOptionalEnums_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalEnums_Params.prototype.initDefaults_ = function() {
    this.optionalEnums = null;
  };
  Params_SendOptionalEnums_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalEnums_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendOptionalEnums_Params.optionalEnums
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, new codec.Enum(RegularEnum), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendOptionalEnums_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalEnums_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalEnums_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalEnums =
        decoder.decodeArrayPointer(new codec.Enum(RegularEnum));
    return val;
  };

  Params_SendOptionalEnums_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalEnums_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.Enum(RegularEnum), val.optionalEnums);
  };
  function Params_SendOptionalEnums_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalEnums_ResponseParams.prototype.initDefaults_ = function() {
    this.values = null;
  };
  Params_SendOptionalEnums_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalEnums_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendOptionalEnums_ResponseParams.values
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, new codec.Enum(RegularEnum), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendOptionalEnums_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalEnums_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalEnums_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.values =
        decoder.decodeArrayPointer(new codec.Enum(RegularEnum));
    return val;
  };

  Params_SendOptionalEnums_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalEnums_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.Enum(RegularEnum), val.values);
  };
  function Params_SendOptionalBoolMap_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalBoolMap_Params.prototype.initDefaults_ = function() {
    this.values = null;
  };
  Params_SendOptionalBoolMap_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalBoolMap_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendOptionalBoolMap_Params.values
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.Int32, codec.PackedBool, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendOptionalBoolMap_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalBoolMap_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalBoolMap_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.values =
        decoder.decodeMapPointer(codec.Int32, codec.PackedBool);
    return val;
  };

  Params_SendOptionalBoolMap_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalBoolMap_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.Int32, codec.PackedBool, val.values);
  };
  function Params_SendOptionalBoolMap_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalBoolMap_ResponseParams.prototype.initDefaults_ = function() {
    this.values = null;
  };
  Params_SendOptionalBoolMap_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalBoolMap_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendOptionalBoolMap_ResponseParams.values
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.Int32, codec.PackedBool, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendOptionalBoolMap_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalBoolMap_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalBoolMap_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.values =
        decoder.decodeMapPointer(codec.Int32, codec.PackedBool);
    return val;
  };

  Params_SendOptionalBoolMap_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalBoolMap_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.Int32, codec.PackedBool, val.values);
  };
  function Params_SendOptionalDoubleMap_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalDoubleMap_Params.prototype.initDefaults_ = function() {
    this.values = null;
  };
  Params_SendOptionalDoubleMap_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalDoubleMap_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendOptionalDoubleMap_Params.values
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.Int32, codec.Double, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendOptionalDoubleMap_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalDoubleMap_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalDoubleMap_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.values =
        decoder.decodeMapPointer(codec.Int32, codec.Double);
    return val;
  };

  Params_SendOptionalDoubleMap_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalDoubleMap_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.Int32, codec.Double, val.values);
  };
  function Params_SendOptionalDoubleMap_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalDoubleMap_ResponseParams.prototype.initDefaults_ = function() {
    this.values = null;
  };
  Params_SendOptionalDoubleMap_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalDoubleMap_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendOptionalDoubleMap_ResponseParams.values
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.Int32, codec.Double, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendOptionalDoubleMap_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalDoubleMap_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalDoubleMap_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.values =
        decoder.decodeMapPointer(codec.Int32, codec.Double);
    return val;
  };

  Params_SendOptionalDoubleMap_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalDoubleMap_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.Int32, codec.Double, val.values);
  };
  function Params_SendOptionalEnumMap_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalEnumMap_Params.prototype.initDefaults_ = function() {
    this.values = null;
  };
  Params_SendOptionalEnumMap_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalEnumMap_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendOptionalEnumMap_Params.values
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.Int32, new codec.Enum(RegularEnum), true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendOptionalEnumMap_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalEnumMap_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalEnumMap_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.values =
        decoder.decodeMapPointer(codec.Int32, new codec.Enum(RegularEnum));
    return val;
  };

  Params_SendOptionalEnumMap_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalEnumMap_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.Int32, new codec.Enum(RegularEnum), val.values);
  };
  function Params_SendOptionalEnumMap_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendOptionalEnumMap_ResponseParams.prototype.initDefaults_ = function() {
    this.values = null;
  };
  Params_SendOptionalEnumMap_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendOptionalEnumMap_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendOptionalEnumMap_ResponseParams.values
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.Int32, new codec.Enum(RegularEnum), false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendOptionalEnumMap_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendOptionalEnumMap_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendOptionalEnumMap_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.values =
        decoder.decodeMapPointer(codec.Int32, new codec.Enum(RegularEnum));
    return val;
  };

  Params_SendOptionalEnumMap_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendOptionalEnumMap_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.Int32, new codec.Enum(RegularEnum), val.values);
  };
  function Params_SendNullStructWithOptionalNumerics_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullStructWithOptionalNumerics_Params.prototype.initDefaults_ = function() {
    this.s = null;
  };
  Params_SendNullStructWithOptionalNumerics_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullStructWithOptionalNumerics_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendNullStructWithOptionalNumerics_Params.s
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, OptionalNumericsStruct, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullStructWithOptionalNumerics_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendNullStructWithOptionalNumerics_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullStructWithOptionalNumerics_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.s =
        decoder.decodeStructPointer(OptionalNumericsStruct);
    return val;
  };

  Params_SendNullStructWithOptionalNumerics_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullStructWithOptionalNumerics_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(OptionalNumericsStruct, val.s);
  };
  function Params_SendNullStructWithOptionalNumerics_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendNullStructWithOptionalNumerics_ResponseParams.prototype.initDefaults_ = function() {
  };
  Params_SendNullStructWithOptionalNumerics_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendNullStructWithOptionalNumerics_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendNullStructWithOptionalNumerics_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Params_SendNullStructWithOptionalNumerics_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendNullStructWithOptionalNumerics_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Params_SendNullStructWithOptionalNumerics_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendNullStructWithOptionalNumerics_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Params_SendStructWithNullOptionalNumerics_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendStructWithNullOptionalNumerics_Params.prototype.initDefaults_ = function() {
    this.s = null;
  };
  Params_SendStructWithNullOptionalNumerics_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendStructWithNullOptionalNumerics_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendStructWithNullOptionalNumerics_Params.s
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, OptionalNumericsStruct, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendStructWithNullOptionalNumerics_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendStructWithNullOptionalNumerics_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendStructWithNullOptionalNumerics_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.s =
        decoder.decodeStructPointer(OptionalNumericsStruct);
    return val;
  };

  Params_SendStructWithNullOptionalNumerics_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendStructWithNullOptionalNumerics_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(OptionalNumericsStruct, val.s);
  };
  function Params_SendStructWithNullOptionalNumerics_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendStructWithNullOptionalNumerics_ResponseParams.prototype.initDefaults_ = function() {
  };
  Params_SendStructWithNullOptionalNumerics_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendStructWithNullOptionalNumerics_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendStructWithNullOptionalNumerics_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  Params_SendStructWithNullOptionalNumerics_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendStructWithNullOptionalNumerics_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Params_SendStructWithNullOptionalNumerics_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendStructWithNullOptionalNumerics_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function Params_SendStructWithOptionalNumerics_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendStructWithOptionalNumerics_Params.prototype.initDefaults_ = function() {
    this.s = null;
  };
  Params_SendStructWithOptionalNumerics_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendStructWithOptionalNumerics_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Params_SendStructWithOptionalNumerics_Params.s
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, OptionalNumericsStruct, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendStructWithOptionalNumerics_Params.encodedSize = codec.kStructHeaderSize + 8;

  Params_SendStructWithOptionalNumerics_Params.decode = function(decoder) {
    var packed;
    var val = new Params_SendStructWithOptionalNumerics_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.s =
        decoder.decodeStructPointer(OptionalNumericsStruct);
    return val;
  };

  Params_SendStructWithOptionalNumerics_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendStructWithOptionalNumerics_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(OptionalNumericsStruct, val.s);
  };
  function Params_SendStructWithOptionalNumerics_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Params_SendStructWithOptionalNumerics_ResponseParams.prototype.initDefaults_ = function() {
    this.boolValue = false;
    this.uint8Value = 0;
    this.int8Value = 0;
    this.uint16Value = 0;
    this.int16Value = 0;
    this.uint32Value = 0;
    this.int32Value = 0;
    this.uint64Value = 0;
    this.int64Value = 0;
    this.floatValue = 0;
    this.enumValue = 0;
    this.doubleValue = 0;
  };
  Params_SendStructWithOptionalNumerics_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Params_SendStructWithOptionalNumerics_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;













    // validate Params_SendStructWithOptionalNumerics_ResponseParams.enumValue
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 36, RegularEnum);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Params_SendStructWithOptionalNumerics_ResponseParams.encodedSize = codec.kStructHeaderSize + 48;

  Params_SendStructWithOptionalNumerics_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Params_SendStructWithOptionalNumerics_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.boolValue = (packed >> 0) & 1 ? true : false;
    val.uint8Value =
        decoder.decodeStruct(codec.Uint8);
    val.int8Value =
        decoder.decodeStruct(codec.Int8);
    decoder.skip(1);
    val.uint16Value =
        decoder.decodeStruct(codec.Uint16);
    val.int16Value =
        decoder.decodeStruct(codec.Int16);
    val.uint32Value =
        decoder.decodeStruct(codec.Uint32);
    val.int32Value =
        decoder.decodeStruct(codec.Int32);
    val.uint64Value =
        decoder.decodeStruct(codec.Uint64);
    val.int64Value =
        decoder.decodeStruct(codec.Int64);
    val.floatValue =
        decoder.decodeStruct(codec.Float);
    val.enumValue =
        decoder.decodeStruct(new codec.Enum(RegularEnum));
    val.doubleValue =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  Params_SendStructWithOptionalNumerics_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Params_SendStructWithOptionalNumerics_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.boolValue & 1) << 0
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Uint8, val.uint8Value);
    encoder.encodeStruct(codec.Int8, val.int8Value);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint16, val.uint16Value);
    encoder.encodeStruct(codec.Int16, val.int16Value);
    encoder.encodeStruct(codec.Uint32, val.uint32Value);
    encoder.encodeStruct(codec.Int32, val.int32Value);
    encoder.encodeStruct(codec.Uint64, val.uint64Value);
    encoder.encodeStruct(codec.Int64, val.int64Value);
    encoder.encodeStruct(codec.Float, val.floatValue);
    encoder.encodeStruct(codec.Int32, val.enumValue);
    encoder.encodeStruct(codec.Double, val.doubleValue);
  };
  function ResponseParams_GetNullBool_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullBool_Params.prototype.initDefaults_ = function() {
  };
  ResponseParams_GetNullBool_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullBool_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullBool_Params.encodedSize = codec.kStructHeaderSize + 0;

  ResponseParams_GetNullBool_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullBool_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ResponseParams_GetNullBool_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullBool_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ResponseParams_GetNullBool_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullBool_ResponseParams.prototype.initDefaults_ = function() {
    this.optional_value_$flag = false;
    this.optional_value_$value = false;
  };
  ResponseParams_GetNullBool_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullBool_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ResponseParams_GetNullBool_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetNullBool_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullBool_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_value_$flag = (packed >> 0) & 1 ? true : false;
    val.optional_value_$value = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResponseParams_GetNullBool_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullBool_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_value_$flag & 1) << 0
    packed |= (val.optional_value_$value & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ResponseParams_GetNullUint8_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullUint8_Params.prototype.initDefaults_ = function() {
  };
  ResponseParams_GetNullUint8_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullUint8_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullUint8_Params.encodedSize = codec.kStructHeaderSize + 0;

  ResponseParams_GetNullUint8_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullUint8_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ResponseParams_GetNullUint8_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullUint8_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ResponseParams_GetNullUint8_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullUint8_ResponseParams.prototype.initDefaults_ = function() {
    this.optional_value_$flag = false;
    this.optional_value_$value = 0;
  };
  ResponseParams_GetNullUint8_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullUint8_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ResponseParams_GetNullUint8_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetNullUint8_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullUint8_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_value_$flag = (packed >> 0) & 1 ? true : false;
    val.optional_value_$value =
        decoder.decodeStruct(codec.Uint8);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResponseParams_GetNullUint8_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullUint8_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_value_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Uint8, val.optional_value_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ResponseParams_GetNullInt8_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullInt8_Params.prototype.initDefaults_ = function() {
  };
  ResponseParams_GetNullInt8_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullInt8_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullInt8_Params.encodedSize = codec.kStructHeaderSize + 0;

  ResponseParams_GetNullInt8_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullInt8_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ResponseParams_GetNullInt8_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullInt8_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ResponseParams_GetNullInt8_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullInt8_ResponseParams.prototype.initDefaults_ = function() {
    this.optional_value_$flag = false;
    this.optional_value_$value = 0;
  };
  ResponseParams_GetNullInt8_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullInt8_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ResponseParams_GetNullInt8_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetNullInt8_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullInt8_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_value_$flag = (packed >> 0) & 1 ? true : false;
    val.optional_value_$value =
        decoder.decodeStruct(codec.Int8);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResponseParams_GetNullInt8_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullInt8_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_value_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Int8, val.optional_value_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ResponseParams_GetNullUint16_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullUint16_Params.prototype.initDefaults_ = function() {
  };
  ResponseParams_GetNullUint16_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullUint16_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullUint16_Params.encodedSize = codec.kStructHeaderSize + 0;

  ResponseParams_GetNullUint16_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullUint16_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ResponseParams_GetNullUint16_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullUint16_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ResponseParams_GetNullUint16_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullUint16_ResponseParams.prototype.initDefaults_ = function() {
    this.optional_value_$flag = false;
    this.optional_value_$value = 0;
  };
  ResponseParams_GetNullUint16_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullUint16_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ResponseParams_GetNullUint16_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetNullUint16_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullUint16_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_value_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    val.optional_value_$value =
        decoder.decodeStruct(codec.Uint16);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResponseParams_GetNullUint16_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullUint16_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_value_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint16, val.optional_value_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ResponseParams_GetNullInt16_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullInt16_Params.prototype.initDefaults_ = function() {
  };
  ResponseParams_GetNullInt16_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullInt16_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullInt16_Params.encodedSize = codec.kStructHeaderSize + 0;

  ResponseParams_GetNullInt16_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullInt16_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ResponseParams_GetNullInt16_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullInt16_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ResponseParams_GetNullInt16_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullInt16_ResponseParams.prototype.initDefaults_ = function() {
    this.optional_value_$flag = false;
    this.optional_value_$value = 0;
  };
  ResponseParams_GetNullInt16_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullInt16_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ResponseParams_GetNullInt16_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetNullInt16_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullInt16_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_value_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    val.optional_value_$value =
        decoder.decodeStruct(codec.Int16);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResponseParams_GetNullInt16_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullInt16_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_value_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int16, val.optional_value_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ResponseParams_GetNullUint32_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullUint32_Params.prototype.initDefaults_ = function() {
  };
  ResponseParams_GetNullUint32_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullUint32_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullUint32_Params.encodedSize = codec.kStructHeaderSize + 0;

  ResponseParams_GetNullUint32_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullUint32_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ResponseParams_GetNullUint32_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullUint32_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ResponseParams_GetNullUint32_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullUint32_ResponseParams.prototype.initDefaults_ = function() {
    this.optional_value_$flag = false;
    this.optional_value_$value = 0;
  };
  ResponseParams_GetNullUint32_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullUint32_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ResponseParams_GetNullUint32_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetNullUint32_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullUint32_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_value_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_value_$value =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  ResponseParams_GetNullUint32_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullUint32_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_value_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.optional_value_$value);
  };
  function ResponseParams_GetNullInt32_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullInt32_Params.prototype.initDefaults_ = function() {
  };
  ResponseParams_GetNullInt32_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullInt32_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullInt32_Params.encodedSize = codec.kStructHeaderSize + 0;

  ResponseParams_GetNullInt32_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullInt32_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ResponseParams_GetNullInt32_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullInt32_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ResponseParams_GetNullInt32_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullInt32_ResponseParams.prototype.initDefaults_ = function() {
    this.optional_value_$flag = false;
    this.optional_value_$value = 0;
  };
  ResponseParams_GetNullInt32_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullInt32_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ResponseParams_GetNullInt32_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetNullInt32_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullInt32_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_value_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_value_$value =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  ResponseParams_GetNullInt32_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullInt32_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_value_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.optional_value_$value);
  };
  function ResponseParams_GetNullUint64_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullUint64_Params.prototype.initDefaults_ = function() {
  };
  ResponseParams_GetNullUint64_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullUint64_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullUint64_Params.encodedSize = codec.kStructHeaderSize + 0;

  ResponseParams_GetNullUint64_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullUint64_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ResponseParams_GetNullUint64_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullUint64_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ResponseParams_GetNullUint64_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullUint64_ResponseParams.prototype.initDefaults_ = function() {
    this.optional_value_$flag = false;
    this.optional_value_$value = 0;
  };
  ResponseParams_GetNullUint64_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullUint64_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ResponseParams_GetNullUint64_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  ResponseParams_GetNullUint64_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullUint64_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_value_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_value_$value =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  ResponseParams_GetNullUint64_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullUint64_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_value_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint64, val.optional_value_$value);
  };
  function ResponseParams_GetNullInt64_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullInt64_Params.prototype.initDefaults_ = function() {
  };
  ResponseParams_GetNullInt64_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullInt64_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullInt64_Params.encodedSize = codec.kStructHeaderSize + 0;

  ResponseParams_GetNullInt64_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullInt64_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ResponseParams_GetNullInt64_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullInt64_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ResponseParams_GetNullInt64_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullInt64_ResponseParams.prototype.initDefaults_ = function() {
    this.optional_value_$flag = false;
    this.optional_value_$value = 0;
  };
  ResponseParams_GetNullInt64_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullInt64_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ResponseParams_GetNullInt64_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  ResponseParams_GetNullInt64_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullInt64_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_value_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_value_$value =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  ResponseParams_GetNullInt64_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullInt64_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_value_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int64, val.optional_value_$value);
  };
  function ResponseParams_GetNullFloat_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullFloat_Params.prototype.initDefaults_ = function() {
  };
  ResponseParams_GetNullFloat_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullFloat_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullFloat_Params.encodedSize = codec.kStructHeaderSize + 0;

  ResponseParams_GetNullFloat_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullFloat_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ResponseParams_GetNullFloat_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullFloat_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ResponseParams_GetNullFloat_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullFloat_ResponseParams.prototype.initDefaults_ = function() {
    this.optional_value_$flag = false;
    this.optional_value_$value = 0;
  };
  ResponseParams_GetNullFloat_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullFloat_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ResponseParams_GetNullFloat_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetNullFloat_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullFloat_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_value_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_value_$value =
        decoder.decodeStruct(codec.Float);
    return val;
  };

  ResponseParams_GetNullFloat_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullFloat_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_value_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Float, val.optional_value_$value);
  };
  function ResponseParams_GetNullDouble_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullDouble_Params.prototype.initDefaults_ = function() {
  };
  ResponseParams_GetNullDouble_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullDouble_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullDouble_Params.encodedSize = codec.kStructHeaderSize + 0;

  ResponseParams_GetNullDouble_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullDouble_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ResponseParams_GetNullDouble_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullDouble_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ResponseParams_GetNullDouble_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullDouble_ResponseParams.prototype.initDefaults_ = function() {
    this.optional_value_$flag = false;
    this.optional_value_$value = 0;
  };
  ResponseParams_GetNullDouble_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullDouble_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ResponseParams_GetNullDouble_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  ResponseParams_GetNullDouble_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullDouble_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_value_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_value_$value =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  ResponseParams_GetNullDouble_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullDouble_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_value_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Double, val.optional_value_$value);
  };
  function ResponseParams_GetNullEnum_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullEnum_Params.prototype.initDefaults_ = function() {
  };
  ResponseParams_GetNullEnum_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullEnum_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullEnum_Params.encodedSize = codec.kStructHeaderSize + 0;

  ResponseParams_GetNullEnum_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullEnum_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ResponseParams_GetNullEnum_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullEnum_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ResponseParams_GetNullEnum_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullEnum_ResponseParams.prototype.initDefaults_ = function() {
    this.optional_value_$flag = false;
    this.optional_value_$value = 0;
  };
  ResponseParams_GetNullEnum_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullEnum_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ResponseParams_GetNullEnum_ResponseParams.optional_value_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, RegularEnum);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullEnum_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetNullEnum_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullEnum_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_value_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_value_$value =
        decoder.decodeStruct(new codec.Enum(RegularEnum));
    return val;
  };

  ResponseParams_GetNullEnum_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullEnum_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_value_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.optional_value_$value);
  };
  function ResponseParams_GetNullBools_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullBools_Params.prototype.initDefaults_ = function() {
  };
  ResponseParams_GetNullBools_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullBools_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullBools_Params.encodedSize = codec.kStructHeaderSize + 0;

  ResponseParams_GetNullBools_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullBools_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ResponseParams_GetNullBools_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullBools_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ResponseParams_GetNullBools_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullBools_ResponseParams.prototype.initDefaults_ = function() {
    this.optionalValues = null;
  };
  ResponseParams_GetNullBools_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullBools_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResponseParams_GetNullBools_ResponseParams.optionalValues
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.PackedBool, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullBools_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetNullBools_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullBools_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalValues =
        decoder.decodeArrayPointer(codec.PackedBool);
    return val;
  };

  ResponseParams_GetNullBools_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullBools_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.PackedBool, val.optionalValues);
  };
  function ResponseParams_GetNullInt16s_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullInt16s_Params.prototype.initDefaults_ = function() {
  };
  ResponseParams_GetNullInt16s_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullInt16s_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullInt16s_Params.encodedSize = codec.kStructHeaderSize + 0;

  ResponseParams_GetNullInt16s_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullInt16s_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ResponseParams_GetNullInt16s_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullInt16s_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ResponseParams_GetNullInt16s_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullInt16s_ResponseParams.prototype.initDefaults_ = function() {
    this.optionalValues = null;
  };
  ResponseParams_GetNullInt16s_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullInt16s_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResponseParams_GetNullInt16s_ResponseParams.optionalValues
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 2, codec.Int16, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullInt16s_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetNullInt16s_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullInt16s_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalValues =
        decoder.decodeArrayPointer(codec.Int16);
    return val;
  };

  ResponseParams_GetNullInt16s_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullInt16s_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Int16, val.optionalValues);
  };
  function ResponseParams_GetNullUint32s_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullUint32s_Params.prototype.initDefaults_ = function() {
  };
  ResponseParams_GetNullUint32s_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullUint32s_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullUint32s_Params.encodedSize = codec.kStructHeaderSize + 0;

  ResponseParams_GetNullUint32s_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullUint32s_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ResponseParams_GetNullUint32s_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullUint32s_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ResponseParams_GetNullUint32s_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullUint32s_ResponseParams.prototype.initDefaults_ = function() {
    this.optionalValues = null;
  };
  ResponseParams_GetNullUint32s_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullUint32s_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResponseParams_GetNullUint32s_ResponseParams.optionalValues
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, codec.Uint32, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullUint32s_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetNullUint32s_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullUint32s_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalValues =
        decoder.decodeArrayPointer(codec.Uint32);
    return val;
  };

  ResponseParams_GetNullUint32s_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullUint32s_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint32, val.optionalValues);
  };
  function ResponseParams_GetNullDoubles_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullDoubles_Params.prototype.initDefaults_ = function() {
  };
  ResponseParams_GetNullDoubles_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullDoubles_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullDoubles_Params.encodedSize = codec.kStructHeaderSize + 0;

  ResponseParams_GetNullDoubles_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullDoubles_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ResponseParams_GetNullDoubles_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullDoubles_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ResponseParams_GetNullDoubles_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullDoubles_ResponseParams.prototype.initDefaults_ = function() {
    this.optionalValues = null;
  };
  ResponseParams_GetNullDoubles_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullDoubles_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResponseParams_GetNullDoubles_ResponseParams.optionalValues
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.Double, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullDoubles_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetNullDoubles_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullDoubles_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalValues =
        decoder.decodeArrayPointer(codec.Double);
    return val;
  };

  ResponseParams_GetNullDoubles_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullDoubles_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Double, val.optionalValues);
  };
  function ResponseParams_GetNullEnums_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullEnums_Params.prototype.initDefaults_ = function() {
  };
  ResponseParams_GetNullEnums_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullEnums_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullEnums_Params.encodedSize = codec.kStructHeaderSize + 0;

  ResponseParams_GetNullEnums_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullEnums_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ResponseParams_GetNullEnums_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullEnums_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ResponseParams_GetNullEnums_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullEnums_ResponseParams.prototype.initDefaults_ = function() {
    this.optionalValues = null;
  };
  ResponseParams_GetNullEnums_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullEnums_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResponseParams_GetNullEnums_ResponseParams.optionalValues
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, new codec.Enum(RegularEnum), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullEnums_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetNullEnums_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullEnums_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalValues =
        decoder.decodeArrayPointer(new codec.Enum(RegularEnum));
    return val;
  };

  ResponseParams_GetNullEnums_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullEnums_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.Enum(RegularEnum), val.optionalValues);
  };
  function ResponseParams_GetNullBoolMap_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullBoolMap_Params.prototype.initDefaults_ = function() {
  };
  ResponseParams_GetNullBoolMap_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullBoolMap_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullBoolMap_Params.encodedSize = codec.kStructHeaderSize + 0;

  ResponseParams_GetNullBoolMap_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullBoolMap_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ResponseParams_GetNullBoolMap_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullBoolMap_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ResponseParams_GetNullBoolMap_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullBoolMap_ResponseParams.prototype.initDefaults_ = function() {
    this.optionalValues = null;
  };
  ResponseParams_GetNullBoolMap_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullBoolMap_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResponseParams_GetNullBoolMap_ResponseParams.optionalValues
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.Int16, codec.PackedBool, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullBoolMap_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetNullBoolMap_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullBoolMap_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalValues =
        decoder.decodeMapPointer(codec.Int16, codec.PackedBool);
    return val;
  };

  ResponseParams_GetNullBoolMap_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullBoolMap_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.Int16, codec.PackedBool, val.optionalValues);
  };
  function ResponseParams_GetNullInt32Map_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullInt32Map_Params.prototype.initDefaults_ = function() {
  };
  ResponseParams_GetNullInt32Map_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullInt32Map_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullInt32Map_Params.encodedSize = codec.kStructHeaderSize + 0;

  ResponseParams_GetNullInt32Map_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullInt32Map_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ResponseParams_GetNullInt32Map_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullInt32Map_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ResponseParams_GetNullInt32Map_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullInt32Map_ResponseParams.prototype.initDefaults_ = function() {
    this.optionalValues = null;
  };
  ResponseParams_GetNullInt32Map_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullInt32Map_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResponseParams_GetNullInt32Map_ResponseParams.optionalValues
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.Int16, codec.Int32, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullInt32Map_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetNullInt32Map_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullInt32Map_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalValues =
        decoder.decodeMapPointer(codec.Int16, codec.Int32);
    return val;
  };

  ResponseParams_GetNullInt32Map_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullInt32Map_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.Int16, codec.Int32, val.optionalValues);
  };
  function ResponseParams_GetNullEnumMap_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullEnumMap_Params.prototype.initDefaults_ = function() {
  };
  ResponseParams_GetNullEnumMap_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullEnumMap_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullEnumMap_Params.encodedSize = codec.kStructHeaderSize + 0;

  ResponseParams_GetNullEnumMap_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullEnumMap_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ResponseParams_GetNullEnumMap_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullEnumMap_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ResponseParams_GetNullEnumMap_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullEnumMap_ResponseParams.prototype.initDefaults_ = function() {
    this.optionalValues = null;
  };
  ResponseParams_GetNullEnumMap_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullEnumMap_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResponseParams_GetNullEnumMap_ResponseParams.optionalValues
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.Int16, new codec.Enum(RegularEnum), true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullEnumMap_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetNullEnumMap_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullEnumMap_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalValues =
        decoder.decodeMapPointer(codec.Int16, new codec.Enum(RegularEnum));
    return val;
  };

  ResponseParams_GetNullEnumMap_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullEnumMap_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.Int16, new codec.Enum(RegularEnum), val.optionalValues);
  };
  function ResponseParams_GetOptionalBool_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalBool_Params.prototype.initDefaults_ = function() {
    this.value = false;
  };
  ResponseParams_GetOptionalBool_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalBool_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalBool_Params.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalBool_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalBool_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.value = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResponseParams_GetOptionalBool_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalBool_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.value & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ResponseParams_GetOptionalBool_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalBool_ResponseParams.prototype.initDefaults_ = function() {
    this.optional_value_$flag = false;
    this.optional_value_$value = false;
  };
  ResponseParams_GetOptionalBool_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalBool_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalBool_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalBool_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalBool_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_value_$flag = (packed >> 0) & 1 ? true : false;
    val.optional_value_$value = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResponseParams_GetOptionalBool_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalBool_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_value_$flag & 1) << 0
    packed |= (val.optional_value_$value & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ResponseParams_GetOptionalUint8_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalUint8_Params.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  ResponseParams_GetOptionalUint8_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalUint8_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalUint8_Params.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalUint8_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalUint8_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Uint8);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResponseParams_GetOptionalUint8_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalUint8_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint8, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ResponseParams_GetOptionalUint8_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalUint8_ResponseParams.prototype.initDefaults_ = function() {
    this.optional_value_$flag = false;
    this.optional_value_$value = 0;
  };
  ResponseParams_GetOptionalUint8_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalUint8_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalUint8_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalUint8_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalUint8_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_value_$flag = (packed >> 0) & 1 ? true : false;
    val.optional_value_$value =
        decoder.decodeStruct(codec.Uint8);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResponseParams_GetOptionalUint8_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalUint8_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_value_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Uint8, val.optional_value_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ResponseParams_GetOptionalInt8_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalInt8_Params.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  ResponseParams_GetOptionalInt8_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalInt8_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalInt8_Params.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalInt8_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalInt8_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Int8);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResponseParams_GetOptionalInt8_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalInt8_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int8, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ResponseParams_GetOptionalInt8_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalInt8_ResponseParams.prototype.initDefaults_ = function() {
    this.optional_value_$flag = false;
    this.optional_value_$value = 0;
  };
  ResponseParams_GetOptionalInt8_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalInt8_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalInt8_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalInt8_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalInt8_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_value_$flag = (packed >> 0) & 1 ? true : false;
    val.optional_value_$value =
        decoder.decodeStruct(codec.Int8);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResponseParams_GetOptionalInt8_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalInt8_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_value_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Int8, val.optional_value_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ResponseParams_GetOptionalUint16_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalUint16_Params.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  ResponseParams_GetOptionalUint16_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalUint16_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalUint16_Params.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalUint16_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalUint16_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Uint16);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResponseParams_GetOptionalUint16_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalUint16_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint16, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ResponseParams_GetOptionalUint16_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalUint16_ResponseParams.prototype.initDefaults_ = function() {
    this.optional_value_$flag = false;
    this.optional_value_$value = 0;
  };
  ResponseParams_GetOptionalUint16_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalUint16_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalUint16_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalUint16_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalUint16_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_value_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    val.optional_value_$value =
        decoder.decodeStruct(codec.Uint16);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResponseParams_GetOptionalUint16_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalUint16_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_value_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint16, val.optional_value_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ResponseParams_GetOptionalInt16_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalInt16_Params.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  ResponseParams_GetOptionalInt16_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalInt16_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalInt16_Params.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalInt16_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalInt16_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Int16);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResponseParams_GetOptionalInt16_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalInt16_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int16, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ResponseParams_GetOptionalInt16_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalInt16_ResponseParams.prototype.initDefaults_ = function() {
    this.optional_value_$flag = false;
    this.optional_value_$value = 0;
  };
  ResponseParams_GetOptionalInt16_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalInt16_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalInt16_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalInt16_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalInt16_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_value_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    val.optional_value_$value =
        decoder.decodeStruct(codec.Int16);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResponseParams_GetOptionalInt16_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalInt16_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_value_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int16, val.optional_value_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ResponseParams_GetOptionalUint32_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalUint32_Params.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  ResponseParams_GetOptionalUint32_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalUint32_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalUint32_Params.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalUint32_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalUint32_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResponseParams_GetOptionalUint32_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalUint32_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ResponseParams_GetOptionalUint32_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalUint32_ResponseParams.prototype.initDefaults_ = function() {
    this.optional_value_$flag = false;
    this.optional_value_$value = 0;
  };
  ResponseParams_GetOptionalUint32_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalUint32_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalUint32_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalUint32_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalUint32_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_value_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_value_$value =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  ResponseParams_GetOptionalUint32_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalUint32_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_value_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.optional_value_$value);
  };
  function ResponseParams_GetOptionalInt32_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalInt32_Params.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  ResponseParams_GetOptionalInt32_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalInt32_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalInt32_Params.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalInt32_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalInt32_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResponseParams_GetOptionalInt32_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalInt32_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ResponseParams_GetOptionalInt32_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalInt32_ResponseParams.prototype.initDefaults_ = function() {
    this.optional_value_$flag = false;
    this.optional_value_$value = 0;
  };
  ResponseParams_GetOptionalInt32_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalInt32_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalInt32_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalInt32_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalInt32_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_value_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_value_$value =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  ResponseParams_GetOptionalInt32_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalInt32_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_value_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.optional_value_$value);
  };
  function ResponseParams_GetOptionalUint64_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalUint64_Params.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  ResponseParams_GetOptionalUint64_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalUint64_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalUint64_Params.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalUint64_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalUint64_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  ResponseParams_GetOptionalUint64_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalUint64_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.value);
  };
  function ResponseParams_GetOptionalUint64_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalUint64_ResponseParams.prototype.initDefaults_ = function() {
    this.optional_value_$flag = false;
    this.optional_value_$value = 0;
  };
  ResponseParams_GetOptionalUint64_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalUint64_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalUint64_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  ResponseParams_GetOptionalUint64_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalUint64_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_value_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_value_$value =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  ResponseParams_GetOptionalUint64_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalUint64_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_value_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint64, val.optional_value_$value);
  };
  function ResponseParams_GetOptionalInt64_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalInt64_Params.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  ResponseParams_GetOptionalInt64_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalInt64_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalInt64_Params.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalInt64_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalInt64_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  ResponseParams_GetOptionalInt64_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalInt64_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.value);
  };
  function ResponseParams_GetOptionalInt64_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalInt64_ResponseParams.prototype.initDefaults_ = function() {
    this.optional_value_$flag = false;
    this.optional_value_$value = 0;
  };
  ResponseParams_GetOptionalInt64_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalInt64_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalInt64_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  ResponseParams_GetOptionalInt64_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalInt64_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_value_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_value_$value =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  ResponseParams_GetOptionalInt64_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalInt64_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_value_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int64, val.optional_value_$value);
  };
  function ResponseParams_GetOptionalFloat_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalFloat_Params.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  ResponseParams_GetOptionalFloat_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalFloat_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalFloat_Params.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalFloat_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalFloat_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Float);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResponseParams_GetOptionalFloat_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalFloat_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Float, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ResponseParams_GetOptionalFloat_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalFloat_ResponseParams.prototype.initDefaults_ = function() {
    this.optional_value_$flag = false;
    this.optional_value_$value = 0;
  };
  ResponseParams_GetOptionalFloat_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalFloat_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalFloat_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalFloat_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalFloat_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_value_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_value_$value =
        decoder.decodeStruct(codec.Float);
    return val;
  };

  ResponseParams_GetOptionalFloat_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalFloat_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_value_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Float, val.optional_value_$value);
  };
  function ResponseParams_GetOptionalDouble_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalDouble_Params.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  ResponseParams_GetOptionalDouble_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalDouble_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalDouble_Params.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalDouble_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalDouble_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  ResponseParams_GetOptionalDouble_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalDouble_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Double, val.value);
  };
  function ResponseParams_GetOptionalDouble_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalDouble_ResponseParams.prototype.initDefaults_ = function() {
    this.optional_value_$flag = false;
    this.optional_value_$value = 0;
  };
  ResponseParams_GetOptionalDouble_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalDouble_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalDouble_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  ResponseParams_GetOptionalDouble_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalDouble_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_value_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_value_$value =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  ResponseParams_GetOptionalDouble_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalDouble_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_value_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Double, val.optional_value_$value);
  };
  function ResponseParams_GetOptionalEnum_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalEnum_Params.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  ResponseParams_GetOptionalEnum_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalEnum_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResponseParams_GetOptionalEnum_Params.value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, RegularEnum);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalEnum_Params.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalEnum_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalEnum_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(new codec.Enum(RegularEnum));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResponseParams_GetOptionalEnum_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalEnum_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ResponseParams_GetOptionalEnum_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalEnum_ResponseParams.prototype.initDefaults_ = function() {
    this.optional_value_$flag = false;
    this.optional_value_$value = 0;
  };
  ResponseParams_GetOptionalEnum_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalEnum_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ResponseParams_GetOptionalEnum_ResponseParams.optional_value_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, RegularEnum);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalEnum_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalEnum_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalEnum_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.optional_value_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.optional_value_$value =
        decoder.decodeStruct(new codec.Enum(RegularEnum));
    return val;
  };

  ResponseParams_GetOptionalEnum_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalEnum_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.optional_value_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.optional_value_$value);
  };
  function ResponseParams_GetOptionalBools_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalBools_Params.prototype.initDefaults_ = function() {
    this.value = false;
  };
  ResponseParams_GetOptionalBools_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalBools_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalBools_Params.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalBools_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalBools_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.value = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResponseParams_GetOptionalBools_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalBools_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.value & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ResponseParams_GetOptionalBools_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalBools_ResponseParams.prototype.initDefaults_ = function() {
    this.optionalValues = null;
  };
  ResponseParams_GetOptionalBools_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalBools_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResponseParams_GetOptionalBools_ResponseParams.optionalValues
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.PackedBool, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalBools_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalBools_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalBools_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalValues =
        decoder.decodeArrayPointer(codec.PackedBool);
    return val;
  };

  ResponseParams_GetOptionalBools_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalBools_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.PackedBool, val.optionalValues);
  };
  function ResponseParams_GetOptionalInt16s_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalInt16s_Params.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  ResponseParams_GetOptionalInt16s_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalInt16s_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalInt16s_Params.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalInt16s_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalInt16s_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Int16);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResponseParams_GetOptionalInt16s_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalInt16s_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int16, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ResponseParams_GetOptionalInt16s_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalInt16s_ResponseParams.prototype.initDefaults_ = function() {
    this.optionalValues = null;
  };
  ResponseParams_GetOptionalInt16s_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalInt16s_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResponseParams_GetOptionalInt16s_ResponseParams.optionalValues
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 2, codec.Int16, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalInt16s_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalInt16s_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalInt16s_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalValues =
        decoder.decodeArrayPointer(codec.Int16);
    return val;
  };

  ResponseParams_GetOptionalInt16s_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalInt16s_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Int16, val.optionalValues);
  };
  function ResponseParams_GetOptionalUint32s_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalUint32s_Params.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  ResponseParams_GetOptionalUint32s_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalUint32s_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalUint32s_Params.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalUint32s_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalUint32s_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResponseParams_GetOptionalUint32s_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalUint32s_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ResponseParams_GetOptionalUint32s_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalUint32s_ResponseParams.prototype.initDefaults_ = function() {
    this.optionalValues = null;
  };
  ResponseParams_GetOptionalUint32s_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalUint32s_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResponseParams_GetOptionalUint32s_ResponseParams.optionalValues
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, codec.Uint32, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalUint32s_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalUint32s_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalUint32s_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalValues =
        decoder.decodeArrayPointer(codec.Uint32);
    return val;
  };

  ResponseParams_GetOptionalUint32s_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalUint32s_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint32, val.optionalValues);
  };
  function ResponseParams_GetOptionalDoubles_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalDoubles_Params.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  ResponseParams_GetOptionalDoubles_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalDoubles_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalDoubles_Params.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalDoubles_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalDoubles_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  ResponseParams_GetOptionalDoubles_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalDoubles_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Double, val.value);
  };
  function ResponseParams_GetOptionalDoubles_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalDoubles_ResponseParams.prototype.initDefaults_ = function() {
    this.optionalValues = null;
  };
  ResponseParams_GetOptionalDoubles_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalDoubles_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResponseParams_GetOptionalDoubles_ResponseParams.optionalValues
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.Double, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalDoubles_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalDoubles_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalDoubles_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalValues =
        decoder.decodeArrayPointer(codec.Double);
    return val;
  };

  ResponseParams_GetOptionalDoubles_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalDoubles_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Double, val.optionalValues);
  };
  function ResponseParams_GetOptionalEnums_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalEnums_Params.prototype.initDefaults_ = function() {
    this.value = 0;
  };
  ResponseParams_GetOptionalEnums_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalEnums_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResponseParams_GetOptionalEnums_Params.value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, RegularEnum);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalEnums_Params.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalEnums_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalEnums_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(new codec.Enum(RegularEnum));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResponseParams_GetOptionalEnums_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalEnums_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ResponseParams_GetOptionalEnums_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalEnums_ResponseParams.prototype.initDefaults_ = function() {
    this.optionalValues = null;
  };
  ResponseParams_GetOptionalEnums_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalEnums_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResponseParams_GetOptionalEnums_ResponseParams.optionalValues
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, new codec.Enum(RegularEnum), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalEnums_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalEnums_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalEnums_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalValues =
        decoder.decodeArrayPointer(new codec.Enum(RegularEnum));
    return val;
  };

  ResponseParams_GetOptionalEnums_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalEnums_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.Enum(RegularEnum), val.optionalValues);
  };
  function ResponseParams_GetOptionalBoolMap_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalBoolMap_Params.prototype.initDefaults_ = function() {
    this.key = 0;
    this.value = false;
  };
  ResponseParams_GetOptionalBoolMap_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalBoolMap_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalBoolMap_Params.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalBoolMap_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalBoolMap_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.key =
        decoder.decodeStruct(codec.Int16);
    packed = decoder.readUint8();
    val.value = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ResponseParams_GetOptionalBoolMap_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalBoolMap_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int16, val.key);
    packed = 0;
    packed |= (val.value & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ResponseParams_GetOptionalBoolMap_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalBoolMap_ResponseParams.prototype.initDefaults_ = function() {
    this.optionalValues = null;
  };
  ResponseParams_GetOptionalBoolMap_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalBoolMap_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResponseParams_GetOptionalBoolMap_ResponseParams.optionalValues
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.Int16, codec.PackedBool, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalBoolMap_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalBoolMap_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalBoolMap_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalValues =
        decoder.decodeMapPointer(codec.Int16, codec.PackedBool);
    return val;
  };

  ResponseParams_GetOptionalBoolMap_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalBoolMap_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.Int16, codec.PackedBool, val.optionalValues);
  };
  function ResponseParams_GetOptionalFloatMap_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalFloatMap_Params.prototype.initDefaults_ = function() {
    this.key = 0;
    this.value = 0;
  };
  ResponseParams_GetOptionalFloatMap_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalFloatMap_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalFloatMap_Params.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalFloatMap_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalFloatMap_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.key =
        decoder.decodeStruct(codec.Int16);
    decoder.skip(1);
    decoder.skip(1);
    val.value =
        decoder.decodeStruct(codec.Float);
    return val;
  };

  ResponseParams_GetOptionalFloatMap_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalFloatMap_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int16, val.key);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Float, val.value);
  };
  function ResponseParams_GetOptionalFloatMap_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalFloatMap_ResponseParams.prototype.initDefaults_ = function() {
    this.optionalValues = null;
  };
  ResponseParams_GetOptionalFloatMap_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalFloatMap_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResponseParams_GetOptionalFloatMap_ResponseParams.optionalValues
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.Int16, codec.Float, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalFloatMap_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalFloatMap_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalFloatMap_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalValues =
        decoder.decodeMapPointer(codec.Int16, codec.Float);
    return val;
  };

  ResponseParams_GetOptionalFloatMap_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalFloatMap_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.Int16, codec.Float, val.optionalValues);
  };
  function ResponseParams_GetOptionalEnumMap_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalEnumMap_Params.prototype.initDefaults_ = function() {
    this.key = 0;
    this.value = 0;
  };
  ResponseParams_GetOptionalEnumMap_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalEnumMap_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ResponseParams_GetOptionalEnumMap_Params.value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, RegularEnum);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalEnumMap_Params.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalEnumMap_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalEnumMap_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.key =
        decoder.decodeStruct(codec.Int16);
    decoder.skip(1);
    decoder.skip(1);
    val.value =
        decoder.decodeStruct(new codec.Enum(RegularEnum));
    return val;
  };

  ResponseParams_GetOptionalEnumMap_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalEnumMap_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int16, val.key);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.value);
  };
  function ResponseParams_GetOptionalEnumMap_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetOptionalEnumMap_ResponseParams.prototype.initDefaults_ = function() {
    this.optionalValues = null;
  };
  ResponseParams_GetOptionalEnumMap_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetOptionalEnumMap_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResponseParams_GetOptionalEnumMap_ResponseParams.optionalValues
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.Int16, new codec.Enum(RegularEnum), true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetOptionalEnumMap_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetOptionalEnumMap_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetOptionalEnumMap_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.optionalValues =
        decoder.decodeMapPointer(codec.Int16, new codec.Enum(RegularEnum));
    return val;
  };

  ResponseParams_GetOptionalEnumMap_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetOptionalEnumMap_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.Int16, new codec.Enum(RegularEnum), val.optionalValues);
  };
  function ResponseParams_GetNullStructWithOptionalNumerics_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullStructWithOptionalNumerics_Params.prototype.initDefaults_ = function() {
  };
  ResponseParams_GetNullStructWithOptionalNumerics_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullStructWithOptionalNumerics_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullStructWithOptionalNumerics_Params.encodedSize = codec.kStructHeaderSize + 0;

  ResponseParams_GetNullStructWithOptionalNumerics_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullStructWithOptionalNumerics_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ResponseParams_GetNullStructWithOptionalNumerics_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullStructWithOptionalNumerics_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ResponseParams_GetNullStructWithOptionalNumerics_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetNullStructWithOptionalNumerics_ResponseParams.prototype.initDefaults_ = function() {
    this.s = null;
  };
  ResponseParams_GetNullStructWithOptionalNumerics_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetNullStructWithOptionalNumerics_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResponseParams_GetNullStructWithOptionalNumerics_ResponseParams.s
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, OptionalNumericsStruct, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetNullStructWithOptionalNumerics_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetNullStructWithOptionalNumerics_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetNullStructWithOptionalNumerics_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.s =
        decoder.decodeStructPointer(OptionalNumericsStruct);
    return val;
  };

  ResponseParams_GetNullStructWithOptionalNumerics_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetNullStructWithOptionalNumerics_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(OptionalNumericsStruct, val.s);
  };
  function ResponseParams_GetStructWithNullOptionalNumerics_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetStructWithNullOptionalNumerics_Params.prototype.initDefaults_ = function() {
  };
  ResponseParams_GetStructWithNullOptionalNumerics_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetStructWithNullOptionalNumerics_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetStructWithNullOptionalNumerics_Params.encodedSize = codec.kStructHeaderSize + 0;

  ResponseParams_GetStructWithNullOptionalNumerics_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetStructWithNullOptionalNumerics_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ResponseParams_GetStructWithNullOptionalNumerics_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetStructWithNullOptionalNumerics_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ResponseParams_GetStructWithNullOptionalNumerics_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetStructWithNullOptionalNumerics_ResponseParams.prototype.initDefaults_ = function() {
    this.s = null;
  };
  ResponseParams_GetStructWithNullOptionalNumerics_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetStructWithNullOptionalNumerics_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResponseParams_GetStructWithNullOptionalNumerics_ResponseParams.s
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, OptionalNumericsStruct, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetStructWithNullOptionalNumerics_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetStructWithNullOptionalNumerics_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetStructWithNullOptionalNumerics_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.s =
        decoder.decodeStructPointer(OptionalNumericsStruct);
    return val;
  };

  ResponseParams_GetStructWithNullOptionalNumerics_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetStructWithNullOptionalNumerics_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(OptionalNumericsStruct, val.s);
  };
  function ResponseParams_GetStructWithOptionalNumerics_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetStructWithOptionalNumerics_Params.prototype.initDefaults_ = function() {
    this.boolValue = false;
    this.uint8Value = 0;
    this.int8Value = 0;
    this.uint16Value = 0;
    this.int16Value = 0;
    this.uint32Value = 0;
    this.int32Value = 0;
    this.uint64Value = 0;
    this.int64Value = 0;
    this.floatValue = 0;
    this.enumValue = 0;
    this.doubleValue = 0;
  };
  ResponseParams_GetStructWithOptionalNumerics_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetStructWithOptionalNumerics_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;













    // validate ResponseParams_GetStructWithOptionalNumerics_Params.enumValue
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 36, RegularEnum);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetStructWithOptionalNumerics_Params.encodedSize = codec.kStructHeaderSize + 48;

  ResponseParams_GetStructWithOptionalNumerics_Params.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetStructWithOptionalNumerics_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.boolValue = (packed >> 0) & 1 ? true : false;
    val.uint8Value =
        decoder.decodeStruct(codec.Uint8);
    val.int8Value =
        decoder.decodeStruct(codec.Int8);
    decoder.skip(1);
    val.uint16Value =
        decoder.decodeStruct(codec.Uint16);
    val.int16Value =
        decoder.decodeStruct(codec.Int16);
    val.uint32Value =
        decoder.decodeStruct(codec.Uint32);
    val.int32Value =
        decoder.decodeStruct(codec.Int32);
    val.uint64Value =
        decoder.decodeStruct(codec.Uint64);
    val.int64Value =
        decoder.decodeStruct(codec.Int64);
    val.floatValue =
        decoder.decodeStruct(codec.Float);
    val.enumValue =
        decoder.decodeStruct(new codec.Enum(RegularEnum));
    val.doubleValue =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  ResponseParams_GetStructWithOptionalNumerics_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetStructWithOptionalNumerics_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.boolValue & 1) << 0
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Uint8, val.uint8Value);
    encoder.encodeStruct(codec.Int8, val.int8Value);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint16, val.uint16Value);
    encoder.encodeStruct(codec.Int16, val.int16Value);
    encoder.encodeStruct(codec.Uint32, val.uint32Value);
    encoder.encodeStruct(codec.Int32, val.int32Value);
    encoder.encodeStruct(codec.Uint64, val.uint64Value);
    encoder.encodeStruct(codec.Int64, val.int64Value);
    encoder.encodeStruct(codec.Float, val.floatValue);
    encoder.encodeStruct(codec.Int32, val.enumValue);
    encoder.encodeStruct(codec.Double, val.doubleValue);
  };
  function ResponseParams_GetStructWithOptionalNumerics_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ResponseParams_GetStructWithOptionalNumerics_ResponseParams.prototype.initDefaults_ = function() {
    this.s = null;
  };
  ResponseParams_GetStructWithOptionalNumerics_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ResponseParams_GetStructWithOptionalNumerics_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ResponseParams_GetStructWithOptionalNumerics_ResponseParams.s
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, OptionalNumericsStruct, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ResponseParams_GetStructWithOptionalNumerics_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ResponseParams_GetStructWithOptionalNumerics_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ResponseParams_GetStructWithOptionalNumerics_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.s =
        decoder.decodeStructPointer(OptionalNumericsStruct);
    return val;
  };

  ResponseParams_GetStructWithOptionalNumerics_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ResponseParams_GetStructWithOptionalNumerics_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(OptionalNumericsStruct, val.s);
  };
  function InterfaceV0_MethodWithVersionedParams_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InterfaceV0_MethodWithVersionedParams_Params.prototype.initDefaults_ = function() {
  };
  InterfaceV0_MethodWithVersionedParams_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InterfaceV0_MethodWithVersionedParams_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InterfaceV0_MethodWithVersionedParams_Params.encodedSize = codec.kStructHeaderSize + 0;

  InterfaceV0_MethodWithVersionedParams_Params.decode = function(decoder) {
    var packed;
    var val = new InterfaceV0_MethodWithVersionedParams_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  InterfaceV0_MethodWithVersionedParams_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InterfaceV0_MethodWithVersionedParams_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function InterfaceV0_MethodWithVersionedParams_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InterfaceV0_MethodWithVersionedParams_ResponseParams.prototype.initDefaults_ = function() {
  };
  InterfaceV0_MethodWithVersionedParams_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InterfaceV0_MethodWithVersionedParams_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InterfaceV0_MethodWithVersionedParams_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  InterfaceV0_MethodWithVersionedParams_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new InterfaceV0_MethodWithVersionedParams_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  InterfaceV0_MethodWithVersionedParams_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InterfaceV0_MethodWithVersionedParams_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function InterfaceV0_MethodWithVersionedStruct_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InterfaceV0_MethodWithVersionedStruct_Params.prototype.initDefaults_ = function() {
    this.s = null;
  };
  InterfaceV0_MethodWithVersionedStruct_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InterfaceV0_MethodWithVersionedStruct_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterfaceV0_MethodWithVersionedStruct_Params.s
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, VersionedStructV0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InterfaceV0_MethodWithVersionedStruct_Params.encodedSize = codec.kStructHeaderSize + 8;

  InterfaceV0_MethodWithVersionedStruct_Params.decode = function(decoder) {
    var packed;
    var val = new InterfaceV0_MethodWithVersionedStruct_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.s =
        decoder.decodeStructPointer(VersionedStructV0);
    return val;
  };

  InterfaceV0_MethodWithVersionedStruct_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InterfaceV0_MethodWithVersionedStruct_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(VersionedStructV0, val.s);
  };
  function InterfaceV0_MethodWithVersionedStruct_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InterfaceV0_MethodWithVersionedStruct_ResponseParams.prototype.initDefaults_ = function() {
    this.s = null;
  };
  InterfaceV0_MethodWithVersionedStruct_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InterfaceV0_MethodWithVersionedStruct_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterfaceV0_MethodWithVersionedStruct_ResponseParams.s
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, VersionedStructV0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InterfaceV0_MethodWithVersionedStruct_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  InterfaceV0_MethodWithVersionedStruct_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new InterfaceV0_MethodWithVersionedStruct_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.s =
        decoder.decodeStructPointer(VersionedStructV0);
    return val;
  };

  InterfaceV0_MethodWithVersionedStruct_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InterfaceV0_MethodWithVersionedStruct_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(VersionedStructV0, val.s);
  };
  function InterfaceV2_MethodWithVersionedParams_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InterfaceV2_MethodWithVersionedParams_Params.prototype.initDefaults_ = function() {
    this.bool_value_$flag = false;
    this.bool_value_$value = false;
    this.uint8_value_$flag = false;
    this.int8_value_$flag = false;
    this.uint16_value_$flag = false;
    this.int16_value_$flag = false;
    this.uint32_value_$flag = false;
    this.int32_value_$flag = false;
    this.uint8_value_$value = 0;
    this.int8_value_$value = 0;
    this.uint64_value_$flag = false;
    this.int64_value_$flag = false;
    this.float_value_$flag = false;
    this.double_value_$flag = false;
    this.enum_value_$flag = false;
    this.uint16_value_$value = 0;
    this.int16_value_$value = 0;
    this.uint32_value_$value = 0;
    this.int32_value_$value = 0;
    this.uint64_value_$value = 0;
    this.int64_value_$value = 0;
    this.float_value_$value = 0;
    this.enum_value_$value = 0;
    this.double_value_$value = 0;
  };
  InterfaceV2_MethodWithVersionedParams_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InterfaceV2_MethodWithVersionedParams_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8},
      {version: 2, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


























    // version check InterfaceV2_MethodWithVersionedParams_Params.enum_value_$value
    if (!messageValidator.isFieldInStructVersion(offset, 2))
      return validator.validationError.NONE;
    // validate InterfaceV2_MethodWithVersionedParams_Params.enum_value_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 36, RegularEnum);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InterfaceV2_MethodWithVersionedParams_Params.encodedSize = codec.kStructHeaderSize + 48;

  InterfaceV2_MethodWithVersionedParams_Params.decode = function(decoder) {
    var packed;
    var val = new InterfaceV2_MethodWithVersionedParams_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.bool_value_$flag = (packed >> 0) & 1 ? true : false;
    val.bool_value_$value = (packed >> 1) & 1 ? true : false;
    val.uint8_value_$flag = (packed >> 2) & 1 ? true : false;
    val.int8_value_$flag = (packed >> 3) & 1 ? true : false;
    val.uint16_value_$flag = (packed >> 4) & 1 ? true : false;
    val.int16_value_$flag = (packed >> 5) & 1 ? true : false;
    val.uint32_value_$flag = (packed >> 6) & 1 ? true : false;
    val.int32_value_$flag = (packed >> 7) & 1 ? true : false;
    if (version >= 2) {
      val.uint8_value_$value =
          decoder.decodeStruct(codec.Uint8);
    } else {
      val.uint8_value_$value = null;
    }
    if (version >= 2) {
      val.int8_value_$value =
          decoder.decodeStruct(codec.Int8);
    } else {
      val.int8_value_$value = null;
    }
    packed = decoder.readUint8();
    val.uint64_value_$flag = (packed >> 0) & 1 ? true : false;
    val.int64_value_$flag = (packed >> 1) & 1 ? true : false;
    val.float_value_$flag = (packed >> 2) & 1 ? true : false;
    val.double_value_$flag = (packed >> 3) & 1 ? true : false;
    val.enum_value_$flag = (packed >> 4) & 1 ? true : false;
    if (version >= 2) {
      val.uint16_value_$value =
          decoder.decodeStruct(codec.Uint16);
    } else {
      val.uint16_value_$value = null;
    }
    if (version >= 2) {
      val.int16_value_$value =
          decoder.decodeStruct(codec.Int16);
    } else {
      val.int16_value_$value = null;
    }
    if (version >= 2) {
      val.uint32_value_$value =
          decoder.decodeStruct(codec.Uint32);
    } else {
      val.uint32_value_$value = null;
    }
    if (version >= 2) {
      val.int32_value_$value =
          decoder.decodeStruct(codec.Int32);
    } else {
      val.int32_value_$value = null;
    }
    if (version >= 2) {
      val.uint64_value_$value =
          decoder.decodeStruct(codec.Uint64);
    } else {
      val.uint64_value_$value = null;
    }
    if (version >= 2) {
      val.int64_value_$value =
          decoder.decodeStruct(codec.Int64);
    } else {
      val.int64_value_$value = null;
    }
    if (version >= 2) {
      val.float_value_$value =
          decoder.decodeStruct(codec.Float);
    } else {
      val.float_value_$value = null;
    }
    if (version >= 2) {
      val.enum_value_$value =
          decoder.decodeStruct(new codec.Enum(RegularEnum));
    } else {
      val.enum_value_$value = null;
    }
    if (version >= 2) {
      val.double_value_$value =
          decoder.decodeStruct(codec.Double);
    } else {
      val.double_value_$value = null;
    }
    return val;
  };

  InterfaceV2_MethodWithVersionedParams_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InterfaceV2_MethodWithVersionedParams_Params.encodedSize);
    encoder.writeUint32(2);
    packed = 0;
    packed |= (val.bool_value_$flag & 1) << 0
    packed |= (val.bool_value_$value & 1) << 1
    packed |= (val.uint8_value_$flag & 1) << 2
    packed |= (val.int8_value_$flag & 1) << 3
    packed |= (val.uint16_value_$flag & 1) << 4
    packed |= (val.int16_value_$flag & 1) << 5
    packed |= (val.uint32_value_$flag & 1) << 6
    packed |= (val.int32_value_$flag & 1) << 7
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Uint8, val.uint8_value_$value);
    encoder.encodeStruct(codec.Int8, val.int8_value_$value);
    packed = 0;
    packed |= (val.uint64_value_$flag & 1) << 0
    packed |= (val.int64_value_$flag & 1) << 1
    packed |= (val.float_value_$flag & 1) << 2
    packed |= (val.double_value_$flag & 1) << 3
    packed |= (val.enum_value_$flag & 1) << 4
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Uint16, val.uint16_value_$value);
    encoder.encodeStruct(codec.Int16, val.int16_value_$value);
    encoder.encodeStruct(codec.Uint32, val.uint32_value_$value);
    encoder.encodeStruct(codec.Int32, val.int32_value_$value);
    encoder.encodeStruct(codec.Uint64, val.uint64_value_$value);
    encoder.encodeStruct(codec.Int64, val.int64_value_$value);
    encoder.encodeStruct(codec.Float, val.float_value_$value);
    encoder.encodeStruct(codec.Int32, val.enum_value_$value);
    encoder.encodeStruct(codec.Double, val.double_value_$value);
  };
  function InterfaceV2_MethodWithVersionedParams_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InterfaceV2_MethodWithVersionedParams_ResponseParams.prototype.initDefaults_ = function() {
    this.bool_value_$flag = false;
    this.bool_value_$value = false;
    this.uint8_value_$flag = false;
    this.int8_value_$flag = false;
    this.uint16_value_$flag = false;
    this.int16_value_$flag = false;
    this.uint32_value_$flag = false;
    this.int32_value_$flag = false;
    this.uint8_value_$value = 0;
    this.int8_value_$value = 0;
    this.uint64_value_$flag = false;
    this.int64_value_$flag = false;
    this.float_value_$flag = false;
    this.double_value_$flag = false;
    this.enum_value_$flag = false;
    this.uint16_value_$value = 0;
    this.int16_value_$value = 0;
    this.uint32_value_$value = 0;
    this.int32_value_$value = 0;
    this.uint64_value_$value = 0;
    this.int64_value_$value = 0;
    this.float_value_$value = 0;
    this.enum_value_$value = 0;
    this.double_value_$value = 0;
  };
  InterfaceV2_MethodWithVersionedParams_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InterfaceV2_MethodWithVersionedParams_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8},
      {version: 2, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


























    // version check InterfaceV2_MethodWithVersionedParams_ResponseParams.enum_value_$value
    if (!messageValidator.isFieldInStructVersion(offset, 2))
      return validator.validationError.NONE;
    // validate InterfaceV2_MethodWithVersionedParams_ResponseParams.enum_value_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 36, RegularEnum);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InterfaceV2_MethodWithVersionedParams_ResponseParams.encodedSize = codec.kStructHeaderSize + 48;

  InterfaceV2_MethodWithVersionedParams_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new InterfaceV2_MethodWithVersionedParams_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.bool_value_$flag = (packed >> 0) & 1 ? true : false;
    val.bool_value_$value = (packed >> 1) & 1 ? true : false;
    val.uint8_value_$flag = (packed >> 2) & 1 ? true : false;
    val.int8_value_$flag = (packed >> 3) & 1 ? true : false;
    val.uint16_value_$flag = (packed >> 4) & 1 ? true : false;
    val.int16_value_$flag = (packed >> 5) & 1 ? true : false;
    val.uint32_value_$flag = (packed >> 6) & 1 ? true : false;
    val.int32_value_$flag = (packed >> 7) & 1 ? true : false;
    if (version >= 2) {
      val.uint8_value_$value =
          decoder.decodeStruct(codec.Uint8);
    } else {
      val.uint8_value_$value = null;
    }
    if (version >= 2) {
      val.int8_value_$value =
          decoder.decodeStruct(codec.Int8);
    } else {
      val.int8_value_$value = null;
    }
    packed = decoder.readUint8();
    val.uint64_value_$flag = (packed >> 0) & 1 ? true : false;
    val.int64_value_$flag = (packed >> 1) & 1 ? true : false;
    val.float_value_$flag = (packed >> 2) & 1 ? true : false;
    val.double_value_$flag = (packed >> 3) & 1 ? true : false;
    val.enum_value_$flag = (packed >> 4) & 1 ? true : false;
    if (version >= 2) {
      val.uint16_value_$value =
          decoder.decodeStruct(codec.Uint16);
    } else {
      val.uint16_value_$value = null;
    }
    if (version >= 2) {
      val.int16_value_$value =
          decoder.decodeStruct(codec.Int16);
    } else {
      val.int16_value_$value = null;
    }
    if (version >= 2) {
      val.uint32_value_$value =
          decoder.decodeStruct(codec.Uint32);
    } else {
      val.uint32_value_$value = null;
    }
    if (version >= 2) {
      val.int32_value_$value =
          decoder.decodeStruct(codec.Int32);
    } else {
      val.int32_value_$value = null;
    }
    if (version >= 2) {
      val.uint64_value_$value =
          decoder.decodeStruct(codec.Uint64);
    } else {
      val.uint64_value_$value = null;
    }
    if (version >= 2) {
      val.int64_value_$value =
          decoder.decodeStruct(codec.Int64);
    } else {
      val.int64_value_$value = null;
    }
    if (version >= 2) {
      val.float_value_$value =
          decoder.decodeStruct(codec.Float);
    } else {
      val.float_value_$value = null;
    }
    if (version >= 2) {
      val.enum_value_$value =
          decoder.decodeStruct(new codec.Enum(RegularEnum));
    } else {
      val.enum_value_$value = null;
    }
    if (version >= 2) {
      val.double_value_$value =
          decoder.decodeStruct(codec.Double);
    } else {
      val.double_value_$value = null;
    }
    return val;
  };

  InterfaceV2_MethodWithVersionedParams_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InterfaceV2_MethodWithVersionedParams_ResponseParams.encodedSize);
    encoder.writeUint32(2);
    packed = 0;
    packed |= (val.bool_value_$flag & 1) << 0
    packed |= (val.bool_value_$value & 1) << 1
    packed |= (val.uint8_value_$flag & 1) << 2
    packed |= (val.int8_value_$flag & 1) << 3
    packed |= (val.uint16_value_$flag & 1) << 4
    packed |= (val.int16_value_$flag & 1) << 5
    packed |= (val.uint32_value_$flag & 1) << 6
    packed |= (val.int32_value_$flag & 1) << 7
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Uint8, val.uint8_value_$value);
    encoder.encodeStruct(codec.Int8, val.int8_value_$value);
    packed = 0;
    packed |= (val.uint64_value_$flag & 1) << 0
    packed |= (val.int64_value_$flag & 1) << 1
    packed |= (val.float_value_$flag & 1) << 2
    packed |= (val.double_value_$flag & 1) << 3
    packed |= (val.enum_value_$flag & 1) << 4
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Uint16, val.uint16_value_$value);
    encoder.encodeStruct(codec.Int16, val.int16_value_$value);
    encoder.encodeStruct(codec.Uint32, val.uint32_value_$value);
    encoder.encodeStruct(codec.Int32, val.int32_value_$value);
    encoder.encodeStruct(codec.Uint64, val.uint64_value_$value);
    encoder.encodeStruct(codec.Int64, val.int64_value_$value);
    encoder.encodeStruct(codec.Float, val.float_value_$value);
    encoder.encodeStruct(codec.Int32, val.enum_value_$value);
    encoder.encodeStruct(codec.Double, val.double_value_$value);
  };
  function InterfaceV2_MethodWithVersionedStruct_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InterfaceV2_MethodWithVersionedStruct_Params.prototype.initDefaults_ = function() {
    this.s = null;
  };
  InterfaceV2_MethodWithVersionedStruct_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InterfaceV2_MethodWithVersionedStruct_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterfaceV2_MethodWithVersionedStruct_Params.s
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, VersionedStructV2, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InterfaceV2_MethodWithVersionedStruct_Params.encodedSize = codec.kStructHeaderSize + 8;

  InterfaceV2_MethodWithVersionedStruct_Params.decode = function(decoder) {
    var packed;
    var val = new InterfaceV2_MethodWithVersionedStruct_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.s =
        decoder.decodeStructPointer(VersionedStructV2);
    return val;
  };

  InterfaceV2_MethodWithVersionedStruct_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InterfaceV2_MethodWithVersionedStruct_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(VersionedStructV2, val.s);
  };
  function InterfaceV2_MethodWithVersionedStruct_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InterfaceV2_MethodWithVersionedStruct_ResponseParams.prototype.initDefaults_ = function() {
    this.s = null;
  };
  InterfaceV2_MethodWithVersionedStruct_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InterfaceV2_MethodWithVersionedStruct_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterfaceV2_MethodWithVersionedStruct_ResponseParams.s
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, VersionedStructV2, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InterfaceV2_MethodWithVersionedStruct_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  InterfaceV2_MethodWithVersionedStruct_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new InterfaceV2_MethodWithVersionedStruct_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.s =
        decoder.decodeStructPointer(VersionedStructV2);
    return val;
  };

  InterfaceV2_MethodWithVersionedStruct_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InterfaceV2_MethodWithVersionedStruct_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(VersionedStructV2, val.s);
  };
  var kParams_SendNullBool_Name = 0;
  var kParams_SendNullUint8_Name = 1;
  var kParams_SendNullInt8_Name = 2;
  var kParams_SendNullUint16_Name = 3;
  var kParams_SendNullInt16_Name = 4;
  var kParams_SendNullUint32_Name = 5;
  var kParams_SendNullInt32_Name = 6;
  var kParams_SendNullUint64_Name = 7;
  var kParams_SendNullInt64_Name = 8;
  var kParams_SendNullFloat_Name = 9;
  var kParams_SendNullDouble_Name = 10;
  var kParams_SendNullEnum_Name = 11;
  var kParams_SendNullBools_Name = 12;
  var kParams_SendNullInt16s_Name = 13;
  var kParams_SendNullUint32s_Name = 14;
  var kParams_SendNullDoubles_Name = 15;
  var kParams_SendNullEnums_Name = 16;
  var kParams_SendNullBoolMap_Name = 17;
  var kParams_SendNullDoubleMap_Name = 18;
  var kParams_SendNullEnumMap_Name = 19;
  var kParams_SendOptionalBool_Name = 20;
  var kParams_SendOptionalUint8_Name = 21;
  var kParams_SendOptionalInt8_Name = 22;
  var kParams_SendOptionalUint16_Name = 23;
  var kParams_SendOptionalInt16_Name = 24;
  var kParams_SendOptionalUint32_Name = 25;
  var kParams_SendOptionalInt32_Name = 26;
  var kParams_SendOptionalUint64_Name = 27;
  var kParams_SendOptionalInt64_Name = 28;
  var kParams_SendOptionalFloat_Name = 29;
  var kParams_SendOptionalDouble_Name = 30;
  var kParams_SendOptionalEnum_Name = 31;
  var kParams_SendOptionalBools_Name = 32;
  var kParams_SendOptionalInt16s_Name = 33;
  var kParams_SendOptionalUint32s_Name = 34;
  var kParams_SendOptionalDoubles_Name = 35;
  var kParams_SendOptionalEnums_Name = 36;
  var kParams_SendOptionalBoolMap_Name = 37;
  var kParams_SendOptionalDoubleMap_Name = 38;
  var kParams_SendOptionalEnumMap_Name = 39;
  var kParams_SendNullStructWithOptionalNumerics_Name = 40;
  var kParams_SendStructWithNullOptionalNumerics_Name = 41;
  var kParams_SendStructWithOptionalNumerics_Name = 42;

  function ParamsPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(Params,
                                                   handleOrPtrInfo);
  }

  function ParamsAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        Params, associatedInterfacePtrInfo);
  }

  ParamsAssociatedPtr.prototype =
      Object.create(ParamsPtr.prototype);
  ParamsAssociatedPtr.prototype.constructor =
      ParamsAssociatedPtr;

  function ParamsProxy(receiver) {
    this.receiver_ = receiver;
  }
  ParamsPtr.prototype.sendNullBool = function() {
    return ParamsProxy.prototype.sendNullBool
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendNullBool = function(optionalBool) {
    var params_ = new Params_SendNullBool_Params();
    params_.optionalBool = optionalBool;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendNullBool_Name,
          codec.align(Params_SendNullBool_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendNullBool_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendNullBool_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendNullUint8 = function() {
    return ParamsProxy.prototype.sendNullUint8
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendNullUint8 = function(optionalUint8) {
    var params_ = new Params_SendNullUint8_Params();
    params_.optionalUint8 = optionalUint8;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendNullUint8_Name,
          codec.align(Params_SendNullUint8_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendNullUint8_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendNullUint8_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendNullInt8 = function() {
    return ParamsProxy.prototype.sendNullInt8
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendNullInt8 = function(optionalInt8) {
    var params_ = new Params_SendNullInt8_Params();
    params_.optionalInt8 = optionalInt8;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendNullInt8_Name,
          codec.align(Params_SendNullInt8_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendNullInt8_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendNullInt8_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendNullUint16 = function() {
    return ParamsProxy.prototype.sendNullUint16
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendNullUint16 = function(optionalUint16) {
    var params_ = new Params_SendNullUint16_Params();
    params_.optionalUint16 = optionalUint16;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendNullUint16_Name,
          codec.align(Params_SendNullUint16_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendNullUint16_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendNullUint16_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendNullInt16 = function() {
    return ParamsProxy.prototype.sendNullInt16
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendNullInt16 = function(optionalInt16) {
    var params_ = new Params_SendNullInt16_Params();
    params_.optionalInt16 = optionalInt16;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendNullInt16_Name,
          codec.align(Params_SendNullInt16_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendNullInt16_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendNullInt16_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendNullUint32 = function() {
    return ParamsProxy.prototype.sendNullUint32
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendNullUint32 = function(optionalUint32) {
    var params_ = new Params_SendNullUint32_Params();
    params_.optionalUint32 = optionalUint32;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendNullUint32_Name,
          codec.align(Params_SendNullUint32_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendNullUint32_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendNullUint32_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendNullInt32 = function() {
    return ParamsProxy.prototype.sendNullInt32
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendNullInt32 = function(optionalInt32) {
    var params_ = new Params_SendNullInt32_Params();
    params_.optionalInt32 = optionalInt32;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendNullInt32_Name,
          codec.align(Params_SendNullInt32_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendNullInt32_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendNullInt32_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendNullUint64 = function() {
    return ParamsProxy.prototype.sendNullUint64
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendNullUint64 = function(optionalUint64) {
    var params_ = new Params_SendNullUint64_Params();
    params_.optionalUint64 = optionalUint64;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendNullUint64_Name,
          codec.align(Params_SendNullUint64_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendNullUint64_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendNullUint64_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendNullInt64 = function() {
    return ParamsProxy.prototype.sendNullInt64
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendNullInt64 = function(optionalInt64) {
    var params_ = new Params_SendNullInt64_Params();
    params_.optionalInt64 = optionalInt64;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendNullInt64_Name,
          codec.align(Params_SendNullInt64_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendNullInt64_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendNullInt64_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendNullFloat = function() {
    return ParamsProxy.prototype.sendNullFloat
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendNullFloat = function(optionalFloat) {
    var params_ = new Params_SendNullFloat_Params();
    params_.optionalFloat = optionalFloat;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendNullFloat_Name,
          codec.align(Params_SendNullFloat_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendNullFloat_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendNullFloat_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendNullDouble = function() {
    return ParamsProxy.prototype.sendNullDouble
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendNullDouble = function(optionalDouble) {
    var params_ = new Params_SendNullDouble_Params();
    params_.optionalDouble = optionalDouble;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendNullDouble_Name,
          codec.align(Params_SendNullDouble_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendNullDouble_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendNullDouble_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendNullEnum = function() {
    return ParamsProxy.prototype.sendNullEnum
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendNullEnum = function(optionalEnum) {
    var params_ = new Params_SendNullEnum_Params();
    params_.optionalEnum = optionalEnum;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendNullEnum_Name,
          codec.align(Params_SendNullEnum_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendNullEnum_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendNullEnum_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendNullBools = function() {
    return ParamsProxy.prototype.sendNullBools
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendNullBools = function(optionalBools) {
    var params_ = new Params_SendNullBools_Params();
    params_.optionalBools = optionalBools;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendNullBools_Name,
          codec.align(Params_SendNullBools_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendNullBools_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendNullBools_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendNullInt16s = function() {
    return ParamsProxy.prototype.sendNullInt16s
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendNullInt16s = function(optionalInt16s) {
    var params_ = new Params_SendNullInt16s_Params();
    params_.optionalInt16s = optionalInt16s;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendNullInt16s_Name,
          codec.align(Params_SendNullInt16s_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendNullInt16s_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendNullInt16s_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendNullUint32s = function() {
    return ParamsProxy.prototype.sendNullUint32s
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendNullUint32s = function(optionalUint32s) {
    var params_ = new Params_SendNullUint32s_Params();
    params_.optionalUint32s = optionalUint32s;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendNullUint32s_Name,
          codec.align(Params_SendNullUint32s_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendNullUint32s_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendNullUint32s_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendNullDoubles = function() {
    return ParamsProxy.prototype.sendNullDoubles
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendNullDoubles = function(optionalDoubles) {
    var params_ = new Params_SendNullDoubles_Params();
    params_.optionalDoubles = optionalDoubles;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendNullDoubles_Name,
          codec.align(Params_SendNullDoubles_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendNullDoubles_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendNullDoubles_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendNullEnums = function() {
    return ParamsProxy.prototype.sendNullEnums
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendNullEnums = function(optionalEnums) {
    var params_ = new Params_SendNullEnums_Params();
    params_.optionalEnums = optionalEnums;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendNullEnums_Name,
          codec.align(Params_SendNullEnums_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendNullEnums_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendNullEnums_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendNullBoolMap = function() {
    return ParamsProxy.prototype.sendNullBoolMap
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendNullBoolMap = function(values) {
    var params_ = new Params_SendNullBoolMap_Params();
    params_.values = values;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendNullBoolMap_Name,
          codec.align(Params_SendNullBoolMap_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendNullBoolMap_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendNullBoolMap_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendNullDoubleMap = function() {
    return ParamsProxy.prototype.sendNullDoubleMap
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendNullDoubleMap = function(values) {
    var params_ = new Params_SendNullDoubleMap_Params();
    params_.values = values;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendNullDoubleMap_Name,
          codec.align(Params_SendNullDoubleMap_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendNullDoubleMap_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendNullDoubleMap_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendNullEnumMap = function() {
    return ParamsProxy.prototype.sendNullEnumMap
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendNullEnumMap = function(values) {
    var params_ = new Params_SendNullEnumMap_Params();
    params_.values = values;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendNullEnumMap_Name,
          codec.align(Params_SendNullEnumMap_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendNullEnumMap_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendNullEnumMap_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendOptionalBool = function() {
    return ParamsProxy.prototype.sendOptionalBool
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendOptionalBool = function(optionalBool) {
    var params_ = new Params_SendOptionalBool_Params();
    params_.optionalBool = optionalBool;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendOptionalBool_Name,
          codec.align(Params_SendOptionalBool_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendOptionalBool_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendOptionalBool_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendOptionalUint8 = function() {
    return ParamsProxy.prototype.sendOptionalUint8
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendOptionalUint8 = function(optionalUint8) {
    var params_ = new Params_SendOptionalUint8_Params();
    params_.optionalUint8 = optionalUint8;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendOptionalUint8_Name,
          codec.align(Params_SendOptionalUint8_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendOptionalUint8_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendOptionalUint8_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendOptionalInt8 = function() {
    return ParamsProxy.prototype.sendOptionalInt8
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendOptionalInt8 = function(optionalInt8) {
    var params_ = new Params_SendOptionalInt8_Params();
    params_.optionalInt8 = optionalInt8;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendOptionalInt8_Name,
          codec.align(Params_SendOptionalInt8_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendOptionalInt8_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendOptionalInt8_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendOptionalUint16 = function() {
    return ParamsProxy.prototype.sendOptionalUint16
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendOptionalUint16 = function(optionalUint16) {
    var params_ = new Params_SendOptionalUint16_Params();
    params_.optionalUint16 = optionalUint16;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendOptionalUint16_Name,
          codec.align(Params_SendOptionalUint16_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendOptionalUint16_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendOptionalUint16_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendOptionalInt16 = function() {
    return ParamsProxy.prototype.sendOptionalInt16
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendOptionalInt16 = function(optionalInt16) {
    var params_ = new Params_SendOptionalInt16_Params();
    params_.optionalInt16 = optionalInt16;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendOptionalInt16_Name,
          codec.align(Params_SendOptionalInt16_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendOptionalInt16_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendOptionalInt16_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendOptionalUint32 = function() {
    return ParamsProxy.prototype.sendOptionalUint32
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendOptionalUint32 = function(optionalUint32) {
    var params_ = new Params_SendOptionalUint32_Params();
    params_.optionalUint32 = optionalUint32;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendOptionalUint32_Name,
          codec.align(Params_SendOptionalUint32_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendOptionalUint32_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendOptionalUint32_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendOptionalInt32 = function() {
    return ParamsProxy.prototype.sendOptionalInt32
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendOptionalInt32 = function(optionalInt32) {
    var params_ = new Params_SendOptionalInt32_Params();
    params_.optionalInt32 = optionalInt32;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendOptionalInt32_Name,
          codec.align(Params_SendOptionalInt32_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendOptionalInt32_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendOptionalInt32_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendOptionalUint64 = function() {
    return ParamsProxy.prototype.sendOptionalUint64
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendOptionalUint64 = function(optionalUint64) {
    var params_ = new Params_SendOptionalUint64_Params();
    params_.optionalUint64 = optionalUint64;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendOptionalUint64_Name,
          codec.align(Params_SendOptionalUint64_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendOptionalUint64_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendOptionalUint64_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendOptionalInt64 = function() {
    return ParamsProxy.prototype.sendOptionalInt64
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendOptionalInt64 = function(optionalInt64) {
    var params_ = new Params_SendOptionalInt64_Params();
    params_.optionalInt64 = optionalInt64;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendOptionalInt64_Name,
          codec.align(Params_SendOptionalInt64_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendOptionalInt64_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendOptionalInt64_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendOptionalFloat = function() {
    return ParamsProxy.prototype.sendOptionalFloat
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendOptionalFloat = function(optionalFloat) {
    var params_ = new Params_SendOptionalFloat_Params();
    params_.optionalFloat = optionalFloat;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendOptionalFloat_Name,
          codec.align(Params_SendOptionalFloat_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendOptionalFloat_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendOptionalFloat_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendOptionalDouble = function() {
    return ParamsProxy.prototype.sendOptionalDouble
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendOptionalDouble = function(optionalDouble) {
    var params_ = new Params_SendOptionalDouble_Params();
    params_.optionalDouble = optionalDouble;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendOptionalDouble_Name,
          codec.align(Params_SendOptionalDouble_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendOptionalDouble_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendOptionalDouble_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendOptionalEnum = function() {
    return ParamsProxy.prototype.sendOptionalEnum
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendOptionalEnum = function(optionalEnum) {
    var params_ = new Params_SendOptionalEnum_Params();
    params_.optionalEnum = optionalEnum;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendOptionalEnum_Name,
          codec.align(Params_SendOptionalEnum_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendOptionalEnum_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendOptionalEnum_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendOptionalBools = function() {
    return ParamsProxy.prototype.sendOptionalBools
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendOptionalBools = function(optionalEnums) {
    var params_ = new Params_SendOptionalBools_Params();
    params_.optionalEnums = optionalEnums;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendOptionalBools_Name,
          codec.align(Params_SendOptionalBools_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendOptionalBools_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendOptionalBools_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendOptionalInt16s = function() {
    return ParamsProxy.prototype.sendOptionalInt16s
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendOptionalInt16s = function(optionalInt16s) {
    var params_ = new Params_SendOptionalInt16s_Params();
    params_.optionalInt16s = optionalInt16s;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendOptionalInt16s_Name,
          codec.align(Params_SendOptionalInt16s_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendOptionalInt16s_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendOptionalInt16s_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendOptionalUint32s = function() {
    return ParamsProxy.prototype.sendOptionalUint32s
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendOptionalUint32s = function(optionalUint32s) {
    var params_ = new Params_SendOptionalUint32s_Params();
    params_.optionalUint32s = optionalUint32s;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendOptionalUint32s_Name,
          codec.align(Params_SendOptionalUint32s_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendOptionalUint32s_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendOptionalUint32s_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendOptionalDoubles = function() {
    return ParamsProxy.prototype.sendOptionalDoubles
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendOptionalDoubles = function(optionalDoubles) {
    var params_ = new Params_SendOptionalDoubles_Params();
    params_.optionalDoubles = optionalDoubles;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendOptionalDoubles_Name,
          codec.align(Params_SendOptionalDoubles_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendOptionalDoubles_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendOptionalDoubles_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendOptionalEnums = function() {
    return ParamsProxy.prototype.sendOptionalEnums
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendOptionalEnums = function(optionalEnums) {
    var params_ = new Params_SendOptionalEnums_Params();
    params_.optionalEnums = optionalEnums;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendOptionalEnums_Name,
          codec.align(Params_SendOptionalEnums_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendOptionalEnums_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendOptionalEnums_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendOptionalBoolMap = function() {
    return ParamsProxy.prototype.sendOptionalBoolMap
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendOptionalBoolMap = function(values) {
    var params_ = new Params_SendOptionalBoolMap_Params();
    params_.values = values;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendOptionalBoolMap_Name,
          codec.align(Params_SendOptionalBoolMap_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendOptionalBoolMap_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendOptionalBoolMap_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendOptionalDoubleMap = function() {
    return ParamsProxy.prototype.sendOptionalDoubleMap
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendOptionalDoubleMap = function(values) {
    var params_ = new Params_SendOptionalDoubleMap_Params();
    params_.values = values;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendOptionalDoubleMap_Name,
          codec.align(Params_SendOptionalDoubleMap_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendOptionalDoubleMap_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendOptionalDoubleMap_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendOptionalEnumMap = function() {
    return ParamsProxy.prototype.sendOptionalEnumMap
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendOptionalEnumMap = function(values) {
    var params_ = new Params_SendOptionalEnumMap_Params();
    params_.values = values;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendOptionalEnumMap_Name,
          codec.align(Params_SendOptionalEnumMap_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendOptionalEnumMap_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendOptionalEnumMap_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendNullStructWithOptionalNumerics = function() {
    return ParamsProxy.prototype.sendNullStructWithOptionalNumerics
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendNullStructWithOptionalNumerics = function(s) {
    var params_ = new Params_SendNullStructWithOptionalNumerics_Params();
    params_.s = s;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendNullStructWithOptionalNumerics_Name,
          codec.align(Params_SendNullStructWithOptionalNumerics_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendNullStructWithOptionalNumerics_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendNullStructWithOptionalNumerics_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendStructWithNullOptionalNumerics = function() {
    return ParamsProxy.prototype.sendStructWithNullOptionalNumerics
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendStructWithNullOptionalNumerics = function(s) {
    var params_ = new Params_SendStructWithNullOptionalNumerics_Params();
    params_.s = s;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendStructWithNullOptionalNumerics_Name,
          codec.align(Params_SendStructWithNullOptionalNumerics_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendStructWithNullOptionalNumerics_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendStructWithNullOptionalNumerics_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ParamsPtr.prototype.sendStructWithOptionalNumerics = function() {
    return ParamsProxy.prototype.sendStructWithOptionalNumerics
        .apply(this.ptr.getProxy(), arguments);
  };

  ParamsProxy.prototype.sendStructWithOptionalNumerics = function(s) {
    var params_ = new Params_SendStructWithOptionalNumerics_Params();
    params_.s = s;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kParams_SendStructWithOptionalNumerics_Name,
          codec.align(Params_SendStructWithOptionalNumerics_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Params_SendStructWithOptionalNumerics_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Params_SendStructWithOptionalNumerics_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function ParamsStub(delegate) {
    this.delegate_ = delegate;
  }
  ParamsStub.prototype.sendNullBool = function(optionalBool) {
    return this.delegate_ && this.delegate_.sendNullBool && this.delegate_.sendNullBool(optionalBool);
  }
  ParamsStub.prototype.sendNullUint8 = function(optionalUint8) {
    return this.delegate_ && this.delegate_.sendNullUint8 && this.delegate_.sendNullUint8(optionalUint8);
  }
  ParamsStub.prototype.sendNullInt8 = function(optionalInt8) {
    return this.delegate_ && this.delegate_.sendNullInt8 && this.delegate_.sendNullInt8(optionalInt8);
  }
  ParamsStub.prototype.sendNullUint16 = function(optionalUint16) {
    return this.delegate_ && this.delegate_.sendNullUint16 && this.delegate_.sendNullUint16(optionalUint16);
  }
  ParamsStub.prototype.sendNullInt16 = function(optionalInt16) {
    return this.delegate_ && this.delegate_.sendNullInt16 && this.delegate_.sendNullInt16(optionalInt16);
  }
  ParamsStub.prototype.sendNullUint32 = function(optionalUint32) {
    return this.delegate_ && this.delegate_.sendNullUint32 && this.delegate_.sendNullUint32(optionalUint32);
  }
  ParamsStub.prototype.sendNullInt32 = function(optionalInt32) {
    return this.delegate_ && this.delegate_.sendNullInt32 && this.delegate_.sendNullInt32(optionalInt32);
  }
  ParamsStub.prototype.sendNullUint64 = function(optionalUint64) {
    return this.delegate_ && this.delegate_.sendNullUint64 && this.delegate_.sendNullUint64(optionalUint64);
  }
  ParamsStub.prototype.sendNullInt64 = function(optionalInt64) {
    return this.delegate_ && this.delegate_.sendNullInt64 && this.delegate_.sendNullInt64(optionalInt64);
  }
  ParamsStub.prototype.sendNullFloat = function(optionalFloat) {
    return this.delegate_ && this.delegate_.sendNullFloat && this.delegate_.sendNullFloat(optionalFloat);
  }
  ParamsStub.prototype.sendNullDouble = function(optionalDouble) {
    return this.delegate_ && this.delegate_.sendNullDouble && this.delegate_.sendNullDouble(optionalDouble);
  }
  ParamsStub.prototype.sendNullEnum = function(optionalEnum) {
    return this.delegate_ && this.delegate_.sendNullEnum && this.delegate_.sendNullEnum(optionalEnum);
  }
  ParamsStub.prototype.sendNullBools = function(optionalBools) {
    return this.delegate_ && this.delegate_.sendNullBools && this.delegate_.sendNullBools(optionalBools);
  }
  ParamsStub.prototype.sendNullInt16s = function(optionalInt16s) {
    return this.delegate_ && this.delegate_.sendNullInt16s && this.delegate_.sendNullInt16s(optionalInt16s);
  }
  ParamsStub.prototype.sendNullUint32s = function(optionalUint32s) {
    return this.delegate_ && this.delegate_.sendNullUint32s && this.delegate_.sendNullUint32s(optionalUint32s);
  }
  ParamsStub.prototype.sendNullDoubles = function(optionalDoubles) {
    return this.delegate_ && this.delegate_.sendNullDoubles && this.delegate_.sendNullDoubles(optionalDoubles);
  }
  ParamsStub.prototype.sendNullEnums = function(optionalEnums) {
    return this.delegate_ && this.delegate_.sendNullEnums && this.delegate_.sendNullEnums(optionalEnums);
  }
  ParamsStub.prototype.sendNullBoolMap = function(values) {
    return this.delegate_ && this.delegate_.sendNullBoolMap && this.delegate_.sendNullBoolMap(values);
  }
  ParamsStub.prototype.sendNullDoubleMap = function(values) {
    return this.delegate_ && this.delegate_.sendNullDoubleMap && this.delegate_.sendNullDoubleMap(values);
  }
  ParamsStub.prototype.sendNullEnumMap = function(values) {
    return this.delegate_ && this.delegate_.sendNullEnumMap && this.delegate_.sendNullEnumMap(values);
  }
  ParamsStub.prototype.sendOptionalBool = function(optionalBool) {
    return this.delegate_ && this.delegate_.sendOptionalBool && this.delegate_.sendOptionalBool(optionalBool);
  }
  ParamsStub.prototype.sendOptionalUint8 = function(optionalUint8) {
    return this.delegate_ && this.delegate_.sendOptionalUint8 && this.delegate_.sendOptionalUint8(optionalUint8);
  }
  ParamsStub.prototype.sendOptionalInt8 = function(optionalInt8) {
    return this.delegate_ && this.delegate_.sendOptionalInt8 && this.delegate_.sendOptionalInt8(optionalInt8);
  }
  ParamsStub.prototype.sendOptionalUint16 = function(optionalUint16) {
    return this.delegate_ && this.delegate_.sendOptionalUint16 && this.delegate_.sendOptionalUint16(optionalUint16);
  }
  ParamsStub.prototype.sendOptionalInt16 = function(optionalInt16) {
    return this.delegate_ && this.delegate_.sendOptionalInt16 && this.delegate_.sendOptionalInt16(optionalInt16);
  }
  ParamsStub.prototype.sendOptionalUint32 = function(optionalUint32) {
    return this.delegate_ && this.delegate_.sendOptionalUint32 && this.delegate_.sendOptionalUint32(optionalUint32);
  }
  ParamsStub.prototype.sendOptionalInt32 = function(optionalInt32) {
    return this.delegate_ && this.delegate_.sendOptionalInt32 && this.delegate_.sendOptionalInt32(optionalInt32);
  }
  ParamsStub.prototype.sendOptionalUint64 = function(optionalUint64) {
    return this.delegate_ && this.delegate_.sendOptionalUint64 && this.delegate_.sendOptionalUint64(optionalUint64);
  }
  ParamsStub.prototype.sendOptionalInt64 = function(optionalInt64) {
    return this.delegate_ && this.delegate_.sendOptionalInt64 && this.delegate_.sendOptionalInt64(optionalInt64);
  }
  ParamsStub.prototype.sendOptionalFloat = function(optionalFloat) {
    return this.delegate_ && this.delegate_.sendOptionalFloat && this.delegate_.sendOptionalFloat(optionalFloat);
  }
  ParamsStub.prototype.sendOptionalDouble = function(optionalDouble) {
    return this.delegate_ && this.delegate_.sendOptionalDouble && this.delegate_.sendOptionalDouble(optionalDouble);
  }
  ParamsStub.prototype.sendOptionalEnum = function(optionalEnum) {
    return this.delegate_ && this.delegate_.sendOptionalEnum && this.delegate_.sendOptionalEnum(optionalEnum);
  }
  ParamsStub.prototype.sendOptionalBools = function(optionalEnums) {
    return this.delegate_ && this.delegate_.sendOptionalBools && this.delegate_.sendOptionalBools(optionalEnums);
  }
  ParamsStub.prototype.sendOptionalInt16s = function(optionalInt16s) {
    return this.delegate_ && this.delegate_.sendOptionalInt16s && this.delegate_.sendOptionalInt16s(optionalInt16s);
  }
  ParamsStub.prototype.sendOptionalUint32s = function(optionalUint32s) {
    return this.delegate_ && this.delegate_.sendOptionalUint32s && this.delegate_.sendOptionalUint32s(optionalUint32s);
  }
  ParamsStub.prototype.sendOptionalDoubles = function(optionalDoubles) {
    return this.delegate_ && this.delegate_.sendOptionalDoubles && this.delegate_.sendOptionalDoubles(optionalDoubles);
  }
  ParamsStub.prototype.sendOptionalEnums = function(optionalEnums) {
    return this.delegate_ && this.delegate_.sendOptionalEnums && this.delegate_.sendOptionalEnums(optionalEnums);
  }
  ParamsStub.prototype.sendOptionalBoolMap = function(values) {
    return this.delegate_ && this.delegate_.sendOptionalBoolMap && this.delegate_.sendOptionalBoolMap(values);
  }
  ParamsStub.prototype.sendOptionalDoubleMap = function(values) {
    return this.delegate_ && this.delegate_.sendOptionalDoubleMap && this.delegate_.sendOptionalDoubleMap(values);
  }
  ParamsStub.prototype.sendOptionalEnumMap = function(values) {
    return this.delegate_ && this.delegate_.sendOptionalEnumMap && this.delegate_.sendOptionalEnumMap(values);
  }
  ParamsStub.prototype.sendNullStructWithOptionalNumerics = function(s) {
    return this.delegate_ && this.delegate_.sendNullStructWithOptionalNumerics && this.delegate_.sendNullStructWithOptionalNumerics(s);
  }
  ParamsStub.prototype.sendStructWithNullOptionalNumerics = function(s) {
    return this.delegate_ && this.delegate_.sendStructWithNullOptionalNumerics && this.delegate_.sendStructWithNullOptionalNumerics(s);
  }
  ParamsStub.prototype.sendStructWithOptionalNumerics = function(s) {
    return this.delegate_ && this.delegate_.sendStructWithOptionalNumerics && this.delegate_.sendStructWithOptionalNumerics(s);
  }

  ParamsStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  ParamsStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kParams_SendNullBool_Name:
      var params = reader.decodeStruct(Params_SendNullBool_Params);
      this.sendNullBool(params.optionalBool).then(function(response) {
        var responseParams =
            new Params_SendNullBool_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kParams_SendNullBool_Name,
            codec.align(Params_SendNullBool_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendNullBool_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendNullUint8_Name:
      var params = reader.decodeStruct(Params_SendNullUint8_Params);
      this.sendNullUint8(params.optionalUint8).then(function(response) {
        var responseParams =
            new Params_SendNullUint8_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kParams_SendNullUint8_Name,
            codec.align(Params_SendNullUint8_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendNullUint8_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendNullInt8_Name:
      var params = reader.decodeStruct(Params_SendNullInt8_Params);
      this.sendNullInt8(params.optionalInt8).then(function(response) {
        var responseParams =
            new Params_SendNullInt8_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kParams_SendNullInt8_Name,
            codec.align(Params_SendNullInt8_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendNullInt8_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendNullUint16_Name:
      var params = reader.decodeStruct(Params_SendNullUint16_Params);
      this.sendNullUint16(params.optionalUint16).then(function(response) {
        var responseParams =
            new Params_SendNullUint16_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kParams_SendNullUint16_Name,
            codec.align(Params_SendNullUint16_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendNullUint16_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendNullInt16_Name:
      var params = reader.decodeStruct(Params_SendNullInt16_Params);
      this.sendNullInt16(params.optionalInt16).then(function(response) {
        var responseParams =
            new Params_SendNullInt16_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kParams_SendNullInt16_Name,
            codec.align(Params_SendNullInt16_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendNullInt16_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendNullUint32_Name:
      var params = reader.decodeStruct(Params_SendNullUint32_Params);
      this.sendNullUint32(params.optionalUint32).then(function(response) {
        var responseParams =
            new Params_SendNullUint32_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kParams_SendNullUint32_Name,
            codec.align(Params_SendNullUint32_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendNullUint32_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendNullInt32_Name:
      var params = reader.decodeStruct(Params_SendNullInt32_Params);
      this.sendNullInt32(params.optionalInt32).then(function(response) {
        var responseParams =
            new Params_SendNullInt32_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kParams_SendNullInt32_Name,
            codec.align(Params_SendNullInt32_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendNullInt32_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendNullUint64_Name:
      var params = reader.decodeStruct(Params_SendNullUint64_Params);
      this.sendNullUint64(params.optionalUint64).then(function(response) {
        var responseParams =
            new Params_SendNullUint64_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kParams_SendNullUint64_Name,
            codec.align(Params_SendNullUint64_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendNullUint64_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendNullInt64_Name:
      var params = reader.decodeStruct(Params_SendNullInt64_Params);
      this.sendNullInt64(params.optionalInt64).then(function(response) {
        var responseParams =
            new Params_SendNullInt64_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kParams_SendNullInt64_Name,
            codec.align(Params_SendNullInt64_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendNullInt64_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendNullFloat_Name:
      var params = reader.decodeStruct(Params_SendNullFloat_Params);
      this.sendNullFloat(params.optionalFloat).then(function(response) {
        var responseParams =
            new Params_SendNullFloat_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kParams_SendNullFloat_Name,
            codec.align(Params_SendNullFloat_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendNullFloat_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendNullDouble_Name:
      var params = reader.decodeStruct(Params_SendNullDouble_Params);
      this.sendNullDouble(params.optionalDouble).then(function(response) {
        var responseParams =
            new Params_SendNullDouble_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kParams_SendNullDouble_Name,
            codec.align(Params_SendNullDouble_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendNullDouble_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendNullEnum_Name:
      var params = reader.decodeStruct(Params_SendNullEnum_Params);
      this.sendNullEnum(params.optionalEnum).then(function(response) {
        var responseParams =
            new Params_SendNullEnum_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kParams_SendNullEnum_Name,
            codec.align(Params_SendNullEnum_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendNullEnum_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendNullBools_Name:
      var params = reader.decodeStruct(Params_SendNullBools_Params);
      this.sendNullBools(params.optionalBools).then(function(response) {
        var responseParams =
            new Params_SendNullBools_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kParams_SendNullBools_Name,
            codec.align(Params_SendNullBools_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendNullBools_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendNullInt16s_Name:
      var params = reader.decodeStruct(Params_SendNullInt16s_Params);
      this.sendNullInt16s(params.optionalInt16s).then(function(response) {
        var responseParams =
            new Params_SendNullInt16s_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kParams_SendNullInt16s_Name,
            codec.align(Params_SendNullInt16s_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendNullInt16s_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendNullUint32s_Name:
      var params = reader.decodeStruct(Params_SendNullUint32s_Params);
      this.sendNullUint32s(params.optionalUint32s).then(function(response) {
        var responseParams =
            new Params_SendNullUint32s_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kParams_SendNullUint32s_Name,
            codec.align(Params_SendNullUint32s_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendNullUint32s_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendNullDoubles_Name:
      var params = reader.decodeStruct(Params_SendNullDoubles_Params);
      this.sendNullDoubles(params.optionalDoubles).then(function(response) {
        var responseParams =
            new Params_SendNullDoubles_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kParams_SendNullDoubles_Name,
            codec.align(Params_SendNullDoubles_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendNullDoubles_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendNullEnums_Name:
      var params = reader.decodeStruct(Params_SendNullEnums_Params);
      this.sendNullEnums(params.optionalEnums).then(function(response) {
        var responseParams =
            new Params_SendNullEnums_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kParams_SendNullEnums_Name,
            codec.align(Params_SendNullEnums_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendNullEnums_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendNullBoolMap_Name:
      var params = reader.decodeStruct(Params_SendNullBoolMap_Params);
      this.sendNullBoolMap(params.values).then(function(response) {
        var responseParams =
            new Params_SendNullBoolMap_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kParams_SendNullBoolMap_Name,
            codec.align(Params_SendNullBoolMap_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendNullBoolMap_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendNullDoubleMap_Name:
      var params = reader.decodeStruct(Params_SendNullDoubleMap_Params);
      this.sendNullDoubleMap(params.values).then(function(response) {
        var responseParams =
            new Params_SendNullDoubleMap_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kParams_SendNullDoubleMap_Name,
            codec.align(Params_SendNullDoubleMap_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendNullDoubleMap_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendNullEnumMap_Name:
      var params = reader.decodeStruct(Params_SendNullEnumMap_Params);
      this.sendNullEnumMap(params.values).then(function(response) {
        var responseParams =
            new Params_SendNullEnumMap_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kParams_SendNullEnumMap_Name,
            codec.align(Params_SendNullEnumMap_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendNullEnumMap_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendOptionalBool_Name:
      var params = reader.decodeStruct(Params_SendOptionalBool_Params);
      this.sendOptionalBool(params.optionalBool).then(function(response) {
        var responseParams =
            new Params_SendOptionalBool_ResponseParams();
        responseParams.value = response.value;
        var builder = new codec.MessageV1Builder(
            kParams_SendOptionalBool_Name,
            codec.align(Params_SendOptionalBool_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendOptionalBool_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendOptionalUint8_Name:
      var params = reader.decodeStruct(Params_SendOptionalUint8_Params);
      this.sendOptionalUint8(params.optionalUint8).then(function(response) {
        var responseParams =
            new Params_SendOptionalUint8_ResponseParams();
        responseParams.value = response.value;
        var builder = new codec.MessageV1Builder(
            kParams_SendOptionalUint8_Name,
            codec.align(Params_SendOptionalUint8_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendOptionalUint8_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendOptionalInt8_Name:
      var params = reader.decodeStruct(Params_SendOptionalInt8_Params);
      this.sendOptionalInt8(params.optionalInt8).then(function(response) {
        var responseParams =
            new Params_SendOptionalInt8_ResponseParams();
        responseParams.value = response.value;
        var builder = new codec.MessageV1Builder(
            kParams_SendOptionalInt8_Name,
            codec.align(Params_SendOptionalInt8_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendOptionalInt8_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendOptionalUint16_Name:
      var params = reader.decodeStruct(Params_SendOptionalUint16_Params);
      this.sendOptionalUint16(params.optionalUint16).then(function(response) {
        var responseParams =
            new Params_SendOptionalUint16_ResponseParams();
        responseParams.value = response.value;
        var builder = new codec.MessageV1Builder(
            kParams_SendOptionalUint16_Name,
            codec.align(Params_SendOptionalUint16_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendOptionalUint16_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendOptionalInt16_Name:
      var params = reader.decodeStruct(Params_SendOptionalInt16_Params);
      this.sendOptionalInt16(params.optionalInt16).then(function(response) {
        var responseParams =
            new Params_SendOptionalInt16_ResponseParams();
        responseParams.value = response.value;
        var builder = new codec.MessageV1Builder(
            kParams_SendOptionalInt16_Name,
            codec.align(Params_SendOptionalInt16_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendOptionalInt16_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendOptionalUint32_Name:
      var params = reader.decodeStruct(Params_SendOptionalUint32_Params);
      this.sendOptionalUint32(params.optionalUint32).then(function(response) {
        var responseParams =
            new Params_SendOptionalUint32_ResponseParams();
        responseParams.value = response.value;
        var builder = new codec.MessageV1Builder(
            kParams_SendOptionalUint32_Name,
            codec.align(Params_SendOptionalUint32_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendOptionalUint32_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendOptionalInt32_Name:
      var params = reader.decodeStruct(Params_SendOptionalInt32_Params);
      this.sendOptionalInt32(params.optionalInt32).then(function(response) {
        var responseParams =
            new Params_SendOptionalInt32_ResponseParams();
        responseParams.value = response.value;
        var builder = new codec.MessageV1Builder(
            kParams_SendOptionalInt32_Name,
            codec.align(Params_SendOptionalInt32_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendOptionalInt32_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendOptionalUint64_Name:
      var params = reader.decodeStruct(Params_SendOptionalUint64_Params);
      this.sendOptionalUint64(params.optionalUint64).then(function(response) {
        var responseParams =
            new Params_SendOptionalUint64_ResponseParams();
        responseParams.value = response.value;
        var builder = new codec.MessageV1Builder(
            kParams_SendOptionalUint64_Name,
            codec.align(Params_SendOptionalUint64_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendOptionalUint64_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendOptionalInt64_Name:
      var params = reader.decodeStruct(Params_SendOptionalInt64_Params);
      this.sendOptionalInt64(params.optionalInt64).then(function(response) {
        var responseParams =
            new Params_SendOptionalInt64_ResponseParams();
        responseParams.value = response.value;
        var builder = new codec.MessageV1Builder(
            kParams_SendOptionalInt64_Name,
            codec.align(Params_SendOptionalInt64_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendOptionalInt64_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendOptionalFloat_Name:
      var params = reader.decodeStruct(Params_SendOptionalFloat_Params);
      this.sendOptionalFloat(params.optionalFloat).then(function(response) {
        var responseParams =
            new Params_SendOptionalFloat_ResponseParams();
        responseParams.value = response.value;
        var builder = new codec.MessageV1Builder(
            kParams_SendOptionalFloat_Name,
            codec.align(Params_SendOptionalFloat_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendOptionalFloat_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendOptionalDouble_Name:
      var params = reader.decodeStruct(Params_SendOptionalDouble_Params);
      this.sendOptionalDouble(params.optionalDouble).then(function(response) {
        var responseParams =
            new Params_SendOptionalDouble_ResponseParams();
        responseParams.value = response.value;
        var builder = new codec.MessageV1Builder(
            kParams_SendOptionalDouble_Name,
            codec.align(Params_SendOptionalDouble_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendOptionalDouble_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendOptionalEnum_Name:
      var params = reader.decodeStruct(Params_SendOptionalEnum_Params);
      this.sendOptionalEnum(params.optionalEnum).then(function(response) {
        var responseParams =
            new Params_SendOptionalEnum_ResponseParams();
        responseParams.value = response.value;
        var builder = new codec.MessageV1Builder(
            kParams_SendOptionalEnum_Name,
            codec.align(Params_SendOptionalEnum_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendOptionalEnum_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendOptionalBools_Name:
      var params = reader.decodeStruct(Params_SendOptionalBools_Params);
      this.sendOptionalBools(params.optionalEnums).then(function(response) {
        var responseParams =
            new Params_SendOptionalBools_ResponseParams();
        responseParams.values = response.values;
        var builder = new codec.MessageV1Builder(
            kParams_SendOptionalBools_Name,
            codec.align(Params_SendOptionalBools_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendOptionalBools_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendOptionalInt16s_Name:
      var params = reader.decodeStruct(Params_SendOptionalInt16s_Params);
      this.sendOptionalInt16s(params.optionalInt16s).then(function(response) {
        var responseParams =
            new Params_SendOptionalInt16s_ResponseParams();
        responseParams.values = response.values;
        var builder = new codec.MessageV1Builder(
            kParams_SendOptionalInt16s_Name,
            codec.align(Params_SendOptionalInt16s_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendOptionalInt16s_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendOptionalUint32s_Name:
      var params = reader.decodeStruct(Params_SendOptionalUint32s_Params);
      this.sendOptionalUint32s(params.optionalUint32s).then(function(response) {
        var responseParams =
            new Params_SendOptionalUint32s_ResponseParams();
        responseParams.values = response.values;
        var builder = new codec.MessageV1Builder(
            kParams_SendOptionalUint32s_Name,
            codec.align(Params_SendOptionalUint32s_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendOptionalUint32s_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendOptionalDoubles_Name:
      var params = reader.decodeStruct(Params_SendOptionalDoubles_Params);
      this.sendOptionalDoubles(params.optionalDoubles).then(function(response) {
        var responseParams =
            new Params_SendOptionalDoubles_ResponseParams();
        responseParams.values = response.values;
        var builder = new codec.MessageV1Builder(
            kParams_SendOptionalDoubles_Name,
            codec.align(Params_SendOptionalDoubles_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendOptionalDoubles_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendOptionalEnums_Name:
      var params = reader.decodeStruct(Params_SendOptionalEnums_Params);
      this.sendOptionalEnums(params.optionalEnums).then(function(response) {
        var responseParams =
            new Params_SendOptionalEnums_ResponseParams();
        responseParams.values = response.values;
        var builder = new codec.MessageV1Builder(
            kParams_SendOptionalEnums_Name,
            codec.align(Params_SendOptionalEnums_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendOptionalEnums_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendOptionalBoolMap_Name:
      var params = reader.decodeStruct(Params_SendOptionalBoolMap_Params);
      this.sendOptionalBoolMap(params.values).then(function(response) {
        var responseParams =
            new Params_SendOptionalBoolMap_ResponseParams();
        responseParams.values = response.values;
        var builder = new codec.MessageV1Builder(
            kParams_SendOptionalBoolMap_Name,
            codec.align(Params_SendOptionalBoolMap_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendOptionalBoolMap_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendOptionalDoubleMap_Name:
      var params = reader.decodeStruct(Params_SendOptionalDoubleMap_Params);
      this.sendOptionalDoubleMap(params.values).then(function(response) {
        var responseParams =
            new Params_SendOptionalDoubleMap_ResponseParams();
        responseParams.values = response.values;
        var builder = new codec.MessageV1Builder(
            kParams_SendOptionalDoubleMap_Name,
            codec.align(Params_SendOptionalDoubleMap_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendOptionalDoubleMap_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendOptionalEnumMap_Name:
      var params = reader.decodeStruct(Params_SendOptionalEnumMap_Params);
      this.sendOptionalEnumMap(params.values).then(function(response) {
        var responseParams =
            new Params_SendOptionalEnumMap_ResponseParams();
        responseParams.values = response.values;
        var builder = new codec.MessageV1Builder(
            kParams_SendOptionalEnumMap_Name,
            codec.align(Params_SendOptionalEnumMap_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendOptionalEnumMap_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendNullStructWithOptionalNumerics_Name:
      var params = reader.decodeStruct(Params_SendNullStructWithOptionalNumerics_Params);
      this.sendNullStructWithOptionalNumerics(params.s).then(function(response) {
        var responseParams =
            new Params_SendNullStructWithOptionalNumerics_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kParams_SendNullStructWithOptionalNumerics_Name,
            codec.align(Params_SendNullStructWithOptionalNumerics_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendNullStructWithOptionalNumerics_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendStructWithNullOptionalNumerics_Name:
      var params = reader.decodeStruct(Params_SendStructWithNullOptionalNumerics_Params);
      this.sendStructWithNullOptionalNumerics(params.s).then(function(response) {
        var responseParams =
            new Params_SendStructWithNullOptionalNumerics_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kParams_SendStructWithNullOptionalNumerics_Name,
            codec.align(Params_SendStructWithNullOptionalNumerics_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendStructWithNullOptionalNumerics_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kParams_SendStructWithOptionalNumerics_Name:
      var params = reader.decodeStruct(Params_SendStructWithOptionalNumerics_Params);
      this.sendStructWithOptionalNumerics(params.s).then(function(response) {
        var responseParams =
            new Params_SendStructWithOptionalNumerics_ResponseParams();
        responseParams.boolValue = response.boolValue;
        responseParams.uint8Value = response.uint8Value;
        responseParams.int8Value = response.int8Value;
        responseParams.uint16Value = response.uint16Value;
        responseParams.int16Value = response.int16Value;
        responseParams.uint32Value = response.uint32Value;
        responseParams.int32Value = response.int32Value;
        responseParams.uint64Value = response.uint64Value;
        responseParams.int64Value = response.int64Value;
        responseParams.floatValue = response.floatValue;
        responseParams.doubleValue = response.doubleValue;
        responseParams.enumValue = response.enumValue;
        var builder = new codec.MessageV1Builder(
            kParams_SendStructWithOptionalNumerics_Name,
            codec.align(Params_SendStructWithOptionalNumerics_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Params_SendStructWithOptionalNumerics_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateParamsRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kParams_SendNullBool_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendNullBool_Params;
      break;
      case kParams_SendNullUint8_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendNullUint8_Params;
      break;
      case kParams_SendNullInt8_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendNullInt8_Params;
      break;
      case kParams_SendNullUint16_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendNullUint16_Params;
      break;
      case kParams_SendNullInt16_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendNullInt16_Params;
      break;
      case kParams_SendNullUint32_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendNullUint32_Params;
      break;
      case kParams_SendNullInt32_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendNullInt32_Params;
      break;
      case kParams_SendNullUint64_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendNullUint64_Params;
      break;
      case kParams_SendNullInt64_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendNullInt64_Params;
      break;
      case kParams_SendNullFloat_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendNullFloat_Params;
      break;
      case kParams_SendNullDouble_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendNullDouble_Params;
      break;
      case kParams_SendNullEnum_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendNullEnum_Params;
      break;
      case kParams_SendNullBools_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendNullBools_Params;
      break;
      case kParams_SendNullInt16s_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendNullInt16s_Params;
      break;
      case kParams_SendNullUint32s_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendNullUint32s_Params;
      break;
      case kParams_SendNullDoubles_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendNullDoubles_Params;
      break;
      case kParams_SendNullEnums_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendNullEnums_Params;
      break;
      case kParams_SendNullBoolMap_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendNullBoolMap_Params;
      break;
      case kParams_SendNullDoubleMap_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendNullDoubleMap_Params;
      break;
      case kParams_SendNullEnumMap_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendNullEnumMap_Params;
      break;
      case kParams_SendOptionalBool_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendOptionalBool_Params;
      break;
      case kParams_SendOptionalUint8_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendOptionalUint8_Params;
      break;
      case kParams_SendOptionalInt8_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendOptionalInt8_Params;
      break;
      case kParams_SendOptionalUint16_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendOptionalUint16_Params;
      break;
      case kParams_SendOptionalInt16_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendOptionalInt16_Params;
      break;
      case kParams_SendOptionalUint32_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendOptionalUint32_Params;
      break;
      case kParams_SendOptionalInt32_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendOptionalInt32_Params;
      break;
      case kParams_SendOptionalUint64_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendOptionalUint64_Params;
      break;
      case kParams_SendOptionalInt64_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendOptionalInt64_Params;
      break;
      case kParams_SendOptionalFloat_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendOptionalFloat_Params;
      break;
      case kParams_SendOptionalDouble_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendOptionalDouble_Params;
      break;
      case kParams_SendOptionalEnum_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendOptionalEnum_Params;
      break;
      case kParams_SendOptionalBools_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendOptionalBools_Params;
      break;
      case kParams_SendOptionalInt16s_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendOptionalInt16s_Params;
      break;
      case kParams_SendOptionalUint32s_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendOptionalUint32s_Params;
      break;
      case kParams_SendOptionalDoubles_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendOptionalDoubles_Params;
      break;
      case kParams_SendOptionalEnums_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendOptionalEnums_Params;
      break;
      case kParams_SendOptionalBoolMap_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendOptionalBoolMap_Params;
      break;
      case kParams_SendOptionalDoubleMap_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendOptionalDoubleMap_Params;
      break;
      case kParams_SendOptionalEnumMap_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendOptionalEnumMap_Params;
      break;
      case kParams_SendNullStructWithOptionalNumerics_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendNullStructWithOptionalNumerics_Params;
      break;
      case kParams_SendStructWithNullOptionalNumerics_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendStructWithNullOptionalNumerics_Params;
      break;
      case kParams_SendStructWithOptionalNumerics_Name:
        if (message.expectsResponse())
          paramsClass = Params_SendStructWithOptionalNumerics_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateParamsResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kParams_SendNullBool_Name:
        if (message.isResponse())
          paramsClass = Params_SendNullBool_ResponseParams;
        break;
      case kParams_SendNullUint8_Name:
        if (message.isResponse())
          paramsClass = Params_SendNullUint8_ResponseParams;
        break;
      case kParams_SendNullInt8_Name:
        if (message.isResponse())
          paramsClass = Params_SendNullInt8_ResponseParams;
        break;
      case kParams_SendNullUint16_Name:
        if (message.isResponse())
          paramsClass = Params_SendNullUint16_ResponseParams;
        break;
      case kParams_SendNullInt16_Name:
        if (message.isResponse())
          paramsClass = Params_SendNullInt16_ResponseParams;
        break;
      case kParams_SendNullUint32_Name:
        if (message.isResponse())
          paramsClass = Params_SendNullUint32_ResponseParams;
        break;
      case kParams_SendNullInt32_Name:
        if (message.isResponse())
          paramsClass = Params_SendNullInt32_ResponseParams;
        break;
      case kParams_SendNullUint64_Name:
        if (message.isResponse())
          paramsClass = Params_SendNullUint64_ResponseParams;
        break;
      case kParams_SendNullInt64_Name:
        if (message.isResponse())
          paramsClass = Params_SendNullInt64_ResponseParams;
        break;
      case kParams_SendNullFloat_Name:
        if (message.isResponse())
          paramsClass = Params_SendNullFloat_ResponseParams;
        break;
      case kParams_SendNullDouble_Name:
        if (message.isResponse())
          paramsClass = Params_SendNullDouble_ResponseParams;
        break;
      case kParams_SendNullEnum_Name:
        if (message.isResponse())
          paramsClass = Params_SendNullEnum_ResponseParams;
        break;
      case kParams_SendNullBools_Name:
        if (message.isResponse())
          paramsClass = Params_SendNullBools_ResponseParams;
        break;
      case kParams_SendNullInt16s_Name:
        if (message.isResponse())
          paramsClass = Params_SendNullInt16s_ResponseParams;
        break;
      case kParams_SendNullUint32s_Name:
        if (message.isResponse())
          paramsClass = Params_SendNullUint32s_ResponseParams;
        break;
      case kParams_SendNullDoubles_Name:
        if (message.isResponse())
          paramsClass = Params_SendNullDoubles_ResponseParams;
        break;
      case kParams_SendNullEnums_Name:
        if (message.isResponse())
          paramsClass = Params_SendNullEnums_ResponseParams;
        break;
      case kParams_SendNullBoolMap_Name:
        if (message.isResponse())
          paramsClass = Params_SendNullBoolMap_ResponseParams;
        break;
      case kParams_SendNullDoubleMap_Name:
        if (message.isResponse())
          paramsClass = Params_SendNullDoubleMap_ResponseParams;
        break;
      case kParams_SendNullEnumMap_Name:
        if (message.isResponse())
          paramsClass = Params_SendNullEnumMap_ResponseParams;
        break;
      case kParams_SendOptionalBool_Name:
        if (message.isResponse())
          paramsClass = Params_SendOptionalBool_ResponseParams;
        break;
      case kParams_SendOptionalUint8_Name:
        if (message.isResponse())
          paramsClass = Params_SendOptionalUint8_ResponseParams;
        break;
      case kParams_SendOptionalInt8_Name:
        if (message.isResponse())
          paramsClass = Params_SendOptionalInt8_ResponseParams;
        break;
      case kParams_SendOptionalUint16_Name:
        if (message.isResponse())
          paramsClass = Params_SendOptionalUint16_ResponseParams;
        break;
      case kParams_SendOptionalInt16_Name:
        if (message.isResponse())
          paramsClass = Params_SendOptionalInt16_ResponseParams;
        break;
      case kParams_SendOptionalUint32_Name:
        if (message.isResponse())
          paramsClass = Params_SendOptionalUint32_ResponseParams;
        break;
      case kParams_SendOptionalInt32_Name:
        if (message.isResponse())
          paramsClass = Params_SendOptionalInt32_ResponseParams;
        break;
      case kParams_SendOptionalUint64_Name:
        if (message.isResponse())
          paramsClass = Params_SendOptionalUint64_ResponseParams;
        break;
      case kParams_SendOptionalInt64_Name:
        if (message.isResponse())
          paramsClass = Params_SendOptionalInt64_ResponseParams;
        break;
      case kParams_SendOptionalFloat_Name:
        if (message.isResponse())
          paramsClass = Params_SendOptionalFloat_ResponseParams;
        break;
      case kParams_SendOptionalDouble_Name:
        if (message.isResponse())
          paramsClass = Params_SendOptionalDouble_ResponseParams;
        break;
      case kParams_SendOptionalEnum_Name:
        if (message.isResponse())
          paramsClass = Params_SendOptionalEnum_ResponseParams;
        break;
      case kParams_SendOptionalBools_Name:
        if (message.isResponse())
          paramsClass = Params_SendOptionalBools_ResponseParams;
        break;
      case kParams_SendOptionalInt16s_Name:
        if (message.isResponse())
          paramsClass = Params_SendOptionalInt16s_ResponseParams;
        break;
      case kParams_SendOptionalUint32s_Name:
        if (message.isResponse())
          paramsClass = Params_SendOptionalUint32s_ResponseParams;
        break;
      case kParams_SendOptionalDoubles_Name:
        if (message.isResponse())
          paramsClass = Params_SendOptionalDoubles_ResponseParams;
        break;
      case kParams_SendOptionalEnums_Name:
        if (message.isResponse())
          paramsClass = Params_SendOptionalEnums_ResponseParams;
        break;
      case kParams_SendOptionalBoolMap_Name:
        if (message.isResponse())
          paramsClass = Params_SendOptionalBoolMap_ResponseParams;
        break;
      case kParams_SendOptionalDoubleMap_Name:
        if (message.isResponse())
          paramsClass = Params_SendOptionalDoubleMap_ResponseParams;
        break;
      case kParams_SendOptionalEnumMap_Name:
        if (message.isResponse())
          paramsClass = Params_SendOptionalEnumMap_ResponseParams;
        break;
      case kParams_SendNullStructWithOptionalNumerics_Name:
        if (message.isResponse())
          paramsClass = Params_SendNullStructWithOptionalNumerics_ResponseParams;
        break;
      case kParams_SendStructWithNullOptionalNumerics_Name:
        if (message.isResponse())
          paramsClass = Params_SendStructWithNullOptionalNumerics_ResponseParams;
        break;
      case kParams_SendStructWithOptionalNumerics_Name:
        if (message.isResponse())
          paramsClass = Params_SendStructWithOptionalNumerics_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var Params = {
    name: 'content.optional_numerics_unittest.mojom.Params',
    kVersion: 0,
    ptrClass: ParamsPtr,
    proxyClass: ParamsProxy,
    stubClass: ParamsStub,
    validateRequest: validateParamsRequest,
    validateResponse: validateParamsResponse,
  };
  ParamsStub.prototype.validator = validateParamsRequest;
  ParamsProxy.prototype.validator = validateParamsResponse;
  var kResponseParams_GetNullBool_Name = 0;
  var kResponseParams_GetNullUint8_Name = 1;
  var kResponseParams_GetNullInt8_Name = 2;
  var kResponseParams_GetNullUint16_Name = 3;
  var kResponseParams_GetNullInt16_Name = 4;
  var kResponseParams_GetNullUint32_Name = 5;
  var kResponseParams_GetNullInt32_Name = 6;
  var kResponseParams_GetNullUint64_Name = 7;
  var kResponseParams_GetNullInt64_Name = 8;
  var kResponseParams_GetNullFloat_Name = 9;
  var kResponseParams_GetNullDouble_Name = 10;
  var kResponseParams_GetNullEnum_Name = 11;
  var kResponseParams_GetNullBools_Name = 12;
  var kResponseParams_GetNullInt16s_Name = 13;
  var kResponseParams_GetNullUint32s_Name = 14;
  var kResponseParams_GetNullDoubles_Name = 15;
  var kResponseParams_GetNullEnums_Name = 16;
  var kResponseParams_GetNullBoolMap_Name = 17;
  var kResponseParams_GetNullInt32Map_Name = 18;
  var kResponseParams_GetNullEnumMap_Name = 19;
  var kResponseParams_GetOptionalBool_Name = 20;
  var kResponseParams_GetOptionalUint8_Name = 21;
  var kResponseParams_GetOptionalInt8_Name = 22;
  var kResponseParams_GetOptionalUint16_Name = 23;
  var kResponseParams_GetOptionalInt16_Name = 24;
  var kResponseParams_GetOptionalUint32_Name = 25;
  var kResponseParams_GetOptionalInt32_Name = 26;
  var kResponseParams_GetOptionalUint64_Name = 27;
  var kResponseParams_GetOptionalInt64_Name = 28;
  var kResponseParams_GetOptionalFloat_Name = 29;
  var kResponseParams_GetOptionalDouble_Name = 30;
  var kResponseParams_GetOptionalEnum_Name = 31;
  var kResponseParams_GetOptionalBools_Name = 32;
  var kResponseParams_GetOptionalInt16s_Name = 33;
  var kResponseParams_GetOptionalUint32s_Name = 34;
  var kResponseParams_GetOptionalDoubles_Name = 35;
  var kResponseParams_GetOptionalEnums_Name = 36;
  var kResponseParams_GetOptionalBoolMap_Name = 37;
  var kResponseParams_GetOptionalFloatMap_Name = 38;
  var kResponseParams_GetOptionalEnumMap_Name = 39;
  var kResponseParams_GetNullStructWithOptionalNumerics_Name = 40;
  var kResponseParams_GetStructWithNullOptionalNumerics_Name = 41;
  var kResponseParams_GetStructWithOptionalNumerics_Name = 42;

  function ResponseParamsPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ResponseParams,
                                                   handleOrPtrInfo);
  }

  function ResponseParamsAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ResponseParams, associatedInterfacePtrInfo);
  }

  ResponseParamsAssociatedPtr.prototype =
      Object.create(ResponseParamsPtr.prototype);
  ResponseParamsAssociatedPtr.prototype.constructor =
      ResponseParamsAssociatedPtr;

  function ResponseParamsProxy(receiver) {
    this.receiver_ = receiver;
  }
  ResponseParamsPtr.prototype.getNullBool = function() {
    return ResponseParamsProxy.prototype.getNullBool
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getNullBool = function() {
    var params_ = new ResponseParams_GetNullBool_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetNullBool_Name,
          codec.align(ResponseParams_GetNullBool_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetNullBool_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetNullBool_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getNullUint8 = function() {
    return ResponseParamsProxy.prototype.getNullUint8
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getNullUint8 = function() {
    var params_ = new ResponseParams_GetNullUint8_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetNullUint8_Name,
          codec.align(ResponseParams_GetNullUint8_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetNullUint8_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetNullUint8_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getNullInt8 = function() {
    return ResponseParamsProxy.prototype.getNullInt8
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getNullInt8 = function() {
    var params_ = new ResponseParams_GetNullInt8_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetNullInt8_Name,
          codec.align(ResponseParams_GetNullInt8_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetNullInt8_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetNullInt8_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getNullUint16 = function() {
    return ResponseParamsProxy.prototype.getNullUint16
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getNullUint16 = function() {
    var params_ = new ResponseParams_GetNullUint16_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetNullUint16_Name,
          codec.align(ResponseParams_GetNullUint16_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetNullUint16_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetNullUint16_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getNullInt16 = function() {
    return ResponseParamsProxy.prototype.getNullInt16
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getNullInt16 = function() {
    var params_ = new ResponseParams_GetNullInt16_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetNullInt16_Name,
          codec.align(ResponseParams_GetNullInt16_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetNullInt16_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetNullInt16_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getNullUint32 = function() {
    return ResponseParamsProxy.prototype.getNullUint32
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getNullUint32 = function() {
    var params_ = new ResponseParams_GetNullUint32_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetNullUint32_Name,
          codec.align(ResponseParams_GetNullUint32_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetNullUint32_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetNullUint32_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getNullInt32 = function() {
    return ResponseParamsProxy.prototype.getNullInt32
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getNullInt32 = function() {
    var params_ = new ResponseParams_GetNullInt32_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetNullInt32_Name,
          codec.align(ResponseParams_GetNullInt32_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetNullInt32_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetNullInt32_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getNullUint64 = function() {
    return ResponseParamsProxy.prototype.getNullUint64
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getNullUint64 = function() {
    var params_ = new ResponseParams_GetNullUint64_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetNullUint64_Name,
          codec.align(ResponseParams_GetNullUint64_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetNullUint64_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetNullUint64_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getNullInt64 = function() {
    return ResponseParamsProxy.prototype.getNullInt64
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getNullInt64 = function() {
    var params_ = new ResponseParams_GetNullInt64_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetNullInt64_Name,
          codec.align(ResponseParams_GetNullInt64_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetNullInt64_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetNullInt64_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getNullFloat = function() {
    return ResponseParamsProxy.prototype.getNullFloat
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getNullFloat = function() {
    var params_ = new ResponseParams_GetNullFloat_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetNullFloat_Name,
          codec.align(ResponseParams_GetNullFloat_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetNullFloat_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetNullFloat_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getNullDouble = function() {
    return ResponseParamsProxy.prototype.getNullDouble
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getNullDouble = function() {
    var params_ = new ResponseParams_GetNullDouble_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetNullDouble_Name,
          codec.align(ResponseParams_GetNullDouble_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetNullDouble_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetNullDouble_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getNullEnum = function() {
    return ResponseParamsProxy.prototype.getNullEnum
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getNullEnum = function() {
    var params_ = new ResponseParams_GetNullEnum_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetNullEnum_Name,
          codec.align(ResponseParams_GetNullEnum_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetNullEnum_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetNullEnum_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getNullBools = function() {
    return ResponseParamsProxy.prototype.getNullBools
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getNullBools = function() {
    var params_ = new ResponseParams_GetNullBools_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetNullBools_Name,
          codec.align(ResponseParams_GetNullBools_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetNullBools_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetNullBools_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getNullInt16s = function() {
    return ResponseParamsProxy.prototype.getNullInt16s
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getNullInt16s = function() {
    var params_ = new ResponseParams_GetNullInt16s_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetNullInt16s_Name,
          codec.align(ResponseParams_GetNullInt16s_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetNullInt16s_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetNullInt16s_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getNullUint32s = function() {
    return ResponseParamsProxy.prototype.getNullUint32s
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getNullUint32s = function() {
    var params_ = new ResponseParams_GetNullUint32s_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetNullUint32s_Name,
          codec.align(ResponseParams_GetNullUint32s_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetNullUint32s_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetNullUint32s_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getNullDoubles = function() {
    return ResponseParamsProxy.prototype.getNullDoubles
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getNullDoubles = function() {
    var params_ = new ResponseParams_GetNullDoubles_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetNullDoubles_Name,
          codec.align(ResponseParams_GetNullDoubles_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetNullDoubles_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetNullDoubles_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getNullEnums = function() {
    return ResponseParamsProxy.prototype.getNullEnums
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getNullEnums = function() {
    var params_ = new ResponseParams_GetNullEnums_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetNullEnums_Name,
          codec.align(ResponseParams_GetNullEnums_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetNullEnums_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetNullEnums_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getNullBoolMap = function() {
    return ResponseParamsProxy.prototype.getNullBoolMap
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getNullBoolMap = function() {
    var params_ = new ResponseParams_GetNullBoolMap_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetNullBoolMap_Name,
          codec.align(ResponseParams_GetNullBoolMap_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetNullBoolMap_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetNullBoolMap_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getNullInt32Map = function() {
    return ResponseParamsProxy.prototype.getNullInt32Map
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getNullInt32Map = function() {
    var params_ = new ResponseParams_GetNullInt32Map_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetNullInt32Map_Name,
          codec.align(ResponseParams_GetNullInt32Map_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetNullInt32Map_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetNullInt32Map_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getNullEnumMap = function() {
    return ResponseParamsProxy.prototype.getNullEnumMap
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getNullEnumMap = function() {
    var params_ = new ResponseParams_GetNullEnumMap_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetNullEnumMap_Name,
          codec.align(ResponseParams_GetNullEnumMap_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetNullEnumMap_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetNullEnumMap_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getOptionalBool = function() {
    return ResponseParamsProxy.prototype.getOptionalBool
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getOptionalBool = function(value) {
    var params_ = new ResponseParams_GetOptionalBool_Params();
    params_.value = value;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetOptionalBool_Name,
          codec.align(ResponseParams_GetOptionalBool_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetOptionalBool_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetOptionalBool_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getOptionalUint8 = function() {
    return ResponseParamsProxy.prototype.getOptionalUint8
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getOptionalUint8 = function(value) {
    var params_ = new ResponseParams_GetOptionalUint8_Params();
    params_.value = value;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetOptionalUint8_Name,
          codec.align(ResponseParams_GetOptionalUint8_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetOptionalUint8_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetOptionalUint8_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getOptionalInt8 = function() {
    return ResponseParamsProxy.prototype.getOptionalInt8
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getOptionalInt8 = function(value) {
    var params_ = new ResponseParams_GetOptionalInt8_Params();
    params_.value = value;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetOptionalInt8_Name,
          codec.align(ResponseParams_GetOptionalInt8_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetOptionalInt8_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetOptionalInt8_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getOptionalUint16 = function() {
    return ResponseParamsProxy.prototype.getOptionalUint16
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getOptionalUint16 = function(value) {
    var params_ = new ResponseParams_GetOptionalUint16_Params();
    params_.value = value;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetOptionalUint16_Name,
          codec.align(ResponseParams_GetOptionalUint16_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetOptionalUint16_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetOptionalUint16_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getOptionalInt16 = function() {
    return ResponseParamsProxy.prototype.getOptionalInt16
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getOptionalInt16 = function(value) {
    var params_ = new ResponseParams_GetOptionalInt16_Params();
    params_.value = value;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetOptionalInt16_Name,
          codec.align(ResponseParams_GetOptionalInt16_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetOptionalInt16_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetOptionalInt16_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getOptionalUint32 = function() {
    return ResponseParamsProxy.prototype.getOptionalUint32
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getOptionalUint32 = function(value) {
    var params_ = new ResponseParams_GetOptionalUint32_Params();
    params_.value = value;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetOptionalUint32_Name,
          codec.align(ResponseParams_GetOptionalUint32_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetOptionalUint32_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetOptionalUint32_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getOptionalInt32 = function() {
    return ResponseParamsProxy.prototype.getOptionalInt32
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getOptionalInt32 = function(value) {
    var params_ = new ResponseParams_GetOptionalInt32_Params();
    params_.value = value;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetOptionalInt32_Name,
          codec.align(ResponseParams_GetOptionalInt32_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetOptionalInt32_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetOptionalInt32_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getOptionalUint64 = function() {
    return ResponseParamsProxy.prototype.getOptionalUint64
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getOptionalUint64 = function(value) {
    var params_ = new ResponseParams_GetOptionalUint64_Params();
    params_.value = value;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetOptionalUint64_Name,
          codec.align(ResponseParams_GetOptionalUint64_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetOptionalUint64_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetOptionalUint64_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getOptionalInt64 = function() {
    return ResponseParamsProxy.prototype.getOptionalInt64
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getOptionalInt64 = function(value) {
    var params_ = new ResponseParams_GetOptionalInt64_Params();
    params_.value = value;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetOptionalInt64_Name,
          codec.align(ResponseParams_GetOptionalInt64_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetOptionalInt64_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetOptionalInt64_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getOptionalFloat = function() {
    return ResponseParamsProxy.prototype.getOptionalFloat
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getOptionalFloat = function(value) {
    var params_ = new ResponseParams_GetOptionalFloat_Params();
    params_.value = value;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetOptionalFloat_Name,
          codec.align(ResponseParams_GetOptionalFloat_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetOptionalFloat_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetOptionalFloat_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getOptionalDouble = function() {
    return ResponseParamsProxy.prototype.getOptionalDouble
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getOptionalDouble = function(value) {
    var params_ = new ResponseParams_GetOptionalDouble_Params();
    params_.value = value;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetOptionalDouble_Name,
          codec.align(ResponseParams_GetOptionalDouble_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetOptionalDouble_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetOptionalDouble_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getOptionalEnum = function() {
    return ResponseParamsProxy.prototype.getOptionalEnum
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getOptionalEnum = function(value) {
    var params_ = new ResponseParams_GetOptionalEnum_Params();
    params_.value = value;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetOptionalEnum_Name,
          codec.align(ResponseParams_GetOptionalEnum_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetOptionalEnum_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetOptionalEnum_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getOptionalBools = function() {
    return ResponseParamsProxy.prototype.getOptionalBools
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getOptionalBools = function(value) {
    var params_ = new ResponseParams_GetOptionalBools_Params();
    params_.value = value;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetOptionalBools_Name,
          codec.align(ResponseParams_GetOptionalBools_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetOptionalBools_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetOptionalBools_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getOptionalInt16s = function() {
    return ResponseParamsProxy.prototype.getOptionalInt16s
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getOptionalInt16s = function(value) {
    var params_ = new ResponseParams_GetOptionalInt16s_Params();
    params_.value = value;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetOptionalInt16s_Name,
          codec.align(ResponseParams_GetOptionalInt16s_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetOptionalInt16s_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetOptionalInt16s_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getOptionalUint32s = function() {
    return ResponseParamsProxy.prototype.getOptionalUint32s
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getOptionalUint32s = function(value) {
    var params_ = new ResponseParams_GetOptionalUint32s_Params();
    params_.value = value;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetOptionalUint32s_Name,
          codec.align(ResponseParams_GetOptionalUint32s_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetOptionalUint32s_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetOptionalUint32s_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getOptionalDoubles = function() {
    return ResponseParamsProxy.prototype.getOptionalDoubles
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getOptionalDoubles = function(value) {
    var params_ = new ResponseParams_GetOptionalDoubles_Params();
    params_.value = value;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetOptionalDoubles_Name,
          codec.align(ResponseParams_GetOptionalDoubles_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetOptionalDoubles_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetOptionalDoubles_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getOptionalEnums = function() {
    return ResponseParamsProxy.prototype.getOptionalEnums
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getOptionalEnums = function(value) {
    var params_ = new ResponseParams_GetOptionalEnums_Params();
    params_.value = value;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetOptionalEnums_Name,
          codec.align(ResponseParams_GetOptionalEnums_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetOptionalEnums_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetOptionalEnums_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getOptionalBoolMap = function() {
    return ResponseParamsProxy.prototype.getOptionalBoolMap
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getOptionalBoolMap = function(key, value) {
    var params_ = new ResponseParams_GetOptionalBoolMap_Params();
    params_.key = key;
    params_.value = value;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetOptionalBoolMap_Name,
          codec.align(ResponseParams_GetOptionalBoolMap_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetOptionalBoolMap_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetOptionalBoolMap_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getOptionalFloatMap = function() {
    return ResponseParamsProxy.prototype.getOptionalFloatMap
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getOptionalFloatMap = function(key, value) {
    var params_ = new ResponseParams_GetOptionalFloatMap_Params();
    params_.key = key;
    params_.value = value;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetOptionalFloatMap_Name,
          codec.align(ResponseParams_GetOptionalFloatMap_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetOptionalFloatMap_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetOptionalFloatMap_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getOptionalEnumMap = function() {
    return ResponseParamsProxy.prototype.getOptionalEnumMap
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getOptionalEnumMap = function(key, value) {
    var params_ = new ResponseParams_GetOptionalEnumMap_Params();
    params_.key = key;
    params_.value = value;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetOptionalEnumMap_Name,
          codec.align(ResponseParams_GetOptionalEnumMap_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetOptionalEnumMap_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetOptionalEnumMap_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getNullStructWithOptionalNumerics = function() {
    return ResponseParamsProxy.prototype.getNullStructWithOptionalNumerics
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getNullStructWithOptionalNumerics = function() {
    var params_ = new ResponseParams_GetNullStructWithOptionalNumerics_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetNullStructWithOptionalNumerics_Name,
          codec.align(ResponseParams_GetNullStructWithOptionalNumerics_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetNullStructWithOptionalNumerics_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetNullStructWithOptionalNumerics_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getStructWithNullOptionalNumerics = function() {
    return ResponseParamsProxy.prototype.getStructWithNullOptionalNumerics
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getStructWithNullOptionalNumerics = function() {
    var params_ = new ResponseParams_GetStructWithNullOptionalNumerics_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetStructWithNullOptionalNumerics_Name,
          codec.align(ResponseParams_GetStructWithNullOptionalNumerics_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetStructWithNullOptionalNumerics_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetStructWithNullOptionalNumerics_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ResponseParamsPtr.prototype.getStructWithOptionalNumerics = function() {
    return ResponseParamsProxy.prototype.getStructWithOptionalNumerics
        .apply(this.ptr.getProxy(), arguments);
  };

  ResponseParamsProxy.prototype.getStructWithOptionalNumerics = function(boolValue, uint8Value, int8Value, uint16Value, int16Value, uint32Value, int32Value, uint64Value, int64Value, floatValue, doubleValue, enumValue) {
    var params_ = new ResponseParams_GetStructWithOptionalNumerics_Params();
    params_.boolValue = boolValue;
    params_.uint8Value = uint8Value;
    params_.int8Value = int8Value;
    params_.uint16Value = uint16Value;
    params_.int16Value = int16Value;
    params_.uint32Value = uint32Value;
    params_.int32Value = int32Value;
    params_.uint64Value = uint64Value;
    params_.int64Value = int64Value;
    params_.floatValue = floatValue;
    params_.doubleValue = doubleValue;
    params_.enumValue = enumValue;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kResponseParams_GetStructWithOptionalNumerics_Name,
          codec.align(ResponseParams_GetStructWithOptionalNumerics_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ResponseParams_GetStructWithOptionalNumerics_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ResponseParams_GetStructWithOptionalNumerics_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function ResponseParamsStub(delegate) {
    this.delegate_ = delegate;
  }
  ResponseParamsStub.prototype.getNullBool = function() {
    return this.delegate_ && this.delegate_.getNullBool && this.delegate_.getNullBool();
  }
  ResponseParamsStub.prototype.getNullUint8 = function() {
    return this.delegate_ && this.delegate_.getNullUint8 && this.delegate_.getNullUint8();
  }
  ResponseParamsStub.prototype.getNullInt8 = function() {
    return this.delegate_ && this.delegate_.getNullInt8 && this.delegate_.getNullInt8();
  }
  ResponseParamsStub.prototype.getNullUint16 = function() {
    return this.delegate_ && this.delegate_.getNullUint16 && this.delegate_.getNullUint16();
  }
  ResponseParamsStub.prototype.getNullInt16 = function() {
    return this.delegate_ && this.delegate_.getNullInt16 && this.delegate_.getNullInt16();
  }
  ResponseParamsStub.prototype.getNullUint32 = function() {
    return this.delegate_ && this.delegate_.getNullUint32 && this.delegate_.getNullUint32();
  }
  ResponseParamsStub.prototype.getNullInt32 = function() {
    return this.delegate_ && this.delegate_.getNullInt32 && this.delegate_.getNullInt32();
  }
  ResponseParamsStub.prototype.getNullUint64 = function() {
    return this.delegate_ && this.delegate_.getNullUint64 && this.delegate_.getNullUint64();
  }
  ResponseParamsStub.prototype.getNullInt64 = function() {
    return this.delegate_ && this.delegate_.getNullInt64 && this.delegate_.getNullInt64();
  }
  ResponseParamsStub.prototype.getNullFloat = function() {
    return this.delegate_ && this.delegate_.getNullFloat && this.delegate_.getNullFloat();
  }
  ResponseParamsStub.prototype.getNullDouble = function() {
    return this.delegate_ && this.delegate_.getNullDouble && this.delegate_.getNullDouble();
  }
  ResponseParamsStub.prototype.getNullEnum = function() {
    return this.delegate_ && this.delegate_.getNullEnum && this.delegate_.getNullEnum();
  }
  ResponseParamsStub.prototype.getNullBools = function() {
    return this.delegate_ && this.delegate_.getNullBools && this.delegate_.getNullBools();
  }
  ResponseParamsStub.prototype.getNullInt16s = function() {
    return this.delegate_ && this.delegate_.getNullInt16s && this.delegate_.getNullInt16s();
  }
  ResponseParamsStub.prototype.getNullUint32s = function() {
    return this.delegate_ && this.delegate_.getNullUint32s && this.delegate_.getNullUint32s();
  }
  ResponseParamsStub.prototype.getNullDoubles = function() {
    return this.delegate_ && this.delegate_.getNullDoubles && this.delegate_.getNullDoubles();
  }
  ResponseParamsStub.prototype.getNullEnums = function() {
    return this.delegate_ && this.delegate_.getNullEnums && this.delegate_.getNullEnums();
  }
  ResponseParamsStub.prototype.getNullBoolMap = function() {
    return this.delegate_ && this.delegate_.getNullBoolMap && this.delegate_.getNullBoolMap();
  }
  ResponseParamsStub.prototype.getNullInt32Map = function() {
    return this.delegate_ && this.delegate_.getNullInt32Map && this.delegate_.getNullInt32Map();
  }
  ResponseParamsStub.prototype.getNullEnumMap = function() {
    return this.delegate_ && this.delegate_.getNullEnumMap && this.delegate_.getNullEnumMap();
  }
  ResponseParamsStub.prototype.getOptionalBool = function(value) {
    return this.delegate_ && this.delegate_.getOptionalBool && this.delegate_.getOptionalBool(value);
  }
  ResponseParamsStub.prototype.getOptionalUint8 = function(value) {
    return this.delegate_ && this.delegate_.getOptionalUint8 && this.delegate_.getOptionalUint8(value);
  }
  ResponseParamsStub.prototype.getOptionalInt8 = function(value) {
    return this.delegate_ && this.delegate_.getOptionalInt8 && this.delegate_.getOptionalInt8(value);
  }
  ResponseParamsStub.prototype.getOptionalUint16 = function(value) {
    return this.delegate_ && this.delegate_.getOptionalUint16 && this.delegate_.getOptionalUint16(value);
  }
  ResponseParamsStub.prototype.getOptionalInt16 = function(value) {
    return this.delegate_ && this.delegate_.getOptionalInt16 && this.delegate_.getOptionalInt16(value);
  }
  ResponseParamsStub.prototype.getOptionalUint32 = function(value) {
    return this.delegate_ && this.delegate_.getOptionalUint32 && this.delegate_.getOptionalUint32(value);
  }
  ResponseParamsStub.prototype.getOptionalInt32 = function(value) {
    return this.delegate_ && this.delegate_.getOptionalInt32 && this.delegate_.getOptionalInt32(value);
  }
  ResponseParamsStub.prototype.getOptionalUint64 = function(value) {
    return this.delegate_ && this.delegate_.getOptionalUint64 && this.delegate_.getOptionalUint64(value);
  }
  ResponseParamsStub.prototype.getOptionalInt64 = function(value) {
    return this.delegate_ && this.delegate_.getOptionalInt64 && this.delegate_.getOptionalInt64(value);
  }
  ResponseParamsStub.prototype.getOptionalFloat = function(value) {
    return this.delegate_ && this.delegate_.getOptionalFloat && this.delegate_.getOptionalFloat(value);
  }
  ResponseParamsStub.prototype.getOptionalDouble = function(value) {
    return this.delegate_ && this.delegate_.getOptionalDouble && this.delegate_.getOptionalDouble(value);
  }
  ResponseParamsStub.prototype.getOptionalEnum = function(value) {
    return this.delegate_ && this.delegate_.getOptionalEnum && this.delegate_.getOptionalEnum(value);
  }
  ResponseParamsStub.prototype.getOptionalBools = function(value) {
    return this.delegate_ && this.delegate_.getOptionalBools && this.delegate_.getOptionalBools(value);
  }
  ResponseParamsStub.prototype.getOptionalInt16s = function(value) {
    return this.delegate_ && this.delegate_.getOptionalInt16s && this.delegate_.getOptionalInt16s(value);
  }
  ResponseParamsStub.prototype.getOptionalUint32s = function(value) {
    return this.delegate_ && this.delegate_.getOptionalUint32s && this.delegate_.getOptionalUint32s(value);
  }
  ResponseParamsStub.prototype.getOptionalDoubles = function(value) {
    return this.delegate_ && this.delegate_.getOptionalDoubles && this.delegate_.getOptionalDoubles(value);
  }
  ResponseParamsStub.prototype.getOptionalEnums = function(value) {
    return this.delegate_ && this.delegate_.getOptionalEnums && this.delegate_.getOptionalEnums(value);
  }
  ResponseParamsStub.prototype.getOptionalBoolMap = function(key, value) {
    return this.delegate_ && this.delegate_.getOptionalBoolMap && this.delegate_.getOptionalBoolMap(key, value);
  }
  ResponseParamsStub.prototype.getOptionalFloatMap = function(key, value) {
    return this.delegate_ && this.delegate_.getOptionalFloatMap && this.delegate_.getOptionalFloatMap(key, value);
  }
  ResponseParamsStub.prototype.getOptionalEnumMap = function(key, value) {
    return this.delegate_ && this.delegate_.getOptionalEnumMap && this.delegate_.getOptionalEnumMap(key, value);
  }
  ResponseParamsStub.prototype.getNullStructWithOptionalNumerics = function() {
    return this.delegate_ && this.delegate_.getNullStructWithOptionalNumerics && this.delegate_.getNullStructWithOptionalNumerics();
  }
  ResponseParamsStub.prototype.getStructWithNullOptionalNumerics = function() {
    return this.delegate_ && this.delegate_.getStructWithNullOptionalNumerics && this.delegate_.getStructWithNullOptionalNumerics();
  }
  ResponseParamsStub.prototype.getStructWithOptionalNumerics = function(boolValue, uint8Value, int8Value, uint16Value, int16Value, uint32Value, int32Value, uint64Value, int64Value, floatValue, doubleValue, enumValue) {
    return this.delegate_ && this.delegate_.getStructWithOptionalNumerics && this.delegate_.getStructWithOptionalNumerics(boolValue, uint8Value, int8Value, uint16Value, int16Value, uint32Value, int32Value, uint64Value, int64Value, floatValue, doubleValue, enumValue);
  }

  ResponseParamsStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  ResponseParamsStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kResponseParams_GetNullBool_Name:
      var params = reader.decodeStruct(ResponseParams_GetNullBool_Params);
      this.getNullBool().then(function(response) {
        var responseParams =
            new ResponseParams_GetNullBool_ResponseParams();
        responseParams.optionalValue = response.optionalValue;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetNullBool_Name,
            codec.align(ResponseParams_GetNullBool_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetNullBool_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetNullUint8_Name:
      var params = reader.decodeStruct(ResponseParams_GetNullUint8_Params);
      this.getNullUint8().then(function(response) {
        var responseParams =
            new ResponseParams_GetNullUint8_ResponseParams();
        responseParams.optionalValue = response.optionalValue;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetNullUint8_Name,
            codec.align(ResponseParams_GetNullUint8_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetNullUint8_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetNullInt8_Name:
      var params = reader.decodeStruct(ResponseParams_GetNullInt8_Params);
      this.getNullInt8().then(function(response) {
        var responseParams =
            new ResponseParams_GetNullInt8_ResponseParams();
        responseParams.optionalValue = response.optionalValue;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetNullInt8_Name,
            codec.align(ResponseParams_GetNullInt8_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetNullInt8_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetNullUint16_Name:
      var params = reader.decodeStruct(ResponseParams_GetNullUint16_Params);
      this.getNullUint16().then(function(response) {
        var responseParams =
            new ResponseParams_GetNullUint16_ResponseParams();
        responseParams.optionalValue = response.optionalValue;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetNullUint16_Name,
            codec.align(ResponseParams_GetNullUint16_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetNullUint16_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetNullInt16_Name:
      var params = reader.decodeStruct(ResponseParams_GetNullInt16_Params);
      this.getNullInt16().then(function(response) {
        var responseParams =
            new ResponseParams_GetNullInt16_ResponseParams();
        responseParams.optionalValue = response.optionalValue;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetNullInt16_Name,
            codec.align(ResponseParams_GetNullInt16_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetNullInt16_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetNullUint32_Name:
      var params = reader.decodeStruct(ResponseParams_GetNullUint32_Params);
      this.getNullUint32().then(function(response) {
        var responseParams =
            new ResponseParams_GetNullUint32_ResponseParams();
        responseParams.optionalValue = response.optionalValue;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetNullUint32_Name,
            codec.align(ResponseParams_GetNullUint32_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetNullUint32_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetNullInt32_Name:
      var params = reader.decodeStruct(ResponseParams_GetNullInt32_Params);
      this.getNullInt32().then(function(response) {
        var responseParams =
            new ResponseParams_GetNullInt32_ResponseParams();
        responseParams.optionalValue = response.optionalValue;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetNullInt32_Name,
            codec.align(ResponseParams_GetNullInt32_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetNullInt32_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetNullUint64_Name:
      var params = reader.decodeStruct(ResponseParams_GetNullUint64_Params);
      this.getNullUint64().then(function(response) {
        var responseParams =
            new ResponseParams_GetNullUint64_ResponseParams();
        responseParams.optionalValue = response.optionalValue;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetNullUint64_Name,
            codec.align(ResponseParams_GetNullUint64_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetNullUint64_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetNullInt64_Name:
      var params = reader.decodeStruct(ResponseParams_GetNullInt64_Params);
      this.getNullInt64().then(function(response) {
        var responseParams =
            new ResponseParams_GetNullInt64_ResponseParams();
        responseParams.optionalValue = response.optionalValue;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetNullInt64_Name,
            codec.align(ResponseParams_GetNullInt64_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetNullInt64_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetNullFloat_Name:
      var params = reader.decodeStruct(ResponseParams_GetNullFloat_Params);
      this.getNullFloat().then(function(response) {
        var responseParams =
            new ResponseParams_GetNullFloat_ResponseParams();
        responseParams.optionalValue = response.optionalValue;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetNullFloat_Name,
            codec.align(ResponseParams_GetNullFloat_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetNullFloat_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetNullDouble_Name:
      var params = reader.decodeStruct(ResponseParams_GetNullDouble_Params);
      this.getNullDouble().then(function(response) {
        var responseParams =
            new ResponseParams_GetNullDouble_ResponseParams();
        responseParams.optionalValue = response.optionalValue;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetNullDouble_Name,
            codec.align(ResponseParams_GetNullDouble_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetNullDouble_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetNullEnum_Name:
      var params = reader.decodeStruct(ResponseParams_GetNullEnum_Params);
      this.getNullEnum().then(function(response) {
        var responseParams =
            new ResponseParams_GetNullEnum_ResponseParams();
        responseParams.optionalValue = response.optionalValue;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetNullEnum_Name,
            codec.align(ResponseParams_GetNullEnum_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetNullEnum_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetNullBools_Name:
      var params = reader.decodeStruct(ResponseParams_GetNullBools_Params);
      this.getNullBools().then(function(response) {
        var responseParams =
            new ResponseParams_GetNullBools_ResponseParams();
        responseParams.optionalValues = response.optionalValues;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetNullBools_Name,
            codec.align(ResponseParams_GetNullBools_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetNullBools_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetNullInt16s_Name:
      var params = reader.decodeStruct(ResponseParams_GetNullInt16s_Params);
      this.getNullInt16s().then(function(response) {
        var responseParams =
            new ResponseParams_GetNullInt16s_ResponseParams();
        responseParams.optionalValues = response.optionalValues;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetNullInt16s_Name,
            codec.align(ResponseParams_GetNullInt16s_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetNullInt16s_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetNullUint32s_Name:
      var params = reader.decodeStruct(ResponseParams_GetNullUint32s_Params);
      this.getNullUint32s().then(function(response) {
        var responseParams =
            new ResponseParams_GetNullUint32s_ResponseParams();
        responseParams.optionalValues = response.optionalValues;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetNullUint32s_Name,
            codec.align(ResponseParams_GetNullUint32s_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetNullUint32s_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetNullDoubles_Name:
      var params = reader.decodeStruct(ResponseParams_GetNullDoubles_Params);
      this.getNullDoubles().then(function(response) {
        var responseParams =
            new ResponseParams_GetNullDoubles_ResponseParams();
        responseParams.optionalValues = response.optionalValues;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetNullDoubles_Name,
            codec.align(ResponseParams_GetNullDoubles_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetNullDoubles_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetNullEnums_Name:
      var params = reader.decodeStruct(ResponseParams_GetNullEnums_Params);
      this.getNullEnums().then(function(response) {
        var responseParams =
            new ResponseParams_GetNullEnums_ResponseParams();
        responseParams.optionalValues = response.optionalValues;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetNullEnums_Name,
            codec.align(ResponseParams_GetNullEnums_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetNullEnums_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetNullBoolMap_Name:
      var params = reader.decodeStruct(ResponseParams_GetNullBoolMap_Params);
      this.getNullBoolMap().then(function(response) {
        var responseParams =
            new ResponseParams_GetNullBoolMap_ResponseParams();
        responseParams.optionalValues = response.optionalValues;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetNullBoolMap_Name,
            codec.align(ResponseParams_GetNullBoolMap_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetNullBoolMap_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetNullInt32Map_Name:
      var params = reader.decodeStruct(ResponseParams_GetNullInt32Map_Params);
      this.getNullInt32Map().then(function(response) {
        var responseParams =
            new ResponseParams_GetNullInt32Map_ResponseParams();
        responseParams.optionalValues = response.optionalValues;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetNullInt32Map_Name,
            codec.align(ResponseParams_GetNullInt32Map_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetNullInt32Map_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetNullEnumMap_Name:
      var params = reader.decodeStruct(ResponseParams_GetNullEnumMap_Params);
      this.getNullEnumMap().then(function(response) {
        var responseParams =
            new ResponseParams_GetNullEnumMap_ResponseParams();
        responseParams.optionalValues = response.optionalValues;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetNullEnumMap_Name,
            codec.align(ResponseParams_GetNullEnumMap_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetNullEnumMap_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetOptionalBool_Name:
      var params = reader.decodeStruct(ResponseParams_GetOptionalBool_Params);
      this.getOptionalBool(params.value).then(function(response) {
        var responseParams =
            new ResponseParams_GetOptionalBool_ResponseParams();
        responseParams.optionalValue = response.optionalValue;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetOptionalBool_Name,
            codec.align(ResponseParams_GetOptionalBool_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetOptionalBool_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetOptionalUint8_Name:
      var params = reader.decodeStruct(ResponseParams_GetOptionalUint8_Params);
      this.getOptionalUint8(params.value).then(function(response) {
        var responseParams =
            new ResponseParams_GetOptionalUint8_ResponseParams();
        responseParams.optionalValue = response.optionalValue;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetOptionalUint8_Name,
            codec.align(ResponseParams_GetOptionalUint8_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetOptionalUint8_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetOptionalInt8_Name:
      var params = reader.decodeStruct(ResponseParams_GetOptionalInt8_Params);
      this.getOptionalInt8(params.value).then(function(response) {
        var responseParams =
            new ResponseParams_GetOptionalInt8_ResponseParams();
        responseParams.optionalValue = response.optionalValue;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetOptionalInt8_Name,
            codec.align(ResponseParams_GetOptionalInt8_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetOptionalInt8_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetOptionalUint16_Name:
      var params = reader.decodeStruct(ResponseParams_GetOptionalUint16_Params);
      this.getOptionalUint16(params.value).then(function(response) {
        var responseParams =
            new ResponseParams_GetOptionalUint16_ResponseParams();
        responseParams.optionalValue = response.optionalValue;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetOptionalUint16_Name,
            codec.align(ResponseParams_GetOptionalUint16_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetOptionalUint16_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetOptionalInt16_Name:
      var params = reader.decodeStruct(ResponseParams_GetOptionalInt16_Params);
      this.getOptionalInt16(params.value).then(function(response) {
        var responseParams =
            new ResponseParams_GetOptionalInt16_ResponseParams();
        responseParams.optionalValue = response.optionalValue;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetOptionalInt16_Name,
            codec.align(ResponseParams_GetOptionalInt16_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetOptionalInt16_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetOptionalUint32_Name:
      var params = reader.decodeStruct(ResponseParams_GetOptionalUint32_Params);
      this.getOptionalUint32(params.value).then(function(response) {
        var responseParams =
            new ResponseParams_GetOptionalUint32_ResponseParams();
        responseParams.optionalValue = response.optionalValue;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetOptionalUint32_Name,
            codec.align(ResponseParams_GetOptionalUint32_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetOptionalUint32_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetOptionalInt32_Name:
      var params = reader.decodeStruct(ResponseParams_GetOptionalInt32_Params);
      this.getOptionalInt32(params.value).then(function(response) {
        var responseParams =
            new ResponseParams_GetOptionalInt32_ResponseParams();
        responseParams.optionalValue = response.optionalValue;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetOptionalInt32_Name,
            codec.align(ResponseParams_GetOptionalInt32_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetOptionalInt32_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetOptionalUint64_Name:
      var params = reader.decodeStruct(ResponseParams_GetOptionalUint64_Params);
      this.getOptionalUint64(params.value).then(function(response) {
        var responseParams =
            new ResponseParams_GetOptionalUint64_ResponseParams();
        responseParams.optionalValue = response.optionalValue;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetOptionalUint64_Name,
            codec.align(ResponseParams_GetOptionalUint64_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetOptionalUint64_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetOptionalInt64_Name:
      var params = reader.decodeStruct(ResponseParams_GetOptionalInt64_Params);
      this.getOptionalInt64(params.value).then(function(response) {
        var responseParams =
            new ResponseParams_GetOptionalInt64_ResponseParams();
        responseParams.optionalValue = response.optionalValue;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetOptionalInt64_Name,
            codec.align(ResponseParams_GetOptionalInt64_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetOptionalInt64_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetOptionalFloat_Name:
      var params = reader.decodeStruct(ResponseParams_GetOptionalFloat_Params);
      this.getOptionalFloat(params.value).then(function(response) {
        var responseParams =
            new ResponseParams_GetOptionalFloat_ResponseParams();
        responseParams.optionalValue = response.optionalValue;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetOptionalFloat_Name,
            codec.align(ResponseParams_GetOptionalFloat_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetOptionalFloat_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetOptionalDouble_Name:
      var params = reader.decodeStruct(ResponseParams_GetOptionalDouble_Params);
      this.getOptionalDouble(params.value).then(function(response) {
        var responseParams =
            new ResponseParams_GetOptionalDouble_ResponseParams();
        responseParams.optionalValue = response.optionalValue;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetOptionalDouble_Name,
            codec.align(ResponseParams_GetOptionalDouble_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetOptionalDouble_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetOptionalEnum_Name:
      var params = reader.decodeStruct(ResponseParams_GetOptionalEnum_Params);
      this.getOptionalEnum(params.value).then(function(response) {
        var responseParams =
            new ResponseParams_GetOptionalEnum_ResponseParams();
        responseParams.optionalValue = response.optionalValue;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetOptionalEnum_Name,
            codec.align(ResponseParams_GetOptionalEnum_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetOptionalEnum_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetOptionalBools_Name:
      var params = reader.decodeStruct(ResponseParams_GetOptionalBools_Params);
      this.getOptionalBools(params.value).then(function(response) {
        var responseParams =
            new ResponseParams_GetOptionalBools_ResponseParams();
        responseParams.optionalValues = response.optionalValues;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetOptionalBools_Name,
            codec.align(ResponseParams_GetOptionalBools_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetOptionalBools_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetOptionalInt16s_Name:
      var params = reader.decodeStruct(ResponseParams_GetOptionalInt16s_Params);
      this.getOptionalInt16s(params.value).then(function(response) {
        var responseParams =
            new ResponseParams_GetOptionalInt16s_ResponseParams();
        responseParams.optionalValues = response.optionalValues;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetOptionalInt16s_Name,
            codec.align(ResponseParams_GetOptionalInt16s_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetOptionalInt16s_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetOptionalUint32s_Name:
      var params = reader.decodeStruct(ResponseParams_GetOptionalUint32s_Params);
      this.getOptionalUint32s(params.value).then(function(response) {
        var responseParams =
            new ResponseParams_GetOptionalUint32s_ResponseParams();
        responseParams.optionalValues = response.optionalValues;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetOptionalUint32s_Name,
            codec.align(ResponseParams_GetOptionalUint32s_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetOptionalUint32s_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetOptionalDoubles_Name:
      var params = reader.decodeStruct(ResponseParams_GetOptionalDoubles_Params);
      this.getOptionalDoubles(params.value).then(function(response) {
        var responseParams =
            new ResponseParams_GetOptionalDoubles_ResponseParams();
        responseParams.optionalValues = response.optionalValues;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetOptionalDoubles_Name,
            codec.align(ResponseParams_GetOptionalDoubles_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetOptionalDoubles_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetOptionalEnums_Name:
      var params = reader.decodeStruct(ResponseParams_GetOptionalEnums_Params);
      this.getOptionalEnums(params.value).then(function(response) {
        var responseParams =
            new ResponseParams_GetOptionalEnums_ResponseParams();
        responseParams.optionalValues = response.optionalValues;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetOptionalEnums_Name,
            codec.align(ResponseParams_GetOptionalEnums_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetOptionalEnums_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetOptionalBoolMap_Name:
      var params = reader.decodeStruct(ResponseParams_GetOptionalBoolMap_Params);
      this.getOptionalBoolMap(params.key, params.value).then(function(response) {
        var responseParams =
            new ResponseParams_GetOptionalBoolMap_ResponseParams();
        responseParams.optionalValues = response.optionalValues;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetOptionalBoolMap_Name,
            codec.align(ResponseParams_GetOptionalBoolMap_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetOptionalBoolMap_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetOptionalFloatMap_Name:
      var params = reader.decodeStruct(ResponseParams_GetOptionalFloatMap_Params);
      this.getOptionalFloatMap(params.key, params.value).then(function(response) {
        var responseParams =
            new ResponseParams_GetOptionalFloatMap_ResponseParams();
        responseParams.optionalValues = response.optionalValues;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetOptionalFloatMap_Name,
            codec.align(ResponseParams_GetOptionalFloatMap_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetOptionalFloatMap_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetOptionalEnumMap_Name:
      var params = reader.decodeStruct(ResponseParams_GetOptionalEnumMap_Params);
      this.getOptionalEnumMap(params.key, params.value).then(function(response) {
        var responseParams =
            new ResponseParams_GetOptionalEnumMap_ResponseParams();
        responseParams.optionalValues = response.optionalValues;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetOptionalEnumMap_Name,
            codec.align(ResponseParams_GetOptionalEnumMap_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetOptionalEnumMap_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetNullStructWithOptionalNumerics_Name:
      var params = reader.decodeStruct(ResponseParams_GetNullStructWithOptionalNumerics_Params);
      this.getNullStructWithOptionalNumerics().then(function(response) {
        var responseParams =
            new ResponseParams_GetNullStructWithOptionalNumerics_ResponseParams();
        responseParams.s = response.s;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetNullStructWithOptionalNumerics_Name,
            codec.align(ResponseParams_GetNullStructWithOptionalNumerics_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetNullStructWithOptionalNumerics_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetStructWithNullOptionalNumerics_Name:
      var params = reader.decodeStruct(ResponseParams_GetStructWithNullOptionalNumerics_Params);
      this.getStructWithNullOptionalNumerics().then(function(response) {
        var responseParams =
            new ResponseParams_GetStructWithNullOptionalNumerics_ResponseParams();
        responseParams.s = response.s;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetStructWithNullOptionalNumerics_Name,
            codec.align(ResponseParams_GetStructWithNullOptionalNumerics_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetStructWithNullOptionalNumerics_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kResponseParams_GetStructWithOptionalNumerics_Name:
      var params = reader.decodeStruct(ResponseParams_GetStructWithOptionalNumerics_Params);
      this.getStructWithOptionalNumerics(params.boolValue, params.uint8Value, params.int8Value, params.uint16Value, params.int16Value, params.uint32Value, params.int32Value, params.uint64Value, params.int64Value, params.floatValue, params.doubleValue, params.enumValue).then(function(response) {
        var responseParams =
            new ResponseParams_GetStructWithOptionalNumerics_ResponseParams();
        responseParams.s = response.s;
        var builder = new codec.MessageV1Builder(
            kResponseParams_GetStructWithOptionalNumerics_Name,
            codec.align(ResponseParams_GetStructWithOptionalNumerics_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ResponseParams_GetStructWithOptionalNumerics_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateResponseParamsRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kResponseParams_GetNullBool_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetNullBool_Params;
      break;
      case kResponseParams_GetNullUint8_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetNullUint8_Params;
      break;
      case kResponseParams_GetNullInt8_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetNullInt8_Params;
      break;
      case kResponseParams_GetNullUint16_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetNullUint16_Params;
      break;
      case kResponseParams_GetNullInt16_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetNullInt16_Params;
      break;
      case kResponseParams_GetNullUint32_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetNullUint32_Params;
      break;
      case kResponseParams_GetNullInt32_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetNullInt32_Params;
      break;
      case kResponseParams_GetNullUint64_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetNullUint64_Params;
      break;
      case kResponseParams_GetNullInt64_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetNullInt64_Params;
      break;
      case kResponseParams_GetNullFloat_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetNullFloat_Params;
      break;
      case kResponseParams_GetNullDouble_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetNullDouble_Params;
      break;
      case kResponseParams_GetNullEnum_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetNullEnum_Params;
      break;
      case kResponseParams_GetNullBools_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetNullBools_Params;
      break;
      case kResponseParams_GetNullInt16s_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetNullInt16s_Params;
      break;
      case kResponseParams_GetNullUint32s_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetNullUint32s_Params;
      break;
      case kResponseParams_GetNullDoubles_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetNullDoubles_Params;
      break;
      case kResponseParams_GetNullEnums_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetNullEnums_Params;
      break;
      case kResponseParams_GetNullBoolMap_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetNullBoolMap_Params;
      break;
      case kResponseParams_GetNullInt32Map_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetNullInt32Map_Params;
      break;
      case kResponseParams_GetNullEnumMap_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetNullEnumMap_Params;
      break;
      case kResponseParams_GetOptionalBool_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetOptionalBool_Params;
      break;
      case kResponseParams_GetOptionalUint8_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetOptionalUint8_Params;
      break;
      case kResponseParams_GetOptionalInt8_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetOptionalInt8_Params;
      break;
      case kResponseParams_GetOptionalUint16_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetOptionalUint16_Params;
      break;
      case kResponseParams_GetOptionalInt16_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetOptionalInt16_Params;
      break;
      case kResponseParams_GetOptionalUint32_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetOptionalUint32_Params;
      break;
      case kResponseParams_GetOptionalInt32_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetOptionalInt32_Params;
      break;
      case kResponseParams_GetOptionalUint64_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetOptionalUint64_Params;
      break;
      case kResponseParams_GetOptionalInt64_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetOptionalInt64_Params;
      break;
      case kResponseParams_GetOptionalFloat_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetOptionalFloat_Params;
      break;
      case kResponseParams_GetOptionalDouble_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetOptionalDouble_Params;
      break;
      case kResponseParams_GetOptionalEnum_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetOptionalEnum_Params;
      break;
      case kResponseParams_GetOptionalBools_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetOptionalBools_Params;
      break;
      case kResponseParams_GetOptionalInt16s_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetOptionalInt16s_Params;
      break;
      case kResponseParams_GetOptionalUint32s_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetOptionalUint32s_Params;
      break;
      case kResponseParams_GetOptionalDoubles_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetOptionalDoubles_Params;
      break;
      case kResponseParams_GetOptionalEnums_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetOptionalEnums_Params;
      break;
      case kResponseParams_GetOptionalBoolMap_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetOptionalBoolMap_Params;
      break;
      case kResponseParams_GetOptionalFloatMap_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetOptionalFloatMap_Params;
      break;
      case kResponseParams_GetOptionalEnumMap_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetOptionalEnumMap_Params;
      break;
      case kResponseParams_GetNullStructWithOptionalNumerics_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetNullStructWithOptionalNumerics_Params;
      break;
      case kResponseParams_GetStructWithNullOptionalNumerics_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetStructWithNullOptionalNumerics_Params;
      break;
      case kResponseParams_GetStructWithOptionalNumerics_Name:
        if (message.expectsResponse())
          paramsClass = ResponseParams_GetStructWithOptionalNumerics_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateResponseParamsResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kResponseParams_GetNullBool_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetNullBool_ResponseParams;
        break;
      case kResponseParams_GetNullUint8_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetNullUint8_ResponseParams;
        break;
      case kResponseParams_GetNullInt8_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetNullInt8_ResponseParams;
        break;
      case kResponseParams_GetNullUint16_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetNullUint16_ResponseParams;
        break;
      case kResponseParams_GetNullInt16_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetNullInt16_ResponseParams;
        break;
      case kResponseParams_GetNullUint32_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetNullUint32_ResponseParams;
        break;
      case kResponseParams_GetNullInt32_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetNullInt32_ResponseParams;
        break;
      case kResponseParams_GetNullUint64_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetNullUint64_ResponseParams;
        break;
      case kResponseParams_GetNullInt64_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetNullInt64_ResponseParams;
        break;
      case kResponseParams_GetNullFloat_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetNullFloat_ResponseParams;
        break;
      case kResponseParams_GetNullDouble_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetNullDouble_ResponseParams;
        break;
      case kResponseParams_GetNullEnum_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetNullEnum_ResponseParams;
        break;
      case kResponseParams_GetNullBools_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetNullBools_ResponseParams;
        break;
      case kResponseParams_GetNullInt16s_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetNullInt16s_ResponseParams;
        break;
      case kResponseParams_GetNullUint32s_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetNullUint32s_ResponseParams;
        break;
      case kResponseParams_GetNullDoubles_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetNullDoubles_ResponseParams;
        break;
      case kResponseParams_GetNullEnums_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetNullEnums_ResponseParams;
        break;
      case kResponseParams_GetNullBoolMap_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetNullBoolMap_ResponseParams;
        break;
      case kResponseParams_GetNullInt32Map_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetNullInt32Map_ResponseParams;
        break;
      case kResponseParams_GetNullEnumMap_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetNullEnumMap_ResponseParams;
        break;
      case kResponseParams_GetOptionalBool_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetOptionalBool_ResponseParams;
        break;
      case kResponseParams_GetOptionalUint8_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetOptionalUint8_ResponseParams;
        break;
      case kResponseParams_GetOptionalInt8_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetOptionalInt8_ResponseParams;
        break;
      case kResponseParams_GetOptionalUint16_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetOptionalUint16_ResponseParams;
        break;
      case kResponseParams_GetOptionalInt16_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetOptionalInt16_ResponseParams;
        break;
      case kResponseParams_GetOptionalUint32_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetOptionalUint32_ResponseParams;
        break;
      case kResponseParams_GetOptionalInt32_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetOptionalInt32_ResponseParams;
        break;
      case kResponseParams_GetOptionalUint64_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetOptionalUint64_ResponseParams;
        break;
      case kResponseParams_GetOptionalInt64_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetOptionalInt64_ResponseParams;
        break;
      case kResponseParams_GetOptionalFloat_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetOptionalFloat_ResponseParams;
        break;
      case kResponseParams_GetOptionalDouble_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetOptionalDouble_ResponseParams;
        break;
      case kResponseParams_GetOptionalEnum_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetOptionalEnum_ResponseParams;
        break;
      case kResponseParams_GetOptionalBools_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetOptionalBools_ResponseParams;
        break;
      case kResponseParams_GetOptionalInt16s_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetOptionalInt16s_ResponseParams;
        break;
      case kResponseParams_GetOptionalUint32s_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetOptionalUint32s_ResponseParams;
        break;
      case kResponseParams_GetOptionalDoubles_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetOptionalDoubles_ResponseParams;
        break;
      case kResponseParams_GetOptionalEnums_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetOptionalEnums_ResponseParams;
        break;
      case kResponseParams_GetOptionalBoolMap_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetOptionalBoolMap_ResponseParams;
        break;
      case kResponseParams_GetOptionalFloatMap_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetOptionalFloatMap_ResponseParams;
        break;
      case kResponseParams_GetOptionalEnumMap_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetOptionalEnumMap_ResponseParams;
        break;
      case kResponseParams_GetNullStructWithOptionalNumerics_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetNullStructWithOptionalNumerics_ResponseParams;
        break;
      case kResponseParams_GetStructWithNullOptionalNumerics_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetStructWithNullOptionalNumerics_ResponseParams;
        break;
      case kResponseParams_GetStructWithOptionalNumerics_Name:
        if (message.isResponse())
          paramsClass = ResponseParams_GetStructWithOptionalNumerics_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var ResponseParams = {
    name: 'content.optional_numerics_unittest.mojom.ResponseParams',
    kVersion: 0,
    ptrClass: ResponseParamsPtr,
    proxyClass: ResponseParamsProxy,
    stubClass: ResponseParamsStub,
    validateRequest: validateResponseParamsRequest,
    validateResponse: validateResponseParamsResponse,
  };
  ResponseParamsStub.prototype.validator = validateResponseParamsRequest;
  ResponseParamsProxy.prototype.validator = validateResponseParamsResponse;
  var kInterfaceV0_MethodWithVersionedParams_Name = 1;
  var kInterfaceV0_MethodWithVersionedStruct_Name = 2;

  function InterfaceV0Ptr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(InterfaceV0,
                                                   handleOrPtrInfo);
  }

  function InterfaceV0AssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        InterfaceV0, associatedInterfacePtrInfo);
  }

  InterfaceV0AssociatedPtr.prototype =
      Object.create(InterfaceV0Ptr.prototype);
  InterfaceV0AssociatedPtr.prototype.constructor =
      InterfaceV0AssociatedPtr;

  function InterfaceV0Proxy(receiver) {
    this.receiver_ = receiver;
  }
  InterfaceV0Ptr.prototype.methodWithVersionedParams = function() {
    return InterfaceV0Proxy.prototype.methodWithVersionedParams
        .apply(this.ptr.getProxy(), arguments);
  };

  InterfaceV0Proxy.prototype.methodWithVersionedParams = function() {
    var params_ = new InterfaceV0_MethodWithVersionedParams_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kInterfaceV0_MethodWithVersionedParams_Name,
          codec.align(InterfaceV0_MethodWithVersionedParams_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(InterfaceV0_MethodWithVersionedParams_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(InterfaceV0_MethodWithVersionedParams_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  InterfaceV0Ptr.prototype.methodWithVersionedStruct = function() {
    return InterfaceV0Proxy.prototype.methodWithVersionedStruct
        .apply(this.ptr.getProxy(), arguments);
  };

  InterfaceV0Proxy.prototype.methodWithVersionedStruct = function(s) {
    var params_ = new InterfaceV0_MethodWithVersionedStruct_Params();
    params_.s = s;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kInterfaceV0_MethodWithVersionedStruct_Name,
          codec.align(InterfaceV0_MethodWithVersionedStruct_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(InterfaceV0_MethodWithVersionedStruct_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(InterfaceV0_MethodWithVersionedStruct_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function InterfaceV0Stub(delegate) {
    this.delegate_ = delegate;
  }
  InterfaceV0Stub.prototype.methodWithVersionedParams = function() {
    return this.delegate_ && this.delegate_.methodWithVersionedParams && this.delegate_.methodWithVersionedParams();
  }
  InterfaceV0Stub.prototype.methodWithVersionedStruct = function(s) {
    return this.delegate_ && this.delegate_.methodWithVersionedStruct && this.delegate_.methodWithVersionedStruct(s);
  }

  InterfaceV0Stub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  InterfaceV0Stub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kInterfaceV0_MethodWithVersionedParams_Name:
      var params = reader.decodeStruct(InterfaceV0_MethodWithVersionedParams_Params);
      this.methodWithVersionedParams().then(function(response) {
        var responseParams =
            new InterfaceV0_MethodWithVersionedParams_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kInterfaceV0_MethodWithVersionedParams_Name,
            codec.align(InterfaceV0_MethodWithVersionedParams_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(InterfaceV0_MethodWithVersionedParams_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kInterfaceV0_MethodWithVersionedStruct_Name:
      var params = reader.decodeStruct(InterfaceV0_MethodWithVersionedStruct_Params);
      this.methodWithVersionedStruct(params.s).then(function(response) {
        var responseParams =
            new InterfaceV0_MethodWithVersionedStruct_ResponseParams();
        responseParams.s = response.s;
        var builder = new codec.MessageV1Builder(
            kInterfaceV0_MethodWithVersionedStruct_Name,
            codec.align(InterfaceV0_MethodWithVersionedStruct_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(InterfaceV0_MethodWithVersionedStruct_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateInterfaceV0Request(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kInterfaceV0_MethodWithVersionedParams_Name:
        if (message.expectsResponse())
          paramsClass = InterfaceV0_MethodWithVersionedParams_Params;
      break;
      case kInterfaceV0_MethodWithVersionedStruct_Name:
        if (message.expectsResponse())
          paramsClass = InterfaceV0_MethodWithVersionedStruct_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateInterfaceV0Response(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kInterfaceV0_MethodWithVersionedParams_Name:
        if (message.isResponse())
          paramsClass = InterfaceV0_MethodWithVersionedParams_ResponseParams;
        break;
      case kInterfaceV0_MethodWithVersionedStruct_Name:
        if (message.isResponse())
          paramsClass = InterfaceV0_MethodWithVersionedStruct_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var InterfaceV0 = {
    name: 'content.optional_numerics_unittest.mojom.InterfaceV0',
    kVersion: 0,
    ptrClass: InterfaceV0Ptr,
    proxyClass: InterfaceV0Proxy,
    stubClass: InterfaceV0Stub,
    validateRequest: validateInterfaceV0Request,
    validateResponse: validateInterfaceV0Response,
  };
  InterfaceV0Stub.prototype.validator = validateInterfaceV0Request;
  InterfaceV0Proxy.prototype.validator = validateInterfaceV0Response;
  var kInterfaceV2_MethodWithVersionedParams_Name = 1;
  var kInterfaceV2_MethodWithVersionedStruct_Name = 2;

  function InterfaceV2Ptr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(InterfaceV2,
                                                   handleOrPtrInfo);
  }

  function InterfaceV2AssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        InterfaceV2, associatedInterfacePtrInfo);
  }

  InterfaceV2AssociatedPtr.prototype =
      Object.create(InterfaceV2Ptr.prototype);
  InterfaceV2AssociatedPtr.prototype.constructor =
      InterfaceV2AssociatedPtr;

  function InterfaceV2Proxy(receiver) {
    this.receiver_ = receiver;
  }
  InterfaceV2Ptr.prototype.methodWithVersionedParams = function() {
    return InterfaceV2Proxy.prototype.methodWithVersionedParams
        .apply(this.ptr.getProxy(), arguments);
  };

  InterfaceV2Proxy.prototype.methodWithVersionedParams = function(boolValue, uint8Value, int8Value, uint16Value, int16Value, uint32Value, int32Value, uint64Value, int64Value, floatValue, doubleValue, enumValue) {
    var params_ = new InterfaceV2_MethodWithVersionedParams_Params();
    params_.boolValue = boolValue;
    params_.uint8Value = uint8Value;
    params_.int8Value = int8Value;
    params_.uint16Value = uint16Value;
    params_.int16Value = int16Value;
    params_.uint32Value = uint32Value;
    params_.int32Value = int32Value;
    params_.uint64Value = uint64Value;
    params_.int64Value = int64Value;
    params_.floatValue = floatValue;
    params_.doubleValue = doubleValue;
    params_.enumValue = enumValue;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kInterfaceV2_MethodWithVersionedParams_Name,
          codec.align(InterfaceV2_MethodWithVersionedParams_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(InterfaceV2_MethodWithVersionedParams_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(InterfaceV2_MethodWithVersionedParams_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  InterfaceV2Ptr.prototype.methodWithVersionedStruct = function() {
    return InterfaceV2Proxy.prototype.methodWithVersionedStruct
        .apply(this.ptr.getProxy(), arguments);
  };

  InterfaceV2Proxy.prototype.methodWithVersionedStruct = function(s) {
    var params_ = new InterfaceV2_MethodWithVersionedStruct_Params();
    params_.s = s;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kInterfaceV2_MethodWithVersionedStruct_Name,
          codec.align(InterfaceV2_MethodWithVersionedStruct_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(InterfaceV2_MethodWithVersionedStruct_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(InterfaceV2_MethodWithVersionedStruct_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function InterfaceV2Stub(delegate) {
    this.delegate_ = delegate;
  }
  InterfaceV2Stub.prototype.methodWithVersionedParams = function(boolValue, uint8Value, int8Value, uint16Value, int16Value, uint32Value, int32Value, uint64Value, int64Value, floatValue, doubleValue, enumValue) {
    return this.delegate_ && this.delegate_.methodWithVersionedParams && this.delegate_.methodWithVersionedParams(boolValue, uint8Value, int8Value, uint16Value, int16Value, uint32Value, int32Value, uint64Value, int64Value, floatValue, doubleValue, enumValue);
  }
  InterfaceV2Stub.prototype.methodWithVersionedStruct = function(s) {
    return this.delegate_ && this.delegate_.methodWithVersionedStruct && this.delegate_.methodWithVersionedStruct(s);
  }

  InterfaceV2Stub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  InterfaceV2Stub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kInterfaceV2_MethodWithVersionedParams_Name:
      var params = reader.decodeStruct(InterfaceV2_MethodWithVersionedParams_Params);
      this.methodWithVersionedParams(params.boolValue, params.uint8Value, params.int8Value, params.uint16Value, params.int16Value, params.uint32Value, params.int32Value, params.uint64Value, params.int64Value, params.floatValue, params.doubleValue, params.enumValue).then(function(response) {
        var responseParams =
            new InterfaceV2_MethodWithVersionedParams_ResponseParams();
        responseParams.boolValue = response.boolValue;
        responseParams.uint8Value = response.uint8Value;
        responseParams.int8Value = response.int8Value;
        responseParams.uint16Value = response.uint16Value;
        responseParams.int16Value = response.int16Value;
        responseParams.uint32Value = response.uint32Value;
        responseParams.int32Value = response.int32Value;
        responseParams.uint64Value = response.uint64Value;
        responseParams.int64Value = response.int64Value;
        responseParams.floatValue = response.floatValue;
        responseParams.doubleValue = response.doubleValue;
        responseParams.enumValue = response.enumValue;
        var builder = new codec.MessageV1Builder(
            kInterfaceV2_MethodWithVersionedParams_Name,
            codec.align(InterfaceV2_MethodWithVersionedParams_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(InterfaceV2_MethodWithVersionedParams_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kInterfaceV2_MethodWithVersionedStruct_Name:
      var params = reader.decodeStruct(InterfaceV2_MethodWithVersionedStruct_Params);
      this.methodWithVersionedStruct(params.s).then(function(response) {
        var responseParams =
            new InterfaceV2_MethodWithVersionedStruct_ResponseParams();
        responseParams.s = response.s;
        var builder = new codec.MessageV1Builder(
            kInterfaceV2_MethodWithVersionedStruct_Name,
            codec.align(InterfaceV2_MethodWithVersionedStruct_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(InterfaceV2_MethodWithVersionedStruct_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateInterfaceV2Request(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kInterfaceV2_MethodWithVersionedParams_Name:
        if (message.expectsResponse())
          paramsClass = InterfaceV2_MethodWithVersionedParams_Params;
      break;
      case kInterfaceV2_MethodWithVersionedStruct_Name:
        if (message.expectsResponse())
          paramsClass = InterfaceV2_MethodWithVersionedStruct_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateInterfaceV2Response(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kInterfaceV2_MethodWithVersionedParams_Name:
        if (message.isResponse())
          paramsClass = InterfaceV2_MethodWithVersionedParams_ResponseParams;
        break;
      case kInterfaceV2_MethodWithVersionedStruct_Name:
        if (message.isResponse())
          paramsClass = InterfaceV2_MethodWithVersionedStruct_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var InterfaceV2 = {
    name: 'content.optional_numerics_unittest.mojom.InterfaceV2',
    kVersion: 2,
    ptrClass: InterfaceV2Ptr,
    proxyClass: InterfaceV2Proxy,
    stubClass: InterfaceV2Stub,
    validateRequest: validateInterfaceV2Request,
    validateResponse: validateInterfaceV2Response,
  };
  InterfaceV2Stub.prototype.validator = validateInterfaceV2Request;
  InterfaceV2Proxy.prototype.validator = validateInterfaceV2Response;
  exports.RegularEnum = RegularEnum;
  exports.OptionalNumericsStruct = OptionalNumericsStruct;
  exports.VersionedStructV0 = VersionedStructV0;
  exports.VersionedStructV2 = VersionedStructV2;
  exports.Params = Params;
  exports.ParamsPtr = ParamsPtr;
  exports.ParamsAssociatedPtr = ParamsAssociatedPtr;
  exports.ResponseParams = ResponseParams;
  exports.ResponseParamsPtr = ResponseParamsPtr;
  exports.ResponseParamsAssociatedPtr = ResponseParamsAssociatedPtr;
  exports.InterfaceV0 = InterfaceV0;
  exports.InterfaceV0Ptr = InterfaceV0Ptr;
  exports.InterfaceV0AssociatedPtr = InterfaceV0AssociatedPtr;
  exports.InterfaceV2 = InterfaceV2;
  exports.InterfaceV2Ptr = InterfaceV2Ptr;
  exports.InterfaceV2AssociatedPtr = InterfaceV2AssociatedPtr;
})();