// extensions/common/mojom/event_router.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'extensions/common/mojom/event_router.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('extensions.mojom');
  var extension_id$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/extension_id.mojom', 'extension_id.mojom.js');
  }
  var values$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/values.mojom', '../../../mojo/public/mojom/base/values.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../url/mojom/url.mojom.js');
  }



  function ServiceWorkerContext(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerContext.prototype.initDefaults_ = function() {
    this.scopeUrl = null;
    this.versionId = 0;
    this.threadId = 0;
  };
  ServiceWorkerContext.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerContext.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerContext.scopeUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ServiceWorkerContext.encodedSize = codec.kStructHeaderSize + 24;

  ServiceWorkerContext.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerContext();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.scopeUrl =
        decoder.decodeStructPointer(url$.Url);
    val.versionId =
        decoder.decodeStruct(codec.Int64);
    val.threadId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ServiceWorkerContext.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerContext.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.scopeUrl);
    encoder.encodeStruct(codec.Int64, val.versionId);
    encoder.encodeStruct(codec.Int32, val.threadId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function EventListener(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EventListener.prototype.initDefaults_ = function() {
    this.listenerOwner = null;
    this.eventName = null;
    this.serviceWorkerContext = null;
    this.filter = null;
  };
  EventListener.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EventListener.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventListener.listenerOwner
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, EventListenerOwner, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventListener.eventName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventListener.serviceWorkerContext
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, ServiceWorkerContext, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventListener.filter
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, values$.DictionaryValue, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EventListener.encodedSize = codec.kStructHeaderSize + 40;

  EventListener.decode = function(decoder) {
    var packed;
    var val = new EventListener();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.listenerOwner =
        decoder.decodeStruct(EventListenerOwner);
    val.eventName =
        decoder.decodeStruct(codec.String);
    val.serviceWorkerContext =
        decoder.decodeStructPointer(ServiceWorkerContext);
    val.filter =
        decoder.decodeStructPointer(values$.DictionaryValue);
    return val;
  };

  EventListener.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EventListener.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(EventListenerOwner, val.listenerOwner);
    encoder.encodeStruct(codec.String, val.eventName);
    encoder.encodeStructPointer(ServiceWorkerContext, val.serviceWorkerContext);
    encoder.encodeStructPointer(values$.DictionaryValue, val.filter);
  };
  function EventRouter_AddListenerForMainThread_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EventRouter_AddListenerForMainThread_Params.prototype.initDefaults_ = function() {
    this.eventListener = null;
  };
  EventRouter_AddListenerForMainThread_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EventRouter_AddListenerForMainThread_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_AddListenerForMainThread_Params.eventListener
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, EventListener, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EventRouter_AddListenerForMainThread_Params.encodedSize = codec.kStructHeaderSize + 8;

  EventRouter_AddListenerForMainThread_Params.decode = function(decoder) {
    var packed;
    var val = new EventRouter_AddListenerForMainThread_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.eventListener =
        decoder.decodeStructPointer(EventListener);
    return val;
  };

  EventRouter_AddListenerForMainThread_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EventRouter_AddListenerForMainThread_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(EventListener, val.eventListener);
  };
  function EventRouter_AddListenerForServiceWorker_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EventRouter_AddListenerForServiceWorker_Params.prototype.initDefaults_ = function() {
    this.eventListener = null;
  };
  EventRouter_AddListenerForServiceWorker_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EventRouter_AddListenerForServiceWorker_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_AddListenerForServiceWorker_Params.eventListener
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, EventListener, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EventRouter_AddListenerForServiceWorker_Params.encodedSize = codec.kStructHeaderSize + 8;

  EventRouter_AddListenerForServiceWorker_Params.decode = function(decoder) {
    var packed;
    var val = new EventRouter_AddListenerForServiceWorker_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.eventListener =
        decoder.decodeStructPointer(EventListener);
    return val;
  };

  EventRouter_AddListenerForServiceWorker_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EventRouter_AddListenerForServiceWorker_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(EventListener, val.eventListener);
  };
  function EventRouter_AddLazyListenerForMainThread_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EventRouter_AddLazyListenerForMainThread_Params.prototype.initDefaults_ = function() {
    this.extensionId = null;
    this.eventName = null;
  };
  EventRouter_AddLazyListenerForMainThread_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EventRouter_AddLazyListenerForMainThread_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_AddLazyListenerForMainThread_Params.extensionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, extension_id$.ExtensionId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_AddLazyListenerForMainThread_Params.eventName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EventRouter_AddLazyListenerForMainThread_Params.encodedSize = codec.kStructHeaderSize + 16;

  EventRouter_AddLazyListenerForMainThread_Params.decode = function(decoder) {
    var packed;
    var val = new EventRouter_AddLazyListenerForMainThread_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extensionId =
        decoder.decodeStructPointer(extension_id$.ExtensionId);
    val.eventName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  EventRouter_AddLazyListenerForMainThread_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EventRouter_AddLazyListenerForMainThread_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(extension_id$.ExtensionId, val.extensionId);
    encoder.encodeStruct(codec.String, val.eventName);
  };
  function EventRouter_AddLazyListenerForServiceWorker_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EventRouter_AddLazyListenerForServiceWorker_Params.prototype.initDefaults_ = function() {
    this.extensionId = null;
    this.workerScopeUrl = null;
    this.eventName = null;
  };
  EventRouter_AddLazyListenerForServiceWorker_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EventRouter_AddLazyListenerForServiceWorker_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_AddLazyListenerForServiceWorker_Params.extensionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, extension_id$.ExtensionId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_AddLazyListenerForServiceWorker_Params.workerScopeUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_AddLazyListenerForServiceWorker_Params.eventName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EventRouter_AddLazyListenerForServiceWorker_Params.encodedSize = codec.kStructHeaderSize + 24;

  EventRouter_AddLazyListenerForServiceWorker_Params.decode = function(decoder) {
    var packed;
    var val = new EventRouter_AddLazyListenerForServiceWorker_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extensionId =
        decoder.decodeStructPointer(extension_id$.ExtensionId);
    val.workerScopeUrl =
        decoder.decodeStructPointer(url$.Url);
    val.eventName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  EventRouter_AddLazyListenerForServiceWorker_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EventRouter_AddLazyListenerForServiceWorker_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(extension_id$.ExtensionId, val.extensionId);
    encoder.encodeStructPointer(url$.Url, val.workerScopeUrl);
    encoder.encodeStruct(codec.String, val.eventName);
  };
  function EventRouter_AddFilteredListenerForMainThread_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EventRouter_AddFilteredListenerForMainThread_Params.prototype.initDefaults_ = function() {
    this.listenerOwner = null;
    this.eventName = null;
    this.filter = null;
    this.addLazyListener = false;
  };
  EventRouter_AddFilteredListenerForMainThread_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EventRouter_AddFilteredListenerForMainThread_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_AddFilteredListenerForMainThread_Params.listenerOwner
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, EventListenerOwner, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_AddFilteredListenerForMainThread_Params.eventName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_AddFilteredListenerForMainThread_Params.filter
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, values$.DictionaryValue, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  EventRouter_AddFilteredListenerForMainThread_Params.encodedSize = codec.kStructHeaderSize + 40;

  EventRouter_AddFilteredListenerForMainThread_Params.decode = function(decoder) {
    var packed;
    var val = new EventRouter_AddFilteredListenerForMainThread_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.listenerOwner =
        decoder.decodeStruct(EventListenerOwner);
    val.eventName =
        decoder.decodeStruct(codec.String);
    val.filter =
        decoder.decodeStructPointer(values$.DictionaryValue);
    packed = decoder.readUint8();
    val.addLazyListener = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  EventRouter_AddFilteredListenerForMainThread_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EventRouter_AddFilteredListenerForMainThread_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(EventListenerOwner, val.listenerOwner);
    encoder.encodeStruct(codec.String, val.eventName);
    encoder.encodeStructPointer(values$.DictionaryValue, val.filter);
    packed = 0;
    packed |= (val.addLazyListener & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function EventRouter_AddFilteredListenerForServiceWorker_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EventRouter_AddFilteredListenerForServiceWorker_Params.prototype.initDefaults_ = function() {
    this.extensionId = null;
    this.eventName = null;
    this.serviceWorkerContext = null;
    this.filter = null;
    this.addLazyListener = false;
  };
  EventRouter_AddFilteredListenerForServiceWorker_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EventRouter_AddFilteredListenerForServiceWorker_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_AddFilteredListenerForServiceWorker_Params.extensionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, extension_id$.ExtensionId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_AddFilteredListenerForServiceWorker_Params.eventName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_AddFilteredListenerForServiceWorker_Params.serviceWorkerContext
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, ServiceWorkerContext, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_AddFilteredListenerForServiceWorker_Params.filter
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, values$.DictionaryValue, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  EventRouter_AddFilteredListenerForServiceWorker_Params.encodedSize = codec.kStructHeaderSize + 40;

  EventRouter_AddFilteredListenerForServiceWorker_Params.decode = function(decoder) {
    var packed;
    var val = new EventRouter_AddFilteredListenerForServiceWorker_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extensionId =
        decoder.decodeStructPointer(extension_id$.ExtensionId);
    val.eventName =
        decoder.decodeStruct(codec.String);
    val.serviceWorkerContext =
        decoder.decodeStructPointer(ServiceWorkerContext);
    val.filter =
        decoder.decodeStructPointer(values$.DictionaryValue);
    packed = decoder.readUint8();
    val.addLazyListener = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  EventRouter_AddFilteredListenerForServiceWorker_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EventRouter_AddFilteredListenerForServiceWorker_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(extension_id$.ExtensionId, val.extensionId);
    encoder.encodeStruct(codec.String, val.eventName);
    encoder.encodeStructPointer(ServiceWorkerContext, val.serviceWorkerContext);
    encoder.encodeStructPointer(values$.DictionaryValue, val.filter);
    packed = 0;
    packed |= (val.addLazyListener & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function EventRouter_RemoveListenerForMainThread_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EventRouter_RemoveListenerForMainThread_Params.prototype.initDefaults_ = function() {
    this.eventListener = null;
  };
  EventRouter_RemoveListenerForMainThread_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EventRouter_RemoveListenerForMainThread_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_RemoveListenerForMainThread_Params.eventListener
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, EventListener, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EventRouter_RemoveListenerForMainThread_Params.encodedSize = codec.kStructHeaderSize + 8;

  EventRouter_RemoveListenerForMainThread_Params.decode = function(decoder) {
    var packed;
    var val = new EventRouter_RemoveListenerForMainThread_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.eventListener =
        decoder.decodeStructPointer(EventListener);
    return val;
  };

  EventRouter_RemoveListenerForMainThread_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EventRouter_RemoveListenerForMainThread_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(EventListener, val.eventListener);
  };
  function EventRouter_RemoveListenerForServiceWorker_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EventRouter_RemoveListenerForServiceWorker_Params.prototype.initDefaults_ = function() {
    this.eventListener = null;
  };
  EventRouter_RemoveListenerForServiceWorker_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EventRouter_RemoveListenerForServiceWorker_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_RemoveListenerForServiceWorker_Params.eventListener
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, EventListener, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EventRouter_RemoveListenerForServiceWorker_Params.encodedSize = codec.kStructHeaderSize + 8;

  EventRouter_RemoveListenerForServiceWorker_Params.decode = function(decoder) {
    var packed;
    var val = new EventRouter_RemoveListenerForServiceWorker_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.eventListener =
        decoder.decodeStructPointer(EventListener);
    return val;
  };

  EventRouter_RemoveListenerForServiceWorker_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EventRouter_RemoveListenerForServiceWorker_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(EventListener, val.eventListener);
  };
  function EventRouter_RemoveLazyListenerForMainThread_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EventRouter_RemoveLazyListenerForMainThread_Params.prototype.initDefaults_ = function() {
    this.extensionId = null;
    this.eventName = null;
  };
  EventRouter_RemoveLazyListenerForMainThread_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EventRouter_RemoveLazyListenerForMainThread_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_RemoveLazyListenerForMainThread_Params.extensionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, extension_id$.ExtensionId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_RemoveLazyListenerForMainThread_Params.eventName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EventRouter_RemoveLazyListenerForMainThread_Params.encodedSize = codec.kStructHeaderSize + 16;

  EventRouter_RemoveLazyListenerForMainThread_Params.decode = function(decoder) {
    var packed;
    var val = new EventRouter_RemoveLazyListenerForMainThread_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extensionId =
        decoder.decodeStructPointer(extension_id$.ExtensionId);
    val.eventName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  EventRouter_RemoveLazyListenerForMainThread_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EventRouter_RemoveLazyListenerForMainThread_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(extension_id$.ExtensionId, val.extensionId);
    encoder.encodeStruct(codec.String, val.eventName);
  };
  function EventRouter_RemoveLazyListenerForServiceWorker_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EventRouter_RemoveLazyListenerForServiceWorker_Params.prototype.initDefaults_ = function() {
    this.extensionId = null;
    this.workerScopeUrl = null;
    this.eventName = null;
  };
  EventRouter_RemoveLazyListenerForServiceWorker_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EventRouter_RemoveLazyListenerForServiceWorker_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_RemoveLazyListenerForServiceWorker_Params.extensionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, extension_id$.ExtensionId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_RemoveLazyListenerForServiceWorker_Params.workerScopeUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_RemoveLazyListenerForServiceWorker_Params.eventName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EventRouter_RemoveLazyListenerForServiceWorker_Params.encodedSize = codec.kStructHeaderSize + 24;

  EventRouter_RemoveLazyListenerForServiceWorker_Params.decode = function(decoder) {
    var packed;
    var val = new EventRouter_RemoveLazyListenerForServiceWorker_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extensionId =
        decoder.decodeStructPointer(extension_id$.ExtensionId);
    val.workerScopeUrl =
        decoder.decodeStructPointer(url$.Url);
    val.eventName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  EventRouter_RemoveLazyListenerForServiceWorker_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EventRouter_RemoveLazyListenerForServiceWorker_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(extension_id$.ExtensionId, val.extensionId);
    encoder.encodeStructPointer(url$.Url, val.workerScopeUrl);
    encoder.encodeStruct(codec.String, val.eventName);
  };
  function EventRouter_RemoveFilteredListenerForMainThread_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EventRouter_RemoveFilteredListenerForMainThread_Params.prototype.initDefaults_ = function() {
    this.listenerOwner = null;
    this.eventName = null;
    this.filter = null;
    this.removeLazyListener = false;
  };
  EventRouter_RemoveFilteredListenerForMainThread_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EventRouter_RemoveFilteredListenerForMainThread_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_RemoveFilteredListenerForMainThread_Params.listenerOwner
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, EventListenerOwner, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_RemoveFilteredListenerForMainThread_Params.eventName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_RemoveFilteredListenerForMainThread_Params.filter
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, values$.DictionaryValue, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  EventRouter_RemoveFilteredListenerForMainThread_Params.encodedSize = codec.kStructHeaderSize + 40;

  EventRouter_RemoveFilteredListenerForMainThread_Params.decode = function(decoder) {
    var packed;
    var val = new EventRouter_RemoveFilteredListenerForMainThread_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.listenerOwner =
        decoder.decodeStruct(EventListenerOwner);
    val.eventName =
        decoder.decodeStruct(codec.String);
    val.filter =
        decoder.decodeStructPointer(values$.DictionaryValue);
    packed = decoder.readUint8();
    val.removeLazyListener = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  EventRouter_RemoveFilteredListenerForMainThread_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EventRouter_RemoveFilteredListenerForMainThread_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(EventListenerOwner, val.listenerOwner);
    encoder.encodeStruct(codec.String, val.eventName);
    encoder.encodeStructPointer(values$.DictionaryValue, val.filter);
    packed = 0;
    packed |= (val.removeLazyListener & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function EventRouter_RemoveFilteredListenerForServiceWorker_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EventRouter_RemoveFilteredListenerForServiceWorker_Params.prototype.initDefaults_ = function() {
    this.extensionId = null;
    this.eventName = null;
    this.serviceWorkerContext = null;
    this.filter = null;
    this.removeLazyListener = false;
  };
  EventRouter_RemoveFilteredListenerForServiceWorker_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EventRouter_RemoveFilteredListenerForServiceWorker_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_RemoveFilteredListenerForServiceWorker_Params.extensionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, extension_id$.ExtensionId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_RemoveFilteredListenerForServiceWorker_Params.eventName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_RemoveFilteredListenerForServiceWorker_Params.serviceWorkerContext
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, ServiceWorkerContext, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventRouter_RemoveFilteredListenerForServiceWorker_Params.filter
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, values$.DictionaryValue, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  EventRouter_RemoveFilteredListenerForServiceWorker_Params.encodedSize = codec.kStructHeaderSize + 40;

  EventRouter_RemoveFilteredListenerForServiceWorker_Params.decode = function(decoder) {
    var packed;
    var val = new EventRouter_RemoveFilteredListenerForServiceWorker_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extensionId =
        decoder.decodeStructPointer(extension_id$.ExtensionId);
    val.eventName =
        decoder.decodeStruct(codec.String);
    val.serviceWorkerContext =
        decoder.decodeStructPointer(ServiceWorkerContext);
    val.filter =
        decoder.decodeStructPointer(values$.DictionaryValue);
    packed = decoder.readUint8();
    val.removeLazyListener = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  EventRouter_RemoveFilteredListenerForServiceWorker_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EventRouter_RemoveFilteredListenerForServiceWorker_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(extension_id$.ExtensionId, val.extensionId);
    encoder.encodeStruct(codec.String, val.eventName);
    encoder.encodeStructPointer(ServiceWorkerContext, val.serviceWorkerContext);
    encoder.encodeStructPointer(values$.DictionaryValue, val.filter);
    packed = 0;
    packed |= (val.removeLazyListener & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };

  function EventListenerOwner(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  EventListenerOwner.Tags = {
    extensionId: 0,
    listenerUrl: 1,
  };

  EventListenerOwner.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  EventListenerOwner.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "extensionId",
        "listenerUrl",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a EventListenerOwner member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(EventListenerOwner.prototype, "extensionId", {
    get: function() {
      if (this.$tag != EventListenerOwner.Tags.extensionId) {
        throw new ReferenceError(
            "EventListenerOwner.extensionId is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = EventListenerOwner.Tags.extensionId;
      this.$data = value;
    }
  });
  Object.defineProperty(EventListenerOwner.prototype, "listenerUrl", {
    get: function() {
      if (this.$tag != EventListenerOwner.Tags.listenerUrl) {
        throw new ReferenceError(
            "EventListenerOwner.listenerUrl is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = EventListenerOwner.Tags.listenerUrl;
      this.$data = value;
    }
  });


    EventListenerOwner.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case EventListenerOwner.Tags.extensionId:
          encoder.encodeStructPointer(extension_id$.ExtensionId, val.extensionId);
          break;
        case EventListenerOwner.Tags.listenerUrl:
          encoder.encodeStructPointer(url$.Url, val.listenerUrl);
          break;
      }
      encoder.align();
    };


    EventListenerOwner.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new EventListenerOwner();
      var tag = decoder.readUint32();
      switch (tag) {
        case EventListenerOwner.Tags.extensionId:
          result.extensionId = decoder.decodeStructPointer(extension_id$.ExtensionId);
          break;
        case EventListenerOwner.Tags.listenerUrl:
          result.listenerUrl = decoder.decodeStructPointer(url$.Url);
          break;
      }
      decoder.align();

      return result;
    };


    EventListenerOwner.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case EventListenerOwner.Tags.extensionId:
          

    // validate EventListenerOwner.extensionId
    err = messageValidator.validateStructPointer(data_offset, extension_id$.ExtensionId, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case EventListenerOwner.Tags.listenerUrl:
          

    // validate EventListenerOwner.listenerUrl
    err = messageValidator.validateStructPointer(data_offset, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  EventListenerOwner.encodedSize = 16;
  var kEventRouter_AddListenerForMainThread_Name = 0;
  var kEventRouter_AddListenerForServiceWorker_Name = 1;
  var kEventRouter_AddLazyListenerForMainThread_Name = 2;
  var kEventRouter_AddLazyListenerForServiceWorker_Name = 3;
  var kEventRouter_AddFilteredListenerForMainThread_Name = 4;
  var kEventRouter_AddFilteredListenerForServiceWorker_Name = 5;
  var kEventRouter_RemoveListenerForMainThread_Name = 6;
  var kEventRouter_RemoveListenerForServiceWorker_Name = 7;
  var kEventRouter_RemoveLazyListenerForMainThread_Name = 8;
  var kEventRouter_RemoveLazyListenerForServiceWorker_Name = 9;
  var kEventRouter_RemoveFilteredListenerForMainThread_Name = 10;
  var kEventRouter_RemoveFilteredListenerForServiceWorker_Name = 11;

  function EventRouterPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(EventRouter,
                                                   handleOrPtrInfo);
  }

  function EventRouterAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        EventRouter, associatedInterfacePtrInfo);
  }

  EventRouterAssociatedPtr.prototype =
      Object.create(EventRouterPtr.prototype);
  EventRouterAssociatedPtr.prototype.constructor =
      EventRouterAssociatedPtr;

  function EventRouterProxy(receiver) {
    this.receiver_ = receiver;
  }
  EventRouterPtr.prototype.addListenerForMainThread = function() {
    return EventRouterProxy.prototype.addListenerForMainThread
        .apply(this.ptr.getProxy(), arguments);
  };

  EventRouterProxy.prototype.addListenerForMainThread = function(eventListener) {
    var params_ = new EventRouter_AddListenerForMainThread_Params();
    params_.eventListener = eventListener;
    var builder = new codec.MessageV0Builder(
        kEventRouter_AddListenerForMainThread_Name,
        codec.align(EventRouter_AddListenerForMainThread_Params.encodedSize));
    builder.encodeStruct(EventRouter_AddListenerForMainThread_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EventRouterPtr.prototype.addListenerForServiceWorker = function() {
    return EventRouterProxy.prototype.addListenerForServiceWorker
        .apply(this.ptr.getProxy(), arguments);
  };

  EventRouterProxy.prototype.addListenerForServiceWorker = function(eventListener) {
    var params_ = new EventRouter_AddListenerForServiceWorker_Params();
    params_.eventListener = eventListener;
    var builder = new codec.MessageV0Builder(
        kEventRouter_AddListenerForServiceWorker_Name,
        codec.align(EventRouter_AddListenerForServiceWorker_Params.encodedSize));
    builder.encodeStruct(EventRouter_AddListenerForServiceWorker_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EventRouterPtr.prototype.addLazyListenerForMainThread = function() {
    return EventRouterProxy.prototype.addLazyListenerForMainThread
        .apply(this.ptr.getProxy(), arguments);
  };

  EventRouterProxy.prototype.addLazyListenerForMainThread = function(extensionId, eventName) {
    var params_ = new EventRouter_AddLazyListenerForMainThread_Params();
    params_.extensionId = extensionId;
    params_.eventName = eventName;
    var builder = new codec.MessageV0Builder(
        kEventRouter_AddLazyListenerForMainThread_Name,
        codec.align(EventRouter_AddLazyListenerForMainThread_Params.encodedSize));
    builder.encodeStruct(EventRouter_AddLazyListenerForMainThread_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EventRouterPtr.prototype.addLazyListenerForServiceWorker = function() {
    return EventRouterProxy.prototype.addLazyListenerForServiceWorker
        .apply(this.ptr.getProxy(), arguments);
  };

  EventRouterProxy.prototype.addLazyListenerForServiceWorker = function(extensionId, workerScopeUrl, eventName) {
    var params_ = new EventRouter_AddLazyListenerForServiceWorker_Params();
    params_.extensionId = extensionId;
    params_.workerScopeUrl = workerScopeUrl;
    params_.eventName = eventName;
    var builder = new codec.MessageV0Builder(
        kEventRouter_AddLazyListenerForServiceWorker_Name,
        codec.align(EventRouter_AddLazyListenerForServiceWorker_Params.encodedSize));
    builder.encodeStruct(EventRouter_AddLazyListenerForServiceWorker_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EventRouterPtr.prototype.addFilteredListenerForMainThread = function() {
    return EventRouterProxy.prototype.addFilteredListenerForMainThread
        .apply(this.ptr.getProxy(), arguments);
  };

  EventRouterProxy.prototype.addFilteredListenerForMainThread = function(listenerOwner, eventName, filter, addLazyListener) {
    var params_ = new EventRouter_AddFilteredListenerForMainThread_Params();
    params_.listenerOwner = listenerOwner;
    params_.eventName = eventName;
    params_.filter = filter;
    params_.addLazyListener = addLazyListener;
    var builder = new codec.MessageV0Builder(
        kEventRouter_AddFilteredListenerForMainThread_Name,
        codec.align(EventRouter_AddFilteredListenerForMainThread_Params.encodedSize));
    builder.encodeStruct(EventRouter_AddFilteredListenerForMainThread_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EventRouterPtr.prototype.addFilteredListenerForServiceWorker = function() {
    return EventRouterProxy.prototype.addFilteredListenerForServiceWorker
        .apply(this.ptr.getProxy(), arguments);
  };

  EventRouterProxy.prototype.addFilteredListenerForServiceWorker = function(extensionId, eventName, serviceWorkerContext, filter, addLazyListener) {
    var params_ = new EventRouter_AddFilteredListenerForServiceWorker_Params();
    params_.extensionId = extensionId;
    params_.eventName = eventName;
    params_.serviceWorkerContext = serviceWorkerContext;
    params_.filter = filter;
    params_.addLazyListener = addLazyListener;
    var builder = new codec.MessageV0Builder(
        kEventRouter_AddFilteredListenerForServiceWorker_Name,
        codec.align(EventRouter_AddFilteredListenerForServiceWorker_Params.encodedSize));
    builder.encodeStruct(EventRouter_AddFilteredListenerForServiceWorker_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EventRouterPtr.prototype.removeListenerForMainThread = function() {
    return EventRouterProxy.prototype.removeListenerForMainThread
        .apply(this.ptr.getProxy(), arguments);
  };

  EventRouterProxy.prototype.removeListenerForMainThread = function(eventListener) {
    var params_ = new EventRouter_RemoveListenerForMainThread_Params();
    params_.eventListener = eventListener;
    var builder = new codec.MessageV0Builder(
        kEventRouter_RemoveListenerForMainThread_Name,
        codec.align(EventRouter_RemoveListenerForMainThread_Params.encodedSize));
    builder.encodeStruct(EventRouter_RemoveListenerForMainThread_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EventRouterPtr.prototype.removeListenerForServiceWorker = function() {
    return EventRouterProxy.prototype.removeListenerForServiceWorker
        .apply(this.ptr.getProxy(), arguments);
  };

  EventRouterProxy.prototype.removeListenerForServiceWorker = function(eventListener) {
    var params_ = new EventRouter_RemoveListenerForServiceWorker_Params();
    params_.eventListener = eventListener;
    var builder = new codec.MessageV0Builder(
        kEventRouter_RemoveListenerForServiceWorker_Name,
        codec.align(EventRouter_RemoveListenerForServiceWorker_Params.encodedSize));
    builder.encodeStruct(EventRouter_RemoveListenerForServiceWorker_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EventRouterPtr.prototype.removeLazyListenerForMainThread = function() {
    return EventRouterProxy.prototype.removeLazyListenerForMainThread
        .apply(this.ptr.getProxy(), arguments);
  };

  EventRouterProxy.prototype.removeLazyListenerForMainThread = function(extensionId, eventName) {
    var params_ = new EventRouter_RemoveLazyListenerForMainThread_Params();
    params_.extensionId = extensionId;
    params_.eventName = eventName;
    var builder = new codec.MessageV0Builder(
        kEventRouter_RemoveLazyListenerForMainThread_Name,
        codec.align(EventRouter_RemoveLazyListenerForMainThread_Params.encodedSize));
    builder.encodeStruct(EventRouter_RemoveLazyListenerForMainThread_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EventRouterPtr.prototype.removeLazyListenerForServiceWorker = function() {
    return EventRouterProxy.prototype.removeLazyListenerForServiceWorker
        .apply(this.ptr.getProxy(), arguments);
  };

  EventRouterProxy.prototype.removeLazyListenerForServiceWorker = function(extensionId, workerScopeUrl, eventName) {
    var params_ = new EventRouter_RemoveLazyListenerForServiceWorker_Params();
    params_.extensionId = extensionId;
    params_.workerScopeUrl = workerScopeUrl;
    params_.eventName = eventName;
    var builder = new codec.MessageV0Builder(
        kEventRouter_RemoveLazyListenerForServiceWorker_Name,
        codec.align(EventRouter_RemoveLazyListenerForServiceWorker_Params.encodedSize));
    builder.encodeStruct(EventRouter_RemoveLazyListenerForServiceWorker_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EventRouterPtr.prototype.removeFilteredListenerForMainThread = function() {
    return EventRouterProxy.prototype.removeFilteredListenerForMainThread
        .apply(this.ptr.getProxy(), arguments);
  };

  EventRouterProxy.prototype.removeFilteredListenerForMainThread = function(listenerOwner, eventName, filter, removeLazyListener) {
    var params_ = new EventRouter_RemoveFilteredListenerForMainThread_Params();
    params_.listenerOwner = listenerOwner;
    params_.eventName = eventName;
    params_.filter = filter;
    params_.removeLazyListener = removeLazyListener;
    var builder = new codec.MessageV0Builder(
        kEventRouter_RemoveFilteredListenerForMainThread_Name,
        codec.align(EventRouter_RemoveFilteredListenerForMainThread_Params.encodedSize));
    builder.encodeStruct(EventRouter_RemoveFilteredListenerForMainThread_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EventRouterPtr.prototype.removeFilteredListenerForServiceWorker = function() {
    return EventRouterProxy.prototype.removeFilteredListenerForServiceWorker
        .apply(this.ptr.getProxy(), arguments);
  };

  EventRouterProxy.prototype.removeFilteredListenerForServiceWorker = function(extensionId, eventName, serviceWorkerContext, filter, removeLazyListener) {
    var params_ = new EventRouter_RemoveFilteredListenerForServiceWorker_Params();
    params_.extensionId = extensionId;
    params_.eventName = eventName;
    params_.serviceWorkerContext = serviceWorkerContext;
    params_.filter = filter;
    params_.removeLazyListener = removeLazyListener;
    var builder = new codec.MessageV0Builder(
        kEventRouter_RemoveFilteredListenerForServiceWorker_Name,
        codec.align(EventRouter_RemoveFilteredListenerForServiceWorker_Params.encodedSize));
    builder.encodeStruct(EventRouter_RemoveFilteredListenerForServiceWorker_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function EventRouterStub(delegate) {
    this.delegate_ = delegate;
  }
  EventRouterStub.prototype.addListenerForMainThread = function(eventListener) {
    return this.delegate_ && this.delegate_.addListenerForMainThread && this.delegate_.addListenerForMainThread(eventListener);
  }
  EventRouterStub.prototype.addListenerForServiceWorker = function(eventListener) {
    return this.delegate_ && this.delegate_.addListenerForServiceWorker && this.delegate_.addListenerForServiceWorker(eventListener);
  }
  EventRouterStub.prototype.addLazyListenerForMainThread = function(extensionId, eventName) {
    return this.delegate_ && this.delegate_.addLazyListenerForMainThread && this.delegate_.addLazyListenerForMainThread(extensionId, eventName);
  }
  EventRouterStub.prototype.addLazyListenerForServiceWorker = function(extensionId, workerScopeUrl, eventName) {
    return this.delegate_ && this.delegate_.addLazyListenerForServiceWorker && this.delegate_.addLazyListenerForServiceWorker(extensionId, workerScopeUrl, eventName);
  }
  EventRouterStub.prototype.addFilteredListenerForMainThread = function(listenerOwner, eventName, filter, addLazyListener) {
    return this.delegate_ && this.delegate_.addFilteredListenerForMainThread && this.delegate_.addFilteredListenerForMainThread(listenerOwner, eventName, filter, addLazyListener);
  }
  EventRouterStub.prototype.addFilteredListenerForServiceWorker = function(extensionId, eventName, serviceWorkerContext, filter, addLazyListener) {
    return this.delegate_ && this.delegate_.addFilteredListenerForServiceWorker && this.delegate_.addFilteredListenerForServiceWorker(extensionId, eventName, serviceWorkerContext, filter, addLazyListener);
  }
  EventRouterStub.prototype.removeListenerForMainThread = function(eventListener) {
    return this.delegate_ && this.delegate_.removeListenerForMainThread && this.delegate_.removeListenerForMainThread(eventListener);
  }
  EventRouterStub.prototype.removeListenerForServiceWorker = function(eventListener) {
    return this.delegate_ && this.delegate_.removeListenerForServiceWorker && this.delegate_.removeListenerForServiceWorker(eventListener);
  }
  EventRouterStub.prototype.removeLazyListenerForMainThread = function(extensionId, eventName) {
    return this.delegate_ && this.delegate_.removeLazyListenerForMainThread && this.delegate_.removeLazyListenerForMainThread(extensionId, eventName);
  }
  EventRouterStub.prototype.removeLazyListenerForServiceWorker = function(extensionId, workerScopeUrl, eventName) {
    return this.delegate_ && this.delegate_.removeLazyListenerForServiceWorker && this.delegate_.removeLazyListenerForServiceWorker(extensionId, workerScopeUrl, eventName);
  }
  EventRouterStub.prototype.removeFilteredListenerForMainThread = function(listenerOwner, eventName, filter, removeLazyListener) {
    return this.delegate_ && this.delegate_.removeFilteredListenerForMainThread && this.delegate_.removeFilteredListenerForMainThread(listenerOwner, eventName, filter, removeLazyListener);
  }
  EventRouterStub.prototype.removeFilteredListenerForServiceWorker = function(extensionId, eventName, serviceWorkerContext, filter, removeLazyListener) {
    return this.delegate_ && this.delegate_.removeFilteredListenerForServiceWorker && this.delegate_.removeFilteredListenerForServiceWorker(extensionId, eventName, serviceWorkerContext, filter, removeLazyListener);
  }

  EventRouterStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kEventRouter_AddListenerForMainThread_Name:
      var params = reader.decodeStruct(EventRouter_AddListenerForMainThread_Params);
      this.addListenerForMainThread(params.eventListener);
      return true;
    case kEventRouter_AddListenerForServiceWorker_Name:
      var params = reader.decodeStruct(EventRouter_AddListenerForServiceWorker_Params);
      this.addListenerForServiceWorker(params.eventListener);
      return true;
    case kEventRouter_AddLazyListenerForMainThread_Name:
      var params = reader.decodeStruct(EventRouter_AddLazyListenerForMainThread_Params);
      this.addLazyListenerForMainThread(params.extensionId, params.eventName);
      return true;
    case kEventRouter_AddLazyListenerForServiceWorker_Name:
      var params = reader.decodeStruct(EventRouter_AddLazyListenerForServiceWorker_Params);
      this.addLazyListenerForServiceWorker(params.extensionId, params.workerScopeUrl, params.eventName);
      return true;
    case kEventRouter_AddFilteredListenerForMainThread_Name:
      var params = reader.decodeStruct(EventRouter_AddFilteredListenerForMainThread_Params);
      this.addFilteredListenerForMainThread(params.listenerOwner, params.eventName, params.filter, params.addLazyListener);
      return true;
    case kEventRouter_AddFilteredListenerForServiceWorker_Name:
      var params = reader.decodeStruct(EventRouter_AddFilteredListenerForServiceWorker_Params);
      this.addFilteredListenerForServiceWorker(params.extensionId, params.eventName, params.serviceWorkerContext, params.filter, params.addLazyListener);
      return true;
    case kEventRouter_RemoveListenerForMainThread_Name:
      var params = reader.decodeStruct(EventRouter_RemoveListenerForMainThread_Params);
      this.removeListenerForMainThread(params.eventListener);
      return true;
    case kEventRouter_RemoveListenerForServiceWorker_Name:
      var params = reader.decodeStruct(EventRouter_RemoveListenerForServiceWorker_Params);
      this.removeListenerForServiceWorker(params.eventListener);
      return true;
    case kEventRouter_RemoveLazyListenerForMainThread_Name:
      var params = reader.decodeStruct(EventRouter_RemoveLazyListenerForMainThread_Params);
      this.removeLazyListenerForMainThread(params.extensionId, params.eventName);
      return true;
    case kEventRouter_RemoveLazyListenerForServiceWorker_Name:
      var params = reader.decodeStruct(EventRouter_RemoveLazyListenerForServiceWorker_Params);
      this.removeLazyListenerForServiceWorker(params.extensionId, params.workerScopeUrl, params.eventName);
      return true;
    case kEventRouter_RemoveFilteredListenerForMainThread_Name:
      var params = reader.decodeStruct(EventRouter_RemoveFilteredListenerForMainThread_Params);
      this.removeFilteredListenerForMainThread(params.listenerOwner, params.eventName, params.filter, params.removeLazyListener);
      return true;
    case kEventRouter_RemoveFilteredListenerForServiceWorker_Name:
      var params = reader.decodeStruct(EventRouter_RemoveFilteredListenerForServiceWorker_Params);
      this.removeFilteredListenerForServiceWorker(params.extensionId, params.eventName, params.serviceWorkerContext, params.filter, params.removeLazyListener);
      return true;
    default:
      return false;
    }
  };

  EventRouterStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateEventRouterRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kEventRouter_AddListenerForMainThread_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EventRouter_AddListenerForMainThread_Params;
      break;
      case kEventRouter_AddListenerForServiceWorker_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EventRouter_AddListenerForServiceWorker_Params;
      break;
      case kEventRouter_AddLazyListenerForMainThread_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EventRouter_AddLazyListenerForMainThread_Params;
      break;
      case kEventRouter_AddLazyListenerForServiceWorker_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EventRouter_AddLazyListenerForServiceWorker_Params;
      break;
      case kEventRouter_AddFilteredListenerForMainThread_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EventRouter_AddFilteredListenerForMainThread_Params;
      break;
      case kEventRouter_AddFilteredListenerForServiceWorker_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EventRouter_AddFilteredListenerForServiceWorker_Params;
      break;
      case kEventRouter_RemoveListenerForMainThread_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EventRouter_RemoveListenerForMainThread_Params;
      break;
      case kEventRouter_RemoveListenerForServiceWorker_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EventRouter_RemoveListenerForServiceWorker_Params;
      break;
      case kEventRouter_RemoveLazyListenerForMainThread_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EventRouter_RemoveLazyListenerForMainThread_Params;
      break;
      case kEventRouter_RemoveLazyListenerForServiceWorker_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EventRouter_RemoveLazyListenerForServiceWorker_Params;
      break;
      case kEventRouter_RemoveFilteredListenerForMainThread_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EventRouter_RemoveFilteredListenerForMainThread_Params;
      break;
      case kEventRouter_RemoveFilteredListenerForServiceWorker_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EventRouter_RemoveFilteredListenerForServiceWorker_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateEventRouterResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var EventRouter = {
    name: 'extensions.mojom.EventRouter',
    kVersion: 0,
    ptrClass: EventRouterPtr,
    proxyClass: EventRouterProxy,
    stubClass: EventRouterStub,
    validateRequest: validateEventRouterRequest,
    validateResponse: null,
  };
  EventRouterStub.prototype.validator = validateEventRouterRequest;
  EventRouterProxy.prototype.validator = null;
  exports.ServiceWorkerContext = ServiceWorkerContext;
  exports.EventListener = EventListener;
  exports.EventListenerOwner = EventListenerOwner;
  exports.EventRouter = EventRouter;
  exports.EventRouterPtr = EventRouterPtr;
  exports.EventRouterAssociatedPtr = EventRouterAssociatedPtr;
})();