// extensions/common/mojom/host_id.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'extensions/common/mojom/host_id.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('extensions.mojom');



  function HostID(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  HostID.HostType = {};
  HostID.HostType.kExtensions = 0;
  HostID.HostType.kWebUi = 1;
  HostID.HostType.kControlledFrameEmbedder = 2;
  HostID.HostType.MIN_VALUE = 0;
  HostID.HostType.MAX_VALUE = 2;

  HostID.HostType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  HostID.HostType.toKnownEnumValue = function(value) {
    return value;
  };

  HostID.HostType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  HostID.prototype.initDefaults_ = function() {
    this.type = HostID.HostType.kExtensions;
    this.id = null;
  };
  HostID.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HostID.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HostID.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, HostID.HostType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HostID.id
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HostID.encodedSize = codec.kStructHeaderSize + 16;

  HostID.decode = function(decoder) {
    var packed;
    var val = new HostID();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(HostID.HostType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.id =
        decoder.decodeStruct(codec.String);
    return val;
  };

  HostID.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HostID.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.id);
  };
  exports.HostID = HostID;
})();