// extensions/common/mojom/message_port.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  DictionaryValue as mojoBase_mojom_DictionaryValue,
  DictionaryValueSpec as mojoBase_mojom_DictionaryValueSpec
} from '../../../mojo/public/mojom/base/values.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../url/mojom/origin.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../url/mojom/url.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SerializationFormatSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SerializationFormat = {
  
  kStructuredCloned: 0,
  kJson: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ChannelTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ChannelType = {
  
  kSendMessage: 0,
  kSendRequest: 1,
  kConnect: 2,
  kNative: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MessagingEndpointTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MessagingEndpointType = {
  
  kExtension: 0,
  kWebPage: 1,
  kContentScript: 2,
  kUserScript: 3,
  kNativeApp: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MessagePortPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'extensions.mojom.MessagePort', scope);
  }
}

/** @interface */
export class MessagePortInterface {
  
  /**
   * @param { !string } error
   */

  dispatchDisconnect(error) {}
  
  /**
   * @param { !Message } message
   */

  deliverMessage(message) {}
}

/**
 * @implements { MessagePortInterface }
 */
export class MessagePortRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MessagePortPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MessagePortPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MessagePortPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } error
   */

  dispatchDisconnect(
      error) {
    this.proxy.sendMessage(
        0,
        MessagePort_DispatchDisconnect_ParamsSpec.$,
        null,
        [
          error
        ],
        false);
  }

  
  /**
   * @param { !Message } message
   */

  deliverMessage(
      message) {
    this.proxy.sendMessage(
        1,
        MessagePort_DeliverMessage_ParamsSpec.$,
        null,
        [
          message
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MessagePort
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MessagePortReceiver {
  /**
   * @param {!MessagePortInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MessagePortRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MessagePortRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MessagePortRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MessagePort_DispatchDisconnect_ParamsSpec.$,
        null,
        impl.dispatchDisconnect.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MessagePort_DeliverMessage_ParamsSpec.$,
        null,
        impl.deliverMessage.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MessagePort {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.MessagePort";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MessagePortRemote}
   */
  static getRemote() {
    let remote = new MessagePortRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MessagePort
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MessagePortCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MessagePortRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MessagePortRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchDisconnect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MessagePort_DispatchDisconnect_ParamsSpec.$,
        null,
        this.dispatchDisconnect.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deliverMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MessagePort_DeliverMessage_ParamsSpec.$,
        null,
        this.deliverMessage.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MessagePortHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'extensions.mojom.MessagePortHost', scope);
  }
}

/** @interface */
export class MessagePortHostInterface {
  
  /**
   * @param { !boolean } closeChannel
   * @param { ?string } errorMessage
   */

  closePort(closeChannel, errorMessage) {}
  
  /**
   * @param { !Message } message
   */

  postMessage(message) {}
  
  /**
   */

  responsePending() {}
}

/**
 * @implements { MessagePortHostInterface }
 */
export class MessagePortHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MessagePortHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MessagePortHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MessagePortHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } closeChannel
   * @param { ?string } errorMessage
   */

  closePort(
      closeChannel,
      errorMessage) {
    this.proxy.sendMessage(
        0,
        MessagePortHost_ClosePort_ParamsSpec.$,
        null,
        [
          closeChannel,
          errorMessage
        ],
        false);
  }

  
  /**
   * @param { !Message } message
   */

  postMessage(
      message) {
    this.proxy.sendMessage(
        1,
        MessagePortHost_PostMessage_ParamsSpec.$,
        null,
        [
          message
        ],
        false);
  }

  
  /**
   */

  responsePending() {
    this.proxy.sendMessage(
        2,
        MessagePortHost_ResponsePending_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MessagePortHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MessagePortHostReceiver {
  /**
   * @param {!MessagePortHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MessagePortHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MessagePortHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MessagePortHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MessagePortHost_ClosePort_ParamsSpec.$,
        null,
        impl.closePort.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MessagePortHost_PostMessage_ParamsSpec.$,
        null,
        impl.postMessage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        MessagePortHost_ResponsePending_ParamsSpec.$,
        null,
        impl.responsePending.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MessagePortHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.MessagePortHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MessagePortHostRemote}
   */
  static getRemote() {
    let remote = new MessagePortHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MessagePortHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MessagePortHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MessagePortHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MessagePortHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closePort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MessagePortHost_ClosePort_ParamsSpec.$,
        null,
        this.closePort.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.postMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MessagePortHost_PostMessage_ParamsSpec.$,
        null,
        this.postMessage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.responsePending =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        MessagePortHost_ResponsePending_ParamsSpec.$,
        null,
        this.responsePending.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PortIdSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MessagingEndpointSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TabConnectionInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ExternalConnectionInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MessageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MessagePort_DispatchDisconnect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MessagePort_DeliverMessage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MessagePortHost_ClosePort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MessagePortHost_PostMessage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MessagePortHost_ResponsePending_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    PortIdSpec.$,
    'PortId',
    [
      mojo.internal.StructField(
        'contextId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'portNumber', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isOpener', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serializationFormat', 16,
        0,
        SerializationFormatSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PortId {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.contextId;
    /** @type { !number } */
    this.portNumber;
    /** @type { !boolean } */
    this.isOpener;
    /** @type { !SerializationFormat } */
    this.serializationFormat;
  }
}



mojo.internal.Struct(
    MessagingEndpointSpec.$,
    'MessagingEndpoint',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        MessagingEndpointTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'extensionId', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'nativeAppName', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class MessagingEndpoint {
  constructor() {
    /** @type { !MessagingEndpointType } */
    this.type;
    /** @type { (string|undefined) } */
    this.extensionId;
    /** @type { (string|undefined) } */
    this.nativeAppName;
  }
}



mojo.internal.Struct(
    TabConnectionInfoSpec.$,
    'TabConnectionInfo',
    [
      mojo.internal.StructField(
        'tab', 0,
        0,
        mojoBase_mojom_DictionaryValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frameId', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'documentId', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'documentLifecycle', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class TabConnectionInfo {
  constructor() {
    /** @type { !mojoBase_mojom_DictionaryValue } */
    this.tab;
    /** @type { !number } */
    this.frameId;
    /** @type { !string } */
    this.documentId;
    /** @type { !string } */
    this.documentLifecycle;
  }
}



mojo.internal.Struct(
    ExternalConnectionInfoSpec.$,
    'ExternalConnectionInfo',
    [
      mojo.internal.StructField(
        'sourceEndpoint', 0,
        0,
        MessagingEndpointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'targetId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceUrl', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceOrigin', 24,
        0,
        url_mojom_OriginSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'guestProcessId', 32,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'guestRenderFrameRoutingId', 36,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class ExternalConnectionInfo {
  constructor() {
    /** @type { !MessagingEndpoint } */
    this.sourceEndpoint;
    /** @type { !string } */
    this.targetId;
    /** @type { !url_mojom_Url } */
    this.sourceUrl;
    /** @type { (url_mojom_Origin|undefined) } */
    this.sourceOrigin;
    /** @type { !number } */
    this.guestProcessId;
    /** @type { !number } */
    this.guestRenderFrameRoutingId;
  }
}



mojo.internal.Struct(
    MessageSpec.$,
    'Message',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'format', 8,
        0,
        SerializationFormatSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'userGesture', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fromPrivilegedContext', 12,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Message {
  constructor() {
    /** @type { !string } */
    this.data;
    /** @type { !SerializationFormat } */
    this.format;
    /** @type { !boolean } */
    this.userGesture;
    /** @type { !boolean } */
    this.fromPrivilegedContext;
  }
}



mojo.internal.Struct(
    MessagePort_DispatchDisconnect_ParamsSpec.$,
    'MessagePort_DispatchDisconnect_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MessagePort_DispatchDisconnect_Params {
  constructor() {
    /** @type { !string } */
    this.error;
  }
}



mojo.internal.Struct(
    MessagePort_DeliverMessage_ParamsSpec.$,
    'MessagePort_DeliverMessage_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        MessageSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MessagePort_DeliverMessage_Params {
  constructor() {
    /** @type { !Message } */
    this.message;
  }
}



mojo.internal.Struct(
    MessagePortHost_ClosePort_ParamsSpec.$,
    'MessagePortHost_ClosePort_Params',
    [
      mojo.internal.StructField(
        'closeChannel', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MessagePortHost_ClosePort_Params {
  constructor() {
    /** @type { !boolean } */
    this.closeChannel;
    /** @type { (string|undefined) } */
    this.errorMessage;
  }
}



mojo.internal.Struct(
    MessagePortHost_PostMessage_ParamsSpec.$,
    'MessagePortHost_PostMessage_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        MessageSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MessagePortHost_PostMessage_Params {
  constructor() {
    /** @type { !Message } */
    this.message;
  }
}



mojo.internal.Struct(
    MessagePortHost_ResponsePending_ParamsSpec.$,
    'MessagePortHost_ResponsePending_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MessagePortHost_ResponsePending_Params {
  constructor() {
  }
}

