// extensions/common/mojom/renderer_host.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  ListValue as mojoBase_mojom_ListValue,
  ListValueSpec as mojoBase_mojom_ListValueSpec
} from '../../../mojo/public/mojom/base/values.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../url/mojom/url.mojom.m.js';

import {
  ExtensionId as extensions_mojom_ExtensionId,
  ExtensionIdSpec as extensions_mojom_ExtensionIdSpec
} from './extension_id.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class RendererHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'extensions.mojom.RendererHost', scope);
  }
}

/** @interface */
export class RendererHostInterface {
  
  /**
   * @param { ?extensions_mojom_ExtensionId } extensionId
   * @param { !string } callName
   * @param { !mojoBase_mojom_ListValue } args
   * @param { !string } extra
   */

  addAPIActionToActivityLog(extensionId, callName, args, extra) {}
  
  /**
   * @param { ?extensions_mojom_ExtensionId } extensionId
   * @param { !string } callName
   * @param { !mojoBase_mojom_ListValue } args
   * @param { !string } extra
   */

  addEventToActivityLog(extensionId, callName, args, extra) {}
  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !string } callName
   * @param { !mojoBase_mojom_ListValue } args
   * @param { !url_mojom_Url } url
   * @param { !mojoBase_mojom_String16 } urlTitle
   * @param { !number } callType
   */

  addDOMActionToActivityLog(extensionId, callName, args, url, urlTitle, callType) {}
  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @return {!Promise<{
        messageMap: !Object<!string, !string>,
   *  }>}
   */

  getMessageBundle(extensionId) {}
}

/**
 * @implements { RendererHostInterface }
 */
export class RendererHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!RendererHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          RendererHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!RendererHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { ?extensions_mojom_ExtensionId } extensionId
   * @param { !string } callName
   * @param { !mojoBase_mojom_ListValue } args
   * @param { !string } extra
   */

  addAPIActionToActivityLog(
      extensionId,
      callName,
      args,
      extra) {
    this.proxy.sendMessage(
        0,
        RendererHost_AddAPIActionToActivityLog_ParamsSpec.$,
        null,
        [
          extensionId,
          callName,
          args,
          extra
        ],
        false);
  }

  
  /**
   * @param { ?extensions_mojom_ExtensionId } extensionId
   * @param { !string } callName
   * @param { !mojoBase_mojom_ListValue } args
   * @param { !string } extra
   */

  addEventToActivityLog(
      extensionId,
      callName,
      args,
      extra) {
    this.proxy.sendMessage(
        1,
        RendererHost_AddEventToActivityLog_ParamsSpec.$,
        null,
        [
          extensionId,
          callName,
          args,
          extra
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !string } callName
   * @param { !mojoBase_mojom_ListValue } args
   * @param { !url_mojom_Url } url
   * @param { !mojoBase_mojom_String16 } urlTitle
   * @param { !number } callType
   */

  addDOMActionToActivityLog(
      extensionId,
      callName,
      args,
      url,
      urlTitle,
      callType) {
    this.proxy.sendMessage(
        2,
        RendererHost_AddDOMActionToActivityLog_ParamsSpec.$,
        null,
        [
          extensionId,
          callName,
          args,
          url,
          urlTitle,
          callType
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @return {!Promise<{
        messageMap: !Object<!string, !string>,
   *  }>}
   */

  getMessageBundle(
      extensionId) {
    return this.proxy.sendMessage(
        3,
        RendererHost_GetMessageBundle_ParamsSpec.$,
        RendererHost_GetMessageBundle_ResponseParamsSpec.$,
        [
          extensionId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the RendererHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class RendererHostReceiver {
  /**
   * @param {!RendererHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!RendererHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        RendererHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RendererHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        RendererHost_AddAPIActionToActivityLog_ParamsSpec.$,
        null,
        impl.addAPIActionToActivityLog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        RendererHost_AddEventToActivityLog_ParamsSpec.$,
        null,
        impl.addEventToActivityLog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        RendererHost_AddDOMActionToActivityLog_ParamsSpec.$,
        null,
        impl.addDOMActionToActivityLog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        RendererHost_GetMessageBundle_ParamsSpec.$,
        RendererHost_GetMessageBundle_ResponseParamsSpec.$,
        impl.getMessageBundle.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class RendererHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.RendererHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!RendererHostRemote}
   */
  static getRemote() {
    let remote = new RendererHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the RendererHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class RendererHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      RendererHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RendererHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addAPIActionToActivityLog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        RendererHost_AddAPIActionToActivityLog_ParamsSpec.$,
        null,
        this.addAPIActionToActivityLog.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addEventToActivityLog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        RendererHost_AddEventToActivityLog_ParamsSpec.$,
        null,
        this.addEventToActivityLog.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addDOMActionToActivityLog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        RendererHost_AddDOMActionToActivityLog_ParamsSpec.$,
        null,
        this.addDOMActionToActivityLog.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getMessageBundle =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        RendererHost_GetMessageBundle_ParamsSpec.$,
        RendererHost_GetMessageBundle_ResponseParamsSpec.$,
        this.getMessageBundle.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RendererHost_AddAPIActionToActivityLog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RendererHost_AddEventToActivityLog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RendererHost_AddDOMActionToActivityLog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RendererHost_GetMessageBundle_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RendererHost_GetMessageBundle_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    RendererHost_AddAPIActionToActivityLog_ParamsSpec.$,
    'RendererHost_AddAPIActionToActivityLog_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions_mojom_ExtensionIdSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'callName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'args', 16,
        0,
        mojoBase_mojom_ListValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'extra', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class RendererHost_AddAPIActionToActivityLog_Params {
  constructor() {
    /** @type { (extensions_mojom_ExtensionId|undefined) } */
    this.extensionId;
    /** @type { !string } */
    this.callName;
    /** @type { !mojoBase_mojom_ListValue } */
    this.args;
    /** @type { !string } */
    this.extra;
  }
}



mojo.internal.Struct(
    RendererHost_AddEventToActivityLog_ParamsSpec.$,
    'RendererHost_AddEventToActivityLog_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions_mojom_ExtensionIdSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'callName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'args', 16,
        0,
        mojoBase_mojom_ListValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'extra', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class RendererHost_AddEventToActivityLog_Params {
  constructor() {
    /** @type { (extensions_mojom_ExtensionId|undefined) } */
    this.extensionId;
    /** @type { !string } */
    this.callName;
    /** @type { !mojoBase_mojom_ListValue } */
    this.args;
    /** @type { !string } */
    this.extra;
  }
}



mojo.internal.Struct(
    RendererHost_AddDOMActionToActivityLog_ParamsSpec.$,
    'RendererHost_AddDOMActionToActivityLog_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions_mojom_ExtensionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'callName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'args', 16,
        0,
        mojoBase_mojom_ListValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'urlTitle', 32,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'callType', 40,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class RendererHost_AddDOMActionToActivityLog_Params {
  constructor() {
    /** @type { !extensions_mojom_ExtensionId } */
    this.extensionId;
    /** @type { !string } */
    this.callName;
    /** @type { !mojoBase_mojom_ListValue } */
    this.args;
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !mojoBase_mojom_String16 } */
    this.urlTitle;
    /** @type { !number } */
    this.callType;
  }
}



mojo.internal.Struct(
    RendererHost_GetMessageBundle_ParamsSpec.$,
    'RendererHost_GetMessageBundle_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions_mojom_ExtensionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RendererHost_GetMessageBundle_Params {
  constructor() {
    /** @type { !extensions_mojom_ExtensionId } */
    this.extensionId;
  }
}



mojo.internal.Struct(
    RendererHost_GetMessageBundle_ResponseParamsSpec.$,
    'RendererHost_GetMessageBundle_ResponseParams',
    [
      mojo.internal.StructField(
        'messageMap', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RendererHost_GetMessageBundle_ResponseParams {
  constructor() {
    /** @type { !Object<!string, !string> } */
    this.messageMap;
  }
}

