// gpu/ipc/common/capabilities.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'gpu/ipc/common/capabilities.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('gpu.mojom');



  function Capabilities(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Capabilities.prototype.initDefaults_ = function() {
  };
  Capabilities.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Capabilities.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Capabilities.encodedSize = codec.kStructHeaderSize + 0;

  Capabilities.decode = function(decoder) {
    var packed;
    var val = new Capabilities();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Capabilities.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Capabilities.encodedSize);
    encoder.writeUint32(0);
  };
  function GLCapabilities(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GLCapabilities.prototype.initDefaults_ = function() {
  };
  GLCapabilities.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GLCapabilities.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GLCapabilities.encodedSize = codec.kStructHeaderSize + 0;

  GLCapabilities.decode = function(decoder) {
    var packed;
    var val = new GLCapabilities();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  GLCapabilities.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GLCapabilities.encodedSize);
    encoder.writeUint32(0);
  };
  exports.Capabilities = Capabilities;
  exports.GLCapabilities = GLCapabilities;
})();