// media/mojo/mojom/audio_decoder.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  MediaLogRemote as media_mojom_MediaLogRemote,
  MediaLogPendingReceiver as media_mojom_MediaLogPendingReceiver
} from './media_log.mojom.m.js';

import {
  AudioCodec as media_mojom_AudioCodec,
  AudioCodecSpec as media_mojom_AudioCodecSpec,
  AudioCodecProfile as media_mojom_AudioCodecProfile,
  AudioCodecProfileSpec as media_mojom_AudioCodecProfileSpec,
  AudioDecoderType as media_mojom_AudioDecoderType,
  AudioDecoderTypeSpec as media_mojom_AudioDecoderTypeSpec,
  WaitingReason as media_mojom_WaitingReason,
  WaitingReasonSpec as media_mojom_WaitingReasonSpec,
  AudioBuffer as media_mojom_AudioBuffer,
  AudioBufferSpec as media_mojom_AudioBufferSpec,
  AudioDecoderConfig as media_mojom_AudioDecoderConfig,
  AudioDecoderConfigSpec as media_mojom_AudioDecoderConfigSpec,
  DecoderStatus as media_mojom_DecoderStatus,
  DecoderStatusSpec as media_mojom_DecoderStatusSpec,
  DecoderBuffer as media_mojom_DecoderBuffer,
  DecoderBufferSpec as media_mojom_DecoderBufferSpec
} from './media_types.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AudioDecoderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.AudioDecoder', scope);
  }
}

/** @interface */
export class AudioDecoderInterface {
  
  /**
   * @return {!Promise<{
        supportedConfigs: !Array<!SupportedAudioDecoderConfig>,
   *  }>}
   */

  getSupportedConfigs() {}
  
  /**
   * @param { !Object } client
   * @param { !media_mojom_MediaLogRemote } mediaLog
   */

  construct(client, mediaLog) {}
  
  /**
   * @param { !media_mojom_AudioDecoderConfig } config
   * @param { ?mojoBase_mojom_UnguessableToken } cdmId
   * @return {!Promise<{
        success: !media_mojom_DecoderStatus,
        needsBitstreamConversion: !boolean,
        decoderType: !media_mojom_AudioDecoderType,
   *  }>}
   */

  initialize(config, cdmId) {}
  
  /**
   * @param { !MojoHandle } receivePipe
   */

  setDataSource(receivePipe) {}
  
  /**
   * @param { !media_mojom_DecoderBuffer } buffer
   * @return {!Promise<{
        status: !media_mojom_DecoderStatus,
   *  }>}
   */

  decode(buffer) {}
  
  /**
   * @return {!Promise}
   */

  reset() {}
}

/**
 * @implements { AudioDecoderInterface }
 */
export class AudioDecoderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AudioDecoderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioDecoderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AudioDecoderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        supportedConfigs: !Array<!SupportedAudioDecoderConfig>,
   *  }>}
   */

  getSupportedConfigs() {
    return this.proxy.sendMessage(
        0,
        AudioDecoder_GetSupportedConfigs_ParamsSpec.$,
        AudioDecoder_GetSupportedConfigs_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Object } client
   * @param { !media_mojom_MediaLogRemote } mediaLog
   */

  construct(
      client,
      mediaLog) {
    this.proxy.sendMessage(
        1,
        AudioDecoder_Construct_ParamsSpec.$,
        null,
        [
          client,
          mediaLog
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_AudioDecoderConfig } config
   * @param { ?mojoBase_mojom_UnguessableToken } cdmId
   * @return {!Promise<{
        success: !media_mojom_DecoderStatus,
        needsBitstreamConversion: !boolean,
        decoderType: !media_mojom_AudioDecoderType,
   *  }>}
   */

  initialize(
      config,
      cdmId) {
    return this.proxy.sendMessage(
        2,
        AudioDecoder_Initialize_ParamsSpec.$,
        AudioDecoder_Initialize_ResponseParamsSpec.$,
        [
          config,
          cdmId
        ],
        false);
  }

  
  /**
   * @param { !MojoHandle } receivePipe
   */

  setDataSource(
      receivePipe) {
    this.proxy.sendMessage(
        3,
        AudioDecoder_SetDataSource_ParamsSpec.$,
        null,
        [
          receivePipe
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_DecoderBuffer } buffer
   * @return {!Promise<{
        status: !media_mojom_DecoderStatus,
   *  }>}
   */

  decode(
      buffer) {
    return this.proxy.sendMessage(
        4,
        AudioDecoder_Decode_ParamsSpec.$,
        AudioDecoder_Decode_ResponseParamsSpec.$,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  reset() {
    return this.proxy.sendMessage(
        5,
        AudioDecoder_Reset_ParamsSpec.$,
        AudioDecoder_Reset_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AudioDecoder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioDecoderReceiver {
  /**
   * @param {!AudioDecoderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AudioDecoderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioDecoderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioDecoderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioDecoder_GetSupportedConfigs_ParamsSpec.$,
        AudioDecoder_GetSupportedConfigs_ResponseParamsSpec.$,
        impl.getSupportedConfigs.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AudioDecoder_Construct_ParamsSpec.$,
        null,
        impl.construct.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        AudioDecoder_Initialize_ParamsSpec.$,
        AudioDecoder_Initialize_ResponseParamsSpec.$,
        impl.initialize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        AudioDecoder_SetDataSource_ParamsSpec.$,
        null,
        impl.setDataSource.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        AudioDecoder_Decode_ParamsSpec.$,
        AudioDecoder_Decode_ResponseParamsSpec.$,
        impl.decode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        AudioDecoder_Reset_ParamsSpec.$,
        AudioDecoder_Reset_ResponseParamsSpec.$,
        impl.reset.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioDecoder {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioDecoder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AudioDecoderRemote}
   */
  static getRemote() {
    let remote = new AudioDecoderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AudioDecoder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioDecoderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioDecoderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioDecoderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSupportedConfigs =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioDecoder_GetSupportedConfigs_ParamsSpec.$,
        AudioDecoder_GetSupportedConfigs_ResponseParamsSpec.$,
        this.getSupportedConfigs.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.construct =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AudioDecoder_Construct_ParamsSpec.$,
        null,
        this.construct.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        AudioDecoder_Initialize_ParamsSpec.$,
        AudioDecoder_Initialize_ResponseParamsSpec.$,
        this.initialize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setDataSource =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        AudioDecoder_SetDataSource_ParamsSpec.$,
        null,
        this.setDataSource.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.decode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        AudioDecoder_Decode_ParamsSpec.$,
        AudioDecoder_Decode_ResponseParamsSpec.$,
        this.decode.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reset =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        AudioDecoder_Reset_ParamsSpec.$,
        AudioDecoder_Reset_ResponseParamsSpec.$,
        this.reset.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AudioDecoderClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.AudioDecoderClient', scope);
  }
}

/** @interface */
export class AudioDecoderClientInterface {
  
  /**
   * @param { !media_mojom_AudioBuffer } buffer
   */

  onBufferDecoded(buffer) {}
  
  /**
   * @param { !media_mojom_WaitingReason } reason
   */

  onWaiting(reason) {}
}

/**
 * @implements { AudioDecoderClientInterface }
 */
export class AudioDecoderClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AudioDecoderClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioDecoderClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AudioDecoderClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media_mojom_AudioBuffer } buffer
   */

  onBufferDecoded(
      buffer) {
    this.proxy.sendMessage(
        0,
        AudioDecoderClient_OnBufferDecoded_ParamsSpec.$,
        null,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_WaitingReason } reason
   */

  onWaiting(
      reason) {
    this.proxy.sendMessage(
        1,
        AudioDecoderClient_OnWaiting_ParamsSpec.$,
        null,
        [
          reason
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AudioDecoderClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioDecoderClientReceiver {
  /**
   * @param {!AudioDecoderClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AudioDecoderClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioDecoderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioDecoderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioDecoderClient_OnBufferDecoded_ParamsSpec.$,
        null,
        impl.onBufferDecoded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AudioDecoderClient_OnWaiting_ParamsSpec.$,
        null,
        impl.onWaiting.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioDecoderClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioDecoderClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AudioDecoderClientRemote}
   */
  static getRemote() {
    let remote = new AudioDecoderClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AudioDecoderClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioDecoderClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioDecoderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioDecoderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onBufferDecoded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioDecoderClient_OnBufferDecoded_ParamsSpec.$,
        null,
        this.onBufferDecoded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onWaiting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AudioDecoderClient_OnWaiting_ParamsSpec.$,
        null,
        this.onWaiting.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SupportedAudioDecoderConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioDecoder_GetSupportedConfigs_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioDecoder_GetSupportedConfigs_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioDecoder_Construct_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioDecoder_Initialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioDecoder_Initialize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioDecoder_SetDataSource_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioDecoder_Decode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioDecoder_Decode_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioDecoder_Reset_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioDecoder_Reset_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioDecoderClient_OnBufferDecoded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioDecoderClient_OnWaiting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SupportedAudioDecoderConfigSpec.$,
    'SupportedAudioDecoderConfig',
    [
      mojo.internal.StructField(
        'codec', 0,
        0,
        media_mojom_AudioCodecSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'profile', 4,
        0,
        media_mojom_AudioCodecProfileSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SupportedAudioDecoderConfig {
  constructor() {
    /** @type { !media_mojom_AudioCodec } */
    this.codec;
    /** @type { !media_mojom_AudioCodecProfile } */
    this.profile;
  }
}



mojo.internal.Struct(
    AudioDecoder_GetSupportedConfigs_ParamsSpec.$,
    'AudioDecoder_GetSupportedConfigs_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AudioDecoder_GetSupportedConfigs_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AudioDecoder_GetSupportedConfigs_ResponseParamsSpec.$,
    'AudioDecoder_GetSupportedConfigs_ResponseParams',
    [
      mojo.internal.StructField(
        'supportedConfigs', 0,
        0,
        mojo.internal.Array(SupportedAudioDecoderConfigSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioDecoder_GetSupportedConfigs_ResponseParams {
  constructor() {
    /** @type { !Array<!SupportedAudioDecoderConfig> } */
    this.supportedConfigs;
  }
}



mojo.internal.Struct(
    AudioDecoder_Construct_ParamsSpec.$,
    'AudioDecoder_Construct_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(AudioDecoderClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mediaLog', 8,
        0,
        mojo.internal.InterfaceProxy(media_mojom_MediaLogRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AudioDecoder_Construct_Params {
  constructor() {
    /** @type { !Object } */
    this.client;
    /** @type { !media_mojom_MediaLogRemote } */
    this.mediaLog;
  }
}



mojo.internal.Struct(
    AudioDecoder_Initialize_ParamsSpec.$,
    'AudioDecoder_Initialize_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        media_mojom_AudioDecoderConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cdmId', 8,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AudioDecoder_Initialize_Params {
  constructor() {
    /** @type { !media_mojom_AudioDecoderConfig } */
    this.config;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.cdmId;
  }
}



mojo.internal.Struct(
    AudioDecoder_Initialize_ResponseParamsSpec.$,
    'AudioDecoder_Initialize_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        media_mojom_DecoderStatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'needsBitstreamConversion', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'decoderType', 12,
        0,
        media_mojom_AudioDecoderTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AudioDecoder_Initialize_ResponseParams {
  constructor() {
    /** @type { !media_mojom_DecoderStatus } */
    this.success;
    /** @type { !boolean } */
    this.needsBitstreamConversion;
    /** @type { !media_mojom_AudioDecoderType } */
    this.decoderType;
  }
}



mojo.internal.Struct(
    AudioDecoder_SetDataSource_ParamsSpec.$,
    'AudioDecoder_SetDataSource_Params',
    [
      mojo.internal.StructField(
        'receivePipe', 0,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioDecoder_SetDataSource_Params {
  constructor() {
    /** @type { !MojoHandle } */
    this.receivePipe;
  }
}



mojo.internal.Struct(
    AudioDecoder_Decode_ParamsSpec.$,
    'AudioDecoder_Decode_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        media_mojom_DecoderBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AudioDecoder_Decode_Params {
  constructor() {
    /** @type { !media_mojom_DecoderBuffer } */
    this.buffer;
  }
}



mojo.internal.Struct(
    AudioDecoder_Decode_ResponseParamsSpec.$,
    'AudioDecoder_Decode_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media_mojom_DecoderStatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioDecoder_Decode_ResponseParams {
  constructor() {
    /** @type { !media_mojom_DecoderStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    AudioDecoder_Reset_ParamsSpec.$,
    'AudioDecoder_Reset_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AudioDecoder_Reset_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AudioDecoder_Reset_ResponseParamsSpec.$,
    'AudioDecoder_Reset_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AudioDecoder_Reset_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    AudioDecoderClient_OnBufferDecoded_ParamsSpec.$,
    'AudioDecoderClient_OnBufferDecoded_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        media_mojom_AudioBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioDecoderClient_OnBufferDecoded_Params {
  constructor() {
    /** @type { !media_mojom_AudioBuffer } */
    this.buffer;
  }
}



mojo.internal.Struct(
    AudioDecoderClient_OnWaiting_ParamsSpec.$,
    'AudioDecoderClient_OnWaiting_Params',
    [
      mojo.internal.StructField(
        'reason', 0,
        0,
        media_mojom_WaitingReasonSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioDecoderClient_OnWaiting_Params {
  constructor() {
    /** @type { !media_mojom_WaitingReason } */
    this.reason;
  }
}

