// media/mojo/mojom/media_metrics_provider.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('media.mojom.AudioCodec');
goog.require('media.mojom.DemuxerType');
goog.require('media.mojom.MediaContainerName');
goog.require('media.mojom.MediaStreamType');
goog.require('media.mojom.RendererType');
goog.require('media.mojom.VideoCodec');
goog.require('media.mojom.PlaybackEventsRecorder');
goog.require('media.mojom.VideoDecodeStatsRecorder');
goog.require('media.mojom.WatchTimeRecorder');
goog.require('media.mojom.AudioPipelineInfo');
goog.require('media.mojom.PipelineStatus');
goog.require('media.mojom.PlaybackProperties');
goog.require('mojoBase.mojom.TimeDelta');
goog.require('media.mojom.VideoPipelineInfo');




goog.provide('media.mojom.MediaURLScheme');
goog.provide('media.mojom.MediaURLSchemeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.MediaURLSchemeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.MediaURLScheme = {
  
  kUnknown: 0,
  kMissing: 1,
  kHttp: 2,
  kHttps: 3,
  kFtp: 4,
  kChromeExtension: 5,
  kJavascript: 6,
  kFile: 7,
  kBlob: 8,
  kData: 9,
  kFileSystem: 10,
  kChrome: 11,
  kContent: 12,
  kContentId: 13,
  MIN_VALUE: 0,
  MAX_VALUE: 13,
};



goog.provide('media.mojom.MediaMetricsProvider');
goog.provide('media.mojom.MediaMetricsProviderReceiver');
goog.provide('media.mojom.MediaMetricsProviderCallbackRouter');
goog.provide('media.mojom.MediaMetricsProviderInterface');
goog.provide('media.mojom.MediaMetricsProviderRemote');
goog.provide('media.mojom.MediaMetricsProviderPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.MediaMetricsProviderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.MediaMetricsProvider.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.MediaMetricsProviderInterface = class {
  
  /**
   * @param { !boolean } isMse
   * @param { !media.mojom.MediaURLScheme } urlScheme
   * @param { !media.mojom.MediaStreamType } streamType
   */

  initialize(isMse, urlScheme, streamType) {}
  
  /**
   * @param { !media.mojom.PipelineStatus } status
   */

  onStarted(status) {}
  
  /**
   * @param { !media.mojom.PipelineStatus } status
   */

  onError(status) {}
  
  /**
   * @param { !media.mojom.PipelineStatus } status
   */

  onFallback(status) {}
  
  /**
   */

  setHasPlayed() {}
  
  /**
   */

  setHaveEnough() {}
  
  /**
   */

  setIsEME() {}
  
  /**
   * @param { !mojoBase.mojom.TimeDelta } elapsed
   */

  setTimeToMetadata(elapsed) {}
  
  /**
   * @param { !mojoBase.mojom.TimeDelta } elapsed
   */

  setTimeToFirstFrame(elapsed) {}
  
  /**
   * @param { !mojoBase.mojom.TimeDelta } elapsed
   */

  setTimeToPlayReady(elapsed) {}
  
  /**
   * @param { !media.mojom.RendererType } rendererType
   */

  setRendererType(rendererType) {}
  
  /**
   * @param { !media.mojom.DemuxerType } demuxerType
   */

  setDemuxerType(demuxerType) {}
  
  /**
   * @param { !string } keySystem
   */

  setKeySystem(keySystem) {}
  
  /**
   */

  setHasWaitingForKey() {}
  
  /**
   */

  setIsHardwareSecure() {}
  
  /**
   * @param { !media.mojom.MediaContainerName } containerName
   */

  setContainerName(containerName) {}
  
  /**
   * @param { !media.mojom.PlaybackProperties } properties
   * @param { !media.mojom.WatchTimeRecorderPendingReceiver } recorder
   */

  acquireWatchTimeRecorder(properties, recorder) {}
  
  /**
   * @param { !media.mojom.VideoDecodeStatsRecorderPendingReceiver } recorder
   */

  acquireVideoDecodeStatsRecorder(recorder) {}
  
  /**
   * @param { !media.mojom.PlaybackEventsRecorderPendingReceiver } receiver
   */

  acquirePlaybackEventsRecorder(receiver) {}
  
  /**
   * @param { !media.mojom.AudioCodec } codec
   */

  setHasAudio(codec) {}
  
  /**
   * @param { !media.mojom.VideoCodec } codec
   */

  setHasVideo(codec) {}
  
  /**
   * @param { !media.mojom.VideoPipelineInfo } info
   */

  setVideoPipelineInfo(info) {}
  
  /**
   * @param { !media.mojom.AudioPipelineInfo } info
   */

  setAudioPipelineInfo(info) {}
};

/**
 * @export
 * @implements { media.mojom.MediaMetricsProviderInterface }
 */
media.mojom.MediaMetricsProviderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.MediaMetricsProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.MediaMetricsProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.MediaMetricsProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } isMse
   * @param { !media.mojom.MediaURLScheme } urlScheme
   * @param { !media.mojom.MediaStreamType } streamType
   */

  initialize(
      isMse,
      urlScheme,
      streamType) {
    this.proxy.sendMessage(
        0,
        media.mojom.MediaMetricsProvider_Initialize_ParamsSpec.$,
        null,
        [
          isMse,
          urlScheme,
          streamType
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.PipelineStatus } status
   */

  onStarted(
      status) {
    this.proxy.sendMessage(
        1,
        media.mojom.MediaMetricsProvider_OnStarted_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.PipelineStatus } status
   */

  onError(
      status) {
    this.proxy.sendMessage(
        2,
        media.mojom.MediaMetricsProvider_OnError_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.PipelineStatus } status
   */

  onFallback(
      status) {
    this.proxy.sendMessage(
        3,
        media.mojom.MediaMetricsProvider_OnFallback_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }

  
  /**
   */

  setHasPlayed() {
    this.proxy.sendMessage(
        4,
        media.mojom.MediaMetricsProvider_SetHasPlayed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  setHaveEnough() {
    this.proxy.sendMessage(
        5,
        media.mojom.MediaMetricsProvider_SetHaveEnough_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  setIsEME() {
    this.proxy.sendMessage(
        6,
        media.mojom.MediaMetricsProvider_SetIsEME_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.TimeDelta } elapsed
   */

  setTimeToMetadata(
      elapsed) {
    this.proxy.sendMessage(
        7,
        media.mojom.MediaMetricsProvider_SetTimeToMetadata_ParamsSpec.$,
        null,
        [
          elapsed
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.TimeDelta } elapsed
   */

  setTimeToFirstFrame(
      elapsed) {
    this.proxy.sendMessage(
        8,
        media.mojom.MediaMetricsProvider_SetTimeToFirstFrame_ParamsSpec.$,
        null,
        [
          elapsed
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.TimeDelta } elapsed
   */

  setTimeToPlayReady(
      elapsed) {
    this.proxy.sendMessage(
        9,
        media.mojom.MediaMetricsProvider_SetTimeToPlayReady_ParamsSpec.$,
        null,
        [
          elapsed
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.RendererType } rendererType
   */

  setRendererType(
      rendererType) {
    this.proxy.sendMessage(
        10,
        media.mojom.MediaMetricsProvider_SetRendererType_ParamsSpec.$,
        null,
        [
          rendererType
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.DemuxerType } demuxerType
   */

  setDemuxerType(
      demuxerType) {
    this.proxy.sendMessage(
        11,
        media.mojom.MediaMetricsProvider_SetDemuxerType_ParamsSpec.$,
        null,
        [
          demuxerType
        ],
        false);
  }

  
  /**
   * @param { !string } keySystem
   */

  setKeySystem(
      keySystem) {
    this.proxy.sendMessage(
        12,
        media.mojom.MediaMetricsProvider_SetKeySystem_ParamsSpec.$,
        null,
        [
          keySystem
        ],
        false);
  }

  
  /**
   */

  setHasWaitingForKey() {
    this.proxy.sendMessage(
        13,
        media.mojom.MediaMetricsProvider_SetHasWaitingForKey_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  setIsHardwareSecure() {
    this.proxy.sendMessage(
        14,
        media.mojom.MediaMetricsProvider_SetIsHardwareSecure_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.MediaContainerName } containerName
   */

  setContainerName(
      containerName) {
    this.proxy.sendMessage(
        15,
        media.mojom.MediaMetricsProvider_SetContainerName_ParamsSpec.$,
        null,
        [
          containerName
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.PlaybackProperties } properties
   * @param { !media.mojom.WatchTimeRecorderPendingReceiver } recorder
   */

  acquireWatchTimeRecorder(
      properties,
      recorder) {
    this.proxy.sendMessage(
        16,
        media.mojom.MediaMetricsProvider_AcquireWatchTimeRecorder_ParamsSpec.$,
        null,
        [
          properties,
          recorder
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.VideoDecodeStatsRecorderPendingReceiver } recorder
   */

  acquireVideoDecodeStatsRecorder(
      recorder) {
    this.proxy.sendMessage(
        17,
        media.mojom.MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_ParamsSpec.$,
        null,
        [
          recorder
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.PlaybackEventsRecorderPendingReceiver } receiver
   */

  acquirePlaybackEventsRecorder(
      receiver) {
    this.proxy.sendMessage(
        18,
        media.mojom.MediaMetricsProvider_AcquirePlaybackEventsRecorder_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.AudioCodec } codec
   */

  setHasAudio(
      codec) {
    this.proxy.sendMessage(
        19,
        media.mojom.MediaMetricsProvider_SetHasAudio_ParamsSpec.$,
        null,
        [
          codec
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.VideoCodec } codec
   */

  setHasVideo(
      codec) {
    this.proxy.sendMessage(
        20,
        media.mojom.MediaMetricsProvider_SetHasVideo_ParamsSpec.$,
        null,
        [
          codec
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.VideoPipelineInfo } info
   */

  setVideoPipelineInfo(
      info) {
    this.proxy.sendMessage(
        21,
        media.mojom.MediaMetricsProvider_SetVideoPipelineInfo_ParamsSpec.$,
        null,
        [
          info
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.AudioPipelineInfo } info
   */

  setAudioPipelineInfo(
      info) {
    this.proxy.sendMessage(
        22,
        media.mojom.MediaMetricsProvider_SetAudioPipelineInfo_ParamsSpec.$,
        null,
        [
          info
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MediaMetricsProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.MediaMetricsProviderReceiver = class {
  /**
   * @param {!media.mojom.MediaMetricsProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.MediaMetricsProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.MediaMetricsProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.MediaMetricsProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.MediaMetricsProvider_Initialize_ParamsSpec.$,
        null,
        impl.initialize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.MediaMetricsProvider_OnStarted_ParamsSpec.$,
        null,
        impl.onStarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.MediaMetricsProvider_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        media.mojom.MediaMetricsProvider_OnFallback_ParamsSpec.$,
        null,
        impl.onFallback.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        media.mojom.MediaMetricsProvider_SetHasPlayed_ParamsSpec.$,
        null,
        impl.setHasPlayed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        media.mojom.MediaMetricsProvider_SetHaveEnough_ParamsSpec.$,
        null,
        impl.setHaveEnough.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        media.mojom.MediaMetricsProvider_SetIsEME_ParamsSpec.$,
        null,
        impl.setIsEME.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        media.mojom.MediaMetricsProvider_SetTimeToMetadata_ParamsSpec.$,
        null,
        impl.setTimeToMetadata.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        media.mojom.MediaMetricsProvider_SetTimeToFirstFrame_ParamsSpec.$,
        null,
        impl.setTimeToFirstFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        media.mojom.MediaMetricsProvider_SetTimeToPlayReady_ParamsSpec.$,
        null,
        impl.setTimeToPlayReady.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        media.mojom.MediaMetricsProvider_SetRendererType_ParamsSpec.$,
        null,
        impl.setRendererType.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        media.mojom.MediaMetricsProvider_SetDemuxerType_ParamsSpec.$,
        null,
        impl.setDemuxerType.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        media.mojom.MediaMetricsProvider_SetKeySystem_ParamsSpec.$,
        null,
        impl.setKeySystem.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        media.mojom.MediaMetricsProvider_SetHasWaitingForKey_ParamsSpec.$,
        null,
        impl.setHasWaitingForKey.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        media.mojom.MediaMetricsProvider_SetIsHardwareSecure_ParamsSpec.$,
        null,
        impl.setIsHardwareSecure.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        media.mojom.MediaMetricsProvider_SetContainerName_ParamsSpec.$,
        null,
        impl.setContainerName.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        media.mojom.MediaMetricsProvider_AcquireWatchTimeRecorder_ParamsSpec.$,
        null,
        impl.acquireWatchTimeRecorder.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        media.mojom.MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_ParamsSpec.$,
        null,
        impl.acquireVideoDecodeStatsRecorder.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        media.mojom.MediaMetricsProvider_AcquirePlaybackEventsRecorder_ParamsSpec.$,
        null,
        impl.acquirePlaybackEventsRecorder.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        media.mojom.MediaMetricsProvider_SetHasAudio_ParamsSpec.$,
        null,
        impl.setHasAudio.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        media.mojom.MediaMetricsProvider_SetHasVideo_ParamsSpec.$,
        null,
        impl.setHasVideo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        media.mojom.MediaMetricsProvider_SetVideoPipelineInfo_ParamsSpec.$,
        null,
        impl.setVideoPipelineInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        media.mojom.MediaMetricsProvider_SetAudioPipelineInfo_ParamsSpec.$,
        null,
        impl.setAudioPipelineInfo.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.MediaMetricsProvider = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.MediaMetricsProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.MediaMetricsProviderRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.MediaMetricsProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MediaMetricsProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.MediaMetricsProviderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.MediaMetricsProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.MediaMetricsProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.MediaMetricsProvider_Initialize_ParamsSpec.$,
        null,
        this.initialize.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.MediaMetricsProvider_OnStarted_ParamsSpec.$,
        null,
        this.onStarted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.MediaMetricsProvider_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFallback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        media.mojom.MediaMetricsProvider_OnFallback_ParamsSpec.$,
        null,
        this.onFallback.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setHasPlayed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        media.mojom.MediaMetricsProvider_SetHasPlayed_ParamsSpec.$,
        null,
        this.setHasPlayed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setHaveEnough =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        media.mojom.MediaMetricsProvider_SetHaveEnough_ParamsSpec.$,
        null,
        this.setHaveEnough.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setIsEME =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        media.mojom.MediaMetricsProvider_SetIsEME_ParamsSpec.$,
        null,
        this.setIsEME.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTimeToMetadata =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        media.mojom.MediaMetricsProvider_SetTimeToMetadata_ParamsSpec.$,
        null,
        this.setTimeToMetadata.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTimeToFirstFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        media.mojom.MediaMetricsProvider_SetTimeToFirstFrame_ParamsSpec.$,
        null,
        this.setTimeToFirstFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTimeToPlayReady =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        media.mojom.MediaMetricsProvider_SetTimeToPlayReady_ParamsSpec.$,
        null,
        this.setTimeToPlayReady.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setRendererType =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        media.mojom.MediaMetricsProvider_SetRendererType_ParamsSpec.$,
        null,
        this.setRendererType.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setDemuxerType =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        media.mojom.MediaMetricsProvider_SetDemuxerType_ParamsSpec.$,
        null,
        this.setDemuxerType.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setKeySystem =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        media.mojom.MediaMetricsProvider_SetKeySystem_ParamsSpec.$,
        null,
        this.setKeySystem.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setHasWaitingForKey =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        media.mojom.MediaMetricsProvider_SetHasWaitingForKey_ParamsSpec.$,
        null,
        this.setHasWaitingForKey.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setIsHardwareSecure =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        media.mojom.MediaMetricsProvider_SetIsHardwareSecure_ParamsSpec.$,
        null,
        this.setIsHardwareSecure.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setContainerName =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        media.mojom.MediaMetricsProvider_SetContainerName_ParamsSpec.$,
        null,
        this.setContainerName.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.acquireWatchTimeRecorder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        media.mojom.MediaMetricsProvider_AcquireWatchTimeRecorder_ParamsSpec.$,
        null,
        this.acquireWatchTimeRecorder.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.acquireVideoDecodeStatsRecorder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        media.mojom.MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_ParamsSpec.$,
        null,
        this.acquireVideoDecodeStatsRecorder.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.acquirePlaybackEventsRecorder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        media.mojom.MediaMetricsProvider_AcquirePlaybackEventsRecorder_ParamsSpec.$,
        null,
        this.acquirePlaybackEventsRecorder.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setHasAudio =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        media.mojom.MediaMetricsProvider_SetHasAudio_ParamsSpec.$,
        null,
        this.setHasAudio.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setHasVideo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        media.mojom.MediaMetricsProvider_SetHasVideo_ParamsSpec.$,
        null,
        this.setHasVideo.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setVideoPipelineInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        media.mojom.MediaMetricsProvider_SetVideoPipelineInfo_ParamsSpec.$,
        null,
        this.setVideoPipelineInfo.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setAudioPipelineInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        media.mojom.MediaMetricsProvider_SetAudioPipelineInfo_ParamsSpec.$,
        null,
        this.setAudioPipelineInfo.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.MediaMetricsProvider_Initialize_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.MediaMetricsProvider_Initialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.MediaMetricsProvider_OnStarted_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.MediaMetricsProvider_OnStarted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.MediaMetricsProvider_OnError_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.MediaMetricsProvider_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.MediaMetricsProvider_OnFallback_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.MediaMetricsProvider_OnFallback_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.MediaMetricsProvider_SetHasPlayed_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.MediaMetricsProvider_SetHasPlayed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.MediaMetricsProvider_SetHaveEnough_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.MediaMetricsProvider_SetHaveEnough_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.MediaMetricsProvider_SetIsEME_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.MediaMetricsProvider_SetIsEME_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.MediaMetricsProvider_SetTimeToMetadata_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.MediaMetricsProvider_SetTimeToMetadata_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.MediaMetricsProvider_SetTimeToFirstFrame_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.MediaMetricsProvider_SetTimeToFirstFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.MediaMetricsProvider_SetTimeToPlayReady_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.MediaMetricsProvider_SetTimeToPlayReady_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.MediaMetricsProvider_SetRendererType_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.MediaMetricsProvider_SetRendererType_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.MediaMetricsProvider_SetDemuxerType_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.MediaMetricsProvider_SetDemuxerType_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.MediaMetricsProvider_SetKeySystem_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.MediaMetricsProvider_SetKeySystem_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.MediaMetricsProvider_SetHasWaitingForKey_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.MediaMetricsProvider_SetHasWaitingForKey_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.MediaMetricsProvider_SetIsHardwareSecure_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.MediaMetricsProvider_SetIsHardwareSecure_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.MediaMetricsProvider_SetContainerName_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.MediaMetricsProvider_SetContainerName_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.MediaMetricsProvider_AcquireWatchTimeRecorder_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.MediaMetricsProvider_AcquireWatchTimeRecorder_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.MediaMetricsProvider_AcquirePlaybackEventsRecorder_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.MediaMetricsProvider_AcquirePlaybackEventsRecorder_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.MediaMetricsProvider_SetHasAudio_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.MediaMetricsProvider_SetHasAudio_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.MediaMetricsProvider_SetHasVideo_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.MediaMetricsProvider_SetHasVideo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.MediaMetricsProvider_SetVideoPipelineInfo_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.MediaMetricsProvider_SetVideoPipelineInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.MediaMetricsProvider_SetAudioPipelineInfo_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.MediaMetricsProvider_SetAudioPipelineInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.MediaMetricsProvider_Initialize_ParamsSpec.$,
    'MediaMetricsProvider_Initialize_Params',
    [
      mojo.internal.StructField(
        'isMse', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'urlScheme', 4,
        0,
        media.mojom.MediaURLSchemeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'streamType', 8,
        0,
        media.mojom.MediaStreamTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.MediaMetricsProvider_Initialize_Params');

/** @record */
media.mojom.MediaMetricsProvider_Initialize_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.isMse;
    /** @export { !media.mojom.MediaURLScheme } */
    this.urlScheme;
    /** @export { !media.mojom.MediaStreamType } */
    this.streamType;
  }
};



mojo.internal.Struct(
    media.mojom.MediaMetricsProvider_OnStarted_ParamsSpec.$,
    'MediaMetricsProvider_OnStarted_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media.mojom.PipelineStatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.MediaMetricsProvider_OnStarted_Params');

/** @record */
media.mojom.MediaMetricsProvider_OnStarted_Params = class {
  constructor() {
    /** @export { !media.mojom.PipelineStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    media.mojom.MediaMetricsProvider_OnError_ParamsSpec.$,
    'MediaMetricsProvider_OnError_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media.mojom.PipelineStatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.MediaMetricsProvider_OnError_Params');

/** @record */
media.mojom.MediaMetricsProvider_OnError_Params = class {
  constructor() {
    /** @export { !media.mojom.PipelineStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    media.mojom.MediaMetricsProvider_OnFallback_ParamsSpec.$,
    'MediaMetricsProvider_OnFallback_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media.mojom.PipelineStatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.MediaMetricsProvider_OnFallback_Params');

/** @record */
media.mojom.MediaMetricsProvider_OnFallback_Params = class {
  constructor() {
    /** @export { !media.mojom.PipelineStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    media.mojom.MediaMetricsProvider_SetHasPlayed_ParamsSpec.$,
    'MediaMetricsProvider_SetHasPlayed_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.MediaMetricsProvider_SetHasPlayed_Params');

/** @record */
media.mojom.MediaMetricsProvider_SetHasPlayed_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.MediaMetricsProvider_SetHaveEnough_ParamsSpec.$,
    'MediaMetricsProvider_SetHaveEnough_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.MediaMetricsProvider_SetHaveEnough_Params');

/** @record */
media.mojom.MediaMetricsProvider_SetHaveEnough_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.MediaMetricsProvider_SetIsEME_ParamsSpec.$,
    'MediaMetricsProvider_SetIsEME_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.MediaMetricsProvider_SetIsEME_Params');

/** @record */
media.mojom.MediaMetricsProvider_SetIsEME_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.MediaMetricsProvider_SetTimeToMetadata_ParamsSpec.$,
    'MediaMetricsProvider_SetTimeToMetadata_Params',
    [
      mojo.internal.StructField(
        'elapsed', 0,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.MediaMetricsProvider_SetTimeToMetadata_Params');

/** @record */
media.mojom.MediaMetricsProvider_SetTimeToMetadata_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.elapsed;
  }
};



mojo.internal.Struct(
    media.mojom.MediaMetricsProvider_SetTimeToFirstFrame_ParamsSpec.$,
    'MediaMetricsProvider_SetTimeToFirstFrame_Params',
    [
      mojo.internal.StructField(
        'elapsed', 0,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.MediaMetricsProvider_SetTimeToFirstFrame_Params');

/** @record */
media.mojom.MediaMetricsProvider_SetTimeToFirstFrame_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.elapsed;
  }
};



mojo.internal.Struct(
    media.mojom.MediaMetricsProvider_SetTimeToPlayReady_ParamsSpec.$,
    'MediaMetricsProvider_SetTimeToPlayReady_Params',
    [
      mojo.internal.StructField(
        'elapsed', 0,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.MediaMetricsProvider_SetTimeToPlayReady_Params');

/** @record */
media.mojom.MediaMetricsProvider_SetTimeToPlayReady_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.elapsed;
  }
};



mojo.internal.Struct(
    media.mojom.MediaMetricsProvider_SetRendererType_ParamsSpec.$,
    'MediaMetricsProvider_SetRendererType_Params',
    [
      mojo.internal.StructField(
        'rendererType', 0,
        0,
        media.mojom.RendererTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.MediaMetricsProvider_SetRendererType_Params');

/** @record */
media.mojom.MediaMetricsProvider_SetRendererType_Params = class {
  constructor() {
    /** @export { !media.mojom.RendererType } */
    this.rendererType;
  }
};



mojo.internal.Struct(
    media.mojom.MediaMetricsProvider_SetDemuxerType_ParamsSpec.$,
    'MediaMetricsProvider_SetDemuxerType_Params',
    [
      mojo.internal.StructField(
        'demuxerType', 0,
        0,
        media.mojom.DemuxerTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.MediaMetricsProvider_SetDemuxerType_Params');

/** @record */
media.mojom.MediaMetricsProvider_SetDemuxerType_Params = class {
  constructor() {
    /** @export { !media.mojom.DemuxerType } */
    this.demuxerType;
  }
};



mojo.internal.Struct(
    media.mojom.MediaMetricsProvider_SetKeySystem_ParamsSpec.$,
    'MediaMetricsProvider_SetKeySystem_Params',
    [
      mojo.internal.StructField(
        'keySystem', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.MediaMetricsProvider_SetKeySystem_Params');

/** @record */
media.mojom.MediaMetricsProvider_SetKeySystem_Params = class {
  constructor() {
    /** @export { !string } */
    this.keySystem;
  }
};



mojo.internal.Struct(
    media.mojom.MediaMetricsProvider_SetHasWaitingForKey_ParamsSpec.$,
    'MediaMetricsProvider_SetHasWaitingForKey_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.MediaMetricsProvider_SetHasWaitingForKey_Params');

/** @record */
media.mojom.MediaMetricsProvider_SetHasWaitingForKey_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.MediaMetricsProvider_SetIsHardwareSecure_ParamsSpec.$,
    'MediaMetricsProvider_SetIsHardwareSecure_Params',
    [
    ],
    [[0, 8],]);



goog.provide('media.mojom.MediaMetricsProvider_SetIsHardwareSecure_Params');

/** @record */
media.mojom.MediaMetricsProvider_SetIsHardwareSecure_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.MediaMetricsProvider_SetContainerName_ParamsSpec.$,
    'MediaMetricsProvider_SetContainerName_Params',
    [
      mojo.internal.StructField(
        'containerName', 0,
        0,
        media.mojom.MediaContainerNameSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.MediaMetricsProvider_SetContainerName_Params');

/** @record */
media.mojom.MediaMetricsProvider_SetContainerName_Params = class {
  constructor() {
    /** @export { !media.mojom.MediaContainerName } */
    this.containerName;
  }
};



mojo.internal.Struct(
    media.mojom.MediaMetricsProvider_AcquireWatchTimeRecorder_ParamsSpec.$,
    'MediaMetricsProvider_AcquireWatchTimeRecorder_Params',
    [
      mojo.internal.StructField(
        'properties', 0,
        0,
        media.mojom.PlaybackPropertiesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'recorder', 8,
        0,
        mojo.internal.InterfaceRequest(media.mojom.WatchTimeRecorderPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.MediaMetricsProvider_AcquireWatchTimeRecorder_Params');

/** @record */
media.mojom.MediaMetricsProvider_AcquireWatchTimeRecorder_Params = class {
  constructor() {
    /** @export { !media.mojom.PlaybackProperties } */
    this.properties;
    /** @export { !media.mojom.WatchTimeRecorderPendingReceiver } */
    this.recorder;
  }
};



mojo.internal.Struct(
    media.mojom.MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_ParamsSpec.$,
    'MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params',
    [
      mojo.internal.StructField(
        'recorder', 0,
        0,
        mojo.internal.InterfaceRequest(media.mojom.VideoDecodeStatsRecorderPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params');

/** @record */
media.mojom.MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params = class {
  constructor() {
    /** @export { !media.mojom.VideoDecodeStatsRecorderPendingReceiver } */
    this.recorder;
  }
};



mojo.internal.Struct(
    media.mojom.MediaMetricsProvider_AcquirePlaybackEventsRecorder_ParamsSpec.$,
    'MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(media.mojom.PlaybackEventsRecorderPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params');

/** @record */
media.mojom.MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params = class {
  constructor() {
    /** @export { !media.mojom.PlaybackEventsRecorderPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    media.mojom.MediaMetricsProvider_SetHasAudio_ParamsSpec.$,
    'MediaMetricsProvider_SetHasAudio_Params',
    [
      mojo.internal.StructField(
        'codec', 0,
        0,
        media.mojom.AudioCodecSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.MediaMetricsProvider_SetHasAudio_Params');

/** @record */
media.mojom.MediaMetricsProvider_SetHasAudio_Params = class {
  constructor() {
    /** @export { !media.mojom.AudioCodec } */
    this.codec;
  }
};



mojo.internal.Struct(
    media.mojom.MediaMetricsProvider_SetHasVideo_ParamsSpec.$,
    'MediaMetricsProvider_SetHasVideo_Params',
    [
      mojo.internal.StructField(
        'codec', 0,
        0,
        media.mojom.VideoCodecSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.MediaMetricsProvider_SetHasVideo_Params');

/** @record */
media.mojom.MediaMetricsProvider_SetHasVideo_Params = class {
  constructor() {
    /** @export { !media.mojom.VideoCodec } */
    this.codec;
  }
};



mojo.internal.Struct(
    media.mojom.MediaMetricsProvider_SetVideoPipelineInfo_ParamsSpec.$,
    'MediaMetricsProvider_SetVideoPipelineInfo_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        media.mojom.VideoPipelineInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.MediaMetricsProvider_SetVideoPipelineInfo_Params');

/** @record */
media.mojom.MediaMetricsProvider_SetVideoPipelineInfo_Params = class {
  constructor() {
    /** @export { !media.mojom.VideoPipelineInfo } */
    this.info;
  }
};



mojo.internal.Struct(
    media.mojom.MediaMetricsProvider_SetAudioPipelineInfo_ParamsSpec.$,
    'MediaMetricsProvider_SetAudioPipelineInfo_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        media.mojom.AudioPipelineInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.MediaMetricsProvider_SetAudioPipelineInfo_Params');

/** @record */
media.mojom.MediaMetricsProvider_SetAudioPipelineInfo_Params = class {
  constructor() {
    /** @export { !media.mojom.AudioPipelineInfo } */
    this.info;
  }
};

