// media/mojo/mojom/media_player.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  MediaPosition as mediaSession_mojom_MediaPosition,
  MediaPositionSpec as mediaSession_mojom_MediaPositionSpec,
  RemotePlaybackMetadata as mediaSession_mojom_RemotePlaybackMetadata,
  RemotePlaybackMetadataSpec as mediaSession_mojom_RemotePlaybackMetadataSpec
} from '../../../services/media_session/public/mojom/media_session.mojom.m.js';

import {
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  FullscreenVideoStatus as media_mojom_FullscreenVideoStatus,
  FullscreenVideoStatusSpec as media_mojom_FullscreenVideoStatusSpec,
  MediaContentType as media_mojom_MediaContentType,
  MediaContentTypeSpec as media_mojom_MediaContentTypeSpec,
  AutoPipInfo as media_mojom_AutoPipInfo,
  AutoPipInfoSpec as media_mojom_AutoPipInfoSpec
} from './media_types.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MediaPlayerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.MediaPlayer', scope);
  }
}

/** @interface */
export class MediaPlayerInterface {
  
  /**
   */

  requestPlay() {}
  
  /**
   * @param { !boolean } triggeredByUser
   */

  requestPause(triggeredByUser) {}
  
  /**
   * @param { !mojoBase_mojom_TimeDelta } seekTime
   */

  requestSeekForward(seekTime) {}
  
  /**
   * @param { !mojoBase_mojom_TimeDelta } seekTime
   */

  requestSeekBackward(seekTime) {}
  
  /**
   * @param { !mojoBase_mojom_TimeDelta } seekTime
   */

  requestSeekTo(seekTime) {}
  
  /**
   */

  requestEnterPictureInPicture() {}
  
  /**
   * @param { !boolean } mute
   */

  requestMute(mute) {}
  
  /**
   * @param { !number } multiplier
   */

  setVolumeMultiplier(multiplier) {}
  
  /**
   * @param { !boolean } persistent
   */

  setPersistentState(persistent) {}
  
  /**
   * @param { !boolean } enabled
   */

  setPowerExperimentState(enabled) {}
  
  /**
   * @param { !string } sinkId
   */

  setAudioSinkId(sinkId) {}
  
  /**
   */

  suspendForFrameClosed() {}
  
  /**
   */

  requestMediaRemoting() {}
  
  /**
   * @return {!Promise<{
        hasSufficientlyVisibleVideo: !boolean,
   *  }>}
   */

  requestVisibility() {}
  
  /**
   * @param { !media_mojom_AutoPipInfo } autoPictureInPictureInfo
   */

  recordAutoPictureInPictureInfo(autoPictureInPictureInfo) {}
}

/**
 * @implements { MediaPlayerInterface }
 */
export class MediaPlayerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MediaPlayerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaPlayerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MediaPlayerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  requestPlay() {
    this.proxy.sendMessage(
        0,
        MediaPlayer_RequestPlay_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } triggeredByUser
   */

  requestPause(
      triggeredByUser) {
    this.proxy.sendMessage(
        1,
        MediaPlayer_RequestPause_ParamsSpec.$,
        null,
        [
          triggeredByUser
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_TimeDelta } seekTime
   */

  requestSeekForward(
      seekTime) {
    this.proxy.sendMessage(
        2,
        MediaPlayer_RequestSeekForward_ParamsSpec.$,
        null,
        [
          seekTime
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_TimeDelta } seekTime
   */

  requestSeekBackward(
      seekTime) {
    this.proxy.sendMessage(
        3,
        MediaPlayer_RequestSeekBackward_ParamsSpec.$,
        null,
        [
          seekTime
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_TimeDelta } seekTime
   */

  requestSeekTo(
      seekTime) {
    this.proxy.sendMessage(
        4,
        MediaPlayer_RequestSeekTo_ParamsSpec.$,
        null,
        [
          seekTime
        ],
        false);
  }

  
  /**
   */

  requestEnterPictureInPicture() {
    this.proxy.sendMessage(
        5,
        MediaPlayer_RequestEnterPictureInPicture_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } mute
   */

  requestMute(
      mute) {
    this.proxy.sendMessage(
        6,
        MediaPlayer_RequestMute_ParamsSpec.$,
        null,
        [
          mute
        ],
        false);
  }

  
  /**
   * @param { !number } multiplier
   */

  setVolumeMultiplier(
      multiplier) {
    this.proxy.sendMessage(
        7,
        MediaPlayer_SetVolumeMultiplier_ParamsSpec.$,
        null,
        [
          multiplier
        ],
        false);
  }

  
  /**
   * @param { !boolean } persistent
   */

  setPersistentState(
      persistent) {
    this.proxy.sendMessage(
        8,
        MediaPlayer_SetPersistentState_ParamsSpec.$,
        null,
        [
          persistent
        ],
        false);
  }

  
  /**
   * @param { !boolean } enabled
   */

  setPowerExperimentState(
      enabled) {
    this.proxy.sendMessage(
        9,
        MediaPlayer_SetPowerExperimentState_ParamsSpec.$,
        null,
        [
          enabled
        ],
        false);
  }

  
  /**
   * @param { !string } sinkId
   */

  setAudioSinkId(
      sinkId) {
    this.proxy.sendMessage(
        10,
        MediaPlayer_SetAudioSinkId_ParamsSpec.$,
        null,
        [
          sinkId
        ],
        false);
  }

  
  /**
   */

  suspendForFrameClosed() {
    this.proxy.sendMessage(
        11,
        MediaPlayer_SuspendForFrameClosed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  requestMediaRemoting() {
    this.proxy.sendMessage(
        12,
        MediaPlayer_RequestMediaRemoting_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        hasSufficientlyVisibleVideo: !boolean,
   *  }>}
   */

  requestVisibility() {
    return this.proxy.sendMessage(
        13,
        MediaPlayer_RequestVisibility_ParamsSpec.$,
        MediaPlayer_RequestVisibility_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_AutoPipInfo } autoPictureInPictureInfo
   */

  recordAutoPictureInPictureInfo(
      autoPictureInPictureInfo) {
    this.proxy.sendMessage(
        14,
        MediaPlayer_RecordAutoPictureInPictureInfo_ParamsSpec.$,
        null,
        [
          autoPictureInPictureInfo
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MediaPlayer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaPlayerReceiver {
  /**
   * @param {!MediaPlayerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MediaPlayerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaPlayerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaPlayerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaPlayer_RequestPlay_ParamsSpec.$,
        null,
        impl.requestPlay.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MediaPlayer_RequestPause_ParamsSpec.$,
        null,
        impl.requestPause.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        MediaPlayer_RequestSeekForward_ParamsSpec.$,
        null,
        impl.requestSeekForward.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        MediaPlayer_RequestSeekBackward_ParamsSpec.$,
        null,
        impl.requestSeekBackward.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        MediaPlayer_RequestSeekTo_ParamsSpec.$,
        null,
        impl.requestSeekTo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        MediaPlayer_RequestEnterPictureInPicture_ParamsSpec.$,
        null,
        impl.requestEnterPictureInPicture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        MediaPlayer_RequestMute_ParamsSpec.$,
        null,
        impl.requestMute.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        MediaPlayer_SetVolumeMultiplier_ParamsSpec.$,
        null,
        impl.setVolumeMultiplier.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        MediaPlayer_SetPersistentState_ParamsSpec.$,
        null,
        impl.setPersistentState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        MediaPlayer_SetPowerExperimentState_ParamsSpec.$,
        null,
        impl.setPowerExperimentState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        MediaPlayer_SetAudioSinkId_ParamsSpec.$,
        null,
        impl.setAudioSinkId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        MediaPlayer_SuspendForFrameClosed_ParamsSpec.$,
        null,
        impl.suspendForFrameClosed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        MediaPlayer_RequestMediaRemoting_ParamsSpec.$,
        null,
        impl.requestMediaRemoting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        MediaPlayer_RequestVisibility_ParamsSpec.$,
        MediaPlayer_RequestVisibility_ResponseParamsSpec.$,
        impl.requestVisibility.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        MediaPlayer_RecordAutoPictureInPictureInfo_ParamsSpec.$,
        null,
        impl.recordAutoPictureInPictureInfo.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaPlayer {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.MediaPlayer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MediaPlayerRemote}
   */
  static getRemote() {
    let remote = new MediaPlayerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MediaPlayer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaPlayerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaPlayerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaPlayerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestPlay =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaPlayer_RequestPlay_ParamsSpec.$,
        null,
        this.requestPlay.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestPause =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MediaPlayer_RequestPause_ParamsSpec.$,
        null,
        this.requestPause.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestSeekForward =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        MediaPlayer_RequestSeekForward_ParamsSpec.$,
        null,
        this.requestSeekForward.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestSeekBackward =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        MediaPlayer_RequestSeekBackward_ParamsSpec.$,
        null,
        this.requestSeekBackward.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestSeekTo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        MediaPlayer_RequestSeekTo_ParamsSpec.$,
        null,
        this.requestSeekTo.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestEnterPictureInPicture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        MediaPlayer_RequestEnterPictureInPicture_ParamsSpec.$,
        null,
        this.requestEnterPictureInPicture.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestMute =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        MediaPlayer_RequestMute_ParamsSpec.$,
        null,
        this.requestMute.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setVolumeMultiplier =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        MediaPlayer_SetVolumeMultiplier_ParamsSpec.$,
        null,
        this.setVolumeMultiplier.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPersistentState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        MediaPlayer_SetPersistentState_ParamsSpec.$,
        null,
        this.setPersistentState.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPowerExperimentState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        MediaPlayer_SetPowerExperimentState_ParamsSpec.$,
        null,
        this.setPowerExperimentState.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setAudioSinkId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        MediaPlayer_SetAudioSinkId_ParamsSpec.$,
        null,
        this.setAudioSinkId.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.suspendForFrameClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        MediaPlayer_SuspendForFrameClosed_ParamsSpec.$,
        null,
        this.suspendForFrameClosed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestMediaRemoting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        MediaPlayer_RequestMediaRemoting_ParamsSpec.$,
        null,
        this.requestMediaRemoting.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestVisibility =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        MediaPlayer_RequestVisibility_ParamsSpec.$,
        MediaPlayer_RequestVisibility_ResponseParamsSpec.$,
        this.requestVisibility.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.recordAutoPictureInPictureInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        MediaPlayer_RecordAutoPictureInPictureInfo_ParamsSpec.$,
        null,
        this.recordAutoPictureInPictureInfo.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MediaPlayerObserverClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.MediaPlayerObserverClient', scope);
  }
}

/** @interface */
export class MediaPlayerObserverClientInterface {
  
  /**
   * @return {!Promise<{
        hasPlayedBefore: !boolean,
   *  }>}
   */

  getHasPlayedBefore() {}
}

/**
 * @implements { MediaPlayerObserverClientInterface }
 */
export class MediaPlayerObserverClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MediaPlayerObserverClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaPlayerObserverClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MediaPlayerObserverClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        hasPlayedBefore: !boolean,
   *  }>}
   */

  getHasPlayedBefore() {
    return this.proxy.sendMessage(
        0,
        MediaPlayerObserverClient_GetHasPlayedBefore_ParamsSpec.$,
        MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MediaPlayerObserverClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaPlayerObserverClientReceiver {
  /**
   * @param {!MediaPlayerObserverClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MediaPlayerObserverClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaPlayerObserverClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaPlayerObserverClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaPlayerObserverClient_GetHasPlayedBefore_ParamsSpec.$,
        MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParamsSpec.$,
        impl.getHasPlayedBefore.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaPlayerObserverClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.MediaPlayerObserverClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MediaPlayerObserverClientRemote}
   */
  static getRemote() {
    let remote = new MediaPlayerObserverClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MediaPlayerObserverClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaPlayerObserverClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaPlayerObserverClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaPlayerObserverClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getHasPlayedBefore =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaPlayerObserverClient_GetHasPlayedBefore_ParamsSpec.$,
        MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParamsSpec.$,
        this.getHasPlayedBefore.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MediaPlayerObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.MediaPlayerObserver', scope);
  }
}

/** @interface */
export class MediaPlayerObserverInterface {
  
  /**
   */

  onMediaPlaying() {}
  
  /**
   * @param { !boolean } streamEnded
   */

  onMediaPaused(streamEnded) {}
  
  /**
   * @param { !boolean } muted
   */

  onMutedStatusChanged(muted) {}
  
  /**
   * @param { !boolean } hasAudio
   * @param { !boolean } hasVideo
   * @param { !media_mojom_MediaContentType } contentType
   */

  onMediaMetadataChanged(hasAudio, hasVideo, contentType) {}
  
  /**
   * @param { !mediaSession_mojom_MediaPosition } mediaPosition
   */

  onMediaPositionStateChanged(mediaPosition) {}
  
  /**
   * @param { !media_mojom_FullscreenVideoStatus } status
   */

  onMediaEffectivelyFullscreenChanged(status) {}
  
  /**
   * @param { !gfx_mojom_Size } size
   */

  onMediaSizeChanged(size) {}
  
  /**
   * @param { !boolean } available
   */

  onPictureInPictureAvailabilityChanged(available) {}
  
  /**
   * @param { !string } hashedDeviceId
   */

  onAudioOutputSinkChanged(hashedDeviceId) {}
  
  /**
   * @param { !boolean } usesAudioService
   */

  onUseAudioServiceChanged(usesAudioService) {}
  
  /**
   */

  onAudioOutputSinkChangingDisabled() {}
  
  /**
   * @param { !mediaSession_mojom_RemotePlaybackMetadata } remotePlaybackMetadata
   */

  onRemotePlaybackMetadataChange(remotePlaybackMetadata) {}
  
  /**
   * @param { !boolean } meetsVisibilityThreshold
   */

  onVideoVisibilityChanged(meetsVisibilityThreshold) {}
}

/**
 * @implements { MediaPlayerObserverInterface }
 */
export class MediaPlayerObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MediaPlayerObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaPlayerObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MediaPlayerObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onMediaPlaying() {
    this.proxy.sendMessage(
        0,
        MediaPlayerObserver_OnMediaPlaying_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } streamEnded
   */

  onMediaPaused(
      streamEnded) {
    this.proxy.sendMessage(
        1,
        MediaPlayerObserver_OnMediaPaused_ParamsSpec.$,
        null,
        [
          streamEnded
        ],
        false);
  }

  
  /**
   * @param { !boolean } muted
   */

  onMutedStatusChanged(
      muted) {
    this.proxy.sendMessage(
        2,
        MediaPlayerObserver_OnMutedStatusChanged_ParamsSpec.$,
        null,
        [
          muted
        ],
        false);
  }

  
  /**
   * @param { !boolean } hasAudio
   * @param { !boolean } hasVideo
   * @param { !media_mojom_MediaContentType } contentType
   */

  onMediaMetadataChanged(
      hasAudio,
      hasVideo,
      contentType) {
    this.proxy.sendMessage(
        3,
        MediaPlayerObserver_OnMediaMetadataChanged_ParamsSpec.$,
        null,
        [
          hasAudio,
          hasVideo,
          contentType
        ],
        false);
  }

  
  /**
   * @param { !mediaSession_mojom_MediaPosition } mediaPosition
   */

  onMediaPositionStateChanged(
      mediaPosition) {
    this.proxy.sendMessage(
        4,
        MediaPlayerObserver_OnMediaPositionStateChanged_ParamsSpec.$,
        null,
        [
          mediaPosition
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_FullscreenVideoStatus } status
   */

  onMediaEffectivelyFullscreenChanged(
      status) {
    this.proxy.sendMessage(
        5,
        MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }

  
  /**
   * @param { !gfx_mojom_Size } size
   */

  onMediaSizeChanged(
      size) {
    this.proxy.sendMessage(
        6,
        MediaPlayerObserver_OnMediaSizeChanged_ParamsSpec.$,
        null,
        [
          size
        ],
        false);
  }

  
  /**
   * @param { !boolean } available
   */

  onPictureInPictureAvailabilityChanged(
      available) {
    this.proxy.sendMessage(
        7,
        MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_ParamsSpec.$,
        null,
        [
          available
        ],
        false);
  }

  
  /**
   * @param { !string } hashedDeviceId
   */

  onAudioOutputSinkChanged(
      hashedDeviceId) {
    this.proxy.sendMessage(
        8,
        MediaPlayerObserver_OnAudioOutputSinkChanged_ParamsSpec.$,
        null,
        [
          hashedDeviceId
        ],
        false);
  }

  
  /**
   * @param { !boolean } usesAudioService
   */

  onUseAudioServiceChanged(
      usesAudioService) {
    this.proxy.sendMessage(
        9,
        MediaPlayerObserver_OnUseAudioServiceChanged_ParamsSpec.$,
        null,
        [
          usesAudioService
        ],
        false);
  }

  
  /**
   */

  onAudioOutputSinkChangingDisabled() {
    this.proxy.sendMessage(
        10,
        MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !mediaSession_mojom_RemotePlaybackMetadata } remotePlaybackMetadata
   */

  onRemotePlaybackMetadataChange(
      remotePlaybackMetadata) {
    this.proxy.sendMessage(
        11,
        MediaPlayerObserver_OnRemotePlaybackMetadataChange_ParamsSpec.$,
        null,
        [
          remotePlaybackMetadata
        ],
        false);
  }

  
  /**
   * @param { !boolean } meetsVisibilityThreshold
   */

  onVideoVisibilityChanged(
      meetsVisibilityThreshold) {
    this.proxy.sendMessage(
        12,
        MediaPlayerObserver_OnVideoVisibilityChanged_ParamsSpec.$,
        null,
        [
          meetsVisibilityThreshold
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MediaPlayerObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaPlayerObserverReceiver {
  /**
   * @param {!MediaPlayerObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MediaPlayerObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaPlayerObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaPlayerObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaPlayerObserver_OnMediaPlaying_ParamsSpec.$,
        null,
        impl.onMediaPlaying.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MediaPlayerObserver_OnMediaPaused_ParamsSpec.$,
        null,
        impl.onMediaPaused.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        MediaPlayerObserver_OnMutedStatusChanged_ParamsSpec.$,
        null,
        impl.onMutedStatusChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        MediaPlayerObserver_OnMediaMetadataChanged_ParamsSpec.$,
        null,
        impl.onMediaMetadataChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        MediaPlayerObserver_OnMediaPositionStateChanged_ParamsSpec.$,
        null,
        impl.onMediaPositionStateChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_ParamsSpec.$,
        null,
        impl.onMediaEffectivelyFullscreenChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        MediaPlayerObserver_OnMediaSizeChanged_ParamsSpec.$,
        null,
        impl.onMediaSizeChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_ParamsSpec.$,
        null,
        impl.onPictureInPictureAvailabilityChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        MediaPlayerObserver_OnAudioOutputSinkChanged_ParamsSpec.$,
        null,
        impl.onAudioOutputSinkChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        MediaPlayerObserver_OnUseAudioServiceChanged_ParamsSpec.$,
        null,
        impl.onUseAudioServiceChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_ParamsSpec.$,
        null,
        impl.onAudioOutputSinkChangingDisabled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        MediaPlayerObserver_OnRemotePlaybackMetadataChange_ParamsSpec.$,
        null,
        impl.onRemotePlaybackMetadataChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        MediaPlayerObserver_OnVideoVisibilityChanged_ParamsSpec.$,
        null,
        impl.onVideoVisibilityChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaPlayerObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.MediaPlayerObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MediaPlayerObserverRemote}
   */
  static getRemote() {
    let remote = new MediaPlayerObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MediaPlayerObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaPlayerObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaPlayerObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaPlayerObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onMediaPlaying =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaPlayerObserver_OnMediaPlaying_ParamsSpec.$,
        null,
        this.onMediaPlaying.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onMediaPaused =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MediaPlayerObserver_OnMediaPaused_ParamsSpec.$,
        null,
        this.onMediaPaused.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onMutedStatusChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        MediaPlayerObserver_OnMutedStatusChanged_ParamsSpec.$,
        null,
        this.onMutedStatusChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onMediaMetadataChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        MediaPlayerObserver_OnMediaMetadataChanged_ParamsSpec.$,
        null,
        this.onMediaMetadataChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onMediaPositionStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        MediaPlayerObserver_OnMediaPositionStateChanged_ParamsSpec.$,
        null,
        this.onMediaPositionStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onMediaEffectivelyFullscreenChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_ParamsSpec.$,
        null,
        this.onMediaEffectivelyFullscreenChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onMediaSizeChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        MediaPlayerObserver_OnMediaSizeChanged_ParamsSpec.$,
        null,
        this.onMediaSizeChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPictureInPictureAvailabilityChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_ParamsSpec.$,
        null,
        this.onPictureInPictureAvailabilityChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAudioOutputSinkChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        MediaPlayerObserver_OnAudioOutputSinkChanged_ParamsSpec.$,
        null,
        this.onAudioOutputSinkChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onUseAudioServiceChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        MediaPlayerObserver_OnUseAudioServiceChanged_ParamsSpec.$,
        null,
        this.onUseAudioServiceChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAudioOutputSinkChangingDisabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_ParamsSpec.$,
        null,
        this.onAudioOutputSinkChangingDisabled.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onRemotePlaybackMetadataChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        MediaPlayerObserver_OnRemotePlaybackMetadataChange_ParamsSpec.$,
        null,
        this.onRemotePlaybackMetadataChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onVideoVisibilityChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        MediaPlayerObserver_OnVideoVisibilityChanged_ParamsSpec.$,
        null,
        this.onVideoVisibilityChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MediaPlayerHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.MediaPlayerHost', scope);
  }
}

/** @interface */
export class MediaPlayerHostInterface {
  
  /**
   * @param { !Object } playerRemote
   * @param { !Object } observer
   * @param { !number } playerId
   */

  onMediaPlayerAdded(playerRemote, observer, playerId) {}
}

/**
 * @implements { MediaPlayerHostInterface }
 */
export class MediaPlayerHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MediaPlayerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaPlayerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MediaPlayerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } playerRemote
   * @param { !Object } observer
   * @param { !number } playerId
   */

  onMediaPlayerAdded(
      playerRemote,
      observer,
      playerId) {
    this.proxy.sendMessage(
        0,
        MediaPlayerHost_OnMediaPlayerAdded_ParamsSpec.$,
        null,
        [
          playerRemote,
          observer,
          playerId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MediaPlayerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaPlayerHostReceiver {
  /**
   * @param {!MediaPlayerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MediaPlayerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaPlayerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaPlayerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaPlayerHost_OnMediaPlayerAdded_ParamsSpec.$,
        null,
        impl.onMediaPlayerAdded.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaPlayerHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.MediaPlayerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MediaPlayerHostRemote}
   */
  static getRemote() {
    let remote = new MediaPlayerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MediaPlayerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaPlayerHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaPlayerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaPlayerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onMediaPlayerAdded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaPlayerHost_OnMediaPlayerAdded_ParamsSpec.$,
        null,
        this.onMediaPlayerAdded.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayer_RequestPlay_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayer_RequestPause_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayer_RequestSeekForward_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayer_RequestSeekBackward_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayer_RequestSeekTo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayer_RequestEnterPictureInPicture_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayer_RequestMute_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayer_SetVolumeMultiplier_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayer_SetPersistentState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayer_SetPowerExperimentState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayer_SetAudioSinkId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayer_SuspendForFrameClosed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayer_RequestMediaRemoting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayer_RequestVisibility_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayer_RequestVisibility_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayer_RecordAutoPictureInPictureInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayerObserverClient_GetHasPlayedBefore_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayerObserver_OnMediaPlaying_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayerObserver_OnMediaPaused_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayerObserver_OnMutedStatusChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayerObserver_OnMediaMetadataChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayerObserver_OnMediaPositionStateChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayerObserver_OnMediaSizeChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayerObserver_OnAudioOutputSinkChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayerObserver_OnUseAudioServiceChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayerObserver_OnRemotePlaybackMetadataChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayerObserver_OnVideoVisibilityChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPlayerHost_OnMediaPlayerAdded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    MediaPlayer_RequestPlay_ParamsSpec.$,
    'MediaPlayer_RequestPlay_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaPlayer_RequestPlay_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaPlayer_RequestPause_ParamsSpec.$,
    'MediaPlayer_RequestPause_Params',
    [
      mojo.internal.StructField(
        'triggeredByUser', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaPlayer_RequestPause_Params {
  constructor() {
    /** @type { !boolean } */
    this.triggeredByUser;
  }
}



mojo.internal.Struct(
    MediaPlayer_RequestSeekForward_ParamsSpec.$,
    'MediaPlayer_RequestSeekForward_Params',
    [
      mojo.internal.StructField(
        'seekTime', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaPlayer_RequestSeekForward_Params {
  constructor() {
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.seekTime;
  }
}



mojo.internal.Struct(
    MediaPlayer_RequestSeekBackward_ParamsSpec.$,
    'MediaPlayer_RequestSeekBackward_Params',
    [
      mojo.internal.StructField(
        'seekTime', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaPlayer_RequestSeekBackward_Params {
  constructor() {
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.seekTime;
  }
}



mojo.internal.Struct(
    MediaPlayer_RequestSeekTo_ParamsSpec.$,
    'MediaPlayer_RequestSeekTo_Params',
    [
      mojo.internal.StructField(
        'seekTime', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaPlayer_RequestSeekTo_Params {
  constructor() {
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.seekTime;
  }
}



mojo.internal.Struct(
    MediaPlayer_RequestEnterPictureInPicture_ParamsSpec.$,
    'MediaPlayer_RequestEnterPictureInPicture_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaPlayer_RequestEnterPictureInPicture_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaPlayer_RequestMute_ParamsSpec.$,
    'MediaPlayer_RequestMute_Params',
    [
      mojo.internal.StructField(
        'mute', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaPlayer_RequestMute_Params {
  constructor() {
    /** @type { !boolean } */
    this.mute;
  }
}



mojo.internal.Struct(
    MediaPlayer_SetVolumeMultiplier_ParamsSpec.$,
    'MediaPlayer_SetVolumeMultiplier_Params',
    [
      mojo.internal.StructField(
        'multiplier', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaPlayer_SetVolumeMultiplier_Params {
  constructor() {
    /** @type { !number } */
    this.multiplier;
  }
}



mojo.internal.Struct(
    MediaPlayer_SetPersistentState_ParamsSpec.$,
    'MediaPlayer_SetPersistentState_Params',
    [
      mojo.internal.StructField(
        'persistent', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaPlayer_SetPersistentState_Params {
  constructor() {
    /** @type { !boolean } */
    this.persistent;
  }
}



mojo.internal.Struct(
    MediaPlayer_SetPowerExperimentState_ParamsSpec.$,
    'MediaPlayer_SetPowerExperimentState_Params',
    [
      mojo.internal.StructField(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaPlayer_SetPowerExperimentState_Params {
  constructor() {
    /** @type { !boolean } */
    this.enabled;
  }
}



mojo.internal.Struct(
    MediaPlayer_SetAudioSinkId_ParamsSpec.$,
    'MediaPlayer_SetAudioSinkId_Params',
    [
      mojo.internal.StructField(
        'sinkId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaPlayer_SetAudioSinkId_Params {
  constructor() {
    /** @type { !string } */
    this.sinkId;
  }
}



mojo.internal.Struct(
    MediaPlayer_SuspendForFrameClosed_ParamsSpec.$,
    'MediaPlayer_SuspendForFrameClosed_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaPlayer_SuspendForFrameClosed_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaPlayer_RequestMediaRemoting_ParamsSpec.$,
    'MediaPlayer_RequestMediaRemoting_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaPlayer_RequestMediaRemoting_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaPlayer_RequestVisibility_ParamsSpec.$,
    'MediaPlayer_RequestVisibility_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaPlayer_RequestVisibility_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaPlayer_RequestVisibility_ResponseParamsSpec.$,
    'MediaPlayer_RequestVisibility_ResponseParams',
    [
      mojo.internal.StructField(
        'hasSufficientlyVisibleVideo', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaPlayer_RequestVisibility_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.hasSufficientlyVisibleVideo;
  }
}



mojo.internal.Struct(
    MediaPlayer_RecordAutoPictureInPictureInfo_ParamsSpec.$,
    'MediaPlayer_RecordAutoPictureInPictureInfo_Params',
    [
      mojo.internal.StructField(
        'autoPictureInPictureInfo', 0,
        0,
        media_mojom_AutoPipInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaPlayer_RecordAutoPictureInPictureInfo_Params {
  constructor() {
    /** @type { !media_mojom_AutoPipInfo } */
    this.autoPictureInPictureInfo;
  }
}



mojo.internal.Struct(
    MediaPlayerObserverClient_GetHasPlayedBefore_ParamsSpec.$,
    'MediaPlayerObserverClient_GetHasPlayedBefore_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaPlayerObserverClient_GetHasPlayedBefore_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParamsSpec.$,
    'MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParams',
    [
      mojo.internal.StructField(
        'hasPlayedBefore', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaPlayerObserverClient_GetHasPlayedBefore_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.hasPlayedBefore;
  }
}



mojo.internal.Struct(
    MediaPlayerObserver_OnMediaPlaying_ParamsSpec.$,
    'MediaPlayerObserver_OnMediaPlaying_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaPlayerObserver_OnMediaPlaying_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaPlayerObserver_OnMediaPaused_ParamsSpec.$,
    'MediaPlayerObserver_OnMediaPaused_Params',
    [
      mojo.internal.StructField(
        'streamEnded', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaPlayerObserver_OnMediaPaused_Params {
  constructor() {
    /** @type { !boolean } */
    this.streamEnded;
  }
}



mojo.internal.Struct(
    MediaPlayerObserver_OnMutedStatusChanged_ParamsSpec.$,
    'MediaPlayerObserver_OnMutedStatusChanged_Params',
    [
      mojo.internal.StructField(
        'muted', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaPlayerObserver_OnMutedStatusChanged_Params {
  constructor() {
    /** @type { !boolean } */
    this.muted;
  }
}



mojo.internal.Struct(
    MediaPlayerObserver_OnMediaMetadataChanged_ParamsSpec.$,
    'MediaPlayerObserver_OnMediaMetadataChanged_Params',
    [
      mojo.internal.StructField(
        'hasAudio', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasVideo', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contentType', 4,
        0,
        media_mojom_MediaContentTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaPlayerObserver_OnMediaMetadataChanged_Params {
  constructor() {
    /** @type { !boolean } */
    this.hasAudio;
    /** @type { !boolean } */
    this.hasVideo;
    /** @type { !media_mojom_MediaContentType } */
    this.contentType;
  }
}



mojo.internal.Struct(
    MediaPlayerObserver_OnMediaPositionStateChanged_ParamsSpec.$,
    'MediaPlayerObserver_OnMediaPositionStateChanged_Params',
    [
      mojo.internal.StructField(
        'mediaPosition', 0,
        0,
        mediaSession_mojom_MediaPositionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaPlayerObserver_OnMediaPositionStateChanged_Params {
  constructor() {
    /** @type { !mediaSession_mojom_MediaPosition } */
    this.mediaPosition;
  }
}



mojo.internal.Struct(
    MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_ParamsSpec.$,
    'MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media_mojom_FullscreenVideoStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params {
  constructor() {
    /** @type { !media_mojom_FullscreenVideoStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    MediaPlayerObserver_OnMediaSizeChanged_ParamsSpec.$,
    'MediaPlayerObserver_OnMediaSizeChanged_Params',
    [
      mojo.internal.StructField(
        'size', 0,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaPlayerObserver_OnMediaSizeChanged_Params {
  constructor() {
    /** @type { !gfx_mojom_Size } */
    this.size;
  }
}



mojo.internal.Struct(
    MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_ParamsSpec.$,
    'MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params',
    [
      mojo.internal.StructField(
        'available', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params {
  constructor() {
    /** @type { !boolean } */
    this.available;
  }
}



mojo.internal.Struct(
    MediaPlayerObserver_OnAudioOutputSinkChanged_ParamsSpec.$,
    'MediaPlayerObserver_OnAudioOutputSinkChanged_Params',
    [
      mojo.internal.StructField(
        'hashedDeviceId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaPlayerObserver_OnAudioOutputSinkChanged_Params {
  constructor() {
    /** @type { !string } */
    this.hashedDeviceId;
  }
}



mojo.internal.Struct(
    MediaPlayerObserver_OnUseAudioServiceChanged_ParamsSpec.$,
    'MediaPlayerObserver_OnUseAudioServiceChanged_Params',
    [
      mojo.internal.StructField(
        'usesAudioService', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaPlayerObserver_OnUseAudioServiceChanged_Params {
  constructor() {
    /** @type { !boolean } */
    this.usesAudioService;
  }
}



mojo.internal.Struct(
    MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_ParamsSpec.$,
    'MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaPlayerObserver_OnRemotePlaybackMetadataChange_ParamsSpec.$,
    'MediaPlayerObserver_OnRemotePlaybackMetadataChange_Params',
    [
      mojo.internal.StructField(
        'remotePlaybackMetadata', 0,
        0,
        mediaSession_mojom_RemotePlaybackMetadataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaPlayerObserver_OnRemotePlaybackMetadataChange_Params {
  constructor() {
    /** @type { !mediaSession_mojom_RemotePlaybackMetadata } */
    this.remotePlaybackMetadata;
  }
}



mojo.internal.Struct(
    MediaPlayerObserver_OnVideoVisibilityChanged_ParamsSpec.$,
    'MediaPlayerObserver_OnVideoVisibilityChanged_Params',
    [
      mojo.internal.StructField(
        'meetsVisibilityThreshold', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaPlayerObserver_OnVideoVisibilityChanged_Params {
  constructor() {
    /** @type { !boolean } */
    this.meetsVisibilityThreshold;
  }
}



mojo.internal.Struct(
    MediaPlayerHost_OnMediaPlayerAdded_ParamsSpec.$,
    'MediaPlayerHost_OnMediaPlayerAdded_Params',
    [
      mojo.internal.StructField(
        'playerRemote', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(MediaPlayerRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observer', 8,
        0,
        mojo.internal.AssociatedInterfaceRequest(MediaPlayerObserverPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'playerId', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MediaPlayerHost_OnMediaPlayerAdded_Params {
  constructor() {
    /** @type { !Object } */
    this.playerRemote;
    /** @type { !Object } */
    this.observer;
    /** @type { !number } */
    this.playerId;
  }
}

